/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetServiceGatewayRequest
extends BmcRequest<Void> {
    private String serviceGatewayId;

    public String getServiceGatewayId() {
        return this.serviceGatewayId;
    }

    public Builder toBuilder() {
        return new Builder().serviceGatewayId(this.serviceGatewayId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",serviceGatewayId=").append(String.valueOf(this.serviceGatewayId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetServiceGatewayRequest)) {
            return false;
        }
        GetServiceGatewayRequest other = (GetServiceGatewayRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.serviceGatewayId, other.serviceGatewayId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.serviceGatewayId == null ? 43 : this.serviceGatewayId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetServiceGatewayRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String serviceGatewayId = null;

        public Builder serviceGatewayId(String serviceGatewayId) {
            this.serviceGatewayId = serviceGatewayId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetServiceGatewayRequest o) {
            this.serviceGatewayId(o.getServiceGatewayId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetServiceGatewayRequest build() {
            GetServiceGatewayRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetServiceGatewayRequest buildWithoutInvocationCallback() {
            GetServiceGatewayRequest request = new GetServiceGatewayRequest();
            request.serviceGatewayId = this.serviceGatewayId;
            return request;
        }
    }
}

