/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.ChangeSecurityListCompartmentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeSecurityListCompartmentRequest
extends BmcRequest<ChangeSecurityListCompartmentDetails> {
    private String securityListId;
    private ChangeSecurityListCompartmentDetails changeSecurityListCompartmentDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getSecurityListId() {
        return this.securityListId;
    }

    public ChangeSecurityListCompartmentDetails getChangeSecurityListCompartmentDetails() {
        return this.changeSecurityListCompartmentDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ChangeSecurityListCompartmentDetails getBody$() {
        return this.changeSecurityListCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().securityListId(this.securityListId).changeSecurityListCompartmentDetails(this.changeSecurityListCompartmentDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",securityListId=").append(String.valueOf(this.securityListId));
        sb.append(",changeSecurityListCompartmentDetails=").append(String.valueOf((Object)this.changeSecurityListCompartmentDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeSecurityListCompartmentRequest)) {
            return false;
        }
        ChangeSecurityListCompartmentRequest other = (ChangeSecurityListCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.securityListId, other.securityListId) && Objects.equals((Object)this.changeSecurityListCompartmentDetails, (Object)other.changeSecurityListCompartmentDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.securityListId == null ? 43 : this.securityListId.hashCode());
        result = result * 59 + (this.changeSecurityListCompartmentDetails == null ? 43 : this.changeSecurityListCompartmentDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeSecurityListCompartmentRequest, ChangeSecurityListCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String securityListId = null;
        private ChangeSecurityListCompartmentDetails changeSecurityListCompartmentDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder securityListId(String securityListId) {
            this.securityListId = securityListId;
            return this;
        }

        public Builder changeSecurityListCompartmentDetails(ChangeSecurityListCompartmentDetails changeSecurityListCompartmentDetails) {
            this.changeSecurityListCompartmentDetails = changeSecurityListCompartmentDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeSecurityListCompartmentRequest o) {
            this.securityListId(o.getSecurityListId());
            this.changeSecurityListCompartmentDetails(o.getChangeSecurityListCompartmentDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeSecurityListCompartmentRequest build() {
            ChangeSecurityListCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeSecurityListCompartmentDetails body) {
            this.changeSecurityListCompartmentDetails(body);
            return this;
        }

        public ChangeSecurityListCompartmentRequest buildWithoutInvocationCallback() {
            ChangeSecurityListCompartmentRequest request = new ChangeSecurityListCompartmentRequest();
            request.securityListId = this.securityListId;
            request.changeSecurityListCompartmentDetails = this.changeSecurityListCompartmentDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

