/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class VirtualCircuitAssociatedTunnelDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="tunnelType")
    private final TunnelType tunnelType;
    @JsonProperty(value="ipsecConnectionId")
    private final String ipsecConnectionId;
    @JsonProperty(value="tunnelId")
    private final String tunnelId;

    @Deprecated
    @ConstructorProperties(value={"tunnelType", "ipsecConnectionId", "tunnelId"})
    public VirtualCircuitAssociatedTunnelDetails(TunnelType tunnelType, String ipsecConnectionId, String tunnelId) {
        this.tunnelType = tunnelType;
        this.ipsecConnectionId = ipsecConnectionId;
        this.tunnelId = tunnelId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public TunnelType getTunnelType() {
        return this.tunnelType;
    }

    public String getIpsecConnectionId() {
        return this.ipsecConnectionId;
    }

    public String getTunnelId() {
        return this.tunnelId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VirtualCircuitAssociatedTunnelDetails(");
        sb.append("super=").append(super.toString());
        sb.append("tunnelType=").append(String.valueOf((Object)this.tunnelType));
        sb.append(", ipsecConnectionId=").append(String.valueOf(this.ipsecConnectionId));
        sb.append(", tunnelId=").append(String.valueOf(this.tunnelId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualCircuitAssociatedTunnelDetails)) {
            return false;
        }
        VirtualCircuitAssociatedTunnelDetails other = (VirtualCircuitAssociatedTunnelDetails)((Object)o);
        return Objects.equals((Object)this.tunnelType, (Object)other.tunnelType) && Objects.equals(this.ipsecConnectionId, other.ipsecConnectionId) && Objects.equals(this.tunnelId, other.tunnelId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.tunnelType == null ? 43 : this.tunnelType.hashCode());
        result = result * 59 + (this.ipsecConnectionId == null ? 43 : this.ipsecConnectionId.hashCode());
        result = result * 59 + (this.tunnelId == null ? 43 : this.tunnelId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum TunnelType implements BmcEnum
    {
        Ipsec("IPSEC"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TunnelType> map;

        private TunnelType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TunnelType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TunnelType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TunnelType.class);
            map = new HashMap<String, TunnelType>();
            for (TunnelType v : TunnelType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="tunnelType")
        private TunnelType tunnelType;
        @JsonProperty(value="ipsecConnectionId")
        private String ipsecConnectionId;
        @JsonProperty(value="tunnelId")
        private String tunnelId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder tunnelType(TunnelType tunnelType) {
            this.tunnelType = tunnelType;
            this.__explicitlySet__.add("tunnelType");
            return this;
        }

        public Builder ipsecConnectionId(String ipsecConnectionId) {
            this.ipsecConnectionId = ipsecConnectionId;
            this.__explicitlySet__.add("ipsecConnectionId");
            return this;
        }

        public Builder tunnelId(String tunnelId) {
            this.tunnelId = tunnelId;
            this.__explicitlySet__.add("tunnelId");
            return this;
        }

        public VirtualCircuitAssociatedTunnelDetails build() {
            VirtualCircuitAssociatedTunnelDetails model = new VirtualCircuitAssociatedTunnelDetails(this.tunnelType, this.ipsecConnectionId, this.tunnelId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VirtualCircuitAssociatedTunnelDetails model) {
            if (model.wasPropertyExplicitlySet("tunnelType")) {
                this.tunnelType(model.getTunnelType());
            }
            if (model.wasPropertyExplicitlySet("ipsecConnectionId")) {
                this.ipsecConnectionId(model.getIpsecConnectionId());
            }
            if (model.wasPropertyExplicitlySet("tunnelId")) {
                this.tunnelId(model.getTunnelId());
            }
            return this;
        }
    }
}

