/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.webmvc;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.spring.webmvc.SpringWebModuleExtender;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class SpringWebFrameworkProvider
extends WebFrameworkProvider {
    public static final String CONTEXT_LOADER = "org.springframework.web.context.ContextLoaderListener";
    public static final String DISPATCHER_SERVLET = "org.springframework.web.servlet.DispatcherServlet";
    private SpringWebModuleExtender panel;

    public SpringWebFrameworkProvider() {
        super(NbBundle.getMessage(SpringWebFrameworkProvider.class, (String)"LBL_FrameworkName"), NbBundle.getMessage(SpringWebFrameworkProvider.class, (String)"LBL_FrameworkDescription"));
    }

    public boolean isInWebModule(WebModule webModule) {
        FileObject dd = webModule.getDeploymentDescriptor();
        if (dd == null) {
            return false;
        }
        try {
            WebApp webApp = DDProvider.getDefault().getDDRoot(dd);
            return webApp.findBeanByName("Servlet", "ServletClass", DISPATCHER_SERVLET) != null || webApp.findBeanByName("Listener", "ListenerClass", CONTEXT_LOADER) != null;
        }
        catch (IOException e) {
            Logger.getLogger("global").log(Level.INFO, null, e);
            return false;
        }
    }

    public File[] getConfigurationFiles(WebModule webModule) {
        return new File[0];
    }

    public WebModuleExtender createWebModuleExtender(WebModule webModule, ExtenderController controller) {
        boolean defaultValue = webModule == null || !this.isInWebModule(webModule);
        this.panel = new SpringWebModuleExtender(this, controller, webModule, !defaultValue);
        return this.panel;
    }
}

