/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.selectors;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.git.ui.selectors.ItemsPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class ItemSelector<I extends Item>
implements ListSelectionListener {
    private final ItemsPanel panel;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private boolean deletesAllowed;

    public ItemSelector(String title) {
        this.panel = new ItemsPanel();
        this.panel.btnAllowDestructiveActions.setVisible(false);
        Mnemonics.setLocalizedText((JLabel)this.panel.titleLabel, (String)title);
        this.panel.list.setCellRenderer(new ItemRenderer());
        this.attachListeners();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void setBranches(List<I> branches) {
        Collections.sort(branches);
        DefaultListModel<Item> model = new DefaultListModel<Item>();
        for (Item i : branches) {
            model.addElement(i);
            if (!i.isDestructive()) continue;
            this.panel.btnAllowDestructiveActions.setVisible(true);
        }
        this.panel.list.setModel(model);
        this.changeSupport.fireChange();
    }

    public List<I> getSelectedBranches() {
        ArrayList<Item> ret = new ArrayList<Item>(this.panel.list.getModel().getSize());
        for (int i = 0; i < this.panel.list.getModel().getSize(); ++i) {
            Item item = (Item)this.panel.list.getModel().getElementAt(i);
            if (!item.isSelected) continue;
            ret.add(item);
        }
        return ret;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && e.getSource() == this.panel.list.getSelectionModel()) {
            this.changeSupport.fireChange();
        }
    }

    public void setEnabled(boolean b) {
        this.panel.list.setEnabled(b);
        this.panel.titleLabel.setEnabled(b);
    }

    public boolean isEmpty() {
        return this.panel.list.getModel().getSize() == 0;
    }

    private void selectAll(boolean newState) {
        for (int i = 0; i < this.panel.list.getModel().getSize(); ++i) {
            Item item = (Item)this.panel.list.getModel().getElementAt(i);
            if (newState && !this.isSelectedStateAllowed(item)) continue;
            item.isSelected = newState;
        }
        this.panel.list.repaint();
        this.changeSupport.fireChange();
    }

    private void attachListeners() {
        this.panel.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ItemSelector.this.switchSelection(ItemSelector.this.panel.list.locationToIndex(e.getPoint()));
            }
        });
        this.panel.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    ItemSelector.this.switchSelection(ItemSelector.this.panel.list.getSelectedIndex());
                }
            }
        });
        this.panel.btnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemSelector.this.selectAll(true);
            }
        });
        this.panel.btnSelectNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemSelector.this.selectAll(false);
            }
        });
        this.panel.btnAllowDestructiveActions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemSelector.this.deletesAllowed = !ItemSelector.this.deletesAllowed;
                boolean fireChange = false;
                if (!ItemSelector.this.deletesAllowed) {
                    int maxItemsCount = ItemSelector.this.panel.list.getModel().getSize();
                    for (int i = 0; i < maxItemsCount; ++i) {
                        Item item = (Item)ItemSelector.this.panel.list.getModel().getElementAt(i);
                        if (!item.isDestructive()) continue;
                        fireChange = item.isSelected;
                        item.isSelected = false;
                    }
                }
                ItemSelector.this.panel.list.repaint();
                if (ItemSelector.this.deletesAllowed) {
                    Mnemonics.setLocalizedText((AbstractButton)ItemSelector.this.panel.btnAllowDestructiveActions, (String)NbBundle.getMessage(ItemsPanel.class, (String)"ItemsPanel.btnDisableDestructiveActions.text"));
                } else {
                    Mnemonics.setLocalizedText((AbstractButton)ItemSelector.this.panel.btnAllowDestructiveActions, (String)NbBundle.getMessage(ItemsPanel.class, (String)"ItemsPanel.btnAllowDestructiveActions.text"));
                }
                if (fireChange) {
                    ItemSelector.this.changeSupport.fireChange();
                }
            }
        });
        this.changeSupport.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int selectedItemsCount = 0;
                int maxItemsCount = ItemSelector.this.panel.list.getModel().getSize();
                for (int i = 0; i < maxItemsCount; ++i) {
                    Item item = (Item)ItemSelector.this.panel.list.getModel().getElementAt(i);
                    if (!item.isSelected) continue;
                    ++selectedItemsCount;
                }
                ItemSelector.this.panel.btnSelectAll.setEnabled(selectedItemsCount < maxItemsCount);
                ItemSelector.this.panel.btnSelectNone.setEnabled(selectedItemsCount > 0);
            }
        });
    }

    private void switchSelection(int index) {
        Item item;
        if (index != -1 && this.isSelectedStateAllowed(item = (Item)this.panel.list.getModel().getElementAt(index))) {
            item.isSelected = !item.isSelected;
            this.panel.list.repaint();
            this.changeSupport.fireChange();
        }
    }

    private boolean isSelectedStateAllowed(Item item) {
        return !item.isDestructive() || this.deletesAllowed;
    }

    public class ItemRenderer
    implements ListCellRenderer {
        private JCheckBox renderer = new JCheckBox();
        private Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public ItemRenderer() {
            this.renderer.setBorder(this.noFocusBorder);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.renderer.setBackground(list.getBackground());
            this.renderer.setForeground(list.getForeground());
            this.renderer.setEnabled(list.isEnabled());
            this.renderer.setFont(list.getFont());
            this.renderer.setFocusPainted(false);
            this.renderer.setBorderPainted(true);
            if (value instanceof Item) {
                Item item = (Item)value;
                this.renderer.setText("<html>" + item.getText() + "</html>");
                this.renderer.setToolTipText(item.getTooltipText());
                this.renderer.setSelected(item.isSelected);
                this.renderer.setEnabled(!item.isDestructive() || ItemSelector.this.deletesAllowed);
            }
            this.renderer.setBorder(isSelected ? UIManager.getBorder("List.focusCellHighlightBorder") : this.noFocusBorder);
            return this.renderer;
        }
    }

    public static abstract class Item
    implements Comparable<Item> {
        boolean isSelected;
        private final boolean isDestructive;

        protected Item(boolean selected, boolean isDestructive) {
            this.isSelected = selected;
            this.isDestructive = isDestructive;
        }

        public abstract String getText();

        public abstract String getTooltipText();

        public final boolean isDestructive() {
            return this.isDestructive;
        }
    }
}

