/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.repository.remote;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.lang.invoke.CallSite;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.libs.git.GitURI;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.ui.repository.remote.ConnectionSettings;
import org.netbeans.modules.git.ui.repository.remote.RemoteRepositoryPanel;
import org.netbeans.modules.git.ui.repository.remote.SSHPanel;
import org.netbeans.modules.git.ui.repository.remote.UserPasswordPanel;
import org.netbeans.modules.git.ui.wizards.AbstractWizardPanel;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class RemoteRepository
implements DocumentListener,
ActionListener,
ItemListener {
    private boolean valid;
    private AbstractWizardPanel.Message msg;
    private ChangeSupport support = new ChangeSupport((Object)this);
    private final boolean urlFixed;
    private final ConnectionSettingsType[] settingTypes;
    private ConnectionSettingsType activeSettingsType;
    private boolean enabled = true;
    private String[] sortedModelUrls;
    private String[] schemeUris;
    private boolean urlComboEnabled = true;
    private final RemoteRepositoryPanel panel;
    private boolean ignoreComboEvents = false;
    private boolean initialized;
    private Map<String, ConnectionSettings> recentConnectionSettings = new HashMap<String, ConnectionSettings>();

    public RemoteRepository(String forPath) {
        this(null, forPath);
    }

    public RemoteRepository(PasswordAuthentication pa, String forPath) {
        this(pa, forPath, false);
    }

    private RemoteRepository(PasswordAuthentication pa, String forPath, boolean fixedUrl) {
        assert (!fixedUrl || forPath != null && !forPath.trim().isEmpty());
        this.panel = new RemoteRepositoryPanel();
        this.urlFixed = fixedUrl;
        this.settingTypes = new ConnectionSettingsType[]{new GitConnectionSettingsType(), new SSHConnectionSettingsType(), new FileConnectionSettingsType(), new DefaultConnectionSettingsType()};
        this.activeSettingsType = this.settingTypes[0];
        this.initHeight();
        this.attachListeners();
        this.initUrlComboValues(forPath, pa);
        this.updateCurrentSettingsType();
        this.validateFields();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public boolean isValid() {
        return this.valid;
    }

    public AbstractWizardPanel.Message getMessage() {
        return this.msg;
    }

    public GitURI getURI() {
        return this.getURI(true);
    }

    private GitURI getURI(boolean trimSpaces) {
        String uriString = this.getURIString(trimSpaces);
        if (uriString != null && !uriString.isEmpty()) {
            try {
                return new GitURI(uriString);
            }
            catch (URISyntaxException ex) {
                Git.LOG.log(Level.INFO, uriString, ex);
            }
        }
        return null;
    }

    public void store() {
        this.activeSettingsType.store();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.panel.urlComboBox.setEnabled(enabled && this.urlComboEnabled);
        for (ConnectionSettingsType type : this.settingTypes) {
            type.setEnabled(enabled);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        this.support.removeChangeListener(listener);
    }

    public void addChangeListener(ChangeListener listener) {
        this.support.addChangeListener(listener);
    }

    private String getURIString(boolean trimSpaces) {
        String uriString = (String)this.panel.urlComboBox.getEditor().getItem();
        return uriString == null ? null : (trimSpaces ? uriString.trim() : uriString);
    }

    private void attachListeners() {
        this.panel.proxySettingsButton.addActionListener(this);
        this.panel.directoryBrowseButton.addActionListener(this);
        ((JTextComponent)this.panel.urlComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        this.panel.urlComboBox.addItemListener(this);
    }

    @Override
    public void insertUpdate(DocumentEvent de) {
        this.uriTextChanged(true);
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        this.uriTextChanged(false);
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
        this.uriTextChanged(true);
    }

    private void uriTextChanged(final boolean findExisting) {
        if (this.ignoreComboEvents) {
            return;
        }
        this.validateFields();
        this.updateCurrentSettingsType();
        EventQueue.invokeLater(new Runnable(){
            final /* synthetic */ RemoteRepository this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.findComboItem(false, findExisting);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.panel.directoryBrowseButton) {
            this.onBrowse();
        } else if (ae.getSource() == this.panel.proxySettingsButton) {
            this.onProxyConfiguration();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        ConnectionSettings setts;
        GitURI guri = this.getURI();
        if (guri != null && (setts = this.recentConnectionSettings.get(guri.toString())) != null) {
            this.activeSettingsType.populateFields(setts);
        }
    }

    public static boolean updateFor(String url) {
        boolean retval = false;
        final RemoteRepository repository = new RemoteRepository(null, url, true);
        JPanel panel = repository.getPanel();
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        final DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(RemoteRepositoryPanel.class, (String)"ACSD_RepositoryPanel_Title"), true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, new HelpCtx(RemoteRepository.class), null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        repository.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                dd.setValid(repository.isValid());
            }
        });
        if (repository.isValid()) {
            dd.setValid(true);
        }
        dialog.setVisible(true);
        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
            repository.activeSettingsType.store();
            retval = true;
        }
        return retval;
    }

    private void validateFields() {
        try {
            this.valid = true;
            this.msg = null;
            GitURI uri = this.getURI();
            if (uri == null) {
                this.valid = false;
                this.msg = new AbstractWizardPanel.Message(NbBundle.getMessage(RemoteRepository.class, (String)"MSG_EMPTY_URI_ERROR"), true);
            }
        }
        finally {
            this.support.fireChange();
        }
    }

    private void updateCurrentSettingsType() {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                GitURI uri = RemoteRepository.this.getURI();
                if (uri == null) {
                    return;
                }
                for (ConnectionSettingsType type : RemoteRepository.this.settingTypes) {
                    if (!type.acceptUri(uri)) continue;
                    RemoteRepository.this.activeSettingsType = type;
                    break;
                }
                if (RemoteRepository.this.urlFixed) {
                    RemoteRepository.this.panel.tipLabel.setText(null);
                    RemoteRepository.this.activeSettingsType.requestFocusInWindow();
                }
            }
        });
    }

    private void enableUrlCombo(boolean comboEnabled) {
        this.urlComboEnabled = comboEnabled;
        this.panel.urlComboBox.setEnabled(comboEnabled && this.enabled);
    }

    private void findComboItem(boolean selectAll, boolean resetFields) {
        String[][] stringArrayArray;
        String uriString;
        final GitURI uri = this.getURI(false);
        String string = uriString = uri == null ? this.getURIString(false) : uri.setUser(null).setPass(null).toString();
        if (uriString == null || uriString.isEmpty()) {
            return;
        }
        boolean preferSchemeUris = false;
        if (uri != null && uri.getScheme() != null && !Scheme.FILE.name.equals(uri.getScheme()) && uri.getHost() == null) {
            uriString = this.getURIString(false);
            preferSchemeUris = !resetFields;
            resetFields = true;
        } else if (uriString.endsWith("/") && !this.getURIString(false).endsWith("/")) {
            uriString = uriString.substring(0, uriString.length() - 1);
        }
        if (!resetFields) {
            return;
        }
        if (preferSchemeUris) {
            String[][] stringArrayArray2 = new String[2][];
            stringArrayArray2[0] = this.schemeUris;
            stringArrayArray = stringArrayArray2;
            stringArrayArray2[1] = this.sortedModelUrls;
        } else {
            String[][] stringArrayArray3 = new String[1][];
            stringArrayArray = stringArrayArray3;
            stringArrayArray3[0] = this.sortedModelUrls;
        }
        String[][] stringArrayArray4 = stringArrayArray;
        int n = stringArrayArray4.length;
        for (int i = 0; i < n; ++i) {
            String[] uris;
            for (final String item : uris = stringArrayArray4[i]) {
                if (!item.startsWith(uriString)) continue;
                final int start = selectAll ? 0 : uriString.length();
                final int end = item.length();
                EventQueue.invokeLater(new Runnable(){
                    final /* synthetic */ RemoteRepository this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        this.this$0.ignoreComboEvents = true;
                        try {
                            this.this$0.setComboText(item, start, end);
                            this.this$0.updateCurrentSettingsType();
                            ConnectionSettings setts = this.this$0.recentConnectionSettings.get(item);
                            if (setts != null && uri != null) {
                                String username = uri.getUser();
                                String string = username = username == null ? "" : username.trim();
                                if (!username.isEmpty() && !username.equals(setts.getUser())) {
                                    setts = setts.copy();
                                    setts.setUser(username);
                                }
                            }
                            this.this$0.activeSettingsType.populateFields(setts);
                        }
                        finally {
                            this.this$0.ignoreComboEvents = false;
                        }
                    }
                });
                return;
            }
        }
    }

    private void setComboText(String item, int start, int end) {
        JTextComponent txt = (JTextComponent)this.panel.urlComboBox.getEditor().getEditorComponent();
        txt.setText(item);
        txt.setCaretPosition(end);
        txt.moveCaretPosition(start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitPopulated() {
        RemoteRepository remoteRepository = this;
        synchronized (remoteRepository) {
            while (!this.initialized) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private void initUrlComboValues(final String forPath, final PasswordAuthentication pa) {
        this.enableUrlCombo(false);
        Git.getInstance().getRequestProcessor().post(new Runnable(){
            final /* synthetic */ RemoteRepository this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    final DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>();
                    try {
                        List<ConnectionSettings> settings = GitModuleConfig.getDefault().getRecentConnectionSettings();
                        for (ConnectionSettings sett : settings) {
                            GitURI g = sett.getUri().setPass(null).setUser(null);
                            model.addElement(g.toString());
                            this.this$0.recentConnectionSettings.put(g.toString(), sett);
                        }
                    }
                    catch (Throwable t) {
                        Git.LOG.log(Level.WARNING, null, t);
                    }
                    final ArrayList<CallSite> schemeUris = new ArrayList<CallSite>(Scheme.values().length);
                    for (Scheme s : Scheme.values()) {
                        String uri = s.toString() + (s == Scheme.FILE ? ":///" : "://");
                        model.addElement(uri);
                        schemeUris.add((CallSite)((Object)uri));
                    }
                    final String[] uris = new String[model.getSize()];
                    for (int i = 0; i < model.getSize(); ++i) {
                        uris[i] = (String)model.getElementAt(i);
                    }
                    EventQueue.invokeLater(new Runnable(){
                        final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            this.this$1.this$0.ignoreComboEvents = true;
                            this.this$1.this$0.sortedModelUrls = uris;
                            this.this$1.this$0.schemeUris = schemeUris.toArray(new String[0]);
                            this.this$1.this$0.panel.urlComboBox.setModel(model);
                            if (forPath != null) {
                                this.this$1.this$0.setComboText(forPath, 0, forPath.length());
                            }
                            this.this$1.this$0.ignoreComboEvents = false;
                            if (pa == null) {
                                this.this$1.this$0.findComboItem(true, true);
                                this.this$1.this$0.updateCurrentSettingsType();
                            } else {
                                this.this$1.this$0.updateCurrentSettingsType();
                                this.this$1.this$0.activeSettingsType.populateCredentials(pa);
                            }
                            this.this$1.this$0.validateFields();
                        }
                    });
                    if (this.this$0.urlFixed) return;
                }
                catch (Throwable throwable) {
                    if (this.this$0.urlFixed) throw throwable;
                    EventQueue.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            this$0.enableUrlCombo(true);
                            RemoteRepository remoteRepository = this$0;
                            synchronized (remoteRepository) {
                                this$0.initialized = true;
                                this$0.notifyAll();
                            }
                        }
                    });
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private void initHeight() {
        int maxHeight = 0;
        for (ConnectionSettingsType t : this.settingTypes) {
            maxHeight = Math.max(maxHeight, t.getPreferedPanelHeight());
        }
        this.panel.connectionSettings.setPreferredSize(new Dimension(0, maxHeight));
        this.panel.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                RemoteRepository.this.panel.connectionSettings.setPreferredSize(null);
                RemoteRepository.this.panel.invalidate();
                RemoteRepository.this.panel.repaint();
                RemoteRepository.this.panel.removeAncestorListener(this);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    private void onBrowse() {
        JTextComponent comboEditor = (JTextComponent)this.panel.urlComboBox.getEditor().getEditorComponent();
        String txt = comboEditor.getText();
        if (txt == null || txt.trim().isEmpty()) {
            return;
        }
        File file = null;
        try {
            URI uri = new URI(comboEditor.getText());
            file = uri.isAbsolute() && "file".equalsIgnoreCase(uri.getScheme()) ? new File(uri) : new File(comboEditor.getText());
        }
        catch (URISyntaxException uri) {
            // empty catch block
        }
        AccessibleJFileChooser fileChooser = new AccessibleJFileChooser(NbBundle.getMessage(RemoteRepositoryPanel.class, (String)"RepositoryPanel.FileChooser.Description"), file);
        fileChooser.setDialogTitle(NbBundle.getMessage(RemoteRepositoryPanel.class, (String)"RepositoryPanel.FileChooser.Title"));
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(1);
        fileChooser.showDialog(this.panel, null);
        File f = fileChooser.getSelectedFile();
        if (f != null) {
            comboEditor.setText(f.toURI().toString());
        }
    }

    private void onProxyConfiguration() {
        OptionsDisplayer.getDefault().open("General");
    }

    private abstract class ConnectionSettingsType {
        private ConnectionSettingsType() {
        }

        protected abstract void setEnabled(boolean var1);

        protected abstract void store();

        protected abstract boolean acceptUri(GitURI var1);

        protected int getPreferedPanelHeight() {
            return 0;
        }

        protected void populateFields(ConnectionSettings connSettings) {
        }

        protected void populateCredentials(PasswordAuthentication pa) {
        }

        protected void requestFocusInWindow() {
        }
    }

    private class GitConnectionSettingsType
    extends ConnectionSettingsType {
        private final JComponent[] inputFields;

        public GitConnectionSettingsType() {
            this.inputFields = new JComponent[]{RemoteRepository.this.panel.directoryBrowseButton, RemoteRepository.this.panel.proxySettingsButton, RemoteRepository.this.panel.repositoryLabel, RemoteRepository.this.panel.tipLabel};
        }

        @Override
        protected void setEnabled(boolean enabled) {
            for (JComponent inputField : this.inputFields) {
                inputField.setEnabled(enabled);
            }
        }

        @Override
        protected void store() {
            GitURI guri = RemoteRepository.this.getURI();
            assert (guri != null);
            if (guri == null) {
                return;
            }
            final ConnectionSettings settings = new ConnectionSettings(guri);
            Runnable outOfAWT = new Runnable(){
                final /* synthetic */ GitConnectionSettingsType this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    GitModuleConfig.getDefault().insertRecentConnectionSettings(settings);
                    this.this$1.RemoteRepository.this.recentConnectionSettings.put(settings.getUri().setUser(null).toString(), settings);
                }
            };
            if (EventQueue.isDispatchThread()) {
                Git.getInstance().getRequestProcessor().post(outOfAWT);
            } else {
                outOfAWT.run();
            }
        }

        @Override
        protected boolean acceptUri(GitURI uri) {
            boolean accepts = false;
            RemoteRepository.this.panel.tipLabel.setText(null);
            if (uri.getScheme() != null && uri.getScheme().equals(Scheme.GIT.toString())) {
                accepts = true;
                RemoteRepository.this.panel.tipLabel.setText(Scheme.GIT.getTip());
            }
            if (accepts) {
                RemoteRepository.this.panel.directoryBrowseButton.setVisible(false);
                RemoteRepository.this.panel.proxySettingsButton.setVisible(true);
                RemoteRepository.this.panel.connectionSettings.removeAll();
            }
            return accepts;
        }
    }

    private final class SSHConnectionSettingsType
    extends ConnectionSettingsType
    implements ActionListener {
        private final JComponent[] inputFields;
        private final SSHPanel settingsPanel = new SSHPanel();
        private final JComponent[] authKeyFields;
        private final JComponent[] authPasswordFields;
        private final EnumSet<Scheme> acceptableSchemes;

        public SSHConnectionSettingsType() {
            this.inputFields = new JComponent[]{this.settingsPanel.lblUser, this.settingsPanel.lblPassword, this.settingsPanel.lblLeaveBlank, this.settingsPanel.lblIdentityFile, this.settingsPanel.lblPassphrase, this.settingsPanel.userTextField, this.settingsPanel.userPasswordField, this.settingsPanel.savePasswordCheckBox, this.settingsPanel.txtIdentityFile, this.settingsPanel.txtPassphrase, this.settingsPanel.btnBrowse, this.settingsPanel.savePassphrase, this.settingsPanel.rbPrivateKey, this.settingsPanel.rbUsernamePassword, RemoteRepository.this.panel.directoryBrowseButton, RemoteRepository.this.panel.proxySettingsButton, RemoteRepository.this.panel.repositoryLabel, RemoteRepository.this.panel.tipLabel};
            this.authKeyFields = new JComponent[]{this.settingsPanel.lblIdentityFile, this.settingsPanel.lblPassphrase, this.settingsPanel.txtIdentityFile, this.settingsPanel.txtPassphrase, this.settingsPanel.btnBrowse, this.settingsPanel.savePassphrase};
            this.authPasswordFields = new JComponent[]{this.settingsPanel.lblPassword, this.settingsPanel.userPasswordField, this.settingsPanel.savePasswordCheckBox};
            this.acceptableSchemes = EnumSet.of(Scheme.SSH, Scheme.SFTP);
            this.attachListeners();
        }

        private void attachListeners() {
            this.settingsPanel.btnBrowse.addActionListener(this);
            this.settingsPanel.rbPrivateKey.addActionListener(this);
            this.settingsPanel.rbUsernamePassword.addActionListener(this);
        }

        @Override
        protected void setEnabled(boolean enabled) {
            for (JComponent inputField : this.inputFields) {
                inputField.setEnabled(enabled);
            }
            if (enabled) {
                this.updateAuthSelection();
            }
        }

        @Override
        protected void populateFields(ConnectionSettings settings) {
            if (settings == null) {
                this.settingsPanel.userTextField.setText("");
                this.settingsPanel.userPasswordField.setText("");
                this.settingsPanel.txtPassphrase.setText("");
                this.settingsPanel.savePasswordCheckBox.setSelected(false);
                this.settingsPanel.savePassphrase.setSelected(false);
                this.settingsPanel.rbPrivateKey.setSelected(false);
                this.settingsPanel.rbUsernamePassword.setSelected(true);
                String identityFile = this.getDefaultIdentityFilePath();
                this.settingsPanel.txtIdentityFile.setText(identityFile);
                return;
            }
            this.settingsPanel.userTextField.setText(settings.getUser());
            char[] pass = settings.getPassword();
            if (pass != null) {
                this.settingsPanel.userPasswordField.setText(new String(pass));
            } else {
                this.settingsPanel.userPasswordField.setText("");
            }
            pass = settings.getPassphrase();
            if (pass != null) {
                this.settingsPanel.txtPassphrase.setText(new String(pass));
            } else {
                this.settingsPanel.txtPassphrase.setText("");
            }
            this.settingsPanel.savePasswordCheckBox.setSelected(settings.isSaveCredentials());
            this.settingsPanel.savePassphrase.setSelected(settings.isSaveCredentials());
            this.settingsPanel.rbPrivateKey.setSelected(settings.isPrivateKeyAuth());
            this.settingsPanel.rbUsernamePassword.setSelected(!settings.isPrivateKeyAuth());
            this.settingsPanel.txtIdentityFile.setText(settings.getIdentityFile());
            this.updateAuthSelection();
        }

        @Override
        protected void store() {
            GitURI guri = RemoteRepository.this.getURI();
            assert (guri != null);
            if (guri == null) {
                return;
            }
            final ConnectionSettings settings = new ConnectionSettings(guri);
            settings.setUser(this.settingsPanel.userTextField.getText());
            settings.setPrivateKeyAuth(this.settingsPanel.rbPrivateKey.isSelected());
            settings.setSaveCredentials(settings.isPrivateKeyAuth() ? this.settingsPanel.savePassphrase.isSelected() : this.settingsPanel.savePasswordCheckBox.isSelected());
            settings.setPassword(this.settingsPanel.userPasswordField.getPassword());
            settings.setPassphrase(this.settingsPanel.txtPassphrase.getPassword());
            settings.setIdentityFile(this.settingsPanel.txtIdentityFile.getText());
            Runnable outOfAWT = new Runnable(){
                final /* synthetic */ SSHConnectionSettingsType this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    GitModuleConfig.getDefault().insertRecentConnectionSettings(settings);
                    this.this$1.RemoteRepository.this.recentConnectionSettings.put(settings.getUri().setUser(null).toString(), settings);
                }
            };
            if (EventQueue.isDispatchThread()) {
                Git.getInstance().getRequestProcessor().post(outOfAWT);
            } else {
                outOfAWT.run();
            }
        }

        @Override
        protected boolean acceptUri(GitURI uri) {
            boolean accepts;
            block3: {
                block2: {
                    accepts = false;
                    RemoteRepository.this.panel.tipLabel.setText(null);
                    if (uri.getScheme() != null) break block2;
                    if (uri.getHost() == null || uri.getHost().length() == 0) break block3;
                    accepts = true;
                    RemoteRepository.this.panel.tipLabel.setText("[user@]host.xz:path/to/repo.git/");
                    break block3;
                }
                for (Scheme s : this.acceptableSchemes) {
                    if (!uri.getScheme().equals(s.toString())) continue;
                    accepts = true;
                    RemoteRepository.this.panel.tipLabel.setText(s.getTip());
                    break;
                }
            }
            if (accepts) {
                RemoteRepository.this.panel.directoryBrowseButton.setVisible(false);
                RemoteRepository.this.panel.proxySettingsButton.setVisible(true);
                RemoteRepository.this.panel.connectionSettings.removeAll();
                RemoteRepository.this.panel.connectionSettings.add((Component)this.settingsPanel, "North");
                this.updateAuthSelection();
            }
            return accepts;
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.settingsPanel.btnBrowse) {
                this.onBrowse();
            } else if (e.getSource() == this.settingsPanel.rbPrivateKey || e.getSource() == this.settingsPanel.rbUsernamePassword) {
                this.updateAuthSelection();
            }
        }

        private void onBrowse() {
            String path = this.settingsPanel.txtIdentityFile.getText();
            if (path.isEmpty()) {
                path = this.getDefaultIdentityFilePath();
            }
            File file = new File(path);
            AccessibleJFileChooser fileChooser = new AccessibleJFileChooser(NbBundle.getMessage(RemoteRepositoryPanel.class, (String)"RepositoryPanel.IdentityFile.FileChooser.Description"), path.isEmpty() ? null : file.getParentFile());
            if (!path.isEmpty()) {
                fileChooser.setSelectedFile(file);
            }
            fileChooser.setDialogType(0);
            fileChooser.setDialogTitle(NbBundle.getMessage(RemoteRepositoryPanel.class, (String)"RepositoryPanel.IdentityFile.FileChooser.Title"));
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setFileSelectionMode(0);
            fileChooser.setFileHidingEnabled(false);
            if (0 == fileChooser.showDialog(RemoteRepository.this.panel, null)) {
                File f = fileChooser.getSelectedFile();
                this.settingsPanel.txtIdentityFile.setText(f.getAbsolutePath());
            }
        }

        private void updateAuthSelection() {
            boolean authViaPrivateKey = this.settingsPanel.rbPrivateKey.isSelected();
            boolean authViaPassword = this.settingsPanel.rbUsernamePassword.isSelected();
            if (!authViaPassword && !authViaPrivateKey) {
                authViaPassword = true;
                this.settingsPanel.rbUsernamePassword.setSelected(true);
            }
            authViaPassword &= this.settingsPanel.rbUsernamePassword.isEnabled();
            authViaPrivateKey &= this.settingsPanel.rbPrivateKey.isEnabled();
            for (JComponent c : this.authKeyFields) {
                c.setEnabled(authViaPrivateKey);
            }
            for (JComponent c : this.authPasswordFields) {
                c.setEnabled(authViaPassword);
            }
            if (authViaPrivateKey && this.settingsPanel.txtIdentityFile.getText().trim().isEmpty()) {
                this.settingsPanel.txtIdentityFile.setText(this.getDefaultIdentityFilePath());
            }
        }

        @Override
        protected int getPreferedPanelHeight() {
            return this.settingsPanel.getPreferredSize().height;
        }

        private String getDefaultIdentityFilePath() {
            String identityFile = "";
            File sshDir = new File(System.getProperty("user.home"), ".ssh");
            File rsaKey = new File(sshDir, "id_rsa");
            File dsaKey = new File(sshDir, "id_dsa");
            if (rsaKey.canRead()) {
                identityFile = rsaKey.getAbsolutePath();
            } else if (dsaKey.canRead()) {
                identityFile = dsaKey.getAbsolutePath();
            }
            return identityFile;
        }

        @Override
        protected void requestFocusInWindow() {
            this.settingsPanel.userTextField.requestFocusInWindow();
        }
    }

    private final class FileConnectionSettingsType
    extends ConnectionSettingsType {
        private final JComponent[] inputFields;
        private final EnumSet<Scheme> acceptableSchemes;

        public FileConnectionSettingsType() {
            this.inputFields = new JComponent[]{RemoteRepository.this.panel.directoryBrowseButton, RemoteRepository.this.panel.proxySettingsButton, RemoteRepository.this.panel.repositoryLabel, RemoteRepository.this.panel.tipLabel};
            this.acceptableSchemes = EnumSet.of(Scheme.FILE);
        }

        @Override
        protected void setEnabled(boolean enabled) {
            for (JComponent inputField : this.inputFields) {
                inputField.setEnabled(enabled);
            }
        }

        @Override
        protected void store() {
            GitURI guri = RemoteRepository.this.getURI();
            assert (guri != null);
            if (guri == null) {
                return;
            }
            final ConnectionSettings settings = new ConnectionSettings(guri);
            Runnable outOfAWT = new Runnable(){
                final /* synthetic */ FileConnectionSettingsType this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    GitModuleConfig.getDefault().insertRecentConnectionSettings(settings);
                    this.this$1.RemoteRepository.this.recentConnectionSettings.put(settings.getUri().setUser(null).toString(), settings);
                }
            };
            if (EventQueue.isDispatchThread()) {
                Git.getInstance().getRequestProcessor().post(outOfAWT);
            } else {
                outOfAWT.run();
            }
        }

        @Override
        protected boolean acceptUri(GitURI uri) {
            boolean accepts = false;
            if (uri.getScheme() == null) {
                accepts = true;
            } else {
                for (Scheme s : this.acceptableSchemes) {
                    if (!uri.getScheme().equals(s.toString())) continue;
                    accepts = true;
                    break;
                }
            }
            if (accepts) {
                RemoteRepository.this.panel.directoryBrowseButton.setVisible(true);
                RemoteRepository.this.panel.proxySettingsButton.setVisible(false);
                RemoteRepository.this.panel.connectionSettings.removeAll();
                RemoteRepository.this.panel.tipLabel.setText(Scheme.FILE.getTip());
            }
            return accepts;
        }
    }

    private class DefaultConnectionSettingsType
    extends ConnectionSettingsType {
        private final JComponent[] inputFields;
        private final UserPasswordPanel settingsPanel = new UserPasswordPanel();
        private final EnumSet<Scheme> acceptableSchemes;

        public DefaultConnectionSettingsType() {
            this.inputFields = new JComponent[]{this.settingsPanel.userTextField, this.settingsPanel.userPasswordField, this.settingsPanel.savePasswordCheckBox, RemoteRepository.this.panel.directoryBrowseButton, RemoteRepository.this.panel.proxySettingsButton, RemoteRepository.this.panel.repositoryLabel, this.settingsPanel.userLabel, this.settingsPanel.passwordLabel, this.settingsPanel.leaveBlankLabel, RemoteRepository.this.panel.tipLabel};
            this.acceptableSchemes = EnumSet.of(Scheme.GIT, Scheme.HTTP, Scheme.HTTPS);
        }

        @Override
        protected void setEnabled(boolean enabled) {
            for (JComponent inputField : this.inputFields) {
                inputField.setEnabled(enabled);
            }
        }

        @Override
        protected void populateFields(ConnectionSettings settings) {
            if (settings == null) {
                this.settingsPanel.userTextField.setText("");
                this.settingsPanel.userPasswordField.setText("");
                this.settingsPanel.savePasswordCheckBox.setSelected(false);
                return;
            }
            this.settingsPanel.userTextField.setText(settings.getUser());
            char[] pass = settings.getPassword();
            if (pass != null) {
                this.settingsPanel.userPasswordField.setText(new String(pass));
            } else {
                this.settingsPanel.userPasswordField.setText("");
            }
            this.settingsPanel.savePasswordCheckBox.setSelected(settings.isSaveCredentials());
        }

        @Override
        protected void populateCredentials(PasswordAuthentication pa) {
            this.settingsPanel.userTextField.setText(pa.getUserName());
            this.settingsPanel.userPasswordField.setText(new String(pa.getPassword()));
            this.settingsPanel.savePasswordCheckBox.setSelected(true);
            this.settingsPanel.savePasswordCheckBox.setEnabled(false);
        }

        @Override
        protected void store() {
            GitURI guri = RemoteRepository.this.getURI();
            assert (guri != null);
            if (guri == null) {
                return;
            }
            final ConnectionSettings settings = new ConnectionSettings(guri);
            settings.setUser(this.settingsPanel.userTextField.getText());
            settings.setPrivateKeyAuth(false);
            settings.setSaveCredentials(this.settingsPanel.savePasswordCheckBox.isSelected());
            settings.setPassword(this.settingsPanel.userPasswordField.getPassword());
            Runnable outOfAWT = new Runnable(){
                final /* synthetic */ DefaultConnectionSettingsType this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    GitModuleConfig.getDefault().insertRecentConnectionSettings(settings);
                    this.this$1.RemoteRepository.this.recentConnectionSettings.put(settings.getUri().setUser(null).toString(), settings);
                }
            };
            if (EventQueue.isDispatchThread()) {
                Git.getInstance().getRequestProcessor().post(outOfAWT);
            } else {
                outOfAWT.run();
            }
        }

        @Override
        protected boolean acceptUri(GitURI uri) {
            boolean accepts = false;
            RemoteRepository.this.panel.tipLabel.setText(null);
            if (uri.getScheme() != null) {
                accepts = true;
                for (Scheme s : this.acceptableSchemes) {
                    if (!uri.getScheme().equals(s.toString())) continue;
                    RemoteRepository.this.panel.tipLabel.setText(s.getTip());
                    break;
                }
            }
            if (accepts) {
                RemoteRepository.this.panel.directoryBrowseButton.setVisible(false);
                RemoteRepository.this.panel.proxySettingsButton.setVisible(true);
                RemoteRepository.this.panel.connectionSettings.removeAll();
                RemoteRepository.this.panel.connectionSettings.add((Component)this.settingsPanel, "North");
            }
            return accepts;
        }

        @Override
        protected int getPreferedPanelHeight() {
            return this.settingsPanel.getPreferredSize().height;
        }

        @Override
        protected void requestFocusInWindow() {
            this.settingsPanel.userTextField.requestFocusInWindow();
        }
    }

    private static enum Scheme {
        FILE("file", NbBundle.getMessage(RemoteRepository.class, (String)"Scheme.FILE")),
        HTTP("http", NbBundle.getMessage(RemoteRepository.class, (String)"Scheme.HTTP")),
        HTTPS("https", NbBundle.getMessage(RemoteRepository.class, (String)"Scheme.HTTPS")),
        SSH("ssh", NbBundle.getMessage(RemoteRepository.class, (String)"Scheme.SSH")),
        SFTP("sftp", NbBundle.getMessage(RemoteRepository.class, (String)"Scheme.SFTP")),
        GIT("git", NbBundle.getMessage(RemoteRepository.class, (String)"Scheme.GIT"));

        private final String name;
        private final String tip;

        private Scheme(String name, String tip) {
            this.name = name;
            this.tip = tip;
        }

        private String getTip() {
            return this.tip;
        }

        public String toString() {
            return this.name;
        }
    }
}

