/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.nodes;

import java.awt.Image;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.netbeans.modules.websvc.saas.spi.SaasNodeActionsProvider;
import org.netbeans.modules.websvc.saas.ui.actions.DeleteServiceAction;
import org.netbeans.modules.websvc.saas.ui.actions.RefreshServiceAction;
import org.netbeans.modules.websvc.saas.ui.actions.ViewApiDocAction;
import org.netbeans.modules.websvc.saas.ui.nodes.SaasNodeChildren;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;

public abstract class SaasNode
extends AbstractNode {
    protected Saas saas;

    public SaasNode(SaasNodeChildren nodeChildren, AbstractLookup lookup, Saas saas) {
        super((Children)nodeChildren, (Lookup)lookup);
        this.saas = saas;
    }

    public Saas getSaas() {
        return this.saas;
    }

    public String getDisplayName() {
        return this.saas.getDisplayName();
    }

    public String getShortDescription() {
        return this.saas.getDescription();
    }

    public Image getIcon(int type) {
        return this.getGenericIcon(type);
    }

    protected abstract Image getGenericIcon(int var1);

    public static List<Action> getActions(Lookup lookup) {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (SaasNodeActionsProvider ext : SaasUtil.getSaasNodeActionsProviders()) {
            actions.addAll(Arrays.asList(ext.getSaasActions(lookup)));
        }
        return actions;
    }

    public Action[] getActions(boolean context) {
        List<Action> actions = SaasNode.getActions(this.getLookup());
        actions.add((Action)SystemAction.get(ViewApiDocAction.class));
        actions.add((Action)SystemAction.get(DeleteServiceAction.class));
        actions.add((Action)SystemAction.get(RefreshServiceAction.class));
        return actions.toArray(new Action[0]);
    }

    public void destroy() throws IOException {
        SaasServicesModel.getInstance().removeService(this.getSaas());
        super.destroy();
    }

    public boolean canDestroy() {
        return this.getSaas().isUserDefined();
    }
}

