/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.ui.options;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.css.prep.less.LessExecutable;
import org.netbeans.modules.css.prep.ui.options.Bundle;
import org.netbeans.modules.css.prep.util.FileUtils;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public final class LessOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 268356546654654L;
    private static final Logger LOGGER = Logger.getLogger(LessOptionsPanel.class.getName());
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JLabel installLessLabel;
    private JCheckBox lessDebugCheckBox;
    private JCheckBox lessOutputOnErrorCheckBox;
    private JButton lessPathBrowseButton;
    private JLabel lessPathHintLabel;
    private JLabel lessPathLabel;
    private JButton lessPathSearchButton;
    private JTextField lessPathTextField;

    public LessOptionsPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.lessPathHintLabel.setText(Bundle.LessOptionsPanel_less_path_hint(LessExecutable.EXECUTABLE_LONG_NAME, "lessc"));
        this.lessPathTextField.getDocument().addDocumentListener(new DefaultDocumentListener());
        DefaultItemListener defaultItemListener = new DefaultItemListener();
        this.lessOutputOnErrorCheckBox.addItemListener(defaultItemListener);
        this.lessDebugCheckBox.addItemListener(defaultItemListener);
    }

    public String getLessPath() {
        return this.lessPathTextField.getText();
    }

    public void setLessPath(String path) {
        this.lessPathTextField.setText(path);
    }

    public boolean getLessOutputOnError() {
        return this.lessOutputOnErrorCheckBox.isSelected();
    }

    public void setLessOutputOnError(boolean outputOnError) {
        this.lessOutputOnErrorCheckBox.setSelected(outputOnError);
    }

    public boolean getLessDebug() {
        return this.lessDebugCheckBox.isSelected();
    }

    public void setLessDebug(boolean debug) {
        this.lessDebugCheckBox.setSelected(debug);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.lessPathLabel = new JLabel();
        this.lessPathTextField = new JTextField();
        this.lessPathBrowseButton = new JButton();
        this.lessPathSearchButton = new JButton();
        this.lessPathHintLabel = new JLabel();
        this.installLessLabel = new JLabel();
        this.lessOutputOnErrorCheckBox = new JCheckBox();
        this.lessDebugCheckBox = new JCheckBox();
        this.lessPathLabel.setLabelFor(this.lessPathTextField);
        Mnemonics.setLocalizedText((JLabel)this.lessPathLabel, (String)NbBundle.getMessage(LessOptionsPanel.class, (String)"LessOptionsPanel.lessPathLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.lessPathBrowseButton, (String)NbBundle.getMessage(LessOptionsPanel.class, (String)"LessOptionsPanel.lessPathBrowseButton.text"));
        this.lessPathBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LessOptionsPanel.this.lessPathBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.lessPathSearchButton, (String)NbBundle.getMessage(LessOptionsPanel.class, (String)"LessOptionsPanel.lessPathSearchButton.text"));
        this.lessPathSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LessOptionsPanel.this.lessPathSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lessPathHintLabel, (String)"HINT");
        Mnemonics.setLocalizedText((JLabel)this.installLessLabel, (String)NbBundle.getMessage(LessOptionsPanel.class, (String)"LessOptionsPanel.installLessLabel.text"));
        this.installLessLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                LessOptionsPanel.this.installLessLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                LessOptionsPanel.this.installLessLabelMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.lessOutputOnErrorCheckBox, (String)NbBundle.getMessage(LessOptionsPanel.class, (String)"LessOptionsPanel.lessOutputOnErrorCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.lessDebugCheckBox, (String)NbBundle.getMessage(LessOptionsPanel.class, (String)"LessOptionsPanel.lessDebugCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lessPathLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lessPathHintLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.installLessLabel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.lessPathTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lessPathBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lessPathSearchButton)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lessOutputOnErrorCheckBox).addComponent(this.lessDebugCheckBox)).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lessPathTextField, -2, -1, -2).addComponent(this.lessPathLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lessPathSearchButton).addComponent(this.lessPathBrowseButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.installLessLabel, -2, -1, -2).addComponent(this.lessPathHintLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lessOutputOnErrorCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lessDebugCheckBox).addGap(0, 0, Short.MAX_VALUE)));
    }

    private void lessPathBrowseButtonActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(LessOptionsPanel.class).setFilesOnly(true).setTitle(Bundle.LessOptionsPanel_less_browse_title()).showOpenDialog();
        if (file != null) {
            this.lessPathTextField.setText(file.getAbsolutePath());
        }
    }

    private void lessPathSearchButtonActionPerformed(ActionEvent evt) {
        List<String> lessPaths = FileUtils.findFileOnUsersPath(LessExecutable.EXECUTABLE_LONG_NAME, "lessc");
        if (lessPaths.isEmpty()) {
            StatusDisplayer.getDefault().setStatusText(Bundle.LessOptionsPanel_executable_notFound());
        } else {
            this.lessPathTextField.setText(lessPaths.get(0));
        }
    }

    private void installLessLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void installLessLabelMousePressed(MouseEvent evt) {
        try {
            URL url = new URL("http://lesscss.org/");
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            LessOptionsPanel.this.fireChange();
        }
    }

    private final class DefaultItemListener
    implements ItemListener {
        private DefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            LessOptionsPanel.this.fireChange();
        }
    }
}

