/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.rest.wizard;

import java.beans.Introspector;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.client.rest.wizard.JSClientGenerator;
import org.netbeans.modules.web.client.rest.wizard.ModelAttribute;
import org.netbeans.modules.web.client.rest.wizard.RestPanel;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.spi.MiscUtilities;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.openide.filesystems.FileObject;

class ModelGenerator {
    private static final String SLASH = "/";
    private static final String ID = "javax.persistence.Id";
    private final StringBuilder myCommonModels;
    private final RestServiceDescription myDescription;
    private final Set<String> myEntities;
    private final RestPanel.JsUi myUi;
    private Set<ModelAttribute> myAttributes;
    private String myDisplayNameAlias;
    private String myModelName;
    private String myCollectionModelName;
    private ModelAttribute myIdAttribute;

    ModelGenerator(RestServiceDescription description, StringBuilder builder, Set<String> entities, RestPanel.JsUi ui) {
        this.myDescription = description;
        this.myCommonModels = builder;
        this.myEntities = entities;
        this.myUi = ui;
    }

    void generateModel(TypeElement entity, String path, String collectionPath, Map<JSClientGenerator.HttpRequests, String> httpPaths, Map<JSClientGenerator.HttpRequests, Boolean> useIds, CompilationController controller) throws IOException {
        String fqn = entity.getQualifiedName().toString();
        String name = entity.getSimpleName().toString();
        this.myModelName = this.suggestModelName(name);
        this.myCommonModels.append("\n// Model for ");
        if (name.equals(this.myModelName)) {
            this.myCommonModels.append(name);
        } else {
            this.myCommonModels.append(fqn);
        }
        this.myCommonModels.append(" entity\n");
        String url = this.getUrl(path);
        this.myCommonModels.append("models.");
        this.myCommonModels.append(this.myModelName);
        this.myCommonModels.append(" = Backbone.Model.extend({\n");
        this.myCommonModels.append("urlRoot : \"");
        this.myCommonModels.append(url);
        this.myCommonModels.append("\"");
        this.myAttributes = new HashSet<ModelAttribute>();
        String parsedData = this.parse(entity, controller);
        if (parsedData != null) {
            this.myCommonModels.append(',');
            this.myCommonModels.append(parsedData);
        }
        if (!this.myAttributes.isEmpty()) {
            ModelAttribute preffered = ModelAttribute.getPreffered();
            this.myDisplayNameAlias = this.myAttributes.contains(preffered) ? preffered.getName() : (this.myIdAttribute == null ? this.myAttributes.iterator().next().getName() : this.myIdAttribute.getName());
            this.myCommonModels.append(",\n toViewJson: function(){\n");
            this.myCommonModels.append("var result = this.toJSON();");
            this.myCommonModels.append(" // displayName property is used to render item in the list\n");
            this.myCommonModels.append("result.displayName = this.get('");
            this.myCommonModels.append(this.myDisplayNameAlias);
            this.myCommonModels.append("');\n return result;\n},\n");
            this.myCommonModels.append("isNew: function(){\n");
            this.myCommonModels.append(" // default isNew() method imlementation is\n");
            this.myCommonModels.append(" // based on the 'id' initialization which\n");
            this.myCommonModels.append(" // sometimes is required to be initialized.\n");
            this.myCommonModels.append(" // So isNew() is rediefined here\n");
            this.myCommonModels.append("return this.notSynced;\n}");
        } else if (this.myIdAttribute != null) {
            this.myDisplayNameAlias = this.myIdAttribute.getName();
        }
        String sync = this.overrideSync(url, httpPaths, useIds);
        if (sync != null && sync.length() > 0) {
            this.myCommonModels.append(",\n");
            this.myCommonModels.append(sync);
            this.myCommonModels.append("\n");
        }
        this.myCommonModels.append("\n});\n\n");
        if (collectionPath == null) {
            return;
        }
        this.myCommonModels.append("\n // Collection class for ");
        if (name.equals(this.myModelName)) {
            this.myCommonModels.append(name);
        } else {
            this.myCommonModels.append(entity.getQualifiedName().toString());
        }
        this.myCommonModels.append(" entities\n");
        this.myCommonModels.append("models.");
        StringBuilder builder = new StringBuilder(this.myModelName);
        builder.append("Collection");
        this.myCollectionModelName = builder.toString();
        this.myCommonModels.append(this.myCollectionModelName);
        this.myCommonModels.append(" = Backbone.Collection.extend({\n");
        this.myCommonModels.append("model: models.");
        this.myCommonModels.append(this.myModelName);
        this.myCommonModels.append(",\nurl : \"");
        this.myCommonModels.append(this.getUrl(collectionPath));
        this.myCommonModels.append("\",\n");
        this.myCommonModels.append(this.getModifierdSync(""));
        this.myCommonModels.append("});\n\n");
    }

    RestPanel.JsUi getUi() {
        return this.myUi;
    }

    boolean hasCollection() {
        return this.myCollectionModelName != null;
    }

    Set<ModelAttribute> getAttributes() {
        return this.myAttributes;
    }

    String getDisplayNameAlias() {
        return this.myDisplayNameAlias;
    }

    String getModelName() {
        return this.myModelName;
    }

    String getCollectionModelName() {
        return this.myCollectionModelName;
    }

    ModelAttribute getIdAttribute() {
        return this.myIdAttribute;
    }

    private String overrideSync(String url, Map<JSClientGenerator.HttpRequests, String> httpPaths, Map<JSClientGenerator.HttpRequests, Boolean> useIds) throws IOException {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<JSClientGenerator.HttpRequests, String> entry : httpPaths.entrySet()) {
            this.overrideMethod(url, entry.getValue(), useIds.get((Object)entry.getKey()), entry.getKey(), builder);
        }
        EnumSet<JSClientGenerator.HttpRequests> set = EnumSet.allOf(JSClientGenerator.HttpRequests.class);
        set.removeAll(httpPaths.keySet());
        for (JSClientGenerator.HttpRequests request : set) {
            this.overrideMethod(url, null, null, request, builder);
        }
        return this.getModifierdSync(builder.toString());
    }

    private String getModifierdSync(String body) {
        StringBuilder result = new StringBuilder();
        result.append("sync: function(method, model, options){\n");
        result.append("options || (options = {});\n");
        result.append("var errorHandler = {\n");
        result.append("error: function (jqXHR, textStatus, errorThrown){\n");
        result.append(" // TODO: put your error handling code here\n");
        result.append(" // If you use the JS client from the different domain\n");
        result.append(" // (f.e. locally) then Cross-origin resource sharing \n");
        result.append(" // headers has to be set on the REST server side.\n");
        result.append(" // Otherwise the JS client has to be copied into the\n");
        result.append(" // some (f.e. the same) Web project on the same domain\n");
        result.append("alert('Unable to fulfil the request');\n}\n};\n\n");
        result.append(body);
        result.append("var result = Backbone.sync(method, model, ");
        result.append("_.extend(options,errorHandler));\n");
        result.append("return result;\n}\n");
        return result.toString();
    }

    private String getUrl(String relativePath) throws IOException {
        Project project = FileOwnerQuery.getOwner((FileObject)this.myDescription.getFile());
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        String applicationPath = restSupport.getApplicationPath();
        String uri = this.myDescription.getUriTemplate();
        applicationPath = applicationPath == null ? uri : this.addUrlPath(applicationPath, uri);
        applicationPath = this.addUrlPath(applicationPath, relativePath);
        return this.addUrlPath(MiscUtilities.getContextRootURL((Project)project), applicationPath);
    }

    private String suggestModelName(String name) {
        if (this.myEntities.contains(name)) {
            int index = 1;
            while (true) {
                String newName;
                if (!this.myEntities.contains(newName = name + index)) {
                    this.myEntities.add(newName);
                    return newName;
                }
                ++index;
            }
        }
        this.myEntities.add(name);
        return name;
    }

    private String parse(TypeElement entity, CompilationController controller) {
        Set<String> attributes = this.parseBeanMethods(entity, controller);
        List<VariableElement> fields = ElementFilter.fieldsIn(controller.getElements().getAllMembers(entity));
        VariableElement id = null;
        for (VariableElement field : fields) {
            boolean has;
            if (JSClientGenerator.getAnnotation(field, ID) == null || !(has = attributes.remove(field.getSimpleName().toString()))) continue;
            id = field;
            break;
        }
        StringBuilder builder = new StringBuilder();
        if (id != null) {
            String idAttr = id.getSimpleName().toString();
            builder.append("\nidAttribute : '");
            builder.append(idAttr);
            builder.append("'");
            if (attributes.size() > 0) {
                builder.append(',');
            }
            this.myIdAttribute = new ModelAttribute(idAttr);
        }
        if (attributes.size() > 0) {
            builder.append("\ndefaults: {");
            for (String attribute : attributes) {
                this.myAttributes.add(new ModelAttribute(attribute));
                builder.append("\n");
                builder.append(attribute);
                builder.append(": \"\",");
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append("\n}");
        }
        if (builder.length() > 0) {
            return builder.toString();
        }
        return null;
    }

    private Set<String> parseBeanMethods(TypeElement entity, CompilationController controller) {
        List<ExecutableElement> methods = ElementFilter.methodsIn(controller.getElements().getAllMembers(entity));
        HashSet<String> result = new HashSet<String>();
        HashMap<String, TypeMirror> getAttrs = new HashMap<String, TypeMirror>();
        HashMap<String, TypeMirror> setAttrs = new HashMap<String, TypeMirror>();
        for (ExecutableElement method : methods) {
            Object[] attribute;
            if (!method.getModifiers().contains((Object)Modifier.PUBLIC) || (attribute = this.getAttrName(method, controller)) == null) continue;
            String name = (String)attribute[1];
            TypeMirror type = (TypeMirror)attribute[2];
            if (attribute[0] == JSClientGenerator.MethodType.GET) {
                if (!this.findAccessor(name, type, getAttrs, setAttrs, controller)) continue;
                result.add(name);
                continue;
            }
            if (!this.findAccessor(name, type, setAttrs, getAttrs, controller)) continue;
            result.add(name);
        }
        return result;
    }

    private boolean findAccessor(String name, TypeMirror type, Map<String, TypeMirror> map1, Map<String, TypeMirror> map2, CompilationController controller) {
        TypeMirror typeMirror = map2.remove(name);
        if (typeMirror != null && controller.getTypes().isSameType(typeMirror, type)) {
            return true;
        }
        map1.put(name, type);
        return false;
    }

    private Object[] getAttrName(ExecutableElement method, CompilationController controller) {
        String name = method.getSimpleName().toString();
        if (name.startsWith("set")) {
            TypeMirror returnType = method.getReturnType();
            if (returnType.getKind() != TypeKind.VOID) {
                return null;
            }
            List<? extends VariableElement> parameters = method.getParameters();
            if (parameters.size() != 1) {
                return null;
            }
            VariableElement param = parameters.get(0);
            TypeMirror type = param.asType();
            if (this.isSimple(type, controller)) {
                return new Object[]{JSClientGenerator.MethodType.SET, Introspector.decapitalize(name.substring(3)), type};
            }
            return null;
        }
        int start = 0;
        if (name.startsWith("get")) {
            start = 3;
        } else if (name.startsWith("is")) {
            start = 2;
        }
        if (start > 0) {
            List<? extends VariableElement> parameters = method.getParameters();
            if (!parameters.isEmpty()) {
                return null;
            }
            TypeMirror returnType = method.getReturnType();
            if (this.isSimple(returnType, controller)) {
                return new Object[]{JSClientGenerator.MethodType.GET, Introspector.decapitalize(name.substring(start)), returnType};
            }
            return null;
        }
        return null;
    }

    private boolean isSimple(TypeMirror typeMirror, CompilationController controller) {
        PackageElement pack;
        if (typeMirror.getKind().isPrimitive()) {
            return true;
        }
        Element fieldTypeElement = controller.getTypes().asElement(typeMirror);
        TypeElement stringElement = controller.getElements().getTypeElement(String.class.getName());
        if (stringElement != null && stringElement.equals(fieldTypeElement)) {
            return true;
        }
        if (fieldTypeElement != null && (pack = controller.getElements().getPackageOf(fieldTypeElement)).getQualifiedName().contentEquals("java.lang")) {
            try {
                if (controller.getTypes().unboxedType(typeMirror) != null) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    private void overrideMethod(String url, String path, Boolean useId, JSClientGenerator.HttpRequests request, StringBuilder builder) throws IOException {
        if (path == null) {
            builder.append("if(method==='");
            builder.append(request.toString());
            builder.append("'){\n");
            builder.append("return false;\n}\n");
        } else {
            path = this.getUrl(path);
            StringBuilder newUrlSnippet = new StringBuilder();
            boolean isModified = false;
            if (!url.equals(path)) {
                newUrlSnippet.append("options.url = '");
                newUrlSnippet.append(path);
                isModified = true;
            }
            if (useId != null && useId.booleanValue()) {
                if (isModified) {
                    if (!path.endsWith(SLASH)) {
                        newUrlSnippet.append('/');
                    }
                    newUrlSnippet.append("'+model.id;\n");
                }
            } else if (isModified) {
                newUrlSnippet.append("';\n");
            } else {
                newUrlSnippet.append("options.url = '");
                newUrlSnippet.append(path);
                newUrlSnippet.append("';\n");
            }
            if (newUrlSnippet.length() == 0) {
                return;
            }
            builder.append("if(method==='");
            builder.append(request.toString());
            builder.append("'){\n");
            builder.append((CharSequence)newUrlSnippet);
            builder.append("}\n");
        }
    }

    private String addUrlPath(String path, String uri) {
        path = uri.startsWith(SLASH) ? (path.endsWith(SLASH) ? path + uri.substring(1) : path + uri) : (path.endsWith(SLASH) ? path + uri : path + SLASH + uri);
        return path;
    }
}

