/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.data;

import java.net.URL;
import java.util.List;

public class PayaraLibrary {
    private final String libraryID;
    private final List<URL> classpath;
    private final List<URL> javadocs;
    private final List<String> javadocLookups;
    private final List<URL> sources;
    private final List<Maven> maven;

    public PayaraLibrary(String libraryID, List<URL> classpath, List<URL> javadocs, List<String> javadocLookups, List<URL> sources, List<Maven> maven) {
        this.libraryID = libraryID;
        this.classpath = classpath;
        this.javadocs = javadocs;
        this.javadocLookups = javadocLookups;
        this.sources = sources;
        this.maven = maven;
    }

    public String getLibraryID() {
        return this.libraryID;
    }

    public List<URL> getClasspath() {
        return this.classpath;
    }

    public List<URL> getJavadocs() {
        return this.javadocs;
    }

    public List<String> getJavadocLookups() {
        return this.javadocLookups;
    }

    public List<URL> getSources() {
        return this.sources;
    }

    public String getMavenDeps() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Maven mvn : this.maven) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(mvn.groupId);
            sb.append(':');
            sb.append(mvn.artifactId);
            sb.append(':');
            sb.append(mvn.version);
            sb.append(":jar");
        }
        return sb.toString();
    }

    public static class Maven {
        private final String groupId;
        private final String artifactId;
        private final String version;

        public Maven(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }
    }
}

