/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.profiler.j2ee.Bundle;
import org.openide.util.NbBundle;

public class DirectorySelectorCombo
extends JPanel {
    public static final String PROPERTY_SELECTEDPATH = "selectedPath";
    private Object lastSelectedObject = null;
    private Object propertyChangeTracker = null;
    private int lastKeypress = 0;
    private String actionText;
    private String welcomeText;
    private String noneText;
    private int itemCountLimit;
    private boolean showWelcome;
    private boolean validSelection;
    private String lastSelectedPath;
    private Set<String> supportedExtensions;
    private JComboBox fileMRU;

    public DirectorySelectorCombo() {
        this.initComponents();
        this.initCustom();
    }

    private void initComponents() {
        this.fileMRU = new JComboBox();
        this.fileMRU.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.fileMRU.setRenderer(new SeparatedListCellRenderer());
        this.fileMRU.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                DirectorySelectorCombo.this.fileMRUPopupMenuWillBecomeVisible(evt);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                DirectorySelectorCombo.this.fileMRUPopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }
        });
        this.fileMRU.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DirectorySelectorCombo.this.fileMRUActionPerformed(evt);
            }
        });
        this.fileMRU.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DirectorySelectorCombo.this.fileMRUKeyPressed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileMRU, 0, 207, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileMRU, -2, -1, -2));
        this.fileMRU.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DirectorySelectorCombo.class, (String)"DirectorySelectorCombo.fileMRU.AccessibleContext.accessibleName"));
        this.fileMRU.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DirectorySelectorCombo.class, (String)"DirectorySelectorCombo.fileMRU.AccessibleContext.accessibleDescription"));
    }

    private void fileMRUPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.fileMRU.getModel();
        ArrayList mukls = new ArrayList();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!(model.getElementAt(i) instanceof ComboListElement) || !((ComboListElement)model.getElementAt(i)).isVolatile()) continue;
            mukls.add(model.getElementAt(i));
        }
        Iterator it = mukls.iterator();
        while (it.hasNext()) {
            Object elem = it.next();
            model.removeElement(elem);
            it.remove();
        }
    }

    private void fileMRUPopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        if (!(this.fileMRU.getSelectedItem() instanceof ComboListElement)) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((ComboListElement)DirectorySelectorCombo.this.fileMRU.getSelectedItem()).select();
            }
        });
    }

    private void fileMRUKeyPressed(KeyEvent evt) {
        switch (evt.getKeyCode()) {
            case 38: {
                this.lastKeypress = 1;
                break;
            }
            case 40: {
                this.lastKeypress = 2;
                break;
            }
            default: {
                this.lastKeypress = 0;
            }
        }
    }

    private void fileMRUActionPerformed(ActionEvent evt) {
        if (this.fileMRU.getSelectedItem() == null) {
            return;
        }
        if (this.fileMRU.getSelectedItem() instanceof JSeparator) {
            int currentIndex = this.fileMRU.getSelectedIndex();
            if (this.lastKeypress == 1) {
                --currentIndex;
            } else if (this.lastKeypress == 2) {
                ++currentIndex;
            }
            if (currentIndex < 0) {
                currentIndex = this.fileMRU.getItemCount() - 1;
            } else if (currentIndex >= this.fileMRU.getItemCount()) {
                currentIndex = 0;
            }
            this.fileMRU.setSelectedIndex(currentIndex);
        }
    }

    private void initCustom() {
        this.showWelcome = true;
        this.welcomeText = Bundle.DirectorySelectorCombo_SelectActionString();
        this.noneText = Bundle.DirectorySelectorCombo_NoneString();
        this.actionText = Bundle.DirectorySelectorCombo_ActionString();
        this.itemCountLimit = 2;
        this.supportedExtensions = new HashSet<String>();
    }

    private void changeModel() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.fileMRU.getModel();
        model.removeAllElements();
        if (this.isShowWelcome()) {
            model.addElement(new StringComboListElement(this.getWelcomeText(), true));
        }
        model.addElement(new ComboListElement(this.getNoneText()){

            @Override
            public void onSelection() {
                DirectorySelectorCombo.this.validSelection = false;
            }
        });
        JSeparator separ = new JSeparator();
        model.addElement(separ);
        model.addElement(new ComboListElement(this.getActionText()){

            @Override
            public void onSelection() {
                DirectorySelectorCombo.this.validSelection = false;
                DirectorySelectorCombo.this.browseFiles();
            }
        });
    }

    private void browseFiles() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setDialogType(0);
        chooser.setDialogTitle(Bundle.DirectorySelectorCombo_DialogCaption());
        chooser.setSelectedFile(new File(this.lastSelectedPath));
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String path = f.getAbsolutePath();
                String ext = path.substring(path.lastIndexOf(46) + 1);
                return DirectorySelectorCombo.this.supportedExtensions.contains(ext);
            }

            @Override
            public String getDescription() {
                return Bundle.DirectorySelectorCombo_DialogFilter();
            }
        });
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            File dir = chooser.getSelectedFile();
            ComboListElement newPath = this.addPath(dir.getAbsolutePath());
            this.fileMRU.setSelectedItem(newPath);
            newPath.select();
        } else if (returnVal == 1) {
            this.fileMRU.setSelectedItem(this.lastSelectedObject);
        }
    }

    private ComboListElement addPath(String path) {
        StringComboListElement newPath;
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.fileMRU.getModel();
        int index = model.getIndexOf(newPath = new StringComboListElement(path));
        if (index == -1) {
            model.insertElementAt(newPath, 1);
        }
        if (model.getSize() > this.itemCountLimit + 3) {
            model.removeElementAt(model.getSize() - 3);
        }
        return newPath;
    }

    public String getActionText() {
        return this.actionText;
    }

    public void setActionText(String value) {
        this.actionText = value;
        this.changeModel();
    }

    public String getWelcomeText() {
        return this.welcomeText;
    }

    public void setWelcomeText(String value) {
        this.welcomeText = value;
        this.changeModel();
    }

    public String getNoneText() {
        return this.noneText;
    }

    public void setNoneText(String value) {
        this.noneText = value;
        this.changeModel();
    }

    public int getItemCountLimit() {
        return this.itemCountLimit;
    }

    public void setItemCountLimit(int value) {
        if (value < 2) {
            value = 2;
        }
        this.itemCountLimit = value;
    }

    public boolean isShowWelcome() {
        return this.showWelcome;
    }

    public void setShowWelcome(boolean value) {
        this.showWelcome = value;
    }

    public boolean isEditable() {
        return this.fileMRU.isEditable();
    }

    public void setEditable(boolean value) {
        this.fileMRU.setEditable(value);
    }

    public boolean isValidSelection() {
        return this.validSelection;
    }

    public void setSupportedExtensions(Set<String> supportedExtensions) {
        this.supportedExtensions.clear();
        this.supportedExtensions.addAll(supportedExtensions);
    }

    public Set<String> getSupportedExtensions() {
        return this.supportedExtensions;
    }

    public String getSelectedPath() {
        if (this.isValidSelection()) {
            this.lastSelectedPath = this.fileMRU.getSelectedItem().toString();
            return this.fileMRU.getSelectedItem().toString();
        }
        return "";
    }

    public void setStartDir(String path) {
        this.lastSelectedPath = path;
    }

    public String getStartDir() {
        return this.lastSelectedPath;
    }

    private class SeparatedListCellRenderer
    implements ListCellRenderer {
        private ListCellRenderer delegate = new DefaultListCellRenderer();

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof JSeparator) {
                return (Component)value;
            }
            return this.delegate.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    private abstract class ComboListElement {
        private Object value;
        private boolean asVolatile;

        public abstract void onSelection();

        public ComboListElement(Object object) {
            this(object, false);
        }

        public ComboListElement(Object object, boolean asVolatile) {
            this.value = object;
            this.asVolatile = asVolatile;
        }

        public void select() {
            String oldVal;
            this.onSelection();
            String string = oldVal = DirectorySelectorCombo.this.propertyChangeTracker != null ? DirectorySelectorCombo.this.propertyChangeTracker.toString() : "";
            String newVal = DirectorySelectorCombo.this.isValidSelection() ? (DirectorySelectorCombo.this.lastSelectedObject != null ? DirectorySelectorCombo.this.lastSelectedObject.toString() : "") : null;
            DirectorySelectorCombo.this.firePropertyChange(DirectorySelectorCombo.PROPERTY_SELECTEDPATH, oldVal, newVal);
            DirectorySelectorCombo.this.propertyChangeTracker = newVal;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isVolatile() {
            return this.asVolatile;
        }

        public String toString() {
            return this.value != null ? this.value.toString() : "";
        }

        public boolean equals(Object other) {
            if (!(other instanceof ComboListElement)) {
                return false;
            }
            if (this.value == null || other == null || ((ComboListElement)other).getValue() == null) {
                return false;
            }
            return this.value.equals(((ComboListElement)other).getValue());
        }
    }

    private class StringComboListElement
    extends ComboListElement {
        public StringComboListElement(Object object) {
            super(object, false);
        }

        public StringComboListElement(Object object, boolean asVolatile) {
            super(object, asVolatile);
        }

        @Override
        public void onSelection() {
            DirectorySelectorCombo.this.lastSelectedObject = this;
            DirectorySelectorCombo.this.validSelection = true;
            if (DirectorySelectorCombo.this.lastSelectedObject != null) {
                DirectorySelectorCombo.this.fileMRU.setToolTipText(DirectorySelectorCombo.this.lastSelectedObject.toString());
            }
        }
    }
}

