/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.Controller;
import org.netbeans.core.windows.view.ViewElement;
import org.netbeans.core.windows.view.dnd.TopComponentDraggable;
import org.netbeans.core.windows.view.dnd.TopComponentDroppable;
import org.netbeans.core.windows.view.dnd.WindowDnDManager;
import org.netbeans.core.windows.view.ui.MainWindow;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.ExternalDropHandler;

public class EditorView
extends ViewElement {
    private static final boolean IS_GTK = "GTK".equals(UIManager.getLookAndFeel().getID());
    private ViewElement editorArea;
    private EditorAreaComponent editorAreaComponent;
    private final WindowDnDManager windowDnDManager;
    private static DataFlavor URI_LIST_DATA_FLAVOR;

    public EditorView(Controller controller, WindowDnDManager windowDnDManager, double resizeWeight, ViewElement editorArea) {
        super(controller, resizeWeight);
        this.editorArea = editorArea;
        this.windowDnDManager = windowDnDManager;
    }

    Rectangle getPureBounds() {
        EditorAreaComponent comp = this.getEditorAreaComponent();
        Rectangle bounds = comp.getBounds();
        Point location = new Point(0, 0);
        SwingUtilities.convertPointToScreen(location, comp);
        bounds.setLocation(location);
        return bounds;
    }

    private EditorAreaComponent getEditorAreaComponent() {
        if (this.editorAreaComponent == null) {
            this.editorAreaComponent = new EditorAreaComponent(this, this.windowDnDManager);
        }
        if (IS_GTK && !this.editorAreaComponent.isValid()) {
            this.editorAreaComponent.repaint();
        }
        return this.editorAreaComponent;
    }

    private void manageBorder(JPanel panel) {
        if (this.editorArea != null) {
            panel.setBorder(null);
        } else if (Utilities.isMac()) {
            panel.setBorder(BorderFactory.createEmptyBorder());
        } else {
            Border border = UIManager.getBorder("Nb.EmptyEditorArea.border");
            if (null == border) {
                border = UIManager.getBorder("Nb.ScrollPane.border");
            }
            panel.setBorder(border);
        }
    }

    public ViewElement getEditorArea() {
        return this.editorArea;
    }

    public void setEditorArea(ViewElement editorArea) {
        this.editorArea = editorArea;
    }

    @Override
    public Component getComponent() {
        return this.getEditorAreaComponent();
    }

    @Override
    public boolean updateAWTHierarchy(Dimension availableSpace) {
        boolean result = false;
        EditorAreaComponent comp = this.getEditorAreaComponent();
        Dimension d = (Dimension)comp.getClientProperty("lastAvailableSpace");
        Dimension currDim = comp.getPreferredSize();
        if (!availableSpace.equals(d) || !availableSpace.equals(currDim)) {
            comp.setPreferredSize(availableSpace);
            comp.putClientProperty("lastAvailableSpace", availableSpace);
            result = true;
        }
        this.assureComponentInEditorArea();
        if (this.editorArea != null) {
            result |= this.editorArea.updateAWTHierarchy(new Dimension(availableSpace.width - 5, availableSpace.height - 5));
        }
        return result;
    }

    void assureComponentInEditorArea() {
        EditorAreaComponent eac = this.getEditorAreaComponent();
        if (this.editorArea == null) {
            eac.setAreaComponent(null);
        } else {
            eac.setAreaComponent(this.editorArea.getComponent());
        }
        this.manageBorder(eac);
    }

    static {
        try {
            URI_LIST_DATA_FLAVOR = new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (ClassNotFoundException cnfE) {
            cnfE.printStackTrace();
        }
    }

    private static class EditorAreaComponent
    extends JPanel
    implements TopComponentDroppable {
        private final EditorView editorView;
        private final JComponent backgroundComponent;
        private final WindowDnDManager windowDnDManager;
        private Component areaComponent;

        public EditorAreaComponent(EditorView editorView, WindowDnDManager windowDnDManager) {
            this.editorView = editorView;
            this.windowDnDManager = windowDnDManager;
            this.backgroundComponent = this.initBackgroundComponent();
            this.init();
        }

        private void init() {
            this.setLayout(new BorderLayout());
            if (this.backgroundComponent != null) {
                this.add((Component)this.backgroundComponent, "Center");
            }
            DropTarget dropTarget = new DropTarget(this, new DropTargetListener(){

                @Override
                public void dragEnter(DropTargetDragEvent dtde) {
                }

                @Override
                public void dragExit(DropTargetEvent dte) {
                }

                @Override
                public void dragOver(DropTargetDragEvent dtde) {
                    for (ExternalDropHandler handler : Lookup.getDefault().lookupAll(ExternalDropHandler.class)) {
                        if (!handler.canDrop(dtde)) continue;
                        dtde.acceptDrag(1);
                        return;
                    }
                    dtde.rejectDrag();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void drop(DropTargetDropEvent dtde) {
                    boolean dropRes = false;
                    try {
                        for (ExternalDropHandler handler : Lookup.getDefault().lookupAll(ExternalDropHandler.class)) {
                            if (!handler.canDrop(dtde)) continue;
                            dtde.acceptDrop(1);
                            dropRes = handler.handleDrop(dtde);
                            break;
                        }
                    }
                    finally {
                        dtde.dropComplete(dropRes);
                    }
                }

                @Override
                public void dropActionChanged(DropTargetDragEvent dtde) {
                }
            });
            this.setDropTarget(dropTarget);
            if (UIManager.getBoolean("NbMainWindow.showCustomBackground") || "Aqua".equals(UIManager.getLookAndFeel().getID())) {
                this.setOpaque(false);
            }
        }

        private JComponent initBackgroundComponent() {
            JComponent actionsComponent;
            Object attr;
            FileObject config;
            JLabel imageComponent = null;
            String imageSource = Constants.SWITCH_IMAGE_SOURCE;
            if (imageSource == null && (config = FileUtil.getConfigFile((String)"Windows2/Background")) != null && (attr = config.getAttribute("backgroundImage")) instanceof String) {
                imageSource = (String)attr;
            }
            if (imageSource != null) {
                Image image = ImageUtilities.loadImage((String)imageSource);
                if (image != null) {
                    JLabel label = new JLabel(ImageUtilities.image2Icon((Image)image));
                    label.setMinimumSize(new Dimension(0, 0));
                    imageComponent = label;
                } else {
                    Logger.getLogger(EditorView.class.getName()).log(Level.WARNING, null, new NullPointerException("Image not found at " + imageSource));
                }
            }
            if ((actionsComponent = this.initBackgroundActions()) != null) {
                JPanel panel = new JPanel(new GridBagLayout());
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.ipadx = 50;
                if (imageComponent != null) {
                    panel.add((Component)imageComponent, gbc);
                }
                panel.add((Component)actionsComponent, gbc);
                return panel;
            }
            return imageComponent;
        }

        private JComponent initBackgroundActions() {
            List actions = Utilities.actionsForPath((String)"Windows2/Background/Actions");
            if (actions.isEmpty()) {
                return null;
            }
            JPanel panel = new JPanel(new GridLayout(0, 1));
            for (Action action : actions) {
                if (action == null) continue;
                BackgroundActionButton button = new BackgroundActionButton(action);
                panel.add(button);
            }
            return panel;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            Color background = UIManager.getColor("Nb.EmptyEditorArea.background");
            if (background == null) {
                background = UIManager.getColor("Panel.background");
            }
            this.setBackground(background);
        }

        public void setAreaComponent(Component areaComponent) {
            if (this.areaComponent == areaComponent) {
                if (areaComponent != null && !Arrays.asList(this.getComponents()).contains(areaComponent)) {
                    if (this.backgroundComponent != null) {
                        this.remove(this.backgroundComponent);
                    }
                    this.add(areaComponent, "Center");
                }
                return;
            }
            if (this.areaComponent != null) {
                this.remove(this.areaComponent);
                if (areaComponent == null && this.backgroundComponent != null) {
                    this.add((Component)this.backgroundComponent, "Center");
                }
            }
            this.areaComponent = areaComponent;
            if (this.areaComponent != null) {
                if (this.backgroundComponent != null) {
                    this.remove(this.backgroundComponent);
                }
                this.add(this.areaComponent, "Center");
            }
            this.repaint();
        }

        @Override
        public Shape getIndicationForLocation(Point location) {
            int kind = this.windowDnDManager.getStartingTransfer().getKind();
            if (kind == 1) {
                Rectangle rect = this.getBounds();
                rect.setLocation(0, 0);
                return rect;
            }
            Rectangle rect = this.getBounds();
            rect.setLocation(0, 0);
            String side = this.getSideForLocation(location);
            double ratio = 0.25;
            if ("top".equals(side)) {
                return new Rectangle(0, 0, rect.width, (int)((double)rect.height * ratio));
            }
            if (side == "left") {
                return new Rectangle(0, 0, (int)((double)rect.width * ratio), rect.height);
            }
            if (side == "right") {
                return new Rectangle(rect.width - (int)((double)rect.width * ratio), 0, (int)((double)rect.width * ratio), rect.height);
            }
            if (side == "bottom") {
                return new Rectangle(0, rect.height - (int)((double)rect.height * ratio), rect.width, (int)((double)rect.height * ratio));
            }
            if (this.windowDnDManager.getStartingTransfer().isAllowedToMoveAnywhere()) {
                return rect;
            }
            return null;
        }

        @Override
        public Object getConstraintForLocation(Point location) {
            int kind = this.windowDnDManager.getStartingTransfer().getKind();
            if (kind == 1) {
                return null;
            }
            return this.getSideForLocation(location);
        }

        private String getSideForLocation(Point location) {
            Rectangle bounds = this.getBounds();
            bounds.setLocation(0, 0);
            int delta = 20;
            Rectangle top = new Rectangle(0, 0, bounds.width, delta);
            if (top.contains(location)) {
                return "top";
            }
            Rectangle left = new Rectangle(0, delta, delta, bounds.height - 2 * delta);
            if (left.contains(location)) {
                return "left";
            }
            Rectangle right = new Rectangle(bounds.width - delta, delta, delta, bounds.height - 2 * delta);
            if (right.contains(location)) {
                return "right";
            }
            Rectangle bottom = new Rectangle(0, bounds.height - delta, bounds.width, delta);
            if (bottom.contains(location)) {
                return "bottom";
            }
            return null;
        }

        @Override
        public Component getDropComponent() {
            return this;
        }

        @Override
        public ViewElement getDropViewElement() {
            return this.editorView;
        }

        @Override
        public boolean canDrop(TopComponentDraggable transfer, Point location) {
            if (transfer.isAllowedToMoveAnywhere()) {
                return true;
            }
            int kind = transfer.getKind();
            if (kind == 1) {
                return true;
            }
            return WindowManagerImpl.getInstance().getEditorAreaState() == 0 && this.getSideForLocation(location) != null;
        }

        @Override
        public boolean supportsKind(TopComponentDraggable transfer) {
            return true;
        }

        @Override
        public int getKind() {
            return 1;
        }
    }

    private static class BackgroundActionButton
    extends JButton {
        private final TitledBorder shortcut;

        private BackgroundActionButton(Action action) {
            this.setContentAreaFilled(false);
            this.setRolloverEnabled(true);
            this.setHorizontalAlignment(2);
            Color textColor = UIManager.getColor("EditorTab.foreground");
            if (textColor != null) {
                this.setForeground(textColor);
            }
            this.shortcut = new TitledBorder(new EmptyBorder(2, 20, 2, 40), "", 1, 4);
            Color shortcutColor = UIManager.getColor("EditorTab.underlineColor");
            if (shortcutColor != null) {
                this.shortcut.setTitleColor(shortcutColor);
            } else {
                shortcutColor = new Color(1461115);
                this.shortcut.setTitleColor(shortcutColor);
            }
            Font font = this.getFont();
            if (font != null) {
                this.shortcut.setTitleFont(font.deriveFont(0.9f * (float)font.getSize()));
            }
            this.setBorder(this.shortcut);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setAction(action);
        }

        @Override
        protected void actionPropertyChanged(Action action, String propertyName) {
            if ("Name".equals(propertyName)) {
                this.configureText(action);
            } else if ("AcceleratorKey".equals(propertyName)) {
                this.configureShortcut(action);
            }
            this.repaint();
        }

        @Override
        protected void configurePropertiesFromAction(Action a) {
            this.configureText(a);
            this.configureShortcut(a);
            this.setIcon(null);
        }

        @Override
        public void paint(Graphics g) {
            Color hoverColor;
            if (this.getModel().isRollover() && (hoverColor = UIManager.getColor("EditorTab.hoverBackground")) != null) {
                g.setColor(hoverColor);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            super.paint(g);
        }

        private void configureShortcut(Action action) {
            KeyStroke ks = (KeyStroke)action.getValue("AcceleratorKey");
            if (ks != null) {
                String shortcutText = Actions.keyStrokeToString((KeyStroke)ks);
                this.shortcut.setTitle(shortcutText);
            } else {
                String noShortcut = NbBundle.getMessage(MainWindow.class, (String)"LBL_NoShortcut");
                if (noShortcut.isEmpty()) {
                    noShortcut = " ";
                }
                this.shortcut.setTitle(noShortcut);
            }
        }

        private void configureText(Action action) {
            String raw = (String)action.getValue("Name");
            if (raw == null) {
                raw = "";
            }
            this.setText(Actions.cutAmpersand((String)raw));
        }
    }
}

