/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.server.config;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.glassfish.tooling.server.config.ServerConfigException;

public enum ModuleType {
    EAR,
    EJB,
    CAR,
    RAR,
    WAR;

    public static final int length;
    static final String EAR_STR = "ear";
    static final String EJB_STR = "ejb";
    static final String CAR_STR = "car";
    static final String RAR_STR = "rar";
    static final String WAR_STR = "war";
    private static final Map<String, ModuleType> stringValuesMap;

    public static ModuleType toValue(String stateStr) {
        if (stateStr != null) {
            return stringValuesMap.get(stateStr.toUpperCase());
        }
        return null;
    }

    public String toString() {
        switch (this.ordinal()) {
            case 0: {
                return EAR_STR;
            }
            case 1: {
                return EJB_STR;
            }
            case 2: {
                return CAR_STR;
            }
            case 3: {
                return RAR_STR;
            }
            case 4: {
                return WAR_STR;
            }
        }
        throw new ServerConfigException("Invalid GlassFish module type name");
    }

    static {
        length = ModuleType.values().length;
        stringValuesMap = new HashMap<String, ModuleType>(2 * ModuleType.values().length);
        for (ModuleType profile : ModuleType.values()) {
            stringValuesMap.put(profile.toString().toUpperCase(), profile);
        }
    }
}

