/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalSecurityConfiguration;
import org.infinispan.configuration.global.GlobalSecurityConfigurationChildBuilder;

public class GlobalSecurityConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements GlobalSecurityConfigurationChildBuilder,
Builder<GlobalSecurityConfiguration> {
    private final GlobalAuthorizationConfigurationBuilder authorizationBuilder = new GlobalAuthorizationConfigurationBuilder(this);
    private final AttributeSet attributes = GlobalSecurityConfiguration.attributeDefinitionSet();

    public GlobalSecurityConfigurationBuilder(GlobalConfigurationBuilder builder) {
        super(builder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    @Override
    public GlobalAuthorizationConfigurationBuilder authorization() {
        return this.authorizationBuilder;
    }

    @Override
    public GlobalSecurityConfigurationBuilder securityCacheSize(int securityCacheSize) {
        this.attributes.attribute(GlobalSecurityConfiguration.CACHE_SIZE).set((Object)securityCacheSize);
        return this;
    }

    @Override
    public GlobalSecurityConfigurationBuilder securityCacheTimeout(long securityCacheTimeout, TimeUnit unit) {
        this.attributes.attribute(GlobalSecurityConfiguration.CACHE_TIMEOUT).set((Object)unit.toMillis(securityCacheTimeout));
        return this;
    }

    public void validate() {
        this.authorizationBuilder.validate();
    }

    public GlobalSecurityConfiguration create() {
        return new GlobalSecurityConfiguration(this.authorizationBuilder.create(), this.attributes.protect());
    }

    public GlobalSecurityConfigurationBuilder read(GlobalSecurityConfiguration template, Combine combine) {
        this.authorizationBuilder.read(template.authorization(), combine);
        this.attributes.read(template.attributes(), combine);
        return this;
    }
}

