/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.metadata;

import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.dom.saml.v2.metadata.EndpointType;
import org.keycloak.dom.saml.v2.metadata.IDPSSODescriptorType;
import org.keycloak.dom.saml.v2.metadata.RoleDescriptorType;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLAssertinIDRequestServiceParser;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLAttributeParser;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLMetadataQNames;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLNameIDMappingServiceParser;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLSSODescriptorTypeParser;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLSingleSignOnServiceParser;

public class SAMLIDPSSODescriptorParser
extends SAMLSSODescriptorTypeParser<IDPSSODescriptorType> {
    private static final SAMLIDPSSODescriptorParser INSTANCE = new SAMLIDPSSODescriptorParser();

    private SAMLIDPSSODescriptorParser() {
        super(SAMLMetadataQNames.IDP_SSO_DESCRIPTOR);
    }

    public static SAMLIDPSSODescriptorParser getInstance() {
        return INSTANCE;
    }

    @Override
    protected IDPSSODescriptorType instantiateElement(XMLEventReader xmlEventReader, StartElement element) throws ParsingException {
        List<String> protocolEnum = StaxParserUtil.getRequiredStringListAttributeValue(element, SAMLMetadataQNames.ATTR_PROTOCOL_SUPPORT_ENUMERATION);
        IDPSSODescriptorType descriptor = new IDPSSODescriptorType(protocolEnum);
        this.parseOptionalArguments(element, (RoleDescriptorType)descriptor);
        Boolean wantAuthnRequestsSigned = StaxParserUtil.getBooleanAttributeValue(element, SAMLMetadataQNames.ATTR_WANT_AUTHN_REQUESTS_SIGNED);
        if (wantAuthnRequestsSigned != null) {
            descriptor.setWantAuthnRequestsSigned(wantAuthnRequestsSigned);
        }
        return descriptor;
    }

    @Override
    protected void processSubElement(XMLEventReader xmlEventReader, IDPSSODescriptorType target, SAMLMetadataQNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case SINGLE_SIGNON_SERVICE: {
                target.addSingleSignOnService((EndpointType)SAMLSingleSignOnServiceParser.getInstance().parse(xmlEventReader));
                break;
            }
            case NAMEID_MAPPING_SERVICE: {
                target.addNameIDMappingService((EndpointType)SAMLNameIDMappingServiceParser.getInstance().parse(xmlEventReader));
                break;
            }
            case ASSERTION_ID_REQUEST_SERVICE: {
                target.addAssertionIDRequestService((EndpointType)SAMLAssertinIDRequestServiceParser.getInstance().parse(xmlEventReader));
                break;
            }
            case ATTRIBUTE_PROFILE: {
                StaxParserUtil.advance(xmlEventReader);
                target.addAttributeProfile(StaxParserUtil.getElementText(xmlEventReader));
                break;
            }
            case ATTRIBUTE: {
                target.addAttribute((AttributeType)SAMLAttributeParser.getInstance().parse(xmlEventReader));
                break;
            }
            default: {
                super.processSubElement(xmlEventReader, target, element, elementDetail);
            }
        }
    }
}

