/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.spiffe;

import java.nio.charset.StandardCharsets;
import org.jboss.logging.Logger;
import org.keycloak.authentication.ClientAuthenticationFlowContext;
import org.keycloak.authentication.authenticators.client.AbstractJWTClientValidator;
import org.keycloak.authentication.authenticators.client.FederatedJWTClientValidator;
import org.keycloak.broker.provider.ClientAssertionIdentityProvider;
import org.keycloak.broker.spiffe.SpiffeBundleEndpointLoader;
import org.keycloak.broker.spiffe.SpiffeIdentityProviderConfig;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.keys.PublicKeyLoader;
import org.keycloak.keys.PublicKeyStorageProvider;
import org.keycloak.keys.PublicKeyStorageUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.JsonWebToken;

public class SpiffeIdentityProvider
implements ClientAssertionIdentityProvider<SpiffeIdentityProviderConfig> {
    private static final Logger LOGGER = Logger.getLogger(SpiffeIdentityProvider.class);
    private final KeycloakSession session;
    private final SpiffeIdentityProviderConfig config;

    public SpiffeIdentityProvider(KeycloakSession session, SpiffeIdentityProviderConfig config) {
        this.session = session;
        this.config = config;
    }

    public SpiffeIdentityProviderConfig getConfig() {
        return this.config;
    }

    public boolean verifyClientAssertion(ClientAuthenticationFlowContext context) throws Exception {
        FederatedJWTClientValidator validator = new FederatedJWTClientValidator(context, this::verifySignature, null, this.config.getAllowedClockSkew(), true);
        validator.setExpectedClientAssertionType("urn:ietf:params:oauth:client-assertion-type:jwt-spiffe");
        String trustedDomain = this.config.getTrustDomain();
        JsonWebToken token = validator.getState().getToken();
        if (!token.getSubject().startsWith(trustedDomain + "/")) {
            throw new RuntimeException("Invalid trust-domain");
        }
        return validator.validate();
    }

    private boolean verifySignature(AbstractJWTClientValidator validator) {
        try {
            String bundleEndpoint = this.config.getBundleEndpoint();
            JWSInput jws = validator.getState().getJws();
            JWSHeader header = jws.getHeader();
            String kid = header.getKeyId();
            String alg = header.getRawAlgorithm();
            String modelKey = PublicKeyStorageUtils.getIdpModelCacheKey((String)validator.getContext().getRealm().getId(), (String)this.config.getInternalId());
            PublicKeyStorageProvider keyStorage = (PublicKeyStorageProvider)this.session.getProvider(PublicKeyStorageProvider.class);
            KeyWrapper publicKey = keyStorage.getPublicKey(modelKey, kid, alg, (PublicKeyLoader)new SpiffeBundleEndpointLoader(this.session, bundleEndpoint));
            SignatureProvider signatureProvider = (SignatureProvider)this.session.getProvider(SignatureProvider.class, alg);
            if (signatureProvider == null) {
                LOGGER.debugf("Failed to verify token, signature provider not found for algorithm %s", (Object)alg);
                return false;
            }
            return signatureProvider.verifier(publicKey).verify(jws.getEncodedSignatureInput().getBytes(StandardCharsets.UTF_8), jws.getSignature());
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Failed to verify token signature", (Throwable)e);
            return false;
        }
    }

    public void close() {
    }
}

