/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jsampler.CC;
import org.jsampler.view.fantasia.A4n;
import org.jsampler.view.fantasia.ChannelView;

public class MenuManager
implements ListSelectionListener {
    private static MenuManager menuManager = null;
    private final Vector<ChannelViewGroup> channelViewGroups = new Vector();

    private MenuManager() {
        CC.getMainFrame().addChannelsPaneSelectionListener(this);
        for (int i = 0; i < CC.getMainFrame().getChannelsPaneCount(); ++i) {
            CC.getMainFrame().getChannelsPane(i).addListSelectionListener(this);
        }
    }

    public static MenuManager getMenuManager() {
        if (menuManager == null) {
            menuManager = new MenuManager();
        }
        return menuManager;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.updateChannelViewGroups();
    }

    public void updateChannelViewGroups() {
        boolean bl = false;
        boolean bl2 = false;
        int n = A4n.SetView.getViewCount(ChannelView.Type.SMALL);
        int n2 = A4n.SetView.getViewCount(ChannelView.Type.NORMAL);
        if (!(n != 0 && n2 != 0 || n == 0 && n2 == 0)) {
            if (n != 0) {
                bl = true;
            } else {
                bl2 = true;
            }
        }
        boolean bl3 = n != 0 || n2 != 0;
        for (ChannelViewGroup channelViewGroup : this.channelViewGroups) {
            channelViewGroup.rbmiSmallView.setSelected(bl);
            channelViewGroup.rbmiNormalView.setSelected(bl2);
            if (!bl && !bl2) {
                channelViewGroup.clearSelection();
            }
            channelViewGroup.setEnabled(bl3);
        }
    }

    public void registerChannelViewGroup(ChannelViewGroup channelViewGroup) {
        this.channelViewGroups.add(channelViewGroup);
        if (this.channelViewGroups.size() < 2) {
            this.updateChannelViewGroups();
        } else {
            boolean bl = this.channelViewGroups.get(0).rbmiSmallView.isSelected();
            boolean bl2 = this.channelViewGroups.get(0).rbmiNormalView.isSelected();
            channelViewGroup.rbmiSmallView.setSelected(bl);
            channelViewGroup.rbmiNormalView.setSelected(bl2);
        }
    }

    public void unregisterChannelViewGroup(ChannelViewGroup channelViewGroup) {
        this.channelViewGroups.remove(channelViewGroup);
    }

    public static class ChannelViewGroup
    extends ButtonGroup {
        private JRadioButtonMenuItem rbmiSmallView;
        private JRadioButtonMenuItem rbmiNormalView;
        private boolean alwaysEnabled;

        public ChannelViewGroup() {
            this(false, false);
        }

        public ChannelViewGroup(boolean bl, boolean bl2) {
            this.alwaysEnabled = bl;
            this.rbmiSmallView = new JRadioButtonMenuItem(A4n.a4n.setSmallView);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(83, 8);
            if (!bl2) {
                this.rbmiSmallView.setAccelerator(keyStroke);
            }
            this.rbmiNormalView = new JRadioButtonMenuItem(A4n.a4n.setNormalView);
            keyStroke = KeyStroke.getKeyStroke(78, 8);
            if (!bl2) {
                this.rbmiNormalView.setAccelerator(keyStroke);
            }
            this.add(this.rbmiSmallView);
            this.add(this.rbmiNormalView);
        }

        public JRadioButtonMenuItem[] getMenuItems() {
            JRadioButtonMenuItem[] jRadioButtonMenuItemArray = new JRadioButtonMenuItem[]{this.rbmiSmallView, this.rbmiNormalView};
            return jRadioButtonMenuItemArray;
        }

        public void setEnabled(boolean bl) {
            if (this.alwaysEnabled) {
                return;
            }
            this.rbmiSmallView.setEnabled(bl);
            this.rbmiNormalView.setEnabled(bl);
        }
    }
}

