---
stage: AI-powered
group: Workflow Catalog
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: エージェント
---

{{< details >}}

- プラン: Premium、Ultimate
- アドオン: GitLab Duo Core、Pro、またはEnterprise。
- 提供形態: GitLab.com
- ステータス: 実験的機能

{{< /details >}}

{{< collapsible title="モデル情報" >}}

- LLM: Anthropic [Claude Sonnet 4](https://www.anthropic.com/claude/sonnet)

{{< /collapsible >}}

{{< history >}}

- GitLab 18.5で`global_ai_catalog`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/549914)されました。GitLab.comで有効になりました。これは[実験的機能](../../../policy/development_stages_support.md)です。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。

{{< /alert >}}

エージェントはAIを使用してタスクを実行し、複雑な質問に答えます。カスタムエージェントを作成して、マージリクエストの作成やレビューコードなど、特定のタスクを実行します。または、AIカタログを使用して、GitLabで作成されたエージェントを見つけます。

エージェントとのインタラクションの準備ができたら、エージェントを有効にするか、テスト実行を実行できます。

## 前提要件 {#prerequisites}

エージェントを使用するには、[前提要件](../_index.md#prerequisites)を満たす必要があります。

エージェントの表示レベルに応じて、追加の要件があります。

### エージェントの表示レベル {#agent-visibility}

エージェントを作成する際、エージェントをソースプロジェクトに関連付け、公開またはプライベートにするかを選択します。

- 公開エージェントは誰でも表示でき、前提条件を満たす任意のプロジェクトで有効にできます。
- プライベートエージェントは、少なくともデベロッパーロールを持つソースプロジェクトのメンバーのみが表示できます。プライベートエージェントは、ソースプロジェクト以外のプロジェクトでは有効にできません。エージェントが現在有効になっている場合、プライベートエージェントを公開にすることはできません。

## エージェントの作成 {#create-an-agent}

前提要件: 

- プロジェクトのメンテナー以上のロールを持っている必要があります。

エージェントを作成するには:

1. 左側のサイドバーで、**検索または移動先** > **検索**を選択します。
1. **AIカタログ**を選択します。
1. **新規エージェント**を選択します。
1. **基本情報**で:
   1. **表示名**に、エージェントの名前を入力します。
   1. **説明**に、エージェントの説明を入力します。
1. **Visibility & access**（表示レベルとアクセス）で:
   1. **表示レベル**で、**プライベート**または**公開**を選択します。
   1. **ソースプロジェクト**のドロップダウンリストから、エージェントのプロジェクトを選択します。
1. **プロンプト**の**システムプロンプト**に、エージェントの個性、専門知識、および動作を定義するプロンプトを入力します。
1. オプション。オプション。**利用可能なツール**の**ツール**のドロップダウンリストから、エージェントがアクセスできるツールを選択します。たとえば、エージェントが自動的にイシューを作成するようにするには、**イシューの作成**を選択します。
1. **エージェントの作成**を選択します。

エージェントはソースプロジェクトで有効になり、AIカタログに表示されます。

## エージェントの有効化 {#enable-an-agent}

チャットでエージェントを使用するには、プロジェクトでエージェントを有効にします。デフォルトでは、エージェントはソースプロジェクトで有効になっています。

前提要件: 

- プロジェクトのメンテナー以上のロールを持っている必要があります。

1. 左側のサイドバーで、**検索または移動先** > **検索**を選択します。
1. **AIカタログ**を選択し、有効にするエージェントを見つけます。
1. エージェント名の横にある**アクション**（{{< icon name="ellipsis_v" >}}）> **Enable in project**（プロジェクトで有効）を選択します。
1. **プロジェクト**ドロップダウンリストから、プロジェクトを選択します。
1. **有効**を選択します。

エージェントがプロジェクトの**エージェント**ページに表示されます。

## エージェントの実行 {#run-an-agent}

テスト実行を実行して、エージェントとのセッションを開始します。

前提要件: 

- あなたはソースプロジェクトのメンバーであり、少なくともメンテナーロールを持っている必要があります。

エージェントを実行するには:

1. 左側のサイドバーで、**検索または移動先** > **検索**を選択します。
1. **AIカタログ**を選択します。
1. エージェントを選択し、**テスト**を選択します。
1. ダイアログで、指示を入力し、**実行**を選択します。

進捗状況を監視するには、**自動化** > **セッション**を選択します。

## エージェントの複製 {#duplicate-an-agent}

別のソースプロジェクトに既存のエージェントのコピーを作成します。他の誰かが作成したエージェントを使用する場合、または元のエージェントを上書きすることなくエージェントを変更する場合は、これを行います。

前提要件: 

- プロジェクトのメンテナー以上のロールを持っている必要があります。

エージェントを複製するには:

1. 左側のサイドバーで、**検索または移動先** > **検索**を選択します。
1. **AIカタログ**を選択し、複製するエージェントを見つけます。
1. エージェント名の横にある**アクション**（{{< icon name="ellipsis_v" >}}）> **複製**を選択します。
1. オプション。変更するフィールドを編集します。
1. **エージェントの作成**を選択します。

## エージェントの管理 {#manage-agents}

エージェントを編集して設定を変更するか、AIカタログから削除します。

前提要件: 

- あなたはソースプロジェクトのメンバーであり、少なくともメンテナーロールを持っている必要があります。

1. 左側のサイドバーで、**検索または移動先** > **検索**を選択します。
1. **AIカタログ**を選択し、管理するエージェントを見つけます。
1. エージェント名の横にある**アクション**（{{< icon name="ellipsis_v" >}}）を選択します。
   - エージェントを編集するには:
     1. **編集**を選択します。
     1. 変更したいフィールドを編集し、**変更を保存**を選択します。
   - エージェントを削除するには:
     1. **削除**を選択します。
     1. 確認ダイアログで、**削除**を選択します。
