---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: '機密シークレットまたはトークンClojarsデプロイトークンの公開'
---

## 説明 {#description}

応答本文に、Clojarsデプロイトークンのパターンに一致するコンテンツが検出されました。デプロイトークンは、デプロイ時にパスワードの代わりに使用され、サインインには使用できません。トークンのスコープは、以下のように設定できます:

- アクセスできるすべてのアーティファクト（「\*」）
- アクセスできるグループ内のすべてのアーティファクト（「group-name/\*」）
- アクセスできる特定のアーティファクト（「group-name/artifact-name」）このトークンにアクセスできる悪意のある攻撃者は、このアカウントを使用して悪意のあるClojure JARをデプロイできます。この値を公開すると、攻撃者がこのトークンによって許可されたすべてのリソースにアクセスできるようになる可能性があります。

## 修正 {#remediation}

セキュリティインシデント発生時の一般的なガイダンスについては、[インターネットへの認証情報の公開](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet)に関するGitLabドキュメントを参照してください。

デプロイトークンを取り消すには:

1. ログイン後、<https://clojars.org/tokens>にアクセスしてください。
1. [既存のデプロイトークン]で、検出されたトークンを見つけます
1. [トークンを無効化]を選択します。

   {{< alert type="note" >}}

   トークンを無効にすると、再度有効にすることはできません。

   {{< /alert >}}

新しいデプロイトークンを作成するには:

1. ログイン後、<https://clojars.org/tokens>にアクセスしてください。
1. トークン名1を入力します。適切なトークンのスコープを選択します
1. トークンが単回使用の場合は、[単回使用？]チェックボックスをオンにし、それ以外の場合は空白のままにします
1. 有効期限日を設定します（90日を推奨）。
1. [トークンの作成]を選択します。トークンの詳細については、[ClojarsのWebサイト](https://github.com/clojars/clojars-web/wiki/Deploy-Tokens)を参照してください。

## 詳細 {#details}

| ID | 集約 | CWE | 型 | リスク |
|:---|:-----------|:----|:-----|:-----|
| 798.20 | いいえ | 798 | パッシブ | 高 |

## リンク {#links}

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
