/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClassDescriptor;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.core.importer.resolvers.ClassResolver;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableCollection;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableMap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSortedMap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

class ImportedClasses {
    private static final ImmutableSet<JavaModifier> PRIMITIVE_TYPE_MODIFIERS = Sets.immutableEnumSet((Enum)JavaModifier.PUBLIC, (Enum[])new JavaModifier[]{JavaModifier.ABSTRACT, JavaModifier.FINAL});
    private static final ImmutableSet<JavaModifier> VISIBILITY_MODIFIERS = Sets.immutableEnumSet((Enum)JavaModifier.PUBLIC, (Enum[])new JavaModifier[]{JavaModifier.PROTECTED, JavaModifier.PRIVATE});
    private final ImmutableMap<String, JavaClass> directlyImported;
    private final Map<String, JavaClass> allClasses = new HashMap<String, JavaClass>();
    private final ClassResolver resolver;
    private final MethodReturnTypeGetter getMethodReturnType;

    ImportedClasses(Map<String, JavaClass> directlyImported, ClassResolver resolver, MethodReturnTypeGetter methodReturnTypeGetter) {
        this.directlyImported = ImmutableMap.copyOf(directlyImported);
        this.allClasses.putAll(directlyImported);
        this.resolver = resolver;
        this.getMethodReturnType = methodReturnTypeGetter;
    }

    Map<String, JavaClass> getDirectlyImported() {
        return this.directlyImported;
    }

    JavaClass getOrResolve(String typeName) {
        JavaClass javaClass = this.allClasses.get(typeName);
        return javaClass != null ? javaClass : this.resolve(typeName);
    }

    ImportedClassState ensurePresent(String typeName) {
        if (this.allClasses.containsKey(typeName)) {
            return ImportedClassState.WAS_ALREADY_PRESENT;
        }
        this.resolve(typeName);
        return ImportedClassState.HAD_TO_BE_IMPORTED;
    }

    private JavaClass resolve(String typeName) {
        JavaClass javaClass;
        Optional<JavaClass> resolved = this.resolver.tryResolve(typeName);
        JavaClass javaClass2 = javaClass = resolved.isPresent() ? resolved.get() : this.stubClassOf(typeName);
        if (javaClass.isArray()) {
            this.ensureAllComponentTypesPresent(javaClass);
        }
        this.allClasses.put(typeName, javaClass);
        return javaClass;
    }

    private void ensureAllComponentTypesPresent(JavaClass javaClass) {
        JavaClassDescriptor current = JavaClassDescriptor.From.javaClass(javaClass);
        while (current.tryGetComponentType().isPresent()) {
            current = current.tryGetComponentType().get();
            this.ensurePresent(current.getFullyQualifiedClassName());
        }
    }

    Collection<JavaClass> getAllWithOuterClassesSortedBeforeInnerClasses() {
        return ImmutableSortedMap.copyOf(this.allClasses).values();
    }

    private JavaClass stubClassOf(String typeName) {
        JavaClassDescriptor descriptor = JavaClassDescriptor.From.name(typeName);
        DomainBuilders.JavaClassBuilder builder = DomainBuilders.JavaClassBuilder.forStub().withDescriptor(descriptor);
        this.addModifiersIfPossible(builder, descriptor);
        return builder.build();
    }

    private void addModifiersIfPossible(DomainBuilders.JavaClassBuilder builder, JavaClassDescriptor descriptor) {
        if (descriptor.isPrimitive()) {
            builder.withModifiers(PRIMITIVE_TYPE_MODIFIERS);
        } else if (descriptor.isArray()) {
            JavaClass elementType = this.getOrResolve(this.getElementType(descriptor).getFullyQualifiedClassName());
            ImmutableCollection modifiers = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.getVisibility(elementType))).add((Object[])new JavaModifier[]{JavaModifier.ABSTRACT, JavaModifier.FINAL})).build();
            builder.withModifiers((Set<JavaModifier>)((Object)modifiers));
        }
    }

    private JavaClassDescriptor getElementType(JavaClassDescriptor descriptor) {
        return descriptor.tryGetComponentType().map(this::getElementType).orElse(descriptor);
    }

    private Set<JavaModifier> getVisibility(JavaClass javaClass) {
        return Sets.intersection(VISIBILITY_MODIFIERS, javaClass.getModifiers());
    }

    public Optional<JavaClass> getMethodReturnType(String declaringClassName, String methodName) {
        return this.getMethodReturnType.getReturnType(declaringClassName, methodName);
    }

    static interface MethodReturnTypeGetter {
        public Optional<JavaClass> getReturnType(String var1, String var2);
    }

    static enum ImportedClassState {
        HAD_TO_BE_IMPORTED,
        WAS_ALREADY_PRESENT;

    }
}

