/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oceanbase.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLProcedure;
import org.jkiss.dbeaver.ext.mysql.model.MySQLProcedureParameter;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableColumn;
import org.jkiss.dbeaver.ext.mysql.model.MySQLView;
import org.jkiss.dbeaver.ext.oceanbase.model.OceanbaseMySQLViewColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.CommonUtils;

public class OceanbaseMySQLCatalog
extends MySQLCatalog {
    private static final Log log = Log.getLog(OceanbaseMySQLCatalog.class);
    private final MySQLDataSource dataSource;
    private final OceanbaseProceduresCache oceanbaseProceduresCache = new OceanbaseProceduresCache();
    private final OceanbaseTableCache oceanbaseTableCache = new OceanbaseTableCache();
    private List<String> proceduresNames = new ArrayList<String>();

    public OceanbaseMySQLCatalog(MySQLDataSource dataSource, ResultSet dbResult) {
        super(dataSource, dbResult);
        this.dataSource = dataSource;
        this.oceanbaseTableCache.setCaseSensitive(false);
    }

    public OceanbaseProceduresCache getProceduresCache() {
        return this.oceanbaseProceduresCache;
    }

    public OceanbaseTableCache getTableCache() {
        return this.oceanbaseTableCache;
    }

    @NotNull
    public MySQLDataSource getDataSource() {
        return this.dataSource;
    }

    public synchronized DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.proceduresNames.clear();
        return super.refreshObject(monitor);
    }

    public synchronized void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        super.cacheStructure(monitor, scope & 0xFFFFFFFD);
    }

    class OceanbaseProceduresCache
    extends MySQLCatalog.ProceduresCache {
        OceanbaseProceduresCache() {
            super((MySQLCatalog)OceanbaseMySQLCatalog.this);
        }

        protected MySQLProcedure fetchObject(@NotNull JDBCSession session, @NotNull MySQLCatalog owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            String routineName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ROUTINE_NAME");
            if (CommonUtils.isEmpty((String)routineName)) {
                log.debug((Object)"Can't read routine name.");
                return null;
            }
            if (OceanbaseMySQLCatalog.this.proceduresNames.contains(routineName)) {
                log.debug((Object)("Skipped duplicate routine name " + routineName));
                return null;
            }
            OceanbaseMySQLCatalog.this.proceduresNames.add(routineName);
            return super.fetchObject(session, owner, dbResult);
        }

        protected JDBCStatement prepareChildrenStatement(@NotNull JDBCSession session, @NotNull MySQLCatalog owner, @Nullable MySQLProcedure procedure) throws SQLException {
            if (procedure != null && procedure.getProcedureType().equals((Object)DBSProcedureType.PROCEDURE)) {
                return session.getMetaData().getProcedureColumns(owner.getName(), null, JDBCUtils.escapeWildCards((JDBCSession)session, (String)procedure.getName()), "%").getSourceStatement();
            }
            String queryFunctionString = "select * from mysql.proc where db=? and type='FUNCTION'" + (procedure != null ? " and name=?" : "");
            JDBCPreparedStatement statement = session.prepareStatement(queryFunctionString);
            statement.setString(1, owner.getName());
            if (procedure != null) {
                statement.setString(2, procedure.getName());
            }
            return statement;
        }

        protected MySQLProcedureParameter fetchChild(@NotNull JDBCSession session, @NotNull MySQLCatalog owner, @NotNull MySQLProcedure parent, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            if (parent.getProcedureType().equals((Object)DBSProcedureType.PROCEDURE)) {
                return super.fetchChild(session, owner, parent, dbResult);
            }
            String returnString = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"returns");
            if (returnString == null) {
                return null;
            }
            String paramListString = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"param_list");
            DBSObjectCache paramCache = owner.getProceduresCache().getChildrenCache((DBSObject)parent);
            if (CommonUtils.isNotEmpty((String)paramListString)) {
                String[] strings = paramListString.split(",");
                ArrayList<MySQLProcedureParameter> funcParams = new ArrayList<MySQLProcedureParameter>();
                for (int i = 0; i < strings.length; ++i) {
                    DBSDataType type;
                    String[] argPart = strings[i].trim().split(" ");
                    if (argPart.length <= 1) continue;
                    String argName = argPart[0];
                    String dataType = argPart[1];
                    Integer typeSize = null;
                    if (CommonUtils.isNotEmpty((String)dataType) && dataType.contains("(") && dataType.contains(")")) {
                        String typeName = dataType.substring(0, dataType.indexOf("("));
                        String typeLength = dataType.substring(dataType.indexOf("(") + 1, dataType.indexOf(")"));
                        typeSize = CommonUtils.toInt((Object)typeLength, (int)-1);
                        type = OceanbaseMySQLCatalog.this.getDataSource().getLocalDataType(typeName);
                    } else {
                        type = OceanbaseMySQLCatalog.this.getDataSource().getLocalDataType(dataType);
                    }
                    funcParams.add(new MySQLProcedureParameter(parent, DBSProcedureParameterKind.IN.getTitle(), DBUtils.getUnQuotedIdentifier((DBPDataSource)OceanbaseMySQLCatalog.this.getDataSource(), (String)argName), type == null ? 4 : type.getTypeID(), i, typeSize != null ? (long)typeSize.intValue() : 42L, null, null, true, DBSProcedureParameterKind.IN));
                }
                for (MySQLProcedureParameter param : funcParams) {
                    paramCache.cacheObject((DBSObject)param);
                }
            }
            String[] returnParamsList = returnString.split("\\(");
            int columnSize = Integer.parseInt(returnParamsList[1].split("\\)")[0]);
            MySQLProcedureParameter parameter = new MySQLProcedureParameter(parent, "RETURN", returnParamsList[0], 2, 0, (long)columnSize, null, null, true, DBSProcedureParameterKind.RETURN);
            paramCache.cacheObject((DBSObject)parameter);
            return parameter;
        }
    }

    static class OceanbaseTableCache
    extends MySQLCatalog.TableCache {
        OceanbaseTableCache() {
        }

        protected JDBCStatement prepareChildrenStatement(@NotNull JDBCSession session, @NotNull MySQLCatalog owner, @Nullable MySQLTableBase forTable) throws SQLException {
            if (forTable instanceof MySQLView) {
                return session.prepareStatement("desc " + owner.getName() + "." + forTable.getName());
            }
            return super.prepareChildrenStatement(session, owner, forTable);
        }

        protected MySQLTableColumn fetchChild(@NotNull JDBCSession session, @NotNull MySQLCatalog owner, @NotNull MySQLTableBase table, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            if (table instanceof MySQLView) {
                return new OceanbaseMySQLViewColumn(table, (ResultSet)dbResult);
            }
            return super.fetchChild(session, owner, table, dbResult);
        }
    }
}

