/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.exporter;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.StreamExporterAbstract;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;

public class DataExporterXML
extends StreamExporterAbstract {
    private static final String PROP_INCLUDE_DOCTYPE_DECLARATION = "includeDoctype";
    private DBDAttributeBinding[] columns;
    private String tableName;
    private boolean includeDoctype;

    @Override
    public void init(IStreamDataExporterSite site) throws DBException {
        super.init(site);
        this.includeDoctype = CommonUtils.getBoolean((Object)site.getProperties().get(PROP_INCLUDE_DOCTYPE_DECLARATION), (boolean)false);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void exportHeader(DBCSession session) throws DBException, IOException {
        this.columns = this.getSite().getAttributes();
        this.printHeader();
    }

    private void printHeader() {
        PrintWriter out = this.getWriter();
        out.write("<?xml version=\"1.0\" encoding=\"" + this.getSite().getOutputEncoding() + "\"?>\n");
        this.tableName = this.escapeXmlElementName(this.getSite().getSource().getName());
        if (this.includeDoctype) {
            int i;
            out.write("<!DOCTYPE " + this.tableName + " [\n");
            out.write("  <!ELEMENT " + this.tableName + " (DATA_RECORD*)>\n");
            out.write("  <!ELEMENT DATA_RECORD (");
            int columnsSize = this.columns.length;
            for (i = 0; i < columnsSize; ++i) {
                String colName = this.columns[i].getLabel();
                if (CommonUtils.isEmpty((String)colName)) {
                    colName = this.columns[i].getName();
                }
                out.write(this.escapeXmlElementName(colName) + "?");
                if (i >= columnsSize - 1) continue;
                out.write(",");
            }
            out.write(")+>\n");
            for (i = 0; i < columnsSize; ++i) {
                out.write("  <!ELEMENT " + this.escapeXmlElementName(this.columns[i].getName()) + " (#PCDATA)>\n");
            }
            out.write("]>\n");
        }
        out.write("<" + this.tableName + ">\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void exportRow(DBCSession session, DBCResultSet resultSet, Object[] row) throws DBException, IOException {
        out = this.getWriter();
        out.write("  <DATA_RECORD>\n");
        for (i = 0; i < row.length; ++i) {
            column = this.columns[i];
            columnName = this.escapeXmlElementName(column.getName());
            out.write("    <" + columnName + ">");
            if (DBUtils.isNullValue((Object)row[i])) {
                this.writeTextCell(null);
            } else if (row[i] instanceof DBDContent) {
                content = (DBDContent)row[i];
                try {
                    cs = content.getContents(session.getProgressMonitor());
                    if (cs == null) ** GOTO lbl30
                    if (ContentUtils.isTextContent((DBDContent)content)) {
                        reader = cs.getContentReader();
                        try {
                            this.writeCellValue(reader);
                        }
                        finally {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                    }
                    this.getSite().writeBinaryData(cs);
                }
                finally {
                    DTUtils.closeContents(resultSet, content);
                }
            } else {
                this.writeTextCell(super.getValueDisplayString(column, row[i]));
            }
lbl30:
            // 5 sources

            out.write("</" + columnName + ">\n");
        }
        out.write("  </DATA_RECORD>\n");
    }

    @Override
    public void exportFooter(DBRProgressMonitor monitor) {
        this.getWriter().write("</" + this.tableName + ">\n");
    }

    private void writeTextCell(@Nullable String value) {
        if (value != null) {
            value = value.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
            this.getWriter().write(value);
        }
    }

    private void writeCellValue(Reader reader) throws IOException {
        int count;
        char[] buffer = new char[2000];
        while ((count = reader.read(buffer)) > 0) {
            for (int i = 0; i < count; ++i) {
                if (buffer[i] == '<') {
                    this.getWriter().write("&lt;");
                    continue;
                }
                if (buffer[i] == '>') {
                    this.getWriter().write("&gt;");
                    continue;
                }
                if (buffer[i] == '&') {
                    this.getWriter().write("&amp;");
                    continue;
                }
                this.getWriter().write(buffer[i]);
            }
        }
    }

    private String escapeXmlElementName(String name) {
        return name.replaceAll("[^\\p{Alpha}\\p{Digit}]+", "_");
    }
}

