/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.exec;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCCallableStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCObjectSupplier;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCPreparedStatementImpl;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCResultSetCallable;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.utils.CommonUtils;

public class JDBCCallableStatementImpl
extends JDBCPreparedStatementImpl<CallableStatement>
implements JDBCCallableStatement {
    private static final Log log = Log.getLog(JDBCCallableStatementImpl.class);
    private static final Pattern EXEC_PATTERN = Pattern.compile("[\\w_\\.]+\\s+([^(]+)\\s*\\(");
    private DBSProcedure procedure;
    private final JDBCResultSetCallable procResults = new JDBCResultSetCallable(this.getConnection(), this);

    public JDBCCallableStatementImpl(@NotNull JDBCSession connection, @NotNull JDBCObjectSupplier<CallableStatement> stmtSupplier, @Nullable String query, boolean disableLogging) throws SQLException {
        super(connection, stmtSupplier, query, disableLogging);
        ParameterMetaData paramsMeta;
        try {
            this.procedure = JDBCCallableStatementImpl.findProcedure(connection, query);
        }
        catch (Throwable e) {
            log.debug((Object)e);
        }
        try {
            paramsMeta = ((CallableStatement)this.getOriginal()).getParameterMetaData();
            if (paramsMeta != null) {
                int paramsCount = this.bindProcedureFromJDBC(paramsMeta);
                if (this.procedure != null && paramsCount == 0 && this.hasOutputParameters()) {
                    try {
                        this.bindProcedureFromMeta();
                    }
                    catch (Throwable e) {
                        log.debug((Object)"Error binding procedure output parameters", e);
                    }
                }
            }
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage());
            try {
                if (this.procedure != null) {
                    this.bindProcedureFromMeta();
                }
            }
            catch (Throwable e1) {
                log.debug((Object)"Error binding procedure output parameters", e1);
            }
        }
        paramsMeta = null;
        try {
            paramsMeta = ((CallableStatement)this.getOriginal()).getParameterMetaData();
        }
        catch (Throwable e) {
            log.debug((Object)"Error extracting parameters meta data", e);
        }
        List<DBSProcedureParameter> metaOutputParameters = this.getOutputParametersFromMeta();
        List<Integer> jdbcOutputParameters = this.getOutputParametersFromJDBC(paramsMeta);
        if (metaOutputParameters == null && jdbcOutputParameters == null) {
            log.debug((Object)"Can't obtain procedure metadata nor jdbc metadata");
            return;
        }
        JDBCDataSource dataSource = connection.getDataSource();
        if (metaOutputParameters != null && jdbcOutputParameters != null && metaOutputParameters.size() == jdbcOutputParameters.size()) {
            int localIndex = 0;
            for (int index = 0; index < metaOutputParameters.size(); ++index) {
                DBSProcedureParameter param = metaOutputParameters.get(index);
                if (JDBCCallableStatementImpl.isParameterCursor((DBPDataSource)dataSource, paramsMeta, jdbcOutputParameters.get(index))) continue;
                this.procResults.addColumn(param.getName(), param.getParameterType(), localIndex++, (int)jdbcOutputParameters.get(index));
            }
        } else if (metaOutputParameters != null) {
            for (int index = 0; index < metaOutputParameters.size(); ++index) {
                DBSProcedureParameter param = metaOutputParameters.get(index);
                this.procResults.addColumn(param.getName(), param.getParameterType(), index, index + 1);
            }
        } else {
            try {
                int localIndex = 0;
                for (int index : jdbcOutputParameters) {
                    if (JDBCCallableStatementImpl.isParameterCursor((DBPDataSource)dataSource, paramsMeta, index)) continue;
                    DBSDataType dataType = dataSource.getLocalDataType(paramsMeta.getParameterTypeName(index));
                    if (dataType == null) {
                        DBPDataKind dataKind = JDBCUtils.resolveDataKind((DBPDataSource)dataSource, paramsMeta.getParameterTypeName(index), paramsMeta.getParameterType(index));
                        this.procResults.addColumn(String.valueOf(index), dataKind, localIndex++, index);
                        continue;
                    }
                    this.procResults.addColumn(String.valueOf(index), (DBSTypedObject)dataType, localIndex++, index);
                }
            }
            catch (Throwable e) {
                log.debug((Object)"Error extracting parameters meta data", e);
            }
        }
        this.procResults.addRow(new Object[0]);
    }

    private static DBSProcedure findProcedure(DBCSession session, String queryString) throws DBException {
        Matcher matcher;
        DBPDataSource dataSource = session.getDataSource();
        if (!CommonUtils.isEmpty((String)queryString) && (matcher = EXEC_PATTERN.matcher(queryString)).find()) {
            char divChar;
            String procName = matcher.group(1);
            if (procName.indexOf(divChar = dataSource.getSQLDialect().getStructSeparator()) != -1) {
                return JDBCCallableStatementImpl.findProcedureByNames(session, procName.split("\\" + divChar));
            }
            return JDBCCallableStatementImpl.findProcedureByNames(session, procName);
        }
        return null;
    }

    private static DBSProcedure findProcedureByNames(@NotNull DBCSession session, String ... names) throws DBException {
        if (!(session.getDataSource() instanceof DBSObjectContainer)) {
            return null;
        }
        DBSObjectContainer container = (DBSObjectContainer)session.getDataSource();
        if (names.length == 1) {
            DBSObject[] selectedObjects = DBUtils.getSelectedObjects((DBCExecutionContext)session.getExecutionContext());
            if (selectedObjects.length > 0 && selectedObjects[selectedObjects.length - 1] instanceof DBSObjectContainer) {
                container = (DBSObjectContainer)selectedObjects[selectedObjects.length - 1];
            }
        } else {
            container = (DBSObjectContainer)session.getDataSource();
            for (int i = 0; i < names.length - 1; ++i) {
                String childName = CommonUtils.trim((String)names[i]);
                if (CommonUtils.isEmpty((String)childName)) {
                    return null;
                }
                DBSObject child = container.getChild(session.getProgressMonitor(), DBObjectNameCaseTransformer.transformName((DBPDataSource)session.getDataSource(), (String)childName));
                if (!(child instanceof DBSObjectContainer)) {
                    return null;
                }
                container = (DBSObjectContainer)child;
            }
        }
        if (container instanceof DBSProcedureContainer) {
            return ((DBSProcedureContainer)container).getProcedure(session.getProgressMonitor(), DBObjectNameCaseTransformer.transformName((DBPDataSource)session.getDataSource(), (String)names[names.length - 1]));
        }
        return null;
    }

    private int bindProcedureFromJDBC(@NotNull ParameterMetaData paramsMeta) throws DBException {
        try {
            int parameterCount = paramsMeta.getParameterCount();
            if (parameterCount > 0) {
                int outParameters = 0;
                for (int index = 0; index < parameterCount; ++index) {
                    int parameterMode = paramsMeta.getParameterMode(index + 1);
                    if (parameterMode != 4 && parameterMode != 2) continue;
                    this.registerOutParameter(index + 1, paramsMeta.getParameterType(index + 1));
                    ++outParameters;
                }
                return outParameters;
            }
            return parameterCount;
        }
        catch (SQLException e) {
            throw new DBException("Error binding callable statement parameters from metadata: " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean hasOutputParameters() throws DBException {
        if (this.procedure == null) {
            return false;
        }
        Collection params = this.procedure.getParameters(this.getConnection().getProgressMonitor());
        if (!CommonUtils.isEmpty((Collection)params)) {
            for (DBSProcedureParameter param : params) {
                if (!param.getParameterKind().isOutput()) continue;
                return true;
            }
        }
        return false;
    }

    private void bindProcedureFromMeta() throws DBException {
        if (this.procedure == null) {
            return;
        }
        try {
            Collection params = this.procedure.getParameters(this.getConnection().getProgressMonitor());
            if (!CommonUtils.isEmpty((Collection)params)) {
                int index = 0;
                for (DBSProcedureParameter param : params) {
                    if (!param.getParameterKind().isOutput()) continue;
                    this.registerOutParameter(++index, param.getParameterType().getTypeID());
                }
            }
        }
        catch (SQLException e) {
            throw new DBException("Error binding callable statement parameters", (Throwable)e);
        }
    }

    @Nullable
    private List<DBSProcedureParameter> getOutputParametersFromMeta() {
        if (this.procedure == null) {
            return null;
        }
        try {
            Collection params = this.procedure.getParameters(this.getConnection().getProgressMonitor());
            if (CommonUtils.isEmpty((Collection)params)) {
                return Collections.emptyList();
            }
            ArrayList<DBSProcedureParameter> outputParams = new ArrayList<DBSProcedureParameter>();
            for (DBSProcedureParameter param : params) {
                if (!param.getParameterKind().isOutput()) continue;
                outputParams.add(param);
            }
            return outputParams;
        }
        catch (DBException e) {
            log.debug((Object)("Error obtaining output parameters from procedure: " + e.getMessage()));
            return null;
        }
    }

    @Nullable
    private List<Integer> getOutputParametersFromJDBC(@Nullable ParameterMetaData paramsMeta) {
        if (paramsMeta == null) {
            return null;
        }
        try {
            int count = paramsMeta.getParameterCount();
            if (count == 0) {
                return Collections.emptyList();
            }
            ArrayList<Integer> outputParams = new ArrayList<Integer>();
            for (int index = 1; index <= count; ++index) {
                int mode = paramsMeta.getParameterMode(index);
                if (mode != 4 && mode != 2) continue;
                outputParams.add(index);
            }
            return outputParams;
        }
        catch (SQLException e) {
            log.debug((Object)("Error obtaining output parameters from metadata: " + e.getMessage()));
            return null;
        }
    }

    private static boolean isParameterCursor(@NotNull DBPDataSource dataSource, @Nullable ParameterMetaData parameterMetaData, int parameterIndex) {
        try {
            return dataSource.getInfo().supportsMultipleResults() && parameterMetaData != null && parameterMetaData.getParameterType(parameterIndex) == 2012;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    @Override
    public boolean executeStatement() throws DBCException {
        return super.executeStatement() || this.procResults.getColumnCount() > 0;
    }

    @Override
    public boolean nextResults() throws DBCException {
        return super.nextResults() || this.procResults.getColumnCount() > 0;
    }

    @Override
    @Nullable
    public JDBCResultSet getResultSet() throws SQLException {
        JDBCResultSet resultSet = this.makeResultSet(((CallableStatement)this.getOriginal()).getResultSet());
        return resultSet != null ? resultSet : this.procResults;
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        ((CallableStatement)this.getOriginal()).registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        ((CallableStatement)this.getOriginal()).registerOutParameter(parameterIndex, sqlType, scale);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return ((CallableStatement)this.getOriginal()).wasNull();
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getString(parameterIndex);
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getBoolean(parameterIndex);
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getByte(parameterIndex);
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getShort(parameterIndex);
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getInt(parameterIndex);
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getLong(parameterIndex);
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getFloat(parameterIndex);
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getDouble(parameterIndex);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getBigDecimal(parameterIndex, scale);
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getBytes(parameterIndex);
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getDate(parameterIndex);
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getTime(parameterIndex);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getTimestamp(parameterIndex);
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getObject(parameterIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getBigDecimal(parameterIndex);
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getObject(parameterIndex, map);
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getRef(parameterIndex);
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getBlob(parameterIndex);
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getClob(parameterIndex);
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getArray(parameterIndex);
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getDate(parameterIndex, cal);
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getTime(parameterIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getTimestamp(parameterIndex, cal);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        ((CallableStatement)this.getOriginal()).registerOutParameter(parameterIndex, sqlType, typeName);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        ((CallableStatement)this.getOriginal()).registerOutParameter(parameterName, sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        ((CallableStatement)this.getOriginal()).registerOutParameter(parameterName, sqlType, scale);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        ((CallableStatement)this.getOriginal()).registerOutParameter(parameterName, sqlType, typeName);
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getURL(parameterIndex);
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        ((CallableStatement)this.getOriginal()).setURL(parameterName, val);
        this.handleStatementBind(parameterName, val);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        ((CallableStatement)this.getOriginal()).setNull(parameterName, sqlType);
        this.handleStatementBind(parameterName, null);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        ((CallableStatement)this.getOriginal()).setBoolean(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        ((CallableStatement)this.getOriginal()).setByte(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        ((CallableStatement)this.getOriginal()).setShort(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        ((CallableStatement)this.getOriginal()).setInt(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        ((CallableStatement)this.getOriginal()).setLong(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        ((CallableStatement)this.getOriginal()).setFloat(parameterName, x);
        this.handleStatementBind(parameterName, Float.valueOf(x));
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        ((CallableStatement)this.getOriginal()).setDouble(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        ((CallableStatement)this.getOriginal()).setBigDecimal(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        ((CallableStatement)this.getOriginal()).setString(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        ((CallableStatement)this.getOriginal()).setBytes(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        ((CallableStatement)this.getOriginal()).setDate(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        ((CallableStatement)this.getOriginal()).setTime(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        ((CallableStatement)this.getOriginal()).setTimestamp(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        ((CallableStatement)this.getOriginal()).setAsciiStream(parameterName, x, length);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        ((CallableStatement)this.getOriginal()).setBinaryStream(parameterName, x, length);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        ((CallableStatement)this.getOriginal()).setObject(parameterName, x, targetSqlType, scale);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        ((CallableStatement)this.getOriginal()).setObject(parameterName, x, targetSqlType);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        ((CallableStatement)this.getOriginal()).setObject(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        ((CallableStatement)this.getOriginal()).setCharacterStream(parameterName, reader, length);
        this.handleStatementBind(parameterName, reader);
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        ((CallableStatement)this.getOriginal()).setDate(parameterName, x, cal);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        ((CallableStatement)this.getOriginal()).setTime(parameterName, x, cal);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        ((CallableStatement)this.getOriginal()).setTimestamp(parameterName, x, cal);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        ((CallableStatement)this.getOriginal()).setNull(parameterName, sqlType, typeName);
        this.handleStatementBind(parameterName, null);
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getString(parameterName);
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getBoolean(parameterName);
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getByte(parameterName);
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getShort(parameterName);
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getInt(parameterName);
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getLong(parameterName);
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getFloat(parameterName);
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getDouble(parameterName);
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getBytes(parameterName);
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getDate(parameterName);
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getTime(parameterName);
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getTimestamp(parameterName);
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getObject(parameterName);
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getBigDecimal(parameterName);
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getObject(parameterName, map);
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getRef(parameterName);
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getBlob(parameterName);
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getClob(parameterName);
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getArray(parameterName);
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getDate(parameterName, cal);
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getTime(parameterName, cal);
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getTimestamp(parameterName, cal);
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getURL(parameterName);
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getRowId(parameterIndex);
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getRowId(parameterName);
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        ((CallableStatement)this.getOriginal()).setRowId(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        ((CallableStatement)this.getOriginal()).setNString(parameterName, value);
        this.handleStatementBind(parameterName, value);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        ((CallableStatement)this.getOriginal()).setNCharacterStream(parameterName, value, length);
        this.handleStatementBind(parameterName, value);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        ((CallableStatement)this.getOriginal()).setNClob(parameterName, value);
        this.handleStatementBind(parameterName, value);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        ((CallableStatement)this.getOriginal()).setClob(parameterName, reader, length);
        this.handleStatementBind(parameterName, reader);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        ((CallableStatement)this.getOriginal()).setBlob(parameterName, inputStream, length);
        this.handleStatementBind(parameterName, inputStream);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        ((CallableStatement)this.getOriginal()).setNClob(parameterName, reader, length);
        this.handleStatementBind(parameterName, reader);
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getNClob(parameterIndex);
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getNClob(parameterName);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        ((CallableStatement)this.getOriginal()).setSQLXML(parameterName, xmlObject);
        this.handleStatementBind(parameterName, xmlObject);
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getSQLXML(parameterIndex);
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getSQLXML(parameterName);
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getNString(parameterIndex);
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getNString(parameterName);
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getNCharacterStream(parameterIndex);
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getNCharacterStream(parameterName);
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getCharacterStream(parameterIndex);
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getCharacterStream(parameterName);
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        ((CallableStatement)this.getOriginal()).setBlob(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        ((CallableStatement)this.getOriginal()).setClob(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        ((CallableStatement)this.getOriginal()).setAsciiStream(parameterName, x, length);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        ((CallableStatement)this.getOriginal()).setBinaryStream(parameterName, x, length);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        ((CallableStatement)this.getOriginal()).setCharacterStream(parameterName, reader, length);
        this.handleStatementBind(parameterName, reader);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        ((CallableStatement)this.getOriginal()).setAsciiStream(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        ((CallableStatement)this.getOriginal()).setBinaryStream(parameterName, x);
        this.handleStatementBind(parameterName, x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        ((CallableStatement)this.getOriginal()).setCharacterStream(parameterName, reader);
        this.handleStatementBind(parameterName, reader);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        ((CallableStatement)this.getOriginal()).setNCharacterStream(parameterName, value);
        this.handleStatementBind(parameterName, value);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        ((CallableStatement)this.getOriginal()).setClob(parameterName, reader);
        this.handleStatementBind(parameterName, reader);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        ((CallableStatement)this.getOriginal()).setBlob(parameterName, inputStream);
        this.handleStatementBind(parameterName, inputStream);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        ((CallableStatement)this.getOriginal()).setNClob(parameterName, reader);
        this.handleStatementBind(parameterName, reader);
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getObject(parameterIndex, type);
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        return ((CallableStatement)this.getOriginal()).getObject(parameterName, type);
    }
}

