/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.ui.views;

import java.util.TimeZone;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.ext.mysql.ui.internal.MySQLUIMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ClientHomesSelector;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.utils.CommonUtils;

public class MySQLConnectionPageAdvanced
extends ConnectionPageAbstract {
    private static final boolean MANAGE_SERVER_TIME_ZONE = true;
    private ClientHomesSelector homesSelector;
    private Combo serverTimezoneCombo;

    public MySQLConnectionPageAdvanced() {
        this.setTitle("Advanced");
        this.setDescription("MySQL advanced connection setting");
    }

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite parent) {
        String[] tzList;
        Composite cfgGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        cfgGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        cfgGroup.setLayoutData((Object)gd);
        Composite advancedGroup = UIUtils.createTitledComposite((Composite)cfgGroup, (String)MySQLUIMessages.dialog_connection_group_advanced, (int)2, (int)32);
        this.serverTimezoneCombo = UIUtils.createLabelCombo((Composite)advancedGroup, (String)MySQLUIMessages.dialog_connection_server_timezone, (int)4);
        this.serverTimezoneCombo.add(MySQLUIMessages.dialog_connection_auto_detect);
        for (String tzID : tzList = TimeZone.getAvailableIDs()) {
            this.serverTimezoneCombo.add(tzID);
        }
        this.serverTimezoneCombo.setLayoutData((Object)new GridData(32));
        boolean supportsClients = CommonUtils.getBoolean((Object)this.getSite().getDriver().getDriverParameter("supportsClients"), (boolean)true);
        if (DBWorkbench.hasFeature((String)"database/administration/advanced") && supportsClients) {
            this.homesSelector = new ClientHomesSelector(advancedGroup, MySQLUIMessages.dialog_connection_local_client, false);
            gd = new GridData(800);
            this.homesSelector.getPanel().setLayoutData((Object)gd);
        }
        this.setControl((Control)cfgGroup);
        this.loadSettings();
    }

    public boolean isComplete() {
        return true;
    }

    public void loadSettings() {
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.serverTimezoneCombo != null) {
            String tzProp = connectionInfo.getProviderProperty("@dbeaver-serverTimezone@");
            if (CommonUtils.isEmpty((String)tzProp)) {
                this.serverTimezoneCombo.select(0);
            } else {
                this.serverTimezoneCombo.setText(tzProp);
            }
        }
        if (this.homesSelector != null) {
            this.homesSelector.populateHomes(this.site.getDriver(), connectionInfo.getClientHomeId(), this.site.isNew());
        }
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionCfg = dataSource.getConnectionConfiguration();
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.serverTimezoneCombo != null) {
            String serverTimeZone = this.serverTimezoneCombo.getText();
            if (CommonUtils.isEmpty((String)serverTimeZone) || serverTimeZone.equals(MySQLUIMessages.dialog_connection_auto_detect)) {
                connectionInfo.removeProviderProperty("@dbeaver-serverTimezone@");
            } else {
                connectionInfo.setProviderProperty("@dbeaver-serverTimezone@", serverTimeZone);
            }
        }
        if (this.homesSelector != null) {
            connectionInfo.setClientHomeId(this.homesSelector.getSelectedHome());
        }
        this.saveConnectionURL(connectionCfg);
    }
}

