/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.ui.IWorkbenchWindowInitializer;
import org.jkiss.utils.CommonUtils;

public class WorkbenchHandlerRegistry {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.workbenchHandler";
    public static final String WORKBENCH_WINDOW_INITIALIZER = "workbenchWindowInitializer";
    private static WorkbenchHandlerRegistry instance = null;
    private final List<InitializerDescriptor> initializers;

    public static synchronized WorkbenchHandlerRegistry getInstance() {
        if (instance == null) {
            instance = new WorkbenchHandlerRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private WorkbenchHandlerRegistry(IExtensionRegistry registry) {
        this.initializers = Arrays.stream(registry.getConfigurationElementsFor(EXTENSION_ID)).filter(ext -> ext.getName().equals(WORKBENCH_WINDOW_INITIALIZER)).map(InitializerDescriptor::new).sorted(Comparator.comparingInt(InitializerDescriptor::getOrder)).toList();
    }

    @NotNull
    public Collection<InitializerDescriptor> getWorkbenchWindowInitializers() {
        return this.initializers;
    }

    public static class InitializerDescriptor
    extends AbstractDescriptor {
        private final AbstractDescriptor.ObjectType type;
        private final int order;

        private InitializerDescriptor(IConfigurationElement config) {
            super(config);
            this.type = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
            this.order = CommonUtils.toInt((Object)config.getAttribute("order"), (int)Integer.MAX_VALUE);
        }

        public IWorkbenchWindowInitializer newInstance() throws DBException {
            return (IWorkbenchWindowInitializer)this.type.createInstance(IWorkbenchWindowInitializer.class);
        }

        public int getOrder() {
            return this.order;
        }
    }
}

