/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.duckdb.model;

import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.duckdb.model.DuckDBExecutionContext;
import org.jkiss.dbeaver.ext.duckdb.model.DuckDBSQLDialect;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;

public class DuckDBDataSource
extends GenericDataSource {
    public DuckDBDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container, GenericMetaModel metaModel) throws DBException {
        super(monitor, container, metaModel, (SQLDialect)new DuckDBSQLDialect());
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int valueType) {
        return switch (typeName.toUpperCase(Locale.ROOT)) {
            case "GEOMETRY" -> DBPDataKind.OBJECT;
            default -> super.resolveDataKind(typeName, valueType);
        };
    }

    protected JDBCExecutionContext createExecutionContext(JDBCRemoteInstance instance, String type) {
        return new DuckDBExecutionContext(instance, type);
    }
}

