/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.merlin;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.merlin.MapRow;

final class SqliteResultSetRow
extends MapRow {
    private static final long TIMESTAMP_EPOCH = 978307200000L;

    public SqliteResultSetRow(ResultSet rs, Map<String, Integer> meta) throws SQLException {
        super(new HashMap<String, Object>());
        for (Map.Entry<String, Integer> entry : meta.entrySet()) {
            Object value;
            String name = entry.getKey().toUpperCase();
            int type = entry.getValue();
            switch (type) {
                case -7: 
                case 16: {
                    value = rs.getBoolean(name);
                    break;
                }
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    value = rs.getString(name);
                    break;
                }
                case 91: {
                    String stringValue = rs.getString(name);
                    if (stringValue == null || stringValue.isEmpty()) {
                        value = null;
                        break;
                    }
                    value = rs.getDate(name);
                    break;
                }
                case 93: {
                    long ts = rs.getLong(name);
                    if (ts == 0L) {
                        value = null;
                        break;
                    }
                    value = DateHelper.getTimestampFromLong(978307200000L + ts * 1000L);
                    break;
                }
                case 2: 
                case 6: 
                case 8: {
                    value = NumberHelper.getDouble(rs.getDouble(name));
                    break;
                }
                case 4: 
                case 5: {
                    value = rs.getInt(name);
                    break;
                }
                case -5: {
                    value = rs.getLong(name);
                    break;
                }
                case -4: 
                case -3: 
                case 2004: {
                    value = rs.getBytes(name);
                    break;
                }
                case 1111: {
                    value = rs.getObject(name);
                    break;
                }
                case 0: {
                    value = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported SQL type: " + type + " for column " + name);
                }
            }
            if (rs.wasNull()) {
                value = null;
            }
            this.m_map.put(name, value);
        }
    }
}

