/**********************************************************
 * This file has been automatically created by "typemaker2"
 * from the file "account_spec.xml".
 * Please do not edit this file, all changes will be lost.
 * Better edit the mentioned source file instead.
 **********************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "./account_spec_p.h"

#include <gwenhywfar/misc.h>
#include <gwenhywfar/debug.h>

/* code headers */

/* macro functions */
GWEN_LIST_FUNCTIONS(AB_ACCOUNT_SPEC, AB_AccountSpec)
GWEN_LIST2_FUNCTIONS(AB_ACCOUNT_SPEC, AB_AccountSpec)


AB_ACCOUNT_SPEC *AB_AccountSpec_new(void) {
  AB_ACCOUNT_SPEC *p_struct;

  GWEN_NEW_OBJECT(AB_ACCOUNT_SPEC, p_struct)
  p_struct->_refCount=1;
  GWEN_LIST_INIT(AB_ACCOUNT_SPEC, p_struct)
  /* members */
  p_struct->type=AB_AccountType_Unknown;
  p_struct->uniqueId=0;
  p_struct->backendName=NULL;
  p_struct->ownerName=NULL;
  p_struct->accountName=NULL;
  p_struct->currency=NULL;
  p_struct->memo=NULL;
  p_struct->iban=NULL;
  p_struct->bic=NULL;
  p_struct->country=NULL;
  p_struct->bankCode=NULL;
  p_struct->branchId=NULL;
  p_struct->accountNumber=NULL;
  p_struct->subAccountNumber=NULL;
  p_struct->transactionLimitsList=AB_TransactionLimits_List_new();
  /* virtual functions */

  return p_struct;
}

void AB_AccountSpec_free(AB_ACCOUNT_SPEC *p_struct) {
  if (p_struct) {
  assert(p_struct->_refCount);
  if (p_struct->_refCount==1) {
    GWEN_LIST_FINI(AB_ACCOUNT_SPEC, p_struct)
  /* members */
    free(p_struct->backendName); p_struct->backendName=NULL;
    free(p_struct->ownerName); p_struct->ownerName=NULL;
    free(p_struct->accountName); p_struct->accountName=NULL;
    free(p_struct->currency); p_struct->currency=NULL;
    free(p_struct->memo); p_struct->memo=NULL;
    free(p_struct->iban); p_struct->iban=NULL;
    free(p_struct->bic); p_struct->bic=NULL;
    free(p_struct->country); p_struct->country=NULL;
    free(p_struct->bankCode); p_struct->bankCode=NULL;
    free(p_struct->branchId); p_struct->branchId=NULL;
    free(p_struct->accountNumber); p_struct->accountNumber=NULL;
    free(p_struct->subAccountNumber); p_struct->subAccountNumber=NULL;
    AB_TransactionLimits_List_free(p_struct->transactionLimitsList); p_struct->transactionLimitsList=NULL;
    p_struct->_refCount=0;
    GWEN_FREE_OBJECT(p_struct);
  }
  else
    p_struct->_refCount--;
  }
}

void AB_AccountSpec_Attach(AB_ACCOUNT_SPEC *p_struct) {
  assert(p_struct);
  assert(p_struct->_refCount);
  p_struct->_refCount++;
}

AB_ACCOUNT_SPEC *AB_AccountSpec_dup(const AB_ACCOUNT_SPEC *p_src) {
  AB_ACCOUNT_SPEC *p_struct;

  assert(p_src);
  p_struct=AB_AccountSpec_new();
  /* member "type" */
  p_struct->type=p_src->type;

  /* member "uniqueId" */
  p_struct->uniqueId=p_src->uniqueId;

  /* member "backendName" */
  if (p_struct->backendName) {
    free(p_struct->backendName); p_struct->backendName=NULL;
    p_struct->backendName=NULL;
  }
  if (p_src->backendName) {
    p_struct->backendName=strdup(p_src->backendName);
  }

  /* member "ownerName" */
  if (p_struct->ownerName) {
    free(p_struct->ownerName); p_struct->ownerName=NULL;
    p_struct->ownerName=NULL;
  }
  if (p_src->ownerName) {
    p_struct->ownerName=strdup(p_src->ownerName);
  }

  /* member "accountName" */
  if (p_struct->accountName) {
    free(p_struct->accountName); p_struct->accountName=NULL;
    p_struct->accountName=NULL;
  }
  if (p_src->accountName) {
    p_struct->accountName=strdup(p_src->accountName);
  }

  /* member "currency" */
  if (p_struct->currency) {
    free(p_struct->currency); p_struct->currency=NULL;
    p_struct->currency=NULL;
  }
  if (p_src->currency) {
    p_struct->currency=strdup(p_src->currency);
  }

  /* member "memo" */
  if (p_struct->memo) {
    free(p_struct->memo); p_struct->memo=NULL;
    p_struct->memo=NULL;
  }
  if (p_src->memo) {
    p_struct->memo=strdup(p_src->memo);
  }

  /* member "iban" */
  if (p_struct->iban) {
    free(p_struct->iban); p_struct->iban=NULL;
    p_struct->iban=NULL;
  }
  if (p_src->iban) {
    p_struct->iban=strdup(p_src->iban);
  }

  /* member "bic" */
  if (p_struct->bic) {
    free(p_struct->bic); p_struct->bic=NULL;
    p_struct->bic=NULL;
  }
  if (p_src->bic) {
    p_struct->bic=strdup(p_src->bic);
  }

  /* member "country" */
  if (p_struct->country) {
    free(p_struct->country); p_struct->country=NULL;
    p_struct->country=NULL;
  }
  if (p_src->country) {
    p_struct->country=strdup(p_src->country);
  }

  /* member "bankCode" */
  if (p_struct->bankCode) {
    free(p_struct->bankCode); p_struct->bankCode=NULL;
    p_struct->bankCode=NULL;
  }
  if (p_src->bankCode) {
    p_struct->bankCode=strdup(p_src->bankCode);
  }

  /* member "branchId" */
  if (p_struct->branchId) {
    free(p_struct->branchId); p_struct->branchId=NULL;
    p_struct->branchId=NULL;
  }
  if (p_src->branchId) {
    p_struct->branchId=strdup(p_src->branchId);
  }

  /* member "accountNumber" */
  if (p_struct->accountNumber) {
    free(p_struct->accountNumber); p_struct->accountNumber=NULL;
    p_struct->accountNumber=NULL;
  }
  if (p_src->accountNumber) {
    p_struct->accountNumber=strdup(p_src->accountNumber);
  }

  /* member "subAccountNumber" */
  if (p_struct->subAccountNumber) {
    free(p_struct->subAccountNumber); p_struct->subAccountNumber=NULL;
    p_struct->subAccountNumber=NULL;
  }
  if (p_src->subAccountNumber) {
    p_struct->subAccountNumber=strdup(p_src->subAccountNumber);
  }

  /* member "transactionLimitsList" */
  if (p_struct->transactionLimitsList) {
    AB_TransactionLimits_List_free(p_struct->transactionLimitsList); p_struct->transactionLimitsList=NULL;
    p_struct->transactionLimitsList=NULL;
  }
  if (p_src->transactionLimitsList) {
    p_struct->transactionLimitsList=AB_TransactionLimits_List_dup(p_src->transactionLimitsList);
  }

  return p_struct;
}

AB_ACCOUNT_SPEC *AB_AccountSpec_copy(AB_ACCOUNT_SPEC *p_struct, const AB_ACCOUNT_SPEC *p_src) {
    assert(p_struct);
  assert(p_src);
  /* member "type" */
  p_struct->type=p_src->type;

  /* member "uniqueId" */
  p_struct->uniqueId=p_src->uniqueId;

  /* member "backendName" */
  if (p_struct->backendName) {
    free(p_struct->backendName); p_struct->backendName=NULL;
    p_struct->backendName=NULL;
  }
  if (p_src->backendName) {
    p_struct->backendName=strdup(p_src->backendName);
  }

  /* member "ownerName" */
  if (p_struct->ownerName) {
    free(p_struct->ownerName); p_struct->ownerName=NULL;
    p_struct->ownerName=NULL;
  }
  if (p_src->ownerName) {
    p_struct->ownerName=strdup(p_src->ownerName);
  }

  /* member "accountName" */
  if (p_struct->accountName) {
    free(p_struct->accountName); p_struct->accountName=NULL;
    p_struct->accountName=NULL;
  }
  if (p_src->accountName) {
    p_struct->accountName=strdup(p_src->accountName);
  }

  /* member "currency" */
  if (p_struct->currency) {
    free(p_struct->currency); p_struct->currency=NULL;
    p_struct->currency=NULL;
  }
  if (p_src->currency) {
    p_struct->currency=strdup(p_src->currency);
  }

  /* member "memo" */
  if (p_struct->memo) {
    free(p_struct->memo); p_struct->memo=NULL;
    p_struct->memo=NULL;
  }
  if (p_src->memo) {
    p_struct->memo=strdup(p_src->memo);
  }

  /* member "iban" */
  if (p_struct->iban) {
    free(p_struct->iban); p_struct->iban=NULL;
    p_struct->iban=NULL;
  }
  if (p_src->iban) {
    p_struct->iban=strdup(p_src->iban);
  }

  /* member "bic" */
  if (p_struct->bic) {
    free(p_struct->bic); p_struct->bic=NULL;
    p_struct->bic=NULL;
  }
  if (p_src->bic) {
    p_struct->bic=strdup(p_src->bic);
  }

  /* member "country" */
  if (p_struct->country) {
    free(p_struct->country); p_struct->country=NULL;
    p_struct->country=NULL;
  }
  if (p_src->country) {
    p_struct->country=strdup(p_src->country);
  }

  /* member "bankCode" */
  if (p_struct->bankCode) {
    free(p_struct->bankCode); p_struct->bankCode=NULL;
    p_struct->bankCode=NULL;
  }
  if (p_src->bankCode) {
    p_struct->bankCode=strdup(p_src->bankCode);
  }

  /* member "branchId" */
  if (p_struct->branchId) {
    free(p_struct->branchId); p_struct->branchId=NULL;
    p_struct->branchId=NULL;
  }
  if (p_src->branchId) {
    p_struct->branchId=strdup(p_src->branchId);
  }

  /* member "accountNumber" */
  if (p_struct->accountNumber) {
    free(p_struct->accountNumber); p_struct->accountNumber=NULL;
    p_struct->accountNumber=NULL;
  }
  if (p_src->accountNumber) {
    p_struct->accountNumber=strdup(p_src->accountNumber);
  }

  /* member "subAccountNumber" */
  if (p_struct->subAccountNumber) {
    free(p_struct->subAccountNumber); p_struct->subAccountNumber=NULL;
    p_struct->subAccountNumber=NULL;
  }
  if (p_src->subAccountNumber) {
    p_struct->subAccountNumber=strdup(p_src->subAccountNumber);
  }

  /* member "transactionLimitsList" */
  if (p_struct->transactionLimitsList) {
    AB_TransactionLimits_List_free(p_struct->transactionLimitsList); p_struct->transactionLimitsList=NULL;
    p_struct->transactionLimitsList=NULL;
  }
  if (p_src->transactionLimitsList) {
    p_struct->transactionLimitsList=AB_TransactionLimits_List_dup(p_src->transactionLimitsList);
  }

  return p_struct;
}

int AB_AccountSpec_GetType(const AB_ACCOUNT_SPEC *p_struct) {
  assert(p_struct);
  return p_struct->type;
}

uint32_t AB_AccountSpec_GetUniqueId(const AB_ACCOUNT_SPEC *p_struct) {
  assert(p_struct);
  return p_struct->uniqueId;
}

const char *AB_AccountSpec_GetBackendName(const AB_ACCOUNT_SPEC *p_struct) {
  assert(p_struct);
  return p_struct->backendName;
}

const char *AB_AccountSpec_GetOwnerName(const AB_ACCOUNT_SPEC *p_struct) {
  assert(p_struct);
  return p_struct->ownerName;
}

const char *AB_AccountSpec_GetAccountName(const AB_ACCOUNT_SPEC *p_struct) {
  assert(p_struct);
  return p_struct->accountName;
}

const char *AB_AccountSpec_GetCurrency(const AB_ACCOUNT_SPEC *p_struct) {
  assert(p_struct);
  return p_struct->currency;
}

const char *AB_AccountSpec_GetMemo(const AB_ACCOUNT_SPEC *p_struct) {
  assert(p_struct);
  return p_struct->memo;
}

const char *AB_AccountSpec_GetIban(const AB_ACCOUNT_SPEC *p_struct) {
  assert(p_struct);
  return p_struct->iban;
}

const char *AB_AccountSpec_GetBic(const AB_ACCOUNT_SPEC *p_struct) {
  assert(p_struct);
  return p_struct->bic;
}

const char *AB_AccountSpec_GetCountry(const AB_ACCOUNT_SPEC *p_struct) {
  assert(p_struct);
  return p_struct->country;
}

const char *AB_AccountSpec_GetBankCode(const AB_ACCOUNT_SPEC *p_struct) {
  assert(p_struct);
  return p_struct->bankCode;
}

const char *AB_AccountSpec_GetBranchId(const AB_ACCOUNT_SPEC *p_struct) {
  assert(p_struct);
  return p_struct->branchId;
}

const char *AB_AccountSpec_GetAccountNumber(const AB_ACCOUNT_SPEC *p_struct) {
  assert(p_struct);
  return p_struct->accountNumber;
}

const char *AB_AccountSpec_GetSubAccountNumber(const AB_ACCOUNT_SPEC *p_struct) {
  assert(p_struct);
  return p_struct->subAccountNumber;
}

AB_TRANSACTION_LIMITS_LIST *AB_AccountSpec_GetTransactionLimitsList(const AB_ACCOUNT_SPEC *p_struct) {
  assert(p_struct);
  return p_struct->transactionLimitsList;
}

void AB_AccountSpec_SetType(AB_ACCOUNT_SPEC *p_struct, int p_src) {
  assert(p_struct);
  p_struct->type=p_src;
}

void AB_AccountSpec_SetUniqueId(AB_ACCOUNT_SPEC *p_struct, uint32_t p_src) {
  assert(p_struct);
  p_struct->uniqueId=p_src;
}

void AB_AccountSpec_SetBackendName(AB_ACCOUNT_SPEC *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->backendName) {
    free(p_struct->backendName); p_struct->backendName=NULL;
  }
  if (p_src) {
    p_struct->backendName=strdup(p_src);
  }
  else {
    p_struct->backendName=NULL;
  }
}

void AB_AccountSpec_SetOwnerName(AB_ACCOUNT_SPEC *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->ownerName) {
    free(p_struct->ownerName); p_struct->ownerName=NULL;
  }
  if (p_src) {
    p_struct->ownerName=strdup(p_src);
  }
  else {
    p_struct->ownerName=NULL;
  }
}

void AB_AccountSpec_SetAccountName(AB_ACCOUNT_SPEC *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->accountName) {
    free(p_struct->accountName); p_struct->accountName=NULL;
  }
  if (p_src) {
    p_struct->accountName=strdup(p_src);
  }
  else {
    p_struct->accountName=NULL;
  }
}

void AB_AccountSpec_SetCurrency(AB_ACCOUNT_SPEC *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->currency) {
    free(p_struct->currency); p_struct->currency=NULL;
  }
  if (p_src) {
    p_struct->currency=strdup(p_src);
  }
  else {
    p_struct->currency=NULL;
  }
}

void AB_AccountSpec_SetMemo(AB_ACCOUNT_SPEC *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->memo) {
    free(p_struct->memo); p_struct->memo=NULL;
  }
  if (p_src) {
    p_struct->memo=strdup(p_src);
  }
  else {
    p_struct->memo=NULL;
  }
}

void AB_AccountSpec_SetIban(AB_ACCOUNT_SPEC *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->iban) {
    free(p_struct->iban); p_struct->iban=NULL;
  }
  if (p_src) {
    p_struct->iban=strdup(p_src);
  }
  else {
    p_struct->iban=NULL;
  }
}

void AB_AccountSpec_SetBic(AB_ACCOUNT_SPEC *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->bic) {
    free(p_struct->bic); p_struct->bic=NULL;
  }
  if (p_src) {
    p_struct->bic=strdup(p_src);
  }
  else {
    p_struct->bic=NULL;
  }
}

void AB_AccountSpec_SetCountry(AB_ACCOUNT_SPEC *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->country) {
    free(p_struct->country); p_struct->country=NULL;
  }
  if (p_src) {
    p_struct->country=strdup(p_src);
  }
  else {
    p_struct->country=NULL;
  }
}

void AB_AccountSpec_SetBankCode(AB_ACCOUNT_SPEC *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->bankCode) {
    free(p_struct->bankCode); p_struct->bankCode=NULL;
  }
  if (p_src) {
    p_struct->bankCode=strdup(p_src);
  }
  else {
    p_struct->bankCode=NULL;
  }
}

void AB_AccountSpec_SetBranchId(AB_ACCOUNT_SPEC *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->branchId) {
    free(p_struct->branchId); p_struct->branchId=NULL;
  }
  if (p_src) {
    p_struct->branchId=strdup(p_src);
  }
  else {
    p_struct->branchId=NULL;
  }
}

void AB_AccountSpec_SetAccountNumber(AB_ACCOUNT_SPEC *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->accountNumber) {
    free(p_struct->accountNumber); p_struct->accountNumber=NULL;
  }
  if (p_src) {
    p_struct->accountNumber=strdup(p_src);
  }
  else {
    p_struct->accountNumber=NULL;
  }
}

void AB_AccountSpec_SetSubAccountNumber(AB_ACCOUNT_SPEC *p_struct, const char *p_src) {
  assert(p_struct);
  if (p_struct->subAccountNumber) {
    free(p_struct->subAccountNumber); p_struct->subAccountNumber=NULL;
  }
  if (p_src) {
    p_struct->subAccountNumber=strdup(p_src);
  }
  else {
    p_struct->subAccountNumber=NULL;
  }
}

void AB_AccountSpec_SetTransactionLimitsList(AB_ACCOUNT_SPEC *p_struct, AB_TRANSACTION_LIMITS_LIST *p_src) {
  assert(p_struct);
  if (p_struct->transactionLimitsList) {
    AB_TransactionLimits_List_free(p_struct->transactionLimitsList); p_struct->transactionLimitsList=NULL;
  }
  p_struct->transactionLimitsList=p_src;
}

/* list1 functions */
AB_ACCOUNT_SPEC_LIST *AB_AccountSpec_List_dup(const AB_ACCOUNT_SPEC_LIST *p_src) {
  AB_ACCOUNT_SPEC_LIST *p_dest;
  AB_ACCOUNT_SPEC *p_elem;

  assert(p_src);
  p_dest=AB_AccountSpec_List_new();
  p_elem=AB_AccountSpec_List_First(p_src);
  while(p_elem) {
    AB_ACCOUNT_SPEC *p_cpy;

    p_cpy=AB_AccountSpec_dup(p_elem);
    AB_AccountSpec_List_Add(p_cpy, p_dest);
    p_elem=AB_AccountSpec_List_Next(p_elem);
  }

  return p_dest;
}

void AB_AccountSpec_ReadDb(AB_ACCOUNT_SPEC *p_struct, GWEN_DB_NODE *p_db) {
  assert(p_struct);
  /* member "type" */
  p_struct->type=GWEN_DB_GetIntValue(p_db, "type", 0, AB_AccountType_Unknown);

  /* member "uniqueId" */
  p_struct->uniqueId=GWEN_DB_GetIntValue(p_db, "uniqueId", 0, 0);

  /* member "backendName" */
  if (p_struct->backendName) {
    free(p_struct->backendName); p_struct->backendName=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "backendName", 0, NULL); if (s) p_struct->backendName=strdup(s); }
  if (p_struct->backendName==NULL) {  p_struct->backendName=NULL;
  }

  /* member "ownerName" */
  if (p_struct->ownerName) {
    free(p_struct->ownerName); p_struct->ownerName=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "ownerName", 0, NULL); if (s) p_struct->ownerName=strdup(s); }
  if (p_struct->ownerName==NULL) {  p_struct->ownerName=NULL;
  }

  /* member "accountName" */
  if (p_struct->accountName) {
    free(p_struct->accountName); p_struct->accountName=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "accountName", 0, NULL); if (s) p_struct->accountName=strdup(s); }
  if (p_struct->accountName==NULL) {  p_struct->accountName=NULL;
  }

  /* member "currency" */
  if (p_struct->currency) {
    free(p_struct->currency); p_struct->currency=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "currency", 0, NULL); if (s) p_struct->currency=strdup(s); }
  if (p_struct->currency==NULL) {  p_struct->currency=NULL;
  }

  /* member "memo" */
  if (p_struct->memo) {
    free(p_struct->memo); p_struct->memo=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "memo", 0, NULL); if (s) p_struct->memo=strdup(s); }
  if (p_struct->memo==NULL) {  p_struct->memo=NULL;
  }

  /* member "iban" */
  if (p_struct->iban) {
    free(p_struct->iban); p_struct->iban=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "iban", 0, NULL); if (s) p_struct->iban=strdup(s); }
  if (p_struct->iban==NULL) {  p_struct->iban=NULL;
  }

  /* member "bic" */
  if (p_struct->bic) {
    free(p_struct->bic); p_struct->bic=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "bic", 0, NULL); if (s) p_struct->bic=strdup(s); }
  if (p_struct->bic==NULL) {  p_struct->bic=NULL;
  }

  /* member "country" */
  if (p_struct->country) {
    free(p_struct->country); p_struct->country=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "country", 0, NULL); if (s) p_struct->country=strdup(s); }
  if (p_struct->country==NULL) {  p_struct->country=NULL;
  }

  /* member "bankCode" */
  if (p_struct->bankCode) {
    free(p_struct->bankCode); p_struct->bankCode=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "bankCode", 0, NULL); if (s) p_struct->bankCode=strdup(s); }
  if (p_struct->bankCode==NULL) {  p_struct->bankCode=NULL;
  }

  /* member "branchId" */
  if (p_struct->branchId) {
    free(p_struct->branchId); p_struct->branchId=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "branchId", 0, NULL); if (s) p_struct->branchId=strdup(s); }
  if (p_struct->branchId==NULL) {  p_struct->branchId=NULL;
  }

  /* member "accountNumber" */
  if (p_struct->accountNumber) {
    free(p_struct->accountNumber); p_struct->accountNumber=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "accountNumber", 0, NULL); if (s) p_struct->accountNumber=strdup(s); }
  if (p_struct->accountNumber==NULL) {  p_struct->accountNumber=NULL;
  }

  /* member "subAccountNumber" */
  if (p_struct->subAccountNumber) {
    free(p_struct->subAccountNumber); p_struct->subAccountNumber=NULL;
  }
  { const char *s; s=GWEN_DB_GetCharValue(p_db, "subAccountNumber", 0, NULL); if (s) p_struct->subAccountNumber=strdup(s); }
  if (p_struct->subAccountNumber==NULL) {  p_struct->subAccountNumber=NULL;
  }

  /* member "transactionLimitsList" */
  if (p_struct->transactionLimitsList) {
    AB_TransactionLimits_List_free(p_struct->transactionLimitsList); p_struct->transactionLimitsList=NULL;
  }
  { GWEN_DB_NODE *dbSource; dbSource=GWEN_DB_GetGroup(p_db, GWEN_PATH_FLAGS_NAMEMUSTEXIST, "transactionLimitsList"); if (dbSource) { AB_TRANSACTION_LIMITS_LIST *t; GWEN_DB_NODE *dbT; t=AB_TransactionLimits_List_new(); dbT=GWEN_DB_FindFirstGroup(dbSource, "element"); while(dbT) { AB_TRANSACTION_LIMITS *elem; elem=AB_TransactionLimits_fromDb(dbT); if (elem) AB_TransactionLimits_List_Add(elem, t); dbT=GWEN_DB_FindNextGroup(dbT, "element"); } p_struct->transactionLimitsList=t; } else p_struct->transactionLimitsList=AB_TransactionLimits_List_new(); }
  if (p_struct->transactionLimitsList==NULL) {  p_struct->transactionLimitsList=AB_TransactionLimits_List_new();
  }

}

int AB_AccountSpec_WriteDb(const AB_ACCOUNT_SPEC *p_struct, GWEN_DB_NODE *p_db) {
  int p_rv;

  assert(p_struct);
  /* member "type" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "type", p_struct->type);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "uniqueId" */
  p_rv=GWEN_DB_SetIntValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "uniqueId", p_struct->uniqueId);
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "backendName" */
  if (p_struct->backendName) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "backendName", p_struct->backendName); else { GWEN_DB_DeleteVar(p_db, "backendName"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "ownerName" */
  if (p_struct->ownerName) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "ownerName", p_struct->ownerName); else { GWEN_DB_DeleteVar(p_db, "ownerName"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "accountName" */
  if (p_struct->accountName) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "accountName", p_struct->accountName); else { GWEN_DB_DeleteVar(p_db, "accountName"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "currency" */
  if (p_struct->currency) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "currency", p_struct->currency); else { GWEN_DB_DeleteVar(p_db, "currency"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "memo" */
  if (p_struct->memo) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "memo", p_struct->memo); else { GWEN_DB_DeleteVar(p_db, "memo"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "iban" */
  if (p_struct->iban) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "iban", p_struct->iban); else { GWEN_DB_DeleteVar(p_db, "iban"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "bic" */
  if (p_struct->bic) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "bic", p_struct->bic); else { GWEN_DB_DeleteVar(p_db, "bic"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "country" */
  if (p_struct->country) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "country", p_struct->country); else { GWEN_DB_DeleteVar(p_db, "country"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "bankCode" */
  if (p_struct->bankCode) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "bankCode", p_struct->bankCode); else { GWEN_DB_DeleteVar(p_db, "bankCode"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "branchId" */
  if (p_struct->branchId) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "branchId", p_struct->branchId); else { GWEN_DB_DeleteVar(p_db, "branchId"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "accountNumber" */
  if (p_struct->accountNumber) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "accountNumber", p_struct->accountNumber); else { GWEN_DB_DeleteVar(p_db, "accountNumber"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "subAccountNumber" */
  if (p_struct->subAccountNumber) p_rv=GWEN_DB_SetCharValue(p_db, GWEN_DB_FLAGS_OVERWRITE_VARS, "subAccountNumber", p_struct->subAccountNumber); else { GWEN_DB_DeleteVar(p_db, "subAccountNumber"); p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  /* member "transactionLimitsList" */
  { if (p_struct->transactionLimitsList) { GWEN_DB_NODE *dbDest; AB_TRANSACTION_LIMITS *elem; dbDest=GWEN_DB_GetGroup(p_db, GWEN_DB_FLAGS_OVERWRITE_GROUPS, "transactionLimitsList"); assert(dbDest); p_rv=0; elem=AB_TransactionLimits_List_First(p_struct->transactionLimitsList); while(elem) { GWEN_DB_NODE *dbElem; dbElem=GWEN_DB_GetGroup(dbDest, GWEN_PATH_FLAGS_CREATE_GROUP, "element"); assert(dbElem); p_rv=AB_TransactionLimits_toDb(elem, dbElem); if (p_rv<0) { DBG_INFO(GWEN_LOGDOMAIN, "here (%d)", p_rv); break; } elem=AB_TransactionLimits_List_Next(elem); } } else p_rv=0; }
  if (p_rv<0) {
    DBG_INFO(GWEN_LOGDOMAIN, "here (%d)\n", p_rv);
    return p_rv;
  }

  return 0;
}

AB_ACCOUNT_SPEC *AB_AccountSpec_fromDb(GWEN_DB_NODE *p_db) {
  AB_ACCOUNT_SPEC *p_struct;
  p_struct=AB_AccountSpec_new();
  AB_AccountSpec_ReadDb(p_struct, p_db);
  return p_struct;
}

int AB_AccountSpec_toDb(const AB_ACCOUNT_SPEC *p_struct, GWEN_DB_NODE *p_db) {
  return AB_AccountSpec_WriteDb(p_struct, p_db);
}

void AB_AccountSpec_ReadXml(AB_ACCOUNT_SPEC *p_struct, GWEN_XMLNODE *p_db) {
  assert(p_struct);
  /* member "type" */
  p_struct->type=GWEN_XMLNode_GetIntValue(p_db, "type", AB_AccountType_Unknown);

  /* member "uniqueId" */
  p_struct->uniqueId=GWEN_XMLNode_GetIntValue(p_db, "uniqueId", 0);

  /* member "backendName" */
  if (p_struct->backendName) {
    free(p_struct->backendName); p_struct->backendName=NULL;
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "backendName", NULL); if (s) p_struct->backendName=strdup(s); }
  if (p_struct->backendName==NULL) {  /* preset member "backendName" if empty */
  p_struct->backendName=NULL;
  }

  /* member "ownerName" */
  if (p_struct->ownerName) {
    free(p_struct->ownerName); p_struct->ownerName=NULL;
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "ownerName", NULL); if (s) p_struct->ownerName=strdup(s); }
  if (p_struct->ownerName==NULL) {  /* preset member "ownerName" if empty */
  p_struct->ownerName=NULL;
  }

  /* member "accountName" */
  if (p_struct->accountName) {
    free(p_struct->accountName); p_struct->accountName=NULL;
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "accountName", NULL); if (s) p_struct->accountName=strdup(s); }
  if (p_struct->accountName==NULL) {  /* preset member "accountName" if empty */
  p_struct->accountName=NULL;
  }

  /* member "currency" */
  if (p_struct->currency) {
    free(p_struct->currency); p_struct->currency=NULL;
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "currency", NULL); if (s) p_struct->currency=strdup(s); }
  if (p_struct->currency==NULL) {  /* preset member "currency" if empty */
  p_struct->currency=NULL;
  }

  /* member "memo" */
  if (p_struct->memo) {
    free(p_struct->memo); p_struct->memo=NULL;
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "memo", NULL); if (s) p_struct->memo=strdup(s); }
  if (p_struct->memo==NULL) {  /* preset member "memo" if empty */
  p_struct->memo=NULL;
  }

  /* member "iban" */
  if (p_struct->iban) {
    free(p_struct->iban); p_struct->iban=NULL;
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "iban", NULL); if (s) p_struct->iban=strdup(s); }
  if (p_struct->iban==NULL) {  /* preset member "iban" if empty */
  p_struct->iban=NULL;
  }

  /* member "bic" */
  if (p_struct->bic) {
    free(p_struct->bic); p_struct->bic=NULL;
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "bic", NULL); if (s) p_struct->bic=strdup(s); }
  if (p_struct->bic==NULL) {  /* preset member "bic" if empty */
  p_struct->bic=NULL;
  }

  /* member "country" */
  if (p_struct->country) {
    free(p_struct->country); p_struct->country=NULL;
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "country", NULL); if (s) p_struct->country=strdup(s); }
  if (p_struct->country==NULL) {  /* preset member "country" if empty */
  p_struct->country=NULL;
  }

  /* member "bankCode" */
  if (p_struct->bankCode) {
    free(p_struct->bankCode); p_struct->bankCode=NULL;
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "bankCode", NULL); if (s) p_struct->bankCode=strdup(s); }
  if (p_struct->bankCode==NULL) {  /* preset member "bankCode" if empty */
  p_struct->bankCode=NULL;
  }

  /* member "branchId" */
  if (p_struct->branchId) {
    free(p_struct->branchId); p_struct->branchId=NULL;
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "branchId", NULL); if (s) p_struct->branchId=strdup(s); }
  if (p_struct->branchId==NULL) {  /* preset member "branchId" if empty */
  p_struct->branchId=NULL;
  }

  /* member "accountNumber" */
  if (p_struct->accountNumber) {
    free(p_struct->accountNumber); p_struct->accountNumber=NULL;
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "accountNumber", NULL); if (s) p_struct->accountNumber=strdup(s); }
  if (p_struct->accountNumber==NULL) {  /* preset member "accountNumber" if empty */
  p_struct->accountNumber=NULL;
  }

  /* member "subAccountNumber" */
  if (p_struct->subAccountNumber) {
    free(p_struct->subAccountNumber); p_struct->subAccountNumber=NULL;
  }
  { const char *s; s=GWEN_XMLNode_GetCharValue(p_db, "subAccountNumber", NULL); if (s) p_struct->subAccountNumber=strdup(s); }
  if (p_struct->subAccountNumber==NULL) {  /* preset member "subAccountNumber" if empty */
  p_struct->subAccountNumber=NULL;
  }

  /* member "transactionLimitsList" */
  if (p_struct->transactionLimitsList) {
    AB_TransactionLimits_List_free(p_struct->transactionLimitsList); p_struct->transactionLimitsList=NULL;
  }
  { GWEN_XMLNODE *dbSource; dbSource=GWEN_XMLNode_FindFirstTag(p_db, "transactionLimitsList", NULL, NULL); if (dbSource) { AB_TRANSACTION_LIMITS_LIST *t; GWEN_XMLNODE *dbT; t=AB_TransactionLimits_List_new(); dbT=GWEN_XMLNode_FindFirstTag(dbSource, "element", NULL, NULL); while(dbT) { AB_TRANSACTION_LIMITS *elem; elem=AB_TransactionLimits_fromXml(dbT); if (elem) AB_TransactionLimits_List_Add(elem, t); dbT=GWEN_XMLNode_FindNextTag(dbT, "element", NULL, NULL); } p_struct->transactionLimitsList=t; } else p_struct->transactionLimitsList=AB_TransactionLimits_List_new(); }
  if (p_struct->transactionLimitsList==NULL) {  /* preset member "transactionLimitsList" if empty */
  p_struct->transactionLimitsList=AB_TransactionLimits_List_new();
  }

}

void AB_AccountSpec_WriteXml(const AB_ACCOUNT_SPEC *p_struct, GWEN_XMLNODE *p_db) {
  assert(p_struct);
  /* member "type" */
  GWEN_XMLNode_SetIntValue(p_db, "type", p_struct->type);

  /* member "uniqueId" */
  GWEN_XMLNode_SetIntValue(p_db, "uniqueId", p_struct->uniqueId);

  /* member "backendName" */
  GWEN_XMLNode_SetCharValue(p_db, "backendName", p_struct->backendName);

  /* member "ownerName" */
  GWEN_XMLNode_SetCharValue(p_db, "ownerName", p_struct->ownerName);

  /* member "accountName" */
  GWEN_XMLNode_SetCharValue(p_db, "accountName", p_struct->accountName);

  /* member "currency" */
  GWEN_XMLNode_SetCharValue(p_db, "currency", p_struct->currency);

  /* member "memo" */
  GWEN_XMLNode_SetCharValue(p_db, "memo", p_struct->memo);

  /* member "iban" */
  GWEN_XMLNode_SetCharValue(p_db, "iban", p_struct->iban);

  /* member "bic" */
  GWEN_XMLNode_SetCharValue(p_db, "bic", p_struct->bic);

  /* member "country" */
  GWEN_XMLNode_SetCharValue(p_db, "country", p_struct->country);

  /* member "bankCode" */
  GWEN_XMLNode_SetCharValue(p_db, "bankCode", p_struct->bankCode);

  /* member "branchId" */
  GWEN_XMLNode_SetCharValue(p_db, "branchId", p_struct->branchId);

  /* member "accountNumber" */
  GWEN_XMLNode_SetCharValue(p_db, "accountNumber", p_struct->accountNumber);

  /* member "subAccountNumber" */
  GWEN_XMLNode_SetCharValue(p_db, "subAccountNumber", p_struct->subAccountNumber);

  /* member "transactionLimitsList" */
  { if (p_struct->transactionLimitsList) { GWEN_XMLNODE *dbDest; AB_TRANSACTION_LIMITS *elem; dbDest=GWEN_XMLNode_new(GWEN_XMLNodeTypeTag, "transactionLimitsList"); elem=AB_TransactionLimits_List_First(p_struct->transactionLimitsList); while(elem) { GWEN_XMLNODE *dbElem; dbElem=GWEN_XMLNode_new(GWEN_XMLNodeTypeTag, "element"); assert(dbElem); AB_TransactionLimits_toXml(elem, dbElem); GWEN_XMLNode_AddChild(dbDest, dbElem); elem=AB_TransactionLimits_List_Next(elem); } GWEN_XMLNode_AddChild(p_db, dbDest); } }

}

void AB_AccountSpec_toXml(const AB_ACCOUNT_SPEC *p_struct, GWEN_XMLNODE *p_db) {
  AB_AccountSpec_WriteXml(p_struct, p_db);
}

AB_ACCOUNT_SPEC *AB_AccountSpec_fromXml(GWEN_XMLNODE *p_db) {
  AB_ACCOUNT_SPEC *p_struct;
  p_struct=AB_AccountSpec_new();
  AB_AccountSpec_ReadXml(p_struct, p_db);
  return p_struct;
}

AB_ACCOUNT_SPEC *AB_AccountSpec_List_GetByUniqueId(const AB_ACCOUNT_SPEC_LIST *p_list, uint32_t p_cmp) {
  AB_ACCOUNT_SPEC *p_struct;

  assert(p_list);
  p_struct = AB_AccountSpec_List_First(p_list);
  while(p_struct) {
    int p_rv;

    if (p_struct->uniqueId==p_cmp) p_rv=0; else if (p_cmp<p_struct->uniqueId) p_rv=-1; else p_rv=1;
    if (p_rv == 0)
      return p_struct;
    p_struct = AB_AccountSpec_List_Next(p_struct);
  }
  return NULL;
}

int AB_AccountSpec_Matches(const AB_ACCOUNT_SPEC *a, const char *backendName, const char *country, const char *bankId, const char *accountNumber, const char *subAccountId, const char *iban, const char *currency, int ty) { const char *lbackendName; const char *lcountry; const char *lbankId; const char *laccountNumber; const char *lsubAccountId; const char *liban; const char *lcurrency; int lty; if (!backendName) backendName="*"; if (!country) country="*"; if (!bankId) bankId="*"; if (!accountNumber) accountNumber="*"; if (!subAccountId) subAccountId="*"; if (!iban) iban="*"; if (!currency) currency="*"; if (ty>=AB_AccountType_Last) ty=AB_AccountType_Unknown; lbackendName=AB_AccountSpec_GetBackendName(a); lcountry=AB_AccountSpec_GetCountry(a); lbankId=AB_AccountSpec_GetBankCode(a); laccountNumber=AB_AccountSpec_GetAccountNumber(a); lsubAccountId=AB_AccountSpec_GetSubAccountNumber(a); liban=AB_AccountSpec_GetIban(a); lcurrency=AB_AccountSpec_GetCurrency(a); lty=AB_AccountSpec_GetType(a); if (!lcountry) lcountry=""; if (!lbankId) lbankId=""; if (!laccountNumber) laccountNumber=""; if (!lsubAccountId) lsubAccountId=""; if (!liban) liban=""; if (!lcurrency) lcurrency=""; if (lty>=AB_AccountType_Last || lty <=AB_AccountType_Unknown) lty=AB_AccountType_Unknown; if ((-1!=GWEN_Text_ComparePattern(lbackendName, backendName, 0)) && (-1!=GWEN_Text_ComparePattern(lcountry, country, 0)) && (-1!=GWEN_Text_ComparePattern(lbankId, bankId, 0)) && (-1!=GWEN_Text_ComparePattern(laccountNumber, accountNumber, 0)) && (-1!=GWEN_Text_ComparePattern(lsubAccountId, subAccountId, 0)) && (-1!=GWEN_Text_ComparePattern(liban, iban, 0)) && (-1!=GWEN_Text_ComparePattern(lcurrency, currency, 0)) && ((ty==AB_AccountType_Unknown) || (ty==lty))) return 1; return 0; }
AB_ACCOUNT_SPEC *AB_AccountSpec_List__FindInternal(AB_ACCOUNT_SPEC *a, const char *backendName, const char *country, const char *bankId, const char *accountNumber, const char *subAccountId, const char *iban, const char *currency, int ty) { if (!backendName) backendName="*"; if (!country) country="*"; if (!bankId) bankId="*"; if (!accountNumber) accountNumber="*"; if (!subAccountId) subAccountId="*"; if (!iban) iban="*"; if (!currency) currency="*"; if (ty>=AB_AccountType_Last) ty=AB_AccountType_Unknown; while(a) { const char *lbackendName; lbackendName=AB_AccountSpec_GetBackendName(a); if (! (lbackendName && *lbackendName) ) { DBG_ERROR(AQBANKING_LOGDOMAIN, "Account: %s/%s/%s: No backend, ignoring", AB_AccountSpec_GetCountry(a), AB_AccountSpec_GetBankCode(a), AB_AccountSpec_GetAccountNumber(a)); } else { int rv; rv=AB_AccountSpec_Matches(a, backendName, country, bankId, accountNumber, subAccountId, iban, currency, ty); if (rv==1) break; } a=AB_AccountSpec_List_Next(a); } /* while */ return a; }
AB_ACCOUNT_SPEC *AB_AccountSpec_List_FindFirst(const AB_ACCOUNT_SPEC_LIST *al, const char *backendName, const char *country, const char *bankId, const char *accountNumber, const char *subAccountId, const char *iban, const char *currency, int ty) { AB_ACCOUNT_SPEC *a; if (AB_AccountSpec_List_GetCount(al)==0) { DBG_INFO(AQBANKING_LOGDOMAIN, "No accounts"); return NULL; } a=AB_AccountSpec_List_First(al); assert(a); return AB_AccountSpec_List__FindInternal(a, backendName, country, bankId, accountNumber, subAccountId, iban, currency, ty); }
AB_ACCOUNT_SPEC *AB_AccountSpec_List_FindNext(AB_ACCOUNT_SPEC *a, const char *backendName, const char *country, const char *bankId, const char *accountNumber, const char *subAccountId, const char *iban, const char *currency, int ty) { assert(a); a=AB_AccountSpec_List_Next(a); if (a==NULL) { DBG_INFO(AQBANKING_LOGDOMAIN, "No more account specs"); return NULL; } return AB_AccountSpec_List__FindInternal(a, backendName, country, bankId, accountNumber, subAccountId, iban, currency, ty); }
AB_TRANSACTION_LIMITS *AB_AccountSpec_GetTransactionLimitsForCommand(const AB_ACCOUNT_SPEC *st, int cmd) { assert(st); if (st->transactionLimitsList) return AB_TransactionLimits_List_GetByCommand(st->transactionLimitsList, cmd); return NULL; }
void AB_AccountSpec_AddTransactionLimits(AB_ACCOUNT_SPEC *st, AB_TRANSACTION_LIMITS *l) { assert(st); assert(l); if (NULL==st->transactionLimitsList) st->transactionLimitsList=AB_TransactionLimits_List_new(); AB_TransactionLimits_List_Add(l, st->transactionLimitsList); }

/* code headers */

