/************************************************************************************
                          kbeartransferviewitem.cpp  -  description
                             -------------------
    Begin					: Wed Jul 26 2000
    Copyright				: (C) 2000 by Bjrn Sahlstrm
    Email						: bjorn.sahlstrom@mail.bip.net
 ***********************************************************************************/

/************************************************************************************
 *																																			*
 *   This program is free software; you can redistribute it and/or modify			*
 *   it under the terms of the GNU General Public License as published by	*
 *   the Free Software Foundation; either version 2 of the License, or				*
 *   (at your option) any later version.																		*
 *																																			*
 ************************************************************************************/

#include "kbeartransferviewitem.h"
#include "kbeartransferview.h"

//-----------------------------------------------
KBearTransferViewItem::KBearTransferViewItem( KIO::Job* job,
								KBearTransferView* v,	const QString& host, bool move  )
	: ProgressBase( 0 ),p_myTransferView( v ), p_myJob( job )
	
{
	hide();
	setJob( (KIO::CopyJob*)job );
	setStopOnClose( true );
	setOnlyClean( true );
	myPix = KGlobal::iconLoader()->loadIcon( "ftp", KIcon::Small );
	p_myTreeViewItem = new KBearTreeViewItem( p_myTransferView, host, &myPix );
	connect( job, SIGNAL( speed(KIO::Job*,unsigned long)),
					this, SLOT( slotSpeed(KIO::Job*,unsigned long)));
	connect( p_myTransferView, SIGNAL( showMenu(KBearTreeViewItem* ) ),
					this, SLOT( slotShowMenu( KBearTreeViewItem* ) ) );
 	
 	p_myTreeViewItem->setText( 1, ((KIO::CopyJob*)job)->srcURLs().first().path() );
	p_myTreeViewItem->setText( 2 , ((KIO::CopyJob*)job)->destURL().path() );
	
	if( move )
		p_myTreeViewItem->setText( 3 , i18n("Moving") );
	else
		p_myTreeViewItem->setText( 3 , i18n("Copying") );
	
	QString text( i18n("%1 bytes/sec").arg( 0 ) );
	p_myTreeViewItem->setText( 7 , text );
	QTime t( 0, 0 );
	p_myTreeViewItem->setText( 8 , t.toString() );
}
//-----------------------------------------------
KBearTransferViewItem::~KBearTransferViewItem(){
}
//-----------------------------------------------
/*
void KBearTransferViewItem::slotCopying( KIO::Job* job, const KURL& source, const KURL& dest ) {
	p_myTreeViewItem->setText( 1, source.path() );
	p_myTreeViewItem->setText( 2 , dest.path() );
	p_myTreeViewItem->setText( 3 , i18n("Copying") );
	disconnect( job, SIGNAL( copying(KIO::Job*, const KURL&, const KURL&)),
						this,SLOT(slotCopying( KIO::Job*, const KURL&, const KURL& )));
}
//-----------------------------------------------
void KBearTransferViewItem::slotMoving( KIO::Job* job, const KURL& source, const KURL& dest ) {
	p_myTreeViewItem->setText( 1, source.path() );
	p_myTreeViewItem->setText( 2 , dest.path() );
	p_myTreeViewItem->setText( 3 , i18n("Moving") );
	disconnect( job, SIGNAL( moving(KIO::Job*, const KURL&, const KURL&)),
						this,SLOT(slotMoving( KIO::Job*, const KURL&, const KURL&)));
}
//-----------------------------------------------
void KBearTransferViewItem::slotCreatingDir( KIO::Job* job, const KURL& dirURL ) {
	p_myTreeViewItem->setText( 2 , dirURL.path() );
	disconnect( job, SIGNAL( creatingDir(KIO::Job*, const KURL&)),
						this,SLOT(slotCreatingDir( KIO::Job*, const KURL& )));
}
*/
//-----------------------------------------------
void KBearTransferViewItem::slotTotalSize( KIO::Job*, unsigned long totSize ) {
	QString text( i18n("%1").arg( createSizeString(totSize) ) );
	p_myTreeViewItem->setText( 4 , text );
	totalSize = totSize;
}
//-----------------------------------------------
void KBearTransferViewItem::slotProcessedSize( KIO::Job*, unsigned long procSize ) {
	QString text( i18n("%1").arg( createSizeString(procSize) ) );
	p_myTreeViewItem->setText( 5 , text );
	processedSize = procSize;
}
//-----------------------------------------------
void KBearTransferViewItem::slotPercent( KIO::Job*, unsigned long percent ) {
	QString text( i18n("%1 %").arg( percent ) );
	p_myTreeViewItem->setText( 6 , text );
}
//-----------------------------------------------
void KBearTransferViewItem::slotSpeed( KIO::Job*, unsigned long speed ) {
	QString text( i18n("%1/sec").arg( createSizeString(speed) ) );
	p_myTreeViewItem->setText( 7 , text );
	if( speed > 0 ) {
		QTime t = KIO::calculateRemaining( totalSize, processedSize, speed );
		p_myTreeViewItem->setText( 8 , t.toString() );
	}
}
//-----------------------------------------------
void KBearTransferViewItem::slotTotalDirs( KIO::Job*, unsigned long totDirs ) {
	QString text( i18n("%1").arg( totDirs ) );
	p_myTreeViewItem->setText( 9 , text );
}
//-----------------------------------------------
void KBearTransferViewItem::slotTotalFiles( KIO::Job*, unsigned long totFiles ) {
	QString text( i18n("%1").arg( totFiles ) );
	p_myTreeViewItem->setText( 10 , text );
}
//-----------------------------------------------
void KBearTransferViewItem::slotClean() {
	p_myJob = 0;
	emit removeMe( this );
}
//-----------------------------------------------
void KBearTransferViewItem::slotShowMenu( KBearTreeViewItem* i ){
	if( i != p_myTreeViewItem )
		return;
	QPopupMenu menu( this );
	menu.insertItem( i18n("&Cancel"), this, SLOT( slotStop() ) );
	menu.setMouseTracking( true );
	menu.exec( QCursor::pos() );
}
//-----------------------------------------------
QString KBearTransferViewItem::createSizeString( unsigned long size ){
	unsigned int mb = 1048576; // 1024*1024
	QString text;
	if( size >= mb ) {
		text = i18n("%1 Mb").arg( double(size)/(mb), 0, 'f', 2 );	
	}
	else if( size >= 1024 ) {
		text = i18n("%1 Kb").arg( double(size)/1024, 0, 'f', 2 );	
	}
	else {
		text = i18n("%1 bytes").arg( size );
	}
	return text;
}
//-----------------------------------------------
void KBearTransferViewItem::slotStop() {
	disconnect( p_myTransferView, SIGNAL( showMenu(KBearTreeViewItem* ) ),
					this, SLOT( slotShowMenu( KBearTreeViewItem* ) ) );
	ProgressBase::slotStop();
	QTimer::singleShot( 4000, this, SLOT( slotClean() ) );  //Should be done after 4 sec ????
}
//-----------------------------------------------

