/***************************************************************************
                          kbeartreeview.cpp  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kbeartreeview.h"
//-----------------------------------------------
static QPixmap* folderClosed = 0;
static QPixmap* folderOpen = 0;
static QPixmap* fileNormal = 0;
//-----------------------------------------------
KBearTreeView::KBearTreeView(QWidget * parent, const char * name, bool rootDec)
	: KListView(parent,name)
{	
	if( ! folderClosed)
		folderClosed = new QPixmap( KGlobal::iconLoader()
							->loadIcon("folder",KIcon::Small, KIcon::SizeSmall ) );
	if( ! folderOpen)
		folderOpen = new QPixmap( KGlobal::iconLoader()
							->loadIcon("folder_open",KIcon::Small, KIcon::SizeSmall ) );
	if( ! fileNormal)
		fileNormal = new QPixmap( KGlobal::iconLoader()
							->loadIcon("ftp",KIcon::Small, KIcon::SizeSmall ) );	
	setRootIsDecorated ( rootDec );
}
//-----------------------------------------------
KBearTreeView::~KBearTreeView() {
	
}
//-----------------------------------------------
/** adds a parent item to root directory ,return item*/
QListViewItem* KBearTreeView::addDirectory( const QString& name ){
	return new KBearTreeViewItem(this,name, folderClosed);
}
//-----------------------------------------------
/** adds a parent item to parent directory ,return item*/
QListViewItem* KBearTreeView::addDirectory( QListViewItem* parent, const QString& name ){
	return new KBearTreeViewItem(parent,name, folderClosed);
}
//-----------------------------------------------
/** adds a child item to root directory ,return item*/
QListViewItem* KBearTreeView::addFile( const QString& name ){
	return new KBearTreeViewItem(this,name, fileNormal);
}
//-----------------------------------------------
/** adds a child item to parent directory ,return item*/
QListViewItem* KBearTreeView::addFile( QListViewItem* parent, const QString& name ){
	return new KBearTreeViewItem(parent,name, fileNormal);
}
//////////////////////////////////////////////////////////////////////////////////////////////////
//	KBearTreeViewItem
//////////////////////////////////////////////////////////////////////////////////////////////////
KBearTreeViewItem::KBearTreeViewItem( QListViewItem* parent, const QString& filename,QPixmap* icon )
	: QListViewItem( parent ,filename)
{
	p = parent;
	setPixmap( icon );
}
//-----------------------------------------------
KBearTreeViewItem::KBearTreeViewItem( QListView * parent, const QString& filename,QPixmap* icon )
	: QListViewItem( parent ,filename)
{
	setPixmap( icon );
	p=0;	
}
//-----------------------------------------------
void KBearTreeViewItem::setOpen(bool o) {
	if ( o )
		setPixmap( folderOpen );
	else
		setPixmap( folderClosed );

	QListViewItem::setOpen( o );
}
//-----------------------------------------------
void KBearTreeViewItem::setPixmap( QPixmap* p ) {
	if( ! p )
		return;
	myPixmap = p;
	QListViewItem::setPixmap( 0, *p );
}
//-----------------------------------------------
const QPixmap* KBearTreeViewItem::pixmap( int col ) const {
	if( col == 0 )
		return myPixmap;
	return 0;
}
//-----------------------------------------------
bool KBearTreeViewItem::isFile( int col ) const {
	return pixmap( col ) ==  fileNormal;
}
//-----------------------------------------------
/** Searches the hole tree for specified name
@param name is the name to search for
@return a pointer to the found item or NULL */
QListViewItem* KBearTreeView::findByName( const QString& name ){
	QListViewItemIterator it( this );
	for ( ; it.current(); ++it ) {
		if ( it.current()->text( 0 ) == name )
			return it.current();
	}
   return NULL;	
}
//-----------------------------------------------
