/***************************************************************************
                          kbearftpview.h  -  description
                             -------------------
    begin                : Thu Jun 2 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/********************************************************************************
 *																															*
 *   This program is free software; you can redistribute it and/or modify		*
 *   it under the terms of the GNU General Public License as published by	*
 *   the Free Software Foundation; either version 2 of the License, or			*
 *   (at your option) any later version.																*
 *																															*
 *********************************************************************************/

#ifndef KBEARFTPVIEW_H
#define KBEARFTPVIEW_H

//////////////////////////////////////////////////////
// Qt specific includes
#include <qvbox.h>
#include <qhbox.h>
#include <qdatetime.h>
#include <qevent.h>
#include <qstatusbar.h>
#include <qprogressbar.h>
#include <qlabel.h>
#include <qwhatsthis.h>
#include <qsplitter.h>
#include <qtoolbutton.h>
#include <qstring.h>
#include <qlistview.h>
#include <qiconview.h>
#include <qnamespace.h>
#include <qtimer.h>
#include <qobjcoll.h>
#include <qapplication.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <kurifilter.h>
#include <kcombobox.h>
#include <kapp.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kurl.h>
#include <kfilereader.h>
#include <kfileview.h>
#include <kfileviewitem.h>
#include <klineeditdlg.h>
#include <ktoolbar.h>
#include <kprogress.h>
#include <kstdaccel.h>
#include <kstdaction.h>
#include <kaction.h>
#include <kprotocolmanager.h>
#include <kanimwidget.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "qextmdichildview.h"
#include "kbeardirview.h"
#include <stdio.h>

class KBear;
class KBearDirOperator;

/**
	*This class is a container for the different view types.
	*It manages communication between views and also between the view and the app
	*It offers a toolbar and some useful information in the statusbar
	*@see KBearDirView
	*@see KBearDirOperator
	*@see KBear
	*
	*@short This class is a container for the different view types
	*@author Bjrn Sahlstrm
*/

class KBearFtpView : public QextMdiChildView {
    Q_OBJECT
    friend class KBearDirOperator;
public:
	/**Constructor*/
	KBearFtpView( KBear* app, QWidget* parent, QString name );
	/**Destructor*/
	~KBearFtpView();
	/**
	*@returns the current url of the view
	*/
	KURL getCurrentURL() const;
	/**
	*@returns a list of @ref KFileViewItem representing all selected items in the view
	 */
	const KFileViewItemList * selectedItems() const;
	/**
	*@returns the @ref KBearDirOperator that works for this view
	*/
	KBearDirOperator* myOperator() { return ( dirOperator ? dirOperator : 0L ); }
	/**
	*Showes / hides the directory tree view
	*@see KBearDirView
	*@param hide set this to true to show directory tree view
	*/
	void showTreeView(bool show);
	/**
	*@returns a pointer to the @ref KBear instance
	*/
	KBear* myApp() { return myKBearApp; }
	/**
	*@returns a @ref KURL::List containing the URL:s of all highlighted items in the view
	*/
	KURL::List myHighlightedItems();
signals: // Signals
	/** emitted when the user tries to close the Local Filesystem view */
	void localFileSysCloseRequest();
	/** emitted whenever the view position or size is changed */
	void viewPositionChanged();
public slots:
   /** */
   virtual void show();
	
	/**
	* this slot is called when current directory is changed
	*@param url holds the new path
	* @see KBearDirView#folderSelected()
	**/
	void slotDirChanged( const QString& url );
	/**
	* this slot is called to connect the remote host and initialize the file view
	*@param host holds the hostname
	*@param port holds the port number
	*@param anonym is true if anonymous login is selected
	*@param user holds the user name
	*@param pass holds the password
	*@param path holds the selected initial path
	*@see KBearSiteManager
	**/
	void slotConnectRemote(const QString& host,const int& port,bool anonym,
						const QString& user,const QString& pass,const QString& path);
	/**
	* this slot is called to open the local filesystem and initialize the file view
	*@param localPath holds the initial path
	**/
	void slotConnectLocal(QString localPath);
	/** displays a status message in sthe statusbar */
	void slotStatusMsg( KIO::Job*, const QString&);
	/**  this slot is called when the @ref KBearDirOperator has finished loading a directory */
	void slotFinishedLoading();
	/**  */
	void slotDirChanged( QListViewItem* );
	/** called when an item is dropped in either the left tree view or the right detailed view  */
	void dropped( KURL::List urlList );
	/** */
   virtual void youAreDetached();


protected: // methods
	/**
	* Ignores the event and calls @ref QextMdiMainFrm::childWindowCloseRequest instead. This is because the
	* mainframe has control over the views. Therefore the MDI view has to request the mainframe for a close.
	*/
	virtual void closeEvent(QCloseEvent *e);
	/**
	* Updates the view if a resizeEvent occures
	*@see QResizeEvent
	**/
	virtual void resizeEvent ( QResizeEvent * );
	/**  */
	void setupConnection();
	/**  */
	virtual void moveEvent ( QMoveEvent * );	
protected slots :
	/**  */
	void slotSetPathCombo(const KURL &url);
	/**  */
	void slotInsertItems( const KFileItemList& list );
	/**  */
	void slotStartLoadingDir();
	/**  */
	void slotUpdateDirsAndFiles( int, int );
	/**  */
	void slotDirViewRightPressed(/* QListViewItem*, const QPoint&, int */);
	/**
	*Show / hides the tree view
	*/
	void slotToggleTreeView( bool );
	/**  */
	void slotFilterChanged( const QString& );
	/**  */
	void slotConnectResult( KIO::Job* job );
	/**  */
	void slotUpdateClock();

private: // methods
	/** Sets up the GUI */
	void setup();
private: // attributes
	KToolBar* toolBarUpper;
	QDateTime* t_myTime;
	KToolBar* toolBarLower;
	QSplitter* splitter;
	QSplitter* transSplitter;
	QVBox* vBox;
	QLabel* statusBarUpper;
	QHBox* statusBarLower;
	QLabel* statusLabel;
	QLabel* directoryLabel;
	QLabel* fileLabel;
	QLabel* timeLabel;
	KListView* leftView;
	KURL url;
	KBearDirOperator* dirOperator;
	ButtonState myKey;
	KBear* myKBearApp;
	KComboBox* pathCombo;
	KAnimWidget* myAnimWidget;
};

#endif
