/***************************************************************************
                          lineitem.cpp  -  description
                             -------------------
    begin                : Mon Apr 16 2001
    copyright            : (C) 2003 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <math.h>
#include <klocale.h>
#include <ksimpleconfig.h>
#include "kgraph.h"
#include "kplchecklistitem.h"
#include "linedlg.h"
#include "lineitem.h"

LineItem::LineItem() : symb(1)
{
}

LineItem::LineItem(Kpl::AutoStruct* aut) :
 ArrowItem(aut), symb(1)
{
}

LineItem::LineItem(KSimpleConfig* plo, Kpl::AutoStruct* aut) :
 ArrowItem(plo, aut)
{
  symb = plo->readNumEntry("symb", 1);
}

LineItem::LineItem(bool act, int iSymb, const QString& col,
                   double x, double y, double d, double l, double relSize) :
 ArrowItem(act, col, x, y, d, l, relSize), symb(iSymb)
{
}

LineItem::~LineItem()
{
}

KplItem::ItemTypes LineItem::iType() const
{
  return Line;
}

void LineItem::draw(KplGraph* g)
{
  if (!g->type())
    bRect.setRect(0, 0, 0, 0);
  if (active) {
    g->setColData(color);
    g->setSymbol(symb);
    double xa[2], ya[2];
    g->cm2r(x0, y0, 1.0, 1.0, &xa[0], &ya[0]);
    double a = 0.0174532925 * dir;
    double x1 = x0 + len * cos(a);
    double y1 = y0 + len * sin(a);
    g->cm2r(x1, y1, 1.0, 1.0, &xa[1], &ya[1]);
    double sav = g->setRelSize(relsiz);
    g->plArray(xa, ya, 1.0, 1.0, 2, false);
    g->setRelSize(sav);
    if (!g->type()) {
      KGraph* gr = (KGraph*) g;
      bRect = QRect(gr->fromcm(QMIN(x0, x1) - 0.1, QMAX(y0, y1) + 0.1),
                    gr->fromcm(QMAX(x0, x1) + 0.1, QMIN(y0, y1) - 0.1));
    }
  }
}

void LineItem::writePlo(KSimpleConfig* plo, const KURL& url, bool abs,
                        KplDoc* m) const
{
  ArrowItem::writePlo(plo, url, abs, m);
  plo->writeEntry("Type", "LINEITEM");
  plo->writeEntry("symb", symb);
}

void LineItem::setText(KplCheckListItem* it, bool*, bool*) const
{
  it->setText(1, i18n("Line"));
  QString s1, s2;
  it->setText(2, s1.sprintf("x = %g cm, y = %g cm, ", x0, y0) +
              i18n("direction") + s2.sprintf(" %g", dir));
}

int LineItem::editItem(QWidget* parent, KplDoc* m, int)
{
  LineDlg dlg(parent, m, this);
  return dlg.exec();
}

KplItem* LineItem::copy() const
{
  return new LineItem(*this);
}
