//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    using System.Text;
    using System.Collections.Generic;
    /// <remarks>
    ///  The KFontDialog provides a dialog for interactive font selection.
    ///  It is basically a thin wrapper around the KFontChooser widget,
    ///  which can also be used standalone. In most cases, the simplest
    ///  use of this class is the static method KFontDialog.GetFont(),
    ///  which pops up the dialog, allows the user to select a font, and
    ///  returns when the dialog is closed.
    ///  Example:
    ///  <pre>
    ///       QFont myFont;
    ///       int result = KFontDialog.GetFont( myFont );
    ///       if ( result == KFontDialog.Accepted )
    ///             ...
    ///  </pre>
    ///  \image html kfontdialog.png "KDE Font Dialog"
    ///  See <see cref="IKFontDialogSignals"></see> for signals emitted by KFontDialog
    /// </remarks>        <author> Preston Brown <pbrown@kde.org>, Bernd Wuebben <wuebben@kde.org>
    ///  </author>
    ///         <short> A font selection dialog. </short>
    [SmokeClass("KFontDialog")]
    public class KFontDialog : KDialog, IDisposable {
        protected KFontDialog(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KFontDialog), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static KFontDialog() {
            staticInterceptor = new SmokeInvocation(typeof(KFontDialog), null);
        }
        /// <remarks>
        ///  Constructs a font selection dialog.
        /// <param> name="parent" The parent widget of the dialog, if any.
        /// </param><param> name="flags" Defines how the font chooser is displayed.
        /// </param><param> name="onlyFixed" only display fonts which have fixed-width
        ///         character sizes.
        /// </param><param> name="fontlist" a list of fonts to display, in XLFD format.  If
        ///         no list is formatted, the internal KDE font list is used.
        ///         If that has not been created, X is queried, and all fonts
        ///         available on the system are displayed.
        /// </param><param> name="makeFrame" Draws a frame with titles around the contents.
        /// </param><param> name="diff" Display the difference version dialog. See getFontDiff().
        /// </param><param> name="sizeIsRelativeState" If not zero the widget will show a
        ///         checkbox where the user may choose whether the font size
        ///         is to be interpreted as relative size.
        ///         Initial state of this checkbox will be set according to
        ///         sizeIsRelativeState, user choice may be retrieved by
        ///         calling sizeIsRelative().
        /// </param>   </remarks>        <short>    Constructs a font selection dialog.</short>
        ///         <see> KFontChooser.DisplayFlags</see>
        public KFontDialog(QWidget parent, uint flags, List<string> fontlist, Qt.CheckState sizeIsRelativeState) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KFontDialog#$?$", "KFontDialog(QWidget*, const KFontChooser::DisplayFlags&, const QStringList&, Qt::CheckState*)", typeof(void), typeof(QWidget), parent, typeof(uint), flags, typeof(List<string>), fontlist, typeof(Qt.CheckState), sizeIsRelativeState);
        }
        public KFontDialog(QWidget parent, uint flags, List<string> fontlist) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KFontDialog#$?", "KFontDialog(QWidget*, const KFontChooser::DisplayFlags&, const QStringList&)", typeof(void), typeof(QWidget), parent, typeof(uint), flags, typeof(List<string>), fontlist);
        }
        public KFontDialog(QWidget parent, uint flags) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KFontDialog#$", "KFontDialog(QWidget*, const KFontChooser::DisplayFlags&)", typeof(void), typeof(QWidget), parent, typeof(uint), flags);
        }
        public KFontDialog(QWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KFontDialog#", "KFontDialog(QWidget*)", typeof(void), typeof(QWidget), parent);
        }
        public KFontDialog() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KFontDialog", "KFontDialog()", typeof(void));
        }
        /// <remarks>
        ///  Sets the currently selected font in the dialog.
        /// <param> name="font" The font to select.
        /// </param><param> name="onlyFixed" readjust the font list to display only fixed
        ///         width fonts if true, or vice-versa
        ///    </param></remarks>        <short>    Sets the currently selected font in the dialog.</short>
        public void SetFont(QFont font, bool onlyFixed) {
            interceptor.Invoke("setFont#$", "setFont(const QFont&, bool)", typeof(void), typeof(QFont), font, typeof(bool), onlyFixed);
        }
        public void SetFont(QFont font) {
            interceptor.Invoke("setFont#", "setFont(const QFont&)", typeof(void), typeof(QFont), font);
        }
        /// <remarks>
        /// </remarks>        <return> The currently selected font in the dialog.
        ///    </return>
        ///         <short>   </short>
        public new QFont Font() {
            return (QFont) interceptor.Invoke("font", "font() const", typeof(QFont));
        }
        /// <remarks>
        ///  Sets the state of the checkbox indicating whether the font size
        ///  is to be interpreted as relative size.
        ///  NOTE: If parameter sizeIsRelative was not set in the constructor
        ///        of the dialog this setting will be ignored.
        ///    </remarks>        <short>    Sets the state of the checkbox indicating whether the font size  is to be interpreted as relative size.</short>
        public void SetSizeIsRelative(Qt.CheckState relative) {
            interceptor.Invoke("setSizeIsRelative$", "setSizeIsRelative(Qt::CheckState)", typeof(void), typeof(Qt.CheckState), relative);
        }
        /// <remarks>
        /// </remarks>        <return> Whether the font size is to be interpreted as relative size
        ///          (default: false)
        ///    </return>
        ///         <short>   </short>
        public Qt.CheckState SizeIsRelative() {
            return (Qt.CheckState) interceptor.Invoke("sizeIsRelative", "sizeIsRelative() const", typeof(Qt.CheckState));
        }
        ~KFontDialog() {
            interceptor.Invoke("~KFontDialog", "~KFontDialog()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~KFontDialog", "~KFontDialog()", typeof(void));
        }
        /// <remarks>
        ///  Creates a modal font dialog, lets the user choose a font,
        ///  and returns when the dialog is closed.
        /// <param> name="theFont" a reference to the font to write the chosen font
        ///         into.
        /// </param><param> name="flags" Defines how the font chooser is displayed.
        /// </param><param> name="parent" Parent widget of the dialog. Specifying a widget different
        ///         from 0 (Null) improves centering (looks better).
        /// </param><param> name="makeFrame" Draws a frame with titles around the contents.
        /// </param><param> name="sizeIsRelativeState" If not zero the widget will show a
        ///         checkbox where the user may choose whether the font size
        ///         is to be interpreted as relative size.
        ///         Initial state of this checkbox will be set according to
        ///         sizeIsRelativeState and user choice will be returned
        ///         therein.
        /// </param></remarks>        <return> QDialog.Result().
        ///    </return>
        ///         <short>    Creates a modal font dialog, lets the user choose a font,  and returns when the dialog is closed.</short>
        ///         <see> KFontChooser.DisplayFlags</see>
        public static int GetFont(QFont theFont, uint flags, QWidget parent, Qt.CheckState sizeIsRelativeState) {
            return (int) staticInterceptor.Invoke("getFont#$#$", "getFont(QFont&, const KFontChooser::DisplayFlags&, QWidget*, Qt::CheckState*)", typeof(int), typeof(QFont), theFont, typeof(uint), flags, typeof(QWidget), parent, typeof(Qt.CheckState), sizeIsRelativeState);
        }
        public static int GetFont(QFont theFont, uint flags, QWidget parent) {
            return (int) staticInterceptor.Invoke("getFont#$#", "getFont(QFont&, const KFontChooser::DisplayFlags&, QWidget*)", typeof(int), typeof(QFont), theFont, typeof(uint), flags, typeof(QWidget), parent);
        }
        public static int GetFont(QFont theFont, uint flags) {
            return (int) staticInterceptor.Invoke("getFont#$", "getFont(QFont&, const KFontChooser::DisplayFlags&)", typeof(int), typeof(QFont), theFont, typeof(uint), flags);
        }
        public static int GetFont(QFont theFont) {
            return (int) staticInterceptor.Invoke("getFont#", "getFont(QFont&)", typeof(int), typeof(QFont), theFont);
        }
        /// <remarks>
        ///  Creates a modal font difference dialog, lets the user choose a selection
        ///  of changes that should be made to a set of fonts, and returns when the
        ///  dialog is closed. Useful for choosing slight adjustments to the font set
        ///  when the user would otherwise have to manually edit a number of fonts.
        /// <param> name="theFont" a reference to the font to write the chosen font
        ///         into.
        /// </param><param> name="flags" Defines how the font chooser is displayed.
        /// </param><param> name="diffFlags" a reference to the int into which the chosen
        ///         difference selection bitmask should be written.
        ///         Check the returned bitmask like:
        ///         <pre>
        ///         if ( diffFlags & KFontChooser.FontDiffFamily )
        ///             [...]
        ///         if ( diffFlags & KFontChooser.FontDiffStyle )
        ///             [...]
        ///         if ( diffFlags & KFontChooser.FontDiffSize )
        ///             [...]
        ///         </pre>
        /// </param><param> name="parent" Parent widget of the dialog. Specifying a widget different
        ///         from 0 (Null) improves centering (looks better).
        /// </param><param> name="sizeIsRelativeState" If not zero the widget will show a
        ///         checkbox where the user may choose whether the font size
        ///         is to be interpreted as relative size.
        ///         Initial state of this checkbox will be set according to
        ///         sizeIsRelativeState and user choice will be returned
        ///         therein.
        /// </param></remarks>        <return> QDialog.Result().
        ///    </return>
        ///         <short>    Creates a modal font difference dialog, lets the user choose a selection  of changes that should be made to a set of fonts, and returns when the  dialog is closed.</short>
        ///         <see> KFontChooser.DisplayFlags</see>
        public static int GetFontDiff(QFont theFont, uint diffFlags, uint flags, QWidget parent, Qt.CheckState sizeIsRelativeState) {
            return (int) staticInterceptor.Invoke("getFontDiff#$$#$", "getFontDiff(QFont&, KFontChooser::FontDiffFlags&, const KFontChooser::DisplayFlags&, QWidget*, Qt::CheckState*)", typeof(int), typeof(QFont), theFont, typeof(uint), diffFlags, typeof(uint), flags, typeof(QWidget), parent, typeof(Qt.CheckState), sizeIsRelativeState);
        }
        public static int GetFontDiff(QFont theFont, uint diffFlags, uint flags, QWidget parent) {
            return (int) staticInterceptor.Invoke("getFontDiff#$$#", "getFontDiff(QFont&, KFontChooser::FontDiffFlags&, const KFontChooser::DisplayFlags&, QWidget*)", typeof(int), typeof(QFont), theFont, typeof(uint), diffFlags, typeof(uint), flags, typeof(QWidget), parent);
        }
        public static int GetFontDiff(QFont theFont, uint diffFlags, uint flags) {
            return (int) staticInterceptor.Invoke("getFontDiff#$$", "getFontDiff(QFont&, KFontChooser::FontDiffFlags&, const KFontChooser::DisplayFlags&)", typeof(int), typeof(QFont), theFont, typeof(uint), diffFlags, typeof(uint), flags);
        }
        public static int GetFontDiff(QFont theFont, uint diffFlags) {
            return (int) staticInterceptor.Invoke("getFontDiff#$", "getFontDiff(QFont&, KFontChooser::FontDiffFlags&)", typeof(int), typeof(QFont), theFont, typeof(uint), diffFlags);
        }
        /// <remarks>
        ///  When you are not only interested in the font selected, but also
        ///  in the example string typed in, you can call this method.
        /// <param> name="theFont" a reference to the font to write the chosen font
        ///         into.
        /// </param><param> name="theString" a reference to the example text that was typed.
        /// </param><param> name="flags" Defines how the font chooser is displayed.
        /// </param><param> name="parent" Parent widget of the dialog. Specifying a widget different
        ///         from 0 (Null) improves centering (looks better).
        /// </param><param> name="sizeIsRelativeState" If not zero the widget will show a
        ///         checkbox where the user may choose whether the font size
        ///         is to be interpreted as relative size.
        ///         Initial state of this checkbox will be set according to
        ///         sizeIsRelativeState and user choice will be returned
        ///         therein.
        /// </param></remarks>        <return> The result of the dialog.
        ///    </return>
        ///         <short>    When you are not only interested in the font selected, but also  in the example string typed in, you can call this method.</short>
        ///         <see> KFontChooser.DisplayFlags</see>
        public static int GetFontAndText(QFont theFont, StringBuilder theString, uint flags, QWidget parent, Qt.CheckState sizeIsRelativeState) {
            return (int) staticInterceptor.Invoke("getFontAndText#$$#$", "getFontAndText(QFont&, QString&, const KFontChooser::DisplayFlags&, QWidget*, Qt::CheckState*)", typeof(int), typeof(QFont), theFont, typeof(StringBuilder), theString, typeof(uint), flags, typeof(QWidget), parent, typeof(Qt.CheckState), sizeIsRelativeState);
        }
        public static int GetFontAndText(QFont theFont, StringBuilder theString, uint flags, QWidget parent) {
            return (int) staticInterceptor.Invoke("getFontAndText#$$#", "getFontAndText(QFont&, QString&, const KFontChooser::DisplayFlags&, QWidget*)", typeof(int), typeof(QFont), theFont, typeof(StringBuilder), theString, typeof(uint), flags, typeof(QWidget), parent);
        }
        public static int GetFontAndText(QFont theFont, StringBuilder theString, uint flags) {
            return (int) staticInterceptor.Invoke("getFontAndText#$$", "getFontAndText(QFont&, QString&, const KFontChooser::DisplayFlags&)", typeof(int), typeof(QFont), theFont, typeof(StringBuilder), theString, typeof(uint), flags);
        }
        public static int GetFontAndText(QFont theFont, StringBuilder theString) {
            return (int) staticInterceptor.Invoke("getFontAndText#$", "getFontAndText(QFont&, QString&)", typeof(int), typeof(QFont), theFont, typeof(StringBuilder), theString);
        }
        protected new IKFontDialogSignals Emit {
            get { return (IKFontDialogSignals) Q_EMIT; }
        }
    }

    public interface IKFontDialogSignals : IKDialogSignals {
        /// <remarks>
        ///  Emitted whenever the currently selected font changes.
        ///  Connect to this to monitor the font as it is selected if you are
        ///  not running modal.
        ///    </remarks>        <short>    Emitted whenever the currently selected font changes.</short>
        [Q_SIGNAL("void fontSelected(QFont)")]
        void FontSelected(QFont font);
    }
}
