//Auto-generated by kalyptus. DO NOT EDIT.
namespace Akonadi {
    using Kimono;
    using System;
    using Qyoto;
    /// <remarks>
    ///  This class is responsible for recording change notification during
    ///  an agent is not online and replay the notifications when the agent
    ///  is online again. Therefor the agent doesn't have to care about
    ///  online/offline mode in its synchronization algorithm.
    ///  See <see cref="IChangeRecorderSignals"></see> for signals emitted by ChangeRecorder
    /// </remarks>        <author> Volker Krause <vkrause@kde.org>
    ///  </author>
    ///         <short> Records and replays change notification. </short>
    [SmokeClass("Akonadi::ChangeRecorder")]
    public class ChangeRecorder : Akonadi.Monitor, IDisposable {
        protected ChangeRecorder(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(ChangeRecorder), this);
        }
        /// <remarks>
        ///  Creates a new change recorder.
        ///      </remarks>        <short>    Creates a new change recorder.</short>
        public ChangeRecorder(QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("ChangeRecorder#", "ChangeRecorder(QObject*)", typeof(void), typeof(QObject), parent);
        }
        public ChangeRecorder() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("ChangeRecorder", "ChangeRecorder()", typeof(void));
        }
        /// <remarks>
        ///  Sets the QSettings object used for persisting recorded changes.
        ///      </remarks>        <short>    Sets the QSettings object used for persisting recorded changes.</short>
        public void SetConfig(QSettings settings) {
            interceptor.Invoke("setConfig#", "setConfig(QSettings*)", typeof(void), typeof(QSettings), settings);
        }
        /// <remarks>
        ///  Returns whether there are recorded changes.
        ///      </remarks>        <short>    Returns whether there are recorded changes.</short>
        public bool IsEmpty() {
            return (bool) interceptor.Invoke("isEmpty", "isEmpty() const", typeof(bool));
        }
        /// <remarks>
        ///  Removes the previously emitted change from the records.
        ///      </remarks>        <short>    Removes the previously emitted change from the records.</short>
        public void ChangeProcessed() {
            interceptor.Invoke("changeProcessed", "changeProcessed()", typeof(void));
        }
        /// <remarks>
        ///  Enables change recording. If change recording is disabled, this class
        ///  behaves exactly like Akonadi.Monitor.
        ///  Change recording is enabled by default.
        ///      </remarks>        <short>    Enables change recording.</short>
        public void SetChangeRecordingEnabled(bool enable) {
            interceptor.Invoke("setChangeRecordingEnabled$", "setChangeRecordingEnabled(bool)", typeof(void), typeof(bool), enable);
        }
        /// <remarks>
        ///  Replay the next change notification and erase the previous one from the record.
        ///      </remarks>        <short>    Replay the next change notification and erase the previous one from the record.</short>
        [Q_SLOT("void replayNext()")]
        public void ReplayNext() {
            interceptor.Invoke("replayNext", "replayNext()", typeof(void));
        }
        ~ChangeRecorder() {
            interceptor.Invoke("~ChangeRecorder", "~ChangeRecorder()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~ChangeRecorder", "~ChangeRecorder()", typeof(void));
        }
        protected new IChangeRecorderSignals Emit {
            get { return (IChangeRecorderSignals) Q_EMIT; }
        }
    }

    public interface IChangeRecorderSignals : Akonadi.IMonitorSignals {
        /// <remarks>
        ///  Emitted when new changes are recorded.
        ///      </remarks>        <short>    Emitted when new changes are recorded.</short>
        [Q_SIGNAL("void changesAdded()")]
        void ChangesAdded();
    }
}
