/*############################################################################*/
/*#                                                                          #*/
/*#  MIT HRTF C Library                                                      #*/
/*#  Filter table for normal set at 96000Hz                                  #*/
/*#  Copyright © 2007 Aristotel Digenis                                      #*/
/*#                                                                          #*/
/*#  Filename:  mit_hrtf_normal_96000.h                                      #*/
/*#  Version:   0.1                                                          #*/
/*#  Date:      04/05/2007                                                   #*/
/*#  Author(s): Aristotel Digenis                                            #*/
/*#  Credit:    Bill Gardner and Keith Martin                                #*/
/*#  Licence:   MIT                                                          #*/
/*#                                                                          #*/
/*############################################################################*/


#include "../mit_hrtf_filter.h"

const mit_hrtf_filter_set_96 normal_96 = 
{
    {    // elev-10 
        {    // H-10e000a.wav
            {8,-4,-12,3,23,11,-24,-27,15,36,-10,-59,-20,63,53,-61,-104,19,129,26,-145,-79,141,109,18,1080,4124,7571,7752,2474,-5657,-10567,-8386,-1615,3133,1829,-3011,-5281,-1673,5380,10676,11169,7837,3845,2015,3716,8551,13997,15970,11436,1498,-8382,-12231,-8403,-935,3815,2147,-4544,-11363,-13721,-10395,-4016,1013,1618,-1923,-6469,-8565,-6952,-3044,672,2578,2594,1541,312,-411,-152,1181,3031,4390,4496,3455,2167,1615,2118,3127,3666,3049,1401,-415,-1420,-1232,-307,468,440,-455,-1802,-3044,-3745,-3740,-3207,-2617,-2461,-2875,-3495,-3747,-3324,-2440,-1625,-1277,-1344,-1406,-1044,-192,821,1550,1787,1678,1534,1554,1720,1896,1977,1938,1797,1586,1339,1083,828,591,409,306,233,78,-231,-622,-927,-1031,-979,-922,-981,-1161,-1373,-1507,-1496,-1351,-1157,-1015,-966,-968,-936,-817,-617,-378,-156,-4,55,61,103,247,467,665,766,770,725,671,615,558,511,478,435,348,204,19,-169,-318,-394,-395,-370,-390,-488,-624,-712,-692,-584,-466,-412,-442,-511,-556,-533,-446,-329,-217,-128,-68,-34,-14,22,96,193,262,261,196,128,112,155,221,269,277,245,182,102,29,-17,-41,-75,-146,-246,-344,-406,-432,-439,-440,-435,-421,-399,-377,-354,-320,-266,-196,-126,-72,-37,-15,6,35,68,93,96,76,46,22,13,14,17,14,6,-9,-24,-34,-41,-55,-83,-121,-153,-169,-173,-172,-170,-162,-148,-133,-118,-97,-72,-56,-59,-71,-66,-37,-6,4,-2,4,30,55,51,21},
            {8,-4,-12,3,23,11,-24,-27,15,36,-10,-59,-20,63,53,-61,-104,19,129,26,-145,-79,141,109,18,1080,4124,7571,7752,2474,-5657,-10567,-8386,-1615,3133,1829,-3011,-5281,-1673,5380,10676,11169,7837,3845,2015,3716,8551,13997,15970,11436,1498,-8382,-12231,-8403,-935,3815,2147,-4544,-11363,-13721,-10395,-4016,1013,1618,-1923,-6469,-8565,-6952,-3044,672,2578,2594,1541,312,-411,-152,1181,3031,4390,4496,3455,2167,1615,2118,3127,3666,3049,1401,-415,-1420,-1232,-307,468,440,-455,-1802,-3044,-3745,-3740,-3207,-2617,-2461,-2875,-3495,-3747,-3324,-2440,-1625,-1277,-1344,-1406,-1044,-192,821,1550,1787,1678,1534,1554,1720,1896,1977,1938,1797,1586,1339,1083,828,591,409,306,233,78,-231,-622,-927,-1031,-979,-922,-981,-1161,-1373,-1507,-1496,-1351,-1157,-1015,-966,-968,-936,-817,-617,-378,-156,-4,55,61,103,247,467,665,766,770,725,671,615,558,511,478,435,348,204,19,-169,-318,-394,-395,-370,-390,-488,-624,-712,-692,-584,-466,-412,-442,-511,-556,-533,-446,-329,-217,-128,-68,-34,-14,22,96,193,262,261,196,128,112,155,221,269,277,245,182,102,29,-17,-41,-75,-146,-246,-344,-406,-432,-439,-440,-435,-421,-399,-377,-354,-320,-266,-196,-126,-72,-37,-15,6,35,68,93,96,76,46,22,13,14,17,14,6,-9,-24,-34,-41,-55,-83,-121,-153,-169,-173,-172,-170,-162,-148,-133,-118,-97,-72,-56,-59,-71,-66,-37,-6,4,-2,4,30,55,51,21}
        },
        {    // H-10e005a.wav
            {-2,4,7,-2,-10,1,17,9,-18,-21,12,29,-8,-47,-16,52,45,-47,-84,14,104,24,-115,-63,116,95,38,961,3575,6572,6844,2461,-4472,-8827,-7199,-1557,2520,1484,-2666,-4733,-1759,4317,9068,9797,7217,3933,2290,3474,7323,11967,14079,10877,2830,-5792,-9846,-7442,-1481,2792,1926,-3386,-9287,-11796,-9522,-4355,68,974,-1682,-5444,-7406,-6358,-3298,-197,1590,1895,1263,338,-317,-217,831,2428,3705,3938,3150,2100,1669,2155,3060,3488,2851,1324,-279,-1123,-960,-239,309,210,-538,-1610,-2590,-3137,-3099,-2623,-2136,-2070,-2513,-3102,-3311,-2885,-2036,-1252,-919,-1046,-1294,-1244,-711,126,889,1299,1357,1269,1223,1264,1341,1408,1461,1491,1466,1353,1154,908,675,503,398,298,112,-191,-528,-762,-823,-774,-755,-859,-1075,-1305,-1436,-1411,-1257,-1070,-944,-902,-893,-843,-720,-535,-323,-124,15,65,56,71,178,362,540,641,650,603,535,469,424,412,419,405,337,208,40,-135,-282,-361,-358,-312,-302,-378,-511,-616,-628,-555,-460,-405,-405,-435,-456,-442,-392,-319,-242,-180,-143,-126,-110,-67,15,118,195,207,164,112,101,141,204,252,263,235,179,112,52,11,-18,-60,-129,-216,-293,-338,-351,-347,-340,-334,-329,-322,-313,-301,-281,-252,-213,-165,-116,-76,-51,-33,-12,14,33,33,14,-12,-34,-49,-56,-53,-40,-26,-22,-28,-36,-39,-40,-49,-65,-81,-92,-99,-104,-108,-107,-102,-94,-84,-74,-68,-70,-77,-81,-76,-65,-49,-30,-9,8,13,6},
            {-9,2,23,15,-23,-35,8,45,3,-66,-43,60,80,-44,-132,-18,147,80,-145,-145,124,178,-36,691,3678,7847,9233,4495,-4659,-11640,-10889,-3696,2796,2842,-2138,-5489,-2515,5026,11358,12457,8941,4333,1945,3408,8468,14674,17646,13572,2869,-8792,-14279,-10783,-2206,4112,3280,-3762,-11665,-15001,-11937,-5013,975,2323,-1177,-6384,-9333,-8138,-3960,447,2988,3278,2130,583,-517,-522,821,2992,4786,5117,3902,2169,1247,1751,3159,4234,3941,2198,-54,-1538,-1576,-537,533,743,-107,-1589,-3063,-4013,-4203,-3754,-3131,-2900,-3307,-4031,-4421,-4036,-3011,-1920,-1292,-1214,-1310,-1084,-319,760,1685,2120,2098,1924,1882,2031,2244,2372,2351,2185,1908,1565,1204,858,559,341,221,144,-12,-326,-732,-1047,-1139,-1049,-950,-989,-1179,-1416,-1568,-1554,-1386,-1162,-1008,-980,-1027,-1040,-945,-744,-486,-230,-36,59,76,104,233,460,688,816,822,762,694,643,606,583,563,517,416,257,63,-132,-295,-388,-400,-368,-374,-477,-643,-766,-765,-653,-527,-473,-501,-557,-578,-538,-446,-324,-202,-105,-55,-46,-46,-6,98,235,336,348,279,191,149,168,222,272,292,268,197,97,7,-41,-54,-76,-146,-255,-362,-434,-474,-499,-515,-515,-497,-472,-446,-410,-354,-277,-194,-117,-53,-7,18,28,42,72,110,133,126,98,68,51,48,50,48,37,20,5,-4,-13,-30,-63,-107,-156,-199,-228,-238,-233,-225,-217,-203,-172,-128,-87,-63,-54,-50,-38,-16,13,36,41,28,21,41,83,109,87,33}
        },
        {    // H-10e010a.wav
            {-3,-4,-1,5,4,-4,-8,3,14,5,-16,-15,13,23,-9,-38,-9,42,29,-44,-65,17,80,8,-91,-32,103,63,60,972,3303,5814,5877,2021,-3825,-7376,-5963,-1363,1853,946,-2324,-3788,-1221,3726,7575,8296,6458,3987,2637,3447,6507,10427,12406,9952,3283,-4111,-7892,-6330,-1649,1908,1415,-2767,-7646,-9959,-8400,-4328,-656,269,-1729,-4740,-6405,-5679,-3273,-706,927,1401,1044,329,-235,-172,714,2083,3199,3458,2864,2024,1660,2054,2836,3253,2745,1387,-133,-1036,-1023,-441,65,47,-526,-1383,-2175,-2628,-2624,-2272,-1891,-1817,-2137,-2592,-2769,-2439,-1729,-1026,-680,-764,-1036,-1136,-855,-269,351,765,925,943,953,1009,1097,1190,1266,1301,1267,1142,938,698,488,358,300,237,81,-182,-469,-665,-722,-695,-685,-761,-926,-1116,-1243,-1239,-1109,-933,-805,-757,-746,-704,-602,-451,-274,-95,48,120,128,129,186,305,429,500,504,467,418,371,335,316,307,287,236,145,18,-126,-257,-335,-346,-321,-323,-386,-486,-557,-556,-496,-428,-393,-396,-414,-418,-391,-333,-261,-191,-144,-126,-130,-132,-100,-21,84,170,199,176,137,121,140,178,209,218,198,149,85,25,-15,-46,-89,-152,-221,-270,-288,-288,-285,-283,-280,-274,-273,-276,-273,-257,-226,-192,-160,-132,-109,-89,-74,-56,-37,-21,-19,-33,-55,-74,-80,-73,-59,-44,-36,-33,-29,-22,-13,-9,-10,-17,-32,-54,-77,-86,-78,-66,-63,-71,-76,-71,-66,-76,-98,-112,-104,-83,-62,-45,-28,-10},
            {17,20,-15,-40,-4,48,21,-62,-66,46,107,-10,-149,-70,142,144,-110,-203,71,241,-15,346,3041,7701,10431,6808,-2810,-11900,-13291,-6470,1546,3359,-1216,-5430,-3148,4848,12272,13899,9902,4439,1630,3264,8779,15519,19063,15310,4162,-8815,-15754,-12809,-3558,3955,3828,-3390,-11947,-15784,-12772,-5533,899,2576,-910,-6452,-9854,-8882,-4553,196,3002,3419,2374,936,-186,-423,631,2698,4610,5083,3883,2123,1323,2112,3766,4879,4442,2524,144,-1439,-1554,-522,629,922,52,-1560,-3182,-4229,-4488,-4135,-3643,-3536,-4027,-4787,-5126,-4550,-3198,-1771,-975,-982,-1326,-1316,-593,623,1764,2396,2504,2387,2321,2369,2444,2474,2453,2373,2191,1886,1494,1085,711,408,193,34,-167,-499,-919,-1250,-1336,-1200,-1034,-1023,-1199,-1447,-1611,-1601,-1433,-1214,-1066,-1039,-1078,-1073,-956,-736,-464,-196,17,131,152,158,249,448,675,823,857,820,765,704,635,570,527,492,422,282,79,-137,-305,-386,-383,-349,-361,-468,-643,-792,-833,-753,-622,-529,-514,-547,-558,-507,-403,-285,-187,-115,-64,-34,-20,7,82,207,330,382,342,261,213,231,288,332,330,282,202,101,0,-74,-111,-133,-182,-274,-382,-463,-502,-520,-539,-560,-565,-544,-505,-456,-394,-315,-222,-132,-57,-3,32,53,75,109,151,179,175,142,106,85,80,78,70,55,37,19,8,3,-7,-35,-85,-141,-187,-215,-231,-241,-248,-252,-247,-225,-182,-133,-97,-82,-69,-38,10,55,79,84,79,70,61,63,87,118,124,87,29}
        },
        {    // H-10e015a.wav
            {-3,-3,-3,-3,-1,3,3,-4,-7,2,11,4,-13,-12,8,17,-7,-28,-8,30,21,-34,-50,11,58,5,-67,-21,75,37,62,869,2856,5002,5142,2013,-2889,-6073,-5220,-1565,1254,856,-1614,-2923,-1130,2724,6023,7048,5971,4093,2803,3149,5501,8899,10978,9410,4044,-2401,-6204,-5556,-1931,1252,1326,-1813,-5951,-8329,-7564,-4467,-1341,-265,-1636,-4050,-5574,-5216,-3403,-1275,270,953,900,389,-167,-265,401,1621,2745,3166,2797,2104,1704,1878,2389,2693,2356,1379,203,-614,-790,-478,-99,-26,-383,-1041,-1741,-2213,-2299,-2041,-1682,-1520,-1692,-2058,-2301,-2173,-1688,-1113,-755,-735,-903,-977,-781,-367,65,362,520,637,776,917,1005,1014,965,888,801,709,609,498,385,290,221,153,36,-149,-361,-517,-568,-544,-528,-588,-728,-892,-1002,-1011,-929,-813,-718,-661,-624,-579,-512,-413,-276,-113,33,119,141,149,190,268,342,378,378,361,333,291,241,198,170,147,110,48,-38,-143,-246,-318,-338,-322,-317,-360,-440,-504,-510,-459,-392,-350,-346,-365,-379,-365,-318,-249,-176,-119,-84,-69,-62,-46,-7,51,105,132,126,111,110,133,166,186,180,145,89,28,-22,-54,-75,-102,-142,-193,-238,-268,-280,-279,-272,-266,-261,-256,-250,-242,-231,-217,-195,-167,-139,-116,-101,-91,-80,-70,-63,-60,-60,-63,-67,-71,-72,-65,-51,-38,-30,-27,-23,-13,-3,-2,-15,-36,-52,-60,-62,-62,-61,-55,-49,-51,-62,-74,-84,-99,-126,-149,-142,-94,-31},
            {4,-40,-27,37,42,-42,-85,10,114,37,-139,-129,96,190,-41,-240,-27,263,69,56,2133,6867,11034,9417,415,-10600,-15225,-10235,-1174,3246,180,-4775,-4086,3598,12439,15712,11994,5394,1234,2349,8295,16001,20625,17618,6289,-8073,-16965,-15227,-5589,3448,4641,-2432,-11869,-16717,-14087,-6451,810,3224,-78,-6150,-10458,-10077,-5545,-1,3473,3916,2427,663,-347,-293,765,2438,3924,4379,3640,2485,2030,2776,4195,5166,4789,2991,582,-1233,-1619,-683,603,1126,396,-1247,-3045,-4360,-4931,-4866,-4534,-4386,-4654,-5118,-5206,-4483,-3086,-1689,-974,-1095,-1555,-1605,-813,618,2033,2838,2923,2634,2398,2379,2477,2550,2556,2501,2358,2088,1710,1294,894,533,234,5,-209,-513,-932,-1326,-1501,-1407,-1212,-1146,-1291,-1539,-1714,-1712,-1548,-1313,-1128,-1063,-1092,-1101,-978,-704,-358,-51,141,202,175,159,255,487,765,951,978,890,778,690,622,560,508,458,380,240,43,-170,-343,-437,-446,-410,-403,-487,-653,-808,-851,-757,-605,-504,-501,-555,-585,-540,-424,-280,-151,-60,-12,0,-5,9,76,199,330,397,368,284,228,248,319,376,374,314,217,102,-15,-108,-160,-184,-226,-310,-415,-491,-517,-520,-532,-561,-581,-572,-536,-486,-426,-349,-258,-169,-99,-56,-31,-5,37,99,168,218,227,196,147,108,96,104,111,98,63,24,0,-6,-12,-37,-85,-139,-182,-209,-225,-237,-244,-245,-240,-228,-205,-171,-136,-113,-101,-80,-31,42,106,137,137,129,130,131,118,94,76,74,72,53,20}
        },
        {    // H-10e020a.wav
            {0,-1,-3,-3,-4,-4,-2,2,2,-3,-5,1,9,4,-10,-12,4,14,-2,-22,-10,19,17,-23,-39,4,44,11,-45,-20,49,25,56,710,2348,4215,4551,2169,-1930,-4929,-4670,-1797,828,955,-913,-2279,-1277,1680,4643,6012,5560,4108,2812,2755,4514,7489,9713,8997,4827,-795,-4663,-4839,-2102,817,1409,-855,-4405,-6884,-6833,-4602,-1953,-718,-1496,-3386,-4855,-4916,-3647,-1823,-239,663,796,350,-235,-405,178,1343,2489,3008,2728,2012,1454,1437,1871,2287,2208,1517,538,-233,-497,-326,-35,65,-173,-715,-1377,-1893,-2041,-1804,-1419,-1225,-1397,-1808,-2139,-2132,-1768,-1254,-861,-729,-784,-813,-645,-290,86,324,400,407,434,491,541,567,583,597,586,525,420,309,228,192,186,174,114,-12,-177,-321,-395,-404,-400,-445,-560,-715,-839,-873,-805,-683,-576,-521,-509,-502,-467,-387,-257,-100,37,109,113,99,123,195,274,316,310,277,234,187,140,102,77,56,19,-45,-132,-224,-296,-326,-307,-265,-243,-273,-346,-422,-455,-434,-381,-330,-303,-300,-303,-293,-262,-213,-156,-101,-59,-38,-31,-22,4,50,95,114,102,79,72,93,127,151,148,120,72,11,-53,-105,-135,-151,-169,-196,-226,-249,-262,-270,-274,-271,-259,-244,-231,-218,-198,-169,-138,-110,-90,-82,-88,-100,-105,-95,-74,-57,-48,-46,-47,-54,-64,-68,-59,-44,-36,-33,-28,-18,-14,-25,-42,-52,-51,-48,-43,-32,-17,-13,-28,-48,-56,-63,-93,-141,-164,-124,-45},
            {-40,30,59,-21,-99,-33,102,85,-98,-170,22,202,50,-224,-134,221,179,-97,1151,5369,10602,11593,4693,-7098,-15399,-14121,-5689,1376,1348,-3041,-4230,1643,10809,16147,14227,7769,2367,2007,7149,15094,21002,19816,9676,-5306,-16622,-17569,-8959,1315,4843,-614,-10141,-16435,-15477,-8682,-963,2909,1123,-4418,-9562,-10726,-7250,-1533,3073,4676,3603,1379,-564,-1367,-657,1345,3659,4969,4620,3227,2178,2439,3804,5159,5350,3952,1505,-798,-1827,-1258,184,1237,999,-542,-2688,-4598,-5720,-5929,-5488,-4897,-4597,-4638,-4646,-4194,-3243,-2218,-1612,-1544,-1653,-1405,-511,851,2153,2897,2957,2628,2337,2306,2461,2612,2656,2600,2461,2222,1868,1432,974,552,217,-9,-179,-409,-774,-1197,-1493,-1543,-1415,-1305,-1359,-1566,-1789,-1880,-1778,-1539,-1290,-1135,-1072,-1009,-852,-596,-314,-78,87,193,261,325,438,621,832,980,1008,934,823,717,626,547,486,436,365,234,29,-214,-428,-547,-548,-473,-417,-468,-628,-808,-886,-816,-655,-513,-461,-486,-524,-517,-447,-334,-208,-98,-18,27,49,75,133,233,346,417,407,326,237,203,244,318,363,341,253,125,-9,-118,-182,-217,-260,-339,-441,-524,-555,-545,-529,-526,-530,-530,-520,-496,-451,-382,-297,-213,-145,-95,-60,-37,-11,35,105,174,208,194,152,115,103,114,130,132,113,78,41,13,-12,-46,-92,-140,-175,-196,-208,-215,-222,-235,-252,-259,-239,-195,-155,-138,-132,-107,-49,28,97,145,172,180,174,166,161,149,117,72,42,41,53,47,19}
        },
        {    // H-10e025a.wav
            {-4,-2,1,0,-3,-5,-5,-4,-1,1,0,-4,-6,0,6,3,-8,-10,3,13,2,-17,-12,11,15,-13,-31,-3,32,13,-33,-23,29,21,42,530,1836,3465,4017,2344,-1018,-3859,-4141,-1963,480,1041,-344,-1792,-1464,756,3447,5085,5123,4015,2734,2355,3606,6198,8545,8600,5526,682,-3193,-4065,-2124,504,1497,-16,-3036,-5600,-6195,-4723,-2451,-1031,-1318,-2852,-4355,-4750,-3834,-2184,-593,401,647,315,-191,-383,54,1025,2046,2577,2416,1827,1327,1284,1663,2075,2089,1562,736,40,-226,-77,216,335,107,-436,-1097,-1620,-1818,-1686,-1410,-1254,-1377,-1718,-2033,-2067,-1748,-1238,-806,-621,-631,-640,-506,-260,-41,57,61,61,104,176,249,316,377,416,414,377,324,268,210,167,163,198,218,156,2,-183,-318,-377,-397,-430,-495,-572,-628,-640,-606,-542,-477,-434,-419,-417,-405,-358,-265,-140,-22,49,64,54,60,101,160,210,234,228,191,127,53,-7,-40,-56,-73,-104,-152,-212,-270,-304,-295,-252,-215,-224,-284,-356,-393,-376,-325,-275,-247,-243,-246,-236,-204,-158,-111,-76,-55,-45,-43,-36,-11,35,85,109,95,61,39,42,63,83,89,76,36,-28,-99,-156,-186,-196,-204,-216,-231,-240,-242,-241,-239,-235,-228,-212,-191,-167,-144,-122,-97,-75,-66,-70,-80,-84,-80,-75,-71,-66,-60,-55,-57,-61,-61,-56,-53,-56,-60,-60,-59,-61,-62,-54,-41,-30,-23,-16,-7,-4,-13,-23,-28,-36,-64,-109,-131,-102,-38},
            {48,-8,-85,-53,76,111,-39,-169,-50,170,128,-154,-204,129,262,-89,365,3580,9100,12541,8869,-1876,-12949,-16446,-10917,-2699,832,-1210,-3110,468,8510,14973,15153,9930,4279,2817,6871,14292,20608,20860,12514,-1720,-14352,-18119,-11921,-1985,3308,249,-7893,-14505,-15149,-10211,-3539,695,448,-3401,-7834,-9632,-7478,-2720,1856,4136,3806,1879,-349,-1783,-1598,396,3273,5321,5364,3845,2414,2387,3652,4998,5265,4130,2080,-8,-1272,-1247,-200,916,1042,-261,-2550,-4868,-6348,-6612,-5856,-4708,-3885,-3751,-4075,-4257,-3875,-3041,-2222,-1742,-1478,-1026,-123,1079,2132,2656,2632,2373,2228,2308,2486,2611,2652,2647,2573,2343,1927,1418,943,567,285,76,-99,-319,-657,-1074,-1413,-1539,-1475,-1388,-1424,-1595,-1802,-1928,-1901,-1716,-1444,-1201,-1070,-1013,-909,-675,-347,-35,184,311,388,457,559,715,898,1026,1029,919,783,692,641,587,510,426,337,210,13,-225,-426,-526,-520,-465,-438,-495,-639,-805,-897,-852,-696,-531,-448,-460,-500,-495,-423,-319,-221,-140,-67,3,61,109,172,270,390,474,466,367,245,181,204,273,323,316,251,146,21,-95,-173,-209,-241,-314,-431,-541,-593,-582,-548,-525,-514,-503,-486,-470,-445,-394,-312,-216,-130,-71,-40,-31,-29,-12,35,100,149,155,125,91,78,89,108,117,109,85,59,45,42,29,-13,-78,-136,-165,-170,-174,-193,-222,-251,-268,-268,-248,-210,-169,-133,-99,-53,9,75,129,166,192,209,217,214,202,178,140,90,49,33,42,52,42,16}
        },
        {    // H-10e030a.wav
            {-1,-2,-2,-2,-1,0,-1,-2,-3,-4,-2,1,2,-1,-2,0,5,3,-4,-6,4,12,4,-12,-12,8,16,-3,-23,-8,22,18,-17,-20,18,22,29,357,1349,2749,3493,2488,-157,-2802,-3559,-2058,138,1027,83,-1370,-1580,-5,2398,4204,4625,3825,2613,2023,2849,5047,7401,8091,6062,2074,-1673,-3153,-2029,214,1494,646,-1873,-4462,-5559,-4699,-2768,-1285,-1263,-2523,-3966,-4504,-3801,-2314,-794,204,493,204,-300,-557,-229,655,1679,2313,2294,1801,1296,1164,1449,1846,1964,1624,987,412,173,271,473,504,217,-348,-1014,-1558,-1809,-1736,-1481,-1278,-1298,-1523,-1763,-1797,-1542,-1114,-745,-608,-688,-811,-789,-575,-277,-48,42,34,10,20,69,143,229,308,357,359,317,256,204,183,193,212,199,128,2,-138,-246,-300,-313,-322,-359,-424,-486,-507,-472,-409,-364,-358,-381,-404,-405,-372,-300,-194,-85,-11,13,8,14,48,94,129,139,127,95,45,-10,-53,-74,-78,-82,-98,-132,-186,-247,-292,-299,-269,-234,-226,-253,-286,-296,-273,-234,-200,-181,-174,-173,-172,-161,-136,-101,-70,-58,-65,-78,-76,-51,-8,37,65,69,50,24,8,10,23,26,3,-44,-98,-141,-165,-176,-183,-191,-199,-203,-203,-198,-191,-184,-179,-177,-174,-165,-145,-115,-84,-63,-55,-55,-59,-66,-77,-86,-86,-76,-65,-58,-55,-54,-56,-63,-73,-80,-82,-83,-85,-80,-63,-40,-21,-11,-5,-3,-6,-15,-20,-17,-21,-47,-89,-110,-85,-31},
            {-43,-72,14,102,26,-134,-117,96,176,-55,-242,-12,286,46,-127,1774,6709,11907,11979,4127,-7848,-15937,-15183,-8230,-2111,-787,-1697,281,6497,12990,14893,11382,6155,3911,6839,13593,20200,21831,15401,2325,-11098,-17487,-14114,-5345,1010,212,-6075,-12246,-13879,-10662,-5470,-1661,-1111,-3615,-7166,-9009,-7394,-2968,1615,3794,3009,714,-1168,-1591,-552,1382,3388,4576,4475,3513,2775,3046,4099,4985,4926,3843,2182,521,-614,-859,-272,491,503,-751,-2937,-5098,-6303,-6197,-5126,-3892,-3276,-3553,-4302,-4730,-4318,-3230,-2111,-1472,-1268,-1016,-302,832,1932,2534,2537,2240,2041,2108,2333,2536,2643,2663,2564,2278,1820,1331,955,702,480,226,-50,-332,-643,-981,-1268,-1413,-1427,-1425,-1507,-1667,-1824,-1904,-1873,-1726,-1490,-1248,-1095,-1041,-986,-804,-472,-87,227,417,510,574,660,782,908,981,963,872,763,679,616,551,479,410,341,240,79,-128,-329,-470,-526,-518,-496,-520,-615,-745,-829,-805,-687,-556,-489,-496,-521,-505,-432,-332,-235,-155,-84,-19,42,104,176,265,357,421,423,360,269,206,204,248,292,297,250,164,55,-50,-127,-172,-212,-285,-397,-510,-578,-593,-586,-583,-582,-567,-533,-492,-445,-379,-291,-195,-112,-53,-17,-1,0,-1,18,56,91,95,66,29,11,19,38,52,52,44,40,47,62,68,48,6,-44,-86,-117,-144,-172,-202,-234,-262,-274,-263,-232,-197,-169,-139,-93,-28,41,95,130,155,182,214,240,250,235,199,149,96,53,29,28,37,41,30,11}
        },
        {    // H-10e035a.wav
            {-1,-1,-1,-1,-2,-3,-2,-1,-1,-2,-4,-6,-4,-1,2,0,-3,-2,2,3,-2,-6,-1,7,4,-9,-12,1,12,2,-16,-12,11,16,-8,-18,7,19,15,209,915,2075,2942,2523,591,-1763,-2884,-2051,-221,862,346,-979,-1553,-554,1482,3304,4005,3529,2503,1832,2284,4018,6232,7422,6397,3334,-150,-2128,-1805,-57,1331,1023,-958,-3376,-4756,-4440,-2988,-1660,-1425,-2282,-3407,-3902,-3450,-2372,-1222,-395,-25,-53,-286,-417,-166,515,1356,1941,2023,1694,1293,1147,1349,1722,1960,1851,1409,855,440,268,249,198,-22,-426,-920,-1358,-1605,-1598,-1397,-1169,-1090,-1218,-1448,-1595,-1541,-1326,-1089,-947,-898,-851,-726,-525,-313,-152,-59,-11,13,27,46,87,155,232,292,318,307,262,194,131,109,134,163,138,42,-82,-171,-200,-197,-209,-257,-330,-402,-445,-447,-410,-359,-330,-343,-386,-419,-405,-331,-218,-107,-34,-11,-20,-31,-22,5,32,44,37,14,-16,-45,-61,-62,-60,-67,-92,-134,-187,-242,-280,-283,-247,-199,-175,-192,-230,-250,-231,-180,-128,-101,-105,-131,-157,-169,-160,-139,-118,-104,-98,-98,-97,-86,-57,-17,13,16,-7,-33,-43,-35,-25,-26,-42,-69,-104,-137,-156,-155,-141,-132,-136,-149,-160,-160,-153,-148,-148,-150,-150,-143,-131,-117,-101,-85,-70,-63,-67,-77,-82,-80,-76,-74,-70,-62,-57,-64,-79,-92,-93,-85,-76,-69,-63,-53,-41,-29,-16,-5,-2,-10,-19,-24,-33,-56,-88,-102,-77,-28},
            {-45,88,94,-74,-170,-7,191,80,-208,-174,204,246,-207,347,3853,9620,13167,9656,-822,-12066,-16888,-13600,-6927,-2505,-1243,346,4963,10896,13929,12060,7612,4980,6944,12901,19485,22283,18006,6855,-6465,-15100,-15029,-8450,-1950,-820,-4951,-9988,-11878,-10000,-6523,-3878,-3217,-4454,-6635,-8138,-7390,-4187,-229,2162,2065,580,-508,-371,616,1789,2842,3639,3943,3695,3333,3449,4098,4670,4543,3686,2519,1375,336,-503,-922,-899,-873,-1453,-2796,-4364,-5341,-5287,-4440,-3496,-3124,-3535,-4352,-4860,-4518,-3376,-2025,-1110,-820,-801,-530,224,1238,2070,2426,2363,2167,2088,2169,2303,2394,2418,2360,2164,1809,1377,1004,754,567,347,64,-249,-563,-869,-1137,-1317,-1400,-1448,-1543,-1698,-1845,-1901,-1821,-1620,-1362,-1147,-1062,-1092,-1103,-938,-562,-97,280,477,530,540,592,714,867,974,969,852,700,597,564,553,515,448,372,283,149,-43,-253,-417,-500,-520,-523,-543,-597,-670,-729,-729,-656,-544,-459,-443,-478,-502,-469,-383,-281,-194,-124,-60,10,84,159,229,293,342,357,324,257,194,180,219,273,294,264,201,125,46,-31,-102,-164,-236,-336,-455,-552,-596,-598,-594,-604,-614,-602,-558,-490,-405,-306,-201,-105,-32,12,28,22,11,15,44,79,92,72,32,-6,-30,-40,-42,-38,-29,-13,18,63,107,119,84,19,-45,-89,-116,-139,-163,-188,-213,-235,-246,-238,-211,-179,-150,-118,-75,-20,37,86,124,157,190,223,247,253,235,199,157,116,82,54,35,30,32,32,22,7}
        },
        {    // H-10e040a.wav
            {0,0,-1,-1,-1,-1,-2,-2,-1,-1,-2,-3,-4,-4,-2,0,1,0,-2,0,3,4,0,-4,-2,5,5,-4,-8,0,11,4,-14,-15,7,22,6,-15,-5,14,15,112,567,1464,2356,2415,1185,-760,-2097,-1903,-569,548,436,-608,-1354,-860,709,2378,3259,3137,2423,1811,1963,3184,5080,6546,6401,4339,1348,-920,-1385,-322,942,1096,-210,-2227,-3753,-4016,-3157,-2033,-1528,-1927,-2803,-3450,-3418,-2736,-1746,-815,-185,52,-34,-208,-171,241,915,1536,1825,1745,1499,1358,1459,1726,1926,1839,1405,779,219,-84,-124,-53,-55,-231,-558,-927,-1206,-1313,-1262,-1163,-1152,-1293,-1522,-1685,-1657,-1433,-1131,-895,-788,-758,-705,-574,-390,-215,-86,-1,55,82,84,78,96,145,206,246,251,227,186,143,117,116,129,124,78,-4,-85,-137,-159,-176,-217,-287,-371,-440,-466,-444,-394,-349,-333,-341,-352,-341,-296,-223,-144,-85,-64,-73,-90,-92,-73,-41,-15,-4,-14,-39,-65,-78,-71,-53,-40,-45,-73,-121,-177,-220,-234,-217,-189,-174,-183,-202,-210,-195,-163,-132,-115,-115,-131,-154,-171,-173,-158,-137,-122,-119,-122,-121,-112,-95,-75,-59,-53,-57,-67,-70,-61,-46,-37,-41,-56,-72,-84,-90,-90,-86,-84,-90,-104,-118,-127,-130,-135,-146,-158,-163,-158,-145,-127,-110,-98,-92,-88,-83,-77,-74,-77,-79,-75,-65,-57,-58,-65,-72,-75,-74,-67,-55,-42,-35,-31,-27,-19,-15,-18,-24,-29,-41,-67,-96,-103,-74,-26},
            {92,-13,-149,-93,128,184,-70,-261,-11,321,64,-290,1272,6039,11757,13185,6788,-4959,-14851,-17189,-12585,-6289,-2284,67,3574,8679,12495,12240,8669,5630,6616,11977,18822,22825,20480,11182,-1638,-11837,-14593,-10245,-4098,-1782,-4507,-8807,-10600,-8981,-6150,-4524,-4678,-5784,-6966,-7685,-7366,-5591,-2832,-448,504,295,101,671,1726,2606,3079,3323,3438,3384,3333,3659,4396,4972,4744,3721,2513,1592,839,-76,-1114,-1903,-2270,-2501,-2962,-3625,-4089,-4053,-3640,-3274,-3308,-3769,-4352,-4607,-4206,-3183,-1962,-1082,-784,-831,-718,-122,832,1704,2137,2145,2025,2035,2174,2277,2254,2159,2064,1931,1687,1362,1071,868,677,409,89,-193,-417,-655,-950,-1238,-1432,-1531,-1607,-1698,-1760,-1741,-1644,-1501,-1333,-1163,-1045,-1019,-1028,-936,-648,-219,190,437,506,485,487,575,730,872,919,855,739,644,591,551,495,429,371,309,207,46,-149,-330,-459,-523,-538,-536,-550,-591,-638,-648,-596,-503,-421,-393,-417,-450,-447,-396,-323,-258,-202,-136,-51,38,110,163,214,269,307,299,245,183,156,175,215,244,250,232,193,128,49,-24,-83,-149,-250,-383,-502,-565,-580,-587,-612,-639,-633,-586,-517,-441,-355,-251,-145,-62,-15,6,11,7,3,14,48,90,110,89,38,-15,-50,-67,-77,-85,-83,-53,6,74,116,110,63,5,-45,-83,-119,-152,-179,-196,-204,-207,-203,-195,-183,-167,-140,-101,-54,-9,29,65,105,147,187,221,243,246,226,189,151,124,102,76,48,27,23,30,33,25,10}
        },
        {    // H-10e045a.wav
            {1,1,0,0,0,0,-1,-1,-2,-2,-1,-1,-2,-3,-4,-3,-2,0,0,-1,-2,-1,2,3,1,-3,-3,0,2,-2,-5,-1,3,-1,-11,-9,8,19,5,-16,-7,19,20,46,299,942,1768,2157,1560,131,-1222,-1568,-835,116,336,-290,-995,-927,69,1419,2407,2693,2401,1944,1844,2522,3961,5488,6054,5006,2707,379,-786,-505,472,1012,454,-997,-2532,-3365,-3260,-2605,-2049,-2007,-2417,-2881,-3009,-2654,-1925,-1064,-332,72,100,-86,-182,61,655,1364,1870,1986,1757,1413,1198,1208,1329,1337,1084,630,192,-37,-29,87,143,31,-263,-678,-1097,-1392,-1489,-1421,-1313,-1286,-1361,-1455,-1462,-1335,-1120,-906,-760,-683,-628,-543,-412,-253,-104,5,63,74,58,44,52,87,138,187,221,231,212,170,127,108,112,112,76,2,-80,-140,-172,-196,-232,-286,-353,-416,-458,-461,-424,-363,-307,-276,-274,-286,-289,-266,-215,-157,-117,-107,-116,-123,-113,-89,-59,-28,-5,0,-17,-45,-58,-47,-25,-17,-37,-79,-130,-178,-216,-231,-220,-197,-186,-198,-218,-218,-189,-149,-123,-123,-139,-152,-155,-152,-149,-148,-147,-144,-145,-150,-152,-141,-115,-89,-78,-81,-85,-79,-64,-48,-35,-20,-7,-3,-15,-34,-49,-59,-70,-86,-101,-109,-113,-123,-141,-161,-175,-180,-177,-169,-154,-135,-118,-106,-99,-93,-86,-77,-68,-62,-56,-47,-36,-30,-33,-44,-53,-54,-51,-47,-43,-31,-18,-14,-25,-41,-52,-61,-80,-105,-110,-80,-28},
            {-17,-144,-60,152,141,-139,-237,96,320,-94,-194,2196,7702,13048,12784,4486,-7914,-16869,-17712,-12184,-5543,-978,2373,6376,10400,11828,9606,6218,5696,9958,17145,22941,23231,16376,4408,-7472,-13688,-12239,-6452,-2260,-3033,-6989,-9722,-8910,-6119,-4343,-4724,-6128,-7198,-7741,-8006,-7567,-5735,-2868,-465,338,-28,-158,761,2317,3632,4273,4309,3920,3359,3127,3686,4829,5604,5158,3579,1733,326,-640,-1488,-2238,-2625,-2621,-2638,-3061,-3729,-4072,-3759,-3106,-2771,-3114,-3875,-4417,-4240,-3320,-2076,-1081,-684,-785,-910,-584,273,1277,1934,2071,1936,1876,1993,2123,2114,2002,1909,1844,1695,1410,1087,858,718,542,243,-128,-458,-699,-883,-1053,-1221,-1387,-1549,-1684,-1745,-1706,-1588,-1437,-1276,-1111,-972,-910,-918,-897,-726,-386,5,289,399,397,400,483,639,799,889,872,768,640,548,510,494,461,402,331,246,119,-67,-278,-434,-490,-475,-465,-502,-562,-592,-569,-510,-443,-385,-352,-357,-397,-433,-418,-346,-259,-200,-168,-131,-65,16,87,142,194,248,280,266,208,149,129,157,201,224,211,176,131,83,30,-24,-79,-151,-252,-372,-479,-546,-576,-592,-610,-617,-595,-539,-460,-374,-291,-216,-152,-98,-57,-32,-26,-27,-10,34,86,112,97,57,21,-1,-18,-41,-67,-80,-70,-35,12,54,71,56,18,-25,-60,-88,-117,-154,-192,-214,-213,-192,-168,-155,-148,-137,-112,-80,-50,-22,8,46,90,137,182,220,242,241,221,193,166,142,116,86,54,28,16,19,29,33,25,9}
        },
        {    // H-10e050a.wav
            {1,1,1,1,0,0,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-3,-4,-4,-3,-1,-1,-1,0,2,3,1,-5,-8,-3,3,4,-2,-7,-6,-3,-1,0,6,10,4,-7,-3,16,17,14,133,541,1209,1765,1699,850,-326,-1063,-956,-332,90,-93,-606,-825,-374,586,1580,2205,2332,2100,1864,2069,2981,4347,5382,5256,3783,1674,61,-335,283,1011,951,-153,-1797,-3130,-3558,-3098,-2283,-1730,-1722,-2099,-2458,-2465,-2032,-1307,-552,-11,207,177,121,264,668,1185,1547,1566,1263,860,625,687,952,1182,1179,920,547,234,64,3,-49,-182,-434,-777,-1122,-1355,-1412,-1319,-1188,-1128,-1173,-1267,-1309,-1228,-1034,-808,-648,-591,-590,-555,-439,-268,-116,-31,-9,-10,-3,24,65,111,151,178,191,193,183,158,124,93,72,53,21,-29,-87,-140,-187,-229,-270,-310,-351,-391,-420,-424,-400,-357,-315,-289,-282,-285,-285,-266,-222,-166,-121,-103,-107,-113,-105,-78,-41,-9,6,1,-21,-44,-58,-59,-55,-53,-56,-72,-110,-165,-217,-242,-235,-214,-201,-202,-205,-199,-186,-172,-160,-147,-138,-137,-147,-159,-162,-153,-143,-140,-148,-158,-161,-153,-134,-109,-82,-64,-60,-64,-63,-47,-18,7,18,14,1,-16,-35,-53,-67,-77,-89,-107,-131,-155,-173,-186,-193,-192,-185,-174,-161,-148,-133,-115,-96,-77,-61,-49,-38,-28,-20,-18,-25,-36,-44,-48,-54,-61,-62,-49,-31,-23,-33,-47,-54,-58,-75,-102,-110,-80,-28},
            {-138,19,185,80,-204,-209,164,294,-195,-94,2779,8674,13837,12710,3301,-9811,-18709,-18819,-12217,-4454,1023,4703,8064,10511,10206,7293,4996,6930,13526,21269,25132,21856,11871,-796,-10513,-13345,-9791,-4450,-2225,-4240,-7486,-8432,-6610,-4440,-4124,-5528,-7136,-8118,-8698,-8873,-7854,-5237,-2119,-292,-336,-1002,-673,965,2904,4123,4449,4258,3903,3686,3982,4902,5852,5862,4550,2540,769,-463,-1491,-2491,-3096,-2956,-2416,-2276,-2893,-3772,-4143,-3792,-3195,-2924,-3104,-3432,-3541,-3253,-2612,-1825,-1183,-884,-834,-680,-133,730,1518,1893,1876,1759,1773,1892,1952,1889,1796,1758,1715,1545,1241,939,756,635,414,25,-424,-768,-945,-1021,-1085,-1182,-1317,-1479,-1629,-1700,-1647,-1495,-1311,-1137,-978,-852,-799,-811,-786,-602,-253,115,337,382,361,399,532,696,812,835,769,651,538,474,459,458,428,361,269,152,3,-170,-322,-407,-423,-421,-453,-519,-575,-574,-514,-428,-355,-317,-318,-350,-390,-406,-377,-311,-241,-191,-159,-121,-59,19,94,154,201,237,250,227,172,120,107,138,181,194,167,118,67,21,-26,-73,-118,-172,-251,-353,-452,-517,-543,-552,-562,-566,-546,-495,-426,-354,-286,-221,-164,-122,-101,-94,-86,-63,-19,37,85,107,98,68,30,-3,-28,-42,-50,-53,-44,-14,32,68,65,18,-45,-91,-113,-128,-155,-189,-214,-219,-208,-190,-167,-141,-117,-100,-86,-71,-53,-35,-14,17,64,122,178,221,241,239,219,191,163,137,111,83,57,36,24,20,21,22,19,11,3}
        },
        {    // H-10e055a.wav
            {1,1,1,1,1,1,1,1,0,0,-1,-1,-2,-2,-2,-2,-2,-2,-2,-1,-1,-1,-1,-1,0,2,3,2,-2,-5,-4,1,5,3,-4,-7,-3,3,5,4,5,8,6,-1,1,17,23,5,31,249,733,1318,1617,1312,475,-414,-841,-684,-285,-97,-268,-545,-534,-42,798,1643,2152,2188,1926,1801,2246,3319,4538,5131,4588,3069,1325,171,-62,286,512,73,-1028,-2268,-2999,-2916,-2251,-1559,-1292,-1511,-1919,-2132,-1926,-1330,-559,108,455,439,209,16,49,311,644,864,894,805,745,816,997,1157,1148,910,512,95,-214,-369,-405,-402,-443,-576,-795,-1034,-1201,-1238,-1157,-1034,-955,-958,-1010,-1032,-965,-815,-648,-532,-486,-473,-439,-357,-245,-134,-49,7,40,58,68,81,103,132,157,162,141,101,59,32,22,17,0,-40,-103,-178,-246,-291,-308,-309,-316,-342,-378,-401,-395,-360,-313,-271,-240,-224,-218,-210,-187,-145,-98,-67,-67,-88,-107,-107,-85,-55,-34,-32,-46,-65,-78,-83,-83,-82,-86,-98,-119,-148,-177,-197,-203,-202,-201,-206,-213,-217,-213,-198,-172,-143,-122,-118,-130,-144,-147,-140,-132,-130,-135,-141,-142,-135,-119,-97,-74,-60,-59,-64,-64,-49,-22,7,23,20,2,-22,-46,-68,-89,-105,-114,-121,-136,-157,-178,-188,-186,-179,-171,-157,-135,-111,-92,-79,-67,-53,-39,-32,-33,-40,-49,-58,-61,-58,-53,-49,-47,-42,-37,-35,-36,-35,-31,-32,-50,-77,-88,-66,-24},
            {-48,156,124,-152,-219,120,290,-160,-102,2737,8801,14337,13422,3607,-10533,-20410,-20571,-12816,-3376,3180,6661,8766,9729,8529,5748,4612,8265,16212,23904,25977,20082,8366,-3956,-11645,-12408,-8174,-3565,-2279,-4308,-6622,-6626,-4745,-3491,-4447,-6772,-8608,-9187,-9030,-8538,-7276,-4923,-2289,-762,-775,-1294,-944,620,2596,3989,4397,4066,3596,3657,4605,6025,6820,6087,4011,1699,70,-907,-1784,-2684,-3132,-2829,-2246,-2194,-2904,-3783,-4097,-3726,-3158,-2883,-2957,-3105,-3060,-2740,-2221,-1677,-1301,-1153,-1046,-668,105,1029,1685,1866,1735,1609,1635,1721,1743,1711,1711,1738,1671,1429,1090,821,692,604,402,33,-418,-825,-1103,-1241,-1271,-1262,-1285,-1370,-1475,-1525,-1488,-1391,-1274,-1141,-995,-875,-827,-818,-727,-452,-45,314,466,421,330,339,473,651,774,800,737,621,495,400,362,368,383,364,287,151,-28,-211,-345,-397,-383,-367,-406,-495,-573,-580,-512,-413,-335,-301,-303,-327,-352,-355,-322,-263,-208,-181,-170,-138,-63,44,146,218,257,268,247,193,122,70,64,98,137,149,128,89,45,0,-50,-100,-151,-212,-291,-378,-448,-484,-490,-488,-490,-491,-476,-439,-388,-330,-275,-229,-195,-172,-152,-131,-106,-75,-33,21,74,103,98,68,36,16,4,-11,-31,-44,-35,1,46,74,67,24,-38,-98,-147,-183,-212,-233,-243,-239,-222,-195,-163,-130,-99,-73,-54,-42,-34,-26,-12,15,54,104,157,203,231,237,223,198,168,135,102,69,45,32,30,34,37,34,25,14,6,1}
        },
        {    // H-10e060a.wav
            {1,1,1,1,2,2,2,2,2,1,0,0,1,1,0,-1,-1,0,1,1,1,1,1,1,0,0,2,4,4,2,-1,-3,-2,1,3,3,0,-1,1,5,7,6,4,6,10,12,12,11,6,-9,-8,95,397,889,1364,1491,1070,246,-534,-851,-645,-250,-73,-231,-463,-382,181,1035,1778,2097,1999,1826,2025,2807,3924,4745,4656,3518,1816,370,-224,20,522,589,-86,-1236,-2249,-2623,-2289,-1600,-1031,-857,-1033,-1306,-1413,-1232,-824,-377,-101,-97,-287,-455,-395,-58,420,826,1010,966,805,664,620,645,640,512,249,-62,-301,-397,-370,-307,-298,-396,-592,-822,-996,-1046,-971,-847,-765,-770,-824,-854,-813,-717,-615,-543,-500,-463,-409,-332,-239,-142,-61,-13,1,3,13,37,57,60,52,49,54,55,36,4,-27,-47,-68,-108,-166,-226,-268,-285,-286,-283,-282,-286,-297,-308,-311,-294,-256,-212,-183,-174,-176,-172,-154,-128,-107,-99,-104,-120,-138,-147,-138,-113,-84,-67,-67,-76,-86,-95,-101,-105,-103,-97,-100,-119,-153,-188,-211,-218,-215,-209,-206,-202,-193,-175,-150,-124,-106,-100,-107,-120,-129,-129,-120,-107,-100,-103,-113,-124,-129,-121,-98,-70,-50,-47,-54,-56,-46,-30,-21,-24,-36,-55,-79,-102,-115,-114,-106,-103,-112,-126,-138,-142,-142,-137,-126,-109,-93,-81,-75,-72,-75,-83,-92,-97,-95,-86,-71,-56,-43,-35,-30,-26,-24,-27,-30,-27,-16,-8,-16,-37,-52,-42,-16},
            {97,99,-102,-198,68,292,-72,-242,2045,7910,14306,14948,5919,-9322,-21524,-23210,-14810,-3238,4955,8318,9041,8739,7214,4885,4494,8934,17496,25201,26384,19132,6608,-5338,-11895,-11805,-7529,-3244,-1872,-3208,-4770,-4651,-3487,-3451,-5533,-8352,-9817,-9433,-8438,-7851,-7174,-5383,-2718,-762,-627,-1575,-1781,-282,2148,3963,4345,3713,3115,3376,4607,6135,6868,6048,3923,1594,29,-749,-1382,-2204,-2822,-2756,-2239,-2063,-2656,-3568,-3992,-3657,-3024,-2691,-2781,-2965,-2904,-2552,-2090,-1722,-1535,-1456,-1267,-749,102,1003,1595,1748,1641,1542,1555,1603,1604,1583,1598,1624,1559,1349,1070,857,764,703,521,142,-364,-829,-1120,-1229,-1250,-1289,-1374,-1454,-1466,-1407,-1327,-1271,-1232,-1167,-1061,-953,-886,-829,-680,-364,58,410,539,453,313,288,416,606,739,762,692,574,450,356,321,343,384,391,327,192,8,-183,-330,-393,-385,-368,-405,-496,-576,-580,-509,-416,-349,-317,-306,-307,-315,-317,-294,-244,-187,-149,-128,-100,-42,50,153,241,293,303,274,218,146,76,33,33,64,90,81,43,5,-16,-31,-67,-132,-215,-305,-395,-473,-517,-513,-476,-438,-419,-409,-385,-338,-280,-234,-212,-206,-205,-198,-183,-157,-113,-47,34,101,123,99,55,22,8,1,-9,-15,-7,15,39,56,60,46,8,-48,-104,-147,-181,-216,-254,-278,-275,-248,-211,-174,-135,-91,-52,-28,-22,-23,-17,4,35,72,111,149,181,201,206,195,173,149,126,104,81,58,43,39,42,44,39,31,26,23,16,6}
        },
        {    // H-10e065a.wav
            {1,2,2,2,2,2,2,2,1,1,2,2,1,0,0,1,1,1,1,1,1,1,1,0,0,0,1,2,3,3,2,0,-1,-1,1,1,1,2,4,4,2,-1,1,7,13,15,12,6,1,-1,-3,-6,-7,32,193,545,1030,1407,1362,780,-88,-748,-853,-488,-84,-12,-249,-433,-204,488,1370,2073,2371,2291,2085,2090,2512,3225,3781,3696,2841,1599,599,242,408,586,314,-464,-1371,-1901,-1789,-1181,-517,-223,-451,-1023,-1585,-1844,-1703,-1271,-752,-334,-109,-49,-49,3,154,352,493,497,371,209,117,140,234,303,275,140,-49,-221,-323,-340,-306,-288,-349,-501,-687,-811,-816,-725,-618,-572,-605,-680,-733,-718,-626,-492,-373,-313,-310,-323,-306,-246,-170,-112,-84,-75,-67,-60,-59,-63,-61,-45,-23,-14,-30,-65,-100,-122,-135,-150,-173,-195,-208,-210,-206,-198,-186,-177,-182,-207,-240,-256,-241,-207,-174,-158,-156,-161,-169,-176,-175,-164,-148,-140,-145,-156,-158,-143,-118,-97,-90,-95,-106,-114,-116,-113,-110,-113,-124,-143,-165,-185,-197,-196,-184,-166,-152,-146,-146,-144,-133,-116,-100,-90,-87,-86,-88,-96,-107,-115,-116,-114,-118,-127,-131,-121,-102,-87,-85,-89,-92,-91,-91,-92,-88,-73,-57,-54,-67,-87,-95,-88,-74,-64,-62,-67,-76,-91,-108,-120,-121,-115,-110,-115,-126,-133,-130,-121,-111,-98,-79,-56,-41,-36,-36,-29,-15,-4,-2,-5,-1,9,12,3,-10,-14,-7},
            {171,-59,-264,-56,321,136,-365,921,6018,13247,16473,9877,-5515,-20807,-26063,-18735,-5208,5703,10048,9722,7997,6085,4248,4278,8736,17357,25433,26932,19517,6541,-5605,-11965,-11657,-7400,-3067,-1135,-1516,-2438,-2594,-2524,-3749,-6638,-9579,-10603,-9545,-8059,-7472,-7218,-5831,-3148,-828,-469,-1680,-2449,-1303,1266,3532,4286,3720,2919,2876,3868,5362,6307,5827,3967,1745,241,-383,-808,-1531,-2208,-2225,-1699,-1496,-2199,-3352,-3960,-3609,-2844,-2447,-2607,-2891,-2858,-2492,-2071,-1828,-1792,-1815,-1655,-1106,-191,778,1417,1594,1505,1423,1423,1409,1339,1316,1439,1637,1707,1527,1178,872,744,733,643,331,-161,-643,-947,-1067,-1132,-1251,-1412,-1526,-1529,-1441,-1329,-1242,-1185,-1129,-1044,-938,-851,-800,-721,-505,-126,284,527,522,381,296,359,508,634,683,662,592,489,381,318,327,384,427,396,267,59,-164,-324,-377,-355,-347,-415,-535,-622,-614,-524,-414,-336,-298,-290,-299,-314,-315,-283,-220,-157,-123,-114,-99,-45,50,162,260,320,335,306,243,163,92,47,34,39,37,15,-17,-40,-44,-43,-58,-103,-177,-273,-378,-470,-524,-529,-500,-462,-428,-393,-346,-291,-240,-204,-190,-196,-213,-224,-210,-169,-114,-56,8,73,120,122,79,22,-15,-25,-24,-20,-6,26,67,93,89,55,0,-64,-125,-175,-209,-232,-246,-249,-242,-230,-217,-197,-157,-100,-44,-13,-10,-20,-24,-14,14,57,108,153,180,186,179,164,143,119,98,85,78,72,66,66,71,75,66,47,30,22,21,16,7}
        },
        {    // H-10e070a.wav
            {1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,0,-1,0,1,2,1,0,-1,-1,0,1,3,3,1,-2,-3,0,3,3,1,0,1,1,1,3,8,13,12,5,-1,-2,3,6,8,6,-3,-3,69,307,737,1203,1396,1070,303,-489,-845,-643,-192,76,16,-126,7,520,1183,1662,1791,1648,1467,1500,1916,2689,3524,3942,3590,2541,1304,472,295,542,738,550,-5,-642,-1047,-1098,-926,-807,-960,-1380,-1831,-2007,-1748,-1145,-475,-22,79,-121,-436,-661,-670,-474,-194,20,86,37,-15,22,151,285,323,232,59,-108,-201,-209,-167,-133,-158,-258,-403,-534,-602,-599,-556,-514,-497,-505,-519,-518,-485,-427,-371,-345,-355,-377,-378,-349,-301,-254,-217,-194,-186,-190,-196,-192,-172,-140,-107,-83,-78,-93,-120,-141,-141,-120,-94,-80,-80,-87,-95,-104,-117,-137,-162,-189,-214,-228,-226,-212,-196,-188,-190,-196,-201,-198,-185,-165,-148,-146,-161,-180,-190,-184,-167,-148,-132,-122,-118,-123,-133,-141,-144,-140,-137,-136,-137,-138,-135,-128,-119,-110,-105,-106,-113,-120,-120,-109,-90,-72,-66,-74,-93,-113,-127,-134,-138,-142,-145,-150,-155,-159,-158,-149,-133,-118,-111,-112,-113,-105,-87,-65,-48,-40,-43,-51,-58,-58,-52,-45,-45,-57,-78,-101,-121,-135,-143,-148,-150,-146,-135,-120,-102,-86,-73,-62,-58,-58,-56,-45,-24,-1,16,26,32,35,33,23,10,1,-1},
            {148,-216,-287,154,383,-167,-137,3238,10444,16734,14698,1517,-16400,-27424,-24443,-10747,3726,11321,11572,8511,5437,3408,3429,7422,15729,24568,27720,21610,8662,-4489,-11972,-12275,-8013,-3132,-232,377,-137,-737,-1564,-3493,-6680,-9803,-11119,-10263,-8603,-7599,-7143,-5960,-3567,-1227,-609,-1759,-2887,-2223,218,2825,4055,3698,2730,2320,3012,4459,5658,5602,4068,1890,248,-393,-541,-862,-1329,-1430,-1068,-874,-1454,-2570,-3345,-3260,-2691,-2381,-2589,-2919,-2891,-2466,-1991,-1787,-1896,-2104,-2106,-1662,-773,269,1052,1364,1325,1198,1120,1061,1005,1055,1305,1661,1867,1741,1349,949,758,769,778,577,135,-379,-753,-907,-942,-1023,-1221,-1462,-1605,-1572,-1397,-1195,-1062,-1012,-988,-950,-911,-897,-858,-678,-308,130,422,457,328,230,273,417,560,642,662,622,528,414,343,353,419,472,450,330,126,-110,-300,-384,-369,-337,-374,-485,-595,-624,-561,-458,-373,-322,-296,-284,-284,-287,-270,-221,-157,-115,-110,-114,-82,12,146,272,352,373,347,287,203,110,34,-4,-4,9,8,-13,-36,-47,-47,-57,-94,-162,-252,-354,-449,-515,-533,-509,-467,-430,-403,-368,-317,-255,-204,-181,-189,-213,-226,-211,-164,-101,-38,18,67,100,103,74,27,-13,-37,-47,-43,-24,9,44,67,71,53,15,-43,-106,-159,-195,-221,-242,-252,-242,-217,-191,-171,-145,-101,-48,-9,-2,-21,-46,-58,-48,-15,36,93,143,176,189,181,155,119,88,69,62,60,62,72,90,107,111,99,77,54,33,16,6,1}
        },
        {    // H-10e075a.wav
            {0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,-1,-1,0,1,1,1,1,1,0,-1,-1,1,2,0,-2,0,4,6,4,1,3,5,3,-1,2,12,18,10,-3,-7,-4,1,42,196,519,933,1202,1081,537,-153,-568,-460,33,493,557,205,-238,-373,-20,684,1413,1877,1990,1904,1912,2243,2865,3454,3599,3121,2241,1431,1055,1102,1226,1031,376,-541,-1341,-1720,-1633,-1284,-969,-873,-985,-1154,-1227,-1152,-989,-847,-813,-902,-1044,-1125,-1046,-798,-465,-179,-27,-9,-44,-36,60,211,340,375,302,164,31,-47,-58,-31,-20,-71,-190,-335,-441,-469,-426,-357,-309,-312,-366,-443,-498,-501,-458,-411,-402,-434,-470,-477,-451,-412,-377,-345,-314,-289,-275,-264,-239,-196,-145,-105,-86,-81,-80,-73,-55,-28,3,21,15,-15,-56,-89,-108,-122,-144,-177,-211,-232,-235,-223,-205,-186,-172,-167,-175,-191,-204,-204,-198,-198,-206,-215,-216,-206,-192,-181,-170,-159,-149,-141,-134,-127,-118,-111,-103,-93,-79,-68,-68,-77,-87,-89,-84,-77,-77,-84,-94,-103,-106,-102,-95,-95,-110,-139,-169,-190,-197,-195,-189,-183,-179,-174,-168,-158,-140,-117,-96,-85,-84,-85,-78,-61,-44,-38,-44,-58,-68,-70,-64,-57,-55,-61,-79,-104,-127,-141,-142,-133,-117,-100,-83,-70,-61,-59,-60,-64,-66,-60,-45,-19,13,42,60,63,49,28,8,-2,-2},
            {63,-309,-192,332,279,-413,576,5895,14009,17916,10654,-6795,-24059,-29402,-19830,-3119,9816,13800,11106,6550,3069,1934,4657,12173,22013,28127,25188,13430,-1110,-11232,-13568,-9775,-3998,361,2139,1972,978,-349,-2335,-5338,-8780,-11206,-11520,-10070,-8231,-6904,-5764,-4137,-2292,-1347,-1855,-2867,-2763,-918,1673,3409,3540,2623,1852,2104,3394,4907,5513,4573,2493,444,-644,-807,-728,-817,-853,-564,-251,-532,-1511,-2516,-2801,-2372,-1916,-2004,-2515,-2898,-2805,-2371,-1968,-1837,-1951,-2090,-1982,-1463,-613,257,824,995,920,800,720,687,755,1013,1430,1795,1859,1570,1137,847,816,900,843,511,-6,-485,-761,-839,-855,-947,-1147,-1369,-1483,-1426,-1244,-1054,-945,-914,-915,-929,-967,-996,-912,-621,-178,216,377,299,151,114,235,432,592,660,636,547,435,354,348,416,502,527,434,226,-34,-252,-362,-363,-324,-329,-412,-533,-609,-590,-497,-392,-327,-306,-308,-310,-304,-281,-232,-165,-110,-96,-112,-108,-43,83,223,327,372,362,313,235,140,47,-21,-51,-48,-31,-14,-4,1,-2,-23,-71,-147,-241,-342,-439,-513,-547,-534,-490,-443,-407,-378,-344,-298,-248,-211,-200,-214,-232,-226,-186,-121,-53,8,65,112,130,104,44,-20,-62,-80,-83,-76,-55,-24,6,26,31,20,-10,-57,-111,-157,-190,-213,-230,-233,-219,-195,-168,-140,-102,-55,-15,-5,-32,-79,-119,-131,-108,-60,0,62,119,160,176,164,136,106,82,62,48,46,63,95,124,136,128,110,89,66,40,16,2,-1}
        },
        {    // H-10e080a.wav
            {-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,1,1,1,1,2,1,-1,-1,0,0,-1,-1,0,1,1,0,0,0,0,0,0,-1,-2,-1,1,4,4,2,1,1,1,-2,-3,1,10,13,9,4,5,9,10,8,6,3,-2,22,137,381,697,943,991,838,595,374,190,-11,-257,-482,-575,-456,-118,386,967,1510,1886,2013,1931,1827,1949,2438,3182,3835,4006,3518,2535,1456,641,193,-46,-296,-630,-931,-1029,-876,-606,-441,-533,-885,-1365,-1791,-2013,-1971,-1719,-1398,-1162,-1076,-1081,-1057,-926,-700,-450,-237,-81,31,125,225,338,441,490,453,345,216,114,54,28,22,20,-5,-72,-174,-272,-326,-331,-317,-323,-366,-434,-498,-533,-531,-509,-499,-521,-565,-597,-590,-546,-483,-422,-371,-331,-303,-284,-261,-221,-162,-100,-52,-24,-8,8,26,39,41,33,20,1,-29,-70,-111,-138,-149,-155,-167,-183,-194,-193,-186,-185,-192,-201,-208,-219,-236,-254,-260,-251,-238,-233,-234,-230,-212,-185,-162,-146,-134,-118,-101,-87,-79,-70,-58,-46,-42,-47,-56,-61,-59,-55,-57,-64,-76,-89,-107,-128,-145,-152,-149,-149,-160,-184,-206,-214,-208,-197,-187,-178,-169,-161,-154,-145,-126,-101,-79,-74,-84,-97,-99,-89,-76,-67,-64,-61,-57,-52,-50,-53,-59,-67,-75,-82,-85,-82,-73,-63,-58,-58,-59,-57,-56,-57,-58,-54,-44,-31,-16,4,29,45,39,12,-15,-22,-10},
            {-29,-348,-72,442,132,-536,1370,8036,16231,17700,6605,-12941,-28329,-28911,-15237,2279,13139,14481,10172,5000,1556,1488,6545,16354,26108,28754,20805,5855,-8055,-14564,-12842,-6544,-192,3512,4166,2830,876,-1012,-3163,-6165,-9672,-12180,-12303,-10186,-7378,-5298,-4111,-3232,-2509,-2402,-2987,-3322,-2240,265,2783,3749,2890,1392,799,1782,3744,5342,5425,3799,1360,-574,-1264,-998,-582,-462,-469,-349,-261,-571,-1266,-1860,-1946,-1677,-1553,-1822,-2237,-2415,-2279,-2076,-2048,-2193,-2312,-2191,-1734,-1019,-274,233,385,305,228,284,430,576,737,993,1336,1609,1639,1413,1105,919,907,930,800,445,-26,-429,-646,-709,-743,-848,-1022,-1178,-1228,-1156,-1031,-936,-899,-897,-905,-932,-983,-999,-875,-568,-177,115,194,110,25,70,248,460,600,625,555,442,343,305,349,455,552,551,410,164,-91,-264,-324,-310,-291,-326,-425,-538,-591,-545,-429,-320,-274,-287,-320,-335,-322,-277,-205,-127,-79,-77,-92,-67,26,160,277,338,340,300,236,159,80,13,-32,-51,-46,-28,-8,11,26,30,6,-57,-156,-271,-384,-480,-545,-566,-540,-488,-433,-389,-347,-299,-250,-214,-204,-221,-246,-256,-230,-165,-83,-6,58,112,153,160,117,33,-54,-114,-136,-130,-107,-76,-39,-6,17,23,8,-24,-64,-99,-128,-153,-173,-179,-170,-155,-148,-147,-135,-102,-60,-36,-46,-82,-123,-149,-149,-121,-69,-3,59,107,135,146,144,131,111,91,75,68,73,94,126,155,167,159,139,114,89,61,34,12,1}
        },
        {    // H-10e085a.wav
            {0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,0,0,0,0,1,2,2,1,-2,-2,0,4,5,4,3,2,-1,-4,-3,3,10,11,9,7,5,2,3,12,24,22,-2,-26,-24,13,79,204,456,850,1246,1380,1065,387,-314,-693,-642,-322,16,229,328,406,548,795,1146,1556,1944,2249,2479,2713,3022,3367,3576,3421,2776,1735,619,-178,-415,-146,316,604,519,110,-420,-887,-1232,-1499,-1746,-1978,-2147,-2192,-2081,-1835,-1528,-1268,-1134,-1118,-1122,-1030,-792,-459,-133,106,240,302,341,394,463,519,518,443,323,215,158,151,162,158,115,21,-112,-249,-345,-377,-361,-344,-362,-421,-500,-569,-613,-629,-627,-620,-613,-606,-591,-560,-513,-455,-398,-354,-323,-296,-260,-206,-141,-75,-15,31,54,49,26,11,22,49,63,45,4,-39,-70,-93,-115,-133,-144,-153,-169,-194,-215,-222,-217,-219,-238,-270,-295,-299,-282,-255,-228,-205,-187,-177,-173,-168,-153,-128,-100,-77,-63,-53,-44,-40,-43,-47,-47,-42,-38,-44,-60,-77,-87,-90,-93,-106,-128,-153,-172,-182,-185,-183,-182,-182,-185,-188,-188,-183,-175,-169,-167,-168,-165,-155,-138,-116,-94,-80,-80,-89,-98,-96,-83,-66,-51,-41,-34,-30,-26,-21,-16,-13,-13,-16,-17,-18,-23,-33,-42,-45,-45,-48,-54,-54,-48,-43,-44,-44,-36,-22,-19,-31,-43,-37,-15},
            {-77,-367,-9,501,61,-600,1748,9039,17179,17341,4366,-16000,-30128,-28149,-12540,5049,14587,14556,9574,4256,941,1507,7796,18614,27849,28092,17177,720,-12247,-16093,-11584,-3555,3202,6272,5684,3016,205,-1769,-3507,-6235,-9969,-12914,-13050,-10244,-6461,-3844,-2944,-2934,-3087,-3417,-3889,-3705,-1970,989,3476,3912,2371,514,67,1443,3646,5195,5120,3439,1046,-858,-1537,-1157,-486,-137,-150,-268,-423,-751,-1216,-1483,-1320,-970,-939,-1408,-2005,-2228,-1990,-1667,-1663,-2010,-2390,-2424,-1948,-1093,-205,345,385,53,-307,-408,-187,225,670,1050,1315,1419,1345,1152,974,918,973,998,830,432,-56,-418,-535,-486,-464,-594,-830,-1020,-1057,-966,-853,-795,-793,-818,-866,-945,-1021,-1006,-827,-511,-186,2,6,-92,-142,-39,200,457,603,588,461,319,235,240,325,455,560,561,419,178,-66,-223,-274,-257,-244,-288,-397,-518,-568,-504,-372,-264,-239,-276,-317,-329,-311,-265,-187,-100,-51,-63,-93,-68,43,191,300,332,301,241,172,100,35,-14,-41,-49,-42,-30,-13,10,40,59,39,-35,-145,-264,-374,-473,-551,-581,-550,-479,-413,-373,-340,-291,-232,-194,-197,-231,-261,-261,-221,-151,-69,12,83,134,151,124,60,-18,-83,-123,-137,-130,-103,-64,-25,1,13,14,2,-25,-60,-89,-101,-104,-112,-126,-137,-141,-146,-155,-159,-141,-104,-73,-75,-110,-152,-168,-147,-99,-45,5,48,86,115,128,125,115,106,98,87,77,81,110,154,190,201,188,167,145,120,85,46,15,1}
        },
        {    // H-10e090a.wav
            {0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,2,2,2,0,0,1,3,2,-1,-3,-3,0,4,8,7,3,-3,-5,-2,3,6,9,14,15,6,-7,-6,11,25,13,-11,-17,0,11,17,96,334,693,960,917,551,101,-149,-106,94,264,339,368,393,399,363,326,378,589,978,1533,2199,2837,3230,3203,2778,2194,1739,1537,1482,1373,1124,832,679,758,985,1141,1006,492,-300,-1134,-1761,-2058,-2074,-1966,-1881,-1876,-1911,-1914,-1837,-1678,-1472,-1262,-1072,-898,-715,-507,-281,-64,120,254,339,386,416,446,480,496,476,421,353,292,236,173,100,21,-59,-145,-235,-313,-358,-371,-378,-410,-477,-560,-628,-660,-651,-616,-581,-564,-564,-563,-549,-520,-484,-441,-388,-330,-276,-232,-189,-137,-80,-34,-5,17,45,76,94,93,79,66,51,23,-22,-68,-97,-107,-114,-134,-165,-197,-221,-241,-260,-273,-272,-258,-243,-239,-245,-244,-227,-200,-181,-175,-172,-159,-135,-113,-99,-88,-73,-59,-54,-61,-70,-73,-71,-72,-76,-77,-72,-69,-78,-98,-114,-118,-117,-125,-148,-176,-192,-189,-177,-168,-171,-181,-191,-201,-211,-218,-214,-195,-169,-148,-136,-123,-105,-85,-76,-82,-92,-91,-75,-51,-28,-10,4,17,26,32,34,33,31,25,14,1,-14,-26,-35,-46,-60,-73,-80,-81,-83,-88,-91,-87,-82,-84,-90,-85,-58,-20},
            {-54,-403,-60,525,134,-660,1420,8598,17008,17646,4906,-15705,-30287,-28487,-12625,5334,14969,14730,9515,4155,935,1572,7866,18647,27712,27472,15792,-1309,-14243,-17134,-11059,-1550,5945,8743,7108,3211,-379,-2392,-3668,-5998,-9793,-13137,-13517,-10459,-6091,-3058,-2252,-2742,-3425,-4045,-4551,-4234,-2250,1013,3700,4072,2228,65,-476,1005,3330,4901,4795,3130,830,-936,-1449,-900,-146,107,-133,-408,-504,-640,-995,-1319,-1239,-816,-568,-863,-1472,-1857,-1784,-1526,-1484,-1746,-2063,-2138,-1844,-1248,-550,-10,169,-20,-359,-573,-523,-240,175,637,1057,1310,1302,1078,823,727,817,933,859,515,36,-336,-444,-349,-256,-327,-546,-765,-858,-825,-749,-700,-689,-709,-770,-878,-987,-999,-839,-533,-215,-40,-74,-235,-347,-264,14,343,550,560,425,260,155,153,251,411,548,567,431,193,-36,-175,-211,-187,-171,-218,-342,-486,-553,-488,-339,-219,-198,-247,-298,-314,-301,-259,-182,-91,-42,-66,-117,-104,10,168,282,312,277,214,141,63,-6,-52,-72,-75,-69,-53,-26,12,53,77,60,-11,-121,-238,-344,-436,-512,-550,-535,-477,-414,-369,-338,-299,-250,-211,-203,-222,-244,-246,-218,-165,-101,-37,23,76,106,94,37,-42,-104,-128,-122,-103,-77,-43,-4,25,36,30,14,-10,-43,-77,-105,-121,-131,-140,-151,-161,-170,-173,-166,-146,-121,-105,-111,-136,-165,-174,-148,-89,-19,37,65,77,86,99,106,102,93,86,81,77,82,109,157,205,226,214,187,163,141,109,67,27,4}
        },
        {    // H-10e095a.wav
            {1,0,0,0,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,2,3,2,1,2,3,2,2,1,1,1,0,1,4,6,5,2,-2,-4,-3,1,10,19,18,9,1,5,12,6,-11,-17,-6,2,2,48,226,541,839,893,591,56,-429,-618,-447,-22,476,870,1041,962,724,484,365,395,549,832,1270,1815,2303,2548,2510,2314,2093,1828,1398,793,245,76,419,1073,1660,1910,1798,1472,1071,643,172,-355,-909,-1423,-1802,-1970,-1925,-1761,-1619,-1593,-1670,-1754,-1747,-1607,-1358,-1060,-785,-582,-455,-367,-265,-125,36,180,282,345,392,436,469,473,441,390,337,283,210,111,2,-84,-137,-174,-219,-280,-342,-392,-430,-464,-495,-523,-547,-566,-576,-571,-551,-528,-515,-516,-522,-519,-498,-464,-420,-371,-316,-254,-190,-128,-69,-10,46,89,103,90,68,58,59,55,38,14,-7,-30,-68,-120,-168,-194,-199,-198,-202,-208,-208,-204,-203,-210,-220,-224,-221,-213,-202,-189,-172,-154,-138,-127,-121,-117,-115,-115,-117,-118,-115,-110,-104,-99,-93,-81,-68,-61,-67,-82,-98,-106,-107,-106,-109,-122,-141,-162,-183,-200,-212,-220,-223,-223,-223,-221,-210,-190,-165,-144,-133,-129,-125,-117,-104,-86,-65,-46,-31,-20,-7,10,28,44,57,66,70,66,55,41,27,8,-15,-37,-54,-69,-83,-97,-104,-107,-112,-124,-132,-127,-116,-113,-119,-113,-78,-27},
            {43,-434,-220,488,360,-619,497,6674,15464,18355,8255,-11689,-28429,-29911,-15837,2816,14335,15336,10224,4581,1219,1491,6825,16660,25880,27069,16905,65,-13935,-17993,-11976,-1347,7519,10984,9037,4220,-298,-2776,-3920,-5788,-9283,-12788,-13610,-10822,-6325,-2989,-2060,-2661,-3461,-4096,-4706,-4760,-3207,17,3225,4286,2726,252,-862,244,2584,4442,4679,3243,969,-940,-1578,-935,115,596,291,-261,-549,-635,-842,-1137,-1153,-789,-473,-666,-1249,-1641,-1503,-1129,-1057,-1453,-1964,-2124,-1771,-1091,-415,-27,-46,-371,-718,-818,-618,-281,21,272,541,822,995,968,812,701,734,821,772,486,68,-254,-327,-205,-88,-136,-332,-532,-619,-598,-555,-556,-599,-659,-728,-809,-881,-891,-784,-558,-292,-115,-125,-296,-468,-455,-204,156,422,485,383,234,125,98,169,326,500,572,467,226,-19,-155,-165,-111,-78,-123,-253,-414,-509,-470,-323,-178,-132,-182,-258,-297,-289,-250,-189,-119,-75,-83,-115,-105,-14,124,233,268,239,179,111,44,-15,-59,-86,-100,-101,-84,-48,1,52,89,91,43,-55,-177,-299,-401,-475,-506,-488,-436,-382,-349,-328,-299,-258,-226,-225,-252,-283,-292,-269,-215,-143,-69,-4,45,72,68,24,-45,-108,-135,-118,-75,-28,12,46,72,83,75,46,2,-50,-100,-142,-173,-190,-193,-184,-170,-163,-166,-167,-152,-122,-97,-99,-127,-161,-175,-154,-98,-23,47,91,102,93,82,79,83,85,82,76,74,83,109,151,196,227,230,210,177,143,109,72,35,9}
        },
        {    // H-10e100a.wav
            {1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,1,1,1,0,-1,0,2,2,1,0,0,2,3,2,2,1,0,1,2,2,1,-1,1,3,2,-4,-6,2,12,14,6,3,15,24,12,-15,-30,-26,-17,12,139,434,820,1046,858,250,-468,-890,-810,-352,171,515,647,690,774,903,984,943,847,881,1179,1671,2114,2280,2130,1798,1450,1190,1059,1052,1068,914,455,-184,-609,-447,313,1274,1930,2027,1666,1119,598,162,-214,-565,-902,-1210,-1443,-1547,-1517,-1419,-1351,-1360,-1410,-1430,-1377,-1257,-1091,-893,-687,-521,-434,-410,-372,-250,-51,146,264,294,285,286,308,330,334,317,278,212,118,10,-90,-164,-204,-216,-215,-223,-258,-314,-372,-414,-440,-463,-487,-500,-493,-472,-460,-474,-510,-547,-569,-568,-546,-501,-433,-348,-259,-185,-131,-92,-60,-30,-1,26,49,64,65,56,42,31,18,-7,-46,-85,-106,-107,-100,-100,-111,-127,-144,-163,-186,-206,-212,-203,-188,-179,-184,-196,-203,-198,-185,-173,-168,-169,-173,-176,-176,-172,-160,-141,-124,-113,-108,-102,-90,-76,-67,-64,-66,-72,-85,-106,-128,-142,-150,-158,-177,-205,-231,-240,-231,-214,-203,-198,-194,-185,-173,-161,-147,-125,-100,-83,-81,-84,-74,-47,-13,12,25,33,44,56,65,69,69,61,43,17,-10,-32,-47,-59,-73,-92,-112,-129,-136,-136,-137,-142,-145,-143,-140,-144,-147,-130,-83,-27},
            {196,-383,-428,302,611,-308,-462,3690,12088,18064,13080,-3963,-23048,-30588,-21443,-3151,11633,15952,11944,5739,1597,1067,4988,13261,22487,26179,19553,4522,-10755,-17866,-14106,-3463,7158,12558,11558,6484,966,-2555,-4191,-5815,-8729,-11991,-13230,-11164,-7070,-3587,-2281,-2641,-3336,-3841,-4439,-4965,-4350,-1833,1660,3939,3571,1313,-608,-542,1318,3431,4311,3490,1553,-384,-1342,-1062,-124,575,614,272,-16,-227,-621,-1145,-1339,-934,-344,-276,-894,-1597,-1710,-1239,-798,-899,-1448,-1925,-1902,-1342,-539,92,232,-153,-763,-1162,-1101,-679,-174,218,476,632,672,590,476,478,645,849,864,575,92,-314,-423,-242,9,89,-64,-312,-470,-472,-399,-362,-408,-510,-628,-740,-828,-855,-774,-572,-312,-117,-105,-280,-502,-574,-397,-56,253,383,329,193,79,41,94,232,405,517,479,286,39,-135,-171,-105,-31,-33,-138,-302,-427,-428,-305,-148,-66,-95,-182,-253,-272,-248,-199,-138,-92,-90,-123,-135,-74,50,171,228,210,149,74,3,-52,-82,-95,-101,-106,-97,-61,-6,51,95,115,94,21,-100,-237,-352,-425,-450,-431,-381,-323,-284,-275,-282,-291,-298,-313,-339,-362,-361,-323,-248,-153,-65,-4,28,39,35,11,-34,-83,-105,-84,-37,10,45,73,95,100,80,39,-9,-57,-104,-149,-187,-212,-221,-215,-199,-178,-161,-148,-132,-109,-84,-76,-94,-131,-162,-162,-120,-48,28,86,118,125,116,98,79,67,65,70,75,83,105,145,190,222,226,207,175,138,98,59,27,7}
        },
        {    // H-10e105a.wav
            {1,2,1,0,0,0,2,2,1,1,1,1,1,1,1,0,0,-1,-1,1,2,1,-1,-1,0,2,2,1,1,0,1,2,2,0,-2,0,4,4,0,-3,1,5,1,-6,-6,5,12,7,-2,4,20,21,4,-11,-7,-9,-22,31,279,731,1147,1167,624,-246,-955,-1129,-770,-178,335,636,753,753,682,597,597,776,1161,1677,2174,2496,2542,2300,1860,1362,939,665,548,550,602,614,493,189,-249,-669,-880,-756,-310,313,915,1331,1480,1367,1064,673,287,-50,-341,-602,-825,-978,-1039,-1031,-1002,-996,-1017,-1050,-1076,-1085,-1071,-1024,-941,-825,-692,-555,-425,-310,-212,-127,-52,12,62,100,136,174,205,211,183,131,72,13,-49,-109,-146,-145,-115,-94,-115,-179,-257,-313,-336,-341,-349,-370,-406,-451,-495,-529,-545,-544,-532,-516,-496,-465,-423,-373,-324,-282,-242,-202,-157,-109,-59,-12,23,38,31,10,-9,-12,1,22,38,41,27,2,-30,-60,-84,-100,-113,-128,-146,-164,-176,-180,-179,-180,-189,-207,-231,-255,-269,-266,-244,-214,-188,-177,-177,-179,-174,-160,-143,-126,-112,-99,-86,-73,-64,-62,-72,-96,-130,-166,-191,-198,-187,-168,-156,-157,-167,-181,-192,-199,-202,-198,-183,-161,-135,-110,-86,-65,-50,-42,-42,-45,-44,-34,-13,16,43,61,66,62,50,31,6,-19,-37,-52,-66,-79,-87,-89,-95,-114,-139,-155,-157,-155,-157,-158,-148,-132,-124,-124,-112,-75,-26},
            {307,-170,-505,-48,624,241,-735,801,7211,15319,16839,5943,-13157,-27761,-27317,-12756,4963,14972,14599,8568,2797,443,2502,9018,17995,24348,22427,10975,-4604,-15640,-16419,-7844,4015,12476,14173,10110,3913,-1093,-3952,-5916,-8438,-11306,-12773,-11480,-8037,-4572,-2799,-2732,-3259,-3638,-4045,-4707,-4962,-3685,-716,2480,3909,2892,713,-586,15,1846,3366,3470,2181,411,-778,-889,-239,414,583,394,241,189,-68,-661,-1193,-1151,-592,-176,-431,-1150,-1657,-1568,-1144,-907,-1068,-1402,-1545,-1306,-752,-145,195,79,-399,-905,-1131,-1011,-683,-288,126,510,732,673,392,137,146,420,709,728,395,-94,-428,-432,-190,51,101,-34,-208,-290,-268,-222,-231,-314,-445,-588,-718,-804,-801,-668,-422,-165,-38,-124,-362,-569,-575,-346,-16,227,282,189,64,1,24,121,265,409,470,383,167,-61,-176,-143,-40,22,-20,-149,-290,-358,-307,-173,-50,-21,-84,-176,-234,-248,-230,-189,-136,-102,-116,-154,-149,-60,76,179,199,150,73,-6,-72,-113,-122,-108,-86,-64,-35,5,48,86,114,118,79,-12,-136,-256,-345,-392,-394,-356,-303,-272,-282,-317,-347,-358,-363,-374,-386,-381,-352,-297,-217,-121,-29,35,65,70,58,25,-28,-75,-86,-55,-7,29,46,55,64,66,50,15,-31,-81,-131,-178,-215,-231,-221,-192,-163,-148,-145,-139,-114,-78,-52,-54,-82,-119,-144,-137,-89,-12,66,121,142,139,124,103,80,62,55,61,76,98,128,165,200,218,210,177,129,81,43,19,6}
        },
        {    // H-10e110a.wav
            {1,2,2,2,1,1,1,1,3,3,2,1,1,2,2,0,-1,0,2,2,0,-1,1,2,3,2,0,-1,0,3,4,3,-1,-2,3,8,6,0,-2,3,7,3,-4,-2,5,6,0,1,14,23,13,-2,-2,4,-8,5,179,604,1133,1381,1018,108,-862,-1344,-1138,-494,163,561,694,695,669,653,665,755,993,1424,2012,2608,2986,2945,2450,1676,922,433,280,357,482,504,362,86,-239,-523,-720,-837,-910,-952,-923,-754,-404,91,625,1075,1351,1420,1295,1027,685,339,40,-193,-358,-460,-514,-548,-599,-685,-797,-914,-1022,-1115,-1168,-1141,-1010,-810,-624,-520,-501,-507,-473,-379,-253,-141,-74,-49,-42,-28,0,37,69,88,90,74,43,7,-20,-30,-26,-24,-37,-71,-121,-183,-248,-308,-357,-394,-424,-447,-458,-456,-449,-449,-461,-477,-487,-485,-471,-443,-397,-333,-262,-200,-154,-119,-87,-53,-17,16,43,60,67,70,72,75,75,68,52,33,11,-16,-48,-80,-106,-124,-135,-147,-168,-199,-233,-259,-272,-275,-276,-279,-277,-263,-237,-208,-184,-167,-158,-156,-157,-155,-140,-115,-93,-87,-98,-119,-138,-151,-159,-164,-165,-161,-151,-141,-132,-127,-124,-128,-138,-153,-163,-160,-141,-113,-87,-64,-46,-32,-25,-23,-23,-21,-18,-16,-14,-7,5,14,13,3,-10,-23,-40,-61,-81,-92,-95,-94,-94,-96,-103,-117,-134,-148,-155,-155,-148,-133,-112,-92,-82,-81,-74,-50,-17},
            {224,150,-252,-365,180,564,-128,-633,2255,9495,16138,14075,300,-17949,-28001,-22720,-6607,8906,15407,12742,6219,1072,35,3950,11929,20359,23573,17632,4210,-9638,-16232,-12553,-1839,9208,14948,13822,8246,2052,-2397,-5249,-7857,-10673,-12552,-12050,-9163,-5586,-3252,-2774,-3319,-3827,-4056,-4393,-4852,-4644,-2940,-5,2670,3556,2447,640,-240,406,1824,2730,2406,1162,-61,-501,-131,464,704,525,279,198,113,-232,-715,-901,-594,-164,-173,-739,-1410,-1673,-1472,-1170,-1094,-1233,-1333,-1177,-752,-239,98,77,-268,-687,-915,-880,-715,-545,-340,-12,393,659,612,315,43,24,238,450,434,165,-175,-367,-330,-156,-14,-2,-88,-166,-164,-109,-83,-142,-271,-421,-559,-673,-741,-710,-542,-284,-59,5,-125,-359,-534,-524,-322,-48,142,171,87,-4,-31,14,112,244,365,394,276,58,-133,-190,-113,1,54,1,-127,-253,-290,-208,-66,28,11,-83,-179,-233,-250,-241,-199,-140,-112,-141,-188,-176,-80,47,131,142,102,40,-28,-91,-129,-132,-107,-74,-39,1,45,93,136,160,141,70,-37,-151,-252,-338,-404,-428,-400,-345,-305,-303,-320,-333,-341,-362,-397,-424,-418,-369,-284,-174,-55,50,119,143,125,73,-1,-80,-134,-141,-101,-38,19,52,58,50,35,15,-14,-52,-93,-131,-165,-193,-208,-201,-176,-151,-143,-144,-132,-96,-50,-24,-34,-73,-116,-136,-115,-55,23,93,137,153,147,126,96,66,43,33,38,58,94,139,181,206,206,180,133,79,34,9,2}
        },
        {    // H-10e115a.wav
            {0,0,1,1,1,1,2,2,2,1,0,1,2,1,0,0,0,1,1,1,1,1,1,2,2,1,-1,-1,2,4,3,-1,-1,2,5,3,0,2,5,4,0,0,6,7,-1,-6,4,19,16,1,2,19,11,-17,70,447,1082,1593,1476,573,-691,-1576,-1607,-907,-11,599,795,730,606,528,538,681,1021,1581,2284,2938,3292,3155,2542,1694,947,511,366,350,328,268,184,49,-188,-524,-859,-1072,-1129,-1095,-1066,-1068,-1056,-972,-793,-530,-183,246,727,1178,1495,1615,1544,1341,1079,814,566,331,104,-106,-278,-413,-546,-713,-901,-1047,-1099,-1075,-1037,-1027,-1021,-976,-887,-791,-722,-671,-608,-521,-426,-349,-292,-245,-195,-132,-47,53,146,199,201,172,138,114,95,73,51,34,15,-20,-78,-150,-215,-263,-297,-330,-365,-399,-424,-442,-465,-498,-535,-558,-557,-532,-495,-455,-405,-338,-255,-169,-99,-53,-30,-15,3,28,55,76,87,95,105,115,114,96,62,25,-6,-30,-52,-79,-112,-150,-191,-227,-254,-268,-274,-278,-285,-291,-293,-286,-268,-243,-214,-187,-168,-161,-163,-171,-177,-179,-177,-171,-166,-160,-152,-144,-138,-137,-140,-141,-135,-125,-115,-108,-101,-91,-82,-81,-85,-86,-76,-60,-49,-47,-46,-39,-27,-18,-17,-19,-23,-27,-36,-49,-63,-74,-83,-92,-99,-102,-100,-97,-98,-105,-113,-118,-118,-118,-121,-126,-127,-119,-108,-99,-94,-87,-75,-64,-62,-65,-61,-41,-14},
            {-48,291,200,-288,-379,223,523,-245,-446,3008,10235,15653,11867,-2415,-19026,-26368,-19437,-3814,9908,14878,11606,5028,28,-458,4481,13172,20927,22046,14042,376,-11389,-14784,-8700,2442,12104,15752,12998,6811,785,-3382,-6301,-9168,-11859,-12880,-11121,-7369,-3865,-2385,-2897,-4039,-4657,-4687,-4663,-4677,-4101,-2350,237,2431,3108,2228,851,187,611,1496,1912,1463,552,-74,-7,520,938,902,552,237,80,-100,-428,-697,-588,-132,191,-72,-843,-1574,-1798,-1549,-1222,-1127,-1222,-1247,-1003,-518,-25,197,18,-424,-811,-907,-741,-523,-383,-246,1,309,483,403,176,26,67,212,278,165,-77,-298,-365,-257,-82,4,-68,-213,-280,-203,-64,2,-63,-206,-356,-486,-596,-651,-590,-397,-152,13,9,-150,-361,-489,-453,-274,-64,60,60,-10,-67,-68,-12,87,208,298,287,151,-41,-171,-168,-61,55,94,26,-104,-212,-221,-130,-15,30,-22,-120,-197,-233,-244,-237,-209,-175,-170,-204,-232,-198,-95,22,97,114,90,42,-22,-89,-135,-144,-120,-76,-17,50,116,167,192,181,124,21,-116,-254,-368,-440,-464,-438,-375,-308,-272,-281,-316,-353,-382,-408,-428,-425,-381,-296,-187,-75,19,80,101,83,38,-23,-85,-134,-153,-135,-87,-31,9,24,18,5,-4,-9,-14,-30,-60,-105,-156,-199,-222,-218,-191,-157,-132,-115,-98,-68,-33,-13,-28,-74,-120,-134,-102,-37,36,96,135,147,131,95,56,26,10,6,17,48,96,148,188,206,194,151,86,26,-6,-8}
        },
        {    // H-10e120a.wav
            {1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,-1,-2,-1,1,1,0,-1,0,1,0,0,2,3,2,1,3,4,1,-2,0,6,7,0,-3,5,12,5,-9,-6,15,23,3,-11,10,33,8,18,286,930,1670,1898,1177,-269,-1624,-2094,-1520,-417,525,946,919,709,518,439,538,895,1560,2459,3349,3885,3790,3046,1944,919,273,30,31,117,212,253,130,-236,-767,-1231,-1424,-1345,-1179,-1111,-1162,-1218,-1174,-1038,-877,-722,-539,-289,12,320,619,931,1267,1587,1812,1879,1774,1525,1185,810,446,112,-191,-451,-628,-700,-703,-727,-841,-1031,-1217,-1319,-1311,-1224,-1103,-992,-914,-869,-831,-769,-675,-567,-461,-358,-244,-121,1,112,204,265,274,234,182,163,187,217,212,167,106,51,-4,-68,-133,-183,-217,-255,-314,-390,-461,-513,-546,-571,-591,-597,-581,-540,-478,-403,-324,-254,-201,-170,-155,-139,-108,-56,6,61,98,117,125,123,114,102,91,80,63,33,-6,-43,-70,-88,-106,-135,-176,-224,-264,-289,-298,-298,-295,-288,-276,-262,-251,-245,-238,-228,-220,-222,-231,-237,-229,-208,-183,-159,-140,-126,-122,-127,-135,-136,-123,-102,-83,-68,-57,-46,-36,-28,-24,-22,-22,-25,-29,-31,-30,-26,-22,-23,-30,-42,-55,-69,-84,-100,-113,-124,-133,-143,-153,-160,-160,-151,-140,-132,-131,-134,-135,-128,-110,-88,-70,-59,-54,-54,-55,-55,-50,-40,-29,-26,-30,-32,-24,-9},
            {-191,51,301,122,-329,-334,256,478,-272,-379,2963,9706,14622,10979,-2274,-17589,-24382,-18085,-3697,9191,14160,11271,4772,-567,-1331,3758,12760,20417,20944,12511,-668,-11008,-12862,-6048,4732,13377,15980,12495,5914,-237,-4294,-6924,-9441,-11823,-12578,-10548,-6560,-3010,-1817,-2901,-4625,-5508,-5350,-4832,-4372,-3613,-2027,196,2070,2673,2016,998,550,850,1340,1385,858,175,-115,207,871,1354,1301,797,216,-173,-395,-568,-621,-372,110,405,109,-704,-1511,-1836,-1657,-1326,-1156,-1167,-1154,-931,-494,-39,169,-2,-421,-778,-850,-672,-442,-275,-120,94,304,370,250,71,0,82,212,240,92,-174,-408,-464,-312,-83,26,-70,-270,-387,-328,-163,-36,-23,-102,-219,-347,-466,-528,-472,-291,-71,62,26,-151,-356,-460,-403,-225,-42,45,15,-71,-134,-134,-74,28,147,236,231,113,-52,-155,-132,-15,101,136,67,-64,-179,-209,-144,-46,-1,-40,-122,-190,-228,-250,-262,-253,-226,-210,-218,-221,-174,-77,26,88,101,82,44,-6,-57,-88,-90,-71,-35,19,85,140,159,136,81,6,-88,-191,-286,-358,-403,-418,-400,-354,-308,-290,-308,-337,-353,-350,-341,-333,-320,-291,-246,-188,-120,-54,-5,18,19,6,-19,-58,-103,-130,-124,-89,-44,-9,12,22,23,17,5,-12,-38,-74,-117,-160,-194,-208,-198,-168,-128,-95,-75,-60,-39,-14,-4,-21,-65,-109,-125,-97,-36,36,93,121,120,100,71,42,19,10,15,33,64,104,149,186,200,179,129,68,21,1}
        },
        {    // H-10e125a.wav
            {3,3,2,1,2,3,2,1,1,1,0,0,0,1,1,-1,-1,1,2,1,0,1,1,1,1,2,3,2,1,2,4,3,-1,-1,6,11,5,-5,-2,11,13,-2,-10,7,25,13,-11,-1,36,30,-2,161,754,1652,2236,1817,320,-1484,-2516,-2233,-997,326,1074,1153,869,553,382,439,813,1573,2645,3734,4415,4354,3533,2287,1100,314,-31,-101,-72,-32,-25,-127,-409,-848,-1306,-1622,-1734,-1691,-1577,-1434,-1270,-1106,-984,-923,-875,-756,-523,-222,50,220,301,375,537,838,1249,1665,1955,2032,1905,1651,1336,974,573,182,-118,-288,-377,-472,-619,-801,-985,-1157,-1309,-1412,-1433,-1372,-1268,-1167,-1088,-1030,-986,-938,-849,-685,-457,-230,-79,-22,-10,22,105,217,317,378,395,377,332,268,199,145,118,105,74,8,-80,-156,-209,-262,-344,-447,-535,-573,-563,-531,-498,-467,-439,-421,-418,-417,-398,-350,-283,-210,-140,-76,-26,2,15,29,56,94,122,125,105,76,50,32,15,0,-11,-17,-23,-42,-81,-134,-187,-231,-264,-289,-306,-311,-302,-286,-276,-280,-292,-304,-308,-300,-280,-250,-217,-191,-176,-171,-165,-152,-134,-116,-98,-81,-66,-55,-48,-43,-34,-23,-9,3,13,20,23,21,15,5,-7,-19,-30,-41,-56,-75,-96,-114,-129,-146,-165,-181,-188,-185,-179,-177,-181,-186,-187,-180,-164,-143,-120,-97,-76,-55,-38,-25,-17,-14,-12,-11,-10,-8,-3,0,-1,-9,-15,-13,-5},
            {-8,-177,-63,218,187,-205,-331,135,449,-125,-414,2188,8177,13301,11225,27,-14328,-22130,-18101,-5543,7118,13189,11495,5291,-707,-2455,1952,10850,18967,20382,13023,761,-9152,-11181,-4942,5251,13592,16146,12557,5584,-1071,-5240,-7274,-8800,-10536,-11467,-10187,-6826,-3349,-1859,-2763,-4657,-5856,-5823,-5129,-4365,-3426,-1913,51,1668,2204,1724,1008,784,1112,1484,1391,765,0,-363,-21,840,1636,1808,1258,386,-320,-673,-759,-648,-298,211,532,302,-449,-1269,-1695,-1651,-1412,-1253,-1209,-1133,-899,-526,-163,6,-111,-422,-693,-735,-558,-329,-171,-55,103,283,365,277,101,0,56,194,253,123,-165,-454,-570,-448,-195,-13,-32,-207,-375,-406,-305,-167,-79,-67,-118,-210,-319,-391,-368,-234,-45,89,78,-82,-296,-429,-396,-226,-36,58,28,-73,-166,-203,-164,-53,101,229,253,152,-7,-115,-106,1,122,170,104,-49,-203,-267,-213,-100,-27,-41,-115,-193,-243,-266,-265,-241,-207,-191,-200,-204,-161,-68,37,110,136,124,89,42,-3,-30,-41,-47,-54,-51,-25,19,63,88,85,47,-29,-136,-253,-355,-423,-445,-419,-358,-288,-240,-227,-241,-266,-291,-315,-336,-351,-347,-315,-247,-152,-53,19,49,43,15,-25,-72,-112,-126,-101,-47,7,40,47,37,18,-3,-26,-45,-62,-80,-103,-128,-147,-148,-133,-109,-89,-78,-68,-51,-23,5,14,-10,-62,-115,-137,-110,-43,35,94,121,119,99,74,56,50,50,52,57,72,101,140,176,194,182,140,79,23}
        },
        {    // H-10e130a.wav
            {1,1,2,3,1,0,0,1,1,-1,-1,-1,-1,-1,-1,1,1,0,-2,-1,1,-1,-2,-1,3,4,0,-1,2,4,0,-3,2,9,5,-7,-8,7,15,-1,-18,-4,26,25,-9,-17,27,49,4,67,565,1550,2471,2443,1043,-1134,-2809,-3005,-1788,-89,1109,1435,1140,680,365,343,719,1580,2857,4203,5070,5019,4017,2506,1117,268,-44,-91,-111,-153,-181,-245,-493,-996,-1628,-2124,-2285,-2125,-1824,-1576,-1453,-1402,-1331,-1188,-974,-712,-428,-159,56,185,244,285,373,540,768,1000,1174,1274,1345,1442,1554,1586,1449,1163,857,638,488,293,-19,-395,-714,-909,-1003,-1065,-1143,-1243,-1347,-1425,-1457,-1435,-1372,-1277,-1149,-986,-812,-662,-546,-433,-293,-141,-17,69,149,257,368,426,406,339,280,251,240,230,211,178,119,31,-70,-158,-221,-265,-299,-325,-342,-358,-386,-426,-465,-488,-494,-493,-492,-481,-441,-364,-269,-189,-142,-121,-103,-72,-31,6,31,47,51,43,27,17,25,48,69,73,59,33,-1,-41,-84,-126,-164,-205,-251,-292,-318,-325,-323,-328,-340,-349,-345,-331,-312,-293,-271,-245,-219,-199,-186,-174,-156,-132,-108,-83,-59,-35,-15,-5,-5,-10,-12,-5,10,27,39,43,40,34,25,14,-3,-28,-62,-100,-134,-161,-183,-200,-213,-220,-221,-217,-215,-216,-217,-214,-205,-191,-173,-151,-125,-98,-75,-58,-46,-38,-31,-24,-14,1,17,28,30,24,12,0,-10,-15,-14,-9,-3},
            {108,-15,-164,-81,177,211,-116,-324,9,403,58,-447,1112,5965,11389,11709,3609,-9460,-19043,-18563,-8695,3735,11509,11740,6372,-139,-3295,-446,7617,16340,19794,14910,4152,-5997,-9590,-5067,4280,12869,16209,13125,5921,-1437,-6002,-7531,-7855,-8622,-9663,-9547,-7511,-4579,-2676,-2823,-4331,-5686,-5982,-5403,-4539,-3552,-2190,-431,1163,1891,1631,998,751,1107,1640,1746,1189,265,-422,-386,389,1396,1955,1711,870,-56,-679,-914,-815,-433,107,498,412,-182,-938,-1429,-1509,-1365,-1252,-1247,-1241,-1090,-763,-378,-134,-168,-429,-687,-721,-507,-218,-28,55,131,255,359,347,223,96,71,147,212,141,-99,-403,-594,-560,-346,-122,-42,-134,-293,-389,-369,-272,-173,-125,-139,-198,-273,-328,-321,-224,-60,93,135,25,-182,-359,-402,-296,-125,1,25,-37,-122,-173,-157,-68,68,193,238,174,43,-63,-77,-1,93,126,54,-101,-263,-342,-296,-169,-62,-50,-121,-210,-260,-266,-247,-217,-182,-158,-157,-157,-122,-33,77,153,167,131,77,20,-35,-87,-129,-153,-146,-102,-25,60,120,136,102,27,-79,-193,-290,-353,-382,-382,-354,-299,-237,-205,-223,-279,-342,-385,-402,-395,-365,-317,-258,-197,-135,-74,-25,2,3,-10,-28,-47,-64,-71,-60,-30,4,26,28,14,-5,-23,-36,-45,-55,-70,-89,-105,-112,-109,-97,-83,-75,-80,-88,-84,-60,-30,-20,-45,-93,-135,-145,-113,-46,35,101,130,122,98,78,71,67,62,59,66,80,99,122,148,164,149,96,32}
        },
        {    // H-10e135a.wav
            {3,4,3,0,0,2,2,-1,-3,0,2,1,-1,0,1,1,-1,-2,0,0,-1,0,3,5,1,-2,2,5,1,-6,-1,12,14,-2,-14,-1,18,10,-16,-16,17,35,3,-23,14,63,28,16,395,1396,2601,3005,1836,-595,-2916,-3732,-2704,-708,990,1676,1459,878,403,285,670,1652,3145,4730,5753,5682,4494,2732,1157,241,-63,-119,-208,-334,-380,-368,-513,-995,-1735,-2417,-2741,-2652,-2333,-2012,-1781,-1597,-1409,-1235,-1116,-1008,-790,-391,95,458,557,451,352,444,739,1080,1271,1224,1020,830,777,849,947,1001,1023,1049,1052,955,719,399,82,-197,-462,-724,-937,-1055,-1089,-1109,-1174,-1291,-1421,-1515,-1526,-1424,-1215,-960,-742,-605,-526,-443,-321,-166,-10,118,207,252,262,253,251,270,303,325,309,244,150,63,16,6,5,-19,-70,-130,-179,-217,-255,-300,-347,-389,-421,-447,-467,-478,-473,-444,-391,-325,-265,-225,-204,-185,-156,-117,-80,-56,-48,-48,-44,-26,8,53,98,127,132,111,71,23,-22,-57,-90,-131,-187,-248,-294,-316,-320,-319,-322,-330,-337,-340,-337,-322,-298,-271,-249,-233,-215,-191,-162,-136,-115,-96,-79,-65,-50,-27,3,32,45,43,34,31,35,42,46,48,44,32,8,-23,-59,-95,-133,-172,-207,-237,-257,-270,-273,-265,-249,-230,-212,-199,-188,-176,-162,-144,-126,-107,-86,-66,-47,-34,-25,-20,-17,-15,-11,-3,10,22,30,31,28,21,11,-3,-14,-14,-6},
            {-49,88,90,-77,-151,28,200,41,-249,-160,249,238,-304,165,3461,8694,11442,7243,-3466,-14389,-18104,-12182,-910,8530,11381,7712,1227,-3364,-2682,3653,12410,18192,16864,8718,-1381,-7262,-5596,2145,10984,15715,13918,7054,-879,-6173,-7734,-7189,-6867,-7612,-8401,-7869,-5942,-3933,-3212,-3974,-5259,-5979,-5764,-4920,-3818,-2525,-1006,493,1458,1568,1081,675,858,1508,2005,1802,923,-44,-424,19,924,1646,1734,1200,392,-321,-742,-823,-585,-143,257,326,-37,-637,-1131,-1310,-1240,-1148,-1187,-1315,-1352,-1155,-755,-365,-217,-368,-636,-753,-597,-274,15,176,261,345,420,416,314,189,135,168,209,156,-27,-281,-483,-532,-419,-236,-120,-141,-263,-375,-393,-318,-217,-155,-158,-216,-304,-385,-407,-327,-155,37,148,113,-48,-246,-370,-359,-232,-77,17,19,-34,-81,-77,-17,82,180,226,179,52,-86,-151,-113,-16,56,36,-85,-250,-370,-379,-285,-168,-113,-142,-207,-249,-244,-206,-153,-100,-67,-69,-95,-101,-55,29,96,101,48,-26,-85,-113,-116,-104,-86,-65,-39,-7,26,49,53,34,-9,-73,-148,-217,-270,-312,-345,-362,-354,-325,-301,-304,-332,-362,-373,-367,-355,-341,-320,-286,-238,-178,-111,-48,-2,19,15,-5,-30,-52,-62,-57,-36,-7,19,32,26,5,-17,-32,-41,-51,-66,-82,-94,-100,-102,-100,-96,-95,-104,-120,-128,-121,-102,-87,-85,-98,-115,-120,-97,-39,37,99,128,128,116,105,90,72,61,62,67,68,71,88,113,117,82,28}
        },
        {    // H-10e140a.wav
            {5,2,0,1,1,0,-1,0,1,-1,-3,-2,2,3,1,-1,0,0,-2,-1,4,7,2,-4,-1,7,6,-6,-8,6,18,6,-13,-9,14,16,-11,-24,7,37,13,-29,-4,66,57,1,265,1228,2644,3471,2620,64,-2849,-4356,-3665,-1481,712,1834,1777,1110,465,239,647,1794,3546,5385,6526,6361,4905,2845,1099,198,7,6,-181,-508,-709,-701,-718,-1072,-1798,-2590,-3055,-3038,-2695,-2306,-2036,-1869,-1718,-1551,-1381,-1181,-870,-417,75,412,489,401,369,551,916,1280,1459,1392,1165,928,778,697,604,472,374,411,577,744,771,632,416,224,82,-52,-216,-412,-615,-806,-976,-1126,-1261,-1364,-1402,-1346,-1215,-1068,-954,-863,-751,-605,-462,-358,-280,-183,-54,71,147,170,172,179,194,206,211,208,198,183,170,161,136,75,-16,-100,-143,-145,-138,-148,-178,-212,-248,-296,-360,-420,-444,-418,-361,-310,-292,-304,-322,-321,-295,-254,-212,-172,-138,-110,-90,-73,-47,-6,45,92,120,125,107,72,28,-14,-51,-89,-139,-198,-251,-279,-284,-282,-289,-304,-317,-321,-317,-310,-295,-270,-239,-214,-203,-200,-195,-178,-153,-127,-103,-81,-57,-32,-10,5,15,28,45,63,72,71,66,60,51,30,-3,-42,-82,-121,-162,-201,-232,-252,-265,-273,-274,-263,-244,-225,-210,-196,-181,-166,-154,-143,-128,-108,-85,-62,-43,-29,-22,-22,-27,-31,-31,-27,-18,-4,11,22,27,25,19,9,-4,-17,-22,-17,-6},
            {-44,-61,18,81,6,-113,-66,114,132,-99,-221,34,276,-20,-254,1312,5424,9682,9574,2695,-7931,-15432,-14602,-6197,3934,9642,8659,3201,-2296,-3917,-112,7532,14861,17346,13081,4432,-3255,-5198,-395,7813,14063,14465,8922,830,-5502,-7801,-6955,-5617,-5680,-6907,-7703,-6977,-5196,-3785,-3721,-4754,-5839,-6124,-5493,-4334,-2982,-1532,-76,1048,1444,1103,571,526,1152,1950,2198,1626,651,-9,64,695,1342,1544,1210,574,-50,-462,-604,-498,-219,82,198,-14,-496,-995,-1253,-1211,-1053,-1022,-1201,-1428,-1450,-1159,-705,-383,-377,-602,-781,-695,-358,24,261,333,350,403,475,493,430,335,272,247,206,93,-91,-282,-393,-377,-275,-185,-195,-302,-418,-447,-372,-256,-175,-158,-193,-265,-362,-446,-453,-345,-163,-5,42,-33,-170,-277,-288,-194,-47,71,104,64,9,-7,28,94,159,190,157,52,-86,-186,-191,-110,-14,15,-62,-217,-368,-432,-376,-249,-139,-106,-139,-182,-189,-156,-104,-55,-29,-41,-90,-143,-152,-98,-10,57,72,43,0,-37,-63,-82,-96,-100,-88,-57,-11,39,74,78,40,-37,-134,-227,-297,-339,-359,-362,-345,-312,-283,-280,-312,-359,-396,-404,-389,-360,-322,-273,-216,-156,-100,-50,-7,22,30,15,-8,-25,-31,-27,-15,10,43,65,60,30,-7,-31,-41,-47,-57,-71,-84,-100,-116,-128,-127,-118,-114,-122,-139,-149,-141,-116,-89,-77,-86,-97,-84,-32,42,112,157,171,160,127,88,62,57,62,61,57,65,87,98,74,27}
        },
        {    // H-10e145a.wav
            {0,1,2,-1,-3,-3,-1,-1,-3,-3,0,2,-1,-3,-2,-2,-5,-6,-1,6,4,-4,-5,2,4,-7,-12,0,14,7,-14,-15,9,19,-8,-30,-3,37,20,-34,-26,57,78,4,177,1085,2653,3853,3344,752,-2676,-4885,-4617,-2335,329,1929,2088,1355,522,169,621,1998,4087,6211,7420,7044,5202,2800,928,131,130,218,-68,-614,-1008,-1058,-1011,-1284,-2013,-2895,-3454,-3434,-2980,-2452,-2116,-1985,-1915,-1798,-1632,-1432,-1135,-657,-45,484,702,589,378,374,705,1227,1642,1730,1491,1122,837,710,655,559,408,281,228,209,152,58,-3,10,55,56,-11,-107,-202,-307,-459,-663,-888,-1080,-1183,-1155,-1011,-828,-710,-700,-749,-769,-712,-597,-459,-315,-175,-62,-5,-7,-34,-35,16,109,208,268,265,208,137,87,60,34,-8,-57,-89,-93,-84,-83,-102,-139,-183,-223,-251,-264,-268,-269,-270,-276,-291,-321,-358,-379,-363,-311,-245,-194,-169,-163,-159,-146,-121,-81,-30,24,63,71,45,-1,-40,-55,-49,-49,-78,-134,-195,-238,-257,-260,-260,-264,-271,-280,-283,-275,-252,-227,-212,-213,-222,-226,-216,-195,-165,-128,-92,-67,-58,-57,-49,-29,-3,18,32,43,56,65,63,49,26,-1,-34,-74,-120,-166,-207,-239,-260,-271,-272,-264,-251,-233,-212,-190,-171,-158,-152,-151,-153,-151,-141,-124,-102,-77,-53,-36,-28,-31,-39,-45,-46,-44,-43,-40,-29,-9,9,16,9,-7,-21,-31,-39,-45,-43,-29,-10},
            {43,-8,-69,-42,53,72,-35,-109,-8,131,61,-151,-145,132,199,-150,74,2369,6527,9450,7270,-632,-9904,-14238,-10631,-1888,5906,8247,5048,-277,-3647,-2621,2729,9955,15249,15423,10107,2472,-2591,-1812,4094,10895,13815,10768,3572,-3628,-7391,-7177,-5164,-4077,-4965,-6731,-7529,-6590,-4799,-3712,-4093,-5351,-6254,-6059,-4955,-3555,-2202,-855,440,1285,1293,663,173,472,1427,2245,2253,1503,652,327,639,1206,1524,1332,730,51,-387,-479,-331,-118,46,106,-13,-369,-885,-1311,-1411,-1199,-956,-973,-1260,-1542,-1523,-1168,-723,-481,-530,-698,-735,-525,-158,178,366,427,452,496,537,538,500,469,469,461,373,174,-81,-283,-354,-306,-235,-232,-319,-430,-478,-432,-332,-247,-221,-250,-307,-371,-424,-442,-404,-314,-210,-146,-150,-201,-247,-231,-133,13,139,182,137,54,0,6,54,109,146,148,100,1,-118,-200,-208,-156,-103,-108,-183,-284,-347,-332,-249,-154,-104,-113,-156,-189,-192,-170,-133,-96,-76,-84,-110,-119,-80,0,72,93,58,-5,-63,-98,-109,-99,-75,-50,-33,-22,-11,-1,-4,-29,-75,-131,-183,-224,-258,-288,-317,-338,-344,-337,-331,-342,-368,-393,-400,-383,-351,-309,-259,-205,-155,-113,-74,-33,8,37,45,36,21,9,2,4,18,40,59,57,32,-5,-35,-51,-57,-64,-81,-103,-123,-135,-138,-135,-127,-122,-124,-138,-156,-163,-147,-117,-90,-77,-72,-56,-16,43,105,150,163,145,109,76,62,61,65,66,69,72,67,46,16}
        },
        {    // H-10e150a.wav
            {1,-1,-4,-4,-1,-1,-3,-4,-2,1,-1,-4,-3,-1,-4,-6,-2,5,4,-3,-5,3,6,-5,-14,-3,13,9,-13,-19,5,20,-5,-33,-10,39,32,-32,-44,40,89,19,130,978,2643,4156,3990,1446,-2399,-5287,-5523,-3257,-174,1943,2398,1650,619,92,558,2193,4696,7178,8459,7784,5426,2590,604,11,316,557,165,-658,-1307,-1449,-1335,-1502,-2217,-3212,-3923,-3965,-3412,-2681,-2168,-1982,-1971,-1945,-1828,-1624,-1296,-774,-100,490,730,583,325,328,734,1338,1775,1815,1519,1138,889,807,775,677,512,363,281,217,86,-123,-323,-421,-415,-384,-396,-445,-472,-436,-368,-341,-412,-562,-703,-747,-678,-572,-510,-513,-531,-523,-499,-490,-486,-441,-333,-204,-122,-108,-119,-93,-8,106,189,197,128,26,-45,-47,0,38,26,-28,-86,-120,-134,-143,-147,-138,-119,-112,-139,-197,-252,-271,-247,-206,-190,-214,-260,-293,-289,-254,-210,-177,-158,-153,-159,-167,-163,-135,-86,-41,-22,-34,-63,-90,-105,-106,-100,-101,-123,-167,-210,-229,-217,-193,-183,-195,-214,-223,-221,-216,-212,-207,-204,-210,-226,-238,-227,-185,-129,-83,-59,-52,-49,-38,-20,-3,7,9,9,9,9,5,0,-7,-20,-48,-92,-141,-180,-204,-220,-236,-253,-264,-266,-259,-241,-214,-182,-151,-130,-117,-111,-108,-110,-113,-116,-115,-108,-94,-73,-49,-34,-34,-47,-61,-70,-71,-67,-59,-50,-37,-23,-9,-2,-7,-24,-45,-62,-72,-77,-76,-65,-41,-13},
            {-22,27,44,-13,-70,-31,58,55,-53,-96,19,121,14,-160,-88,161,125,-164,423,3055,6896,8677,5322,-2538,-10094,-12074,-7295,408,5618,5652,1918,-2032,-3232,-661,4784,10778,14374,13473,8457,2475,-462,1591,6920,11337,11272,6328,-628,-5764,-7059,-5411,-3447,-3236,-4848,-6743,-7356,-6395,-4874,-4066,-4440,-5413,-5995,-5620,-4440,-2961,-1540,-288,663,1045,753,179,37,714,1826,2537,2329,1465,690,546,983,1509,1646,1249,530,-141,-477,-432,-175,57,118,-21,-335,-765,-1192,-1438,-1396,-1163,-1003,-1117,-1438,-1674,-1579,-1180,-747,-545,-604,-721,-666,-374,25,347,506,545,549,566,591,614,639,671,685,633,480,238,-26,-226,-304,-281,-240,-268,-374,-484,-512,-440,-338,-285,-305,-368,-434,-489,-521,-500,-405,-257,-121,-66,-107,-203,-284,-291,-204,-58,76,143,141,112,97,101,101,90,74,54,12,-58,-130,-161,-137,-95,-89,-144,-235,-310,-328,-280,-195,-125,-111,-149,-196,-209,-177,-124,-76,-51,-53,-76,-104,-109,-78,-24,17,22,-7,-41,-58,-57,-52,-56,-74,-93,-96,-76,-46,-27,-33,-62,-105,-151,-194,-228,-254,-277,-308,-343,-367,-368,-352,-340,-343,-352,-347,-324,-290,-256,-220,-179,-131,-82,-38,-1,32,57,68,62,45,27,16,17,24,33,36,24,-2,-33,-56,-65,-66,-73,-88,-107,-120,-129,-136,-142,-144,-142,-140,-145,-153,-151,-131,-99,-70,-53,-41,-19,22,73,116,134,131,116,100,86,74,67,67,67,57,35,11}
        },
        {    // H-10e155a.wav
            {-2,-2,0,0,-2,-3,0,3,2,-1,-2,-1,-3,-4,0,5,5,-2,-3,5,9,-2,-13,-4,15,12,-12,-20,5,24,0,-35,-17,38,44,-20,-48,27,90,33,122,943,2674,4406,4507,2032,-2109,-5562,-6295,-4145,-758,1845,2654,1967,774,67,534,2429,5362,8216,9567,8565,5627,2281,132,-232,472,973,530,-590,-1562,-1862,-1714,-1770,-2437,-3505,-4354,-4485,-3894,-3004,-2306,-2011,-2009,-2062,-2015,-1818,-1435,-823,-48,634,919,728,345,215,573,1255,1842,2009,1740,1280,902,720,673,641,562,454,346,233,93,-71,-232,-374,-518,-675,-814,-871,-817,-696,-593,-578,-656,-760,-788,-660,-395,-113,42,13,-131,-272,-338,-337,-304,-251,-178,-91,-15,32,47,34,2,-32,-48,-47,-50,-74,-102,-99,-59,-26,-48,-126,-208,-241,-218,-173,-139,-130,-140,-167,-210,-259,-286,-271,-215,-144,-99,-99,-135,-174,-183,-148,-88,-36,-22,-52,-110,-164,-190,-179,-140,-92,-57,-50,-79,-134,-189,-216,-208,-187,-181,-202,-236,-252,-235,-195,-160,-147,-156,-172,-185,-189,-185,-178,-175,-182,-199,-214,-207,-168,-105,-39,9,32,38,36,31,25,16,8,-1,-12,-29,-53,-79,-103,-123,-138,-151,-162,-174,-192,-218,-248,-268,-270,-256,-235,-213,-191,-166,-140,-117,-101,-88,-77,-69,-67,-67,-63,-56,-47,-44,-44,-47,-52,-59,-65,-69,-69,-71,-75,-76,-70,-54,-35,-21,-17,-26,-45,-68,-87,-95,-96,-94,-87,-71,-43,-14},
            {8,-23,-19,25,37,-17,-61,-16,60,39,-64,-84,38,113,-11,-155,-49,171,84,-136,656,3351,6781,7805,4059,-3137,-9144,-9829,-5194,819,3970,3055,55,-2166,-1910,971,5578,10269,12961,12157,8303,3983,2217,4060,7631,9563,7665,2594,-2793,-5719,-5483,-3645,-2487,-3175,-5104,-6744,-7046,-6178,-5128,-4721,-4978,-5297,-5128,-4433,-3524,-2602,-1591,-451,508,821,435,-53,110,1076,2210,2696,2284,1439,832,783,1129,1492,1575,1291,751,170,-248,-416,-382,-251,-139,-165,-426,-895,-1363,-1567,-1434,-1180,-1122,-1363,-1691,-1795,-1554,-1133,-801,-690,-713,-681,-471,-116,249,502,618,650,660,676,695,723,772,824,821,703,465,181,-47,-153,-150,-116,-141,-260,-428,-553,-574,-507,-424,-386,-399,-432,-462,-487,-496,-463,-369,-241,-141,-118,-170,-247,-292,-277,-209,-122,-53,-14,12,53,114,166,179,148,93,30,-40,-107,-144,-125,-65,-20,-42,-134,-250,-327,-323,-246,-141,-65,-49,-80,-122,-146,-147,-137,-126,-121,-129,-150,-167,-151,-98,-34,1,-7,-38,-61,-67,-60,-50,-43,-49,-71,-101,-118,-112,-95,-88,-102,-130,-159,-187,-216,-247,-273,-290,-299,-305,-311,-317,-323,-327,-327,-318,-297,-266,-226,-182,-138,-96,-55,-15,20,40,45,42,41,42,39,29,21,21,26,20,-2,-30,-51,-59,-64,-75,-91,-102,-109,-117,-131,-143,-145,-140,-136,-143,-155,-158,-144,-114,-80,-51,-30,-11,11,39,68,94,111,113,103,87,75,72,70,60,38,12}
        },
        {    // H-10e160a.wav
            {-3,-3,-4,-4,-1,1,-1,-2,-2,-1,-4,-6,-2,4,4,-3,-5,3,8,-3,-13,-6,12,10,-13,-22,2,21,0,-35,-21,31,40,-17,-44,25,82,28,132,983,2782,4633,4862,2415,-1903,-5724,-6851,-4894,-1377,1593,2773,2250,978,114,580,2745,6111,9295,10636,9252,5758,1966,-318,-505,526,1282,870,-443,-1698,-2203,-2098,-2086,-2704,-3824,-4791,-5000,-4365,-3326,-2457,-2062,-2064,-2197,-2236,-2068,-1626,-889,20,795,1109,903,489,326,653,1299,1852,1996,1722,1275,923,772,739,690,565,405,259,118,-58,-261,-411,-445,-400,-402,-534,-756,-942,-1007,-982,-970,-1037,-1135,-1139,-957,-614,-238,37,159,167,121,54,-13,-36,45,231,434,525,438,223,0,-129,-141,-80,-19,-11,-67,-155,-228,-261,-264,-267,-284,-304,-308,-296,-281,-277,-280,-282,-286,-302,-325,-332,-293,-206,-110,-58,-65,-102,-113,-69,11,82,110,89,33,-38,-106,-145,-140,-97,-52,-42,-82,-152,-217,-252,-256,-242,-230,-235,-259,-287,-294,-267,-221,-187,-187,-212,-235,-231,-203,-170,-152,-155,-171,-188,-191,-168,-114,-40,33,79,88,74,60,62,71,66,35,-13,-64,-107,-142,-167,-177,-172,-163,-165,-184,-209,-230,-242,-251,-261,-267,-263,-245,-218,-187,-156,-130,-111,-103,-102,-102,-95,-78,-57,-39,-26,-14,-3,3,-4,-22,-46,-67,-81,-90,-94,-92,-86,-79,-70,-61,-52,-47,-53,-69,-90,-112,-127,-133,-130,-120,-107,-91,-69,-40,-12},
            {3,18,3,-24,-14,27,32,-22,-57,-7,59,27,-70,-72,49,103,-27,-147,-22,172,57,-113,753,3339,6381,7031,3469,-2785,-7658,-8012,-4353,-44,1918,1182,-500,-1310,-526,1775,5224,9000,11639,11768,9387,6227,4490,4980,6416,6604,4360,491,-2955,-4386,-3817,-2636,-2346,-3435,-5214,-6553,-6806,-6183,-5415,-5069,-5102,-5020,-4435,-3476,-2604,-2072,-1663,-1032,-212,378,468,336,540,1274,2119,2478,2181,1583,1162,1094,1234,1357,1351,1212,971,650,264,-157,-538,-760,-753,-602,-534,-725,-1119,-1463,-1569,-1497,-1470,-1613,-1814,-1843,-1599,-1202,-866,-697,-619,-480,-210,119,385,532,603,673,761,838,874,876,866,846,791,674,488,257,32,-122,-167,-136,-122,-195,-342,-480,-545,-542,-520,-501,-465,-404,-353,-354,-404,-448,-440,-387,-340,-334,-360,-379,-353,-275,-168,-70,-16,-9,-22,-23,0,34,68,98,118,108,52,-32,-101,-118,-85,-41,-20,-36,-76,-114,-130,-118,-97,-98,-135,-187,-220,-217,-190,-161,-144,-141,-153,-178,-201,-198,-162,-108,-65,-46,-44,-44,-41,-39,-48,-72,-107,-141,-158,-154,-135,-112,-93,-83,-89,-115,-155,-194,-220,-237,-252,-266,-273,-276,-287,-311,-334,-335,-307,-263,-221,-184,-149,-112,-80,-57,-39,-22,-3,18,37,51,56,52,40,26,13,0,-14,-32,-52,-68,-78,-82,-86,-96,-107,-116,-122,-129,-138,-145,-145,-142,-145,-152,-151,-131,-95,-60,-37,-24,-13,3,24,47,67,78,80,79,83,87,77,50,16}
        },
        {    // H-10e165a.wav
            {-5,-4,0,3,1,-2,-3,-3,-5,-6,-2,4,2,-5,-6,3,7,-3,-13,-4,12,8,-14,-22,2,19,-3,-36,-21,27,33,-19,-37,30,73,18,163,1096,2974,4859,5068,2566,-1844,-5816,-7147,-5372,-1901,1217,2667,2375,1182,286,779,3166,6896,10348,11626,9825,5792,1645,-666,-646,613,1474,1028,-397,-1784,-2408,-2380,-2391,-3002,-4140,-5177,-5466,-4841,-3700,-2663,-2126,-2084,-2273,-2409,-2310,-1863,-1041,1,900,1283,1081,639,462,798,1456,1997,2107,1795,1311,915,722,692,700,622,398,72,-234,-394,-377,-268,-201,-267,-460,-707,-917,-1031,-1037,-985,-970,-1065,-1239,-1349,-1252,-935,-548,-275,-184,-183,-131,47,314,580,768,842,803,684,541,420,341,293,259,215,142,21,-138,-287,-374,-390,-378,-395,-452,-515,-540,-519,-478,-444,-423,-407,-394,-390,-392,-386,-350,-275,-181,-99,-51,-31,-14,24,85,147,178,162,107,40,-14,-41,-40,-21,0,0,-35,-104,-183,-244,-269,-267,-258,-265,-291,-320,-328,-310,-276,-253,-257,-284,-313,-319,-294,-245,-189,-141,-110,-96,-90,-80,-57,-21,22,59,82,93,97,96,85,57,9,-48,-98,-133,-150,-154,-153,-153,-162,-184,-214,-241,-257,-265,-269,-271,-267,-255,-236,-215,-194,-172,-148,-127,-114,-109,-108,-104,-94,-80,-62,-42,-20,0,12,15,8,-8,-29,-47,-59,-63,-66,-72,-81,-87,-87,-86,-88,-92,-96,-101,-113,-131,-149,-159,-163,-162,-152,-123,-77,-30,-1,4},
            {-4,-9,5,17,0,-24,-11,28,29,-23,-51,-2,54,17,-68,-58,55,90,-38,-134,-3,165,40,-98,745,3119,5842,6438,3423,-1868,-6106,-6843,-4490,-1493,138,250,-130,-170,381,1732,4226,7682,10881,12206,11005,8244,5697,4464,4209,3744,2248,-11,-2009,-2911,-2753,-2340,-2543,-3628,-5128,-6285,-6633,-6271,-5655,-5154,-4782,-4331,-3706,-3054,-2554,-2157,-1636,-914,-228,125,175,302,815,1590,2188,2295,1989,1591,1353,1316,1387,1451,1416,1233,931,592,275,-30,-341,-619,-798,-884,-965,-1099,-1245,-1327,-1361,-1454,-1669,-1921,-2040,-1916,-1589,-1190,-838,-579,-389,-217,-23,190,384,524,607,670,751,860,970,1043,1044,959,796,588,374,191,63,-7,-43,-87,-171,-285,-383,-423,-401,-356,-327,-330,-355,-392,-442,-502,-559,-591,-588,-555,-511,-471,-444,-427,-399,-340,-248,-144,-56,3,43,72,82,62,23,-5,-1,28,57,75,91,116,136,129,83,9,-66,-124,-155,-163,-160,-161,-175,-198,-216,-223,-218,-210,-202,-197,-198,-207,-215,-211,-188,-152,-113,-82,-63,-57,-61,-72,-89,-111,-132,-141,-129,-103,-78,-66,-65,-65,-70,-87,-118,-154,-182,-203,-226,-255,-280,-292,-293,-291,-290,-283,-260,-225,-190,-165,-146,-126,-101,-76,-52,-27,3,36,60,67,57,40,25,14,2,-15,-36,-55,-70,-80,-88,-93,-91,-86,-86,-98,-119,-137,-142,-138,-134,-136,-136,-130,-121,-110,-95,-72,-45,-27,-20,-13,7,36,62,79,92,101,96,66,23}
        },
        {    // H-10e170a.wav
            {-2,0,0,0,-1,-3,-6,-6,-1,3,0,-5,-2,5,4,-7,-12,0,13,4,-18,-19,5,15,-10,-33,-10,30,20,-32,-31,44,67,4,218,1285,3256,5086,5113,2446,-1994,-5892,-7190,-5511,-2200,841,2371,2263,1253,506,1166,3784,7755,11307,12421,10226,5767,1382,-893,-673,759,1639,1080,-485,-1959,-2614,-2600,-2638,-3287,-4462,-5533,-5852,-5234,-4049,-2911,-2259,-2153,-2359,-2564,-2510,-2037,-1128,5,952,1335,1116,677,543,953,1673,2223,2287,1931,1457,1100,871,659,415,203,93,55,-12,-153,-311,-401,-419,-454,-595,-835,-1076,-1208,-1193,-1090,-1011,-1037,-1155,-1262,-1247,-1087,-851,-622,-420,-211,14,206,317,372,459,638,866,1038,1075,983,829,677,552,445,337,215,76,-76,-231,-375,-500,-600,-671,-713,-723,-706,-671,-630,-592,-563,-545,-539,-537,-518,-455,-339,-199,-82,-24,-18,-21,9,79,163,221,232,195,125,48,-9,-23,14,79,127,115,37,-73,-165,-214,-230,-245,-276,-321,-361,-379,-370,-340,-310,-303,-326,-363,-380,-352,-284,-205,-145,-114,-103,-92,-69,-30,20,70,104,109,82,42,8,-7,-14,-28,-52,-75,-87,-90,-96,-113,-136,-158,-178,-202,-227,-247,-258,-263,-266,-270,-267,-253,-229,-203,-182,-167,-152,-138,-125,-118,-113,-104,-85,-63,-44,-31,-19,-5,3,-2,-15,-26,-27,-23,-22,-28,-39,-52,-69,-87,-100,-105,-106,-111,-122,-133,-143,-154,-167,-176,-177,-171,-157,-127,-75,-12,33,40,17},
            {5,6,-5,-8,8,17,0,-22,-8,26,24,-21,-42,2,45,8,-61,-44,53,74,-40,-112,10,149,29,-84,675,2783,5258,6017,3721,-730,-4760,-6267,-5170,-2952,-1052,67,586,708,702,1264,3254,6771,10595,12839,12333,9502,5965,3300,2053,1682,1280,367,-842,-1812,-2259,-2417,-2792,-3677,-4893,-5951,-6443,-6310,-5777,-5098,-4384,-3661,-3024,-2640,-2546,-2497,-2113,-1243,-174,596,819,713,725,1098,1679,2110,2166,1914,1599,1430,1431,1475,1415,1199,880,530,174,-176,-462,-606,-613,-627,-811,-1182,-1565,-1752,-1694,-1535,-1472,-1579,-1760,-1838,-1690,-1332,-893,-510,-240,-52,104,234,327,402,514,693,896,1041,1076,1017,916,809,702,580,438,280,134,33,-8,-14,-38,-108,-204,-282,-318,-330,-348,-380,-417,-459,-522,-615,-712,-769,-757,-690,-607,-547,-518,-501,-463,-386,-273,-151,-43,38,94,127,135,125,111,113,136,164,177,171,154,138,125,106,71,13,-68,-159,-233,-265,-251,-211,-172,-154,-161,-192,-238,-281,-302,-295,-270,-245,-226,-206,-179,-147,-117,-97,-88,-88,-92,-90,-81,-68,-62,-65,-69,-68,-64,-60,-59,-59,-63,-77,-104,-135,-163,-185,-207,-231,-254,-273,-287,-294,-288,-268,-238,-205,-175,-150,-129,-115,-103,-88,-64,-35,-6,21,43,57,55,39,18,-2,-22,-44,-65,-78,-79,-75,-74,-76,-79,-81,-86,-96,-108,-119,-129,-137,-141,-140,-137,-131,-120,-104,-85,-70,-60,-49,-33,-11,13,43,81,113,115,79,27}
        },
        {    // H-10e175a.wav
            {-1,-1,0,-2,-6,-6,0,4,-1,-6,-1,6,3,-9,-11,4,13,-3,-22,-14,11,11,-22,-35,2,37,7,-46,-20,63,55,-13,306,1564,3633,5307,4987,2054,-2349,-5967,-7017,-5342,-2255,544,1981,1950,1133,660,1651,4578,8702,12157,12969,10432,5755,1337,-864,-580,835,1645,1027,-563,-2066,-2790,-2875,-2981,-3626,-4749,-5782,-6116,-5548,-4390,-3209,-2453,-2241,-2408,-2655,-2674,-2223,-1253,-12,1020,1428,1190,718,554,956,1725,2397,2597,2262,1622,998,614,510,565,594,458,144,-236,-525,-626,-565,-469,-474,-644,-934,-1223,-1385,-1371,-1252,-1170,-1227,-1386,-1486,-1367,-1013,-563,-209,-51,-52,-96,-80,36,232,466,696,884,1003,1038,999,926,862,822,775,673,496,274,60,-110,-240,-358,-481,-605,-711,-782,-810,-800,-774,-754,-749,-749,-737,-699,-636,-545,-430,-305,-195,-126,-92,-61,1,94,183,233,230,194,149,112,92,92,117,153,177,164,111,36,-36,-95,-146,-202,-268,-335,-386,-408,-398,-364,-326,-303,-306,-328,-345,-337,-300,-251,-211,-186,-166,-135,-92,-43,3,37,58,60,48,29,14,6,-3,-22,-53,-86,-107,-110,-99,-90,-92,-108,-134,-163,-191,-214,-230,-242,-254,-266,-274,-268,-247,-220,-195,-176,-161,-148,-139,-133,-125,-109,-88,-68,-52,-35,-16,3,13,8,-7,-23,-34,-36,-34,-32,-35,-40,-47,-57,-73,-94,-110,-118,-121,-128,-140,-151,-160,-168,-175,-176,-163,-136,-101,-60,-13,31,54,45,17},
            {-8,-4,6,6,-5,-8,5,13,-1,-19,-8,20,21,-15,-34,-2,32,5,-48,-37,37,55,-31,-86,10,119,25,-64,568,2382,4675,5725,4176,377,-3726,-6085,-5962,-4074,-1687,227,1201,1215,765,876,2601,6125,10281,13082,13015,10085,5814,2206,476,450,981,965,97,-1139,-2105,-2601,-2942,-3549,-4527,-5578,-6261,-6310,-5762,-4865,-3908,-3119,-2643,-2520,-2620,-2641,-2266,-1404,-297,643,1137,1220,1140,1138,1298,1564,1819,1964,1956,1816,1608,1393,1188,980,751,478,145,-230,-564,-743,-733,-639,-643,-852,-1215,-1577,-1799,-1841,-1751,-1615,-1500,-1419,-1330,-1176,-943,-669,-405,-173,32,219,378,500,597,688,783,871,929,936,881,776,654,556,491,439,374,295,222,162,92,-16,-160,-310,-431,-512,-559,-583,-594,-609,-643,-701,-768,-812,-811,-763,-685,-601,-527,-463,-397,-314,-210,-92,24,118,175,194,189,183,192,218,247,266,264,236,182,109,36,-20,-62,-108,-170,-231,-264,-255,-223,-201,-204,-228,-260,-290,-307,-301,-269,-230,-212,-227,-258,-268,-240,-182,-120,-73,-46,-34,-29,-29,-34,-39,-40,-38,-42,-57,-76,-83,-72,-57,-57,-77,-104,-124,-140,-163,-197,-232,-256,-269,-278,-284,-278,-256,-222,-189,-163,-143,-126,-110,-100,-91,-79,-56,-26,1,16,22,24,25,17,-3,-30,-50,-59,-64,-72,-78,-75,-65,-60,-67,-82,-95,-103,-113,-129,-144,-150,-146,-138,-133,-130,-125,-108,-79,-45,-21,-10,4,35,74,92,71,25}
        },
        {    // H-10e180a.wav
            {2,-1,-7,-6,2,5,-2,-6,2,10,1,-13,-8,13,16,-10,-28,-7,22,8,-34,-34,19,44,-12,-63,-5,86,37,-35,439,1956,4123,5511,4644,1329,-2953,-6044,-6605,-4834,-2025,403,1616,1561,894,729,2141,5429,9629,12803,13168,10335,5690,1530,-459,-218,920,1431,705,-761,-2065,-2730,-2971,-3326,-4108,-5158,-6001,-6208,-5670,-4636,-3535,-2741,-2415,-2480,-2686,-2709,-2284,-1353,-163,840,1294,1195,909,878,1258,1817,2171,2131,1828,1532,1383,1303,1148,879,572,290,16,-276,-535,-664,-646,-590,-637,-825,-1073,-1277,-1400,-1474,-1545,-1625,-1674,-1623,-1415,-1066,-682,-395,-261,-220,-163,-37,137,309,465,611,741,829,862,855,834,814,795,769,727,660,559,429,288,145,-7,-174,-346,-496,-601,-663,-699,-722,-737,-745,-758,-786,-820,-837,-806,-719,-594,-464,-356,-280,-226,-173,-103,-10,90,174,222,231,216,196,186,193,213,234,234,201,138,64,1,-45,-87,-144,-220,-300,-356,-369,-342,-296,-260,-248,-259,-283,-307,-318,-306,-272,-234,-210,-206,-208,-192,-149,-90,-35,1,19,24,20,9,-7,-22,-36,-50,-68,-84,-91,-86,-77,-77,-92,-115,-137,-155,-176,-204,-234,-257,-269,-272,-270,-258,-234,-203,-176,-159,-148,-136,-124,-115,-107,-95,-75,-49,-23,-2,13,19,15,2,-16,-31,-41,-47,-51,-55,-58,-59,-60,-62,-71,-87,-105,-119,-128,-134,-141,-147,-151,-154,-158,-159,-143,-108,-66,-32,-7,18,44,57,45,17},
            {2,-1,-7,-6,2,5,-2,-6,2,10,1,-13,-8,13,16,-10,-28,-7,22,8,-34,-34,19,44,-12,-63,-5,86,37,-35,439,1956,4123,5511,4644,1329,-2953,-6044,-6605,-4834,-2025,403,1616,1561,894,729,2141,5429,9629,12803,13168,10335,5690,1530,-459,-218,920,1431,705,-761,-2065,-2730,-2971,-3326,-4108,-5158,-6001,-6208,-5670,-4636,-3535,-2741,-2415,-2480,-2686,-2709,-2284,-1353,-163,840,1294,1195,909,878,1258,1817,2171,2131,1828,1532,1383,1303,1148,879,572,290,16,-276,-535,-664,-646,-590,-637,-825,-1073,-1277,-1400,-1474,-1545,-1625,-1674,-1623,-1415,-1066,-682,-395,-261,-220,-163,-37,137,309,465,611,741,829,862,855,834,814,795,769,727,660,559,429,288,145,-7,-174,-346,-496,-601,-663,-699,-722,-737,-745,-758,-786,-820,-837,-806,-719,-594,-464,-356,-280,-226,-173,-103,-10,90,174,222,231,216,196,186,193,213,234,234,201,138,64,1,-45,-87,-144,-220,-300,-356,-369,-342,-296,-260,-248,-259,-283,-307,-318,-306,-272,-234,-210,-206,-208,-192,-149,-90,-35,1,19,24,20,9,-7,-22,-36,-50,-68,-84,-91,-86,-77,-77,-92,-115,-137,-155,-176,-204,-234,-257,-269,-272,-270,-258,-234,-203,-176,-159,-148,-136,-124,-115,-107,-95,-75,-49,-23,-2,13,19,15,2,-16,-31,-41,-47,-51,-55,-58,-59,-60,-62,-71,-87,-105,-119,-128,-134,-141,-147,-151,-154,-158,-159,-143,-108,-66,-32,-7,18,44,57,45,17}
        }
    },
    {    // elev-20 
        {    // H-20e000a.wav
            {5,-3,-9,2,18,12,-14,-20,9,28,-4,-49,-29,43,55,-28,-88,-16,89,44,-98,-89,84,107,18,755,3273,6659,7761,3842,-3907,-10263,-10445,-4933,793,1741,-1647,-4396,-2446,3435,9071,11193,9738,6636,3792,2639,4375,9040,14116,15313,10055,448,-7794,-9931,-6030,-577,1450,-1618,-7350,-11434,-10901,-6138,-512,2107,203,-4367,-8026,-8346,-5594,-1883,829,1894,1687,838,-51,-337,463,2186,3940,4706,4158,2871,1807,1565,2004,2431,2129,889,-806,-2105,-2426,-1903,-1248,-1156,-1790,-2774,-3586,-3923,-3764,-3226,-2467,-1701,-1199,-1138,-1408,-1601,-1299,-437,590,1239,1273,939,710,864,1298,1696,1825,1677,1399,1144,988,924,899,855,756,584,324,-27,-407,-692,-776,-687,-594,-667,-921,-1201,-1315,-1196,-948,-757,-745,-887,-1031,-1020,-815,-519,-274,-148,-107,-85,-46,21,130,287,452,549,533,446,372,363,391,399,356,268,160,49,-52,-138,-204,-260,-312,-363,-417,-476,-531,-553,-512,-418,-323,-289,-329,-395,-419,-368,-267,-172,-127,-141,-180,-197,-160,-80,8,71,106,120,125,123,121,128,140,134,95,35,-24,-67,-104,-137,-154,-140,-110,-95,-108,-130,-135,-113,-78,-44,-24,-28,-60,-104,-126,-107,-62,-28,-31,-68,-112,-134,-112,-53,4,10,-52,-142,-205,-223,-219,-221,-228,-225,-207,-177,-133,-74,-17,9,-10,-54,-90,-101,-90,-63,-28,1,8,-4,-24,-52,-102,-171,-231,-253,-248,-247,-261,-272,-276,-288,-308,-302,-257,-228,-286,-405,-455,-340,-122},
            {5,-3,-9,2,18,12,-14,-20,9,28,-4,-49,-29,43,55,-28,-88,-16,89,44,-98,-89,84,107,18,755,3273,6659,7761,3842,-3907,-10263,-10445,-4933,793,1741,-1647,-4396,-2446,3435,9071,11193,9738,6636,3792,2639,4375,9040,14116,15313,10055,448,-7794,-9931,-6030,-577,1450,-1618,-7350,-11434,-10901,-6138,-512,2107,203,-4367,-8026,-8346,-5594,-1883,829,1894,1687,838,-51,-337,463,2186,3940,4706,4158,2871,1807,1565,2004,2431,2129,889,-806,-2105,-2426,-1903,-1248,-1156,-1790,-2774,-3586,-3923,-3764,-3226,-2467,-1701,-1199,-1138,-1408,-1601,-1299,-437,590,1239,1273,939,710,864,1298,1696,1825,1677,1399,1144,988,924,899,855,756,584,324,-27,-407,-692,-776,-687,-594,-667,-921,-1201,-1315,-1196,-948,-757,-745,-887,-1031,-1020,-815,-519,-274,-148,-107,-85,-46,21,130,287,452,549,533,446,372,363,391,399,356,268,160,49,-52,-138,-204,-260,-312,-363,-417,-476,-531,-553,-512,-418,-323,-289,-329,-395,-419,-368,-267,-172,-127,-141,-180,-197,-160,-80,8,71,106,120,125,123,121,128,140,134,95,35,-24,-67,-104,-137,-154,-140,-110,-95,-108,-130,-135,-113,-78,-44,-24,-28,-60,-104,-126,-107,-62,-28,-31,-68,-112,-134,-112,-53,4,10,-52,-142,-205,-223,-219,-221,-228,-225,-207,-177,-133,-74,-17,9,-10,-54,-90,-101,-90,-63,-28,1,8,-4,-24,-52,-102,-171,-231,-253,-248,-247,-261,-272,-276,-288,-308,-302,-257,-228,-286,-405,-455,-340,-122}
        },
        {    // H-20e005a.wav
            {-6,-1,6,4,-6,-7,7,17,4,-16,-10,16,17,-20,-42,-3,47,25,-50,-60,23,72,-9,-93,-18,102,46,131,1297,3923,6480,6103,1394,-5326,-9352,-7909,-3033,380,-456,-3538,-4475,-1129,4544,8891,9973,8446,6024,4103,3748,5766,9705,13057,12564,7139,-569,-6003,-6445,-3135,47,-104,-3749,-8228,-10265,-8373,-3849,210,1185,-1177,-4754,-6890,-6401,-4077,-1536,151,842,831,404,-101,-171,594,2021,3336,3746,3097,1988,1256,1314,1882,2263,1900,792,-531,-1420,-1575,-1215,-857,-921,-1469,-2235,-2850,-3079,-2923,-2564,-2211,-1987,-1887,-1820,-1658,-1298,-727,-82,412,597,531,440,528,810,1138,1360,1434,1405,1322,1198,1033,849,681,566,513,474,360,110,-227,-502,-590,-518,-444,-508,-712,-935,-1054,-1026,-902,-772,-716,-752,-818,-813,-683,-472,-286,-196,-188,-197,-161,-59,96,255,352,349,276,213,217,279,336,340,291,216,141,78,25,-32,-104,-186,-257,-304,-340,-388,-441,-460,-422,-354,-310,-317,-353,-378,-372,-338,-290,-240,-205,-188,-179,-154,-104,-41,13,50,75,96,116,133,148,154,137,95,39,-15,-56,-89,-115,-130,-126,-103,-75,-60,-64,-81,-94,-89,-64,-31,-13,-24,-59,-99,-119,-104,-67,-34,-30,-57,-95,-122,-130,-130,-143,-179,-234,-281,-291,-255,-195,-144,-110,-83,-51,-22,-8,-10,-17,-28,-48,-66,-59,-19,27,44,28,-5,-44,-101,-178,-252,-300,-322,-331,-324,-296,-273,-293,-349,-376,-340,-296,-331,-431,-468,-345,-123},
            {-9,-1,17,19,-8,-28,-5,30,15,-42,-50,23,75,7,-95,-65,73,96,-58,-138,23,148,19,360,2474,6246,8793,6364,-1465,-9937,-12741,-8127,-924,2239,-375,-4238,-3736,2044,8998,12559,11565,7963,4274,2330,3507,8241,14425,17401,13272,2948,-7624,-12063,-8821,-2178,1684,-339,-6390,-11685,-12289,-7796,-1405,2465,1374,-3431,-8155,-9506,-7032,-2864,464,1845,1687,897,159,-51,632,2188,3956,4962,4681,3483,2314,1931,2354,2901,2714,1403,-627,-2412,-3117,-2658,-1750,-1312,-1780,-2885,-3985,-4562,-4446,-3754,-2750,-1767,-1140,-1055,-1380,-1670,-1452,-591,553,1396,1590,1298,1004,1077,1489,1919,2071,1893,1541,1210,1009,934,917,884,798,653,435,117,-280,-644,-832,-816,-746,-819,-1087,-1396,-1531,-1401,-1104,-833,-734,-830,-1006,-1093,-977,-688,-369,-153,-60,-24,26,108,218,355,502,611,635,582,517,493,508,514,466,350,183,2,-146,-237,-283,-318,-362,-410,-458,-524,-610,-668,-637,-512,-371,-306,-335,-393,-402,-340,-238,-145,-94,-95,-131,-161,-147,-79,15,94,137,148,142,129,115,102,90,73,49,21,-9,-40,-77,-115,-143,-152,-147,-144,-154,-172,-183,-167,-119,-56,-7,3,-30,-81,-113,-105,-66,-29,-23,-52,-94,-117,-98,-40,30,69,44,-35,-124,-174,-181,-178,-199,-240,-267,-259,-220,-163,-102,-51,-28,-41,-72,-88,-80,-64,-57,-56,-47,-31,-21,-28,-53,-94,-152,-211,-243,-239,-223,-223,-239,-248,-240,-233,-235,-236,-239,-285,-399,-517,-519,-354,-118}
        },
        {    // H-20e010a.wav
            {-4,-5,-4,2,6,2,-5,-2,9,12,-3,-16,-5,15,9,-23,-32,6,39,9,-49,-42,29,52,-22,-68,12,82,19,229,1509,3924,5860,4916,382,-5270,-8074,-6267,-2129,255,-880,-3376,-3659,-430,4369,7825,8624,7408,5485,3947,3772,5666,9081,11716,10916,6116,-228,-4474,-4773,-2402,-400,-987,-4009,-7338,-8592,-6841,-3243,-214,324,-1665,-4434,-5942,-5380,-3450,-1422,-91,462,477,207,-56,62,778,1868,2744,2901,2326,1493,978,1037,1460,1759,1535,762,-206,-904,-1093,-897,-672,-721,-1104,-1637,-2064,-2228,-2158,-1994,-1871,-1833,-1838,-1805,-1643,-1288,-762,-212,158,238,124,38,144,430,761,1013,1137,1140,1053,913,766,646,565,527,526,526,452,254,-25,-253,-333,-297,-277,-373,-566,-754,-841,-809,-711,-630,-627,-698,-769,-752,-625,-456,-339,-308,-324,-319,-256,-139,5,134,203,193,136,100,130,212,287,308,274,213,157,114,77,30,-35,-112,-186,-244,-286,-321,-350,-365,-362,-350,-346,-357,-374,-383,-375,-351,-316,-280,-251,-228,-199,-148,-76,-5,46,73,91,107,120,128,139,153,152,117,51,-15,-58,-84,-111,-139,-148,-127,-97,-87,-100,-117,-119,-103,-79,-52,-30,-25,-42,-69,-81,-70,-48,-37,-47,-80,-125,-167,-192,-200,-211,-241,-278,-288,-251,-186,-124,-80,-48,-27,-22,-32,-42,-41,-37,-40,-42,-28,6,38,52,40,3,-60,-137,-205,-250,-284,-323,-358,-363,-343,-335,-355,-373,-349,-307,-305,-348,-357,-260,-93},
            {8,22,4,-25,-17,26,32,-25,-65,-8,77,48,-74,-101,33,126,3,-151,-51,153,73,97,1627,5355,9130,8686,1818,-8105,-14029,-11693,-4059,1530,814,-3331,-4479,391,8209,13504,13577,9802,5213,2279,2666,7122,14051,18814,16425,6246,-6247,-13379,-11646,-4463,1147,521,-5374,-11518,-13127,-9067,-2293,2496,2219,-2482,-7925,-10317,-8511,-4330,-523,1432,1782,1420,922,578,779,1867,3569,4929,5058,3983,2660,2131,2635,3443,3480,2168,-149,-2448,-3733,-3695,-2846,-2074,-2003,-2646,-3552,-4215,-4366,-4006,-3288,-2425,-1676,-1279,-1288,-1445,-1295,-549,597,1552,1818,1440,965,937,1435,2075,2408,2282,1861,1400,1056,858,773,750,727,646,461,157,-231,-600,-822,-842,-757,-770,-1006,-1383,-1663,-1652,-1365,-1011,-820,-866,-1028,-1101,-963,-655,-334,-128,-52,-31,13,109,255,435,611,721,717,626,536,515,551,568,505,367,197,38,-89,-181,-243,-294,-353,-428,-514,-607,-699,-758,-737,-617,-451,-332,-322,-391,-448,-420,-302,-156,-54,-33,-73,-120,-119,-55,40,123,174,197,198,178,144,111,89,68,34,-11,-45,-63,-79,-108,-142,-156,-147,-140,-156,-187,-204,-192,-154,-104,-59,-35,-46,-88,-130,-134,-92,-34,-3,-19,-68,-109,-103,-41,51,120,130,85,20,-33,-65,-91,-129,-184,-246,-291,-295,-255,-193,-137,-104,-90,-82,-73,-63,-56,-57,-70,-89,-95,-76,-43,-22,-34,-77,-131,-182,-217,-230,-223,-209,-201,-198,-188,-174,-171,-193,-237,-301,-396,-512,-588,-537,-345,-111}
        },
        {    // H-20e015a.wav
            {-4,-4,-3,-4,-3,1,4,0,-6,-3,7,9,-4,-13,-2,12,3,-23,-25,9,30,-2,-45,-30,29,38,-24,-48,22,56,8,297,1567,3697,5163,4006,-87,-4792,-6846,-5088,-1669,77,-1034,-3020,-2999,-111,3930,6781,7452,6487,4935,3718,3691,5413,8332,10491,9762,5765,489,-3204,-3846,-2329,-896,-1273,-3487,-6048,-7114,-5843,-3039,-616,-173,-1774,-3994,-5168,-4670,-3102,-1483,-411,81,172,31,-110,74,765,1731,2418,2384,1675,808,363,574,1182,1660,1591,945,67,-588,-776,-591,-349,-335,-625,-1073,-1451,-1617,-1580,-1467,-1404,-1450,-1580,-1711,-1727,-1527,-1100,-577,-177,-44,-138,-269,-258,-62,234,514,708,801,812,773,721,684,669,674,678,640,516,299,60,-93,-115,-68,-79,-216,-440,-640,-727,-692,-593,-514,-511,-584,-672,-703,-650,-551,-461,-410,-384,-355,-301,-213,-96,19,90,95,57,31,55,122,197,249,265,245,196,132,70,15,-39,-95,-143,-176,-203,-243,-292,-326,-328,-315,-324,-368,-421,-443,-416,-355,-288,-236,-201,-178,-154,-122,-78,-25,32,82,114,124,121,124,132,128,94,40,-10,-43,-70,-109,-150,-171,-162,-141,-127,-119,-108,-91,-79,-71,-53,-16,21,30,0,-48,-81,-87,-77,-74,-94,-136,-186,-230,-259,-272,-274,-268,-255,-233,-194,-135,-68,-16,2,-11,-35,-52,-59,-59,-48,-23,10,37,54,58,43,-1,-75,-157,-223,-269,-308,-342,-361,-364,-367,-376,-375,-346,-309,-297,-308,-289,-199,-69},
            {19,-19,-30,11,42,-2,-67,-43,57,80,-35,-123,-28,121,69,-127,-127,110,148,-25,801,3984,8522,10354,5662,-4443,-13408,-14746,-8415,-962,1163,-1956,-4436,-1303,6434,13387,15298,12203,7056,2953,2078,5638,12746,19204,19247,10370,-3295,-13425,-14293,-7537,-333,998,-4083,-10805,-13582,-10305,-3422,2259,3048,-1216,-7308,-11118,-10553,-6586,-1882,1415,2738,2594,1696,727,443,1378,3247,4912,5256,4184,2717,2080,2676,3812,4275,3212,703,-2277,-4456,-5055,-4232,-2875,-1935,-1852,-2468,-3327,-4013,-4279,-4038,-3352,-2449,-1649,-1182,-1002,-798,-259,608,1410,1698,1398,921,813,1269,1992,2504,2541,2183,1669,1191,833,619,540,546,548,452,199,-192,-603,-864,-872,-713,-628,-812,-1233,-1642,-1787,-1605,-1247,-942,-838,-918,-1024,-987,-751,-423,-161,-38,5,69,192,350,507,647,739,742,651,534,475,493,523,494,393,254,112,-19,-135,-229,-299,-358,-418,-491,-581,-682,-765,-777,-686,-531,-406,-383,-447,-508,-485,-363,-199,-71,-25,-55,-106,-116,-55,51,149,202,213,209,205,200,187,163,124,64,-15,-91,-139,-153,-151,-148,-141,-124,-108,-117,-159,-210,-233,-210,-157,-104,-77,-89,-132,-178,-188,-147,-80,-32,-31,-64,-93,-84,-25,67,152,185,153,90,48,45,48,12,-69,-167,-245,-286,-286,-248,-194,-159,-158,-170,-155,-106,-55,-37,-55,-89,-117,-126,-110,-74,-43,-44,-78,-120,-153,-181,-210,-226,-208,-171,-150,-154,-161,-152,-153,-202,-301,-414,-514,-590,-612,-530,-335,-108}
        },
        {    // H-20e020a.wav
            {-1,-1,-1,-2,-4,-6,-3,3,4,-1,-6,-2,7,7,-5,-10,0,11,0,-20,-18,10,24,-5,-37,-19,28,29,-20,-33,21,36,9,331,1513,3353,4497,3345,-219,-4144,-5743,-4196,-1393,-64,-1061,-2659,-2506,8,3405,5771,6349,5621,4440,3538,3604,5110,7622,9520,8986,5608,976,-2474,-3341,-2193,-884,-1006,-2765,-4972,-6011,-5079,-2817,-845,-504,-1823,-3618,-4555,-4162,-2923,-1614,-683,-182,-17,-65,-121,78,640,1343,1764,1623,1029,414,220,584,1245,1714,1622,979,161,-378,-435,-155,134,171,-96,-538,-962,-1231,-1310,-1265,-1204,-1219,-1335,-1505,-1623,-1584,-1354,-1020,-741,-624,-643,-659,-549,-297,13,290,494,635,735,799,819,796,748,706,680,639,536,362,177,60,31,29,-29,-171,-352,-499,-561,-534,-460,-406,-430,-531,-644,-692,-653,-570,-498,-454,-421,-380,-330,-269,-190,-101,-33,-5,-6,8,62,140,200,217,199,168,137,104,62,12,-35,-70,-94,-119,-159,-216,-274,-313,-328,-327,-326,-331,-338,-339,-327,-293,-241,-186,-147,-133,-129,-111,-72,-22,18,42,58,74,85,81,60,31,2,-27,-56,-85,-107,-121,-130,-134,-127,-103,-73,-51,-46,-48,-42,-18,13,36,37,11,-32,-74,-100,-106,-106,-116,-148,-201,-261,-306,-318,-298,-265,-239,-215,-176,-114,-46,-3,5,-8,-28,-48,-61,-55,-27,13,42,54,57,56,38,-9,-80,-155,-220,-275,-318,-341,-346,-349,-360,-365,-348,-319,-303,-298,-265,-175,-59},
            {-32,1,40,15,-57,-67,23,90,12,-116,-87,79,118,-65,-175,18,191,0,194,2423,6963,10771,9150,588,-10304,-15977,-12943,-5228,-176,-923,-3690,-2544,4048,11972,16004,14468,9557,4654,2415,4493,10857,18321,21036,14695,1205,-11572,-15983,-11070,-3051,539,-2813,-9382,-13236,-11198,-4783,1481,3403,-150,-6655,-11759,-12323,-8441,-2877,1397,3195,3121,2270,1343,790,1101,2443,4149,5030,4453,3042,2147,2575,3843,4613,3775,1240,-2065,-4793,-5916,-5222,-3372,-1519,-664,-1141,-2525,-3995,-4841,-4790,-3998,-2854,-1773,-1036,-680,-480,-116,529,1202,1492,1254,816,706,1160,1918,2495,2604,2294,1783,1245,778,462,349,401,484,453,240,-125,-530,-827,-899,-774,-642,-731,-1097,-1547,-1791,-1674,-1289,-892,-707,-779,-964,-1048,-905,-586,-255,-46,42,101,210,374,547,679,731,688,578,475,456,524,597,584,459,272,89,-52,-154,-232,-295,-350,-399,-454,-531,-640,-751,-804,-747,-599,-450,-388,-425,-499,-524,-460,-327,-184,-87,-61,-80,-86,-37,57,143,184,183,176,186,210,230,230,200,129,25,-82,-159,-193,-198,-191,-172,-138,-100,-90,-124,-181,-224,-226,-195,-157,-136,-143,-177,-224,-257,-248,-192,-118,-71,-67,-85,-78,-18,81,173,214,197,151,118,115,123,105,39,-61,-161,-230,-256,-249,-226,-210,-213,-224,-215,-169,-100,-50,-47,-83,-127,-155,-162,-150,-121,-88,-69,-76,-99,-128,-164,-207,-241,-235,-188,-140,-127,-137,-134,-116,-138,-249,-427,-589,-669,-657,-573,-430,-247,-76}
        },
        {    // H-20e025a.wav
            {-1,1,2,1,-1,-2,-3,-4,-2,2,2,-1,-4,0,6,5,-4,-7,2,9,0,-15,-11,12,20,-6,-30,-11,28,26,-16,-26,15,21,10,322,1368,2942,3890,2890,-117,-3404,-4753,-3511,-1252,-208,-1043,-2319,-2125,-2,2813,4775,5319,4860,4056,3438,3550,4828,6969,8624,8205,5297,1233,-1854,-2694,-1742,-601,-673,-2158,-4058,-5017,-4368,-2624,-1083,-812,-1848,-3279,-4060,-3793,-2810,-1692,-817,-288,-91,-156,-301,-273,69,606,1033,1116,882,598,559,863,1324,1605,1463,943,351,26,92,386,606,528,140,-386,-837,-1090,-1153,-1115,-1072,-1086,-1190,-1379,-1594,-1728,-1695,-1507,-1266,-1066,-914,-745,-511,-224,62,303,484,599,653,667,670,679,688,686,665,621,537,404,247,126,75,66,28,-83,-239,-367,-410,-379,-334,-338,-417,-541,-648,-687,-649,-565,-482,-431,-412,-408,-393,-343,-255,-153,-72,-34,-25,-11,32,93,144,165,153,116,69,29,4,-8,-22,-49,-83,-119,-156,-198,-242,-271,-272,-256,-244,-247,-254,-249,-231,-209,-192,-181,-170,-159,-142,-116,-83,-50,-27,-14,-8,-9,-15,-23,-26,-25,-30,-46,-67,-81,-86,-88,-87,-77,-52,-20,3,9,5,0,-2,-1,5,11,8,-16,-57,-100,-130,-146,-158,-178,-213,-260,-304,-328,-323,-293,-249,-199,-147,-96,-50,-17,-1,-5,-24,-46,-53,-36,-3,30,56,74,80,66,27,-27,-86,-150,-220,-283,-316,-317,-307,-307,-318,-325,-331,-344,-349,-306,-196,-64},
            {19,29,-23,-67,-15,78,61,-72,-123,14,139,26,-168,-89,174,120,-79,1060,4836,9758,11309,5796,-5084,-14432,-16046,-10290,-3469,-1157,-2741,-2965,1763,9540,15301,15844,12016,6962,3691,4241,9276,16777,21561,18254,6357,-7873,-15887,-14050,-6561,-1200,-2336,-7849,-12078,-11119,-5642,296,2547,-340,-6347,-11459,-12441,-9004,-3660,574,2437,2651,2412,2158,1803,1574,2011,3146,4163,4194,3332,2582,2773,3662,4157,3306,1038,-1862,-4294,-5399,-4913,-3274,-1440,-410,-685,-2014,-3617,-4701,-4871,-4213,-3098,-1949,-1081,-620,-441,-232,255,937,1416,1369,931,638,912,1644,2323,2532,2268,1790,1302,847,450,204,179,300,387,301,30,-344,-695,-898,-892,-772,-749,-975,-1364,-1646,-1599,-1251,-844,-623,-667,-861,-998,-928,-648,-294,-32,72,86,124,241,409,569,672,694,634,539,489,527,608,631,532,344,151,5,-102,-201,-301,-384,-438,-472,-513,-582,-673,-741,-729,-627,-489,-405,-416,-483,-526,-489,-381,-250,-146,-91,-76,-64,-20,63,147,186,173,150,161,209,256,265,225,144,39,-68,-148,-180,-173,-157,-146,-133,-110,-92,-104,-149,-199,-218,-197,-158,-132,-138,-179,-240,-294,-312,-282,-221,-161,-125,-105,-79,-20,76,185,262,272,221,158,137,163,190,166,80,-37,-140,-209,-238,-237,-224,-222,-235,-243,-215,-145,-66,-25,-41,-94,-147,-179,-182,-164,-134,-105,-82,-67,-66,-92,-151,-223,-265,-249,-195,-145,-121,-103,-71,-42,-73,-202,-406,-607,-724,-719,-604,-424,-240,-98,-20}
        },
        {    // H-20e030a.wav
            {-1,-2,-1,0,0,-1,-1,-2,-4,-4,-2,1,2,-2,-4,0,5,3,-5,-6,2,8,0,-13,-10,8,14,-6,-23,-7,24,20,-15,-22,10,13,6,273,1162,2508,3355,2595,138,-2628,-3873,-3004,-1242,-383,-1000,-1978,-1806,-108,2163,3816,4418,4271,3824,3431,3524,4512,6220,7578,7270,4915,1570,-1034,-1846,-1200,-356,-431,-1618,-3185,-4097,-3785,-2562,-1375,-1086,-1810,-2900,-3532,-3345,-2579,-1708,-1051,-674,-531,-557,-639,-599,-300,214,728,1016,1023,899,866,1033,1313,1493,1417,1107,744,522,503,585,597,420,61,-367,-723,-924,-992,-1010,-1059,-1171,-1336,-1524,-1689,-1771,-1722,-1546,-1301,-1052,-819,-583,-336,-106,74,197,284,357,422,476,516,541,556,573,598,616,583,467,298,146,68,54,44,-9,-105,-211,-289,-327,-338,-356,-410,-497,-582,-619,-594,-532,-471,-431,-410,-398,-382,-349,-290,-213,-144,-98,-71,-48,-17,16,42,61,73,74,59,28,-8,-40,-63,-74,-78,-81,-96,-125,-164,-198,-219,-228,-231,-234,-236,-234,-224,-203,-175,-149,-134,-133,-141,-149,-147,-130,-102,-73,-57,-55,-61,-64,-63,-59,-58,-59,-63,-67,-69,-63,-45,-17,16,44,59,56,36,6,-21,-40,-47,-45,-39,-42,-63,-98,-138,-174,-209,-251,-293,-324,-338,-334,-309,-258,-187,-118,-74,-56,-48,-42,-42,-49,-48,-27,8,37,56,70,79,69,35,-11,-53,-101,-167,-236,-276,-278,-268,-271,-278,-277,-288,-344,-414,-412,-287,-99},
            {15,-65,-67,38,98,-2,-131,-75,106,117,-98,-188,54,223,-41,127,2507,7370,11536,10163,1603,-9725,-16453,-14915,-8395,-3307,-2487,-2948,-149,6548,13297,15951,13798,9319,5633,4936,8295,14907,20980,20956,11987,-2296,-13611,-15835,-10279,-3979,-2847,-6716,-10724,-10614,-6354,-1333,907,-885,-5363,-9746,-11472,-9643,-5465,-1236,1402,2375,2531,2456,2190,1840,1915,2747,3843,4250,3621,2666,2366,2857,3266,2622,795,-1454,-3177,-3886,-3649,-2838,-1897,-1256,-1239,-1894,-2908,-3767,-4077,-3775,-3078,-2266,-1547,-1025,-697,-427,-12,602,1179,1375,1127,796,846,1358,1958,2217,2053,1696,1351,1022,648,292,99,111,204,208,43,-261,-608,-873,-947,-841,-722,-795,-1093,-1418,-1517,-1310,-949,-669,-596,-689,-801,-790,-605,-320,-72,38,30,16,96,274,474,610,640,580,492,447,484,571,626,582,441,262,107,-5,-99,-206,-332,-453,-534,-569,-589,-633,-691,-703,-620,-478,-374,-383,-474,-554,-548,-460,-337,-218,-123,-61,-32,-12,33,106,170,187,167,157,185,232,254,226,154,58,-46,-136,-190,-202,-189,-173,-156,-128,-87,-57,-61,-100,-150,-181,-185,-173,-169,-188,-230,-277,-306,-307,-283,-248,-209,-170,-124,-64,23,131,232,288,283,242,211,213,230,222,162,57,-61,-151,-196,-203,-199,-209,-236,-261,-257,-211,-136,-68,-38,-55,-94,-131,-153,-163,-164,-150,-120,-88,-68,-71,-99,-153,-220,-264,-256,-203,-152,-129,-105,-43,26,11,-147,-396,-620,-738,-743,-654,-478,-243,-33,63,42}
        },
        {    // H-20e035a.wav
            {-1,-1,-2,-2,-2,-2,-1,-1,-2,-4,-5,-5,-3,0,0,-3,-6,-3,2,3,-2,-6,-2,3,-1,-11,-10,4,11,-4,-19,-9,15,16,-11,-21,0,3,0,213,935,2071,2878,2414,495,-1852,-3121,-2677,-1343,-549,-889,-1626,-1573,-318,1507,2991,3726,3860,3678,3426,3440,4088,5331,6423,6342,4679,2113,-79,-1006,-765,-207,-208,-1061,-2355,-3317,-3379,-2592,-1603,-1156,-1527,-2365,-3052,-3200,-2830,-2195,-1526,-969,-628,-554,-662,-725,-524,-28,580,1041,1219,1178,1111,1179,1378,1552,1524,1248,853,540,422,451,475,358,76,-289,-624,-869,-1031,-1147,-1235,-1294,-1337,-1393,-1469,-1514,-1449,-1251,-986,-753,-607,-526,-453,-351,-218,-71,71,189,276,337,386,431,470,501,527,543,520,434,297,163,88,75,76,37,-48,-144,-209,-241,-264,-308,-373,-438,-483,-499,-493,-477,-459,-445,-435,-428,-414,-380,-322,-251,-188,-148,-125,-107,-83,-54,-21,14,47,67,61,33,2,-17,-28,-44,-66,-84,-96,-113,-147,-192,-227,-241,-240,-235,-224,-201,-167,-136,-118,-114,-119,-130,-146,-158,-160,-151,-137,-122,-103,-85,-74,-71,-72,-72,-74,-77,-74,-56,-27,-2,16,35,59,76,70,42,9,-16,-34,-48,-50,-38,-23,-27,-59,-112,-173,-234,-284,-315,-326,-327,-320,-296,-246,-179,-122,-87,-71,-62,-59,-58,-47,-19,13,33,43,58,77,78,47,-1,-44,-85,-138,-191,-216,-212,-212,-235,-253,-240,-232,-290,-395,-435,-322,-116},
            {-67,-4,83,54,-85,-133,12,149,35,-180,-116,178,154,-161,664,4205,9491,12228,8129,-2307,-12990,-17237,-13804,-7494,-3681,-2934,-1518,3415,10274,14853,14720,11136,7283,5804,7959,13501,19930,22499,17075,4420,-8928,-15467,-13195,-7071,-3886,-5951,-9900,-11020,-7907,-3068,-13,-453,-3726,-7802,-10474,-10329,-7473,-3457,-127,1700,2415,2647,2528,2043,1691,2193,3506,4559,4320,2984,1781,1601,2058,2040,970,-666,-1964,-2500,-2497,-2344,-2181,-1988,-1855,-1987,-2444,-2984,-3262,-3130,-2719,-2247,-1815,-1423,-1071,-761,-410,93,696,1128,1162,931,851,1167,1671,1939,1816,1533,1352,1233,961,500,90,-41,64,167,90,-165,-501,-827,-1044,-1063,-906,-746,-778,-1013,-1260,-1308,-1125,-852,-656,-593,-608,-600,-497,-307,-112,-4,1,-24,21,167,364,527,589,538,421,330,342,453,572,595,501,355,220,108,-11,-143,-267,-360,-427,-488,-554,-626,-688,-715,-672,-556,-422,-354,-388,-477,-527,-491,-392,-286,-203,-139,-83,-31,23,86,150,189,189,167,161,185,212,209,165,91,-1,-100,-184,-230,-236,-224,-209,-182,-131,-70,-34,-41,-70,-93,-107,-127,-160,-200,-243,-287,-322,-327,-297,-253,-225,-214,-196,-149,-69,35,151,250,297,286,252,241,256,262,224,146,54,-36,-117,-176,-205,-218,-239,-269,-281,-251,-193,-141,-112,-98,-91,-93,-102,-113,-120,-129,-136,-126,-95,-68,-76,-121,-174,-215,-236,-238,-215,-176,-142,-108,-44,49,80,-57,-347,-636,-773,-755,-673,-559,-357,-61,191,243,109}
        },
        {    // H-20e040a.wav
            {1,0,0,0,0,0,-1,-1,-1,0,0,-1,-3,-4,-3,1,2,0,-2,-1,3,4,0,-3,-1,3,1,-6,-5,5,10,0,-13,-6,15,18,-5,-19,-4,4,1,150,707,1667,2478,2322,881,-1154,-2518,-2468,-1463,-661,-748,-1319,-1413,-529,973,2364,3214,3546,3539,3357,3246,3549,4384,5323,5565,4598,2707,801,-284,-379,-12,69,-549,-1669,-2664,-2952,-2457,-1677,-1290,-1609,-2377,-3032,-3173,-2786,-2118,-1438,-921,-656,-652,-795,-855,-616,-42,680,1266,1524,1470,1284,1162,1178,1250,1234,1061,794,569,464,443,396,237,-43,-384,-709,-957,-1098,-1128,-1076,-997,-958,-992,-1078,-1144,-1123,-1007,-855,-742,-703,-707,-687,-592,-418,-206,-16,104,157,180,217,278,345,401,444,470,454,374,253,153,120,135,138,91,8,-67,-112,-138,-168,-215,-281,-360,-435,-481,-489,-471,-456,-457,-464,-458,-430,-382,-325,-269,-225,-196,-177,-156,-124,-82,-36,4,29,36,31,24,17,2,-26,-63,-98,-124,-148,-172,-192,-200,-198,-190,-178,-161,-142,-130,-128,-128,-123,-118,-123,-139,-158,-167,-166,-161,-156,-148,-135,-120,-104,-89,-76,-65,-58,-54,-49,-39,-22,3,30,47,50,44,35,25,10,-5,-13,-12,-11,-18,-33,-55,-93,-152,-224,-286,-320,-329,-327,-315,-285,-236,-179,-129,-91,-72,-71,-79,-77,-55,-22,6,27,46,60,54,24,-10,-35,-62,-108,-157,-178,-172,-171,-196,-218,-210,-205,-258,-353,-389,-289,-104},
            {2,80,27,-105,-103,69,143,-41,-206,-25,239,44,-170,1367,5794,11045,12246,5996,-5470,-15244,-17654,-13177,-7118,-3693,-2215,761,6499,12327,14641,12649,8805,6383,7355,11924,18438,23155,21532,11799,-2183,-12812,-14881,-10115,-5195,-5164,-9061,-11914,-10245,-5150,-549,574,-1911,-6043,-9463,-10559,-8953,-5561,-2012,436,1605,2044,2186,2113,2010,2352,3318,4255,4176,2902,1435,961,1578,2219,1810,346,-1244,-2109,-2181,-1959,-1854,-1888,-1934,-2016,-2261,-2631,-2875,-2781,-2421,-2058,-1847,-1703,-1468,-1099,-651,-157,350,728,805,632,554,880,1489,1914,1849,1467,1176,1122,1093,863,488,191,68,23,-55,-177,-332,-554,-840,-1067,-1108,-996,-914,-977,-1103,-1127,-1001,-817,-687,-631,-606,-564,-468,-300,-91,63,84,-1,-66,-1,192,409,539,529,415,293,263,351,487,556,507,378,244,138,49,-41,-135,-234,-334,-425,-490,-536,-591,-660,-699,-655,-540,-431,-394,-416,-435,-407,-347,-287,-242,-204,-161,-106,-35,55,142,195,192,149,109,106,142,185,195,150,56,-56,-153,-217,-246,-249,-234,-206,-169,-130,-97,-73,-59,-49,-47,-57,-85,-126,-173,-225,-279,-320,-330,-304,-266,-240,-223,-189,-122,-32,62,149,223,267,269,249,241,257,263,224,146,68,10,-43,-109,-182,-245,-289,-315,-311,-267,-206,-167,-162,-165,-146,-109,-80,-68,-66,-74,-96,-117,-109,-76,-61,-97,-162,-203,-208,-207,-215,-208,-161,-90,-15,53,84,-1,-253,-583,-800,-799,-669,-552,-444,-222,128,406,406,168}
        },
        {    // H-20e045a.wav
            {1,1,0,-1,-1,-1,-1,-1,-2,-2,-1,-1,-2,-3,-4,-4,-2,0,1,0,-3,-2,2,3,0,-4,-3,3,3,-4,-8,0,8,4,-9,-9,8,16,-1,-20,-14,-2,-1,92,503,1306,2124,2242,1216,-563,-2029,-2331,-1597,-759,-605,-1033,-1263,-691,566,1903,2835,3268,3326,3148,2926,2975,3526,4385,4920,4532,3204,1563,397,63,280,410,-44,-1086,-2242,-2906,-2793,-2159,-1586,-1517,-1938,-2462,-2693,-2503,-2027,-1486,-1049,-806,-762,-802,-722,-355,280,958,1395,1453,1217,917,760,807,961,1066,1022,843,622,437,296,150,-44,-273,-479,-607,-648,-637,-616,-614,-640,-701,-802,-928,-1038,-1081,-1038,-937,-835,-778,-765,-752,-688,-552,-371,-197,-69,12,71,126,178,223,273,335,392,405,352,259,182,156,170,183,167,118,50,-23,-91,-146,-193,-245,-317,-403,-473,-502,-486,-451,-425,-419,-422,-421,-408,-381,-338,-282,-225,-184,-166,-158,-137,-91,-32,16,33,19,-14,-48,-73,-88,-98,-106,-114,-122,-134,-148,-155,-145,-120,-99,-97,-111,-126,-131,-133,-138,-148,-158,-168,-181,-191,-189,-171,-147,-129,-120,-116,-110,-102,-90,-75,-58,-43,-33,-25,-18,-12,-5,6,24,39,44,39,35,35,31,16,-4,-24,-48,-93,-160,-229,-281,-308,-315,-304,-276,-237,-201,-175,-155,-134,-116,-108,-104,-92,-69,-39,-8,18,31,22,-2,-23,-31,-41,-71,-108,-129,-132,-145,-179,-206,-200,-188,-222,-297,-326,-243,-87},
            {78,-42,-143,-54,132,126,-110,-206,58,261,-59,-128,1969,6952,12040,12125,4482,-7620,-16897,-18293,-13133,-6842,-3055,-741,2996,8493,12865,13381,10468,7190,6559,9742,15864,22153,24388,19066,6813,-6549,-13910,-12923,-7967,-5558,-7922,-11499,-11504,-7095,-1752,623,-913,-4519,-7878,-9683,-9536,-7559,-4474,-1503,398,1214,1576,1913,2184,2353,2671,3235,3554,3016,1797,939,1251,2295,2753,1808,-33,-1561,-2100,-1954,-1771,-1780,-1790,-1698,-1719,-2052,-2531,-2767,-2605,-2259,-2013,-1889,-1705,-1359,-919,-465,0,427,628,487,222,275,826,1535,1869,1665,1260,1053,1064,1024,781,478,317,284,202,-21,-306,-543,-722,-879,-993,-1023,-1002,-1032,-1144,-1234,-1169,-937,-666,-497,-462,-493,-493,-404,-230,-34,93,98,19,-36,25,194,377,467,429,321,250,290,424,553,574,462,283,127,36,-16,-70,-142,-224,-306,-391,-481,-572,-645,-674,-644,-565,-481,-434,-430,-432,-400,-328,-246,-185,-155,-145,-137,-109,-44,50,133,163,136,94,79,100,130,143,125,76,-4,-97,-172,-207,-211,-211,-217,-212,-181,-134,-99,-85,-82,-72,-56,-48,-59,-85,-120,-164,-216,-273,-319,-336,-316,-270,-214,-153,-82,3,88,149,177,188,203,232,265,282,269,220,148,76,24,-13,-58,-127,-209,-279,-317,-318,-288,-249,-226,-229,-237,-214,-151,-79,-39,-36,-48,-57,-66,-74,-74,-66,-74,-112,-161,-186,-186,-187,-195,-178,-110,-9,73,92,12,-193,-489,-751,-836,-727,-554,-433,-312,-62,298,542,478,186}
        },
        {    // H-20e050a.wav
            {1,1,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,0,1,1,-1,-2,1,3,1,-4,-3,4,6,0,-7,-4,5,5,-5,-7,7,18,2,-23,-21,1,9,55,334,994,1810,2157,1480,-82,-1630,-2218,-1699,-826,-471,-773,-1092,-747,319,1584,2515,2947,2996,2808,2542,2467,2857,3669,4405,4446,3597,2280,1181,683,606,442,-192,-1253,-2302,-2831,-2629,-1942,-1298,-1120,-1444,-1957,-2291,-2285,-2003,-1595,-1179,-832,-597,-457,-318,-72,298,680,920,941,796,621,546,626,806,955,948,757,476,239,116,78,51,-3,-67,-114,-147,-200,-301,-452,-631,-805,-945,-1033,-1060,-1031,-969,-904,-863,-852,-849,-821,-748,-630,-485,-339,-207,-98,-11,62,125,176,217,255,295,328,331,297,250,224,234,256,248,192,98,-4,-90,-149,-187,-220,-270,-338,-406,-450,-463,-461,-460,-461,-458,-446,-428,-404,-365,-313,-259,-217,-188,-164,-134,-100,-71,-52,-44,-44,-47,-55,-63,-66,-62,-51,-45,-53,-72,-92,-102,-102,-98,-93,-92,-97,-116,-149,-180,-195,-191,-181,-174,-172,-169,-163,-156,-150,-140,-126,-110,-100,-94,-87,-75,-60,-42,-29,-22,-20,-17,-6,13,34,56,74,86,82,61,31,1,-29,-67,-115,-167,-212,-245,-263,-263,-248,-225,-208,-200,-193,-185,-177,-167,-149,-119,-84,-58,-40,-23,-8,-6,-18,-30,-29,-25,-38,-65,-86,-99,-122,-163,-195,-194,-181,-200,-252,-270,-200,-72},
            {-3,-125,-75,109,130,-97,-212,48,267,-56,-162,1953,7105,12449,12642,4738,-7970,-17898,-19599,-14167,-7096,-2378,547,4242,9056,12456,12192,9091,6419,7113,11836,18806,24445,24634,17156,4227,-7913,-13467,-11932,-8183,-7299,-9620,-11270,-9108,-4215,-377,-53,-2572,-5767,-8183,-9401,-9160,-7247,-4203,-1346,335,1000,1409,1860,2073,1972,1969,2298,2499,2041,1266,1205,2258,3456,3374,1698,-443,-1707,-1826,-1518,-1433,-1528,-1485,-1354,-1509,-2063,-2632,-2772,-2502,-2219,-2172,-2194,-1978,-1471,-877,-365,61,387,475,269,28,160,757,1425,1680,1466,1157,1067,1115,1027,748,491,422,438,336,76,-211,-440,-658,-899,-1071,-1079,-989,-982,-1123,-1270,-1238,-1011,-740,-559,-477,-426,-363,-284,-185,-71,14,19,-39,-58,53,260,425,438,321,202,196,319,490,605,605,495,327,161,28,-69,-143,-206,-267,-333,-409,-493,-575,-640,-668,-645,-572,-476,-404,-379,-382,-367,-311,-232,-163,-119,-92,-68,-41,-5,39,78,88,66,44,57,103,143,137,87,15,-61,-135,-192,-217,-213,-204,-206,-203,-176,-132,-98,-87,-82,-66,-47,-47,-67,-91,-112,-142,-187,-235,-270,-287,-290,-277,-236,-166,-83,-2,70,128,162,171,175,196,234,261,254,213,157,104,59,15,-39,-111,-193,-261,-293,-290,-272,-263,-269,-282,-285,-260,-202,-125,-63,-39,-44,-53,-55,-55,-60,-64,-63,-71,-101,-141,-166,-173,-176,-170,-126,-29,77,116,31,-171,-439,-687,-823,-790,-626,-439,-286,-116,146,440,581,452,163}
        },
        {    // H-20e055a.wav
            {1,2,1,0,0,0,2,2,1,-1,0,0,0,0,-1,-1,0,0,-1,-1,-1,0,2,3,1,0,1,4,3,0,-1,3,7,2,-6,-6,4,9,3,-3,3,11,1,-18,-15,9,15,25,210,751,1533,2022,1619,277,-1277,-2076,-1763,-893,-354,-490,-839,-699,149,1295,2180,2567,2570,2393,2188,2136,2455,3197,4039,4416,3958,2813,1541,660,284,116,-239,-933,-1746,-2264,-2201,-1649,-1024,-765,-1013,-1545,-1992,-2106,-1873,-1441,-989,-650,-480,-446,-435,-332,-90,230,512,652,620,474,341,339,490,693,802,752,607,482,434,432,416,353,247,108,-61,-252,-447,-622,-763,-866,-931,-964,-982,-993,-987,-950,-890,-841,-828,-838,-818,-727,-566,-385,-234,-136,-75,-26,24,79,140,212,291,356,381,358,314,286,285,288,261,191,95,2,-70,-121,-158,-192,-241,-312,-399,-475,-518,-524,-510,-493,-475,-455,-428,-394,-356,-312,-267,-230,-207,-196,-183,-159,-119,-70,-27,-3,-1,-15,-31,-37,-35,-28,-22,-16,-16,-28,-55,-88,-113,-127,-136,-147,-158,-162,-160,-160,-166,-176,-189,-202,-212,-212,-195,-164,-130,-101,-81,-70,-68,-71,-70,-61,-47,-32,-17,3,25,44,55,65,74,76,63,34,3,-22,-44,-69,-99,-133,-169,-202,-224,-233,-230,-221,-209,-193,-182,-181,-187,-183,-156,-116,-83,-66,-55,-45,-40,-42,-43,-32,-15,-15,-35,-62,-88,-119,-159,-188,-186,-172,-183,-220,-231,-170,-61},
            {-112,-49,111,122,-97,-220,30,282,-18,-245,1625,6732,12546,13516,5954,-7417,-18676,-21299,-15564,-7226,-1340,1828,4919,8933,11792,11244,8051,5705,7362,13317,20876,25840,24526,15912,2991,-8405,-13536,-12361,-9095,-7845,-8841,-9159,-6696,-2674,-137,-737,-3559,-6638,-8754,-9590,-9006,-6960,-4040,-1385,231,968,1378,1606,1457,1056,931,1292,1638,1453,1082,1445,2781,4045,3893,2136,-60,-1401,-1619,-1328,-1079,-903,-708,-727,-1278,-2226,-2969,-3047,-2614,-2206,-2128,-2209,-2119,-1748,-1222,-664,-131,265,347,112,-124,30,612,1233,1483,1348,1139,1078,1073,939,694,534,540,572,460,219,-17,-202,-410,-671,-888,-962,-944,-980,-1115,-1234,-1207,-1035,-834,-692,-611,-551,-482,-378,-227,-60,38,9,-93,-130,-10,212,386,407,304,198,195,312,481,607,635,561,423,261,101,-42,-158,-241,-301,-357,-423,-500,-575,-633,-655,-629,-560,-474,-400,-356,-335,-320,-292,-245,-183,-122,-75,-43,-12,31,76,99,80,30,-9,-2,49,110,137,111,39,-57,-155,-230,-264,-259,-234,-209,-186,-155,-116,-84,-67,-54,-33,-11,-10,-38,-82,-124,-162,-200,-232,-245,-243,-237,-232,-216,-174,-109,-36,33,94,139,161,168,182,213,238,229,185,136,106,91,69,22,-51,-141,-229,-287,-298,-277,-260,-269,-296,-309,-289,-235,-163,-95,-54,-47,-59,-68,-69,-71,-77,-76,-61,-51,-64,-96,-121,-132,-137,-127,-74,22,100,70,-98,-350,-591,-750,-790,-705,-529,-323,-129,64,279,466,513,367,127}
        },
        {    // H-20e060a.wav
            {3,2,0,0,1,1,1,1,1,1,0,0,0,1,1,0,-1,-1,0,1,1,0,-1,0,2,3,1,0,2,5,4,0,-1,4,7,3,-5,-4,5,11,3,-6,-1,11,8,-9,-12,7,17,21,147,575,1271,1812,1619,516,-954,-1876,-1749,-933,-265,-233,-554,-566,56,1027,1817,2156,2151,2047,2000,2098,2423,2974,3533,3739,3370,2553,1670,1039,696,440,40,-574,-1257,-1731,-1763,-1356,-791,-452,-554,-992,-1464,-1723,-1719,-1552,-1327,-1094,-870,-669,-499,-340,-165,22,172,228,175,75,47,195,521,902,1164,1201,1051,837,655,516,374,205,33,-102,-193,-275,-393,-561,-744,-887,-956,-965,-959,-966,-976,-959,-910,-857,-825,-807,-770,-695,-589,-474,-362,-256,-154,-57,37,126,209,277,327,358,369,359,332,303,284,275,254,199,107,-5,-104,-167,-197,-224,-276,-356,-442,-503,-530,-534,-525,-503,-465,-423,-395,-380,-363,-331,-288,-246,-215,-188,-158,-125,-88,-49,-16,1,-3,-16,-21,-11,5,13,11,-1,-19,-44,-73,-96,-110,-116,-124,-137,-154,-174,-193,-212,-229,-239,-241,-235,-222,-204,-179,-145,-107,-72,-51,-44,-47,-50,-48,-39,-22,1,23,37,41,40,38,36,29,16,0,-16,-28,-40,-55,-79,-115,-156,-191,-209,-211,-203,-190,-174,-159,-154,-160,-164,-158,-142,-125,-111,-96,-81,-70,-67,-60,-44,-29,-31,-51,-74,-94,-119,-152,-176,-175,-166,-180,-213,-218,-156,-55},
            {-119,86,186,-20,-250,-82,273,122,-304,915,5542,11944,14612,8561,-5050,-18420,-23303,-18041,-8206,-536,3016,5084,8023,10755,10718,7820,5368,7072,13564,21716,26727,24958,15958,2997,-8438,-13954,-13194,-9682,-7354,-7134,-6968,-4953,-1788,55,-952,-4043,-7300,-9401,-10027,-9195,-6987,-3977,-1289,200,591,636,793,911,790,624,686,847,804,731,1260,2604,3952,4117,2775,821,-567,-997,-888,-691,-461,-191,-183,-794,-1894,-2861,-3191,-2959,-2607,-2406,-2283,-2089,-1824,-1536,-1164,-648,-140,82,-46,-212,-36,506,1056,1278,1188,1047,1012,996,875,691,596,631,670,592,421,255,107,-101,-393,-659,-782,-789,-821,-957,-1116,-1167,-1082,-953,-865,-814,-749,-649,-525,-382,-225,-98,-60,-106,-132,-37,161,326,339,225,123,151,308,504,642,677,613,479,311,149,20,-76,-158,-242,-327,-405,-476,-547,-612,-649,-632,-564,-477,-405,-364,-346,-335,-319,-284,-224,-149,-81,-36,-3,33,74,93,72,23,-15,-9,37,91,119,104,44,-49,-154,-238,-279,-273,-242,-211,-188,-164,-130,-92,-61,-38,-13,15,30,12,-39,-99,-152,-197,-238,-269,-275,-255,-227,-200,-171,-124,-58,16,79,119,135,134,138,160,191,205,183,141,109,98,89,58,-1,-80,-163,-233,-275,-282,-275,-279,-301,-320,-308,-260,-193,-129,-83,-61,-63,-78,-95,-105,-111,-106,-84,-52,-32,-39,-61,-79,-89,-96,-87,-36,37,53,-60,-287,-528,-689,-743,-703,-581,-386,-163,35,191,323,422,426,298,104}
        },
        {    // H-20e065a.wav
            {1,2,2,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,2,2,1,0,-1,0,1,3,4,3,2,2,2,1,1,2,5,6,2,-4,-4,2,7,5,2,6,11,5,-10,-11,9,25,33,130,468,1048,1551,1484,624,-660,-1595,-1642,-963,-243,-19,-212,-313,46,761,1454,1880,2050,2059,1938,1736,1649,1913,2529,3160,3380,3035,2335,1628,1101,694,241,-326,-900,-1249,-1183,-722,-155,118,-140,-831,-1603,-2112,-2222,-2003,-1603,-1155,-766,-524,-461,-523,-592,-564,-418,-203,20,231,456,729,1031,1281,1378,1271,1004,679,398,207,104,53,21,-24,-104,-228,-396,-589,-771,-900,-959,-969,-967,-972,-967,-926,-855,-792,-768,-775,-775,-732,-638,-509,-364,-218,-81,36,123,181,218,251,287,322,344,343,325,301,278,250,203,129,30,-78,-171,-231,-257,-269,-301,-365,-445,-506,-526,-511,-484,-455,-426,-394,-366,-347,-334,-310,-271,-225,-188,-162,-138,-106,-70,-39,-20,-8,1,5,5,5,10,17,19,11,-5,-24,-47,-76,-111,-145,-172,-194,-215,-235,-251,-256,-246,-227,-210,-200,-191,-173,-143,-106,-75,-54,-39,-29,-24,-23,-20,-8,6,13,9,3,3,7,6,1,-4,-7,-11,-21,-37,-55,-80,-113,-148,-172,-178,-168,-149,-130,-117,-119,-131,-141,-142,-138,-137,-139,-135,-122,-107,-96,-85,-70,-61,-69,-89,-103,-106,-114,-137,-159,-162,-160,-181,-221,-229,-166,-59},
            {-45,157,108,-171,-203,155,268,-208,131,3632,10205,15155,12133,-410,-16026,-24787,-21775,-10975,-687,4286,5489,6765,9049,10040,8212,5686,6517,12525,21138,27066,25952,17129,4012,-7848,-14009,-13763,-10115,-6917,-5673,-5048,-3310,-767,525,-865,-4222,-7594,-9638,-10211,-9546,-7653,-4755,-1808,28,430,118,-49,132,380,540,672,697,422,63,338,1678,3441,4306,3564,1809,244,-488,-578,-400,-28,486,706,111,-1234,-2582,-3216,-3107,-2770,-2593,-2527,-2361,-2075,-1780,-1487,-1106,-681,-413,-401,-439,-219,305,841,1081,1018,882,842,851,795,687,651,735,831,808,665,501,370,209,-47,-346,-558,-631,-647,-719,-859,-982,-1026,-1009,-983,-958,-905,-818,-711,-597,-468,-345,-272,-258,-232,-103,117,292,301,163,31,43,207,429,608,698,688,583,406,213,67,-11,-51,-100,-181,-286,-398,-501,-582,-619,-602,-544,-477,-429,-406,-399,-391,-372,-332,-269,-191,-116,-58,-14,24,55,66,45,3,-32,-30,17,86,134,123,47,-65,-170,-240,-269,-264,-234,-192,-158,-142,-136,-122,-85,-36,6,31,38,31,7,-35,-95,-166,-238,-294,-321,-312,-278,-232,-179,-119,-58,-4,42,80,107,115,108,109,133,163,167,137,101,91,99,88,36,-39,-111,-164,-199,-222,-238,-261,-300,-342,-356,-323,-251,-171,-107,-70,-62,-79,-103,-118,-122,-122,-116,-93,-57,-29,-28,-46,-61,-67,-67,-57,-28,-2,-47,-207,-439,-639,-728,-704,-602,-440,-228,-8,161,260,321,362,347,241,85}
        },
        {    // H-20e070a.wav
            {0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,1,2,0,-1,-1,1,2,2,0,0,1,1,1,2,3,3,2,1,1,1,2,3,4,3,1,-2,-1,3,6,7,6,5,1,-5,-6,3,18,26,46,154,438,874,1240,1204,585,-407,-1240,-1432,-952,-245,173,173,77,276,813,1357,1556,1370,1059,912,1042,1414,1965,2619,3208,3489,3298,2699,1952,1310,859,520,196,-116,-328,-365,-265,-188,-318,-733,-1336,-1902,-2219,-2201,-1918,-1524,-1170,-949,-881,-918,-960,-895,-654,-257,192,563,782,872,924,1005,1096,1104,964,702,424,227,133,102,80,40,-26,-126,-270,-455,-653,-827,-942,-989,-980,-941,-897,-861,-831,-804,-779,-758,-741,-715,-660,-560,-417,-258,-116,-15,50,97,143,187,223,255,287,313,315,283,229,179,141,99,31,-63,-158,-229,-272,-298,-323,-351,-380,-406,-423,-430,-427,-416,-399,-380,-365,-354,-342,-320,-287,-246,-204,-165,-132,-106,-88,-71,-46,-16,8,17,14,10,14,19,15,3,-14,-31,-53,-83,-121,-161,-199,-230,-251,-260,-254,-234,-206,-182,-168,-168,-173,-174,-165,-147,-120,-87,-53,-28,-16,-15,-16,-17,-18,-20,-20,-16,-11,-8,-8,-7,-5,-6,-10,-18,-30,-52,-82,-112,-133,-142,-141,-129,-107,-83,-74,-88,-115,-140,-156,-165,-168,-159,-140,-122,-114,-115,-117,-118,-123,-128,-124,-116,-120,-141,-160,-162,-163,-191,-235,-241,-172,-61},
            {65,146,-50,-242,-19,325,61,-345,1418,7039,13938,15445,6564,-9843,-23739,-26086,-16678,-3599,4804,6780,6317,7053,8525,8334,6483,6249,10697,18956,26188,27102,19786,6992,-5685,-13287,-14320,-11072,-7234,-4883,-3502,-1705,491,1443,-193,-3833,-7498,-9677,-10261,-9783,-8386,-5982,-3085,-857,-70,-332,-596,-293,292,634,587,301,-94,-410,-189,971,2738,4017,3892,2525,944,-10,-279,-194,135,739,1302,1188,103,-1462,-2663,-3091,-2998,-2815,-2684,-2503,-2244,-2001,-1804,-1562,-1246,-978,-862,-787,-528,-34,482,767,792,726,707,721,700,664,698,821,937,942,845,731,643,523,308,29,-207,-345,-436,-559,-716,-835,-874,-869,-874,-891,-889,-866,-846,-829,-771,-658,-546,-489,-444,-307,-49,206,286,159,-29,-90,39,280,511,660,708,656,518,339,185,97,63,38,-21,-119,-239,-358,-458,-523,-541,-519,-477,-441,-425,-425,-430,-429,-406,-346,-253,-155,-86,-53,-34,-5,25,28,-5,-48,-58,-15,58,118,128,75,-23,-131,-212,-247,-236,-196,-149,-115,-104,-109,-108,-84,-37,14,50,62,51,21,-20,-67,-122,-192,-273,-338,-355,-317,-247,-178,-125,-82,-41,-4,28,54,77,96,115,138,162,165,133,81,44,43,60,63,39,-4,-51,-95,-134,-169,-212,-272,-339,-380,-366,-300,-215,-141,-90,-62,-61,-84,-113,-128,-125,-117,-106,-84,-51,-26,-22,-35,-50,-63,-72,-68,-47,-47,-132,-318,-537,-682,-706,-635,-507,-325,-95,128,269,315,321,331,315,223,80}
        },
        {    // H-20e075a.wav
            {0,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,3,3,3,1,0,1,3,4,5,5,5,2,-1,-2,2,6,8,4,0,0,5,11,17,35,93,225,442,700,881,831,453,-185,-809,-1067,-767,-64,610,852,594,134,-129,-8,379,788,1072,1252,1436,1717,2127,2627,3097,3359,3276,2867,2316,1839,1512,1233,844,299,-275,-683,-824,-780,-760,-943,-1346,-1822,-2171,-2270,-2127,-1841,-1525,-1247,-1023,-832,-632,-385,-83,244,531,717,779,755,719,727,775,800,737,577,371,194,91,56,47,13,-78,-231,-420,-606,-751,-842,-881,-880,-856,-827,-808,-799,-787,-758,-714,-669,-632,-591,-524,-424,-307,-196,-107,-38,22,77,124,160,189,215,237,245,229,187,128,66,10,-39,-91,-150,-213,-266,-295,-297,-284,-277,-289,-319,-353,-375,-379,-372,-363,-353,-338,-318,-296,-276,-254,-220,-176,-129,-93,-69,-48,-28,-15,-15,-25,-32,-28,-15,-3,1,-6,-24,-52,-87,-121,-148,-167,-180,-191,-201,-207,-208,-200,-187,-175,-169,-169,-171,-174,-176,-173,-156,-126,-89,-55,-29,-11,0,0,-8,-16,-18,-15,-11,-6,2,10,12,7,-1,-11,-28,-53,-80,-100,-107,-109,-105,-93,-75,-64,-76,-108,-145,-173,-187,-187,-172,-147,-126,-118,-121,-129,-140,-151,-157,-151,-140,-139,-152,-163,-159,-156,-180,-219,-223,-158,-55},
            {159,89,-192,-227,184,378,-191,-204,3055,10064,16079,13747,424,-17268,-27736,-24341,-11028,2057,7985,7702,6295,6564,7274,6741,6239,8909,15786,23701,27300,23105,12070,-1099,-10977,-14599,-12748,-8623,-5052,-2676,-574,1654,2858,1521,-2320,-6772,-9730,-10546,-9956,-8754,-7039,-4768,-2486,-1061,-747,-899,-727,-118,442,539,189,-360,-826,-812,118,1915,3702,4309,3338,1557,130,-398,-247,224,909,1648,1929,1252,-230,-1717,-2510,-2608,-2505,-2541,-2631,-2560,-2308,-2010,-1757,-1557,-1437,-1417,-1395,-1160,-623,30,487,603,507,428,471,590,703,791,868,923,920,863,810,813,834,766,540,211,-83,-258,-350,-449,-588,-719,-789,-792,-761,-729,-725,-772,-857,-925,-924,-862,-792,-722,-586,-336,-42,140,118,-39,-164,-136,47,307,550,701,717,608,437,288,206,180,172,148,87,-20,-160,-297,-394,-437,-446,-448,-452,-446,-425,-401,-395,-404,-400,-354,-269,-181,-121,-87,-56,-23,-8,-32,-79,-101,-69,5,80,114,90,16,-81,-165,-207,-201,-161,-110,-69,-51,-56,-69,-61,-18,43,88,96,72,32,-14,-67,-128,-192,-252,-301,-325,-311,-262,-197,-142,-107,-83,-55,-17,26,63,85,96,110,132,146,128,76,23,3,19,47,64,67,62,40,-6,-72,-141,-211,-287,-356,-380,-335,-243,-154,-101,-82,-80,-91,-111,-129,-128,-112,-95,-84,-70,-47,-27,-25,-41,-64,-83,-92,-82,-64,-85,-195,-384,-572,-671,-658,-569,-429,-229,16,228,327,324,305,320,319,234,86}
        },
        {    // H-20e080a.wav
            {0,0,0,0,1,2,1,0,0,1,2,2,1,0,1,2,2,0,0,1,2,1,0,0,1,2,1,0,-1,0,1,1,0,0,0,0,-2,-2,0,5,8,6,1,-2,-3,-2,-2,-1,4,9,10,6,2,2,8,25,66,147,269,408,518,554,491,335,133,-35,-97,-46,27,-8,-200,-445,-538,-330,152,725,1193,1470,1597,1678,1813,2077,2498,3018,3479,3677,3485,2936,2196,1455,821,302,-136,-507,-788,-951,-1020,-1088,-1269,-1616,-2057,-2419,-2525,-2304,-1823,-1244,-733,-382,-190,-85,14,152,311,437,494,488,467,485,556,648,691,631,469,262,86,-19,-62,-87,-134,-224,-353,-496,-618,-693,-730,-753,-780,-799,-791,-758,-717,-682,-644,-592,-536,-491,-460,-418,-348,-256,-168,-101,-50,-1,50,96,131,151,157,146,117,74,26,-19,-57,-89,-120,-153,-183,-207,-222,-233,-244,-255,-262,-267,-276,-292,-308,-315,-311,-303,-295,-286,-269,-245,-216,-189,-163,-137,-108,-81,-63,-57,-61,-65,-64,-59,-55,-53,-50,-43,-40,-49,-72,-98,-115,-123,-130,-142,-157,-171,-181,-187,-192,-196,-198,-199,-198,-195,-190,-181,-167,-148,-126,-101,-72,-39,-11,7,13,14,14,13,11,10,13,18,18,10,0,-11,-22,-37,-54,-67,-75,-81,-84,-85,-87,-97,-120,-151,-180,-200,-205,-193,-165,-132,-111,-109,-118,-127,-138,-156,-173,-176,-165,-157,-160,-162,-149,-136,-149,-182,-190,-138,-49},
            {216,19,-309,-201,337,388,-367,23,4384,12110,17007,11714,-4316,-21961,-29273,-21939,-6702,5595,9600,7993,6048,5772,5845,5600,6994,12153,19970,25995,25738,18043,5791,-6037,-13200,-14287,-10996,-6468,-2892,-374,1939,3895,3946,883,-4364,-9126,-11247,-10715,-9034,-7417,-5946,-4319,-2750,-1783,-1463,-1200,-537,247,505,25,-770,-1304,-1253,-501,954,2761,4083,4101,2794,1036,-176,-500,-193,457,1326,2118,2248,1328,-294,-1749,-2422,-2411,-2211,-2135,-2151,-2142,-2100,-2059,-1995,-1881,-1770,-1704,-1602,-1309,-801,-250,137,297,325,339,395,503,652,813,928,951,888,810,794,857,929,894,697,395,115,-72,-197,-330,-485,-617,-685,-695,-674,-644,-637,-697,-823,-953,-1011,-994,-950,-884,-729,-454,-162,-23,-96,-253,-305,-169,87,350,545,648,645,546,400,285,246,266,289,264,177,44,-101,-230,-322,-374,-392,-388,-378,-372,-375,-386,-402,-417,-416,-382,-313,-235,-175,-137,-105,-76,-71,-106,-156,-166,-105,0,86,108,64,-19,-108,-175,-198,-173,-112,-49,-10,-4,-17,-18,8,56,99,113,92,43,-17,-75,-124,-165,-210,-267,-321,-341,-310,-244,-181,-141,-115,-82,-38,6,38,56,62,57,49,46,46,40,23,9,17,46,74,86,80,67,46,11,-40,-104,-178,-254,-311,-323,-286,-225,-170,-135,-118,-117,-130,-146,-145,-125,-103,-98,-100,-87,-60,-40,-43,-60,-75,-87,-98,-105,-110,-150,-265,-445,-605,-662,-607,-488,-338,-147,74,251,319,299,279,303,313,234,87}
        },
        {    // H-20e085a.wav
            {0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,3,3,2,1,0,0,1,1,1,1,1,1,1,2,2,1,0,-1,-1,0,1,2,3,6,8,5,-1,-2,1,3,0,-2,2,11,12,5,1,8,15,11,18,83,211,336,388,395,482,711,929,834,254,-611,-1279,-1356,-855,-164,308,449,454,581,907,1310,1622,1782,1877,2060,2439,2991,3538,3821,3637,2981,2066,1204,626,353,219,14,-373,-885,-1367,-1693,-1858,-1953,-2058,-2157,-2146,-1929,-1504,-966,-457,-91,88,112,59,11,8,46,111,204,330,466,561,578,526,442,344,221,68,-84,-180,-197,-174,-174,-239,-358,-492,-606,-686,-730,-742,-727,-696,-660,-622,-583,-541,-500,-464,-435,-409,-378,-335,-280,-220,-157,-96,-40,5,33,42,37,26,11,-6,-23,-38,-52,-75,-114,-160,-193,-199,-189,-184,-199,-222,-235,-229,-216,-208,-211,-219,-224,-225,-224,-223,-219,-214,-211,-212,-211,-200,-173,-138,-111,-99,-97,-95,-92,-90,-91,-89,-76,-60,-53,-64,-84,-97,-102,-106,-116,-131,-143,-152,-164,-186,-210,-228,-233,-226,-213,-198,-182,-162,-141,-122,-107,-96,-80,-58,-36,-19,-3,18,42,59,59,46,30,14,-4,-24,-36,-35,-28,-28,-38,-50,-59,-66,-79,-100,-125,-153,-181,-208,-226,-230,-218,-189,-149,-113,-94,-95,-105,-117,-132,-156,-179,-186,-174,-158,-149,-141,-122,-108,-121,-154,-166,-123,-44},
            {258,-3,-368,-200,414,414,-451,62,4879,12933,17348,10731,-6480,-23989,-29724,-20549,-4533,7265,10345,8145,5854,5075,4703,4857,7740,14473,22428,26618,23627,14063,1799,-8536,-13788,-13411,-9336,-4530,-943,1455,3530,5047,4380,414,-5577,-10524,-12139,-10699,-8225,-6324,-5150,-4183,-3292,-2689,-2248,-1488,-331,548,418,-626,-1720,-2078,-1526,-260,1492,3318,4424,4099,2482,628,-405,-394,185,901,1642,2230,2189,1203,-357,-1654,-2169,-2095,-1937,-1910,-1887,-1765,-1663,-1730,-1931,-2112,-2179,-2111,-1879,-1449,-900,-424,-166,-93,-46,89,311,547,732,842,881,866,826,794,810,887,972,959,782,502,265,151,85,-59,-298,-527,-643,-650,-619,-596,-594,-636,-743,-893,-1015,-1061,-1040,-966,-816,-581,-343,-234,-297,-418,-422,-233,72,356,531,588,560,485,400,339,321,339,361,340,248,97,-59,-173,-234,-268,-295,-310,-303,-288,-294,-336,-401,-454,-465,-425,-348,-261,-192,-151,-131,-130,-152,-193,-225,-211,-134,-23,70,102,64,-21,-112,-173,-182,-146,-87,-27,20,44,49,48,61,93,125,129,94,34,-29,-82,-126,-170,-225,-286,-335,-346,-310,-242,-173,-118,-76,-39,-11,4,6,-1,-13,-25,-26,-12,8,11,-2,-7,18,64,102,116,114,109,95,58,-1,-71,-142,-210,-261,-277,-251,-206,-171,-156,-153,-157,-165,-172,-163,-137,-113,-109,-115,-105,-75,-46,-38,-46,-58,-72,-89,-105,-125,-179,-304,-478,-618,-649,-569,-434,-276,-88,115,264,301,261,239,276,301,232,88}
        },
        {    // H-20e090a.wav
            {0,0,0,0,1,1,2,2,2,1,0,0,1,2,2,1,0,1,2,2,2,2,2,3,2,0,-1,0,3,3,1,-1,0,1,1,-1,-3,-1,5,8,6,0,-2,1,4,3,2,4,10,9,0,-7,-1,12,16,3,-10,-6,19,67,181,409,728,985,978,626,71,-427,-698,-767,-753,-690,-493,-91,432,862,1037,987,916,1036,1422,1983,2528,2878,2960,2833,2642,2497,2394,2228,1903,1433,931,523,245,22,-285,-782,-1454,-2130,-2555,-2550,-2145,-1568,-1084,-809,-678,-549,-354,-132,30,82,30,-78,-174,-193,-97,94,304,447,478,415,305,194,105,41,-7,-58,-121,-187,-237,-264,-285,-336,-433,-555,-653,-692,-674,-630,-583,-537,-488,-443,-419,-418,-418,-396,-349,-301,-271,-254,-230,-186,-129,-76,-42,-31,-39,-57,-76,-89,-94,-95,-98,-110,-133,-165,-195,-215,-221,-217,-207,-192,-175,-162,-153,-145,-132,-117,-112,-125,-154,-181,-195,-195,-191,-192,-196,-199,-198,-193,-182,-165,-140,-111,-85,-73,-76,-85,-90,-92,-98,-112,-125,-127,-118,-112,-119,-138,-160,-179,-193,-205,-214,-217,-212,-200,-184,-166,-147,-127,-105,-84,-67,-54,-42,-29,-18,-11,-2,14,35,52,55,46,32,16,-6,-32,-52,-61,-61,-58,-56,-54,-56,-66,-88,-117,-148,-180,-212,-239,-252,-246,-224,-191,-149,-108,-81,-74,-79,-89,-105,-131,-158,-168,-159,-142,-129,-111,-83,-63,-77,-119,-144,-113,-42},
            {269,35,-368,-255,392,490,-411,-183,4329,12471,17472,11495,-5613,-23657,-30050,-21073,-4719,7540,10788,8402,5750,4611,4024,4286,7679,15045,23175,26716,22557,12112,-132,-9631,-13809,-12597,-8009,-2911,731,2853,4407,5445,4530,436,-5780,-11013,-12678,-10869,-7833,-5626,-4630,-4149,-3714,-3352,-2941,-2050,-649,461,355,-925,-2309,-2723,-1924,-307,1666,3537,4607,4223,2514,560,-473,-304,500,1339,2028,2454,2245,1129,-509,-1792,-2164,-1870,-1541,-1491,-1574,-1588,-1562,-1625,-1784,-1949,-2077,-2160,-2114,-1819,-1293,-743,-389,-269,-246,-161,47,343,643,856,930,883,788,727,747,845,962,992,862,610,382,279,254,166,-49,-313,-507,-591,-604,-591,-579,-600,-689,-834,-970,-1047,-1062,-1017,-891,-683,-478,-402,-480,-582,-541,-308,18,301,477,547,533,458,365,312,327,384,422,394,295,154,13,-95,-160,-195,-215,-229,-236,-241,-256,-296,-364,-439,-482,-461,-384,-289,-216,-175,-159,-164,-197,-250,-285,-259,-169,-53,34,63,32,-36,-110,-156,-154,-114,-62,-20,8,26,40,56,86,132,174,179,134,53,-32,-99,-146,-184,-227,-274,-307,-306,-268,-214,-168,-135,-109,-87,-71,-63,-54,-42,-36,-43,-51,-45,-32,-35,-53,-55,-10,69,138,172,185,191,177,122,32,-63,-139,-199,-242,-254,-228,-184,-160,-172,-204,-229,-234,-218,-186,-147,-120,-117,-125,-120,-92,-56,-29,-18,-20,-36,-63,-92,-126,-197,-334,-509,-638,-653,-560,-416,-251,-62,132,262,279,226,200,239,271,213,81}
        },
        {    // H-20e095a.wav
            {0,0,0,0,0,0,1,2,2,0,0,0,1,2,2,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,2,2,0,-2,-2,2,6,4,-2,-3,2,6,3,-2,1,13,18,9,-4,-6,3,3,-8,-12,0,11,16,82,322,743,1136,1167,654,-217,-979,-1230,-920,-341,139,327,269,141,122,315,700,1142,1479,1660,1802,2070,2473,2803,2795,2381,1767,1282,1135,1300,1568,1699,1541,1099,520,2,-354,-621,-975,-1511,-2108,-2487,-2411,-1861,-1053,-302,152,240,72,-159,-286,-257,-140,-43,-26,-68,-101,-78,1,105,196,243,224,142,31,-60,-101,-106,-115,-166,-258,-357,-425,-445,-435,-432,-464,-527,-589,-609,-572,-495,-411,-346,-310,-301,-312,-328,-328,-301,-256,-217,-197,-187,-164,-125,-88,-76,-90,-115,-139,-158,-176,-187,-186,-181,-188,-211,-237,-251,-247,-237,-225,-200,-158,-108,-76,-73,-89,-103,-109,-109,-113,-121,-129,-136,-147,-162,-180,-194,-198,-193,-180,-159,-131,-103,-85,-84,-99,-117,-128,-132,-137,-147,-161,-174,-185,-193,-197,-197,-193,-190,-192,-195,-195,-188,-175,-158,-140,-121,-102,-82,-59,-36,-18,-7,1,9,17,20,17,11,7,4,1,-4,-9,-16,-28,-44,-59,-70,-79,-90,-100,-105,-104,-103,-107,-119,-142,-176,-216,-249,-262,-254,-231,-198,-156,-111,-77,-61,-59,-65,-78,-100,-124,-132,-123,-109,-100,-90,-70,-52,-61,-97,-121,-97,-37},
            {230,129,-282,-349,240,578,-189,-547,2839,10573,17004,13716,-1627,-20565,-29917,-23525,-7514,6256,11014,8924,5746,4261,3748,3948,6834,13740,22104,26491,23050,12664,22,-9760,-13820,-12228,-7226,-1790,2002,3925,4962,5538,4619,914,-5049,-10557,-12806,-11311,-8067,-5452,-4310,-4032,-3897,-3752,-3534,-2857,-1526,-169,164,-850,-2347,-3085,-2496,-835,1343,3447,4724,4480,2777,705,-423,-186,801,1754,2393,2707,2461,1362,-328,-1763,-2264,-1946,-1461,-1255,-1277,-1321,-1373,-1537,-1787,-1978,-2043,-2030,-1965,-1789,-1475,-1116,-836,-658,-503,-304,-65,184,423,636,787,853,844,799,770,796,873,928,868,686,493,399,385,320,125,-134,-335,-436,-484,-526,-567,-608,-678,-791,-911,-993,-1026,-1017,-945,-790,-607,-514,-563,-654,-620,-389,-52,240,407,464,454,405,339,296,314,383,446,441,350,209,71,-30,-93,-132,-159,-178,-191,-205,-230,-272,-334,-400,-442,-432,-373,-297,-239,-207,-188,-183,-208,-263,-310,-300,-219,-106,-14,22,0,-60,-125,-161,-149,-103,-52,-18,1,12,23,44,88,150,203,211,163,77,-14,-86,-129,-150,-168,-202,-250,-280,-269,-227,-190,-177,-177,-167,-144,-116,-90,-65,-46,-42,-52,-63,-68,-74,-82,-70,-14,77,162,216,241,250,235,181,93,-7,-98,-178,-239,-262,-243,-206,-191,-211,-245,-269,-273,-255,-213,-159,-118,-110,-123,-122,-90,-43,-3,19,26,13,-23,-72,-126,-206,-340,-510,-640,-657,-561,-409,-246,-73,100,221,245,203,180,213,243,192,74}
        },
        {    // H-20e100a.wav
            {0,0,0,0,0,0,1,1,1,1,1,1,1,0,-1,0,1,2,2,1,1,0,0,-1,-1,0,1,1,0,-2,-2,0,3,1,-3,-4,-1,3,2,-2,-2,2,3,-2,-7,-2,8,12,7,3,7,10,0,-16,-21,-16,-13,21,178,520,937,1148,895,198,-611,-1125,-1156,-822,-375,12,304,525,670,720,689,642,686,938,1462,2177,2821,3070,2770,2091,1411,1025,945,969,924,814,754,801,881,864,680,345,-86,-559,-1016,-1389,-1619,-1694,-1637,-1456,-1128,-642,-67,438,700,645,345,-20,-266,-300,-160,27,125,85,-40,-147,-165,-105,-24,24,22,-25,-111,-223,-335,-417,-457,-473,-486,-499,-497,-476,-454,-455,-482,-509,-507,-463,-385,-299,-228,-189,-188,-210,-230,-224,-189,-144,-113,-107,-117,-130,-138,-143,-147,-149,-152,-165,-198,-243,-283,-304,-308,-304,-297,-281,-251,-218,-193,-182,-177,-168,-153,-134,-117,-101,-87,-78,-75,-76,-82,-94,-111,-129,-137,-133,-117,-101,-94,-101,-117,-133,-142,-144,-142,-139,-142,-155,-180,-212,-242,-263,-273,-272,-261,-239,-212,-187,-171,-162,-154,-144,-132,-118,-100,-76,-51,-28,-8,10,23,29,27,22,19,20,20,14,-1,-23,-46,-63,-72,-77,-82,-88,-94,-99,-105,-112,-118,-123,-129,-138,-150,-159,-169,-186,-210,-231,-235,-223,-206,-188,-165,-135,-103,-77,-59,-49,-47,-57,-73,-82,-81,-79,-83,-85,-77,-69,-82,-111,-124,-94,-34},
            {125,264,-64,-404,-63,540,202,-670,932,7266,15064,16109,4917,-13920,-27801,-26955,-13193,2518,10564,10000,6245,3896,3399,3728,5717,11140,19156,25248,24484,15756,2810,-8494,-13912,-12759,-7413,-1354,2901,4863,5514,5656,4778,1689,-3658,-9268,-12391,-11835,-8885,-5907,-4286,-3814,-3729,-3738,-3850,-3742,-2907,-1477,-426,-627,-1861,-2981,-2972,-1655,492,2774,4414,4686,3420,1406,-58,-207,680,1809,2665,3105,2946,1925,195,-1467,-2246,-2042,-1471,-1154,-1179,-1287,-1330,-1398,-1590,-1852,-2061,-2141,-2056,-1789,-1405,-1070,-924,-929,-909,-725,-393,-21,299,532,671,727,737,743,768,820,885,922,864,697,507,419,447,464,333,66,-194,-338,-383,-410,-461,-530,-616,-732,-868,-982,-1036,-1027,-960,-837,-688,-584,-583,-647,-648,-485,-181,134,341,410,389,340,296,275,290,342,408,439,396,278,130,7,-62,-89,-108,-138,-175,-204,-220,-237,-278,-340,-390,-389,-332,-261,-217,-204,-200,-196,-212,-262,-319,-331,-276,-177,-83,-28,-28,-80,-157,-213,-208,-144,-60,5,35,39,29,27,54,118,191,228,204,134,50,-22,-73,-105,-132,-172,-231,-285,-297,-263,-214,-184,-180,-183,-180,-171,-155,-129,-95,-69,-58,-53,-44,-38,-44,-47,-19,48,129,194,239,273,287,261,188,82,-35,-152,-253,-311,-311,-274,-244,-244,-262,-276,-276,-263,-230,-176,-122,-99,-104,-105,-74,-20,27,49,48,28,-6,-49,-99,-178,-310,-481,-620,-654,-575,-436,-280,-115,48,161,186,154,148,196,235,189,73}
        },
        {    // H-20e105a.wav
            {3,4,3,2,3,4,5,5,4,3,3,4,4,4,3,3,3,4,4,4,4,5,5,5,5,6,6,5,3,3,5,7,6,3,3,5,7,4,1,3,9,10,5,0,2,7,9,9,13,18,16,5,0,5,-2,-16,54,337,826,1256,1233,575,-457,-1306,-1537,-1144,-480,77,374,478,510,543,611,738,937,1209,1554,1969,2408,2745,2826,2572,2042,1389,779,345,170,258,484,636,558,279,-14,-146,-104,-21,-42,-230,-555,-936,-1252,-1372,-1225,-880,-510,-252,-90,103,402,731,922,866,596,254,-15,-130,-101,-10,36,-31,-179,-301,-312,-224,-130,-117,-198,-334,-484,-622,-719,-738,-671,-561,-482,-470,-503,-528,-519,-481,-431,-373,-307,-239,-180,-128,-78,-30,-3,-8,-35,-62,-75,-79,-84,-89,-90,-89,-101,-131,-172,-209,-239,-272,-313,-353,-371,-358,-322,-287,-266,-260,-262,-264,-263,-252,-228,-190,-146,-109,-85,-71,-64,-60,-56,-46,-27,-4,11,5,-19,-46,-66,-82,-99,-118,-131,-140,-150,-170,-198,-228,-255,-278,-296,-306,-302,-287,-265,-241,-214,-184,-151,-120,-95,-76,-61,-46,-30,-16,-6,2,14,28,38,41,38,36,37,36,29,14,-9,-36,-67,-95,-117,-129,-132,-126,-115,-106,-106,-116,-128,-134,-138,-146,-160,-174,-182,-186,-188,-187,-180,-170,-165,-163,-157,-139,-111,-79,-48,-22,-8,-9,-19,-28,-34,-46,-66,-83,-87,-88,-105,-132,-138,-100,-35},
            {-63,309,218,-298,-388,253,556,-273,-454,3281,10925,16390,11848,-3741,-21287,-28471,-20684,-4820,7730,11083,7887,4070,2664,3097,4644,8345,14945,22109,24994,20090,8494,-4502,-12984,-14085,-9159,-2139,3322,5845,6259,5906,5005,2619,-1844,-7277,-11281,-12074,-9971,-6928,-4727,-3758,-3456,-3419,-3715,-4231,-4305,-3385,-1860,-865,-1129,-2217,-2962,-2498,-799,1513,3566,4540,4040,2455,831,123,505,1462,2435,3154,3404,2832,1320,-592,-1949,-2203,-1667,-1102,-964,-1159,-1388,-1520,-1614,-1737,-1891,-2039,-2110,-2000,-1669,-1244,-940,-860,-903,-894,-747,-487,-157,209,541,744,775,701,643,682,807,935,962,834,604,413,365,420,429,289,49,-164,-280,-330,-374,-437,-521,-631,-772,-916,-1021,-1057,-1015,-898,-733,-593,-556,-623,-683,-598,-330,15,285,398,381,309,240,199,199,248,332,406,415,337,199,60,-34,-75,-90,-110,-146,-184,-205,-208,-215,-247,-294,-322,-303,-250,-204,-189,-193,-197,-208,-247,-310,-354,-341,-269,-176,-103,-76,-100,-161,-220,-235,-193,-118,-49,-2,27,44,51,64,105,173,231,238,187,105,25,-39,-88,-127,-168,-217,-268,-295,-280,-235,-196,-183,-193,-206,-212,-201,-173,-131,-90,-62,-41,-17,1,-4,-24,-24,20,92,157,205,246,284,293,249,157,39,-88,-216,-321,-373,-362,-322,-292,-284,-282,-273,-253,-222,-179,-131,-95,-82,-78,-61,-25,18,52,66,53,16,-29,-74,-138,-256,-427,-583,-647,-598,-479,-336,-186,-36,76,117,110,122,174,212,169,64}
        },
        {    // H-20e110a.wav
            {-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,-1,-2,-3,-3,-3,-2,-1,-1,-2,-3,-2,-1,-2,-3,-3,0,1,-1,-4,-3,0,0,-4,-7,-4,1,2,-1,-3,-3,-4,-6,-2,7,9,-3,-11,2,15,-1,1,175,627,1207,1495,1101,50,-1155,-1881,-1824,-1159,-315,354,723,832,788,699,658,722,919,1287,1860,2583,3228,3470,3114,2266,1277,511,134,85,183,258,215,59,-137,-284,-356,-409,-514,-666,-773,-744,-586,-412,-350,-447,-630,-761,-723,-485,-127,217,442,550,640,806,1034,1190,1128,823,395,16,-204,-268,-246,-212,-210,-249,-317,-394,-466,-538,-620,-708,-780,-815,-817,-801,-773,-722,-648,-578,-542,-542,-545,-505,-410,-280,-148,-35,51,104,120,103,65,28,6,1,8,15,17,8,-19,-69,-135,-204,-256,-286,-297,-304,-316,-340,-373,-407,-430,-434,-420,-395,-367,-336,-303,-271,-247,-231,-213,-179,-126,-65,-13,22,41,50,56,57,50,34,10,-19,-53,-90,-123,-150,-174,-200,-231,-261,-284,-299,-311,-321,-328,-322,-300,-267,-233,-202,-172,-139,-104,-71,-45,-25,-9,0,-4,-17,-28,-23,-5,14,22,21,23,29,29,12,-21,-61,-98,-127,-148,-157,-155,-147,-138,-131,-130,-138,-151,-165,-172,-171,-164,-158,-155,-160,-173,-187,-192,-184,-174,-170,-170,-160,-134,-102,-74,-51,-30,-15,-11,-17,-23,-27,-41,-72,-108,-132,-146,-164,-182,-173,-118,-40},
            {-213,160,363,-2,-456,-205,482,362,-581,219,5351,12839,15555,7380,-9402,-24077,-26294,-15235,151,9702,10270,6033,2522,1819,3113,5859,10711,17401,22951,23047,15607,3078,-8742,-14436,-12359,-5234,2215,6587,7508,6650,5403,3570,181,-4715,-9391,-11700,-10920,-8272,-5669,-4133,-3459,-3151,-3226,-3911,-4857,-5124,-4131,-2416,-1204,-1222,-2053,-2600,-2025,-272,2007,3831,4381,3510,1926,720,537,1201,2125,2914,3417,3396,2516,828,-957,-1958,-1901,-1295,-847,-849,-1136,-1454,-1697,-1860,-1949,-1995,-2033,-2030,-1886,-1577,-1237,-1026,-957,-906,-786,-629,-478,-282,30,410,703,801,748,678,690,783,880,890,772,577,420,373,393,368,238,48,-117,-221,-286,-348,-426,-527,-653,-790,-912,-1000,-1039,-1000,-863,-671,-533,-535,-630,-661,-505,-190,136,338,385,329,231,138,86,107,206,331,408,384,270,124,4,-65,-95,-107,-114,-122,-132,-145,-163,-190,-229,-266,-276,-247,-198,-165,-166,-192,-227,-270,-325,-374,-389,-351,-275,-194,-136,-122,-159,-227,-276,-264,-194,-108,-42,4,46,81,103,118,148,193,220,196,126,47,-10,-44,-73,-118,-185,-261,-316,-325,-288,-234,-191,-172,-171,-183,-198,-200,-173,-126,-84,-59,-41,-16,5,6,-6,4,53,120,172,201,221,236,232,192,113,3,-128,-262,-368,-420,-416,-375,-324,-276,-241,-220,-202,-174,-135,-101,-88,-90,-85,-59,-15,34,71,77,43,-11,-59,-105,-190,-341,-518,-635,-640,-553,-423,-278,-130,-6,60,72,81,117,148,123,47}
        },
        {    // H-20e115a.wav
            {3,3,3,2,1,3,4,4,3,1,2,3,4,3,2,2,2,1,1,2,4,3,1,2,3,4,3,3,5,6,5,3,4,5,3,0,1,4,5,3,4,8,8,0,-5,7,21,14,-9,-12,14,23,-2,64,424,1089,1685,1648,712,-757,-1977,-2340,-1821,-873,5,587,894,1016,1011,935,877,941,1211,1731,2460,3216,3689,3610,2945,1940,954,233,-172,-325,-302,-178,-57,-60,-240,-544,-846,-1044,-1106,-1069,-993,-928,-888,-834,-695,-440,-138,65,63,-99,-244,-201,68,459,828,1091,1239,1298,1293,1236,1123,930,636,267,-83,-306,-366,-331,-316,-391,-544,-717,-857,-943,-971,-945,-888,-837,-823,-851,-889,-893,-839,-734,-606,-483,-376,-282,-191,-91,15,114,183,206,189,161,152,165,185,189,171,134,79,10,-59,-106,-124,-137,-176,-251,-336,-402,-441,-466,-485,-491,-478,-455,-442,-441,-439,-418,-378,-329,-276,-217,-151,-89,-40,-4,28,64,97,117,119,111,98,78,39,-22,-91,-146,-176,-190,-200,-216,-233,-252,-271,-289,-299,-292,-271,-244,-218,-192,-162,-130,-103,-82,-65,-48,-31,-17,-9,-5,-5,-7,-8,-3,6,18,27,29,19,-5,-39,-75,-105,-124,-132,-132,-129,-127,-131,-138,-141,-138,-129,-119,-110,-106,-111,-126,-144,-158,-166,-172,-177,-175,-163,-147,-139,-138,-136,-122,-97,-71,-47,-26,-7,5,8,2,-14,-44,-85,-125,-152,-167,-179,-184,-162,-104,-34},
            {-166,-116,169,262,-96,-404,-56,499,176,-610,812,6374,13197,14183,4587,-11755,-24082,-23762,-11867,2351,10023,9360,4800,1390,989,3010,6842,12380,18537,22389,20624,12261,157,-10205,-14028,-10277,-2197,5205,8688,8399,6488,4450,1972,-1834,-6569,-10320,-11323,-9620,-6905,-4867,-3892,-3387,-3007,-3143,-4156,-5494,-5968,-4938,-3025,-1517,-1178,-1687,-2082,-1560,31,2143,3799,4160,3167,1668,761,915,1764,2686,3357,3664,3365,2205,422,-1166,-1798,-1460,-816,-516,-702,-1130,-1553,-1872,-2060,-2116,-2097,-2070,-2013,-1835,-1532,-1247,-1116,-1095,-1025,-833,-600,-415,-250,-14,299,587,744,767,739,739,782,822,795,687,558,485,481,471,374,194,8,-116,-180,-224,-282,-374,-504,-658,-804,-909,-966,-979,-931,-803,-631,-512,-519,-601,-613,-448,-142,159,333,355,283,182,92,47,76,180,304,367,325,205,77,-6,-38,-42,-39,-42,-59,-89,-121,-143,-161,-188,-222,-240,-222,-186,-169,-189,-229,-268,-305,-349,-387,-395,-358,-289,-217,-172,-172,-214,-263,-275,-227,-141,-56,6,49,78,90,88,99,139,195,222,196,126,48,-13,-54,-85,-127,-192,-272,-331,-333,-278,-199,-139,-114,-121,-144,-168,-177,-163,-132,-100,-69,-34,1,23,27,26,44,84,127,159,180,197,206,193,149,73,-33,-158,-279,-369,-411,-405,-361,-296,-230,-180,-152,-137,-126,-118,-114,-111,-99,-73,-34,14,62,90,80,35,-19,-66,-131,-251,-421,-575,-642,-599,-482,-336,-197,-92,-33,-3,35,92,132,113,44}
        },
        {    // H-20e120a.wav
            {0,1,1,1,1,1,1,1,1,1,1,0,-1,0,1,0,-1,-1,0,1,1,0,0,0,-1,0,2,3,2,1,3,6,3,-3,-3,2,4,-2,-6,2,11,7,-9,-10,11,23,4,-18,-3,27,9,-6,206,831,1667,2089,1506,-42,-1784,-2778,-2613,-1614,-440,440,925,1121,1137,1057,985,1031,1276,1767,2506,3379,4079,4213,3574,2351,1038,90,-345,-409,-323,-230,-201,-287,-511,-813,-1073,-1216,-1275,-1335,-1421,-1465,-1382,-1164,-887,-637,-451,-307,-162,7,182,312,350,314,309,460,801,1217,1524,1603,1480,1270,1071,914,784,652,486,254,-46,-366,-631,-800,-892,-956,-1014,-1048,-1046,-1025,-1020,-1041,-1063,-1057,-1018,-957,-874,-759,-613,-461,-334,-246,-179,-108,-21,77,173,257,322,356,357,332,293,254,217,186,159,132,92,26,-68,-176,-281,-367,-424,-451,-455,-454,-464,-495,-535,-568,-578,-562,-525,-473,-412,-349,-290,-237,-186,-134,-82,-30,25,81,131,158,148,105,51,6,-21,-37,-55,-82,-117,-160,-203,-235,-246,-237,-220,-207,-201,-198,-194,-189,-187,-185,-181,-171,-156,-138,-113,-83,-54,-34,-26,-23,-19,-11,-4,-2,-5,-11,-19,-31,-52,-80,-109,-130,-142,-150,-154,-154,-147,-136,-126,-115,-100,-81,-62,-50,-48,-56,-76,-108,-151,-191,-218,-224,-212,-187,-158,-135,-125,-124,-127,-129,-128,-119,-95,-56,-18,3,3,-13,-38,-75,-120,-157,-173,-173,-172,-170,-150,-97,-32},
            {55,-198,-178,157,291,-70,-392,-52,479,153,-558,932,6311,12633,13202,3866,-11443,-22646,-21989,-10732,2511,9589,8791,4138,488,54,2620,7305,13182,18640,21169,18509,10409,-487,-9535,-12590,-8638,-583,6732,9920,8980,6199,3416,576,-3157,-7443,-10472,-10708,-8539,-5899,-4358,-3893,-3587,-3120,-3151,-4240,-5819,-6564,-5716,-3807,-2059,-1274,-1323,-1487,-1054,258,2100,3592,3885,2904,1525,842,1231,2207,3110,3673,3853,3428,2146,283,-1276,-1747,-1186,-382,-77,-406,-1038,-1628,-2028,-2219,-2237,-2176,-2129,-2074,-1901,-1589,-1289,-1160,-1178,-1159,-983,-709,-454,-242,-10,265,517,669,716,723,748,792,810,758,647,548,526,564,566,448,227,4,-137,-191,-208,-239,-314,-445,-616,-779,-884,-920,-904,-846,-741,-613,-533,-554,-631,-633,-464,-162,134,303,323,250,145,54,11,46,155,281,350,320,215,99,22,-4,1,11,9,-11,-45,-82,-119,-157,-201,-239,-254,-239,-212,-199,-213,-248,-292,-344,-400,-444,-456,-420,-343,-250,-175,-146,-166,-206,-221,-186,-119,-53,-9,18,39,55,73,105,159,213,228,182,94,6,-48,-66,-71,-91,-145,-222,-286,-303,-267,-203,-150,-125,-124,-134,-143,-145,-141,-131,-117,-97,-66,-27,8,31,45,65,97,135,165,180,181,168,138,85,10,-83,-186,-285,-357,-384,-360,-301,-234,-175,-134,-112,-109,-123,-140,-146,-137,-117,-89,-48,9,62,83,58,10,-35,-82,-167,-313,-487,-616,-640,-560,-421,-282,-182,-123,-81,-27,39,84,79,33}
        },
        {    // H-20e125a.wav
            {1,1,1,2,2,2,1,1,2,1,0,1,2,2,0,-1,1,3,2,0,0,1,1,1,2,3,4,2,3,6,7,3,-1,2,7,3,-5,-3,11,15,-1,-16,-2,25,21,-12,-19,23,42,-2,62,540,1470,2317,2250,878,-1244,-2950,-3364,-2508,-1103,119,873,1245,1375,1326,1170,1062,1186,1659,2495,3557,4517,4918,4429,3130,1521,187,-575,-836,-814,-658,-440,-273,-306,-598,-1037,-1432,-1682,-1811,-1871,-1849,-1707,-1471,-1223,-1010,-789,-509,-206,10,77,60,95,260,520,790,1004,1140,1199,1206,1202,1226,1262,1251,1152,1001,876,805,727,544,219,-196,-603,-920,-1109,-1174,-1160,-1127,-1126,-1161,-1198,-1202,-1164,-1097,-1013,-916,-812,-712,-623,-533,-422,-285,-144,-28,57,131,214,304,379,419,428,425,418,402,365,307,232,143,40,-72,-170,-237,-272,-298,-336,-390,-451,-505,-551,-586,-605,-603,-581,-551,-518,-481,-433,-377,-323,-275,-223,-153,-67,12,60,71,61,52,50,48,39,24,5,-17,-45,-76,-103,-122,-135,-145,-148,-143,-132,-124,-128,-143,-164,-183,-196,-203,-204,-198,-183,-161,-135,-109,-84,-57,-31,-11,-3,-4,-11,-20,-36,-60,-87,-107,-120,-131,-146,-163,-176,-180,-173,-155,-128,-93,-58,-26,-1,16,25,22,7,-20,-62,-114,-170,-218,-246,-253,-239,-209,-172,-140,-123,-119,-124,-131,-139,-138,-120,-85,-51,-35,-40,-53,-65,-82,-106,-126,-129,-123,-124,-133,-129,-90,-31},
            {110,13,-167,-135,142,258,-48,-346,-78,414,187,-482,649,5339,11344,12668,4966,-8990,-20241,-21004,-11386,1159,8622,8481,3958,-108,-897,1830,6982,13010,17994,19832,17060,9845,425,-7487,-10402,-7165,26,6910,10081,9109,5995,2739,-318,-3815,-7583,-10135,-10103,-7848,-5252,-3920,-3840,-3932,-3613,-3434,-4169,-5613,-6627,-6276,-4719,-2914,-1683,-1162,-943,-487,533,1987,3234,3522,2699,1499,952,1447,2505,3416,3886,3943,3483,2286,527,-1030,-1607,-1138,-303,138,-74,-723,-1465,-2057,-2369,-2398,-2280,-2182,-2130,-2003,-1731,-1426,-1254,-1220,-1177,-1013,-770,-546,-349,-116,172,444,620,692,720,758,812,839,793,675,553,512,566,622,565,365,102,-113,-225,-254,-255,-285,-375,-517,-666,-776,-834,-849,-822,-748,-654,-601,-626,-680,-656,-487,-213,57,230,281,235,141,53,22,71,180,293,352,333,253,155,81,49,51,57,42,0,-53,-99,-131,-165,-209,-253,-270,-255,-232,-237,-278,-334,-382,-419,-449,-463,-442,-381,-295,-212,-152,-127,-140,-175,-196,-177,-122,-61,-15,16,39,52,58,73,118,177,208,180,109,37,-5,-20,-34,-66,-120,-188,-250,-280,-264,-216,-165,-134,-126,-130,-137,-139,-136,-131,-124,-108,-74,-25,21,45,55,74,111,152,177,180,170,148,106,38,-45,-129,-211,-286,-337,-340,-289,-209,-138,-96,-84,-95,-123,-157,-180,-181,-163,-138,-107,-62,-3,49,67,44,-1,-49,-112,-217,-371,-533,-627,-607,-490,-350,-251,-204,-169,-110,-31,29,43,20}
        },
        {    // H-20e130a.wav
            {0,1,2,1,-1,0,2,2,1,-1,0,1,0,-2,-1,1,2,0,-1,0,0,-1,-1,2,4,1,-1,2,6,3,-3,-1,8,9,-3,-12,2,19,11,-16,-19,14,35,4,-33,-5,50,29,-7,278,1162,2336,2864,1907,-394,-2831,-4038,-3545,-1979,-354,737,1292,1534,1580,1465,1299,1293,1643,2430,3566,4743,5456,5231,3988,2177,504,-559,-994,-1056,-961,-791,-622,-592,-788,-1128,-1435,-1624,-1769,-1962,-2165,-2238,-2100,-1806,-1454,-1084,-696,-334,-88,11,42,118,260,412,555,759,1077,1420,1599,1509,1235,963,817,798,855,954,1049,1061,915,637,331,79,-141,-400,-707,-987,-1160,-1225,-1240,-1247,-1243,-1219,-1184,-1153,-1113,-1037,-921,-794,-682,-582,-471,-337,-194,-64,40,119,181,233,291,367,457,535,565,523,419,288,172,92,42,4,-41,-97,-163,-239,-318,-391,-447,-485,-517,-552,-588,-609,-601,-566,-521,-482,-452,-420,-375,-316,-255,-200,-154,-112,-71,-38,-15,2,18,30,32,18,-4,-24,-34,-37,-36,-31,-25,-28,-44,-72,-100,-120,-133,-145,-158,-169,-176,-183,-193,-201,-200,-185,-162,-137,-114,-90,-63,-37,-24,-27,-43,-62,-80,-100,-123,-148,-171,-186,-193,-192,-180,-160,-136,-114,-92,-67,-35,1,36,65,83,87,74,44,-5,-72,-149,-221,-270,-289,-281,-256,-222,-187,-157,-137,-131,-134,-143,-153,-157,-147,-127,-106,-93,-85,-73,-62,-61,-72,-81,-76,-69,-80,-106,-117,-86,-31},
            {-56,101,101,-97,-186,26,236,62,-276,-184,284,284,-337,134,3712,9368,12141,7150,-4866,-16661,-20126,-13251,-1589,6891,8194,4218,-276,-1703,727,5831,11760,16594,18553,16451,10403,2246,-4867,-7867,-5567,380,6395,9363,8580,5607,2344,-597,-3680,-6978,-9413,-9678,-7746,-5136,-3574,-3501,-4032,-4224,-4102,-4359,-5268,-6209,-6304,-5306,-3758,-2382,-1487,-888,-211,781,1992,2966,3167,2490,1509,1075,1570,2619,3555,4022,4027,3565,2504,940,-558,-1291,-1065,-357,141,71,-479,-1224,-1905,-2350,-2497,-2428,-2303,-2204,-2081,-1872,-1626,-1444,-1331,-1188,-959,-711,-536,-418,-257,-6,267,474,595,685,788,897,958,917,765,565,432,439,539,597,506,283,33,-149,-242,-282,-317,-376,-465,-570,-669,-745,-793,-808,-781,-724,-678,-682,-719,-706,-570,-319,-40,166,251,232,160,87,59,100,202,323,405,409,335,219,111,46,28,30,17,-26,-84,-129,-152,-173,-215,-274,-322,-339,-336,-341,-364,-388,-399,-401,-405,-409,-397,-360,-304,-243,-188,-148,-135,-144,-154,-140,-102,-61,-36,-22,-10,4,20,47,99,169,219,217,160,80,8,-42,-73,-98,-132,-176,-220,-242,-233,-203,-175,-162,-163,-169,-171,-166,-149,-122,-94,-68,-42,-13,11,20,24,43,89,146,186,194,175,133,72,-7,-90,-169,-239,-294,-318,-295,-228,-145,-80,-51,-60,-101,-160,-214,-240,-230,-200,-166,-130,-82,-24,22,32,4,-41,-89,-153,-263,-417,-559,-614,-555,-429,-324,-279,-263,-220,-136,-49,-1,5}
        },
        {    // H-20e135a.wav
            {1,2,1,-1,0,1,1,-1,-1,-1,-1,-2,-2,0,2,0,-1,-1,0,-1,-2,0,4,3,-1,0,5,5,-3,-7,4,16,7,-13,-14,10,22,-2,-28,-8,35,30,-21,-29,36,60,-11,89,803,2137,3244,2924,750,-2297,-4472,-4649,-3110,-1059,485,1286,1632,1779,1765,1615,1518,1758,2511,3715,5036,5928,5863,4669,2735,803,-521,-1108,-1210,-1117,-952,-768,-691,-866,-1284,-1743,-2032,-2119,-2138,-2198,-2270,-2257,-2112,-1871,-1574,-1219,-811,-405,-82,121,230,294,363,499,760,1126,1460,1597,1504,1306,1155,1066,947,756,585,558,670,783,761,582,322,56,-175,-343,-433,-478,-556,-728,-972,-1199,-1341,-1386,-1353,-1254,-1103,-938,-813,-742,-684,-588,-444,-296,-188,-122,-58,38,167,299,396,438,431,396,351,313,289,281,273,240,162,47,-75,-169,-224,-250,-273,-310,-364,-429,-489,-530,-549,-552,-548,-532,-496,-442,-390,-362,-361,-365,-352,-312,-251,-183,-121,-74,-49,-47,-54,-59,-51,-32,-6,22,44,50,39,15,-14,-42,-70,-94,-109,-111,-110,-114,-127,-142,-153,-164,-175,-185,-187,-176,-157,-136,-117,-102,-90,-81,-77,-81,-95,-119,-146,-170,-186,-190,-184,-174,-164,-159,-156,-146,-125,-97,-68,-39,-6,31,64,88,104,110,103,74,22,-49,-126,-202,-267,-309,-320,-303,-268,-229,-197,-176,-167,-163,-160,-157,-159,-168,-174,-167,-146,-115,-83,-54,-32,-28,-39,-51,-51,-45,-53,-76,-89,-69,-26},
            {-60,-58,44,91,-29,-154,-53,164,138,-154,-242,103,320,-103,-228,1950,6785,10917,9277,197,-11636,-18276,-15242,-5342,4069,7408,4692,116,-2098,-441,4103,9654,14464,17043,16220,11711,4763,-1924,-5386,-4144,695,6024,8786,7960,4843,1512,-1012,-3146,-5564,-7924,-9004,-8035,-5705,-3670,-3081,-3705,-4492,-4796,-4863,-5204,-5769,-5961,-5339,-4115,-2886,-2014,-1370,-587,533,1835,2871,3178,2638,1696,1124,1430,2444,3528,4146,4169,3686,2734,1386,-7,-889,-941,-398,145,209,-274,-1055,-1810,-2320,-2524,-2507,-2413,-2315,-2174,-1946,-1689,-1509,-1419,-1306,-1070,-759,-498,-339,-209,-30,190,384,522,632,750,870,954,955,852,671,495,417,458,531,516,366,146,-45,-158,-220,-281,-365,-465,-562,-647,-715,-762,-779,-758,-711,-677,-690,-739,-752,-651,-423,-142,90,211,232,204,176,180,228,312,399,442,410,314,194,93,28,-2,-14,-24,-50,-95,-149,-198,-240,-287,-341,-380,-381,-347,-308,-298,-320,-357,-393,-419,-430,-417,-376,-313,-242,-174,-124,-107,-122,-141,-134,-97,-55,-33,-25,-10,18,46,71,106,158,201,199,139,50,-26,-66,-79,-87,-105,-136,-171,-197,-205,-196,-180,-167,-162,-165,-168,-160,-132,-93,-61,-47,-40,-26,-4,14,25,46,95,158,203,206,172,120,60,-14,-104,-193,-262,-296,-291,-251,-184,-113,-63,-49,-74,-123,-181,-226,-245,-233,-203,-170,-137,-99,-54,-22,-21,-47,-79,-108,-160,-267,-420,-548,-582,-513,-406,-334,-309,-286,-222,-128,-47,-7}
        },
        {    // H-20e140a.wav
            {2,0,0,2,1,-1,-1,0,1,-1,-3,-1,2,3,1,0,1,-1,-3,-2,5,7,2,-2,2,8,2,-8,-4,12,14,-6,-18,3,27,12,-28,-27,24,46,-4,-44,14,88,29,-17,466,1794,3368,3786,2028,-1383,-4543,-5652,-4410,-2012,79,1230,1682,1876,1966,1923,1847,2029,2734,3972,5409,6454,6507,5322,3251,1079,-488,-1242,-1429,-1370,-1194,-933,-736,-833,-1291,-1880,-2279,-2387,-2376,-2445,-2585,-2622,-2445,-2118,-1772,-1441,-1072,-657,-284,-48,63,146,283,498,793,1162,1541,1792,1799,1586,1294,1044,857,710,633,661,734,695,455,108,-149,-218,-174,-155,-208,-288,-359,-444,-580,-752,-907,-1015,-1081,-1114,-1100,-1026,-904,-769,-648,-546,-455,-360,-251,-125,5,111,170,187,186,198,235,285,326,336,315,273,222,163,94,20,-46,-97,-139,-183,-234,-286,-335,-375,-409,-434,-450,-454,-445,-422,-395,-383,-394,-419,-430,-408,-356,-294,-239,-196,-167,-158,-163,-168,-153,-110,-56,-8,23,42,50,42,12,-30,-67,-85,-83,-74,-68,-68,-76,-92,-114,-134,-144,-142,-137,-134,-133,-130,-123,-118,-121,-129,-137,-142,-145,-148,-151,-153,-154,-155,-155,-156,-159,-162,-160,-150,-137,-123,-106,-81,-50,-21,1,20,41,64,83,94,97,94,76,37,-25,-100,-178,-249,-303,-329,-327,-304,-272,-240,-215,-199,-189,-180,-167,-157,-158,-165,-163,-140,-103,-70,-48,-30,-12,-2,-8,-20,-24,-22,-30,-53,-70,-58,-23},
            {51,-33,-92,-20,93,62,-93,-127,52,176,6,-221,-89,246,148,-263,549,3969,8627,10190,5053,-5341,-14496,-16060,-9398,4,5566,4963,979,-1945,-1401,2172,7039,11663,14896,15645,13141,7793,1597,-2625,-2879,628,5457,8473,7941,4575,670,-1926,-3155,-4233,-5944,-7631,-7943,-6446,-4263,-3031,-3360,-4469,-5237,-5350,-5298,-5471,-5608,-5201,-4194,-3064,-2263,-1759,-1166,-193,1095,2338,3083,3042,2339,1563,1400,2077,3160,3967,4127,3716,2942,1900,708,-299,-720,-486,6,208,-140,-880,-1665,-2235,-2521,-2584,-2519,-2389,-2207,-1976,-1740,-1569,-1477,-1380,-1178,-865,-542,-301,-132,35,240,458,637,751,800,799,776,754,727,672,592,535,542,574,532,359,106,-109,-215,-238,-251,-302,-394,-502,-606,-691,-747,-765,-750,-716,-688,-689,-720,-736,-668,-478,-202,65,241,311,312,294,285,292,317,353,376,355,277,164,54,-27,-73,-95,-102,-109,-129,-166,-214,-256,-288,-315,-336,-343,-328,-304,-297,-319,-361,-400,-422,-427,-416,-384,-328,-252,-173,-111,-83,-88,-106,-108,-81,-38,-2,20,33,42,44,39,43,72,112,130,103,44,-13,-48,-61,-66,-75,-96,-129,-165,-187,-184,-161,-139,-132,-141,-151,-148,-129,-99,-71,-53,-43,-30,-5,29,61,91,124,161,189,188,155,99,31,-44,-126,-205,-264,-289,-278,-237,-183,-131,-95,-77,-82,-112,-161,-213,-242,-235,-203,-168,-141,-113,-84,-69,-82,-112,-129,-128,-150,-241,-392,-524,-563,-503,-408,-345,-318,-283,-207,-106,-26}
        },
        {    // H-20e145a.wav
            {-1,2,3,0,-4,-3,0,0,-3,-4,-1,1,-1,-2,-1,0,-3,-4,2,7,4,-3,-1,8,6,-9,-12,6,21,5,-21,-13,22,28,-14,-40,1,50,20,-48,-23,84,83,-31,215,1391,3247,4393,3288,-180,-4217,-6439,-5786,-3193,-496,1132,1731,1914,2049,2126,2143,2353,3087,4409,5960,7085,7146,5895,3686,1322,-433,-1314,-1571,-1574,-1469,-1232,-952,-912,-1312,-1993,-2542,-2689,-2554,-2466,-2589,-2782,-2813,-2606,-2257,-1853,-1385,-846,-337,0,128,151,194,321,565,963,1482,1944,2112,1909,1511,1179,1008,904,761,603,516,496,438,260,-6,-273,-487,-640,-721,-712,-634,-558,-543,-589,-651,-700,-730,-726,-676,-602,-568,-614,-690,-683,-520,-243,24,176,190,125,57,36,69,137,214,277,305,285,222,140,70,25,-9,-52,-110,-168,-210,-230,-235,-241,-262,-306,-359,-396,-397,-375,-358,-363,-380,-388,-385,-379,-371,-346,-295,-236,-198,-191,-199,-200,-184,-159,-128,-91,-51,-17,-1,-5,-24,-55,-92,-125,-139,-129,-101,-73,-55,-54,-69,-94,-118,-132,-131,-121,-109,-100,-95,-96,-106,-126,-149,-166,-175,-180,-184,-182,-170,-151,-134,-127,-130,-134,-133,-128,-122,-114,-103,-90,-79,-71,-61,-45,-21,5,29,51,69,80,80,69,49,22,-13,-56,-104,-156,-211,-267,-311,-332,-329,-310,-289,-269,-250,-229,-207,-184,-159,-139,-127,-117,-98,-68,-40,-26,-22,-13,4,13,5,-7,-8,-10,-36,-85,-117,-97,-37},
            {-14,46,37,-47,-77,11,87,10,-117,-74,107,130,-88,-204,34,248,-19,-129,1540,5474,9137,8292,1213,-8543,-14395,-12424,-4854,2208,4301,1896,-1213,-1837,481,4368,8461,11978,14117,13833,10638,5537,879,-999,668,4464,7638,7900,4985,734,-2457,-3594,-3654,-4258,-5831,-7188,-6956,-5202,-3449,-3104,-4120,-5299,-5706,-5484,-5298,-5338,-5159,-4384,-3246,-2302,-1785,-1419,-798,213,1422,2473,3009,2855,2238,1756,1942,2764,3634,3966,3653,2973,2164,1266,360,-269,-374,-91,106,-165,-861,-1630,-2160,-2394,-2440,-2415,-2364,-2281,-2145,-1946,-1715,-1505,-1340,-1170,-929,-609,-283,-26,156,315,494,679,818,874,855,807,768,735,671,562,452,413,450,479,398,189,-63,-257,-357,-394,-408,-418,-435,-476,-556,-662,-760,-817,-819,-771,-697,-626,-566,-490,-354,-149,79,254,332,332,301,278,268,263,259,251,226,175,102,24,-43,-93,-130,-151,-156,-154,-157,-174,-199,-231,-271,-319,-362,-379,-368,-351,-353,-374,-390,-387,-371,-355,-341,-315,-266,-200,-134,-84,-55,-42,-35,-28,-19,-15,-17,-21,-20,-15,-8,3,27,60,86,86,54,7,-33,-55,-59,-54,-55,-76,-116,-158,-178,-168,-143,-124,-124,-133,-137,-128,-105,-75,-46,-23,-6,13,38,67,94,118,143,163,162,127,61,-20,-102,-180,-245,-286,-290,-259,-212,-168,-134,-111,-100,-107,-134,-174,-210,-226,-218,-192,-162,-139,-124,-120,-129,-154,-180,-183,-158,-145,-203,-340,-486,-546,-495,-400,-342,-327,-291,-191,-63}
        },
        {    // H-20e150a.wav
            {2,0,-2,-2,0,0,-4,-6,-1,2,0,-4,-3,0,-3,-7,-3,5,6,-2,-4,5,9,-5,-17,-4,17,12,-17,-23,11,32,-2,-45,-19,46,41,-42,-60,53,123,10,70,1011,2957,4710,4390,1190,-3483,-6883,-7127,-4607,-1332,929,1807,1968,2061,2217,2365,2666,3477,4932,6655,7883,7897,6467,4038,1493,-380,-1331,-1647,-1727,-1706,-1509,-1186,-1055,-1420,-2193,-2898,-3113,-2864,-2556,-2526,-2741,-2916,-2855,-2592,-2241,-1816,-1269,-646,-109,202,294,289,325,505,885,1416,1900,2105,1968,1664,1410,1242,1041,770,580,608,748,721,378,-129,-529,-712,-786,-881,-993,-1041,-1004,-943,-902,-862,-782,-673,-577,-510,-448,-364,-260,-158,-72,-11,23,36,50,89,158,234,288,305,295,276,255,221,160,76,-6,-56,-75,-93,-142,-221,-302,-350,-358,-335,-302,-273,-262,-275,-309,-352,-391,-420,-433,-423,-387,-338,-297,-275,-262,-244,-216,-181,-147,-114,-83,-61,-55,-57,-55,-44,-37,-49,-83,-122,-153,-173,-183,-181,-164,-137,-117,-113,-118,-118,-111,-106,-107,-109,-105,-101,-104,-114,-125,-134,-148,-174,-205,-225,-222,-196,-156,-117,-93,-87,-95,-107,-115,-116,-107,-85,-57,-38,-39,-52,-61,-59,-49,-36,-20,2,24,37,41,43,44,34,6,-32,-67,-99,-132,-170,-210,-250,-288,-322,-340,-338,-321,-299,-271,-235,-200,-176,-163,-146,-116,-78,-44,-15,11,27,25,8,-2,-1,-2,-17,-32,-33,-39,-84,-159,-203,-161,-60},
            {-13,-29,8,45,10,-62,-51,44,74,-33,-118,-18,134,73,-147,-155,122,205,-113,149,2417,6338,8787,6207,-1462,-9647,-12736,-9105,-2424,2033,2091,-246,-1652,-619,2137,5387,8595,11477,13156,12475,9242,4918,1835,1548,3720,6357,7199,5269,1507,-2002,-3678,-3637,-3361,-4128,-5727,-6763,-6220,-4593,-3392,-3589,-4744,-5670,-5740,-5327,-5058,-4981,-4626,-3742,-2646,-1821,-1355,-928,-231,731,1724,2473,2777,2607,2223,2094,2508,3247,3749,3640,3037,2295,1589,877,191,-247,-289,-129,-174,-641,-1361,-1990,-2334,-2435,-2422,-2368,-2278,-2142,-1966,-1769,-1578,-1402,-1214,-956,-610,-235,70,261,379,498,654,819,935,963,916,843,789,748,672,538,392,298,257,200,68,-115,-269,-349,-380,-412,-459,-510,-563,-625,-694,-741,-742,-696,-624,-546,-477,-423,-372,-288,-141,54,226,303,277,205,158,161,190,213,212,189,142,74,-3,-65,-94,-95,-90,-97,-121,-157,-201,-247,-290,-324,-353,-376,-385,-375,-350,-334,-341,-360,-371,-363,-342,-315,-277,-222,-156,-95,-53,-33,-34,-49,-64,-66,-55,-42,-39,-39,-32,-18,-8,0,17,48,72,69,38,0,-24,-31,-31,-35,-49,-83,-130,-168,-175,-149,-115,-94,-90,-94,-96,-92,-76,-51,-24,-5,12,39,76,106,116,112,107,96,61,-3,-79,-148,-204,-247,-266,-250,-210,-170,-147,-138,-137,-141,-151,-161,-168,-175,-187,-193,-183,-163,-156,-167,-177,-179,-190,-215,-220,-175,-120,-144,-280,-445,-517,-472,-394,-354,-321,-228,-82}
        },
        {    // H-20e155a.wav
            {-1,-3,0,1,-2,-5,-3,2,2,-2,-3,-1,-2,-6,-4,3,6,-1,-4,4,12,1,-16,-11,14,18,-10,-28,-1,33,12,-40,-35,34,58,-18,-75,10,122,59,35,760,2637,4771,5180,2480,-2487,-6921,-8234,-6092,-2394,574,1881,2075,2068,2239,2512,2937,3856,5482,7441,8827,8778,7081,4339,1583,-372,-1346,-1698,-1844,-1898,-1744,-1398,-1196,-1520,-2367,-3258,-3638,-3382,-2875,-2597,-2687,-2900,-2947,-2763,-2456,-2081,-1587,-962,-340,93,276,312,362,544,911,1437,1969,2262,2155,1730,1267,1002,960,1017,1068,1069,969,694,242,-257,-641,-855,-965,-1044,-1099,-1104,-1079,-1075,-1112,-1167,-1207,-1200,-1096,-844,-460,-68,186,258,228,214,259,333,395,432,448,445,427,409,396,374,321,234,135,46,-20,-68,-111,-167,-246,-341,-422,-459,-447,-408,-370,-353,-364,-395,-429,-443,-434,-416,-402,-393,-374,-345,-317,-295,-268,-219,-147,-71,-8,36,62,66,44,6,-30,-49,-52,-54,-69,-102,-147,-194,-228,-239,-228,-206,-182,-161,-144,-136,-140,-151,-160,-159,-150,-142,-145,-155,-168,-180,-196,-215,-227,-218,-187,-142,-101,-71,-53,-48,-55,-70,-80,-76,-61,-40,-21,-5,1,-7,-26,-43,-46,-38,-26,-17,-9,1,9,9,1,-12,-30,-52,-76,-95,-112,-137,-175,-221,-264,-299,-325,-340,-338,-320,-295,-266,-231,-190,-156,-134,-115,-83,-37,3,25,37,46,48,32,5,-12,-17,-31,-62,-94,-107,-121,-167,-235,-259,-191,-69},
            {23,9,-27,-27,24,49,-7,-70,-32,62,56,-63,-107,25,139,21,-171,-93,178,148,-145,450,3035,6631,8008,4496,-2816,-9282,-10663,-6920,-1876,686,223,-1052,-1016,596,2906,5401,8157,10890,12471,11777,8924,5501,3462,3675,5281,6346,5319,2236,-1294,-3398,-3503,-2741,-2776,-4171,-5910,-6535,-5657,-4286,-3714,-4257,-5156,-5565,-5383,-5078,-4923,-4674,-4002,-2992,-2060,-1457,-1033,-490,281,1157,1948,2490,2670,2526,2334,2435,2880,3326,3374,2976,2411,1888,1348,693,61,-287,-329,-361,-678,-1243,-1777,-2081,-2199,-2266,-2328,-2336,-2256,-2096,-1869,-1590,-1304,-1063,-863,-633,-329,-3,247,397,511,660,835,972,1027,1008,952,884,805,705,580,446,334,254,172,40,-150,-341,-467,-512,-515,-516,-529,-552,-592,-652,-708,-719,-667,-563,-442,-332,-257,-232,-240,-232,-159,-23,114,191,208,208,222,237,229,195,157,128,100,59,12,-30,-65,-102,-143,-182,-217,-251,-286,-310,-317,-322,-344,-381,-404,-395,-368,-348,-344,-337,-313,-280,-255,-238,-213,-169,-116,-69,-38,-24,-25,-36,-52,-64,-73,-79,-77,-62,-38,-15,0,13,33,57,72,66,44,15,-9,-21,-23,-24,-40,-78,-122,-148,-143,-117,-93,-81,-82,-86,-86,-78,-61,-41,-18,6,33,58,74,79,78,70,49,10,-45,-107,-164,-210,-236,-236,-211,-172,-137,-118,-121,-142,-171,-191,-192,-181,-170,-165,-159,-155,-165,-189,-208,-209,-209,-229,-255,-240,-169,-100,-111,-218,-354,-445,-468,-433,-348,-215,-71}
        },
        {    // H-20e160a.wav
            {-3,-1,-2,-5,-4,0,2,-1,-2,-1,-3,-7,-6,2,6,1,-5,1,9,2,-14,-14,8,19,-3,-25,-8,26,15,-34,-42,19,59,2,-68,-14,98,73,37,640,2408,4703,5628,3479,-1439,-6559,-8913,-7448,-3654,-46,1859,2245,2134,2225,2593,3193,4250,6006,8157,9740,9720,7800,4708,1691,-346,-1318,-1718,-1987,-2151,-2010,-1588,-1292,-1584,-2502,-3547,-4094,-3916,-3344,-2907,-2853,-3007,-3057,-2875,-2551,-2179,-1724,-1131,-485,10,226,235,256,484,963,1572,2074,2258,2091,1758,1501,1401,1336,1174,952,806,761,663,360,-112,-566,-867,-1029,-1135,-1215,-1253,-1257,-1278,-1336,-1390,-1383,-1292,-1127,-898,-622,-347,-133,6,123,276,472,665,808,889,910,867,755,595,432,314,261,253,247,200,102,-19,-123,-195,-255,-331,-422,-499,-538,-540,-527,-515,-508,-506,-509,-521,-537,-546,-531,-481,-401,-317,-259,-238,-232,-202,-127,-23,76,142,165,149,108,61,27,12,6,-6,-33,-70,-112,-157,-199,-225,-229,-218,-210,-212,-219,-220,-220,-228,-242,-253,-252,-244,-239,-236,-232,-223,-214,-209,-203,-187,-157,-114,-64,-20,4,5,-9,-24,-28,-24,-16,-4,9,18,19,13,6,-3,-14,-29,-40,-42,-36,-30,-29,-36,-51,-73,-97,-110,-108,-97,-89,-93,-117,-160,-217,-273,-315,-339,-349,-344,-318,-273,-222,-182,-156,-138,-120,-97,-66,-24,22,54,64,61,54,40,12,-23,-49,-68,-100,-150,-193,-204,-199,-221,-268,-279,-203,-73},
            {-14,8,28,6,-33,-23,30,41,-22,-67,-11,68,32,-82,-85,58,123,-31,-176,-33,202,85,-143,701,3369,6526,7167,3421,-3093,-8240,-9006,-6024,-2463,-754,-776,-924,-194,1222,2919,5047,7813,10613,12148,11538,9193,6552,4988,4852,5312,5013,3118,39,-2740,-3819,-3117,-2022,-2151,-3843,-5863,-6654,-5843,-4478,-3859,-4302,-5093,-5453,-5291,-4981,-4690,-4189,-3298,-2250,-1460,-1048,-737,-209,579,1442,2172,2624,2723,2550,2384,2500,2861,3103,2928,2418,1896,1509,1113,573,12,-344,-497,-693,-1109,-1632,-2010,-2145,-2143,-2142,-2166,-2162,-2093,-1945,-1707,-1392,-1069,-802,-583,-340,-49,222,395,485,582,746,940,1073,1093,1016,898,789,702,615,504,379,274,206,141,27,-146,-331,-478,-581,-654,-697,-694,-652,-610,-602,-618,-622,-591,-530,-454,-378,-320,-290,-271,-224,-122,12,124,186,217,250,290,310,292,242,181,120,61,9,-31,-60,-87,-119,-156,-200,-252,-311,-361,-386,-385,-380,-388,-403,-406,-388,-362,-343,-329,-307,-271,-235,-212,-196,-170,-127,-79,-45,-31,-31,-38,-49,-63,-76,-82,-81,-72,-56,-35,-12,11,35,59,77,79,64,42,26,22,22,17,-2,-39,-92,-143,-168,-156,-124,-99,-94,-101,-106,-103,-95,-81,-56,-21,16,46,66,75,67,39,-1,-46,-92,-141,-187,-212,-208,-184,-158,-139,-127,-124,-137,-165,-192,-202,-193,-176,-158,-143,-136,-151,-187,-224,-241,-239,-242,-257,-266,-244,-189,-129,-106,-149,-259,-391,-466,-420,-262,-82}
        },
        {    // H-20e165a.wav
            {-2,-5,-4,1,2,-1,-2,-1,-3,-7,-5,3,7,1,-6,0,10,5,-11,-13,7,17,-2,-23,-8,23,16,-29,-42,10,52,10,-52,-15,77,59,44,622,2318,4621,5792,4073,-568,-5930,-9043,-8394,-4917,-978,1550,2360,2302,2281,2650,3416,4673,6559,8800,10475,10498,8481,5171,1945,-186,-1178,-1644,-2077,-2416,-2345,-1858,-1443,-1663,-2605,-3760,-4445,-4364,-3791,-3264,-3104,-3221,-3303,-3148,-2775,-2297,-1757,-1150,-525,-17,259,314,291,381,728,1334,2022,2499,2557,2236,1781,1420,1202,1054,936,867,820,667,306,-190,-625,-871,-981,-1098,-1286,-1486,-1601,-1591,-1483,-1339,-1215,-1138,-1084,-990,-817,-590,-371,-189,-14,199,448,686,865,974,1022,1019,970,882,769,646,523,410,311,224,144,70,-2,-85,-194,-328,-465,-574,-630,-630,-594,-556,-552,-591,-652,-697,-705,-680,-632,-557,-452,-336,-244,-190,-156,-113,-55,-1,39,79,133,189,216,198,152,106,74,47,15,-21,-53,-84,-120,-161,-194,-213,-223,-241,-272,-307,-336,-356,-371,-377,-367,-337,-302,-276,-261,-249,-233,-213,-191,-165,-128,-80,-27,19,49,55,43,27,20,25,35,42,46,49,47,37,24,17,16,12,-6,-32,-55,-72,-84,-96,-106,-115,-126,-140,-147,-137,-114,-93,-90,-107,-142,-190,-242,-284,-306,-310,-301,-281,-246,-203,-167,-144,-124,-96,-64,-41,-23,3,38,65,70,60,46,23,-19,-74,-121,-154,-186,-225,-252,-248,-236,-252,-292,-292,-206,-72},
            {10,-7,-13,8,24,2,-28,-12,31,29,-30,-55,6,63,12,-82,-56,73,95,-60,-152,17,194,28,-113,863,3433,6180,6490,3017,-2637,-7078,-8047,-6089,-3450,-1766,-1048,-516,274,1336,2800,4971,7761,10370,11757,11433,9778,7703,6037,5066,4396,3265,1222,-1291,-3131,-3435,-2527,-1736,-2208,-3865,-5559,-6209,-5730,-4894,-4452,-4529,-4784,-4931,-4946,-4843,-4485,-3726,-2676,-1677,-995,-609,-302,116,716,1479,2276,2843,2937,2603,2225,2177,2453,2698,2613,2230,1760,1298,790,239,-215,-484,-675,-968,-1382,-1759,-1966,-2034,-2064,-2089,-2073,-2005,-1903,-1753,-1498,-1145,-791,-534,-359,-175,58,291,469,606,742,868,938,934,895,866,844,797,711,605,503,416,341,268,170,22,-174,-378,-540,-633,-662,-654,-638,-633,-647,-669,-683,-682,-667,-635,-580,-504,-430,-374,-323,-233,-82,97,240,310,321,310,299,280,250,220,203,189,157,98,24,-47,-109,-171,-237,-303,-359,-397,-413,-411,-400,-397,-407,-419,-416,-394,-362,-329,-296,-260,-230,-214,-205,-187,-154,-120,-98,-83,-64,-41,-29,-35,-45,-44,-34,-28,-29,-27,-13,11,36,61,84,100,98,78,51,28,12,3,-6,-26,-63,-110,-150,-168,-170,-166,-163,-154,-139,-125,-113,-92,-57,-14,20,37,43,40,23,-8,-44,-75,-105,-142,-180,-199,-193,-169,-146,-132,-128,-136,-155,-171,-174,-163,-151,-145,-142,-140,-150,-177,-211,-235,-245,-249,-253,-258,-264,-269,-249,-186,-110,-101,-205,-357,-416,-306,-106}
        },
        {    // H-20e170a.wav
            {-5,-1,1,-1,-1,0,-2,-7,-6,1,5,-1,-5,1,9,3,-12,-12,6,13,-7,-25,-9,20,11,-29,-36,12,40,-4,-50,0,80,39,30,649,2365,4642,5817,4248,-127,-5355,-8729,-8701,-5823,-2039,841,2184,2455,2471,2789,3633,5095,7159,9441,11055,11005,8943,5595,2326,154,-886,-1452,-2056,-2591,-2649,-2179,-1701,-1859,-2793,-3991,-4739,-4704,-4145,-3594,-3393,-3484,-3577,-3457,-3105,-2590,-1943,-1180,-413,140,317,186,47,223,833,1690,2430,2746,2590,2165,1740,1454,1276,1133,1012,933,853,666,309,-164,-631,-1010,-1286,-1468,-1547,-1525,-1448,-1380,-1358,-1378,-1412,-1419,-1337,-1120,-786,-434,-166,-11,81,167,266,375,508,685,884,1038,1087,1032,927,832,765,705,617,483,318,156,27,-71,-162,-274,-408,-543,-648,-707,-722,-710,-697,-700,-722,-744,-752,-737,-698,-626,-522,-405,-310,-250,-207,-144,-48,57,143,195,221,227,211,183,159,154,160,157,133,88,30,-36,-107,-170,-215,-242,-267,-302,-344,-383,-414,-437,-452,-453,-436,-405,-370,-337,-306,-275,-244,-213,-184,-154,-119,-73,-19,36,77,93,85,65,49,42,46,57,70,77,73,59,45,38,32,21,0,-29,-59,-84,-106,-124,-140,-155,-172,-188,-198,-191,-163,-125,-94,-86,-101,-132,-170,-208,-240,-259,-259,-245,-228,-214,-199,-176,-148,-120,-98,-80,-62,-41,-14,16,44,58,51,26,-13,-60,-113,-160,-194,-217,-240,-264,-279,-281,-283,-299,-307,-269,-171,-55},
            {-8,6,9,-5,-10,7,18,-1,-24,-8,26,19,-29,-42,11,49,-3,-72,-36,67,65,-69,-118,42,163,-5,-65,929,3297,5751,6067,3104,-1890,-6167,-7711,-6591,-4332,-2348,-1078,-250,524,1543,3047,5128,7551,9777,11223,11505,10553,8665,6459,4549,3095,1712,-7,-1846,-3006,-2935,-2072,-1599,-2371,-4093,-5617,-6024,-5398,-4584,-4308,-4596,-4961,-4998,-4696,-4253,-3754,-3120,-2314,-1461,-746,-244,120,477,932,1519,2153,2635,2789,2635,2399,2281,2256,2153,1912,1658,1500,1331,943,299,-387,-874,-1127,-1285,-1461,-1642,-1774,-1851,-1905,-1938,-1928,-1871,-1770,-1599,-1323,-963,-604,-324,-125,37,181,290,371,469,623,808,956,1017,990,909,813,737,695,665,604,489,336,179,35,-103,-233,-340,-415,-468,-512,-544,-562,-584,-641,-740,-849,-917,-915,-845,-726,-584,-450,-346,-268,-186,-79,46,167,267,346,403,426,409,362,306,254,204,149,89,23,-52,-139,-227,-301,-355,-387,-402,-400,-389,-383,-391,-410,-424,-424,-409,-385,-351,-308,-265,-236,-225,-223,-217,-198,-166,-123,-73,-22,17,37,37,27,18,14,14,16,24,38,55,70,76,76,74,71,59,37,11,-8,-20,-36,-61,-97,-134,-167,-190,-200,-196,-182,-165,-145,-120,-89,-58,-30,-5,13,18,6,-18,-42,-66,-94,-127,-158,-176,-182,-182,-173,-152,-132,-128,-140,-147,-133,-108,-95,-98,-107,-117,-140,-176,-204,-212,-214,-230,-250,-255,-255,-281,-325,-322,-232,-118,-98,-194,-288,-251,-99}
        },
        {    // H-20e175a.wav
            {1,-1,0,2,-1,-7,-6,2,5,-1,-5,3,12,3,-12,-9,10,12,-12,-26,-3,24,7,-35,-32,21,39,-19,-58,12,92,26,18,707,2510,4774,5813,4136,-132,-5064,-8244,-8415,-6092,-2845,-97,1563,2315,2661,3093,3981,5543,7728,10031,11532,11327,9191,5887,2716,602,-471,-1153,-1914,-2597,-2766,-2378,-1975,-2202,-3166,-4329,-5002,-4921,-4380,-3877,-3696,-3771,-3859,-3766,-3423,-2857,-2139,-1374,-677,-132,233,435,539,679,1013,1584,2220,2627,2637,2346,1987,1696,1451,1215,1037,968,915,689,204,-405,-911,-1194,-1300,-1331,-1357,-1411,-1515,-1649,-1736,-1704,-1560,-1371,-1177,-947,-660,-369,-166,-76,-24,79,249,431,577,682,769,843,889,899,883,855,821,778,721,644,547,430,293,132,-53,-247,-429,-578,-686,-749,-769,-761,-752,-760,-783,-800,-791,-760,-717,-669,-607,-527,-434,-336,-232,-118,-1,105,182,233,266,290,305,305,290,264,231,195,153,98,31,-43,-117,-186,-249,-307,-352,-379,-391,-401,-422,-452,-477,-485,-475,-453,-423,-380,-327,-274,-233,-206,-180,-147,-107,-66,-22,28,80,118,127,110,82,57,44,42,53,72,87,89,75,54,40,31,19,-5,-41,-79,-109,-129,-144,-159,-178,-198,-212,-216,-204,-175,-132,-89,-64,-67,-93,-128,-159,-183,-198,-203,-200,-194,-192,-194,-189,-168,-134,-101,-78,-61,-43,-19,5,20,22,11,-13,-50,-97,-145,-182,-203,-216,-233,-258,-287,-311,-328,-333,-315,-262,-178,-87,-21},
            {-1,-7,-4,6,6,-5,-6,8,14,-3,-19,-4,23,15,-24,-33,9,36,-4,-56,-27,50,46,-53,-83,43,127,-10,-14,913,3059,5359,5872,3416,-1184,-5587,-7720,-7165,-5029,-2740,-1050,82,1029,2091,3402,5007,6906,8969,10794,11722,11172,9136,6339,3771,1940,616,-663,-1916,-2666,-2580,-2018,-1830,-2579,-4011,-5296,-5750,-5348,-4616,-4130,-4111,-4391,-4645,-4627,-4249,-3557,-2677,-1768,-971,-367,45,326,578,921,1420,1994,2438,2589,2498,2375,2352,2328,2112,1676,1216,926,786,612,279,-174,-634,-1040,-1378,-1622,-1737,-1746,-1728,-1739,-1764,-1760,-1710,-1611,-1433,-1146,-784,-454,-237,-125,-38,82,238,404,565,712,834,922,975,991,957,867,745,628,534,450,371,309,270,222,118,-53,-243,-387,-464,-506,-558,-637,-732,-823,-890,-924,-920,-879,-809,-720,-625,-536,-452,-363,-252,-111,45,189,301,375,416,431,423,394,350,295,231,161,89,16,-55,-125,-194,-258,-310,-348,-374,-391,-399,-402,-410,-430,-456,-467,-450,-413,-372,-339,-312,-286,-262,-241,-216,-181,-134,-83,-32,17,57,82,92,94,89,74,49,29,28,46,64,68,64,58,53,43,33,27,22,3,-37,-84,-120,-145,-167,-188,-200,-198,-188,-177,-162,-135,-99,-67,-45,-32,-27,-34,-49,-63,-74,-89,-116,-149,-175,-189,-193,-186,-167,-141,-125,-124,-122,-102,-67,-40,-32,-37,-55,-95,-154,-202,-214,-204,-205,-227,-247,-256,-277,-327,-367,-339,-244,-156,-132,-144,-123,-51}
        },
        {    // H-20e180a.wav
            {-2,2,0,-6,-4,3,5,-2,-5,5,11,0,-14,-6,14,12,-17,-28,2,29,2,-45,-31,32,42,-32,-68,23,105,13,5,782,2712,4991,5838,3889,-457,-5127,-7881,-7845,-5773,-3103,-865,681,1733,2563,3400,4504,6127,8276,10471,11809,11469,9333,6185,3211,1166,-30,-923,-1823,-2513,-2646,-2305,-2075,-2520,-3629,-4795,-5350,-5127,-4525,-4081,-4000,-4098,-4105,-3945,-3692,-3351,-2781,-1885,-813,94,573,648,584,677,1065,1666,2255,2608,2644,2458,2213,1988,1755,1485,1214,980,735,382,-79,-510,-772,-880,-987,-1213,-1526,-1798,-1932,-1921,-1817,-1670,-1511,-1349,-1168,-945,-686,-437,-251,-133,-40,76,228,406,597,786,940,1012,977,857,717,630,624,667,694,659,571,470,376,268,119,-74,-281,-474,-638,-756,-811,-799,-759,-741,-768,-821,-862,-869,-836,-758,-637,-501,-393,-328,-274,-182,-39,121,254,344,400,426,414,366,308,266,245,223,178,107,20,-74,-168,-255,-323,-362,-379,-387,-396,-411,-432,-456,-477,-486,-478,-453,-417,-376,-331,-286,-245,-212,-185,-157,-118,-66,-4,57,102,125,127,113,92,69,51,44,50,61,68,67,63,60,58,53,40,17,-13,-49,-86,-116,-141,-163,-185,-202,-209,-205,-194,-176,-150,-116,-83,-59,-50,-54,-69,-91,-117,-137,-149,-157,-167,-182,-193,-191,-176,-153,-129,-107,-83,-57,-33,-15,-5,-3,-14,-44,-90,-139,-176,-194,-203,-212,-229,-251,-282,-318,-350,-357,-324,-257,-176,-104,-49,-14},
            {-2,2,0,-6,-4,3,5,-2,-5,5,11,0,-14,-6,14,12,-17,-28,2,29,2,-45,-31,32,42,-32,-68,23,105,13,5,782,2712,4991,5838,3889,-457,-5127,-7881,-7845,-5773,-3103,-865,681,1733,2563,3400,4504,6127,8276,10471,11809,11469,9333,6185,3211,1166,-30,-923,-1823,-2513,-2646,-2305,-2075,-2520,-3629,-4795,-5350,-5127,-4525,-4081,-4000,-4098,-4105,-3945,-3692,-3351,-2781,-1885,-813,94,573,648,584,677,1065,1666,2255,2608,2644,2458,2213,1988,1755,1485,1214,980,735,382,-79,-510,-772,-880,-987,-1213,-1526,-1798,-1932,-1921,-1817,-1670,-1511,-1349,-1168,-945,-686,-437,-251,-133,-40,76,228,406,597,786,940,1012,977,857,717,630,624,667,694,659,571,470,376,268,119,-74,-281,-474,-638,-756,-811,-799,-759,-741,-768,-821,-862,-869,-836,-758,-637,-501,-393,-328,-274,-182,-39,121,254,344,400,426,414,366,308,266,245,223,178,107,20,-74,-168,-255,-323,-362,-379,-387,-396,-411,-432,-456,-477,-486,-478,-453,-417,-376,-331,-286,-245,-212,-185,-157,-118,-66,-4,57,102,125,127,113,92,69,51,44,50,61,68,67,63,60,58,53,40,17,-13,-49,-86,-116,-141,-163,-185,-202,-209,-205,-194,-176,-150,-116,-83,-59,-50,-54,-69,-91,-117,-137,-149,-157,-167,-182,-193,-191,-176,-153,-129,-107,-83,-57,-33,-15,-5,-3,-14,-44,-90,-139,-176,-194,-203,-212,-229,-251,-282,-318,-350,-357,-324,-257,-176,-104,-49,-14}
        }
    },
    {    // elev-30 
        {    // H-30e000a.wav
            {-8,-7,4,10,1,-11,-5,14,15,-8,-21,0,23,5,-37,-37,15,45,-2,-63,-35,47,47,-51,-80,35,90,-10,319,2025,5004,7130,5557,-289,-7159,-10265,-7715,-2490,459,-836,-3621,-3620,503,6177,9907,10407,8742,6430,4396,3565,5117,9126,13205,13657,8726,664,-5840,-7539,-5128,-2223,-2112,-5216,-9098,-10564,-8147,-3210,1040,1956,-591,-4289,-6383,-5752,-3307,-747,845,1346,1091,439,-234,-492,-92,730,1357,1279,532,-305,-548,63,1118,1793,1471,249,-1120,-1819,-1569,-739,48,364,143,-421,-1029,-1412,-1434,-1163,-814,-597,-584,-691,-748,-613,-263,150,385,303,4,-243,-234,20,355,620,759,776,690,536,372,240,146,83,58,60,27,-109,-327,-505,-542,-471,-422,-478,-600,-683,-664,-553,-398,-255,-181,-202,-280,-326,-275,-143,-11,56,47,5,-20,2,67,137,161,123,53,-3,-28,-43,-66,-96,-122,-144,-166,-180,-175,-153,-130,-112,-90,-61,-48,-75,-134,-179,-177,-137,-95,-74,-68,-62,-53,-44,-34,-21,-16,-35,-82,-133,-156,-143,-118,-112,-137,-173,-185,-143,-60,10,-3,-134,-344,-536,-631,-623,-571,-524,-466,-340,-120,146,368,483,489,432,367,319,268,179,34,-139,-286,-380,-438,-498,-581,-681,-778,-847,-839,-703,-436,-115,143,272,293,272,258,256,249,222,174,115,65,37,20,-2,-32,-45,-22,27,78,117,144,148,111,43,-22,-63,-105,-171,-239,-262,-244,-242,-285,-330,-326,-310,-360,-467,-506,-374,-134},
            {-8,-7,4,10,1,-11,-5,14,15,-8,-21,0,23,5,-37,-37,15,45,-2,-63,-35,47,47,-51,-80,35,90,-10,319,2025,5004,7130,5557,-289,-7159,-10265,-7715,-2490,459,-836,-3621,-3620,503,6177,9907,10407,8742,6430,4396,3565,5117,9126,13205,13657,8726,664,-5840,-7539,-5128,-2223,-2112,-5216,-9098,-10564,-8147,-3210,1040,1956,-591,-4289,-6383,-5752,-3307,-747,845,1346,1091,439,-234,-492,-92,730,1357,1279,532,-305,-548,63,1118,1793,1471,249,-1120,-1819,-1569,-739,48,364,143,-421,-1029,-1412,-1434,-1163,-814,-597,-584,-691,-748,-613,-263,150,385,303,4,-243,-234,20,355,620,759,776,690,536,372,240,146,83,58,60,27,-109,-327,-505,-542,-471,-422,-478,-600,-683,-664,-553,-398,-255,-181,-202,-280,-326,-275,-143,-11,56,47,5,-20,2,67,137,161,123,53,-3,-28,-43,-66,-96,-122,-144,-166,-180,-175,-153,-130,-112,-90,-61,-48,-75,-134,-179,-177,-137,-95,-74,-68,-62,-53,-44,-34,-21,-16,-35,-82,-133,-156,-143,-118,-112,-137,-173,-185,-143,-60,10,-3,-134,-344,-536,-631,-623,-571,-524,-466,-340,-120,146,368,483,489,432,367,319,268,179,34,-139,-286,-380,-438,-498,-581,-681,-778,-847,-839,-703,-436,-115,143,272,293,272,258,256,249,222,174,115,65,37,20,-2,-32,-45,-22,27,78,117,144,148,111,43,-22,-63,-105,-171,-239,-262,-244,-242,-285,-330,-326,-310,-360,-467,-506,-374,-134}
        },
        {    // H-30e006a.wav
            {-2,-1,-4,-7,-4,5,8,-2,-9,-1,13,9,-9,-14,6,19,-3,-33,-23,20,30,-17,-52,-14,42,20,-51,-42,45,44,17,569,2332,4803,5980,3849,-1337,-6516,-8217,-5821,-2239,-1023,-2818,-4878,-4036,153,5282,8610,9245,8072,6377,5115,5092,6854,9819,11911,10842,6216,248,-3880,-4568,-2917,-1553,-2403,-5271,-8145,-8777,-6393,-2325,908,1461,-510,-3148,-4505,-3993,-2460,-1117,-519,-455,-510,-538,-618,-747,-715,-329,294,720,581,-7,-445,-184,711,1564,1695,1041,144,-393,-396,-113,137,197,57,-262,-702,-1118,-1324,-1227,-931,-691,-733,-1058,-1400,-1402,-930,-235,232,212,-128,-366,-216,245,697,879,769,536,371,339,365,325,178,15,-43,12,67,20,-99,-173,-157,-131,-194,-342,-473,-509,-459,-384,-324,-290,-287,-316,-356,-365,-329,-269,-221,-191,-167,-143,-120,-86,-26,46,84,48,-40,-107,-98,-21,63,93,50,-35,-100,-96,-30,44,69,43,7,-5,-3,-18,-51,-71,-59,-31,-23,-46,-87,-130,-170,-205,-230,-247,-272,-317,-368,-396,-380,-315,-205,-72,35,39,-97,-328,-541,-644,-631,-566,-507,-446,-325,-104,191,472,648,682,614,517,435,362,271,157,31,-96,-227,-361,-485,-596,-712,-850,-989,-1062,-999,-785,-486,-203,-19,53,57,49,59,80,106,138,182,229,264,281,290,291,272,233,197,192,212,224,199,139,60,-23,-96,-147,-182,-225,-291,-358,-386,-378,-374,-397,-417,-409,-414,-485,-587,-591,-414,-143},
            {2,10,3,-9,-5,15,19,-6,-24,-4,27,13,-37,-46,12,56,6,-71,-49,50,65,-48,-101,23,109,-5,271,2040,5351,7951,6542,165,-7762,-11742,-9244,-3323,347,-822,-3958,-4109,513,7071,11397,11831,9655,6833,4517,3615,5317,9776,14475,15234,9830,625,-6967,-8992,-6126,-2645,-2477,-6052,-10359,-11688,-8612,-3016,1420,2025,-939,-4757,-6603,-5609,-2976,-451,1055,1581,1428,792,-25,-471,-119,834,1611,1489,444,-785,-1258,-575,771,1720,1475,159,-1278,-1859,-1343,-297,486,580,68,-698,-1353,-1636,-1461,-974,-499,-330,-526,-882,-1078,-896,-364,245,580,474,87,-222,-199,110,456,639,645,576,512,472,439,398,337,258,179,105,2,-167,-368,-498,-493,-416,-407,-533,-724,-844,-822,-687,-518,-380,-314,-326,-366,-352,-234,-47,115,181,153,83,33,44,120,215,255,197,82,-1,-6,25,15,-65,-175,-259,-296,-295,-272,-238,-206,-185,-166,-138,-113,-118,-158,-193,-182,-132,-88,-78,-86,-76,-44,-7,21,40,47,32,-2,-30,-30,-12,-11,-46,-107,-168,-204,-190,-114,-8,43,-37,-243,-479,-634,-675,-651,-621,-590,-507,-323,-49,238,440,503,457,380,333,310,259,149,-2,-148,-260,-342,-421,-517,-638,-773,-887,-924,-833,-599,-269,56,279,359,337,290,264,249,215,156,97,58,42,39,43,50,52,49,56,85,128,157,157,133,93,31,-49,-130,-193,-239,-283,-318,-331,-326,-334,-357,-360,-325,-301,-357,-465,-497,-362,-129}
        },
        {    // H-30e012a.wav
            {1,-1,-1,-1,-3,-6,-3,4,6,-2,-8,-1,11,9,-5,-9,5,15,-2,-26,-18,16,24,-13,-42,-12,34,19,-38,-32,38,37,18,481,1968,4092,5200,3551,-753,-5232,-6927,-5157,-2225,-1123,-2530,-4257,-3629,-168,4180,7110,7855,7162,6079,5263,5202,6327,8391,10002,9383,5980,1247,-2379,-3417,-2429,-1364,-1881,-4082,-6514,-7323,-5701,-2559,102,717,-686,-2680,-3743,-3425,-2382,-1487,-1071,-930,-827,-780,-900,-1099,-1079,-628,103,658,663,200,-204,-39,700,1478,1716,1309,662,247,203,335,408,330,120,-203,-604,-971,-1150,-1076,-863,-737,-868,-1226,-1575,-1629,-1275,-699,-251,-152,-308,-413,-249,135,499,644,556,376,263,276,350,373,300,200,181,263,351,340,231,121,70,42,-36,-177,-321,-409,-433,-421,-397,-377,-378,-403,-431,-433,-406,-371,-341,-312,-282,-266,-267,-258,-205,-111,-28,2,-12,-19,16,79,128,131,90,37,7,18,55,85,88,67,46,39,44,50,44,28,4,-20,-44,-69,-103,-149,-201,-249,-289,-327,-372,-422,-467,-487,-458,-369,-230,-88,-14,-64,-233,-445,-595,-623,-557,-470,-398,-307,-135,123,395,592,677,669,607,509,390,268,155,47,-67,-189,-306,-410,-505,-607,-725,-852,-955,-975,-865,-638,-375,-165,-40,30,81,114,120,113,118,138,151,149,149,165,187,199,202,210,221,222,213,199,174,117,35,-35,-68,-89,-138,-208,-256,-275,-309,-381,-445,-450,-435,-485,-588,-609,-439,-156},
            {8,-8,-8,14,24,-1,-26,-10,27,20,-35,-55,4,61,20,-71,-65,43,81,-34,-117,2,126,6,149,1775,5251,8490,7839,1596,-7262,-12774,-11308,-5177,-397,-639,-3746,-4443,-39,7088,12354,13335,10996,7604,4778,3641,5395,10196,15476,16739,11289,1302,-7406,-10189,-7363,-3459,-2963,-6626,-11301,-12879,-9621,-3404,1797,2886,-153,-4511,-6937,-6156,-3306,-419,1289,1801,1562,875,19,-487,-146,923,1857,1701,279,-1547,-2485,-1820,6,1705,2133,1149,-366,-1307,-1209,-439,294,520,193,-464,-1138,-1522,-1424,-923,-371,-166,-450,-996,-1375,-1259,-650,110,568,497,69,-298,-298,26,392,570,548,453,387,363,350,330,315,321,345,344,244,13,-269,-451,-447,-334,-276,-370,-562,-729,-789,-741,-630,-511,-443,-461,-530,-553,-448,-226,16,177,215,164,99,91,168,280,334,268,123,5,-16,32,61,10,-107,-235,-326,-364,-359,-330,-300,-280,-267,-247,-222,-203,-195,-181,-141,-88,-53,-58,-83,-84,-38,40,111,145,132,84,26,-12,-12,14,30,6,-61,-145,-212,-224,-162,-46,47,19,-162,-426,-643,-730,-703,-640,-590,-538,-429,-232,27,274,430,465,417,363,341,326,262,136,-11,-128,-210,-292,-405,-551,-715,-874,-983,-978,-808,-494,-127,173,337,372,339,298,265,222,150,68,15,12,40,65,78,90,110,134,156,185,220,242,220,154,69,-12,-87,-161,-227,-277,-320,-371,-422,-449,-438,-403,-364,-331,-314,-338,-406,-468,-438,-287,-93}
        },
        {    // H-30e018a.wav
            {-4,-1,1,0,-2,-2,-3,-5,-4,2,4,-1,-7,-3,7,7,-4,-9,2,12,0,-20,-16,10,19,-10,-34,-12,26,17,-28,-27,27,29,10,372,1580,3380,4455,3322,-103,-3926,-5689,-4609,-2339,-1295,-2224,-3554,-3151,-486,3032,5609,6580,6442,5891,5300,5006,5503,6893,8279,8180,5848,2153,-1010,-2270,-1817,-1065,-1376,-2996,-4956,-5866,-4990,-2816,-729,28,-748,-2184,-3154,-3153,-2477,-1718,-1222,-996,-953,-1087,-1379,-1652,-1611,-1094,-269,427,631,384,127,305,942,1615,1851,1565,1076,760,730,840,890,773,461,-29,-602,-1081,-1298,-1231,-1035,-934,-1063,-1384,-1704,-1796,-1559,-1101,-673,-462,-448,-447,-306,-35,227,355,341,271,246,310,429,527,558,542,540,569,580,516,390,275,217,177,84,-79,-250,-358,-385,-368,-356,-374,-425,-495,-552,-572,-550,-517,-504,-519,-537,-532,-488,-403,-282,-145,-26,46,75,89,117,159,189,188,158,118,92,94,119,144,144,116,79,55,46,34,14,-5,-13,-19,-42,-88,-148,-207,-263,-310,-344,-364,-385,-421,-461,-474,-430,-333,-215,-128,-120,-213,-378,-535,-605,-570,-480,-390,-298,-160,48,285,484,600,630,597,523,422,305,182,61,-49,-147,-238,-331,-427,-524,-628,-744,-855,-906,-846,-672,-444,-235,-81,22,89,122,124,108,87,72,68,74,83,83,75,78,105,147,182,207,225,228,194,126,60,25,4,-38,-102,-154,-182,-220,-291,-359,-387,-407,-482,-589,-602,-429,-151},
            {-8,14,27,2,-30,-19,24,28,-28,-64,-12,62,37,-65,-85,25,95,-11,-130,-35,135,43,14,1307,4708,8595,9169,3795,-5543,-12888,-13379,-7892,-2140,-868,-3253,-4333,-594,6510,12479,14260,12271,8770,5635,4133,5536,10248,15976,18077,13185,2859,-6989,-10965,-8730,-4827,-4219,-7943,-12659,-13905,-9895,-2837,2887,4004,585,-4328,-7256,-6769,-3975,-977,921,1653,1641,1132,330,-260,-60,904,1755,1413,-397,-2706,-3913,-2983,-314,2467,3676,2795,736,-1025,-1598,-1108,-241,413,611,342,-262,-903,-1223,-1088,-733,-568,-789,-1221,-1487,-1306,-689,61,520,420,-115,-629,-702,-301,233,538,538,404,307,279,267,256,274,343,437,484,400,157,-156,-356,-323,-129,5,-85,-356,-626,-753,-726,-617,-500,-436,-465,-567,-646,-594,-402,-172,-26,5,-20,-12,75,228,376,424,320,113,-66,-108,-24,77,89,-9,-162,-300,-378,-387,-353,-315,-298,-289,-264,-225,-202,-212,-222,-186,-106,-39,-28,-56,-64,-23,47,107,140,143,112,58,12,15,62,101,75,-21,-145,-244,-286,-252,-146,-15,49,-40,-276,-552,-737,-777,-716,-638,-579,-508,-365,-131,141,357,453,446,407,392,390,352,256,126,7,-86,-175,-286,-424,-588,-773,-955,-1069,-1030,-794,-410,-10,270,373,346,279,231,194,140,68,13,5,32,58,66,77,112,170,227,269,297,315,312,274,200,104,5,-85,-162,-230,-299,-376,-452,-507,-521,-493,-444,-393,-357,-348,-372,-416,-438,-396,-284,-145,-37}
        },
        {    // H-30e024a.wav
            {-1,-2,-1,0,0,-1,-1,0,-1,-3,-3,1,4,0,-5,-1,7,7,-3,-7,2,11,3,-14,-15,5,15,-3,-23,-11,19,18,-15,-20,20,25,1,243,1158,2657,3777,3233,683,-2600,-4582,-4260,-2584,-1464,-1842,-2831,-2773,-946,1862,4297,5627,5961,5674,5051,4481,4556,5563,6893,7266,5823,2995,224,-1223,-1218,-695,-780,-1913,-3584,-4745,-4586,-3147,-1347,-328,-601,-1715,-2719,-2965,-2500,-1818,-1347,-1208,-1325,-1599,-1919,-2093,-1896,-1248,-355,391,699,616,490,667,1182,1741,1995,1849,1497,1205,1088,1075,1033,865,532,48,-507,-994,-1290,-1372,-1323,-1272,-1321,-1491,-1700,-1790,-1635,-1261,-856,-621,-595,-631,-554,-315,-12,232,364,418,456,518,600,666,691,685,688,712,715,647,515,379,288,220,118,-30,-178,-275,-314,-329,-354,-404,-480,-575,-666,-730,-754,-746,-717,-672,-614,-554,-497,-426,-320,-180,-41,59,115,144,171,203,235,258,260,235,194,159,146,146,140,118,86,54,25,-7,-42,-72,-90,-97,-101,-111,-136,-179,-229,-274,-308,-336,-369,-403,-428,-425,-380,-298,-210,-169,-215,-341,-488,-585,-595,-531,-428,-308,-165,9,203,376,484,516,496,454,399,320,216,103,-2,-98,-196,-294,-380,-450,-523,-612,-701,-749,-720,-608,-435,-246,-88,12,62,89,103,93,51,3,-13,7,24,13,-9,-5,32,82,131,182,223,224,175,107,56,24,-14,-57,-83,-96,-130,-195,-251,-265,-281,-370,-504,-546,-400,-142},
            {29,11,-27,-27,18,38,-13,-66,-31,55,58,-45,-100,-4,103,29,-126,-84,122,104,-70,747,3760,8091,10159,6412,-2662,-11729,-14842,-10932,-4719,-1795,-3029,-4252,-1263,5617,12184,14764,13172,9697,6547,5025,6220,10627,16394,19098,14966,4876,-5547,-10643,-9674,-6935,-7094,-10704,-14163,-13530,-8155,-1024,3783,4010,423,-4138,-6855,-6665,-4489,-2026,-318,652,1259,1529,1248,561,79,236,652,366,-1154,-3232,-4301,-3154,-76,3193,4716,3791,1361,-882,-1799,-1379,-331,627,1115,1025,437,-367,-992,-1205,-1125,-1075,-1244,-1507,-1575,-1258,-624,30,348,150,-399,-871,-900,-486,30,314,315,227,222,299,355,337,290,294,369,452,438,273,28,-131,-89,89,199,86,-217,-530,-689,-656,-508,-356,-295,-360,-506,-631,-639,-522,-354,-224,-168,-160,-142,-62,88,248,322,251,83,-59,-81,-1,82,80,-16,-154,-272,-336,-341,-307,-263,-232,-211,-185,-157,-147,-167,-192,-181,-125,-63,-38,-49,-59,-32,24,77,106,104,78,35,-2,-7,30,79,92,47,-43,-146,-232,-271,-236,-127,-8,16,-122,-385,-651,-802,-806,-720,-623,-542,-437,-255,5,265,432,472,439,417,438,460,426,322,183,48,-76,-204,-348,-510,-689,-880,-1052,-1131,-1034,-730,-293,117,356,390,302,201,136,83,19,-28,-19,42,99,109,88,93,155,256,350,407,425,412,377,318,231,124,17,-68,-131,-199,-297,-415,-514,-563,-565,-543,-504,-451,-398,-373,-383,-402,-390,-332,-244,-153,-76,-21}
        },
        {    // H-30e030a.wav
            {0,0,0,-1,-1,0,1,0,-1,-1,-1,-3,-3,0,3,2,-2,-2,4,6,1,-4,0,8,4,-9,-12,2,14,2,-17,-12,14,21,-4,-17,8,21,-1,136,780,1989,3119,3089,1335,-1420,-3548,-3878,-2741,-1586,-1511,-2221,-2450,-1294,976,3307,4834,5354,5119,4489,3896,3849,4607,5765,6350,5571,3545,1270,-183,-484,-193,-217,-1086,-2573,-3864,-4145,-3222,-1711,-605,-529,-1311,-2237,-2691,-2576,-2204,-1911,-1804,-1818,-1869,-1904,-1850,-1594,-1068,-358,309,710,807,798,954,1368,1855,2112,1990,1616,1246,1045,980,918,752,459,70,-361,-763,-1069,-1247,-1327,-1381,-1478,-1630,-1777,-1810,-1655,-1342,-1004,-781,-704,-678,-575,-343,-36,246,435,533,588,644,706,741,723,673,639,649,672,650,562,442,330,230,120,-8,-135,-234,-308,-373,-441,-511,-579,-649,-717,-763,-775,-754,-720,-683,-636,-573,-497,-414,-319,-202,-69,45,111,130,139,171,224,271,284,266,237,212,192,164,122,74,33,5,-17,-43,-70,-85,-77,-60,-59,-87,-133,-183,-229,-272,-306,-325,-336,-356,-384,-394,-358,-287,-230,-239,-321,-436,-527,-554,-514,-430,-325,-206,-66,92,239,342,386,387,369,335,279,202,118,32,-60,-158,-248,-316,-367,-417,-477,-536,-572,-560,-487,-362,-217,-98,-28,5,27,43,37,5,-36,-66,-79,-81,-71,-46,-16,5,20,50,96,134,138,111,75,39,3,-25,-30,-26,-50,-110,-164,-176,-178,-237,-345,-397,-302,-110},
            {-8,-28,-1,32,6,-57,-55,28,71,-9,-103,-51,85,79,-89,-142,54,159,-56,206,2428,6747,10377,9124,1499,-8746,-15095,-14025,-8197,-3483,-2911,-4013,-2227,3801,10871,14754,14107,10785,7400,5667,6653,10851,16814,20463,17578,7950,-3466,-10535,-11333,-9324,-9198,-12014,-14604,-13268,-7517,-381,4248,4403,907,-3640,-6638,-6943,-5225,-3057,-1500,-476,558,1583,1924,1169,-136,-961,-918,-671,-1125,-2295,-3108,-2390,-50,2681,4193,3734,1879,-66,-1085,-986,-212,662,1224,1257,760,-15,-680,-1010,-1125,-1313,-1681,-2014,-1987,-1473,-661,57,313,-13,-677,-1183,-1150,-628,-34,247,193,60,60,174,267,280,259,273,346,455,537,506,323,83,-43,25,170,199,34,-220,-411,-478,-454,-393,-336,-332,-415,-555,-650,-617,-472,-318,-246,-258,-281,-232,-92,79,173,128,-13,-126,-118,-9,96,109,26,-98,-210,-284,-311,-294,-249,-198,-149,-98,-56,-54,-109,-187,-216,-164,-68,-1,3,-25,-36,-16,16,35,37,26,6,-16,-25,-5,30,50,27,-36,-118,-196,-253,-263,-202,-81,27,25,-140,-420,-691,-840,-838,-739,-620,-505,-357,-137,135,367,476,462,403,384,421,464,453,373,247,102,-53,-218,-392,-577,-779,-989,-1163,-1211,-1048,-666,-180,224,409,377,240,110,20,-53,-110,-116,-49,50,111,114,108,155,263,387,475,513,514,488,437,354,243,122,18,-53,-105,-180,-301,-446,-557,-601,-595,-576,-555,-519,-470,-432,-418,-406,-357,-268,-178,-120,-91,-61,-23}
        },
        {    // H-30e036a.wav
            {-1,-2,-2,-1,-1,-3,-3,-1,0,-1,-2,-2,-2,-4,-5,-3,0,0,-4,-5,-1,3,0,-5,-4,2,2,-7,-14,-5,7,3,-13,-14,7,20,2,-19,-7,13,-1,57,478,1429,2536,2908,1827,-444,-2644,-3503,-2859,-1748,-1330,-1757,-2110,-1416,395,2510,4023,4595,4438,3946,3479,3377,3858,4752,5430,5205,3926,2167,787,244,282,209,-517,-1845,-3152,-3683,-3128,-1892,-817,-558,-1127,-1989,-2574,-2697,-2542,-2347,-2188,-2012,-1797,-1589,-1410,-1189,-815,-266,338,814,1055,1116,1160,1310,1530,1670,1620,1415,1194,1056,984,888,703,425,87,-278,-631,-923,-1119,-1229,-1313,-1435,-1613,-1787,-1851,-1720,-1405,-1023,-717,-550,-464,-356,-174,45,230,349,420,479,546,608,639,621,564,515,514,557,587,549,437,294,163,51,-59,-173,-273,-343,-387,-426,-476,-536,-595,-644,-681,-706,-716,-698,-651,-589,-538,-505,-464,-383,-257,-126,-31,19,48,82,126,172,213,246,259,241,196,148,118,105,90,62,26,-1,-13,-19,-30,-49,-70,-91,-118,-157,-207,-254,-287,-310,-332,-358,-380,-385,-369,-339,-311,-304,-330,-385,-441,-466,-448,-397,-333,-257,-158,-30,105,215,279,296,280,246,205,155,92,17,-64,-141,-207,-263,-306,-333,-351,-375,-406,-422,-392,-313,-216,-140,-94,-67,-46,-33,-34,-49,-73,-106,-140,-156,-144,-116,-91,-78,-63,-34,4,41,69,81,68,29,-7,-15,-2,-8,-51,-98,-114,-116,-154,-230,-270,-208,-77},
            {-20,32,33,-36,-76,-12,72,40,-77,-98,30,110,-12,-155,-48,160,51,-110,1050,4638,9284,10978,6297,-3656,-13080,-16184,-12380,-6450,-3390,-3496,-2896,1473,8316,13528,14449,11883,8478,6410,6914,10641,16765,21745,20754,11946,-755,-10328,-12818,-10617,-9294,-11532,-14713,-14281,-8734,-1023,4338,4937,1613,-2962,-6297,-7236,-6089,-4056,-2283,-1116,-188,775,1402,1075,-182,-1488,-1920,-1455,-916,-980,-1383,-1209,61,1899,3156,3095,1964,644,-135,-213,179,742,1206,1292,839,26,-696,-1002,-1012,-1127,-1566,-2120,-2365,-2043,-1245,-338,227,152,-481,-1182,-1393,-959,-260,184,204,51,20,131,211,166,90,118,275,484,649,693,573,329,98,21,103,205,181,18,-180,-307,-342,-322,-303,-330,-427,-572,-691,-708,-612,-470,-373,-356,-374,-334,-185,22,159,125,-48,-215,-239,-114,51,136,108,18,-74,-143,-192,-230,-253,-249,-204,-123,-38,-3,-50,-148,-222,-213,-132,-40,7,5,-10,-9,6,18,14,1,-11,-14,-6,11,24,16,-25,-86,-141,-178,-206,-231,-234,-182,-74,27,24,-136,-410,-674,-812,-793,-681,-559,-449,-302,-76,192,402,479,443,382,371,409,447,437,364,242,90,-73,-238,-408,-592,-798,-1012,-1179,-1210,-1023,-618,-119,277,431,355,176,15,-90,-160,-198,-179,-98,-2,60,91,144,260,419,557,626,622,577,521,460,375,256,126,29,-19,-58,-152,-315,-490,-600,-621,-601,-590,-595,-584,-542,-481,-421,-360,-286,-204,-138,-103,-87,-68,-39,-10}
        },
        {    // H-30e042a.wav
            {1,1,1,-1,-2,-1,0,-1,-2,-2,-1,0,-1,-2,-2,-3,-4,-2,1,1,-2,-4,-1,5,4,-4,-6,0,5,0,-10,-7,6,10,-1,-10,2,17,9,-11,-7,13,4,11,262,984,2010,2635,2088,300,-1816,-3025,-2829,-1868,-1228,-1351,-1673,-1308,23,1769,3140,3762,3776,3497,3171,3012,3232,3867,4570,4772,4137,2891,1643,887,634,463,-92,-1157,-2386,-3170,-3078,-2213,-1183,-665,-908,-1622,-2305,-2657,-2687,-2528,-2250,-1874,-1472,-1163,-988,-837,-543,-54,503,911,1037,932,792,808,1022,1304,1474,1446,1277,1082,926,793,635,422,148,-175,-512,-811,-1022,-1146,-1231,-1335,-1469,-1587,-1606,-1465,-1171,-814,-518,-360,-319,-304,-232,-91,70,194,266,305,342,392,444,478,483,472,464,463,446,385,284,177,93,32,-29,-101,-179,-248,-307,-361,-414,-462,-506,-550,-593,-625,-636,-626,-607,-587,-564,-526,-463,-373,-265,-156,-67,-10,22,48,83,125,160,179,183,180,176,168,152,128,97,69,54,53,56,43,7,-44,-93,-131,-163,-195,-230,-260,-282,-298,-313,-332,-353,-364,-357,-332,-311,-316,-348,-381,-386,-358,-314,-273,-228,-163,-74,26,114,173,199,194,169,135,100,61,13,-49,-119,-185,-235,-257,-253,-241,-239,-256,-277,-281,-258,-219,-178,-146,-122,-102,-83,-65,-59,-73,-109,-151,-184,-199,-196,-177,-142,-100,-63,-31,6,48,78,78,53,32,27,22,1,-27,-41,-48,-77,-128,-159,-127,-48},
            {32,-12,-67,-45,44,73,-21,-112,-46,94,79,-98,-144,68,173,-90,95,2315,6861,10985,10265,2747,-8177,-15881,-16176,-10882,-5448,-3256,-2777,-341,5157,11012,13780,12629,9509,7032,6994,10249,16271,22103,22996,15991,3471,-7865,-12644,-11480,-9597,-10906,-14086,-14625,-10050,-2508,3448,4841,2042,-2432,-6032,-7393,-6526,-4474,-2586,-1599,-1247,-843,-210,142,-219,-978,-1392,-1169,-770,-747,-975,-746,381,1967,3031,2952,1981,899,295,238,507,915,1306,1404,930,-37,-975,-1362,-1203,-1014,-1250,-1844,-2331,-2322,-1786,-986,-293,-37,-335,-927,-1286,-1061,-430,83,162,-14,-72,97,279,281,162,110,195,343,484,601,663,605,426,239,161,169,141,12,-155,-255,-258,-216,-192,-231,-361,-576,-795,-895,-812,-614,-448,-404,-445,-451,-332,-107,99,160,50,-121,-200,-123,35,141,130,40,-47,-88,-96,-105,-134,-176,-209,-207,-165,-113,-95,-126,-171,-185,-161,-130,-119,-120,-102,-53,9,56,76,70,42,3,-22,-14,19,35,-1,-77,-145,-174,-176,-185,-208,-211,-156,-50,38,21,-147,-418,-672,-795,-760,-641,-525,-426,-279,-39,239,439,486,420,346,337,383,420,396,305,173,31,-110,-258,-427,-622,-830,-1023,-1147,-1130,-908,-500,-36,297,386,268,74,-88,-192,-257,-279,-240,-150,-55,9,65,167,339,540,692,746,711,634,555,480,387,264,137,46,-4,-56,-164,-333,-506,-614,-644,-634,-628,-631,-618,-568,-488,-397,-309,-228,-164,-124,-104,-87,-62,-30,-6,2}
        },
        {    // H-30e048a.wav
            {3,1,0,0,1,1,0,0,0,0,-1,-1,0,1,1,1,0,0,-1,0,1,2,0,-2,1,7,7,1,-4,1,8,6,-4,-7,4,13,6,-7,-3,13,14,-3,-8,8,6,-6,136,663,1549,2282,2133,818,-1083,-2480,-2677,-1952,-1203,-1033,-1223,-1082,-218,1098,2280,2968,3192,3137,2940,2736,2748,3146,3791,4240,4086,3327,2356,1594,1137,734,57,-986,-2135,-2917,-2954,-2254,-1257,-571,-561,-1137,-1897,-2456,-2657,-2525,-2146,-1611,-1056,-640,-451,-422,-381,-192,134,466,663,688,633,646,808,1069,1293,1373,1293,1116,911,711,516,307,60,-234,-540,-783,-902,-912,-895,-931,-1030,-1139,-1186,-1126,-960,-737,-538,-425,-401,-402,-357,-251,-123,-17,60,130,208,284,333,342,318,289,279,291,298,269,202,128,79,55,26,-29,-106,-181,-241,-291,-337,-383,-429,-475,-517,-547,-560,-560,-554,-545,-523,-482,-419,-337,-244,-154,-82,-38,-16,-5,8,27,53,82,110,133,147,155,156,146,118,78,43,24,20,14,-5,-33,-63,-93,-130,-175,-218,-248,-263,-275,-295,-323,-346,-354,-347,-336,-330,-331,-330,-316,-287,-247,-206,-165,-117,-57,10,67,95,93,73,55,45,39,27,-2,-51,-115,-180,-227,-241,-224,-193,-168,-161,-175,-199,-221,-228,-220,-200,-173,-139,-99,-67,-59,-80,-120,-164,-204,-232,-236,-210,-160,-111,-77,-52,-20,21,56,72,72,63,47,26,8,0,-8,-32,-69,-91,-73,-28},
            {-12,-68,-33,57,62,-49,-114,-10,117,44,-142,-115,134,142,-171,360,3328,8361,11876,9424,181,-11111,-17602,-16252,-10140,-4769,-2521,-1242,2094,7409,11721,12599,10506,7903,7056,9086,13982,20112,23784,21005,11122,-1453,-10338,-12651,-11124,-10515,-12361,-13823,-11431,-5192,1312,4309,2822,-1276,-5259,-7326,-7143,-5515,-3708,-2634,-2308,-2057,-1375,-501,-79,-344,-854,-1042,-861,-699,-752,-660,92,1489,2844,3376,2903,1921,1063,593,437,516,824,1189,1193,540,-523,-1360,-1584,-1444,-1476,-1873,-2311,-2369,-1955,-1308,-738,-461,-567,-942,-1237,-1091,-503,106,311,124,-80,-21,203,337,309,260,302,397,470,530,610,656,579,395,227,164,161,110,-29,-202,-339,-401,-385,-324,-293,-375,-578,-797,-896,-834,-694,-589,-556,-528,-415,-194,50,185,140,-22,-147,-125,17,160,206,152,63,-7,-46,-67,-88,-125,-178,-219,-214,-162,-114,-125,-191,-253,-258,-214,-165,-140,-128,-110,-85,-61,-35,4,49,78,81,73,77,85,65,-1,-88,-148,-157,-135,-119,-126,-132,-98,-17,59,36,-145,-443,-716,-831,-771,-635,-521,-422,-257,12,300,476,483,388,305,294,336,371,356,282,165,26,-123,-287,-475,-680,-879,-1031,-1090,-1004,-742,-342,68,325,342,165,-69,-245,-331,-349,-319,-244,-140,-44,20,74,177,359,581,759,825,784,693,607,530,432,296,150,39,-30,-95,-201,-346,-487,-578,-619,-636,-649,-652,-626,-562,-468,-359,-253,-168,-120,-105,-101,-83,-51,-18,-2,0,-2}
        },
        {    // H-30e054a.wav
            {1,1,2,1,0,0,0,0,0,0,0,0,0,-1,0,1,0,-1,0,0,-1,-2,-1,1,3,2,2,4,4,1,0,2,6,3,-5,-6,3,10,2,-10,-6,11,16,0,-11,2,9,-2,84,465,1180,1877,1949,1042,-518,-1878,-2337,-1903,-1205,-840,-849,-803,-323,564,1521,2253,2670,2804,2702,2472,2352,2596,3216,3877,4115,3696,2786,1776,968,381,-179,-879,-1664,-2251,-2327,-1817,-1006,-383,-319,-824,-1583,-2191,-2397,-2175,-1671,-1105,-676,-490,-512,-601,-600,-434,-135,194,445,564,587,613,727,927,1117,1197,1133,964,739,483,213,-31,-201,-276,-282,-264,-262,-307,-418,-590,-784,-943,-1021,-1005,-914,-782,-651,-556,-507,-483,-451,-389,-298,-192,-84,13,90,139,160,156,135,112,105,123,151,163,146,117,97,90,71,22,-49,-121,-180,-227,-266,-298,-328,-363,-407,-451,-480,-487,-480,-468,-449,-415,-366,-307,-248,-196,-154,-127,-113,-99,-76,-41,-2,30,52,67,82,97,105,96,68,35,16,21,38,47,36,11,-17,-46,-84,-131,-180,-222,-258,-296,-335,-362,-368,-355,-337,-321,-305,-280,-247,-212,-181,-152,-120,-85,-49,-17,5,13,8,-7,-22,-32,-38,-45,-62,-96,-141,-184,-209,-208,-186,-156,-130,-123,-139,-175,-214,-238,-239,-223,-196,-163,-127,-99,-91,-107,-138,-170,-192,-199,-192,-176,-157,-136,-112,-81,-43,-4,31,55,62,51,32,18,15,12,-7,-39,-60,-51,-20},
            {-59,-5,69,47,-70,-118,1,126,38,-156,-116,148,144,-185,437,3673,8991,12441,9357,-792,-12624,-18894,-16799,-9972,-4162,-1555,122,3557,8242,11344,11220,9044,7274,7616,10642,16020,21847,24279,19732,8590,-3885,-11590,-12859,-11244,-10971,-12347,-12171,-8121,-1743,3053,3711,798,-3290,-6476,-7876,-7509,-5973,-4253,-3182,-2777,-2314,-1270,-41,488,3,-880,-1357,-1270,-1027,-836,-345,838,2464,3695,3864,3057,1918,1020,541,438,677,1130,1414,1085,99,-1037,-1723,-1841,-1795,-1990,-2398,-2657,-2493,-1942,-1250,-694,-498,-734,-1180,-1375,-1000,-227,400,506,232,7,65,282,437,492,537,597,603,542,503,549,612,574,427,270,176,108,-6,-173,-338,-458,-528,-548,-522,-485,-509,-628,-781,-854,-798,-679,-602,-587,-549,-391,-126,118,205,116,-33,-99,-31,110,217,232,169,82,17,-10,-18,-39,-97,-175,-222,-208,-159,-140,-186,-265,-317,-315,-278,-237,-199,-155,-113,-94,-103,-115,-96,-43,18,71,117,164,194,176,102,1,-79,-114,-112,-99,-90,-77,-34,44,110,72,-135,-464,-761,-880,-808,-660,-544,-450,-281,-2,296,470,468,362,270,247,272,296,289,247,176,74,-66,-251,-477,-711,-907,-1020,-1020,-886,-614,-242,118,324,293,70,-206,-406,-485,-467,-387,-266,-130,-19,45,94,196,385,615,792,851,806,723,645,566,458,319,178,65,-26,-127,-254,-392,-506,-577,-610,-622,-624,-615,-587,-532,-446,-334,-221,-136,-96,-92,-92,-73,-36,-2,13,11,4,0}
        },
        {    // H-30e060a.wav
            {0,0,1,1,1,1,1,1,1,1,0,0,1,2,2,0,-1,-1,0,1,1,0,0,1,2,3,3,3,3,5,5,3,1,1,3,2,-2,-2,3,7,4,-2,-1,7,9,2,-2,4,6,5,87,387,933,1481,1597,994,-162,-1290,-1829,-1662,-1148,-751,-632,-593,-342,217,943,1624,2130,2433,2551,2535,2493,2560,2795,3100,3257,3076,2530,1770,1011,399,-67,-482,-908,-1282,-1442,-1267,-826,-377,-210,-451,-987,-1553,-1896,-1902,-1615,-1188,-801,-581,-548,-617,-652,-547,-284,57,348,495,503,476,529,682,842,881,753,526,314,196,177,216,269,297,273,191,58,-111,-306,-515,-713,-867,-948,-954,-901,-813,-713,-622,-558,-524,-508,-483,-425,-329,-216,-124,-77,-70,-74,-66,-47,-25,1,41,91,128,136,126,124,133,128,84,12,-53,-91,-117,-154,-205,-254,-292,-324,-360,-391,-404,-394,-377,-369,-373,-373,-353,-314,-272,-241,-219,-193,-155,-114,-84,-64,-43,-12,19,37,38,37,48,66,80,85,87,90,87,68,33,-7,-41,-73,-118,-176,-236,-285,-318,-340,-354,-352,-327,-285,-242,-209,-184,-156,-125,-103,-97,-102,-100,-82,-59,-47,-51,-59,-64,-67,-77,-94,-114,-132,-150,-172,-189,-189,-165,-128,-99,-97,-122,-162,-206,-247,-277,-283,-254,-198,-137,-94,-80,-87,-106,-127,-146,-158,-163,-159,-149,-132,-110,-85,-57,-27,2,21,25,18,10,10,11,1,-20,-35,-31,-12},
            {-41,63,84,-40,-135,-32,135,83,-149,-167,125,206,-156,247,3339,8938,13040,10387,-143,-13057,-20279,-18209,-10468,-3549,-415,1031,3861,8027,10856,10592,8310,6579,7341,11213,17468,23525,25161,19197,6982,-5559,-12572,-13189,-11349,-10831,-11340,-9865,-5076,700,3868,2980,-589,-4574,-7541,-8923,-8529,-6698,-4540,-3222,-2847,-2446,-1269,198,816,171,-973,-1620,-1545,-1169,-713,92,1430,2880,3724,3668,3032,2263,1514,808,386,574,1260,1759,1395,188,-1174,-2040,-2352,-2478,-2676,-2852,-2799,-2462,-1931,-1324,-789,-553,-748,-1171,-1345,-966,-237,337,466,323,250,364,523,597,626,697,773,762,668,603,615,614,501,318,200,192,184,45,-223,-492,-655,-700,-677,-627,-583,-597,-704,-855,-932,-860,-695,-561,-512,-467,-318,-71,136,175,56,-81,-110,-15,126,230,265,236,166,85,29,10,5,-27,-90,-142,-146,-122,-131,-208,-318,-391,-393,-350,-304,-269,-231,-190,-164,-164,-168,-144,-83,-6,63,123,183,230,239,195,116,41,-4,-21,-27,-39,-44,-14,67,157,152,-35,-374,-711,-878,-844,-717,-614,-531,-368,-81,235,426,429,323,233,216,236,241,220,193,168,121,12,-173,-418,-670,-865,-955,-922,-770,-518,-200,109,295,272,49,-263,-522,-645,-628,-508,-331,-148,-13,55,103,209,406,637,806,858,819,749,679,601,498,372,245,123,-2,-146,-302,-442,-537,-580,-591,-593,-592,-577,-535,-470,-390,-301,-210,-134,-91,-81,-78,-58,-19,20,43,47,40,27,11}
        },
        {    // H-30e066a.wav
            {0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,1,2,2,2,1,1,2,2,2,2,2,2,2,2,2,3,3,1,0,-1,0,1,4,6,5,1,-4,-4,1,7,9,7,0,-3,23,137,397,775,1107,1144,736,-14,-778,-1222,-1238,-991,-743,-622,-551,-360,61,683,1385,2011,2419,2518,2332,2019,1805,1847,2127,2469,2652,2530,2096,1462,799,254,-120,-361,-516,-572,-475,-238,-12,-17,-364,-943,-1494,-1785,-1751,-1488,-1152,-866,-696,-643,-655,-648,-547,-345,-103,91,190,209,200,209,259,347,459,572,657,692,675,624,561,496,429,352,256,128,-49,-274,-517,-728,-863,-912,-893,-835,-759,-682,-621,-593,-597,-611,-608,-569,-499,-417,-341,-281,-237,-202,-168,-131,-85,-27,41,108,154,173,173,172,173,165,135,83,22,-35,-83,-121,-152,-176,-203,-238,-279,-315,-337,-352,-373,-401,-423,-423,-400,-366,-329,-291,-251,-213,-186,-168,-148,-114,-67,-22,10,30,48,69,88,97,96,93,96,102,97,76,39,-8,-64,-125,-184,-229,-256,-269,-279,-289,-289,-270,-234,-195,-164,-144,-134,-128,-128,-132,-136,-133,-122,-105,-89,-80,-79,-84,-93,-104,-119,-134,-150,-165,-178,-185,-180,-159,-130,-111,-116,-148,-194,-238,-269,-283,-277,-250,-205,-149,-96,-59,-46,-57,-81,-104,-123,-136,-144,-143,-134,-120,-105,-87,-59,-27,-2,5,0,-7,-10,-16,-29,-37,-31,-12},
            {10,76,14,-113,-88,95,142,-79,-225,17,265,-26,-110,2129,7553,12994,12545,3166,-10968,-20934,-20772,-12594,-3724,729,1725,3199,6678,9951,10360,8079,5876,6549,11031,18022,24304,25725,19622,7480,-5180,-12764,-13957,-11933,-10305,-9494,-7423,-3071,1706,3999,2701,-923,-4929,-8109,-9874,-9753,-7773,-5023,-3065,-2496,-2459,-1816,-550,334,148,-688,-1279,-1288,-1009,-628,110,1377,2745,3515,3456,2945,2384,1786,1083,585,762,1539,2117,1708,355,-1142,-2078,-2440,-2654,-2965,-3229,-3201,-2818,-2180,-1433,-791,-539,-804,-1318,-1546,-1168,-391,281,536,477,383,396,483,602,767,962,1084,1050,911,797,753,685,495,232,52,40,112,98,-85,-373,-640,-801,-851,-826,-783,-780,-851,-955,-993,-903,-731,-590,-526,-464,-304,-55,149,182,58,-91,-141,-67,74,210,295,307,250,160,90,62,58,41,7,-23,-36,-59,-129,-249,-375,-455,-471,-442,-397,-349,-305,-271,-255,-248,-232,-189,-119,-36,49,135,215,270,279,242,177,112,67,46,38,27,7,5,59,164,224,114,-197,-580,-836,-871,-764,-662,-601,-489,-244,75,304,344,251,167,165,204,213,181,155,165,172,104,-77,-344,-620,-823,-895,-829,-655,-413,-142,112,271,252,34,-301,-605,-765,-753,-614,-415,-218,-75,-2,47,155,359,602,782,844,821,774,725,652,540,413,300,200,79,-87,-280,-453,-561,-598,-590,-572,-559,-541,-500,-433,-350,-264,-187,-126,-93,-86,-82,-57,-11,34,57,59,55,50,36,13}
        },
        {    // H-30e072a.wav
            {1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,4,4,3,3,4,5,6,5,4,4,5,5,4,3,4,5,5,3,3,6,8,5,1,2,8,11,6,-1,-3,2,9,12,13,12,6,5,49,187,425,680,815,722,405,-16,-394,-645,-773,-823,-806,-678,-395,28,496,896,1169,1334,1448,1543,1609,1637,1654,1727,1910,2191,2464,2570,2373,1856,1169,563,252,272,464,587,483,153,-286,-702,-1019,-1225,-1336,-1374,-1354,-1285,-1170,-1023,-873,-760,-699,-669,-626,-551,-456,-371,-296,-202,-55,151,394,633,829,951,980,924,812,683,563,463,381,306,218,86,-109,-350,-580,-737,-794,-773,-723,-688,-683,-707,-745,-782,-798,-781,-730,-660,-585,-511,-439,-368,-304,-250,-194,-122,-31,61,127,158,166,173,185,196,195,177,148,108,62,13,-30,-63,-93,-133,-184,-235,-275,-304,-335,-376,-420,-449,-452,-431,-396,-356,-316,-279,-249,-225,-202,-171,-131,-88,-51,-21,6,35,62,83,98,108,118,123,118,100,71,33,-12,-65,-122,-170,-202,-216,-220,-222,-221,-212,-194,-173,-161,-162,-167,-168,-159,-145,-132,-124,-119,-113,-109,-110,-116,-123,-126,-124,-121,-124,-133,-149,-171,-195,-217,-227,-219,-196,-169,-151,-150,-166,-191,-216,-233,-237,-224,-193,-145,-90,-46,-23,-24,-40,-66,-99,-131,-153,-157,-145,-128,-109,-85,-55,-28,-15,-17,-26,-37,-49,-60,-60,-42,-15},
            {64,50,-79,-140,15,184,56,-223,-165,220,221,-242,581,4782,11233,14425,8761,-5068,-18894,-23623,-17336,-6452,1092,3012,2899,4580,7807,9585,8410,6130,6025,9874,16715,23385,25906,21486,10658,-2253,-11704,-14876,-13258,-10310,-7906,-5411,-1849,1974,3982,2989,-294,-4260,-7734,-10073,-10646,-9084,-6114,-3481,-2503,-2808,-2868,-1782,-209,551,64,-920,-1447,-1243,-579,317,1377,2390,2993,3061,2852,2599,2171,1388,576,439,1218,2209,2350,1281,-373,-1732,-2459,-2790,-3002,-3114,-3049,-2831,-2505,-2044,-1459,-971,-861,-1126,-1398,-1281,-738,-87,345,478,437,364,350,466,740,1095,1350,1376,1214,1033,937,867,686,366,47,-94,-33,70,30,-202,-517,-772,-898,-917,-890,-884,-949,-1071,-1156,-1099,-896,-664,-518,-446,-339,-145,55,134,60,-72,-139,-93,38,199,334,394,356,251,154,118,129,132,98,47,10,-16,-71,-182,-329,-461,-533,-538,-494,-425,-357,-314,-305,-319,-317,-271,-182,-77,22,113,202,278,317,302,245,176,123,101,100,97,73,41,52,137,244,243,36,-332,-682,-847,-816,-713,-645,-583,-426,-151,120,241,193,100,86,148,196,176,137,150,206,210,74,-195,-508,-751,-855,-805,-634,-392,-122,136,320,344,153,-208,-596,-854,-906,-782,-563,-333,-157,-61,-14,66,242,488,705,811,813,775,739,691,603,486,377,289,192,41,-167,-381,-532,-588,-574,-544,-531,-524,-490,-417,-320,-227,-154,-105,-85,-86,-86,-61,-13,26,34,22,22,40,56,45,16}
        },
        {    // H-30e078a.wav
            {0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,2,2,3,3,3,2,1,1,2,2,1,0,0,0,0,0,-1,0,2,3,3,2,2,1,0,1,4,8,7,1,-2,1,7,7,4,5,8,6,14,84,249,461,592,536,319,80,-64,-126,-196,-306,-381,-337,-206,-113,-126,-161,-62,236,652,1056,1383,1647,1858,1986,2012,1997,2052,2223,2426,2503,2338,1946,1452,1009,709,538,391,155,-213,-647,-1016,-1219,-1248,-1176,-1100,-1082,-1126,-1193,-1224,-1176,-1058,-930,-859,-860,-875,-815,-620,-298,90,461,751,924,988,978,936,889,832,748,629,489,354,240,143,41,-85,-235,-389,-521,-617,-675,-707,-729,-762,-814,-873,-916,-920,-883,-819,-746,-667,-584,-500,-422,-350,-280,-203,-123,-44,29,93,139,163,166,163,169,182,188,178,155,127,94,52,-4,-70,-138,-203,-261,-310,-348,-372,-383,-387,-387,-386,-381,-372,-358,-339,-314,-281,-241,-200,-166,-142,-123,-99,-68,-34,-5,23,55,92,128,150,151,129,92,46,-3,-48,-82,-105,-127,-152,-181,-204,-212,-205,-189,-172,-158,-149,-147,-154,-164,-166,-156,-136,-119,-113,-119,-129,-140,-150,-160,-167,-171,-170,-171,-180,-200,-226,-252,-272,-280,-271,-239,-189,-137,-105,-104,-127,-155,-175,-180,-170,-144,-108,-72,-49,-45,-55,-73,-97,-122,-140,-144,-135,-120,-106,-94,-83,-73,-67,-66,-67,-72,-82,-89,-80,-52,-17},
            {101,10,-156,-134,111,219,-50,-310,-63,353,109,-329,1411,6920,13374,14121,4782,-10959,-23008,-23485,-13695,-2148,3898,4211,3396,4692,7115,8056,7051,6332,8387,13688,20301,24840,23970,16341,4087,-7805,-14652,-15233,-11931,-7897,-4427,-1136,2074,4086,3685,960,-2824,-6425,-9194,-10637,-10172,-7824,-4858,-3024,-2954,-3550,-3244,-1695,-20,567,-25,-924,-1327,-1044,-244,884,2071,2894,3087,2839,2545,2258,1682,801,226,595,1703,2505,2128,712,-861,-1906,-2410,-2692,-2900,-2958,-2829,-2586,-2279,-1891,-1492,-1269,-1323,-1476,-1412,-998,-408,76,309,332,265,224,310,575,968,1325,1484,1416,1239,1105,1054,988,779,422,65,-118,-100,-31,-91,-326,-629,-857,-950,-940,-910,-939,-1062,-1221,-1296,-1196,-958,-706,-523,-383,-220,-45,61,47,-46,-127,-130,-39,128,324,472,504,418,291,206,183,179,148,91,30,-24,-81,-155,-246,-347,-443,-518,-550,-526,-457,-381,-339,-344,-364,-353,-283,-166,-40,72,164,235,275,277,252,220,201,195,194,184,153,103,67,99,203,288,219,-62,-450,-746,-834,-770,-692,-655,-577,-372,-89,111,128,36,-9,62,168,201,161,145,203,264,203,-30,-361,-659,-819,-810,-658,-420,-155,94,290,376,283,-8,-414,-773,-946,-902,-718,-497,-313,-192,-115,-29,121,345,583,750,807,783,732,678,613,531,446,374,299,183,2,-221,-424,-545,-573,-547,-517,-502,-481,-426,-331,-221,-126,-69,-61,-87,-113,-102,-49,12,35,17,-8,-6,19,36,29,10}
        },
        {    // H-30e084a.wav
            {0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,2,2,2,2,2,3,3,2,1,1,1,1,0,0,-1,-1,-1,-1,1,3,3,0,-3,-3,1,6,6,3,2,6,11,10,3,-4,-6,-3,3,7,11,19,49,132,270,406,434,304,104,28,186,460,556,269,-309,-854,-1085,-976,-699,-401,-73,361,892,1399,1764,1974,2086,2150,2188,2240,2381,2630,2872,2895,2549,1872,1076,415,34,-78,-51,-57,-214,-529,-899,-1181,-1286,-1238,-1139,-1091,-1133,-1239,-1352,-1422,-1416,-1317,-1131,-884,-610,-322,-15,317,647,913,1057,1072,1002,907,819,738,651,549,435,310,183,68,-26,-107,-197,-309,-436,-560,-666,-755,-828,-880,-900,-895,-882,-877,-871,-843,-783,-697,-601,-504,-408,-316,-234,-167,-109,-54,0,45,75,94,115,145,181,212,228,224,199,155,94,24,-48,-117,-179,-236,-287,-328,-354,-362,-358,-349,-337,-325,-315,-311,-313,-317,-314,-299,-272,-240,-204,-164,-123,-85,-54,-30,-7,18,47,79,111,139,154,149,121,72,15,-40,-84,-117,-140,-159,-174,-183,-185,-184,-181,-176,-168,-160,-152,-145,-137,-126,-119,-119,-128,-141,-153,-165,-177,-189,-202,-215,-227,-238,-246,-251,-259,-274,-289,-296,-284,-249,-198,-142,-94,-64,-52,-52,-60,-72,-85,-96,-100,-100,-100,-101,-103,-109,-119,-131,-135,-128,-114,-103,-98,-97,-98,-102,-110,-115,-111,-103,-98,-96,-84,-55,-18},
            {126,-20,-204,-119,182,237,-124,-359,16,441,36,-386,1880,8058,14358,13640,2392,-14057,-24817,-22928,-11407,371,5647,5088,3564,4080,5745,6587,6583,7514,10800,16119,21527,24196,21464,12563,70,-10912,-16060,-14801,-10023,-5024,-1099,2031,4335,4865,2936,-794,-4818,-8003,-9956,-10461,-9280,-6782,-4301,-3214,-3578,-4033,-3282,-1473,66,326,-452,-1272,-1421,-847,190,1408,2473,3031,3022,2765,2542,2188,1388,366,-66,630,1949,2687,2092,503,-1143,-2207,-2659,-2734,-2597,-2362,-2183,-2135,-2094,-1895,-1590,-1418,-1496,-1633,-1524,-1078,-481,5,250,277,191,130,228,542,979,1343,1478,1389,1221,1118,1102,1056,860,526,204,32,1,-36,-194,-456,-710,-869,-924,-918,-913,-974,-1128,-1308,-1379,-1258,-1002,-744,-549,-379,-186,-7,71,18,-100,-182,-166,-39,171,395,545,564,473,354,272,230,191,129,47,-33,-98,-149,-197,-257,-335,-419,-485,-513,-497,-447,-387,-346,-338,-349,-339,-278,-172,-53,52,141,215,264,277,260,232,213,209,213,209,181,130,99,142,253,326,220,-102,-507,-792,-861,-793,-724,-682,-579,-351,-81,69,37,-66,-81,23,141,176,157,180,268,321,216,-64,-414,-689,-797,-727,-527,-271,-21,186,326,348,194,-142,-555,-873,-972,-862,-655,-463,-333,-252,-176,-65,109,335,560,719,780,759,699,633,571,508,446,380,297,174,2,-195,-368,-478,-523,-529,-518,-489,-431,-345,-249,-162,-96,-64,-76,-122,-157,-142,-81,-24,-13,-38,-56,-38,-1,23,21,8}
        },
        {    // H-30e090a.wav
            {0,0,0,0,0,0,0,0,1,1,1,1,1,2,3,3,3,3,3,2,2,2,3,3,2,1,0,0,1,1,-1,-1,0,2,3,3,1,-1,-1,1,4,5,4,3,4,6,7,8,9,9,3,-7,-11,-2,12,14,4,9,59,157,281,413,550,668,692,539,199,-230,-611,-871,-1012,-1039,-913,-599,-151,300,665,971,1302,1681,2037,2305,2513,2737,2972,3086,2939,2522,1979,1480,1094,772,450,128,-135,-281,-314,-300,-337,-492,-766,-1073,-1300,-1376,-1326,-1250,-1244,-1336,-1469,-1540,-1453,-1166,-715,-207,233,524,673,757,854,977,1077,1088,984,798,594,427,312,236,173,103,18,-83,-199,-325,-450,-562,-654,-725,-782,-829,-868,-892,-893,-866,-818,-765,-721,-681,-623,-533,-423,-320,-247,-200,-160,-114,-65,-21,20,63,107,141,156,160,167,178,178,152,101,41,-18,-81,-154,-230,-292,-328,-341,-343,-338,-322,-300,-281,-277,-287,-300,-308,-309,-306,-293,-263,-215,-161,-117,-88,-68,-44,-12,21,50,74,95,114,126,129,122,105,75,32,-17,-62,-97,-124,-149,-177,-205,-227,-237,-231,-207,-170,-133,-108,-102,-111,-124,-136,-149,-166,-186,-206,-223,-237,-248,-256,-260,-263,-269,-282,-298,-308,-304,-284,-252,-214,-172,-125,-75,-28,9,34,43,33,5,-34,-73,-106,-133,-155,-170,-173,-166,-150,-135,-124,-121,-122,-121,-116,-113,-118,-127,-130,-119,-101,-88,-84,-76,-51,-17},
            {139,-15,-220,-139,190,267,-120,-395,-6,486,84,-488,1569,7724,14304,13978,2876,-13838,-25046,-23349,-11520,873,6583,5868,3588,3168,4317,5434,6365,8313,12052,16987,21436,23120,19797,10788,-1452,-11907,-16251,-13988,-8287,-2790,1070,3736,5439,5338,2723,-1679,-6074,-9056,-10300,-10045,-8544,-6295,-4333,-3622,-4024,-4282,-3326,-1463,-21,85,-808,-1657,-1760,-1084,108,1530,2783,3402,3260,2760,2371,2058,1447,565,90,619,1818,2591,2119,590,-1130,-2329,-2850,-2864,-2574,-2164,-1829,-1668,-1597,-1498,-1412,-1485,-1712,-1849,-1646,-1115,-525,-137,-15,-42,-62,30,268,616,977,1238,1328,1262,1138,1063,1067,1062,926,640,334,159,124,86,-89,-390,-693,-888,-952,-926,-886,-921,-1077,-1296,-1425,-1345,-1087,-788,-547,-357,-173,-15,46,-20,-154,-251,-228,-69,178,421,567,581,502,403,326,265,195,109,19,-62,-128,-179,-224,-274,-337,-402,-448,-460,-436,-388,-339,-314,-327,-355,-353,-289,-176,-51,59,149,216,250,250,231,214,207,204,203,203,192,158,128,154,245,310,207,-108,-505,-779,-836,-762,-701,-679,-595,-380,-124,4,-48,-152,-146,-11,131,182,184,235,339,377,232,-80,-425,-662,-726,-628,-423,-180,40,203,291,270,95,-236,-624,-900,-954,-811,-600,-434,-339,-276,-200,-87,71,270,481,654,743,742,688,626,580,539,483,396,283,156,19,-122,-259,-377,-463,-512,-520,-482,-402,-299,-199,-123,-78,-68,-96,-150,-193,-190,-143,-95,-84,-100,-100,-60,1,39,37,14}
        },
        {    // H-30e096a.wav
            {0,0,1,1,1,1,1,1,1,1,2,2,2,2,3,4,4,4,4,4,4,4,3,2,2,3,3,2,0,-1,0,1,2,3,3,2,0,1,4,6,4,1,1,5,7,6,6,9,11,10,8,9,8,-2,-14,-13,2,7,2,64,301,713,1092,1136,697,-52,-738,-1081,-1074,-891,-686,-485,-257,-4,247,498,765,1026,1237,1427,1733,2254,2883,3314,3294,2846,2243,1749,1419,1137,808,468,218,95,36,-45,-187,-364,-523,-618,-645,-654,-727,-913,-1167,-1374,-1448,-1401,-1316,-1253,-1187,-1037,-748,-336,126,546,851,1008,1035,995,949,919,878,787,636,453,282,149,54,-26,-110,-206,-306,-398,-481,-568,-664,-755,-816,-833,-819,-802,-798,-799,-777,-719,-635,-552,-489,-446,-406,-355,-288,-212,-141,-85,-46,-19,7,38,69,88,92,91,101,125,146,139,93,20,-63,-140,-202,-243,-265,-275,-285,-306,-331,-349,-351,-339,-321,-304,-286,-266,-243,-222,-205,-191,-176,-154,-122,-79,-31,13,47,66,73,75,77,79,79,78,80,88,93,82,50,2,-51,-101,-149,-194,-234,-264,-279,-275,-252,-210,-158,-112,-88,-91,-116,-149,-179,-204,-225,-244,-256,-260,-261,-266,-274,-280,-281,-279,-280,-281,-273,-251,-221,-189,-153,-107,-48,14,65,95,102,85,48,-4,-59,-111,-154,-184,-197,-196,-187,-173,-159,-149,-146,-149,-150,-141,-125,-113,-108,-97,-76,-55,-54,-72,-83,-64,-23},
            {124,42,-176,-192,108,299,0,-387,-159,435,289,-501,551,5749,12875,14957,6470,-9777,-23304,-24814,-14482,-1106,6533,6719,3844,2378,3105,4504,5849,7957,11641,16435,20729,22407,19473,11199,-445,-10888,-15645,-13594,-7568,-1584,2326,4537,5787,5631,3167,-1322,-6102,-9379,-10551,-10059,-8530,-6491,-4665,-3835,-4073,-4413,-3729,-1987,-351,35,-815,-1895,-2252,-1643,-341,1261,2715,3539,3532,3024,2551,2230,1720,886,266,553,1669,2623,2416,969,-918,-2362,-3005,-2979,-2582,-2100,-1754,-1601,-1506,-1321,-1116,-1121,-1416,-1759,-1799,-1427,-858,-401,-204,-206,-248,-183,63,466,905,1222,1318,1208,1014,883,884,956,950,777,507,295,213,175,41,-224,-530,-763,-873,-882,-851,-866,-991,-1201,-1365,-1348,-1141,-865,-632,-450,-268,-90,9,-32,-171,-291,-285,-128,126,381,544,577,506,401,317,262,210,135,38,-61,-137,-186,-226,-274,-330,-376,-398,-399,-389,-368,-335,-304,-297,-312,-309,-251,-140,-15,85,153,195,208,192,161,138,138,156,178,189,171,121,75,95,199,299,251,-12,-388,-681,-773,-723,-668,-658,-612,-452,-230,-94,-115,-195,-182,-40,122,201,219,271,372,408,260,-60,-409,-634,-677,-569,-376,-161,26,160,228,204,47,-255,-616,-882,-937,-800,-595,-435,-345,-282,-202,-95,43,212,401,570,673,695,663,624,604,588,540,435,289,144,31,-59,-157,-279,-405,-492,-515,-475,-393,-295,-202,-131,-91,-89,-124,-183,-234,-244,-209,-160,-136,-140,-136,-91,-18,38,47,20}
        },
        {    // H-30e102a.wav
            {0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,-1,-1,1,2,2,0,1,4,4,1,0,4,9,7,0,1,12,18,9,-5,-6,-4,-18,-8,138,491,930,1159,926,265,-495,-1005,-1144,-1043,-870,-673,-396,-20,386,725,944,1045,1078,1144,1376,1831,2390,2797,2850,2573,2163,1792,1485,1186,893,670,539,416,206,-72,-294,-373,-357,-373,-484,-643,-763,-805,-784,-722,-641,-595,-667,-888,-1166,-1320,-1223,-894,-471,-86,224,496,763,1005,1165,1195,1088,890,674,516,445,424,374,233,11,-222,-392,-477,-509,-534,-576,-634,-700,-767,-824,-851,-833,-778,-716,-674,-656,-642,-606,-537,-446,-347,-257,-186,-138,-110,-96,-85,-70,-47,-19,15,51,81,99,100,83,51,9,-32,-63,-81,-98,-128,-175,-234,-293,-344,-384,-405,-404,-386,-364,-347,-331,-307,-275,-239,-205,-172,-133,-90,-51,-23,-5,9,27,48,65,73,74,69,63,55,49,45,48,55,59,53,36,7,-35,-93,-164,-234,-285,-310,-312,-296,-271,-240,-208,-181,-159,-144,-141,-156,-192,-238,-280,-306,-311,-300,-278,-256,-238,-228,-224,-226,-233,-238,-234,-214,-182,-143,-99,-53,-8,27,51,65,67,52,16,-37,-94,-143,-179,-200,-206,-201,-197,-200,-205,-203,-192,-176,-159,-139,-116,-96,-79,-61,-39,-27,-40,-72,-91,-73,-27},
            {59,122,-44,-217,-68,242,189,-242,-347,187,490,-178,-371,2805,9578,14779,11339,-2143,-18019,-25309,-19476,-6188,4581,7503,4869,2067,1887,3441,5101,6876,9868,14406,19206,21940,20327,13366,2508,-8236,-14282,-13553,-7918,-1421,3007,5081,5862,5674,3797,-95,-4892,-8744,-10546,-10451,-9168,-7271,-5295,-3974,-3800,-4331,-4378,-3194,-1337,-134,-331,-1440,-2352,-2318,-1282,397,2195,3502,3886,3457,2809,2390,2056,1454,739,593,1373,2472,2771,1719,-185,-1947,-2918,-3082,-2758,-2273,-1856,-1621,-1515,-1390,-1200,-1089,-1207,-1470,-1603,-1432,-1056,-716,-546,-493,-435,-297,-62,261,637,981,1189,1202,1055,869,771,795,849,803,621,407,287,261,206,15,-285,-568,-730,-758,-724,-726,-837,-1049,-1260,-1334,-1219,-987,-757,-578,-414,-238,-96,-62,-147,-265,-297,-184,46,302,485,542,485,378,284,228,191,143,76,-1,-71,-131,-188,-253,-319,-370,-393,-386,-356,-308,-253,-214,-214,-245,-264,-231,-140,-22,83,155,188,180,138,86,50,35,34,47,73,97,91,65,81,187,330,354,149,-225,-571,-726,-707,-647,-628,-598,-472,-271,-131,-141,-231,-244,-111,83,213,263,313,395,422,275,-48,-405,-635,-673,-557,-369,-169,1,118,174,157,33,-216,-543,-818,-912,-807,-603,-423,-316,-255,-193,-110,3,156,338,509,619,649,629,606,606,613,584,484,324,159,42,-24,-88,-195,-333,-445,-485,-457,-392,-318,-245,-182,-144,-140,-168,-211,-249,-262,-242,-200,-165,-152,-145,-112,-46,17,39,20}
        },
        {    // H-30e108a.wav
            {-1,0,0,0,1,2,2,2,1,1,2,3,2,1,1,1,2,3,4,4,4,3,2,2,2,2,1,0,0,1,3,3,0,-1,0,2,2,-1,-2,0,3,2,0,3,8,6,-3,-5,7,18,11,-5,0,21,17,-7,68,395,930,1335,1201,426,-618,-1371,-1532,-1246,-860,-568,-318,11,412,768,995,1112,1190,1302,1523,1912,2437,2915,3088,2806,2146,1356,698,325,248,358,477,456,280,71,-48,-92,-204,-474,-811,-1021,-1000,-835,-690,-634,-608,-523,-374,-225,-145,-166,-293,-503,-710,-778,-602,-197,300,728,999,1112,1111,1034,918,795,685,578,454,309,159,15,-134,-310,-505,-672,-764,-774,-743,-723,-731,-754,-775,-795,-816,-819,-778,-683,-563,-460,-397,-359,-318,-261,-192,-119,-51,4,35,40,35,38,52,60,45,11,-20,-31,-28,-28,-42,-70,-103,-145,-199,-265,-326,-369,-389,-399,-410,-421,-424,-415,-397,-375,-344,-294,-224,-149,-90,-51,-21,13,53,87,108,116,117,115,106,87,65,46,29,9,-8,-12,7,40,62,56,22,-22,-70,-127,-195,-266,-319,-345,-348,-339,-319,-284,-239,-199,-180,-185,-208,-240,-274,-303,-318,-310,-279,-237,-200,-177,-164,-156,-152,-154,-163,-167,-157,-131,-101,-76,-56,-37,-20,-13,-18,-26,-30,-34,-53,-91,-136,-170,-186,-192,-199,-209,-216,-215,-205,-188,-171,-154,-133,-108,-85,-71,-60,-41,-15,0,-16,-54,-79,-65,-24},
            {-58,132,124,-126,-238,25,286,70,-344,-224,356,345,-427,187,4621,11413,14304,7510,-7402,-21035,-23861,-14745,-1533,6592,6810,3155,902,1721,3922,5827,7765,11044,15823,20248,21398,17152,7848,-3259,-11465,-13455,-9470,-2857,2665,5487,6203,5814,4368,1399,-2819,-6972,-9690,-10549,-9985,-8559,-6656,-4809,-3767,-3873,-4480,-4401,-3103,-1307,-276,-577,-1640,-2403,-2163,-871,1036,2868,3936,3963,3319,2676,2324,1985,1407,934,1190,2175,2987,2620,977,-1058,-2481,-2944,-2756,-2370,-2050,-1861,-1762,-1655,-1470,-1279,-1251,-1427,-1608,-1538,-1189,-791,-585,-594,-654,-605,-392,-43,381,790,1072,1152,1043,854,723,726,818,861,745,505,301,256,319,312,113,-223,-528,-679,-683,-643,-672,-822,-1050,-1242,-1289,-1169,-959,-753,-580,-415,-255,-149,-143,-213,-268,-223,-59,168,366,464,445,353,258,205,185,160,105,28,-47,-106,-153,-196,-233,-262,-286,-308,-319,-300,-239,-164,-124,-145,-196,-220,-181,-95,-1,75,121,124,80,11,-47,-70,-67,-52,-25,18,55,65,75,147,290,394,311,12,-358,-607,-667,-630,-605,-591,-507,-335,-169,-124,-190,-241,-168,5,169,260,310,365,381,260,-29,-381,-629,-679,-563,-379,-205,-68,31,93,106,37,-140,-407,-672,-817,-784,-622,-435,-300,-224,-178,-128,-48,85,268,454,578,609,581,555,568,602,603,525,369,190,57,-5,-41,-116,-247,-381,-456,-455,-410,-359,-310,-260,-215,-191,-199,-228,-260,-272,-256,-219,-182,-162,-150,-121,-66,-9,18,12}
        },
        {    // H-30e114a.wav
            {-1,-1,0,0,0,0,0,1,2,1,0,1,2,1,0,0,1,2,2,1,1,1,1,0,0,0,-1,-1,0,2,1,-1,-2,1,4,1,-4,-4,-1,-1,-5,-4,5,9,-1,-13,-7,12,16,-2,-10,14,30,5,31,311,910,1525,1614,861,-458,-1633,-2098,-1843,-1280,-772,-363,82,591,1034,1286,1366,1378,1408,1531,1860,2460,3185,3654,3499,2677,1539,564,23,-145,-181,-270,-422,-519,-461,-272,-104,-116,-347,-676,-931,-1042,-1072,-1106,-1128,-1024,-725,-310,38,189,165,99,100,171,230,210,120,42,66,229,492,764,956,1020,964,837,703,602,529,438,282,48,-223,-463,-622,-700,-735,-770,-821,-879,-916,-918,-884,-830,-770,-713,-655,-596,-539,-484,-426,-352,-261,-166,-91,-44,-11,32,98,168,206,187,118,33,-27,-44,-30,-15,-25,-68,-136,-209,-268,-304,-317,-321,-330,-356,-398,-444,-482,-502,-498,-473,-430,-373,-309,-242,-178,-121,-72,-26,21,70,119,160,184,187,173,151,126,96,61,27,6,2,7,7,-1,-10,-10,-4,-4,-19,-53,-105,-170,-244,-314,-364,-389,-392,-384,-367,-342,-306,-268,-242,-238,-257,-285,-308,-314,-299,-264,-211,-151,-99,-67,-56,-58,-64,-73,-83,-90,-86,-71,-54,-51,-67,-95,-122,-139,-143,-139,-133,-131,-139,-156,-179,-205,-225,-231,-222,-202,-179,-159,-141,-126,-116,-112,-105,-89,-64,-42,-27,-16,-6,-3,-15,-39,-53,-43,-16},
            {-109,5,141,63,-169,-199,84,267,-2,-347,-137,384,232,-466,522,5202,11542,13338,5703,-8848,-20924,-22072,-12339,141,6867,5940,1882,-68,1445,4322,6535,8328,11252,15713,19738,20071,14683,4744,-5576,-11600,-11176,-5869,590,5101,6804,6496,5055,2665,-688,-4471,-7680,-9567,-10086,-9599,-8390,-6668,-4925,-3905,-3959,-4515,-4481,-3321,-1634,-578,-742,-1661,-2307,-1922,-445,1576,3313,4102,3862,3138,2594,2375,2118,1627,1320,1756,2767,3351,2600,641,-1472,-2728,-2905,-2470,-1993,-1767,-1795,-1924,-1965,-1835,-1643,-1577,-1667,-1722,-1544,-1165,-810,-642,-629,-638,-578,-414,-115,320,797,1139,1214,1043,790,638,669,814,904,816,583,374,320,374,360,161,-163,-449,-589,-609,-614,-695,-870,-1081,-1227,-1236,-1118,-946,-786,-638,-473,-306,-197,-190,-246,-267,-182,1,211,368,423,380,281,182,123,104,98,75,30,-23,-65,-91,-109,-127,-150,-182,-222,-256,-257,-212,-146,-110,-133,-192,-235,-225,-168,-91,-18,33,45,11,-48,-98,-120,-120,-101,-60,-5,35,55,103,226,379,417,234,-114,-437,-592,-597,-567,-556,-513,-387,-224,-130,-150,-208,-193,-75,82,203,277,328,341,247,6,-325,-603,-706,-620,-432,-247,-124,-58,-16,16,16,-65,-249,-491,-681,-726,-619,-440,-283,-194,-159,-139,-94,7,172,365,512,563,532,489,494,544,581,546,424,254,103,17,-19,-66,-170,-313,-428,-467,-441,-399,-369,-338,-290,-239,-218,-241,-284,-306,-290,-246,-197,-158,-127,-95,-59,-27,-7,-1}
        },
        {    // H-30e120a.wav
            {0,0,1,1,1,1,1,2,2,3,3,1,0,-1,1,2,2,1,1,2,3,2,1,2,1,1,2,4,4,1,0,2,5,3,-2,-2,4,5,-4,-10,-1,13,9,-10,-16,5,20,2,-21,-3,35,25,9,216,837,1667,2067,1451,-97,-1772,-2673,-2522,-1761,-999,-471,-17,534,1114,1527,1694,1699,1681,1762,2073,2704,3528,4132,4050,3151,1800,586,-119,-351,-392,-465,-605,-743,-833,-887,-934,-983,-1024,-1048,-1056,-1059,-1083,-1135,-1175,-1123,-930,-634,-340,-122,38,208,414,602,701,710,701,740,818,869,833,705,535,390,332,400,577,778,876,780,502,154,-134,-303,-386,-465,-594,-767,-937,-1051,-1087,-1050,-967,-870,-784,-714,-651,-584,-517,-463,-423,-383,-318,-218,-97,21,113,166,173,140,89,56,68,122,182,205,165,67,-62,-191,-291,-344,-350,-326,-304,-311,-351,-409,-462,-493,-500,-490,-468,-439,-404,-367,-329,-290,-245,-191,-131,-66,4,77,144,190,203,184,148,116,100,102,111,115,107,86,56,28,6,-7,-13,-19,-30,-49,-76,-108,-144,-183,-227,-276,-331,-386,-429,-446,-431,-389,-342,-310,-301,-308,-316,-316,-303,-275,-232,-179,-124,-75,-38,-10,8,16,14,10,11,17,21,12,-16,-61,-115,-170,-218,-251,-264,-259,-244,-228,-215,-209,-210,-219,-233,-245,-240,-212,-166,-116,-75,-46,-27,-19,-21,-27,-30,-23,-11,1,12,20,22,14,-2,-15,-16,-7},
            {-8,-101,-41,107,89,-116,-187,46,240,27,-304,-151,332,242,-400,398,4604,10580,12672,6081,-7334,-19060,-20886,-12212,-343,6378,5515,1172,-1114,625,4348,7294,8945,10886,14287,17857,18385,13501,4207,-5242,-10210,-8918,-3338,2763,6584,7517,6392,4117,1139,-2209,-5350,-7663,-8911,-9306,-9131,-8426,-7157,-5626,-4491,-4213,-4493,-4459,-3519,-2004,-885,-836,-1607,-2255,-1904,-359,1801,3608,4326,3940,3118,2585,2468,2356,1996,1747,2145,3064,3585,2844,916,-1226,-2589,-2879,-2481,-1960,-1681,-1720,-1942,-2124,-2137,-2048,-2014,-2057,-2010,-1731,-1306,-960,-804,-749,-662,-515,-339,-107,251,713,1116,1281,1173,929,740,722,839,951,927,758,563,461,444,387,188,-117,-397,-552,-596,-620,-714,-895,-1100,-1228,-1216,-1089,-933,-808,-701,-567,-412,-299,-272,-291,-266,-143,49,233,345,368,319,232,152,113,124,156,165,132,73,18,-19,-45,-70,-97,-123,-153,-189,-219,-228,-217,-218,-251,-296,-310,-264,-176,-84,-20,4,-12,-56,-104,-133,-140,-130,-100,-48,10,48,75,148,292,425,393,135,-232,-502,-577,-530,-483,-459,-396,-268,-147,-118,-172,-211,-158,-28,116,237,329,374,312,97,-237,-563,-743,-715,-531,-309,-149,-83,-74,-69,-53,-60,-143,-312,-502,-616,-590,-449,-281,-163,-116,-112,-104,-52,66,237,404,498,493,441,422,467,532,544,468,331,191,91,33,-18,-105,-238,-378,-467,-480,-443,-404,-378,-344,-289,-237,-228,-267,-317,-333,-298,-232,-161,-101,-55,-24,-6,0,1}
        },
        {    // H-30e126a.wav
            {0,0,0,0,1,1,1,1,2,2,0,-2,0,2,3,0,-2,0,2,2,1,1,0,0,1,4,5,4,1,2,7,6,-1,-4,3,10,2,-11,-9,10,17,-2,-19,-4,23,14,-23,-25,23,39,-2,115,699,1707,2478,2149,485,-1726,-3237,-3360,-2427,-1290,-493,29,561,1155,1625,1836,1863,1872,1993,2340,3026,3984,4804,4895,3950,2273,586,-510,-899,-865,-741,-693,-740,-859,-1015,-1159,-1262,-1365,-1535,-1759,-1918,-1890,-1679,-1401,-1158,-944,-694,-399,-134,30,104,168,292,487,725,976,1212,1390,1471,1433,1292,1077,821,562,354,248,253,328,407,441,405,287,80,-198,-488,-718,-843,-874,-869,-876,-908,-943,-957,-941,-897,-822,-716,-588,-461,-350,-249,-142,-33,49,71,37,-13,-30,11,99,200,273,292,247,156,49,-46,-114,-160,-194,-228,-268,-317,-375,-434,-485,-519,-534,-533,-515,-482,-436,-385,-341,-308,-284,-261,-233,-196,-148,-93,-35,14,47,65,73,79,89,106,124,137,138,128,113,100,91,82,70,54,33,6,-29,-70,-112,-151,-187,-221,-257,-291,-321,-344,-362,-375,-378,-366,-345,-329,-333,-358,-389,-404,-390,-345,-277,-194,-107,-29,26,52,56,47,37,31,37,56,79,92,79,34,-40,-129,-220,-298,-351,-378,-382,-370,-344,-310,-278,-259,-257,-266,-273,-262,-223,-161,-94,-39,-1,29,54,70,71,61,53,54,56,50,36,27,24,16,-2,-21,-24,-10},
            {66,-8,-101,-58,89,110,-67,-183,-14,210,98,-233,-217,218,314,-251,-29,3081,8588,11973,8069,-3255,-15354,-19841,-13953,-2919,4975,5554,1356,-1936,-936,3294,7465,9651,10676,12409,15049,16282,13297,5827,-2827,-8020,-7305,-2093,3884,7529,8034,6303,3480,215,-3077,-5847,-7590,-8262,-8314,-8232,-8089,-7621,-6700,-5645,-4951,-4732,-4521,-3746,-2396,-1136,-713,-1228,-1984,-2015,-818,1270,3296,4352,4221,3476,2899,2763,2724,2436,2111,2276,3000,3580,3154,1575,-427,-1916,-2475,-2336,-1996,-1831,-1951,-2227,-2424,-2404,-2264,-2211,-2297,-2326,-2099,-1672,-1296,-1114,-1021,-839,-542,-237,29,321,690,1051,1253,1236,1082,940,909,989,1086,1086,947,738,579,506,431,244,-60,-364,-548,-602,-618,-700,-876,-1086,-1228,-1233,-1118,-967,-857,-789,-711,-588,-457,-375,-350,-316,-202,-2,221,387,452,422,332,229,157,142,174,217,230,196,130,56,-14,-77,-135,-186,-229,-262,-278,-268,-240,-225,-246,-295,-329,-310,-238,-144,-66,-30,-36,-68,-99,-113,-112,-105,-88,-52,-7,29,68,158,307,419,349,61,-306,-549,-587,-510,-438,-390,-309,-184,-82,-67,-114,-140,-101,-13,95,218,341,392,281,-14,-395,-698,-797,-676,-431,-202,-89,-98,-157,-180,-150,-123,-174,-315,-473,-548,-498,-361,-216,-120,-81,-69,-50,11,130,283,406,436,380,318,336,434,528,532,435,297,181,104,43,-37,-155,-300,-437,-517,-517,-461,-398,-357,-327,-288,-254,-255,-300,-354,-365,-312,-217,-118,-42,3,20,17,7}
        },
        {    // H-30e132a.wav
            {1,1,2,3,2,1,2,2,2,1,1,2,2,0,-1,1,3,2,1,1,1,0,-1,2,6,5,0,-1,5,9,2,-5,0,11,9,-8,-13,6,21,5,-23,-15,24,33,-9,-35,10,52,5,33,538,1666,2823,2898,1255,-1484,-3771,-4388,-3377,-1773,-531,176,708,1304,1835,2089,2079,2006,2076,2449,3254,4440,5562,5892,4942,2949,766,-768,-1382,-1371,-1177,-1051,-1028,-1075,-1164,-1263,-1358,-1494,-1735,-2055,-2298,-2322,-2148,-1933,-1773,-1576,-1190,-622,-85,204,231,182,243,440,676,872,1040,1230,1448,1637,1719,1643,1404,1061,729,529,503,569,576,412,91,-267,-534,-647,-626,-547,-489,-501,-588,-713,-829,-900,-928,-928,-909,-857,-749,-586,-403,-248,-147,-90,-55,-25,0,23,55,107,175,237,269,252,186,95,15,-26,-30,-34,-75,-154,-244,-312,-356,-392,-438,-492,-541,-576,-589,-573,-529,-464,-396,-337,-285,-230,-169,-111,-70,-55,-63,-77,-83,-70,-42,-9,18,35,43,54,75,104,127,135,126,109,93,78,57,29,-1,-29,-59,-101,-156,-216,-270,-307,-326,-329,-321,-313,-308,-302,-289,-268,-251,-254,-287,-345,-408,-449,-448,-399,-314,-210,-105,-8,69,115,125,106,77,58,61,83,109,120,100,42,-48,-156,-263,-348,-402,-424,-428,-423,-409,-387,-361,-345,-340,-333,-306,-254,-189,-125,-70,-23,15,46,73,103,135,160,177,185,182,157,111,62,27,3,-27,-64,-86,-70,-27},
            {-22,55,54,-49,-96,9,115,28,-142,-109,121,180,-86,-264,13,326,20,-310,1298,5741,10343,10020,2169,-9573,-17393,-15930,-7055,1995,5147,2282,-1817,-2464,1105,6117,9556,10799,11385,12653,13862,12724,7885,856,-4648,-5539,-1783,3763,7720,8470,6533,3336,-58,-3197,-5790,-7457,-8004,-7749,-7362,-7292,-7416,-7290,-6721,-5983,-5433,-5016,-4302,-3044,-1600,-682,-684,-1273,-1627,-1062,475,2364,3744,4121,3719,3217,3082,3181,3091,2748,2576,2907,3416,3319,2173,365,-1238,-2022,-2012,-1678,-1512,-1747,-2288,-2816,-3029,-2893,-2639,-2491,-2423,-2245,-1897,-1547,-1372,-1320,-1180,-837,-370,81,467,809,1087,1238,1241,1165,1106,1117,1187,1258,1252,1119,895,683,563,492,354,88,-235,-484,-598,-634,-693,-832,-1022,-1181,-1236,-1177,-1063,-973,-933,-892,-790,-625,-458,-342,-262,-157,7,203,370,462,473,428,365,317,297,296,284,237,156,63,-18,-78,-119,-146,-164,-184,-214,-249,-271,-272,-266,-275,-301,-320,-302,-243,-160,-84,-35,-27,-53,-88,-108,-108,-95,-75,-45,-9,22,59,137,262,353,285,18,-325,-555,-583,-483,-377,-305,-224,-113,-16,14,-12,-40,-37,-4,67,193,345,415,290,-38,-435,-718,-770,-605,-340,-123,-52,-121,-236,-293,-265,-218,-240,-344,-458,-493,-424,-298,-183,-109,-67,-32,15,92,206,333,415,400,312,245,284,416,538,559,472,340,217,116,18,-87,-203,-326,-435,-496,-487,-429,-373,-347,-335,-312,-288,-294,-339,-383,-375,-301,-187,-73,11,49,44,16}
        },
        {    // H-30e138a.wav
            {1,2,2,0,0,1,1,0,0,2,3,0,-2,-2,1,2,0,0,1,-1,-3,-2,4,7,2,-1,3,9,5,-5,-4,10,15,-3,-16,0,26,17,-21,-29,14,42,4,-42,-3,68,32,-16,386,1587,3108,3645,2128,-1083,-4217,-5487,-4531,-2467,-673,341,929,1519,2097,2412,2401,2268,2282,2651,3522,4859,6202,6730,5814,3607,1031,-898,-1764,-1836,-1615,-1406,-1278,-1239,-1312,-1474,-1653,-1814,-2010,-2274,-2522,-2612,-2506,-2308,-2107,-1850,-1426,-860,-354,-85,-11,72,293,583,799,916,1044,1262,1510,1651,1625,1484,1316,1167,1055,1000,1001,990,852,527,78,-353,-661,-829,-903,-919,-885,-809,-720,-651,-622,-631,-665,-697,-686,-600,-450,-299,-223,-245,-305,-312,-220,-61,93,199,256,283,287,260,210,160,130,113,87,40,-23,-92,-165,-243,-320,-382,-421,-445,-465,-487,-509,-529,-551,-571,-573,-540,-470,-374,-273,-185,-120,-83,-72,-75,-76,-60,-24,18,47,48,25,-1,-9,9,40,64,73,73,73,74,65,39,-2,-45,-80,-103,-119,-135,-156,-184,-217,-253,-286,-308,-313,-302,-282,-257,-230,-196,-161,-143,-164,-227,-316,-401,-456,-466,-426,-342,-232,-117,-15,63,112,128,118,97,87,98,123,143,137,94,14,-92,-206,-308,-386,-434,-455,-457,-447,-428,-400,-372,-356,-360,-366,-343,-274,-177,-90,-36,-9,12,38,75,124,184,241,279,287,269,228,167,99,48,23,5,-39,-103,-140,-114,-43},
            {-12,-32,10,55,13,-71,-57,56,88,-43,-142,-20,162,86,-176,-180,154,242,-174,70,2684,7290,10192,7099,-2180,-12212,-16065,-11458,-2774,3126,2995,-683,-2944,-1107,3523,7821,9994,10643,11265,12187,12078,9402,4332,-805,-3093,-1300,3116,7145,8440,6716,3368,-12,-2724,-4869,-6586,-7642,-7784,-7254,-6731,-6698,-7001,-7125,-6820,-6291,-5763,-5078,-3913,-2342,-984,-470,-799,-1293,-1153,-66,1616,3155,3926,3827,3316,2997,3087,3297,3279,3090,3090,3369,3462,2774,1248,-489,-1656,-1943,-1648,-1328,-1376,-1835,-2465,-2953,-3145,-3126,-3061,-2982,-2754,-2293,-1734,-1329,-1183,-1160,-1043,-739,-298,193,672,1073,1326,1403,1352,1258,1187,1172,1216,1270,1245,1089,859,672,576,487,286,-35,-358,-568,-656,-714,-826,-1000,-1179,-1284,-1272,-1163,-1027,-931,-881,-825,-721,-584,-462,-367,-257,-81,153,382,531,567,508,402,304,247,232,232,219,182,128,64,-9,-86,-150,-191,-216,-239,-265,-281,-275,-256,-249,-267,-296,-308,-281,-218,-136,-64,-27,-34,-71,-113,-137,-140,-121,-88,-53,-26,6,77,192,283,236,8,-302,-522,-557,-458,-341,-258,-186,-95,-8,37,40,30,24,29,71,187,349,438,324,-8,-415,-697,-742,-571,-308,-101,-48,-154,-327,-442,-444,-390,-378,-436,-495,-472,-363,-241,-169,-142,-111,-49,35,126,228,336,407,399,325,268,304,419,523,533,447,321,205,105,6,-101,-209,-315,-408,-471,-484,-454,-415,-392,-385,-373,-355,-350,-376,-412,-414,-348,-225,-93,-1,28,15}
        },
        {    // H-30e144a.wav
            {4,1,-1,0,2,1,-1,0,1,0,-2,-2,1,2,0,-1,-1,-1,-3,-2,4,6,1,-4,1,11,7,-9,-12,6,18,1,-22,-11,24,27,-15,-37,4,49,16,-49,-22,79,70,-34,256,1479,3324,4350,3062,-529,-4525,-6585,-5837,-3369,-963,466,1182,1780,2396,2766,2751,2557,2528,2937,3937,5455,6980,7606,6605,4105,1128,-1144,-2194,-2307,-2053,-1780,-1552,-1393,-1383,-1549,-1800,-2046,-2309,-2638,-2959,-3090,-2938,-2617,-2301,-2009,-1603,-1021,-421,-48,27,-23,29,256,580,910,1219,1499,1707,1806,1802,1721,1548,1255,903,653,636,797,919,806,438,-50,-503,-839,-1049,-1142,-1144,-1102,-1065,-1037,-972,-824,-602,-374,-212,-146,-147,-164,-164,-137,-87,-17,66,144,193,206,198,196,216,254,289,302,277,209,114,19,-60,-135,-228,-348,-463,-534,-543,-516,-494,-499,-528,-559,-573,-559,-521,-468,-414,-374,-346,-321,-281,-222,-152,-86,-32,14,59,102,133,143,131,104,74,52,44,49,56,53,35,3,-39,-88,-142,-189,-215,-215,-194,-166,-150,-156,-184,-224,-259,-275,-272,-256,-235,-212,-186,-154,-116,-78,-66,-109,-210,-336,-436,-476,-457,-396,-309,-210,-110,-26,34,70,84,81,74,83,113,154,178,166,107,1,-141,-289,-403,-465,-485,-485,-472,-442,-394,-351,-334,-345,-366,-371,-338,-264,-164,-70,-7,25,44,69,101,140,191,251,296,300,264,216,172,129,81,42,25,4,-56,-145,-197,-159,-59},
            {26,11,-29,-28,27,52,-11,-77,-30,74,63,-73,-120,31,157,19,-196,-100,207,153,-203,493,3530,7738,9248,4808,-4291,-12271,-13667,-8292,-1230,2084,615,-2212,-2476,675,5060,8170,9387,9822,10558,11314,10731,7866,3489,-77,-621,2105,5996,8173,7177,3849,213,-2371,-3978,-5334,-6656,-7449,-7318,-6630,-6194,-6403,-6892,-7077,-6803,-6327,-5778,-4917,-3523,-1878,-659,-317,-646,-958,-641,445,1946,3264,3930,3896,3547,3327,3333,3307,3065,2802,2848,3140,3136,2346,888,-567,-1401,-1541,-1398,-1428,-1793,-2339,-2790,-2968,-2907,-2800,-2793,-2834,-2736,-2399,-1936,-1548,-1301,-1088,-775,-344,124,547,890,1134,1265,1294,1261,1216,1195,1219,1278,1316,1256,1077,848,662,527,361,95,-227,-492,-627,-670,-717,-827,-990,-1142,-1219,-1199,-1112,-1020,-959,-904,-805,-649,-485,-368,-291,-195,-34,172,356,458,467,415,347,301,287,290,281,242,175,98,22,-49,-111,-160,-191,-213,-234,-258,-275,-276,-264,-255,-262,-279,-284,-257,-199,-128,-73,-53,-66,-100,-138,-167,-174,-155,-120,-80,-34,42,157,260,253,76,-212,-459,-546,-478,-354,-255,-183,-102,-6,74,110,103,73,49,75,185,353,463,382,83,-313,-616,-703,-578,-348,-150,-93,-201,-398,-551,-579,-521,-478,-500,-531,-488,-365,-240,-182,-177,-156,-77,46,175,293,390,444,429,362,308,325,408,489,506,448,349,241,128,6,-114,-215,-298,-374,-441,-480,-478,-452,-434,-435,-434,-415,-398,-411,-448,-460,-399,-272,-135,-42,-4}
        },
        {    // H-30e150a.wav
            {1,3,4,1,-2,0,3,2,-2,-3,1,3,1,-2,-1,0,-2,-3,2,8,4,-4,-1,10,9,-6,-14,3,21,6,-23,-17,23,33,-13,-48,-4,61,34,-56,-48,79,111,-20,176,1403,3518,4994,3948,38,-4769,-7626,-7149,-4347,-1356,508,1401,2068,2775,3227,3196,2899,2805,3278,4449,6150,7784,8406,7278,4536,1258,-1292,-2539,-2769,-2577,-2306,-2000,-1697,-1547,-1645,-1903,-2183,-2475,-2851,-3260,-3494,-3398,-3051,-2657,-2277,-1785,-1102,-394,52,128,17,-13,148,432,766,1148,1567,1928,2120,2116,1964,1687,1287,846,560,575,797,926,727,236,-305,-689,-893,-1016,-1130,-1222,-1249,-1196,-1085,-951,-833,-763,-734,-690,-553,-299,20,299,454,473,412,355,352,400,455,468,422,341,268,238,258,293,290,214,76,-81,-222,-342,-456,-560,-629,-645,-619,-581,-555,-545,-548,-564,-585,-596,-579,-530,-458,-376,-293,-225,-183,-164,-150,-115,-45,48,144,220,258,254,219,176,142,122,101,65,15,-40,-88,-124,-152,-178,-205,-231,-247,-245,-227,-208,-201,-209,-226,-241,-248,-246,-234,-214,-189,-160,-123,-75,-22,10,-12,-103,-240,-377,-467,-491,-458,-384,-281,-162,-48,32,64,58,34,13,12,45,109,182,223,200,106,-41,-209,-364,-472,-516,-510,-486,-459,-421,-366,-314,-295,-316,-347,-346,-300,-221,-134,-53,11,57,95,133,173,206,230,252,266,253,203,143,114,120,122,91,42,5,-32,-103,-202,-254,-200,-74},
            {-15,8,30,9,-33,-27,29,46,-20,-74,-17,76,45,-85,-104,53,145,-14,-196,-60,216,107,-181,703,3755,7519,8342,3711,-4543,-11072,-11634,-6919,-1569,418,-922,-2449,-1505,1805,5426,7678,8529,9007,9814,10544,10084,7772,4361,1812,1806,4154,6706,7089,4712,1084,-1792,-3225,-4024,-5162,-6581,-7420,-7175,-6329,-5810,-6017,-6555,-6820,-6618,-6132,-5478,-4531,-3218,-1813,-785,-377,-381,-340,108,1024,2169,3138,3601,3557,3343,3315,3482,3532,3252,2825,2587,2560,2355,1623,493,-522,-1034,-1116,-1149,-1433,-1972,-2545,-2913,-2982,-2841,-2682,-2625,-2604,-2448,-2090,-1661,-1354,-1203,-1058,-756,-282,243,691,1006,1189,1260,1253,1212,1178,1169,1186,1211,1200,1106,929,736,593,488,333,70,-252,-515,-649,-687,-722,-813,-947,-1066,-1118,-1094,-1034,-986,-962,-924,-824,-659,-478,-334,-224,-106,44,205,323,368,352,318,301,311,333,337,302,229,141,63,2,-51,-104,-154,-195,-225,-250,-272,-284,-278,-260,-246,-249,-260,-258,-230,-184,-141,-116,-108,-113,-127,-143,-149,-138,-121,-110,-95,-37,87,232,291,176,-91,-375,-534,-523,-408,-285,-195,-118,-25,76,149,164,124,66,50,125,275,410,404,200,-135,-445,-597,-559,-401,-242,-182,-263,-437,-597,-651,-604,-541,-535,-566,-549,-439,-290,-191,-166,-155,-83,60,226,358,434,456,434,383,338,334,379,442,477,457,386,278,147,10,-113,-209,-281,-343,-404,-454,-478,-476,-468,-469,-481,-489,-488,-486,-484,-464,-397,-280,-145,-39}
        },
        {    // H-30e156a.wav
            {5,2,-2,-1,3,3,-2,-5,-1,3,2,-2,-2,-1,-3,-5,0,6,4,-4,-2,9,11,-6,-17,-2,19,8,-23,-22,19,35,-11,-54,-14,59,42,-55,-63,68,124,-1,176,1440,3749,5524,4628,455,-5002,-8533,-8329,-5285,-1798,458,1519,2264,3117,3759,3817,3454,3255,3745,5068,6911,8533,8981,7626,4711,1325,-1321,-2683,-3038,-2955,-2761,-2493,-2183,-1979,-1985,-2134,-2315,-2554,-2960,-3482,-3848,-3817,-3437,-2960,-2522,-1995,-1241,-403,156,236,22,-98,92,514,977,1383,1732,2002,2138,2114,1963,1717,1380,1008,738,686,790,829,612,146,-397,-849,-1144,-1291,-1318,-1256,-1165,-1111,-1119,-1152,-1156,-1096,-967,-780,-554,-321,-113,56,201,355,541,747,922,1010,985,871,728,609,531,480,428,350,233,88,-51,-157,-236,-322,-439,-564,-650,-672,-653,-638,-657,-705,-756,-788,-784,-735,-645,-539,-444,-373,-317,-255,-184,-116,-63,-22,22,77,140,199,244,264,253,213,158,109,71,37,-1,-36,-61,-79,-103,-143,-191,-232,-255,-257,-241,-218,-201,-204,-225,-249,-263,-265,-258,-237,-203,-163,-125,-83,-28,29,44,-21,-161,-320,-438,-488,-477,-422,-336,-228,-116,-18,49,72,55,17,-11,-7,32,95,160,198,171,63,-104,-274,-399,-461,-480,-480,-476,-463,-429,-374,-316,-287,-294,-311,-299,-246,-176,-112,-52,19,95,153,186,209,238,264,268,247,210,164,115,86,91,113,102,43,-24,-58,-85,-163,-285,-349,-272,-100},
            {11,-6,-15,5,27,9,-29,-21,30,42,-20,-64,-9,70,33,-81,-84,61,128,-29,-177,-33,204,78,-152,756,3595,6933,7548,3415,-3719,-9328,-10060,-6635,-2711,-1159,-1730,-2128,-708,2168,5018,6844,7769,8481,9365,10079,9833,8178,5703,3868,3820,5174,6134,5082,2118,-1073,-2913,-3368,-3666,-4764,-6331,-7261,-6972,-6012,-5399,-5589,-6184,-6521,-6330,-5774,-5037,-4096,-2918,-1702,-799,-381,-273,-109,397,1282,2330,3171,3503,3336,3024,2946,3130,3260,3085,2737,2519,2456,2199,1440,325,-655,-1144,-1230,-1270,-1515,-1938,-2351,-2599,-2660,-2626,-2611,-2640,-2596,-2328,-1827,-1282,-913,-760,-663,-452,-105,268,562,761,907,1030,1127,1183,1190,1166,1145,1138,1113,1012,825,614,458,359,239,31,-233,-460,-588,-643,-700,-804,-940,-1056,-1104,-1075,-997,-911,-836,-759,-653,-526,-410,-331,-266,-166,-14,154,279,331,327,308,301,306,307,286,238,168,94,31,-18,-65,-120,-180,-227,-252,-263,-267,-264,-243,-209,-185,-184,-200,-209,-200,-181,-166,-154,-140,-126,-120,-119,-115,-106,-101,-94,-56,40,173,259,209,6,-266,-477,-547,-486,-370,-266,-184,-95,22,140,202,174,83,12,35,166,327,400,308,70,-211,-416,-480,-420,-312,-252,-303,-457,-626,-705,-663,-575,-540,-576,-601,-528,-368,-211,-129,-100,-47,76,243,386,459,458,411,348,299,288,323,387,442,451,398,295,167,37,-75,-157,-208,-250,-308,-386,-454,-488,-499,-517,-552,-576,-563,-527,-500,-473,-396,-247,-78}
        },
        {    // H-30e162a.wav
            {-3,-3,0,1,-3,-5,-2,0,-2,-4,-4,-3,-6,-8,-2,4,1,-7,-4,8,8,-10,-21,-3,18,5,-28,-25,18,35,-15,-60,-19,57,41,-56,-66,60,116,11,248,1620,4058,5925,4998,603,-5251,-9204,-9229,-6092,-2271,330,1573,2366,3295,4133,4431,4219,4057,4556,5906,7712,9125,9231,7589,4596,1307,-1243,-2645,-3148,-3206,-3081,-2850,-2612,-2513,-2586,-2692,-2710,-2738,-2992,-3504,-3997,-4132,-3839,-3333,-2809,-2229,-1457,-553,180,471,354,133,114,398,894,1441,1895,2176,2285,2277,2177,1927,1477,941,578,566,787,906,671,125,-474,-908,-1145,-1278,-1390,-1501,-1586,-1606,-1536,-1373,-1158,-952,-794,-682,-588,-482,-340,-144,90,321,509,661,814,990,1152,1237,1209,1082,903,725,582,473,368,238,85,-56,-167,-270,-404,-565,-705,-777,-789,-784,-797,-827,-855,-873,-875,-855,-806,-727,-623,-495,-350,-207,-93,-20,22,54,89,130,171,205,219,202,159,111,81,75,78,75,57,26,-12,-51,-87,-118,-149,-182,-213,-236,-243,-236,-223,-215,-221,-236,-250,-254,-247,-232,-213,-189,-162,-130,-85,-21,37,39,-58,-233,-413,-524,-544,-499,-414,-299,-158,-19,80,113,83,18,-44,-68,-39,32,112,170,178,117,-15,-186,-336,-420,-443,-448,-466,-483,-469,-416,-349,-302,-292,-311,-328,-310,-244,-153,-70,-2,66,140,195,212,207,219,250,261,225,166,131,126,126,119,113,103,59,-22,-97,-132,-171,-284,-444,-511,-385,-139},
            {-10,4,12,-1,-13,1,22,11,-21,-19,21,33,-17,-56,-10,59,30,-69,-76,47,110,-21,-155,-37,176,79,-136,600,3058,6145,7112,3992,-2106,-7534,-9226,-7231,-4148,-2357,-2059,-1809,-407,2016,4480,6230,7263,8063,8979,9818,9943,8899,7053,5486,5020,5284,4956,3097,198,-2256,-3282,-3318,-3611,-4806,-6304,-6984,-6427,-5305,-4659,-4917,-5653,-6159,-6097,-5583,-4831,-3888,-2747,-1565,-641,-158,-15,89,434,1115,1998,2784,3196,3193,3024,2982,3085,3076,2771,2326,2056,2023,1920,1425,582,-251,-798,-1111,-1421,-1840,-2267,-2538,-2590,-2489,-2356,-2283,-2265,-2194,-1948,-1533,-1106,-829,-698,-552,-255,160,539,772,867,902,932,965,982,973,956,957,981,988,915,744,538,374,261,129,-75,-316,-505,-593,-615,-643,-711,-805,-883,-916,-894,-838,-783,-753,-732,-680,-576,-445,-328,-233,-131,-5,123,212,245,245,245,257,267,256,215,154,89,33,-12,-53,-100,-152,-196,-221,-226,-219,-207,-190,-165,-139,-126,-137,-162,-183,-187,-174,-150,-122,-97,-80,-75,-77,-80,-87,-100,-101,-57,48,163,193,73,-167,-415,-564,-585,-519,-422,-313,-186,-33,122,229,238,152,39,-4,75,234,363,368,227,0,-225,-371,-407,-361,-309,-332,-452,-604,-696,-684,-615,-576,-602,-636,-588,-425,-216,-66,-9,12,83,219,357,425,412,357,295,242,214,233,299,374,405,376,305,215,116,17,-62,-113,-162,-236,-326,-397,-438,-481,-551,-621,-650,-638,-617,-586,-496,-314,-103}
        },
        {    // H-30e168a.wav
            {1,0,-4,-4,0,2,0,-2,-2,-2,-5,-5,1,5,0,-5,1,12,8,-10,-16,3,18,0,-29,-19,22,29,-19,-51,-8,50,22,-57,-41,70,84,11,427,2024,4515,6153,4859,229,-5626,-9489,-9528,-6510,-2739,-2,1485,2468,3484,4400,4863,4904,5011,5704,7083,8660,9594,9158,7196,4253,1244,-1091,-2516,-3197,-3395,-3298,-3075,-2935,-3005,-3196,-3287,-3184,-3074,-3224,-3668,-4133,-4310,-4129,-3722,-3170,-2408,-1410,-384,318,510,335,124,134,434,964,1591,2136,2445,2493,2392,2234,1981,1554,1038,687,677,887,979,718,151,-489,-1017,-1388,-1634,-1775,-1816,-1779,-1695,-1585,-1458,-1319,-1167,-981,-747,-491,-265,-105,11,130,281,455,629,787,914,992,1015,996,964,943,934,917,857,731,540,326,131,-33,-199,-398,-611,-771,-827,-793,-742,-741,-808,-907,-988,-1014,-977,-887,-766,-636,-509,-388,-273,-170,-86,-21,30,77,121,161,194,217,223,208,174,134,99,75,58,45,34,20,-4,-38,-74,-104,-131,-157,-183,-199,-204,-208,-219,-230,-231,-224,-219,-223,-227,-219,-206,-196,-182,-140,-57,40,92,44,-116,-336,-529,-620,-597,-496,-361,-211,-53,87,165,154,76,-14,-68,-64,-7,82,169,205,161,39,-124,-280,-389,-438,-443,-445,-464,-480,-456,-387,-320,-304,-333,-355,-329,-259,-173,-89,-6,72,134,174,193,196,190,190,209,230,228,200,178,185,198,179,132,91,64,13,-86,-196,-272,-333,-436,-559,-580,-415,-145},
            {1,-7,-8,2,9,-1,-10,1,18,11,-16,-18,14,28,-9,-45,-15,42,28,-50,-67,25,87,-6,-122,-45,134,84,-100,431,2448,5276,6677,4661,-413,-5772,-8493,-7852,-5476,-3431,-2405,-1641,-205,1985,4245,5897,6839,7495,8320,9308,9929,9608,8338,6775,5597,4776,3618,1603,-889,-2849,-3639,-3632,-3786,-4626,-5731,-6238,-5762,-4789,-4173,-4338,-4988,-5512,-5564,-5213,-4645,-3882,-2856,-1664,-610,23,227,260,437,926,1659,2382,2818,2886,2781,2783,2948,3043,2830,2367,1942,1716,1528,1116,447,-249,-750,-1066,-1355,-1703,-2045,-2280,-2382,-2396,-2375,-2336,-2253,-2066,-1726,-1260,-800,-480,-319,-206,-21,247,513,700,811,897,981,1041,1035,955,841,747,698,664,590,463,329,242,194,117,-38,-241,-410,-489,-493,-480,-499,-563,-654,-750,-825,-863,-864,-833,-773,-680,-561,-438,-335,-254,-173,-74,35,124,175,194,205,216,216,191,143,86,35,-2,-26,-44,-69,-109,-158,-195,-208,-200,-182,-156,-116,-72,-47,-57,-91,-119,-127,-117,-96,-66,-35,-20,-34,-71,-116,-162,-202,-202,-130,2,104,75,-107,-360,-562,-638,-600,-499,-380,-253,-109,51,196,269,237,131,43,53,161,290,348,290,135,-63,-239,-345,-372,-360,-372,-451,-579,-686,-708,-646,-567,-540,-562,-556,-449,-260,-81,14,46,88,180,288,353,354,309,247,190,160,173,222,278,315,326,310,263,187,110,52,4,-62,-151,-244,-327,-418,-520,-603,-640,-650,-676,-695,-620,-404,-134}
        },
        {    // H-30e174a.wav
            {-5,-3,2,1,-2,-3,-1,-3,-8,-7,2,6,-1,-6,2,12,5,-12,-11,9,14,-11,-30,-7,27,14,-35,-41,17,47,-13,-69,-4,93,41,18,714,2634,5095,6183,4179,-727,-6196,-9414,-9156,-6392,-3079,-534,1149,2481,3734,4733,5268,5495,5891,6846,8276,9575,9964,8980,6771,3968,1271,-889,-2399,-3286,-3603,-3493,-3257,-3230,-3503,-3830,-3882,-3621,-3384,-3531,-4036,-4492,-4527,-4154,-3655,-3187,-2612,-1756,-729,99,457,425,330,439,801,1303,1802,2185,2396,2456,2430,2337,2121,1755,1357,1124,1109,1125,904,368,-309,-889,-1272,-1510,-1680,-1804,-1872,-1897,-1897,-1864,-1765,-1575,-1297,-961,-621,-340,-154,-42,66,214,389,544,659,752,846,929,966,938,865,789,748,749,759,730,636,493,333,163,-34,-264,-490,-657,-739,-761,-765,-784,-823,-871,-907,-907,-867,-803,-737,-671,-587,-480,-373,-292,-234,-174,-97,-12,67,137,199,243,252,226,186,156,140,128,106,72,31,-8,-41,-65,-84,-97,-104,-104,-104,-112,-131,-155,-175,-191,-201,-202,-197,-195,-207,-233,-258,-266,-254,-216,-139,-26,80,106,-3,-221,-457,-614,-647,-578,-454,-303,-136,38,180,238,192,81,-17,-44,5,93,173,206,169,59,-96,-249,-357,-413,-442,-469,-505,-532,-525,-469,-386,-326,-325,-358,-361,-292,-177,-69,6,67,125,165,171,159,157,170,180,182,193,219,242,248,248,251,235,176,93,30,-14,-88,-216,-341,-402,-430,-504,-616,-633,-454,-161},
            {-4,-1,1,-5,-9,-2,6,2,-8,-3,12,11,-10,-18,4,23,0,-36,-25,25,33,-26,-62,-4,65,19,-86,-63,87,103,-59,222,1757,4351,6274,5437,1376,-3991,-7806,-8535,-6861,-4568,-2799,-1436,161,2184,4175,5581,6311,6788,7519,8620,9663,10008,9329,7860,6109,4345,2451,308,-1787,-3236,-3737,-3661,-3741,-4348,-5131,-5413,-4926,-4108,-3686,-3994,-4712,-5246,-5261,-4853,-4256,-3543,-2649,-1609,-659,-55,163,196,315,682,1277,1939,2461,2734,2826,2890,2962,2897,2550,2016,1587,1439,1422,1216,672,-58,-718,-1197,-1545,-1825,-2025,-2112,-2110,-2079,-2055,-2032,-1984,-1867,-1632,-1265,-840,-472,-220,-29,184,425,623,722,752,786,854,929,962,937,867,777,682,580,459,316,179,90,60,47,-2,-94,-186,-242,-274,-330,-438,-580,-718,-821,-876,-886,-863,-827,-786,-727,-636,-518,-401,-303,-214,-117,-13,75,132,163,179,184,168,132,87,51,32,27,24,7,-32,-83,-125,-144,-142,-135,-124,-103,-66,-28,-10,-23,-55,-84,-94,-84,-65,-51,-54,-82,-130,-188,-243,-283,-290,-242,-136,-13,46,-28,-228,-466,-628,-657,-581,-459,-325,-171,5,172,274,272,186,83,39,88,196,287,294,201,45,-123,-265,-359,-404,-424,-467,-558,-662,-700,-636,-521,-446,-448,-471,-435,-316,-162,-30,54,105,144,189,236,264,254,210,164,142,144,162,196,249,298,307,268,214,175,140,78,-7,-90,-174,-291,-439,-557,-599,-607,-655,-727,-693,-473,-162}
        },
        {    // H-30e180a.wav
            {2,1,-2,-1,0,-3,-6,-2,5,4,-4,-3,10,15,-1,-15,-4,18,10,-22,-28,10,34,-3,-50,-25,44,40,-46,-69,42,108,-8,86,1175,3462,5747,5964,2948,-2263,-7022,-9091,-8171,-5637,-3041,-993,746,2474,4070,5197,5754,6070,6656,7762,9114,10034,9903,8575,6422,3982,1616,-523,-2283,-3425,-3817,-3667,-3466,-3611,-4078,-4481,-4471,-4088,-3729,-3760,-4176,-4637,-4800,-4579,-4092,-3429,-2577,-1565,-598,47,261,215,217,488,1028,1661,2173,2454,2565,2654,2781,2815,2564,2020,1423,1049,941,887,661,222,-309,-806,-1234,-1597,-1883,-2069,-2155,-2157,-2085,-1950,-1770,-1556,-1292,-966,-623,-351,-204,-136,-45,134,379,625,823,962,1036,1040,975,865,746,650,591,556,516,455,382,326,295,250,140,-47,-263,-444,-555,-608,-638,-672,-720,-778,-831,-861,-860,-833,-786,-720,-629,-519,-411,-318,-236,-151,-60,18,66,90,111,139,164,170,158,143,133,119,89,48,7,-31,-69,-100,-113,-103,-80,-58,-42,-32,-34,-56,-95,-128,-140,-134,-125,-124,-137,-165,-208,-256,-292,-300,-265,-180,-59,44,48,-89,-319,-529,-630,-613,-525,-405,-259,-89,82,213,263,225,130,42,26,93,189,241,212,114,-22,-170,-303,-390,-425,-449,-506,-589,-636,-599,-495,-395,-351,-360,-372,-337,-241,-111,4,74,112,146,181,193,175,149,143,151,153,155,184,241,287,291,268,246,217,153,65,-10,-72,-166,-310,-439,-490,-502,-568,-682,-697,-499,-176},
            {2,1,-2,-1,0,-3,-6,-2,5,4,-4,-3,10,15,-1,-15,-4,18,10,-22,-28,10,34,-3,-50,-25,44,40,-46,-69,42,108,-8,86,1175,3462,5747,5964,2948,-2263,-7022,-9091,-8171,-5637,-3041,-993,746,2474,4070,5197,5754,6070,6656,7762,9114,10034,9903,8575,6422,3982,1616,-523,-2283,-3425,-3817,-3667,-3466,-3611,-4078,-4481,-4471,-4088,-3729,-3760,-4176,-4637,-4800,-4579,-4092,-3429,-2577,-1565,-598,47,261,215,217,488,1028,1661,2173,2454,2565,2654,2781,2815,2564,2020,1423,1049,941,887,661,222,-309,-806,-1234,-1597,-1883,-2069,-2155,-2157,-2085,-1950,-1770,-1556,-1292,-966,-623,-351,-204,-136,-45,134,379,625,823,962,1036,1040,975,865,746,650,591,556,516,455,382,326,295,250,140,-47,-263,-444,-555,-608,-638,-672,-720,-778,-831,-861,-860,-833,-786,-720,-629,-519,-411,-318,-236,-151,-60,18,66,90,111,139,164,170,158,143,133,119,89,48,7,-31,-69,-100,-113,-103,-80,-58,-42,-32,-34,-56,-95,-128,-140,-134,-125,-124,-137,-165,-208,-256,-292,-300,-265,-180,-59,44,48,-89,-319,-529,-630,-613,-525,-405,-259,-89,82,213,263,225,130,42,26,93,189,241,212,114,-22,-170,-303,-390,-425,-449,-506,-589,-636,-599,-495,-395,-351,-360,-372,-337,-241,-111,4,74,112,146,181,193,175,149,143,151,153,155,184,241,287,291,268,246,217,153,65,-10,-72,-166,-310,-439,-490,-502,-568,-682,-697,-499,-176}
        }
    },
    {    // elev-40 
        {    // H-40e000a.wav
            {-10,-2,9,6,-5,-6,10,16,-1,-16,-2,21,11,-27,-34,10,42,6,-50,-33,40,46,-41,-74,28,87,-28,134,1455,4070,6385,5871,1490,-4626,-8468,-7606,-3448,167,676,-994,-1811,147,4073,7663,9321,8975,7324,5093,3168,2762,4624,7903,10219,9378,5243,-82,-3917,-5004,-4195,-3488,-4340,-6500,-8209,-7677,-4733,-1221,414,-842,-3786,-6177,-6622,-5373,-3582,-2145,-1276,-848,-720,-716,-570,-95,619,1269,1593,1518,1175,863,960,1643,2585,3075,2621,1463,383,-27,161,457,532,428,294,108,-238,-703,-1068,-1171,-1074,-986,-1052,-1234,-1366,-1295,-1013,-684,-535,-658,-913,-1030,-847,-437,-27,199,216,135,90,147,279,409,495,559,633,674,586,343,65,-84,-74,-50,-171,-421,-615,-580,-319,6,223,272,217,167,182,242,281,260,194,119,34,-95,-271,-438,-534,-569,-633,-800,-1038,-1223,-1238,-1071,-808,-561,-386,-258,-120,47,205,305,349,389,461,531,533,445,332,272,270,257,168,7,-169,-316,-432,-529,-605,-638,-613,-534,-418,-290,-176,-90,-25,30,72,83,59,27,22,46,63,37,-26,-86,-116,-118,-108,-93,-73,-59,-70,-114,-177,-231,-256,-243,-201,-153,-119,-106,-104,-98,-93,-109,-156,-217,-265,-282,-271,-243,-211,-186,-176,-178,-172,-142,-87,-28,16,38,46,50,58,73,91,104,106,94,72,40,-1,-42,-70,-83,-92,-108,-131,-149,-161,-178,-202,-222,-224,-215,-216,-239,-267,-275,-253,-211,-163,-113,-64,-25,-4},
            {-10,-2,9,6,-5,-6,10,16,-1,-16,-2,21,11,-27,-34,10,42,6,-50,-33,40,46,-41,-74,28,87,-28,134,1455,4070,6385,5871,1490,-4626,-8468,-7606,-3448,167,676,-994,-1811,147,4073,7663,9321,8975,7324,5093,3168,2762,4624,7903,10219,9378,5243,-82,-3917,-5004,-4195,-3488,-4340,-6500,-8209,-7677,-4733,-1221,414,-842,-3786,-6177,-6622,-5373,-3582,-2145,-1276,-848,-720,-716,-570,-95,619,1269,1593,1518,1175,863,960,1643,2585,3075,2621,1463,383,-27,161,457,532,428,294,108,-238,-703,-1068,-1171,-1074,-986,-1052,-1234,-1366,-1295,-1013,-684,-535,-658,-913,-1030,-847,-437,-27,199,216,135,90,147,279,409,495,559,633,674,586,343,65,-84,-74,-50,-171,-421,-615,-580,-319,6,223,272,217,167,182,242,281,260,194,119,34,-95,-271,-438,-534,-569,-633,-800,-1038,-1223,-1238,-1071,-808,-561,-386,-258,-120,47,205,305,349,389,461,531,533,445,332,272,270,257,168,7,-169,-316,-432,-529,-605,-638,-613,-534,-418,-290,-176,-90,-25,30,72,83,59,27,22,46,63,37,-26,-86,-116,-118,-108,-93,-73,-59,-70,-114,-177,-231,-256,-243,-201,-153,-119,-106,-104,-98,-93,-109,-156,-217,-265,-282,-271,-243,-211,-186,-176,-178,-172,-142,-87,-28,16,38,46,50,58,73,91,104,106,94,72,40,-1,-42,-70,-83,-92,-108,-131,-149,-161,-178,-202,-222,-224,-215,-216,-239,-267,-275,-253,-211,-163,-113,-64,-25,-4}
        },
        {    // H-40e006a.wav
            {0,-1,-4,-4,3,8,3,-5,-1,12,14,-2,-11,2,17,5,-21,-20,14,28,-6,-39,-11,39,25,-41,-42,41,53,-25,281,1633,3898,5562,4649,677,-4338,-7257,-6541,-3630,-1445,-1504,-2605,-2326,414,4415,7547,8645,8033,6650,5202,4169,4105,5345,7339,8621,7829,4897,1207,-1497,-2453,-2350,-2603,-4077,-6287,-7728,-7116,-4562,-1634,-154,-795,-2723,-4496,-5234,-4987,-4238,-3334,-2402,-1561,-965,-638,-400,-45,450,911,1137,1052,777,607,848,1556,2393,2816,2526,1731,945,549,541,674,728,621,362,1,-378,-676,-847,-938,-1031,-1170,-1331,-1451,-1461,-1322,-1071,-831,-728,-777,-863,-850,-709,-506,-313,-148,3,149,287,408,488,489,410,320,287,294,241,78,-90,-89,141,460,656,635,483,359,342,393,412,337,179,0,-147,-244,-302,-328,-327,-331,-401,-579,-827,-1039,-1121,-1070,-966,-880,-821,-736,-578,-351,-115,58,136,151,180,270,395,490,520,507,487,452,360,199,19,-122,-217,-313,-446,-586,-670,-659,-566,-435,-310,-211,-146,-105,-72,-39,-4,35,82,132,163,142,71,-11,-60,-69,-68,-80,-97,-95,-70,-50,-64,-121,-204,-287,-344,-358,-330,-280,-237,-215,-209,-206,-197,-180,-160,-142,-131,-125,-111,-83,-48,-27,-27,-40,-50,-56,-62,-71,-75,-68,-50,-23,12,48,68,58,24,-13,-38,-50,-60,-75,-93,-109,-118,-114,-93,-63,-44,-52,-76,-93,-85,-64,-59,-95,-165,-235,-267,-253,-220,-200,-192,-168,-110,-36},
            {3,6,-2,-5,7,18,6,-16,-13,17,23,-15,-46,-14,40,30,-39,-58,16,66,-9,-96,-26,101,30,-26,858,3339,6355,7172,3689,-2968,-8627,-9497,-5674,-991,761,-649,-2173,-927,3067,7432,9981,10240,8867,6555,4040,2644,3766,7292,10864,11373,7581,1292,-4088,-6251,-5524,-4172,-4334,-6305,-8400,-8420,-5619,-1567,959,241,-2977,-6241,-7489,-6471,-4385,-2524,-1431,-1034,-1085,-1294,-1290,-794,117,1051,1628,1737,1512,1227,1226,1764,2695,3394,3222,2169,943,302,364,641,668,435,192,21,-231,-665,-1147,-1452,-1508,-1440,-1407,-1456,-1505,-1427,-1160,-794,-540,-565,-811,-1006,-900,-484,16,351,436,355,251,225,292,398,480,528,576,622,580,367,39,-216,-268,-190,-191,-377,-626,-707,-514,-150,170,308,275,191,159,194,231,208,135,67,24,-43,-183,-369,-520,-602,-681,-844,-1087,-1289,-1317,-1134,-819,-497,-257,-109,-7,102,227,330,382,408,462,552,618,595,493,387,327,279,169,-22,-236,-404,-512,-591,-664,-713,-702,-624,-501,-371,-262,-182,-121,-65,-12,22,24,9,11,48,90,97,55,0,-27,-17,8,31,47,55,43,0,-70,-143,-195,-213,-201,-171,-145,-138,-145,-152,-154,-170,-217,-287,-349,-373,-362,-331,-293,-252,-215,-193,-184,-165,-121,-63,-18,2,8,18,37,64,92,116,126,119,103,87,71,47,17,-5,-16,-34,-75,-128,-165,-182,-206,-254,-307,-332,-325,-319,-328,-330,-298,-242,-195,-161,-112,-35,37,58,28}
        },
        {    // H-40e013a.wav
            {-2,-2,-1,-2,-5,-4,2,5,0,-4,1,10,8,-4,-7,6,13,-3,-23,-14,16,20,-13,-33,-1,36,12,-39,-23,44,28,-7,428,1839,3876,5033,3697,-157,-4440,-6491,-5418,-2855,-1269,-1533,-2266,-1505,1214,4530,6738,7260,6673,5733,4803,4138,4216,5343,6983,7821,6789,4058,949,-1149,-1849,-1895,-2400,-3865,-5752,-6874,-6332,-4288,-1950,-711,-1136,-2675,-4235,-5015,-4857,-4027,-2881,-1741,-884,-465,-391,-374,-159,282,769,1091,1158,1066,1039,1274,1752,2185,2226,1783,1129,668,591,762,898,816,512,89,-333,-666,-872,-974,-1036,-1108,-1196,-1277,-1325,-1308,-1204,-1030,-858,-759,-737,-725,-659,-531,-377,-216,-47,125,273,373,418,407,346,277,264,323,376,321,171,72,164,418,653,708,595,449,382,386,375,283,119,-64,-218,-326,-394,-433,-445,-436,-444,-523,-692,-897,-1035,-1046,-956,-846,-764,-689,-569,-385,-175,-2,99,143,175,228,294,341,347,329,318,315,284,195,66,-59,-152,-231,-332,-456,-561,-599,-553,-445,-319,-213,-140,-95,-62,-30,2,35,75,119,147,129,63,-19,-74,-90,-94,-118,-157,-182,-171,-141,-128,-157,-221,-291,-343,-361,-340,-291,-236,-199,-186,-186,-179,-159,-137,-129,-136,-142,-128,-91,-42,-1,14,1,-25,-47,-55,-49,-38,-28,-16,0,19,37,46,40,15,-24,-62,-89,-105,-124,-152,-179,-188,-174,-144,-107,-74,-54,-55,-68,-72,-57,-40,-55,-107,-162,-183,-173,-162,-165,-157,-110,-39},
            {4,-7,-1,17,16,-10,-22,5,30,4,-44,-35,29,51,-15,-72,-17,72,38,-87,-86,72,98,-61,371,2440,5819,7994,5982,-496,-7781,-10974,-8340,-2924,494,9,-2003,-1830,1738,6683,10221,11226,10241,8075,5326,3118,3203,6367,10808,12854,9962,3129,-3787,-7256,-6773,-4781,-4225,-6042,-8573,-9157,-6514,-1999,1343,1202,-2146,-6177,-8267,-7598,-5259,-2900,-1501,-1180,-1605,-2260,-2520,-1892,-411,1308,2506,2799,2317,1540,1063,1348,2379,3503,3839,3062,1753,848,734,988,974,528,-30,-402,-615,-852,-1149,-1390,-1520,-1625,-1790,-1973,-2030,-1848,-1435,-935,-568,-505,-714,-938,-880,-460,115,542,669,567,412,334,356,429,500,560,628,697,690,510,163,-195,-380,-359,-291,-362,-584,-768,-709,-385,21,278,294,165,59,58,107,109,45,-16,-21,-12,-81,-246,-429,-551,-641,-796,-1050,-1302,-1392,-1241,-905,-521,-205,7,141,245,342,423,467,480,496,538,583,585,533,468,423,376,263,56,-197,-416,-563,-660,-745,-815,-834,-769,-622,-435,-269,-169,-135,-128,-105,-61,-22,-2,20,73,145,188,168,104,47,31,52,87,121,145,152,129,71,-10,-94,-156,-180,-169,-144,-128,-131,-141,-155,-189,-256,-346,-421,-455,-448,-420,-383,-337,-281,-228,-187,-155,-117,-67,-18,13,20,18,25,48,81,112,133,144,145,134,112,83,58,45,40,29,-3,-56,-115,-163,-195,-231,-286,-352,-398,-407,-390,-371,-347,-298,-221,-147,-106,-77,-17,78,146,132,53}
        },
        {    // H-40e019a.wav
            {0,0,0,-1,-1,-3,-4,-3,2,5,1,-3,2,10,9,-3,-8,3,14,3,-17,-16,9,19,-5,-27,-6,30,21,-24,-23,31,32,-4,294,1396,3142,4358,3593,555,-3218,-5428,-4995,-2964,-1363,-1185,-1603,-1108,815,3285,5081,5769,5720,5364,4808,4191,4005,4705,6015,6873,6292,4248,1706,-221,-1126,-1455,-1996,-3196,-4797,-5965,-5877,-4408,-2372,-1010,-1082,-2344,-3847,-4709,-4628,-3814,-2656,-1511,-667,-286,-296,-402,-304,84,607,1045,1281,1353,1394,1525,1749,1921,1856,1506,1045,725,659,735,745,566,219,-198,-591,-894,-1073,-1128,-1097,-1043,-1020,-1064,-1164,-1256,-1248,-1095,-851,-631,-511,-472,-444,-378,-269,-132,25,186,326,420,457,444,401,372,395,454,474,392,249,177,262,440,555,518,391,298,288,304,267,158,10,-146,-297,-429,-516,-539,-518,-503,-547,-675,-860,-1030,-1105,-1049,-898,-729,-593,-477,-334,-149,39,174,237,258,278,309,327,310,264,221,199,183,139,54,-50,-144,-224,-313,-428,-545,-613,-595,-499,-366,-236,-135,-67,-32,-20,-17,-5,24,64,96,100,69,13,-42,-77,-92,-108,-141,-182,-205,-197,-174,-164,-187,-234,-285,-318,-322,-292,-242,-196,-176,-180,-189,-183,-162,-143,-135,-135,-126,-98,-56,-12,13,13,-8,-33,-48,-47,-32,-11,10,26,36,39,35,20,-10,-45,-73,-91,-106,-132,-168,-201,-218,-218,-199,-162,-118,-87,-79,-80,-64,-25,9,14,-8,-33,-55,-83,-118,-131,-98,-36},
            {-3,19,22,-8,-28,-1,35,16,-42,-50,18,62,4,-75,-40,67,64,-72,-114,45,127,-50,184,2042,5601,8527,7388,1063,-7218,-11996,-10390,-4750,-247,188,-1694,-1923,1388,6536,10509,11855,11079,9106,6464,4056,3631,6340,10760,13197,10717,3992,-3129,-6977,-7002,-5623,-5540,-7305,-9153,-8831,-5667,-1281,1537,911,-2661,-6703,-8707,-7928,-5543,-3304,-2196,-2192,-2773,-3356,-3345,-2270,-172,2202,3823,4084,3159,1810,918,1059,2181,3564,4247,3770,2555,1482,1049,1026,896,461,-84,-536,-915,-1297,-1610,-1718,-1660,-1656,-1864,-2195,-2400,-2279,-1825,-1213,-722,-572,-749,-967,-882,-388,280,768,894,740,517,390,407,524,665,772,838,872,840,665,329,-55,-312,-378,-368,-461,-698,-931,-956,-701,-289,58,190,128,16,-21,20,53,20,-45,-78,-87,-135,-247,-376,-469,-562,-741,-1023,-1296,-1401,-1264,-940,-548,-186,100,305,444,537,589,592,550,497,473,480,487,470,446,437,419,324,117,-156,-406,-577,-685,-772,-850,-885,-841,-715,-541,-371,-251,-195,-179,-160,-111,-44,17,75,149,239,306,303,234,148,95,89,109,137,165,185,183,153,97,26,-47,-106,-139,-148,-148,-150,-152,-152,-177,-255,-376,-484,-527,-511,-480,-460,-435,-382,-307,-232,-163,-85,1,67,86,66,38,28,39,63,90,113,127,130,131,129,116,91,68,59,54,30,-23,-83,-129,-163,-204,-268,-346,-418,-463,-466,-425,-361,-296,-237,-174,-103,-42,-4,34,101,184,220,167,59}
        },
        {    // H-40e026a.wav
            {-4,-3,0,2,0,-2,-2,-2,-3,-2,3,5,1,-2,2,9,8,-2,-5,5,10,-1,-15,-8,14,15,-10,-22,5,32,13,-27,-15,35,24,7,358,1453,3015,3916,2956,103,-3138,-4832,-4262,-2463,-1105,-884,-1091,-610,868,2703,4118,4875,5143,5038,4567,3976,3825,4472,5551,6130,5491,3747,1693,125,-727,-1222,-1929,-3147,-4603,-5548,-5281,-3784,-1912,-835,-1159,-2505,-3902,-4549,-4248,-3286,-2096,-1049,-394,-196,-290,-372,-218,175,650,1047,1304,1439,1519,1612,1736,1805,1690,1352,921,598,476,474,435,260,-45,-413,-761,-1012,-1114,-1075,-968,-895,-923,-1051,-1206,-1280,-1186,-931,-624,-401,-317,-323,-328,-277,-171,-28,136,300,434,519,560,575,577,570,542,474,349,191,80,92,219,356,391,314,212,164,166,159,105,15,-91,-211,-345,-468,-547,-578,-595,-643,-744,-882,-1015,-1085,-1047,-903,-704,-516,-364,-224,-64,110,257,343,375,381,384,379,352,299,230,161,93,19,-69,-164,-247,-312,-371,-444,-533,-607,-625,-570,-452,-305,-161,-47,21,37,16,-15,-30,-17,18,53,67,50,10,-36,-76,-107,-136,-164,-182,-183,-168,-152,-154,-179,-219,-254,-268,-255,-223,-193,-184,-198,-221,-229,-211,-176,-144,-127,-116,-97,-66,-34,-15,-11,-15,-19,-21,-19,-12,-1,10,16,21,23,19,1,-28,-58,-82,-104,-129,-154,-174,-191,-212,-229,-222,-184,-133,-94,-72,-48,-9,34,60,64,53,26,-23,-81,-113,-91,-34},
            {26,8,-24,-20,22,36,-13,-58,-19,56,47,-47,-80,17,94,2,-128,-55,125,56,-87,831,3787,7703,9212,5353,-2992,-10823,-13007,-8914,-2872,193,-595,-1895,-217,4489,9342,11822,11768,10355,8286,5809,4025,4798,8578,12768,13322,8478,676,-5565,-7687,-6929,-6394,-7699,-9605,-9596,-6522,-1807,1618,1560,-1822,-6233,-9003,-8935,-6826,-4437,-3060,-2893,-3389,-3846,-3673,-2495,-369,2070,3880,4417,3742,2515,1562,1456,2253,3433,4181,3972,3000,1968,1393,1184,921,424,-108,-467,-737,-1129,-1638,-2027,-2137,-2081,-2085,-2223,-2352,-2282,-1942,-1434,-978,-790,-913,-1122,-1072,-600,110,687,898,798,613,521,568,706,855,953,982,967,930,835,616,274,-82,-324,-433,-517,-694,-952,-1140,-1096,-793,-379,-66,36,-7,-41,12,93,108,49,-21,-62,-115,-220,-343,-420,-466,-587,-847,-1164,-1362,-1321,-1067,-711,-355,-42,219,424,569,650,665,620,544,478,439,411,377,348,352,379,365,246,27,-221,-433,-593,-724,-837,-905,-898,-803,-642,-457,-297,-203,-179,-189,-183,-135,-61,20,107,209,310,368,353,282,202,152,133,133,142,156,170,176,164,131,79,16,-44,-90,-119,-137,-148,-158,-184,-250,-361,-483,-560,-569,-536,-502,-480,-447,-384,-299,-208,-115,-17,74,131,140,115,85,68,62,60,57,55,62,82,109,124,109,73,42,35,35,14,-37,-90,-125,-149,-194,-269,-358,-431,-473,-478,-444,-375,-289,-211,-147,-86,-19,46,98,140,178,201,183,118,38}
        },
        {    // H-40e032a.wav
            {1,0,-2,-1,0,1,0,-1,0,0,-2,-2,2,4,2,-1,2,8,7,-1,-5,3,10,4,-9,-7,10,15,-3,-17,1,27,16,-17,-14,27,23,-7,223,1063,2397,3360,2871,668,-2183,-4002,-3875,-2386,-953,-491,-724,-716,113,1559,3029,4102,4665,4721,4328,3764,3516,3916,4750,5325,5027,3811,2188,771,-175,-839,-1623,-2763,-4052,-4881,-4668,-3399,-1799,-873,-1152,-2318,-3532,-4081,-3780,-2879,-1773,-809,-230,-100,-258,-396,-281,101,592,1024,1312,1446,1452,1398,1363,1371,1355,1225,975,700,491,353,215,15,-242,-503,-712,-831,-858,-826,-795,-823,-926,-1070,-1178,-1168,-1003,-722,-440,-267,-237,-291,-339,-319,-210,-16,239,497,680,742,703,628,563,511,441,334,199,76,10,18,71,111,104,67,41,36,26,-18,-87,-156,-223,-306,-407,-493,-535,-543,-562,-626,-726,-827,-894,-902,-837,-703,-527,-347,-185,-38,107,242,348,411,438,440,420,368,283,184,91,17,-48,-118,-200,-290,-379,-459,-528,-583,-619,-620,-572,-473,-337,-190,-62,22,46,15,-42,-87,-89,-49,5,43,52,36,3,-35,-72,-102,-124,-144,-163,-174,-170,-156,-148,-155,-174,-192,-200,-196,-187,-183,-197,-226,-252,-252,-219,-168,-126,-102,-89,-76,-64,-57,-51,-38,-19,-2,2,-8,-23,-35,-38,-29,-13,-3,-9,-33,-65,-93,-116,-136,-156,-179,-205,-229,-236,-212,-158,-92,-37,-2,18,30,44,64,80,74,32,-29,-70,-64,-25},
            {-11,-24,4,32,2,-53,-43,34,63,-16,-89,-27,84,49,-105,-114,75,117,-101,304,2649,6744,9735,7890,367,-8917,-13999,-12058,-5884,-928,5,-1101,-393,3523,8546,11787,12302,10960,8663,5868,3744,4382,8637,13984,15738,11250,2711,-4760,-7840,-7575,-7345,-8901,-10777,-10304,-6608,-1536,1908,1822,-1477,-5931,-9162,-9871,-8394,-6123,-4354,-3512,-3269,-3123,-2726,-1855,-401,1436,3084,3921,3761,3013,2385,2407,3109,4010,4433,4000,2950,1913,1323,1066,751,246,-220,-444,-575,-929,-1568,-2222,-2613,-2713,-2661,-2544,-2354,-2083,-1761,-1416,-1091,-903,-957,-1152,-1165,-747,-19,616,868,809,707,717,792,846,878,933,1007,1057,1055,986,808,490,89,-262,-470,-586,-747,-1015,-1294,-1394,-1201,-778,-327,-44,24,-14,-18,52,131,152,116,58,-22,-145,-290,-395,-449,-534,-741,-1039,-1266,-1278,-1073,-762,-446,-158,103,315,451,515,540,549,536,496,439,383,337,311,318,357,382,333,182,-33,-255,-459,-652,-831,-953,-973,-887,-729,-543,-368,-237,-170,-154,-148,-116,-58,6,68,144,239,321,348,309,234,168,133,131,150,171,180,175,169,173,174,148,91,22,-36,-74,-101,-129,-171,-247,-366,-501,-600,-630,-612,-587,-563,-515,-423,-303,-193,-105,-23,65,140,174,160,123,92,74,60,40,20,14,27,49,59,44,15,-4,-1,15,22,4,-31,-70,-107,-152,-213,-290,-367,-430,-466,-469,-433,-358,-261,-172,-108,-61,-7,59,115,141,144,151,165,160,111,39}
        },
        {    // H-40e039a.wav
            {-1,1,2,1,0,-1,0,1,0,-1,0,0,-1,0,2,3,1,0,3,7,5,1,1,8,10,0,-9,-2,12,13,-4,-11,6,20,5,-18,-3,30,13,4,286,1125,2304,2988,2299,199,-2222,-3524,-3111,-1699,-571,-401,-781,-809,4,1411,2825,3826,4294,4266,3879,3433,3320,3721,4365,4693,4297,3240,1947,828,1,-718,-1593,-2698,-3763,-4281,-3886,-2740,-1541,-1047,-1496,-2452,-3209,-3327,-2827,-2009,-1181,-556,-247,-238,-356,-362,-125,292,726,1052,1226,1247,1142,997,925,974,1070,1086,967,770,571,385,171,-90,-352,-547,-641,-649,-623,-617,-673,-793,-941,-1056,-1089,-1023,-870,-669,-477,-341,-276,-257,-231,-155,-10,195,423,620,730,736,659,544,425,311,199,89,-6,-69,-92,-81,-61,-53,-61,-73,-80,-92,-122,-165,-204,-231,-264,-319,-384,-424,-429,-429,-461,-534,-621,-686,-712,-693,-625,-510,-366,-216,-75,57,175,269,327,354,360,345,299,217,117,23,-48,-100,-147,-202,-269,-348,-429,-499,-546,-566,-554,-505,-416,-297,-171,-70,-15,-10,-42,-87,-119,-119,-87,-44,-10,2,-3,-14,-26,-39,-60,-94,-137,-175,-193,-185,-164,-145,-138,-141,-146,-151,-155,-158,-161,-171,-192,-214,-220,-197,-153,-112,-88,-82,-80,-74,-69,-70,-74,-74,-65,-55,-53,-59,-67,-65,-50,-29,-16,-19,-40,-72,-104,-129,-146,-161,-178,-195,-205,-197,-169,-121,-63,-10,23,32,32,42,68,88,79,41,0,-17,-9},
            {-23,29,41,-19,-69,-20,66,52,-57,-93,17,104,1,-146,-66,139,63,-140,744,3858,8213,10259,6585,-2335,-11453,-15007,-11542,-4982,-581,8,-494,1315,5805,10396,12547,11832,9350,6298,3882,3839,7463,13440,17524,15698,8062,-945,-6609,-8043,-8044,-9307,-11435,-11782,-8661,-3249,1391,2737,376,-4112,-8343,-10494,-10146,-8212,-6022,-4349,-3199,-2330,-1695,-1304,-889,-36,1310,2645,3340,3263,2906,2933,3598,4529,5021,4601,3419,2122,1290,971,785,439,9,-296,-494,-816,-1378,-2027,-2553,-2899,-3098,-3110,-2850,-2359,-1821,-1384,-1075,-901,-919,-1090,-1162,-855,-192,467,787,784,721,771,873,905,871,854,889,940,982,1013,985,807,458,39,-311,-553,-757,-998,-1260,-1445,-1437,-1183,-750,-311,-47,-1,-50,-39,75,211,276,251,158,13,-165,-324,-424,-493,-617,-826,-1042,-1146,-1086,-904,-666,-404,-133,109,276,360,393,413,432,444,442,416,362,300,283,343,441,481,392,201,-13,-205,-397,-620,-843,-987,-999,-897,-734,-552,-376,-236,-159,-137,-126,-88,-27,25,65,120,206,293,331,297,219,147,117,134,175,207,211,198,196,214,225,198,132,58,3,-31,-57,-90,-148,-250,-398,-548,-643,-665,-645,-621,-587,-512,-393,-265,-159,-71,20,112,179,200,183,145,102,60,28,4,-13,-24,-18,8,33,31,2,-23,-19,6,22,13,-14,-52,-99,-157,-219,-279,-338,-398,-448,-466,-437,-364,-262,-156,-72,-20,16,65,126,164,154,118,110,144,168,132,49}
        },
        {    // H-40e045a.wav
            {1,1,1,1,1,0,-1,0,1,1,0,0,0,-1,-1,1,3,3,1,1,5,9,7,3,4,9,8,-1,-6,2,12,8,-7,-8,9,18,3,-11,7,24,-1,28,376,1196,2170,2530,1653,-250,-2120,-2857,-2254,-1117,-462,-590,-948,-784,144,1480,2701,3507,3852,3793,3466,3132,3089,3421,3866,4009,3624,2824,1901,1044,231,-671,-1721,-2791,-3572,-3735,-3178,-2195,-1351,-1112,-1501,-2127,-2519,-2463,-2043,-1468,-915,-495,-267,-208,-202,-119,85,351,594,766,847,823,723,649,709,906,1105,1154,1017,783,547,332,107,-132,-342,-477,-529,-526,-511,-524,-599,-745,-932,-1096,-1164,-1088,-872,-576,-295,-109,-37,-37,-39,6,112,255,393,477,483,432,369,320,271,186,59,-75,-171,-211,-209,-185,-151,-112,-82,-75,-95,-131,-161,-177,-186,-206,-246,-294,-323,-321,-306,-312,-361,-440,-520,-573,-586,-556,-484,-378,-257,-137,-31,61,135,187,216,226,216,179,109,21,-56,-99,-108,-108,-125,-172,-241,-317,-381,-422,-434,-420,-383,-329,-259,-183,-117,-78,-76,-107,-152,-186,-189,-159,-110,-66,-41,-32,-28,-28,-43,-77,-125,-167,-189,-188,-171,-149,-129,-116,-111,-113,-118,-122,-123,-123,-125,-129,-132,-128,-116,-100,-87,-85,-91,-100,-106,-111,-119,-129,-136,-133,-122,-107,-94,-84,-76,-67,-54,-41,-32,-39,-60,-86,-108,-122,-134,-148,-160,-165,-159,-144,-117,-77,-29,11,34,45,59,81,100,97,70,34,8},
            {35,8,-48,-48,28,74,6,-87,-56,68,80,-70,-142,26,157,-55,-31,1673,5660,9850,10146,4022,-6221,-14410,-15552,-10186,-3476,26,385,1039,4275,8779,11551,11241,8945,6391,4593,4422,7078,12594,18066,18928,13062,3335,-4813,-8404,-9041,-9994,-12002,-12662,-9684,-3877,1382,3120,880,-3608,-8043,-10761,-11122,-9500,-6971,-4651,-3044,-1998,-1241,-763,-614,-540,-75,950,2147,2947,3193,3285,3718,4509,5130,5009,4087,2858,1872,1267,810,330,-62,-217,-273,-555,-1191,-1955,-2566,-2980,-3307,-3512,-3400,-2891,-2171,-1507,-1018,-723,-679,-903,-1165,-1062,-429,417,964,1022,842,749,794,826,779,748,812,915,962,950,925,865,681,342,-67,-428,-702,-932,-1159,-1371,-1497,-1452,-1192,-769,-339,-61,21,2,12,97,209,278,276,208,90,-62,-226,-393,-570,-754,-911,-995,-985,-899,-761,-578,-356,-129,53,168,228,260,284,308,341,380,403,390,360,361,415,479,477,380,221,44,-148,-378,-633,-843,-937,-902,-784,-637,-491,-365,-281,-243,-226,-191,-124,-49,9,51,99,158,210,230,214,177,146,146,188,253,303,308,281,255,249,248,222,167,103,50,8,-38,-100,-187,-303,-435,-557,-637,-667,-659,-624,-558,-460,-344,-235,-142,-56,35,123,183,200,180,140,99,63,28,-10,-51,-77,-73,-39,0,17,8,-8,-5,17,41,48,24,-34,-118,-207,-274,-312,-339,-378,-427,-453,-425,-343,-238,-141,-63,1,60,116,163,188,180,146,112,99,106,106,76,28}
        },
        {    // H-40e051a.wav
            {0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,-2,-2,-1,1,2,1,1,3,4,2,-1,0,3,2,-4,-5,3,11,6,-7,-8,4,10,-1,-10,1,7,-13,31,339,1002,1748,1995,1314,-97,-1453,-2002,-1652,-987,-657,-781,-929,-631,191,1242,2179,2834,3180,3230,3053,2838,2811,3041,3355,3474,3242,2706,2000,1198,300,-692,-1694,-2539,-3014,-2967,-2427,-1662,-1073,-938,-1217,-1614,-1827,-1746,-1443,-1046,-648,-325,-141,-109,-157,-176,-108,34,204,373,516,598,613,618,689,836,973,989,850,620,383,186,26,-103,-202,-271,-325,-385,-468,-586,-731,-875,-971,-979,-884,-701,-468,-240,-76,-12,-35,-93,-131,-124,-74,7,103,187,229,218,173,118,58,-12,-88,-150,-181,-192,-202,-214,-206,-164,-98,-42,-20,-36,-73,-111,-141,-163,-181,-199,-218,-239,-271,-320,-381,-439,-479,-493,-485,-455,-402,-326,-241,-158,-86,-27,17,41,46,38,23,-2,-37,-74,-96,-91,-68,-54,-65,-102,-151,-197,-231,-252,-259,-251,-235,-220,-212,-211,-212,-214,-222,-236,-245,-238,-210,-171,-137,-118,-113,-115,-121,-132,-150,-167,-176,-171,-156,-138,-121,-108,-99,-98,-99,-97,-86,-69,-57,-56,-61,-66,-67,-72,-82,-94,-104,-112,-123,-139,-155,-165,-173,-181,-188,-186,-172,-151,-133,-118,-99,-73,-45,-28,-30,-47,-69,-85,-93,-99,-107,-119,-131,-141,-150,-150,-133,-93,-42,0,24,43,68,94,98,68,23},
            {17,-55,-59,27,80,6,-97,-63,71,86,-74,-153,24,164,-59,-45,1723,5881,10243,10500,4027,-6707,-15215,-16348,-10756,-3756,149,1116,2337,5540,9131,10614,9582,7602,5994,5068,5475,8642,14559,19802,19523,12218,1780,-6090,-9220,-10016,-11414,-13035,-12063,-7258,-970,2968,2615,-1068,-5778,-9595,-11458,-11025,-8777,-5961,-3811,-2656,-1956,-1210,-525,-218,-163,138,894,1743,2251,2506,3006,3981,4996,5331,4711,3572,2594,2051,1670,1098,371,-171,-359,-422,-711,-1296,-1976,-2587,-3140,-3610,-3790,-3490,-2815,-2090,-1527,-1105,-800,-726,-921,-1100,-848,-114,672,1050,998,854,849,902,855,742,718,812,906,923,913,921,868,644,261,-153,-500,-789,-1049,-1263,-1389,-1424,-1375,-1212,-906,-514,-187,-40,-44,-62,8,156,293,347,311,213,78,-95,-311,-553,-769,-910,-958,-936,-859,-723,-527,-309,-130,-23,31,69,104,133,176,259,380,483,517,485,442,427,426,403,342,254,127,-70,-339,-622,-824,-888,-830,-703,-555,-418,-327,-306,-335,-353,-308,-206,-99,-28,13,49,94,136,159,158,138,118,126,179,262,332,357,350,342,344,331,288,227,169,116,47,-47,-153,-253,-346,-438,-527,-602,-652,-668,-637,-555,-439,-324,-234,-163,-85,6,95,160,189,182,147,98,54,20,-14,-56,-92,-96,-64,-20,5,7,3,10,26,42,50,35,-21,-120,-230,-307,-337,-345,-366,-404,-426,-401,-331,-241,-161,-98,-40,29,109,181,219,214,179,139,105,73,39,10,-5,-4}
        },
        {    // H-40e058a.wav
            {3,3,2,1,1,1,2,2,2,1,0,1,3,4,4,3,2,1,2,3,4,3,3,4,6,5,3,3,6,8,4,0,3,9,9,1,-5,0,7,3,-7,-5,5,0,1,128,510,1087,1525,1420,664,-382,-1147,-1319,-1072,-823,-797,-853,-698,-204,509,1242,1878,2375,2692,2799,2761,2730,2813,2959,3007,2848,2511,2077,1563,913,97,-810,-1640,-2205,-2372,-2124,-1603,-1072,-778,-793,-984,-1139,-1133,-976,-751,-525,-348,-257,-261,-308,-312,-227,-86,46,142,217,288,349,399,463,560,663,710,661,541,405,286,178,67,-45,-147,-235,-321,-411,-500,-578,-638,-671,-662,-595,-472,-326,-204,-138,-134,-171,-216,-246,-249,-220,-162,-92,-31,4,15,18,20,15,-15,-69,-130,-177,-208,-230,-238,-216,-152,-61,24,70,71,43,4,-36,-74,-110,-144,-181,-226,-278,-334,-385,-424,-445,-445,-424,-391,-356,-324,-289,-245,-191,-136,-91,-55,-26,-4,5,-7,-37,-67,-80,-70,-47,-27,-19,-26,-46,-76,-108,-136,-154,-166,-182,-203,-225,-239,-244,-246,-250,-255,-252,-242,-227,-213,-201,-191,-185,-182,-180,-176,-169,-163,-158,-151,-139,-118,-94,-72,-58,-53,-53,-54,-53,-51,-49,-47,-46,-44,-44,-48,-54,-62,-74,-92,-116,-139,-157,-172,-184,-193,-192,-181,-163,-146,-129,-113,-96,-77,-56,-34,-20,-20,-30,-42,-49,-59,-77,-100,-119,-134,-147,-155,-145,-111,-68,-35,-14,12,46,69,59,23},
            {-41,-44,24,70,7,-94,-72,60,95,-58,-164,-3,177,-20,-128,1400,5496,10252,11209,5140,-5988,-15529,-17576,-12092,-4370,489,1983,3056,5652,8609,9786,8886,7294,6027,5258,5786,9240,15535,20901,20267,12318,1328,-6852,-10187,-11111,-12246,-12928,-10639,-4998,968,3606,1870,-2473,-6997,-10223,-11557,-10826,-8471,-5683,-3659,-2631,-1943,-1077,-254,88,68,251,860,1480,1686,1722,2269,3555,4922,5422,4762,3531,2520,1963,1540,982,453,240,258,78,-556,-1428,-2163,-2682,-3161,-3615,-3760,-3388,-2696,-2083,-1703,-1413,-1135,-1012,-1108,-1134,-711,116,854,1101,961,833,901,1008,979,874,843,891,904,858,846,897,883,666,269,-163,-538,-868,-1167,-1380,-1450,-1401,-1301,-1161,-940,-639,-354,-204,-201,-232,-162,45,297,463,477,371,209,13,-229,-502,-730,-842,-850,-822,-793,-720,-553,-327,-140,-53,-37,-29,-5,23,69,174,347,516,595,565,488,433,408,380,330,258,149,-33,-297,-579,-775,-824,-748,-616,-483,-380,-324,-327,-366,-387,-347,-255,-157,-89,-49,-16,20,59,93,117,123,118,121,159,226,293,333,357,386,418,426,395,340,281,215,117,-18,-167,-297,-393,-462,-517,-570,-622,-653,-635,-558,-442,-330,-247,-183,-114,-35,46,116,167,186,165,117,69,36,6,-39,-82,-91,-57,-14,-3,-22,-34,-11,30,56,53,25,-25,-105,-204,-289,-329,-331,-331,-354,-383,-379,-326,-248,-178,-129,-83,-21,62,144,201,220,207,176,139,95,43,-8,-40,-39,-17}
        },
        {    // H-40e064a.wav
            {4,3,1,0,1,1,2,2,3,3,2,2,2,3,3,3,3,3,2,2,2,3,3,1,1,3,6,5,3,3,4,4,2,3,6,8,2,-6,-7,0,3,0,0,8,9,-5,17,181,532,943,1142,920,338,-297,-682,-762,-717,-734,-809,-775,-502,-25,519,1026,1488,1920,2288,2525,2599,2549,2436,2301,2160,2025,1903,1756,1498,1031,333,-489,-1226,-1654,-1665,-1331,-869,-497,-312,-265,-261,-265,-304,-398,-504,-557,-534,-466,-397,-344,-304,-279,-277,-281,-254,-173,-62,37,107,168,249,350,447,505,501,425,287,116,-48,-168,-226,-228,-197,-163,-158,-196,-261,-319,-340,-321,-284,-251,-235,-241,-263,-295,-323,-343,-353,-356,-341,-300,-234,-160,-101,-68,-62,-80,-125,-188,-245,-273,-264,-228,-180,-120,-43,43,118,156,151,114,64,9,-49,-111,-171,-225,-271,-314,-355,-389,-409,-411,-403,-389,-373,-352,-328,-299,-263,-211,-142,-70,-15,8,3,-16,-39,-63,-86,-101,-97,-76,-52,-39,-41,-50,-61,-72,-87,-108,-133,-158,-181,-201,-217,-227,-234,-239,-246,-253,-256,-250,-240,-232,-228,-228,-224,-214,-199,-186,-175,-163,-145,-120,-92,-66,-49,-46,-58,-80,-97,-98,-81,-55,-31,-17,-10,-9,-12,-23,-42,-65,-91,-117,-145,-168,-179,-175,-160,-145,-136,-135,-135,-133,-125,-106,-78,-46,-22,-13,-16,-24,-34,-51,-78,-110,-139,-160,-172,-176,-169,-149,-119,-90,-66,-47,-30,-14,-3},
            {-58,16,78,28,-87,-100,31,114,-12,-171,-68,169,64,-194,874,4663,9892,12072,7003,-4420,-15525,-19131,-13897,-5085,1018,2795,3216,5115,7973,9458,8699,6913,5489,4972,6069,9995,16410,21649,20846,12672,1220,-7665,-11585,-12440,-12629,-11847,-8357,-2449,2757,4139,1381,-3358,-7797,-10848,-12093,-11211,-8478,-5231,-3023,-2240,-1962,-1280,-337,151,43,-31,419,1098,1449,1534,1999,3150,4384,4788,4151,3128,2430,2082,1648,988,490,504,794,758,104,-902,-1860,-2666,-3384,-3868,-3804,-3157,-2347,-1847,-1715,-1680,-1593,-1564,-1616,-1460,-807,172,939,1150,992,882,970,1084,1073,1008,1013,1050,1001,875,809,845,839,637,257,-157,-521,-864,-1203,-1455,-1529,-1450,-1327,-1210,-1037,-755,-439,-255,-278,-396,-404,-197,138,424,551,534,426,233,-63,-410,-682,-784,-744,-682,-664,-647,-550,-373,-201,-110,-97,-109,-106,-75,1,143,339,527,629,618,532,430,347,290,247,200,111,-58,-298,-542,-703,-733,-653,-520,-388,-292,-254,-281,-346,-397,-393,-332,-247,-170,-113,-74,-47,-22,8,42,69,84,107,161,240,310,345,361,387,422,436,413,371,336,295,209,60,-119,-277,-388,-460,-513,-558,-599,-629,-628,-578,-479,-358,-254,-182,-132,-80,-17,51,112,150,160,148,124,92,48,-11,-62,-78,-53,-21,-18,-46,-65,-45,4,40,33,-11,-68,-124,-175,-217,-244,-258,-277,-312,-350,-362,-332,-276,-219,-173,-121,-48,41,122,170,183,171,150,124,91,47,-2,-40,-52,-38,-12}
        },
        {    // H-40e071a.wav
            {3,3,2,1,1,1,2,2,3,3,3,2,2,3,3,3,3,3,3,3,2,1,1,1,0,0,2,4,4,3,3,3,2,0,0,2,5,3,-2,-3,3,8,3,-3,0,5,-2,-1,83,311,631,856,801,452,0,-328,-454,-482,-545,-650,-682,-533,-196,258,746,1206,1572,1792,1865,1867,1878,1912,1915,1853,1766,1723,1728,1685,1462,994,338,-341,-834,-981,-766,-343,50,245,234,121,-10,-151,-323,-501,-621,-650,-618,-575,-544,-519,-506,-518,-546,-545,-483,-377,-274,-195,-110,18,181,330,414,416,343,213,57,-73,-127,-86,25,149,233,247,184,63,-77,-191,-257,-284,-297,-317,-343,-371,-394,-417,-437,-451,-452,-438,-408,-364,-312,-261,-219,-195,-191,-204,-228,-251,-260,-251,-223,-182,-128,-58,28,118,193,230,220,166,85,-5,-90,-162,-221,-265,-297,-322,-344,-365,-381,-389,-385,-374,-357,-336,-304,-256,-193,-123,-63,-27,-19,-34,-58,-83,-106,-128,-144,-148,-137,-119,-104,-96,-93,-86,-71,-55,-43,-45,-65,-99,-138,-172,-195,-206,-212,-217,-224,-234,-245,-255,-261,-264,-262,-256,-244,-230,-215,-200,-187,-172,-154,-133,-113,-97,-91,-95,-104,-109,-100,-78,-48,-17,9,23,25,18,5,-12,-36,-64,-91,-112,-126,-134,-141,-145,-148,-149,-148,-144,-134,-121,-105,-85,-60,-38,-28,-33,-45,-58,-75,-102,-136,-163,-178,-187,-195,-198,-185,-158,-132,-116,-98,-64,-22},
            {-54,45,91,-6,-125,-75,96,113,-94,-196,34,217,-67,-16,2285,7392,12128,11042,1709,-11429,-19777,-18099,-9164,-487,3150,3189,3780,6375,8835,8961,7171,5405,4845,5810,8939,14573,20560,22305,16599,5315,-5765,-12078,-13565,-12809,-11133,-7752,-2404,2747,4696,2522,-2040,-6654,-10131,-12116,-12124,-9860,-6250,-3212,-1970,-1972,-1828,-1019,-238,-144,-395,-194,578,1283,1510,1674,2387,3515,4241,4036,3230,2504,2063,1610,1008,615,782,1259,1374,773,-247,-1210,-2012,-2822,-3578,-3878,-3471,-2644,-1951,-1651,-1596,-1604,-1707,-1914,-1944,-1433,-419,584,1080,1068,922,919,1014,1062,1072,1135,1224,1195,1008,811,746,762,679,406,26,-346,-695,-1050,-1364,-1529,-1509,-1392,-1284,-1168,-953,-633,-358,-287,-402,-498,-386,-79,247,448,517,514,434,213,-145,-506,-707,-715,-639,-596,-588,-538,-405,-249,-153,-142,-165,-166,-123,-34,108,308,521,667,686,587,441,312,223,160,99,20,-104,-284,-487,-637,-669,-581,-434,-298,-211,-180,-204,-274,-358,-408,-398,-344,-279,-219,-160,-99,-45,-10,9,24,46,83,144,230,322,394,429,434,422,399,365,332,310,288,234,125,-22,-171,-293,-387,-460,-516,-556,-587,-607,-599,-542,-440,-324,-227,-158,-102,-42,21,81,128,155,160,147,124,89,36,-26,-64,-55,-15,6,-23,-73,-86,-41,19,36,-8,-79,-137,-169,-183,-189,-194,-209,-246,-295,-331,-329,-295,-254,-217,-175,-107,-12,87,159,187,178,151,119,79,25,-34,-75,-80,-52,-18,0}
        },
        {    // H-40e077a.wav
            {0,0,0,0,1,1,1,1,1,1,2,3,3,2,1,1,2,2,1,0,-1,-1,-1,-1,-1,-1,0,1,1,1,-1,-1,0,2,1,0,-1,1,3,3,2,2,2,0,-4,-6,-2,1,-1,23,122,314,529,631,520,236,-70,-256,-308,-313,-343,-362,-278,-49,257,533,712,798,827,841,891,1033,1285,1581,1813,1914,1914,1891,1879,1829,1655,1317,872,447,176,124,238,372,379,216,-39,-260,-380,-428,-467,-535,-625,-717,-794,-839,-837,-795,-749,-734,-743,-733,-668,-557,-431,-306,-167,-9,140,225,221,157,94,85,143,250,377,495,576,600,554,436,264,68,-115,-255,-340,-383,-408,-443,-495,-550,-581,-571,-530,-490,-475,-485,-498,-492,-461,-410,-349,-289,-246,-229,-237,-248,-243,-216,-175,-125,-60,23,115,193,234,231,193,134,67,-3,-70,-132,-191,-246,-291,-318,-325,-320,-318,-325,-334,-332,-314,-286,-258,-231,-196,-154,-113,-89,-88,-106,-134,-165,-194,-215,-226,-228,-224,-212,-185,-142,-87,-30,20,56,69,54,14,-37,-87,-127,-158,-184,-208,-228,-246,-260,-271,-281,-289,-293,-290,-283,-274,-265,-253,-236,-213,-191,-174,-161,-150,-138,-126,-113,-97,-74,-45,-14,12,28,33,33,32,27,16,-1,-18,-34,-54,-85,-121,-149,-161,-161,-155,-146,-134,-121,-115,-113,-108,-96,-86,-84,-87,-90,-93,-105,-124,-145,-163,-181,-202,-215,-213,-202,-198,-197,-174,-114,-38},
            {-38,80,92,-59,-158,-20,168,78,-195,-178,176,222,-195,458,4167,10058,13104,8002,-4717,-17332,-21148,-14466,-3771,3107,4179,3313,4361,6977,8362,7372,5543,4756,5582,8110,12707,18576,22291,19694,10071,-2289,-11525,-14933,-13906,-10884,-6761,-1630,3194,5338,3633,-687,-5370,-9104,-11611,-12482,-11018,-7502,-3790,-1871,-1940,-2437,-2008,-921,-317,-555,-850,-449,439,1148,1562,2154,3106,3879,3867,3181,2453,1997,1551,901,408,590,1336,1875,1601,668,-362,-1249,-2162,-3114,-3672,-3433,-2591,-1804,-1510,-1586,-1708,-1804,-1974,-2109,-1862,-1082,-91,599,798,743,738,836,927,979,1069,1206,1266,1154,949,805,751,664,440,134,-138,-364,-639,-1001,-1336,-1487,-1434,-1308,-1212,-1108,-904,-634,-462,-486,-595,-563,-293,88,380,505,522,480,342,70,-260,-493,-545,-478,-421,-432,-463,-445,-368,-286,-243,-240,-242,-212,-131,12,213,439,619,679,595,419,244,139,104,88,43,-55,-201,-372,-522,-591,-544,-402,-238,-124,-91,-130,-208,-294,-361,-395,-403,-394,-366,-306,-210,-103,-21,14,15,11,26,75,158,263,368,446,482,472,426,370,330,317,311,270,170,30,-110,-226,-323,-405,-462,-482,-483,-499,-542,-575,-549,-455,-332,-226,-147,-77,-2,70,122,148,153,146,131,107,71,26,-18,-40,-33,-14,-12,-37,-64,-66,-37,-10,-16,-63,-124,-168,-176,-152,-123,-124,-173,-252,-318,-337,-312,-272,-235,-193,-129,-43,49,125,172,182,158,111,54,-5,-62,-105,-117,-91,-44,-7,4}
        },
        {    // H-40e084a.wav
            {1,2,1,0,0,1,3,3,2,2,3,4,4,2,1,1,1,1,1,0,0,-1,-2,-1,0,1,1,1,1,1,1,1,2,4,4,3,0,-1,2,6,7,5,4,4,2,-3,-5,-2,0,-3,1,48,169,338,472,474,318,73,-131,-195,-108,58,198,228,129,-46,-193,-216,-81,167,444,692,926,1195,1523,1865,2125,2236,2209,2130,2086,2090,2060,1880,1496,975,469,113,-56,-111,-165,-278,-435,-571,-632,-619,-580,-583,-677,-849,-1028,-1125,-1094,-964,-816,-714,-665,-632,-575,-482,-362,-233,-112,-19,38,70,112,201,350,536,706,809,822,759,659,548,426,273,81,-130,-314,-435,-489,-507,-529,-579,-646,-698,-705,-663,-593,-533,-504,-505,-514,-506,-470,-409,-340,-278,-234,-206,-189,-175,-155,-122,-77,-23,31,82,127,159,173,166,147,122,92,46,-21,-102,-181,-243,-281,-297,-297,-290,-284,-283,-285,-284,-278,-269,-262,-255,-245,-226,-199,-172,-160,-170,-201,-242,-281,-308,-312,-288,-234,-161,-82,-8,58,112,146,151,123,68,0,-67,-125,-169,-200,-221,-238,-256,-274,-290,-303,-308,-306,-299,-288,-274,-260,-249,-241,-232,-218,-196,-174,-154,-137,-116,-91,-65,-42,-17,11,36,48,46,40,40,42,36,17,-10,-42,-76,-108,-131,-143,-146,-145,-141,-134,-125,-120,-120,-122,-124,-125,-123,-116,-104,-97,-102,-117,-130,-142,-163,-192,-212,-208,-195,-196,-208,-196,-133,-45},
            {-33,99,93,-87,-173,13,207,54,-254,-166,258,232,-269,631,4912,11025,13221,6457,-7384,-19390,-21168,-12599,-1444,4632,4721,3353,4146,6369,7369,6431,5143,5051,6505,9625,14603,20056,22196,17429,6261,-6208,-14302,-16010,-13159,-8359,-2945,2262,5682,5677,2291,-2591,-6990,-10154,-11990,-12006,-9714,-5934,-2787,-1815,-2462,-2893,-2163,-1061,-752,-1199,-1350,-605,527,1297,1717,2320,3197,3771,3581,2884,2232,1749,1167,507,285,836,1710,2051,1506,493,-439,-1226,-2081,-2903,-3234,-2842,-2083,-1531,-1398,-1489,-1623,-1842,-2153,-2272,-1853,-935,15,543,606,489,443,505,624,799,1024,1203,1216,1071,913,845,805,651,358,50,-161,-316,-544,-870,-1168,-1300,-1278,-1225,-1200,-1131,-944,-713,-601,-652,-704,-559,-205,182,431,528,548,500,318,-6,-342,-519,-491,-363,-275,-274,-316,-342,-337,-322,-318,-325,-324,-284,-172,22,268,497,628,613,469,274,119,53,57,71,43,-46,-182,-331,-444,-478,-418,-300,-183,-120,-128,-186,-258,-311,-333,-338,-356,-394,-420,-387,-279,-136,-19,35,37,23,25,56,122,222,343,452,507,493,433,378,357,354,325,238,108,-27,-144,-251,-355,-438,-470,-451,-425,-439,-494,-543,-538,-467,-361,-256,-165,-81,1,78,139,176,183,163,126,82,41,5,-18,-25,-14,0,-1,-24,-56,-77,-78,-71,-77,-103,-141,-166,-157,-115,-72,-76,-149,-266,-365,-391,-345,-265,-190,-126,-57,23,97,145,158,142,105,52,-8,-62,-99,-116,-117,-103,-75,-41,-12}
        },
        {    // H-40e090a.wav
            {1,1,1,1,1,2,3,3,3,3,3,3,3,2,2,2,2,1,0,0,0,0,-1,-2,-2,-1,1,2,2,2,2,2,4,4,4,3,2,2,2,3,4,6,6,4,2,1,-3,-9,-11,-8,-4,-1,18,82,195,315,376,358,312,316,378,407,288,-1,-360,-638,-744,-678,-481,-181,206,637,1032,1319,1487,1600,1746,1979,2285,2590,2809,2879,2777,2496,2040,1432,747,115,-332,-534,-539,-462,-418,-465,-596,-760,-890,-937,-905,-853,-858,-946,-1060,-1098,-1000,-792,-568,-418,-369,-382,-395,-366,-295,-206,-118,-21,111,292,506,707,850,911,895,826,727,612,484,340,176,-8,-204,-392,-548,-647,-684,-678,-666,-676,-708,-739,-741,-703,-633,-552,-480,-430,-404,-393,-379,-344,-282,-210,-152,-124,-118,-115,-103,-79,-48,-9,38,92,143,180,202,204,177,118,38,-40,-98,-138,-171,-203,-226,-234,-234,-244,-270,-303,-324,-326,-317,-311,-308,-304,-293,-277,-263,-256,-255,-262,-277,-296,-303,-281,-226,-152,-76,-6,59,115,152,156,128,79,17,-49,-110,-154,-178,-190,-207,-234,-262,-281,-286,-285,-282,-278,-270,-258,-249,-249,-255,-256,-244,-216,-184,-156,-135,-115,-94,-72,-49,-22,7,32,46,50,51,54,51,36,8,-25,-60,-93,-119,-131,-131,-130,-134,-141,-142,-137,-132,-130,-127,-122,-119,-116,-112,-103,-97,-104,-119,-130,-134,-143,-162,-176,-173,-167,-182,-211,-210,-147,-51},
            {-44,111,111,-91,-192,16,234,63,-284,-189,295,282,-321,443,4716,10980,13310,6487,-7559,-19676,-21268,-12243,-607,5661,5440,3302,3217,4937,6075,5755,5158,5556,7303,10571,15426,20306,21490,15759,4029,-8396,-15804,-16213,-11673,-5384,570,5033,6853,5267,970,-4067,-8105,-10602,-11610,-10906,-8367,-4962,-2531,-2130,-2946,-3288,-2508,-1511,-1344,-1818,-1863,-942,400,1389,1944,2472,3071,3373,3153,2671,2257,1838,1187,505,365,978,1797,2033,1459,482,-465,-1322,-2126,-2643,-2557,-1952,-1348,-1179,-1389,-1643,-1784,-1924,-2108,-2119,-1716,-967,-224,209,306,237,161,158,272,515,817,1037,1088,1018,943,907,836,649,376,136,-11,-139,-367,-697,-988,-1112,-1095,-1071,-1099,-1107,-1011,-861,-785,-804,-778,-556,-167,215,448,537,548,489,309,13,-288,-460,-456,-341,-219,-160,-177,-241,-308,-353,-382,-415,-442,-409,-262,0,301,535,620,542,353,151,25,7,60,109,94,7,-121,-244,-324,-341,-296,-222,-162,-153,-195,-261,-313,-329,-317,-308,-330,-377,-412,-388,-292,-162,-58,-19,-28,-39,-15,48,141,252,373,474,517,491,430,392,396,403,359,247,102,-34,-151,-265,-375,-454,-474,-446,-413,-414,-448,-480,-478,-436,-369,-289,-200,-103,-8,73,134,174,187,167,121,72,40,25,13,1,1,19,33,13,-42,-100,-127,-119,-107,-118,-151,-179,-171,-121,-61,-45,-107,-232,-353,-399,-348,-242,-137,-63,-7,48,107,152,166,142,87,15,-56,-109,-139,-146,-134,-107,-70,-34,-9}
        },
        {    // H-40e096a.wav
            {0,0,0,0,0,0,1,1,2,2,2,2,2,2,1,0,-1,-1,-1,0,0,-1,-2,-3,-3,-3,-2,-1,1,2,2,0,-1,0,2,3,4,4,5,3,0,-3,-2,0,0,-3,-5,-5,-4,-8,-11,-6,4,7,14,85,296,635,952,1026,731,156,-453,-864,-1002,-929,-736,-465,-131,226,546,794,985,1161,1346,1549,1783,2075,2436,2814,3088,3125,2850,2305,1633,1012,548,236,-4,-243,-477,-653,-737,-761,-792,-881,-1025,-1172,-1256,-1226,-1072,-843,-632,-529,-551,-625,-636,-520,-308,-93,33,39,-46,-159,-230,-205,-64,168,431,663,820,887,879,821,736,630,493,313,102,-105,-270,-388,-483,-581,-683,-764,-799,-788,-750,-711,-684,-667,-648,-614,-558,-478,-389,-313,-266,-248,-242,-229,-206,-178,-153,-134,-116,-95,-66,-21,39,105,152,167,152,127,102,76,42,3,-30,-52,-66,-82,-107,-140,-180,-227,-281,-335,-381,-409,-413,-396,-368,-342,-327,-322,-321,-319,-308,-289,-267,-247,-227,-200,-163,-122,-81,-44,-11,13,19,7,-17,-38,-49,-55,-61,-69,-85,-113,-154,-197,-227,-238,-233,-223,-214,-211,-216,-229,-247,-262,-271,-270,-259,-237,-208,-175,-142,-110,-83,-67,-57,-44,-22,6,27,38,42,40,26,-3,-40,-73,-99,-121,-143,-158,-162,-159,-156,-152,-145,-137,-131,-127,-118,-104,-93,-92,-92,-89,-86,-93,-103,-105,-100,-105,-126,-146,-151,-156,-188,-236,-244,-174,-61},
            {-71,100,147,-50,-218,-55,229,155,-232,-284,200,397,-211,-114,3197,9410,13384,8993,-3948,-17509,-21970,-14768,-2600,5484,6281,3534,2224,3476,5130,5518,5208,5581,7275,10391,14874,19509,21104,16341,5301,-7360,-15566,-16372,-11405,-4421,1717,5769,7121,5391,1112,-4015,-8153,-10476,-11093,-10204,-7944,-5022,-2837,-2360,-3080,-3527,-2926,-1946,-1658,-2101,-2277,-1461,-25,1163,1795,2237,2774,3190,3169,2786,2344,1910,1349,767,603,1084,1807,2067,1562,590,-415,-1288,-2019,-2443,-2327,-1736,-1108,-869,-1060,-1431,-1780,-2071,-2259,-2185,-1727,-1009,-348,3,34,-82,-158,-96,108,388,650,820,888,904,920,935,894,753,528,297,123,-15,-201,-475,-766,-963,-1034,-1046,-1059,-1049,-976,-881,-864,-927,-923,-695,-261,196,500,619,616,526,330,40,-250,-424,-436,-337,-223,-168,-193,-271,-352,-404,-429,-448,-457,-410,-258,-4,283,507,595,531,358,161,25,-10,29,77,79,18,-79,-173,-233,-244,-213,-171,-155,-190,-264,-336,-366,-348,-308,-290,-318,-378,-427,-418,-335,-209,-98,-50,-59,-76,-48,41,170,307,425,498,510,467,408,381,394,409,376,282,152,17,-117,-253,-380,-471,-505,-492,-462,-442,-437,-431,-410,-374,-330,-280,-216,-137,-52,24,83,129,157,157,129,95,78,73,60,32,8,6,13,-6,-60,-117,-138,-124,-109,-127,-172,-209,-205,-154,-82,-39,-68,-169,-287,-351,-325,-236,-142,-75,-28,25,88,143,163,137,75,1,-63,-107,-129,-133,-119,-89,-52,-21,-5}
        },
        {    // H-40e103a.wav
            {3,3,2,2,2,2,2,3,3,4,4,3,3,3,3,3,3,2,2,2,2,1,1,0,0,0,1,2,2,2,1,1,2,3,3,3,5,7,7,4,2,2,2,0,-4,-3,1,2,-4,-6,2,9,3,19,141,417,767,984,875,425,-175,-675,-931,-951,-808,-555,-218,153,484,725,877,973,1044,1129,1300,1641,2158,2709,3059,3030,2624,2024,1464,1088,889,759,597,376,143,-56,-231,-438,-712,-1012,-1242,-1329,-1281,-1166,-1063,-998,-948,-865,-717,-514,-303,-145,-79,-86,-95,-32,118,288,370,298,106,-94,-188,-123,73,332,587,778,866,832,699,514,319,133,-46,-214,-355,-452,-508,-545,-584,-632,-683,-725,-748,-744,-708,-647,-580,-524,-482,-442,-388,-321,-255,-207,-186,-186,-196,-201,-183,-134,-62,10,58,77,76,65,48,32,24,30,47,60,64,59,48,26,-15,-71,-128,-176,-217,-261,-305,-341,-362,-373,-383,-393,-393,-376,-345,-313,-288,-270,-254,-238,-223,-206,-183,-153,-126,-113,-118,-133,-145,-149,-146,-135,-111,-77,-44,-22,-17,-25,-43,-69,-100,-125,-135,-133,-128,-127,-134,-149,-174,-207,-241,-266,-277,-273,-253,-221,-185,-155,-134,-117,-99,-81,-65,-48,-24,4,28,40,37,24,-2,-38,-77,-111,-137,-159,-174,-178,-173,-166,-162,-157,-146,-130,-116,-102,-82,-60,-46,-47,-51,-49,-46,-54,-68,-70,-63,-68,-97,-127,-138,-145,-180,-236,-253,-186,-66},
            {-101,43,160,39,-188,-162,135,247,-75,-348,-36,419,105,-438,1226,6483,12201,11908,2172,-12278,-21356,-18612,-7219,3495,7029,4610,1778,1875,3801,5060,5114,5291,6736,9596,13594,17943,20402,17764,8710,-3756,-13654,-16463,-12315,-4982,1649,5772,7150,5835,2083,-2972,-7512,-10182,-10802,-9888,-7924,-5417,-3281,-2470,-2990,-3706,-3499,-2490,-1773,-1975,-2469,-2194,-930,557,1521,1985,2392,2875,3160,3047,2652,2151,1572,993,739,1095,1844,2323,2013,997,-234,-1277,-1997,-2337,-2219,-1704,-1109,-803,-907,-1252,-1625,-1941,-2172,-2215,-1941,-1359,-678,-177,-12,-130,-325,-380,-205,126,455,670,773,823,861,890,892,848,738,558,339,124,-84,-315,-571,-794,-929,-986,-1011,-1015,-971,-894,-864,-924,-977,-849,-473,27,450,681,733,650,444,130,-208,-444,-501,-410,-278,-203,-218,-296,-387,-457,-497,-510,-483,-391,-217,23,274,474,567,530,385,198,53,2,28,68,69,21,-49,-108,-143,-156,-150,-141,-155,-216,-316,-407,-436,-390,-315,-277,-306,-382,-450,-461,-396,-272,-137,-47,-28,-51,-53,14,150,310,440,506,503,454,398,368,371,385,379,332,240,108,-48,-207,-350,-462,-532,-553,-525,-469,-416,-382,-359,-332,-298,-266,-233,-182,-104,-19,45,83,107,123,125,109,92,88,90,79,50,18,-5,-32,-76,-126,-154,-150,-138,-148,-184,-219,-215,-162,-86,-32,-39,-108,-203,-272,-286,-250,-190,-126,-64,-2,56,104,129,122,84,31,-16,-44,-60,-73,-84,-83,-64,-34,-9}
        },
        {    // H-40e109a.wav
            {3,3,2,2,2,2,2,2,3,4,4,3,2,3,3,3,2,2,2,3,3,3,2,1,1,3,4,3,1,-1,0,1,1,0,1,3,4,2,1,5,9,6,-2,-3,4,8,0,-8,-1,13,9,20,159,510,972,1239,1009,271,-642,-1286,-1432,-1168,-731,-288,123,502,813,1012,1102,1124,1116,1120,1226,1545,2097,2713,3104,3042,2522,1750,989,416,78,-60,-57,31,147,226,208,52,-226,-556,-852,-1061,-1184,-1243,-1238,-1147,-965,-740,-550,-445,-411,-382,-286,-94,163,408,562,599,561,516,496,466,369,193,-5,-139,-155,-50,133,336,494,547,472,293,73,-121,-256,-335,-380,-415,-453,-498,-545,-587,-615,-626,-622,-608,-591,-570,-540,-493,-427,-356,-301,-275,-267,-251,-205,-136,-72,-38,-34,-33,-13,25,61,75,60,21,-28,-71,-89,-72,-27,21,49,46,14,-38,-103,-167,-218,-251,-272,-289,-304,-312,-312,-313,-322,-335,-338,-321,-292,-266,-251,-242,-228,-206,-186,-175,-173,-174,-176,-186,-206,-227,-236,-230,-211,-185,-154,-119,-87,-62,-45,-33,-27,-27,-31,-32,-27,-23,-30,-50,-79,-111,-144,-179,-212,-239,-259,-267,-261,-237,-198,-157,-124,-103,-93,-90,-87,-74,-48,-17,6,14,11,-3,-29,-68,-109,-144,-173,-199,-216,-217,-206,-193,-186,-174,-146,-107,-72,-49,-29,-11,-3,-10,-21,-25,-23,-26,-34,-37,-36,-49,-82,-115,-131,-144,-185,-242,-257,-186,-66},
            {-72,-65,64,127,-27,-200,-87,195,184,-181,-313,114,412,-105,-298,2329,8115,12674,9761,-1955,-15623,-21322,-15181,-2947,5855,6763,3034,497,1411,3747,5021,5184,5821,7961,11429,15466,18719,18830,13499,3072,-8264,-14915,-14109,-7750,-249,5011,7092,6406,3436,-1156,-5980,-9373,-10537,-9891,-8279,-6233,-4157,-2751,-2621,-3436,-4002,-3478,-2315,-1648,-1888,-2271,-1863,-646,634,1461,2002,2589,3139,3309,3008,2484,1953,1438,1021,988,1508,2237,2490,1859,567,-808,-1832,-2374,-2443,-2088,-1485,-970,-838,-1108,-1548,-1906,-2082,-2084,-1918,-1567,-1072,-576,-259,-199,-312,-407,-336,-98,193,433,607,749,862,918,913,881,839,757,597,374,128,-123,-388,-650,-851,-949,-966,-952,-933,-910,-910,-960,-1013,-941,-652,-199,244,534,651,648,545,323,8,-292,-451,-433,-317,-225,-227,-311,-419,-508,-567,-593,-567,-456,-251,12,268,456,542,517,397,227,83,25,55,115,136,90,5,-75,-129,-159,-175,-184,-202,-250,-335,-425,-472,-449,-380,-321,-314,-356,-410,-438,-414,-328,-200,-74,-4,-3,-29,-16,74,220,365,461,493,471,423,376,353,353,361,349,291,181,32,-128,-277,-406,-508,-568,-567,-511,-440,-392,-369,-344,-303,-266,-247,-226,-167,-74,9,46,52,67,96,113,101,85,93,114,112,69,6,-48,-91,-138,-186,-213,-211,-200,-202,-213,-205,-161,-92,-35,-20,-52,-114,-183,-237,-266,-263,-225,-158,-75,2,61,101,121,115,81,35,-1,-17,-26,-45,-70,-78,-57,-20}
        },
        {    // H-40e116a.wav
            {4,4,3,2,2,3,4,4,3,2,2,3,4,3,2,3,4,4,4,3,3,3,3,3,3,4,3,2,1,1,0,-2,-1,2,4,1,-3,0,7,9,0,-8,-3,8,8,-4,-4,12,15,5,89,419,984,1476,1450,706,-474,-1499,-1924,-1736,-1225,-657,-103,458,980,1352,1518,1529,1470,1399,1388,1569,2051,2753,3357,3483,2963,1959,838,-53,-544,-668,-577,-448,-392,-417,-458,-463,-447,-474,-585,-750,-901,-981,-973,-891,-759,-614,-495,-421,-367,-287,-155,8,158,272,376,510,683,854,957,946,820,618,389,178,10,-101,-152,-156,-134,-106,-78,-48,-18,-1,-18,-75,-168,-280,-395,-494,-556,-574,-560,-541,-534,-530,-516,-487,-459,-445,-438,-417,-366,-293,-218,-160,-127,-116,-114,-106,-79,-33,26,78,107,101,61,4,-54,-96,-119,-125,-116,-98,-76,-62,-64,-85,-127,-180,-230,-263,-276,-273,-263,-248,-231,-223,-238,-276,-317,-335,-315,-272,-232,-215,-220,-234,-242,-237,-217,-188,-158,-137,-135,-156,-193,-232,-257,-264,-253,-230,-196,-156,-118,-89,-68,-53,-39,-25,-9,9,24,25,8,-20,-47,-73,-103,-143,-186,-220,-241,-250,-248,-233,-207,-174,-142,-111,-84,-64,-54,-51,-51,-53,-57,-58,-54,-51,-59,-82,-114,-147,-177,-206,-228,-233,-222,-204,-185,-162,-128,-91,-59,-35,-12,9,19,12,0,-2,1,-2,-15,-27,-35,-50,-78,-104,-115,-129,-174,-235,-251,-181,-64},
            {23,-95,-78,82,134,-50,-205,-47,221,141,-225,-259,202,363,-220,-65,3151,8970,12435,7894,-4488,-16934,-20272,-12470,-466,6689,5991,1692,-499,1003,3754,5298,5725,6642,9027,12570,16203,18269,16597,9811,-617,-10156,-14070,-11027,-3891,2931,6667,6991,4739,766,-3945,-7980,-10086,-10065,-8727,-6953,-5128,-3519,-2678,-2986,-3913,-4274,-3453,-2105,-1368,-1527,-1787,-1332,-249,788,1441,1971,2646,3265,3432,3080,2494,1920,1416,1090,1194,1785,2425,2440,1550,118,-1227,-2102,-2482,-2456,-2099,-1563,-1138,-1078,-1377,-1791,-2068,-2122,-1988,-1709,-1297,-815,-409,-223,-274,-411,-430,-237,87,386,576,690,789,875,911,891,858,828,755,585,332,62,-180,-409,-646,-863,-996,-1011,-935,-847,-824,-896,-1010,-1040,-870,-494,-38,338,554,624,587,445,197,-96,-318,-388,-326,-234,-214,-290,-413,-521,-591,-626,-622,-543,-355,-74,223,448,556,552,467,333,190,89,66,110,159,151,71,-42,-133,-181,-203,-228,-272,-328,-382,-423,-440,-430,-396,-356,-333,-338,-362,-380,-370,-318,-225,-113,-21,21,13,-1,30,126,261,387,465,485,461,419,380,356,342,325,289,218,110,-26,-170,-307,-426,-518,-565,-553,-495,-433,-397,-377,-343,-292,-246,-215,-174,-99,-12,40,39,26,45,91,123,124,120,134,150,129,60,-31,-109,-166,-208,-236,-242,-230,-212,-196,-177,-145,-101,-54,-19,-11,-36,-93,-165,-234,-279,-282,-235,-149,-52,27,77,103,111,96,62,31,24,31,21,-14,-49,-51,-21}
        },
        {    // H-40e122a.wav
            {3,4,3,3,3,3,4,3,2,2,2,2,2,3,3,4,3,2,4,5,4,2,3,5,6,5,4,4,2,-4,-7,-2,5,4,-4,-6,4,10,1,-13,-11,6,8,-9,-15,9,25,7,68,421,1118,1811,1898,1028,-496,-1887,-2488,-2235,-1540,-818,-183,439,1046,1511,1744,1799,1784,1751,1745,1912,2433,3278,4061,4246,3545,2160,629,-537,-1125,-1235,-1115,-987,-952,-990,-1031,-1047,-1086,-1206,-1389,-1517,-1478,-1258,-958,-687,-484,-320,-163,-26,61,99,128,205,347,524,681,785,847,901,962,1004,986,900,774,635,480,288,67,-138,-285,-373,-436,-496,-537,-525,-450,-338,-234,-181,-199,-283,-403,-513,-578,-590,-568,-533,-500,-470,-439,-399,-335,-241,-134,-54,-31,-60,-105,-129,-119,-90,-54,-14,35,88,129,133,92,11,-85,-168,-218,-230,-213,-178,-140,-110,-104,-132,-193,-268,-327,-350,-338,-306,-269,-236,-207,-191,-201,-242,-303,-353,-370,-352,-314,-273,-235,-201,-172,-152,-142,-132,-117,-95,-75,-68,-82,-116,-165,-218,-264,-299,-319,-316,-284,-228,-164,-112,-78,-56,-38,-21,-4,9,14,10,-2,-14,-23,-39,-71,-118,-165,-198,-216,-226,-229,-221,-197,-165,-128,-88,-48,-18,-10,-31,-69,-112,-144,-157,-150,-130,-115,-112,-121,-135,-152,-176,-201,-214,-209,-191,-167,-141,-111,-83,-63,-48,-31,-8,9,12,11,17,24,18,-3,-25,-39,-54,-79,-103,-113,-125,-165,-221,-237,-173,-62},
            {62,11,-84,-71,66,125,-26,-183,-73,179,157,-164,-258,126,352,-119,-178,2375,7673,11643,8743,-2014,-14313,-19237,-13411,-2166,5709,6014,1786,-1208,-316,2767,5264,6396,7327,9246,12207,15269,16866,15148,9066,-88,-8479,-11973,-9212,-2574,3851,7153,6780,3687,-845,-5536,-9057,-10461,-9802,-8036,-6152,-4565,-3386,-2896,-3326,-4241,-4606,-3776,-2247,-1135,-945,-1112,-807,89,1038,1639,2050,2564,3103,3326,3108,2659,2206,1793,1461,1416,1778,2242,2212,1361,-29,-1346,-2174,-2496,-2471,-2215,-1829,-1503,-1440,-1671,-2011,-2231,-2229,-2029,-1680,-1213,-694,-263,-62,-114,-279,-343,-181,158,510,742,842,868,867,846,824,831,856,813,621,308,-1,-208,-342,-506,-738,-954,-1042,-989,-899,-890,-982,-1074,-1031,-789,-403,4,328,529,608,564,389,112,-176,-357,-378,-288,-204,-213,-315,-444,-546,-612,-648,-630,-499,-231,110,403,558,575,519,442,353,245,143,90,96,118,94,1,-126,-225,-269,-281,-304,-358,-424,-468,-474,-451,-417,-382,-349,-317,-290,-275,-272,-268,-241,-179,-90,-9,30,29,29,75,179,309,417,471,468,429,379,340,314,293,265,221,157,69,-47,-186,-333,-468,-564,-602,-579,-514,-448,-403,-371,-329,-272,-217,-174,-126,-58,18,63,63,46,54,93,133,150,147,145,142,115,46,-54,-153,-226,-265,-276,-266,-240,-205,-169,-139,-114,-89,-57,-25,-9,-28,-83,-160,-231,-270,-264,-217,-147,-76,-13,40,77,89,72,48,42,60,76,65,31,2,-4}
        },
        {    // H-40e129a.wav
            {3,3,2,1,2,3,2,1,2,2,3,3,3,3,3,3,3,3,3,2,2,5,7,6,4,5,6,3,-3,-3,4,7,-1,-9,-2,13,12,-8,-18,-2,14,-1,-24,-8,28,18,7,239,936,1896,2413,1801,87,-1862,-3000,-2929,-2072,-1107,-349,304,980,1579,1921,2001,1973,1949,1947,2052,2493,3396,4472,5060,4596,3081,1107,-571,-1509,-1724,-1533,-1282,-1171,-1217,-1331,-1433,-1528,-1677,-1887,-2065,-2089,-1930,-1659,-1355,-1024,-638,-236,73,216,249,306,472,714,934,1072,1131,1156,1185,1234,1282,1269,1134,872,570,348,273,308,349,307,140,-137,-467,-763,-938,-957,-856,-712,-591,-507,-443,-386,-344,-344,-400,-495,-587,-623,-574,-447,-282,-129,-20,36,53,47,31,11,-8,-20,-20,-8,11,40,82,127,142,92,-27,-176,-293,-336,-305,-234,-162,-116,-103,-120,-153,-195,-241,-291,-338,-368,-369,-344,-305,-267,-247,-262,-320,-408,-490,-520,-479,-385,-278,-192,-137,-100,-68,-38,-13,4,18,29,35,25,-6,-60,-127,-197,-262,-319,-365,-392,-390,-354,-293,-222,-157,-98,-44,1,25,23,4,-18,-33,-37,-32,-25,-27,-46,-83,-128,-172,-206,-227,-229,-206,-160,-102,-46,-2,18,9,-29,-82,-133,-170,-190,-195,-185,-168,-152,-142,-133,-125,-127,-147,-176,-194,-190,-170,-146,-118,-87,-59,-46,-48,-48,-39,-25,-14,-1,19,36,34,14,-6,-20,-43,-84,-125,-141,-144,-165,-206,-219,-162,-58},
            {-13,60,47,-56,-89,23,116,13,-155,-102,133,172,-105,-258,45,327,-25,-252,1685,6415,10741,9375,346,-11546,-17915,-14263,-4168,4253,5845,2223,-1251,-1115,1860,4930,6626,7588,9106,11628,14405,15870,14289,8826,727,-6666,-9814,-7510,-1757,3866,6692,6122,3000,-1457,-6040,-9509,-10910,-10167,-8149,-5964,-4259,-3211,-2927,-3450,-4357,-4752,-4000,-2428,-1048,-515,-530,-347,345,1229,1924,2430,2918,3317,3366,3004,2494,2109,1875,1715,1694,1914,2190,2047,1165,-235,-1560,-2353,-2582,-2474,-2226,-1934,-1707,-1679,-1887,-2197,-2406,-2389,-2146,-1733,-1207,-645,-174,78,70,-88,-191,-85,220,573,819,917,928,910,882,853,856,886,856,659,306,-50,-268,-369,-497,-727,-964,-1055,-977,-874,-890,-1017,-1101,-1000,-704,-318,38,304,472,538,482,297,27,-233,-386,-400,-330,-275,-291,-362,-434,-476,-505,-526,-497,-351,-79,232,459,545,528,484,441,377,274,162,89,68,59,9,-95,-220,-316,-364,-382,-408,-457,-504,-512,-468,-401,-353,-338,-333,-307,-258,-215,-199,-201,-188,-134,-53,22,64,80,102,155,239,331,406,446,443,399,330,259,209,180,161,136,95,28,-80,-227,-390,-528,-608,-620,-576,-505,-435,-384,-346,-301,-242,-180,-132,-90,-36,33,88,100,80,70,98,145,173,167,141,113,76,11,-86,-188,-266,-305,-309,-284,-239,-185,-138,-115,-113,-113,-98,-67,-41,-47,-91,-155,-207,-230,-223,-197,-160,-113,-56,3,50,69,62,47,45,61,77,73,45,13}
        },
        {    // H-40e135a.wav
            {3,2,2,2,2,0,-1,1,2,2,1,1,1,1,1,3,3,2,1,3,7,7,3,4,8,8,0,-6,0,10,6,-8,-10,8,20,4,-18,-10,17,12,-27,-33,20,47,-4,75,660,1791,2800,2664,961,-1555,-3454,-3807,-2849,-1521,-499,226,940,1661,2144,2265,2187,2126,2126,2192,2528,3403,4706,5748,5683,4210,1859,-395,-1803,-2212,-1968,-1567,-1355,-1414,-1613,-1772,-1839,-1914,-2109,-2386,-2564,-2495,-2208,-1847,-1515,-1190,-824,-441,-129,77,239,453,747,1061,1312,1466,1543,1591,1637,1658,1590,1388,1080,770,559,471,452,438,401,329,197,-32,-347,-679,-940,-1084,-1115,-1069,-981,-885,-804,-740,-677,-601,-513,-425,-336,-242,-151,-86,-51,-23,32,115,192,222,202,157,114,83,58,34,19,20,36,42,10,-72,-186,-290,-351,-364,-337,-281,-205,-121,-55,-31,-59,-129,-222,-313,-377,-402,-395,-379,-373,-386,-421,-479,-556,-627,-653,-610,-507,-376,-249,-139,-45,35,99,144,167,173,166,150,124,83,25,-42,-111,-179,-251,-329,-406,-465,-488,-469,-412,-333,-247,-165,-92,-33,3,9,-9,-30,-37,-26,-10,-1,-2,-16,-43,-84,-132,-175,-202,-206,-181,-134,-78,-29,1,11,-1,-34,-85,-136,-172,-187,-187,-184,-182,-182,-184,-184,-180,-169,-158,-152,-151,-146,-139,-135,-135,-130,-111,-83,-60,-47,-36,-22,-8,5,20,36,40,20,-12,-34,-47,-71,-114,-152,-158,-149,-164,-205,-220,-163,-59},
            {-22,-23,27,53,-9,-79,-36,77,74,-73,-140,16,172,43,-206,-132,212,194,-241,329,3476,8187,10244,5709,-4429,-13785,-15766,-9532,-613,4412,3593,204,-1394,246,3442,5980,7245,8140,9717,12089,14200,14317,11089,4798,-2190,-6604,-6488,-2609,2226,5248,5299,2844,-983,-5072,-8430,-10235,-10192,-8780,-6921,-5334,-4243,-3640,-3548,-3879,-4181,-3867,-2797,-1487,-597,-251,-20,497,1247,1942,2487,3009,3518,3763,3530,2937,2316,1872,1601,1494,1625,1938,2071,1582,395,-1058,-2185,-2688,-2672,-2413,-2121,-1904,-1834,-1948,-2194,-2430,-2511,-2366,-2009,-1503,-933,-403,-26,125,84,-2,38,264,582,837,966,1015,1044,1049,1003,938,904,867,708,373,-15,-272,-359,-424,-607,-852,-982,-926,-816,-831,-978,-1094,-1020,-754,-414,-106,142,327,423,390,227,-2,-213,-343,-377,-345,-303,-294,-326,-368,-394,-404,-408,-383,-270,-39,251,473,543,492,423,401,399,349,239,123,55,23,-37,-163,-321,-441,-488,-488,-494,-525,-550,-522,-438,-339,-279,-270,-280,-268,-223,-170,-141,-138,-135,-102,-34,48,118,167,205,240,276,307,335,356,362,337,276,189,101,34,-1,-8,-1,-9,-62,-174,-325,-472,-571,-603,-576,-515,-450,-393,-341,-279,-204,-133,-86,-60,-28,27,89,126,127,118,133,173,203,195,151,94,38,-26,-110,-206,-285,-325,-319,-279,-220,-159,-116,-108,-128,-152,-152,-126,-98,-92,-108,-132,-150,-162,-174,-184,-184,-160,-107,-31,42,79,70,42,37,64,89,76,30}
        },
        {    // H-40e141a.wav
            {2,3,1,-1,-2,1,2,-1,-3,-1,2,3,1,0,1,1,0,2,6,7,4,4,10,12,2,-7,-1,14,12,-8,-16,6,28,9,-25,-18,28,38,-18,-51,11,72,12,30,628,1994,3383,3425,1384,-1885,-4445,-4904,-3514,-1645,-352,377,1085,1938,2589,2754,2599,2456,2424,2463,2763,3697,5238,6591,6645,4923,2045,-732,-2420,-2824,-2409,-1827,-1527,-1619,-1926,-2183,-2268,-2292,-2441,-2733,-2969,-2947,-2667,-2286,-1912,-1514,-1037,-553,-208,-54,18,172,477,875,1268,1576,1764,1837,1846,1851,1844,1745,1485,1116,789,624,609,635,606,487,277,-16,-353,-647,-816,-852,-841,-889,-1033,-1221,-1354,-1359,-1222,-990,-734,-507,-318,-147,17,157,254,308,345,382,410,407,364,296,227,165,103,33,-39,-84,-79,-39,-22,-86,-236,-411,-523,-523,-427,-285,-148,-45,14,25,-10,-78,-163,-253,-336,-408,-468,-519,-558,-579,-584,-587,-610,-659,-705,-700,-614,-460,-281,-117,16,124,213,276,306,301,276,243,208,162,97,13,-77,-159,-234,-312,-397,-474,-519,-518,-477,-416,-356,-304,-256,-208,-158,-108,-61,-22,11,36,51,50,33,10,-10,-26,-46,-71,-95,-107,-104,-91,-77,-68,-70,-82,-95,-99,-92,-81,-77,-82,-97,-123,-162,-205,-238,-249,-240,-221,-195,-166,-139,-127,-133,-152,-172,-188,-192,-176,-134,-78,-28,8,36,62,80,82,68,44,15,-21,-56,-80,-96,-120,-156,-184,-189,-187,-208,-246,-247,-175,-61},
            {29,-10,-41,-5,54,34,-52,-72,26,94,2,-128,-72,118,132,-99,-206,55,267,-41,-179,1536,5562,9252,8323,1155,-8546,-14251,-12328,-5201,1237,3094,1258,-654,-191,2272,4921,6622,7598,8682,10364,12292,13294,11940,7676,1760,-3110,-4605,-2534,1092,3728,4035,2227,-790,-4203,-7349,-9500,-10074,-9120,-7379,-5740,-4677,-4193,-4132,-4310,-4392,-3942,-2804,-1373,-303,114,188,420,979,1681,2343,2970,3555,3897,3777,3257,2659,2228,1945,1704,1542,1553,1612,1372,597,-543,-1594,-2205,-2366,-2291,-2178,-2111,-2109,-2187,-2329,-2467,-2507,-2389,-2107,-1693,-1200,-703,-296,-59,9,14,101,338,649,894,1009,1048,1086,1120,1104,1039,973,901,732,410,35,-216,-291,-332,-496,-749,-916,-902,-815,-827,-956,-1055,-983,-747,-457,-200,8,170,263,257,163,27,-108,-221,-297,-332,-337,-340,-360,-385,-392,-379,-362,-329,-228,-21,250,466,534,474,397,384,413,398,298,161,56,-11,-93,-229,-390,-508,-553,-553,-555,-569,-563,-503,-395,-287,-228,-228,-247,-233,-175,-108,-78,-97,-129,-127,-74,13,107,189,253,293,306,300,289,279,266,233,172,92,15,-38,-55,-42,-21,-22,-71,-172,-308,-440,-534,-573,-557,-505,-436,-369,-308,-249,-190,-133,-91,-62,-29,25,95,149,164,150,142,160,187,186,146,84,20,-43,-116,-201,-276,-316,-311,-268,-207,-152,-122,-127,-155,-180,-183,-165,-142,-133,-139,-148,-148,-142,-146,-169,-195,-191,-136,-45,38,79,82,78,82,83,61,23}
        },
        {    // H-40e148a.wav
            {4,2,-1,0,2,2,0,-1,0,1,1,1,2,1,-1,0,7,10,6,2,9,17,12,-4,-5,14,22,2,-20,-5,31,27,-20,-37,15,61,17,-56,-24,82,65,-29,340,1686,3552,4365,2703,-1097,-4829,-6210,-4835,-2272,-329,531,1045,1853,2743,3168,3050,2797,2709,2762,3002,3791,5324,6985,7511,6032,2922,-436,-2698,-3397,-2960,-2166,-1646,-1651,-2049,-2480,-2658,-2615,-2641,-2921,-3293,-3410,-3128,-2636,-2191,-1829,-1399,-847,-333,-40,54,146,384,732,1068,1333,1553,1761,1949,2082,2122,2023,1753,1365,1001,791,741,735,666,513,311,62,-258,-620,-922,-1063,-1038,-940,-869,-870,-929,-1014,-1092,-1129,-1090,-955,-733,-454,-158,115,336,493,593,651,670,646,566,436,283,151,72,40,23,1,-19,-21,-24,-78,-212,-395,-547,-604,-555,-433,-282,-132,-11,57,57,-10,-127,-267,-397,-490,-537,-550,-547,-538,-531,-541,-588,-671,-746,-757,-669,-497,-287,-89,69,184,263,312,334,334,317,289,250,197,124,36,-62,-157,-243,-315,-377,-433,-482,-511,-506,-467,-412,-362,-322,-281,-232,-177,-128,-85,-44,2,45,74,81,70,52,34,19,2,-16,-27,-25,-10,1,-8,-45,-98,-149,-180,-180,-153,-110,-72,-52,-55,-79,-120,-171,-216,-239,-236,-217,-192,-168,-147,-140,-154,-186,-219,-237,-232,-207,-161,-100,-37,18,68,119,161,174,148,98,47,-1,-52,-99,-129,-141,-156,-183,-206,-206,-200,-222,-266,-270,-193,-68},
            {-1,28,20,-23,-33,19,52,0,-70,-37,64,68,-59,-122,11,148,41,-176,-119,181,182,-189,247,2858,6913,8985,5724,-2340,-10302,-12880,-9092,-2816,1170,1367,-74,-332,1390,3887,5783,6807,7602,8841,10589,12123,12184,9775,5196,348,-2393,-1981,481,2744,3188,1706,-853,-3677,-6327,-8418,-9456,-9179,-7906,-6358,-5133,-4411,-4118,-4138,-4280,-4179,-3485,-2232,-891,45,492,748,1090,1537,2006,2517,3120,3679,3902,3638,3067,2507,2125,1881,1720,1663,1662,1487,886,-122,-1193,-1927,-2182,-2116,-1984,-1944,-2022,-2181,-2371,-2533,-2601,-2525,-2290,-1918,-1456,-966,-529,-223,-83,-49,9,196,499,802,1003,1105,1171,1222,1221,1142,1019,884,702,424,98,-144,-236,-268,-382,-589,-756,-785,-743,-771,-900,-1006,-957,-748,-480,-237,-36,119,201,184,96,-6,-87,-159,-237,-308,-353,-372,-386,-402,-410,-404,-391,-363,-277,-89,174,409,512,476,398,374,406,414,342,215,99,17,-69,-197,-348,-469,-529,-547,-558,-567,-549,-487,-392,-302,-251,-243,-251,-235,-179,-108,-66,-75,-112,-132,-108,-46,31,110,188,262,314,327,298,243,184,136,99,64,31,1,-20,-33,-43,-64,-108,-182,-282,-390,-479,-526,-524,-481,-414,-343,-278,-222,-172,-128,-98,-81,-63,-25,37,100,137,143,138,146,165,172,149,97,32,-34,-96,-155,-208,-247,-261,-247,-213,-178,-161,-169,-190,-207,-207,-192,-174,-164,-164,-164,-155,-144,-148,-173,-196,-187,-133,-55,15,66,99,116,107,70,22}
        },
        {    // H-40e154a.wav
            {-3,0,2,0,-4,-4,1,3,1,-1,-1,-2,-4,-1,7,11,3,-3,4,16,11,-9,-12,11,25,2,-26,-8,36,35,-23,-49,12,74,27,-66,-35,97,90,-42,327,1864,4114,5208,3332,-1253,-5900,-7685,-5932,-2553,29,1029,1365,2046,3018,3596,3522,3198,3057,3153,3505,4416,6063,7799,8275,6536,2991,-814,-3362,-4129,-3589,-2606,-1885,-1758,-2166,-2749,-3109,-3139,-3088,-3238,-3556,-3723,-3517,-3031,-2503,-2015,-1471,-842,-298,-30,-8,9,229,649,1123,1531,1832,2027,2122,2149,2142,2079,1883,1525,1116,833,760,802,786,608,279,-143,-597,-1003,-1257,-1290,-1144,-957,-859,-877,-944,-976,-934,-835,-714,-597,-496,-400,-284,-125,81,306,507,650,726,744,709,619,478,321,191,106,52,12,-1,35,96,96,-41,-299,-564,-712,-699,-567,-391,-227,-107,-55,-79,-164,-274,-377,-456,-505,-523,-519,-513,-517,-527,-534,-541,-568,-616,-649,-612,-480,-280,-69,108,242,345,424,469,464,408,320,226,135,43,-54,-146,-223,-285,-347,-417,-489,-546,-577,-577,-548,-493,-420,-345,-278,-222,-169,-116,-67,-26,9,39,63,76,80,82,84,82,71,53,36,31,40,54,54,26,-30,-96,-151,-186,-201,-198,-180,-153,-130,-122,-128,-138,-148,-161,-176,-189,-192,-188,-182,-179,-180,-191,-216,-246,-262,-249,-209,-154,-90,-22,44,102,150,188,204,183,128,62,5,-45,-94,-140,-168,-177,-189,-214,-233,-225,-211,-224,-262,-265,-189,-67},
            {3,-10,2,25,16,-20,-25,19,44,-4,-60,-26,60,56,-56,-103,17,129,26,-158,-94,167,150,-165,301,2734,6426,8319,5462,-1697,-8912,-11583,-8743,-3552,-2,564,-200,-41,1705,4085,5936,6931,7534,8374,9673,10946,11130,9314,5701,1842,-407,-365,973,1923,1506,-110,-2267,-4543,-6750,-8508,-9219,-8585,-7021,-5400,-4399,-4120,-4252,-4429,-4388,-3944,-3039,-1856,-768,-51,340,664,1103,1630,2155,2674,3196,3597,3676,3386,2935,2579,2375,2192,1940,1683,1489,1252,767,-26,-919,-1609,-1959,-2060,-2082,-2114,-2160,-2211,-2283,-2376,-2436,-2390,-2201,-1882,-1472,-1018,-586,-252,-55,55,186,400,656,854,951,994,1044,1096,1096,1016,877,696,462,186,-54,-173,-182,-192,-287,-429,-519,-539,-578,-703,-848,-880,-741,-508,-292,-132,-6,96,141,108,26,-56,-130,-217,-323,-416,-461,-459,-440,-428,-422,-415,-398,-351,-238,-45,181,348,402,379,369,411,462,448,352,230,136,66,-23,-150,-281,-376,-433,-483,-541,-588,-592,-545,-474,-411,-371,-342,-298,-227,-144,-84,-72,-96,-121,-117,-84,-35,24,101,193,274,307,281,220,163,134,130,130,116,83,39,-4,-40,-75,-121,-186,-264,-342,-411,-458,-470,-441,-379,-307,-246,-206,-180,-162,-148,-139,-129,-109,-69,-8,58,109,132,131,126,129,135,125,91,44,-1,-41,-84,-135,-180,-202,-202,-195,-195,-202,-209,-214,-217,-218,-213,-203,-191,-179,-168,-159,-156,-161,-166,-162,-144,-106,-44,35,106,131,97,34}
        },
        {    // H-40e161a.wav
            {0,-1,-3,-3,1,3,1,-1,-1,-1,-4,-3,6,11,5,-4,1,16,14,-7,-16,6,29,9,-30,-24,29,48,-9,-61,-15,70,51,-58,-67,78,130,-26,159,1549,4041,5831,4609,-65,-5718,-8779,-7636,-3851,-354,1291,1707,2215,3163,3903,3945,3566,3319,3406,3811,4722,6332,8145,8874,7400,3879,-238,-3288,-4500,-4187,-3193,-2309,-2004,-2336,-2970,-3421,-3477,-3375,-3489,-3851,-4094,-3889,-3314,-2707,-2246,-1799,-1217,-600,-183,-15,106,391,829,1262,1600,1879,2135,2326,2396,2353,2219,1963,1560,1103,782,704,760,736,520,178,-178,-519,-868,-1190,-1382,-1384,-1259,-1136,-1085,-1069,-1022,-924,-802,-672,-524,-344,-159,-16,60,92,129,206,328,478,626,727,731,629,470,339,276,246,192,111,63,88,134,88,-111,-402,-656,-773,-745,-624,-467,-313,-192,-131,-134,-190,-275,-372,-467,-539,-574,-573,-553,-529,-505,-489,-497,-541,-599,-614,-532,-351,-126,79,236,356,457,531,552,508,409,283,154,33,-73,-159,-226,-283,-345,-421,-508,-594,-661,-692,-679,-627,-545,-445,-338,-235,-147,-83,-50,-37,-27,-4,36,77,107,125,139,149,145,119,81,55,52,66,77,69,36,-21,-91,-156,-200,-219,-223,-222,-220,-213,-200,-185,-168,-153,-145,-150,-163,-176,-181,-184,-193,-213,-240,-265,-279,-268,-225,-161,-96,-44,5,60,117,160,178,174,151,108,51,-3,-43,-77,-121,-173,-211,-227,-234,-242,-238,-212,-186,-195,-234,-243,-176,-63},
            {4,9,-2,-8,8,24,8,-23,-16,25,33,-18,-54,-6,61,31,-68,-76,44,105,-22,-152,-33,175,71,-149,632,3252,6599,7704,4292,-2582,-8841,-10727,-7932,-3428,-435,219,0,609,2404,4556,6168,7023,7519,8183,9183,10072,9987,8344,5512,2726,1123,821,953,584,-530,-2050,-3663,-5337,-6994,-8186,-8341,-7348,-5790,-4514,-3999,-4125,-4448,-4587,-4352,-3692,-2668,-1494,-474,189,538,776,1070,1463,1947,2518,3108,3530,3599,3329,2943,2650,2455,2224,1905,1592,1349,1066,558,-185,-940,-1454,-1682,-1785,-1930,-2141,-2334,-2450,-2494,-2482,-2393,-2193,-1876,-1472,-1033,-618,-298,-118,-55,-4,141,393,667,855,924,911,868,816,754,681,587,455,282,109,-4,-42,-60,-120,-220,-308,-364,-436,-567,-716,-778,-694,-508,-313,-159,-38,62,120,110,40,-55,-152,-255,-364,-458,-512,-529,-527,-514,-488,-451,-418,-387,-326,-196,-8,171,277,313,342,411,494,523,469,364,261,172,72,-50,-170,-261,-337,-430,-548,-652,-700,-688,-645,-595,-539,-471,-387,-294,-203,-127,-88,-92,-118,-129,-103,-49,11,75,147,219,265,262,219,171,149,157,171,166,132,77,16,-45,-107,-176,-247,-309,-357,-391,-412,-415,-391,-342,-286,-240,-215,-205,-201,-196,-186,-175,-162,-144,-110,-55,6,50,67,68,74,95,117,122,102,65,21,-24,-65,-102,-135,-164,-187,-202,-209,-216,-228,-245,-256,-259,-252,-239,-224,-211,-202,-191,-176,-159,-151,-151,-140,-96,-29,27,40,18}
        },
        {    // H-40e167a.wav
            {-6,-5,0,1,-2,-3,-2,-2,-7,-5,5,12,4,-6,1,17,13,-11,-19,7,29,6,-34,-23,32,44,-20,-66,-9,75,41,-72,-61,94,123,-37,278,1954,4706,6451,4764,-579,-6709,-9804,-8335,-4156,-407,1367,1931,2669,3840,4655,4576,3986,3614,3774,4409,5526,7126,8659,8982,7221,3676,-274,-3199,-4512,-4501,-3815,-3058,-2676,-2845,-3340,-3694,-3657,-3483,-3624,-4155,-4633,-4580,-3972,-3172,-2460,-1797,-1071,-389,19,128,195,480,984,1515,1937,2259,2514,2664,2665,2545,2347,2031,1547,982,569,464,569,616,435,78,-307,-654,-989,-1301,-1501,-1518,-1405,-1287,-1238,-1220,-1155,-1018,-843,-669,-501,-332,-168,-28,88,200,318,425,495,531,561,595,599,525,381,244,195,235,291,304,283,269,249,143,-109,-460,-772,-919,-865,-670,-425,-208,-61,-2,-20,-91,-195,-313,-425,-505,-537,-535,-528,-538,-557,-569,-575,-590,-616,-616,-543,-378,-156,61,230,351,446,528,584,591,538,431,285,118,-48,-188,-289,-354,-403,-454,-514,-584,-655,-709,-723,-686,-609,-512,-411,-309,-210,-127,-76,-53,-39,-14,23,61,93,123,154,181,196,195,188,184,183,176,148,94,22,-50,-111,-155,-188,-214,-234,-249,-260,-266,-264,-248,-219,-180,-143,-119,-120,-143,-177,-206,-224,-237,-253,-267,-269,-251,-214,-163,-103,-42,15,66,114,158,184,184,158,118,72,21,-34,-84,-125,-160,-194,-222,-230,-223,-216,-218,-214,-194,-178,-192,-225,-226,-159,-55},
            {-9,-8,5,12,1,-10,1,21,14,-15,-20,12,30,-5,-44,-18,42,36,-44,-74,13,88,10,-117,-60,127,102,-103,379,2476,5628,7394,5288,-612,-7108,-10334,-8943,-4920,-1402,91,369,1037,2715,4731,6124,6619,6716,7080,7937,8902,9260,8489,6662,4420,2499,1205,313,-575,-1641,-2813,-4002,-5213,-6379,-7184,-7222,-6405,-5176,-4225,-3958,-4231,-4569,-4600,-4244,-3587,-2706,-1675,-662,109,542,757,972,1321,1800,2343,2866,3245,3354,3181,2876,2623,2452,2244,1922,1566,1295,1072,717,128,-574,-1157,-1511,-1716,-1898,-2081,-2199,-2221,-2189,-2155,-2104,-1980,-1745,-1417,-1046,-685,-375,-143,13,131,255,399,539,638,682,693,702,722,738,710,603,420,213,48,-45,-86,-116,-148,-173,-193,-245,-360,-514,-625,-619,-498,-322,-161,-40,42,88,92,61,6,-66,-163,-289,-423,-527,-580,-591,-575,-540,-489,-437,-403,-382,-338,-240,-95,51,164,257,362,485,581,602,540,429,304,177,49,-73,-173,-257,-351,-470,-593,-683,-723,-724,-707,-674,-615,-526,-417,-305,-203,-130,-99,-105,-116,-98,-41,33,99,152,200,247,281,289,275,251,226,201,167,123,70,12,-50,-119,-195,-271,-332,-363,-361,-336,-304,-274,-247,-222,-201,-189,-188,-194,-201,-204,-205,-208,-212,-205,-175,-120,-59,-14,5,15,39,87,142,178,178,146,101,60,23,-19,-74,-134,-181,-202,-205,-208,-224,-249,-268,-273,-265,-253,-241,-227,-205,-176,-147,-129,-127,-133,-127,-99,-54,-15}
        },
        {    // H-40e174a.wav
            {-2,0,-1,-2,0,-1,-5,-5,4,11,4,-6,0,16,15,-7,-17,6,29,9,-31,-26,28,46,-13,-65,-18,67,44,-67,-71,79,128,-24,229,1813,4618,6690,5468,335,-6151,-10030,-9258,-5252,-1196,959,1684,2477,3877,5131,5415,4851,4241,4184,4757,5820,7207,8461,8726,7277,4252,703,-2155,-3751,-4261,-4167,-3871,-3644,-3647,-3838,-3970,-3859,-3664,-3754,-4259,-4829,-4959,-4487,-3688,-2884,-2126,-1309,-476,151,442,542,715,1067,1511,1941,2332,2662,2843,2807,2609,2371,2120,1778,1324,901,673,624,551,289,-124,-528,-837,-1090,-1336,-1535,-1608,-1553,-1457,-1396,-1361,-1296,-1181,-1042,-902,-735,-511,-248,-10,160,279,397,533,655,728,754,750,703,572,355,131,9,22,101,149,140,117,108,69,-67,-304,-553,-709,-721,-608,-421,-212,-33,73,93,50,-20,-102,-202,-320,-428,-497,-532,-562,-603,-641,-652,-643,-640,-647,-625,-523,-333,-104,100,256,378,487,577,626,616,549,431,271,87,-88,-221,-305,-367,-439,-531,-625,-695,-730,-729,-693,-623,-529,-431,-341,-259,-185,-127,-97,-90,-78,-40,18,73,110,136,168,206,238,252,251,239,216,179,125,59,-10,-74,-127,-168,-201,-231,-257,-275,-284,-281,-265,-232,-188,-147,-128,-133,-157,-187,-217,-242,-254,-254,-247,-242,-233,-211,-174,-129,-83,-33,30,101,166,207,216,193,148,94,41,-11,-65,-118,-159,-183,-200,-220,-238,-239,-224,-210,-208,-206,-190,-172,-179,-207,-208,-148,-52},
            {-2,-4,-9,-6,5,11,1,-8,3,20,13,-13,-17,12,27,-5,-39,-15,38,31,-41,-66,12,77,6,-103,-46,119,89,-72,467,2543,5564,7166,4996,-818,-7160,-10288,-8902,-4927,-1392,254,793,1709,3460,5288,6292,6357,6098,6182,6832,7774,8460,8347,7187,5202,2965,1016,-461,-1607,-2608,-3518,-4332,-5090,-5786,-6220,-6092,-5356,-4435,-3934,-4110,-4633,-4932,-4698,-4046,-3228,-2360,-1445,-558,139,573,852,1135,1479,1846,2221,2613,2955,3104,2992,2735,2506,2337,2108,1752,1372,1103,912,615,110,-485,-960,-1242,-1432,-1645,-1873,-2026,-2064,-2032,-1986,-1918,-1783,-1563,-1282,-984,-697,-440,-225,-53,97,254,429,602,737,812,840,844,827,761,614,398,179,24,-53,-100,-162,-230,-255,-225,-193,-229,-345,-474,-531,-483,-356,-204,-65,36,90,96,70,30,-24,-106,-216,-333,-427,-486,-525,-555,-573,-568,-550,-539,-540,-520,-442,-294,-112,60,206,339,466,567,611,584,505,395,265,123,-15,-123,-205,-291,-411,-557,-685,-760,-781,-768,-731,-662,-561,-447,-341,-254,-188,-148,-136,-132,-107,-41,50,132,185,218,249,282,302,299,273,236,195,152,104,46,-20,-90,-158,-221,-276,-314,-325,-305,-265,-225,-198,-184,-177,-173,-175,-187,-206,-227,-242,-251,-254,-251,-241,-218,-182,-136,-90,-52,-23,8,53,115,176,211,205,169,131,100,61,-5,-92,-169,-208,-215,-215,-227,-247,-261,-262,-253,-242,-234,-230,-226,-209,-176,-141,-125,-126,-119,-83,-29}
        },
        {    // H-40e180a.wav
            {-2,-3,-1,-1,-7,-8,1,11,6,-5,-1,16,17,-6,-19,2,27,11,-30,-28,24,46,-10,-64,-21,63,44,-67,-77,71,129,-26,182,1703,4528,6809,5939,1064,-5525,-9904,-9740,-6075,-1970,404,1235,1998,3479,5116,5957,5797,5259,5058,5461,6340,7392,8176,8128,6845,4447,1595,-935,-2693,-3656,-4039,-4135,-4236,-4518,-4875,-4974,-4607,-4006,-3702,-4002,-4657,-5098,-4963,-4322,-3436,-2446,-1378,-353,382,691,720,769,1022,1449,1936,2401,2770,2948,2897,2708,2516,2332,2040,1587,1109,807,705,616,355,-68,-512,-884,-1216,-1536,-1781,-1853,-1761,-1628,-1571,-1589,-1592,-1502,-1312,-1058,-780,-502,-252,-51,104,244,402,573,719,808,847,868,872,812,635,356,73,-117,-196,-213,-210,-175,-93,-7,-9,-149,-376,-569,-636,-562,-392,-185,4,129,169,136,69,-6,-89,-186,-289,-374,-433,-480,-536,-597,-641,-655,-655,-660,-660,-615,-491,-298,-81,118,290,442,571,654,670,614,502,351,180,16,-113,-199,-262,-341,-454,-586,-702,-776,-801,-776,-706,-600,-480,-368,-280,-213,-162,-127,-109,-94,-64,-12,51,108,154,195,234,263,272,265,248,226,193,143,80,14,-50,-113,-172,-220,-250,-263,-261,-250,-233,-216,-200,-186,-173,-166,-175,-198,-227,-247,-251,-246,-239,-233,-229,-222,-205,-172,-128,-82,-39,6,66,135,191,215,206,177,139,92,32,-36,-100,-152,-185,-200,-207,-222,-247,-267,-262,-236,-214,-209,-205,-184,-157,-149,-163,-163,-117,-42},
            {-2,-3,-1,-1,-7,-8,1,11,6,-5,-1,16,17,-6,-19,2,27,11,-30,-28,24,46,-10,-64,-21,63,44,-67,-77,71,129,-26,182,1703,4528,6809,5939,1064,-5525,-9904,-9740,-6075,-1970,404,1235,1998,3479,5116,5957,5797,5259,5058,5461,6340,7392,8176,8128,6845,4447,1595,-935,-2693,-3656,-4039,-4135,-4236,-4518,-4875,-4974,-4607,-4006,-3702,-4002,-4657,-5098,-4963,-4322,-3436,-2446,-1378,-353,382,691,720,769,1022,1449,1936,2401,2770,2948,2897,2708,2516,2332,2040,1587,1109,807,705,616,355,-68,-512,-884,-1216,-1536,-1781,-1853,-1761,-1628,-1571,-1589,-1592,-1502,-1312,-1058,-780,-502,-252,-51,104,244,402,573,719,808,847,868,872,812,635,356,73,-117,-196,-213,-210,-175,-93,-7,-9,-149,-376,-569,-636,-562,-392,-185,4,129,169,136,69,-6,-89,-186,-289,-374,-433,-480,-536,-597,-641,-655,-655,-660,-660,-615,-491,-298,-81,118,290,442,571,654,670,614,502,351,180,16,-113,-199,-262,-341,-454,-586,-702,-776,-801,-776,-706,-600,-480,-368,-280,-213,-162,-127,-109,-94,-64,-12,51,108,154,195,234,263,272,265,248,226,193,143,80,14,-50,-113,-172,-220,-250,-263,-261,-250,-233,-216,-200,-186,-173,-166,-175,-198,-227,-247,-251,-246,-239,-233,-229,-222,-205,-172,-128,-82,-39,6,66,135,191,215,206,177,139,92,32,-36,-100,-152,-185,-200,-207,-222,-247,-267,-262,-236,-214,-209,-205,-184,-157,-149,-163,-163,-117,-42}
        }
    },
    {    // elev0 
        {    // H0e000a.wav
            {10,-5,-12,7,26,7,-27,-17,31,37,-24,-60,3,77,29,-90,-82,73,133,-32,-169,-15,189,54,51,1516,4864,7938,7267,1831,-4810,-7299,-3900,1409,2957,-642,-5107,-5152,64,6416,9185,7315,3622,1803,3640,8263,12917,14303,10387,2180,-6104,-9604,-6581,-74,4354,2942,-3565,-10866,-14484,-12718,-7288,-1817,562,-957,-4544,-7128,-6604,-3265,661,2889,2727,1209,-56,-94,1062,2727,4056,4425,3725,2473,1523,1432,2025,2565,2394,1419,112,-862,-1047,-427,545,1181,1001,89,-983,-1625,-1665,-1364,-1087,-1029,-1199,-1544,-1990,-2415,-2674,-2698,-2550,-2356,-2190,-2018,-1752,-1338,-822,-335,-13,108,115,138,259,480,766,1070,1327,1449,1390,1195,975,814,725,669,606,503,333,103,-121,-249,-258,-224,-259,-411,-621,-781,-820,-759,-680,-670,-749,-863,-923,-882,-762,-631,-554,-549,-586,-604,-548,-404,-218,-59,32,72,99,143,211,303,413,514,557,510,389,241,110,17,-32,-35,-11,-5,-57,-161,-264,-313,-301,-271,-269,-308,-363,-395,-379,-320,-245,-185,-158,-162,-178,-178,-143,-76,-9,12,-37,-134,-224,-251,-198,-95,6,67,78,57,29,16,22,35,30,-7,-69,-125,-147,-136,-118,-122,-151,-183,-196,-189,-179,-183,-202,-227,-243,-234,-192,-123,-45,20,61,74,62,31,-8,-37,-45,-37,-33,-51,-96,-153,-197,-210,-195,-169,-156,-164,-183,-194,-186,-157,-119,-85,-63,-52,-44,-33,-21,-17,-26,-42,-56,-61,-57,-48,-39,-39,-51,-66,-66,-45,-14},
            {10,-5,-12,7,26,7,-27,-17,31,37,-24,-60,3,77,29,-90,-82,73,133,-32,-169,-15,189,54,51,1516,4864,7938,7267,1831,-4810,-7299,-3900,1409,2957,-642,-5107,-5152,64,6416,9185,7315,3622,1803,3640,8263,12917,14303,10387,2180,-6104,-9604,-6581,-74,4354,2942,-3565,-10866,-14484,-12718,-7288,-1817,562,-957,-4544,-7128,-6604,-3265,661,2889,2727,1209,-56,-94,1062,2727,4056,4425,3725,2473,1523,1432,2025,2565,2394,1419,112,-862,-1047,-427,545,1181,1001,89,-983,-1625,-1665,-1364,-1087,-1029,-1199,-1544,-1990,-2415,-2674,-2698,-2550,-2356,-2190,-2018,-1752,-1338,-822,-335,-13,108,115,138,259,480,766,1070,1327,1449,1390,1195,975,814,725,669,606,503,333,103,-121,-249,-258,-224,-259,-411,-621,-781,-820,-759,-680,-670,-749,-863,-923,-882,-762,-631,-554,-549,-586,-604,-548,-404,-218,-59,32,72,99,143,211,303,413,514,557,510,389,241,110,17,-32,-35,-11,-5,-57,-161,-264,-313,-301,-271,-269,-308,-363,-395,-379,-320,-245,-185,-158,-162,-178,-178,-143,-76,-9,12,-37,-134,-224,-251,-198,-95,6,67,78,57,29,16,22,35,30,-7,-69,-125,-147,-136,-118,-122,-151,-183,-196,-189,-179,-183,-202,-227,-243,-234,-192,-123,-45,20,61,74,62,31,-8,-37,-45,-37,-33,-51,-96,-153,-197,-210,-195,-169,-156,-164,-183,-194,-186,-157,-119,-85,-63,-52,-44,-33,-21,-17,-26,-42,-56,-61,-57,-48,-39,-39,-51,-66,-66,-45,-14}
        },
        {    // H0e005a.wav
            {-5,3,8,1,-6,5,17,3,-22,-13,26,32,-18,-52,-6,59,30,-65,-70,48,106,-17,-134,-22,152,65,63,1247,4065,6841,6620,2265,-3503,-6104,-3645,893,2621,-134,-4135,-4762,-759,4780,7762,6819,3922,2127,3206,6816,10919,12739,10224,3705,-3628,-7567,-6078,-1083,2961,2552,-2317,-8493,-12198,-11560,-7492,-2770,-176,-817,-3559,-5941,-5979,-3546,-257,1956,2274,1295,238,-17,679,1922,3094,3637,3319,2406,1531,1249,1609,2146,2274,1730,715,-271,-734,-465,312,1044,1198,634,-324,-1160,-1544,-1485,-1223,-1034,-1104,-1475,-2022,-2507,-2710,-2577,-2241,-1908,-1707,-1620,-1527,-1300,-901,-414,13,276,376,385,371,371,420,554,765,972,1066,1001,826,632,484,401,365,330,248,100,-71,-195,-235,-235,-273,-390,-558,-704,-766,-733,-652,-601,-634,-736,-830,-837,-742,-596,-474,-417,-417,-431,-407,-315,-169,-15,98,157,181,199,229,274,326,369,382,349,273,170,58,-45,-114,-131,-112,-100,-135,-210,-277,-291,-253,-202,-181,-204,-254,-297,-305,-264,-194,-133,-113,-138,-178,-193,-164,-104,-49,-33,-68,-136,-200,-220,-180,-97,-10,43,44,11,-24,-36,-25,-13,-21,-56,-103,-140,-152,-140,-121,-111,-117,-131,-143,-147,-149,-155,-171,-190,-198,-183,-146,-95,-44,0,37,64,72,57,25,-5,-23,-31,-41,-66,-106,-153,-191,-208,-201,-181,-169,-175,-194,-206,-200,-175,-142,-113,-94,-85,-82,-80,-71,-58,-48,-47,-52,-56,-54,-49,-45,-41,-33,-20,-7},
            {-13,8,31,13,-30,-26,32,51,-18,-79,-18,87,58,-90,-120,53,169,3,-204,-72,218,123,-60,1172,4710,8574,8706,3168,-4682,-8545,-5472,750,3401,-35,-5272,-5989,-505,6813,10310,8334,3955,1560,3388,8549,13960,15878,11842,2702,-6951,-11427,-8297,-669,5056,4179,-2862,-11298,-15865,-14331,-8401,-2084,974,-409,-4435,-7687,-7555,-4040,483,3277,3275,1490,-191,-474,756,2753,4486,5125,4429,2942,1704,1488,2182,2917,2824,1715,134,-1102,-1418,-782,300,1059,953,53,-1037,-1683,-1701,-1364,-1059,-986,-1156,-1512,-1965,-2386,-2652,-2745,-2748,-2733,-2677,-2500,-2152,-1654,-1099,-624,-343,-251,-192,21,430,903,1276,1500,1622,1665,1599,1415,1189,1015,921,862,785,663,485,252,4,-177,-242,-237,-268,-405,-613,-785,-841,-784,-699,-683,-774,-915,-1001,-967,-843,-712,-642,-641,-674,-693,-650,-521,-331,-152,-46,-13,6,63,166,289,411,518,582,575,490,360,230,130,68,46,53,51,-3,-117,-237,-296,-272,-214,-197,-259,-375,-477,-507,-450,-343,-244,-196,-203,-230,-233,-190,-109,-29,5,-32,-128,-227,-262,-201,-69,65,138,138,95,54,40,50,66,65,32,-29,-88,-115,-103,-83,-97,-151,-211,-237,-227,-210,-214,-242,-274,-291,-283,-247,-183,-103,-25,31,56,52,27,-6,-35,-51,-51,-46,-50,-78,-127,-174,-192,-173,-139,-127,-149,-184,-199,-182,-148,-115,-89,-66,-46,-32,-20,-3,16,22,4,-28,-52,-54,-43,-36,-40,-54,-68,-78,-79,-64,-38,-12}
        },
        {    // H0e010a.wav
            {-2,-3,-1,7,7,-5,-10,4,19,7,-18,-15,17,28,-9,-39,-5,46,25,-50,-56,37,84,-12,-104,-14,124,56,78,1107,3528,5958,5901,2311,-2639,-5087,-3265,524,2184,79,-3327,-4148,-1052,3659,6567,6250,4041,2409,3018,5865,9425,11345,9680,4402,-2020,-6003,-5501,-1698,1884,2116,-1483,-6671,-10298,-10429,-7378,-3277,-626,-718,-2877,-5058,-5402,-3561,-759,1350,1922,1279,352,-71,303,1301,2442,3141,3029,2241,1376,1048,1400,2020,2307,1934,1030,53,-510,-416,188,839,1056,669,-91,-805,-1191,-1239,-1133,-1083,-1225,-1578,-2030,-2378,-2449,-2231,-1883,-1607,-1493,-1472,-1403,-1184,-818,-388,0,280,443,513,513,462,393,357,387,468,543,563,518,436,353,291,243,178,70,-67,-183,-228,-206,-180,-224,-363,-551,-705,-758,-705,-608,-550,-575,-658,-722,-707,-605,-457,-321,-239,-220,-235,-231,-169,-58,54,128,162,180,193,198,195,199,217,230,209,147,63,-16,-84,-139,-172,-180,-178,-197,-246,-294,-297,-241,-161,-111,-119,-171,-226,-253,-243,-206,-157,-118,-105,-119,-144,-151,-127,-87,-64,-84,-136,-186,-199,-166,-100,-28,23,39,19,-19,-51,-62,-55,-50,-66,-101,-138,-156,-149,-130,-120,-125,-139,-149,-150,-144,-138,-136,-143,-153,-157,-143,-107,-56,-1,47,78,86,68,32,-8,-37,-54,-65,-80,-105,-137,-164,-176,-172,-165,-172,-194,-219,-228,-219,-197,-170,-142,-119,-105,-99,-92,-78,-63,-56,-60,-68,-68,-58,-45,-31,-18,-5},
            {31,18,-29,-37,24,64,1,-80,-35,89,84,-84,-157,25,206,62,-220,-149,212,207,-112,818,4390,9002,10153,4848,-4104,-9630,-7332,-398,3537,583,-5281,-6730,-1053,7256,11499,9330,4174,1286,3339,9179,15209,17357,13028,3057,-7722,-13032,-9877,-1383,5352,4859,-2586,-11727,-16725,-15176,-8978,-2364,921,-358,-4466,-7946,-7995,-4425,355,3386,3429,1533,-272,-620,596,2644,4552,5460,4967,3477,2072,1711,2404,3232,3205,2068,350,-1155,-1855,-1545,-469,707,1207,685,-483,-1520,-1888,-1640,-1208,-983,-1104,-1508,-2034,-2495,-2763,-2853,-2886,-2951,-3006,-2935,-2665,-2219,-1673,-1121,-648,-283,31,384,790,1170,1445,1632,1790,1910,1909,1744,1485,1247,1083,958,830,680,501,286,65,-93,-143,-140,-199,-389,-652,-859,-913,-826,-705,-670,-768,-939,-1062,-1048,-911,-749,-661,-680,-764,-828,-792,-634,-403,-195,-77,-36,-10,52,149,262,383,505,598,624,569,459,333,213,117,61,48,46,6,-88,-192,-243,-224,-182,-185,-257,-367,-457,-487,-453,-384,-319,-288,-300,-330,-337,-287,-187,-81,-25,-46,-122,-198,-217,-155,-33,98,186,207,176,134,111,112,118,102,52,-22,-90,-125,-119,-98,-98,-133,-185,-224,-237,-236,-243,-271,-311,-344,-348,-312,-242,-159,-81,-19,19,29,8,-30,-64,-75,-64,-49,-48,-70,-106,-138,-146,-130,-106,-101,-124,-162,-187,-184,-156,-119,-87,-69,-59,-45,-18,16,41,43,23,-9,-37,-50,-46,-38,-44,-67,-88,-87,-66,-55,-67,-83,-70,-28}
        },
        {    // H0e015a.wav
            {-3,-2,-1,-3,-1,4,6,-1,-6,2,12,5,-12,-10,15,22,-8,-35,-9,36,26,-35,-51,17,63,-2,-79,-16,98,55,59,865,2888,5099,5380,2593,-1711,-4249,-3137,77,1893,469,-2516,-3695,-1466,2604,5551,5773,4065,2494,2687,4904,8031,10091,9246,5105,-552,-4661,-5053,-2189,1152,2022,-534,-4984,-8601,-9369,-7165,-3630,-997,-648,-2286,-4281,-4923,-3649,-1285,752,1536,1119,244,-285,-49,861,1970,2686,2662,2034,1335,1093,1433,2010,2309,2019,1214,278,-329,-346,127,682,884,576,-36,-594,-876,-916,-896,-975,-1199,-1519,-1836,-2049,-2097,-1993,-1811,-1633,-1496,-1380,-1233,-1006,-693,-339,-21,203,327,379,382,343,282,236,235,264,284,267,226,186,154,119,73,21,-37,-103,-172,-223,-238,-226,-232,-299,-433,-586,-683,-681,-601,-515,-484,-507,-529,-492,-392,-270,-173,-125,-119,-133,-138,-112,-52,24,85,117,119,107,94,91,106,130,146,134,88,16,-68,-145,-194,-204,-187,-177,-199,-245,-280,-275,-231,-175,-135,-128,-152,-190,-215,-203,-157,-108,-88,-104,-135,-153,-148,-126,-101,-88,-96,-129,-172,-193,-167,-99,-20,30,38,18,-6,-23,-33,-46,-65,-92,-125,-157,-177,-176,-161,-148,-152,-165,-169,-153,-126,-108,-109,-120,-128,-124,-108,-83,-49,-9,27,48,47,27,-1,-29,-52,-68,-77,-82,-89,-103,-124,-145,-159,-167,-177,-198,-225,-241,-231,-201,-166,-142,-130,-121,-112,-103,-93,-81,-66,-56,-58,-67,-66,-46,-16},
            {-5,-32,8,58,13,-83,-67,75,122,-41,-184,-45,200,137,-189,-233,151,298,-88,375,3586,8772,11452,7356,-2153,-9911,-9666,-2798,2895,1577,-4345,-7129,-2327,6573,12175,10733,5145,1367,3024,9235,16021,18824,14722,4328,-7552,-14211,-11835,-2994,4924,5500,-1759,-11560,-17406,-16274,-9911,-2783,1028,9,-4246,-8174,-8615,-5029,175,3659,3801,1638,-496,-979,284,2436,4484,5621,5379,3969,2398,1821,2531,3640,3867,2628,409,-1706,-2748,-2307,-708,1074,1916,1316,-205,-1545,-1957,-1562,-1030,-896,-1235,-1817,-2376,-2736,-2841,-2800,-2842,-3124,-3547,-3808,-3639,-2998,-2060,-1089,-303,200,475,659,862,1101,1353,1627,1932,2196,2283,2122,1792,1452,1195,1011,855,702,528,309,69,-109,-158,-129,-160,-340,-616,-845,-920,-853,-748,-721,-820,-991,-1112,-1078,-903,-707,-624,-690,-830,-924,-886,-711,-459,-227,-83,-29,-10,34,121,243,384,530,648,690,632,496,334,195,104,72,87,106,71,-37,-169,-243,-227,-169,-155,-229,-360,-473,-513,-476,-403,-348,-344,-385,-429,-426,-347,-212,-79,-7,-19,-97,-186,-224,-173,-39,125,247,289,267,225,195,177,154,114,57,-11,-74,-107,-100,-75,-79,-133,-212,-265,-271,-255,-257,-292,-343,-384,-395,-367,-299,-205,-108,-30,16,28,7,-36,-82,-109,-104,-77,-51,-51,-81,-123,-142,-120,-75,-51,-72,-122,-162,-168,-147,-121,-97,-76,-57,-42,-23,4,34,47,32,-3,-35,-52,-53,-51,-52,-61,-75,-83,-77,-60,-50,-56,-68,-65,-42,-12}
        },
        {    // H0e020a.wav
            {2,-1,-5,-4,-2,0,1,4,4,-2,-7,-1,10,7,-8,-9,10,20,-1,-27,-12,28,30,-20,-46,2,51,13,-56,-25,74,59,34,605,2241,4269,4908,2897,-811,-3452,-3008,-339,1597,784,-1784,-3218,-1734,1703,4561,5175,3937,2521,2413,4046,6708,8846,8757,5704,810,-3343,-4488,-2469,589,1945,297,-3427,-6939,-8248,-6860,-3918,-1353,-621,-1799,-3635,-4534,-3732,-1753,157,1037,801,75,-399,-224,533,1495,2206,2373,2029,1518,1251,1414,1837,2135,1989,1364,530,-107,-260,53,521,759,579,102,-382,-657,-711,-691,-755,-967,-1286,-1614,-1854,-1953,-1912,-1770,-1580,-1386,-1213,-1057,-886,-676,-439,-227,-85,-10,45,118,205,273,295,268,200,109,18,-47,-70,-60,-35,-11,2,-10,-55,-128,-198,-236,-239,-236,-260,-325,-409,-470,-482,-454,-422,-415,-424,-412,-359,-276,-198,-145,-118,-113,-125,-139,-133,-92,-28,33,68,80,78,70,63,63,71,75,58,15,-43,-103,-157,-195,-207,-190,-165,-161,-190,-235,-261,-249,-207,-163,-138,-140,-162,-183,-184,-161,-127,-104,-105,-127,-150,-157,-137,-99,-64,-53,-75,-117,-150,-148,-104,-39,19,45,33,-5,-43,-64,-68,-69,-87,-125,-167,-192,-193,-179,-165,-159,-154,-145,-131,-117,-105,-98,-95,-99,-104,-102,-88,-64,-41,-22,-10,-3,-5,-20,-42,-58,-61,-54,-50,-60,-86,-116,-138,-147,-150,-157,-168,-179,-186,-191,-190,-178,-154,-129,-118,-121,-120,-103,-81,-73,-81,-82,-59,-20},
            {-22,59,54,-53,-92,31,131,10,-181,-114,165,213,-107,-293,30,340,23,12,2471,7726,12013,10107,1231,-8552,-11533,-6284,689,1995,-2623,-6381,-3358,4946,11528,11425,6350,2220,3350,9330,16219,19442,16058,6290,-5788,-13794,-13227,-5385,3043,5137,-773,-10244,-16816,-16917,-11576,-4659,-37,330,-2932,-7036,-8651,-6200,-1144,3173,4292,2479,8,-1042,-191,1784,3873,5322,5622,4688,3177,2221,2461,3368,3681,2587,416,-1699,-2703,-2225,-668,1057,1987,1647,359,-1004,-1695,-1609,-1198,-988,-1210,-1772,-2417,-2890,-3079,-3096,-3217,-3637,-4252,-4677,-4503,-3568,-2080,-532,541,881,669,386,430,847,1414,1916,2287,2514,2535,2299,1881,1460,1172,1019,922,811,644,406,129,-99,-199,-203,-238,-402,-654,-859,-913,-833,-732,-730,-865,-1064,-1192,-1145,-945,-721,-606,-642,-773,-893,-902,-754,-485,-208,-40,-10,-41,-26,76,237,411,570,683,710,634,491,341,217,121,55,35,57,71,23,-76,-160,-174,-143,-147,-238,-392,-531,-596,-577,-513,-448,-410,-403,-407,-389,-323,-209,-86,-8,-12,-85,-175,-220,-180,-57,107,251,329,335,297,253,220,189,146,82,8,-56,-90,-91,-80,-93,-143,-213,-269,-290,-288,-293,-324,-381,-442,-473,-448,-364,-247,-130,-34,31,60,45,-8,-70,-106,-108,-92,-82,-89,-108,-126,-132,-117,-84,-58,-64,-103,-144,-156,-133,-97,-71,-62,-61,-55,-37,-8,17,25,9,-23,-54,-77,-89,-89,-80,-71,-67,-61,-43,-14,4,-9,-38,-50,-30,2,17,9}
        },
        {    // H0e025a.wav
            {-5,-2,2,2,-1,-2,-2,-1,-1,1,4,1,-3,0,8,9,-3,-8,5,18,5,-20,-16,18,31,-5,-39,-13,38,27,-32,-26,55,64,14,362,1611,3425,4386,3161,115,-2571,-2821,-800,1180,1024,-988,-2582,-1882,793,3468,4487,3792,2583,2184,3228,5413,7588,8182,6174,2100,-1954,-3732,-2570,71,1767,975,-1962,-5263,-7031,-6449,-4165,-1775,-749,-1471,-3053,-4083,-3710,-2197,-534,412,457,14,-354,-287,269,1106,1860,2191,2008,1557,1245,1324,1693,2008,1953,1460,731,105,-139,52,466,764,709,327,-156,-514,-676,-720,-758,-859,-1042,-1288,-1543,-1716,-1736,-1609,-1425,-1283,-1215,-1173,-1088,-931,-728,-526,-353,-211,-92,7,83,131,152,142,97,27,-49,-105,-128,-115,-65,13,87,111,56,-55,-160,-201,-173,-124,-113,-164,-254,-334,-371,-367,-357,-374,-416,-449,-434,-360,-255,-158,-101,-95,-124,-156,-154,-105,-28,40,71,64,35,5,-11,-6,14,34,34,6,-42,-95,-139,-164,-168,-156,-144,-151,-182,-220,-242,-233,-201,-168,-152,-162,-187,-205,-199,-170,-137,-117,-117,-129,-137,-130,-104,-63,-23,-6,-24,-67,-107,-119,-98,-58,-22,-7,-18,-44,-68,-77,-72,-68,-79,-108,-141,-166,-175,-171,-163,-155,-147,-139,-130,-117,-106,-103,-110,-123,-134,-133,-116,-88,-56,-30,-16,-15,-24,-40,-57,-65,-61,-49,-40,-45,-65,-89,-108,-115,-114,-110,-112,-123,-143,-160,-167,-163,-156,-154,-152,-146,-136,-127,-117,-96,-59,-19},
            {62,-42,-108,-9,130,72,-139,-173,78,244,16,-279,-110,299,178,-178,1228,5811,11306,12385,5876,-4752,-11619,-10055,-3399,791,-949,-4555,-3647,2926,9852,11375,7365,3034,3485,9239,16440,20153,17356,8317,-3323,-11940,-13148,-7224,510,3575,-545,-8708,-15205,-16374,-12621,-6988,-2586,-1106,-2537,-5348,-7123,-6027,-2318,1688,3544,2724,782,-333,124,1624,3292,4548,5077,4763,3883,3074,2785,2793,2464,1493,227,-760,-1197,-1119,-588,317,1243,1605,1076,-32,-1026,-1462,-1443,-1342,-1400,-1630,-1992,-2496,-3135,-3829,-4458,-4928,-5137,-4951,-4254,-3074,-1651,-368,440,671,532,395,535,967,1517,2018,2407,2651,2675,2426,1977,1509,1171,987,892,818,718,544,281,-9,-219,-303,-335,-427,-615,-821,-934,-918,-836,-799,-881,-1052,-1194,-1192,-1031,-808,-653,-628,-701,-785,-795,-679,-447,-186,-9,26,-25,-49,25,187,379,560,701,764,715,562,363,184,58,-12,-29,-3,38,47,0,-75,-128,-142,-160,-239,-390,-557,-661,-664,-589,-494,-423,-388,-373,-348,-292,-203,-102,-26,-7,-49,-124,-183,-179,-91,60,217,325,362,349,315,275,223,156,84,15,-41,-79,-94,-96,-108,-149,-211,-264,-287,-291,-307,-355,-428,-497,-527,-498,-409,-286,-162,-58,21,72,81,47,-14,-67,-92,-96,-95,-98,-106,-119,-131,-131,-112,-87,-82,-105,-136,-148,-132,-102,-78,-64,-55,-45,-33,-19,-5,1,-10,-38,-75,-110,-133,-139,-124,-96,-67,-38,-6,31,59,62,44,26,18,12,-2,-18,-22,-9}
        },
        {    // H0e030a.wav
            {0,-2,-3,-1,2,2,-1,-2,-1,-1,-2,-1,2,2,-1,-2,3,6,-1,-8,-1,12,8,-12,-17,8,27,4,-32,-24,22,33,-9,-23,32,57,2,170,1047,2589,3774,3296,988,-1615,-2515,-1223,682,1154,-221,-1866,-1913,-48,2368,3735,3568,2608,2008,2540,4233,6309,7425,6420,3295,-456,-2754,-2494,-422,1466,1466,-650,-3636,-5756,-5942,-4383,-2284,-1018,-1217,-2426,-3537,-3657,-2699,-1287,-178,256,131,-170,-275,13,654,1386,1876,1933,1655,1354,1303,1526,1804,1854,1541,969,412,136,224,521,739,665,301,-169,-534,-701,-707,-656,-643,-727,-916,-1170,-1413,-1577,-1637,-1615,-1550,-1467,-1366,-1239,-1081,-899,-717,-557,-429,-321,-221,-128,-52,0,37,67,91,97,82,56,43,60,109,164,187,154,75,-7,-55,-60,-52,-71,-140,-247,-356,-424,-437,-416,-405,-425,-464,-480,-441,-352,-242,-149,-95,-85,-99,-113,-105,-75,-39,-15,-8,-16,-27,-28,-9,26,60,70,48,1,-57,-114,-159,-182,-179,-161,-150,-165,-198,-226,-230,-209,-183,-169,-176,-197,-219,-225,-211,-180,-147,-122,-111,-108,-99,-76,-40,-5,9,-5,-41,-80,-103,-102,-82,-58,-46,-51,-68,-85,-91,-86,-79,-80,-95,-119,-139,-149,-151,-152,-156,-160,-159,-150,-139,-130,-127,-131,-142,-151,-148,-127,-96,-68,-51,-43,-39,-41,-50,-59,-61,-55,-45,-38,-36,-39,-48,-61,-71,-74,-76,-87,-106,-126,-142,-156,-170,-175,-167,-155,-154,-158,-143,-94,-31},
            {-76,-40,79,97,-64,-180,-29,199,120,-198,-225,165,299,-142,217,3447,9162,13086,10387,1101,-8661,-12091,-8305,-2773,-988,-2643,-2858,1419,7589,10440,8103,4097,3601,8439,15703,20397,18959,11154,86,-9191,-12312,-8566,-1846,1990,-342,-7107,-13453,-15591,-13289,-8949,-5148,-3210,-3287,-4710,-6063,-5704,-3043,630,3049,2981,1279,-101,84,1607,3458,4806,5275,4789,3586,2316,1701,1900,2315,2169,1229,-51,-1001,-1204,-636,403,1382,1748,1275,262,-698,-1196,-1250,-1151,-1159,-1394,-1899,-2685,-3686,-4711,-5490,-5768,-5416,-4515,-3354,-2274,-1468,-903,-454,-50,313,657,1027,1420,1766,2022,2220,2396,2491,2399,2108,1735,1411,1167,967,785,621,451,233,-15,-208,-287,-299,-358,-521,-743,-927,-1007,-985,-926,-923,-1025,-1178,-1250,-1154,-933,-721,-616,-607,-623,-609,-546,-426,-262,-105,-8,24,50,130,268,425,572,691,751,706,552,346,172,67,12,-20,-38,-44,-55,-88,-134,-162,-165,-175,-238,-366,-513,-615,-629,-567,-473,-397,-362,-356,-343,-293,-206,-107,-31,-4,-33,-100,-166,-179,-107,41,206,325,369,356,323,288,248,190,113,25,-62,-127,-153,-140,-122,-135,-188,-251,-288,-297,-307,-350,-426,-505,-548,-530,-452,-333,-201,-82,14,78,103,87,42,-12,-56,-86,-102,-112,-120,-131,-140,-134,-105,-69,-58,-86,-135,-169,-170,-148,-121,-96,-71,-50,-36,-26,-13,-3,-7,-36,-79,-120,-149,-165,-164,-141,-97,-43,11,61,101,121,112,84,55,38,24,1,-28,-44,-36,-13}
        },
        {    // H0e035a.wav
            {-4,-3,1,1,-1,-2,0,2,0,-1,-1,-1,-1,-1,2,3,1,-2,1,5,1,-6,-4,9,13,-3,-18,-5,20,16,-17,-30,3,35,16,-17,1,37,14,70,601,1785,3036,3219,1741,-576,-2001,-1519,103,1077,425,-1057,-1708,-695,1286,2848,3193,2598,1951,2055,3199,4999,6445,6372,4317,1111,-1501,-2125,-813,994,1617,364,-2102,-4361,-5234,-4469,-2791,-1371,-1054,-1844,-2975,-3515,-3035,-1834,-609,77,124,-171,-384,-230,315,1038,1626,1855,1728,1456,1304,1398,1645,1813,1705,1298,758,334,190,298,468,496,304,-23,-321,-479,-497,-466,-491,-633,-887,-1189,-1462,-1648,-1728,-1714,-1636,-1536,-1447,-1378,-1302,-1180,-1000,-794,-605,-457,-337,-225,-115,-9,100,214,318,378,373,317,254,222,228,253,269,252,193,99,-4,-83,-129,-165,-226,-324,-430,-500,-512,-486,-465,-469,-484,-481,-444,-378,-299,-217,-146,-105,-106,-132,-147,-126,-73,-19,17,33,37,34,29,32,50,74,79,45,-23,-98,-155,-182,-183,-168,-154,-155,-174,-200,-216,-214,-201,-190,-193,-213,-236,-246,-229,-187,-142,-112,-104,-105,-99,-78,-43,-3,27,28,-5,-58,-102,-116,-100,-72,-55,-57,-73,-90,-99,-97,-91,-89,-96,-110,-126,-139,-145,-142,-134,-131,-137,-150,-158,-158,-157,-161,-167,-162,-143,-119,-101,-90,-80,-68,-55,-44,-39,-40,-43,-42,-31,-16,-7,-10,-21,-36,-52,-67,-78,-80,-81,-96,-123,-144,-147,-143,-155,-178,-176,-123,-43},
            {-4,105,41,-131,-125,103,197,-54,-272,-27,329,87,-262,1325,6094,11716,13116,7270,-2947,-10732,-11656,-7511,-3511,-2315,-1844,1021,5870,8996,7927,4647,3761,7831,14888,20168,19810,13250,3236,-5769,-9903,-8157,-3235,195,-994,-6029,-11286,-13636,-12723,-10290,-7986,-6293,-5157,-4717,-4940,-5004,-3800,-1225,1415,2610,2126,1093,799,1653,3212,4753,5573,5125,3407,1323,248,859,2401,3324,2684,894,-823,-1513,-1047,76,1181,1727,1488,656,-267,-818,-900,-785,-841,-1288,-2147,-3304,-4537,-5532,-5973,-5698,-4815,-3669,-2660,-2020,-1703,-1467,-1097,-553,75,696,1263,1718,1982,2046,2028,2067,2176,2237,2152,1947,1705,1456,1173,855,548,285,56,-140,-255,-258,-222,-274,-464,-710,-891,-965,-978,-996,-1046,-1126,-1217,-1266,-1212,-1034,-795,-598,-499,-482,-489,-478,-430,-341,-213,-63,84,215,327,430,529,623,695,711,643,500,333,194,104,42,-19,-86,-152,-211,-255,-269,-237,-178,-145,-193,-323,-474,-570,-577,-514,-430,-362,-320,-296,-276,-242,-185,-112,-51,-30,-54,-99,-133,-129,-77,21,146,265,343,366,348,312,266,205,120,17,-87,-164,-196,-187,-168,-174,-213,-259,-285,-287,-290,-318,-374,-442,-503,-532,-504,-410,-271,-125,1,94,150,156,111,32,-43,-89,-109,-118,-128,-137,-140,-128,-103,-73,-61,-81,-124,-163,-180,-175,-162,-145,-122,-91,-58,-29,-6,5,-5,-38,-83,-122,-150,-166,-167,-144,-97,-42,8,50,90,121,130,112,84,62,43,17,-14,-28,-16,8,18,10}
        },
        {    // H0e040a.wav
            {1,0,-1,-2,0,1,0,-1,-1,1,1,0,-1,-1,-2,-2,1,3,2,-1,-1,3,3,-2,-3,4,10,0,-14,-10,12,19,-6,-27,-9,28,26,-11,-16,26,35,25,270,1077,2248,2925,2265,429,-1293,-1599,-468,788,867,-223,-1253,-1081,281,1845,2655,2528,1987,1763,2350,3740,5306,6007,5050,2621,-36,-1457,-1076,358,1409,1048,-690,-2854,-4286,-4336,-3207,-1773,-996,-1301,-2315,-3189,-3243,-2422,-1235,-306,53,-49,-268,-280,59,675,1331,1761,1835,1642,1417,1363,1494,1645,1617,1333,884,461,226,222,362,487,463,258,-57,-368,-596,-734,-822,-910,-1024,-1168,-1336,-1510,-1662,-1760,-1785,-1746,-1671,-1579,-1462,-1299,-1084,-843,-615,-426,-275,-143,-8,138,289,424,523,573,575,538,469,386,313,275,264,245,183,71,-60,-175,-258,-319,-373,-430,-485,-529,-551,-550,-532,-512,-497,-482,-456,-414,-354,-286,-218,-164,-129,-109,-92,-63,-21,26,62,77,69,50,35,36,52,68,69,47,3,-55,-116,-162,-181,-173,-156,-152,-172,-208,-240,-252,-243,-223,-210,-212,-223,-228,-216,-189,-155,-123,-101,-90,-87,-80,-60,-29,-2,3,-17,-50,-81,-98,-100,-91,-79,-70,-72,-85,-101,-107,-99,-84,-78,-87,-105,-117,-121,-123,-133,-147,-156,-161,-165,-171,-171,-163,-153,-151,-157,-154,-137,-112,-91,-74,-55,-34,-21,-22,-27,-25,-17,-9,-4,-3,-8,-25,-48,-63,-67,-71,-84,-100,-108,-115,-135,-163,-164,-116,-40},
            {88,-90,-179,2,221,112,-214,-221,190,322,-182,-21,2915,8595,13258,12078,4096,-6037,-12008,-11508,-7498,-4048,-1986,668,4755,8018,7781,4779,3182,6490,13796,20308,21295,15540,5772,-3405,-8161,-7398,-3310,-22,-684,-5089,-10053,-12401,-11652,-9790,-8740,-8557,-8112,-6879,-5445,-4407,-3467,-2002,-175,1088,1256,942,1268,2665,4482,5643,5479,4042,2024,486,332,1599,3230,3836,2877,1066,-400,-898,-630,-79,474,901,1028,741,216,-178,-275,-314,-694,-1593,-2854,-4155,-5186,-5711,-5613,-4972,-4068,-3233,-2649,-2278,-1956,-1540,-1007,-435,84,541,989,1441,1808,1984,1984,1944,1974,2046,2062,1986,1855,1678,1405,1010,564,184,-70,-208,-255,-233,-214,-297,-505,-741,-876,-895,-893,-956,-1084,-1224,-1336,-1382,-1305,-1076,-767,-522,-433,-463,-504,-488,-411,-292,-137,34,180,280,363,473,611,728,775,743,649,507,337,173,50,-29,-95,-175,-259,-315,-321,-283,-226,-182,-180,-237,-340,-450,-520,-523,-464,-377,-302,-266,-266,-268,-233,-153,-60,4,18,-5,-41,-78,-106,-102,-44,66,188,278,323,340,347,331,268,154,13,-118,-213,-261,-265,-242,-224,-235,-270,-299,-298,-275,-264,-296,-371,-458,-515,-511,-439,-316,-170,-25,97,177,199,162,87,9,-50,-91,-123,-145,-151,-140,-121,-100,-82,-74,-89,-129,-178,-208,-210,-194,-177,-159,-131,-88,-42,-9,6,3,-16,-51,-98,-144,-172,-169,-134,-80,-25,17,46,71,96,113,111,88,59,37,19,-3,-29,-36,-8,42,74,65,25}
        },
        {    // H0e045a.wav
            {3,1,1,0,0,0,0,0,-1,-1,-1,2,2,1,-1,-2,-1,0,2,4,2,-2,-3,2,7,5,-2,-1,6,6,-4,-8,5,19,10,-14,-15,14,31,9,-12,10,36,17,89,552,1488,2395,2436,1262,-424,-1353,-883,338,1013,496,-612,-1141,-512,828,1960,2318,2025,1646,1773,2687,4132,5321,5341,3841,1463,-502,-1053,-222,985,1387,466,-1352,-3066,-3786,-3286,-2112,-1183,-1151,-1957,-2914,-3261,-2717,-1619,-579,-25,20,-168,-256,-40,483,1138,1659,1837,1663,1344,1149,1207,1421,1567,1479,1166,770,452,293,267,276,216,31,-253,-555,-792,-925,-975,-993,-1033,-1132,-1300,-1512,-1716,-1850,-1881,-1812,-1682,-1529,-1366,-1180,-956,-705,-465,-269,-124,2,139,295,448,574,659,698,687,624,523,416,331,272,218,146,48,-70,-193,-303,-383,-424,-442,-463,-506,-560,-596,-595,-568,-541,-525,-509,-475,-419,-349,-272,-192,-119,-69,-49,-45,-32,3,44,70,76,71,68,66,62,58,55,52,40,12,-29,-75,-119,-154,-178,-193,-205,-220,-239,-254,-256,-242,-218,-196,-187,-191,-201,-202,-186,-157,-126,-107,-102,-105,-104,-94,-73,-49,-31,-30,-46,-70,-90,-94,-80,-58,-42,-42,-56,-74,-85,-84,-78,-72,-71,-78,-96,-122,-143,-153,-152,-152,-157,-161,-159,-159,-166,-176,-178,-165,-146,-131,-118,-97,-70,-43,-25,-14,-5,0,-1,-6,-8,-6,-7,-18,-35,-54,-71,-84,-88,-85,-86,-103,-127,-129,-91,-32},
            {-95,-98,79,185,-11,-255,-98,290,185,-328,498,4462,10468,14007,10829,1483,-8467,-13270,-11824,-7434,-3441,-202,3404,6822,7745,5403,2753,4200,10969,19221,23026,19207,9597,-708,-6948,-7376,-3791,-100,276,-3266,-8199,-11145,-10869,-9092,-8323,-9159,-10004,-9247,-7099,-5011,-3774,-2843,-1518,-109,552,466,717,2183,4371,5814,5516,3796,1838,726,878,2021,3380,4028,3454,1971,478,-316,-387,-162,56,277,537,679,529,161,-193,-485,-971,-1927,-3278,-4573,-5328,-5378,-4925,-4312,-3762,-3312,-2907,-2501,-2059,-1520,-850,-127,464,790,911,1013,1215,1477,1696,1843,1949,2008,1981,1876,1767,1682,1531,1210,746,296,-8,-165,-248,-299,-328,-367,-475,-658,-843,-944,-954,-955,-1032,-1205,-1407,-1526,-1463,-1208,-855,-549,-384,-356,-395,-424,-389,-266,-73,129,273,351,412,505,621,717,763,761,703,567,358,133,-36,-124,-173,-230,-297,-338,-328,-280,-228,-200,-206,-248,-324,-416,-490,-508,-458,-368,-292,-265,-278,-282,-235,-137,-22,68,106,95,49,-11,-63,-90,-78,-26,57,153,245,320,365,365,306,191,45,-102,-223,-301,-331,-324,-303,-296,-309,-320,-302,-261,-232,-248,-315,-402,-473,-498,-465,-374,-238,-82,66,174,223,208,148,72,2,-57,-108,-147,-163,-156,-133,-105,-81,-68,-80,-122,-180,-229,-252,-256,-249,-232,-196,-139,-76,-23,7,13,-2,-31,-70,-110,-141,-152,-133,-89,-33,16,54,82,99,101,90,70,48,22,-7,-33,-47,-46,-32,-4,39,83,99,73,25}
        },
        {    // H0e050a.wav
            {1,2,1,0,0,2,2,0,0,0,1,0,-1,-1,-1,-1,-1,-1,-1,-2,-1,0,2,1,-2,-1,2,3,-1,-4,0,5,1,-8,-6,9,15,0,-15,-4,20,20,-2,-4,22,21,17,214,835,1727,2256,1799,464,-801,-1019,-146,851,950,78,-878,-979,-88,1138,1925,1993,1645,1459,1903,3042,4398,5129,4566,2781,676,-609,-520,518,1453,1373,113,-1695,-3080,-3385,-2681,-1673,-1169,-1495,-2296,-2877,-2754,-1970,-969,-215,97,66,-56,-32,251,738,1239,1542,1558,1390,1246,1275,1455,1620,1589,1279,755,192,-209,-337,-236,-79,-57,-244,-570,-893,-1108,-1193,-1189,-1157,-1155,-1224,-1373,-1557,-1697,-1730,-1647,-1486,-1299,-1111,-917,-709,-497,-301,-137,2,133,265,391,500,584,644,672,656,586,474,349,236,142,61,-15,-96,-187,-290,-392,-467,-495,-489,-487,-516,-571,-618,-627,-597,-546,-495,-449,-402,-350,-290,-220,-142,-74,-34,-30,-47,-53,-31,17,68,104,112,96,66,38,26,31,41,40,15,-32,-90,-145,-185,-207,-212,-210,-212,-222,-238,-248,-242,-221,-195,-179,-181,-193,-202,-197,-179,-155,-137,-130,-132,-134,-126,-104,-72,-42,-25,-28,-46,-67,-76,-65,-40,-19,-16,-33,-58,-77,-80,-71,-60,-61,-80,-112,-141,-158,-160,-156,-153,-157,-167,-178,-183,-180,-170,-160,-153,-144,-129,-109,-90,-71,-48,-23,-6,-4,-14,-24,-31,-35,-41,-45,-48,-55,-69,-83,-86,-78,-73,-77,-76,-55,-20},
            {-101,133,200,-63,-281,-43,322,97,-357,926,5498,11653,14511,10129,-210,-10424,-14789,-12490,-7027,-1900,2071,5338,7177,6219,3301,2280,6669,15433,22874,23227,15506,4112,-4816,-7683,-5151,-885,1151,-832,-5480,-9531,-10566,-9021,-7493,-7955,-9804,-10783,-9546,-6902,-4566,-3263,-2447,-1524,-657,-179,239,1293,2997,4393,4525,3450,2132,1478,1721,2585,3639,4370,4244,3096,1470,281,1,278,448,286,99,177,390,382,-10,-698,-1590,-2691,-3885,-4807,-5088,-4732,-4149,-3774,-3699,-3679,-3430,-2871,-2108,-1286,-507,151,617,866,950,979,1042,1168,1335,1515,1677,1785,1810,1768,1712,1662,1564,1331,951,523,171,-56,-195,-290,-352,-391,-455,-591,-773,-922,-990,-1021,-1101,-1263,-1457,-1589,-1580,-1397,-1067,-682,-373,-234,-250,-314,-312,-208,-33,154,317,439,516,556,588,638,707,753,720,584,372,152,-13,-103,-147,-193,-265,-346,-398,-395,-336,-251,-177,-152,-196,-303,-429,-514,-519,-456,-370,-304,-269,-243,-202,-135,-43,57,137,165,135,69,8,-28,-43,-43,-16,52,151,253,325,355,338,264,129,-44,-209,-320,-366,-367,-354,-347,-348,-346,-325,-283,-236,-215,-242,-313,-403,-474,-493,-440,-318,-155,7,134,210,236,213,149,63,-20,-85,-128,-154,-161,-142,-103,-60,-36,-44,-84,-142,-201,-250,-284,-304,-305,-282,-235,-172,-104,-43,4,27,21,-9,-49,-87,-115,-129,-117,-72,-2,65,107,125,128,124,106,70,22,-27,-71,-102,-113,-92,-39,28,83,109,102,74,38,10}
        },
        {    // H0e055a.wav
            {1,1,1,2,2,2,1,1,1,1,1,1,1,1,-1,-2,-1,0,0,0,0,0,0,0,0,1,0,-1,1,2,0,-3,-2,3,4,-2,-4,4,14,8,-10,-12,10,26,12,-7,5,23,10,48,362,1053,1794,1954,1197,-32,-781,-475,475,1051,636,-388,-1055,-748,302,1345,1802,1661,1365,1444,2177,3393,4481,4715,3762,2022,431,-188,272,1149,1518,862,-600,-2111,-2914,-2746,-1978,-1307,-1239,-1749,-2359,-2539,-2093,-1246,-428,34,88,-74,-165,17,485,1069,1532,1724,1655,1455,1259,1122,1015,871,636,302,-70,-364,-479,-417,-304,-304,-489,-789,-1060,-1202,-1206,-1125,-1022,-953,-964,-1065,-1217,-1344,-1381,-1317,-1182,-1009,-819,-626,-449,-302,-187,-87,17,132,248,353,438,497,525,519,477,406,320,227,127,20,-86,-173,-232,-278,-334,-404,-470,-509,-520,-521,-531,-547,-552,-537,-501,-454,-401,-348,-302,-265,-232,-194,-143,-90,-54,-43,-47,-43,-19,18,50,67,72,69,57,35,12,-1,-2,-5,-26,-64,-104,-136,-159,-177,-191,-197,-199,-208,-230,-253,-260,-244,-215,-192,-186,-193,-202,-203,-194,-176,-154,-136,-125,-118,-110,-93,-70,-47,-35,-35,-42,-48,-48,-40,-26,-11,-7,-20,-43,-62,-68,-66,-69,-83,-102,-117,-128,-140,-152,-160,-164,-168,-174,-178,-175,-163,-150,-142,-138,-132,-122,-110,-98,-87,-78,-69,-60,-52,-49,-51,-53,-50,-44,-40,-41,-44,-45,-47,-54,-62,-60,-41,-14},
            {76,143,-38,-217,-30,285,82,-313,1032,5738,12140,15152,10469,-724,-11886,-16543,-13480,-6547,-141,4097,6418,6686,4609,1946,2614,9067,18678,24818,22324,12058,155,-6987,-7178,-2997,975,1461,-1792,-6411,-9394,-9435,-7839,-7106,-8389,-10381,-10821,-8930,-6067,-4055,-3301,-2839,-1869,-673,58,307,714,1639,2659,3101,2812,2223,1876,2079,2897,4111,5097,5078,3803,1933,539,151,413,670,675,605,562,344,-258,-1156,-2107,-3016,-3923,-4725,-5101,-4853,-4213,-3687,-3582,-3734,-3718,-3250,-2378,-1358,-434,265,717,953,1041,1060,1072,1107,1166,1253,1375,1525,1651,1687,1617,1497,1394,1306,1150,865,487,132,-113,-244,-312,-364,-429,-526,-662,-810,-939,-1049,-1183,-1374,-1586,-1728,-1716,-1524,-1197,-826,-513,-323,-250,-229,-190,-107,11,154,316,476,590,625,597,566,576,625,670,659,556,362,125,-79,-188,-212,-221,-281,-384,-463,-454,-357,-230,-142,-131,-198,-317,-443,-522,-517,-440,-340,-273,-249,-236,-190,-94,32,146,211,212,162,87,15,-41,-72,-64,-5,96,208,292,334,336,299,210,63,-117,-280,-386,-426,-425,-407,-387,-364,-335,-294,-246,-208,-203,-246,-328,-419,-479,-478,-406,-276,-116,41,167,241,252,202,116,26,-44,-92,-129,-153,-154,-125,-77,-34,-17,-30,-69,-128,-196,-257,-303,-332,-343,-335,-298,-233,-152,-75,-16,18,26,9,-27,-72,-109,-121,-98,-40,36,105,148,164,162,149,120,70,4,-64,-117,-148,-152,-129,-78,-6,67,113,120,93,53,21,5}
        },
        {    // H0e060a.wav
            {-1,-1,0,0,0,0,1,1,1,1,1,1,1,0,-1,0,-1,-2,-2,-2,-1,-2,-1,-1,0,-1,-2,-1,0,-1,-2,-1,0,-3,-5,-3,4,6,2,0,4,5,-5,-14,-2,21,27,8,-6,4,6,-3,105,515,1192,1723,1595,750,-202,-486,68,804,881,129,-787,-1031,-375,679,1434,1589,1371,1255,1627,2560,3734,4531,4370,3154,1459,203,-8,663,1432,1495,598,-846,-2094,-2589,-2280,-1605,-1147,-1227,-1710,-2145,-2134,-1617,-868,-242,82,168,203,333,594,924,1205,1315,1193,888,553,345,314,371,355,159,-190,-554,-781,-805,-683,-552,-537,-663,-852,-985,-989,-874,-714,-588,-552,-621,-765,-919,-1011,-994,-877,-710,-552,-432,-349,-284,-220,-149,-66,28,122,202,257,290,305,303,277,224,147,59,-31,-115,-185,-236,-272,-306,-353,-413,-466,-488,-474,-442,-413,-402,-404,-406,-394,-360,-312,-265,-235,-222,-214,-196,-161,-118,-79,-54,-41,-37,-36,-33,-23,-2,22,36,29,4,-23,-39,-41,-40,-47,-64,-84,-105,-128,-158,-187,-206,-215,-222,-236,-256,-265,-255,-227,-199,-184,-181,-182,-179,-168,-151,-134,-119,-110,-107,-104,-96,-79,-56,-37,-30,-35,-44,-46,-37,-25,-16,-17,-25,-38,-53,-67,-75,-76,-72,-75,-90,-114,-136,-149,-155,-160,-168,-174,-173,-163,-152,-146,-147,-152,-153,-151,-148,-143,-134,-117,-94,-74,-60,-49,-36,-24,-19,-21,-21,-16,-15,-28,-49,-60,-46,-16},
            {167,-43,-255,-82,294,181,-313,648,5052,11817,15890,12068,485,-12284,-18426,-15353,-6923,1097,5731,7136,6162,3510,1220,2850,10251,20203,25710,21805,10208,-1980,-8132,-6835,-1753,2103,1947,-1691,-6130,-8701,-8601,-7302,-7067,-8693,-10683,-10832,-8578,-5514,-3570,-3069,-2838,-1959,-827,-357,-594,-617,265,1640,2514,2442,1900,1670,2130,3152,4352,5235,5291,4326,2763,1430,878,956,1138,1122,970,728,187,-837,-2152,-3303,-4031,-4447,-4735,-4860,-4680,-4274,-3951,-3904,-3949,-3703,-2963,-1867,-727,199,799,1071,1106,1049,1030,1080,1147,1192,1243,1344,1473,1552,1528,1431,1336,1278,1213,1061,788,436,100,-136,-244,-263,-279,-369,-557,-786,-970,-1070,-1141,-1272,-1487,-1711,-1827,-1764,-1534,-1194,-814,-475,-247,-147,-116,-67,36,165,278,372,468,558,605,593,559,562,620,684,685,580,385,155,-47,-181,-247,-281,-326,-395,-456,-457,-375,-249,-156,-152,-236,-354,-446,-481,-460,-403,-334,-281,-258,-241,-188,-73,77,203,257,236,170,91,18,-40,-71,-60,-1,98,213,314,371,370,309,192,28,-156,-323,-438,-489,-485,-450,-401,-349,-299,-252,-208,-179,-184,-236,-323,-415,-478,-487,-429,-305,-131,50,188,253,246,190,110,27,-46,-100,-136,-155,-151,-119,-62,-5,25,12,-39,-110,-183,-249,-305,-349,-375,-371,-332,-263,-179,-103,-44,-8,4,-6,-36,-74,-104,-110,-80,-14,70,145,185,189,174,153,124,76,11,-59,-115,-148,-155,-134,-86,-19,45,85,91,71,42,18,6,2}
        },
        {    // H0e065a.wav
            {3,4,3,2,3,4,5,5,4,4,4,5,5,5,4,4,4,4,4,3,3,4,6,6,6,6,6,5,4,6,8,7,4,3,7,9,7,4,7,14,16,10,3,4,8,10,15,27,33,17,-6,-8,11,15,27,192,640,1245,1590,1315,547,-110,-130,376,751,472,-293,-857,-701,65,905,1387,1493,1482,1623,2053,2751,3502,3907,3601,2590,1378,641,699,1245,1596,1239,188,-1073,-1959,-2168,-1822,-1342,-1138,-1327,-1671,-1785,-1453,-783,-104,302,370,227,53,-29,25,195,402,531,492,292,41,-144,-226,-264,-343,-485,-634,-710,-677,-568,-462,-423,-456,-512,-529,-473,-361,-240,-163,-162,-243,-384,-541,-659,-704,-669,-577,-470,-386,-346,-345,-350,-324,-255,-157,-63,6,48,71,79,73,54,28,-3,-41,-91,-153,-217,-266,-290,-292,-287,-288,-297,-306,-307,-300,-290,-283,-281,-280,-275,-259,-233,-203,-185,-184,-194,-197,-180,-146,-105,-75,-63,-68,-79,-84,-74,-52,-28,-12,-8,-12,-20,-30,-39,-46,-52,-59,-69,-87,-113,-144,-173,-196,-212,-221,-226,-224,-217,-204,-187,-166,-146,-131,-126,-128,-129,-125,-118,-110,-103,-95,-83,-73,-67,-62,-54,-43,-33,-32,-35,-36,-29,-17,-9,-9,-16,-24,-31,-38,-44,-51,-58,-69,-88,-112,-135,-150,-156,-161,-168,-176,-180,-179,-174,-170,-166,-161,-155,-148,-138,-120,-97,-73,-52,-34,-18,-6,0,3,4,0,-13,-29,-38,-30,-11},
            {121,-218,-254,164,332,-174,53,3504,10348,16145,14594,3760,-10737,-19741,-18249,-9003,1077,7016,8161,6177,2911,665,2521,10028,20125,25925,22169,10263,-2493,-8904,-7256,-1483,2949,3086,-443,-4920,-7774,-8167,-7279,-7104,-8520,-10381,-10683,-8692,-5695,-3540,-2757,-2442,-1799,-1178,-1337,-2072,-2181,-875,1186,2550,2492,1623,1090,1506,2701,4153,5309,5642,4862,3285,1807,1212,1500,2006,2127,1756,1041,-2,-1402,-2887,-3943,-4313,-4275,-4298,-4513,-4683,-4627,-4459,-4353,-4214,-3751,-2834,-1658,-537,347,959,1288,1332,1173,990,920,977,1097,1244,1404,1531,1551,1450,1310,1233,1234,1225,1100,817,434,66,-174,-245,-202,-169,-264,-513,-844,-1132,-1291,-1330,-1337,-1407,-1559,-1720,-1777,-1654,-1354,-950,-546,-235,-60,3,26,71,158,268,375,458,503,509,505,540,635,753,818,772,611,379,138,-50,-147,-166,-177,-251,-389,-513,-533,-431,-275,-160,-139,-209,-330,-450,-518,-505,-424,-325,-261,-245,-239,-192,-81,68,200,270,260,190,96,13,-39,-57,-42,6,87,189,287,354,372,333,229,60,-145,-331,-451,-492,-484,-457,-420,-366,-298,-232,-180,-150,-149,-191,-281,-397,-490,-518,-465,-343,-177,0,152,241,253,202,120,34,-42,-106,-155,-177,-158,-102,-30,26,48,35,-7,-73,-158,-248,-321,-363,-375,-364,-330,-270,-192,-117,-61,-30,-18,-23,-49,-90,-124,-125,-80,1,91,158,187,184,166,147,126,96,50,-9,-74,-129,-155,-136,-76,-3,47,62,53,35,17,-1,-14,-16,-7}
        },
        {    // H0e070a.wav
            {0,0,0,0,0,0,0,0,1,1,1,2,3,2,1,1,2,2,2,1,0,-1,-1,0,1,1,0,-1,-1,0,2,4,3,0,-2,0,5,6,0,-6,-2,10,16,7,-6,-5,9,17,12,7,12,15,1,-15,-8,14,19,51,249,702,1237,1471,1156,496,13,43,376,489,129,-399,-547,-93,667,1235,1367,1209,1095,1295,1895,2772,3599,3953,3571,2597,1552,970,1005,1327,1406,908,-85,-1158,-1843,-1902,-1463,-907,-604,-665,-911,-1070,-1004,-790,-601,-539,-583,-647,-650,-554,-371,-162,-35,-79,-294,-571,-760,-771,-627,-433,-294,-257,-302,-360,-365,-289,-164,-46,24,50,65,95,132,142,93,-22,-181,-345,-476,-556,-581,-566,-532,-508,-514,-545,-566,-542,-467,-373,-299,-256,-225,-189,-149,-121,-108,-104,-103,-114,-143,-179,-203,-201,-177,-148,-128,-124,-140,-169,-199,-216,-211,-194,-180,-180,-192,-204,-208,-205,-205,-212,-221,-222,-211,-196,-184,-173,-161,-146,-136,-134,-130,-112,-82,-54,-41,-45,-54,-61,-66,-73,-79,-81,-80,-87,-108,-142,-175,-195,-198,-189,-178,-170,-162,-153,-143,-136,-134,-132,-128,-124,-125,-129,-127,-115,-102,-100,-109,-117,-113,-99,-83,-71,-58,-41,-25,-18,-19,-21,-20,-16,-17,-25,-33,-36,-37,-44,-65,-94,-121,-140,-156,-175,-193,-201,-200,-197,-197,-197,-191,-179,-169,-165,-159,-141,-116,-94,-83,-76,-65,-50,-36,-25,-15,-10,-16,-32,-43,-36,-14},
            {-31,-275,-52,339,84,-340,1523,7465,14875,17079,9206,-5960,-19012,-21676,-13584,-1499,7227,9740,7454,3246,129,1204,8146,18503,25695,23687,12509,-1154,-9306,-8777,-2683,3160,4799,2027,-2709,-6541,-7982,-7573,-7130,-7999,-9719,-10504,-9143,-6292,-3719,-2470,-2138,-1902,-1747,-2231,-3240,-3609,-2301,269,2466,2999,2068,966,818,1829,3468,4967,5639,5130,3711,2239,1556,1788,2330,2519,2174,1452,414,-998,-2585,-3819,-4298,-4187,-4025,-4146,-4434,-4629,-4683,-4684,-4561,-4073,-3105,-1860,-687,209,826,1203,1331,1224,1005,837,811,917,1108,1340,1538,1607,1516,1346,1235,1233,1251,1149,867,477,119,-104,-177,-159,-146,-233,-466,-801,-1122,-1314,-1362,-1355,-1403,-1533,-1677,-1739,-1657,-1421,-1064,-664,-326,-130,-69,-61,-22,74,203,335,446,510,509,473,474,572,743,891,912,766,496,198,-27,-125,-126,-117,-184,-332,-486,-548,-477,-319,-170,-114,-178,-322,-472,-561,-563,-495,-398,-315,-270,-248,-205,-103,52,204,289,280,202,102,20,-28,-41,-25,14,74,150,232,302,337,317,232,85,-105,-292,-427,-485,-479,-441,-395,-346,-291,-234,-187,-156,-151,-184,-263,-377,-487,-548,-528,-418,-240,-39,130,225,237,187,107,22,-54,-113,-154,-176,-170,-130,-61,13,57,54,11,-55,-133,-217,-298,-360,-391,-388,-353,-292,-215,-136,-71,-28,-12,-24,-59,-102,-137,-147,-122,-57,34,119,167,171,154,142,137,116,67,0,-62,-107,-130,-122,-75,-2,57,74,58,32,5,-32,-76,-99,-79,-29}
        },
        {    // H0e075a.wav
            {0,0,0,0,-1,-1,-1,-1,0,0,0,0,0,1,1,1,1,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-2,0,3,3,-1,-6,-3,8,18,14,-1,-12,-5,11,19,17,13,11,2,-13,-14,6,20,11,56,298,778,1282,1450,1103,471,31,71,421,645,476,53,-248,-176,224,720,1104,1316,1449,1686,2188,2943,3673,3959,3545,2583,1570,989,965,1208,1271,892,158,-598,-1039,-1052,-799,-595,-688,-1092,-1594,-1917,-1909,-1629,-1271,-1020,-946,-1001,-1077,-1085,-998,-861,-750,-719,-750,-763,-674,-465,-199,24,139,153,122,107,141,223,330,430,495,507,467,389,282,151,2,-152,-291,-407,-506,-594,-666,-710,-727,-732,-742,-754,-747,-704,-632,-552,-476,-406,-339,-280,-235,-201,-169,-134,-99,-73,-55,-41,-28,-15,-7,-5,-12,-29,-58,-92,-119,-132,-130,-125,-130,-150,-182,-212,-232,-243,-252,-265,-278,-284,-279,-264,-240,-212,-188,-170,-161,-156,-148,-132,-111,-91,-76,-71,-75,-81,-86,-87,-87,-87,-89,-90,-91,-97,-107,-120,-127,-127,-121,-120,-125,-134,-137,-133,-125,-120,-122,-127,-133,-138,-143,-147,-148,-142,-130,-114,-95,-74,-53,-36,-26,-23,-23,-24,-25,-26,-26,-27,-29,-38,-53,-72,-89,-103,-114,-128,-146,-165,-180,-189,-196,-202,-203,-196,-183,-173,-168,-159,-141,-123,-114,-116,-118,-110,-96,-83,-71,-54,-36,-27,-33,-40,-34,-13},
            {-201,-194,224,347,-279,-98,3695,11264,17485,15185,2419,-13957,-23237,-19919,-7758,4576,10789,10106,5404,542,-675,4381,14663,24290,25947,17049,2602,-8601,-10927,-5524,1931,6132,5245,776,-4303,-7494,-8080,-7321,-7204,-8517,-10060,-9938,-7604,-4418,-2189,-1525,-1790,-2331,-3153,-4259,-4858,-3847,-1149,1803,3239,2675,1246,522,1188,2802,4444,5361,5193,4053,2577,1639,1695,2369,2817,2512,1593,461,-697,-1875,-2907,-3473,-3498,-3361,-3533,-4093,-4695,-4986,-4906,-4574,-4044,-3283,-2328,-1333,-442,297,867,1197,1222,1003,724,575,637,880,1210,1507,1648,1584,1393,1236,1223,1308,1320,1114,693,212,-134,-245,-161,-34,-27,-229,-606,-1015,-1296,-1384,-1351,-1336,-1427,-1592,-1721,-1714,-1533,-1204,-802,-434,-195,-116,-145,-186,-160,-32,178,401,548,565,495,444,501,659,834,934,900,717,425,124,-67,-109,-81,-112,-255,-437,-535,-487,-329,-159,-71,-111,-264,-458,-603,-642,-578,-460,-351,-291,-275,-254,-167,-5,177,295,309,239,136,39,-29,-51,-27,22,68,111,172,255,326,337,267,127,-52,-238,-391,-475,-477,-422,-350,-286,-234,-193,-166,-154,-157,-186,-256,-365,-478,-548,-545,-461,-308,-112,79,206,236,182,93,10,-57,-114,-162,-188,-183,-145,-83,-15,40,61,43,-10,-88,-178,-265,-335,-379,-390,-367,-310,-231,-147,-75,-21,14,23,-7,-74,-152,-202,-196,-133,-33,73,153,186,176,148,125,107,78,28,-34,-88,-117,-110,-61,16,86,110,82,31,-12,-45,-84,-125,-138,-101,-37}
        },
        {    // H0e080a.wav
            {0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,-1,-1,0,1,1,1,0,0,0,0,-1,-1,0,1,2,1,0,0,0,0,0,-1,-1,-1,0,1,1,1,0,0,2,8,12,9,0,-8,-3,14,28,29,16,1,-10,-16,-17,-9,1,-1,12,131,454,954,1414,1554,1271,754,329,177,200,179,29,-113,-55,255,678,1031,1224,1315,1455,1798,2408,3166,3761,3856,3340,2470,1725,1468,1671,1949,1855,1201,163,-863,-1528,-1730,-1636,-1532,-1621,-1905,-2215,-2361,-2272,-2029,-1778,-1621,-1567,-1552,-1505,-1381,-1181,-939,-712,-537,-412,-287,-109,133,391,586,667,643,575,531,547,616,697,743,719,616,450,254,64,-97,-230,-348,-467,-591,-713,-818,-897,-945,-964,-962,-945,-914,-865,-790,-693,-591,-502,-427,-352,-263,-165,-76,-12,32,66,95,111,107,92,80,78,71,46,7,-30,-54,-70,-88,-112,-139,-169,-210,-262,-308,-328,-318,-299,-295,-304,-308,-296,-273,-252,-239,-226,-209,-191,-177,-164,-144,-117,-95,-87,-91,-95,-87,-68,-45,-25,-12,-7,-15,-35,-63,-88,-101,-104,-104,-107,-115,-124,-131,-138,-143,-148,-152,-157,-163,-168,-168,-159,-142,-124,-110,-100,-90,-77,-64,-51,-40,-32,-28,-31,-41,-53,-61,-63,-64,-69,-79,-90,-98,-106,-118,-134,-151,-164,-175,-184,-188,-185,-174,-162,-156,-158,-161,-159,-153,-144,-136,-129,-126,-124,-119,-108,-92,-74,-57,-41,-23,-7},
            {-313,-64,427,247,-549,396,5703,13918,18346,12366,-3205,-19001,-24555,-17112,-3065,8435,12396,9507,3551,-967,-8,7961,19449,26705,23330,10179,-4674,-12400,-10113,-1879,5669,8194,5356,-362,-5669,-8258,-7994,-6798,-6878,-8596,-10150,-9504,-6513,-3002,-926,-815,-1963,-3568,-5185,-6224,-5720,-3167,491,3200,3486,1807,119,96,1830,4093,5551,5622,4517,2908,1627,1305,1927,2741,2836,1932,523,-726,-1568,-2125,-2476,-2572,-2520,-2672,-3274,-4118,-4723,-4824,-4558,-4167,-3678,-2957,-1984,-954,-107,447,723,777,681,543,472,521,684,928,1202,1420,1496,1425,1318,1296,1368,1412,1281,928,446,10,-223,-206,-35,98,29,-269,-681,-1039,-1245,-1315,-1338,-1395,-1507,-1631,-1692,-1623,-1392,-1033,-641,-333,-183,-179,-241,-281,-238,-92,135,371,521,541,481,455,541,721,899,973,885,644,331,68,-56,-60,-55,-140,-311,-467,-505,-403,-222,-65,-23,-132,-346,-563,-683,-671,-563,-428,-320,-267,-251,-219,-117,51,215,298,273,178,69,-16,-60,-56,-16,32,71,118,195,285,339,314,211,54,-131,-317,-455,-498,-447,-355,-276,-221,-174,-130,-106,-114,-151,-216,-314,-438,-550,-595,-544,-404,-211,-9,150,224,203,120,22,-63,-131,-186,-222,-228,-199,-137,-54,25,70,64,14,-58,-137,-218,-297,-357,-380,-362,-312,-245,-169,-94,-33,7,20,2,-49,-123,-192,-223,-194,-112,0,105,170,179,150,114,94,79,45,-11,-69,-106,-114,-91,-35,44,108,117,67,2,-39,-61,-98,-149,-173,-132,-49}
        },
        {    // H0e085a.wav
            {1,1,0,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,2,2,2,2,1,1,1,1,1,1,1,0,0,1,1,-1,-2,-2,-1,0,0,0,2,5,5,1,-4,-3,6,15,16,9,2,5,15,23,20,10,-4,-19,-32,-32,-7,29,52,79,211,567,1126,1634,1729,1254,457,-154,-212,205,674,817,601,298,190,352,662,955,1151,1282,1472,1888,2624,3569,4374,4640,4201,3268,2285,1615,1299,1081,641,-152,-1130,-1947,-2326,-2260,-2019,-1942,-2183,-2614,-2957,-3006,-2751,-2342,-1948,-1668,-1505,-1406,-1293,-1105,-830,-508,-205,35,217,375,544,728,898,1008,1025,953,840,751,724,738,740,681,549,361,146,-76,-280,-443,-555,-633,-715,-825,-953,-1061,-1115,-1113,-1077,-1034,-990,-934,-857,-754,-630,-493,-353,-222,-111,-26,39,93,138,171,188,191,180,159,132,107,91,82,65,29,-29,-92,-143,-178,-203,-229,-258,-286,-307,-320,-325,-323,-319,-316,-318,-322,-321,-310,-288,-260,-232,-209,-192,-175,-153,-123,-88,-55,-32,-21,-15,-7,7,25,35,31,11,-16,-42,-62,-79,-95,-109,-119,-125,-131,-139,-149,-157,-162,-166,-170,-169,-163,-152,-139,-127,-119,-113,-108,-104,-101,-93,-79,-60,-42,-35,-40,-52,-64,-70,-74,-79,-87,-94,-99,-104,-110,-116,-121,-127,-139,-154,-165,-165,-156,-146,-145,-153,-162,-167,-167,-165,-162,-159,-154,-145,-132,-112,-86,-59,-34,-16,-4},
            {-364,10,528,186,-672,695,6734,15121,18447,10551,-6239,-21385,-24773,-15206,-392,10423,13048,9005,2580,-1447,861,10183,21690,26975,20597,5448,-8987,-14240,-9077,919,8636,10139,5805,-1157,-6892,-8964,-7729,-5897,-6086,-8363,-10294,-9496,-5993,-2032,78,-342,-2484,-5134,-7212,-7692,-5841,-2032,1924,3856,3018,796,-523,282,2575,4785,5797,5467,4224,2656,1441,1161,1803,2548,2407,1166,-447,-1557,-1936,-1929,-1862,-1809,-1868,-2293,-3153,-4055,-4455,-4235,-3795,-3518,-3330,-2873,-1992,-921,-19,524,705,596,314,52,8,247,651,1033,1260,1309,1240,1162,1180,1316,1470,1481,1246,791,267,-130,-257,-111,147,279,130,-259,-702,-1019,-1157,-1188,-1223,-1334,-1515,-1690,-1750,-1614,-1284,-859,-483,-264,-219,-277,-342,-346,-268,-111,97,304,440,476,454,466,574,754,917,967,855,602,296,54,-54,-55,-56,-142,-300,-435,-457,-347,-166,-19,-3,-146,-385,-600,-692,-645,-516,-376,-276,-233,-227,-198,-91,84,242,291,216,87,-20,-73,-83,-62,-20,32,83,140,213,289,325,286,173,11,-169,-333,-442,-465,-414,-333,-259,-195,-128,-69,-42,-59,-115,-207,-335,-482,-594,-615,-529,-362,-158,40,184,236,188,79,-34,-121,-184,-234,-263,-258,-210,-131,-40,35,71,56,1,-75,-156,-236,-302,-339,-340,-313,-272,-218,-148,-70,-7,23,19,-14,-69,-136,-191,-203,-162,-81,15,101,160,179,161,126,93,62,16,-47,-109,-143,-138,-97,-29,50,107,113,69,11,-31,-63,-111,-170,-193,-145,-53}
        },
        {    // H0e090a.wav
            {0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,-1,-1,0,1,1,0,-1,-1,0,1,1,0,-1,-1,-1,0,0,-2,-3,-3,-2,-2,-2,-1,2,4,3,-1,-3,-2,1,5,11,17,18,10,1,-1,7,15,10,-6,-19,-22,-17,15,121,332,587,735,660,433,295,440,808,1109,1097,809,523,485,682,894,925,762,543,404,384,455,600,868,1365,2178,3276,4418,5200,5250,4461,3093,1641,558,24,-100,-140,-394,-957,-1689,-2326,-2680,-2762,-2748,-2808,-2962,-3078,-3011,-2722,-2300,-1879,-1543,-1306,-1133,-969,-763,-489,-160,166,425,597,717,835,971,1101,1181,1183,1105,965,797,652,565,533,497,386,175,-93,-344,-531,-652,-733,-792,-843,-902,-982,-1078,-1155,-1178,-1139,-1062,-977,-883,-764,-614,-455,-318,-214,-125,-38,46,113,157,186,209,222,215,190,161,139,117,84,37,-8,-41,-68,-105,-154,-200,-226,-238,-254,-286,-322,-344,-347,-342,-340,-342,-344,-345,-350,-351,-335,-294,-236,-180,-137,-107,-80,-55,-35,-21,-10,3,18,32,41,44,39,22,-6,-37,-63,-79,-87,-90,-95,-104,-116,-130,-145,-164,-182,-192,-190,-175,-156,-147,-149,-157,-163,-161,-152,-139,-121,-101,-82,-67,-57,-52,-51,-52,-59,-73,-88,-98,-98,-94,-94,-100,-108,-112,-115,-120,-127,-132,-133,-132,-137,-145,-153,-158,-164,-176,-189,-195,-189,-171,-145,-115,-86,-62,-45,-32,-19,-6},
            {-371,-13,536,225,-699,509,6457,14962,18519,10697,-6301,-21723,-25112,-15186,64,11034,13460,9108,2553,-1349,1173,10537,21732,26359,19204,3530,-10847,-15353,-8960,2303,10799,12237,7037,-1101,-7628,-9672,-7732,-5118,-5030,-7676,-10254,-9830,-6135,-1629,806,29,-3061,-6599,-8824,-8597,-5745,-1359,2482,3915,2689,432,-666,393,2814,4973,5790,5239,3917,2507,1586,1493,2017,2355,1740,225,-1311,-2041,-1931,-1547,-1345,-1381,-1620,-2166,-3007,-3766,-3993,-3673,-3239,-3031,-2915,-2525,-1758,-874,-170,269,479,459,217,-99,-236,-52,369,813,1108,1198,1132,1033,1031,1169,1349,1393,1187,768,286,-85,-222,-106,147,321,241,-103,-547,-897,-1069,-1117,-1151,-1248,-1420,-1612,-1723,-1642,-1326,-860,-424,-179,-158,-266,-374,-404,-342,-197,15,237,388,424,399,419,546,736,889,920,803,566,287,64,-37,-40,-42,-127,-283,-417,-440,-332,-149,7,35,-106,-355,-581,-674,-614,-468,-322,-228,-203,-218,-205,-103,79,242,281,177,12,-114,-161,-140,-81,-10,49,88,127,192,271,316,281,166,-1,-184,-348,-446,-449,-374,-278,-201,-139,-77,-26,-17,-55,-123,-211,-332,-477,-596,-621,-529,-353,-148,44,182,228,171,49,-75,-162,-216,-260,-291,-290,-241,-153,-53,30,74,68,20,-56,-144,-232,-305,-349,-356,-333,-286,-217,-129,-39,26,50,37,-6,-69,-142,-201,-217,-174,-84,26,124,184,196,167,120,72,24,-31,-94,-148,-172,-161,-115,-43,38,96,101,58,-1,-45,-78,-118,-159,-168,-121,-44}
        },
        {    // H0e095a.wav
            {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,-1,-1,-1,-1,-1,-1,0,1,1,0,-1,0,1,1,0,0,-1,-3,-3,-2,-2,-2,-3,-1,2,2,-2,-4,-2,2,5,6,9,11,11,9,10,13,8,-5,-11,-6,-1,2,53,226,515,777,816,551,120,-221,-275,-25,403,843,1162,1293,1239,1065,880,805,931,1258,1616,1692,1234,327,-534,-745,-57,1235,2549,3469,3944,4120,4072,3726,3006,1991,910,26,-488,-622,-549,-561,-900,-1590,-2405,-3032,-3285,-3204,-2963,-2725,-2555,-2435,-2303,-2095,-1774,-1360,-941,-618,-431,-324,-196,17,298,576,798,953,1057,1121,1146,1131,1077,977,827,649,488,378,301,205,52,-148,-357,-545,-698,-801,-839,-825,-811,-851,-953,-1066,-1128,-1111,-1031,-915,-781,-645,-527,-434,-356,-272,-171,-68,18,81,128,167,192,195,176,143,111,85,65,49,36,24,6,-24,-69,-121,-170,-212,-248,-278,-300,-308,-310,-318,-340,-369,-391,-396,-387,-367,-335,-290,-237,-187,-148,-118,-92,-68,-47,-32,-19,-4,9,18,18,13,7,-1,-15,-33,-48,-52,-45,-36,-39,-60,-93,-127,-153,-168,-178,-185,-191,-197,-201,-202,-198,-187,-174,-162,-155,-152,-146,-134,-117,-101,-90,-85,-81,-75,-66,-61,-62,-70,-82,-95,-108,-120,-127,-128,-123,-114,-108,-106,-109,-118,-130,-142,-151,-159,-163,-165,-165,-163,-160,-150,-132,-103,-73,-51,-39,-32,-21,-7},
            {-337,-142,431,367,-559,-42,4939,13366,18393,12710,-3304,-19842,-25514,-17176,-1853,10283,13811,9937,3343,-970,747,9173,20000,25304,19405,4450,-10383,-15981,-10129,1804,11753,14380,9342,351,-7410,-10290,-8325,-4953,-4031,-6486,-9694,-10167,-6855,-1972,1073,406,-3232,-7432,-9830,-9272,-6066,-1640,2108,3687,2864,885,-362,266,2377,4558,5593,5223,3970,2574,1658,1562,2083,2416,1717,-28,-1842,-2635,-2228,-1370,-874,-961,-1423,-2088,-2864,-3504,-3670,-3326,-2849,-2604,-2524,-2239,-1573,-744,-87,254,326,190,-87,-344,-362,-67,376,723,859,846,805,822,933,1115,1275,1284,1071,693,287,-13,-133,-62,135,304,275,-3,-413,-755,-922,-965,-1013,-1147,-1352,-1553,-1659,-1590,-1313,-887,-460,-189,-129,-213,-327,-396,-390,-287,-85,157,335,386,361,376,496,674,808,830,728,529,288,83,-18,-24,-22,-97,-247,-392,-437,-348,-165,15,79,-31,-267,-499,-609,-575,-451,-309,-202,-159,-177,-194,-132,25,190,245,159,3,-128,-195,-203,-160,-78,12,75,115,166,242,300,283,177,13,-164,-318,-409,-411,-337,-239,-162,-106,-52,-4,6,-35,-114,-213,-334,-470,-577,-597,-509,-347,-160,14,144,196,153,44,-77,-174,-246,-301,-330,-313,-247,-150,-47,41,93,92,35,-61,-169,-265,-335,-370,-368,-335,-278,-202,-111,-18,52,78,57,0,-76,-152,-203,-205,-153,-61,42,129,179,182,145,91,41,-1,-45,-97,-147,-179,-180,-145,-82,-7,49,61,34,-4,-31,-56,-92,-134,-145,-106,-38}
        },
        {    // H0e100a.wav
            {1,1,0,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,1,1,3,3,2,0,1,1,1,-1,-1,1,3,2,-1,-1,0,2,5,8,10,8,5,6,13,16,13,9,9,2,-13,11,158,460,805,968,783,311,-177,-401,-274,67,397,570,581,530,542,707,1028,1420,1764,1997,2145,2241,2200,1825,1001,-86,-941,-1056,-294,988,2182,2840,2902,2621,2306,2113,2005,1828,1434,795,57,-530,-798,-806,-815,-1079,-1640,-2305,-2806,-2983,-2856,-2566,-2272,-2067,-1943,-1817,-1596,-1262,-890,-585,-402,-310,-227,-80,156,448,728,929,1017,1010,958,903,861,818,750,638,480,294,114,-35,-157,-278,-409,-535,-627,-675,-697,-717,-746,-782,-819,-857,-886,-887,-844,-764,-671,-587,-516,-445,-367,-284,-202,-125,-53,10,54,69,62,49,49,64,82,93,95,91,80,58,21,-25,-76,-125,-172,-209,-231,-240,-245,-262,-295,-338,-375,-393,-382,-346,-296,-250,-220,-207,-200,-185,-156,-119,-83,-54,-36,-29,-30,-36,-42,-42,-36,-26,-18,-14,-15,-19,-23,-27,-31,-37,-47,-63,-85,-113,-146,-177,-201,-214,-217,-212,-202,-189,-174,-160,-151,-148,-152,-160,-165,-163,-148,-125,-100,-80,-69,-64,-65,-69,-75,-79,-85,-95,-108,-119,-124,-121,-117,-114,-115,-117,-122,-124,-122,-114,-105,-102,-107,-111,-110,-103,-97,-91,-82,-69,-56,-45,-35,-22,-7},
            {-206,-313,177,505,-189,-571,2599,10205,17206,15583,2516,-14933,-24823,-20649,-6513,7464,13735,11577,5166,-170,-247,6375,16671,23600,20694,7872,-7413,-15609,-12302,-898,10747,15931,12628,3654,-5589,-10380,-9500,-5768,-3547,-5012,-8445,-10119,-7893,-3116,676,772,-2727,-7343,-10233,-9976,-6978,-2749,1034,3146,3182,1769,325,192,1646,3736,5133,5174,4154,2848,1934,1726,2063,2316,1740,161,-1684,-2713,-2492,-1584,-889,-822,-1207,-1778,-2453,-3130,-3518,-3382,-2867,-2367,-2084,-1847,-1406,-761,-143,248,365,233,-85,-428,-556,-325,157,613,838,824,706,622,658,827,1053,1186,1098,785,368,8,-179,-151,47,271,331,120,-275,-642,-827,-855,-873,-991,-1205,-1431,-1574,-1551,-1314,-901,-461,-168,-101,-193,-313,-380,-374,-289,-121,88,250,303,287,309,428,601,737,772,691,511,276,66,-40,-35,-2,-37,-163,-317,-409,-379,-224,-20,110,64,-148,-397,-543,-539,-435,-306,-199,-143,-148,-179,-154,-26,145,234,174,20,-125,-201,-216,-190,-131,-55,12,61,117,199,279,300,232,90,-85,-248,-358,-382,-326,-235,-154,-91,-29,25,41,-2,-87,-190,-310,-445,-561,-598,-524,-365,-179,-7,124,188,160,52,-85,-196,-263,-297,-310,-294,-238,-147,-43,44,90,82,22,-73,-179,-274,-339,-361,-343,-301,-251,-197,-132,-53,23,69,72,36,-23,-89,-143,-165,-143,-81,2,79,130,148,137,110,73,26,-33,-98,-157,-197,-208,-183,-118,-31,41,67,47,10,-17,-41,-74,-110,-120,-86,-30}
        },
        {    // H0e105a.wav
            {1,0,0,1,2,2,2,1,0,0,1,2,2,0,-1,0,1,1,0,0,0,0,0,0,0,0,0,0,2,2,2,0,1,1,1,1,1,1,1,0,0,1,0,-2,0,8,14,9,-2,-5,8,20,17,6,8,18,10,4,95,375,786,1087,1022,557,-55,-453,-440,-104,293,530,546,429,304,258,322,521,916,1550,2349,3058,3340,3008,2189,1251,543,168,2,-110,-183,-112,171,593,980,1195,1226,1164,1119,1142,1207,1230,1106,774,267,-284,-722,-960,-1045,-1115,-1302,-1637,-2028,-2310,-2351,-2134,-1777,-1452,-1266,-1202,-1158,-1053,-881,-677,-464,-241,-13,188,339,448,544,637,707,733,718,683,634,559,448,307,154,2,-143,-267,-356,-404,-425,-444,-475,-519,-566,-605,-628,-635,-633,-629,-625,-623,-619,-604,-568,-506,-426,-349,-296,-268,-248,-221,-183,-137,-85,-33,11,39,52,63,80,95,91,61,16,-29,-65,-94,-117,-135,-153,-177,-213,-252,-278,-283,-270,-256,-249,-248,-245,-234,-217,-197,-176,-154,-133,-118,-111,-111,-110,-103,-92,-85,-82,-79,-67,-46,-23,-11,-15,-31,-50,-63,-67,-64,-58,-60,-75,-103,-135,-160,-172,-175,-174,-173,-170,-164,-159,-159,-165,-174,-182,-185,-182,-173,-156,-134,-110,-92,-82,-81,-86,-91,-94,-91,-86,-83,-87,-97,-113,-128,-138,-140,-135,-124,-111,-95,-76,-58,-47,-46,-47,-47,-48,-53,-62,-66,-61,-55,-56,-62,-61,-42,-14},
            {28,-410,-207,452,345,-570,334,5770,13797,17219,9833,-6242,-20690,-23521,-13571,1342,11733,13368,8332,1836,-1055,2522,11494,20317,21891,13148,-1529,-13017,-14322,-5536,6987,15574,15909,8737,-1354,-8863,-10645,-7735,-4222,-3734,-6427,-9193,-8825,-5049,-704,836,-1557,-6119,-9833,-10636,-8431,-4549,-621,2148,3171,2565,1210,395,971,2673,4364,5014,4450,3273,2255,1855,2050,2352,2035,696,-1234,-2677,-2833,-1929,-938,-622,-974,-1561,-2127,-2684,-3172,-3345,-3068,-2530,-2037,-1671,-1276,-745,-188,199,330,237,-8,-299,-477,-401,-83,309,600,732,751,718,682,692,776,887,920,799,536,211,-80,-232,-179,35,228,196,-97,-477,-734,-814,-828,-904,-1062,-1242,-1377,-1411,-1287,-982,-571,-217,-53,-86,-216,-335,-382,-334,-188,16,190,261,246,237,311,462,621,714,697,555,317,68,-85,-100,-38,-9,-73,-207,-332,-373,-289,-108,73,124,-12,-261,-470,-536,-467,-341,-226,-153,-135,-152,-149,-69,78,197,197,75,-88,-205,-247,-226,-165,-92,-35,2,48,132,238,304,279,167,8,-156,-289,-358,-341,-259,-162,-86,-30,20,50,28,-54,-168,-286,-401,-504,-566,-547,-435,-261,-76,74,161,165,89,-34,-159,-247,-287,-290,-269,-234,-187,-124,-48,25,64,49,-16,-105,-197,-279,-341,-369,-355,-307,-242,-172,-94,-7,70,111,98,37,-47,-126,-177,-185,-145,-63,38,122,165,159,121,68,10,-53,-115,-165,-194,-197,-174,-121,-47,23,61,57,28,-5,-36,-67,-92,-93,-63,-21}
        },
        {    // H0e110a.wav
            {0,0,0,0,1,1,1,1,0,1,2,1,0,0,0,0,0,0,0,1,0,-1,-1,1,1,1,0,0,0,1,2,3,3,1,0,1,3,2,2,3,2,-2,-6,-2,9,15,8,-2,-2,7,11,7,11,23,20,0,50,298,749,1186,1276,859,124,-493,-649,-330,183,559,642,488,258,97,91,289,719,1365,2106,2717,2972,2798,2341,1856,1508,1268,1011,680,353,126,-21,-211,-514,-823,-927,-703,-243,219,501,600,643,735,877,983,963,778,444,30,-363,-641,-776,-829,-895,-1028,-1211,-1384,-1493,-1513,-1445,-1319,-1187,-1096,-1037,-955,-793,-562,-327,-153,-49,18,89,176,273,369,446,482,456,368,249,140,66,24,-10,-60,-130,-207,-269,-305,-318,-317,-317,-332,-368,-419,-464,-484,-479,-466,-460,-461,-464,-470,-485,-504,-505,-470,-407,-342,-295,-255,-204,-137,-74,-34,-19,-14,-7,2,4,-1,-8,-17,-35,-66,-103,-129,-134,-121,-108,-106,-118,-137,-159,-178,-191,-194,-187,-176,-167,-161,-153,-140,-131,-136,-155,-174,-178,-165,-146,-126,-103,-78,-59,-58,-73,-87,-88,-80,-80,-94,-112,-122,-118,-108,-96,-87,-82,-84,-94,-106,-116,-123,-132,-146,-166,-188,-203,-207,-199,-184,-168,-154,-144,-137,-133,-127,-118,-107,-99,-98,-100,-99,-97,-101,-113,-127,-132,-130,-123,-113,-99,-82,-69,-62,-55,-40,-23,-13,-10,-7,-2,-5,-20,-38,-47,-51,-67,-93,-103,-77,-28},
            {246,-255,-465,89,610,34,-674,1553,8136,15158,15246,4734,-11239,-21972,-20243,-8152,5546,12962,12026,5988,186,-774,4827,14193,20716,18356,6947,-6751,-13957,-10521,510,11853,17119,14141,5294,-4371,-10066,-10056,-6575,-3807,-4308,-7014,-8653,-7072,-3246,-257,-525,-3909,-8088,-10478,-9908,-6930,-2996,485,2594,3006,2093,891,565,1573,3286,4557,4685,3857,2778,2069,1957,2234,2328,1598,-91,-2029,-3108,-2804,-1646,-663,-450,-881,-1563,-2284,-2949,-3351,-3262,-2740,-2119,-1663,-1321,-903,-381,76,300,276,85,-171,-376,-399,-190,154,461,631,683,685,689,717,772,826,821,718,530,295,47,-162,-250,-165,10,91,-53,-360,-646,-786,-809,-828,-910,-1041,-1173,-1254,-1225,-1034,-698,-331,-74,4,-63,-191,-304,-355,-303,-144,65,225,274,245,236,315,464,608,670,612,433,180,-51,-165,-138,-49,-11,-79,-212,-317,-320,-206,-33,91,70,-109,-347,-511,-528,-428,-291,-181,-122,-115,-124,-97,0,126,191,135,-10,-157,-242,-251,-202,-119,-34,22,50,86,157,241,276,226,106,-43,-183,-285,-322,-283,-197,-110,-49,-6,22,21,-29,-118,-220,-323,-426,-514,-546,-493,-361,-189,-20,111,175,152,56,-68,-176,-251,-298,-320,-311,-263,-182,-81,21,98,123,82,-13,-134,-250,-344,-400,-407,-363,-282,-182,-84,0,59,82,67,17,-51,-117,-160,-168,-135,-68,15,92,134,130,90,37,-6,-39,-68,-99,-130,-152,-158,-135,-79,-5,55,76,62,31,-1,-35,-66,-76,-55,-18}
        },
        {    // H0e115a.wav
            {1,1,1,1,1,2,2,3,2,1,1,2,3,2,1,0,0,1,1,0,0,1,2,2,1,1,0,-1,0,3,4,2,0,1,3,2,1,2,7,7,0,-5,-1,8,9,3,2,9,11,4,4,21,31,9,20,217,683,1250,1530,1218,396,-467,-861,-622,-11,534,731,585,289,43,-29,145,617,1378,2276,3011,3275,2960,2249,1503,1012,846,882,957,966,855,587,156,-367,-845,-1160,-1285,-1287,-1235,-1133,-927,-590,-173,206,454,572,647,772,956,1104,1084,830,405,-19,-270,-292,-190,-149,-301,-639,-1037,-1351,-1493,-1452,-1274,-1041,-851,-766,-771,-782,-723,-582,-411,-265,-164,-94,-41,5,41,65,67,45,14,2,27,76,116,116,72,1,-71,-125,-148,-148,-142,-154,-195,-253,-308,-343,-358,-367,-387,-424,-469,-507,-529,-533,-518,-479,-419,-354,-304,-274,-253,-227,-193,-160,-134,-114,-98,-88,-87,-91,-91,-81,-61,-35,-10,11,24,25,11,-16,-54,-95,-127,-139,-130,-110,-95,-95,-111,-136,-158,-171,-174,-172,-171,-170,-169,-164,-155,-144,-130,-119,-117,-126,-143,-160,-172,-175,-168,-152,-129,-108,-92,-82,-74,-64,-52,-45,-46,-60,-85,-117,-149,-177,-196,-203,-197,-182,-167,-159,-154,-146,-135,-127,-126,-129,-128,-124,-121,-123,-126,-130,-133,-136,-134,-122,-101,-81,-65,-52,-41,-35,-35,-35,-28,-16,-3,8,19,25,17,-6,-31,-46,-61,-89,-124,-134,-98,-34},
            {216,100,-276,-315,223,509,-183,-509,2390,9063,14944,13243,1893,-12885,-21081,-17383,-5204,7062,12856,11027,4874,-523,-751,5480,14598,19641,15460,3563,-8411,-12611,-6883,4363,14049,17061,12486,3259,-5740,-10373,-9651,-6167,-3794,-4415,-6644,-7630,-5972,-2932,-1087,-2022,-5184,-8533,-10100,-9113,-6102,-2306,971,2785,2851,1733,632,627,1875,3536,4541,4440,3569,2591,2007,1969,2234,2216,1328,-441,-2303,-3231,-2844,-1694,-684,-335,-634,-1367,-2310,-3157,-3519,-3214,-2481,-1769,-1315,-1018,-686,-299,17,166,155,28,-163,-314,-298,-65,288,596,752,763,700,645,661,753,857,869,722,439,105,-175,-321,-298,-155,-28,-63,-293,-603,-829,-892,-845,-798,-824,-927,-1055,-1134,-1086,-867,-521,-175,37,64,-40,-178,-279,-312,-257,-108,88,238,278,240,227,309,462,596,632,541,337,81,-128,-200,-133,-26,4,-82,-219,-310,-294,-180,-33,47,-19,-218,-439,-556,-521,-388,-246,-148,-109,-114,-126,-89,14,131,174,100,-43,-169,-225,-210,-145,-55,28,76,92,110,155,210,226,179,75,-56,-183,-272,-294,-250,-175,-107,-57,-20,-3,-23,-85,-165,-246,-333,-431,-513,-529,-452,-302,-128,30,141,174,112,-22,-169,-269,-308,-304,-280,-238,-170,-80,11,79,104,80,12,-88,-196,-288,-341,-352,-330,-289,-237,-177,-112,-53,-10,10,8,-14,-52,-95,-128,-137,-117,-69,-6,51,83,84,64,40,17,-9,-42,-79,-113,-137,-139,-105,-37,39,90,100,80,44,1,-43,-67,-56,-20}
        },
        {    // H0e120a.wav
            {0,1,2,1,0,1,3,4,2,1,1,2,1,-1,-1,0,0,-1,0,1,1,0,1,2,2,-1,-2,0,2,2,1,1,3,2,0,1,6,9,3,-3,0,8,8,-2,-5,8,18,7,-5,11,39,30,12,147,596,1267,1749,1596,746,-345,-1028,-955,-306,417,797,729,379,-1,-192,-33,566,1549,2656,3481,3673,3174,2275,1432,959,848,859,768,539,290,126,22,-140,-443,-845,-1207,-1396,-1386,-1261,-1142,-1096,-1094,-1046,-877,-569,-169,249,612,871,1012,1063,1078,1104,1143,1142,1028,775,436,115,-118,-277,-441,-664,-918,-1119,-1202,-1165,-1067,-975,-928,-927,-941,-926,-856,-740,-616,-518,-457,-422,-401,-377,-325,-226,-89,45,137,181,201,218,230,222,188,141,93,50,12,-20,-54,-104,-179,-267,-340,-380,-391,-392,-396,-404,-413,-426,-446,-465,-471,-456,-425,-389,-356,-326,-299,-280,-273,-278,-280,-260,-207,-127,-43,23,59,72,71,65,59,52,43,29,11,-10,-33,-52,-65,-72,-74,-74,-80,-94,-115,-137,-157,-171,-178,-182,-184,-186,-188,-188,-188,-196,-212,-231,-242,-241,-227,-204,-175,-141,-110,-93,-88,-85,-72,-52,-36,-35,-50,-72,-96,-119,-140,-155,-163,-166,-163,-158,-151,-145,-140,-135,-129,-123,-123,-129,-140,-153,-165,-169,-161,-146,-130,-117,-101,-82,-62,-51,-48,-47,-41,-33,-24,-12,3,14,13,5,-1,-3,-12,-33,-55,-67,-77,-102,-135,-145,-105,-37},
            {-56,248,183,-249,-349,176,475,-174,-427,2428,8731,14027,12098,1386,-12126,-19374,-15790,-4572,6787,12342,10753,4747,-852,-1456,4444,13302,18195,14222,3131,-7604,-10739,-4722,5921,14544,16653,11714,2632,-6028,-10445,-9710,-6240,-3673,-3873,-5740,-6806,-5795,-3641,-2333,-3070,-5448,-8000,-9265,-8506,-5887,-2302,967,2780,2745,1525,439,533,1836,3466,4440,4383,3593,2633,1968,1814,2025,2057,1303,-322,-2118,-3111,-2886,-1877,-884,-430,-599,-1258,-2188,-3033,-3383,-3075,-2363,-1674,-1218,-900,-583,-287,-107,-51,-40,-41,-85,-154,-140,47,361,660,827,843,763,667,639,720,854,907,766,440,46,-276,-437,-418,-276,-142,-163,-388,-710,-950,-1002,-912,-808,-781,-838,-933,-999,-961,-770,-449,-120,78,92,-19,-148,-230,-245,-185,-47,124,245,257,200,181,269,434,577,615,517,306,55,-135,-186,-107,-3,13,-88,-237,-334,-324,-223,-99,-43,-115,-296,-486,-575,-524,-385,-242,-152,-126,-140,-147,-99,9,123,165,103,-18,-122,-166,-148,-85,-1,71,107,113,125,161,202,204,148,49,-69,-184,-270,-298,-259,-185,-118,-77,-54,-44,-61,-114,-190,-268,-344,-422,-481,-483,-405,-273,-133,-25,39,52,11,-68,-150,-198,-207,-198,-190,-178,-148,-95,-30,28,60,56,15,-56,-146,-237,-313,-358,-365,-336,-283,-216,-144,-72,-15,11,0,-41,-96,-149,-184,-186,-146,-68,20,86,110,98,70,41,16,-9,-35,-62,-87,-103,-95,-55,9,72,109,108,74,25,-21,-44,-40,-16}
        },
        {    // H0e125a.wav
            {2,1,1,1,2,3,1,0,1,2,1,-1,-1,-1,0,0,-1,-1,0,-1,-2,-2,-2,-2,-1,0,1,0,-2,-2,1,1,-3,-4,3,9,4,-6,-7,4,10,-1,-10,0,17,12,-8,-4,30,40,16,102,515,1255,1931,1974,1146,-158,-1163,-1310,-657,244,824,857,480,-6,-305,-180,507,1699,3057,4048,4225,3527,2358,1321,815,802,926,860,545,155,-143,-356,-618,-1005,-1418,-1659,-1608,-1340,-1064,-948,-996,-1082,-1088,-1001,-881,-759,-591,-319,43,402,664,815,921,1065,1271,1483,1604,1557,1327,965,556,183,-91,-239,-292,-328,-439,-657,-923,-1134,-1217,-1184,-1105,-1050,-1048,-1079,-1103,-1093,-1044,-972,-891,-795,-665,-494,-302,-122,19,120,188,235,270,304,341,372,378,341,256,141,25,-64,-117,-146,-175,-216,-261,-295,-315,-329,-347,-371,-396,-420,-441,-460,-469,-466,-453,-441,-442,-456,-468,-451,-391,-294,-189,-103,-47,-15,4,16,24,34,52,72,82,72,46,19,5,6,17,26,25,8,-24,-61,-92,-110,-121,-138,-164,-189,-200,-196,-194,-209,-238,-269,-292,-306,-309,-292,-253,-203,-165,-151,-150,-143,-122,-95,-72,-60,-55,-60,-76,-100,-123,-135,-135,-131,-128,-127,-123,-114,-103,-99,-104,-115,-125,-135,-147,-159,-165,-161,-153,-152,-157,-156,-141,-117,-95,-78,-63,-49,-44,-47,-49,-42,-26,-10,0,2,-3,-15,-30,-40,-46,-58,-76,-92,-96,-97,-113,-138,-141,-101,-35},
            {-154,-1,223,140,-234,-324,135,439,-100,-441,1838,7387,12616,11837,2913,-9520,-17273,-15360,-5688,5254,11519,10960,5402,-757,-2662,2013,10638,16654,14618,5162,-5111,-8984,-4205,5500,13882,16346,11975,3244,-5528,-10421,-10105,-6562,-3387,-2897,-4598,-6261,-6266,-4879,-3600,-3653,-5100,-7035,-8282,-7992,-5957,-2725,533,2533,2655,1430,226,228,1556,3306,4413,4453,3707,2721,1940,1614,1722,1858,1412,123,-1531,-2666,-2762,-2065,-1241,-782,-808,-1250,-1967,-2682,-3027,-2822,-2261,-1708,-1335,-1043,-711,-393,-214,-177,-167,-116,-63,-45,0,160,429,702,866,887,803,698,660,734,863,917,784,463,57,-298,-497,-503,-363,-211,-200,-394,-703,-960,-1056,-1004,-901,-829,-817,-851,-887,-860,-713,-452,-166,28,76,15,-75,-137,-148,-97,20,164,260,252,169,112,164,321,500,603,567,391,139,-74,-156,-105,-19,-12,-118,-274,-387,-402,-320,-198,-122,-162,-319,-508,-613,-578,-441,-285,-175,-131,-138,-152,-119,-20,102,170,143,52,-38,-80,-70,-21,46,101,123,120,126,160,195,189,124,24,-84,-187,-271,-308,-283,-216,-147,-101,-73,-60,-74,-126,-202,-277,-345,-415,-480,-511,-473,-366,-220,-73,39,93,75,3,-87,-158,-197,-213,-213,-194,-152,-84,-3,72,114,101,29,-84,-205,-305,-367,-383,-354,-298,-238,-190,-154,-123,-97,-84,-91,-116,-147,-171,-177,-155,-102,-31,41,93,113,102,72,39,15,0,-13,-31,-48,-55,-45,-18,22,66,100,103,68,13,-29,-36,-16}
        },
        {    // H0e130a.wav
            {1,1,2,3,2,1,1,2,1,-1,-2,0,1,0,-2,-1,1,1,0,-1,-1,-2,-2,-1,1,1,-2,-2,3,5,0,-5,-2,7,8,-1,-6,2,10,2,-8,-1,18,18,-6,-10,25,49,22,69,449,1247,2106,2356,1584,88,-1258,-1679,-1073,-8,799,974,601,16,-396,-305,494,1933,3563,4696,4792,3837,2387,1203,730,849,1069,972,517,-25,-395,-586,-798,-1201,-1737,-2164,-2265,-2024,-1614,-1249,-1035,-955,-942,-939,-897,-761,-496,-152,138,257,210,139,213,505,936,1334,1543,1517,1335,1135,1009,943,855,686,452,214,15,-145,-281,-406,-533,-689,-889,-1102,-1267,-1340,-1334,-1308,-1316,-1362,-1402,-1370,-1226,-984,-706,-462,-291,-185,-107,-25,81,213,351,450,471,416,329,263,235,218,182,118,42,-31,-98,-154,-194,-221,-250,-293,-348,-396,-419,-417,-405,-404,-427,-473,-526,-561,-551,-489,-389,-288,-215,-178,-167,-161,-149,-126,-91,-44,4,38,44,27,8,8,33,68,98,113,113,98,68,26,-22,-66,-100,-124,-141,-152,-159,-160,-161,-173,-202,-244,-285,-311,-316,-308,-290,-266,-234,-201,-175,-158,-148,-136,-121,-106,-96,-93,-96,-107,-123,-141,-156,-158,-145,-120,-94,-74,-61,-54,-51,-59,-80,-108,-133,-150,-162,-168,-166,-153,-136,-122,-114,-104,-90,-79,-74,-74,-71,-62,-51,-42,-35,-30,-28,-30,-35,-41,-50,-64,-79,-88,-92,-99,-111,-116,-106,-95,-100,-119,-122,-88,-31},
            {47,-138,-121,122,204,-79,-305,-24,372,92,-421,881,5307,10632,11817,5626,-5420,-14321,-15226,-7961,2465,9983,11204,6637,-15,-3723,-1076,6852,14447,15571,8793,-1089,-6891,-4718,3508,12144,15951,12949,4874,-4163,-9954,-10507,-7121,-3251,-1844,-3304,-5731,-6946,-6293,-4802,-3978,-4538,-6044,-7380,-7512,-6019,-3258,-216,1923,2410,1458,192,-119,989,2862,4341,4690,3992,2848,1869,1399,1450,1686,1551,670,-747,-1996,-2465,-2141,-1515,-1088,-1049,-1343,-1842,-2364,-2656,-2543,-2113,-1658,-1386,-1245,-1061,-769,-463,-248,-134,-80,-55,-39,23,190,451,720,898,940,868,753,687,724,834,899,804,524,135,-232,-464,-504,-379,-214,-172,-335,-636,-912,-1041,-1025,-946,-875,-841,-842,-859,-845,-735,-509,-233,-16,76,60,1,-51,-73,-42,56,192,289,286,196,107,107,216,383,526,569,475,269,44,-91,-98,-43,-36,-134,-298,-437,-482,-423,-302,-199,-191,-302,-477,-610,-622,-514,-354,-218,-150,-146,-158,-126,-25,112,209,215,142,50,-10,-20,15,77,134,159,150,136,146,169,167,117,31,-71,-172,-261,-308,-292,-222,-140,-82,-59,-64,-100,-170,-265,-356,-421,-458,-472,-460,-407,-309,-183,-61,24,50,18,-50,-120,-165,-177,-159,-122,-77,-37,-10,9,26,35,20,-28,-101,-178,-245,-298,-332,-340,-316,-274,-232,-204,-189,-173,-149,-122,-104,-106,-122,-136,-130,-96,-36,36,100,135,128,90,51,33,32,32,21,3,-13,-23,-17,15,67,107,99,44,-14,-35,-17}
        },
        {    // H0e135a.wav
            {3,3,1,-1,-1,1,0,-2,-2,-1,0,-1,-2,-1,0,0,-2,-2,-1,-1,-3,-2,2,3,-1,-4,-1,3,0,-5,-3,6,9,-2,-9,-1,10,3,-13,-9,16,24,-2,-20,13,53,35,55,398,1236,2256,2715,2024,369,-1311,-2031,-1512,-307,728,1061,698,16,-500,-406,561,2286,4186,5412,5359,4091,2342,1020,605,888,1243,1155,577,-149,-662,-890,-1052,-1403,-1967,-2509,-2731,-2518,-2023,-1532,-1256,-1209,-1267,-1284,-1167,-882,-450,35,421,580,516,374,331,466,716,948,1064,1054,972,885,826,790,759,725,701,686,647,542,357,128,-87,-250,-370,-487,-643,-856,-1107,-1346,-1523,-1610,-1610,-1541,-1417,-1250,-1063,-888,-740,-607,-463,-304,-153,-34,52,122,194,267,325,354,356,343,325,302,260,191,101,12,-57,-107,-152,-204,-259,-311,-354,-388,-413,-429,-434,-430,-419,-406,-393,-379,-359,-326,-282,-241,-220,-222,-229,-221,-195,-162,-138,-124,-111,-92,-64,-26,21,75,122,147,142,115,78,42,9,-20,-50,-83,-117,-143,-150,-138,-122,-118,-138,-176,-219,-256,-281,-288,-278,-254,-226,-206,-199,-200,-200,-189,-170,-150,-139,-141,-150,-160,-166,-171,-172,-168,-158,-140,-118,-92,-63,-40,-31,-38,-59,-87,-116,-140,-153,-152,-142,-129,-118,-109,-99,-85,-68,-54,-46,-50,-62,-75,-83,-85,-81,-73,-62,-55,-61,-77,-96,-108,-115,-124,-133,-135,-128,-119,-117,-114,-103,-90,-91,-104,-107,-77,-27},
            {62,49,-69,-111,38,174,31,-223,-146,226,238,-260,80,2982,7898,11065,8373,-312,-9999,-14281,-10456,-1342,7288,10770,7999,1552,-3821,-3835,2355,10893,15565,12645,4164,-3566,-4967,669,9137,14721,13938,7230,-1795,-8648,-10527,-7815,-3548,-1135,-1990,-4878,-7308,-7635,-6128,-4404,-3945,-4990,-6525,-7179,-6195,-3823,-1019,1140,1966,1468,373,-240,368,2041,3837,4748,4416,3252,2004,1248,1143,1426,1575,1124,33,-1217,-1995,-2035,-1614,-1228,-1169,-1408,-1776,-2125,-2337,-2314,-2052,-1695,-1436,-1336,-1280,-1120,-826,-496,-243,-111,-72,-57,3,156,400,675,890,978,933,818,725,718,786,844,796,599,291,-41,-297,-407,-365,-245,-183,-283,-532,-809,-977,-993,-918,-846,-826,-848,-874,-862,-774,-594,-354,-132,4,41,22,-5,-14,6,69,176,284,327,279,192,150,197,309,419,468,416,268,79,-61,-93,-46,-20,-94,-260,-435,-533,-517,-413,-294,-242,-304,-453,-597,-643,-565,-411,-258,-163,-133,-137,-117,-34,100,221,262,213,122,49,25,49,100,153,177,162,127,110,122,135,113,44,-50,-140,-206,-238,-232,-198,-162,-151,-166,-193,-217,-238,-260,-286,-314,-346,-379,-403,-398,-356,-283,-195,-111,-49,-20,-25,-46,-64,-66,-59,-54,-55,-54,-45,-26,-6,7,4,-25,-79,-154,-234,-299,-339,-350,-337,-305,-264,-221,-186,-158,-135,-113,-99,-99,-113,-124,-116,-81,-23,41,95,126,129,108,81,61,54,52,47,32,8,-17,-28,-14,18,44,48,30,10,0}
        },
        {    // H0e140a.wav
            {1,0,-1,0,0,-2,-3,-2,0,-1,-2,-1,0,0,-1,-1,0,0,-3,-4,0,2,0,-3,-1,4,2,-5,-4,5,9,0,-9,-1,12,6,-13,-14,12,25,0,-23,9,58,43,44,371,1261,2434,3073,2444,633,-1363,-2374,-1953,-624,642,1149,809,17,-622,-516,665,2740,4931,6211,5930,4288,2230,811,502,965,1424,1295,567,-316,-907,-1120,-1233,-1580,-2223,-2889,-3197,-2971,-2371,-1753,-1397,-1341,-1433,-1495,-1420,-1166,-728,-164,369,690,731,618,573,731,1039,1306,1361,1162,807,470,289,298,416,524,549,498,422,370,363,393,426,403,271,23,-284,-565,-766,-897,-1015,-1166,-1339,-1466,-1476,-1353,-1156,-971,-844,-765,-703,-645,-585,-503,-371,-192,-18,96,143,168,217,287,341,349,310,244,173,110,64,30,-9,-73,-165,-263,-335,-364,-348,-305,-261,-240,-254,-296,-339,-351,-319,-259,-204,-180,-191,-220,-248,-264,-267,-257,-237,-213,-192,-174,-154,-121,-72,-14,43,84,101,93,70,43,19,-6,-42,-84,-119,-133,-124,-101,-80,-74,-90,-127,-173,-212,-228,-219,-193,-168,-157,-161,-173,-185,-191,-191,-186,-179,-174,-179,-192,-206,-211,-205,-194,-185,-176,-158,-130,-98,-70,-50,-44,-56,-84,-117,-140,-146,-140,-132,-121,-105,-84,-59,-36,-16,-5,-7,-22,-44,-68,-88,-100,-103,-96,-86,-82,-86,-95,-108,-125,-140,-147,-144,-138,-141,-148,-147,-133,-116,-107,-99,-86,-76,-81,-100,-107,-78,-28},
            {-61,30,92,10,-112,-73,99,129,-80,-208,14,255,9,-257,1029,4724,8963,9792,4714,-4234,-11392,-11904,-5578,3210,8991,8819,3661,-2553,-5231,-1870,5998,13326,14960,9710,1540,-3443,-1730,5106,11938,13948,9697,1574,-6073,-9670,-8397,-4397,-1126,-947,-3652,-6958,-8465,-7470,-5239,-3740,-4011,-5500,-6713,-6459,-4614,-1996,300,1500,1434,564,-209,-39,1279,3098,4382,4496,3601,2377,1457,1095,1179,1376,1279,637,-413,-1379,-1800,-1642,-1286,-1133,-1276,-1557,-1819,-2015,-2119,-2072,-1862,-1603,-1434,-1367,-1277,-1064,-764,-501,-345,-267,-193,-77,98,333,602,835,951,927,821,730,720,782,852,849,724,483,185,-86,-260,-311,-270,-220,-255,-422,-669,-881,-959,-903,-795,-722,-714,-748,-790,-799,-733,-567,-337,-130,-23,-13,-37,-35,7,79,173,278,352,347,272,194,186,257,350,393,346,212,33,-118,-174,-125,-42,-28,-132,-315,-483,-559,-524,-419,-324,-312,-399,-529,-606,-572,-440,-277,-151,-98,-105,-127,-102,-2,140,246,263,204,130,87,86,109,133,142,125,88,61,69,106,131,109,36,-63,-162,-239,-279,-273,-233,-186,-158,-153,-164,-187,-223,-270,-320,-368,-411,-445,-456,-428,-355,-251,-141,-50,2,10,-16,-50,-66,-59,-39,-21,-13,-16,-26,-38,-52,-67,-89,-124,-173,-228,-275,-303,-310,-300,-274,-237,-200,-175,-164,-157,-144,-123,-104,-95,-91,-81,-57,-21,21,64,101,119,115,94,72,59,52,40,18,-10,-36,-49,-43,-18,12,29,25,8}
        },
        {    // H0e145a.wav
            {-1,-1,-2,-4,-5,-2,-1,-2,-4,-3,0,0,-2,-3,-1,0,-3,-5,-2,1,0,-3,-1,3,1,-6,-5,5,9,-3,-14,-5,14,11,-14,-21,8,28,2,-31,-3,57,49,40,365,1320,2647,3445,2841,845,-1469,-2751,-2405,-941,556,1238,919,11,-748,-605,851,3331,5818,7072,6434,4320,1957,542,467,1180,1715,1444,458,-639,-1290,-1415,-1394,-1680,-2389,-3206,-3648,-3449,-2753,-1978,-1495,-1406,-1557,-1709,-1679,-1384,-833,-152,432,709,656,491,503,814,1282,1631,1671,1410,1008,645,420,324,284,233,154,82,52,66,96,127,161,202,230,208,112,-56,-280,-532,-775,-962,-1054,-1044,-962,-857,-774,-739,-756,-802,-841,-836,-772,-657,-521,-392,-285,-200,-124,-53,11,66,110,142,155,145,114,78,46,16,-29,-94,-160,-196,-186,-141,-95,-79,-104,-159,-221,-266,-278,-256,-211,-162,-128,-120,-140,-178,-219,-249,-260,-256,-243,-228,-216,-208,-202,-189,-164,-126,-81,-40,-13,-2,-5,-17,-34,-51,-69,-88,-107,-119,-116,-100,-80,-73,-85,-111,-141,-164,-170,-158,-134,-110,-99,-105,-124,-144,-156,-157,-150,-143,-146,-163,-190,-216,-228,-226,-215,-204,-194,-179,-157,-131,-111,-103,-107,-120,-137,-155,-167,-172,-166,-152,-128,-94,-52,-9,24,40,40,26,-1,-38,-78,-109,-126,-129,-125,-116,-106,-100,-105,-119,-134,-144,-150,-157,-162,-163,-163,-162,-157,-139,-115,-97,-91,-90,-85,-83,-97,-121,-126,-91,-32},
            {12,-51,-48,34,69,-15,-96,-26,106,69,-118,-141,96,191,-106,3,1923,5741,8954,8025,1885,-6199,-10785,-8707,-1634,5458,8153,5430,-224,-4663,-4495,921,8753,14150,13545,7534,693,-1903,1390,7692,12044,11108,5229,-2246,-7416,-8220,-5450,-1953,-602,-2368,-5809,-8365,-8404,-6378,-4204,-3540,-4516,-5899,-6299,-5220,-3154,-981,594,1216,911,166,-180,532,2169,3805,4458,3894,2690,1626,1098,1055,1243,1359,1099,326,-718,-1508,-1680,-1370,-1038,-997,-1194,-1424,-1615,-1802,-1948,-1936,-1754,-1560,-1495,-1494,-1372,-1065,-718,-508,-454,-428,-320,-118,136,414,688,892,958,887,765,695,725,821,905,899,758,497,184,-85,-240,-270,-233,-227,-329,-535,-753,-869,-843,-734,-638,-609,-637,-685,-722,-717,-637,-484,-311,-188,-135,-112,-68,3,81,157,236,304,323,270,184,134,160,238,312,331,268,120,-71,-225,-274,-218,-140,-132,-218,-349,-448,-471,-421,-342,-297,-327,-424,-521,-542,-459,-313,-173,-91,-78,-106,-123,-82,24,151,231,232,180,127,103,108,122,129,116,81,40,19,33,59,63,27,-33,-89,-127,-144,-145,-134,-125,-138,-175,-224,-267,-301,-332,-360,-382,-396,-406,-410,-396,-352,-280,-194,-114,-50,-11,0,-11,-26,-32,-29,-28,-38,-55,-72,-88,-103,-115,-125,-136,-153,-178,-203,-220,-228,-230,-228,-221,-208,-195,-185,-173,-151,-120,-87,-62,-50,-45,-40,-26,0,36,71,91,91,76,56,38,25,14,4,-9,-25,-39,-44,-36,-20,-6,0}
        },
        {    // H0e150a.wav
            {0,-2,-4,-3,0,0,-2,-3,-2,-2,-3,-2,-1,-2,-5,-5,-1,2,-1,-5,-1,6,4,-6,-7,5,11,-2,-16,-7,13,10,-16,-22,11,35,5,-36,-9,57,51,33,374,1418,2901,3831,3210,1007,-1613,-3133,-2843,-1252,459,1312,1029,20,-858,-669,1097,4032,6827,7992,6890,4225,1555,208,446,1458,2085,1662,380,-995,-1770,-1829,-1635,-1789,-2512,-3470,-4061,-3899,-3102,-2161,-1562,-1464,-1686,-1912,-1896,-1545,-903,-140,490,775,708,522,523,842,1336,1721,1793,1539,1109,696,443,384,439,464,357,126,-126,-290,-325,-259,-151,-57,-25,-76,-191,-313,-388,-416,-448,-530,-649,-731,-710,-593,-457,-379,-382,-432,-486,-529,-558,-556,-507,-420,-337,-295,-290,-283,-247,-186,-126,-83,-64,-78,-127,-195,-245,-248,-201,-133,-70,-24,3,11,1,-20,-40,-60,-90,-137,-181,-194,-163,-107,-63,-52,-71,-104,-138,-166,-182,-182,-174,-175,-197,-233,-258,-251,-208,-147,-93,-67,-78,-114,-152,-166,-152,-125,-111,-122,-147,-165,-158,-129,-92,-66,-63,-84,-114,-137,-142,-127,-102,-81,-78,-94,-115,-122,-108,-81,-63,-66,-88,-116,-140,-155,-164,-173,-184,-194,-197,-191,-178,-165,-156,-153,-160,-179,-203,-221,-224,-210,-185,-153,-116,-77,-38,-2,28,50,53,34,-4,-50,-94,-128,-149,-152,-139,-119,-100,-89,-87,-92,-106,-126,-145,-158,-165,-169,-169,-161,-148,-133,-119,-105,-95,-94,-102,-110,-111,-108,-112,-119,-110,-73,-24},
            {11,31,1,-46,-29,41,52,-32,-86,-2,100,34,-124,-97,118,130,-125,277,2503,6123,8424,6444,166,-6608,-9136,-5789,656,5509,5843,2176,-2494,-4781,-2704,3250,10083,13800,12136,6507,1191,30,3424,8207,10316,7840,2085,-3699,-6635,-5961,-3256,-1183,-1594,-4274,-7259,-8482,-7394,-5225,-3777,-3901,-4998,-5780,-5414,-4006,-2219,-662,358,738,556,208,329,1305,2815,3974,4077,3182,1981,1150,907,1064,1296,1300,864,19,-891,-1423,-1423,-1152,-973,-993,-1073,-1122,-1226,-1463,-1718,-1805,-1716,-1630,-1654,-1672,-1495,-1121,-750,-564,-544,-537,-425,-199,93,404,687,879,937,881,786,731,752,836,922,931,806,551,233,-49,-220,-261,-231,-228,-329,-521,-705,-783,-743,-655,-592,-574,-585,-610,-636,-628,-543,-388,-231,-145,-131,-126,-81,-8,57,102,139,168,163,119,72,69,120,189,226,208,131,12,-117,-205,-219,-176,-142,-178,-284,-403,-463,-429,-329,-230,-201,-260,-364,-440,-434,-348,-229,-133,-92,-105,-139,-145,-87,25,136,190,176,133,105,105,114,109,75,19,-40,-68,-43,29,105,142,126,74,9,-55,-112,-154,-178,-195,-219,-252,-282,-301,-313,-331,-357,-381,-395,-396,-382,-348,-289,-213,-141,-89,-62,-54,-57,-62,-62,-56,-51,-56,-72,-95,-115,-127,-128,-119,-107,-102,-111,-131,-153,-173,-190,-204,-211,-206,-192,-176,-161,-140,-110,-75,-47,-31,-25,-24,-22,-18,-6,14,36,47,42,27,14,9,7,4,-6,-25,-50,-68,-68,-45,-15}
        },
        {    // H0e155a.wav
            {-4,-3,-1,-1,-3,-3,-1,1,0,-1,-1,-2,-4,-3,1,4,1,-2,0,6,3,-6,-6,7,12,-3,-18,-7,16,13,-16,-25,10,37,8,-35,-7,60,48,28,405,1557,3190,4214,3528,1097,-1806,-3518,-3245,-1519,382,1373,1105,2,-958,-669,1446,4839,7893,8892,7254,4011,1071,-129,484,1802,2476,1852,266,-1362,-2254,-2279,-1951,-1963,-2634,-3670,-4409,-4343,-3494,-2380,-1606,-1449,-1746,-2090,-2128,-1717,-941,-51,631,877,721,471,490,904,1506,1940,1970,1620,1098,636,377,341,430,493,416,206,-37,-208,-279,-294,-303,-332,-381,-444,-514,-579,-628,-662,-690,-715,-720,-678,-572,-407,-223,-71,6,1,-54,-116,-154,-165,-159,-156,-172,-212,-264,-298,-293,-256,-224,-234,-301,-405,-506,-555,-521,-409,-267,-158,-119,-136,-154,-131,-66,4,41,30,-15,-71,-116,-131,-106,-48,18,56,46,-2,-60,-102,-119,-119,-116,-125,-148,-178,-198,-195,-168,-130,-103,-102,-122,-151,-173,-186,-195,-211,-239,-275,-303,-302,-258,-176,-84,-22,-16,-59,-116,-154,-160,-143,-118,-96,-80,-73,-74,-75,-66,-45,-23,-10,-15,-34,-56,-75,-92,-110,-133,-160,-184,-197,-195,-180,-164,-157,-165,-186,-212,-234,-243,-237,-218,-187,-149,-105,-60,-19,10,24,15,-16,-65,-117,-157,-177,-175,-155,-125,-91,-64,-50,-50,-62,-79,-99,-122,-143,-158,-164,-159,-147,-133,-120,-110,-104,-100,-101,-108,-119,-131,-137,-134,-123,-107,-86,-61,-33,-9},
            {-12,-9,20,31,-8,-49,-20,47,43,-44,-78,17,101,14,-129,-69,135,104,-112,447,2745,6057,7718,5337,-461,-5913,-7209,-3824,1208,4114,3323,70,-3043,-3727,-975,4466,10116,12901,11261,6603,2431,1598,4076,7195,7958,5317,680,-3375,-4974,-4094,-2363,-1754,-3108,-5592,-7481,-7615,-6251,-4669,-4005,-4391,-5069,-5182,-4443,-3158,-1814,-717,26,387,441,483,927,1922,3085,3734,3475,2551,1591,1069,1016,1160,1207,980,448,-243,-822,-1077,-1043,-952,-965,-1023,-1000,-917,-929,-1106,-1340,-1501,-1605,-1746,-1899,-1895,-1625,-1199,-849,-702,-682,-630,-461,-195,111,408,648,789,825,800,777,800,870,953,994,940,766,501,222,13,-84,-95,-100,-179,-354,-558,-691,-703,-631,-557,-527,-528,-534,-536,-534,-507,-428,-304,-186,-119,-99,-91,-77,-70,-78,-81,-59,-26,-17,-41,-67,-55,-1,67,120,138,111,39,-51,-104,-93,-48,-43,-127,-277,-415,-473,-432,-323,-207,-144,-156,-216,-268,-274,-238,-193,-167,-165,-175,-179,-155,-83,20,107,129,88,28,-6,0,25,51,69,76,74,70,78,97,111,99,61,9,-40,-81,-114,-140,-162,-189,-223,-257,-282,-300,-314,-323,-320,-306,-296,-301,-313,-313,-294,-262,-226,-187,-145,-107,-83,-74,-68,-57,-47,-50,-68,-92,-110,-117,-113,-102,-91,-85,-90,-103,-120,-138,-153,-163,-168,-166,-158,-142,-120,-94,-72,-53,-36,-23,-17,-18,-20,-15,-4,5,6,1,-5,-12,-19,-23,-19,-13,-16,-29,-39,-33,-13}
        },
        {    // H0e160a.wav
            {-2,-3,-3,-2,0,0,-3,-3,-2,-2,-5,-5,0,3,1,-1,3,8,3,-7,-5,9,13,-4,-19,-6,18,12,-20,-25,15,41,3,-41,-3,71,50,29,468,1759,3537,4589,3753,1059,-2076,-3885,-3569,-1721,316,1404,1146,-29,-1038,-607,1905,5770,9036,9764,7493,3652,515,-433,619,2224,2870,1977,74,-1768,-2724,-2705,-2289,-2222,-2854,-3901,-4688,-4665,-3808,-2613,-1723,-1494,-1814,-2245,-2332,-1855,-918,119,836,1001,734,435,489,974,1625,2067,2090,1738,1206,705,381,287,357,435,370,139,-144,-328,-349,-265,-190,-216,-364,-584,-782,-879,-873,-846,-894,-1025,-1138,-1103,-864,-489,-106,173,309,318,248,156,98,108,175,244,251,175,47,-75,-158,-210,-263,-332,-408,-470,-504,-516,-519,-523,-525,-514,-475,-403,-306,-201,-110,-54,-48,-93,-167,-226,-226,-151,-27,94,163,165,115,48,-7,-34,-36,-30,-31,-50,-84,-121,-148,-154,-132,-86,-38,-14,-34,-92,-160,-214,-248,-279,-318,-361,-390,-384,-336,-259,-174,-111,-88,-106,-146,-182,-190,-165,-120,-80,-62,-69,-80,-75,-45,-3,34,54,56,41,10,-30,-70,-104,-133,-158,-172,-167,-142,-113,-97,-99,-116,-141,-175,-213,-243,-254,-242,-213,-178,-140,-101,-67,-48,-50,-71,-107,-153,-199,-233,-243,-226,-185,-131,-77,-35,-13,-9,-17,-34,-58,-88,-117,-136,-143,-139,-128,-112,-95,-84,-84,-95,-110,-125,-139,-151,-157,-153,-141,-124,-99,-65,-25,5,15,8},
            {15,4,-18,-13,21,32,-10,-49,-15,48,34,-51,-72,27,96,-2,-128,-47,143,86,-104,507,2712,5695,7022,4774,-221,-4661,-5604,-3013,509,2248,1450,-713,-2462,-2413,63,4544,9306,11954,11060,7479,3844,2483,3617,5434,5782,3867,641,-2157,-3368,-3136,-2602,-2890,-4226,-5860,-6782,-6569,-5635,-4773,-4476,-4621,-4709,-4357,-3583,-2673,-1838,-1069,-303,366,772,958,1247,1894,2722,3223,3058,2390,1686,1262,1094,1001,863,636,283,-183,-630,-885,-915,-852,-829,-842,-829,-807,-860,-999,-1137,-1230,-1359,-1613,-1912,-2040,-1867,-1484,-1106,-858,-707,-554,-353,-119,112,316,475,584,657,722,795,872,949,1014,1036,968,784,520,259,75,-12,-40,-71,-156,-303,-470,-584,-601,-539,-460,-415,-413,-435,-459,-469,-452,-399,-322,-252,-211,-193,-176,-156,-149,-166,-198,-223,-229,-222,-207,-185,-147,-89,-12,73,142,164,127,60,10,2,13,-5,-77,-188,-297,-362,-362,-304,-223,-167,-160,-183,-195,-176,-144,-131,-149,-190,-238,-276,-281,-230,-128,-18,53,72,67,67,80,91,86,69,51,38,36,46,58,62,50,24,-7,-39,-72,-102,-125,-143,-165,-192,-217,-231,-235,-239,-248,-258,-268,-286,-319,-355,-375,-369,-340,-299,-253,-200,-146,-100,-64,-38,-22,-19,-34,-64,-96,-117,-122,-114,-102,-89,-78,-70,-65,-65,-74,-92,-117,-138,-148,-146,-133,-115,-91,-62,-35,-15,-3,2,-1,-14,-33,-50,-55,-49,-43,-46,-50,-46,-32,-21,-19,-23,-20,-8}
        },
        {    // H0e165a.wav
            {-4,-2,2,1,-2,-3,-2,-1,-4,-3,1,3,-1,-4,1,7,2,-8,-5,9,12,-8,-23,-7,17,9,-24,-26,17,39,-5,-45,4,78,45,40,572,2020,3916,4928,3878,913,-2394,-4213,-3799,-1837,279,1397,1123,-92,-1080,-450,2457,6731,10124,10531,7638,3257,-17,-677,813,2671,3241,2042,-184,-2208,-3180,-3081,-2582,-2480,-3126,-4208,-5015,-4972,-4054,-2773,-1804,-1539,-1889,-2395,-2538,-2026,-948,267,1088,1223,832,424,468,1033,1772,2235,2202,1771,1197,711,428,358,410,433,303,20,-285,-461,-458,-348,-256,-263,-377,-559,-757,-933,-1076,-1186,-1258,-1270,-1200,-1044,-827,-589,-360,-154,22,163,267,342,396,438,467,474,446,381,290,195,119,73,54,33,-28,-160,-355,-557,-696,-736,-693,-617,-545,-484,-428,-376,-340,-325,-326,-333,-336,-327,-292,-219,-118,-18,55,93,106,100,80,56,47,62,83,76,25,-47,-93,-84,-31,34,74,69,15,-71,-159,-219,-246,-260,-292,-347,-402,-423,-392,-319,-238,-186,-183,-223,-271,-290,-262,-199,-132,-88,-71,-69,-61,-33,13,57,83,82,59,26,-8,-41,-71,-96,-115,-127,-127,-114,-86,-51,-19,-5,-18,-58,-114,-169,-210,-233,-241,-236,-220,-195,-170,-151,-140,-134,-137,-156,-196,-248,-292,-309,-293,-248,-183,-111,-46,-3,13,8,-7,-25,-46,-71,-94,-106,-104,-91,-77,-68,-66,-71,-83,-100,-119,-136,-149,-160,-164,-160,-144,-116,-82,-45,-11,13,22,17,6},
            {-7,5,16,4,-19,-13,20,29,-11,-45,-13,41,24,-51,-60,33,86,-10,-116,-34,132,68,-92,488,2482,5157,6427,4672,548,-3307,-4551,-3081,-733,618,455,-559,-1456,-1386,336,3851,8144,11204,11358,8688,5087,2754,2536,3535,4132,3341,1381,-776,-2285,-2987,-3321,-3801,-4577,-5388,-5867,-5860,-5510,-5093,-4775,-4510,-4135,-3580,-2967,-2460,-2029,-1441,-549,447,1149,1390,1431,1658,2131,2540,2590,2315,1960,1655,1337,947,570,318,153,-64,-384,-697,-870,-877,-787,-669,-574,-568,-707,-956,-1196,-1341,-1421,-1523,-1662,-1757,-1728,-1582,-1380,-1154,-880,-549,-211,46,176,213,240,329,485,664,813,919,993,1038,1024,921,738,527,340,197,92,10,-64,-146,-245,-343,-405,-413,-380,-340,-313,-310,-341,-414,-512,-581,-574,-496,-396,-324,-288,-275,-277,-297,-323,-325,-289,-237,-208,-214,-228,-212,-147,-43,79,186,243,230,169,108,78,64,22,-67,-178,-262,-284,-246,-179,-119,-99,-130,-194,-257,-291,-290,-265,-236,-219,-224,-245,-252,-217,-138,-46,24,63,83,94,92,68,31,-7,-37,-57,-60,-41,-2,43,74,84,74,47,5,-42,-82,-112,-137,-162,-184,-201,-215,-231,-249,-267,-284,-309,-343,-379,-401,-402,-385,-349,-294,-224,-153,-99,-65,-45,-33,-31,-42,-64,-87,-103,-108,-102,-86,-63,-40,-23,-19,-29,-52,-82,-109,-127,-135,-135,-126,-106,-76,-43,-16,0,5,0,-18,-46,-73,-90,-96,-93,-87,-78,-67,-56,-47,-37,-23,-8}
        },
        {    // H0e170a.wav
            {1,0,-1,-1,-1,-4,-6,-3,3,3,-3,-5,2,7,0,-8,-1,14,11,-12,-24,-2,20,5,-29,-22,25,37,-17,-50,13,82,34,68,741,2373,4340,5199,3836,599,-2779,-4477,-3891,-1832,282,1349,1021,-199,-1073,-153,3160,7744,11114,11107,7627,2839,-437,-767,1094,3093,3508,1997,-502,-2654,-3620,-3453,-2882,-2736,-3377,-4487,-5331,-5300,-4342,-2971,-1902,-1575,-1926,-2478,-2655,-2116,-946,372,1247,1365,927,492,548,1145,1912,2383,2335,1860,1221,672,364,311,397,438,302,2,-322,-522,-537,-419,-293,-296,-500,-849,-1171,-1299,-1213,-1057,-1002,-1084,-1187,-1175,-1013,-767,-513,-283,-86,64,150,195,250,349,465,534,521,454,407,436,532,630,646,528,288,-9,-276,-452,-525,-529,-518,-530,-569,-616,-640,-624,-571,-504,-457,-457,-502,-552,-553,-469,-318,-153,-29,34,51,48,42,39,42,50,63,72,73,70,74,94,130,167,180,153,86,-2,-86,-152,-205,-257,-316,-379,-428,-442,-406,-326,-236,-181,-186,-244,-316,-361,-356,-304,-226,-152,-106,-85,-69,-35,20,73,96,79,34,-15,-51,-70,-74,-69,-60,-52,-44,-33,-16,6,29,40,30,-1,-45,-90,-133,-175,-213,-244,-263,-266,-257,-237,-211,-190,-188,-211,-255,-305,-343,-355,-331,-276,-199,-121,-58,-21,-6,-8,-17,-27,-38,-49,-60,-67,-64,-54,-40,-29,-26,-34,-55,-86,-114,-132,-141,-145,-147,-145,-136,-122,-104,-76,-39,-8,-1,-17,-36,-35,-14},
            {6,-3,-8,1,14,6,-12,-9,18,25,-9,-38,-12,34,22,-39,-49,25,70,-6,-93,-28,108,60,-72,410,2117,4533,5950,4866,1523,-2108,-3985,-3596,-1986,-519,131,10,-511,-797,79,2808,6937,10645,11862,9894,6053,2653,1288,1870,3038,3371,2327,342,-1718,-3199,-3951,-4228,-4398,-4688,-5091,-5441,-5562,-5376,-4913,-4253,-3519,-2888,-2531,-2438,-2307,-1743,-650,588,1407,1583,1415,1376,1649,2035,2254,2222,2028,1758,1438,1093,769,469,144,-209,-500,-643,-663,-668,-693,-670,-565,-479,-567,-852,-1188,-1419,-1523,-1571,-1603,-1582,-1476,-1324,-1193,-1089,-951,-724,-422,-121,107,240,306,361,449,575,707,803,851,868,872,851,780,647,479,318,197,116,48,-34,-133,-229,-293,-316,-309,-299,-302,-330,-390,-488,-607,-707,-739,-688,-578,-462,-379,-345,-351,-379,-401,-390,-335,-252,-174,-123,-95,-67,-19,55,142,218,259,254,210,154,109,78,41,-23,-120,-223,-292,-301,-254,-185,-131,-115,-135,-181,-241,-298,-329,-322,-291,-263,-250,-232,-185,-109,-32,18,37,36,17,-19,-63,-91,-87,-61,-34,-14,8,41,79,107,121,122,111,82,33,-28,-87,-135,-173,-205,-233,-254,-266,-268,-268,-274,-292,-323,-362,-400,-426,-428,-396,-331,-248,-167,-100,-55,-31,-26,-38,-56,-72,-81,-81,-76,-64,-47,-27,-10,-2,-6,-20,-42,-67,-89,-105,-112,-111,-103,-92,-77,-57,-35,-16,-8,-16,-37,-67,-98,-121,-129,-119,-102,-90,-84,-71,-45,-15}
        },
        {    // H0e175a.wav
            {-1,-1,-1,-5,-6,-2,4,4,-3,-3,3,6,-3,-8,3,17,8,-18,-23,5,23,0,-32,-15,32,30,-31,-49,29,80,15,120,986,2807,4761,5341,3601,157,-3140,-4593,-3815,-1728,294,1245,852,-326,-993,290,3973,8701,11854,11377,7459,2519,-588,-609,1456,3420,3604,1820,-850,-3036,-3964,-3774,-3217,-3080,-3681,-4716,-5514,-5505,-4604,-3257,-2139,-1720,-1995,-2510,-2666,-2086,-860,493,1359,1451,1003,582,651,1237,1985,2463,2452,2004,1338,706,308,212,311,388,276,-13,-320,-496,-528,-509,-535,-635,-780,-934,-1064,-1151,-1197,-1232,-1278,-1316,-1286,-1146,-919,-678,-479,-324,-184,-53,45,90,101,122,179,273,394,546,721,878,947,891,736,551,387,246,110,-20,-126,-213,-310,-437,-569,-651,-654,-603,-553,-548,-594,-674,-758,-807,-782,-669,-495,-314,-172,-83,-38,-25,-32,-41,-34,-3,38,68,79,82,98,140,204,270,305,285,206,95,-7,-83,-143,-210,-293,-374,-425,-427,-377,-293,-209,-164,-181,-249,-324,-362,-350,-302,-247,-207,-187,-178,-161,-119,-52,17,60,58,22,-23,-54,-64,-54,-36,-19,-5,7,24,48,74,94,101,89,54,-2,-67,-127,-174,-209,-238,-260,-271,-268,-257,-246,-242,-251,-278,-318,-361,-390,-390,-356,-293,-212,-132,-69,-31,-14,-13,-22,-37,-50,-55,-55,-52,-49,-38,-18,2,9,-1,-21,-44,-71,-103,-132,-149,-150,-144,-135,-118,-95,-70,-52,-38,-27,-27,-51,-88,-106,-81,-30},
            {-7,-1,4,0,-5,2,11,6,-9,-9,11,20,-4,-30,-14,23,19,-28,-42,12,55,4,-70,-32,80,63,-43,307,1711,3913,5549,5124,2413,-1172,-3689,-4136,-2919,-1168,156,594,169,-534,-360,1785,5852,10140,12229,10787,6695,2431,241,642,2367,3552,3069,1064,-1443,-3379,-4246,-4249,-3992,-4019,-4494,-5175,-5636,-5555,-4894,-3890,-2927,-2355,-2294,-2517,-2529,-1905,-658,692,1511,1571,1217,1013,1243,1744,2161,2279,2114,1782,1380,991,697,526,397,179,-176,-567,-835,-883,-743,-531,-385,-402,-598,-901,-1185,-1365,-1447,-1494,-1540,-1554,-1474,-1283,-1034,-804,-633,-512,-406,-293,-165,-9,181,391,564,642,617,558,555,641,770,863,870,792,656,485,309,166,79,26,-44,-163,-303,-404,-431,-402,-374,-390,-465,-587,-725,-831,-861,-799,-679,-554,-463,-409,-372,-339,-304,-265,-217,-163,-113,-74,-39,15,101,209,309,362,351,281,181,87,23,-15,-49,-102,-180,-262,-319,-323,-272,-190,-118,-86,-102,-151,-213,-268,-304,-316,-315,-315,-319,-310,-265,-183,-90,-17,20,27,13,-15,-47,-68,-68,-52,-32,-13,11,49,94,135,160,165,148,107,46,-24,-92,-151,-201,-240,-264,-271,-266,-258,-256,-267,-295,-337,-383,-419,-434,-424,-385,-320,-241,-162,-101,-62,-39,-30,-33,-47,-65,-76,-76,-68,-55,-38,-16,5,19,20,9,-13,-43,-75,-102,-119,-128,-128,-118,-97,-74,-55,-42,-32,-31,-48,-79,-111,-126,-124,-119,-115,-101,-66,-22}
        },
        {    // H0e180a.wav
            {-2,-6,-6,0,5,1,-5,-3,6,6,-6,-10,6,17,2,-24,-20,11,20,-13,-36,-3,42,17,-50,-42,51,72,-13,202,1314,3325,5166,5317,3131,-428,-3449,-4503,-3526,-1533,253,1021,600,-425,-765,922,4872,9524,12260,11294,7150,2361,-396,-168,1876,3596,3489,1520,-1191,-3327,-4210,-4041,-3566,-3492,-4059,-4964,-5625,-5582,-4774,-3556,-2483,-1987,-2126,-2535,-2633,-2007,-730,643,1471,1508,1071,745,901,1463,2067,2385,2314,1935,1397,860,470,303,306,320,194,-105,-481,-775,-869,-752,-544,-428,-530,-823,-1144,-1335,-1372,-1354,-1380,-1441,-1443,-1306,-1040,-723,-437,-225,-101,-68,-109,-169,-159,-13,251,532,710,741,684,642,675,760,828,820,722,553,347,142,-25,-141,-217,-278,-341,-404,-457,-497,-533,-574,-633,-716,-813,-886,-888,-792,-627,-460,-343,-290,-271,-251,-209,-142,-63,4,40,43,34,45,94,176,271,348,376,331,220,81,-34,-100,-132,-164,-217,-280,-324,-330,-297,-238,-176,-136,-142,-193,-268,-328,-346,-323,-286,-265,-268,-276,-263,-214,-132,-40,38,76,66,21,-30,-63,-71,-66,-54,-32,5,53,103,144,171,176,150,91,10,-69,-131,-175,-208,-234,-251,-260,-265,-269,-273,-278,-291,-316,-353,-391,-415,-410,-373,-309,-231,-153,-87,-45,-29,-30,-37,-43,-50,-60,-66,-63,-47,-26,-7,10,23,26,11,-19,-54,-85,-110,-131,-144,-145,-135,-120,-100,-72,-42,-24,-27,-47,-73,-96,-119,-134,-125,-83,-28},
            {-2,-6,-6,0,5,1,-5,-3,6,6,-6,-10,6,17,2,-24,-20,11,20,-13,-36,-3,42,17,-50,-42,51,72,-13,202,1314,3325,5166,5317,3131,-428,-3449,-4503,-3526,-1533,253,1021,600,-425,-765,922,4872,9524,12260,11294,7150,2361,-396,-168,1876,3596,3489,1520,-1191,-3327,-4210,-4041,-3566,-3492,-4059,-4964,-5625,-5582,-4774,-3556,-2483,-1987,-2126,-2535,-2633,-2007,-730,643,1471,1508,1071,745,901,1463,2067,2385,2314,1935,1397,860,470,303,306,320,194,-105,-481,-775,-869,-752,-544,-428,-530,-823,-1144,-1335,-1372,-1354,-1380,-1441,-1443,-1306,-1040,-723,-437,-225,-101,-68,-109,-169,-159,-13,251,532,710,741,684,642,675,760,828,820,722,553,347,142,-25,-141,-217,-278,-341,-404,-457,-497,-533,-574,-633,-716,-813,-886,-888,-792,-627,-460,-343,-290,-271,-251,-209,-142,-63,4,40,43,34,45,94,176,271,348,376,331,220,81,-34,-100,-132,-164,-217,-280,-324,-330,-297,-238,-176,-136,-142,-193,-268,-328,-346,-323,-286,-265,-268,-276,-263,-214,-132,-40,38,76,66,21,-30,-63,-71,-66,-54,-32,5,53,103,144,171,176,150,91,10,-69,-131,-175,-208,-234,-251,-260,-265,-269,-273,-278,-291,-316,-353,-391,-415,-410,-373,-309,-231,-153,-87,-45,-29,-30,-37,-43,-50,-60,-66,-63,-47,-26,-7,10,23,26,11,-19,-54,-85,-110,-131,-144,-145,-135,-120,-100,-72,-42,-24,-27,-47,-73,-96,-119,-134,-125,-83,-28}
        }
    },
    {    // elev10 
        {    // H10e000a.wav
            {6,7,-6,-9,10,25,4,-26,-11,35,33,-32,-61,9,78,23,-89,-71,77,116,-51,-159,13,191,29,57,1568,4851,7786,7213,2398,-3359,-5535,-3074,381,470,-3005,-5843,-4114,1564,6762,7869,5453,3190,4107,8039,12156,13310,10101,3633,-3052,-6606,-5461,-1060,2934,3167,-1036,-7318,-12098,-12982,-10035,-5381,-1734,-841,-2584,-5153,-6284,-4854,-1675,1212,2213,1376,106,-180,843,2422,3539,3661,2920,1877,1178,1214,1879,2624,2849,2350,1403,477,-87,-184,104,524,709,395,-324,-1022,-1291,-1079,-673,-427,-533,-1006,-1726,-2449,-2854,-2727,-2131,-1368,-744,-390,-261,-252,-281,-302,-316,-358,-443,-511,-466,-274,-10,206,305,285,176,19,-111,-139,-45,106,224,261,217,104,-57,-204,-253,-181,-70,-47,-165,-361,-526,-597,-592,-572,-585,-629,-652,-588,-414,-186,-10,37,-38,-157,-229,-210,-117,-12,39,12,-61,-114,-96,-10,92,150,126,29,-99,-209,-269,-282,-269,-246,-220,-191,-171,-169,-180,-184,-169,-144,-132,-148,-184,-219,-229,-206,-155,-92,-38,-8,-3,-10,-13,-6,2,-6,-36,-81,-124,-144,-128,-77,-11,34,31,-14,-64,-87,-83,-80,-106,-163,-230,-280,-297,-285,-258,-236,-227,-221,-200,-163,-126,-111,-125,-150,-162,-143,-89,-13,64,122,157,174,176,155,106,36,-34,-84,-110,-119,-123,-129,-137,-145,-145,-133,-117,-119,-151,-202,-239,-240,-204,-153,-111,-84,-67,-48,-28,-16,-25,-58,-104,-144,-161,-148,-116,-86,-69,-65,-59,-41,-14},
            {6,7,-6,-9,10,25,4,-26,-11,35,33,-32,-61,9,78,23,-89,-71,77,116,-51,-159,13,191,29,57,1568,4851,7786,7213,2398,-3359,-5535,-3074,381,470,-3005,-5843,-4114,1564,6762,7869,5453,3190,4107,8039,12156,13310,10101,3633,-3052,-6606,-5461,-1060,2934,3167,-1036,-7318,-12098,-12982,-10035,-5381,-1734,-841,-2584,-5153,-6284,-4854,-1675,1212,2213,1376,106,-180,843,2422,3539,3661,2920,1877,1178,1214,1879,2624,2849,2350,1403,477,-87,-184,104,524,709,395,-324,-1022,-1291,-1079,-673,-427,-533,-1006,-1726,-2449,-2854,-2727,-2131,-1368,-744,-390,-261,-252,-281,-302,-316,-358,-443,-511,-466,-274,-10,206,305,285,176,19,-111,-139,-45,106,224,261,217,104,-57,-204,-253,-181,-70,-47,-165,-361,-526,-597,-592,-572,-585,-629,-652,-588,-414,-186,-10,37,-38,-157,-229,-210,-117,-12,39,12,-61,-114,-96,-10,92,150,126,29,-99,-209,-269,-282,-269,-246,-220,-191,-171,-169,-180,-184,-169,-144,-132,-148,-184,-219,-229,-206,-155,-92,-38,-8,-3,-10,-13,-6,2,-6,-36,-81,-124,-144,-128,-77,-11,34,31,-14,-64,-87,-83,-80,-106,-163,-230,-280,-297,-285,-258,-236,-227,-221,-200,-163,-126,-111,-125,-150,-162,-143,-89,-13,64,122,157,174,176,155,106,36,-34,-84,-110,-119,-123,-129,-137,-145,-145,-133,-117,-119,-151,-202,-239,-240,-204,-153,-111,-84,-67,-48,-28,-16,-25,-58,-104,-144,-161,-148,-116,-86,-69,-65,-59,-41,-14}
        },
        {    // H10e005a.wav
            {-4,-4,4,7,-4,-11,4,21,8,-18,-13,24,29,-19,-50,-2,61,27,-69,-72,46,100,-20,-128,-14,148,50,45,1203,3940,6675,6670,2906,-2169,-4588,-2912,131,601,-2247,-5089,-4204,463,5306,6864,5135,3131,3682,6957,10663,12057,9784,4562,-1237,-4807,-4561,-1313,2070,2618,-595,-5857,-10170,-11350,-9259,-5547,-2429,-1408,-2537,-4497,-5482,-4454,-1898,588,1607,1060,52,-194,658,1986,2920,3027,2468,1731,1293,1390,1900,2410,2489,2002,1186,427,2,-22,260,627,794,559,-13,-603,-900,-848,-641,-512,-576,-855,-1323,-1879,-2312,-2397,-2070,-1499,-960,-654,-602,-676,-694,-554,-301,-92,-48,-137,-214,-171,-23,143,269,343,351,275,136,-7,-106,-169,-224,-264,-261,-224,-210,-248,-296,-296,-255,-244,-318,-441,-529,-532,-475,-430,-441,-492,-522,-471,-331,-153,-15,28,-21,-116,-190,-197,-129,-25,51,58,7,-49,-65,-36,14,58,74,48,-22,-112,-185,-220,-228,-237,-255,-268,-259,-233,-207,-194,-185,-170,-156,-157,-178,-204,-209,-181,-127,-69,-25,0,9,8,9,18,29,26,-8,-72,-140,-177,-160,-99,-29,13,8,-33,-82,-111,-116,-113,-123,-156,-204,-246,-262,-245,-213,-192,-199,-225,-242,-232,-202,-174,-160,-155,-147,-126,-91,-39,23,85,136,171,187,179,142,80,10,-46,-81,-98,-104,-109,-116,-128,-136,-133,-124,-126,-152,-191,-218,-214,-186,-152,-125,-106,-92,-77,-58,-36,-26,-46,-93,-141,-162,-152,-131,-111,-89,-56,-18},
            {2,-11,1,25,14,-26,-27,27,51,-12,-74,-23,78,57,-82,-115,48,163,7,-196,-78,206,126,-80,1002,4305,8144,8812,4352,-2521,-6410,-4720,-539,757,-2430,-6115,-5262,581,6854,8885,6474,3537,3904,7937,12707,14600,11743,4954,-2705,-7465,-7073,-2490,2481,3802,100,-6495,-12135,-13951,-11597,-6944,-2685,-873,-1940,-4525,-6312,-5623,-2685,581,2192,1719,413,-116,726,2305,3584,3951,3417,2398,1468,1143,1583,2411,2956,2779,1986,1032,318,5,74,376,613,449,-195,-989,-1444,-1351,-947,-673,-811,-1341,-2035,-2621,-2882,-2738,-2268,-1650,-1042,-527,-143,84,155,95,-74,-350,-685,-929,-919,-630,-227,75,167,71,-127,-319,-371,-183,200,579,752,686,498,312,161,44,-10,30,115,132,11,-209,-424,-557,-607,-625,-661,-724,-773,-733,-565,-317,-104,-20,-67,-170,-238,-229,-158,-81,-56,-98,-168,-198,-148,-39,73,141,141,71,-52,-181,-264,-281,-253,-219,-193,-166,-131,-103,-97,-105,-108,-99,-97,-121,-173,-233,-270,-268,-223,-155,-90,-51,-41,-45,-42,-24,-2,3,-25,-88,-163,-210,-198,-123,-21,56,74,42,-4,-33,-45,-63,-108,-180,-257,-311,-320,-282,-222,-174,-160,-170,-173,-151,-115,-95,-105,-131,-148,-135,-91,-26,47,111,158,179,175,145,90,18,-56,-115,-147,-154,-148,-144,-150,-159,-158,-142,-125,-129,-166,-220,-260,-262,-229,-180,-134,-100,-73,-42,-3,33,42,9,-60,-132,-173,-168,-132,-94,-73,-65,-52,-27,0,13,8}
        },
        {    // H10e010a.wav
            {-3,0,-2,-1,5,5,-5,-9,5,19,7,-15,-10,20,24,-15,-39,3,51,20,-60,-58,42,85,-17,-103,-2,128,41,63,1112,3519,5902,5926,2733,-1602,-3745,-2482,-57,301,-2006,-4280,-3536,246,4202,5639,4586,3350,4019,6643,9483,10514,8718,4581,-140,-3262,-3456,-1250,1196,1593,-831,-4868,-8332,-9559,-8298,-5595,-3046,-1905,-2428,-3760,-4520,-3809,-1895,51,966,744,167,89,726,1640,2262,2353,2060,1698,1521,1612,1852,2003,1876,1474,967,545,305,270,421,661,789,616,151,-369,-680,-714,-611,-557,-649,-888,-1234,-1602,-1859,-1890,-1694,-1387,-1114,-947,-869,-806,-675,-438,-147,74,126,24,-110,-162,-108,0,112,206,264,260,184,51,-114,-292,-451,-539,-528,-451,-380,-359,-365,-355,-332,-341,-405,-483,-511,-462,-370,-299,-293,-347,-412,-423,-344,-198,-56,17,2,-65,-124,-135,-95,-34,12,19,-3,-30,-34,-10,33,74,90,68,11,-60,-124,-172,-215,-258,-292,-301,-285,-261,-244,-232,-213,-184,-159,-155,-172,-194,-199,-175,-125,-64,-13,15,19,11,5,9,16,15,-6,-49,-107,-156,-173,-146,-91,-43,-30,-48,-75,-91,-95,-102,-126,-166,-210,-242,-247,-224,-189,-169,-182,-216,-244,-245,-223,-195,-175,-162,-147,-120,-76,-21,35,83,119,145,158,152,125,81,32,-14,-51,-79,-99,-118,-137,-151,-150,-133,-113,-108,-127,-160,-188,-196,-181,-153,-126,-108,-96,-80,-56,-35,-35,-59,-99,-138,-166,-171,-145,-90,-29},
            {-4,30,28,-21,-39,17,63,7,-79,-47,75,86,-65,-145,16,190,65,-202,-147,196,209,-115,638,3858,8308,10021,6084,-1484,-6837,-6124,-1680,567,-2152,-6284,-6059,-86,7068,9829,7298,3685,3712,8211,13846,16221,13069,5433,-3121,-8434,-8112,-3183,2311,3993,271,-6642,-12584,-14460,-11986,-7257,-3055,-1305,-2289,-4677,-6309,-5593,-2704,503,2028,1427,46,-368,765,2602,3913,4123,3459,2477,1668,1371,1689,2361,2853,2764,2143,1369,784,498,465,576,637,411,-173,-881,-1354,-1448,-1343,-1309,-1458,-1741,-2088,-2454,-2740,-2789,-2495,-1915,-1222,-590,-124,151,267,269,158,-114,-533,-950,-1148,-1042,-756,-492,-349,-296,-265,-215,-100,125,435,703,805,748,641,558,473,353,252,247,318,336,194,-77,-346,-508,-564,-583,-633,-726,-809,-802,-658,-419,-193,-84,-114,-218,-300,-302,-231,-145,-110,-151,-232,-286,-266,-171,-38,80,138,108,3,-120,-197,-208,-185,-167,-162,-142,-95,-38,1,13,11,1,-30,-93,-181,-266,-319,-327,-299,-251,-194,-136,-85,-46,-18,3,15,3,-48,-133,-217,-259,-235,-154,-44,52,98,84,30,-28,-67,-94,-129,-182,-239,-275,-270,-224,-159,-108,-94,-109,-121,-107,-76,-59,-77,-118,-151,-149,-106,-34,42,103,138,152,153,137,92,17,-68,-135,-171,-180,-175,-169,-168,-172,-169,-152,-128,-126,-164,-230,-287,-300,-270,-217,-167,-127,-90,-45,11,66,93,71,5,-71,-120,-132,-116,-93,-78,-73,-67,-49,-16,20,39,31,10}
        },
        {    // H10e015a.wav
            {-1,-4,-3,-1,-3,-2,3,4,-4,-7,4,16,7,-13,-10,15,22,-9,-31,-2,38,16,-47,-48,33,71,-8,-80,-3,105,37,47,907,2957,5113,5387,2875,-886,-3079,-2398,-404,204,-1423,-3387,-3181,-390,2991,4720,4442,3669,4052,5890,8086,9118,8039,4969,1082,-1925,-2792,-1579,289,990,-419,-3418,-6492,-8161,-7801,-5868,-3538,-2041,-1962,-2893,-3747,-3569,-2263,-600,494,691,397,241,509,1039,1527,1816,1917,1884,1751,1575,1439,1390,1393,1360,1221,964,655,421,382,537,715,685,364,-103,-472,-614,-594,-576,-684,-934,-1250,-1501,-1570,-1436,-1208,-1048,-1033,-1093,-1078,-892,-556,-190,65,117,-20,-233,-378,-378,-267,-125,-13,57,87,74,25,-48,-138,-248,-371,-469,-506,-485,-450,-433,-424,-401,-370,-363,-391,-426,-427,-382,-318,-276,-283,-332,-387,-395,-325,-194,-62,10,2,-55,-106,-110,-65,-6,24,8,-32,-56,-40,6,58,92,95,66,10,-57,-116,-161,-201,-241,-273,-282,-265,-239,-220,-209,-195,-176,-159,-157,-171,-188,-192,-175,-137,-91,-49,-19,-7,-10,-17,-17,-8,-1,-14,-53,-107,-150,-162,-142,-104,-68,-46,-43,-53,-67,-79,-95,-121,-160,-203,-234,-243,-229,-206,-188,-185,-190,-191,-178,-160,-148,-149,-153,-147,-124,-87,-39,15,65,99,115,117,110,91,57,13,-26,-52,-68,-83,-103,-123,-136,-136,-121,-102,-96,-114,-148,-176,-180,-164,-141,-120,-104,-92,-89,-87,-76,-56,-52,-83,-130,-148,-109,-38},
            {38,-15,-52,-1,70,34,-76,-81,55,119,-25,-170,-48,192,146,-171,-238,129,310,-70,176,2913,7789,11009,8522,846,-6368,-7731,-3805,-351,-1673,-5711,-6576,-1462,6100,10132,8491,4685,3898,7961,14067,17470,15078,7301,-2315,-9052,-9737,-4880,1409,4162,1088,-5947,-12598,-15267,-13209,-8335,-3561,-1148,-1771,-4322,-6518,-6318,-3443,291,2421,1943,96,-922,29,2237,4101,4601,3846,2608,1630,1327,1728,2470,2968,2821,2138,1393,965,876,939,1007,986,729,112,-776,-1610,-2065,-2061,-1773,-1477,-1423,-1741,-2349,-2938,-3149,-2838,-2157,-1389,-740,-277,8,166,263,312,205,-180,-795,-1376,-1652,-1561,-1229,-798,-333,93,369,446,419,440,539,629,651,650,683,707,642,505,408,407,415,303,54,-216,-388,-449,-479,-560,-700,-831,-853,-715,-459,-213,-100,-151,-292,-408,-425,-343,-224,-155,-189,-300,-400,-405,-295,-127,25,111,116,50,-52,-138,-174,-163,-138,-121,-99,-51,20,83,113,111,90,49,-25,-139,-271,-381,-431,-413,-342,-248,-159,-93,-52,-29,-16,-14,-35,-90,-170,-252,-303,-295,-222,-105,7,65,51,-5,-50,-61,-59,-80,-134,-199,-239,-234,-183,-109,-46,-24,-41,-67,-73,-58,-47,-62,-101,-140,-153,-129,-71,5,74,119,143,149,132,80,-6,-100,-173,-211,-220,-211,-194,-180,-175,-174,-161,-138,-131,-164,-232,-299,-328,-310,-262,-205,-153,-107,-58,2,65,105,98,43,-30,-87,-110,-105,-85,-67,-59,-61,-55,-27,9,25,5,-28,-37,-16}
        },
        {    // H10e020a.wav
            {0,2,0,-3,-2,0,-1,-1,2,3,-2,-4,4,13,7,-9,-9,11,20,-3,-26,-8,29,21,-30,-42,16,58,6,-60,-13,81,43,23,651,2330,4324,4947,3137,-145,-2505,-2398,-706,243,-785,-2624,-3030,-1084,1949,4043,4366,3800,3790,4972,6771,7985,7619,5441,2153,-883,-2365,-1894,-320,795,246,-2025,-4953,-7078,-7417,-5983,-3717,-1923,-1472,-2258,-3315,-3562,-2624,-1044,249,707,478,110,52,406,1012,1616,1985,1975,1637,1220,1017,1130,1405,1575,1474,1125,691,383,348,573,844,881,557,20,-440,-641,-635,-603,-675,-844,-1022,-1122,-1118,-1045,-977,-975,-1032,-1069,-997,-789,-504,-250,-123,-166,-343,-548,-665,-637,-496,-323,-177,-82,-42,-55,-96,-128,-126,-110,-119,-173,-256,-345,-427,-486,-494,-438,-350,-291,-302,-363,-417,-422,-385,-344,-328,-334,-335,-302,-227,-135,-62,-33,-46,-77,-94,-81,-45,-8,3,-20,-61,-92,-92,-57,-3,50,80,75,38,-17,-71,-113,-148,-179,-202,-208,-198,-185,-183,-190,-194,-186,-172,-164,-170,-185,-199,-201,-188,-159,-120,-82,-55,-41,-33,-26,-18,-16,-27,-52,-89,-129,-154,-150,-115,-69,-38,-35,-51,-71,-84,-93,-105,-129,-163,-199,-225,-228,-209,-182,-161,-148,-137,-124,-112,-109,-116,-129,-140,-139,-121,-84,-33,18,59,86,94,84,57,22,-14,-43,-63,-72,-73,-77,-92,-112,-124,-120,-106,-98,-106,-125,-145,-158,-156,-138,-115,-104,-109,-113,-96,-67,-53,-65,-79,-65,-25},
            {-39,-10,59,51,-55,-102,12,127,33,-158,-123,139,217,-76,-294,-12,341,80,-137,1720,6406,11029,10837,4309,-4225,-8382,-6276,-2292,-1765,-4764,-6300,-2535,4523,9256,8651,5322,4393,8204,14344,18119,16324,9148,-275,-7656,-9774,-6400,-687,2770,1133,-4739,-11224,-14760,-14066,-10291,-5705,-2376,-1463,-2854,-5094,-6077,-4540,-1224,1632,2266,955,-398,-178,1554,3454,4319,3963,2963,1988,1473,1603,2242,2892,2995,2420,1585,1036,972,1206,1456,1510,1182,338,-894,-2038,-2555,-2287,-1588,-1037,-1023,-1552,-2330,-2976,-3237,-3077,-2618,-1997,-1301,-620,-91,195,282,276,168,-186,-844,-1610,-2121,-2128,-1627,-799,103,795,1042,832,437,217,307,549,725,784,805,811,735,551,359,279,304,309,202,7,-184,-314,-396,-477,-593,-730,-819,-769,-551,-255,-45,-40,-217,-435,-548,-505,-372,-266,-261,-341,-429,-451,-382,-242,-70,87,173,150,35,-103,-188,-199,-164,-116,-60,7,79,136,170,181,166,111,6,-136,-275,-370,-399,-368,-302,-231,-175,-138,-113,-92,-65,-38,-32,-74,-173,-298,-393,-411,-347,-234,-116,-28,15,20,10,4,0,-19,-66,-130,-181,-189,-144,-64,9,40,19,-24,-52,-52,-41,-46,-75,-114,-144,-148,-115,-46,36,103,140,149,133,84,-5,-110,-193,-230,-232,-226,-222,-218,-209,-196,-179,-152,-129,-135,-187,-264,-321,-328,-293,-241,-188,-133,-69,6,78,128,130,79,-6,-86,-129,-132,-111,-83,-56,-34,-18,-6,10,23,16,-19,-64,-84,-63,-22}
        },
        {    // H10e025a.wav
            {-5,-5,-1,2,1,-3,-2,-1,-1,-1,2,5,1,-3,1,10,9,-5,-10,5,17,2,-21,-12,21,24,-17,-39,2,51,23,-43,-25,64,60,6,390,1696,3535,4510,3394,587,-1915,-2344,-948,283,-230,-1963,-2891,-1658,1075,3425,4171,3714,3390,4108,5662,7052,7243,5768,2987,-8,-1908,-1981,-635,767,826,-916,-3691,-6052,-6823,-5783,-3723,-1905,-1277,-1900,-2970,-3436,-2779,-1348,-15,546,314,-180,-346,51,819,1551,1905,1789,1383,1010,907,1089,1371,1538,1479,1219,875,606,536,664,817,768,436,-25,-366,-467,-419,-390,-459,-584,-688,-742,-778,-844,-967,-1126,-1239,-1211,-1015,-733,-503,-413,-463,-598,-761,-902,-956,-878,-680,-441,-247,-137,-95,-82,-68,-38,10,56,72,42,-31,-135,-260,-384,-470,-483,-425,-343,-295,-308,-363,-414,-428,-398,-343,-293,-261,-235,-194,-136,-85,-69,-90,-121,-138,-133,-117,-102,-95,-100,-116,-131,-129,-98,-39,33,96,130,123,79,16,-44,-87,-114,-134,-149,-161,-169,-173,-172,-168,-164,-166,-179,-204,-233,-256,-264,-249,-213,-165,-119,-87,-69,-57,-43,-28,-20,-29,-58,-97,-131,-149,-144,-117,-80,-48,-35,-43,-61,-74,-77,-81,-97,-127,-160,-179,-179,-165,-151,-144,-141,-136,-127,-116,-107,-105,-110,-122,-133,-129,-102,-55,-8,23,37,42,41,27,-5,-45,-74,-84,-84,-87,-93,-95,-91,-89,-92,-94,-91,-88,-98,-120,-139,-141,-130,-119,-117,-117,-111,-100,-85,-67,-42,-14},
            {19,61,-5,-96,-45,98,94,-97,-179,32,237,64,-265,-176,261,263,-191,621,4422,9871,12389,8414,-223,-7356,-8560,-5470,-3255,-4290,-5641,-3194,2888,8057,8588,5789,4491,7873,14321,19045,18173,11428,1917,-5973,-9004,-6807,-2080,1130,165,-4512,-10018,-13421,-13615,-11357,-8096,-5058,-3111,-2729,-3615,-4538,-4104,-2053,346,1460,923,-26,125,1648,3452,4289,3864,2815,1936,1611,1810,2300,2751,2835,2443,1798,1288,1154,1348,1613,1610,1059,-60,-1347,-2157,-2113,-1464,-866,-784,-1162,-1662,-2080,-2457,-2850,-3159,-3190,-2822,-2085,-1137,-235,351,470,173,-365,-989,-1603,-2070,-2187,-1823,-1067,-195,506,886,940,772,549,436,497,660,799,856,849,791,660,461,275,194,218,253,215,105,-24,-144,-272,-427,-594,-730,-783,-711,-514,-266,-92,-88,-237,-423,-532,-531,-477,-437,-436,-455,-467,-446,-371,-228,-32,154,254,229,107,-43,-156,-201,-181,-118,-38,36,89,119,129,119,85,28,-45,-124,-198,-256,-286,-289,-278,-263,-242,-202,-141,-74,-25,-5,-23,-88,-199,-332,-445,-498,-473,-379,-241,-100,5,55,60,48,32,5,-38,-87,-121,-123,-93,-43,3,25,15,-6,-11,3,10,-18,-77,-138,-174,-173,-137,-69,15,89,128,129,105,65,3,-79,-164,-225,-253,-258,-257,-253,-244,-225,-197,-165,-140,-142,-179,-241,-298,-324,-309,-265,-207,-143,-71,10,89,140,142,91,10,-70,-122,-139,-131,-113,-95,-77,-53,-21,9,23,17,-6,-44,-89,-126,-131,-93,-33}
        },
        {    // H10e030a.wav
            {-4,-3,-2,-3,-1,0,0,-2,-3,-1,-1,-1,1,3,1,-4,-2,7,9,-2,-11,-1,14,9,-14,-18,7,24,0,-30,-13,32,28,-24,-28,41,60,-11,175,1123,2744,3969,3516,1285,-1207,-2127,-1153,181,136,-1347,-2602,-2029,267,2685,3780,3527,3055,3416,4710,6158,6758,5889,3637,836,-1284,-1804,-787,664,1142,-60,-2479,-4851,-5981,-5455,-3798,-2081,-1257,-1597,-2554,-3181,-2838,-1661,-403,218,78,-341,-441,2,741,1347,1560,1413,1122,911,897,1072,1339,1565,1620,1439,1070,679,456,474,622,699,583,325,65,-107,-200,-256,-290,-307,-354,-502,-775,-1109,-1387,-1506,-1430,-1199,-922,-728,-694,-796,-939,-1041,-1084,-1081,-1026,-895,-689,-455,-254,-115,-30,19,51,82,123,173,207,201,143,34,-113,-275,-405,-457,-421,-339,-277,-273,-313,-357,-373,-357,-326,-298,-279,-262,-240,-211,-182,-163,-162,-182,-217,-251,-260,-233,-185,-143,-124,-114,-91,-44,18,80,131,160,156,118,61,10,-21,-42,-67,-97,-122,-137,-150,-170,-191,-200,-201,-208,-233,-268,-291,-289,-267,-239,-210,-177,-137,-100,-74,-60,-50,-41,-38,-49,-79,-119,-151,-156,-130,-87,-49,-30,-30,-38,-46,-52,-61,-77,-99,-121,-135,-136,-128,-121,-124,-137,-146,-141,-122,-103,-96,-104,-118,-127,-124,-108,-86,-65,-49,-37,-30,-25,-24,-30,-46,-70,-96,-112,-110,-95,-80,-73,-68,-58,-48,-47,-63,-88,-112,-132,-145,-148,-138,-126,-123,-128,-118,-79,-27},
            {42,-76,-94,44,129,-8,-176,-76,184,178,-148,-271,91,350,-38,-70,2334,7506,12155,11682,4994,-3692,-8716,-8435,-6054,-5087,-5175,-3289,1601,6554,7942,5884,4417,7191,13557,19062,19373,13615,4592,-3419,-7227,-6267,-2684,65,-531,-4399,-9205,-12375,-12946,-11654,-9640,-7477,-5383,-3828,-3342,-3688,-3723,-2479,-337,1231,1230,262,-102,1017,2980,4391,4447,3446,2243,1514,1480,1989,2638,2943,2665,2033,1528,1395,1429,1268,788,158,-412,-834,-1084,-1127,-986,-807,-762,-907,-1189,-1573,-2085,-2701,-3252,-3493,-3258,-2555,-1568,-598,29,100,-374,-1161,-1928,-2369,-2294,-1702,-822,-19,433,532,488,500,612,768,927,1066,1128,1046,840,624,497,442,380,289,220,205,202,153,59,-34,-113,-223,-400,-604,-739,-737,-612,-433,-267,-155,-116,-158,-267,-400,-500,-538,-540,-555,-587,-585,-491,-306,-90,95,220,279,258,156,14,-94,-119,-80,-33,-14,-14,-10,2,12,17,23,29,14,-41,-128,-212,-259,-261,-237,-212,-193,-170,-133,-86,-47,-33,-53,-110,-202,-319,-430,-498,-493,-412,-279,-139,-30,34,64,80,87,72,27,-37,-91,-118,-112,-80,-28,27,64,72,61,49,35,2,-59,-128,-174,-179,-146,-91,-26,41,96,127,127,95,36,-41,-123,-197,-253,-283,-288,-271,-242,-211,-178,-143,-116,-114,-151,-214,-273,-307,-309,-283,-232,-159,-74,12,89,147,170,143,71,-16,-87,-127,-142,-140,-125,-98,-66,-32,-1,20,19,-9,-53,-92,-115,-122,-116,-93,-55,-16}
        },
        {    // H10e035a.wav
            {-4,-5,-2,1,-1,-4,-3,1,2,-1,-3,-2,-1,-1,0,1,1,-3,-4,2,7,0,-9,-5,9,11,-8,-19,0,25,12,-25,-29,13,36,1,-30,10,52,6,53,649,1958,3298,3466,1927,-382,-1738,-1318,-61,334,-738,-2128,-2180,-469,1840,3240,3296,2820,2889,3866,5238,6114,5796,4143,1696,-498,-1434,-856,474,1264,625,-1323,-3589,-5030,-5051,-3875,-2335,-1349,-1373,-2135,-2846,-2806,-1936,-798,-71,5,-257,-375,-131,344,791,1065,1170,1164,1096,1035,1063,1215,1414,1515,1410,1126,807,613,616,756,888,880,696,401,99,-134,-274,-339,-380,-471,-675,-991,-1339,-1595,-1670,-1556,-1332,-1113,-990,-983,-1048,-1119,-1156,-1153,-1105,-995,-811,-581,-360,-187,-62,32,103,151,185,220,258,283,281,246,175,57,-103,-265,-364,-365,-300,-236,-222,-257,-312,-360,-391,-401,-394,-379,-364,-350,-330,-301,-273,-260,-270,-296,-319,-317,-279,-212,-137,-79,-45,-25,1,44,100,156,189,188,155,107,63,28,-3,-34,-61,-85,-113,-155,-205,-245,-258,-248,-232,-229,-245,-273,-297,-303,-283,-243,-197,-159,-129,-105,-81,-61,-47,-43,-55,-82,-119,-147,-150,-124,-81,-44,-28,-32,-44,-49,-44,-36,-34,-45,-63,-84,-99,-105,-103,-98,-99,-108,-121,-129,-131,-133,-139,-149,-156,-153,-141,-126,-112,-99,-86,-69,-52,-40,-40,-51,-67,-82,-92,-95,-88,-68,-45,-32,-35,-44,-49,-55,-78,-116,-146,-149,-135,-129,-135,-129,-89,-31},
            {-91,2,114,53,-132,-154,73,215,0,-271,-108,294,188,-278,647,4542,10078,13003,9900,1933,-5919,-9559,-9146,-7503,-6079,-3693,704,5394,7272,5707,3942,5970,12220,18732,20552,15830,7001,-1335,-5579,-5068,-1999,262,-576,-4310,-8683,-11382,-11819,-11095,-10396,-9724,-8324,-6068,-3938,-2976,-3020,-2886,-1778,-191,783,823,722,1360,2673,3801,4074,3587,2868,2311,2047,2105,2414,2708,2682,2324,1901,1554,1065,221,-683,-1003,-488,312,562,10,-801,-1176,-972,-616,-585,-1004,-1704,-2472,-3141,-3523,-3418,-2779,-1836,-1010,-669,-913,-1548,-2217,-2579,-2433,-1795,-892,-77,371,422,296,262,423,700,983,1237,1448,1527,1361,964,516,218,132,170,229,268,283,248,135,-35,-195,-300,-366,-444,-550,-655,-709,-683,-576,-410,-226,-83,-42,-122,-282,-443,-547,-598,-632,-650,-606,-462,-250,-47,94,179,237,267,244,174,94,37,-1,-43,-91,-122,-126,-113,-93,-64,-23,16,21,-27,-114,-208,-274,-295,-279,-246,-210,-176,-142,-114,-101,-103,-111,-125,-161,-234,-330,-411,-446,-424,-350,-235,-97,30,111,139,129,92,31,-51,-130,-174,-171,-133,-80,-24,30,71,91,86,57,5,-65,-137,-188,-206,-191,-155,-101,-33,41,105,142,136,85,-3,-108,-203,-273,-313,-322,-304,-264,-214,-169,-137,-121,-124,-149,-191,-237,-275,-297,-301,-283,-237,-163,-66,39,129,176,166,107,26,-50,-109,-151,-173,-173,-150,-112,-67,-26,-1,-4,-37,-84,-123,-147,-158,-153,-122,-69,-17,10,7}
        },
        {    // H10e040a.wav
            {-1,0,-1,-3,-3,-1,-1,-3,-3,-1,1,0,-2,-3,-1,0,1,1,1,-1,-3,1,5,2,-7,-8,4,11,0,-14,-5,18,18,-12,-30,-3,30,16,-20,-6,42,23,-8,301,1260,2553,3198,2392,477,-1154,-1350,-388,326,-210,-1499,-2082,-1085,914,2550,3016,2677,2507,3118,4321,5378,5542,4485,2492,390,-858,-771,261,1197,1074,-320,-2346,-3991,-4523,-3874,-2610,-1547,-1249,-1696,-2333,-2517,-2014,-1139,-440,-219,-346,-473,-352,16,487,908,1167,1196,1025,810,764,989,1377,1688,1738,1520,1182,915,829,905,1005,966,702,276,-148,-420,-499,-467,-461,-588,-875,-1254,-1598,-1794,-1800,-1657,-1451,-1262,-1131,-1066,-1054,-1071,-1094,-1093,-1037,-905,-703,-470,-259,-97,21,110,175,216,243,281,338,394,411,370,274,143,-1,-131,-216,-245,-238,-236,-268,-331,-401,-451,-472,-471,-462,-462,-473,-482,-468,-421,-359,-309,-291,-302,-316,-310,-270,-203,-126,-54,3,43,69,92,121,159,196,211,191,141,82,31,-8,-41,-70,-99,-131,-174,-221,-258,-267,-250,-229,-223,-239,-265,-283,-287,-274,-250,-217,-184,-154,-130,-110,-92,-77,-70,-75,-92,-113,-128,-127,-108,-79,-53,-38,-34,-32,-27,-15,0,10,9,-8,-37,-65,-83,-90,-96,-109,-128,-146,-159,-168,-173,-176,-175,-174,-173,-169,-158,-141,-121,-99,-78,-59,-46,-41,-44,-54,-65,-73,-70,-59,-50,-52,-61,-65,-60,-54,-58,-71,-87,-105,-126,-142,-134,-89,-30},
            {20,85,-9,-140,-62,154,152,-133,-252,75,334,-34,-225,1753,6628,11837,13002,8063,-428,-7614,-10675,-10346,-8489,-5486,-859,4290,7115,6100,3586,4087,9666,17363,21514,18642,10195,1040,-4337,-4601,-1718,879,599,-2807,-7363,-10532,-11228,-10452,-9950,-10281,-10367,-8962,-6270,-3808,-2724,-2647,-2380,-1429,-418,6,185,1010,2674,4278,4792,4126,3060,2351,2189,2424,2918,3466,3656,3108,1903,551,-485,-1086,-1273,-965,-168,703,1000,484,-359,-800,-619,-270,-326,-903,-1678,-2310,-2711,-2931,-2953,-2714,-2276,-1894,-1841,-2163,-2614,-2824,-2563,-1887,-1069,-399,-18,112,134,197,379,660,959,1213,1420,1592,1669,1535,1144,628,218,56,90,169,200,193,178,128,-9,-220,-420,-531,-559,-580,-656,-760,-800,-702,-484,-248,-100,-84,-165,-279,-374,-437,-481,-518,-539,-514,-420,-266,-94,54,170,265,339,368,332,246,146,64,2,-53,-111,-169,-206,-201,-151,-73,-6,22,-3,-75,-180,-286,-354,-362,-325,-287,-272,-265,-231,-162,-81,-22,-3,-33,-114,-229,-336,-391,-380,-318,-228,-121,-6,98,169,194,172,104,-2,-118,-205,-234,-208,-149,-80,-18,29,56,65,61,38,-15,-95,-176,-230,-244,-223,-176,-102,-5,96,170,192,156,68,-47,-159,-244,-296,-320,-318,-288,-233,-169,-120,-94,-90,-106,-144,-196,-247,-281,-297,-298,-280,-226,-131,-14,93,163,182,152,83,-3,-82,-140,-171,-177,-160,-125,-84,-48,-24,-17,-31,-64,-104,-135,-152,-162,-165,-143,-79,5,64,65,26}
        },
        {    // H10e045a.wav
            {0,0,0,-1,-2,-3,-2,1,2,0,-2,0,2,2,0,0,1,1,0,-1,1,1,-1,0,3,4,-2,-7,0,10,9,-4,-7,8,17,0,-23,-12,22,28,-4,-17,18,33,-6,104,699,1776,2692,2582,1259,-392,-1149,-670,148,142,-834,-1740,-1461,42,1737,2598,2521,2238,2509,3456,4561,5110,4642,3195,1329,-123,-531,79,991,1279,460,-1191,-2876,-3812,-3682,-2755,-1680,-1090,-1229,-1821,-2298,-2225,-1615,-857,-367,-268,-374,-413,-244,97,483,788,942,960,944,1030,1288,1655,1963,2052,1862,1464,1017,683,547,560,571,431,113,-272,-570,-702,-715,-730,-854,-1105,-1414,-1667,-1778,-1732,-1582,-1400,-1232,-1099,-1010,-974,-987,-1014,-1008,-932,-774,-557,-324,-125,13,97,156,212,269,324,379,434,473,470,415,318,199,74,-53,-169,-254,-300,-318,-337,-380,-447,-516,-563,-577,-568,-555,-547,-534,-497,-434,-367,-320,-301,-299,-291,-265,-216,-148,-70,5,64,97,110,115,122,138,158,167,154,117,66,13,-31,-62,-82,-98,-122,-157,-195,-225,-237,-237,-230,-223,-219,-223,-240,-264,-277,-268,-242,-213,-189,-170,-149,-126,-105,-92,-86,-86,-91,-96,-96,-84,-58,-26,-1,7,3,0,7,22,30,23,2,-25,-53,-81,-107,-124,-133,-140,-151,-163,-168,-166,-164,-170,-179,-185,-184,-176,-160,-136,-105,-73,-47,-29,-21,-24,-35,-47,-56,-62,-69,-75,-75,-68,-62,-58,-50,-37,-35,-58,-95,-111,-84,-30},
            {76,-86,-157,15,205,85,-212,-194,190,287,-188,4,2780,8150,12896,12831,6755,-2176,-9273,-12126,-11366,-8407,-3780,1861,6324,7124,4618,2829,5946,13716,20884,21656,14822,4646,-2906,-4710,-2037,1304,2012,-768,-5387,-9174,-10450,-9703,-8927,-9558,-10974,-11194,-9095,-5725,-3213,-2569,-2894,-2751,-1827,-901,-450,74,1400,3276,4629,4773,4077,3355,2987,2900,3099,3702,4385,4264,2733,306,-1680,-2273,-1652,-671,56,459,627,524,169,-169,-220,-83,-167,-710,-1496,-2112,-2390,-2481,-2570,-2656,-2677,-2708,-2908,-3259,-3456,-3148,-2286,-1214,-400,-89,-176,-356,-358,-78,427,991,1435,1649,1660,1583,1505,1403,1197,871,519,264,149,125,122,103,56,-29,-155,-296,-406,-469,-522,-621,-777,-927,-971,-854,-609,-341,-159,-110,-174,-292,-403,-461,-454,-404,-351,-314,-276,-211,-119,-15,100,240,390,489,482,381,256,164,102,28,-73,-176,-245,-261,-219,-131,-30,32,14,-77,-199,-311,-392,-435,-443,-429,-408,-376,-314,-212,-90,11,64,65,16,-76,-188,-278,-311,-289,-233,-154,-53,63,165,225,236,201,119,-7,-148,-251,-279,-244,-180,-114,-52,5,42,49,24,-23,-86,-161,-232,-278,-281,-242,-167,-65,51,157,221,221,154,40,-88,-195,-263,-295,-304,-291,-253,-189,-118,-67,-55,-75,-111,-155,-204,-251,-289,-310,-309,-277,-206,-95,33,136,182,168,112,42,-28,-92,-145,-178,-183,-157,-108,-58,-24,-16,-27,-46,-69,-97,-127,-155,-172,-170,-144,-91,-15,56,91,74,28}
        },
        {    // H10e050a.wav
            {0,0,1,0,-1,0,0,-1,-2,-1,0,-1,-2,-2,0,1,0,0,1,0,-2,-3,-1,2,1,-3,-2,1,0,-5,-4,6,12,4,-8,-6,8,10,-6,-16,0,18,8,-10,5,32,14,19,308,1066,2019,2450,1827,449,-681,-800,-162,234,-252,-1182,-1498,-651,848,1989,2260,2035,2067,2736,3774,4552,4552,3650,2166,722,-59,61,737,1240,965,-151,-1618,-2762,-3140,-2754,-1979,-1330,-1161,-1465,-1894,-2025,-1688,-1093,-628,-522,-679,-795,-628,-158,442,950,1235,1311,1310,1380,1573,1806,1920,1801,1460,1019,626,383,304,310,271,84,-245,-600,-838,-905,-871,-861,-959,-1151,-1355,-1487,-1516,-1462,-1373,-1276,-1175,-1064,-957,-884,-861,-862,-838,-754,-607,-424,-232,-54,88,183,232,257,285,334,400,460,484,451,363,243,121,15,-76,-160,-242,-321,-392,-454,-507,-552,-583,-596,-591,-572,-550,-533,-517,-489,-441,-379,-324,-286,-257,-221,-168,-108,-58,-22,8,37,63,76,73,67,68,79,89,88,73,50,22,-10,-45,-77,-100,-117,-135,-159,-186,-205,-212,-214,-220,-234,-249,-260,-267,-271,-270,-259,-239,-216,-195,-177,-156,-131,-104,-81,-64,-52,-47,-46,-43,-33,-18,-5,-1,-3,-5,-2,4,9,4,-13,-41,-74,-100,-113,-115,-116,-125,-138,-151,-158,-164,-171,-184,-198,-207,-207,-192,-165,-130,-95,-65,-44,-33,-30,-31,-36,-48,-65,-78,-77,-67,-60,-62,-63,-53,-38,-36,-50,-60,-49,-18},
            {-57,-105,26,160,40,-200,-143,201,220,-226,201,3343,8957,13596,13030,6218,-3433,-10955,-13655,-12006,-7667,-1921,3753,7037,6401,3595,3197,8368,16950,22564,20207,10849,547,-4776,-3747,390,3139,2079,-2107,-6823,-9601,-9735,-8588,-8272,-9622,-11327,-11250,-8707,-5243,-3027,-2716,-3160,-3049,-2317,-1680,-1269,-352,1533,3673,4828,4568,3651,3109,3340,4112,5021,5562,5040,3032,154,-2044,-2369,-1151,138,432,-25,-329,-104,258,342,241,202,98,-417,-1317,-2082,-2286,-2107,-2099,-2554,-3260,-3841,-4124,-4104,-3728,-2918,-1814,-822,-302,-269,-428,-486,-351,-59,364,904,1458,1845,1946,1815,1608,1424,1237,976,645,342,173,157,211,218,109,-102,-337,-508,-562,-519,-467,-520,-721,-988,-1152,-1094,-841,-540,-325,-236,-237,-290,-375,-450,-461,-390,-287,-221,-197,-163,-82,30,138,244,369,499,575,556,461,336,211,84,-47,-165,-249,-282,-252,-162,-49,19,-4,-109,-249,-375,-465,-511,-511,-486,-468,-464,-430,-323,-154,5,91,102,70,17,-55,-137,-199,-221,-213,-189,-138,-42,97,234,321,325,243,94,-76,-211,-275,-273,-240,-199,-154,-100,-47,-12,-2,-23,-78,-165,-261,-329,-342,-305,-233,-136,-17,108,205,242,211,127,16,-97,-191,-257,-293,-303,-284,-230,-150,-71,-25,-25,-64,-120,-177,-229,-274,-310,-330,-327,-283,-191,-64,62,145,166,134,75,10,-53,-111,-156,-178,-170,-137,-92,-51,-23,-15,-25,-45,-70,-99,-135,-173,-196,-188,-147,-85,-24,25,51,52,34,10}
        },
        {    // H10e055a.wav
            {1,1,1,1,2,2,1,0,0,1,1,1,1,1,0,-1,1,2,2,1,0,0,-1,-1,1,3,3,0,-2,0,2,0,-1,4,11,9,-2,-7,5,15,7,-13,-15,5,18,10,9,28,29,-1,85,525,1327,2046,2053,1171,-16,-637,-397,122,106,-577,-1216,-1029,19,1208,1831,1848,1800,2188,3020,3866,4236,3871,2858,1588,603,311,692,1256,1365,682,-593,-1892,-2661,-2671,-2093,-1364,-934,-1018,-1482,-1940,-2047,-1740,-1243,-834,-607,-445,-173,263,768,1187,1411,1421,1289,1137,1075,1133,1237,1268,1140,857,496,155,-93,-230,-299,-375,-504,-668,-797,-841,-824,-812,-861,-965,-1080,-1169,-1222,-1244,-1226,-1152,-1018,-860,-737,-695,-726,-768,-751,-642,-462,-261,-87,36,107,148,187,237,291,322,324,310,300,295,272,212,117,1,-124,-247,-353,-428,-467,-485,-499,-516,-530,-535,-530,-521,-511,-499,-481,-450,-400,-332,-260,-199,-155,-127,-109,-99,-90,-77,-54,-25,1,13,11,3,2,14,39,64,72,57,27,-4,-28,-47,-69,-94,-122,-148,-175,-200,-219,-225,-224,-227,-239,-256,-267,-265,-255,-243,-233,-220,-202,-180,-157,-131,-98,-60,-28,-16,-23,-37,-46,-43,-31,-17,-5,-2,-9,-23,-32,-30,-20,-15,-23,-43,-67,-85,-96,-106,-120,-139,-160,-176,-185,-185,-182,-178,-177,-179,-179,-166,-139,-105,-76,-57,-43,-32,-28,-35,-50,-60,-61,-56,-52,-51,-49,-49,-56,-67,-67,-46,-16},
            {-113,48,180,43,-211,-161,186,229,-203,194,3322,9096,14077,13720,6568,-3987,-12380,-15153,-12578,-6929,-432,4940,7205,5735,3061,3788,10202,18943,23126,18538,7755,-2085,-5457,-2518,2185,4106,1858,-2827,-7116,-9104,-8794,-7834,-8080,-9878,-11602,-11181,-8271,-4725,-2761,-2835,-3561,-3543,-2779,-2105,-1725,-891,937,3130,4443,4371,3639,3359,3978,5071,5848,5638,4156,1754,-538,-1603,-1177,-130,419,217,-82,81,467,487,79,-240,-158,-42,-435,-1299,-2051,-2307,-2339,-2700,-3558,-4542,-5132,-5032,-4231,-2930,-1526,-517,-203,-432,-727,-704,-347,119,540,936,1358,1741,1953,1947,1807,1642,1471,1229,870,459,143,29,91,190,188,44,-186,-413,-569,-633,-635,-654,-763,-955,-1128,-1161,-1030,-812,-607,-464,-390,-386,-436,-481,-448,-328,-203,-159,-196,-228,-176,-42,127,300,475,636,738,735,630,467,296,143,18,-80,-156,-216,-253,-244,-179,-91,-43,-82,-202,-350,-473,-542,-563,-556,-543,-528,-490,-401,-256,-85,58,138,148,102,18,-80,-161,-202,-202,-174,-127,-53,55,181,291,349,329,230,74,-94,-221,-280,-280,-253,-217,-173,-118,-65,-33,-36,-80,-160,-257,-342,-386,-377,-322,-235,-120,14,141,228,252,214,130,21,-90,-181,-242,-278,-293,-279,-223,-132,-43,5,-2,-46,-103,-163,-227,-292,-345,-370,-356,-294,-186,-50,75,152,166,126,59,-15,-81,-137,-176,-191,-172,-123,-60,-10,11,5,-17,-43,-73,-111,-154,-192,-213,-205,-163,-96,-26,23,40,32,15,3,-1}
        },
        {    // H10e060a.wav
            {0,0,0,0,0,0,1,1,0,-1,0,0,0,0,-1,-1,-1,-1,-1,0,1,0,-1,-1,-1,-1,-1,1,1,-1,-3,-1,2,2,0,2,8,9,0,-8,-2,13,12,-8,-23,-8,21,30,17,12,17,2,5,197,731,1460,1900,1616,711,-168,-423,-108,158,-115,-730,-1014,-548,404,1210,1524,1564,1790,2408,3214,3807,3890,3404,2519,1564,906,745,956,1147,936,228,-739,-1583,-2021,-2005,-1704,-1402,-1327,-1510,-1758,-1795,-1494,-967,-449,-90,130,305,468,573,587,550,541,598,694,780,825,819,745,587,350,72,-186,-377,-482,-517,-519,-519,-526,-532,-537,-562,-628,-732,-840,-910,-924,-897,-859,-826,-800,-772,-735,-697,-668,-652,-632,-581,-485,-356,-220,-101,-6,59,90,88,72,72,104,159,210,233,218,163,79,-19,-115,-200,-274,-342,-397,-429,-435,-423,-413,-417,-434,-455,-465,-459,-435,-397,-348,-297,-251,-216,-192,-175,-159,-149,-148,-152,-146,-118,-77,-46,-37,-44,-47,-35,-12,13,33,44,44,31,10,-14,-39,-70,-106,-141,-164,-175,-182,-191,-202,-211,-218,-227,-237,-243,-243,-237,-228,-217,-206,-193,-176,-153,-123,-93,-69,-52,-40,-31,-28,-31,-36,-39,-37,-35,-36,-36,-30,-17,-3,5,-1,-19,-45,-71,-92,-109,-124,-139,-151,-159,-162,-161,-156,-153,-160,-174,-186,-183,-163,-136,-109,-84,-61,-44,-40,-42,-42,-35,-32,-40,-51,-55,-56,-69,-91,-99,-74,-27},
            {-43,153,128,-139,-220,88,273,-92,5,2650,8394,14171,14917,8122,-3308,-13133,-16683,-13673,-6930,330,5672,7436,5580,2935,4001,10750,19499,23188,17773,6356,-3399,-5948,-2026,3159,4908,2248,-2612,-6759,-8544,-8193,-7323,-7651,-9502,-11339,-11129,-8430,-4971,-2956,-2943,-3648,-3697,-3049,-2502,-2231,-1458,368,2572,3864,3816,3333,3581,4692,5711,5638,4321,2433,855,141,288,771,908,445,-163,-209,444,1140,1137,426,-322,-585,-539,-695,-1220,-1832,-2321,-2894,-3867,-5122,-6055,-6063,-5032,-3384,-1756,-661,-290,-470,-784,-833,-489,77,620,1039,1377,1678,1900,1982,1938,1848,1751,1594,1287,828,343,10,-83,-11,64,30,-98,-235,-331,-410,-521,-678,-857,-1025,-1157,-1222,-1194,-1068,-885,-707,-586,-541,-546,-549,-497,-383,-253,-175,-175,-217,-226,-146,28,260,498,697,831,886,855,735,542,320,129,-2,-88,-164,-242,-292,-281,-215,-142,-111,-144,-227,-336,-448,-545,-611,-636,-616,-561,-474,-355,-201,-27,125,206,194,104,-20,-133,-208,-234,-210,-149,-65,31,136,245,337,375,332,211,49,-103,-210,-264,-280,-271,-244,-194,-126,-59,-19,-29,-91,-193,-308,-401,-441,-419,-346,-243,-124,7,137,237,278,247,160,47,-64,-158,-231,-283,-304,-279,-204,-98,-5,39,24,-29,-95,-164,-237,-308,-362,-382,-358,-288,-177,-45,73,144,152,111,48,-19,-83,-144,-191,-206,-179,-116,-43,15,43,43,22,-12,-57,-109,-163,-211,-241,-235,-186,-104,-23,30,46,40,30,22,14,4}
        },
        {    // H10e065a.wav
            {0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,-1,-2,-2,-2,-1,-1,0,0,-1,-2,-2,-1,0,0,-1,-2,-2,0,0,0,0,1,4,6,5,0,-4,1,9,7,-7,-18,-5,23,36,21,1,0,-1,-14,44,336,905,1501,1688,1244,438,-160,-218,42,110,-239,-700,-770,-283,452,1014,1296,1552,2071,2854,3605,3955,3709,2950,1991,1224,921,1062,1339,1351,867,-44,-1072,-1858,-2161,-1955,-1428,-894,-606,-610,-733,-763,-631,-448,-359,-391,-447,-422,-295,-124,28,133,184,187,160,142,156,181,169,89,-49,-203,-337,-423,-441,-383,-280,-204,-220,-331,-473,-563,-564,-504,-445,-431,-469,-535,-601,-646,-656,-630,-589,-565,-572,-585,-559,-472,-350,-247,-194,-182,-179,-165,-138,-103,-56,-3,42,63,61,49,35,11,-34,-98,-165,-219,-256,-282,-301,-311,-311,-308,-317,-343,-371,-382,-362,-325,-294,-281,-279,-272,-256,-242,-234,-228,-217,-200,-184,-171,-152,-124,-96,-80,-79,-80,-70,-47,-21,-2,11,22,27,16,-12,-49,-82,-105,-120,-134,-149,-159,-165,-175,-192,-210,-220,-220,-215,-211,-210,-206,-197,-186,-178,-171,-161,-143,-118,-89,-63,-43,-31,-30,-37,-45,-47,-41,-30,-22,-19,-18,-17,-17,-22,-32,-43,-54,-69,-89,-107,-116,-120,-126,-138,-150,-154,-151,-151,-158,-164,-163,-156,-145,-130,-110,-89,-74,-65,-54,-39,-32,-39,-55,-67,-76,-93,-114,-116,-83,-29},
            {83,131,-63,-223,-9,284,52,-210,1538,6731,13336,16121,10993,-668,-12483,-18112,-15765,-8252,131,6094,7952,5982,3081,3681,9985,18734,22940,18079,6715,-3489,-6474,-2499,3244,5715,3559,-1228,-5750,-8151,-8254,-7324,-7122,-8464,-10344,-10780,-8842,-5715,-3515,-3174,-3795,-4017,-3534,-2966,-2581,-1797,-102,1984,3342,3560,3382,3717,4504,4851,4180,2894,1845,1434,1405,1366,1200,990,815,757,934,1299,1490,1130,320,-346,-423,-152,-204,-933,-2061,-3139,-4098,-5142,-6207,-6754,-6244,-4733,-2883,-1440,-727,-602,-726,-806,-670,-269,316,926,1421,1757,1955,2033,2003,1907,1829,1809,1766,1546,1075,466,-48,-297,-294,-188,-114,-104,-129,-188,-314,-514,-736,-910,-1028,-1135,-1257,-1342,-1310,-1138,-902,-715,-627,-605,-579,-517,-428,-341,-271,-224,-195,-161,-70,112,365,620,815,937,991,963,827,603,368,195,84,-25,-169,-317,-400,-385,-294,-179,-92,-74,-144,-290,-461,-599,-667,-668,-623,-552,-457,-333,-175,0,152,232,215,117,-22,-155,-242,-263,-221,-144,-58,31,134,251,351,392,352,243,91,-74,-214,-296,-309,-279,-237,-195,-138,-66,-9,-6,-73,-186,-307,-403,-454,-452,-397,-298,-169,-22,124,242,298,277,193,75,-43,-146,-227,-282,-303,-276,-197,-86,16,67,54,-8,-92,-177,-256,-321,-365,-376,-348,-277,-168,-43,62,120,124,89,36,-25,-87,-146,-193,-213,-195,-136,-55,21,64,68,47,17,-19,-70,-138,-210,-258,-260,-210,-125,-34,34,64,62,44,23,9,3,1}
        },
        {    // H10e070a.wav
            {0,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,0,0,-1,-2,-2,-1,0,-1,-3,-3,0,1,0,-3,-1,3,5,2,-2,-1,3,6,5,0,-5,-5,4,17,22,11,-7,-10,-2,0,12,131,471,996,1439,1469,997,324,-100,-88,110,90,-270,-667,-685,-199,539,1183,1616,1981,2447,2995,3433,3559,3307,2762,2091,1477,1054,853,774,645,334,-140,-604,-838,-731,-369,-3,103,-171,-727,-1310,-1664,-1668,-1386,-1012,-745,-680,-773,-887,-903,-785,-587,-386,-226,-113,-39,2,21,39,60,59,3,-102,-200,-227,-178,-105,-66,-72,-94,-104,-106,-125,-173,-237,-300,-350,-392,-432,-477,-528,-579,-622,-647,-645,-618,-573,-520,-471,-430,-398,-371,-344,-315,-277,-226,-162,-94,-36,7,36,53,51,27,-14,-57,-89,-113,-138,-171,-204,-226,-237,-242,-250,-262,-273,-279,-284,-292,-305,-317,-326,-327,-321,-305,-278,-245,-217,-202,-199,-193,-174,-147,-125,-115,-110,-97,-74,-47,-23,-2,16,24,17,-5,-35,-64,-88,-107,-121,-132,-143,-156,-170,-183,-190,-191,-185,-177,-173,-175,-182,-188,-187,-182,-176,-167,-151,-127,-102,-80,-62,-44,-27,-18,-19,-28,-36,-42,-46,-48,-47,-43,-37,-32,-30,-34,-45,-59,-73,-86,-101,-117,-131,-138,-139,-138,-139,-141,-142,-144,-145,-142,-133,-121,-112,-105,-99,-92,-89,-91,-92,-86,-82,-92,-109,-108,-76,-26},
            {178,-3,-256,-146,266,269,-261,313,4213,11051,16344,14545,4367,-9163,-18375,-18798,-11677,-1831,5937,8913,7127,3530,2822,7980,16764,22443,19448,8812,-2348,-7032,-4004,2268,6272,5589,1358,-3746,-7428,-8665,-7960,-6985,-7291,-8842,-9987,-9189,-6704,-4297,-3365,-3701,-4164,-4124,-3820,-3468,-2642,-862,1487,3316,3959,3814,3682,3726,3433,2553,1649,1478,2020,2473,2210,1458,926,969,1359,1735,1962,1998,1694,999,232,-136,-46,-3,-568,-1813,-3368,-4892,-6239,-7192,-7318,-6316,-4484,-2637,-1493,-1162,-1240,-1269,-1047,-596,-10,610,1160,1568,1837,2006,2094,2089,2011,1932,1900,1866,1709,1342,802,228,-221,-454,-471,-343,-172,-58,-72,-227,-467,-700,-863,-968,-1081,-1241,-1405,-1477,-1396,-1191,-957,-776,-666,-594,-532,-481,-448,-416,-353,-243,-99,57,218,396,596,800,978,1090,1093,956,703,419,200,83,16,-77,-222,-368,-437,-391,-255,-104,-22,-58,-207,-410,-593,-702,-716,-648,-537,-424,-319,-199,-40,132,248,252,153,5,-134,-236,-282,-260,-180,-80,7,87,184,295,374,373,284,143,-11,-153,-262,-319,-316,-271,-208,-136,-62,1,17,-36,-151,-287,-398,-454,-452,-406,-330,-223,-82,81,225,304,296,217,101,-21,-132,-217,-268,-284,-264,-205,-112,-9,61,68,15,-67,-149,-223,-290,-346,-376,-365,-306,-202,-74,42,112,123,86,27,-35,-94,-152,-203,-230,-217,-161,-78,4,62,86,78,48,4,-47,-105,-170,-230,-257,-226,-143,-44,29,62,69,62,41,7,-23,-29,-12}
        },
        {    // H10e075a.wav
            {1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,2,2,1,0,-1,-2,0,2,3,1,-1,0,4,5,1,-3,0,8,14,11,2,-3,0,6,10,11,7,0,-5,2,12,21,60,224,579,1040,1350,1261,792,261,22,129,299,216,-131,-442,-422,-48,475,984,1510,2170,2933,3553,3739,3378,2619,1772,1148,921,1086,1481,1864,2022,1853,1385,732,39,-565,-1001,-1265,-1420,-1552,-1705,-1850,-1926,-1902,-1816,-1734,-1690,-1656,-1568,-1384,-1117,-820,-546,-321,-139,10,133,228,291,317,293,214,99,-1,-21,65,220,358,401,328,183,38,-56,-91,-96,-103,-135,-203,-309,-449,-601,-735,-821,-848,-827,-779,-727,-686,-660,-646,-629,-594,-535,-455,-362,-259,-154,-55,24,75,103,117,123,118,102,77,48,15,-27,-78,-125,-154,-161,-160,-169,-197,-240,-287,-328,-358,-375,-381,-377,-362,-340,-312,-286,-270,-264,-263,-254,-231,-198,-165,-139,-120,-104,-88,-70,-49,-25,-1,19,25,17,-4,-31,-60,-85,-104,-118,-126,-129,-129,-129,-129,-133,-140,-149,-159,-165,-165,-164,-164,-167,-168,-167,-163,-156,-142,-117,-86,-56,-35,-25,-22,-24,-33,-46,-56,-54,-44,-34,-29,-30,-30,-28,-27,-30,-41,-58,-76,-92,-103,-113,-124,-130,-131,-127,-126,-128,-129,-125,-125,-133,-148,-156,-154,-147,-141,-131,-111,-89,-82,-90,-91,-66,-24},
            {192,-157,-341,24,431,79,-399,1413,7110,14293,17082,11030,-2171,-15268,-20957,-17013,-6863,3618,9615,9420,5183,2033,4669,12985,21015,21570,12891,633,-7056,-6402,-199,5778,7600,4930,-257,-5453,-8630,-9008,-7596,-6542,-7201,-8800,-9342,-7848,-5351,-3637,-3400,-3947,-4385,-4512,-4437,-3862,-2275,208,2646,4101,4448,4165,3546,2508,1216,445,893,2218,3160,2816,1612,786,1019,1849,2400,2360,2046,1760,1467,1109,866,856,747,-31,-1651,-3666,-5452,-6689,-7315,-7207,-6235,-4627,-3051,-2118,-1868,-1848,-1645,-1221,-734,-228,373,1050,1622,1928,1999,1997,2033,2087,2100,2061,1988,1861,1606,1174,610,54,-333,-465,-375,-189,-58,-76,-245,-479,-667,-754,-796,-910,-1154,-1451,-1641,-1621,-1423,-1170,-956,-796,-666,-566,-521,-529,-542,-495,-363,-173,30,225,416,607,790,947,1061,1103,1033,833,554,294,126,43,-26,-132,-258,-345,-351,-272,-147,-37,-15,-123,-335,-557,-695,-713,-645,-545,-447,-352,-240,-99,62,203,271,233,103,-66,-217,-306,-313,-246,-141,-39,44,122,212,299,343,315,214,67,-92,-226,-301,-309,-274,-220,-155,-74,9,48,6,-106,-242,-355,-427,-454,-435,-366,-254,-117,30,168,270,304,256,144,10,-107,-191,-245,-279,-284,-246,-159,-46,49,87,62,-7,-96,-187,-265,-321,-352,-359,-338,-271,-154,-17,89,126,101,45,-19,-86,-156,-217,-250,-241,-192,-113,-23,51,90,93,71,38,-1,-52,-116,-185,-234,-234,-172,-72,22,73,85,76,57,21,-27,-60,-54,-20}
        },
        {    // H10e080a.wav
            {1,1,1,1,1,1,0,-1,-1,-1,0,0,0,0,0,0,1,2,2,2,1,0,0,0,0,0,0,0,-1,-1,0,2,1,-1,-4,-4,-1,3,4,1,-2,-1,4,6,1,-4,-1,11,20,15,-1,-9,-2,9,8,-4,-10,0,18,34,41,36,29,69,244,599,1023,1278,1201,894,663,691,804,622,-12,-785,-1147,-805,44,939,1571,1963,2285,2605,2834,2880,2778,2674,2701,2886,3137,3287,3168,2687,1877,886,-92,-893,-1427,-1686,-1755,-1795,-1967,-2314,-2716,-2962,-2918,-2628,-2269,-1999,-1844,-1711,-1498,-1173,-790,-424,-125,98,254,359,423,459,476,475,455,423,401,418,480,556,585,518,367,195,75,36,47,52,8,-98,-254,-441,-634,-803,-928,-998,-1022,-1013,-986,-951,-916,-879,-828,-750,-642,-515,-385,-263,-152,-53,29,90,131,161,189,213,224,213,184,143,96,46,-8,-60,-103,-137,-169,-208,-259,-315,-364,-394,-403,-394,-379,-367,-366,-372,-377,-371,-348,-314,-275,-239,-206,-175,-148,-127,-112,-100,-85,-67,-49,-36,-25,-14,-6,-11,-32,-61,-83,-89,-81,-70,-65,-68,-78,-93,-111,-132,-149,-155,-151,-140,-134,-137,-147,-159,-170,-179,-184,-176,-154,-123,-95,-74,-58,-43,-29,-22,-23,-30,-36,-39,-38,-40,-44,-46,-42,-32,-24,-24,-34,-49,-67,-87,-108,-125,-132,-131,-132,-136,-141,-142,-142,-151,-165,-176,-177,-174,-170,-164,-149,-132,-123,-121,-108,-71,-24},
            {156,-260,-334,175,467,-130,-344,2550,9311,16088,16535,7579,-6955,-18820,-21558,-14665,-2890,7369,11519,8942,3562,1662,6953,16531,22445,18647,6866,-4733,-8790,-4523,3041,8219,8493,4560,-1390,-6820,-9570,-9040,-6903,-5827,-6938,-8785,-9068,-7162,-4570,-3116,-3225,-4069,-4812,-5183,-5011,-3882,-1603,1231,3521,4539,4355,3433,2136,810,74,515,1934,3195,3192,2005,850,800,1727,2618,2757,2318,1861,1606,1428,1307,1393,1552,1173,-309,-2750,-5309,-7107,-7751,-7308,-6058,-4453,-3103,-2482,-2531,-2692,-2442,-1758,-988,-392,90,609,1149,1555,1765,1874,1994,2122,2190,2170,2099,1999,1834,1536,1078,518,-6,-330,-360,-160,64,103,-110,-452,-722,-812,-779,-787,-960,-1277,-1594,-1755,-1699,-1472,-1177,-905,-709,-604,-579,-606,-638,-624,-530,-351,-125,104,317,523,731,919,1044,1078,1016,871,665,442,258,143,73,-10,-132,-257,-319,-280,-163,-32,34,-26,-215,-466,-670,-747,-697,-579,-459,-365,-284,-185,-48,111,234,264,183,27,-143,-278,-345,-331,-243,-125,-23,50,124,221,313,341,274,132,-36,-186,-289,-326,-298,-229,-149,-73,-4,45,41,-36,-165,-298,-392,-436,-438,-402,-327,-211,-61,100,235,306,292,203,71,-65,-178,-255,-295,-304,-281,-219,-112,13,105,121,58,-48,-154,-240,-303,-344,-361,-350,-306,-223,-108,6,82,96,58,-5,-74,-141,-203,-252,-273,-250,-181,-80,20,86,109,101,73,31,-26,-92,-154,-204,-226,-201,-119,-12,70,93,77,56,36,-5,-67,-111,-95,-36}
        },
        {    // H10e085a.wav
            {1,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,1,1,1,1,2,1,-1,-1,0,0,-1,-2,-2,-1,-1,-1,-1,-1,-2,-3,-3,-1,2,3,2,-1,-2,1,3,2,-2,0,13,26,24,2,-21,-25,-9,5,9,15,35,51,42,11,-18,-29,-14,90,402,961,1581,1912,1738,1213,722,491,370,50,-528,-1071,-1233,-953,-425,203,998,2078,3348,4475,5128,5201,4815,4174,3453,2778,2232,1819,1466,1072,574,-51,-798,-1628,-2428,-3025,-3298,-3276,-3117,-2983,-2913,-2839,-2687,-2452,-2177,-1888,-1570,-1208,-825,-475,-188,46,254,440,583,673,723,754,775,778,757,721,678,633,584,528,459,367,251,134,46,-4,-41,-105,-223,-391,-594,-812,-1019,-1179,-1265,-1274,-1227,-1147,-1047,-942,-842,-750,-649,-522,-376,-239,-133,-54,19,94,161,209,240,266,290,300,285,247,195,136,67,-15,-102,-177,-230,-265,-295,-326,-354,-372,-379,-385,-397,-414,-426,-431,-425,-406,-369,-316,-261,-218,-193,-176,-158,-137,-120,-109,-100,-91,-82,-79,-80,-79,-70,-57,-43,-34,-26,-16,-6,-5,-18,-44,-72,-95,-112,-124,-132,-133,-128,-122,-121,-127,-137,-149,-164,-180,-191,-192,-181,-160,-134,-105,-76,-50,-29,-13,-5,-7,-19,-35,-48,-56,-60,-60,-54,-42,-30,-24,-27,-41,-64,-90,-113,-125,-132,-139,-151,-161,-165,-165,-168,-170,-166,-160,-162,-176,-187,-182,-168,-162,-163,-148,-98,-33},
            {136,-304,-322,246,472,-235,-301,3103,10300,16765,16005,5669,-9385,-20469,-21584,-13120,-553,9437,12465,8641,2836,1719,8214,17952,22275,16106,3050,-7700,-9486,-3130,5302,10198,9633,4740,-2040,-7845,-10265,-8902,-6060,-4909,-6482,-8811,-9213,-7095,-4237,-2680,-2919,-4092,-5232,-5828,-5502,-3859,-987,2172,4308,4692,3582,1821,264,-436,91,1644,3271,3775,2771,1182,445,1124,2415,3086,2731,1954,1485,1448,1561,1693,1883,1865,998,-1099,-3939,-6404,-7585,-7342,-6147,-4644,-3392,-2758,-2754,-2966,-2853,-2245,-1463,-902,-578,-190,430,1094,1504,1621,1664,1818,2044,2192,2210,2166,2100,1937,1567,991,364,-88,-222,-63,198,327,183,-186,-584,-815,-832,-766,-811,-1060,-1432,-1739,-1836,-1701,-1416,-1091,-816,-643,-589,-629,-700,-730,-670,-520,-319,-114,84,299,550,805,993,1062,1023,913,759,573,389,260,202,157,56,-101,-236,-274,-203,-73,42,72,-31,-261,-530,-715,-744,-649,-515,-405,-321,-237,-128,9,148,237,228,114,-59,-222,-328,-355,-306,-205,-98,-21,34,110,227,335,358,260,79,-113,-260,-334,-332,-270,-181,-95,-19,45,82,60,-35,-173,-305,-399,-444,-441,-389,-288,-154,-2,148,269,322,281,160,7,-127,-218,-271,-294,-288,-245,-162,-50,58,122,113,36,-77,-186,-266,-315,-340,-349,-338,-290,-197,-74,36,90,81,28,-41,-113,-182,-238,-270,-269,-229,-148,-39,66,131,143,116,71,16,-48,-116,-171,-203,-200,-155,-67,31,95,101,72,41,15,-28,-87,-122,-100,-36}
        },
        {    // H10e090a.wav
            {1,2,2,2,1,1,0,0,1,2,2,0,-1,-1,0,1,2,2,2,1,1,2,4,4,2,1,1,3,2,0,-2,-1,1,1,1,1,1,1,0,1,4,5,3,1,1,3,4,3,4,8,15,23,24,11,-13,-31,-20,17,49,50,29,14,9,-5,-18,25,176,409,642,832,1017,1230,1429,1538,1549,1490,1276,662,-501,-1957,-3050,-3139,-2048,-123,2078,4101,5631,6411,6285,5368,4079,2928,2222,1962,1958,1986,1869,1477,769,-179,-1204,-2144,-2901,-3415,-3637,-3551,-3243,-2902,-2703,-2682,-2711,-2619,-2335,-1925,-1503,-1132,-810,-516,-249,-2,252,530,792,959,989,930,873,864,875,857,803,739,674,590,467,319,177,66,-8,-48,-66,-96,-193,-392,-673,-965,-1191,-1314,-1340,-1299,-1221,-1125,-1020,-910,-804,-702,-599,-484,-354,-223,-110,-24,46,111,173,223,261,293,323,340,329,283,213,134,51,-37,-125,-200,-250,-278,-297,-318,-342,-365,-384,-399,-412,-422,-425,-416,-394,-361,-322,-283,-248,-218,-193,-174,-158,-142,-126,-119,-125,-140,-150,-142,-119,-91,-65,-40,-13,13,30,35,29,16,-5,-34,-67,-94,-109,-112,-112,-114,-120,-121,-116,-110,-110,-121,-139,-157,-171,-181,-184,-173,-143,-102,-66,-42,-26,-13,-5,-6,-16,-29,-40,-49,-57,-61,-59,-54,-54,-57,-61,-64,-70,-80,-92,-106,-123,-143,-162,-174,-179,-179,-174,-164,-151,-148,-156,-167,-170,-171,-182,-193,-176,-116,-39},
            {152,-305,-349,231,505,-207,-402,2830,9994,16634,16089,5772,-9477,-20720,-21722,-12913,-39,10014,12898,8890,2957,1731,8053,17521,21494,14970,1704,-8914,-10117,-2854,6463,11837,11147,5621,-1954,-8307,-10755,-8933,-5477,-3977,-5698,-8555,-9489,-7562,-4491,-2570,-2637,-3973,-5458,-6300,-5944,-4015,-740,2742,4880,4758,2741,204,-1355,-1141,588,2729,3983,3677,2258,966,823,1772,2814,3019,2366,1578,1260,1399,1665,1907,2094,1885,651,-1836,-4843,-7041,-7519,-6430,-4715,-3334,-2740,-2833,-3163,-3213,-2721,-1879,-1159,-851,-781,-548,15,693,1184,1424,1565,1726,1881,1982,2064,2181,2260,2122,1648,934,249,-130,-96,218,519,543,232,-237,-611,-754,-735,-732,-876,-1176,-1533,-1815,-1906,-1753,-1401,-991,-684,-566,-611,-720,-801,-801,-703,-522,-309,-119,40,224,481,770,983,1042,969,837,687,525,375,285,262,235,123,-61,-213,-238,-138,5,99,81,-71,-314,-555,-690,-683,-585,-472,-382,-308,-228,-125,5,138,218,189,49,-139,-296,-377,-374,-297,-177,-66,-7,22,83,205,325,350,244,57,-132,-274,-350,-350,-278,-169,-69,3,57,91,79,-6,-147,-293,-402,-458,-456,-397,-283,-133,24,164,262,291,240,123,-16,-136,-216,-257,-267,-253,-215,-147,-49,52,111,95,9,-105,-205,-274,-321,-352,-362,-340,-278,-179,-63,35,85,73,12,-73,-159,-227,-268,-279,-260,-207,-119,-12,80,125,123,100,69,26,-40,-115,-177,-210,-209,-166,-79,25,93,98,62,26,2,-37,-94,-131,-108,-40}
        },
        {    // H10e095a.wav
            {1,1,1,1,0,0,0,0,0,0,0,0,0,-1,-2,-1,0,1,1,0,0,0,1,2,1,0,0,1,2,1,-1,-3,-2,0,0,-1,-3,-1,2,2,-1,-3,-1,2,4,1,-1,1,7,10,7,2,3,10,15,10,0,-3,8,23,27,14,0,25,139,362,631,790,692,359,49,86,594,1363,2013,2258,2007,1244,-32,-1641,-3023,-3385,-2237,140,2791,4713,5459,5238,4564,3855,3299,2916,2646,2409,2155,1896,1653,1359,861,75,-876,-1720,-2267,-2549,-2740,-2943,-3106,-3130,-3000,-2797,-2600,-2415,-2211,-1977,-1732,-1487,-1223,-915,-567,-206,138,440,675,821,878,879,871,884,912,928,910,852,759,636,490,338,198,84,1,-55,-92,-134,-213,-363,-584,-833,-1044,-1168,-1198,-1167,-1113,-1060,-1010,-950,-867,-758,-634,-511,-402,-303,-205,-106,-17,53,105,150,198,245,279,292,283,252,200,132,59,-8,-64,-117,-176,-238,-292,-328,-344,-352,-362,-375,-386,-387,-377,-358,-336,-317,-304,-295,-281,-256,-222,-191,-174,-172,-180,-189,-194,-188,-168,-137,-104,-77,-59,-46,-35,-23,-6,13,27,28,11,-17,-46,-72,-93,-111,-122,-125,-120,-112,-102,-90,-81,-81,-97,-122,-146,-159,-160,-152,-139,-122,-104,-84,-67,-55,-48,-42,-33,-22,-20,-36,-62,-84,-93,-94,-95,-94,-86,-73,-64,-67,-80,-97,-118,-142,-167,-185,-191,-188,-177,-162,-151,-151,-162,-170,-169,-163,-165,-169,-151,-99,-33},
            {201,-251,-399,125,542,-38,-569,1826,8404,15594,16679,7894,-7128,-19536,-22100,-14240,-1410,9240,13008,9749,3858,1675,6622,15496,20292,15269,2753,-8476,-10833,-3966,6154,12845,13024,7515,-692,-7906,-11051,-9422,-5523,-3259,-4544,-7724,-9515,-8294,-5291,-2921,-2523,-3741,-5420,-6524,-6326,-4410,-1010,2700,5014,4787,2340,-641,-2225,-1530,779,3094,4058,3429,2057,1125,1273,2209,3046,3070,2300,1385,967,1164,1650,2068,2192,1734,293,-2211,-5076,-7049,-7239,-5841,-3941,-2634,-2314,-2644,-3014,-2985,-2494,-1802,-1256,-1003,-886,-635,-166,359,752,1009,1247,1512,1732,1858,1958,2113,2251,2169,1725,1009,316,-52,14,357,660,660,330,-127,-465,-597,-627,-707,-912,-1213,-1539,-1809,-1920,-1788,-1425,-981,-653,-546,-616,-740,-825,-829,-739,-562,-344,-152,-2,160,394,672,890,970,928,824,687,521,367,290,298,302,203,13,-153,-191,-103,32,121,103,-46,-291,-529,-654,-635,-534,-436,-366,-305,-231,-142,-37,79,168,163,37,-158,-329,-411,-396,-309,-185,-70,0,36,90,193,300,330,242,75,-101,-242,-324,-333,-269,-163,-64,5,54,88,83,13,-113,-253,-369,-443,-463,-417,-306,-158,-4,133,239,289,258,150,10,-113,-192,-231,-246,-238,-205,-141,-52,39,95,85,8,-105,-211,-287,-332,-353,-353,-326,-265,-169,-58,35,79,64,6,-72,-150,-217,-263,-280,-265,-216,-132,-26,72,132,145,125,86,33,-37,-113,-178,-220,-231,-196,-110,3,90,112,84,42,4,-44,-103,-134,-106,-38}
        },
        {    // H10e100a.wav
            {1,1,1,1,0,0,0,0,0,0,0,0,0,0,-1,-1,0,0,1,1,0,0,0,0,1,0,0,1,2,1,0,-1,0,0,-1,-3,-2,2,4,4,1,-2,-3,-2,1,3,4,5,8,11,9,-1,-8,-2,16,32,32,20,5,-7,-15,11,128,368,673,887,856,555,140,-134,-90,249,683,1008,1152,1163,1067,783,236,-433,-823,-537,470,1791,2846,3293,3203,2892,2637,2531,2533,2568,2557,2419,2096,1610,1068,585,201,-131,-481,-872,-1268,-1611,-1877,-2086,-2277,-2471,-2633,-2688,-2573,-2301,-1979,-1730,-1604,-1534,-1400,-1136,-776,-410,-98,151,348,493,588,656,732,825,902,917,860,758,649,554,475,398,302,170,12,-135,-233,-282,-327,-413,-540,-669,-769,-840,-896,-938,-949,-926,-883,-839,-793,-726,-631,-521,-420,-338,-265,-189,-108,-33,28,76,114,143,159,162,156,145,125,94,51,2,-50,-100,-150,-196,-231,-258,-283,-312,-339,-351,-340,-317,-297,-288,-285,-277,-265,-255,-251,-248,-241,-234,-233,-238,-239,-225,-193,-152,-114,-87,-73,-68,-70,-72,-71,-65,-53,-36,-19,-8,-8,-19,-40,-65,-90,-108,-117,-113,-101,-87,-73,-60,-53,-56,-70,-88,-100,-103,-102,-103,-106,-109,-112,-114,-113,-106,-94,-77,-62,-55,-57,-67,-78,-86,-90,-92,-93,-88,-80,-75,-79,-90,-101,-114,-134,-158,-175,-176,-167,-162,-167,-171,-169,-163,-161,-158,-144,-123,-111,-111,-105,-74,-26},
            {235,-127,-403,-62,486,226,-570,542,5762,13258,16914,11350,-2334,-16333,-22116,-16868,-4757,6928,12598,11033,5538,1924,4504,12151,18288,16270,5813,-6069,-10995,-6200,3978,12493,14756,10409,2122,-6179,-10868,-10404,-6535,-3193,-3275,-6233,-8962,-8976,-6519,-3800,-2706,-3487,-5151,-6483,-6585,-4981,-1809,1918,4553,4762,2564,-484,-2305,-1790,463,2776,3768,3276,2166,1447,1557,2247,2917,3045,2506,1644,1009,938,1344,1860,2087,1666,293,-2049,-4759,-6723,-7039,-5756,-3862,-2482,-2076,-2323,-2619,-2591,-2237,-1765,-1378,-1143,-970,-714,-325,111,473,740,973,1214,1436,1619,1800,2012,2179,2131,1756,1122,472,77,68,351,658,726,478,70,-275,-455,-546,-676,-896,-1173,-1461,-1719,-1870,-1810,-1503,-1069,-720,-591,-647,-753,-812,-805,-737,-600,-405,-205,-45,100,295,548,777,893,888,813,698,541,371,266,270,316,281,125,-58,-148,-106,4,99,114,15,-192,-436,-607,-641,-564,-460,-380,-320,-258,-187,-100,5,102,130,43,-134,-317,-424,-429,-350,-226,-105,-22,25,81,177,284,330,269,124,-44,-191,-289,-314,-260,-160,-66,-7,31,63,69,16,-97,-233,-352,-437,-477,-452,-352,-201,-39,103,213,278,272,185,48,-83,-172,-216,-234,-233,-208,-149,-64,23,78,72,6,-96,-198,-278,-330,-355,-355,-330,-276,-191,-83,22,84,82,26,-58,-143,-221,-283,-317,-306,-246,-147,-33,70,138,161,140,84,6,-78,-150,-204,-236,-239,-198,-111,-4,74,94,68,29,-9,-54,-102,-122,-92,-32}
        },
        {    // H10e105a.wav
            {1,0,0,1,2,2,1,-1,0,0,0,0,-1,0,1,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,0,-2,-2,-1,2,3,1,-1,-2,-1,1,2,1,-1,-1,1,1,-2,-1,5,12,10,1,-6,-2,7,11,14,24,32,20,4,66,295,673,1016,1085,781,259,-169,-261,-11,378,666,718,545,244,-44,-154,71,693,1578,2412,2864,2794,2343,1821,1490,1419,1508,1618,1674,1671,1620,1509,1321,1064,772,483,213,-37,-254,-413,-504,-567,-684,-913,-1227,-1523,-1703,-1753,-1745,-1763,-1820,-1852,-1779,-1582,-1320,-1078,-903,-780,-655,-497,-311,-120,64,244,417,556,640,667,655,620,565,494,427,380,339,270,148,-12,-174,-306,-397,-449,-466,-461,-462,-493,-554,-620,-665,-686,-693,-693,-675,-629,-564,-502,-459,-427,-385,-321,-244,-176,-127,-91,-57,-28,-12,-8,-5,9,27,29,3,-41,-79,-100,-109,-118,-133,-154,-179,-209,-241,-266,-277,-275,-269,-264,-259,-245,-223,-204,-203,-224,-255,-279,-285,-273,-244,-203,-156,-116,-96,-93,-96,-94,-89,-90,-101,-112,-112,-100,-87,-83,-86,-85,-79,-76,-84,-97,-100,-85,-64,-52,-54,-60,-56,-46,-39,-41,-46,-48,-51,-60,-76,-90,-98,-103,-114,-130,-147,-155,-152,-140,-124,-106,-89,-75,-67,-67,-74,-79,-81,-82,-91,-111,-134,-150,-156,-162,-171,-178,-177,-170,-168,-171,-169,-156,-139,-125,-116,-105,-93,-89,-92,-87,-60,-21},
            {195,68,-263,-262,232,440,-220,-402,2570,9231,15423,14759,4727,-9830,-19979,-19733,-10210,2177,10708,12206,8081,3113,2440,7625,14656,16698,10246,-1068,-9195,-8511,-151,9742,15129,13618,6607,-2335,-9181,-11202,-8577,-4436,-2511,-4099,-7261,-8977,-7961,-5413,-3464,-3289,-4539,-6037,-6635,-5665,-3095,345,3291,4374,3145,562,-1557,-1821,-260,1857,3168,3224,2536,1882,1706,2006,2519,2871,2741,2102,1325,914,1068,1535,1847,1608,570,-1326,-3751,-5883,-6779,-6092,-4410,-2806,-2008,-1986,-2237,-2322,-2130,-1780,-1424,-1142,-934,-742,-497,-178,178,518,813,1051,1227,1365,1527,1752,1979,2045,1816,1310,712,263,121,276,559,738,661,348,-38,-336,-504,-620,-782,-1021,-1303,-1567,-1748,-1770,-1586,-1241,-885,-674,-654,-739,-807,-803,-736,-625,-466,-273,-88,65,213,402,620,795,864,825,714,560,392,266,236,284,316,249,97,-41,-84,-31,62,121,87,-63,-292,-507,-620,-615,-539,-448,-366,-295,-234,-172,-85,23,97,67,-74,-258,-396,-442,-401,-299,-170,-56,14,63,138,248,339,338,228,57,-109,-230,-284,-261,-175,-71,5,40,50,42,-1,-92,-219,-345,-439,-481,-457,-366,-223,-66,74,179,239,242,182,79,-34,-124,-184,-215,-221,-201,-153,-84,-6,55,75,36,-50,-154,-246,-310,-346,-358,-343,-294,-207,-94,18,91,98,40,-58,-162,-244,-289,-297,-273,-221,-148,-58,33,103,132,114,56,-21,-96,-154,-189,-209,-213,-189,-128,-43,30,63,59,36,6,-36,-83,-105,-82,-29}
        },
        {    // H10e110a.wav
            {0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,1,1,0,-1,-1,1,1,-2,-2,1,6,5,-1,-3,1,6,6,3,5,8,6,0,6,21,23,11,57,273,686,1123,1293,1014,405,-174,-398,-205,191,504,570,391,72,-232,-336,-56,671,1689,2643,3179,3158,2735,2217,1847,1668,1561,1391,1127,839,613,467,345,176,-43,-246,-346,-310,-186,-63,-17,-73,-208,-367,-487,-527,-499,-468,-509,-652,-859,-1059,-1190,-1229,-1185,-1091,-989,-915,-877,-850,-791,-687,-552,-412,-273,-127,23,155,248,301,332,345,331,280,208,142,98,59,-4,-102,-213,-303,-353,-369,-363,-347,-328,-322,-339,-374,-405,-417,-414,-411,-414,-413,-394,-366,-346,-340,-333,-314,-289,-272,-266,-256,-231,-196,-167,-152,-144,-141,-144,-153,-157,-142,-111,-88,-88,-107,-121,-121,-115,-124,-153,-187,-210,-217,-212,-206,-200,-198,-203,-219,-240,-251,-243,-214,-179,-151,-133,-120,-109,-99,-96,-101,-110,-118,-122,-127,-133,-141,-146,-146,-144,-147,-154,-157,-149,-129,-104,-83,-65,-47,-32,-26,-31,-36,-33,-21,-9,-6,-10,-13,-18,-31,-54,-81,-103,-120,-137,-158,-177,-184,-177,-159,-138,-118,-99,-81,-67,-61,-64,-74,-86,-101,-122,-147,-167,-176,-177,-181,-190,-196,-191,-177,-161,-146,-128,-107,-93,-90,-92,-86,-74,-65,-64,-62,-45,-16},
            {37,214,29,-300,-170,333,292,-420,153,4346,11204,15449,11596,-317,-13596,-19985,-16068,-5182,5912,11747,10859,5927,1991,3125,9024,14554,13842,5854,-4075,-8658,-4798,4357,12600,15300,11567,3615,-4843,-10191,-10603,-7220,-3470,-2446,-4513,-7411,-8603,-7434,-5242,-3804,-3897,-5036,-6105,-6092,-4551,-1790,1204,3184,3347,1892,-45,-1138,-777,612,2061,2850,2884,2492,2052,1833,1969,2375,2696,2545,1896,1176,876,1090,1468,1537,972,-351,-2321,-4465,-5996,-6261,-5262,-3702,-2435,-1876,-1879,-2054,-2111,-1948,-1605,-1201,-878,-697,-581,-394,-77,305,648,898,1070,1198,1324,1486,1681,1824,1782,1489,1016,544,252,216,388,618,729,604,264,-144,-458,-619,-699,-820,-1043,-1327,-1577,-1696,-1634,-1405,-1092,-823,-691,-702,-772,-811,-779,-683,-538,-356,-159,20,168,307,466,633,758,799,745,614,443,289,213,234,298,317,247,122,18,-17,15,73,100,37,-136,-368,-562,-645,-617,-533,-444,-370,-310,-255,-186,-88,14,57,-6,-156,-318,-420,-433,-369,-253,-120,-11,59,116,197,294,350,313,186,21,-126,-221,-247,-201,-107,-15,34,40,20,-20,-91,-199,-316,-407,-448,-437,-376,-270,-136,-2,106,172,193,166,97,4,-86,-151,-186,-195,-184,-152,-100,-33,32,70,59,-3,-99,-196,-270,-313,-328,-319,-286,-225,-142,-57,8,35,20,-31,-101,-169,-220,-247,-251,-234,-193,-129,-53,15,55,61,37,-4,-53,-100,-144,-184,-218,-226,-189,-108,-13,59,87,74,32,-30,-91,-118,-91,-34}
        },
        {    // H10e115a.wav
            {1,1,1,1,2,3,3,2,1,2,3,3,2,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,3,5,4,2,1,3,5,3,1,2,6,7,3,-1,2,7,6,1,4,14,17,6,-2,11,26,20,43,229,662,1209,1528,1322,630,-153,-570,-454,-10,399,526,343,-21,-361,-435,-25,920,2148,3165,3525,3135,2329,1620,1345,1477,1726,1797,1587,1192,765,378,-4,-434,-881,-1218,-1319,-1171,-891,-635,-477,-382,-285,-179,-109,-98,-99,-40,87,205,217,101,-78,-223,-288,-304,-336,-429,-576,-730,-839,-874,-835,-746,-641,-546,-478,-432,-391,-331,-239,-127,-30,16,-3,-66,-133,-177,-199,-220,-247,-265,-253,-216,-180,-172,-191,-213,-215,-196,-173,-156,-145,-139,-138,-150,-171,-193,-206,-212,-217,-229,-250,-280,-319,-364,-399,-407,-386,-358,-344,-349,-349,-323,-271,-218,-183,-167,-155,-140,-125,-116,-110,-103,-95,-94,-104,-120,-132,-140,-153,-177,-207,-231,-237,-222,-187,-143,-99,-67,-52,-50,-58,-69,-83,-102,-119,-130,-136,-142,-155,-172,-186,-192,-193,-194,-196,-197,-191,-175,-152,-127,-104,-84,-68,-54,-40,-28,-18,-6,7,21,28,22,6,-10,-26,-45,-73,-109,-142,-161,-162,-152,-138,-128,-124,-127,-133,-136,-131,-116,-95,-80,-77,-88,-107,-129,-153,-175,-191,-196,-194,-192,-191,-184,-166,-142,-125,-117,-109,-96,-82,-73,-68,-58,-44,-37,-41,-45,-35,-13},
            {-131,147,246,-68,-359,-85,401,180,-483,597,5260,11703,14506,9223,-2762,-14434,-18593,-13280,-2501,7367,11721,9816,4660,1161,2820,8653,13396,11909,4177,-4211,-6870,-2008,6638,13375,14580,10065,2146,-5738,-10346,-10197,-6641,-3052,-2248,-4368,-7200,-8429,-7505,-5604,-4245,-4122,-4884,-5614,-5422,-3922,-1462,1021,2521,2575,1530,271,-374,-110,793,1830,2593,2881,2679,2173,1744,1750,2172,2552,2414,1757,1064,793,948,1165,1064,430,-814,-2572,-4407,-5619,-5700,-4757,-3437,-2402,-1908,-1831,-1927,-1988,-1868,-1522,-1068,-716,-560,-479,-282,78,478,776,949,1059,1166,1292,1435,1576,1647,1565,1295,904,523,282,246,386,582,666,524,178,-232,-547,-707,-772,-854,-1025,-1272,-1506,-1615,-1533,-1288,-993,-775,-698,-730,-787,-801,-747,-631,-464,-264,-66,97,223,342,476,608,698,713,655,538,393,268,220,258,326,341,270,154,59,18,21,40,36,-40,-209,-432,-613,-677,-630,-536,-454,-395,-343,-284,-210,-121,-37,-7,-67,-199,-336,-408,-392,-305,-181,-57,38,98,150,218,290,319,274,164,30,-93,-178,-206,-168,-92,-24,5,1,-18,-56,-130,-236,-335,-395,-410,-390,-338,-247,-130,-15,70,120,135,112,49,-38,-114,-156,-164,-154,-134,-104,-60,-7,41,63,43,-19,-106,-189,-251,-290,-310,-311,-290,-241,-167,-79,3,50,43,-17,-101,-180,-238,-272,-283,-265,-216,-143,-65,1,40,45,17,-34,-88,-132,-168,-198,-214,-198,-145,-70,3,53,68,41,-22,-91,-123,-97,-37}
        },
        {    // H10e120a.wav
            {0,0,0,0,1,1,1,1,1,1,1,1,1,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,1,0,-2,-2,1,3,1,0,0,2,1,-1,0,4,7,2,-4,-3,1,0,-3,1,15,21,8,-6,2,20,17,32,208,664,1291,1719,1578,841,-94,-689,-680,-229,263,468,301,-101,-466,-479,98,1253,2629,3655,3879,3279,2283,1470,1180,1324,1532,1484,1139,706,414,302,204,-75,-575,-1144,-1563,-1702,-1590,-1355,-1118,-937,-816,-734,-654,-516,-270,72,413,618,626,506,406,433,568,692,689,524,257,-19,-239,-385,-482,-558,-631,-699,-749,-770,-757,-712,-649,-588,-545,-525,-520,-514,-500,-485,-482,-492,-502,-489,-436,-345,-237,-143,-84,-64,-66,-69,-56,-25,17,58,87,95,80,47,10,-21,-41,-62,-99,-157,-226,-291,-345,-397,-461,-533,-588,-598,-554,-476,-391,-322,-276,-250,-241,-239,-235,-220,-195,-164,-132,-101,-74,-61,-69,-98,-137,-173,-194,-197,-180,-147,-108,-75,-53,-36,-18,1,9,-1,-26,-56,-82,-108,-135,-162,-184,-199,-210,-220,-227,-229,-226,-220,-213,-203,-185,-160,-135,-117,-108,-103,-96,-83,-64,-41,-12,20,44,52,38,6,-32,-68,-99,-121,-132,-131,-122,-111,-104,-101,-101,-103,-110,-123,-140,-151,-149,-137,-123,-119,-128,-146,-165,-178,-185,-187,-185,-181,-177,-171,-162,-148,-134,-123,-119,-117,-108,-91,-71,-55,-47,-44,-45,-47,-46,-38,-23,-7},
            {-102,-76,116,178,-81,-302,-46,363,128,-438,695,5141,11098,13499,8352,-2841,-13489,-17041,-11876,-1771,7414,11394,9335,3974,105,1386,7119,12229,11555,4826,-2768,-5201,-772,7053,13046,13936,9558,1984,-5634,-10184,-10101,-6560,-2838,-1834,-3884,-6907,-8516,-7926,-6092,-4494,-3966,-4387,-5020,-5035,-3945,-1889,403,1999,2353,1650,638,68,224,905,1749,2474,2874,2783,2245,1655,1523,1950,2442,2393,1726,950,581,645,775,628,70,-935,-2345,-3867,-4941,-5113,-4433,-3413,-2577,-2117,-1943,-1908,-1893,-1776,-1468,-1036,-672,-495,-408,-215,155,580,890,1037,1091,1148,1244,1365,1476,1525,1458,1246,915,558,296,221,329,502,572,431,104,-278,-582,-754,-832,-899,-1021,-1207,-1393,-1478,-1394,-1169,-917,-754,-715,-748,-773,-753,-687,-576,-410,-206,-14,120,203,292,422,563,654,667,619,533,423,317,265,295,363,381,304,169,51,-5,-12,-8,-32,-120,-282,-481,-641,-698,-653,-557,-465,-401,-360,-324,-269,-186,-100,-63,-106,-204,-296,-333,-305,-223,-109,6,89,130,154,198,256,287,254,164,50,-57,-137,-171,-152,-97,-43,-15,-8,-16,-47,-117,-216,-315,-383,-411,-400,-349,-262,-156,-55,24,78,102,85,29,-43,-101,-130,-132,-119,-96,-65,-25,20,60,76,53,-14,-110,-208,-285,-328,-328,-288,-226,-159,-97,-41,2,15,-18,-87,-166,-233,-278,-298,-287,-241,-174,-105,-50,-14,3,-2,-26,-56,-83,-107,-134,-163,-182,-179,-150,-100,-40,12,29,-2,-57,-91,-76,-29}
        },
        {    // H10e125a.wav
            {0,2,3,3,2,2,2,2,2,2,2,1,0,-1,0,1,1,0,0,1,2,1,0,0,0,0,1,1,2,0,-1,1,3,3,1,1,5,6,3,-1,1,6,3,-7,-7,10,23,14,-1,7,28,22,22,186,673,1394,1941,1859,1057,-51,-838,-940,-472,128,444,310,-144,-573,-546,224,1653,3222,4231,4237,3349,2156,1313,1127,1409,1688,1584,1060,386,-124,-357,-442,-592,-898,-1264,-1512,-1530,-1358,-1142,-1026,-1061,-1191,-1294,-1260,-1039,-670,-256,85,286,370,429,557,774,1011,1165,1176,1058,880,707,566,444,314,156,-32,-233,-429,-600,-731,-815,-856,-864,-859,-859,-874,-902,-928,-935,-922,-895,-862,-813,-729,-603,-456,-322,-226,-164,-114,-58,10,86,161,219,247,243,224,211,216,222,207,157,84,4,-71,-147,-237,-342,-447,-531,-576,-585,-568,-536,-495,-447,-400,-361,-340,-335,-337,-332,-308,-264,-208,-155,-120,-109,-121,-145,-166,-165,-135,-88,-48,-31,-36,-42,-33,-8,22,43,51,47,32,4,-33,-73,-110,-141,-169,-197,-219,-231,-229,-219,-210,-206,-206,-206,-203,-192,-171,-145,-123,-112,-112,-110,-96,-67,-32,0,21,26,11,-18,-53,-86,-110,-124,-126,-116,-96,-74,-57,-48,-50,-66,-89,-113,-128,-133,-132,-131,-134,-141,-155,-174,-192,-200,-193,-175,-157,-146,-142,-142,-142,-139,-131,-121,-112,-104,-96,-89,-80,-69,-57,-45,-41,-45,-47,-36,-14,8,14,7},
            {65,-114,-141,75,209,-9,-278,-104,308,186,-361,427,4220,9752,12560,8668,-1175,-11310,-15497,-11577,-2462,6487,10839,9178,3677,-987,-631,4909,11061,12231,6998,-386,-3851,-812,6165,12132,13538,9803,2692,-4834,-9697,-10095,-6794,-2849,-1384,-3209,-6489,-8632,-8423,-6555,-4582,-3619,-3821,-4590,-5036,-4428,-2604,-170,1785,2417,1758,667,104,406,1209,1981,2484,2718,2647,2224,1664,1432,1765,2300,2379,1762,876,326,266,369,269,-151,-875,-1899,-3098,-4091,-4456,-4116,-3430,-2825,-2456,-2219,-2010,-1822,-1643,-1397,-1057,-728,-525,-415,-229,133,588,955,1133,1163,1156,1193,1291,1407,1471,1417,1224,926,602,346,237,291,424,481,346,33,-333,-620,-784,-863,-919,-997,-1111,-1238,-1315,-1273,-1104,-889,-737,-694,-714,-724,-690,-620,-519,-375,-195,-26,83,137,198,314,472,610,681,672,599,483,368,305,322,380,398,324,179,31,-64,-93,-89,-101,-173,-320,-506,-659,-721,-682,-581,-472,-398,-372,-367,-338,-255,-145,-75,-87,-161,-238,-271,-249,-175,-64,55,137,159,151,163,207,240,220,145,49,-37,-98,-128,-117,-74,-26,1,2,-15,-50,-115,-209,-310,-388,-423,-411,-355,-269,-172,-85,-16,33,58,52,16,-32,-67,-79,-73,-59,-42,-25,-7,7,13,5,-21,-64,-115,-161,-195,-216,-222,-213,-196,-174,-150,-123,-97,-85,-100,-139,-186,-225,-248,-256,-249,-223,-180,-124,-65,-15,15,20,0,-36,-80,-124,-161,-187,-199,-195,-170,-121,-59,-11,-2,-26,-49,-43,-16}
        },
        {    // H10e130a.wav
            {0,0,0,0,1,2,0,-1,-1,0,-1,-2,-2,-2,-1,-1,-1,-1,-1,-1,-2,-1,-2,-3,-2,-1,1,-1,-3,-2,1,1,-3,-4,2,6,0,-7,-6,4,5,-6,-12,2,20,13,-6,-1,25,28,27,188,700,1502,2158,2135,1269,-13,-996,-1212,-735,-38,384,298,-176,-633,-554,399,2085,3836,4818,4582,3383,1992,1154,1117,1559,1901,1732,1045,173,-497,-793,-845,-932,-1241,-1709,-2087,-2136,-1814,-1304,-878,-721,-832,-1058,-1208,-1154,-887,-505,-152,58,107,86,135,342,691,1066,1331,1401,1283,1070,876,776,758,750,672,494,245,-18,-245,-413,-534,-641,-768,-922,-1078,-1194,-1250,-1255,-1235,-1212,-1188,-1150,-1078,-961,-805,-638,-493,-387,-307,-224,-119,5,128,228,294,324,327,319,316,325,341,346,321,244,111,-59,-224,-340,-398,-420,-437,-459,-469,-451,-414,-387,-393,-431,-480,-512,-508,-461,-385,-306,-253,-238,-251,-271,-276,-253,-200,-125,-54,-11,-3,-13,-17,-5,16,32,42,53,65,67,48,12,-27,-58,-85,-118,-159,-195,-212,-208,-194,-181,-177,-180,-188,-196,-201,-199,-191,-181,-173,-164,-148,-118,-80,-44,-21,-13,-16,-26,-44,-72,-105,-132,-146,-145,-134,-119,-99,-75,-52,-37,-37,-47,-62,-81,-104,-128,-145,-151,-148,-146,-152,-167,-182,-190,-188,-178,-164,-150,-137,-131,-133,-138,-137,-124,-104,-88,-83,-83,-79,-70,-62,-59,-58,-53,-45,-36,-24,-3,21,37,32,13},
            {53,53,-56,-111,21,163,47,-204,-157,197,241,-224,48,2806,7740,11380,9590,1701,-8068,-13661,-11822,-4135,4639,9784,9085,3860,-1623,-2682,2143,9342,12987,9955,2866,-2289,-1472,4318,10575,13106,10491,4051,-3377,-8704,-9898,-7206,-3226,-1163,-2436,-5759,-8491,-8861,-7079,-4708,-3270,-3312,-4334,-5253,-5041,-3323,-680,1620,2475,1781,510,-116,376,1478,2373,2693,2618,2399,2077,1690,1494,1722,2171,2278,1719,802,132,-28,63,23,-278,-784,-1481,-2358,-3214,-3707,-3680,-3336,-3000,-2778,-2543,-2201,-1831,-1549,-1340,-1112,-858,-654,-512,-313,58,553,980,1190,1195,1129,1122,1216,1356,1446,1408,1224,939,639,408,305,331,411,418,255,-59,-404,-659,-787,-835,-867,-915,-993,-1094,-1184,-1195,-1084,-889,-712,-630,-633,-652,-631,-566,-473,-353,-207,-62,38,87,128,219,369,533,650,686,639,535,420,348,342,371,374,304,167,11,-109,-164,-162,-154,-200,-329,-507,-658,-723,-694,-606,-501,-415,-372,-366,-356,-296,-185,-83,-55,-108,-189,-236,-221,-151,-44,67,146,169,155,144,160,181,169,116,42,-24,-66,-76,-55,-19,7,5,-19,-52,-89,-140,-210,-285,-344,-376,-376,-344,-283,-207,-132,-69,-15,29,53,48,21,-10,-31,-41,-51,-62,-72,-71,-53,-19,16,35,22,-21,-81,-142,-194,-234,-258,-266,-258,-236,-202,-163,-131,-120,-137,-172,-207,-227,-228,-212,-181,-135,-80,-30,0,5,-12,-42,-81,-122,-160,-185,-197,-196,-185,-157,-109,-54,-14,-3,-11,-16,-8}
        },
        {    // H10e135a.wav
            {1,1,2,2,1,0,0,0,-1,-1,-1,-1,-1,-1,-1,0,1,0,-1,-1,-1,-2,-2,0,1,0,-2,-1,3,3,-2,-3,1,5,1,-6,-3,5,4,-9,-13,4,22,13,-7,1,32,32,20,187,754,1658,2414,2413,1458,1,-1162,-1482,-999,-207,328,298,-201,-693,-544,636,2613,4528,5413,4860,3318,1754,974,1138,1779,2202,1963,1092,2,-836,-1206,-1248,-1292,-1567,-2022,-2395,-2439,-2119,-1624,-1214,-1048,-1101,-1222,-1232,-1026,-618,-139,222,324,184,-29,-99,75,423,775,989,1033,971,902,896,964,1048,1063,957,756,542,378,270,178,61,-96,-293,-520,-763,-995,-1187,-1324,-1411,-1459,-1464,-1412,-1298,-1145,-993,-875,-790,-711,-609,-474,-321,-166,-24,99,189,239,259,276,314,375,432,449,400,285,133,-13,-119,-182,-228,-277,-324,-346,-331,-298,-278,-291,-336,-400,-467,-521,-545,-527,-476,-417,-376,-363,-364,-354,-316,-251,-176,-113,-73,-53,-40,-29,-18,-8,10,39,71,84,68,33,4,-10,-19,-42,-82,-130,-168,-192,-199,-189,-165,-136,-120,-128,-154,-178,-189,-190,-190,-192,-190,-181,-164,-139,-103,-58,-15,6,-6,-46,-93,-130,-150,-158,-157,-150,-139,-128,-119,-111,-98,-77,-58,-51,-63,-88,-114,-132,-144,-153,-159,-159,-154,-151,-152,-154,-150,-140,-133,-135,-146,-155,-158,-154,-145,-130,-109,-87,-73,-69,-70,-70,-64,-55,-48,-43,-39,-36,-30,-22,-12,-3,1,1,-1,-1},
            {-59,32,89,2,-115,-64,108,119,-99,-204,40,253,-28,-207,1330,5276,9541,10193,5012,-3816,-10904,-11814,-6304,1900,7929,8693,4433,-1401,-4066,-803,6595,12666,12686,6874,257,-1791,1972,8182,12112,11144,5819,-1246,-6986,-9206,-7589,-3989,-1368,-1736,-4684,-7877,-9045,-7675,-5089,-3159,-2929,-4093,-5410,-5571,-4013,-1290,1250,2359,1783,438,-345,105,1375,2521,2953,2774,2384,2006,1678,1507,1659,2041,2199,1743,811,-23,-334,-221,-91,-212,-583,-1127,-1809,-2528,-3056,-3224,-3110,-2947,-2846,-2705,-2406,-1997,-1632,-1376,-1173,-974,-801,-660,-455,-76,449,933,1189,1185,1054,974,1041,1224,1404,1448,1300,1013,703,475,374,376,408,374,203,-91,-412,-650,-758,-777,-777,-809,-885,-990,-1086,-1115,-1042,-888,-731,-637,-606,-590,-548,-480,-404,-318,-210,-86,19,79,110,156,250,379,506,587,601,546,451,364,321,320,319,267,150,-1,-132,-204,-215,-201,-219,-305,-448,-592,-678,-683,-625,-538,-453,-396,-373,-360,-315,-220,-109,-48,-65,-131,-184,-188,-142,-62,30,108,145,137,114,109,125,133,107,51,-9,-46,-51,-30,-1,15,4,-32,-76,-116,-155,-200,-248,-291,-321,-334,-323,-283,-220,-152,-92,-41,1,26,23,-6,-40,-58,-57,-46,-32,-17,0,16,26,28,16,-14,-65,-130,-193,-244,-278,-297,-302,-293,-273,-246,-216,-185,-157,-138,-132,-134,-139,-143,-143,-138,-125,-106,-87,-73,-69,-75,-92,-115,-137,-154,-164,-168,-164,-152,-127,-91,-51,-19,-1,3,1}
        },
        {    // H10e140a.wav
            {1,2,1,0,0,0,0,-2,-2,-1,0,-1,-1,0,1,0,-1,-1,-1,-2,-2,-1,1,0,-2,-2,1,1,-1,-2,3,5,-1,-9,-5,8,8,-9,-18,-2,19,12,-10,0,38,41,21,192,813,1830,2699,2717,1639,-32,-1387,-1788,-1261,-358,279,292,-221,-723,-488,917,3177,5258,6043,5150,3224,1453,732,1131,1997,2508,2197,1159,-114,-1095,-1544,-1608,-1645,-1917,-2389,-2777,-2799,-2399,-1786,-1277,-1083,-1201,-1449,-1587,-1431,-941,-256,364,684,654,435,273,310,506,717,828,813,717,608,556,601,727,855,901,835,700,556,440,356,294,233,138,-29,-269,-539,-784,-981,-1142,-1282,-1389,-1436,-1409,-1316,-1181,-1035,-899,-790,-708,-635,-544,-419,-267,-117,3,85,143,199,257,297,299,262,209,162,124,75,5,-74,-139,-175,-184,-177,-168,-164,-174,-206,-260,-326,-391,-447,-486,-506,-508,-495,-468,-427,-368,-298,-233,-188,-164,-146,-121,-94,-75,-69,-64,-45,-12,19,34,31,20,9,-4,-23,-49,-77,-105,-134,-164,-188,-193,-173,-139,-109,-93,-97,-116,-146,-174,-188,-182,-165,-154,-154,-152,-133,-96,-57,-30,-24,-36,-64,-101,-137,-157,-159,-152,-145,-143,-140,-132,-119,-104,-95,-96,-104,-116,-127,-138,-151,-165,-173,-172,-163,-150,-136,-121,-108,-101,-101,-106,-114,-129,-150,-169,-174,-160,-133,-102,-73,-53,-46,-52,-61,-62,-58,-54,-52,-43,-27,-14,-13,-19,-22,-28,-53,-90,-110,-85,-31},
            {1,-52,-33,47,58,-41,-97,5,120,33,-153,-109,148,152,-165,265,2768,6887,9650,7772,1030,-6777,-10608,-8167,-1454,5051,7544,5039,-269,-4234,-3264,2918,10447,13943,10958,4240,-611,25,5016,9989,11123,7627,1463,-4433,-7727,-7573,-4929,-2119,-1427,-3462,-6689,-8703,-8177,-5791,-3472,-2772,-3792,-5317,-5841,-4608,-2053,549,1942,1713,529,-397,-224,940,2277,3024,3021,2610,2156,1790,1547,1525,1751,1976,1801,1087,167,-453,-560,-361,-207,-298,-664,-1260,-1977,-2600,-2914,-2894,-2732,-2622,-2570,-2451,-2205,-1900,-1613,-1335,-1042,-782,-622,-516,-306,109,634,1039,1167,1057,896,862,1000,1218,1366,1340,1149,883,644,485,399,353,296,177,-31,-298,-544,-692,-727,-700,-682,-724,-832,-968,-1066,-1062,-942,-764,-615,-542,-524,-503,-441,-344,-234,-127,-34,31,57,57,68,128,240,370,468,500,463,385,306,261,256,257,223,133,8,-112,-192,-221,-213,-203,-236,-332,-466,-579,-625,-598,-533,-472,-435,-418,-401,-353,-258,-135,-37,-12,-59,-126,-155,-125,-57,15,64,77,60,38,37,66,104,120,97,47,-3,-30,-26,-4,10,-3,-43,-92,-129,-151,-167,-187,-210,-231,-247,-254,-245,-220,-187,-156,-130,-98,-57,-14,20,38,46,50,50,43,29,10,-10,-29,-47,-70,-103,-149,-200,-244,-275,-292,-301,-300,-289,-267,-237,-201,-160,-119,-88,-77,-85,-103,-120,-132,-139,-142,-142,-136,-127,-118,-113,-111,-108,-102,-95,-91,-92,-95,-96,-93,-86,-72,-51,-26,-6}
        },
        {    // H10e145a.wav
            {1,0,0,0,-1,-2,-2,-2,-2,-2,-2,0,2,1,-1,-1,-1,-2,-2,0,1,0,-2,-1,2,1,-5,-6,2,8,1,-11,-9,6,9,-7,-17,-1,20,8,-18,-4,44,49,26,214,910,2049,3015,3016,1779,-122,-1665,-2127,-1531,-495,254,303,-233,-727,-355,1320,3852,6016,6602,5322,3042,1139,536,1175,2234,2781,2356,1133,-296,-1351,-1805,-1856,-1909,-2233,-2766,-3186,-3184,-2701,-1969,-1353,-1113,-1258,-1567,-1739,-1567,-1046,-358,231,535,555,463,468,651,926,1126,1143,985,743,525,415,435,535,613,586,453,299,217,242,332,410,411,304,109,-121,-327,-482,-605,-732,-875,-1012,-1110,-1148,-1127,-1061,-971,-881,-808,-751,-690,-606,-496,-374,-258,-157,-70,-2,40,54,54,61,82,96,73,3,-81,-134,-134,-102,-73,-66,-77,-91,-105,-119,-135,-163,-217,-302,-401,-479,-507,-476,-402,-314,-240,-203,-203,-220,-221,-193,-145,-102,-80,-75,-77,-77,-76,-74,-64,-45,-26,-18,-29,-51,-69,-80,-95,-124,-164,-202,-220,-211,-178,-129,-83,-60,-70,-103,-137,-154,-155,-153,-152,-149,-138,-119,-90,-52,-15,5,-9,-51,-99,-133,-144,-142,-135,-131,-133,-139,-143,-139,-128,-116,-110,-109,-113,-126,-149,-175,-194,-201,-200,-193,-179,-156,-128,-99,-73,-55,-51,-70,-107,-146,-170,-175,-162,-133,-93,-55,-30,-21,-20,-24,-36,-54,-66,-63,-51,-44,-42,-34,-21,-22,-44,-72,-87,-98,-129,-175,-190,-140,-50},
            {19,21,-22,-50,-4,59,29,-67,-72,49,106,-28,-155,-26,178,52,-130,856,3847,7553,8815,5367,-1509,-7481,-8646,-4650,1330,5270,5016,1271,-3034,-4358,-750,6362,12557,13588,9015,2781,-153,1980,6655,9694,8701,4284,-1160,-5259,-6711,-5585,-3258,-1771,-2520,-5125,-7658,-8236,-6609,-4258,-3015,-3537,-4948,-5738,-4973,-2870,-472,1118,1399,679,-187,-370,400,1691,2759,3125,2861,2365,1947,1681,1549,1562,1667,1641,1246,519,-186,-520,-461,-284,-261,-482,-900,-1445,-2016,-2452,-2628,-2581,-2475,-2426,-2393,-2277,-2056,-1785,-1497,-1176,-844,-585,-450,-361,-167,188,597,888,977,922,850,860,967,1112,1202,1176,1038,849,666,512,380,259,134,-16,-201,-392,-533,-590,-580,-565,-597,-695,-836,-969,-1027,-965,-802,-618,-496,-453,-435,-384,-291,-190,-105,-36,18,44,28,-3,4,81,207,326,388,378,310,219,145,117,132,150,130,59,-38,-128,-186,-206,-202,-203,-242,-327,-429,-499,-512,-480,-440,-417,-417,-427,-418,-362,-250,-113,-12,14,-23,-72,-91,-73,-38,-9,2,-11,-34,-43,-17,41,102,133,119,73,21,-18,-34,-36,-40,-59,-87,-106,-109,-106,-114,-140,-178,-215,-245,-262,-257,-226,-175,-117,-64,-16,29,68,93,101,95,79,54,18,-30,-86,-140,-182,-206,-217,-225,-234,-241,-242,-237,-233,-232,-232,-228,-217,-199,-172,-139,-107,-87,-88,-101,-116,-126,-136,-149,-162,-163,-149,-126,-104,-84,-63,-43,-30,-31,-42,-56,-71,-89,-103,-97,-65,-22}
        },
        {    // H10e150a.wav
            {0,0,0,-2,-2,0,0,-1,-2,0,2,1,-1,-1,-2,-2,-3,-1,1,0,-2,0,4,4,-3,-5,2,8,1,-11,-7,8,9,-9,-18,4,25,6,-26,-9,48,52,25,246,1045,2327,3376,3311,1863,-290,-1997,-2476,-1778,-602,243,307,-257,-718,-160,1834,4649,6846,7139,5384,2723,737,343,1298,2564,3102,2486,1019,-582,-1680,-2083,-2073,-2116,-2492,-3099,-3569,-3561,-3007,-2160,-1429,-1127,-1293,-1676,-1903,-1715,-1114,-348,272,560,560,476,501,692,960,1169,1234,1154,980,786,647,601,619,612,497,276,35,-121,-144,-64,46,114,103,15,-120,-268,-406,-528,-633,-714,-763,-780,-767,-727,-665,-592,-535,-515,-535,-570,-579,-523,-395,-238,-127,-114,-179,-243,-232,-141,-33,21,-1,-76,-162,-234,-277,-283,-252,-203,-158,-128,-109,-90,-78,-93,-151,-249,-358,-435,-441,-369,-251,-144,-91,-95,-126,-149,-148,-127,-96,-66,-49,-59,-94,-136,-158,-144,-103,-57,-29,-31,-61,-99,-126,-133,-129,-135,-163,-207,-245,-258,-238,-195,-148,-113,-97,-97,-108,-122,-132,-133,-127,-122,-122,-121,-105,-69,-23,12,20,0,-37,-78,-109,-124,-124,-120,-122,-132,-146,-155,-154,-142,-122,-104,-99,-110,-133,-160,-188,-214,-236,-246,-239,-213,-169,-114,-61,-31,-33,-64,-107,-148,-175,-180,-159,-115,-67,-29,-7,3,3,-8,-23,-35,-43,-51,-60,-62,-53,-45,-53,-71,-85,-90,-97,-117,-136,-144,-151,-184,-229,-236,-169,-59},
            {-17,3,32,16,-37,-48,16,62,4,-83,-47,78,86,-72,-145,32,176,-17,-29,1346,4469,7562,7693,3601,-2563,-6740,-6381,-2413,1911,3712,2240,-1100,-3689,-3001,1760,8509,13155,12646,7722,2464,772,3127,6682,8127,6268,2243,-1931,-4674,-5327,-4247,-2723,-2326,-3737,-6056,-7513,-7057,-5278,-3764,-3598,-4504,-5295,-4993,-3530,-1596,-20,718,631,127,-205,81,998,2105,2842,2955,2620,2176,1827,1604,1506,1519,1516,1267,694,44,-303,-234,-32,-61,-407,-875,-1275,-1599,-1903,-2158,-2288,-2305,-2308,-2344,-2339,-2199,-1922,-1581,-1236,-917,-658,-492,-388,-246,3,310,552,657,664,665,720,828,957,1065,1110,1068,944,775,596,432,295,184,76,-64,-237,-397,-483,-485,-454,-461,-535,-658,-788,-878,-888,-805,-658,-510,-410,-358,-321,-272,-214,-159,-107,-57,-19,-15,-40,-61,-40,30,123,204,251,256,217,146,78,47,59,81,67,2,-92,-172,-211,-204,-171,-150,-174,-250,-346,-415,-429,-400,-366,-357,-374,-396,-391,-341,-249,-145,-64,-28,-26,-38,-45,-45,-43,-44,-56,-78,-92,-75,-20,51,104,118,99,67,35,6,-20,-43,-69,-100,-127,-136,-125,-107,-102,-116,-142,-170,-191,-196,-181,-143,-94,-42,8,54,92,110,105,81,44,-4,-63,-127,-187,-234,-262,-269,-253,-223,-190,-167,-156,-157,-169,-192,-219,-236,-240,-230,-211,-182,-148,-118,-104,-105,-113,-121,-129,-137,-138,-126,-105,-85,-70,-55,-41,-31,-30,-30,-27,-25,-36,-57,-67,-51,-19}
        },
        {    // H10e155a.wav
            {-1,-2,-2,0,0,-1,-1,0,1,0,0,1,0,-2,-3,0,2,1,-2,0,4,2,-4,-3,6,9,-3,-16,-8,13,13,-11,-21,6,30,7,-31,-9,53,51,20,287,1213,2654,3775,3601,1891,-539,-2394,-2842,-1998,-669,254,306,-294,-700,89,2442,5540,7722,7645,5363,2330,318,188,1466,2902,3385,2559,860,-889,-2016,-2364,-2294,-2337,-2771,-3444,-3937,-3899,-3282,-2354,-1531,-1148,-1286,-1711,-2004,-1830,-1164,-310,333,566,508,454,602,922,1224,1346,1258,1040,803,646,632,751,897,921,734,383,13,-240,-322,-267,-164,-117,-200,-397,-604,-708,-688,-629,-625,-690,-751,-738,-641,-494,-332,-182,-80,-62,-126,-212,-245,-211,-162,-162,-219,-278,-275,-203,-107,-50,-57,-121,-212,-306,-378,-408,-393,-354,-322,-314,-316,-308,-283,-256,-246,-257,-281,-304,-316,-305,-262,-196,-128,-76,-47,-30,-14,5,22,31,29,17,-8,-43,-83,-113,-122,-108,-83,-66,-66,-80,-102,-121,-138,-152,-166,-182,-205,-237,-273,-296,-290,-249,-189,-137,-115,-123,-144,-157,-156,-144,-128,-109,-91,-76,-62,-42,-13,14,26,15,-13,-45,-72,-89,-98,-101,-106,-119,-138,-150,-144,-123,-100,-87,-87,-102,-128,-163,-198,-229,-252,-262,-252,-219,-174,-129,-92,-67,-58,-70,-103,-142,-163,-153,-116,-62,-6,38,56,45,19,-6,-23,-36,-50,-63,-71,-77,-84,-89,-90,-93,-104,-118,-126,-127,-134,-156,-182,-198,-208,-224,-237,-215,-141,-47},
            {16,-5,-20,4,34,12,-41,-40,26,56,-14,-83,-22,90,60,-97,-118,77,160,-58,76,1646,4652,7171,6709,2723,-2437,-5428,-4756,-1739,1031,1781,409,-1857,-3086,-1474,3343,9323,12931,11886,7292,2798,1420,3168,5608,6328,4680,1597,-1532,-3648,-4284,-3719,-2964,-3129,-4464,-6055,-6681,-5994,-4792,-4141,-4344,-4802,-4723,-3840,-2484,-1176,-260,167,190,47,80,539,1357,2168,2610,2622,2405,2155,1900,1612,1353,1208,1110,877,461,72,-44,78,136,-105,-574,-1031,-1355,-1607,-1850,-2031,-2089,-2080,-2122,-2225,-2265,-2128,-1828,-1460,-1093,-754,-476,-296,-192,-76,113,325,447,436,369,370,499,716,931,1072,1107,1032,863,636,408,243,169,150,109,-10,-185,-336,-400,-382,-347,-358,-436,-560,-683,-755,-741,-650,-530,-437,-386,-350,-303,-248,-211,-195,-182,-153,-122,-114,-128,-131,-93,-22,52,108,145,168,171,144,99,62,46,32,-7,-77,-152,-201,-206,-175,-134,-113,-135,-196,-272,-327,-345,-338,-331,-338,-355,-366,-352,-303,-227,-150,-97,-74,-69,-67,-63,-64,-72,-85,-100,-108,-99,-59,5,69,101,93,58,18,-14,-37,-55,-72,-92,-113,-123,-117,-97,-78,-71,-74,-81,-90,-100,-108,-106,-90,-66,-38,-7,25,51,58,37,-5,-57,-109,-157,-199,-230,-247,-246,-229,-204,-178,-161,-154,-156,-167,-183,-203,-224,-243,-259,-265,-254,-222,-178,-137,-110,-97,-89,-85,-82,-83,-84,-85,-83,-77,-68,-55,-40,-22,-4,9,9,-1,-13,-14,-6}
        },
        {    // H10e160a.wav
            {-3,-2,-1,-2,-2,0,1,0,-1,0,-1,-4,-4,-1,2,0,-3,0,5,2,-6,-6,5,9,-5,-20,-10,13,10,-18,-26,8,34,3,-39,-8,63,52,14,341,1422,3040,4207,3860,1828,-888,-2843,-3198,-2172,-695,275,288,-351,-670,404,3150,6512,8602,8071,5228,1861,-94,110,1727,3283,3626,2519,568,-1290,-2370,-2597,-2439,-2499,-3040,-3829,-4362,-4266,-3540,-2515,-1636,-1231,-1357,-1772,-2054,-1849,-1121,-201,454,617,453,353,573,1039,1459,1598,1438,1118,797,582,526,622,782,860,755,486,172,-69,-187,-203,-184,-216,-367,-631,-914,-1096,-1135,-1089,-1043,-1015,-956,-822,-628,-420,-232,-60,99,224,277,243,146,44,-7,8,58,88,69,16,-35,-63,-83,-131,-228,-363,-499,-591,-611,-562,-480,-415,-400,-434,-486,-517,-502,-438,-350,-280,-261,-283,-299,-263,-169,-54,38,87,106,107,95,71,47,36,36,29,7,-25,-48,-52,-41,-29,-29,-47,-87,-138,-182,-203,-203,-206,-232,-282,-331,-349,-325,-270,-212,-174,-164,-175,-196,-209,-203,-177,-139,-107,-90,-85,-77,-54,-19,14,28,19,-5,-34,-60,-79,-89,-95,-101,-109,-117,-116,-101,-77,-58,-55,-73,-106,-146,-186,-224,-252,-265,-260,-242,-218,-193,-168,-147,-134,-130,-134,-139,-138,-123,-94,-52,-5,37,67,83,83,67,36,-3,-42,-79,-114,-143,-161,-164,-157,-146,-133,-123,-122,-134,-153,-170,-180,-193,-210,-223,-220,-204,-189,-176,-149,-95,-31},
            {-4,12,14,-6,-16,8,30,4,-40,-29,32,44,-26,-72,0,89,35,-103,-86,99,130,-79,156,1752,4515,6635,6069,2596,-1713,-4258,-4049,-2127,-268,383,-306,-1625,-2184,-452,3965,9316,12505,11559,7434,3226,1501,2415,4189,4962,4049,1872,-690,-2766,-3784,-3784,-3463,-3636,-4492,-5456,-5836,-5527,-5006,-4721,-4641,-4405,-3786,-2896,-2000,-1257,-675,-238,45,216,425,827,1410,1977,2322,2405,2332,2184,1935,1553,1125,807,671,637,584,470,321,145,-83,-359,-631,-874,-1129,-1432,-1732,-1932,-2012,-2057,-2136,-2206,-2156,-1944,-1631,-1301,-985,-678,-396,-169,5,148,263,314,282,207,171,231,391,615,845,1008,1042,933,727,500,306,165,79,46,45,33,-21,-111,-193,-238,-256,-282,-345,-442,-547,-629,-660,-628,-547,-453,-379,-339,-324,-316,-303,-283,-257,-226,-199,-183,-177,-166,-137,-83,-8,77,153,192,180,130,81,64,72,67,22,-59,-146,-208,-229,-205,-151,-104,-103,-159,-237,-293,-310,-307,-308,-318,-327,-325,-303,-257,-187,-110,-56,-47,-77,-121,-153,-162,-148,-120,-90,-67,-51,-33,-8,20,45,58,56,36,-1,-43,-76,-92,-95,-95,-88,-72,-48,-29,-22,-23,-29,-39,-59,-85,-107,-114,-107,-88,-61,-28,4,24,20,-6,-48,-95,-142,-185,-219,-236,-230,-207,-179,-162,-160,-168,-179,-191,-207,-228,-251,-269,-278,-272,-249,-211,-164,-121,-88,-67,-53,-44,-40,-43,-52,-63,-68,-63,-47,-26,-5,16,35,47,46,29,9}
        },
        {    // H10e165a.wav
            {-2,-3,-1,1,1,-2,-3,-1,-1,-4,-5,-1,2,-1,-4,0,6,3,-6,-6,6,10,-7,-21,-8,16,11,-21,-26,13,37,-4,-49,-7,73,53,16,416,1664,3453,4645,4096,1719,-1288,-3325,-3548,-2301,-666,325,258,-431,-627,781,3935,7519,9448,8419,5024,1374,-470,97,2043,3679,3831,2410,211,-1725,-2731,-2826,-2581,-2638,-3249,-4130,-4726,-4628,-3832,-2704,-1741,-1305,-1444,-1880,-2150,-1886,-1066,-55,648,788,542,350,530,1039,1555,1774,1621,1231,816,547,507,658,846,881,678,321,-8,-177,-175,-83,-11,-63,-296,-679,-1078,-1343,-1422,-1390,-1350,-1327,-1264,-1106,-860,-574,-294,-46,136,222,222,205,246,360,483,533,484,381,291,253,248,231,159,16,-182,-396,-567,-650,-646,-605,-593,-638,-702,-721,-655,-522,-382,-303,-316,-402,-503,-551,-499,-354,-165,1,102,134,118,83,55,46,60,85,102,91,55,16,1,18,52,74,63,18,-46,-105,-145,-167,-184,-212,-257,-311,-355,-372,-353,-304,-249,-213,-208,-224,-236,-229,-206,-179,-157,-140,-129,-120,-109,-82,-38,9,33,22,-13,-48,-68,-75,-73,-69,-67,-68,-71,-70,-60,-43,-27,-24,-41,-78,-123,-166,-204,-240,-272,-292,-284,-247,-196,-154,-130,-124,-131,-145,-161,-167,-152,-116,-63,1,69,132,170,173,141,86,20,-47,-107,-155,-189,-209,-215,-209,-194,-178,-167,-161,-162,-170,-186,-204,-213,-214,-211,-205,-190,-160,-126,-104,-99,-91,-62,-22},
            {2,-6,-3,11,12,-6,-13,7,23,-1,-36,-22,27,31,-28,-59,6,73,18,-91,-61,91,96,-77,194,1673,4155,6098,5779,2938,-850,-3502,-4029,-2919,-1342,-304,-289,-1058,-1486,-29,3912,8898,12100,11532,7779,3488,1154,1370,2928,4157,4046,2510,128,-2201,-3677,-4058,-3804,-3669,-4059,-4786,-5387,-5583,-5402,-4982,-4400,-3697,-2975,-2366,-1911,-1515,-1049,-490,50,441,686,918,1263,1706,2101,2314,2310,2123,1784,1340,908,641,598,677,707,593,358,73,-212,-456,-621,-720,-838,-1076,-1437,-1814,-2089,-2223,-2243,-2169,-1995,-1732,-1432,-1150,-895,-643,-381,-129,79,220,286,287,248,208,195,229,320,471,659,816,867,784,607,411,253,148,94,75,71,57,22,-20,-50,-71,-105,-174,-279,-407,-541,-656,-719,-706,-624,-514,-426,-378,-359,-351,-347,-342,-329,-298,-253,-210,-180,-159,-130,-78,0,89,166,204,191,143,93,70,71,67,32,-38,-120,-188,-222,-216,-186,-157,-154,-184,-230,-271,-292,-295,-291,-289,-293,-298,-287,-245,-172,-94,-42,-38,-73,-126,-173,-202,-207,-190,-157,-115,-67,-17,32,70,88,79,50,7,-38,-74,-95,-102,-100,-93,-78,-53,-23,-3,-1,-16,-41,-68,-96,-121,-136,-139,-130,-111,-81,-44,-7,16,18,-1,-32,-67,-105,-143,-176,-202,-216,-222,-221,-217,-213,-209,-209,-214,-228,-250,-274,-288,-287,-272,-245,-205,-155,-103,-60,-32,-17,-11,-15,-33,-58,-74,-71,-54,-34,-13,17,51,68,55,21}
        },
        {    // H10e170a.wav
            {-4,-1,1,-1,-2,-2,-2,-5,-5,-1,2,-1,-4,1,7,2,-8,-5,9,10,-11,-25,-7,19,9,-27,-28,18,38,-12,-56,-4,79,46,28,538,1975,3911,5059,4243,1509,-1748,-3809,-3859,-2376,-589,393,209,-541,-570,1249,4842,8579,10222,8620,4712,895,-737,208,2426,4057,3948,2176,-267,-2229,-3087,-3005,-2679,-2780,-3489,-4441,-5051,-4925,-4083,-2900,-1876,-1389,-1506,-1949,-2228,-1945,-1070,12,773,945,710,514,676,1153,1639,1847,1696,1297,845,529,468,642,873,937,728,335,-49,-278,-325,-245,-140,-125,-294,-643,-1051,-1363,-1516,-1561,-1571,-1548,-1433,-1203,-916,-667,-501,-387,-261,-88,118,311,454,543,595,627,641,639,626,612,585,520,393,206,-15,-239,-435,-578,-653,-671,-668,-669,-670,-646,-592,-531,-496,-495,-511,-529,-544,-543,-504,-411,-284,-163,-81,-35,0,41,78,96,89,66,43,31,33,51,81,114,144,157,142,94,20,-54,-105,-126,-136,-159,-210,-281,-348,-386,-384,-341,-278,-224,-201,-212,-238,-255,-252,-233,-207,-185,-170,-160,-147,-123,-85,-41,-8,1,-12,-34,-49,-52,-48,-44,-45,-49,-50,-46,-35,-20,-8,-6,-22,-59,-112,-166,-210,-238,-251,-249,-233,-203,-166,-137,-125,-132,-151,-173,-188,-190,-170,-127,-65,5,73,130,168,179,159,110,46,-23,-87,-145,-192,-227,-250,-259,-254,-237,-214,-196,-188,-190,-198,-213,-229,-239,-234,-213,-187,-160,-127,-86,-50,-37,-49,-60,-49,-19},
            {-3,3,3,-2,0,9,9,-3,-8,8,19,0,-29,-19,19,25,-20,-46,3,57,18,-68,-50,70,79,-50,187,1461,3688,5632,5722,3449,-100,-3089,-4274,-3619,-1987,-505,-12,-554,-1091,-4,3509,8288,11685,11578,8134,3656,729,426,1974,3718,4279,3158,769,-1865,-3683,-4209,-3819,-3386,-3568,-4365,-5263,-5726,-5550,-4872,-3971,-3106,-2457,-2092,-1932,-1757,-1342,-645,121,653,840,863,1017,1424,1934,2290,2334,2066,1591,1070,697,607,748,887,807,504,157,-83,-224,-352,-488,-591,-671,-834,-1162,-1599,-1984,-2190,-2213,-2116,-1945,-1707,-1410,-1088,-783,-514,-285,-95,50,145,200,232,259,289,323,359,400,447,494,536,574,604,601,524,365,178,53,32,76,104,77,15,-42,-85,-137,-214,-309,-418,-543,-674,-773,-796,-729,-609,-490,-408,-367,-357,-361,-355,-318,-247,-171,-128,-128,-145,-134,-72,30,139,219,247,217,151,89,59,56,49,11,-59,-136,-193,-215,-197,-157,-126,-135,-189,-259,-309,-320,-306,-290,-286,-290,-293,-282,-245,-186,-119,-69,-50,-61,-89,-121,-144,-150,-138,-119,-103,-87,-60,-18,31,66,77,62,25,-24,-73,-109,-124,-121,-107,-84,-57,-30,-14,-10,-21,-43,-77,-117,-152,-172,-174,-159,-126,-78,-23,24,51,58,50,27,-13,-66,-123,-173,-213,-239,-249,-245,-234,-225,-223,-229,-241,-255,-269,-278,-279,-274,-258,-228,-182,-129,-78,-36,-5,9,2,-23,-49,-62,-61,-54,-41,-14,22,46,41,16}
        },
        {    // H10e175a.wav
            {1,-1,-2,-1,-2,-6,-5,0,3,-1,-4,2,8,2,-7,-3,11,9,-14,-25,-2,23,7,-29,-24,25,39,-18,-56,7,81,32,52,703,2332,4360,5389,4278,1239,-2170,-4189,-4071,-2409,-523,431,140,-644,-478,1758,5750,9561,10852,8690,4379,531,-831,441,2818,4363,3979,1882,-778,-2754,-3450,-3169,-2752,-2899,-3709,-4718,-5319,-5166,-4320,-3143,-2096,-1538,-1564,-1932,-2176,-1896,-1051,-7,736,939,794,710,942,1401,1799,1918,1735,1354,913,559,431,568,828,954,784,376,-58,-334,-403,-331,-233,-229,-409,-763,-1172,-1483,-1630,-1658,-1641,-1587,-1460,-1255,-1026,-827,-663,-498,-311,-124,36,165,287,418,550,655,712,726,726,735,747,721,615,422,177,-72,-281,-422,-483,-475,-437,-420,-455,-525,-584,-599,-577,-551,-554,-590,-634,-653,-622,-538,-417,-290,-185,-114,-73,-53,-42,-31,-16,3,19,27,29,39,68,121,183,228,230,176,86,0,-48,-57,-57,-85,-153,-245,-330,-381,-379,-330,-260,-207,-198,-226,-260,-271,-258,-236,-225,-230,-242,-248,-229,-178,-106,-39,-3,-3,-27,-53,-65,-58,-38,-22,-18,-28,-38,-35,-17,6,20,12,-23,-81,-144,-191,-209,-201,-182,-165,-150,-135,-122,-113,-112,-119,-136,-163,-193,-209,-197,-151,-81,-3,68,120,145,146,126,92,47,-7,-67,-130,-188,-235,-264,-272,-266,-255,-243,-230,-219,-215,-222,-234,-241,-241,-234,-217,-186,-142,-98,-66,-45,-30,-23,-30,-48,-58,-45,-17},
            {-2,-6,-4,2,2,-2,-1,7,9,-2,-8,3,15,3,-23,-22,9,22,-10,-38,-6,43,24,-48,-50,45,76,-18,146,1192,3205,5213,5704,3887,466,-2821,-4451,-4024,-2283,-509,242,-211,-880,-140,2954,7524,11126,11510,8425,3845,445,-271,1284,3435,4484,3630,1218,-1593,-3561,-4111,-3632,-3089,-3242,-4124,-5157,-5698,-5483,-4672,-3627,-2694,-2099,-1904,-1957,-1935,-1534,-731,157,722,828,731,822,1261,1855,2260,2272,1923,1398,910,629,617,777,904,833,556,200,-115,-336,-449,-449,-388,-403,-627,-1041,-1474,-1767,-1905,-1981,-2037,-2008,-1814,-1466,-1060,-688,-389,-175,-59,-30,-27,21,137,280,390,447,472,496,526,557,580,587,563,498,394,278,180,117,79,40,-15,-83,-149,-200,-231,-253,-287,-360,-484,-636,-766,-819,-783,-691,-590,-511,-451,-395,-337,-279,-224,-169,-118,-87,-85,-106,-121,-99,-29,74,178,247,259,216,141,71,32,23,21,-4,-62,-139,-210,-244,-231,-185,-140,-129,-168,-240,-311,-353,-358,-342,-325,-318,-314,-292,-239,-160,-80,-27,-12,-29,-63,-95,-111,-105,-84,-65,-62,-71,-76,-64,-36,-3,23,33,23,-6,-46,-84,-111,-126,-132,-127,-109,-82,-57,-43,-45,-62,-92,-130,-168,-192,-194,-171,-124,-60,12,74,111,115,89,44,-11,-69,-127,-177,-214,-237,-248,-248,-244,-237,-233,-234,-241,-254,-270,-283,-286,-277,-253,-215,-164,-108,-59,-26,-11,-10,-16,-26,-37,-46,-48,-41,-28,-14,-4,0}
        },
        {    // H10e180a.wav
            {-3,-1,-3,-6,-5,1,3,-2,-3,3,8,0,-9,-2,12,7,-17,-25,0,20,-2,-34,-18,31,31,-32,-55,21,76,9,92,922,2739,4793,5611,4174,903,-2534,-4430,-4161,-2402,-502,387,8,-752,-329,2334,6652,10419,11293,8638,4097,374,-698,773,3144,4521,3903,1579,-1238,-3242,-3829,-3386,-2871,-3039,-3929,-4979,-5545,-5340,-4500,-3388,-2394,-1808,-1716,-1929,-2045,-1708,-889,60,690,834,735,786,1165,1699,2065,2074,1774,1334,915,630,545,646,808,854,682,332,-60,-356,-479,-433,-312,-274,-457,-863,-1332,-1672,-1801,-1795,-1767,-1747,-1671,-1466,-1137,-767,-453,-247,-141,-95,-61,-3,99,247,420,572,665,692,685,682,691,686,626,489,291,82,-74,-133,-112,-80,-113,-226,-366,-460,-482,-461,-444,-458,-512,-604,-716,-803,-806,-701,-527,-365,-270,-242,-237,-217,-171,-107,-43,-1,3,-29,-65,-62,-2,97,189,241,244,207,145,79,27,0,-15,-45,-110,-199,-278,-312,-292,-241,-199,-191,-220,-264,-299,-313,-310,-301,-293,-287,-282,-268,-232,-170,-97,-38,-10,-15,-39,-66,-85,-89,-77,-60,-49,-47,-45,-30,-4,18,22,3,-30,-68,-103,-131,-149,-158,-159,-153,-137,-111,-87,-75,-81,-102,-130,-158,-181,-192,-182,-148,-94,-31,30,78,107,113,97,66,22,-31,-90,-150,-201,-238,-258,-264,-261,-253,-244,-239,-240,-246,-256,-267,-273,-268,-248,-216,-172,-123,-74,-34,-13,-12,-23,-38,-50,-58,-59,-50,-31,-10},
            {-3,-1,-3,-6,-5,1,3,-2,-3,3,8,0,-9,-2,12,7,-17,-25,0,20,-2,-34,-18,31,31,-32,-55,21,76,9,92,922,2739,4793,5611,4174,903,-2534,-4430,-4161,-2402,-502,387,8,-752,-329,2334,6652,10419,11293,8638,4097,374,-698,773,3144,4521,3903,1579,-1238,-3242,-3829,-3386,-2871,-3039,-3929,-4979,-5545,-5340,-4500,-3388,-2394,-1808,-1716,-1929,-2045,-1708,-889,60,690,834,735,786,1165,1699,2065,2074,1774,1334,915,630,545,646,808,854,682,332,-60,-356,-479,-433,-312,-274,-457,-863,-1332,-1672,-1801,-1795,-1767,-1747,-1671,-1466,-1137,-767,-453,-247,-141,-95,-61,-3,99,247,420,572,665,692,685,682,691,686,626,489,291,82,-74,-133,-112,-80,-113,-226,-366,-460,-482,-461,-444,-458,-512,-604,-716,-803,-806,-701,-527,-365,-270,-242,-237,-217,-171,-107,-43,-1,3,-29,-65,-62,-2,97,189,241,244,207,145,79,27,0,-15,-45,-110,-199,-278,-312,-292,-241,-199,-191,-220,-264,-299,-313,-310,-301,-293,-287,-282,-268,-232,-170,-97,-38,-10,-15,-39,-66,-85,-89,-77,-60,-49,-47,-45,-30,-4,18,22,3,-30,-68,-103,-131,-149,-158,-159,-153,-137,-111,-87,-75,-81,-102,-130,-158,-181,-192,-182,-148,-94,-31,30,78,107,113,97,66,22,-31,-90,-150,-201,-238,-258,-264,-261,-253,-244,-239,-240,-246,-256,-267,-273,-268,-248,-216,-172,-123,-74,-34,-13,-12,-23,-38,-50,-58,-59,-50,-31,-10}
        }
    },
    {    // elev20 
        {    // H20e000a.wav
            {2,-7,-7,4,5,-8,-8,14,25,-1,-25,0,42,23,-42,-48,31,72,-12,-101,-31,113,87,-104,-142,82,190,-28,189,2017,5258,7631,6698,2681,-1364,-2694,-1832,-1649,-3598,-5722,-4968,-952,3432,5216,4499,3984,5801,9316,11945,11560,8001,2885,-1496,-3338,-2268,335,2114,1341,-1884,-5913,-8912,-9991,-9276,-7385,-5092,-3263,-2597,-3100,-3894,-3845,-2570,-804,326,394,27,173,1124,2298,2920,2772,2273,1964,2042,2331,2528,2404,1894,1142,450,72,8,50,58,101,290,535,610,430,177,66,71,-38,-421,-1012,-1627,-2132,-2465,-2559,-2353,-1893,-1369,-1003,-896,-953,-952,-689,-136,512,964,1068,930,795,817,943,1010,910,644,283,-76,-348,-491,-549,-613,-741,-902,-1038,-1130,-1187,-1185,-1067,-827,-559,-394,-379,-456,-535,-577,-593,-593,-563,-477,-333,-157,13,135,180,144,62,-10,-29,7,67,110,118,101,84,84,109,156,209,238,212,119,-18,-150,-242,-290,-316,-343,-377,-409,-426,-421,-397,-359,-313,-270,-242,-241,-263,-284,-280,-245,-196,-143,-82,-4,81,151,188,188,152,79,-19,-109,-160,-162,-135,-101,-68,-38,-16,-6,-7,-17,-40,-88,-157,-225,-264,-266,-238,-198,-161,-138,-129,-123,-111,-99,-107,-141,-184,-211,-208,-178,-128,-63,5,57,83,82,58,10,-59,-130,-177,-189,-178,-161,-141,-116,-87,-58,-38,-33,-52,-91,-132,-149,-137,-117,-101,-79,-32,31,87,117,119,94,35,-47,-110,-125,-115,-127,-170,-194,-148,-53},
            {2,-7,-7,4,5,-8,-8,14,25,-1,-25,0,42,23,-42,-48,31,72,-12,-101,-31,113,87,-104,-142,82,190,-28,189,2017,5258,7631,6698,2681,-1364,-2694,-1832,-1649,-3598,-5722,-4968,-952,3432,5216,4499,3984,5801,9316,11945,11560,8001,2885,-1496,-3338,-2268,335,2114,1341,-1884,-5913,-8912,-9991,-9276,-7385,-5092,-3263,-2597,-3100,-3894,-3845,-2570,-804,326,394,27,173,1124,2298,2920,2772,2273,1964,2042,2331,2528,2404,1894,1142,450,72,8,50,58,101,290,535,610,430,177,66,71,-38,-421,-1012,-1627,-2132,-2465,-2559,-2353,-1893,-1369,-1003,-896,-953,-952,-689,-136,512,964,1068,930,795,817,943,1010,910,644,283,-76,-348,-491,-549,-613,-741,-902,-1038,-1130,-1187,-1185,-1067,-827,-559,-394,-379,-456,-535,-577,-593,-593,-563,-477,-333,-157,13,135,180,144,62,-10,-29,7,67,110,118,101,84,84,109,156,209,238,212,119,-18,-150,-242,-290,-316,-343,-377,-409,-426,-421,-397,-359,-313,-270,-242,-241,-263,-284,-280,-245,-196,-143,-82,-4,81,151,188,188,152,79,-19,-109,-160,-162,-135,-101,-68,-38,-16,-6,-7,-17,-40,-88,-157,-225,-264,-266,-238,-198,-161,-138,-129,-123,-111,-99,-107,-141,-184,-211,-208,-178,-128,-63,5,57,83,82,58,10,-59,-130,-177,-189,-178,-161,-141,-116,-87,-58,-38,-33,-52,-91,-132,-149,-137,-117,-101,-79,-32,31,87,117,119,94,35,-47,-110,-125,-115,-127,-170,-194,-148,-53}
        },
        {    // H20e005a.wav
            {-8,0,2,-4,-4,3,3,-6,-5,13,19,-3,-20,2,33,15,-36,-37,29,57,-15,-84,-21,94,67,-84,-104,77,146,-31,224,1877,4701,6734,5937,2514,-961,-2160,-1468,-1280,-2913,-4876,-4589,-1455,2403,4482,4457,4166,5379,7988,10249,10372,7816,3555,-504,-2541,-1917,310,2028,1552,-1229,-4988,-8050,-9385,-8853,-6953,-4583,-2803,-2363,-3144,-4109,-4067,-2681,-769,462,520,-2,-97,670,1846,2646,2705,2289,1908,1845,2020,2160,2032,1590,1001,529,321,289,242,138,127,320,576,632,416,138,33,78,34,-281,-818,-1399,-1885,-2210,-2320,-2181,-1844,-1452,-1144,-948,-787,-561,-228,176,546,769,803,713,629,629,692,727,661,479,217,-64,-304,-475,-590,-682,-757,-798,-808,-828,-893,-975,-1001,-924,-776,-633,-545,-514,-521,-552,-593,-619,-603,-528,-394,-214,-20,133,195,155,59,-18,-25,28,95,130,122,89,58,48,69,119,175,202,170,75,-53,-170,-251,-296,-319,-332,-339,-342,-342,-337,-323,-293,-254,-220,-206,-215,-238,-252,-242,-210,-166,-123,-79,-30,28,86,133,155,138,79,-9,-98,-158,-181,-174,-145,-99,-45,4,31,32,13,-19,-68,-136,-210,-266,-284,-261,-215,-168,-137,-122,-118,-118,-121,-129,-146,-167,-179,-172,-142,-94,-36,20,63,82,71,34,-21,-81,-135,-173,-187,-179,-160,-144,-136,-125,-102,-74,-59,-67,-90,-111,-115,-103,-82,-57,-32,-3,34,79,116,122,91,38,-15,-63,-114,-160,-168,-121,-43},
            {-12,0,10,-2,-13,5,27,9,-28,-18,36,43,-28,-70,1,84,30,-99,-84,89,147,-46,-194,-9,226,62,-39,1307,4616,7977,8284,4565,-486,-3138,-2668,-1908,-3458,-6179,-6392,-2402,3200,6273,5602,3960,4841,8747,12849,13754,10294,4104,-1723,-4535,-3554,-293,2368,2101,-1286,-5921,-9453,-10660,-9787,-7802,-5627,-3945,-3208,-3421,-3933,-3784,-2547,-825,264,203,-371,-307,869,2477,3401,3182,2347,1768,1858,2380,2835,2874,2426,1634,780,149,-148,-212,-178,-42,256,609,755,569,247,92,150,145,-207,-906,-1706,-2361,-2743,-2800,-2527,-2030,-1536,-1260,-1230,-1272,-1155,-759,-151,460,864,992,961,954,1041,1129,1092,908,649,381,115,-143,-358,-518,-671,-872,-1105,-1289,-1365,-1327,-1181,-920,-576,-270,-146,-236,-418,-541,-555,-522,-511,-514,-470,-340,-145,52,180,198,114,-14,-106,-121,-72,-7,36,54,65,83,113,152,197,236,247,209,124,18,-79,-153,-216,-284,-356,-418,-456,-464,-448,-413,-362,-302,-247,-218,-229,-269,-307,-311,-271,-205,-138,-78,-18,47,109,150,157,127,64,-21,-102,-152,-161,-139,-104,-71,-45,-31,-29,-35,-41,-49,-73,-122,-185,-236,-256,-244,-211,-169,-129,-103,-91,-89,-93,-107,-138,-182,-221,-233,-213,-164,-93,-10,68,121,134,107,46,-35,-117,-177,-200,-192,-172,-155,-139,-114,-77,-37,-11,-14,-49,-104,-152,-170,-156,-126,-96,-61,-9,55,106,117,83,22,-45,-101,-137,-148,-144,-143,-159,-175,-161,-106,-36}
        },
        {    // H20e010a.wav
            {2,-5,-5,-1,-1,-4,-2,3,1,-6,-2,13,15,-4,-14,6,27,6,-31,-22,31,41,-24,-66,-1,83,42,-77,-67,79,99,-28,347,1962,4430,5991,5055,2042,-788,-1644,-1084,-1167,-2812,-4539,-4120,-1177,2330,4192,4157,3887,4993,7389,9457,9501,7050,3145,-349,-1859,-1074,839,2019,1188,-1544,-4935,-7540,-8502,-7774,-5940,-3936,-2698,-2674,-3476,-4082,-3618,-2104,-448,375,189,-287,-180,718,1851,2509,2463,2042,1708,1661,1781,1835,1679,1327,924,629,491,418,314,220,263,453,599,509,232,26,53,178,120,-252,-820,-1370,-1775,-2008,-2058,-1928,-1677,-1410,-1183,-946,-604,-137,349,687,764,600,353,207,247,400,517,510,398,242,62,-149,-373,-556,-663,-705,-718,-719,-712,-709,-727,-758,-773,-757,-731,-715,-696,-642,-559,-500,-509,-571,-612,-567,-424,-226,-34,102,152,118,37,-33,-47,0,68,106,91,43,3,3,45,103,143,138,85,-3,-97,-176,-232,-270,-293,-302,-298,-284,-265,-241,-209,-173,-146,-140,-159,-194,-228,-240,-221,-181,-138,-108,-86,-60,-21,25,62,75,55,7,-53,-107,-144,-160,-157,-131,-87,-40,-9,2,3,-1,-17,-62,-130,-199,-243,-258,-251,-226,-187,-146,-117,-107,-108,-110,-116,-130,-148,-155,-144,-116,-76,-26,26,65,79,63,23,-34,-99,-157,-193,-203,-199,-192,-184,-167,-140,-110,-82,-60,-50,-60,-83,-98,-90,-65,-40,-18,11,51,89,107,104,86,46,-20,-94,-131,-103,-38},
            {10,1,-14,-1,31,25,-21,-34,21,59,0,-77,-37,78,76,-70,-130,33,181,41,-201,-117,209,188,-124,610,3599,7701,9567,6908,1355,-2903,-3599,-2674,-3466,-6193,-7432,-4311,1751,6354,6869,5060,4831,8003,12622,14981,12770,6622,-509,-5175,-5426,-2053,1821,2874,-30,-5213,-9767,-11740,-11035,-8734,-6066,-3969,-3060,-3416,-4290,-4437,-3121,-908,739,815,-217,-862,-52,1851,3478,3792,2945,1925,1580,2012,2735,3169,2993,2241,1242,408,-54,-242,-337,-321,-34,489,901,875,497,176,162,265,84,-559,-1490,-2385,-2984,-3159,-2916,-2436,-2002,-1785,-1701,-1511,-1092,-535,-13,394,705,935,1075,1133,1151,1146,1085,935,717,479,237,-22,-300,-587,-881,-1183,-1446,-1572,-1490,-1225,-879,-550,-288,-120,-75,-155,-299,-418,-463,-452,-430,-415,-384,-304,-163,18,186,268,216,47,-144,-253,-236,-142,-53,-12,-1,18,61,122,188,248,283,265,183,61,-59,-156,-235,-310,-377,-425,-450,-451,-431,-383,-316,-248,-202,-191,-212,-250,-279,-270,-217,-145,-87,-55,-32,3,50,88,103,86,38,-39,-123,-181,-198,-187,-168,-145,-109,-64,-29,-16,-19,-26,-46,-94,-161,-217,-238,-225,-190,-145,-99,-68,-63,-79,-101,-122,-153,-199,-240,-250,-217,-150,-67,20,99,153,173,155,104,26,-69,-159,-216,-231,-215,-189,-161,-127,-86,-46,-20,-20,-46,-90,-135,-163,-167,-150,-119,-73,-12,57,110,126,99,36,-42,-112,-159,-177,-178,-178,-181,-176,-148,-100,-49,-14,0}
        },
        {    // H20e015a.wav
            {-3,2,1,-3,-4,-2,-2,-4,-2,2,1,-4,-1,10,11,-4,-11,6,21,2,-27,-17,26,30,-24,-53,4,70,29,-66,-51,69,76,-13,375,1837,3979,5288,4467,1932,-423,-1191,-916,-1262,-2807,-4163,-3520,-790,2200,3641,3550,3500,4777,7054,8762,8517,6176,2842,94,-951,-261,1113,1722,683,-1777,-4584,-6597,-7233,-6593,-5229,-3845,-3030,-2989,-3392,-3558,-2979,-1766,-580,-42,-166,-373,-68,796,1720,2179,2079,1744,1527,1524,1591,1565,1399,1158,936,787,699,612,490,375,332,358,363,288,192,181,250,249,36,-377,-848,-1243,-1517,-1671,-1703,-1622,-1477,-1314,-1111,-798,-352,139,520,667,557,281,2,-130,-63,120,275,312,235,89,-98,-310,-504,-620,-643,-619,-607,-620,-628,-613,-588,-573,-570,-573,-580,-594,-607,-602,-578,-554,-548,-553,-546,-503,-415,-288,-145,-28,29,21,-19,-42,-33,-9,-3,-24,-55,-70,-54,-12,41,85,107,99,58,-7,-83,-152,-200,-222,-224,-215,-203,-188,-168,-145,-123,-105,-94,-96,-115,-151,-189,-213,-213,-195,-169,-140,-111,-81,-57,-41,-33,-32,-39,-59,-88,-116,-131,-133,-125,-111,-93,-73,-54,-40,-30,-27,-36,-62,-107,-161,-207,-230,-222,-192,-158,-134,-117,-101,-85,-76,-84,-103,-124,-134,-132,-117,-88,-45,1,35,47,38,12,-31,-89,-152,-205,-229,-222,-200,-180,-169,-155,-126,-87,-60,-57,-72,-85,-85,-76,-61,-37,-3,32,59,80,100,108,84,27,-29,-45,-22},
            {-9,-9,22,34,-6,-40,-1,60,31,-64,-72,45,104,-18,-145,-42,167,127,-151,-209,119,286,-57,96,2397,6724,10105,9202,4047,-1576,-4084,-3829,-4027,-6189,-7893,-5788,-40,5403,7096,5777,5239,8020,12801,15855,14424,8692,1321,-4322,-5973,-3670,178,2263,649,-3928,-8880,-11851,-12119,-10375,-7700,-5004,-3077,-2525,-3255,-4203,-4009,-2263,-12,1184,788,-194,-279,989,2682,3545,3214,2356,1838,1969,2493,2983,3112,2718,1869,894,171,-189,-351,-427,-277,222,827,1069,785,340,202,379,404,-123,-1125,-2181,-2942,-3334,-3438,-3323,-3004,-2501,-1879,-1248,-732,-391,-156,127,535,968,1242,1279,1166,1040,963,918,864,757,532,138,-397,-963,-1441,-1749,-1824,-1623,-1190,-703,-370,-263,-268,-238,-151,-98,-143,-240,-300,-301,-294,-316,-343,-315,-201,-23,162,286,291,165,-31,-198,-270,-255,-212,-182,-157,-106,-25,64,142,211,269,296,255,132,-42,-212,-333,-391,-406,-405,-404,-396,-367,-316,-262,-223,-200,-182,-171,-177,-194,-194,-156,-98,-59,-52,-48,-15,39,82,91,70,22,-60,-167,-265,-313,-307,-270,-223,-169,-109,-57,-30,-24,-26,-34,-64,-118,-175,-207,-206,-181,-143,-102,-70,-59,-71,-94,-120,-155,-200,-237,-246,-216,-154,-71,26,124,203,242,232,175,78,-44,-163,-246,-276,-263,-230,-191,-145,-95,-49,-25,-31,-65,-115,-160,-183,-179,-160,-136,-100,-42,35,105,138,122,64,-17,-100,-163,-195,-205,-210,-216,-209,-171,-108,-44,-4,7,4,0}
        },
        {    // H20e020a.wav
            {-5,-6,-1,3,1,-4,-3,1,0,-3,-2,2,1,-4,-1,10,12,-2,-10,3,17,5,-20,-14,20,25,-17,-41,5,57,24,-53,-39,60,65,-5,333,1590,3455,4668,4113,2056,-7,-905,-975,-1425,-2645,-3559,-2859,-600,1760,2919,3031,3333,4673,6611,7872,7492,5517,2876,744,-108,279,1097,1289,272,-1704,-3830,-5346,-5941,-5722,-4981,-4056,-3296,-2942,-2944,-2944,-2562,-1765,-919,-433,-350,-315,42,724,1391,1727,1717,1573,1470,1418,1356,1279,1223,1195,1153,1063,919,723,483,258,145,186,301,361,324,259,227,182,22,-282,-643,-942,-1132,-1236,-1300,-1340,-1346,-1283,-1102,-775,-343,74,339,377,215,-39,-260,-355,-299,-131,71,214,216,41,-259,-551,-695,-656,-525,-431,-424,-467,-500,-508,-498,-466,-403,-332,-312,-369,-469,-548,-577,-572,-563,-555,-537,-500,-446,-370,-274,-176,-111,-97,-115,-125,-104,-74,-69,-102,-149,-166,-130,-54,31,99,138,145,115,47,-40,-114,-151,-152,-136,-123,-116,-108,-95,-78,-64,-57,-62,-80,-108,-138,-165,-183,-192,-192,-187,-178,-166,-150,-131,-113,-100,-89,-83,-85,-101,-129,-156,-167,-158,-135,-107,-81,-57,-37,-25,-27,-45,-75,-110,-142,-162,-166,-153,-130,-109,-99,-97,-95,-86,-74,-70,-83,-105,-124,-133,-126,-105,-71,-32,3,22,20,-2,-41,-91,-143,-183,-206,-214,-213,-206,-193,-169,-136,-101,-74,-63,-67,-77,-78,-61,-32,-4,16,30,48,71,91,93,74,41,11},
            {4,36,16,-35,-26,44,58,-32,-91,-4,107,42,-124,-110,111,190,-56,-255,-19,308,99,-178,1192,5096,9548,10831,7247,1191,-3288,-4724,-5142,-6632,-8163,-6816,-1829,3838,6550,5977,5312,7624,12554,16650,16479,11334,3554,-3142,-5905,-4383,-846,1395,318,-3566,-8010,-10982,-11876,-11181,-9513,-7231,-4791,-2965,-2361,-2751,-3116,-2553,-1159,105,472,212,294,1257,2578,3251,2892,2079,1664,1945,2573,3061,3164,2847,2167,1310,563,91,-192,-411,-450,-82,605,1118,1056,591,284,414,650,432,-442,-1693,-2898,-3795,-4267,-4225,-3652,-2724,-1770,-1068,-683,-487,-296,5,411,811,1075,1155,1109,1040,1010,1015,1010,922,659,154,-559,-1315,-1888,-2095,-1878,-1334,-695,-236,-115,-260,-430,-427,-252,-57,34,22,-30,-100,-212,-358,-462,-436,-266,-15,222,372,395,292,110,-74,-201,-268,-307,-330,-306,-214,-92,-2,37,76,159,253,271,163,-31,-224,-357,-425,-445,-427,-382,-330,-286,-247,-206,-168,-143,-133,-129,-127,-131,-135,-119,-78,-33,-15,-21,-19,17,70,106,97,37,-68,-198,-316,-383,-393,-367,-324,-264,-185,-107,-60,-50,-50,-44,-46,-75,-127,-172,-192,-191,-178,-151,-112,-73,-56,-64,-86,-111,-142,-176,-199,-194,-153,-84,9,117,222,294,306,249,133,-16,-162,-266,-307,-292,-251,-208,-170,-127,-81,-44,-35,-57,-100,-148,-186,-206,-206,-183,-138,-71,12,93,146,147,97,13,-76,-151,-201,-228,-236,-230,-211,-175,-116,-42,17,32,3,-35,-44,-21}
        },
        {    // H20e025a.wav
            {-3,-2,-4,-5,-2,0,0,-3,-3,-1,-2,-4,-2,1,0,-3,-1,8,9,-3,-10,1,15,5,-17,-15,13,22,-9,-33,-2,42,22,-37,-31,46,53,-8,248,1275,2898,4111,3892,2265,356,-754,-1079,-1448,-2266,-2890,-2386,-709,1163,2287,2702,3225,4424,5962,6928,6641,5150,3118,1389,527,545,917,928,160,-1266,-2866,-4177,-4969,-5196,-4884,-4158,-3305,-2685,-2469,-2485,-2371,-1917,-1253,-695,-409,-266,-9,464,1010,1405,1547,1495,1366,1246,1183,1200,1269,1317,1274,1131,919,657,365,114,20,128,334,467,453,370,320,296,204,-5,-276,-524,-733,-951,-1205,-1439,-1550,-1459,-1157,-724,-305,-45,-14,-160,-352,-469,-465,-363,-212,-58,57,89,2,-197,-439,-617,-649,-538,-373,-256,-234,-282,-346,-389,-392,-353,-278,-196,-147,-166,-254,-386,-522,-627,-675,-663,-612,-546,-479,-411,-346,-299,-279,-273,-258,-221,-176,-147,-144,-162,-179,-172,-127,-48,45,126,171,174,140,82,20,-28,-54,-63,-63,-60,-54,-49,-48,-51,-54,-54,-57,-71,-97,-128,-157,-182,-202,-218,-226,-226,-217,-197,-173,-148,-131,-123,-125,-138,-158,-179,-191,-187,-168,-141,-107,-71,-41,-26,-27,-37,-47,-59,-79,-102,-117,-115,-102,-89,-84,-83,-82,-78,-72,-70,-73,-85,-103,-119,-127,-123,-108,-86,-61,-39,-25,-24,-38,-66,-104,-143,-171,-185,-192,-201,-211,-209,-187,-149,-106,-67,-41,-31,-37,-48,-50,-38,-21,-9,3,26,56,71,56,20},
            {36,-20,-46,14,71,14,-85,-57,77,96,-66,-156,14,206,73,-224,-173,221,275,-172,218,3079,7838,11227,10165,5018,-768,-4362,-6043,-7559,-8871,-7864,-3465,2154,5481,5538,4953,6962,11842,16581,17660,13848,6788,-311,-4518,-4679,-2066,395,177,-3006,-7256,-10349,-11478,-11261,-10459,-9131,-7074,-4679,-2901,-2313,-2421,-2178,-1141,43,449,37,-199,651,2329,3619,3608,2568,1552,1331,1861,2625,3168,3248,2768,1841,836,145,-159,-289,-345,-152,399,994,1145,783,409,507,940,1040,276,-1280,-3066,-4448,-5010,-4661,-3657,-2504,-1661,-1239,-1003,-693,-289,60,275,434,631,848,999,1057,1073,1090,1063,891,488,-138,-856,-1451,-1730,-1635,-1275,-836,-479,-284,-266,-370,-485,-483,-314,-51,167,244,171,-8,-242,-472,-613,-586,-381,-69,241,463,549,483,289,42,-162,-267,-294,-293,-288,-264,-209,-139,-77,-18,51,116,137,88,-21,-159,-302,-420,-479,-454,-374,-294,-244,-206,-152,-95,-65,-64,-65,-55,-55,-79,-101,-89,-53,-35,-47,-48,-2,73,125,124,69,-28,-161,-304,-409,-444,-424,-389,-350,-290,-204,-116,-56,-26,-19,-39,-94,-169,-228,-245,-228,-197,-163,-124,-83,-53,-38,-36,-49,-80,-124,-158,-161,-128,-67,17,120,224,294,307,260,165,34,-111,-234,-303,-314,-292,-265,-231,-179,-110,-45,-15,-28,-75,-134,-187,-222,-236,-226,-189,-123,-32,65,139,165,135,57,-45,-139,-206,-242,-258,-256,-232,-181,-113,-44,11,45,46,12,-38,-68,-57,-20}
        },
        {    // H20e030a.wav
            {-4,-5,-2,0,-2,-4,-2,1,1,-1,-2,0,-1,-2,-2,2,2,-1,0,6,8,-1,-8,1,14,9,-11,-14,11,24,0,-28,-11,34,33,-17,-32,22,46,1,161,947,2342,3587,3705,2464,674,-604,-1081,-1317,-1825,-2335,-2128,-954,617,1811,2458,3038,4008,5234,6094,6035,4991,3385,1855,908,665,815,828,317,-728,-2028,-3260,-4206,-4715,-4667,-4069,-3179,-2428,-2123,-2197,-2281,-2046,-1491,-895,-511,-331,-135,250,777,1245,1481,1458,1278,1090,1013,1087,1249,1363,1319,1101,780,446,179,53,118,333,559,664,645,611,632,639,504,195,-186,-526,-805,-1073,-1341,-1542,-1589,-1450,-1166,-833,-560,-437,-479,-604,-682,-629,-459,-248,-75,22,24,-69,-234,-412,-528,-532,-427,-266,-124,-60,-90,-181,-276,-325,-307,-227,-118,-25,3,-59,-197,-370,-532,-651,-714,-719,-672,-595,-517,-459,-427,-413,-404,-390,-364,-319,-261,-206,-172,-159,-148,-121,-72,-10,52,109,157,185,179,143,95,59,41,33,25,11,-8,-32,-61,-86,-96,-88,-72,-65,-78,-111,-153,-193,-221,-238,-245,-245,-239,-226,-209,-190,-175,-165,-164,-171,-183,-190,-185,-169,-147,-123,-98,-71,-49,-33,-23,-12,-4,-7,-26,-55,-82,-95,-93,-82,-67,-53,-43,-40,-42,-49,-62,-82,-106,-129,-146,-151,-142,-121,-92,-64,-44,-39,-50,-75,-106,-135,-159,-173,-180,-179,-173,-159,-138,-110,-76,-47,-33,-39,-54,-64,-61,-49,-33,-17,-2,9,11,5},
            {-35,-7,54,41,-55,-90,17,109,15,-144,-93,137,176,-98,-262,22,328,48,-245,1206,5242,9942,11776,8984,3289,-2128,-5790,-8304,-9971,-9416,-5460,362,4518,5125,4169,5407,10245,16107,18805,16155,9452,2152,-2525,-3356,-1542,249,-230,-3209,-6959,-9514,-10369,-10460,-10682,-10752,-9679,-7170,-4241,-2339,-1948,-2210,-1920,-777,444,912,721,721,1467,2572,3199,3019,2453,2075,2030,2141,2308,2543,2705,2485,1770,831,43,-448,-646,-456,208,1051,1451,1111,505,417,986,1416,763,-1077,-3245,-4698,-4997,-4409,-3480,-2614,-1955,-1464,-1045,-655,-332,-137,-43,70,301,616,889,1021,1011,902,710,396,-59,-582,-991,-1099,-880,-531,-335,-416,-639,-764,-677,-467,-277,-151,-44,62,123,92,-14,-153,-309,-479,-622,-651,-510,-228,107,397,574,590,442,199,-18,-126,-149,-177,-256,-335,-337,-249,-132,-52,-11,19,38,11,-84,-219,-341,-408,-412,-369,-311,-271,-262,-253,-203,-101,12,83,94,65,16,-39,-93,-127,-134,-125,-111,-85,-29,46,108,129,105,35,-81,-231,-373,-455,-467,-436,-394,-339,-256,-156,-70,-25,-20,-52,-119,-212,-297,-336,-320,-267,-198,-125,-58,-13,5,2,-9,-30,-67,-110,-131,-115,-64,9,96,191,270,306,281,202,85,-54,-189,-290,-337,-336,-314,-282,-233,-160,-76,-15,1,-31,-95,-169,-229,-260,-259,-230,-172,-85,22,119,169,159,99,11,-87,-180,-250,-285,-287,-263,-217,-146,-62,11,53,61,48,17,-28,-73,-92,-71,-26}
        },
        {    // H20e035a.wav
            {-2,-2,-3,-4,-3,-2,-2,-4,-3,-1,-1,-3,-3,-2,-1,-3,-3,0,1,-1,-3,0,3,-2,-9,-4,9,9,-6,-14,2,18,3,-24,-17,23,33,-11,-41,1,45,16,83,630,1794,3047,3473,2616,994,-379,-974,-1135,-1447,-1923,-1981,-1194,163,1408,2184,2743,3520,4557,5412,5566,4849,3543,2173,1207,818,830,846,519,-255,-1335,-2492,-3509,-4184,-4329,-3888,-3065,-2283,-1912,-1988,-2188,-2128,-1690,-1087,-615,-356,-138,229,727,1148,1302,1191,987,868,906,1054,1203,1250,1145,918,657,447,330,322,431,637,867,1015,1018,891,691,456,194,-77,-324,-544,-786,-1098,-1451,-1729,-1803,-1631,-1289,-935,-718,-695,-796,-876,-819,-617,-356,-134,-6,17,-62,-214,-369,-445,-404,-276,-133,-29,15,0,-65,-152,-216,-225,-181,-119,-70,-44,-46,-90,-191,-342,-504,-633,-703,-717,-689,-640,-587,-546,-523,-510,-493,-461,-412,-357,-303,-254,-209,-162,-114,-66,-21,19,58,99,143,181,202,200,179,148,115,80,41,-3,-49,-92,-123,-133,-123,-100,-79,-69,-76,-103,-147,-201,-250,-280,-290,-287,-278,-266,-249,-226,-202,-182,-172,-172,-178,-183,-181,-170,-151,-125,-97,-71,-49,-30,-13,1,7,2,-13,-31,-48,-62,-69,-67,-56,-46,-45,-53,-61,-67,-80,-106,-143,-174,-188,-183,-164,-139,-111,-85,-65,-57,-64,-81,-101,-120,-137,-150,-155,-151,-140,-129,-122,-116,-101,-80,-65,-64,-70,-71,-64,-60,-61,-59,-43,-15},
            {9,55,9,-77,-54,66,86,-59,-145,8,190,74,-208,-177,197,274,-178,13,2506,7163,11274,11732,7928,2015,-3543,-7850,-10765,-11291,-8159,-2166,3297,5163,4020,3722,7343,13829,18837,18629,13053,5272,-776,-2847,-1411,947,1319,-1476,-6052,-9708,-10812,-10073,-9467,-10017,-10793,-10111,-7487,-4223,-2081,-1606,-1860,-1666,-805,107,669,1191,2080,3060,3388,2815,1992,1755,2212,2764,2906,2697,2424,2126,1669,1090,584,188,-221,-552,-416,348,1248,1568,1212,819,882,1009,352,-1295,-3112,-4089,-4026,-3545,-3246,-3100,-2710,-1926,-1038,-430,-218,-252,-319,-278,-50,356,803,1056,948,515,-47,-542,-870,-980,-814,-366,193,541,430,-88,-677,-988,-914,-595,-224,93,322,411,309,40,-270,-494,-600,-641,-662,-647,-551,-358,-101,169,390,505,483,359,220,131,71,-35,-212,-377,-413,-298,-129,-22,-3,-19,-30,-58,-137,-247,-328,-348,-333,-320,-317,-313,-304,-281,-219,-95,70,202,242,193,101,4,-92,-180,-237,-241,-197,-125,-42,44,115,142,113,34,-73,-192,-303,-383,-419,-419,-396,-349,-272,-176,-91,-43,-37,-65,-126,-215,-309,-371,-379,-345,-284,-203,-103,-4,67,95,88,57,0,-75,-138,-149,-99,-15,73,156,234,294,308,258,151,10,-140,-274,-364,-393,-367,-311,-244,-172,-94,-23,14,-1,-61,-138,-209,-257,-276,-261,-207,-120,-16,81,148,168,138,68,-24,-120,-205,-269,-301,-298,-261,-197,-115,-27,48,88,88,60,24,-18,-68,-115,-130,-97,-35}
        },
        {    // H20e040a.wav
            {1,0,0,0,-2,-3,-1,1,-1,-4,-4,0,2,1,-1,-1,0,-1,-1,2,5,2,-2,0,5,4,-2,-2,8,13,3,-9,-2,14,10,-12,-16,13,31,3,-30,-3,47,29,26,372,1306,2513,3178,2696,1310,-72,-773,-932,-1134,-1587,-1842,-1368,-220,1017,1870,2420,3063,3956,4801,5127,4700,3677,2467,1490,977,879,913,742,181,-732,-1816,-2853,-3627,-3931,-3661,-2953,-2188,-1770,-1817,-2068,-2109,-1735,-1106,-556,-261,-107,126,499,845,970,862,698,667,809,1023,1174,1191,1088,934,813,771,799,852,896,923,922,867,741,566,391,238,84,-113,-370,-680,-1032,-1399,-1708,-1855,-1777,-1512,-1193,-959,-879,-917,-968,-928,-759,-501,-247,-70,7,-4,-79,-189,-288,-317,-249,-115,20,98,99,37,-56,-143,-192,-194,-162,-118,-77,-44,-36,-78,-182,-329,-475,-586,-653,-684,-689,-677,-655,-631,-602,-561,-509,-452,-401,-357,-312,-256,-191,-127,-71,-23,22,62,96,126,157,191,220,228,206,159,103,49,1,-41,-77,-102,-114,-117,-113,-106,-96,-87,-88,-109,-154,-213,-271,-312,-328,-318,-290,-254,-223,-204,-195,-186,-172,-155,-144,-144,-147,-144,-133,-116,-93,-66,-36,-12,1,9,18,28,29,14,-13,-40,-58,-69,-76,-79,-75,-70,-71,-82,-103,-127,-150,-167,-176,-176,-170,-153,-125,-90,-57,-37,-31,-38,-56,-83,-115,-138,-147,-144,-136,-128,-117,-102,-87,-75,-68,-62,-63,-72,-83,-80,-55,-19},
            {49,-39,-92,-7,100,45,-113,-114,88,181,-31,-239,-52,283,134,-298,476,3739,8590,12062,11609,7224,932,-5258,-10197,-12717,-11348,-5950,799,4918,4852,3276,4496,9959,16589,19580,16600,9447,2249,-1624,-1492,726,2063,547,-3497,-7839,-10256,-10357,-9621,-9665,-10562,-10913,-9502,-6668,-3969,-2620,-2420,-2264,-1487,-446,209,516,1141,2389,3644,4014,3364,2435,1985,2085,2368,2630,2899,3032,2657,1664,500,-241,-415,-304,-99,299,904,1376,1363,967,591,328,-204,-1276,-2528,-3273,-3272,-2966,-2883,-3006,-2891,-2281,-1419,-737,-417,-333,-295,-212,-45,232,551,711,502,-78,-786,-1302,-1420,-1118,-506,223,824,1065,844,280,-344,-744,-799,-569,-206,155,424,533,435,151,-205,-494,-653,-730,-804,-875,-860,-689,-389,-68,183,335,409,419,372,281,166,35,-110,-240,-297,-249,-137,-43,-12,-20,-29,-42,-91,-173,-245,-273,-275,-296,-345,-391,-397,-347,-233,-59,141,298,349,284,148,-6,-147,-253,-300,-285,-229,-162,-89,-3,81,126,105,36,-51,-143,-238,-325,-379,-393,-381,-354,-300,-211,-112,-41,-18,-32,-74,-153,-266,-376,-433,-420,-358,-272,-168,-50,61,132,148,117,52,-31,-109,-149,-132,-69,15,103,188,263,305,293,217,84,-81,-243,-364,-420,-415,-369,-300,-215,-118,-28,30,42,5,-68,-157,-238,-287,-291,-251,-174,-75,30,118,166,165,118,42,-46,-136,-222,-291,-326,-313,-252,-159,-61,21,76,101,98,69,24,-32,-90,-137,-154,-129,-74,-20}
        },
        {    // H20e045a.wav
            {1,2,0,-2,-1,0,-1,-3,-3,-1,0,-2,-3,-1,1,1,-2,-3,-1,0,-1,0,2,1,-3,-3,1,3,-1,-3,6,13,5,-10,-10,7,13,-6,-20,0,27,15,-20,-14,31,31,-4,185,888,1978,2795,2662,1581,282,-498,-712,-878,-1317,-1714,-1498,-551,645,1546,2084,2609,3381,4236,4741,4582,3791,2690,1691,1094,946,1025,981,563,-248,-1276,-2289,-3076,-3460,-3341,-2794,-2108,-1646,-1589,-1788,-1892,-1659,-1155,-654,-360,-236,-103,130,383,537,587,639,772,950,1088,1165,1227,1310,1378,1358,1213,971,713,533,490,566,660,646,474,204,-60,-259,-421,-616,-885,-1207,-1502,-1675,-1668,-1510,-1296,-1130,-1056,-1049,-1042,-974,-816,-580,-323,-120,-15,-2,-39,-93,-150,-196,-196,-130,-26,54,65,16,-48,-94,-120,-135,-141,-132,-105,-69,-44,-50,-103,-205,-338,-466,-562,-620,-656,-689,-717,-724,-691,-619,-529,-449,-395,-364,-338,-296,-231,-153,-83,-30,5,33,59,87,115,143,169,185,181,155,112,64,22,-14,-45,-73,-95,-112,-124,-133,-135,-131,-123,-125,-148,-193,-246,-287,-304,-301,-288,-271,-252,-229,-205,-181,-155,-129,-110,-105,-113,-124,-129,-121,-103,-80,-57,-36,-17,0,15,26,29,22,4,-22,-52,-76,-86,-87,-86,-91,-101,-108,-111,-115,-128,-145,-158,-165,-167,-162,-147,-117,-80,-46,-24,-18,-25,-43,-67,-96,-126,-147,-153,-141,-122,-106,-96,-82,-62,-48,-58,-84,-97,-73,-26},
            {-38,-59,16,78,1,-116,-65,117,135,-94,-217,32,281,14,-296,904,4587,9487,12621,11704,6832,-118,-7076,-12267,-13861,-10644,-3769,2915,5666,4447,3192,5870,12293,18097,18804,13737,6224,564,-1080,422,2395,2329,-589,-5085,-8812,-10189,-9641,-9015,-9644,-10974,-11189,-9212,-5933,-3363,-2644,-3093,-3184,-2227,-826,178,772,1534,2620,3455,3534,3138,2948,3123,3167,2749,2258,2276,2716,2848,2174,987,-43,-561,-603,-220,579,1473,1802,1166,-52,-1017,-1297,-1224,-1373,-1899,-2499,-2874,-3002,-2966,-2732,-2237,-1590,-1038,-729,-587,-446,-222,56,323,486,404,-48,-822,-1615,-2013,-1771,-980,-4,766,1126,1103,834,448,44,-274,-396,-285,-23,239,398,434,372,220,-11,-268,-487,-646,-785,-936,-1055,-1052,-881,-583,-244,63,295,420,416,301,141,12,-59,-91,-107,-108,-89,-61,-45,-37,-14,34,74,57,-34,-166,-289,-366,-392,-383,-355,-313,-241,-116,62,246,363,360,239,51,-144,-293,-363,-351,-282,-198,-124,-61,-2,43,60,46,9,-51,-145,-265,-374,-433,-431,-386,-313,-220,-118,-35,10,18,-5,-64,-170,-304,-412,-449,-412,-330,-223,-99,28,121,150,116,49,-22,-83,-124,-133,-103,-41,36,116,196,264,296,266,163,1,-181,-338,-432,-452,-415,-344,-260,-170,-81,-6,38,42,6,-63,-149,-228,-280,-286,-243,-158,-48,59,136,165,148,96,23,-64,-160,-252,-316,-331,-290,-207,-109,-20,45,82,91,81,58,21,-34,-103,-166,-189,-157,-92,-32,-4}
        },
        {    // H20e050a.wav
            {1,1,2,3,2,0,-1,1,0,-2,-3,-2,-2,-3,-3,0,3,2,-1,-1,1,2,1,0,1,0,-2,-3,1,4,1,-2,4,13,9,-7,-12,2,14,2,-16,-5,23,23,-12,-24,14,35,1,78,558,1473,2348,2523,1793,661,-166,-480,-667,-1094,-1572,-1560,-819,288,1197,1732,2187,2884,3758,4408,4462,3860,2861,1866,1216,1028,1131,1173,859,137,-814,-1748,-2472,-2861,-2842,-2454,-1907,-1508,-1449,-1644,-1807,-1704,-1345,-931,-635,-459,-287,-51,212,432,611,805,1033,1250,1397,1466,1473,1410,1250,1009,755,562,446,387,372,389,388,291,74,-184,-370,-452,-515,-662,-910,-1173,-1349,-1396,-1344,-1255,-1183,-1144,-1115,-1053,-931,-756,-561,-382,-237,-132,-68,-39,-38,-63,-114,-174,-208,-188,-121,-47,-2,6,-7,-29,-57,-87,-105,-102,-88,-82,-96,-129,-177,-242,-330,-434,-539,-623,-673,-690,-679,-646,-595,-530,-460,-400,-359,-329,-293,-240,-177,-121,-82,-55,-28,4,39,69,89,100,106,114,122,121,102,62,9,-40,-73,-92,-108,-128,-151,-166,-168,-162,-160,-168,-184,-203,-222,-244,-264,-275,-269,-249,-224,-197,-170,-139,-111,-91,-85,-87,-90,-91,-92,-95,-98,-96,-83,-61,-36,-16,-1,10,16,11,-8,-36,-61,-78,-90,-102,-113,-120,-123,-123,-123,-123,-125,-130,-140,-149,-153,-148,-133,-108,-75,-41,-18,-11,-17,-32,-56,-87,-114,-128,-127,-120,-114,-105,-89,-74,-72,-83,-85,-61,-22},
            {-62,34,86,-9,-121,-54,121,116,-108,-199,54,261,-31,-267,1086,4916,9917,13112,12126,6852,-876,-8589,-13850,-14538,-9948,-2220,4237,6108,4375,3557,7144,13831,18590,17458,11094,3840,-200,-93,2084,3420,2192,-1399,-5678,-8695,-9583,-9150,-9043,-10053,-11234,-10887,-8461,-5292,-3313,-3150,-3699,-3539,-2435,-1231,-516,98,1241,2715,3620,3499,2936,2805,3214,3536,3361,3004,2920,2975,2633,1746,799,309,280,419,612,895,1040,593,-499,-1565,-1826,-1290,-785,-1051,-1964,-2785,-3007,-2761,-2450,-2228,-1958,-1534,-1055,-674,-407,-162,105,314,332,50,-559,-1383,-2134,-2427,-2014,-1003,162,998,1293,1174,900,623,347,72,-105,-69,159,414,527,472,344,224,109,-47,-250,-468,-676,-876,-1060,-1183,-1184,-1034,-754,-403,-64,175,258,198,77,-11,-36,-31,-38,-57,-57,-28,3,12,19,68,165,248,238,106,-97,-287,-402,-427,-381,-295,-200,-103,7,133,247,296,245,111,-55,-204,-312,-367,-367,-323,-257,-186,-109,-25,50,87,73,10,-93,-229,-369,-465,-481,-424,-332,-237,-141,-46,31,65,49,-4,-83,-184,-293,-377,-401,-357,-269,-163,-58,35,99,116,83,15,-63,-127,-160,-158,-127,-72,6,107,211,284,293,228,96,-78,-260,-402,-471,-461,-402,-326,-244,-154,-55,28,69,55,-4,-86,-169,-237,-277,-274,-221,-125,-12,85,141,150,120,63,-15,-108,-200,-272,-306,-295,-239,-155,-66,4,46,65,70,62,36,-9,-70,-138,-194,-208,-165,-84,-10,20,12}
        },
        {    // H20e055a.wav
            {0,1,0,0,0,1,1,-1,-1,0,1,-1,-3,-2,-1,-1,-2,-1,1,1,-1,-2,0,1,-1,-2,-1,0,-1,-4,-2,3,3,1,3,9,8,-5,-13,-3,12,8,-9,-9,14,22,-6,-29,-2,34,14,20,308,1019,1871,2284,1911,1013,198,-214,-452,-870,-1403,-1576,-1066,-94,814,1386,1821,2456,3326,4092,4342,3916,3000,1993,1291,1077,1215,1345,1147,554,-253,-1045,-1689,-2134,-2325,-2230,-1939,-1670,-1618,-1768,-1899,-1784,-1395,-913,-556,-387,-292,-101,257,711,1111,1329,1322,1159,975,891,928,991,957,783,527,285,114,24,8,44,74,25,-116,-280,-376,-401,-443,-586,-812,-1016,-1108,-1090,-1030,-994,-1001,-1022,-1011,-934,-789,-613,-449,-323,-231,-159,-111,-99,-130,-188,-249,-284,-277,-224,-142,-57,7,45,58,42,-7,-77,-137,-161,-152,-136,-139,-171,-226,-296,-370,-435,-479,-506,-528,-554,-576,-573,-533,-465,-393,-338,-306,-288,-271,-242,-196,-143,-99,-75,-62,-48,-21,13,41,59,71,80,84,74,48,12,-26,-63,-96,-127,-152,-168,-176,-178,-176,-172,-170,-174,-184,-196,-205,-209,-210,-212,-213,-207,-192,-170,-144,-118,-90,-67,-55,-59,-72,-85,-96,-108,-120,-124,-112,-83,-51,-26,-11,-2,1,-8,-30,-60,-85,-99,-105,-111,-119,-128,-135,-138,-136,-131,-125,-119,-118,-122,-128,-128,-118,-97,-73,-50,-31,-17,-11,-18,-35,-57,-78,-98,-114,-121,-117,-111,-112,-117,-107,-71,-24},
            {-1,62,15,-87,-60,90,120,-70,-192,10,241,22,-259,878,4547,9760,13528,13023,7652,-781,-9312,-14933,-15327,-10051,-1700,4999,6720,4718,3833,7591,14331,18623,16583,9523,2437,-617,536,3074,4045,2303,-1424,-5443,-8147,-8931,-8612,-8729,-9997,-11400,-11125,-8557,-5148,-3064,-3067,-3950,-4055,-2994,-1661,-836,-285,635,1918,2891,3158,3092,3235,3517,3470,3063,2878,3303,3848,3623,2413,984,278,528,1224,1702,1535,572,-981,-2408,-2805,-1913,-575,-83,-930,-2366,-3241,-3139,-2569,-2176,-2063,-1909,-1517,-1013,-583,-228,134,432,433,-44,-944,-1967,-2706,-2808,-2153,-965,262,1053,1257,1090,882,790,729,572,334,170,190,345,487,527,493,439,355,182,-86,-370,-585,-727,-870,-1059,-1248,-1327,-1211,-907,-511,-166,18,20,-75,-147,-141,-94,-73,-93,-101,-57,18,68,82,115,220,367,457,404,214,-27,-220,-320,-334,-295,-232,-156,-62,53,172,247,237,140,-1,-137,-249,-334,-389,-400,-364,-300,-226,-138,-34,64,113,82,-24,-174,-331,-455,-509,-477,-381,-267,-166,-79,0,62,87,72,27,-40,-130,-232,-317,-347,-312,-232,-137,-47,30,85,107,87,24,-67,-161,-222,-232,-193,-122,-29,79,190,270,284,217,78,-101,-279,-411,-468,-452,-392,-319,-240,-147,-43,49,99,89,25,-75,-182,-266,-301,-278,-205,-101,11,105,156,159,121,56,-29,-130,-227,-294,-307,-268,-193,-107,-29,28,60,72,68,51,15,-41,-108,-170,-211,-213,-165,-76,18,70,63,23}
        },
        {    // H20e060a.wav
            {0,-1,0,0,1,0,0,1,2,1,0,0,0,0,-2,-2,0,0,-1,-1,0,2,1,0,0,1,0,-1,0,1,0,-2,-1,4,7,4,0,3,7,3,-6,-5,6,10,1,-5,6,16,-1,-23,-8,33,32,9,151,652,1407,1967,1915,1291,552,76,-213,-630,-1211,-1566,-1296,-469,444,1077,1518,2106,2967,3817,4209,3909,3064,2085,1393,1200,1403,1660,1621,1152,378,-470,-1228,-1831,-2230,-2360,-2211,-1901,-1626,-1507,-1497,-1433,-1190,-788,-355,-13,214,383,537,653,682,628,559,548,604,669,672,584,425,234,52,-91,-176,-190,-132,-28,64,79,-4,-145,-273,-358,-427,-514,-608,-663,-663,-650,-687,-789,-908,-972,-941,-828,-679,-541,-440,-372,-321,-279,-251,-248,-274,-312,-342,-343,-299,-208,-90,15,73,71,24,-43,-106,-143,-151,-144,-152,-186,-228,-244,-228,-210,-225,-281,-352,-411,-450,-474,-481,-464,-426,-384,-355,-340,-325,-299,-265,-234,-211,-188,-158,-123,-91,-66,-44,-19,3,13,10,7,13,21,13,-21,-70,-112,-135,-144,-148,-154,-160,-164,-169,-177,-182,-177,-160,-140,-133,-144,-164,-178,-178,-169,-159,-145,-121,-91,-68,-61,-66,-70,-73,-82,-101,-121,-128,-119,-101,-85,-69,-51,-33,-22,-23,-35,-51,-69,-87,-104,-120,-132,-138,-137,-132,-127,-120,-108,-94,-90,-97,-107,-111,-108,-104,-99,-83,-52,-17,4,7,2,-7,-27,-60,-91,-106,-112,-128,-149,-148,-104,-36},
            {50,17,-74,-74,64,139,-11,-187,-69,208,125,-234,424,3569,8862,13529,14163,9317,483,-8974,-15457,-16341,-11100,-2291,5208,7566,5504,3908,6981,13652,18346,16559,9323,1981,-976,567,3402,4443,2784,-684,-4498,-7350,-8522,-8383,-8259,-9192,-10665,-10970,-9099,-6032,-3807,-3404,-3924,-3902,-2990,-1992,-1504,-1098,-77,1410,2480,2680,2545,2818,3440,3709,3354,2964,3182,3769,3855,3054,1983,1527,1824,2167,1806,630,-872,-2056,-2460,-1982,-1019,-359,-623,-1680,-2722,-3050,-2730,-2375,-2378,-2512,-2317,-1673,-878,-248,157,398,392,-65,-1016,-2160,-2991,-3106,-2442,-1275,-55,831,1221,1210,1039,909,880,880,818,676,516,408,375,394,444,512,557,500,282,-58,-388,-610,-748,-905,-1131,-1350,-1423,-1276,-960,-611,-352,-232,-213,-223,-217,-204,-219,-262,-287,-248,-149,-33,71,174,307,463,590,616,511,306,80,-87,-163,-171,-154,-135,-102,-36,60,154,205,185,93,-43,-186,-306,-390,-438,-447,-413,-337,-233,-119,-14,60,76,20,-97,-238,-362,-441,-466,-438,-364,-263,-157,-62,21,88,131,139,105,32,-72,-183,-270,-303,-277,-212,-131,-48,33,101,136,116,40,-74,-194,-282,-313,-279,-195,-85,35,149,235,262,212,90,-74,-239,-367,-436,-441,-397,-324,-235,-135,-30,63,117,111,43,-66,-183,-272,-309,-285,-211,-105,7,101,156,166,137,80,-1,-102,-208,-291,-319,-287,-209,-113,-20,51,90,97,86,65,27,-35,-117,-192,-230,-221,-169,-85,12,90,118,88,31}
        },
        {    // H20e065a.wav
            {-1,-1,0,-1,-2,-1,1,0,-1,0,1,1,0,-1,0,-1,-2,-2,-1,0,-2,-4,-2,0,1,-1,-2,-1,-1,-2,-3,-1,0,-2,-2,2,6,3,-2,0,7,6,-5,-12,-1,14,12,-3,-10,-2,0,-11,-5,28,41,10,53,372,995,1620,1820,1466,857,375,58,-361,-998,-1535,-1513,-848,62,781,1276,1852,2689,3566,4044,3872,3187,2370,1785,1600,1733,1910,1813,1277,406,-522,-1254,-1699,-1897,-1914,-1793,-1590,-1380,-1208,-1024,-745,-372,-44,57,-104,-352,-442,-275,23,233,250,141,43,22,48,65,44,-17,-111,-207,-241,-163,8,179,257,216,100,-23,-109,-145,-143,-138,-164,-231,-312,-382,-444,-534,-669,-817,-917,-929,-860,-747,-629,-528,-452,-406,-389,-394,-404,-404,-384,-343,-287,-224,-159,-102,-63,-51,-60,-76,-90,-103,-122,-146,-166,-168,-154,-131,-113,-110,-128,-166,-217,-267,-307,-335,-360,-384,-403,-408,-397,-374,-349,-328,-314,-305,-290,-259,-213,-163,-127,-110,-105,-99,-87,-73,-61,-51,-44,-42,-45,-54,-66,-80,-95,-111,-125,-137,-149,-161,-169,-169,-160,-144,-127,-113,-105,-106,-115,-127,-138,-144,-145,-140,-129,-114,-97,-83,-74,-70,-73,-80,-91,-103,-114,-121,-120,-110,-97,-87,-78,-69,-58,-53,-57,-70,-87,-104,-120,-129,-127,-118,-110,-108,-108,-102,-93,-90,-93,-95,-95,-97,-103,-103,-84,-51,-21,-3,9,17,12,-12,-43,-65,-81,-109,-146,-157,-116,-42},
            {64,-46,-114,-3,150,85,-146,-169,116,235,-116,-47,2164,7097,12674,15119,11790,3230,-7199,-15236,-17565,-13146,-4138,4588,8418,6839,4224,5700,11745,17351,17047,10482,2646,-1169,28,3152,4728,3586,556,-3075,-6250,-8125,-8443,-8034,-8220,-9336,-10175,-9344,-7003,-4800,-4033,-4317,-4305,-3402,-2258,-1641,-1377,-717,526,1709,2252,2363,2617,3082,3290,3052,2879,3296,4007,4134,3346,2387,2235,2880,3232,2294,231,-1801,-2723,-2329,-1210,-192,115,-468,-1633,-2740,-3241,-3094,-2732,-2574,-2612,-2497,-1975,-1137,-286,314,505,161,-765,-2059,-3182,-3555,-2960,-1714,-417,478,892,1014,1047,1071,1089,1114,1162,1192,1119,895,581,317,217,301,488,637,623,402,52,-293,-553,-756,-983,-1247,-1456,-1488,-1306,-996,-697,-505,-423,-388,-344,-293,-285,-348,-445,-503,-476,-370,-212,-12,227,473,667,758,734,612,427,230,80,6,-5,2,5,12,38,77,108,119,103,48,-56,-191,-323,-421,-482,-508,-486,-404,-275,-136,-25,38,42,-17,-126,-249,-348,-410,-439,-436,-388,-292,-174,-63,28,106,171,204,184,109,-7,-134,-238,-283,-259,-189,-109,-36,33,102,149,138,55,-77,-215,-323,-374,-359,-281,-160,-27,93,183,226,205,113,-33,-193,-325,-402,-418,-384,-317,-231,-132,-29,64,120,120,57,-54,-179,-279,-324,-302,-225,-118,-10,81,143,168,155,105,26,-74,-181,-273,-323,-313,-246,-146,-45,35,87,113,119,103,61,-9,-99,-186,-238,-237,-185,-102,-11,65,109,111,74,25}
        },
        {    // H20e070a.wav
            {0,0,-1,0,1,0,-1,0,1,1,1,1,2,3,2,2,1,1,0,0,1,1,0,-1,-1,1,3,3,2,2,1,-1,-1,2,4,2,-1,1,5,5,2,3,9,8,-3,-10,3,23,22,-2,-21,-13,5,7,5,25,44,22,16,199,680,1287,1646,1530,1093,667,352,-73,-774,-1498,-1738,-1254,-334,533,1165,1784,2618,3542,4150,4140,3559,2718,1950,1464,1299,1340,1367,1177,723,118,-478,-971,-1316,-1442,-1278,-869,-428,-212,-316,-603,-839,-902,-843,-777,-751,-731,-683,-630,-606,-598,-556,-465,-372,-330,-324,-294,-202,-75,45,147,237,301,314,285,264,282,306,272,169,56,-6,-14,-15,-54,-144,-292,-498,-737,-941,-1038,-1008,-896,-768,-663,-589,-541,-516,-503,-481,-439,-389,-355,-349,-353,-337,-284,-205,-133,-92,-83,-86,-85,-74,-59,-43,-31,-29,-40,-60,-70,-62,-49,-58,-104,-172,-239,-291,-333,-368,-395,-406,-402,-395,-391,-384,-362,-323,-277,-238,-211,-192,-174,-160,-153,-149,-144,-133,-120,-108,-93,-70,-46,-36,-46,-68,-90,-105,-116,-126,-132,-133,-130,-128,-126,-118,-102,-84,-71,-70,-80,-96,-115,-130,-137,-136,-127,-112,-96,-87,-84,-83,-79,-74,-75,-86,-99,-109,-115,-122,-127,-125,-112,-97,-86,-78,-68,-61,-65,-80,-95,-102,-103,-104,-105,-102,-97,-94,-93,-90,-80,-70,-67,-68,-64,-55,-45,-35,-23,-8,-1,-7,-17,-21,-29,-57,-98,-118,-91,-33},
            {37,-94,-93,77,156,-30,-212,-47,245,94,-265,731,4578,10505,15065,14448,7476,-3384,-13504,-18474,-16077,-7532,2577,8735,8600,5243,4458,8942,15286,17336,12554,4528,-821,-844,2297,4775,4631,2270,-1157,-4725,-7511,-8651,-8227,-7545,-7852,-8874,-9144,-7847,-5847,-4615,-4518,-4627,-4086,-3108,-2387,-1982,-1284,-13,1280,1919,1995,2166,2694,3118,3011,2703,2883,3609,4136,3883,3224,2990,3288,3231,1999,-66,-1711,-2042,-1303,-404,34,-12,-378,-1036,-1934,-2777,-3219,-3239,-3123,-3048,-2842,-2237,-1283,-367,125,54,-539,-1554,-2742,-3607,-3615,-2659,-1233,-55,519,671,779,990,1190,1277,1323,1445,1600,1598,1321,855,415,171,163,327,543,665,583,296,-90,-452,-758,-1044,-1320,-1507,-1510,-1323,-1047,-807,-654,-558,-471,-391,-358,-408,-524,-646,-712,-695,-595,-409,-142,177,479,698,805,809,728,586,420,284,209,182,168,154,146,144,128,91,55,37,19,-42,-160,-299,-416,-499,-551,-560,-502,-372,-208,-66,16,26,-25,-115,-212,-295,-364,-423,-459,-441,-354,-218,-76,46,143,211,241,223,158,56,-65,-175,-239,-235,-179,-105,-33,42,118,168,151,56,-87,-231,-344,-405,-401,-330,-212,-83,28,115,175,192,144,26,-131,-276,-370,-400,-373,-306,-217,-119,-25,54,108,120,80,-14,-139,-258,-329,-330,-263,-151,-26,83,157,187,174,125,46,-52,-159,-255,-316,-321,-265,-167,-61,23,75,103,117,117,96,44,-36,-127,-201,-228,-198,-125,-41,29,73,92,87,58,20}
        },
        {    // H20e075a.wav
            {0,0,1,0,-1,0,0,-1,-2,-1,2,3,1,0,1,2,1,0,-1,0,-1,-2,-2,0,1,-1,-1,1,4,4,1,-2,-2,0,1,2,1,-1,-3,0,5,7,4,2,5,6,0,-4,6,21,17,-10,-32,-19,11,24,18,26,46,31,-5,82,441,1005,1462,1539,1276,931,619,158,-628,-1520,-1970,-1613,-620,511,1464,2295,3135,3849,4096,3691,2828,1922,1321,1149,1337,1689,1930,1824,1343,710,227,20,-42,-173,-454,-783,-1011,-1087,-1075,-1070,-1118,-1219,-1352,-1482,-1561,-1547,-1439,-1291,-1163,-1064,-950,-780,-563,-348,-170,-33,73,156,232,333,477,630,719,700,596,475,380,312,258,215,184,148,79,-40,-209,-421,-660,-885,-1036,-1075,-1017,-912,-803,-704,-620,-566,-550,-555,-553,-534,-513,-504,-491,-447,-363,-264,-181,-127,-90,-55,-16,22,54,72,72,57,34,18,16,25,31,15,-30,-97,-172,-241,-300,-353,-399,-429,-442,-443,-439,-427,-398,-353,-307,-276,-260,-249,-233,-218,-213,-214,-209,-189,-159,-129,-104,-81,-61,-49,-52,-64,-75,-79,-80,-85,-96,-106,-110,-108,-103,-99,-94,-83,-71,-65,-70,-84,-96,-104,-113,-127,-141,-142,-127,-104,-85,-76,-70,-66,-67,-78,-97,-118,-135,-147,-155,-156,-145,-124,-97,-73,-54,-45,-45,-57,-77,-97,-109,-110,-106,-102,-101,-95,-81,-65,-53,-47,-43,-39,-41,-52,-63,-62,-51,-39,-33,-27,-17,-12,-28,-59,-79,-64,-24},
            {-10,-105,-32,130,98,-136,-193,98,264,-106,-189,1873,6935,12993,15901,12418,2848,-8915,-17553,-19023,-12630,-1805,7405,10307,7414,4162,5734,11744,16506,14939,7789,666,-1657,727,4180,5573,4334,1386,-2372,-6093,-8562,-8909,-7747,-6833,-7230,-8196,-8246,-6991,-5463,-4711,-4640,-4468,-3886,-3267,-2847,-2252,-1083,379,1430,1830,2031,2461,2910,2922,2594,2570,3175,3913,4093,3729,3451,3498,3225,1907,-143,-1669,-1746,-709,336,700,534,208,-311,-1240,-2399,-3221,-3378,-3138,-2965,-2917,-2641,-1914,-997,-400,-442,-1106,-2167,-3269,-3918,-3668,-2514,-1030,31,369,312,378,744,1198,1498,1648,1784,1919,1902,1618,1146,686,386,272,305,426,554,583,439,137,-244,-633,-998,-1306,-1492,-1505,-1360,-1141,-938,-781,-655,-542,-462,-452,-523,-649,-784,-886,-920,-854,-658,-340,35,373,603,723,768,761,700,595,483,408,372,346,307,261,219,176,123,69,34,14,-27,-118,-248,-382,-497,-584,-629,-604,-495,-326,-155,-38,-2,-35,-106,-183,-253,-324,-402,-467,-480,-420,-302,-162,-25,103,211,271,266,202,104,-7,-114,-196,-221,-183,-108,-33,28,85,136,149,85,-55,-226,-369,-444,-445,-383,-277,-152,-37,52,110,138,130,68,-55,-211,-345,-412,-400,-331,-238,-141,-49,33,90,111,85,13,-97,-219,-319,-359,-320,-213,-74,55,143,179,169,124,53,-39,-141,-239,-309,-334,-303,-221,-112,-12,54,85,95,96,87,53,-10,-89,-161,-205,-207,-169,-102,-31,24,53,59,48,28,8}
        },
        {    // H20e080a.wav
            {0,0,1,1,1,0,-1,0,1,0,-1,-1,0,1,1,0,1,2,1,0,0,0,0,0,-1,0,1,0,-1,0,2,1,-1,-2,-2,-1,0,0,0,-2,-3,0,5,6,1,0,5,10,6,-1,2,10,5,-19,-32,-7,34,48,28,13,20,10,-24,29,320,832,1320,1524,1417,1167,842,287,-606,-1549,-1949,-1433,-228,1037,1894,2332,2595,2807,2896,2787,2548,2306,2112,1968,1923,2062,2362,2625,2587,2116,1284,302,-588,-1190,-1408,-1314,-1136,-1129,-1398,-1823,-2170,-2277,-2164,-1983,-1870,-1854,-1855,-1768,-1534,-1171,-756,-395,-170,-90,-72,-2,188,471,755,954,1028,977,843,690,585,543,513,433,296,164,91,62,5,-136,-354,-601,-828,-995,-1073,-1052,-960,-852,-769,-724,-706,-703,-707,-707,-691,-651,-593,-522,-441,-352,-266,-191,-126,-65,-6,47,90,124,149,158,149,132,118,107,89,57,19,-23,-74,-145,-231,-312,-369,-405,-431,-454,-468,-465,-444,-413,-377,-343,-314,-297,-291,-289,-285,-273,-254,-228,-198,-164,-134,-112,-96,-83,-71,-60,-54,-54,-56,-59,-61,-61,-61,-62,-67,-81,-102,-119,-125,-115,-94,-72,-57,-56,-73,-101,-130,-145,-141,-124,-102,-87,-81,-85,-92,-98,-102,-107,-118,-135,-150,-156,-148,-128,-105,-87,-77,-74,-72,-69,-68,-73,-83,-92,-97,-97,-93,-83,-66,-50,-43,-46,-52,-52,-50,-53,-58,-61,-60,-59,-61,-58,-48,-37,-39,-53,-60,-46,-17},
            {-47,-90,31,150,29,-199,-136,203,222,-253,19,2925,8676,14433,15809,10217,-915,-12741,-19630,-18128,-9012,2633,10242,10501,6197,3758,6997,13223,16048,12080,4299,-1247,-1348,2200,5481,6187,4377,938,-3319,-7224,-9247,-8779,-7058,-6104,-6674,-7688,-7725,-6632,-5374,-4700,-4467,-4226,-3911,-3655,-3253,-2296,-823,528,1230,1493,1916,2633,3138,3026,2624,2627,3238,3961,4253,4088,3695,2995,1698,-15,-1293,-1374,-451,519,850,722,651,634,150,-1054,-2492,-3409,-3546,-3242,-2878,-2475,-1916,-1319,-1025,-1258,-1935,-2805,-3591,-3984,-3681,-2644,-1295,-282,69,9,55,456,1035,1501,1781,1986,2163,2188,1935,1464,982,656,508,475,507,576,620,547,303,-72,-481,-843,-1122,-1305,-1383,-1359,-1265,-1129,-962,-766,-576,-462,-474,-596,-761,-904,-998,-1041,-1011,-871,-603,-248,111,400,593,705,757,755,703,627,564,531,512,476,413,337,263,196,141,103,79,44,-32,-157,-304,-445,-560,-636,-649,-579,-434,-265,-131,-64,-58,-89,-138,-198,-270,-355,-437,-483,-460,-366,-232,-94,30,140,229,277,269,206,104,-14,-124,-191,-193,-136,-51,27,86,128,144,112,15,-133,-292,-414,-466,-439,-351,-234,-118,-18,67,133,162,128,22,-131,-284,-388,-418,-376,-284,-171,-65,18,75,108,111,72,-18,-144,-266,-336,-330,-251,-128,3,107,163,166,131,80,19,-61,-163,-266,-332,-331,-267,-165,-59,27,82,108,111,98,68,17,-54,-130,-186,-205,-179,-119,-46,17,54,60,45,24,8,1}
        },
        {    // H20e085a.wav
            {0,0,0,0,1,1,1,0,-1,0,0,-1,-2,-1,0,0,0,0,1,2,1,0,1,2,1,0,0,0,0,-2,-2,0,2,2,-1,-3,-2,0,2,2,0,-1,-1,1,3,4,4,7,13,13,2,-11,-12,-1,5,2,3,20,38,32,8,-5,2,-2,-16,54,322,780,1253,1545,1606,1497,1215,644,-253,-1220,-1809,-1714,-1003,12,1063,2034,2842,3339,3415,3160,2839,2695,2792,3031,3260,3326,3098,2534,1751,975,359,-144,-684,-1307,-1869,-2176,-2205,-2133,-2169,-2356,-2558,-2606,-2463,-2229,-2024,-1877,-1729,-1506,-1197,-847,-517,-239,-15,173,354,544,739,915,1046,1118,1126,1060,916,724,544,419,342,277,201,123,49,-46,-195,-388,-580,-732,-840,-925,-992,-1027,-1017,-972,-913,-856,-813,-790,-775,-743,-669,-558,-442,-354,-296,-248,-188,-113,-32,45,109,154,179,192,204,218,225,213,172,109,35,-33,-87,-129,-173,-227,-291,-353,-406,-443,-461,-459,-440,-419,-405,-400,-391,-371,-346,-325,-311,-299,-282,-257,-224,-188,-151,-122,-106,-102,-100,-92,-76,-57,-42,-29,-17,-7,-5,-16,-42,-81,-123,-156,-166,-149,-112,-72,-45,-37,-45,-61,-78,-93,-106,-117,-122,-122,-118,-116,-115,-114,-113,-109,-107,-106,-106,-107,-108,-110,-110,-110,-111,-113,-112,-102,-82,-60,-46,-43,-46,-50,-54,-59,-63,-63,-64,-66,-68,-65,-57,-48,-43,-45,-51,-61,-70,-74,-71,-66,-65,-70,-66,-45,-16},
            {-58,-83,51,149,-3,-219,-104,243,190,-321,127,3409,9430,14964,15520,8847,-3011,-14655,-20323,-17047,-6574,5158,11587,10389,5505,3564,7428,13348,14972,10010,2401,-1972,-882,3174,6381,6867,4809,951,-3813,-7911,-9573,-8470,-6349,-5426,-6241,-7451,-7608,-6623,-5407,-4624,-4237,-4038,-4014,-4036,-3619,-2396,-716,579,1073,1203,1650,2468,3081,3088,2800,2844,3420,4132,4467,4207,3356,1967,291,-1039,-1342,-570,508,1024,866,629,741,876,383,-863,-2258,-3121,-3308,-3105,-2732,-2181,-1526,-1114,-1315,-2139,-3211,-4066,-4392,-4055,-3100,-1832,-759,-264,-272,-321,-14,630,1292,1738,1999,2197,2315,2209,1829,1324,918,719,676,691,717,738,705,541,217,-208,-623,-938,-1126,-1213,-1249,-1268,-1267,-1191,-998,-726,-498,-434,-554,-768,-964,-1094,-1158,-1153,-1049,-834,-536,-217,72,314,505,647,734,759,727,663,608,586,582,557,486,385,291,228,193,171,142,84,-23,-174,-339,-483,-588,-642,-629,-540,-395,-253,-164,-133,-134,-145,-170,-224,-305,-396,-468,-492,-447,-334,-186,-45,68,155,221,258,250,193,100,-12,-117,-181,-182,-120,-28,58,120,154,151,94,-23,-179,-329,-435,-472,-437,-345,-227,-114,-17,68,137,167,121,-10,-187,-344,-430,-429,-358,-249,-132,-29,46,92,110,101,53,-41,-165,-278,-334,-310,-216,-88,37,126,165,156,118,67,4,-81,-188,-290,-347,-333,-254,-140,-28,55,98,105,89,63,28,-25,-95,-164,-206,-206,-163,-92,-10,56,83,66,23,-13,-21,-10}
        },
        {    // H20e090a.wav
            {0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,0,0,2,3,2,2,1,1,1,1,0,0,-1,-2,-2,0,2,3,1,-1,-2,-1,1,2,0,-2,-1,3,6,5,4,7,14,13,-1,-16,-18,-2,18,27,25,20,12,1,-6,-2,4,-5,-20,20,187,508,968,1544,2173,2636,2538,1537,-282,-2263,-3510,-3454,-2189,-307,1532,2902,3648,3821,3652,3483,3561,3829,3963,3690,3063,2417,2039,1915,1786,1402,692,-244,-1236,-2091,-2631,-2772,-2607,-2376,-2306,-2443,-2636,-2683,-2495,-2149,-1812,-1604,-1526,-1470,-1299,-950,-475,-5,337,511,573,625,737,913,1096,1209,1200,1070,865,650,481,375,315,261,181,72,-44,-147,-239,-341,-474,-639,-817,-978,-1100,-1161,-1154,-1088,-994,-905,-836,-779,-714,-629,-531,-438,-368,-324,-287,-234,-152,-50,43,106,139,158,180,210,242,261,252,207,129,36,-49,-109,-142,-162,-189,-235,-295,-356,-399,-418,-419,-418,-423,-434,-441,-439,-424,-399,-367,-331,-297,-271,-252,-234,-208,-175,-141,-116,-109,-114,-120,-113,-86,-44,-3,24,25,3,-36,-80,-118,-145,-155,-149,-134,-113,-89,-66,-47,-36,-34,-41,-56,-77,-101,-126,-144,-153,-152,-144,-131,-117,-105,-93,-81,-72,-73,-87,-111,-132,-139,-136,-130,-123,-110,-89,-63,-38,-16,0,1,-17,-49,-79,-95,-96,-91,-84,-73,-59,-49,-47,-50,-56,-61,-69,-77,-84,-90,-101,-109,-99,-65,-22},
            {-49,-88,39,154,17,-214,-128,230,221,-302,15,3123,9095,14762,15491,8852,-3097,-14765,-20245,-16666,-5994,5730,12020,10660,5579,3329,6793,12386,13929,9164,1915,-2090,-706,3572,6968,7596,5554,1512,-3588,-7980,-9683,-8327,-5851,-4746,-5689,-7255,-7774,-6960,-5670,-4661,-4079,-3861,-4003,-4249,-3959,-2699,-881,536,1050,1097,1432,2203,2871,2983,2775,2876,3551,4392,4712,4119,2728,1012,-422,-1057,-749,92,758,846,613,613,973,1165,583,-740,-2119,-2887,-2942,-2619,-2219,-1812,-1469,-1430,-1928,-2878,-3865,-4438,-4382,-3750,-2767,-1746,-988,-621,-497,-310,124,729,1300,1733,2065,2314,2383,2156,1681,1178,863,784,838,908,947,941,846,604,218,-229,-621,-889,-1036,-1116,-1187,-1265,-1302,-1218,-984,-690,-494,-501,-673,-891,-1065,-1183,-1247,-1223,-1070,-805,-503,-233,-6,198,389,555,677,742,742,689,628,602,609,601,536,429,331,278,260,249,220,153,32,-139,-327,-487,-591,-630,-598,-501,-370,-261,-208,-195,-189,-184,-205,-268,-356,-433,-479,-482,-429,-317,-169,-32,71,148,215,260,255,190,85,-26,-118,-169,-163,-100,-8,78,137,168,163,103,-19,-181,-339,-447,-481,-437,-335,-212,-101,-14,57,116,139,88,-40,-206,-350,-426,-422,-351,-238,-114,-11,55,89,104,96,50,-44,-169,-281,-333,-302,-201,-65,64,151,182,165,121,66,-2,-93,-203,-301,-348,-321,-233,-119,-16,53,81,76,54,29,-2,-47,-110,-173,-208,-198,-150,-77,1,64,88,64,10,-32,-38,-16}
        },
        {    // H20e095a.wav
            {0,0,0,1,0,-1,0,1,0,-1,-1,-1,0,0,-1,-1,0,1,2,2,2,1,0,0,1,1,-1,-2,-1,0,-1,-3,-2,0,2,2,1,0,-1,-2,-2,-1,-1,-1,0,4,7,5,0,1,9,11,-1,-15,-14,5,24,32,30,23,4,-25,-36,-13,15,3,-16,97,477,1108,1814,2378,2629,2379,1419,-276,-2261,-3676,-3763,-2454,-429,1436,2691,3446,3987,4392,4510,4228,3645,3020,2594,2471,2589,2734,2612,2023,1023,-78,-937,-1424,-1675,-1906,-2216,-2531,-2721,-2724,-2572,-2346,-2131,-1990,-1934,-1912,-1832,-1640,-1359,-1059,-784,-519,-239,42,282,462,605,739,859,934,954,943,920,877,794,666,515,361,220,104,31,2,-16,-77,-211,-411,-639,-853,-1020,-1120,-1152,-1134,-1089,-1024,-939,-834,-724,-621,-531,-453,-394,-358,-334,-297,-231,-143,-54,20,76,119,148,167,181,193,197,177,131,70,9,-45,-91,-130,-161,-190,-222,-260,-300,-335,-362,-383,-401,-422,-445,-463,-462,-438,-397,-355,-319,-287,-255,-227,-209,-199,-185,-162,-138,-126,-125,-122,-104,-71,-35,-10,-3,-18,-50,-91,-126,-139,-132,-115,-103,-100,-99,-91,-72,-52,-37,-33,-38,-52,-74,-102,-129,-147,-153,-150,-142,-128,-105,-79,-62,-60,-71,-87,-107,-128,-145,-149,-135,-112,-92,-79,-67,-48,-24,-3,5,-3,-23,-49,-75,-95,-106,-105,-94,-79,-66,-58,-54,-52,-55,-67,-87,-105,-111,-110,-111,-112,-100,-65,-22},
            {-18,-106,-16,143,81,-171,-191,146,280,-185,-234,2162,7685,13746,15633,10202,-1194,-13156,-19535,-17053,-7196,4482,11596,11273,6409,3182,5310,10490,12917,9432,2710,-1719,-949,3260,7129,8316,6616,2685,-2538,-7345,-9602,-8529,-5801,-4167,-4872,-6772,-7918,-7533,-6254,-4994,-4143,-3760,-3872,-4245,-4204,-3164,-1354,278,1033,1142,1354,1987,2633,2801,2613,2687,3384,4324,4698,3993,2416,701,-423,-652,-207,381,651,537,383,571,1059,1319,813,-445,-1840,-2680,-2744,-2323,-1835,-1503,-1406,-1644,-2304,-3253,-4100,-4439,-4152,-3442,-2627,-1927,-1411,-1044,-725,-342,157,714,1225,1638,1972,2221,2290,2080,1631,1147,838,767,852,991,1125,1198,1118,809,316,-200,-576,-773,-870,-970,-1114,-1261,-1326,-1238,-1001,-723,-554,-576,-744,-943,-1101,-1211,-1274,-1248,-1091,-827,-541,-302,-109,73,260,437,581,675,706,678,628,604,613,613,563,472,389,341,320,304,282,238,137,-40,-262,-458,-574,-604,-568,-488,-386,-296,-246,-232,-229,-228,-250,-313,-399,-475,-514,-504,-438,-318,-170,-35,62,132,195,241,244,188,91,-18,-113,-172,-168,-96,13,109,163,179,164,106,-9,-166,-320,-423,-455,-423,-342,-236,-127,-33,40,89,100,52,-60,-206,-334,-404,-405,-343,-240,-122,-19,49,82,92,82,37,-54,-174,-280,-325,-290,-187,-51,79,170,200,177,122,61,-4,-85,-183,-277,-328,-314,-240,-137,-41,24,48,38,13,-7,-24,-51,-99,-157,-200,-204,-165,-94,-14,49,72,53,11,-21,-25,-10}
        },
        {    // H20e100a.wav
            {1,1,0,0,-1,0,1,0,-1,-1,-1,-1,-1,0,0,1,0,-1,0,1,2,1,0,0,1,0,-1,-2,-2,-1,0,1,1,0,0,1,2,2,0,-2,-1,-1,-2,-2,1,6,6,2,0,3,5,2,-1,3,10,9,2,8,29,41,19,-18,-31,-14,0,23,178,605,1267,1885,2130,1894,1336,662,-94,-1004,-1968,-2605,-2472,-1427,246,2025,3455,4299,4513,4193,3555,2897,2472,2374,2515,2715,2793,2612,2093,1258,266,-649,-1300,-1643,-1763,-1786,-1805,-1878,-2020,-2192,-2301,-2257,-2057,-1792,-1573,-1445,-1372,-1289,-1156,-957,-702,-425,-183,-19,82,184,330,499,631,696,717,730,738,722,672,600,518,420,304,187,97,36,-27,-131,-287,-481,-685,-874,-1023,-1110,-1121,-1067,-977,-878,-786,-703,-625,-548,-471,-396,-329,-274,-234,-206,-179,-143,-88,-12,67,128,152,139,107,72,45,22,-1,-25,-47,-69,-93,-121,-150,-177,-202,-231,-268,-309,-345,-370,-389,-408,-427,-436,-426,-396,-356,-315,-279,-249,-224,-208,-197,-186,-174,-161,-149,-137,-119,-98,-80,-71,-72,-77,-83,-90,-102,-116,-123,-120,-109,-96,-87,-80,-74,-69,-64,-57,-51,-49,-55,-74,-99,-125,-141,-144,-133,-116,-98,-81,-68,-62,-67,-81,-98,-115,-130,-140,-142,-131,-107,-78,-53,-35,-23,-17,-17,-21,-30,-39,-49,-59,-70,-82,-94,-100,-97,-85,-71,-63,-62,-69,-84,-106,-128,-137,-127,-104,-86,-77,-67,-45,-15},
            {31,-106,-86,100,154,-69,-235,-3,296,36,-375,914,5378,11634,15342,12379,2549,-9647,-17841,-17800,-9833,1489,10003,11796,7940,3618,3578,7730,11396,10236,4743,-433,-1269,2114,6444,8698,7917,4535,-554,-5832,-9132,-9026,-6406,-3989,-3873,-5743,-7636,-8071,-7122,-5711,-4536,-3844,-3722,-4048,-4258,-3638,-2072,-286,862,1244,1432,1887,2428,2610,2432,2423,3005,3912,4368,3820,2443,963,52,-123,137,407,454,338,302,541,983,1259,943,-58,-1343,-2294,-2555,-2259,-1810,-1522,-1487,-1725,-2266,-3050,-3803,-4170,-3991,-3424,-2764,-2188,-1701,-1250,-822,-415,12,495,1003,1458,1802,2023,2094,1965,1634,1211,868,723,778,967,1206,1390,1383,1089,555,-26,-451,-654,-727,-807,-957,-1140,-1263,-1246,-1078,-839,-664,-647,-771,-943,-1086,-1185,-1244,-1230,-1102,-872,-616,-399,-223,-49,142,327,476,574,624,630,612,600,608,613,581,514,444,401,383,372,359,326,240,73,-154,-370,-512,-564,-550,-494,-412,-328,-270,-247,-245,-251,-278,-339,-423,-496,-531,-520,-461,-350,-203,-59,45,110,161,206,229,202,128,27,-72,-142,-156,-99,7,113,177,194,175,121,21,-121,-265,-369,-411,-400,-348,-268,-169,-71,8,59,74,42,-44,-170,-296,-377,-387,-331,-233,-125,-33,30,63,73,60,20,-52,-147,-237,-287,-269,-182,-51,80,170,200,178,133,86,35,-34,-125,-221,-290,-307,-269,-189,-94,-13,29,29,7,-15,-29,-51,-92,-147,-191,-202,-175,-116,-39,32,75,77,49,17,0,-2}
        },
        {    // H20e105a.wav
            {1,1,1,1,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,1,1,1,0,-1,-1,-1,0,0,0,0,1,2,2,2,3,3,2,1,0,0,0,1,2,4,4,4,3,4,6,6,2,-1,0,5,11,17,19,14,5,3,16,28,20,22,150,517,1096,1650,1869,1613,1037,443,5,-364,-853,-1466,-1913,-1783,-866,678,2398,3784,4478,4375,3644,2670,1915,1698,2011,2532,2838,2676,2084,1304,580,15,-424,-821,-1213,-1561,-1790,-1845,-1743,-1566,-1426,-1397,-1484,-1618,-1693,-1617,-1372,-1031,-729,-572,-566,-615,-596,-451,-225,-15,98,108,71,69,151,305,466,564,571,510,431,374,353,354,351,313,215,52,-155,-365,-539,-662,-748,-823,-900,-966,-989,-947,-848,-724,-608,-522,-465,-426,-384,-325,-246,-163,-102,-78,-81,-84,-63,-14,46,92,100,65,-1,-68,-113,-128,-128,-129,-139,-150,-152,-147,-145,-158,-187,-227,-271,-313,-351,-379,-389,-379,-354,-329,-313,-301,-287,-262,-232,-205,-190,-186,-185,-178,-161,-137,-113,-97,-94,-105,-124,-144,-153,-145,-123,-101,-93,-99,-111,-116,-109,-96,-82,-69,-60,-56,-58,-64,-69,-76,-89,-107,-126,-134,-127,-108,-86,-67,-56,-50,-54,-68,-89,-107,-117,-120,-121,-120,-112,-95,-71,-48,-29,-14,-4,-3,-13,-32,-52,-66,-74,-77,-78,-78,-78,-79,-81,-82,-86,-94,-105,-117,-127,-132,-132,-122,-101,-78,-61,-52,-44,-29,-10},
            {71,-62,-127,13,170,64,-192,-168,178,246,-229,-64,2689,8284,13675,14189,7466,-4016,-14284,-17859,-13139,-3079,6735,11399,9729,5035,2449,4463,8711,10464,7501,2283,-728,592,4587,8039,8885,6802,2389,-3141,-7762,-9403,-7698,-4678,-3136,-4169,-6513,-8137,-8101,-6859,-5331,-4154,-3629,-3775,-4172,-4053,-2940,-1174,390,1236,1580,1898,2273,2416,2235,2121,2519,3335,3911,3655,2613,1404,631,415,456,439,306,199,254,497,848,1119,1030,381,-712,-1787,-2360,-2316,-1964,-1700,-1690,-1879,-2199,-2649,-3164,-3553,-3639,-3426,-3055,-2618,-2092,-1464,-841,-363,-40,258,640,1075,1455,1710,1837,1826,1646,1319,963,734,714,878,1136,1377,1472,1308,875,309,-182,-472,-592,-667,-790,-961,-1118,-1188,-1137,-989,-826,-740,-774,-892,-1027,-1134,-1197,-1200,-1114,-937,-717,-512,-339,-172,10,195,350,460,527,554,551,544,558,588,600,566,501,443,415,411,412,397,332,187,-26,-251,-418,-502,-522,-502,-452,-382,-317,-281,-271,-271,-287,-335,-415,-496,-542,-540,-495,-407,-278,-133,-13,60,106,152,193,201,158,77,-12,-83,-117,-98,-26,70,148,182,175,135,62,-50,-184,-304,-379,-399,-371,-306,-219,-126,-45,16,47,40,-17,-117,-232,-326,-366,-344,-268,-166,-69,-1,30,39,36,18,-30,-108,-194,-252,-256,-199,-95,27,131,187,187,153,114,76,23,-61,-167,-258,-302,-289,-232,-150,-68,-8,11,-5,-30,-50,-69,-104,-156,-200,-212,-183,-124,-49,26,81,97,73,34,6,-1}
        },
        {    // H20e110a.wav
            {0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,-1,-1,-1,-1,-2,-2,-1,0,0,0,0,0,0,0,0,0,0,-2,-2,0,3,4,2,1,2,3,0,-2,2,9,8,0,-4,6,19,18,7,3,7,10,38,191,573,1142,1656,1802,1451,781,140,-231,-364,-487,-783,-1194,-1425,-1116,-80,1525,3209,4349,4530,3796,2654,1765,1534,1878,2353,2509,2194,1587,978,527,187,-180,-643,-1131,-1493,-1615,-1510,-1312,-1184,-1211,-1343,-1445,-1405,-1205,-925,-677,-539,-519,-558,-559,-446,-228,-11,79,-1,-167,-278,-256,-134,-12,39,23,-4,7,65,146,221,273,293,279,234,167,87,-4,-123,-282,-474,-661,-794,-848,-829,-775,-722,-692,-680,-665,-622,-543,-441,-344,-270,-214,-159,-98,-41,-4,11,16,24,33,29,7,-26,-59,-90,-126,-168,-210,-239,-254,-260,-261,-256,-240,-215,-197,-202,-235,-287,-337,-364,-359,-328,-292,-267,-254,-244,-226,-202,-185,-183,-190,-195,-190,-178,-161,-140,-118,-101,-101,-121,-152,-175,-181,-171,-154,-140,-130,-123,-117,-114,-113,-112,-109,-105,-98,-91,-84,-80,-82,-92,-107,-122,-131,-129,-117,-99,-80,-61,-50,-50,-61,-76,-87,-92,-94,-98,-105,-109,-104,-90,-72,-57,-47,-42,-37,-32,-26,-25,-29,-37,-51,-71,-91,-102,-98,-83,-72,-75,-91,-111,-128,-139,-145,-144,-135,-122,-108,-92,-74,-61,-59,-63,-61,-42,-15},
            {64,18,-86,-78,78,150,-31,-217,-55,254,109,-322,542,4295,10070,13980,11878,3174,-8027,-15634,-15674,-8585,1429,9027,10813,7394,2909,1765,4853,8850,9575,6157,1698,1,2077,5868,8575,8623,5803,792,-4816,-8680,-9073,-6494,-3542,-2745,-4486,-7074,-8560,-8245,-6697,-4915,-3694,-3405,-3849,-4270,-3845,-2387,-520,938,1697,2025,2217,2251,2047,1830,2014,2697,3417,3537,2873,1856,1095,823,798,677,387,129,102,320,663,982,1098,801,0,-1088,-2001,-2381,-2264,-1994,-1877,-1969,-2167,-2398,-2656,-2909,-3081,-3135,-3089,-2923,-2543,-1892,-1098,-413,4,222,423,702,1008,1263,1449,1571,1588,1445,1166,880,730,771,959,1197,1371,1370,1132,701,221,-160,-386,-512,-626,-774,-940,-1076,-1129,-1079,-956,-836,-792,-842,-946,-1051,-1129,-1160,-1119,-993,-806,-611,-440,-284,-117,59,218,342,429,478,486,470,473,522,590,619,581,506,442,415,414,415,388,299,133,-82,-281,-413,-474,-487,-471,-431,-379,-335,-310,-295,-287,-301,-354,-436,-510,-545,-531,-469,-362,-227,-100,-12,41,86,138,178,179,136,66,-7,-62,-79,-44,30,107,154,164,146,104,26,-91,-223,-333,-393,-396,-347,-262,-166,-81,-20,18,32,12,-52,-147,-243,-311,-333,-307,-238,-142,-50,9,29,25,15,-5,-51,-125,-200,-241,-226,-156,-51,64,158,205,199,157,104,51,-13,-97,-188,-255,-272,-240,-179,-112,-60,-37,-42,-65,-87,-101,-112,-132,-157,-172,-161,-118,-51,20,72,89,69,34,8,-1}
        },
        {    // H20e115a.wav
            {0,0,0,0,0,0,0,0,1,1,2,2,2,2,1,0,0,1,1,1,-1,-1,-1,0,0,-1,-2,-2,-1,1,1,1,-1,-1,0,0,0,0,1,2,1,0,1,5,4,-1,-4,1,9,7,-1,-2,8,15,5,-6,3,22,23,34,182,595,1226,1784,1911,1467,662,-95,-500,-551,-490,-570,-839,-1072,-893,-32,1429,3007,4059,4179,3465,2450,1737,1619,1956,2350,2438,2104,1475,784,209,-204,-515,-813,-1136,-1446,-1654,-1679,-1514,-1250,-1025,-945,-1014,-1132,-1167,-1034,-745,-389,-80,108,170,151,113,101,129,180,216,190,82,-78,-211,-249,-192,-112,-94,-164,-269,-321,-265,-116,48,141,118,-7,-171,-311,-400,-454,-507,-579,-661,-727,-749,-715,-636,-542,-467,-434,-438,-451,-439,-379,-277,-158,-52,27,78,110,128,134,128,106,64,6,-60,-122,-171,-209,-242,-272,-298,-322,-342,-358,-361,-347,-324,-316,-337,-378,-405,-393,-345,-288,-242,-210,-182,-158,-147,-148,-150,-143,-130,-127,-138,-150,-148,-131,-115,-111,-119,-136,-153,-167,-170,-157,-136,-123,-128,-146,-160,-160,-146,-127,-109,-99,-99,-109,-126,-141,-145,-140,-132,-129,-133,-134,-122,-95,-66,-46,-40,-43,-49,-58,-72,-87,-97,-97,-92,-85,-78,-70,-61,-53,-46,-41,-41,-47,-54,-56,-52,-48,-49,-55,-63,-71,-81,-92,-102,-107,-111,-117,-124,-130,-135,-140,-141,-130,-110,-90,-79,-74,-66,-61,-71,-90,-95,-69,-25},
            {-1,74,28,-90,-77,85,132,-65,-209,2,262,23,-294,1005,5138,10604,13334,9868,717,-9459,-15058,-13268,-5529,3681,9528,9581,5325,1160,973,4821,8967,9520,6122,1993,603,2679,6231,8675,8457,5276,-71,-5653,-8982,-8643,-5654,-2835,-2501,-4683,-7499,-8973,-8430,-6527,-4469,-3257,-3235,-3942,-4382,-3751,-2063,-72,1425,2165,2346,2213,1884,1535,1505,2019,2850,3392,3183,2345,1460,1021,1013,1047,813,375,39,20,301,709,1044,1093,675,-217,-1301,-2144,-2480,-2395,-2184,-2076,-2108,-2225,-2383,-2550,-2678,-2743,-2777,-2795,-2698,-2327,-1648,-848,-196,186,378,522,682,847,1013,1195,1360,1422,1319,1092,862,742,772,928,1132,1270,1235,991,610,220,-83,-291,-447,-595,-753,-912,-1041,-1090,-1035,-916,-823,-821,-898,-993,-1060,-1092,-1087,-1024,-887,-705,-534,-396,-264,-106,68,219,322,384,417,425,421,437,494,567,603,570,488,409,371,372,382,357,265,104,-93,-273,-402,-468,-482,-458,-416,-379,-357,-341,-317,-294,-302,-355,-432,-496,-525,-516,-462,-359,-225,-105,-30,9,48,103,151,161,126,64,0,-44,-49,-11,55,116,147,144,115,60,-29,-145,-263,-352,-393,-379,-313,-218,-122,-54,-16,3,9,-11,-70,-158,-246,-302,-314,-283,-217,-130,-48,2,15,7,-4,-21,-61,-131,-205,-244,-221,-139,-24,88,168,198,179,130,74,20,-35,-100,-168,-221,-240,-221,-178,-134,-110,-108,-117,-121,-113,-100,-92,-97,-111,-126,-126,-97,-41,19,51,42,10,-11,-9}
        },
        {    // H20e120a.wav
            {-1,-1,0,0,0,0,1,2,2,2,2,2,2,1,0,0,0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-2,-2,0,0,-2,-2,-1,0,-1,-2,-1,2,1,-2,-2,3,5,-1,-7,-5,5,9,5,3,9,10,-2,-10,4,24,17,24,190,654,1348,1937,2031,1493,573,-272,-706,-714,-553,-514,-696,-899,-733,109,1565,3137,4154,4200,3392,2285,1501,1354,1731,2228,2424,2117,1408,603,-4,-328,-516,-793,-1253,-1772,-2104,-2072,-1713,-1250,-946,-929,-1115,-1285,-1235,-918,-461,-67,125,132,92,155,369,653,855,861,667,375,127,25,74,183,222,114,-111,-345,-480,-484,-407,-324,-281,-285,-321,-376,-438,-500,-561,-624,-687,-735,-749,-719,-659,-588,-521,-464,-416,-375,-344,-322,-301,-275,-238,-191,-133,-62,26,125,218,278,286,245,171,85,2,-66,-118,-161,-207,-262,-320,-369,-399,-407,-401,-399,-421,-472,-534,-568,-548,-481,-401,-333,-277,-217,-153,-101,-80,-85,-98,-102,-96,-87,-81,-78,-77,-82,-97,-120,-143,-152,-143,-121,-103,-97,-104,-117,-133,-151,-169,-180,-177,-160,-136,-115,-108,-118,-143,-172,-195,-204,-201,-188,-168,-145,-121,-97,-72,-50,-37,-37,-45,-52,-56,-64,-74,-82,-80,-71,-65,-65,-62,-51,-38,-34,-39,-47,-52,-56,-62,-69,-73,-75,-78,-82,-85,-89,-98,-111,-122,-128,-135,-142,-142,-132,-119,-112,-108,-97,-80,-73,-79,-86,-79,-72,-92,-135,-157,-120,-44},
            {-59,28,90,12,-109,-70,101,128,-82,-204,21,254,-5,-260,1129,5177,10253,12467,8790,52,-9187,-13800,-11493,-3959,4418,9152,8256,3574,-386,69,4657,9370,10210,6826,2487,780,2611,6116,8654,8478,5190,-286,-5820,-8892,-8270,-5170,-2457,-2350,-4769,-7752,-9247,-8534,-6349,-4096,-2920,-3111,-4008,-4482,-3743,-1896,245,1836,2522,2441,1930,1348,1057,1334,2142,3027,3384,2931,1973,1160,926,1146,1317,1071,492,-18,-128,181,685,1084,1113,615,-347,-1448,-2270,-2586,-2494,-2271,-2131,-2134,-2246,-2408,-2532,-2539,-2446,-2366,-2370,-2349,-2091,-1511,-768,-129,257,436,529,618,730,880,1064,1228,1289,1201,1008,811,704,732,879,1071,1191,1137,894,543,206,-44,-214,-359,-520,-701,-869,-981,-1010,-962,-886,-840,-856,-917,-982,-1021,-1026,-989,-901,-767,-619,-492,-388,-273,-119,60,220,329,385,403,398,392,411,466,528,550,509,428,353,319,326,345,334,254,98,-100,-281,-401,-449,-444,-415,-384,-367,-361,-350,-322,-292,-291,-333,-400,-460,-493,-490,-442,-344,-219,-115,-58,-30,7,69,128,149,123,68,9,-29,-30,13,78,127,137,110,65,6,-72,-165,-256,-321,-347,-331,-276,-193,-109,-47,-12,3,4,-16,-70,-150,-230,-280,-284,-244,-175,-98,-34,3,12,2,-18,-46,-85,-136,-188,-215,-193,-115,-3,99,154,158,132,100,70,35,-11,-71,-140,-205,-247,-250,-214,-160,-118,-102,-103,-101,-85,-64,-56,-71,-103,-131,-132,-102,-56,-18,-4,-7,-11,-7}
        },
        {    // H20e125a.wav
            {-1,-1,-1,0,2,2,1,1,1,2,2,1,0,0,0,-1,-1,-1,-1,-2,-2,-1,0,0,-1,-2,-1,0,-2,-3,-2,0,0,0,0,2,2,0,0,2,4,0,-4,-2,3,2,-3,1,16,21,6,-12,-4,18,16,29,213,719,1474,2110,2193,1568,515,-449,-933,-906,-650,-503,-601,-753,-554,323,1808,3373,4318,4241,3314,2151,1396,1334,1784,2280,2378,1909,1052,195,-342,-514,-555,-756,-1227,-1814,-2231,-2278,-1973,-1519,-1158,-1030,-1110,-1245,-1263,-1067,-683,-240,118,315,384,417,496,634,784,885,897,819,686,545,443,392,370,332,244,98,-84,-261,-385,-427,-404,-380,-427,-568,-757,-918,-1000,-1006,-974,-940,-912,-876,-811,-710,-586,-463,-367,-306,-275,-256,-232,-193,-142,-89,-45,-9,29,86,165,249,310,325,287,207,108,17,-48,-86,-115,-160,-230,-307,-363,-388,-405,-450,-530,-616,-664,-659,-621,-570,-511,-434,-343,-259,-201,-166,-137,-105,-77,-61,-54,-46,-35,-32,-44,-65,-82,-88,-87,-85,-79,-67,-51,-46,-56,-79,-106,-136,-168,-194,-201,-180,-147,-125,-127,-146,-169,-190,-211,-231,-240,-232,-209,-180,-148,-117,-87,-63,-49,-43,-44,-50,-56,-59,-57,-53,-52,-55,-55,-49,-41,-36,-34,-33,-35,-40,-48,-56,-63,-70,-78,-85,-91,-97,-107,-117,-125,-130,-132,-133,-132,-130,-130,-131,-124,-105,-86,-76,-75,-72,-66,-71,-88,-105,-110,-117,-145,-184,-191,-136,-47},
            {-22,-53,1,66,21,-84,-69,77,119,-60,-190,-3,229,25,-237,925,4550,9290,11605,8561,716,-7825,-12262,-10330,-3509,4101,8232,6983,2190,-1664,-860,4339,9799,11210,7901,3109,753,2171,5679,8471,8547,5414,53,-5382,-8445,-7952,-5033,-2411,-2282,-4677,-7711,-9276,-8547,-6254,-3907,-2738,-3023,-4020,-4542,-3780,-1838,433,2077,2621,2224,1424,810,770,1372,2330,3127,3288,2696,1714,962,845,1225,1557,1377,710,10,-263,7,572,1036,1072,545,-428,-1503,-2286,-2576,-2471,-2241,-2113,-2164,-2343,-2528,-2580,-2424,-2142,-1929,-1908,-1974,-1877,-1460,-819,-202,208,405,490,564,676,834,1008,1138,1157,1047,862,696,629,689,849,1027,1116,1034,782,449,152,-42,-155,-260,-409,-596,-773,-893,-942,-933,-896,-862,-856,-882,-925,-955,-948,-894,-798,-683,-572,-480,-395,-286,-136,41,210,333,395,399,372,352,370,422,465,458,397,319,264,250,271,300,298,223,67,-126,-288,-374,-392,-380,-365,-354,-348,-346,-340,-320,-295,-290,-321,-377,-428,-451,-440,-392,-315,-229,-163,-127,-99,-46,31,101,129,108,57,2,-32,-28,14,70,102,95,60,16,-32,-89,-156,-221,-269,-294,-289,-253,-193,-126,-71,-35,-15,-11,-29,-72,-132,-190,-226,-227,-190,-129,-69,-30,-20,-28,-42,-57,-75,-101,-132,-161,-174,-157,-102,-23,51,96,105,92,73,54,27,-16,-75,-142,-200,-233,-232,-198,-148,-104,-82,-82,-90,-92,-85,-83,-97,-125,-152,-160,-146,-116,-77,-42,-16,-3}
        },
        {    // H20e130a.wav
            {0,0,1,1,1,1,1,1,1,1,1,1,0,-1,-1,0,0,0,-2,-2,-1,0,-1,-1,-1,-1,-2,-2,0,0,-1,-1,2,4,3,-2,-2,3,4,-1,-7,-3,5,5,-4,-4,11,20,9,-5,2,20,13,29,239,802,1626,2303,2358,1631,445,-621,-1135,-1072,-752,-549,-604,-701,-412,581,2162,3744,4597,4349,3249,1998,1273,1317,1863,2376,2405,1833,890,-29,-618,-840,-899,-1061,-1443,-1944,-2326,-2393,-2119,-1661,-1253,-1066,-1113,-1261,-1318,-1151,-764,-291,85,263,286,302,440,704,975,1111,1048,838,606,471,488,625,776,822,702,448,168,-30,-101,-78,-51,-110,-295,-570,-854,-1074,-1209,-1279,-1311,-1310,-1266,-1178,-1054,-906,-747,-597,-478,-400,-349,-301,-240,-170,-98,-28,40,102,153,197,238,279,307,303,259,185,108,50,17,-2,-28,-72,-128,-182,-234,-298,-389,-496,-592,-652,-673,-673,-659,-625,-559,-469,-383,-322,-289,-268,-242,-204,-156,-107,-65,-42,-42,-59,-77,-81,-63,-28,12,43,53,37,9,-16,-31,-47,-79,-125,-168,-186,-177,-157,-144,-147,-164,-189,-216,-236,-243,-241,-234,-228,-221,-207,-184,-152,-116,-81,-54,-44,-52,-67,-79,-77,-65,-50,-41,-39,-43,-45,-41,-30,-17,-8,-6,-14,-29,-48,-65,-78,-88,-99,-111,-122,-129,-133,-134,-134,-137,-145,-156,-160,-151,-132,-111,-93,-78,-63,-51,-48,-53,-62,-76,-98,-127,-153,-167,-171,-171,-163,-136,-84,-27},
            {35,-21,-63,-14,67,44,-67,-88,42,124,-9,-169,-57,189,97,-208,499,3413,7801,10663,8948,2446,-5537,-10444,-9638,-3994,2871,6858,5889,1388,-2468,-1827,3538,9774,12196,9372,4147,817,1470,4841,7994,8594,5967,1014,-4270,-7605,-7698,-5275,-2720,-2276,-4328,-7283,-9023,-8522,-6348,-3984,-2726,-2928,-3917,-4516,-3846,-1913,424,2074,2453,1798,880,430,720,1541,2452,3044,3073,2527,1670,972,820,1192,1622,1596,1005,231,-220,-127,338,799,914,513,-343,-1359,-2148,-2473,-2396,-2190,-2099,-2198,-2411,-2598,-2618,-2394,-1994,-1626,-1481,-1541,-1585,-1386,-923,-373,66,322,450,543,663,817,972,1067,1052,926,746,598,550,625,785,945,1006,906,667,379,142,-4,-87,-171,-302,-480,-668,-816,-892,-895,-853,-810,-799,-824,-863,-885,-868,-809,-715,-609,-515,-445,-385,-300,-167,5,179,313,386,396,365,331,330,365,397,376,297,202,146,150,197,245,251,183,42,-128,-261,-318,-316,-299,-299,-315,-330,-335,-322,-293,-261,-254,-286,-342,-391,-407,-389,-347,-291,-236,-199,-182,-161,-110,-27,54,98,92,53,3,-33,-39,-8,38,66,57,21,-18,-48,-78,-116,-161,-203,-235,-248,-235,-199,-151,-110,-78,-52,-28,-14,-21,-49,-90,-128,-149,-144,-116,-81,-60,-59,-70,-76,-73,-71,-79,-99,-127,-153,-159,-134,-75,-5,47,64,51,30,16,9,-4,-36,-86,-140,-179,-189,-170,-139,-114,-108,-115,-125,-126,-119,-113,-120,-143,-173,-187,-169,-120,-61,-17,0}
        },
        {    // H20e135a.wav
            {0,1,1,1,2,2,2,0,0,0,0,-1,-2,-1,0,-1,-1,-1,1,1,0,-1,0,0,-2,-2,0,1,1,-1,1,3,2,-1,0,4,5,-2,-6,-2,5,3,-6,-4,12,19,5,-8,9,30,16,27,265,901,1812,2527,2531,1679,356,-800,-1333,-1233,-848,-584,-592,-651,-300,793,2487,4124,4921,4517,3250,1916,1218,1350,1962,2470,2426,1741,685,-305,-898,-1053,-1019,-1128,-1548,-2166,-2680,-2813,-2501,-1918,-1361,-1062,-1064,-1215,-1285,-1114,-709,-233,123,271,274,278,388,603,840,1002,1034,932,746,564,475,515,632,731,743,669,552,437,341,268,207,128,-11,-236,-524,-826,-1090,-1296,-1436,-1507,-1503,-1429,-1304,-1149,-982,-822,-690,-596,-528,-458,-369,-264,-163,-75,6,95,198,305,396,449,449,388,277,149,43,-15,-30,-25,-18,-16,-29,-76,-172,-299,-417,-489,-521,-547,-586,-621,-621,-576,-511,-456,-421,-394,-362,-328,-294,-260,-221,-187,-169,-172,-182,-179,-148,-88,-10,67,121,137,118,90,74,69,53,10,-53,-113,-153,-172,-178,-173,-159,-148,-153,-184,-230,-268,-282,-273,-251,-232,-220,-210,-195,-167,-128,-87,-57,-47,-55,-70,-81,-83,-81,-78,-78,-77,-70,-53,-30,-5,13,20,13,-3,-22,-38,-50,-64,-81,-101,-122,-138,-147,-147,-144,-143,-148,-156,-164,-169,-167,-157,-138,-110,-82,-58,-40,-29,-27,-38,-62,-92,-123,-149,-168,-176,-168,-147,-121,-95,-68,-39,-12},
            {1,33,11,-44,-40,33,60,-20,-87,-13,104,54,-119,-121,103,166,-113,69,2016,5817,9310,9386,4775,-2420,-8056,-8963,-5051,864,4983,4901,1221,-2623,-2727,2062,8802,12689,11141,5949,1466,780,3547,6994,8400,6691,2491,-2507,-6263,-7321,-5784,-3428,-2468,-3825,-6479,-8454,-8442,-6648,-4365,-2921,-2847,-3678,-4347,-3899,-2158,124,1787,2127,1386,475,211,750,1671,2460,2858,2845,2460,1809,1159,869,1073,1488,1629,1254,568,1,-162,57,430,663,504,-139,-1080,-1921,-2328,-2292,-2100,-2044,-2200,-2454,-2643,-2650,-2416,-1979,-1509,-1220,-1188,-1266,-1216,-928,-493,-86,197,372,502,638,796,955,1052,1027,871,658,496,456,536,674,788,811,718,541,345,188,82,0,-100,-239,-414,-597,-745,-819,-812,-761,-722,-729,-771,-811,-816,-779,-708,-617,-524,-449,-401,-366,-313,-212,-63,106,257,359,395,372,325,295,299,311,288,214,124,64,60,98,143,162,129,35,-97,-215,-275,-276,-255,-251,-274,-303,-317,-301,-264,-223,-206,-228,-282,-338,-367,-358,-317,-265,-226,-211,-214,-209,-172,-102,-22,40,68,57,17,-30,-59,-50,-17,9,7,-14,-33,-42,-52,-76,-113,-155,-193,-221,-230,-217,-185,-146,-105,-62,-16,24,44,36,0,-50,-96,-120,-117,-97,-82,-81,-91,-97,-90,-78,-70,-80,-109,-149,-179,-176,-133,-65,-2,32,34,21,12,16,20,8,-30,-87,-143,-180,-190,-181,-167,-159,-163,-173,-177,-165,-140,-118,-111,-119,-123,-109,-77,-39,-10}
        },
        {    // H20e140a.wav
            {0,0,1,1,0,-1,-1,-1,-1,-2,-3,-2,-2,-3,-4,-3,-1,0,-2,-2,-2,-3,-4,-4,-2,-2,-4,-5,-2,2,0,-4,-3,3,3,-5,-12,-5,4,1,-12,-12,7,18,3,-11,7,31,19,35,302,1007,2006,2772,2733,1743,247,-1026,-1575,-1409,-938,-615,-590,-600,-154,1069,2869,4521,5216,4634,3202,1805,1175,1449,2169,2666,2491,1632,441,-610,-1207,-1335,-1249,-1284,-1634,-2224,-2771,-2983,-2760,-2251,-1737,-1426,-1334,-1321,-1224,-963,-573,-154,187,386,453,456,479,574,729,881,953,892,716,513,395,420,543,657,675,593,478,406,409,465,515,490,342,75,-257,-581,-847,-1047,-1197,-1311,-1389,-1418,-1383,-1282,-1133,-978,-858,-790,-753,-706,-619,-491,-341,-193,-60,58,167,270,368,448,494,487,416,290,139,6,-72,-87,-66,-57,-96,-180,-274,-339,-370,-393,-436,-494,-536,-533,-492,-446,-420,-414,-411,-396,-367,-331,-296,-268,-257,-271,-304,-338,-344,-300,-206,-83,30,106,139,144,139,129,112,89,65,42,11,-38,-101,-159,-189,-188,-173,-168,-185,-215,-243,-259,-264,-265,-266,-264,-255,-237,-207,-167,-122,-84,-64,-58,-59,-62,-67,-80,-97,-110,-115,-114,-108,-93,-64,-25,11,32,34,18,-10,-41,-68,-87,-101,-111,-120,-127,-131,-135,-139,-146,-158,-172,-185,-190,-185,-172,-154,-130,-100,-67,-42,-31,-34,-45,-64,-91,-121,-142,-149,-148,-145,-138,-121,-97,-79,-71,-64,-44,-16},
            {-16,-7,25,25,-24,-52,-3,56,23,-65,-59,55,94,-40,-145,-11,168,31,-130,819,3665,7349,9142,6863,1099,-4896,-7632,-5904,-1407,2648,3657,1278,-2197,-3231,244,6761,12065,12535,8302,3029,619,2103,5425,7667,7182,4104,-291,-4300,-6417,-6103,-4310,-2943,-3397,-5435,-7493,-8078,-6912,-4914,-3339,-2896,-3411,-4043,-3862,-2495,-460,1175,1619,993,179,21,669,1632,2356,2653,2636,2403,1963,1410,1014,1002,1285,1505,1365,887,338,-20,-76,126,406,470,75,-743,-1604,-2086,-2090,-1904,-1881,-2119,-2456,-2685,-2705,-2493,-2072,-1553,-1137,-977,-1023,-1061,-909,-574,-197,97,288,423,556,720,903,1041,1048,888,630,411,332,391,512,605,620,552,433,305,201,131,75,3,-113,-282,-484,-666,-769,-769,-698,-623,-600,-638,-699,-735,-714,-641,-543,-453,-392,-364,-356,-340,-285,-173,-15,153,283,345,339,292,244,223,223,214,166,87,17,-5,23,67,88,64,1,-82,-161,-211,-223,-211,-203,-217,-251,-282,-289,-264,-219,-179,-170,-199,-249,-291,-307,-297,-275,-255,-243,-240,-234,-209,-156,-86,-23,11,11,-15,-48,-73,-78,-63,-44,-38,-47,-56,-53,-43,-42,-60,-98,-145,-189,-217,-217,-189,-146,-99,-50,1,50,81,81,51,4,-44,-81,-101,-105,-101,-102,-112,-123,-122,-105,-83,-77,-98,-137,-174,-185,-160,-108,-49,-2,24,31,27,22,19,8,-26,-87,-155,-204,-224,-223,-219,-216,-209,-192,-166,-135,-98,-61,-40,-44,-62,-70,-51,-18}
        },
        {    // H20e145a.wav
            {3,3,1,-1,-1,1,0,-2,-3,-2,0,0,-1,0,1,1,-1,-1,0,0,-3,-4,-2,0,-1,-1,1,4,2,-2,-1,5,5,-4,-9,-1,8,3,-12,-10,9,17,0,-11,14,41,21,42,358,1164,2268,3061,2926,1751,75,-1288,-1814,-1559,-1002,-634,-591,-556,7,1404,3348,5018,5565,4737,3095,1631,1094,1539,2391,2898,2605,1559,202,-932,-1521,-1595,-1460,-1473,-1812,-2379,-2894,-3086,-2874,-2402,-1924,-1629,-1536,-1519,-1410,-1112,-642,-115,322,576,654,651,667,743,849,926,928,838,677,500,375,347,399,462,476,432,374,351,383,446,496,483,378,183,-64,-315,-542,-744,-925,-1074,-1167,-1184,-1133,-1043,-952,-886,-853,-852,-868,-871,-832,-728,-565,-374,-190,-32,102,219,321,395,430,419,365,283,197,132,89,42,-41,-162,-281,-351,-359,-341,-341,-370,-406,-428,-436,-439,-437,-421,-384,-341,-306,-284,-266,-252,-251,-276,-322,-367,-385,-364,-308,-233,-156,-89,-31,24,77,121,142,137,116,92,70,43,3,-46,-91,-118,-128,-131,-139,-157,-182,-208,-231,-250,-266,-275,-278,-273,-259,-235,-200,-157,-112,-70,-38,-25,-33,-57,-83,-101,-110,-113,-116,-113,-103,-84,-60,-32,-6,12,16,4,-20,-46,-71,-92,-110,-122,-127,-124,-116,-110,-110,-121,-137,-154,-169,-178,-179,-168,-147,-120,-92,-65,-41,-26,-32,-57,-86,-105,-113,-119,-124,-124,-119,-114,-112,-102,-77,-46,-33,-46,-61,-52,-20},
            {16,-7,-22,4,34,12,-40,-38,27,54,-14,-75,-13,89,50,-98,-105,84,146,-76,84,1719,4903,7844,8012,4458,-1038,-5245,-5966,-3482,-18,1933,1188,-1339,-3041,-1370,3914,9971,12837,10740,5672,1589,1036,3425,6186,7089,5497,2105,-1793,-4795,-5896,-5138,-3755,-3312,-4407,-6220,-7339,-6989,-5531,-3974,-3145,-3197,-3626,-3656,-2791,-1215,285,940,650,52,-76,508,1419,2131,2438,2467,2357,2098,1671,1232,1021,1112,1310,1336,1078,641,218,-32,-36,157,331,195,-368,-1135,-1700,-1849,-1744,-1723,-1949,-2307,-2587,-2681,-2579,-2278,-1796,-1267,-899,-800,-863,-865,-675,-339,9,279,456,569,656,751,865,954,942,793,559,347,237,235,291,351,381,366,305,218,138,91,64,9,-121,-321,-533,-678,-713,-654,-559,-495,-496,-552,-612,-623,-569,-479,-399,-355,-346,-352,-357,-338,-270,-142,20,165,251,271,247,210,184,174,167,142,87,19,-29,-36,-11,16,19,-10,-61,-116,-156,-172,-172,-174,-196,-233,-266,-276,-254,-207,-157,-127,-130,-161,-199,-227,-243,-253,-261,-265,-263,-255,-236,-198,-140,-79,-36,-27,-45,-75,-100,-110,-106,-94,-87,-84,-78,-58,-28,-3,0,-28,-81,-145,-198,-219,-200,-149,-85,-22,34,80,108,107,76,26,-27,-69,-91,-98,-95,-94,-103,-120,-134,-133,-112,-86,-78,-99,-134,-160,-158,-129,-87,-43,-7,11,8,-9,-24,-34,-51,-91,-149,-205,-238,-244,-232,-207,-177,-147,-122,-96,-63,-30,-14,-20,-32,-29,-12}
        },
        {    // H20e150a.wav
            {1,0,0,0,-1,-3,-3,-1,0,-1,-2,-1,0,0,0,0,1,0,-4,-4,-1,1,0,-2,1,4,2,-2,0,5,4,-6,-10,0,11,3,-14,-12,11,19,-3,-16,15,47,23,49,418,1338,2566,3396,3145,1736,-170,-1639,-2111,-1709,-1022,-607,-573,-514,173,1769,3877,5554,5926,4827,2963,1434,1000,1633,2632,3145,2700,1428,-103,-1285,-1819,-1814,-1640,-1654,-1998,-2553,-3043,-3215,-2996,-2535,-2084,-1820,-1733,-1669,-1477,-1111,-634,-155,235,501,666,785,900,1005,1061,1042,957,839,710,580,464,378,332,307,280,241,206,202,244,322,394,403,304,100,-154,-385,-554,-666,-754,-831,-885,-896,-858,-785,-700,-629,-595,-618,-696,-794,-852,-822,-696,-512,-321,-155,-16,106,213,296,342,343,304,235,150,59,-29,-102,-148,-166,-176,-208,-280,-371,-438,-455,-430,-400,-394,-413,-433,-428,-388,-320,-243,-186,-169,-195,-250,-308,-340,-333,-292,-238,-196,-173,-151,-107,-36,40,90,99,76,49,34,28,19,-3,-37,-76,-110,-132,-138,-127,-110,-104,-121,-157,-200,-238,-265,-282,-285,-277,-262,-241,-210,-162,-101,-43,-9,-5,-22,-49,-79,-107,-124,-129,-124,-115,-102,-78,-45,-10,13,16,0,-29,-63,-95,-119,-134,-140,-141,-136,-126,-115,-106,-100,-101,-110,-130,-154,-172,-175,-164,-140,-105,-65,-30,-14,-20,-41,-68,-95,-119,-133,-134,-128,-122,-118,-110,-95,-80,-69,-58,-42,-29,-33,-54,-68,-55,-21},
            {-2,16,13,-11,-14,15,28,-7,-43,-14,45,34,-42,-61,29,88,-4,-118,-42,132,77,-112,421,2490,5569,7632,6733,2883,-1768,-4636,-4608,-2538,-316,451,-592,-2206,-2166,1057,6608,11344,12196,8846,4050,1215,1655,4035,6025,6128,4202,981,-2415,-4801,-5450,-4677,-3726,-3769,-4916,-6228,-6666,-5970,-4707,-3654,-3217,-3258,-3302,-2895,-1933,-768,51,242,36,-47,322,1036,1736,2173,2341,2340,2196,1883,1464,1127,1030,1138,1240,1135,805,401,106,9,72,161,111,-174,-639,-1103,-1405,-1545,-1660,-1866,-2141,-2380,-2504,-2498,-2353,-2044,-1603,-1159,-862,-744,-700,-593,-374,-91,182,403,555,637,675,715,787,865,884,792,593,341,107,-46,-80,6,154,279,315,258,161,75,6,-76,-201,-355,-489,-559,-557,-514,-470,-455,-472,-498,-507,-485,-439,-389,-353,-338,-343,-364,-383,-367,-283,-134,36,170,232,225,179,133,113,122,136,124,73,2,-58,-85,-80,-58,-37,-34,-57,-101,-146,-176,-190,-203,-223,-247,-259,-249,-214,-162,-111,-82,-87,-117,-153,-186,-214,-242,-266,-279,-277,-264,-238,-193,-134,-78,-45,-46,-74,-115,-151,-166,-158,-132,-101,-76,-52,-26,-2,7,-9,-50,-102,-148,-174,-171,-140,-91,-37,14,56,86,98,86,53,10,-34,-68,-87,-93,-91,-94,-108,-129,-140,-128,-99,-72,-65,-83,-114,-140,-148,-137,-114,-91,-75,-69,-68,-63,-54,-53,-70,-110,-159,-197,-213,-205,-183,-159,-138,-119,-96,-68,-41,-22,-13,-9,-4}
        },
        {    // H20e155a.wav
            {0,1,0,-2,-3,-1,0,-1,-2,-1,1,1,0,0,1,-1,-4,-3,1,2,-1,-3,1,6,3,-4,-2,6,6,-6,-13,-1,12,4,-14,-10,14,18,-10,-22,18,55,22,50,477,1529,2901,3775,3394,1722,-448,-2045,-2464,-1895,-1046,-554,-517,-442,359,2157,4440,6126,6299,4897,2801,1228,927,1756,2890,3399,2809,1311,-429,-1712,-2209,-2087,-1812,-1799,-2171,-2744,-3203,-3311,-3051,-2607,-2224,-2030,-1964,-1856,-1572,-1110,-573,-81,289,525,669,788,932,1091,1203,1205,1090,913,743,618,539,481,417,329,218,109,41,46,121,224,288,256,107,-123,-366,-562,-683,-749,-791,-826,-841,-806,-708,-564,-422,-332,-319,-376,-470,-554,-593,-569,-494,-398,-306,-221,-130,-21,97,206,282,304,255,131,-36,-182,-252,-243,-203,-188,-215,-258,-285,-288,-289,-317,-378,-459,-529,-557,-522,-433,-324,-235,-193,-199,-234,-268,-273,-236,-170,-113,-101,-137,-186,-200,-153,-61,39,111,138,123,76,15,-40,-74,-87,-94,-110,-140,-171,-186,-172,-134,-96,-82,-103,-147,-190,-216,-228,-238,-252,-266,-267,-245,-201,-142,-80,-30,-3,-5,-28,-59,-87,-106,-117,-123,-121,-112,-94,-69,-38,-7,13,13,-7,-41,-78,-112,-145,-175,-195,-199,-185,-158,-126,-97,-80,-79,-94,-120,-147,-166,-169,-152,-121,-81,-43,-11,8,8,-11,-45,-85,-118,-141,-150,-147,-133,-116,-100,-85,-68,-53,-45,-45,-47,-47,-47,-54,-65,-65,-46,-16},
            {-1,-7,2,14,4,-14,-7,19,17,-21,-38,3,44,11,-54,-38,50,65,-43,-107,10,131,9,-75,738,2952,5722,7144,5831,2223,-1714,-4041,-4122,-2699,-1147,-594,-1214,-1900,-851,2865,7975,11524,11232,7543,3269,1169,1885,3981,5519,5384,3500,487,-2622,-4706,-5187,-4505,-3810,-3980,-4918,-5806,-5947,-5309,-4361,-3579,-3145,-2952,-2763,-2371,-1726,-986,-401,-103,15,199,614,1211,1791,2178,2313,2240,2013,1683,1330,1076,1008,1071,1088,916,584,266,107,97,107,31,-144,-371,-608,-852,-1115,-1408,-1726,-2036,-2282,-2413,-2407,-2274,-2036,-1728,-1406,-1132,-928,-759,-569,-334,-82,146,323,442,511,555,615,715,834,910,888,748,507,212,-66,-245,-272,-164,2,139,213,235,220,160,44,-117,-285,-417,-486,-488,-446,-395,-377,-404,-455,-487,-473,-426,-379,-353,-347,-353,-369,-392,-398,-353,-243,-93,49,147,189,184,150,111,96,112,134,121,53,-45,-127,-159,-143,-103,-66,-49,-62,-100,-148,-190,-219,-235,-245,-249,-240,-214,-168,-114,-72,-58,-73,-105,-142,-183,-225,-258,-272,-269,-261,-251,-230,-186,-127,-75,-49,-51,-73,-106,-142,-169,-178,-167,-143,-113,-76,-35,-3,7,-14,-56,-102,-136,-148,-136,-106,-69,-32,4,39,70,88,87,65,27,-18,-60,-89,-103,-108,-117,-130,-137,-124,-90,-51,-28,-39,-79,-134,-181,-208,-208,-186,-150,-115,-89,-71,-57,-45,-42,-58,-92,-131,-157,-167,-168,-165,-159,-148,-131,-110,-86,-58,-29,-7}
        },
        {    // H20e160a.wav
            {-2,-4,-3,-1,0,-2,-3,-2,0,0,-1,-1,0,-2,-5,-4,0,0,-3,-4,2,6,2,-5,-3,6,4,-10,-15,0,14,2,-20,-14,16,21,-15,-32,15,59,24,55,542,1729,3253,4178,3663,1706,-754,-2491,-2849,-2091,-1066,-501,-475,-386,552,2590,5070,6754,6688,4943,2600,1000,860,1905,3166,3649,2896,1174,-756,-2123,-2592,-2385,-2037,-2000,-2382,-2955,-3375,-3413,-3084,-2614,-2270,-2164,-2179,-2086,-1735,-1163,-532,5,379,602,726,823,962,1152,1320,1353,1203,940,707,601,604,615,543,377,175,18,-42,1,108,209,229,126,-89,-356,-608,-800,-918,-969,-968,-936,-884,-809,-697,-552,-400,-283,-220,-200,-203,-213,-228,-236,-223,-183,-123,-55,16,96,176,230,223,138,-3,-149,-245,-268,-244,-225,-250,-314,-375,-395,-366,-317,-290,-309,-371,-449,-513,-542,-529,-483,-421,-365,-321,-278,-218,-138,-62,-23,-37,-88,-141,-167,-155,-106,-33,46,109,138,130,96,49,4,-33,-61,-93,-139,-199,-253,-274,-249,-193,-138,-113,-123,-155,-187,-207,-213,-214,-216,-221,-226,-224,-209,-178,-129,-74,-29,-5,-6,-24,-51,-79,-104,-124,-135,-137,-126,-100,-61,-19,11,19,4,-28,-66,-104,-136,-166,-196,-223,-235,-223,-187,-138,-97,-74,-76,-101,-138,-173,-188,-177,-144,-100,-54,-11,24,40,33,2,-43,-91,-127,-144,-142,-127,-108,-93,-84,-80,-77,-70,-58,-48,-47,-57,-69,-72,-67,-61,-58,-50,-33,-11},
            {1,3,-3,-4,7,13,1,-11,0,19,9,-25,-29,12,37,-3,-49,-18,53,42,-55,-79,41,110,-28,-4,952,3127,5606,6716,5386,2086,-1536,-3871,-4274,-3190,-1716,-927,-1098,-1267,163,3868,8470,11266,10458,6779,2864,1046,1738,3637,5062,4976,3213,313,-2677,-4638,-5057,-4416,-3777,-3873,-4595,-5292,-5441,-4993,-4223,-3436,-2836,-2513,-2405,-2291,-1931,-1288,-582,-86,147,331,709,1297,1876,2209,2243,2087,1848,1556,1236,981,887,925,941,810,553,290,106,-3,-65,-96,-126,-227,-452,-764,-1081,-1373,-1688,-2048,-2363,-2488,-2355,-2039,-1678,-1372,-1158,-1026,-932,-801,-563,-226,119,354,435,414,392,446,589,775,924,958,843,607,321,61,-120,-210,-222,-183,-113,-21,84,176,218,180,61,-111,-290,-433,-508,-511,-465,-410,-381,-384,-405,-425,-436,-433,-414,-380,-347,-332,-342,-358,-349,-294,-195,-71,53,156,218,223,182,127,95,91,87,49,-25,-108,-167,-186,-171,-138,-99,-73,-72,-99,-140,-179,-208,-230,-250,-261,-251,-211,-150,-90,-51,-44,-62,-98,-146,-201,-248,-270,-265,-243,-221,-201,-176,-140,-99,-64,-42,-34,-44,-74,-121,-166,-192,-194,-178,-152,-116,-75,-42,-30,-43,-70,-95,-106,-103,-89,-70,-47,-26,-6,16,41,66,81,74,46,5,-39,-79,-114,-140,-152,-146,-121,-83,-43,-14,-15,-50,-111,-177,-227,-246,-232,-194,-148,-108,-80,-58,-35,-16,-11,-25,-55,-92,-131,-166,-186,-187,-178,-173,-170,-149,-96,-32}
        },
        {    // H20e165a.wav
            {-4,-1,1,0,-2,-1,0,0,-2,-1,1,-1,-6,-6,0,3,-1,-3,2,7,3,-5,-2,8,6,-11,-18,0,17,4,-20,-14,19,24,-16,-35,16,64,22,57,602,1924,3607,4599,3969,1732,-1036,-2948,-3267,-2316,-1087,-430,-423,-346,709,2997,5709,7420,7121,5015,2404,768,795,2061,3450,3900,2980,1038,-1073,-2520,-2962,-2671,-2256,-2205,-2610,-3198,-3588,-3551,-3136,-2614,-2276,-2227,-2312,-2255,-1885,-1253,-556,31,447,712,862,937,1003,1127,1305,1435,1391,1145,818,588,538,595,605,471,225,-16,-138,-101,54,229,304,191,-112,-512,-873,-1098,-1177,-1164,-1124,-1088,-1046,-965,-822,-629,-434,-290,-219,-194,-167,-107,-19,65,117,131,136,174,263,370,424,370,215,26,-124,-209,-246,-265,-286,-313,-351,-398,-440,-456,-437,-403,-386,-408,-460,-521,-566,-584,-576,-549,-503,-432,-329,-197,-66,23,42,-1,-65,-110,-118,-98,-64,-22,31,88,134,153,140,105,59,14,-28,-67,-105,-143,-185,-230,-269,-291,-280,-237,-184,-151,-154,-187,-223,-240,-239,-232,-229,-226,-212,-181,-135,-80,-25,18,35,22,-16,-63,-102,-125,-133,-128,-118,-105,-88,-64,-31,2,17,5,-31,-78,-123,-160,-189,-211,-222,-220,-205,-179,-145,-111,-90,-88,-105,-136,-167,-189,-190,-167,-123,-67,-8,44,79,85,57,3,-57,-108,-139,-145,-131,-104,-80,-64,-55,-45,-37,-37,-49,-65,-80,-93,-99,-92,-67,-36,-22,-33,-48,-43,-18},
            {-10,-6,4,5,-4,-5,6,11,0,-10,2,17,6,-23,-23,12,28,-9,-43,-11,45,26,-53,-59,45,82,-38,58,1041,3107,5400,6428,5209,2083,-1516,-4018,-4600,-3514,-1848,-806,-759,-765,730,4300,8544,10928,9901,6271,2513,765,1415,3290,4788,4819,3124,243,-2710,-4588,-4925,-4235,-3548,-3562,-4209,-4921,-5181,-4832,-4031,-3109,-2434,-2229,-2387,-2495,-2161,-1382,-539,-13,184,370,807,1429,1942,2145,2086,1927,1730,1452,1100,808,717,812,923,879,640,288,-49,-249,-243,-81,64,-2,-321,-757,-1145,-1451,-1744,-2046,-2263,-2285,-2114,-1848,-1570,-1297,-1033,-821,-692,-606,-467,-223,69,296,393,388,369,421,569,770,926,941,780,494,194,-21,-109,-99,-54,-28,-36,-60,-71,-52,-14,18,7,-76,-230,-416,-570,-641,-622,-547,-465,-410,-389,-390,-392,-382,-358,-334,-319,-315,-312,-300,-269,-209,-113,7,120,196,220,203,166,128,94,61,18,-42,-116,-184,-222,-217,-176,-120,-77,-63,-81,-119,-160,-194,-223,-250,-273,-284,-273,-238,-180,-110,-51,-24,-41,-91,-147,-191,-216,-223,-218,-207,-195,-182,-161,-125,-76,-28,2,4,-25,-75,-131,-176,-201,-210,-210,-199,-174,-139,-104,-78,-62,-52,-52,-65,-85,-96,-89,-70,-48,-22,11,48,75,80,64,34,-5,-49,-91,-123,-141,-147,-141,-123,-93,-60,-34,-25,-42,-89,-156,-214,-239,-226,-194,-155,-112,-63,-21,2,6,3,-10,-48,-113,-175,-208,-218,-231,-248,-232,-158,-54}
        },
        {    // H20e170a.wav
            {1,-1,-3,-1,1,0,-2,-1,0,-2,-6,-4,1,3,-1,-3,3,8,2,-7,-3,9,7,-12,-20,-1,16,2,-23,-14,23,26,-20,-41,15,65,19,62,671,2129,3967,5026,4286,1775,-1309,-3417,-3719,-2577,-1128,-363,-376,-323,848,3401,6371,8126,7592,5112,2219,542,739,2229,3740,4138,3025,852,-1421,-2911,-3302,-2942,-2492,-2449,-2868,-3445,-3791,-3693,-3216,-2647,-2299,-2280,-2413,-2383,-1995,-1316,-577,29,462,774,1002,1136,1181,1195,1246,1333,1367,1262,1028,779,635,611,603,489,238,-57,-245,-229,-30,218,346,243,-87,-532,-952,-1251,-1405,-1438,-1389,-1292,-1179,-1061,-931,-774,-594,-423,-287,-190,-110,-32,40,96,152,235,357,486,565,562,493,406,333,267,172,32,-134,-280,-370,-401,-404,-418,-459,-509,-532,-514,-479,-474,-525,-624,-728,-793,-785,-686,-505,-287,-101,0,10,-28,-64,-72,-59,-42,-34,-36,-38,-25,12,69,131,174,181,148,85,17,-36,-65,-84,-115,-168,-235,-291,-312,-290,-240,-193,-179,-203,-243,-268,-267,-253,-243,-244,-246,-236,-203,-145,-69,10,67,84,57,2,-59,-105,-128,-135,-136,-135,-127,-104,-66,-27,-2,4,-10,-42,-88,-138,-177,-203,-218,-225,-221,-200,-164,-127,-101,-90,-96,-118,-152,-185,-204,-200,-172,-127,-73,-18,26,56,68,61,34,-7,-52,-87,-108,-117,-114,-100,-77,-54,-34,-20,-14,-21,-47,-87,-121,-139,-139,-124,-95,-54,-21,-18,-44,-67,-58,-22},
            {1,-2,-8,-6,1,3,-2,-3,5,9,0,-8,1,14,5,-19,-20,7,19,-11,-36,-8,39,23,-45,-49,38,69,-25,91,1026,2973,5177,6234,5126,2055,-1616,-4225,-4795,-3548,-1692,-550,-488,-496,975,4418,8414,10551,9424,5856,2199,488,1135,3046,4633,4741,3070,204,-2679,-4436,-4663,-3921,-3226,-3257,-3944,-4712,-4996,-4590,-3691,-2748,-2211,-2241,-2563,-2655,-2193,-1325,-501,-29,189,465,956,1513,1889,2000,1946,1830,1628,1288,887,626,645,869,1053,981,624,136,-255,-388,-256,-6,148,66,-240,-661,-1097,-1504,-1840,-2037,-2055,-1945,-1819,-1723,-1593,-1341,-975,-613,-373,-271,-235,-184,-85,47,185,305,400,490,600,728,825,828,712,512,292,111,-2,-40,-16,37,66,26,-81,-204,-278,-279,-244,-243,-320,-461,-609,-707,-732,-692,-606,-499,-395,-314,-266,-246,-239,-233,-225,-216,-212,-211,-199,-155,-69,47,161,235,247,201,125,60,28,17,-7,-66,-147,-215,-240,-220,-170,-111,-66,-58,-91,-151,-209,-247,-269,-287,-307,-319,-306,-260,-187,-105,-34,9,14,-15,-67,-122,-165,-190,-202,-205,-201,-181,-143,-90,-35,10,32,23,-22,-89,-153,-196,-213,-217,-214,-205,-183,-151,-118,-91,-77,-76,-84,-96,-104,-106,-100,-84,-58,-21,21,63,95,105,82,30,-34,-91,-132,-158,-166,-154,-127,-93,-62,-30,-3,6,-21,-79,-139,-180,-197,-195,-175,-135,-87,-49,-26,-7,7,-4,-51,-113,-162,-197,-236,-273,-265,-182,-62}
        },
        {    // H20e175a.wav
            {-5,-2,2,1,-3,-2,-1,-3,-7,-6,0,3,-1,-3,3,9,2,-7,-3,8,5,-13,-19,1,16,-1,-26,-13,26,25,-26,-43,20,67,10,69,758,2356,4327,5420,4562,1805,-1552,-3836,-4133,-2825,-1173,-305,-341,-316,971,3797,7023,8810,8035,5197,2057,362,719,2405,4017,4360,3053,633,-1819,-3338,-3628,-3145,-2660,-2680,-3178,-3762,-4023,-3800,-3231,-2638,-2318,-2346,-2510,-2477,-2061,-1353,-606,-10,422,774,1089,1326,1432,1414,1337,1261,1199,1132,1047,953,868,789,684,509,251,-43,-272,-331,-184,82,295,288,3,-475,-985,-1376,-1583,-1627,-1578,-1494,-1392,-1256,-1066,-838,-619,-454,-351,-281,-206,-103,27,168,286,352,365,365,410,521,653,730,694,549,344,138,-21,-121,-182,-242,-332,-440,-525,-551,-522,-485,-493,-572,-710,-858,-951,-933,-790,-565,-343,-197,-139,-129,-111,-68,-17,13,16,-2,-31,-66,-93,-87,-32,60,148,194,187,146,98,57,25,-5,-45,-107,-187,-266,-314,-312,-266,-205,-162,-157,-188,-238,-284,-312,-320,-314,-299,-275,-240,-187,-116,-35,37,77,73,31,-25,-72,-100,-112,-116,-119,-120,-119,-111,-92,-63,-36,-23,-29,-51,-81,-118,-157,-193,-219,-232,-230,-212,-176,-128,-86,-66,-73,-103,-145,-185,-209,-208,-180,-132,-74,-14,39,75,82,60,20,-27,-71,-107,-122,-115,-91,-64,-39,-16,2,7,-5,-29,-59,-94,-136,-171,-179,-154,-116,-84,-60,-35,-23,-43,-90,-123,-101,-39},
            {-2,-1,2,-2,-7,-5,2,4,-1,-3,5,9,1,-7,0,13,5,-17,-20,5,19,-6,-31,-8,35,24,-35,-44,32,67,-9,97,957,2796,4942,6034,5000,1961,-1719,-4295,-4746,-3361,-1458,-368,-365,-381,1067,4364,8114,10063,8940,5526,2017,343,950,2836,4453,4621,3021,255,-2493,-4125,-4302,-3600,-2989,-3078,-3759,-4465,-4670,-4229,-3389,-2601,-2239,-2356,-2636,-2629,-2123,-1302,-545,-62,245,596,1059,1505,1782,1867,1826,1688,1422,1047,717,619,790,1048,1127,895,437,-36,-334,-388,-241,-14,145,122,-121,-535,-1020,-1472,-1801,-1949,-1922,-1799,-1670,-1563,-1423,-1185,-862,-542,-307,-172,-101,-63,-42,-21,35,150,309,475,617,719,775,773,709,590,434,261,98,-17,-55,-25,18,6,-91,-244,-393,-495,-549,-585,-628,-680,-720,-731,-704,-643,-559,-464,-372,-292,-225,-165,-111,-70,-50,-58,-88,-125,-152,-146,-89,13,130,218,243,203,129,60,17,-3,-25,-71,-140,-210,-254,-251,-207,-142,-87,-73,-110,-182,-258,-309,-332,-337,-336,-327,-296,-234,-148,-54,21,58,49,8,-44,-91,-127,-154,-169,-174,-170,-159,-136,-94,-37,12,32,14,-28,-79,-130,-178,-215,-234,-232,-215,-189,-156,-121,-89,-72,-76,-99,-129,-150,-151,-132,-101,-62,-13,45,95,115,96,48,-9,-67,-123,-163,-172,-149,-114,-82,-51,-14,23,38,18,-25,-71,-112,-146,-165,-163,-143,-120,-100,-79,-57,-44,-46,-56,-66,-95,-158,-233,-254,-185,-66}
        },
        {    // H20e180a.wav
            {2,1,-2,-2,-1,-4,-8,-5,2,3,-3,-5,3,8,1,-9,-3,9,5,-16,-21,2,18,-2,-29,-13,27,23,-31,-45,23,66,2,85,859,2583,4656,5762,4805,1867,-1701,-4152,-4499,-3100,-1282,-297,-329,-331,1052,4136,7625,9467,8479,5326,1993,310,799,2599,4231,4497,3041,436,-2172,-3741,-3964,-3372,-2836,-2900,-3482,-4103,-4312,-3973,-3280,-2613,-2293,-2374,-2590,-2560,-2095,-1338,-594,-51,335,705,1103,1450,1651,1690,1607,1432,1190,948,813,847,984,1058,939,631,248,-82,-284,-330,-224,-19,167,192,-26,-453,-961,-1409,-1703,-1818,-1791,-1687,-1555,-1402,-1206,-960,-705,-499,-363,-268,-170,-57,48,117,150,180,244,364,524,678,772,780,709,590,446,292,140,10,-82,-138,-183,-236,-302,-370,-435,-513,-621,-754,-867,-908,-860,-750,-629,-529,-452,-385,-319,-250,-173,-89,-9,47,59,26,-38,-107,-150,-143,-82,17,120,192,216,196,148,93,44,0,-50,-111,-176,-231,-265,-271,-247,-197,-145,-121,-145,-206,-273,-321,-344,-351,-345,-322,-271,-195,-105,-23,37,66,64,33,-21,-81,-126,-144,-139,-131,-131,-130,-114,-82,-49,-25,-15,-19,-42,-81,-127,-165,-191,-213,-232,-238,-218,-175,-123,-81,-61,-65,-93,-133,-171,-193,-190,-158,-101,-31,33,75,89,77,42,-10,-66,-109,-130,-134,-125,-104,-70,-31,2,24,37,35,5,-49,-108,-151,-175,-186,-179,-146,-96,-58,-48,-50,-43,-43,-82,-153,-193,-153,-56},
            {2,1,-2,-2,-1,-4,-8,-5,2,3,-3,-5,3,8,1,-9,-3,9,5,-16,-21,2,18,-2,-29,-13,27,23,-31,-45,23,66,2,85,859,2583,4656,5762,4805,1867,-1701,-4152,-4499,-3100,-1282,-297,-329,-331,1052,4136,7625,9467,8479,5326,1993,310,799,2599,4231,4497,3041,436,-2172,-3741,-3964,-3372,-2836,-2900,-3482,-4103,-4312,-3973,-3280,-2613,-2293,-2374,-2590,-2560,-2095,-1338,-594,-51,335,705,1103,1450,1651,1690,1607,1432,1190,948,813,847,984,1058,939,631,248,-82,-284,-330,-224,-19,167,192,-26,-453,-961,-1409,-1703,-1818,-1791,-1687,-1555,-1402,-1206,-960,-705,-499,-363,-268,-170,-57,48,117,150,180,244,364,524,678,772,780,709,590,446,292,140,10,-82,-138,-183,-236,-302,-370,-435,-513,-621,-754,-867,-908,-860,-750,-629,-529,-452,-385,-319,-250,-173,-89,-9,47,59,26,-38,-107,-150,-143,-82,17,120,192,216,196,148,93,44,0,-50,-111,-176,-231,-265,-271,-247,-197,-145,-121,-145,-206,-273,-321,-344,-351,-345,-322,-271,-195,-105,-23,37,66,64,33,-21,-81,-126,-144,-139,-131,-131,-130,-114,-82,-49,-25,-15,-19,-42,-81,-127,-165,-191,-213,-232,-238,-218,-175,-123,-81,-61,-65,-93,-133,-171,-193,-190,-158,-101,-31,33,75,89,77,42,-10,-66,-109,-130,-134,-125,-104,-70,-31,2,24,37,35,5,-49,-108,-151,-175,-186,-179,-146,-96,-58,-48,-50,-43,-43,-82,-153,-193,-153,-56}
        }
    },
    {    // elev30 
        {    // H30e000a.wav
            {-4,16,19,-10,-24,10,41,4,-54,-31,53,58,-48,-98,20,138,39,-152,-102,155,169,-94,299,2302,5288,7051,5984,2932,214,-1169,-2497,-5048,-7586,-7238,-3014,2482,5566,5344,4395,5614,9015,11901,11679,8074,2991,-1063,-2400,-915,1818,3359,2064,-1616,-5549,-7795,-8074,-7440,-6851,-6355,-5569,-4512,-3651,-3260,-3042,-2519,-1654,-914,-693,-775,-505,501,1870,2783,2768,2127,1587,1592,2003,2388,2459,2209,1790,1389,1148,1049,877,427,-197,-594,-496,-114,70,-151,-496,-580,-379,-211,-325,-666,-1030,-1319,-1552,-1710,-1716,-1561,-1342,-1149,-960,-709,-414,-183,-92,-104,-107,-9,219,547,898,1177,1311,1296,1201,1108,1059,1025,919,646,183,-386,-914,-1298,-1527,-1640,-1645,-1533,-1345,-1184,-1148,-1237,-1364,-1437,-1416,-1301,-1092,-797,-460,-156,52,154,178,159,123,97,104,143,185,189,154,117,126,191,283,363,408,406,349,235,85,-66,-186,-268,-325,-368,-406,-448,-490,-516,-501,-443,-370,-317,-298,-306,-326,-344,-345,-316,-254,-173,-85,8,103,185,225,212,157,79,-8,-89,-145,-162,-146,-119,-95,-66,-26,19,51,57,34,-24,-118,-227,-313,-343,-321,-274,-226,-181,-138,-105,-94,-106,-138,-180,-226,-260,-265,-235,-178,-105,-29,47,110,149,151,117,55,-21,-95,-150,-176,-178,-166,-145,-118,-88,-64,-55,-63,-86,-122,-164,-196,-207,-195,-170,-137,-94,-40,18,65,88,86,63,24,-24,-68,-95,-100,-86,-62,-31,1,27,34,20,-1,-12,-8},
            {-4,16,19,-10,-24,10,41,4,-54,-31,53,58,-48,-98,20,138,39,-152,-102,155,169,-94,299,2302,5288,7051,5984,2932,214,-1169,-2497,-5048,-7586,-7238,-3014,2482,5566,5344,4395,5614,9015,11901,11679,8074,2991,-1063,-2400,-915,1818,3359,2064,-1616,-5549,-7795,-8074,-7440,-6851,-6355,-5569,-4512,-3651,-3260,-3042,-2519,-1654,-914,-693,-775,-505,501,1870,2783,2768,2127,1587,1592,2003,2388,2459,2209,1790,1389,1148,1049,877,427,-197,-594,-496,-114,70,-151,-496,-580,-379,-211,-325,-666,-1030,-1319,-1552,-1710,-1716,-1561,-1342,-1149,-960,-709,-414,-183,-92,-104,-107,-9,219,547,898,1177,1311,1296,1201,1108,1059,1025,919,646,183,-386,-914,-1298,-1527,-1640,-1645,-1533,-1345,-1184,-1148,-1237,-1364,-1437,-1416,-1301,-1092,-797,-460,-156,52,154,178,159,123,97,104,143,185,189,154,117,126,191,283,363,408,406,349,235,85,-66,-186,-268,-325,-368,-406,-448,-490,-516,-501,-443,-370,-317,-298,-306,-326,-344,-345,-316,-254,-173,-85,8,103,185,225,212,157,79,-8,-89,-145,-162,-146,-119,-95,-66,-26,19,51,57,34,-24,-118,-227,-313,-343,-321,-274,-226,-181,-138,-105,-94,-106,-138,-180,-226,-260,-265,-235,-178,-105,-29,47,110,149,151,117,55,-21,-95,-150,-176,-178,-166,-145,-118,-88,-64,-55,-63,-86,-122,-164,-196,-207,-195,-170,-137,-94,-40,18,65,88,86,63,24,-24,-68,-95,-100,-86,-62,-31,1,27,34,20,-1,-12,-8}
        },
        {    // H30e006a.wav
            {3,-4,6,20,10,-13,-8,26,29,-17,-43,5,59,19,-65,-47,73,102,-36,-127,16,178,47,-42,854,3084,5448,6060,4343,1704,-168,-1277,-2908,-5306,-6639,-4953,-778,3048,4363,3918,4240,6603,9647,10924,9260,5527,1640,-748,-932,616,2393,2672,763,-2410,-5163,-6535,-6838,-6840,-6740,-6160,-4948,-3622,-2876,-2825,-2920,-2596,-1849,-1120,-717,-467,30,881,1740,2167,2080,1807,1712,1866,2075,2148,2050,1851,1623,1411,1215,946,497,-71,-466,-415,-11,314,222,-169,-444,-379,-156,-105,-341,-721,-1076,-1358,-1572,-1676,-1622,-1445,-1227,-1004,-750,-468,-235,-128,-124,-101,59,381,768,1058,1122,967,745,638,704,840,886,760,486,125,-274,-668,-1001,-1230,-1349,-1370,-1305,-1172,-1025,-942,-959,-1040,-1113,-1143,-1137,-1091,-967,-731,-423,-149,-1,13,-38,-76,-67,-16,56,125,160,143,89,45,55,125,220,303,352,356,306,203,70,-60,-170,-263,-343,-404,-438,-445,-438,-421,-392,-349,-303,-267,-247,-241,-244,-242,-222,-179,-126,-76,-27,31,96,145,154,123,69,5,-61,-118,-148,-142,-114,-88,-72,-56,-32,-3,21,30,17,-28,-102,-183,-240,-263,-262,-247,-220,-177,-128,-91,-78,-88,-116,-158,-204,-233,-227,-191,-140,-87,-29,35,93,124,121,87,37,-18,-71,-114,-141,-149,-140,-120,-93,-67,-49,-47,-64,-96,-138,-178,-204,-212,-201,-173,-128,-69,-3,54,87,93,75,42,3,-33,-59,-71,-69,-57,-38,-13,17,42,51,38,14},
            {28,-10,-34,5,49,11,-65,-49,56,80,-45,-125,2,161,67,-173,-149,162,227,-101,194,2326,5771,8032,7050,3568,253,-1521,-3061,-5907,-8825,-8560,-3818,2585,6410,6438,5405,6545,9997,12941,12645,8787,3252,-1421,-3328,-2007,1132,3349,2428,-1503,-6103,-8938,-9396,-8531,-7478,-6462,-5272,-4110,-3515,-3582,-3653,-2985,-1616,-385,-44,-443,-654,82,1577,2888,3234,2682,1951,1656,1854,2216,2429,2368,2047,1584,1191,1006,908,615,66,-431,-537,-318,-176,-341,-598,-611,-377,-232,-427,-867,-1288,-1560,-1710,-1754,-1644,-1397,-1148,-1008,-934,-786,-497,-162,50,22,-223,-509,-575,-228,482,1255,1744,1808,1585,1340,1237,1237,1171,889,382,-221,-755,-1146,-1427,-1644,-1782,-1794,-1697,-1586,-1546,-1555,-1523,-1401,-1228,-1071,-944,-799,-591,-320,-25,234,398,423,326,194,123,146,203,216,168,120,132,207,303,386,446,469,424,290,98,-81,-203,-274,-329,-387,-439,-478,-500,-498,-462,-398,-337,-313,-332,-375,-416,-438,-430,-383,-303,-206,-106,-2,104,199,263,283,260,190,72,-70,-183,-226,-203,-153,-105,-59,-7,40,63,59,28,-34,-136,-261,-361,-397,-367,-306,-245,-193,-150,-117,-99,-102,-127,-173,-229,-273,-281,-249,-183,-92,14,118,194,220,197,139,58,-35,-123,-186,-212,-211,-200,-183,-151,-100,-46,-11,-12,-47,-99,-152,-192,-214,-215,-191,-145,-86,-26,28,74,102,99,64,13,-34,-66,-90,-104,-101,-72,-31,6,30,41,37,8,-37,-69,-61,-23}
        },
        {    // H30e012a.wav
            {-3,3,0,-3,5,15,8,-10,-7,18,22,-13,-35,-2,41,15,-48,-40,47,75,-24,-95,7,129,34,-37,655,2450,4488,5254,4115,1999,257,-893,-2290,-4211,-5443,-4496,-1514,1615,3221,3544,4169,6017,8297,9384,8379,5710,2616,367,-273,603,1964,2396,1140,-1327,-3810,-5469,-6289,-6600,-6459,-5698,-4439,-3273,-2765,-2894,-3083,-2790,-2001,-1151,-626,-402,-137,421,1162,1744,1941,1835,1687,1668,1758,1846,1863,1805,1680,1481,1185,777,292,-126,-271,-61,314,492,279,-149,-434,-399,-201,-123,-287,-610,-955,-1245,-1447,-1525,-1465,-1306,-1095,-839,-537,-255,-105,-140,-266,-302,-114,284,741,1057,1092,848,485,218,175,318,498,560,428,113,-300,-691,-959,-1078,-1096,-1077,-1044,-990,-920,-861,-830,-809,-781,-766,-799,-871,-910,-842,-659,-426,-228,-112,-79,-101,-141,-154,-113,-32,36,46,5,-36,-30,27,108,182,236,256,228,150,43,-61,-148,-223,-295,-357,-396,-410,-404,-378,-331,-269,-210,-174,-163,-166,-172,-169,-150,-119,-87,-64,-47,-19,25,70,91,76,31,-30,-92,-142,-168,-168,-153,-138,-122,-98,-64,-31,-7,3,-2,-30,-83,-148,-201,-230,-240,-242,-232,-206,-166,-125,-95,-84,-92,-119,-155,-187,-200,-190,-159,-111,-48,20,75,102,98,68,21,-31,-82,-122,-149,-165,-166,-149,-118,-83,-59,-53,-67,-98,-138,-175,-196,-196,-181,-157,-125,-85,-40,3,36,53,49,23,-15,-52,-75,-85,-86,-74,-44,-4,25,28,11},
            {-30,12,55,14,-72,-63,51,91,-33,-135,-18,167,96,-169,-188,138,264,-84,63,2121,5849,8733,8284,4780,875,-1645,-3711,-6851,-9968,-9742,-4676,2369,6758,6963,5900,7251,11251,14626,14136,9502,3160,-1882,-3750,-2322,786,2903,1951,-1932,-6493,-9358,-9933,-9284,-8481,-7525,-5961,-4028,-2710,-2637,-3272,-3415,-2454,-945,74,210,58,443,1475,2484,2813,2513,2156,2130,2307,2377,2261,2087,1909,1672,1400,1212,1082,797,260,-271,-452,-314,-250,-488,-776,-726,-368,-149,-407,-1004,-1551,-1844,-1947,-1942,-1788,-1460,-1078,-806,-662,-526,-329,-155,-145,-339,-620,-791,-687,-268,360,1003,1493,1762,1825,1731,1538,1311,1089,845,510,72,-400,-838,-1247,-1656,-2016,-2206,-2168,-1982,-1773,-1579,-1359,-1117,-946,-921,-967,-919,-682,-317,39,305,468,529,479,346,214,160,179,201,179,136,129,173,239,308,384,461,490,411,218,-23,-232,-370,-444,-477,-484,-477,-466,-452,-422,-375,-332,-318,-344,-394,-446,-475,-463,-405,-314,-214,-117,-8,119,247,336,362,326,234,97,-60,-188,-244,-230,-183,-133,-83,-27,22,46,42,13,-49,-154,-287,-400,-449,-437,-393,-336,-266,-188,-123,-92,-93,-115,-155,-214,-267,-279,-230,-139,-37,62,153,225,257,235,170,80,-22,-125,-211,-265,-282,-267,-224,-155,-73,-2,35,33,-2,-62,-137,-205,-246,-256,-241,-201,-132,-37,57,116,129,106,64,8,-50,-94,-111,-108,-98,-80,-42,8,44,48,33,19,2,-41,-105,-143,-117,-45}
        },
        {    // H30e018a.wav
            {-1,-5,-3,1,0,-3,2,11,9,-5,-8,9,17,-5,-27,-9,26,18,-30,-39,20,58,2,-63,-13,80,35,-32,423,1780,3538,4509,3949,2330,741,-389,-1586,-3241,-4613,-4394,-2256,580,2542,3280,3786,5048,6881,8138,7839,5961,3348,1137,185,637,1770,2379,1604,-428,-2804,-4625,-5590,-5873,-5670,-5038,-4121,-3292,-2909,-2956,-3028,-2715,-1994,-1220,-749,-591,-428,33,752,1401,1695,1645,1494,1453,1543,1666,1745,1761,1694,1506,1178,759,354,81,25,171,362,381,146,-190,-364,-271,-70,-12,-199,-525,-824,-1016,-1114,-1147,-1119,-1032,-895,-719,-532,-395,-370,-452,-529,-457,-175,235,595,752,661,411,164,50,92,217,331,372,313,133,-162,-506,-788,-930,-941,-890,-824,-755,-685,-640,-639,-660,-663,-642,-637,-680,-747,-771,-715,-593,-451,-323,-226,-167,-150,-165,-183,-186,-176,-165,-154,-126,-71,-6,39,56,59,67,82,88,69,19,-56,-142,-217,-265,-284,-286,-285,-278,-253,-202,-136,-80,-52,-56,-82,-114,-135,-137,-124,-102,-77,-46,-12,16,28,19,-7,-44,-89,-137,-177,-202,-210,-200,-173,-130,-79,-33,-4,1,-16,-53,-102,-151,-189,-212,-223,-222,-207,-177,-139,-105,-81,-72,-80,-102,-129,-148,-149,-137,-118,-93,-56,-9,36,62,65,43,2,-52,-109,-154,-177,-178,-164,-144,-122,-100,-80,-66,-62,-68,-86,-110,-135,-152,-160,-157,-145,-123,-92,-56,-23,-1,5,-4,-23,-46,-66,-76,-72,-55,-32,-11,-1},
            {43,14,-62,-63,41,95,-16,-133,-39,160,130,-138,-212,95,289,-38,-98,1629,5342,8868,9462,6648,2512,-992,-4103,-7833,-11127,-10963,-5903,1406,6401,7238,6432,7659,11608,15407,15675,11501,4803,-1301,-4261,-3295,78,2721,2007,-2075,-6976,-9959,-10381,-9599,-8978,-8487,-7283,-5178,-3083,-2032,-2096,-2427,-2225,-1479,-737,-310,99,942,2123,2957,2897,2180,1607,1711,2285,2733,2715,2329,1836,1419,1196,1213,1310,1156,613,-28,-341,-288,-258,-523,-841,-788,-365,-63,-309,-1001,-1698,-2100,-2213,-2132,-1875,-1472,-1062,-781,-616,-468,-342,-349,-518,-693,-688,-501,-280,-111,108,532,1149,1732,2020,1924,1576,1196,915,713,509,255,-54,-451,-1004,-1710,-2398,-2790,-2704,-2201,-1536,-977,-680,-666,-856,-1101,-1224,-1113,-780,-337,97,450,675,723,587,351,162,113,168,211,181,125,118,177,253,305,342,383,414,385,266,72,-156,-368,-519,-577,-550,-488,-448,-439,-426,-387,-337,-313,-325,-353,-383,-409,-423,-408,-352,-259,-137,14,181,327,411,417,367,277,145,-21,-177,-267,-277,-237,-181,-116,-40,31,67,55,4,-76,-186,-317,-433,-498,-505,-473,-418,-342,-248,-158,-99,-85,-104,-141,-184,-219,-229,-204,-145,-59,48,167,275,341,339,266,138,-14,-156,-261,-312,-311,-271,-204,-122,-35,39,80,73,20,-63,-152,-226,-272,-287,-271,-227,-156,-64,33,112,150,139,90,24,-42,-100,-140,-152,-131,-91,-46,1,49,86,89,56,13,-16,-45,-103,-179,-214,-164,-59}
        },
        {    // H30e024a.wav
            {-2,1,0,-5,-6,-1,1,-1,1,8,9,-2,-8,3,15,3,-20,-15,16,23,-12,-36,1,48,25,-40,-34,43,46,-21,214,1165,2643,3763,3725,2628,1281,192,-939,-2508,-4021,-4282,-2697,-113,1946,2801,3152,4072,5719,7170,7363,6028,3807,1735,654,818,1730,2380,1900,206,-1968,-3710,-4614,-4858,-4776,-4499,-4024,-3461,-3039,-2870,-2790,-2524,-1990,-1395,-1005,-850,-687,-260,411,1044,1374,1395,1314,1316,1418,1546,1661,1757,1778,1617,1234,732,299,76,79,220,361,372,212,-24,-170,-137,-3,68,-17,-214,-426,-601,-751,-893,-1010,-1065,-1031,-908,-739,-605,-582,-657,-718,-630,-357,0,280,373,289,137,42,65,168,263,293,270,229,160,9,-245,-533,-743,-809,-753,-650,-559,-509,-506,-540,-582,-601,-594,-587,-605,-638,-659,-648,-610,-554,-481,-391,-302,-241,-221,-234,-265,-302,-332,-333,-286,-198,-104,-44,-24,-19,-2,32,66,80,66,25,-31,-88,-130,-151,-160,-169,-174,-163,-128,-81,-44,-31,-41,-62,-86,-109,-133,-152,-160,-148,-117,-72,-29,-2,0,-20,-56,-102,-150,-193,-222,-231,-219,-188,-144,-99,-67,-50,-47,-52,-66,-94,-130,-166,-188,-195,-186,-164,-130,-93,-65,-54,-59,-71,-86,-101,-115,-124,-124,-114,-96,-71,-42,-15,3,7,-5,-30,-62,-97,-128,-148,-157,-158,-152,-140,-118,-90,-63,-48,-49,-63,-87,-114,-137,-152,-156,-151,-139,-118,-89,-58,-35,-24,-22,-24,-30,-45,-63,-68,-49,-18},
            {-38,-64,14,85,4,-127,-74,130,157,-93,-235,28,303,41,-253,941,4325,8308,10135,8586,4897,796,-3486,-8336,-12380,-12572,-7517,92,5557,6849,6387,7878,12035,15975,16394,12572,6441,716,-2612,-2828,-758,1365,1174,-1957,-6326,-9507,-10523,-10263,-9941,-9628,-8518,-6301,-3825,-2278,-1978,-2154,-1881,-1042,-274,-70,-121,326,1528,2851,3414,3006,2220,1748,1752,1970,2177,2319,2304,1985,1437,1013,946,1028,870,434,55,-79,-197,-556,-948,-904,-361,122,-54,-872,-1776,-2297,-2412,-2306,-2033,-1542,-945,-547,-567,-900,-1201,-1177,-792,-267,94,109,-143,-354,-219,327,1065,1665,1912,1804,1491,1159,917,753,572,288,-122,-643,-1266,-1948,-2538,-2793,-2547,-1886,-1120,-568,-379,-503,-798,-1105,-1273,-1195,-860,-378,96,455,662,710,612,417,225,127,128,161,167,155,165,205,246,266,288,335,387,381,275,79,-159,-381,-543,-620,-617,-570,-519,-474,-425,-369,-322,-296,-287,-285,-298,-335,-375,-382,-338,-255,-145,-2,171,337,441,465,431,354,220,25,-178,-309,-334,-288,-221,-148,-63,17,60,51,4,-70,-181,-328,-474,-566,-586,-554,-494,-410,-302,-190,-102,-58,-58,-97,-166,-240,-283,-272,-209,-107,23,171,309,395,405,336,207,46,-113,-231,-287,-285,-246,-187,-110,-26,44,78,68,18,-62,-158,-246,-303,-321,-307,-266,-194,-92,18,105,145,139,98,36,-34,-98,-146,-171,-170,-138,-78,-6,57,98,112,101,65,11,-45,-95,-142,-189,-216,-195,-123,-38}
        },
        {    // H30e030a.wav
            {2,-2,-3,0,1,-3,-5,-2,2,1,-1,3,7,1,-6,-1,10,6,-13,-16,7,22,-2,-32,-14,34,37,-19,-44,12,48,-6,66,657,1824,2993,3397,2829,1780,744,-363,-1847,-3401,-4013,-2969,-772,1235,2208,2555,3277,4733,6233,6763,5920,4148,2316,1178,1049,1661,2255,2032,747,-1092,-2676,-3561,-3883,-3997,-4039,-3904,-3533,-3076,-2739,-2548,-2348,-2017,-1610,-1281,-1076,-865,-482,82,654,1043,1205,1247,1288,1369,1479,1603,1701,1676,1433,1005,573,324,290,359,407,396,345,268,183,137,176,264,290,170,-68,-326,-542,-730,-920,-1091,-1181,-1150,-1029,-902,-850,-898,-982,-984,-807,-464,-83,176,229,120,-22,-73,7,168,316,392,394,346,251,87,-144,-389,-571,-642,-616,-541,-466,-425,-432,-483,-549,-592,-596,-576,-557,-552,-560,-574,-586,-587,-567,-523,-465,-407,-364,-342,-347,-369,-390,-387,-347,-278,-198,-124,-61,-10,32,63,85,97,99,88,62,20,-29,-72,-101,-112,-107,-87,-60,-39,-35,-48,-69,-90,-108,-124,-142,-158,-172,-179,-170,-139,-96,-61,-51,-64,-85,-106,-130,-162,-194,-216,-221,-213,-197,-169,-130,-88,-55,-40,-43,-59,-86,-118,-146,-157,-149,-126,-98,-73,-54,-43,-40,-48,-69,-99,-128,-146,-152,-147,-131,-103,-66,-32,-12,-9,-18,-33,-53,-78,-104,-125,-140,-151,-157,-152,-135,-108,-80,-61,-55,-63,-81,-100,-116,-126,-134,-135,-127,-111,-92,-74,-57,-39,-30,-38,-57,-65,-49,-17},
            {-30,79,56,-93,-119,72,189,-8,-245,-87,282,196,-277,211,2899,7027,10073,10132,7502,3519,-1412,-7425,-12971,-14576,-10123,-1973,4587,6497,5812,6910,11355,16300,17713,14279,8018,2066,-1399,-1774,32,1837,1308,-2179,-6757,-9721,-10128,-9455,-9592,-10585,-10741,-8774,-5377,-2521,-1493,-1856,-2227,-1754,-698,220,730,1148,1765,2395,2652,2521,2400,2547,2720,2513,1946,1470,1410,1613,1733,1651,1457,1157,686,189,-3,172,277,-125,-825,-1112,-633,100,243,-470,-1528,-2277,-2516,-2416,-2114,-1628,-1102,-867,-1102,-1554,-1709,-1286,-491,195,438,257,-74,-268,-180,185,722,1275,1668,1775,1601,1292,1012,797,537,103,-514,-1206,-1826,-2244,-2343,-2078,-1565,-1067,-808,-784,-809,-750,-666,-698,-847,-943,-825,-503,-124,187,401,523,543,458,329,239,218,220,196,153,133,153,187,224,286,386,473,456,299,53,-191,-383,-531,-644,-705,-698,-637,-557,-475,-384,-283,-197,-154,-166,-216,-281,-332,-348,-317,-242,-133,7,172,339,462,504,465,362,212,31,-146,-270,-317,-301,-254,-190,-107,-21,40,57,33,-31,-146,-312,-492,-623,-665,-626,-539,-426,-295,-165,-65,-21,-32,-88,-175,-271,-338,-344,-282,-169,-28,126,274,380,413,366,262,134,10,-95,-169,-207,-211,-186,-133,-58,25,85,97,52,-39,-150,-253,-327,-361,-354,-308,-231,-130,-21,73,133,149,122,64,-9,-83,-143,-179,-184,-155,-97,-23,48,101,126,123,95,49,-12,-80,-141,-180,-190,-177,-150,-112,-66,-22}
        },
        {    // H30e036a.wav
            {-5,-1,2,0,-2,-1,0,-2,-4,-2,2,1,-3,-1,5,4,-4,-6,5,10,-1,-12,-2,15,7,-21,-22,17,39,2,-39,-14,38,15,-1,306,1144,2232,2929,2837,2138,1239,208,-1162,-2709,-3627,-3134,-1392,512,1630,2047,2605,3820,5279,6086,5727,4428,2855,1664,1231,1524,2060,2129,1303,-192,-1676,-2621,-3036,-3263,-3501,-3633,-3478,-3076,-2658,-2391,-2228,-2023,-1733,-1442,-1225,-1023,-690,-166,435,905,1121,1122,1055,1054,1170,1370,1556,1595,1405,1040,679,486,475,539,582,601,620,608,507,328,173,118,120,65,-102,-340,-576,-785,-981,-1155,-1263,-1276,-1219,-1154,-1127,-1135,-1117,-994,-725,-365,-48,100,61,-61,-126,-67,83,251,385,467,490,437,300,94,-130,-319,-441,-493,-495,-469,-436,-415,-425,-469,-526,-564,-566,-539,-510,-508,-538,-590,-638,-661,-648,-609,-560,-511,-462,-412,-368,-342,-335,-331,-309,-259,-195,-135,-86,-36,24,87,129,133,104,72,57,55,44,7,-45,-86,-97,-80,-50,-24,-15,-26,-59,-106,-153,-182,-189,-181,-176,-180,-186,-181,-162,-136,-113,-96,-86,-85,-103,-141,-185,-216,-224,-216,-199,-173,-132,-82,-38,-13,-7,-13,-31,-62,-100,-133,-144,-131,-105,-79,-63,-58,-60,-69,-83,-101,-122,-141,-151,-149,-136,-117,-93,-62,-30,-7,-5,-24,-53,-82,-105,-123,-137,-146,-149,-145,-134,-114,-89,-66,-55,-55,-66,-81,-97,-111,-117,-117,-112,-104,-90,-72,-59,-60,-70,-71,-51,-18},
            {74,-68,-144,7,193,96,-190,-200,159,309,-116,-255,1391,5080,9015,10869,9827,6566,1622,-4988,-11984,-15855,-13361,-5394,2835,6523,5945,5649,9085,14812,18259,16487,10615,4149,-34,-1081,176,1913,2040,-594,-5110,-9087,-10662,-10187,-9560,-10002,-10794,-10308,-7956,-4856,-2638,-1900,-1933,-1762,-1124,-397,174,843,1882,2996,3513,3161,2446,2096,2288,2581,2551,2227,1860,1530,1197,968,1028,1267,1269,815,217,-71,-50,-139,-511,-783,-530,55,283,-264,-1279,-2100,-2359,-2173,-1861,-1677,-1759,-2090,-2393,-2232,-1417,-301,461,509,95,-240,-215,20,193,257,390,729,1186,1548,1680,1593,1347,935,311,-497,-1322,-1927,-2141,-1954,-1503,-1006,-682,-651,-858,-1092,-1133,-928,-621,-417,-401,-498,-574,-554,-440,-257,-28,209,384,448,418,364,333,303,226,104,13,24,138,288,411,482,494,432,289,93,-112,-301,-480,-644,-761,-798,-765,-693,-588,-436,-251,-97,-37,-77,-165,-246,-294,-302,-263,-180,-73,41,165,299,415,466,432,333,202,56,-95,-223,-300,-319,-301,-257,-181,-74,32,93,85,5,-137,-322,-502,-620,-646,-598,-515,-418,-304,-186,-93,-48,-53,-94,-166,-255,-331,-356,-318,-234,-127,-1,143,281,373,394,347,257,143,20,-95,-181,-224,-217,-164,-78,17,92,120,90,9,-104,-220,-314,-370,-388,-369,-312,-217,-97,21,109,151,145,101,29,-56,-136,-192,-208,-178,-111,-29,46,100,128,127,99,51,-5,-62,-120,-169,-193,-181,-145,-111,-91,-76,-49,-15}
        },
        {    // H30e042a.wav
            {-1,-3,-4,-1,2,1,-2,-3,-1,-2,-3,-3,1,2,-1,-2,1,2,-2,-4,4,12,5,-10,-9,7,11,-10,-23,1,33,20,-27,-33,16,34,-3,100,611,1505,2350,2662,2345,1646,733,-475,-1928,-3066,-3133,-1962,-274,987,1573,2050,3016,4365,5386,5472,4607,3273,2067,1422,1460,1904,2168,1736,598,-745,-1744,-2270,-2584,-2928,-3246,-3315,-3061,-2648,-2293,-2069,-1902,-1709,-1483,-1250,-1004,-704,-335,51,366,566,687,815,1011,1258,1478,1575,1495,1264,996,834,846,953,996,886,676,489,379,298,189,65,-23,-72,-136,-264,-444,-639,-837,-1038,-1219,-1324,-1326,-1263,-1200,-1170,-1142,-1054,-868,-599,-312,-91,9,0,-48,-61,-5,103,228,348,443,484,442,308,104,-118,-302,-409,-433,-410,-386,-389,-412,-436,-456,-486,-528,-567,-584,-579,-579,-604,-642,-668,-665,-638,-598,-548,-482,-406,-341,-304,-293,-289,-275,-245,-205,-162,-122,-91,-67,-38,6,60,102,113,96,71,54,40,17,-22,-65,-92,-94,-76,-54,-43,-50,-71,-101,-136,-173,-205,-226,-231,-226,-215,-201,-184,-162,-139,-120,-106,-102,-109,-126,-147,-164,-172,-169,-154,-127,-92,-57,-30,-12,-5,-11,-33,-67,-101,-123,-131,-130,-122,-111,-96,-84,-76,-74,-78,-87,-102,-121,-139,-149,-150,-141,-122,-96,-66,-38,-21,-20,-38,-65,-90,-107,-119,-130,-138,-137,-123,-103,-83,-67,-55,-50,-58,-75,-92,-101,-105,-110,-111,-105,-93,-85,-84,-76,-51,-17},
            {-93,-54,105,142,-65,-226,-25,280,119,-332,188,2776,6829,10270,11331,9628,5422,-1178,-9241,-15625,-16248,-9954,-638,5752,6786,5557,6820,11669,16608,17484,13490,7300,2246,8,349,1849,2580,972,-2993,-7440,-10058,-10227,-9476,-9645,-10799,-11275,-9705,-6630,-3926,-2856,-2966,-2908,-1995,-702,210,671,1210,2100,2981,3393,3380,3322,3307,3023,2328,1642,1493,1838,2094,1856,1314,873,619,385,183,204,379,277,-327,-981,-968,-212,501,336,-696,-1802,-2275,-2124,-1890,-2036,-2571,-3118,-3192,-2505,-1197,161,921,850,295,-171,-258,-97,47,106,228,541,990,1391,1593,1556,1286,771,4,-915,-1731,-2140,-2000,-1454,-833,-432,-340,-475,-699,-898,-989,-918,-702,-452,-300,-307,-421,-533,-561,-475,-289,-54,157,281,311,301,299,291,229,106,-3,0,131,310,434,469,453,423,371,256,61,-188,-435,-630,-750,-803,-804,-757,-649,-477,-280,-121,-51,-68,-132,-201,-242,-238,-186,-103,-18,61,151,257,349,384,355,292,210,95,-60,-215,-310,-330,-310,-284,-243,-159,-46,43,65,15,-89,-231,-390,-521,-584,-570,-508,-428,-336,-231,-130,-61,-45,-83,-157,-246,-323,-367,-364,-316,-226,-97,59,213,332,393,387,319,201,61,-65,-157,-212,-232,-210,-138,-32,70,127,123,64,-35,-154,-266,-344,-382,-387,-363,-300,-194,-61,61,138,160,133,70,-15,-105,-177,-214,-207,-157,-76,12,84,125,133,114,74,18,-46,-109,-162,-196,-201,-171,-120,-74,-54,-55,-56,-40,-15}
        },
        {    // H30e048a.wav
            {-2,-2,-1,-1,-2,-2,1,1,0,-2,-1,-1,-2,-2,0,1,0,-3,-1,2,1,-1,3,11,10,-3,-10,1,13,2,-17,-10,20,27,-8,-34,-3,38,16,8,258,908,1741,2312,2342,1906,1190,200,-1095,-2376,-2971,-2434,-1075,285,1117,1638,2406,3574,4673,5091,4625,3578,2454,1678,1467,1740,2096,2015,1264,108,-940,-1592,-1973,-2351,-2776,-3038,-2945,-2551,-2087,-1750,-1578,-1510,-1484,-1463,-1393,-1195,-826,-333,157,523,739,878,1036,1236,1426,1538,1542,1454,1307,1139,987,864,751,615,455,304,187,83,-42,-183,-289,-332,-342,-379,-477,-621,-783,-942,-1073,-1149,-1163,-1150,-1152,-1162,-1114,-951,-682,-386,-158,-48,-45,-93,-124,-96,-10,101,205,291,357,384,344,225,51,-127,-262,-336,-360,-358,-353,-362,-391,-439,-502,-567,-619,-639,-628,-604,-590,-592,-598,-589,-561,-520,-470,-416,-365,-328,-305,-285,-253,-213,-183,-174,-178,-179,-172,-159,-140,-103,-44,25,75,92,83,64,41,7,-36,-75,-96,-100,-97,-92,-80,-60,-45,-54,-91,-145,-195,-232,-254,-263,-256,-233,-204,-180,-164,-151,-133,-110,-89,-79,-79,-82,-83,-86,-95,-106,-109,-97,-73,-52,-42,-39,-38,-42,-58,-86,-115,-131,-134,-132,-129,-123,-109,-91,-79,-78,-88,-106,-126,-142,-152,-152,-145,-134,-117,-88,-54,-26,-15,-20,-38,-62,-89,-113,-128,-128,-117,-104,-90,-74,-61,-56,-61,-74,-85,-92,-97,-101,-104,-105,-105,-101,-83,-52,-17},
            {-38,139,114,-128,-204,80,290,-33,-362,675,3790,7950,11116,11810,9550,4170,-4022,-12797,-17749,-15276,-6465,2911,7377,6774,5730,8211,13306,16669,15338,10374,5131,2023,1284,1886,2581,2170,-172,-4103,-7967,-10071,-10261,-9892,-10158,-10734,-10339,-8431,-5941,-4250,-3743,-3630,-3052,-1996,-1009,-306,457,1542,2613,3128,3100,3107,3509,3917,3695,2826,1979,1696,1814,1841,1641,1459,1369,1081,431,-228,-416,-182,-51,-292,-544,-356,108,206,-374,-1220,-1740,-1891,-2157,-2851,-3660,-3947,-3384,-2207,-931,40,567,705,592,379,178,22,-98,-156,-62,258,758,1255,1526,1444,1030,388,-368,-1114,-1659,-1801,-1495,-953,-515,-364,-416,-470,-454,-448,-515,-589,-566,-464,-404,-467,-595,-666,-622,-487,-306,-115,47,129,120,75,54,64,62,32,23,92,225,341,381,366,368,422,478,448,283,12,-288,-540,-703,-769,-751,-679,-584,-484,-381,-271,-163,-82,-52,-75,-126,-169,-174,-136,-67,21,120,222,305,347,338,291,218,115,-23,-174,-298,-361,-368,-342,-295,-221,-124,-30,23,21,-28,-110,-217,-336,-440,-502,-508,-465,-383,-274,-156,-56,-5,-19,-92,-204,-320,-404,-431,-393,-298,-159,6,175,315,395,399,333,217,81,-46,-146,-209,-235,-222,-171,-88,8,86,122,101,29,-75,-187,-285,-355,-391,-385,-329,-227,-97,27,116,156,150,106,34,-50,-129,-185,-204,-183,-128,-51,29,91,121,119,96,60,10,-54,-123,-177,-198,-185,-147,-96,-48,-18,-20,-47,-69,-60,-24}
        },
        {    // H30e054a.wav
            {1,0,-1,-2,-2,-1,-2,-2,0,1,-1,-3,-2,0,0,-2,-3,-1,0,-2,-4,-1,2,2,3,7,9,2,-8,-5,7,9,-5,-14,2,20,9,-18,-15,18,21,-8,83,481,1163,1831,2150,2023,1550,780,-328,-1629,-2605,-2682,-1784,-472,599,1285,1958,2928,3999,4646,4528,3757,2749,1928,1555,1659,1995,2129,1721,816,-196,-950,-1402,-1756,-2137,-2441,-2491,-2281,-1999,-1838,-1827,-1850,-1781,-1591,-1321,-1022,-708,-368,-8,350,685,999,1285,1500,1571,1471,1261,1055,927,867,811,706,541,336,131,-30,-129,-194,-277,-385,-458,-435,-335,-258,-286,-412,-571,-711,-829,-938,-1030,-1081,-1077,-1013,-880,-682,-457,-271,-179,-182,-224,-242,-206,-124,-26,63,132,180,213,223,196,122,9,-116,-221,-290,-324,-343,-370,-419,-480,-535,-573,-599,-616,-617,-589,-531,-469,-434,-430,-435,-426,-399,-367,-341,-317,-286,-247,-212,-187,-178,-182,-200,-225,-241,-232,-197,-146,-99,-63,-38,-17,0,9,3,-18,-48,-74,-87,-89,-86,-83,-83,-83,-86,-95,-111,-133,-157,-184,-214,-239,-249,-243,-227,-208,-186,-158,-126,-95,-71,-53,-38,-28,-26,-36,-55,-79,-101,-113,-113,-103,-87,-70,-56,-49,-53,-67,-88,-108,-126,-143,-156,-155,-140,-117,-101,-96,-97,-101,-110,-123,-137,-141,-135,-124,-116,-111,-101,-80,-56,-37,-31,-37,-49,-63,-78,-94,-105,-106,-98,-88,-83,-81,-75,-69,-71,-81,-89,-86,-80,-85,-99,-99,-70,-24},
            {123,28,-162,-139,151,262,-116,-338,904,4182,8438,11698,12384,9694,3311,-5985,-15029,-18873,-14462,-4201,5222,8665,7122,5968,8781,13691,15992,13435,8162,3876,2278,2514,3034,2948,1810,-704,-4285,-7659,-9535,-9921,-10023,-10641,-11101,-10132,-7641,-5085,-3958,-4209,-4481,-3744,-2301,-1110,-497,63,1025,2113,2782,3036,3365,3919,4167,3615,2603,2022,2257,2749,2730,2107,1410,1018,795,501,194,38,-73,-369,-738,-734,-192,404,373,-415,-1462,-2285,-2897,-3526,-4085,-4142,-3455,-2309,-1241,-524,-35,424,816,938,699,256,-127,-280,-178,131,569,999,1225,1090,615,-11,-571,-957,-1156,-1163,-977,-685,-467,-440,-519,-504,-322,-119,-81,-208,-332,-338,-311,-407,-648,-877,-918,-737,-437,-157,25,90,58,-29,-125,-195,-225,-211,-147,-32,112,246,339,392,434,484,529,521,412,203,-59,-308,-499,-615,-657,-632,-562,-474,-392,-316,-238,-150,-65,-9,-5,-52,-120,-161,-148,-86,-5,79,169,259,326,336,284,186,62,-86,-248,-390,-470,-469,-405,-313,-213,-112,-21,43,61,21,-73,-202,-336,-439,-486,-469,-393,-277,-152,-50,5,6,-44,-139,-263,-379,-444,-433,-357,-240,-101,52,207,333,397,378,284,144,-4,-128,-216,-264,-274,-239,-165,-66,27,92,112,77,-10,-127,-241,-321,-361,-365,-332,-259,-149,-26,82,151,173,149,88,6,-78,-150,-198,-210,-178,-109,-27,44,92,113,105,73,26,-25,-76,-131,-175,-186,-157,-107,-68,-46,-29,-20,-35,-74,-103,-86,-33}
        },
        {    // H30e060a.wav
            {3,1,0,-1,-1,-1,-1,0,-1,-1,-1,0,1,0,0,1,1,-1,-3,-2,0,0,-1,0,4,6,5,5,6,4,-3,-4,4,11,2,-12,-8,12,18,-2,-18,-2,21,8,23,227,713,1344,1830,1971,1758,1227,334,-894,-2106,-2701,-2320,-1204,19,937,1660,2506,3484,4215,4315,3769,2910,2138,1706,1679,1930,2153,2014,1413,585,-125,-602,-1032,-1620,-2290,-2725,-2685,-2248,-1733,-1418,-1359,-1420,-1430,-1298,-1023,-645,-212,216,574,815,939,983,986,954,887,801,726,662,570,423,247,99,1,-77,-162,-244,-296,-316,-323,-313,-257,-150,-56,-55,-168,-339,-495,-611,-710,-806,-883,-903,-842,-706,-535,-391,-330,-356,-411,-419,-348,-230,-122,-55,-21,3,31,59,73,59,11,-66,-153,-230,-290,-340,-390,-442,-488,-520,-530,-520,-500,-475,-445,-403,-350,-306,-291,-307,-335,-351,-342,-313,-276,-239,-213,-203,-209,-222,-231,-234,-237,-244,-248,-238,-214,-185,-163,-148,-132,-110,-81,-56,-43,-44,-56,-72,-84,-88,-88,-94,-109,-128,-139,-137,-129,-126,-134,-151,-171,-190,-205,-212,-208,-192,-164,-127,-86,-49,-24,-14,-14,-19,-27,-42,-61,-82,-101,-117,-127,-124,-108,-86,-70,-66,-75,-88,-102,-115,-127,-136,-143,-146,-144,-135,-121,-106,-94,-90,-92,-101,-113,-123,-127,-127,-127,-126,-113,-89,-59,-37,-27,-26,-33,-46,-64,-78,-83,-84,-89,-97,-99,-90,-77,-71,-68,-62,-56,-60,-74,-78,-58,-21},
            {93,-142,-192,91,283,-37,-362,635,3755,8179,11911,13059,10468,3727,-6185,-15771,-19785,-15016,-3966,6265,9999,8012,6012,8169,12891,15256,12717,7453,3417,2316,2949,3499,3239,2103,-154,-3536,-7036,-9212,-9709,-9620,-10024,-10581,-10058,-8093,-5825,-4593,-4428,-4269,-3436,-2374,-1782,-1519,-814,568,1914,2496,2540,2869,3702,4286,3884,2802,2082,2279,2905,3149,2807,2264,1792,1258,549,-63,-233,-38,103,-17,-166,-86,72,-106,-820,-1880,-2979,-3919,-4532,-4576,-3925,-2821,-1764,-1067,-615,-116,483,924,949,601,171,-77,-73,109,377,654,826,752,362,-227,-748,-959,-823,-515,-269,-210,-316,-484,-602,-578,-383,-95,125,159,35,-115,-210,-296,-460,-695,-888,-928,-801,-576,-327,-109,36,69,-20,-185,-345,-433,-429,-351,-235,-96,67,255,445,594,663,644,544,373,151,-86,-285,-414,-472,-483,-467,-431,-382,-325,-259,-175,-76,12,53,30,-33,-99,-139,-150,-138,-99,-25,82,198,284,314,282,193,50,-138,-334,-486,-551,-528,-448,-340,-220,-97,13,88,112,73,-33,-189,-347,-451,-465,-399,-291,-176,-73,8,52,40,-34,-151,-277,-374,-417,-401,-336,-233,-100,48,190,298,353,342,263,127,-30,-167,-259,-304,-311,-279,-205,-102,1,75,104,81,2,-120,-248,-338,-369,-348,-291,-203,-90,27,121,174,184,155,90,-2,-98,-174,-214,-213,-170,-92,-2,69,105,113,102,73,22,-42,-104,-150,-177,-179,-150,-100,-55,-34,-31,-30,-32,-53,-91,-111,-86,-31}
        },
        {    // H30e066a.wav
            {1,2,1,0,0,0,0,-2,-2,-2,-1,-2,-2,-1,0,-1,-1,-1,0,0,-3,-4,-3,-1,-1,0,2,4,2,0,1,2,-1,-4,0,6,2,-11,-14,3,18,9,-13,-12,11,17,11,103,418,936,1461,1782,1809,1528,860,-249,-1580,-2564,-2658,-1820,-553,582,1445,2255,3134,3854,4064,3677,2960,2289,1904,1878,2140,2460,2485,1955,961,-90,-821,-1188,-1423,-1705,-1967,-2021,-1815,-1498,-1265,-1167,-1118,-1015,-842,-653,-488,-339,-177,10,199,356,452,477,436,355,270,203,144,65,-23,-65,-15,94,154,82,-90,-248,-299,-230,-93,57,175,217,155,11,-147,-270,-371,-498,-659,-797,-844,-786,-675,-573,-516,-504,-514,-512,-467,-378,-274,-201,-173,-172,-162,-131,-91,-67,-74,-109,-162,-221,-282,-338,-382,-405,-400,-378,-355,-346,-346,-340,-315,-277,-237,-210,-205,-227,-266,-298,-299,-266,-227,-214,-235,-269,-287,-278,-257,-241,-242,-257,-281,-300,-303,-282,-244,-207,-184,-175,-165,-145,-115,-85,-67,-66,-78,-94,-110,-123,-132,-137,-135,-127,-119,-114,-114,-116,-119,-126,-138,-151,-159,-156,-144,-124,-98,-69,-45,-33,-34,-41,-49,-55,-63,-75,-90,-106,-120,-132,-136,-131,-119,-105,-97,-94,-93,-94,-100,-113,-129,-140,-140,-131,-120,-112,-105,-100,-99,-105,-117,-129,-132,-128,-121,-114,-108,-98,-84,-68,-54,-43,-37,-35,-37,-43,-54,-71,-88,-99,-100,-93,-83,-69,-56,-50,-58,-71,-72,-50,-17},
            {-36,-158,-12,221,77,-319,154,2659,7006,11414,13595,11856,5527,-4504,-14895,-20315,-16803,-5809,5784,11124,9437,6132,6682,10987,14284,12919,8082,3778,2353,2922,3522,3366,2598,982,-1980,-5776,-8757,-9756,-9363,-9058,-9356,-9398,-8387,-6787,-5680,-5311,-4872,-3747,-2407,-1723,-1717,-1506,-481,926,1895,2302,2728,3454,3946,3586,2641,2077,2433,3217,3549,3169,2538,2094,1767,1290,703,301,186,165,99,124,358,528,108,-1127,-2796,-4200,-4863,-4763,-4174,-3408,-2681,-2074,-1530,-916,-188,499,876,798,397,1,-112,100,453,704,704,447,11,-481,-857,-936,-647,-147,253,315,60,-293,-528,-571,-447,-201,99,333,375,208,-46,-241,-339,-415,-548,-735,-890,-920,-787,-535,-264,-84,-46,-126,-257,-379,-466,-512,-514,-465,-353,-164,94,376,607,725,717,602,406,161,-77,-241,-302,-298,-287,-297,-309,-294,-249,-181,-95,2,84,118,90,16,-74,-158,-217,-233,-191,-98,23,142,231,268,238,138,-17,-201,-378,-515,-582,-567,-483,-363,-232,-105,13,104,140,102,-8,-159,-304,-399,-418,-361,-254,-132,-28,43,74,63,8,-86,-203,-313,-386,-402,-357,-261,-131,12,145,249,305,298,224,98,-46,-174,-267,-325,-351,-334,-267,-162,-46,46,95,89,22,-91,-213,-304,-342,-332,-284,-202,-88,36,134,185,190,158,93,1,-101,-185,-229,-224,-175,-92,3,84,130,138,119,79,23,-44,-110,-162,-193,-200,-178,-132,-80,-44,-30,-26,-23,-29,-54,-84,-93,-66,-22}
        },
        {    // H30e072a.wav
            {1,1,2,2,1,0,1,1,1,0,-1,-1,0,0,0,1,1,0,0,2,3,2,-1,-2,-1,0,0,1,3,4,2,0,2,6,5,1,1,6,3,-9,-14,0,21,20,-2,-13,3,18,17,67,279,679,1151,1537,1744,1704,1262,263,-1161,-2445,-2910,-2305,-1019,317,1373,2240,3059,3705,3913,3630,3116,2675,2396,2195,2012,1863,1724,1480,1057,538,80,-284,-659,-1110,-1506,-1630,-1413,-1032,-756,-726,-883,-1067,-1153,-1108,-970,-801,-652,-535,-421,-290,-165,-113,-169,-283,-346,-279,-105,86,220,291,325,322,254,126,3,-35,24,124,209,275,342,391,365,232,24,-196,-394,-572,-727,-825,-834,-769,-683,-621,-589,-572,-560,-544,-517,-476,-431,-397,-371,-331,-265,-195,-159,-175,-222,-263,-280,-277,-263,-240,-213,-189,-182,-194,-213,-222,-211,-183,-154,-139,-144,-163,-183,-200,-214,-229,-247,-263,-277,-289,-299,-304,-301,-290,-281,-283,-299,-321,-333,-327,-304,-276,-255,-246,-238,-223,-195,-159,-124,-100,-92,-98,-110,-120,-120,-114,-107,-106,-108,-106,-98,-88,-80,-76,-71,-66,-67,-77,-94,-111,-122,-124,-119,-105,-86,-69,-60,-61,-66,-70,-73,-80,-94,-111,-128,-139,-142,-136,-125,-113,-101,-92,-82,-76,-74,-80,-92,-107,-123,-134,-137,-132,-123,-117,-113,-110,-106,-103,-103,-103,-101,-98,-98,-97,-90,-72,-53,-40,-36,-35,-34,-36,-43,-51,-59,-67,-75,-82,-82,-77,-72,-68,-58,-38,-13},
            {-127,-70,156,181,-191,-277,1216,4901,9741,13416,13551,8743,-697,-11966,-19876,-19420,-9983,2888,11262,11534,7327,5262,8048,12348,13265,9780,5135,2687,2726,3419,3520,3090,2115,-129,-3845,-7656,-9668,-9474,-8468,-8084,-8304,-8191,-7413,-6565,-6095,-5588,-4477,-3050,-2190,-2153,-2135,-1282,220,1434,1912,2173,2814,3571,3643,2845,2000,2009,2822,3584,3649,3151,2565,2054,1496,933,661,805,1059,1038,738,452,265,-160,-1174,-2646,-4001,-4729,-4761,-4360,-3783,-3122,-2406,-1699,-1067,-515,-33,320,433,287,50,-29,160,469,624,459,24,-486,-873,-995,-775,-256,344,719,681,313,-128,-428,-521,-417,-129,278,619,685,429,29,-281,-411,-447,-510,-639,-782,-864,-835,-693,-491,-317,-236,-250,-317,-399,-486,-571,-622,-605,-501,-317,-73,190,418,562,611,574,457,266,47,-120,-184,-172,-154,-170,-193,-183,-135,-70,2,87,169,205,164,57,-73,-189,-268,-295,-259,-167,-44,75,163,197,165,70,-72,-235,-396,-524,-589,-577,-501,-397,-285,-164,-31,90,155,137,46,-84,-220,-333,-390,-367,-268,-135,-15,67,110,117,81,-6,-131,-257,-347,-383,-364,-295,-183,-47,87,191,249,253,199,89,-57,-201,-306,-361,-376,-359,-308,-218,-99,16,91,104,51,-50,-167,-262,-313,-315,-276,-203,-104,3,94,154,177,165,115,29,-76,-169,-224,-232,-194,-116,-17,76,136,153,140,107,55,-18,-101,-173,-216,-229,-214,-174,-118,-63,-25,-10,-11,-20,-38,-63,-84,-83,-56,-19}
        },
        {    // H30e078a.wav
            {0,1,1,0,0,1,1,2,2,1,-1,-2,-1,0,1,0,-1,0,1,2,2,2,1,-2,-3,-3,-1,0,-1,-1,1,1,0,0,3,5,3,0,2,4,-2,-13,-13,6,24,18,-3,-8,8,12,0,44,238,586,992,1361,1658,1791,1503,525,-1042,-2554,-3196,-2616,-1185,392,1680,2695,3548,4104,4075,3407,2451,1710,1472,1687,2111,2471,2544,2214,1562,856,365,135,-25,-320,-750,-1131,-1305,-1283,-1200,-1172,-1228,-1343,-1481,-1585,-1586,-1445,-1213,-1009,-925,-940,-941,-819,-560,-240,33,196,248,247,271,366,518,642,642,491,263,92,77,221,436,605,637,507,260,-14,-232,-371,-471,-587,-725,-831,-847,-771,-663,-595,-595,-644,-698,-726,-713,-661,-580,-491,-414,-359,-322,-299,-285,-277,-263,-231,-181,-127,-86,-64,-53,-44,-42,-55,-79,-98,-99,-87,-81,-95,-123,-152,-179,-214,-257,-296,-312,-305,-297,-308,-334,-355,-355,-340,-327,-322,-323,-324,-327,-332,-332,-317,-288,-254,-226,-205,-188,-173,-163,-157,-148,-129,-102,-81,-75,-79,-82,-78,-71,-69,-71,-66,-50,-29,-16,-20,-39,-68,-103,-140,-168,-174,-156,-124,-97,-84,-81,-81,-80,-85,-96,-109,-117,-120,-124,-131,-137,-134,-122,-103,-86,-72,-64,-62,-67,-82,-103,-124,-140,-146,-148,-145,-135,-116,-93,-78,-78,-88,-99,-105,-106,-105,-103,-97,-86,-73,-58,-42,-29,-20,-19,-24,-33,-47,-61,-72,-78,-81,-85,-84,-72,-45,-14},
            {-154,26,235,72,-346,-4,2307,6685,11532,14224,12385,5092,-6106,-16762,-21069,-15700,-3286,8550,13069,10074,5481,5030,8807,12195,11498,7575,3980,2792,3227,3672,3629,3215,1864,-1242,-5559,-8995,-9872,-8656,-7276,-6980,-7385,-7541,-7217,-6778,-6265,-5298,-3891,-2772,-2537,-2765,-2434,-1150,419,1455,1951,2469,3145,3425,2900,2048,1799,2460,3387,3767,3447,2853,2320,1813,1283,952,1038,1375,1541,1351,1003,679,184,-815,-2266,-3626,-4353,-4381,-4060,-3711,-3368,-2925,-2366,-1778,-1203,-632,-122,158,107,-131,-239,-38,316,470,211,-343,-867,-1097,-961,-528,70,647,980,927,553,94,-231,-346,-273,-25,366,758,919,715,258,-186,-432,-500,-528,-604,-716,-804,-824,-766,-648,-516,-421,-385,-394,-431,-493,-579,-659,-684,-622,-477,-270,-33,190,352,432,438,387,288,153,28,-39,-47,-47,-77,-112,-102,-36,52,129,200,270,308,264,129,-48,-201,-294,-322,-293,-218,-113,-9,69,103,85,13,-100,-236,-372,-490,-568,-589,-549,-467,-366,-253,-124,13,124,170,132,26,-114,-250,-345,-367,-304,-182,-45,66,132,155,136,71,-38,-170,-289,-360,-364,-307,-209,-96,13,107,175,204,177,87,-49,-196,-319,-397,-427,-411,-350,-249,-128,-15,67,104,88,14,-98,-212,-287,-308,-283,-227,-146,-46,51,122,154,152,121,62,-24,-119,-194,-225,-206,-145,-58,36,112,154,155,124,71,4,-68,-137,-194,-228,-232,-204,-151,-90,-41,-14,-7,-15,-37,-65,-88,-93,-76,-45,-14}
        },
        {    // H30e084a.wav
            {0,0,1,1,1,1,1,2,2,3,3,1,0,-1,1,2,1,-1,0,2,3,2,1,1,1,0,-1,-1,-2,-3,-1,4,6,3,-1,0,5,8,5,3,5,4,-6,-13,-2,23,33,17,-2,-4,-4,-25,-25,88,354,698,1020,1314,1620,1795,1451,283,-1469,-2959,-3289,-2205,-279,1576,2746,3160,3075,2778,2476,2311,2337,2473,2577,2590,2587,2641,2679,2519,2066,1413,748,179,-300,-720,-1055,-1270,-1401,-1539,-1726,-1901,-1966,-1906,-1811,-1790,-1867,-1962,-1956,-1765,-1387,-904,-446,-134,-4,9,27,139,357,625,854,961,903,712,492,360,356,422,463,439,378,323,278,211,97,-59,-240,-433,-615,-747,-798,-772,-715,-680,-692,-745,-810,-856,-857,-809,-731,-656,-601,-551,-483,-392,-297,-224,-181,-156,-133,-104,-68,-25,24,71,102,106,79,32,-13,-42,-56,-69,-97,-141,-189,-230,-262,-286,-303,-313,-320,-330,-348,-367,-377,-372,-359,-346,-336,-332,-333,-338,-339,-327,-299,-267,-245,-240,-245,-248,-238,-214,-179,-140,-103,-72,-51,-40,-38,-39,-41,-46,-53,-57,-49,-30,-9,-4,-22,-57,-96,-127,-148,-156,-150,-135,-121,-117,-118,-117,-109,-100,-97,-100,-103,-105,-106,-108,-109,-106,-102,-101,-104,-104,-97,-85,-73,-69,-74,-87,-104,-122,-135,-140,-132,-115,-96,-84,-80,-81,-86,-93,-100,-103,-98,-89,-81,-77,-70,-54,-37,-27,-27,-31,-32,-34,-38,-44,-48,-53,-68,-87,-90,-64,-23},
            {-147,71,246,6,-386,202,2902,7573,12337,14349,11224,2498,-9295,-18807,-20398,-12311,938,11224,13224,8726,4311,4683,8612,11362,10185,6620,3851,3159,3554,3886,3974,3642,1902,-1916,-6620,-9710,-9775,-7868,-6236,-6050,-6761,-7328,-7374,-7011,-6190,-4833,-3408,-2736,-2999,-3328,-2705,-1131,452,1347,1807,2411,3095,3221,2565,1810,1834,2706,3649,3920,3466,2700,1947,1322,976,1099,1586,1949,1773,1176,638,370,41,-787,-2087,-3345,-4069,-4181,-3907,-3459,-2936,-2431,-2062,-1836,-1586,-1153,-604,-201,-119,-243,-304,-184,-43,-128,-488,-910,-1114,-974,-556,0,562,995,1154,975,557,121,-142,-163,35,394,806,1082,1036,651,118,-306,-507,-552,-577,-647,-745,-822,-837,-772,-644,-509,-427,-418,-459,-518,-585,-653,-699,-693,-622,-490,-303,-82,125,259,300,278,237,186,120,49,7,2,9,7,12,54,131,214,280,338,385,384,292,111,-95,-253,-326,-323,-269,-187,-98,-23,22,25,-16,-96,-200,-317,-433,-530,-587,-586,-529,-442,-343,-231,-99,37,138,168,117,8,-124,-242,-310,-302,-220,-100,17,104,156,170,140,59,-61,-186,-281,-324,-311,-248,-154,-52,38,106,149,156,108,0,-148,-291,-392,-440,-442,-404,-321,-199,-66,43,106,119,81,-6,-122,-231,-293,-297,-256,-189,-106,-12,75,136,158,145,102,33,-52,-136,-191,-201,-163,-93,-10,63,112,134,129,100,49,-19,-87,-144,-182,-200,-197,-167,-116,-64,-30,-21,-28,-40,-55,-73,-88,-90,-73,-43,-13}
        },
        {    // H30e090a.wav
            {-1,-2,-1,0,0,0,0,2,2,2,2,2,2,1,0,0,0,0,-2,-2,0,0,0,-1,0,1,1,0,-2,-3,-3,-2,1,5,4,0,-1,3,6,4,1,1,2,-2,-4,8,28,32,10,-15,-19,-14,-28,-35,57,303,641,953,1215,1487,1711,1583,772,-657,-2094,-2779,-2384,-1210,172,1387,2365,3103,3491,3430,3033,2609,2430,2552,2848,3155,3335,3258,2834,2099,1244,492,-58,-464,-830,-1191,-1513,-1762,-1946,-2086,-2182,-2238,-2279,-2333,-2378,-2337,-2136,-1784,-1366,-979,-666,-419,-213,-28,159,369,592,778,876,886,860,845,836,784,657,467,267,113,49,88,196,290,287,160,-48,-266,-452,-600,-713,-786,-816,-817,-815,-819,-826,-831,-840,-853,-854,-823,-749,-641,-517,-395,-287,-206,-151,-115,-86,-58,-28,8,52,104,152,182,183,150,88,12,-61,-117,-150,-170,-189,-216,-253,-294,-327,-344,-346,-342,-346,-361,-380,-393,-393,-379,-355,-330,-312,-304,-300,-295,-288,-285,-291,-298,-298,-285,-261,-228,-189,-145,-102,-67,-42,-27,-21,-25,-35,-46,-50,-48,-44,-45,-52,-62,-71,-77,-81,-85,-89,-97,-111,-129,-145,-152,-148,-139,-130,-122,-112,-99,-89,-86,-92,-97,-97,-95,-97,-106,-117,-124,-122,-112,-96,-80,-71,-69,-74,-83,-94,-107,-118,-124,-121,-112,-99,-85,-72,-65,-68,-78,-85,-85,-81,-76,-74,-70,-62,-53,-44,-33,-25,-24,-30,-39,-43,-47,-60,-77,-80,-57,-20},
            {-142,52,230,24,-368,128,2705,7348,12194,14239,10958,2010,-9735,-18733,-19580,-11031,2078,11763,13118,8207,3572,3768,7575,10424,9651,6621,4211,3557,3811,4088,4319,4176,2436,-1630,-6648,-9857,-9737,-7471,-5555,-5350,-6327,-7290,-7623,-7267,-6206,-4587,-3116,-2663,-3245,-3773,-3146,-1435,302,1291,1739,2211,2705,2733,2195,1741,2056,3036,3894,3999,3392,2509,1691,1115,952,1273,1785,1945,1506,820,440,428,267,-521,-1801,-2966,-3565,-3629,-3439,-3157,-2784,-2363,-2029,-1838,-1668,-1370,-977,-677,-585,-608,-581,-476,-439,-601,-904,-1134,-1109,-806,-325,222,735,1097,1189,982,608,278,134,185,374,653,956,1145,1065,686,168,-263,-494,-576,-625,-705,-802,-866,-855,-751,-584,-432,-371,-417,-515,-604,-664,-707,-733,-720,-649,-524,-359,-176,-4,118,172,173,150,116,73,33,19,35,61,84,117,179,261,332,379,411,429,406,307,137,-52,-202,-286,-306,-276,-212,-136,-74,-40,-36,-64,-130,-236,-365,-487,-572,-604,-582,-518,-429,-327,-215,-96,21,109,138,96,-5,-127,-228,-268,-236,-148,-40,55,119,153,155,120,47,-56,-164,-251,-294,-284,-223,-132,-37,40,92,118,111,53,-59,-202,-334,-419,-450,-437,-384,-290,-167,-43,49,98,105,68,-13,-124,-227,-283,-281,-236,-168,-86,2,81,130,144,131,95,35,-45,-125,-176,-182,-147,-85,-12,56,104,122,113,83,38,-19,-81,-134,-169,-182,-171,-138,-93,-52,-31,-34,-51,-69,-83,-92,-96,-90,-69,-39,-12}
        },
        {    // H30e096a.wav
            {0,-1,-1,-1,0,1,1,2,3,2,2,2,2,1,0,0,0,0,-1,-2,-1,1,1,2,2,1,1,0,-1,0,-2,-3,-2,1,3,2,3,5,6,1,-5,-3,7,13,8,6,19,29,12,-20,-28,-5,7,-23,-26,116,431,811,1152,1492,1890,2153,1792,432,-1651,-3490,-4048,-2966,-778,1530,3167,3861,3783,3320,2876,2711,2833,3039,3123,3058,2963,2901,2767,2388,1711,855,3,-721,-1253,-1555,-1640,-1616,-1657,-1881,-2251,-2610,-2800,-2753,-2491,-2095,-1680,-1357,-1177,-1077,-924,-623,-205,206,497,637,672,672,700,793,938,1060,1048,847,512,183,-23,-82,-43,38,131,210,237,180,44,-132,-314,-491,-664,-816,-914,-936,-893,-824,-775,-769,-799,-835,-845,-809,-727,-618,-500,-388,-292,-213,-147,-87,-33,10,38,61,91,133,171,189,176,134,70,-8,-85,-145,-177,-186,-193,-221,-271,-324,-358,-366,-359,-356,-364,-376,-384,-384,-377,-362,-332,-291,-254,-242,-259,-293,-319,-325,-316,-302,-289,-275,-255,-224,-183,-131,-79,-41,-28,-39,-58,-68,-65,-57,-58,-71,-90,-106,-112,-105,-83,-51,-22,-16,-41,-84,-123,-143,-146,-140,-132,-122,-112,-106,-105,-104,-100,-92,-87,-92,-104,-116,-123,-124,-123,-122,-120,-113,-98,-80,-66,-60,-62,-71,-85,-103,-118,-124,-118,-103,-84,-65,-49,-44,-51,-66,-81,-89,-90,-86,-80,-73,-65,-57,-46,-34,-25,-26,-36,-43,-42,-42,-53,-73,-79,-57,-20},
            {-125,-24,171,112,-264,-143,1786,6000,11052,13920,11723,3718,-7585,-16973,-19077,-12041,334,10589,13146,8757,3384,2369,5767,9388,9775,7338,4804,3830,3967,4284,4597,4686,3400,-305,-5487,-9366,-9857,-7629,-5282,-4732,-5813,-7191,-7884,-7656,-6540,-4765,-3078,-2458,-3103,-3964,-3706,-2094,-135,1139,1669,2013,2365,2371,1890,1484,1872,3026,4105,4295,3529,2369,1421,982,1074,1503,1856,1708,1047,389,281,644,773,66,-1323,-2650,-3307,-3288,-2976,-2670,-2418,-2196,-2043,-1973,-1875,-1617,-1236,-932,-855,-947,-1022,-979,-886,-871,-962,-1065,-1049,-842,-442,102,676,1105,1231,1039,695,428,359,452,617,813,1017,1142,1056,717,250,-145,-364,-466,-564,-710,-858,-934,-885,-717,-496,-330,-300,-398,-539,-649,-719,-772,-802,-775,-681,-557,-438,-316,-173,-24,79,109,86,44,7,-15,-6,44,114,171,204,236,287,352,411,450,461,427,331,177,7,-133,-220,-257,-255,-225,-182,-140,-106,-85,-86,-134,-238,-377,-505,-585,-608,-585,-524,-436,-332,-226,-124,-29,52,93,74,-5,-115,-211,-252,-222,-135,-24,72,132,156,148,110,40,-55,-153,-232,-273,-271,-226,-148,-60,15,65,88,79,26,-76,-209,-333,-412,-436,-418,-366,-280,-169,-58,24,64,65,33,-33,-124,-212,-263,-262,-222,-161,-87,-9,61,106,122,116,91,42,-32,-113,-170,-185,-158,-101,-28,44,98,120,109,75,28,-25,-80,-129,-162,-171,-159,-128,-89,-56,-42,-51,-73,-93,-104,-108,-107,-99,-77,-45,-14}
        },
        {    // H30e102a.wav
            {-1,-1,0,0,0,0,1,3,2,2,2,2,2,0,-1,-1,0,-1,-2,-1,0,1,1,2,2,2,0,-1,0,0,-3,-3,1,5,2,-3,-3,4,7,1,-7,-4,6,11,8,9,19,22,5,-15,-15,0,-3,-23,8,173,502,983,1600,2273,2701,2358,852,-1556,-3835,-4739,-3693,-1223,1440,3230,3835,3638,3226,2977,2962,3053,3075,2928,2664,2466,2479,2629,2616,2150,1217,118,-761,-1220,-1327,-1297,-1324,-1512,-1868,-2298,-2626,-2689,-2460,-2087,-1775,-1616,-1545,-1428,-1187,-838,-436,-45,265,433,460,439,493,667,896,1058,1074,935,686,390,124,-50,-113,-105,-79,-50,3,86,156,140,6,-212,-440,-617,-725,-777,-801,-815,-827,-835,-831,-810,-767,-708,-641,-582,-541,-510,-470,-407,-320,-220,-120,-29,45,96,126,144,159,167,156,118,60,-3,-58,-97,-123,-142,-162,-194,-237,-284,-325,-355,-374,-388,-401,-410,-407,-386,-355,-323,-300,-282,-261,-240,-233,-251,-283,-307,-308,-292,-272,-258,-250,-239,-222,-193,-150,-100,-57,-41,-54,-83,-107,-118,-120,-126,-143,-162,-167,-146,-100,-45,1,19,4,-38,-87,-124,-136,-128,-114,-104,-96,-88,-80,-77,-80,-88,-98,-109,-123,-133,-137,-134,-129,-128,-129,-125,-113,-93,-72,-60,-61,-73,-88,-101,-112,-120,-117,-99,-71,-48,-38,-40,-43,-50,-65,-82,-93,-92,-85,-79,-75,-66,-54,-46,-44,-40,-31,-26,-30,-37,-40,-49,-76,-114,-129,-96,-35},
            {-57,-112,34,175,-32,-297,582,3734,8669,12812,12870,7115,-3042,-13209,-18037,-14394,-3950,7180,12507,10180,4350,1176,3189,7630,10046,8838,5979,4060,3756,4231,4803,5200,4603,1796,-3138,-7932,-9849,-8346,-5585,-4204,-4970,-6716,-7982,-8144,-7233,-5498,-3541,-2366,-2607,-3674,-4115,-3043,-1006,742,1582,1864,2064,2117,1789,1371,1563,2616,3880,4383,3761,2503,1406,947,1109,1552,1822,1584,893,247,167,633,1002,607,-586,-1958,-2842,-3058,-2861,-2546,-2225,-1937,-1772,-1801,-1923,-1920,-1681,-1330,-1092,-1069,-1163,-1217,-1175,-1100,-1067,-1068,-1029,-872,-565,-121,398,864,1129,1114,894,650,528,550,660,817,1001,1142,1108,822,375,-28,-248,-320,-388,-546,-755,-904,-901,-739,-496,-298,-238,-321,-471,-610,-715,-803,-863,-852,-760,-630,-515,-413,-290,-146,-26,30,29,4,-22,-40,-31,31,132,222,263,270,284,324,374,415,439,437,381,256,88,-69,-171,-216,-224,-210,-183,-152,-125,-110,-114,-149,-225,-332,-441,-525,-573,-580,-543,-465,-362,-261,-173,-92,-15,41,47,-1,-83,-163,-214,-218,-166,-69,43,128,166,158,118,54,-33,-130,-213,-259,-260,-226,-169,-101,-33,24,61,67,33,-45,-154,-265,-348,-387,-388,-356,-293,-203,-104,-23,25,39,23,-28,-108,-192,-245,-248,-210,-156,-97,-32,35,91,119,116,90,42,-27,-104,-161,-176,-147,-91,-27,33,80,105,100,72,30,-19,-69,-113,-141,-148,-139,-119,-94,-71,-59,-65,-82,-96,-99,-99,-106,-113,-101,-65,-21}
        },
        {    // H30e108a.wav
            {-1,-1,0,1,2,2,2,2,1,1,1,1,1,0,-1,-1,-1,-1,-1,0,0,1,2,3,2,0,-1,-1,-1,-1,-1,1,4,5,3,-1,-2,-1,-1,-2,0,6,10,8,5,7,12,10,1,-4,2,3,-12,6,178,627,1359,2177,2706,2536,1442,-419,-2449,-3820,-3892,-2605,-527,1504,2892,3542,3716,3693,3561,3280,2858,2425,2164,2181,2422,2680,2683,2234,1360,328,-509,-941,-1019,-969,-1008,-1223,-1575,-1962,-2266,-2389,-2297,-2056,-1794,-1604,-1474,-1327,-1106,-822,-521,-234,32,265,439,536,579,614,685,793,896,920,812,575,281,25,-136,-206,-220,-200,-146,-69,-6,-2,-72,-199,-349,-497,-618,-695,-718,-702,-682,-686,-721,-765,-787,-761,-679,-557,-437,-360,-340,-355,-365,-343,-285,-199,-97,16,125,210,251,241,188,112,33,-36,-89,-128,-153,-165,-169,-178,-205,-252,-309,-360,-396,-416,-426,-434,-437,-428,-398,-346,-283,-232,-204,-203,-223,-253,-281,-291,-275,-242,-214,-205,-211,-213,-197,-171,-145,-126,-112,-102,-98,-101,-111,-130,-161,-204,-246,-264,-246,-193,-123,-56,-8,13,7,-19,-56,-92,-117,-122,-110,-91,-76,-70,-67,-62,-58,-60,-70,-83,-99,-120,-144,-164,-169,-159,-141,-123,-110,-98,-87,-78,-71,-72,-86,-109,-130,-136,-125,-102,-77,-53,-32,-21,-24,-38,-54,-68,-81,-91,-95,-89,-78,-68,-60,-50,-40,-33,-30,-26,-21,-23,-39,-62,-84,-108,-137,-161,-154,-104,-35},
            {43,-117,-118,100,181,-125,-192,1342,5192,10058,12859,10709,3152,-7000,-14833,-15967,-9409,1222,9603,11155,6646,1430,579,4468,9105,10509,8305,5127,3412,3511,4486,5479,5751,4221,220,-5095,-8940,-9253,-6746,-4218,-3860,-5535,-7555,-8512,-8078,-6579,-4560,-2836,-2276,-3005,-3989,-3866,-2284,-189,1261,1789,1874,1881,1725,1398,1365,2098,3344,4181,3900,2709,1485,943,1125,1572,1787,1546,953,371,191,511,962,957,205,-1020,-2123,-2696,-2752,-2537,-2243,-1940,-1697,-1626,-1759,-1947,-1967,-1741,-1416,-1212,-1200,-1266,-1266,-1181,-1097,-1071,-1051,-936,-683,-327,74,475,819,1025,1038,899,724,619,617,703,853,1011,1072,928,587,197,-75,-185,-236,-346,-534,-720,-804,-743,-568,-362,-226,-221,-334,-500,-658,-786,-872,-893,-833,-718,-598,-498,-400,-279,-154,-60,-14,-1,-7,-25,-32,10,111,225,287,286,265,269,300,334,365,392,393,329,191,26,-104,-173,-199,-202,-184,-147,-107,-89,-99,-133,-184,-254,-339,-424,-495,-536,-537,-489,-404,-307,-225,-161,-101,-43,-5,-2,-36,-90,-145,-183,-182,-127,-30,70,133,146,122,74,7,-76,-159,-219,-244,-237,-205,-154,-91,-28,20,46,47,19,-44,-135,-229,-302,-338,-340,-311,-254,-173,-87,-17,23,29,1,-60,-141,-213,-244,-226,-174,-110,-45,18,71,103,107,86,49,-1,-59,-112,-139,-131,-92,-38,16,58,78,75,55,29,3,-26,-58,-88,-110,-121,-122,-111,-89,-66,-59,-72,-89,-98,-101,-107,-114,-105,-69,-23}
        },
        {    // H30e114a.wav
            {1,2,2,2,2,2,2,2,2,1,0,0,1,1,0,-1,-1,0,2,2,2,3,3,1,-1,-1,2,3,2,0,0,4,5,3,2,3,3,-1,-5,-1,7,10,6,5,12,16,6,-9,-4,16,17,10,126,548,1323,2197,2696,2411,1271,-395,-2027,-3074,-3199,-2387,-936,680,2044,2974,3515,3764,3745,3441,2926,2412,2132,2177,2427,2627,2532,2025,1179,231,-535,-950,-1061,-1064,-1142,-1341,-1582,-1773,-1884,-1932,-1928,-1865,-1750,-1615,-1476,-1309,-1065,-724,-332,25,276,408,458,478,516,603,742,897,999,979,814,545,259,36,-93,-145,-162,-174,-189,-199,-199,-201,-237,-333,-486,-648,-762,-795,-761,-702,-654,-628,-622,-626,-633,-628,-596,-535,-455,-375,-309,-261,-229,-209,-191,-169,-135,-80,4,111,215,277,267,194,95,5,-65,-122,-170,-204,-221,-228,-239,-261,-296,-342,-399,-458,-503,-517,-496,-451,-396,-342,-295,-262,-244,-235,-224,-209,-200,-204,-215,-219,-204,-174,-144,-124,-112,-100,-90,-85,-88,-99,-114,-132,-157,-190,-228,-265,-292,-300,-281,-232,-164,-96,-45,-20,-20,-37,-64,-90,-107,-106,-91,-73,-60,-55,-52,-49,-47,-49,-57,-66,-73,-81,-95,-116,-139,-154,-158,-152,-136,-113,-87,-66,-59,-69,-90,-112,-129,-137,-134,-119,-95,-67,-43,-28,-25,-31,-42,-53,-62,-72,-82,-87,-83,-72,-59,-48,-34,-18,-6,-4,-14,-29,-48,-74,-105,-129,-137,-132,-124,-118,-101,-65,-21},
            {80,-5,-126,-72,134,144,-172,-71,1742,5702,10204,12142,9050,1173,-8158,-14180,-13459,-6223,3294,9360,8870,3861,-214,678,5690,10351,11054,8068,4426,2681,3163,4745,6147,6216,3940,-724,-5975,-9024,-8454,-5644,-3500,-3808,-5970,-8090,-8788,-7893,-5990,-3911,-2547,-2476,-3392,-4105,-3525,-1696,310,1512,1827,1759,1636,1454,1333,1668,2619,3647,3891,3055,1757,928,945,1433,1771,1652,1178,637,302,335,680,1005,875,104,-1044,-2056,-2569,-2576,-2300,-1967,-1717,-1642,-1771,-2008,-2136,-1992,-1627,-1279,-1153,-1240,-1357,-1342,-1191,-1012,-887,-803,-692,-515,-274,28,381,731,971,1022,904,730,612,591,655,769,877,891,737,446,150,-27,-90,-146,-281,-472,-628,-674,-600,-448,-286,-192,-220,-363,-554,-718,-818,-851,-827,-760,-676,-601,-530,-437,-305,-161,-49,10,24,12,-3,8,69,168,252,274,241,203,198,224,261,300,330,324,253,124,-17,-121,-176,-195,-189,-160,-117,-79,-64,-73,-100,-145,-213,-300,-387,-455,-487,-480,-437,-371,-303,-246,-196,-144,-87,-38,-17,-33,-80,-134,-166,-153,-95,-19,40,67,68,53,26,-22,-90,-162,-219,-249,-246,-212,-153,-82,-20,22,44,52,38,-7,-86,-176,-250,-292,-302,-285,-239,-168,-88,-25,6,4,-27,-83,-150,-203,-219,-191,-139,-84,-35,8,43,65,74,70,54,19,-33,-85,-117,-116,-88,-45,2,38,55,51,37,24,10,-11,-40,-72,-99,-116,-118,-104,-80,-64,-67,-85,-102,-109,-109,-104,-89,-57,-18}
        },
        {    // H30e120a.wav
            {3,3,2,2,2,2,1,1,0,0,1,1,1,0,0,1,2,2,2,2,2,2,1,0,0,1,1,1,3,5,3,1,0,3,3,-1,-4,1,9,8,0,-2,7,14,7,-4,3,21,14,15,177,682,1519,2353,2677,2152,862,-727,-2052,-2726,-2642,-1918,-789,493,1724,2779,3563,3970,3905,3391,2647,2026,1814,2058,2530,2856,2725,2049,1009,-51,-812,-1156,-1202,-1186,-1282,-1514,-1783,-1975,-2031,-1965,-1829,-1682,-1562,-1473,-1382,-1233,-981,-626,-222,140,389,520,590,670,782,888,942,936,905,878,839,740,549,286,16,-193,-297,-291,-208,-104,-49,-96,-261,-507,-759,-939,-1009,-989,-930,-874,-829,-779,-717,-651,-592,-538,-475,-400,-330,-285,-263,-245,-213,-168,-120,-75,-28,29,91,150,192,210,198,157,98,38,-10,-50,-94,-151,-214,-268,-304,-324,-344,-376,-422,-477,-530,-568,-574,-538,-466,-383,-324,-302,-302,-296,-270,-230,-193,-166,-143,-124,-113,-115,-116,-102,-68,-29,-5,-3,-20,-48,-85,-132,-186,-241,-291,-330,-345,-330,-285,-222,-162,-117,-93,-85,-89,-97,-105,-110,-113,-113,-111,-104,-89,-65,-37,-18,-15,-30,-52,-70,-80,-83,-83,-87,-97,-112,-125,-129,-123,-113,-102,-92,-83,-80,-85,-98,-114,-127,-134,-132,-119,-97,-73,-55,-46,-45,-49,-58,-71,-81,-85,-82,-77,-70,-56,-36,-17,-5,-1,-2,-12,-35,-70,-104,-127,-138,-141,-130,-106,-79,-67,-71,-73,-54,-20},
            {-1,83,36,-100,-93,97,143,-131,-72,1554,5212,9439,11319,8525,1301,-7198,-12549,-11708,-5140,3093,7856,6735,2053,-1047,854,6465,11232,11670,8188,4016,1998,2671,4770,6585,6664,4123,-691,-5790,-8567,-7895,-5217,-3283,-3743,-5995,-8164,-8817,-7758,-5695,-3643,-2508,-2673,-3620,-4155,-3364,-1452,498,1579,1765,1589,1434,1363,1466,1969,2828,3482,3298,2296,1222,818,1125,1585,1696,1419,1002,632,391,370,613,929,912,286,-785,-1809,-2371,-2404,-2124,-1810,-1663,-1771,-2075,-2354,-2348,-1978,-1440,-1061,-1018,-1217,-1408,-1406,-1204,-915,-657,-484,-391,-337,-257,-79,228,601,900,1001,896,693,531,481,531,627,706,706,590,382,169,28,-38,-95,-199,-340,-464,-521,-498,-407,-290,-216,-245,-382,-558,-695,-756,-758,-732,-696,-656,-614,-559,-467,-327,-164,-26,53,73,55,31,31,76,155,221,228,177,115,88,108,158,213,255,257,197,84,-41,-131,-171,-175,-165,-145,-116,-82,-52,-34,-32,-58,-123,-222,-329,-411,-448,-445,-414,-370,-322,-274,-226,-171,-109,-53,-25,-36,-80,-130,-157,-146,-106,-58,-22,-7,-7,-15,-32,-64,-115,-175,-225,-249,-240,-200,-140,-73,-15,27,55,68,59,18,-51,-128,-189,-226,-243,-243,-220,-176,-123,-76,-45,-31,-37,-67,-116,-160,-177,-165,-139,-110,-79,-39,6,43,69,82,78,46,-13,-80,-126,-134,-108,-66,-22,14,37,47,45,33,16,-8,-36,-66,-93,-109,-108,-92,-74,-67,-75,-87,-97,-100,-96,-80,-50,-17}
        },
        {    // H30e126a.wav
            {3,2,0,-1,-1,1,0,-2,-3,-2,0,0,-1,-1,0,1,1,0,-1,-2,-2,-1,0,0,-2,-2,1,4,2,-1,-2,1,1,-5,-9,-3,7,7,-1,-1,8,12,-2,-15,-3,16,13,45,297,928,1835,2581,2643,1803,330,-1195,-2239,-2574,-2261,-1498,-477,665,1833,2918,3754,4137,3940,3252,2407,1824,1753,2122,2598,2787,2460,1648,609,-317,-891,-1095,-1120,-1207,-1477,-1854,-2143,-2198,-2040,-1831,-1736,-1789,-1874,-1830,-1577,-1166,-711,-307,9,244,412,541,666,808,952,1052,1080,1058,1029,1009,965,850,644,379,117,-76,-163,-152,-90,-43,-55,-133,-267,-446,-660,-882,-1064,-1169,-1195,-1169,-1117,-1039,-933,-812,-702,-617,-545,-461,-354,-238,-141,-88,-81,-100,-111,-83,-7,99,203,277,305,286,230,154,77,13,-32,-62,-88,-117,-156,-204,-260,-320,-383,-443,-498,-545,-578,-587,-571,-537,-504,-482,-464,-434,-384,-326,-280,-246,-213,-170,-131,-111,-105,-93,-59,-11,26,43,45,41,26,-9,-66,-132,-194,-243,-281,-306,-316,-307,-282,-242,-195,-153,-130,-130,-144,-154,-151,-143,-142,-149,-155,-147,-123,-92,-63,-40,-25,-23,-32,-49,-65,-77,-85,-94,-100,-101,-99,-98,-96,-88,-77,-70,-75,-89,-104,-114,-122,-130,-135,-131,-119,-104,-91,-79,-70,-66,-71,-85,-100,-111,-114,-106,-89,-67,-43,-20,-2,8,3,-16,-45,-74,-103,-127,-141,-137,-119,-103,-96,-88,-71,-55,-61,-87,-102,-79,-29},
            {-52,3,75,40,-84,-103,58,146,-67,-150,981,4004,7982,10404,8834,2933,-4813,-10353,-10581,-5516,1441,5710,4962,1069,-1412,741,6496,11567,12331,8822,4163,1559,2007,4337,6579,7043,4834,320,-4668,-7716,-7605,-5381,-3477,-3623,-5582,-7729,-8577,-7726,-5781,-3773,-2633,-2741,-3613,-4133,-3419,-1595,342,1464,1653,1437,1308,1391,1653,2110,2674,2989,2695,1882,1122,918,1219,1557,1574,1305,968,673,440,353,513,805,881,455,-394,-1286,-1881,-2095,-2047,-1911,-1850,-1984,-2291,-2549,-2477,-2000,-1365,-941,-907,-1140,-1363,-1380,-1172,-842,-517,-284,-172,-151,-148,-72,135,446,750,906,852,652,447,346,363,447,532,562,500,350,169,29,-41,-76,-125,-205,-296,-375,-422,-416,-354,-280,-272,-366,-512,-627,-664,-645,-613,-588,-574,-571,-563,-510,-380,-193,-17,88,115,93,59,37,46,90,140,150,99,20,-29,-20,41,121,187,207,161,60,-49,-121,-148,-150,-149,-144,-128,-99,-62,-20,16,24,-25,-130,-257,-361,-414,-420,-394,-355,-315,-281,-246,-198,-133,-67,-29,-37,-83,-138,-173,-176,-154,-123,-99,-90,-91,-94,-97,-103,-121,-155,-197,-232,-240,-212,-153,-82,-17,32,63,76,68,33,-20,-76,-120,-154,-180,-201,-208,-194,-164,-127,-88,-51,-27,-31,-68,-121,-163,-180,-173,-151,-116,-67,-12,32,56,64,59,37,-11,-74,-124,-138,-115,-77,-40,-12,10,22,22,13,4,-4,-16,-39,-67,-86,-92,-88,-81,-74,-70,-72,-81,-90,-83,-56,-19}
        },
        {    // H30e132a.wav
            {3,1,0,0,0,-1,-1,0,1,1,0,0,0,1,1,1,1,-1,-1,0,2,2,0,1,3,5,3,1,1,4,1,-4,-5,1,4,1,-1,8,20,14,-6,-11,9,20,9,93,487,1287,2249,2827,2539,1346,-285,-1696,-2440,-2455,-1944,-1138,-158,966,2186,3344,4163,4372,3901,2986,2089,1638,1779,2299,2777,2823,2275,1262,122,-786,-1262,-1357,-1305,-1351,-1593,-1939,-2190,-2204,-2005,-1775,-1704,-1831,-2005,-2010,-1747,-1297,-815,-389,-13,334,615,778,836,874,963,1090,1180,1187,1132,1064,994,891,727,508,281,95,-19,-49,-14,43,66,11,-139,-368,-629,-865,-1026,-1097,-1108,-1111,-1140,-1180,-1186,-1123,-994,-832,-674,-539,-432,-345,-268,-191,-111,-35,30,80,121,167,223,285,336,356,332,268,182,98,24,-40,-101,-161,-210,-238,-247,-257,-297,-382,-498,-601,-653,-647,-610,-574,-548,-518,-477,-435,-407,-385,-347,-283,-211,-161,-144,-144,-132,-96,-44,12,63,103,119,101,52,-13,-73,-119,-151,-175,-195,-214,-232,-245,-245,-228,-203,-184,-180,-182,-180,-173,-173,-187,-207,-213,-200,-171,-139,-104,-67,-34,-17,-22,-43,-67,-84,-90,-87,-80,-75,-76,-80,-80,-70,-56,-45,-43,-51,-65,-85,-106,-123,-130,-128,-123,-117,-110,-99,-85,-71,-65,-73,-93,-118,-135,-138,-127,-102,-68,-31,-1,13,13,0,-25,-64,-107,-137,-145,-134,-119,-103,-82,-58,-43,-46,-59,-68,-76,-93,-117,-122,-88,-31},
            {16,-45,-43,37,73,-15,-102,-22,121,44,-158,331,2429,5946,9045,9236,5313,-1360,-7380,-9432,-6586,-1092,3124,3432,678,-1476,221,5589,11065,12830,10031,5164,1663,1267,3336,5930,7146,5864,2139,-2644,-6315,-7321,-5941,-4059,-3561,-4853,-6825,-8009,-7692,-6155,-4266,-2947,-2721,-3363,-3969,-3597,-2079,-178,1125,1490,1339,1258,1450,1762,2046,2277,2395,2248,1805,1303,1068,1174,1397,1472,1332,1065,761,476,316,382,612,750,556,28,-623,-1193,-1619,-1919,-2100,-2182,-2253,-2392,-2529,-2456,-2049,-1448,-976,-861,-1048,-1279,-1318,-1107,-755,-415,-187,-82,-54,-36,27,173,394,626,769,752,597,401,267,238,293,378,429,399,281,130,19,-25,-40,-76,-144,-222,-294,-358,-399,-392,-343,-306,-336,-424,-506,-531,-505,-468,-449,-455,-484,-521,-521,-435,-266,-74,69,134,138,108,61,17,1,15,30,9,-47,-97,-101,-50,32,110,152,136,67,-21,-86,-114,-120,-126,-136,-143,-133,-101,-50,8,44,32,-36,-140,-244,-321,-356,-353,-325,-296,-278,-260,-220,-149,-70,-22,-26,-71,-133,-188,-224,-237,-223,-192,-158,-134,-118,-105,-97,-105,-136,-181,-221,-234,-216,-173,-115,-49,15,66,94,93,68,28,-19,-62,-100,-130,-154,-169,-169,-152,-121,-83,-49,-31,-39,-74,-122,-160,-173,-165,-145,-118,-82,-41,-8,11,21,28,26,3,-39,-80,-99,-94,-80,-66,-51,-32,-15,-3,9,26,40,34,6,-30,-61,-81,-91,-87,-69,-54,-58,-78,-87,-65,-23}
        },
        {    // H30e138a.wav
            {-1,-1,-2,-3,-2,-1,-1,-2,-2,-2,-1,0,0,-1,-2,-3,-3,-1,-1,-2,-2,1,4,3,-1,-2,2,3,-3,-9,-7,1,3,-5,-8,5,16,8,-8,-4,16,12,13,197,781,1751,2697,3000,2282,737,-981,-2194,-2594,-2302,-1627,-787,189,1362,2687,3912,4643,4580,3766,2630,1758,1539,1946,2587,2962,2746,1920,747,-385,-1164,-1497,-1528,-1515,-1657,-1973,-2311,-2462,-2315,-1947,-1588,-1468,-1642,-1935,-2075,-1893,-1433,-871,-367,24,323,549,709,825,944,1090,1228,1287,1234,1113,1005,951,915,819,613,330,67,-71,-42,100,239,266,139,-107,-393,-641,-811,-896,-925,-940,-978,-1047,-1118,-1148,-1115,-1029,-924,-829,-748,-663,-557,-436,-319,-226,-155,-88,0,115,245,359,427,432,385,314,248,201,167,129,75,-4,-102,-202,-280,-324,-344,-361,-392,-442,-513,-604,-700,-759,-739,-637,-502,-399,-355,-349,-342,-323,-301,-282,-257,-217,-168,-124,-85,-41,10,53,68,51,18,-10,-22,-23,-22,-29,-55,-101,-151,-186,-195,-187,-182,-189,-199,-202,-203,-211,-230,-249,-258,-257,-253,-245,-222,-175,-115,-61,-27,-17,-24,-43,-67,-90,-106,-112,-112,-110,-101,-84,-58,-32,-17,-16,-29,-49,-70,-89,-104,-115,-120,-120,-120,-118,-111,-98,-87,-85,-98,-117,-132,-138,-138,-133,-121,-98,-68,-37,-11,3,-2,-31,-75,-115,-137,-143,-138,-126,-110,-91,-77,-67,-56,-46,-45,-57,-74,-84,-92,-107,-126,-124,-86,-30},
            {4,23,-4,-38,-11,47,35,-53,-73,40,102,-52,-57,972,3561,6886,8835,7452,2642,-3369,-7358,-7323,-3917,21,1663,491,-1232,-447,3837,9410,12623,11470,7133,2763,908,1963,4504,6570,6672,4296,141,-4063,-6486,-6464,-4996,-3865,-4167,-5598,-6999,-7392,-6571,-5023,-3543,-2816,-3017,-3610,-3682,-2701,-1012,486,1189,1251,1232,1435,1713,1837,1832,1862,1933,1866,1573,1226,1079,1190,1380,1433,1270,946,569,274,186,330,558,635,426,-16,-553,-1094,-1610,-2062,-2379,-2530,-2552,-2487,-2304,-1959,-1510,-1135,-991,-1067,-1190,-1181,-986,-688,-408,-216,-106,-34,46,153,284,421,541,615,622,560,452,335,247,206,210,228,222,171,92,26,-7,-23,-53,-110,-187,-276,-368,-437,-449,-391,-303,-247,-253,-298,-346,-377,-392,-394,-386,-388,-417,-454,-446,-351,-189,-20,100,153,145,92,15,-50,-75,-68,-63,-88,-128,-146,-115,-42,42,102,115,81,21,-35,-72,-93,-113,-141,-167,-175,-153,-100,-31,30,56,33,-33,-121,-203,-262,-289,-288,-272,-255,-241,-215,-167,-102,-46,-27,-52,-110,-178,-237,-275,-283,-262,-224,-183,-149,-120,-97,-87,-100,-137,-180,-210,-217,-201,-163,-106,-38,27,77,105,111,95,62,20,-23,-60,-93,-118,-128,-122,-103,-82,-67,-58,-61,-76,-101,-124,-134,-133,-128,-121,-108,-87,-63,-39,-12,16,36,36,13,-21,-52,-74,-85,-83,-67,-44,-20,4,29,52,65,60,41,12,-24,-59,-82,-84,-76,-78,-91,-96,-71,-26}
        },
        {    // H30e144a.wav
            {-1,-1,-1,-1,-1,-1,0,2,2,0,0,0,-1,-2,-3,-1,0,0,0,3,5,2,-2,0,5,3,-4,-8,-1,7,1,-9,-6,12,18,1,-10,9,29,12,45,374,1188,2315,3162,3077,1862,-19,-1737,-2654,-2660,-2070,-1269,-411,593,1867,3317,4559,5103,4691,3534,2248,1489,1552,2219,2930,3137,2597,1457,134,-938,-1526,-1689,-1680,-1750,-1995,-2337,-2604,-2648,-2421,-2016,-1635,-1479,-1602,-1851,-1965,-1766,-1289,-724,-252,70,300,501,693,858,994,1108,1197,1237,1210,1132,1042,964,881,753,561,333,128,5,-13,52,142,184,120,-58,-307,-554,-739,-842,-877,-870,-852,-850,-879,-927,-955,-925,-840,-738,-666,-632,-613,-581,-528,-459,-373,-262,-122,32,180,306,400,452,452,405,329,249,180,121,66,12,-42,-99,-163,-233,-302,-371,-454,-567,-695,-790,-799,-713,-581,-471,-414,-388,-360,-321,-292,-286,-288,-272,-236,-198,-173,-152,-116,-65,-23,-11,-25,-41,-37,-9,27,52,55,33,-6,-49,-88,-116,-132,-136,-131,-130,-145,-182,-226,-263,-284,-295,-302,-304,-295,-269,-226,-169,-107,-57,-31,-31,-43,-54,-61,-70,-86,-103,-111,-105,-90,-73,-56,-37,-21,-14,-22,-43,-66,-83,-93,-100,-107,-111,-107,-94,-83,-82,-92,-106,-118,-126,-137,-149,-153,-142,-114,-77,-37,-7,4,-7,-36,-73,-108,-134,-146,-142,-129,-111,-92,-72,-52,-40,-39,-46,-52,-55,-63,-76,-86,-87,-89,-103,-123,-123,-86,-29},
            {-23,-11,18,19,-20,-39,3,48,12,-64,-47,62,65,-84,110,1452,4140,7045,8156,6075,1331,-3731,-6508,-5957,-3257,-786,-164,-893,-818,1856,6683,11036,12189,9560,5109,1676,925,2570,5035,6563,5993,3174,-906,-4522,-6240,-5909,-4682,-4000,-4470,-5626,-6556,-6629,-5785,-4449,-3286,-2835,-3108,-3481,-3182,-1998,-478,624,1061,1166,1318,1523,1572,1458,1430,1630,1856,1797,1432,1078,1031,1263,1494,1484,1201,756,300,-3,-9,287,663,799,525,-59,-718,-1307,-1816,-2258,-2567,-2654,-2509,-2217,-1879,-1557,-1293,-1137,-1106,-1139,-1117,-958,-695,-433,-255,-158,-80,32,180,329,446,517,543,541,529,512,474,384,239,83,-16,-29,7,33,27,10,-3,-35,-117,-241,-356,-421,-436,-422,-390,-332,-257,-190,-160,-171,-212,-271,-334,-384,-410,-418,-420,-412,-368,-268,-128,10,105,138,110,38,-45,-103,-120,-110,-108,-129,-157,-162,-129,-63,14,73,86,47,-21,-84,-119,-135,-150,-172,-190,-187,-158,-104,-40,13,36,15,-40,-111,-177,-225,-249,-252,-244,-235,-225,-200,-151,-91,-46,-38,-67,-122,-190,-259,-312,-333,-318,-276,-225,-172,-124,-86,-70,-86,-128,-181,-227,-250,-241,-198,-130,-51,23,80,118,133,128,103,61,7,-50,-98,-130,-144,-142,-130,-109,-87,-71,-66,-72,-87,-107,-128,-146,-156,-157,-147,-126,-96,-58,-18,17,38,42,25,-10,-50,-81,-94,-90,-76,-52,-23,9,37,57,66,57,22,-33,-88,-123,-138,-141,-138,-118,-76,-25}
        },
        {    // H30e150a.wav
            {-3,-3,-3,-2,-1,0,0,-1,-1,-2,-4,-4,-3,-1,-1,-2,0,4,4,-1,-4,0,5,1,-8,-8,2,7,-3,-13,-4,14,12,-9,-10,20,30,8,116,647,1713,2944,3581,3002,1254,-906,-2520,-3057,-2636,-1766,-866,9,1074,2486,4051,5235,5483,4647,3168,1840,1317,1717,2596,3263,3191,2281,858,-543,-1483,-1840,-1829,-1800,-1989,-2380,-2772,-2948,-2820,-2451,-2005,-1659,-1530,-1616,-1791,-1867,-1697,-1262,-678,-117,293,530,657,755,867,989,1097,1177,1218,1204,1124,990,848,738,650,534,354,145,-13,-53,10,97,118,22,-184,-449,-698,-855,-885,-812,-707,-647,-668,-743,-814,-825,-757,-639,-521,-449,-435,-460,-496,-516,-510,-475,-407,-299,-147,37,217,343,385,355,295,240,202,174,146,113,64,-4,-81,-144,-191,-256,-380,-559,-733,-835,-839,-775,-683,-575,-455,-335,-250,-223,-248,-290,-312,-298,-254,-198,-152,-128,-128,-146,-164,-164,-132,-70,-2,44,55,42,30,26,21,-4,-49,-93,-114,-105,-82,-71,-90,-138,-199,-253,-287,-304,-311,-314,-313,-303,-278,-237,-181,-122,-73,-42,-34,-46,-69,-93,-107,-108,-98,-86,-75,-63,-48,-31,-20,-18,-27,-44,-67,-93,-115,-128,-131,-125,-114,-101,-90,-83,-85,-96,-113,-132,-147,-159,-164,-159,-139,-105,-63,-25,-3,-5,-32,-73,-113,-139,-146,-139,-126,-114,-102,-90,-76,-60,-43,-30,-26,-36,-53,-68,-78,-85,-97,-113,-124,-126,-118,-102,-76,-44,-13},
            {13,-7,-26,-13,18,19,-17,-31,9,44,5,-57,-30,61,41,-74,229,1650,4225,6793,7552,5424,1068,-3414,-5902,-5674,-3743,-1877,-1094,-834,444,3677,7995,11133,11189,8197,4112,1310,1010,2773,5098,6353,5512,2590,-1310,-4554,-5982,-5634,-4575,-3980,-4315,-5228,-6010,-6097,-5358,-4143,-3106,-2755,-3013,-3235,-2783,-1623,-306,610,1023,1181,1262,1241,1120,1097,1348,1741,1905,1647,1196,969,1136,1479,1646,1458,983,408,-54,-202,59,580,982,925,379,-381,-1053,-1550,-1952,-2297,-2496,-2455,-2206,-1891,-1622,-1415,-1249,-1132,-1080,-1054,-972,-788,-544,-321,-163,-54,37,125,211,311,438,572,664,672,608,508,393,255,98,-37,-103,-98,-66,-50,-48,-35,-21,-53,-161,-317,-450,-511,-497,-432,-342,-249,-181,-152,-153,-163,-180,-221,-293,-375,-431,-449,-437,-396,-312,-179,-23,104,162,143,72,-13,-75,-95,-82,-69,-84,-127,-171,-184,-152,-89,-22,20,22,-8,-51,-91,-125,-159,-192,-214,-218,-201,-164,-105,-34,25,44,13,-52,-122,-176,-209,-222,-221,-212,-201,-187,-160,-113,-56,-14,-10,-51,-125,-209,-283,-330,-342,-318,-270,-214,-163,-121,-91,-79,-94,-134,-187,-229,-244,-224,-176,-109,-37,30,84,119,135,131,107,69,21,-32,-88,-139,-174,-184,-167,-131,-87,-46,-17,-10,-29,-67,-114,-159,-194,-210,-196,-153,-91,-24,38,81,96,77,32,-21,-65,-92,-101,-89,-59,-23,5,22,34,40,29,-4,-49,-87,-114,-138,-154,-143,-95,-31}
        },
        {    // H30e156a.wav
            {-2,-1,1,0,-1,0,1,0,-3,-4,-1,2,1,-2,1,6,6,0,-3,2,5,-1,-9,-3,9,9,-8,-15,3,20,6,-17,-4,33,29,14,244,1038,2369,3628,3917,2731,439,-1906,-3286,-3352,-2493,-1382,-419,484,1660,3247,4892,5903,5724,4411,2673,1445,1284,2059,3088,3591,3125,1783,88,-1319,-2041,-2115,-1926,-1901,-2222,-2749,-3174,-3261,-2978,-2484,-2007,-1707,-1618,-1655,-1697,-1648,-1461,-1122,-652,-125,351,678,842,915,985,1089,1194,1250,1234,1160,1053,937,823,708,573,405,219,59,-29,-38,-6,13,-25,-143,-338,-580,-810,-963,-1005,-951,-845,-725,-615,-536,-505,-517,-539,-528,-466,-374,-288,-239,-240,-288,-357,-399,-365,-241,-66,94,189,214,193,156,118,88,73,73,78,76,60,26,-34,-130,-266,-421,-560,-657,-712,-736,-731,-685,-593,-483,-395,-350,-332,-308,-260,-202,-158,-139,-142,-160,-190,-221,-232,-204,-136,-49,24,57,46,12,-14,-14,5,16,2,-35,-74,-100,-111,-113,-110,-108,-117,-145,-191,-237,-272,-293,-305,-310,-303,-280,-244,-201,-155,-110,-74,-56,-60,-74,-88,-95,-99,-103,-105,-99,-80,-49,-13,18,34,29,4,-32,-73,-111,-141,-157,-159,-152,-140,-130,-120,-110,-104,-107,-118,-136,-155,-168,-170,-158,-129,-89,-46,-13,-1,-11,-38,-72,-102,-124,-136,-138,-130,-114,-93,-72,-52,-36,-28,-26,-30,-37,-49,-64,-80,-95,-107,-114,-114,-102,-79,-54,-39,-35,-33,-25,-9},
            {-4,8,12,-5,-24,-13,14,15,-16,-28,7,38,4,-51,-28,51,35,-53,248,1566,3946,6360,7174,5350,1372,-2954,-5680,-5970,-4466,-2566,-1225,-219,1473,4481,8100,10553,10346,7536,3789,1199,926,2632,4897,6108,5263,2440,-1259,-4318,-5704,-5442,-4444,-3772,-3946,-4755,-5551,-5717,-5054,-3917,-2968,-2665,-2882,-3018,-2554,-1493,-293,582,983,1025,888,745,775,1081,1543,1839,1738,1349,1046,1096,1415,1673,1605,1193,616,106,-139,-17,399,843,989,689,65,-623,-1208,-1669,-2029,-2242,-2246,-2078,-1864,-1702,-1575,-1413,-1216,-1057,-986,-949,-852,-667,-449,-260,-110,24,132,186,198,242,384,602,786,826,698,466,224,46,-46,-71,-68,-75,-97,-106,-76,-19,11,-41,-181,-362,-519,-607,-611,-537,-409,-272,-176,-149,-176,-224,-270,-312,-354,-388,-401,-387,-351,-294,-210,-95,31,137,190,179,116,31,-38,-69,-67,-63,-85,-133,-181,-201,-182,-136,-85,-49,-39,-52,-80,-116,-156,-200,-239,-262,-258,-228,-180,-117,-51,3,23,3,-46,-104,-157,-199,-225,-229,-213,-183,-146,-102,-53,-10,9,-7,-57,-129,-207,-274,-314,-318,-294,-257,-220,-183,-145,-111,-93,-97,-123,-160,-194,-211,-201,-165,-114,-60,-8,39,79,103,106,88,52,-1,-66,-130,-179,-199,-189,-152,-97,-37,9,27,15,-24,-80,-140,-188,-210,-201,-168,-117,-52,16,71,98,93,63,19,-31,-75,-98,-95,-79,-67,-61,-49,-28,-8,-3,-10,-20,-39,-77,-123,-141,-106,-38}
        },
        {    // H30e162a.wav
            {0,0,-1,0,-1,-3,-6,-5,-1,1,-1,-2,3,7,3,-4,-3,4,5,-6,-13,-3,11,5,-13,-13,9,18,-6,-23,7,44,18,37,449,1550,3119,4296,4106,2249,-542,-2955,-3982,-3516,-2230,-929,57,989,2313,4094,5774,6503,5799,4001,2109,1127,1421,2548,3615,3828,2897,1130,-773,-2110,-2566,-2357,-2029,-2051,-2511,-3132,-3527,-3484,-3059,-2491,-2028,-1793,-1738,-1721,-1624,-1426,-1173,-891,-548,-113,367,773,1006,1074,1079,1118,1207,1289,1298,1218,1086,946,812,667,496,315,157,48,-19,-69,-121,-182,-258,-368,-526,-719,-904,-1038,-1099,-1086,-1006,-873,-713,-563,-451,-381,-340,-311,-281,-242,-200,-178,-195,-237,-251,-191,-55,106,229,282,267,204,119,36,-22,-49,-49,-35,-20,-22,-61,-147,-258,-359,-433,-496,-568,-642,-687,-674,-612,-534,-471,-436,-416,-392,-348,-283,-214,-159,-136,-145,-178,-220,-246,-227,-153,-41,64,121,120,82,39,8,-12,-26,-41,-56,-73,-98,-130,-158,-167,-155,-135,-130,-152,-191,-229,-255,-273,-287,-296,-295,-281,-253,-212,-160,-108,-71,-57,-65,-81,-95,-104,-112,-117,-119,-113,-99,-77,-49,-14,23,52,59,39,-3,-57,-110,-155,-185,-196,-187,-165,-142,-128,-125,-131,-145,-166,-190,-209,-214,-201,-169,-123,-71,-27,-2,-1,-18,-45,-72,-95,-108,-114,-114,-108,-96,-76,-57,-43,-35,-29,-26,-32,-47,-67,-83,-96,-110,-122,-121,-104,-78,-51,-23,5,19,4,-34,-63,-56,-22},
            {11,1,-6,3,12,1,-18,-15,10,18,-8,-26,-2,31,12,-38,-31,36,40,-30,202,1325,3482,5846,6899,5498,1844,-2491,-5563,-6280,-4957,-2841,-1032,331,1965,4506,7582,9796,9767,7329,3822,1207,751,2299,4528,5825,5165,2589,-892,-3876,-5351,-5224,-4261,-3493,-3535,-4281,-5101,-5345,-4795,-3782,-2916,-2604,-2743,-2836,-2422,-1456,-318,506,780,633,413,430,767,1253,1606,1646,1435,1214,1197,1391,1600,1601,1316,856,418,159,136,303,544,717,696,430,-47,-639,-1231,-1717,-2013,-2081,-1963,-1774,-1627,-1555,-1501,-1393,-1224,-1048,-909,-797,-670,-508,-332,-177,-59,19,63,93,154,285,486,694,820,802,639,386,130,-48,-108,-70,0,36,20,-19,-39,-37,-50,-118,-244,-393,-524,-619,-676,-685,-629,-508,-363,-254,-219,-252,-311,-359,-379,-371,-342,-294,-228,-144,-47,49,125,168,176,157,122,85,54,31,1,-48,-119,-191,-240,-248,-218,-164,-106,-67,-60,-86,-130,-179,-224,-263,-289,-293,-273,-235,-186,-130,-72,-22,5,0,-34,-87,-145,-190,-211,-207,-188,-160,-125,-76,-21,24,39,17,-35,-105,-176,-235,-269,-278,-268,-250,-224,-188,-144,-101,-74,-74,-101,-145,-185,-207,-203,-178,-138,-91,-44,-1,34,58,64,47,3,-57,-117,-160,-179,-169,-136,-86,-33,9,31,29,5,-36,-84,-126,-151,-157,-145,-113,-65,-13,30,58,71,69,44,-1,-49,-84,-103,-113,-116,-108,-86,-59,-37,-16,7,20,5,-35,-67,-62,-24}
        },
        {    // H30e168a.wav
            {-1,-1,-1,-5,-7,-5,0,1,-2,-1,5,7,0,-6,-1,7,2,-12,-14,2,13,-1,-20,-9,18,16,-19,-28,19,47,6,99,753,2186,3931,4898,4116,1570,-1633,-3981,-4562,-3555,-1898,-468,531,1545,3077,5048,6666,6982,5683,3450,1541,938,1730,3149,4133,3942,2494,331,-1691,-2868,-3017,-2549,-2142,-2256,-2860,-3539,-3858,-3657,-3096,-2483,-2061,-1882,-1827,-1729,-1505,-1197,-900,-651,-397,-61,370,810,1136,1279,1265,1199,1178,1228,1284,1259,1129,947,781,645,501,331,171,66,12,-48,-164,-332,-516,-693,-858,-1000,-1091,-1119,-1109,-1091,-1063,-986,-839,-653,-480,-353,-273,-226,-209,-212,-218,-206,-173,-123,-53,53,195,340,439,464,419,332,227,125,44,-5,-35,-75,-150,-253,-350,-412,-438,-458,-503,-575,-649,-694,-697,-666,-611,-540,-461,-389,-335,-295,-259,-222,-200,-204,-229,-251,-244,-203,-137,-57,27,99,142,150,135,113,91,64,31,-7,-47,-95,-152,-208,-242,-243,-217,-183,-161,-158,-174,-205,-243,-280,-310,-328,-328,-308,-269,-218,-162,-110,-65,-35,-25,-39,-69,-102,-128,-140,-138,-126,-108,-85,-59,-27,7,34,47,45,27,-8,-59,-118,-166,-190,-190,-179,-163,-146,-127,-118,-130,-164,-210,-252,-276,-274,-244,-191,-128,-69,-25,-3,-4,-23,-50,-75,-91,-97,-93,-82,-67,-54,-45,-39,-30,-21,-17,-21,-30,-42,-61,-89,-120,-142,-150,-141,-117,-77,-29,10,30,30,21,2,-30,-65,-82,-64,-24},
            {1,9,11,2,-7,-1,9,3,-15,-17,6,19,0,-24,-10,25,20,-27,-37,22,49,-10,119,996,2904,5240,6596,5686,2405,-1905,-5275,-6365,-5216,-2974,-897,586,2002,4079,6772,8982,9331,7361,4081,1346,578,1863,4033,5494,5155,2932,-313,-3274,-4903,-4959,-4062,-3217,-3125,-3786,-4627,-4995,-4622,-3759,-2939,-2560,-2598,-2653,-2296,-1444,-435,253,405,228,128,351,814,1239,1429,1408,1336,1345,1437,1519,1492,1318,1042,758,549,432,377,359,387,456,485,339,-59,-635,-1209,-1621,-1821,-1854,-1786,-1673,-1556,-1466,-1397,-1313,-1183,-1008,-814,-628,-458,-313,-209,-152,-129,-118,-94,-29,111,337,603,808,854,722,487,259,109,41,22,28,48,75,88,65,1,-89,-183,-274,-369,-468,-565,-655,-733,-789,-802,-751,-637,-494,-365,-279,-239,-241,-271,-302,-301,-247,-149,-39,58,137,200,242,247,211,151,93,52,22,-15,-68,-133,-193,-238,-259,-252,-216,-160,-109,-91,-118,-178,-240,-283,-301,-302,-296,-284,-263,-228,-178,-117,-58,-17,-7,-29,-71,-118,-157,-178,-182,-171,-149,-119,-80,-33,14,48,53,22,-39,-116,-188,-240,-264,-262,-242,-208,-167,-125,-90,-72,-78,-108,-156,-204,-236,-242,-222,-183,-134,-83,-35,2,22,19,-7,-50,-101,-147,-175,-176,-151,-107,-55,-4,36,58,56,30,-14,-64,-106,-132,-133,-112,-76,-36,-5,13,18,12,-2,-23,-47,-72,-92,-105,-111,-110,-102,-86,-60,-27,2,18,15,4,-4,-3}
        },
        {    // H30e174a.wav
            {0,-4,-7,-2,3,2,-2,0,6,7,0,-5,1,7,-1,-14,-10,8,12,-9,-22,0,27,10,-31,-22,37,44,-1,217,1169,2932,4758,5375,3916,718,-2764,-4909,-4981,-3466,-1518,-18,997,2148,3937,6072,7521,7306,5381,2808,1044,935,2218,3816,4572,3879,1905,-576,-2605,-3536,-3373,-2713,-2303,-2535,-3244,-3921,-4123,-3762,-3093,-2482,-2143,-2031,-1933,-1678,-1278,-880,-605,-431,-241,49,425,816,1152,1381,1464,1401,1267,1176,1181,1223,1189,1027,785,553,385,283,232,210,172,59,-156,-443,-736,-991,-1188,-1311,-1343,-1292,-1210,-1149,-1107,-1028,-870,-655,-452,-318,-263,-264,-288,-305,-291,-235,-143,-29,100,242,387,507,574,578,535,465,385,295,188,66,-60,-166,-239,-284,-320,-366,-426,-502,-594,-694,-779,-820,-804,-743,-655,-557,-457,-370,-313,-286,-278,-274,-264,-240,-190,-115,-37,8,9,-7,5,63,145,210,228,198,137,69,8,-42,-87,-137,-189,-232,-254,-251,-227,-194,-169,-168,-196,-242,-287,-316,-328,-329,-323,-309,-279,-228,-158,-82,-18,15,12,-18,-59,-98,-126,-140,-139,-125,-103,-77,-45,-7,34,68,82,64,13,-58,-129,-179,-197,-187,-161,-131,-108,-97,-102,-125,-164,-211,-253,-280,-286,-270,-233,-180,-122,-70,-36,-24,-31,-51,-74,-90,-90,-77,-62,-51,-46,-40,-29,-13,3,19,31,30,10,-25,-64,-97,-122,-139,-148,-143,-125,-94,-53,-6,35,53,43,16,-15,-42,-67,-85,-83,-56,-19},
            {2,-2,-2,6,12,5,-5,-3,8,7,-10,-18,-2,16,5,-20,-15,20,28,-14,-41,5,53,11,48,673,2285,4525,6148,5773,2994,-1135,-4697,-6162,-5302,-3119,-945,569,1779,3463,5844,8095,8871,7450,4488,1668,529,1435,3451,5061,5100,3317,390,-2496,-4279,-4575,-3836,-2986,-2777,-3328,-4168,-4664,-4483,-3773,-2986,-2520,-2438,-2441,-2158,-1480,-676,-134,-1,-65,3,330,762,1082,1232,1310,1410,1507,1524,1434,1282,1129,999,886,766,613,423,255,200,280,373,289,-57,-565,-1049,-1393,-1605,-1721,-1739,-1648,-1493,-1357,-1273,-1195,-1058,-853,-630,-443,-318,-253,-238,-244,-235,-193,-124,-39,85,278,526,747,844,782,600,382,197,82,42,54,80,87,63,15,-50,-136,-250,-389,-532,-656,-746,-799,-816,-800,-756,-696,-639,-588,-530,-445,-334,-224,-152,-124,-116,-99,-63,-15,43,113,192,263,298,285,225,134,37,-39,-78,-92,-111,-158,-220,-265,-271,-239,-191,-148,-127,-138,-180,-238,-288,-317,-329,-334,-333,-316,-273,-205,-126,-53,-3,12,-10,-58,-107,-137,-144,-138,-132,-127,-113,-81,-31,22,62,76,56,3,-72,-147,-203,-225,-220,-200,-177,-151,-123,-98,-86,-97,-130,-176,-222,-256,-268,-254,-216,-166,-114,-66,-26,1,6,-15,-58,-109,-153,-176,-173,-142,-90,-29,26,66,86,85,62,23,-26,-73,-105,-115,-106,-85,-61,-42,-33,-31,-34,-36,-38,-43,-56,-73,-87,-91,-82,-63,-43,-24,-10,-1,4,4,2}
        },
        {    // H30e180a.wav
            {-7,-1,3,1,-2,2,8,6,-4,-6,4,8,-5,-18,-8,12,10,-15,-21,9,29,-2,-39,-11,49,30,8,405,1688,3733,5521,5674,3521,-225,-3825,-5657,-5226,-3303,-1179,344,1423,2796,4871,7104,8268,7456,4956,2179,684,1106,2819,4480,4899,3647,1165,-1552,-3478,-4093,-3626,-2847,-2521,-2911,-3695,-4295,-4319,-3790,-3056,-2501,-2273,-2212,-2033,-1592,-1014,-549,-321,-227,-74,216,569,880,1130,1345,1503,1539,1433,1264,1145,1113,1109,1040,862,599,332,164,157,265,338,225,-100,-521,-902,-1195,-1419,-1575,-1617,-1526,-1366,-1233,-1159,-1086,-943,-728,-502,-334,-249,-242,-287,-338,-346,-280,-151,7,165,318,461,578,652,679,659,585,446,257,71,-49,-79,-48,-22,-52,-148,-279,-408,-519,-619,-715,-800,-854,-860,-816,-733,-630,-529,-456,-420,-409,-393,-343,-251,-133,-20,51,63,26,-15,-10,59,165,258,297,269,186,78,-19,-82,-109,-122,-146,-188,-232,-256,-247,-211,-169,-148,-164,-212,-269,-310,-330,-338,-344,-344,-328,-287,-223,-146,-67,-7,17,1,-40,-82,-109,-123,-128,-127,-119,-103,-81,-51,-8,43,82,85,45,-25,-101,-165,-204,-217,-204,-172,-135,-106,-91,-91,-110,-149,-203,-259,-297,-303,-276,-227,-169,-114,-67,-35,-23,-32,-56,-83,-105,-119,-123,-116,-96,-66,-31,3,34,59,71,64,37,-3,-46,-81,-102,-112,-114,-115,-113,-106,-87,-57,-25,-5,-2,-16,-36,-52,-57,-50,-43,-42,-46,-45,-32,-11},
            {-7,-1,3,1,-2,2,8,6,-4,-6,4,8,-5,-18,-8,12,10,-15,-21,9,29,-2,-39,-11,49,30,8,405,1688,3733,5521,5674,3521,-225,-3825,-5657,-5226,-3303,-1179,344,1423,2796,4871,7104,8268,7456,4956,2179,684,1106,2819,4480,4899,3647,1165,-1552,-3478,-4093,-3626,-2847,-2521,-2911,-3695,-4295,-4319,-3790,-3056,-2501,-2273,-2212,-2033,-1592,-1014,-549,-321,-227,-74,216,569,880,1130,1345,1503,1539,1433,1264,1145,1113,1109,1040,862,599,332,164,157,265,338,225,-100,-521,-902,-1195,-1419,-1575,-1617,-1526,-1366,-1233,-1159,-1086,-943,-728,-502,-334,-249,-242,-287,-338,-346,-280,-151,7,165,318,461,578,652,679,659,585,446,257,71,-49,-79,-48,-22,-52,-148,-279,-408,-519,-619,-715,-800,-854,-860,-816,-733,-630,-529,-456,-420,-409,-393,-343,-251,-133,-20,51,63,26,-15,-10,59,165,258,297,269,186,78,-19,-82,-109,-122,-146,-188,-232,-256,-247,-211,-169,-148,-164,-212,-269,-310,-330,-338,-344,-344,-328,-287,-223,-146,-67,-7,17,1,-40,-82,-109,-123,-128,-127,-119,-103,-81,-51,-8,43,82,85,45,-25,-101,-165,-204,-217,-204,-172,-135,-106,-91,-91,-110,-149,-203,-259,-297,-303,-276,-227,-169,-114,-67,-35,-23,-32,-56,-83,-105,-119,-123,-116,-96,-66,-31,3,34,59,71,64,37,-3,-46,-81,-102,-112,-114,-115,-113,-106,-87,-57,-25,-5,-2,-16,-36,-52,-57,-50,-43,-42,-46,-45,-32,-11}
        }
    },
    {    // elev40 
        {    // H40e000a.wav
            {12,-2,-14,-6,6,0,-9,4,22,10,-18,-11,27,26,-31,-57,5,63,6,-94,-60,87,109,-66,-164,25,222,45,-147,657,2808,5100,5784,4442,2213,-81,-3208,-8006,-12878,-14078,-9367,-865,6634,10241,11194,12388,14540,15539,13223,7889,1896,-2430,-4048,-3064,-400,2266,3108,1469,-1486,-3874,-4882,-5214,-5794,-6490,-6415,-5251,-3791,-3076,-3264,-3589,-3317,-2525,-1864,-1734,-1837,-1542,-593,623,1501,1811,1841,1978,2286,2539,2560,2428,2322,2294,2241,2047,1672,1172,696,432,420,400,-3,-837,-1621,-1760,-1191,-522,-441,-1055,-1848,-2240,-2081,-1629,-1196,-914,-753,-644,-535,-390,-204,-5,174,323,430,472,436,356,301,315,405,560,773,1011,1191,1228,1099,866,622,419,253,87,-107,-330,-555,-749,-908,-1058,-1226,-1396,-1512,-1539,-1494,-1431,-1385,-1351,-1311,-1262,-1205,-1112,-933,-645,-290,37,252,328,303,243,210,240,322,399,406,325,207,126,113,131,126,77,1,-77,-141,-186,-211,-231,-272,-342,-409,-429,-386,-307,-240,-215,-236,-293,-361,-408,-411,-382,-350,-331,-309,-262,-188,-102,-14,69,129,144,113,69,49,56,64,56,41,36,44,53,56,53,39,-1,-74,-161,-232,-270,-276,-264,-246,-227,-210,-193,-180,-173,-172,-173,-169,-163,-160,-163,-162,-144,-108,-69,-45,-39,-46,-56,-62,-62,-58,-59,-70,-87,-97,-92,-76,-63,-59,-62,-67,-72,-76,-78,-76,-71,-65,-66,-74,-89,-108,-125,-134,-134,-122,-100,-74,-54,-44,-41,-35,-21,-6},
            {12,-2,-14,-6,6,0,-9,4,22,10,-18,-11,27,26,-31,-57,5,63,6,-94,-60,87,109,-66,-164,25,222,45,-147,657,2808,5100,5784,4442,2213,-81,-3208,-8006,-12878,-14078,-9367,-865,6634,10241,11194,12388,14540,15539,13223,7889,1896,-2430,-4048,-3064,-400,2266,3108,1469,-1486,-3874,-4882,-5214,-5794,-6490,-6415,-5251,-3791,-3076,-3264,-3589,-3317,-2525,-1864,-1734,-1837,-1542,-593,623,1501,1811,1841,1978,2286,2539,2560,2428,2322,2294,2241,2047,1672,1172,696,432,420,400,-3,-837,-1621,-1760,-1191,-522,-441,-1055,-1848,-2240,-2081,-1629,-1196,-914,-753,-644,-535,-390,-204,-5,174,323,430,472,436,356,301,315,405,560,773,1011,1191,1228,1099,866,622,419,253,87,-107,-330,-555,-749,-908,-1058,-1226,-1396,-1512,-1539,-1494,-1431,-1385,-1351,-1311,-1262,-1205,-1112,-933,-645,-290,37,252,328,303,243,210,240,322,399,406,325,207,126,113,131,126,77,1,-77,-141,-186,-211,-231,-272,-342,-409,-429,-386,-307,-240,-215,-236,-293,-361,-408,-411,-382,-350,-331,-309,-262,-188,-102,-14,69,129,144,113,69,49,56,64,56,41,36,44,53,56,53,39,-1,-74,-161,-232,-270,-276,-264,-246,-227,-210,-193,-180,-173,-172,-173,-169,-163,-160,-163,-162,-144,-108,-69,-45,-39,-46,-56,-62,-62,-58,-59,-70,-87,-97,-92,-76,-63,-59,-62,-67,-72,-76,-78,-76,-71,-65,-66,-74,-89,-108,-125,-134,-134,-122,-100,-74,-54,-44,-41,-35,-21,-6}
        },
        {    // H40e006a.wav
            {-6,1,9,3,-8,-7,3,2,-7,-2,15,15,-7,-15,12,29,-4,-44,-21,37,28,-52,-73,25,100,11,-116,-49,136,109,-100,200,1611,3636,4878,4459,2863,968,-1394,-5101,-9734,-12677,-11166,-5269,1804,6703,8896,10319,12467,14520,14411,11181,5929,814,-2392,-2996,-1445,857,2189,1617,-311,-2178,-3114,-3474,-4096,-5120,-5835,-5599,-4614,-3663,-3249,-3183,-2995,-2553,-2161,-2101,-2220,-2041,-1262,-106,867,1290,1295,1308,1591,2037,2366,2427,2290,2122,2042,2052,2043,1865,1488,1071,807,639,254,-529,-1408,-1796,-1443,-769,-479,-866,-1572,-2017,-1955,-1576,-1193,-942,-779,-634,-483,-327,-172,-41,43,94,157,254,342,358,294,224,256,459,807,1177,1401,1359,1053,620,247,62,57,109,72,-122,-423,-714,-915,-1035,-1138,-1252,-1347,-1368,-1306,-1203,-1105,-1029,-968,-923,-911,-933,-949,-884,-689,-381,-49,197,294,260,169,103,105,158,211,212,152,64,-5,-25,-5,24,27,-12,-83,-154,-195,-205,-214,-253,-321,-382,-404,-384,-339,-283,-228,-191,-195,-246,-316,-367,-381,-362,-320,-261,-196,-135,-84,-34,24,80,117,126,116,98,74,47,27,26,38,47,43,29,13,-10,-49,-99,-148,-187,-216,-236,-240,-224,-197,-176,-172,-181,-191,-193,-185,-172,-159,-151,-147,-140,-128,-111,-96,-88,-84,-80,-73,-65,-55,-44,-33,-27,-29,-38,-52,-70,-90,-103,-101,-87,-73,-69,-70,-69,-60,-49,-44,-53,-76,-106,-134,-151,-150,-139,-126,-114,-94,-60,-20},
            {-13,-12,3,2,-10,-4,20,19,-14,-24,17,40,-12,-72,-32,63,53,-73,-111,37,152,14,-192,-98,203,188,-155,166,2070,4873,6546,5815,3436,773,-2362,-7219,-13155,-16396,-13179,-4124,5641,11296,12690,13298,15412,17462,16225,10735,3320,-2674,-5348,-4711,-1908,1312,3027,2147,-661,-3504,-5044,-5574,-6164,-7050,-7328,-6231,-4269,-2808,-2656,-3339,-3761,-3363,-2505,-1859,-1613,-1368,-699,326,1238,1722,1925,2194,2599,2878,2812,2526,2328,2343,2412,2312,1963,1422,820,347,164,197,91,-455,-1274,-1797,-1644,-1069,-723,-981,-1616,-2107,-2162,-1868,-1464,-1106,-833,-641,-507,-389,-257,-110,50,241,450,587,556,386,242,266,427,572,614,632,776,1079,1400,1525,1334,886,371,-21,-222,-301,-377,-516,-711,-935,-1177,-1420,-1616,-1714,-1721,-1701,-1714,-1745,-1722,-1591,-1363,-1092,-828,-587,-368,-158,52,260,433,526,528,481,449,454,458,420,345,279,250,234,194,119,32,-50,-125,-197,-259,-311,-362,-413,-441,-420,-359,-303,-285,-296,-309,-319,-343,-385,-423,-435,-423,-394,-346,-270,-175,-82,2,82,156,196,182,135,97,83,72,45,15,8,29,57,71,72,57,14,-67,-174,-270,-330,-348,-338,-313,-278,-241,-208,-183,-171,-173,-183,-191,-185,-169,-153,-140,-121,-92,-60,-37,-30,-31,-33,-35,-37,-41,-49,-63,-79,-90,-88,-80,-79,-90,-104,-109,-100,-86,-77,-76,-82,-91,-102,-112,-120,-124,-124,-117,-104,-89,-74,-61,-50,-37,-25,-15,-9,-6,-4,-2}
        },
        {    // H40e013a.wav
            {5,0,-3,4,8,1,-8,-6,1,0,-5,1,13,8,-9,-8,15,22,-10,-36,-8,33,12,-50,-48,38,77,-11,-94,-14,117,52,-78,339,1678,3368,4259,3801,2477,858,-1393,-4907,-8951,-11107,-9301,-4083,1650,5405,7225,8885,11320,13392,13183,10076,5343,1033,-1402,-1642,-359,1192,1794,1005,-563,-1882,-2519,-2919,-3694,-4779,-5479,-5257,-4320,-3362,-2865,-2760,-2699,-2511,-2312,-2223,-2125,-1739,-964,-47,621,881,938,1107,1487,1906,2147,2163,2068,1989,1974,1995,1968,1811,1527,1217,953,627,43,-775,-1449,-1553,-1088,-555,-485,-938,-1501,-1752,-1620,-1318,-1039,-816,-615,-440,-321,-250,-194,-146,-113,-74,11,137,232,227,143,94,195,474,845,1162,1290,1171,850,448,102,-99,-148,-105,-68,-116,-279,-520,-775,-989,-1136,-1204,-1192,-1115,-1018,-949,-922,-907,-866,-800,-753,-753,-776,-756,-645,-452,-227,-22,126,194,176,101,24,-13,-11,-7,-22,-44,-48,-37,-33,-48,-71,-89,-100,-114,-139,-173,-217,-267,-307,-317,-297,-268,-255,-256,-255,-243,-229,-226,-241,-273,-314,-346,-345,-298,-216,-128,-52,11,61,93,104,99,88,74,51,25,9,11,25,36,38,32,15,-17,-62,-107,-145,-173,-193,-200,-193,-180,-173,-176,-184,-190,-195,-202,-206,-202,-189,-174,-160,-144,-124,-104,-94,-95,-99,-93,-72,-42,-17,-4,-2,-5,-12,-28,-54,-85,-108,-119,-117,-105,-82,-55,-38,-41,-53,-55,-50,-53,-75,-99,-109,-111,-127,-154,-158,-112,-39},
            {-4,3,-7,-8,16,28,-1,-29,0,46,18,-63,-67,33,81,-25,-127,-28,150,102,-147,-191,110,272,-49,-134,1266,4170,6747,7048,5044,2147,-1191,-6128,-12815,-17985,-16890,-8322,3251,11565,14380,14627,15972,18352,18498,14079,6310,-1331,-5953,-6633,-4095,-160,2754,2803,117,-3253,-5286,-5821,-6187,-7198,-8068,-7490,-5385,-3141,-2168,-2567,-3316,-3489,-3045,-2495,-2109,-1634,-744,435,1390,1778,1809,1979,2491,3039,3204,2938,2564,2379,2376,2347,2126,1684,1091,515,159,75,17,-352,-1036,-1616,-1682,-1320,-1037,-1207,-1704,-2106,-2158,-1924,-1597,-1286,-1012,-780,-579,-372,-150,28,120,192,355,583,699,581,337,190,213,267,227,203,446,1028,1686,2014,1802,1192,522,50,-182,-280,-356,-449,-566,-723,-946,-1220,-1491,-1713,-1892,-2061,-2214,-2272,-2137,-1787,-1315,-887,-632,-558,-554,-473,-233,132,499,745,821,771,687,624,571,490,377,280,246,262,269,222,126,16,-92,-198,-297,-376,-429,-462,-475,-459,-414,-358,-317,-294,-275,-268,-298,-375,-465,-522,-523,-479,-399,-286,-155,-41,36,91,151,211,241,226,189,158,131,88,30,-13,-14,19,58,82,81,45,-32,-146,-270,-371,-428,-439,-413,-364,-306,-250,-202,-173,-171,-193,-215,-212,-182,-144,-120,-108,-93,-68,-41,-23,-13,-5,2,3,-2,-8,-18,-34,-59,-83,-101,-111,-119,-127,-127,-117,-103,-95,-100,-115,-130,-137,-133,-122,-109,-96,-86,-79,-77,-76,-69,-54,-34,-16,-1,8,13,11,5,-1,-1}
        },
        {    // H40e019a.wav
            {-8,-1,5,2,-3,0,6,4,-4,-5,0,1,-2,0,9,7,-6,-10,7,17,-3,-28,-16,19,16,-30,-43,16,60,7,-69,-31,77,58,-58,170,1130,2529,3503,3462,2613,1389,-387,-3240,-6784,-9207,-8637,-5060,-499,2959,5036,6956,9487,11754,12134,9984,6261,2626,274,-493,-47,860,1385,1036,2,-1067,-1754,-2259,-3029,-4078,-4858,-4826,-4041,-3107,-2587,-2548,-2656,-2611,-2395,-2155,-1941,-1635,-1129,-499,50,394,612,868,1221,1579,1823,1929,1949,1940,1928,1918,1888,1787,1578,1289,966,585,64,-562,-1049,-1124,-794,-412,-359,-689,-1118,-1338,-1284,-1093,-900,-744,-625,-554,-526,-490,-404,-297,-231,-216,-193,-118,-20,32,22,24,137,396,731,1003,1088,952,668,361,126,-15,-81,-91,-64,-50,-121,-318,-599,-864,-1027,-1066,-1016,-928,-845,-796,-786,-798,-795,-759,-704,-662,-641,-624,-582,-505,-399,-271,-133,-9,69,82,40,-27,-95,-159,-211,-231,-199,-125,-49,-15,-42,-108,-171,-197,-182,-158,-158,-191,-232,-248,-230,-200,-187,-198,-220,-241,-256,-265,-263,-254,-246,-248,-251,-236,-193,-130,-67,-15,23,51,67,73,72,66,52,30,7,-8,-12,-10,-5,-2,-3,-15,-38,-69,-100,-129,-156,-176,-185,-184,-186,-197,-213,-221,-216,-206,-201,-198,-192,-182,-171,-158,-135,-103,-76,-67,-71,-70,-52,-26,-6,0,-2,-10,-23,-41,-60,-79,-101,-121,-131,-123,-101,-75,-53,-33,-19,-18,-35,-58,-76,-91,-116,-145,-148,-106,-38},
            {-7,-13,12,32,5,-30,-8,43,26,-57,-75,21,83,-13,-129,-48,146,130,-124,-213,75,291,-10,-229,961,3867,6855,7820,6329,3499,-229,-5916,-13651,-19978,-19638,-10831,2047,12057,16049,16583,17665,19759,19787,15292,7390,-451,-5436,-6794,-5120,-1700,1509,2457,486,-2943,-5598,-6617,-6950,-7696,-8536,-8205,-6234,-3716,-2215,-2203,-2833,-3067,-2726,-2345,-2255,-2103,-1327,79,1477,2242,2372,2355,2544,2835,2959,2885,2801,2795,2734,2486,2079,1598,1064,518,131,31,42,-216,-854,-1501,-1700,-1464,-1268,-1478,-1946,-2251,-2190,-1910,-1631,-1399,-1163,-924,-707,-471,-162,168,391,480,554,701,824,747,445,91,-136,-203,-158,27,442,1070,1686,1995,1847,1337,697,143,-221,-391,-424,-403,-412,-509,-714,-1013,-1376,-1770,-2157,-2475,-2633,-2536,-2160,-1602,-1061,-723,-648,-729,-777,-647,-309,152,601,922,1056,1025,902,760,626,495,372,289,272,294,298,244,146,30,-91,-215,-327,-404,-449,-485,-522,-534,-493,-406,-313,-246,-217,-231,-294,-396,-498,-556,-558,-515,-435,-318,-178,-49,51,132,213,281,305,280,235,201,174,134,82,41,30,38,51,63,66,43,-31,-149,-277,-382,-448,-479,-477,-443,-388,-328,-278,-245,-229,-225,-222,-208,-185,-163,-152,-143,-119,-75,-24,16,39,47,47,44,42,39,27,-1,-39,-73,-93,-104,-113,-122,-128,-133,-143,-160,-175,-174,-156,-126,-97,-76,-64,-64,-75,-90,-99,-94,-77,-55,-34,-15,4,16,18,11,6,9,16,17,8}
        },
        {    // H40e026a.wav
            {-1,-6,-6,0,3,0,-3,1,6,3,-3,-4,0,1,-1,2,7,4,-6,-6,8,13,-5,-23,-9,18,10,-27,-31,19,49,1,-56,-17,64,35,-49,186,1027,2205,3025,3050,2435,1445,-146,-2733,-5873,-8003,-7635,-4821,-1150,1838,3994,6160,8673,10661,10897,9070,6053,3108,1073,188,277,856,1261,1016,189,-729,-1395,-1946,-2704,-3636,-4274,-4200,-3522,-2780,-2432,-2487,-2616,-2547,-2285,-1997,-1776,-1549,-1200,-727,-244,149,460,768,1113,1451,1709,1843,1853,1774,1671,1617,1628,1644,1579,1389,1080,654,121,-415,-743,-712,-416,-162,-208,-535,-907,-1117,-1136,-1058,-965,-882,-812,-754,-680,-565,-441,-382,-419,-469,-412,-227,-28,50,-1,-52,50,339,705,966,995,792,480,217,97,106,159,171,108,-25,-204,-407,-609,-779,-892,-932,-907,-843,-777,-739,-729,-730,-722,-705,-692,-684,-660,-599,-506,-413,-342,-287,-224,-147,-76,-36,-31,-56,-106,-183,-265,-308,-276,-179,-76,-27,-50,-120,-193,-229,-217,-170,-126,-118,-149,-191,-211,-201,-181,-177,-196,-227,-253,-261,-251,-231,-207,-183,-157,-134,-124,-124,-115,-78,-16,44,77,82,73,60,38,5,-28,-46,-45,-32,-15,1,10,5,-19,-60,-107,-150,-178,-188,-184,-178,-182,-195,-210,-221,-225,-220,-203,-180,-162,-155,-150,-131,-98,-67,-53,-54,-55,-49,-39,-33,-29,-26,-22,-20,-22,-30,-48,-73,-99,-116,-122,-118,-104,-80,-55,-42,-40,-36,-27,-32,-70,-126,-150,-112,-40},
            {-4,28,23,-19,-26,25,46,-22,-86,-27,78,46,-99,-114,74,181,-11,-231,-75,269,183,-266,122,2359,5675,7939,7834,5838,2616,-2632,-10726,-19322,-22831,-17143,-4341,8500,15722,17647,18446,20404,21505,18522,11182,2582,-3769,-6371,-5667,-2930,163,1749,759,-2087,-4869,-6354,-7024,-7986,-9229,-9488,-7845,-5015,-2732,-2053,-2515,-2937,-2719,-2195,-1906,-1841,-1518,-641,533,1527,2177,2667,3119,3347,3146,2680,2390,2511,2813,2892,2583,2007,1326,640,93,-145,-113,-130,-474,-1022,-1389,-1431,-1430,-1707,-2171,-2425,-2258,-1878,-1610,-1523,-1444,-1236,-929,-599,-260,76,342,511,676,926,1152,1076,566,-132,-563,-471,-19,418,638,753,980,1349,1641,1590,1133,452,-173,-553,-648,-528,-325,-207,-326,-734,-1334,-1938,-2383,-2597,-2574,-2331,-1912,-1423,-1019,-823,-840,-953,-996,-842,-460,78,630,1041,1210,1140,934,719,570,482,418,364,339,347,359,328,231,85,-82,-243,-373,-456,-492,-507,-519,-518,-481,-410,-333,-281,-258,-257,-285,-353,-445,-520,-545,-519,-455,-359,-239,-116,-10,83,179,274,337,340,298,248,209,166,107,51,27,47,85,112,108,68,-12,-126,-254,-366,-442,-477,-480,-465,-439,-402,-355,-307,-277,-270,-278,-280,-264,-235,-206,-175,-136,-86,-34,12,48,74,85,82,72,60,45,18,-19,-53,-71,-77,-83,-100,-126,-155,-177,-189,-190,-180,-160,-128,-92,-65,-58,-71,-89,-101,-102,-96,-85,-69,-51,-37,-28,-17,-2,9,8,1,3,17,29,25,9}
        },
        {    // H40e032a.wav
            {-3,0,0,-3,-5,-3,1,0,-2,0,4,3,-2,-3,0,2,-2,-3,2,5,-1,-5,1,9,2,-13,-10,10,13,-12,-27,1,34,14,-37,-32,32,42,-27,54,579,1500,2355,2690,2462,1846,738,-1220,-3935,-6363,-7112,-5664,-2852,14,2365,4541,6876,8923,9759,8908,6784,4296,2222,958,567,809,1178,1155,597,-195,-858,-1369,-1974,-2764,-3447,-3625,-3239,-2661,-2328,-2357,-2508,-2487,-2232,-1908,-1686,-1566,-1406,-1089,-628,-129,316,676,952,1147,1264,1329,1378,1435,1507,1602,1717,1810,1804,1642,1323,893,421,-1,-262,-299,-181,-95,-203,-506,-856,-1099,-1182,-1153,-1082,-1015,-976,-955,-912,-807,-660,-540,-490,-465,-382,-234,-112,-105,-177,-186,-10,333,698,914,901,701,443,266,233,305,375,349,202,-19,-247,-438,-583,-691,-772,-826,-846,-831,-792,-749,-718,-709,-716,-730,-732,-699,-620,-509,-404,-339,-318,-317,-311,-285,-239,-179,-117,-81,-96,-155,-220,-248,-228,-186,-153,-141,-143,-152,-165,-172,-165,-143,-124,-130,-160,-196,-221,-230,-228,-218,-200,-178,-163,-164,-177,-192,-199,-193,-174,-142,-102,-64,-38,-24,-13,1,16,23,18,6,-6,-13,-18,-23,-31,-35,-31,-24,-23,-34,-58,-88,-119,-146,-166,-175,-173,-168,-169,-182,-201,-215,-218,-210,-195,-171,-143,-116,-96,-83,-73,-62,-55,-58,-67,-70,-61,-48,-39,-36,-30,-22,-20,-29,-46,-65,-85,-105,-120,-120,-107,-94,-90,-88,-75,-57,-55,-72,-84,-67,-26},
            {35,-9,-35,10,54,4,-82,-56,62,78,-66,-143,15,190,68,-210,-171,205,295,-167,-233,1407,4619,7549,8496,7419,4874,107,-8141,-18261,-24577,-21490,-9306,5189,14796,18097,19019,20943,22707,20739,13884,4942,-2172,-5574,-5659,-3587,-610,1617,1486,-1156,-4587,-6836,-7613,-8163,-9308,-10222,-9474,-6911,-4026,-2429,-2326,-2686,-2602,-2136,-1820,-1734,-1393,-471,698,1519,1869,2187,2815,3498,3697,3289,2719,2460,2521,2586,2451,2153,1727,1122,403,-154,-357,-374,-536,-886,-1143,-1154,-1194,-1628,-2359,-2840,-2674,-2048,-1497,-1334,-1425,-1460,-1267,-870,-369,115,464,649,789,999,1178,1052,508,-163,-470,-205,342,688,655,507,608,1012,1412,1458,1059,404,-238,-681,-843,-718,-414,-166,-236,-720,-1461,-2148,-2517,-2487,-2151,-1695,-1309,-1109,-1083,-1119,-1099,-985,-810,-597,-319,56,482,845,1043,1058,950,796,637,485,353,273,275,349,432,446,346,153,-71,-260,-384,-451,-497,-548,-598,-604,-538,-419,-307,-243,-223,-225,-257,-336,-444,-522,-525,-464,-385,-314,-237,-144,-44,54,156,265,349,371,328,259,203,159,109,55,28,43,84,120,133,113,53,-51,-186,-319,-419,-476,-495,-484,-451,-404,-355,-315,-296,-303,-330,-355,-355,-324,-275,-221,-163,-96,-25,34,66,74,71,72,80,87,79,50,6,-37,-63,-76,-88,-108,-130,-144,-143,-133,-120,-109,-102,-102,-107,-112,-111,-105,-98,-93,-90,-87,-82,-76,-70,-64,-55,-42,-26,-8,4,10,13,20,36,51,53,38,14}
        },
        {    // H40e039a.wav
            {4,0,-2,-1,1,-2,-4,-2,2,2,0,1,4,3,0,-2,1,2,0,-1,3,5,1,-4,1,8,5,-6,-6,8,11,-6,-19,-1,23,10,-26,-20,28,33,-21,49,484,1260,2016,2381,2291,1848,933,-774,-3217,-5526,-6480,-5515,-3198,-594,1720,3884,6095,7990,8837,8246,6528,4413,2561,1342,854,935,1177,1142,681,12,-574,-1045,-1591,-2286,-2896,-3097,-2839,-2421,-2203,-2268,-2399,-2343,-2069,-1756,-1575,-1508,-1390,-1097,-668,-244,75,309,532,785,1045,1272,1441,1553,1628,1704,1811,1923,1951,1797,1433,934,427,34,-180,-227,-203,-236,-400,-657,-898,-1047,-1119,-1182,-1265,-1324,-1288,-1126,-877,-633,-483,-458,-502,-513,-427,-274,-156,-138,-178,-151,47,402,771,978,932,690,415,254,247,321,372,332,191,-25,-269,-488,-637,-714,-757,-802,-847,-863,-835,-782,-735,-704,-678,-652,-628,-600,-551,-473,-386,-331,-323,-338,-338,-304,-247,-184,-128,-89,-85,-120,-170,-196,-181,-145,-128,-147,-182,-201,-189,-161,-142,-147,-175,-210,-238,-248,-243,-229,-213,-194,-174,-157,-147,-144,-143,-143,-143,-141,-129,-100,-60,-24,-8,-11,-22,-31,-31,-25,-13,-3,1,-4,-15,-30,-45,-58,-69,-73,-72,-69,-73,-87,-111,-137,-154,-156,-149,-149,-161,-178,-189,-191,-190,-187,-173,-143,-106,-78,-67,-64,-60,-57,-60,-66,-70,-67,-60,-54,-47,-39,-32,-31,-35,-40,-47,-63,-86,-108,-119,-120,-116,-110,-100,-92,-92,-97,-90,-61,-21},
            {-16,-9,36,36,-42,-90,-13,87,34,-117,-110,93,183,-36,-248,-57,296,171,-324,44,2278,5650,8204,8745,7475,4366,-1927,-11925,-22141,-25879,-18943,-4398,9572,17030,18848,19740,21887,22778,19057,10994,2358,-3302,-5164,-4359,-2183,271,1632,751,-2091,-5208,-7183,-8190,-9249,-10477,-10726,-9088,-6260,-3970,-3180,-3273,-3069,-2259,-1524,-1420,-1582,-1212,-90,1205,2057,2478,2875,3359,3589,3327,2850,2648,2817,2975,2768,2244,1674,1180,713,284,-2,-174,-429,-841,-1183,-1210,-1076,-1246,-1922,-2708,-2990,-2585,-1898,-1455,-1405,-1501,-1450,-1155,-694,-186,279,645,898,1034,1017,808,462,173,131,325,531,537,364,251,417,842,1280,1438,1179,580,-134,-714,-1000,-969,-730,-490,-465,-771,-1337,-1922,-2244,-2164,-1770,-1317,-1053,-1065,-1236,-1346,-1238,-921,-537,-229,-37,96,235,393,543,664,755,809,800,699,521,333,219,218,292,353,330,217,66,-66,-163,-249,-364,-514,-662,-741,-707,-573,-401,-258,-175,-151,-181,-259,-363,-444,-464,-432,-384,-343,-294,-215,-104,23,154,277,364,379,321,232,164,127,99,64,35,34,60,91,110,112,89,29,-74,-202,-322,-406,-449,-459,-448,-421,-379,-332,-302,-307,-342,-379,-389,-364,-320,-270,-212,-143,-73,-14,24,45,58,64,69,76,82,72,35,-20,-70,-98,-110,-117,-123,-121,-104,-79,-56,-46,-52,-71,-96,-117,-129,-129,-119,-103,-87,-79,-84,-97,-106,-104,-90,-70,-46,-20,4,20,28,31,32,36,44,51,48,33,11}
        },
        {    // H40e045a.wav
            {0,2,1,-1,-1,0,0,-2,-4,-2,0,0,-1,0,2,2,-1,-2,0,1,-2,-3,1,3,-1,-5,0,8,5,-5,-7,4,8,-7,-20,-5,17,11,-17,-17,18,22,-21,38,401,1058,1723,2093,2107,1832,1127,-339,-2569,-4826,-5978,-5403,-3473,-1095,1148,3271,5391,7197,8070,7667,6244,4431,2796,1657,1109,1051,1180,1134,754,187,-329,-750,-1226,-1833,-2393,-2632,-2489,-2202,-2069,-2151,-2246,-2137,-1831,-1542,-1457,-1545,-1598,-1431,-1033,-530,-57,333,651,914,1133,1321,1489,1633,1745,1837,1925,1975,1897,1610,1140,626,215,-36,-166,-234,-280,-338,-453,-665,-956,-1245,-1432,-1470,-1380,-1223,-1049,-881,-725,-600,-529,-509,-493,-427,-313,-216,-204,-253,-245,-62,300,704,964,967,749,454,240,182,247,333,349,261,89,-122,-333,-513,-649,-749,-831,-899,-933,-905,-816,-702,-613,-574,-580,-605,-620,-602,-543,-459,-382,-334,-313,-296,-269,-239,-212,-184,-144,-98,-68,-71,-100,-126,-130,-120,-125,-160,-214,-257,-268,-248,-223,-215,-231,-258,-273,-270,-253,-233,-214,-194,-174,-157,-142,-121,-92,-66,-54,-60,-75,-83,-79,-67,-49,-30,-16,-14,-23,-32,-35,-29,-27,-36,-53,-73,-88,-98,-105,-105,-96,-83,-78,-87,-107,-127,-139,-144,-148,-153,-158,-159,-160,-162,-162,-151,-130,-107,-92,-85,-80,-71,-63,-60,-62,-64,-65,-66,-70,-75,-76,-71,-61,-51,-48,-52,-60,-70,-83,-102,-121,-131,-130,-126,-132,-140,-127,-83,-28},
            {1,47,13,-72,-70,40,84,-36,-143,-29,165,112,-161,-212,119,315,-65,-388,671,3505,6819,8889,9073,7352,2780,-5971,-17482,-25988,-24953,-13306,2636,14483,18971,19367,20164,21737,20849,15411,7278,272,-3371,-3968,-2762,-659,1378,1919,56,-3421,-6583,-8270,-9000,-9795,-10576,-10270,-8392,-5932,-4358,-4048,-4075,-3497,-2418,-1611,-1384,-1232,-575,514,1538,2291,3005,3790,4283,4068,3298,2636,2536,2815,2971,2759,2278,1665,947,238,-206,-274,-227,-426,-866,-1193,-1223,-1253,-1689,-2465,-3026,-2928,-2317,-1729,-1523,-1599,-1623,-1389,-925,-364,172,583,791,776,632,521,570,766,953,939,664,274,21,72,403,841,1184,1285,1082,617,25,-524,-920,-1146,-1237,-1235,-1205,-1233,-1367,-1543,-1621,-1524,-1322,-1158,-1115,-1156,-1186,-1142,-1003,-767,-450,-104,189,363,405,353,270,224,265,398,566,680,674,550,370,208,112,86,102,126,133,107,39,-73,-220,-385,-540,-657,-711,-684,-576,-419,-266,-168,-143,-176,-237,-298,-347,-379,-392,-376,-321,-230,-114,12,138,255,341,373,337,250,149,66,13,-14,-23,-15,12,51,90,108,93,40,-43,-145,-248,-334,-388,-406,-400,-383,-359,-328,-299,-294,-319,-358,-379,-365,-325,-280,-237,-194,-145,-90,-35,12,43,56,55,52,47,31,-6,-55,-98,-122,-128,-124,-109,-84,-60,-46,-45,-50,-56,-67,-85,-103,-106,-96,-81,-75,-79,-90,-106,-125,-138,-139,-126,-104,-77,-46,-12,19,41,48,45,37,32,32,36,35,26,12,2}
        },
        {    // H40e051a.wav
            {2,1,1,3,2,0,-2,-1,1,0,-2,-3,-1,1,1,1,2,2,1,-1,-1,-1,-3,-4,-1,2,-1,-6,-3,7,9,0,-7,-2,5,-2,-15,-10,10,15,-7,-21,1,19,-5,1,208,685,1269,1706,1894,1872,1544,568,-1268,-3541,-5244,-5505,-4273,-2223,-49,2041,4112,5992,7178,7259,6315,4841,3365,2205,1483,1190,1170,1152,923,500,58,-304,-673,-1163,-1707,-2078,-2128,-1955,-1807,-1839,-1990,-2090,-2047,-1912,-1780,-1675,-1526,-1257,-865,-418,9,374,675,929,1156,1361,1525,1609,1605,1564,1550,1560,1497,1262,872,463,179,44,-31,-150,-352,-595,-815,-963,-1032,-1056,-1086,-1146,-1203,-1192,-1073,-868,-642,-458,-354,-339,-388,-442,-438,-350,-210,-68,65,215,404,594,708,686,540,348,200,142,162,206,213,151,17,-164,-362,-551,-707,-818,-875,-878,-836,-762,-675,-597,-548,-544,-579,-622,-631,-583,-487,-381,-300,-259,-247,-242,-231,-209,-178,-143,-107,-73,-46,-33,-39,-68,-110,-151,-188,-224,-269,-316,-349,-353,-328,-293,-268,-262,-267,-271,-269,-262,-247,-218,-172,-114,-61,-27,-14,-15,-27,-49,-73,-87,-83,-64,-41,-22,-12,-12,-26,-47,-64,-72,-75,-82,-97,-111,-118,-118,-115,-111,-108,-106,-106,-107,-107,-107,-108,-112,-115,-117,-120,-125,-128,-126,-122,-120,-120,-116,-106,-92,-79,-69,-60,-55,-58,-69,-81,-90,-97,-100,-95,-80,-66,-61,-64,-65,-65,-74,-95,-116,-126,-132,-148,-168,-162,-111,-38},
            {45,-10,-83,-51,62,77,-60,-141,1,178,82,-187,-185,163,301,-129,-394,789,3681,6992,9155,9533,7746,2477,-7367,-19463,-27270,-24503,-11259,5123,16264,19711,19357,19621,20549,19029,13533,6219,487,-2230,-2685,-1867,-128,1854,2506,610,-3202,-6921,-9138,-10067,-10519,-10514,-9456,-7426,-5576,-4923,-5148,-5034,-3974,-2619,-1913,-1876,-1678,-757,571,1697,2528,3382,4257,4650,4231,3411,2944,3073,3326,3177,2620,1994,1465,941,406,28,-140,-328,-732,-1170,-1291,-1127,-1171,-1782,-2679,-3188,-2979,-2368,-1896,-1759,-1744,-1585,-1224,-746,-239,210,475,484,359,367,666,1123,1413,1317,898,424,141,126,312,594,881,1072,1058,797,365,-102,-537,-970,-1411,-1763,-1887,-1758,-1510,-1299,-1176,-1102,-1060,-1078,-1152,-1200,-1140,-978,-789,-617,-436,-207,55,289,441,484,419,281,147,106,190,347,478,511,442,307,164,61,30,60,106,115,67,-22,-122,-219,-316,-420,-520,-591,-605,-550,-440,-306,-187,-115,-111,-172,-270,-353,-387,-365,-306,-228,-137,-34,74,175,261,324,346,308,213,96,1,-51,-69,-70,-61,-34,10,59,89,84,40,-39,-145,-258,-350,-398,-398,-368,-330,-294,-261,-241,-244,-273,-308,-326,-316,-290,-264,-240,-209,-161,-98,-28,30,58,54,32,12,-4,-29,-70,-115,-142,-142,-124,-101,-77,-53,-37,-39,-54,-72,-84,-91,-96,-94,-81,-62,-48,-49,-63,-83,-101,-115,-123,-126,-122,-107,-80,-45,-9,19,40,53,57,51,41,39,41,35,14,-10,-18,-9}
        },
        {    // H40e058a.wav
            {1,2,1,0,0,2,2,1,0,0,0,-2,-2,-1,1,1,-1,0,2,2,-1,-2,-1,-1,-2,-3,0,2,-1,-4,1,11,12,1,-8,-2,6,-1,-14,-9,10,14,-8,-20,1,19,0,11,199,618,1123,1513,1726,1796,1583,711,-1037,-3245,-4938,-5280,-4203,-2312,-237,1810,3835,5626,6710,6744,5860,4544,3269,2277,1627,1300,1197,1133,944,613,251,-65,-383,-785,-1238,-1605,-1795,-1864,-1943,-2079,-2177,-2112,-1865,-1551,-1309,-1181,-1094,-938,-661,-289,107,460,734,920,1036,1109,1155,1179,1193,1211,1231,1211,1103,899,649,409,177,-78,-345,-550,-621,-577,-523,-556,-698,-899,-1090,-1207,-1193,-1026,-759,-507,-372,-368,-422,-450,-417,-339,-244,-154,-80,-13,74,211,380,511,530,428,271,148,101,108,123,109,53,-50,-189,-340,-470,-565,-631,-688,-735,-757,-739,-687,-626,-578,-553,-548,-549,-538,-500,-435,-359,-295,-256,-236,-220,-198,-172,-145,-122,-99,-75,-54,-44,-54,-82,-121,-165,-209,-255,-301,-343,-373,-380,-363,-330,-299,-287,-296,-313,-316,-292,-241,-176,-115,-69,-44,-36,-36,-37,-36,-34,-32,-31,-30,-33,-39,-42,-41,-38,-42,-57,-78,-95,-102,-102,-106,-118,-136,-148,-152,-148,-141,-130,-114,-93,-76,-67,-65,-68,-74,-86,-103,-114,-115,-109,-106,-109,-110,-106,-100,-95,-93,-89,-82,-76,-73,-70,-68,-71,-83,-96,-104,-105,-104,-102,-93,-82,-79,-86,-95,-98,-108,-138,-174,-177,-124,-42},
            {12,-73,-65,45,79,-45,-140,-16,169,99,-171,-201,134,310,-89,-433,558,3303,6700,9209,10012,8488,3180,-7001,-19613,-27890,-25247,-11609,5491,17144,20433,19287,18639,19081,17672,12703,6083,1030,-1215,-1599,-1100,268,2232,3251,1697,-2233,-6527,-9372,-10600,-10992,-10784,-9561,-7433,-5527,-4883,-5220,-5300,-4449,-3255,-2619,-2550,-2257,-1265,71,1222,2232,3426,4618,5087,4498,3482,3018,3363,3865,3813,3155,2300,1522,829,277,40,75,-3,-493,-1173,-1545,-1488,-1432,-1812,-2500,-2973,-2936,-2598,-2324,-2189,-1993,-1591,-1060,-568,-210,-11,30,-6,88,500,1153,1674,1698,1210,581,233,291,549,739,779,762,759,726,578,305,-55,-511,-1103,-1755,-2231,-2300,-1967,-1476,-1092,-911,-878,-921,-1004,-1073,-1058,-933,-754,-584,-424,-234,-21,160,276,356,423,446,379,247,138,115,153,189,188,167,144,125,115,119,126,102,30,-67,-143,-179,-196,-232,-299,-383,-459,-503,-495,-420,-293,-158,-71,-69,-146,-257,-349,-385,-359,-288,-190,-83,21,113,196,274,330,335,266,144,17,-67,-103,-113,-116,-109,-80,-32,20,57,66,38,-33,-143,-265,-361,-406,-400,-363,-312,-252,-194,-158,-163,-204,-247,-267,-264,-257,-253,-243,-214,-164,-99,-30,32,63,52,10,-34,-63,-86,-117,-151,-169,-158,-129,-98,-71,-50,-42,-53,-77,-99,-108,-108,-102,-91,-77,-64,-60,-64,-69,-72,-75,-80,-82,-80,-79,-79,-72,-50,-19,8,25,36,48,54,51,43,38,30,5,-31,-55,-47,-17}
        },
        {    // H40e064a.wav
            {1,0,1,2,1,0,0,2,2,1,-1,0,1,-1,-3,-3,-1,0,0,1,3,3,1,-1,-1,-1,-2,-3,0,2,0,-2,2,11,12,0,-8,-3,7,1,-12,-10,10,16,-4,-20,-1,25,13,3,129,465,909,1281,1525,1691,1671,1080,-408,-2540,-4427,-5142,-4422,-2740,-746,1250,3211,4975,6122,6300,5585,4435,3320,2461,1867,1501,1318,1225,1099,879,596,289,-83,-580,-1149,-1607,-1792,-1719,-1567,-1497,-1516,-1508,-1383,-1175,-987,-882,-831,-769,-653,-476,-241,35,306,510,618,666,712,778,841,881,901,888,789,563,261,17,-71,-33,4,-54,-187,-312,-392,-467,-589,-749,-882,-928,-877,-766,-638,-512,-396,-305,-264,-283,-337,-375,-355,-269,-138,6,139,236,272,242,172,110,82,80,74,38,-30,-115,-195,-248,-265,-262,-277,-343,-459,-589,-686,-723,-703,-646,-573,-498,-440,-409,-405,-408,-395,-354,-299,-254,-230,-217,-190,-145,-100,-80,-93,-121,-141,-139,-124,-114,-125,-164,-222,-282,-323,-338,-332,-326,-335,-360,-384,-390,-372,-335,-287,-234,-183,-142,-117,-105,-94,-74,-47,-22,-6,4,11,14,9,-3,-20,-37,-52,-64,-74,-83,-93,-102,-109,-114,-125,-144,-168,-184,-183,-166,-141,-111,-83,-62,-52,-51,-51,-50,-51,-61,-75,-86,-88,-84,-82,-83,-89,-98,-109,-114,-110,-99,-85,-70,-55,-45,-49,-68,-89,-104,-115,-127,-134,-127,-111,-101,-104,-106,-97,-89,-105,-139,-150,-110,-39},
            {-58,-49,41,73,-37,-134,-32,151,111,-146,-215,88,311,-23,-450,264,2753,6200,9114,10441,9291,4107,-6203,-19235,-28168,-26082,-12429,5349,17775,21149,19180,17405,17274,16184,12072,6268,1671,-476,-988,-669,682,2926,4381,3048,-1129,-5986,-9290,-10608,-10841,-10550,-9511,-7757,-6191,-5654,-5781,-5423,-4171,-2916,-2667,-3206,-3351,-2398,-804,641,1822,3096,4370,4945,4456,3538,3213,3737,4385,4364,3635,2706,1933,1301,767,428,270,13,-553,-1204,-1514,-1429,-1395,-1812,-2528,-3028,-3045,-2795,-2604,-2493,-2232,-1711,-1108,-680,-509,-477,-418,-212,198,787,1383,1708,1571,1061,526,311,483,808,994,946,783,641,531,375,129,-209,-664,-1264,-1909,-2337,-2323,-1918,-1419,-1089,-949,-870,-790,-760,-808,-849,-777,-595,-388,-216,-73,51,135,180,239,349,454,457,334,172,64,19,-22,-86,-134,-117,-32,83,176,207,149,12,-145,-250,-265,-223,-185,-196,-255,-333,-394,-403,-341,-224,-97,-19,-24,-104,-216,-310,-353,-343,-294,-220,-122,-2,126,236,308,332,304,222,97,-36,-138,-191,-206,-205,-190,-148,-74,8,62,65,17,-70,-181,-296,-381,-411,-385,-329,-268,-206,-144,-99,-94,-133,-187,-219,-223,-216,-213,-210,-190,-150,-97,-40,7,28,14,-26,-66,-95,-118,-148,-176,-185,-171,-147,-127,-112,-96,-83,-81,-92,-106,-117,-124,-130,-129,-117,-100,-87,-81,-76,-68,-60,-54,-44,-30,-20,-22,-31,-33,-22,-6,6,14,24,33,33,23,12,1,-17,-47,-77,-83,-57,-19}
        },
        {    // H40e071a.wav
            {0,0,0,0,1,2,1,0,1,2,1,0,-1,0,1,-1,-2,-1,0,-1,-1,0,3,2,0,-2,-1,-1,-2,-2,0,1,-1,-1,6,13,9,-4,-8,1,8,-1,-12,-6,11,11,-9,-13,12,25,1,12,184,539,945,1261,1491,1670,1592,825,-853,-2999,-4641,-4973,-3939,-2122,-133,1783,3584,5071,5867,5758,4941,3878,2951,2289,1860,1608,1469,1329,1073,690,284,-36,-267,-485,-730,-949,-1068,-1087,-1082,-1118,-1174,-1181,-1107,-1001,-941,-956,-1006,-1026,-961,-790,-518,-194,97,282,357,392,458,553,612,578,462,335,274,309,406,484,461,312,88,-105,-191,-176,-144,-194,-373,-637,-870,-947,-822,-572,-347,-262,-322,-436,-511,-508,-448,-364,-278,-190,-94,11,106,151,119,28,-59,-86,-58,-26,-36,-87,-145,-183,-198,-198,-192,-195,-234,-328,-461,-584,-646,-633,-568,-488,-422,-380,-361,-359,-359,-347,-319,-286,-259,-237,-210,-170,-129,-108,-120,-152,-183,-196,-191,-180,-173,-174,-188,-219,-259,-296,-315,-319,-326,-351,-385,-405,-392,-349,-300,-259,-229,-202,-176,-151,-127,-98,-60,-23,2,11,13,16,19,14,-1,-19,-37,-55,-75,-98,-116,-125,-129,-134,-144,-155,-163,-166,-165,-162,-153,-133,-104,-79,-65,-62,-59,-51,-42,-42,-52,-61,-64,-64,-67,-74,-84,-96,-106,-110,-105,-94,-82,-74,-69,-67,-68,-73,-80,-89,-104,-124,-143,-150,-146,-141,-140,-135,-119,-100,-95,-104,-103,-74,-26},
            {-75,9,87,19,-118,-98,92,165,-41,-234,-61,270,174,-340,-261,1457,4663,8079,10370,10460,6856,-1946,-14858,-26205,-28302,-17893,-109,15114,21270,19837,16814,15821,15507,13017,8183,3435,630,-496,-763,74,2401,4896,4964,1407,-4056,-8435,-10281,-10359,-9931,-9275,-8155,-6939,-6396,-6503,-6242,-4918,-3224,-2467,-2934,-3540,-3173,-1887,-466,771,2156,3720,4712,4455,3396,2805,3371,4478,4985,4456,3378,2390,1700,1243,1007,933,715,36,-960,-1696,-1791,-1505,-1438,-1862,-2518,-3014,-3219,-3204,-2982,-2489,-1800,-1188,-903,-923,-993,-858,-441,166,801,1296,1514,1397,1023,613,416,543,868,1120,1111,881,623,461,346,149,-195,-667,-1220,-1766,-2143,-2180,-1868,-1422,-1105,-994,-964,-878,-744,-646,-603,-551,-447,-318,-201,-93,22,123,185,227,288,355,365,289,176,94,38,-47,-179,-295,-318,-228,-71,91,203,217,115,-61,-216,-278,-250,-196,-175,-201,-254,-304,-319,-275,-172,-50,30,30,-43,-147,-236,-289,-301,-280,-232,-158,-62,48,158,248,303,307,249,132,-16,-150,-233,-261,-258,-241,-203,-134,-46,25,51,27,-39,-142,-270,-383,-431,-395,-305,-214,-147,-101,-73,-73,-106,-149,-170,-162,-151,-158,-175,-175,-146,-98,-47,-5,15,0,-44,-92,-119,-125,-130,-144,-162,-168,-164,-159,-155,-146,-129,-112,-104,-105,-113,-127,-143,-151,-145,-127,-109,-97,-86,-70,-51,-32,-14,4,17,18,6,-6,-4,9,21,24,21,19,15,5,-8,-21,-32,-46,-64,-75,-69,-45,-15}
        },
        {    // H40e077a.wav
            {0,1,2,2,0,0,1,2,2,1,1,2,2,1,1,1,0,-2,-1,0,1,0,0,2,3,1,-1,0,2,0,-3,-3,1,4,3,3,7,10,4,-5,-4,5,7,-4,-11,2,18,14,-2,1,18,9,-24,16,234,605,986,1278,1508,1661,1457,480,-1345,-3419,-4755,-4691,-3346,-1381,587,2321,3788,4867,5336,5112,4386,3501,2712,2109,1687,1425,1282,1187,1075,932,775,598,372,95,-183,-401,-561,-716,-897,-1071,-1181,-1222,-1248,-1304,-1377,-1414,-1388,-1307,-1178,-982,-710,-412,-167,-17,61,103,113,88,80,179,417,700,875,866,723,548,402,300,253,263,281,207,-16,-324,-571,-660,-618,-553,-544,-594,-659,-697,-684,-614,-506,-402,-348,-342,-332,-262,-128,10,76,32,-95,-225,-283,-235,-117,-4,32,-23,-126,-210,-238,-215,-180,-166,-192,-255,-339,-416,-465,-476,-457,-424,-388,-352,-320,-296,-284,-277,-265,-247,-231,-221,-212,-196,-179,-178,-198,-226,-244,-242,-228,-214,-205,-201,-206,-226,-263,-303,-334,-345,-340,-326,-313,-308,-310,-314,-307,-284,-245,-197,-149,-105,-66,-33,-7,9,17,18,13,3,-10,-23,-34,-45,-59,-81,-108,-134,-154,-162,-160,-150,-138,-130,-128,-132,-138,-138,-129,-114,-96,-79,-65,-54,-49,-48,-46,-41,-38,-40,-49,-59,-68,-73,-77,-82,-87,-89,-88,-86,-84,-83,-81,-78,-77,-82,-96,-115,-135,-150,-158,-160,-156,-144,-127,-109,-96,-86,-68,-41,-13},
            {-55,48,77,-40,-129,-20,151,96,-148,-194,100,291,-44,-449,226,2624,6128,9383,11033,9570,3222,-8340,-21416,-28599,-23854,-8387,9204,19733,20743,17002,14355,14104,13544,10558,6143,2558,593,-367,-417,1181,4106,5970,4260,-864,-6473,-9697,-10124,-9272,-8440,-7774,-7141,-6864,-7124,-7215,-6197,-4255,-2770,-2756,-3628,-3910,-2931,-1322,101,1320,2672,3871,4139,3351,2495,2668,3819,4856,4889,4047,3040,2313,1858,1592,1492,1366,852,-135,-1138,-1583,-1437,-1240,-1480,-2111,-2737,-3110,-3260,-3239,-2958,-2374,-1693,-1243,-1156,-1240,-1183,-822,-228,413,928,1213,1225,992,644,400,449,782,1157,1277,1059,695,432,321,204,-72,-510,-1010,-1481,-1833,-1946,-1751,-1363,-1035,-935,-988,-994,-858,-658,-500,-396,-300,-210,-157,-129,-64,58,187,264,288,286,255,178,78,14,2,-22,-127,-296,-430,-440,-313,-104,106,235,225,81,-114,-250,-274,-221,-162,-145,-171,-215,-243,-224,-144,-27,69,92,33,-71,-170,-227,-238,-219,-192,-163,-121,-48,55,164,242,264,224,128,-5,-138,-230,-266,-266,-258,-247,-211,-134,-41,24,30,-23,-120,-239,-348,-404,-382,-301,-207,-135,-86,-50,-36,-55,-100,-136,-140,-123,-113,-119,-126,-118,-95,-62,-28,-5,-10,-47,-96,-127,-131,-126,-131,-143,-152,-157,-166,-178,-181,-168,-148,-140,-145,-152,-152,-151,-152,-153,-144,-127,-110,-94,-78,-57,-33,-8,15,33,38,30,16,9,17,32,45,50,42,24,0,-23,-39,-48,-54,-60,-65,-64,-53,-33,-12}
        },
        {    // H40e084a.wav
            {0,-1,0,1,0,-1,-1,1,1,0,-1,1,3,1,-1,-2,-1,-1,-2,-2,-2,-1,-1,-1,0,1,0,-1,-2,-1,-1,-4,-4,-1,1,0,-1,4,8,5,-3,-5,1,2,-6,-10,4,21,20,4,-1,6,-7,-42,-15,177,527,909,1222,1478,1661,1519,646,-1084,-3152,-4594,-4670,-3387,-1389,606,2238,3469,4311,4697,4586,4073,3354,2617,2010,1655,1608,1778,1944,1900,1616,1218,846,540,272,27,-186,-386,-637,-962,-1285,-1482,-1512,-1466,-1472,-1561,-1648,-1644,-1543,-1397,-1221,-979,-664,-369,-225,-265,-360,-319,-50,367,753,967,987,885,763,691,683,700,681,581,408,222,87,14,-56,-192,-417,-679,-893,-1001,-993,-894,-751,-617,-531,-502,-496,-469,-407,-328,-254,-185,-118,-74,-84,-145,-205,-205,-137,-48,-2,-24,-95,-176,-232,-241,-200,-133,-83,-80,-128,-208,-300,-387,-452,-476,-454,-397,-333,-282,-253,-246,-255,-270,-277,-269,-251,-235,-229,-237,-251,-265,-273,-270,-255,-230,-209,-201,-211,-233,-260,-284,-301,-308,-301,-286,-276,-280,-298,-316,-322,-310,-285,-249,-202,-147,-92,-48,-20,-5,0,-5,-18,-33,-43,-46,-49,-60,-77,-94,-108,-119,-129,-138,-143,-144,-141,-136,-132,-128,-125,-122,-119,-116,-114,-108,-98,-84,-69,-58,-52,-48,-46,-47,-48,-50,-52,-56,-65,-77,-90,-100,-103,-100,-93,-88,-87,-91,-97,-103,-110,-119,-129,-137,-145,-153,-156,-150,-134,-114,-99,-87,-70,-43,-14},
            {-38,56,56,-62,-111,21,150,42,-176,-141,160,248,-150,-421,531,3154,6739,9927,11171,8632,705,-11823,-23880,-27941,-19769,-2977,12985,20389,19050,14759,12648,12875,12445,9683,5788,2661,784,-192,67,2159,5094,6126,3252,-2449,-7645,-9880,-9427,-8142,-7271,-6851,-6693,-6936,-7432,-7337,-5996,-4027,-2889,-3231,-4115,-4129,-2922,-1247,254,1666,3104,4003,3698,2543,1862,2547,4045,4999,4697,3611,2617,2103,1950,1964,1982,1708,868,-343,-1242,-1326,-861,-629,-1112,-2080,-2965,-3426,-3462,-3167,-2618,-1987,-1566,-1516,-1670,-1665,-1291,-649,1,479,750,841,767,570,380,370,613,980,1208,1131,826,530,394,340,184,-164,-639,-1120,-1507,-1702,-1625,-1313,-972,-832,-922,-1046,-1001,-783,-535,-364,-264,-197,-169,-175,-156,-51,112,238,276,259,229,175,72,-41,-96,-92,-114,-226,-387,-490,-463,-317,-111,89,216,211,68,-133,-272,-284,-205,-121,-92,-121,-166,-184,-148,-60,42,107,96,15,-90,-170,-200,-190,-168,-155,-147,-116,-44,62,165,224,216,140,14,-125,-230,-272,-261,-241,-239,-242,-209,-128,-34,20,4,-72,-181,-295,-376,-389,-327,-230,-151,-109,-83,-53,-29,-34,-69,-105,-118,-115,-113,-114,-105,-82,-55,-36,-27,-31,-51,-86,-116,-124,-114,-112,-130,-157,-173,-175,-173,-175,-174,-167,-164,-172,-188,-195,-190,-179,-168,-157,-142,-123,-102,-83,-65,-48,-31,-13,5,20,25,22,17,20,29,39,46,49,45,32,10,-17,-41,-59,-69,-72,-68,-58,-44,-26,-9}
        },
        {    // H40e090a.wav
            {1,1,0,1,2,0,-1,0,2,2,1,0,1,2,0,-1,0,1,1,0,1,2,2,0,0,2,3,1,-1,0,1,0,-1,0,2,1,-1,0,6,9,4,-3,-1,4,1,-7,0,23,35,19,-5,-6,3,-20,-55,3,243,619,995,1302,1569,1719,1418,276,-1663,-3680,-4771,-4367,-2719,-613,1253,2612,3509,4015,4135,3912,3491,3043,2670,2406,2274,2277,2341,2319,2101,1703,1238,798,405,63,-203,-377,-528,-769,-1137,-1522,-1752,-1763,-1652,-1573,-1605,-1714,-1815,-1821,-1661,-1316,-881,-552,-474,-581,-623,-388,102,618,944,1037,993,924,893,916,974,993,880,625,355,233,297,399,333,17,-459,-916,-1210,-1287,-1171,-946,-726,-605,-596,-630,-625,-557,-465,-394,-350,-308,-248,-172,-94,-24,25,38,9,-45,-96,-129,-152,-177,-195,-186,-142,-86,-46,-37,-55,-101,-184,-297,-404,-464,-461,-412,-350,-294,-255,-241,-253,-279,-291,-274,-245,-235,-255,-289,-312,-312,-295,-273,-247,-219,-194,-184,-195,-222,-251,-270,-274,-269,-263,-260,-260,-261,-262,-266,-272,-276,-273,-259,-231,-188,-135,-84,-48,-33,-34,-41,-49,-54,-58,-65,-75,-88,-98,-101,-93,-80,-71,-75,-94,-120,-142,-150,-143,-125,-106,-92,-86,-87,-96,-104,-107,-98,-82,-65,-54,-52,-54,-56,-53,-49,-47,-50,-58,-68,-79,-90,-100,-104,-100,-92,-87,-91,-98,-103,-103,-104,-108,-114,-120,-127,-132,-129,-115,-96,-80,-72,-62,-41,-14},
            {-31,52,48,-56,-96,24,133,32,-159,-121,150,221,-145,-391,501,3018,6598,9902,11164,8330,-26,-12544,-23768,-26536,-17558,-1143,13461,19402,17246,12887,11125,11846,11995,9822,6318,3235,1200,177,611,2864,5640,6172,2766,-3147,-8115,-9822,-8791,-7118,-6202,-6081,-6368,-6911,-7412,-7153,-5758,-3991,-3189,-3753,-4620,-4468,-3107,-1363,150,1556,2957,3785,3420,2280,1681,2439,3935,4821,4456,3364,2418,1985,1926,2023,2080,1786,911,-260,-1007,-891,-300,-85,-685,-1780,-2750,-3262,-3337,-3065,-2512,-1884,-1525,-1606,-1891,-1933,-1501,-767,-88,312,436,387,259,140,138,335,687,1008,1093,902,600,408,393,409,269,-84,-553,-1005,-1336,-1459,-1320,-989,-694,-643,-823,-1000,-961,-718,-440,-254,-166,-138,-162,-218,-227,-116,81,243,289,244,174,98,3,-95,-154,-174,-215,-319,-447,-507,-450,-300,-117,46,144,140,33,-114,-213,-218,-156,-94,-74,-90,-111,-109,-67,8,84,122,96,18,-76,-147,-180,-182,-167,-149,-127,-89,-25,59,135,174,156,80,-38,-166,-267,-308,-291,-249,-216,-197,-167,-108,-40,-2,-21,-91,-188,-285,-352,-363,-313,-228,-149,-98,-65,-37,-20,-27,-52,-77,-88,-93,-102,-108,-97,-69,-39,-21,-18,-28,-56,-95,-123,-123,-104,-98,-120,-158,-183,-185,-176,-166,-159,-156,-162,-181,-202,-213,-210,-199,-187,-169,-143,-112,-85,-64,-50,-40,-34,-26,-12,2,10,9,8,18,38,57,65,63,56,45,28,7,-14,-32,-46,-56,-61,-59,-48,-30,-10}
        },
        {    // H40e096a.wav
            {0,-1,-1,-1,0,0,0,0,0,0,0,0,1,2,1,-1,-2,-1,0,-1,-2,-2,-2,-3,-3,-1,1,0,-1,-2,-2,-3,-4,-2,2,1,-2,-4,0,4,0,-6,-4,4,5,-4,-5,13,32,25,-3,-17,-9,-13,-43,-25,144,480,880,1246,1564,1793,1671,791,-985,-3157,-4736,-4906,-3594,-1453,685,2322,3382,3971,4183,4095,3822,3486,3145,2818,2552,2419,2413,2390,2174,1720,1163,680,333,58,-222,-508,-763,-986,-1219,-1474,-1692,-1796,-1783,-1743,-1768,-1856,-1907,-1822,-1602,-1344,-1146,-1012,-845,-550,-141,259,522,627,671,773,971,1200,1352,1349,1182,908,636,474,465,543,570,433,108,-334,-782,-1128,-1295,-1264,-1094,-899,-774,-734,-729,-707,-663,-621,-591,-555,-490,-390,-261,-112,40,162,218,194,109,5,-82,-134,-149,-141,-128,-123,-125,-121,-102,-75,-61,-87,-161,-269,-377,-448,-463,-430,-375,-325,-292,-276,-270,-268,-264,-259,-258,-269,-295,-327,-346,-341,-311,-269,-231,-204,-190,-183,-181,-187,-203,-232,-269,-298,-305,-282,-240,-201,-185,-196,-219,-239,-250,-248,-234,-208,-177,-152,-137,-125,-110,-93,-85,-93,-112,-128,-131,-115,-88,-59,-40,-37,-49,-71,-96,-118,-132,-133,-122,-106,-92,-83,-79,-79,-81,-83,-82,-81,-81,-83,-86,-85,-80,-76,-75,-74,-71,-69,-71,-77,-85,-94,-104,-113,-115,-110,-102,-95,-90,-87,-89,-95,-102,-103,-99,-96,-97,-93,-80,-68,-69,-82,-85,-61,-21},
            {-41,36,53,-34,-93,-8,112,63,-115,-141,80,216,-45,-366,178,2276,5687,9223,11054,9012,1553,-10297,-21625,-25563,-18353,-3269,11145,17760,16250,12013,10183,11238,12168,10681,7324,3977,1681,550,863,2909,5613,6399,3384,-2410,-7655,-9709,-8722,-6796,-5658,-5567,-6033,-6696,-7229,-7027,-5744,-4051,-3246,-3841,-4876,-4932,-3630,-1764,-126,1249,2533,3347,3125,2144,1592,2320,3820,4759,4418,3297,2346,1982,1988,2035,1948,1567,773,-197,-748,-514,123,330,-326,-1484,-2453,-2885,-2890,-2677,-2328,-1932,-1696,-1757,-1951,-1930,-1516,-882,-346,-79,-33,-78,-121,-103,35,311,642,866,864,672,455,371,425,472,359,57,-347,-744,-1057,-1214,-1153,-904,-642,-563,-695,-859,-858,-666,-414,-230,-142,-127,-170,-243,-264,-158,39,202,242,188,120,66,-3,-93,-165,-201,-243,-336,-451,-503,-445,-308,-159,-36,47,74,26,-72,-155,-169,-123,-74,-62,-79,-92,-76,-34,25,84,120,110,47,-45,-129,-179,-193,-185,-165,-134,-86,-23,43,97,125,114,59,-35,-147,-242,-291,-289,-259,-227,-198,-160,-102,-42,-10,-24,-80,-161,-248,-317,-345,-318,-254,-185,-130,-83,-38,-9,-14,-50,-84,-93,-87,-85,-93,-92,-72,-41,-17,-11,-20,-45,-81,-113,-124,-115,-106,-117,-143,-166,-174,-173,-169,-164,-157,-157,-171,-193,-208,-207,-198,-188,-180,-163,-136,-105,-76,-55,-41,-33,-29,-25,-19,-12,-7,-2,10,32,59,78,83,75,58,38,16,-3,-19,-29,-36,-40,-42,-38,-26,-10}
        },
        {    // H40e103a.wav
            {0,0,0,1,2,1,0,1,2,1,1,1,1,2,1,0,1,1,0,-1,0,1,0,-1,-1,2,3,1,-1,0,0,-2,-3,-2,3,4,1,0,3,3,-4,-10,-5,5,8,3,5,19,27,12,-8,-9,-1,-20,-49,3,225,594,1007,1402,1772,1989,1677,432,-1701,-3983,-5338,-5078,-3353,-958,1272,2904,3920,4462,4654,4573,4271,3792,3192,2597,2184,2063,2145,2173,1926,1403,801,324,25,-177,-381,-621,-895,-1196,-1497,-1723,-1801,-1745,-1678,-1714,-1835,-1898,-1799,-1596,-1439,-1385,-1312,-1044,-550,9,416,583,592,594,691,898,1158,1378,1453,1330,1061,790,652,657,687,592,316,-78,-480,-803,-1012,-1100,-1086,-1020,-960,-931,-906,-848,-763,-701,-697,-720,-703,-611,-461,-297,-137,15,146,228,246,213,158,98,43,0,-22,-30,-45,-86,-141,-185,-200,-188,-166,-153,-170,-230,-329,-437,-508,-512,-455,-368,-290,-242,-229,-241,-262,-280,-293,-305,-321,-333,-332,-308,-268,-227,-198,-185,-179,-169,-160,-165,-195,-243,-284,-296,-273,-231,-190,-161,-151,-157,-179,-205,-226,-234,-231,-223,-214,-201,-183,-165,-156,-160,-173,-181,-174,-146,-101,-52,-16,-6,-24,-57,-87,-104,-106,-102,-93,-82,-71,-66,-70,-75,-76,-72,-67,-64,-61,-59,-63,-75,-92,-103,-104,-99,-93,-91,-91,-92,-93,-97,-103,-108,-110,-108,-103,-98,-92,-87,-81,-75,-75,-80,-84,-80,-72,-67,-66,-64,-59,-57,-68,-84,-84,-59,-20},
            {-45,9,48,1,-74,-47,65,92,-40,-143,-23,174,93,-251,-177,1182,4076,7730,10460,10053,4627,-5701,-17299,-23872,-20531,-8205,6171,14855,15395,11736,9490,10561,12467,12084,8997,5139,2295,924,982,2571,5097,6534,4701,-396,-6060,-9191,-8960,-7039,-5536,-5225,-5685,-6364,-6933,-6945,-5982,-4369,-3263,-3528,-4662,-5230,-4380,-2571,-765,673,1915,2844,2939,2158,1432,1824,3273,4574,4667,3680,2571,2025,1973,2006,1863,1449,723,-146,-676,-474,224,629,166,-944,-1977,-2458,-2476,-2330,-2139,-1884,-1667,-1670,-1870,-1967,-1690,-1112,-578,-361,-432,-567,-578,-416,-121,237,558,727,677,472,284,262,399,534,500,265,-76,-419,-722,-950,-1029,-909,-680,-537,-588,-732,-770,-622,-391,-224,-164,-169,-203,-252,-269,-187,-8,157,200,128,42,3,-19,-73,-141,-183,-210,-277,-393,-485,-473,-358,-214,-102,-30,14,16,-34,-106,-144,-123,-73,-45,-53,-74,-79,-54,-5,57,107,117,72,-13,-101,-162,-188,-191,-181,-159,-124,-73,-10,53,97,103,62,-19,-114,-194,-238,-244,-231,-220,-214,-193,-139,-66,-10,-3,-47,-122,-205,-281,-326,-323,-275,-212,-161,-124,-84,-43,-26,-47,-87,-110,-106,-92,-88,-87,-71,-39,-11,-3,-16,-43,-75,-104,-119,-118,-110,-113,-130,-151,-164,-166,-165,-162,-157,-154,-160,-174,-187,-189,-186,-185,-187,-182,-164,-136,-105,-77,-55,-43,-40,-41,-39,-34,-27,-15,4,30,59,80,88,84,68,46,20,-2,-15,-18,-15,-12,-12,-13,-10,-5}
        },
        {    // H40e109a.wav
            {0,0,1,2,1,0,1,2,1,0,0,1,2,1,0,0,0,-1,-2,-1,1,2,0,0,0,1,1,1,1,1,0,-1,1,3,1,-1,0,5,6,-2,-10,-8,0,2,-3,2,20,30,16,-7,-11,2,-6,-35,-8,174,536,1021,1553,2037,2254,1804,347,-1980,-4373,-5734,-5374,-3467,-871,1495,3161,4155,4708,4970,4950,4614,3999,3249,2572,2149,2017,2023,1924,1566,1012,467,94,-120,-303,-550,-848,-1133,-1373,-1571,-1717,-1785,-1780,-1759,-1758,-1734,-1624,-1459,-1377,-1458,-1573,-1451,-944,-205,420,686,634,514,548,789,1128,1404,1493,1363,1097,860,788,876,973,895,569,71,-446,-849,-1070,-1105,-1010,-884,-826,-870,-959,-1006,-968,-886,-824,-805,-791,-733,-613,-449,-269,-100,28,98,118,128,162,223,277,290,257,197,127,59,-4,-59,-115,-185,-263,-321,-334,-306,-278,-290,-352,-439,-516,-551,-528,-448,-340,-252,-219,-240,-284,-319,-334,-335,-326,-301,-260,-215,-182,-164,-152,-141,-141,-164,-205,-242,-251,-232,-204,-184,-173,-161,-148,-143,-152,-172,-191,-204,-219,-239,-254,-253,-238,-224,-224,-239,-257,-262,-245,-201,-136,-68,-22,-11,-31,-63,-89,-103,-104,-94,-74,-53,-40,-40,-47,-56,-61,-62,-60,-55,-49,-47,-50,-58,-68,-77,-88,-102,-115,-122,-120,-117,-119,-124,-129,-128,-125,-124,-122,-113,-93,-73,-63,-66,-72,-71,-65,-61,-59,-55,-50,-50,-59,-67,-65,-55,-50,-54,-56,-41,-15},
            {-31,-28,14,29,-20,-63,-14,71,52,-71,-111,33,157,-3,-269,91,1830,4980,8492,10379,8380,1276,-9438,-19045,-21815,-15239,-2708,8566,13206,11743,9127,9394,12088,13720,11945,7681,3536,1211,826,1942,4079,6092,6067,2804,-2588,-7220,-8875,-7795,-5972,-5055,-5248,-5923,-6551,-6815,-6354,-5068,-3628,-3113,-3861,-4930,-5012,-3758,-1922,-314,938,1977,2568,2337,1586,1315,2170,3629,4516,4246,3297,2487,2121,1962,1739,1384,874,194,-438,-600,-145,464,521,-184,-1162,-1808,-1996,-2005,-2017,-1928,-1650,-1375,-1371,-1611,-1761,-1564,-1124,-772,-709,-844,-934,-815,-489,-69,306,525,535,378,190,123,243,462,605,553,322,7,-318,-625,-859,-924,-787,-571,-473,-558,-685,-671,-488,-280,-184,-201,-246,-259,-233,-168,-61,54,109,71,-8,-54,-58,-63,-96,-132,-151,-182,-265,-378,-444,-411,-303,-182,-85,-18,10,-14,-77,-134,-144,-114,-82,-69,-70,-73,-73,-64,-30,33,94,103,42,-57,-140,-180,-186,-181,-173,-158,-131,-90,-35,26,72,81,41,-36,-119,-178,-198,-188,-176,-180,-190,-179,-130,-64,-21,-25,-72,-140,-211,-273,-304,-293,-250,-203,-172,-148,-117,-86,-79,-100,-124,-127,-111,-96,-91,-82,-57,-23,-1,-2,-23,-54,-87,-107,-110,-103,-105,-125,-152,-166,-163,-154,-147,-143,-139,-139,-147,-158,-164,-167,-174,-188,-197,-190,-168,-142,-119,-98,-80,-70,-68,-66,-57,-41,-23,-4,21,50,76,87,83,65,40,15,-2,-4,8,21,23,15,4,-2,-2}
        },
        {    // H40e116a.wav
            {0,0,0,0,0,2,2,1,0,1,3,3,2,1,1,1,-1,-1,-1,0,0,0,1,2,2,1,0,0,1,-1,-1,1,4,3,-1,-1,2,3,-1,-6,-6,-3,-3,-4,1,13,18,10,1,4,6,-12,-33,18,228,641,1230,1887,2388,2363,1421,-541,-3060,-5174,-5921,-4933,-2654,6,2254,3778,4675,5135,5227,4934,4296,3486,2752,2291,2149,2204,2223,1993,1463,778,167,-237,-469,-657,-885,-1145,-1401,-1638,-1838,-1946,-1910,-1768,-1636,-1592,-1590,-1530,-1402,-1315,-1336,-1357,-1159,-643,25,543,735,685,631,746,1020,1310,1470,1436,1252,1033,899,895,952,935,735,354,-115,-554,-886,-1077,-1126,-1060,-946,-866,-858,-898,-935,-950,-963,-983,-974,-884,-705,-490,-309,-188,-109,-48,3,41,80,136,211,290,350,375,353,282,180,82,20,-12,-54,-139,-260,-372,-437,-451,-441,-437,-449,-472,-496,-508,-500,-468,-420,-371,-337,-324,-328,-332,-321,-289,-246,-203,-170,-145,-125,-114,-121,-148,-183,-207,-211,-196,-173,-151,-135,-126,-128,-138,-149,-155,-161,-178,-208,-240,-259,-262,-260,-268,-287,-305,-308,-288,-248,-196,-144,-102,-81,-80,-94,-109,-116,-112,-100,-84,-64,-45,-31,-26,-32,-43,-53,-59,-59,-52,-40,-29,-25,-32,-48,-68,-87,-101,-108,-110,-113,-119,-126,-131,-131,-133,-139,-147,-148,-142,-130,-113,-90,-65,-45,-38,-43,-49,-54,-60,-66,-70,-66,-58,-51,-46,-40,-35,-39,-50,-56,-43,-16},
            {0,-32,-23,17,22,-25,-50,5,65,24,-78,-75,64,125,-65,-232,349,2315,5540,8780,9892,6754,-1160,-11402,-18951,-19132,-11337,-78,8292,10641,9154,8428,10663,13863,14501,11313,6231,2145,498,1025,2864,5083,6354,5195,1258,-3807,-7397,-8128,-6820,-5373,-4953,-5427,-6127,-6591,-6551,-5780,-4425,-3275,-3184,-4089,-4902,-4580,-3137,-1409,-22,1029,1856,2207,1879,1333,1431,2461,3717,4248,3839,3062,2488,2155,1818,1402,987,557,46,-393,-435,-32,374,265,-391,-1139,-1586,-1751,-1846,-1890,-1727,-1363,-1080,-1124,-1404,-1600,-1513,-1251,-1050,-1015,-1057,-1015,-801,-441,-43,259,377,314,171,84,142,333,554,673,616,394,71,-289,-619,-828,-837,-669,-482,-442,-555,-665,-628,-462,-303,-240,-242,-234,-192,-140,-91,-38,1,-5,-51,-87,-76,-43,-41,-76,-109,-123,-154,-236,-338,-387,-346,-241,-127,-38,13,14,-38,-113,-164,-167,-143,-120,-111,-106,-101,-98,-84,-39,34,91,82,1,-103,-175,-195,-182,-163,-151,-145,-137,-112,-61,6,60,72,33,-37,-106,-147,-155,-141,-130,-138,-158,-166,-142,-94,-52,-40,-66,-119,-186,-246,-278,-274,-248,-221,-200,-176,-144,-118,-115,-130,-141,-137,-124,-115,-107,-86,-50,-14,5,5,-11,-40,-74,-100,-111,-113,-124,-147,-166,-163,-141,-120,-113,-116,-120,-123,-129,-137,-146,-157,-172,-188,-194,-184,-166,-147,-132,-119,-106,-96,-86,-72,-52,-30,-10,12,39,65,78,70,50,31,22,21,27,35,42,40,29,13,2,-1}
        },
        {    // H40e122a.wav
            {0,0,0,0,1,1,2,2,2,2,1,1,1,0,-1,-1,-1,0,0,0,1,2,2,1,0,0,0,0,0,1,3,3,2,2,2,2,-1,-4,-4,-2,-2,-3,-1,7,13,9,-1,-4,3,3,-11,8,164,565,1231,2015,2587,2511,1448,-590,-3088,-5147,-5912,-5039,-2883,-239,2139,3880,4976,5534,5592,5148,4300,3302,2469,2010,1940,2093,2216,2092,1650,1010,390,-56,-346,-616,-969,-1386,-1774,-2054,-2203,-2220,-2117,-1948,-1803,-1729,-1666,-1515,-1278,-1096,-1097,-1207,-1161,-749,-47,616,944,915,769,770,988,1289,1483,1480,1325,1136,1011,978,987,944,764,419,-39,-502,-859,-1049,-1074,-994,-893,-842,-861,-918,-965,-984,-995,-1020,-1032,-976,-820,-593,-370,-210,-124,-89,-77,-62,-24,49,150,255,336,375,368,318,246,185,159,157,144,86,-19,-145,-267,-377,-473,-548,-587,-587,-557,-516,-483,-470,-481,-505,-528,-533,-513,-467,-395,-305,-213,-138,-92,-79,-95,-128,-160,-172,-153,-114,-77,-63,-73,-97,-120,-133,-133,-123,-117,-128,-158,-192,-212,-217,-221,-245,-290,-337,-364,-358,-322,-266,-206,-156,-126,-117,-124,-137,-149,-159,-161,-150,-127,-98,-73,-53,-34,-17,-10,-21,-43,-61,-63,-52,-39,-28,-18,-13,-18,-37,-64,-89,-109,-122,-128,-126,-116,-105,-101,-106,-120,-139,-156,-163,-155,-135,-108,-82,-58,-42,-35,-36,-41,-47,-59,-76,-87,-82,-60,-38,-27,-22,-16,-18,-41,-77,-97,-75,-28},
            {15,-3,-28,-22,10,17,-16,-38,-2,45,21,-53,-61,37,96,-35,-182,241,1880,4800,7985,9388,6875,-155,-9479,-16567,-17318,-11227,-2075,4976,7530,7470,8389,11647,15083,15456,11790,6175,1691,-4,813,2957,5182,6238,5032,1444,-3105,-6438,-7332,-6391,-5223,-4908,-5390,-6048,-6413,-6270,-5513,-4318,-3323,-3208,-3930,-4589,-4282,-2981,-1403,-147,758,1453,1801,1635,1275,1396,2268,3364,3903,3657,3029,2464,2037,1632,1254,963,663,208,-282,-448,-150,262,276,-236,-933,-1438,-1677,-1763,-1718,-1477,-1118,-894,-973,-1246,-1455,-1475,-1387,-1318,-1283,-1207,-1037,-780,-469,-159,77,172,135,58,59,190,411,627,745,711,522,211,-160,-504,-718,-738,-607,-470,-459,-568,-668,-646,-518,-386,-312,-272,-219,-157,-113,-93,-80,-77,-105,-147,-153,-93,-7,33,11,-35,-70,-112,-188,-275,-312,-266,-166,-68,-2,24,6,-56,-138,-200,-220,-211,-197,-187,-171,-147,-120,-88,-40,20,58,37,-40,-126,-173,-176,-157,-143,-140,-145,-147,-133,-92,-30,26,48,29,-12,-50,-75,-89,-101,-116,-139,-162,-167,-141,-93,-47,-26,-40,-82,-143,-208,-256,-274,-267,-251,-230,-200,-161,-133,-137,-167,-193,-191,-167,-139,-113,-81,-41,-5,13,11,-6,-34,-69,-101,-119,-126,-131,-139,-142,-132,-115,-102,-98,-96,-91,-89,-98,-116,-135,-152,-169,-183,-186,-175,-159,-150,-150,-148,-139,-122,-101,-78,-50,-22,1,16,24,28,32,38,47,56,62,62,57,51,44,35,24,12,4}
        },
        {    // H40e129a.wav
            {-1,-1,0,1,2,1,0,0,1,1,1,0,-1,-1,-1,-1,-1,0,0,1,1,1,0,-1,-1,-1,-2,-1,1,4,3,1,0,1,1,-2,-4,-4,-2,-3,-4,0,8,11,5,-3,-1,2,-7,-6,104,468,1155,2026,2704,2697,1654,-391,-2908,-5033,-5945,-5273,-3275,-655,1852,3811,5121,5824,5931,5444,4483,3347,2399,1886,1822,2019,2190,2095,1654,994,359,-62,-274,-441,-727,-1156,-1632,-2038,-2315,-2444,-2426,-2292,-2116,-1976,-1875,-1735,-1496,-1213,-1017,-974,-970,-794,-328,314,867,1133,1138,1078,1128,1287,1416,1398,1256,1114,1064,1092,1106,1022,813,493,99,-319,-690,-953,-1079,-1082,-1000,-884,-783,-744,-790,-903,-1033,-1125,-1139,-1052,-868,-628,-401,-251,-196,-197,-196,-156,-80,10,99,182,261,323,345,312,239,171,149,175,207,195,127,31,-61,-144,-241,-361,-486,-582,-626,-624,-594,-555,-528,-526,-553,-595,-625,-621,-571,-478,-353,-223,-121,-76,-87,-122,-141,-126,-86,-44,-16,-4,-5,-20,-47,-76,-95,-102,-110,-131,-161,-186,-201,-216,-246,-289,-328,-343,-332,-304,-272,-239,-211,-192,-184,-181,-176,-168,-161,-156,-151,-144,-139,-133,-122,-101,-73,-48,-31,-23,-21,-28,-39,-48,-47,-36,-26,-24,-29,-38,-50,-66,-88,-109,-121,-124,-120,-114,-109,-106,-109,-120,-136,-150,-150,-133,-105,-80,-65,-56,-50,-50,-60,-78,-89,-84,-72,-64,-61,-52,-37,-26,-29,-37,-42,-49,-71,-103,-116,-87,-31},
            {3,13,2,-20,-21,1,11,-9,-27,-6,28,17,-35,-48,17,69,-15,-141,150,1478,4074,7173,8897,7101,1006,-7510,-14399,-15943,-11529,-4172,1972,4989,6320,8598,12511,15924,16019,12106,6276,1557,-310,491,2711,4975,6059,5045,1866,-2281,-5524,-6688,-6127,-5168,-4845,-5239,-5835,-6169,-6027,-5350,-4310,-3427,-3258,-3791,-4302,-4018,-2868,-1446,-297,526,1162,1531,1476,1215,1308,2046,3052,3644,3517,2929,2292,1800,1461,1264,1136,867,320,-284,-498,-163,324,386,-138,-887,-1428,-1646,-1665,-1561,-1321,-1025,-872,-971,-1199,-1351,-1379,-1393,-1459,-1483,-1337,-1024,-672,-392,-207,-89,-27,-12,1,78,251,482,691,800,768,592,303,-42,-365,-584,-650,-596,-523,-520,-586,-640,-618,-538,-462,-412,-356,-274,-189,-138,-122,-118,-125,-157,-193,-181,-96,13,71,58,17,-16,-57,-129,-211,-244,-205,-124,-46,8,34,16,-59,-168,-257,-289,-272,-243,-221,-200,-171,-137,-101,-58,-13,10,-11,-70,-128,-155,-151,-140,-138,-147,-161,-172,-165,-127,-63,-1,31,30,10,-14,-41,-70,-99,-123,-143,-158,-157,-130,-82,-36,-16,-28,-67,-125,-190,-244,-270,-268,-252,-235,-216,-192,-173,-176,-200,-221,-216,-188,-153,-120,-86,-50,-21,-10,-18,-36,-56,-78,-97,-108,-112,-114,-118,-121,-116,-106,-95,-87,-79,-72,-74,-90,-115,-136,-151,-161,-170,-171,-163,-154,-153,-161,-167,-160,-141,-115,-86,-58,-34,-20,-17,-14,-2,20,46,67,79,81,78,70,59,45,30,15,4}
        },
        {    // H40e135a.wav
            {1,1,1,1,1,1,1,1,0,-1,-2,-2,-2,-2,-2,-1,0,2,2,1,-1,-2,-2,-1,-2,-2,0,3,3,1,-1,-1,-1,-3,-6,-6,-3,-3,-6,-6,2,10,7,-3,-4,4,0,-6,84,443,1174,2130,2874,2850,1698,-479,-3076,-5205,-6085,-5387,-3373,-711,1895,3998,5448,6226,6308,5696,4562,3279,2265,1767,1759,2004,2203,2117,1664,953,235,-263,-492,-604,-800,-1159,-1597,-1976,-2220,-2334,-2352,-2304,-2225,-2159,-2112,-2027,-1821,-1487,-1132,-905,-840,-796,-555,-28,639,1178,1425,1444,1424,1471,1519,1449,1260,1079,1021,1063,1078,974,764,508,229,-98,-475,-842,-1107,-1208,-1147,-977,-779,-641,-622,-727,-905,-1076,-1165,-1122,-940,-665,-392,-215,-170,-207,-245,-229,-166,-82,7,103,202,276,295,258,194,145,133,155,184,189,159,99,26,-47,-120,-199,-291,-386,-470,-528,-563,-583,-599,-617,-636,-659,-681,-687,-653,-568,-454,-351,-288,-252,-214,-157,-91,-41,-14,4,20,31,27,11,-1,-2,-3,-22,-60,-105,-143,-179,-221,-271,-315,-336,-332,-307,-272,-235,-205,-193,-202,-224,-242,-245,-230,-207,-184,-168,-161,-156,-152,-144,-132,-115,-95,-76,-63,-55,-48,-41,-34,-31,-32,-32,-29,-25,-29,-41,-59,-79,-98,-112,-118,-114,-106,-101,-104,-116,-132,-145,-151,-145,-131,-113,-92,-69,-47,-32,-33,-49,-73,-96,-116,-125,-117,-93,-62,-39,-28,-23,-22,-31,-54,-80,-96,-103,-109,-114,-105,-71,-24},
            {3,4,9,6,-6,-14,-9,0,-3,-14,-10,8,17,-3,-27,-11,33,27,-66,-44,597,2376,5186,7781,8074,4484,-2489,-9937,-14180,-13322,-8552,-2920,1314,4273,7536,11812,15703,16807,13987,8516,3104,-41,-357,1342,3732,5516,5635,3625,69,-3530,-5705,-6055,-5369,-4764,-4785,-5252,-5711,-5825,-5447,-4635,-3742,-3283,-3481,-3933,-3928,-3140,-1902,-768,52,682,1164,1335,1184,1102,1537,2442,3244,3406,2914,2189,1648,1429,1430,1428,1177,588,-96,-424,-175,335,520,105,-633,-1223,-1469,-1502,-1469,-1360,-1150,-957,-942,-1102,-1274,-1348,-1380,-1459,-1533,-1446,-1130,-700,-351,-187,-175,-215,-218,-136,44,294,553,748,829,789,655,459,222,-39,-293,-488,-586,-606,-599,-597,-589,-555,-515,-509,-530,-519,-432,-302,-206,-174,-171,-158,-139,-138,-145,-124,-68,-8,26,43,63,67,20,-75,-163,-186,-141,-70,-10,23,23,-25,-119,-222,-284,-293,-270,-244,-221,-193,-159,-125,-93,-61,-36,-31,-52,-85,-110,-124,-135,-149,-165,-179,-190,-190,-166,-114,-48,5,28,26,10,-14,-45,-76,-102,-121,-136,-142,-126,-86,-39,-8,-4,-24,-64,-121,-186,-237,-259,-255,-240,-220,-198,-179,-176,-193,-215,-219,-202,-176,-154,-132,-105,-74,-51,-42,-42,-49,-63,-79,-90,-88,-77,-68,-67,-71,-75,-80,-83,-82,-75,-68,-70,-84,-105,-125,-138,-144,-144,-142,-142,-149,-158,-162,-157,-142,-122,-100,-83,-73,-66,-53,-29,5,40,69,88,97,97,93,90,86,73,46,15}
        },
        {    // H40e141a.wav
            {1,1,1,1,1,0,-1,-1,-2,-2,-2,-2,-1,0,0,1,1,0,-1,-1,-1,0,-1,-2,0,2,2,0,0,2,2,-3,-7,-6,-1,-2,-7,-7,3,11,5,-7,-4,9,4,10,176,707,1648,2694,3238,2695,894,-1748,-4375,-6067,-6239,-4859,-2398,440,3048,5082,6404,6932,6613,5536,4048,2661,1799,1588,1833,2182,2307,2030,1375,550,-165,-593,-767,-881,-1115,-1500,-1923,-2242,-2389,-2385,-2294,-2185,-2105,-2071,-2060,-2007,-1839,-1530,-1155,-862,-755,-767,-676,-287,372,1056,1521,1722,1790,1824,1784,1587,1281,1042,989,1051,1051,889,622,354,111,-162,-496,-841,-1110,-1248,-1243,-1112,-893,-666,-534,-558,-715,-912,-1046,-1051,-909,-649,-353,-126,-40,-79,-160,-198,-170,-101,-24,51,121,172,182,152,109,87,98,129,155,162,147,109,48,-36,-133,-228,-306,-353,-368,-364,-368,-404,-482,-584,-678,-738,-755,-738,-698,-637,-556,-457,-352,-260,-194,-156,-132,-107,-73,-36,-3,26,57,86,98,83,49,12,-18,-55,-114,-192,-264,-308,-316,-295,-259,-222,-198,-194,-209,-232,-249,-252,-241,-221,-199,-188,-194,-212,-228,-225,-202,-166,-131,-102,-81,-64,-52,-44,-42,-45,-49,-51,-46,-35,-22,-13,-12,-21,-39,-63,-90,-113,-127,-131,-126,-121,-122,-130,-140,-145,-147,-144,-133,-111,-82,-54,-35,-24,-20,-27,-47,-74,-95,-106,-108,-105,-93,-70,-46,-32,-31,-38,-48,-66,-92,-112,-113,-102,-101,-112,-114,-83,-30},
            {10,7,2,2,4,0,-9,-12,-7,-1,-2,-5,-2,4,4,-9,-15,4,25,-10,-60,193,1299,3559,6344,7928,6396,1209,-5876,-11625,-13466,-11183,-6670,-2042,2019,6161,10822,15033,16874,15115,10404,4905,857,-636,215,2400,4637,5685,4734,1892,-1707,-4536,-5706,-5465,-4778,-4460,-4693,-5179,-5516,-5424,-4842,-4008,-3390,-3326,-3647,-3768,-3253,-2225,-1160,-351,266,791,1105,1096,996,1257,2021,2857,3158,2754,2041,1548,1467,1599,1615,1313,727,115,-192,-49,320,485,199,-387,-926,-1236,-1380,-1456,-1434,-1263,-1039,-958,-1089,-1301,-1424,-1433,-1416,-1407,-1331,-1115,-794,-483,-274,-186,-186,-217,-200,-61,212,536,781,864,794,646,488,341,185,-5,-222,-431,-594,-689,-707,-651,-546,-454,-437,-498,-567,-561,-467,-343,-248,-195,-161,-139,-137,-153,-158,-133,-91,-54,-18,27,71,74,16,-71,-130,-134,-100,-57,-20,3,-6,-58,-138,-209,-245,-250,-241,-228,-208,-181,-153,-128,-98,-62,-34,-30,-54,-92,-129,-159,-183,-201,-212,-219,-217,-198,-153,-90,-33,0,4,-10,-32,-54,-71,-81,-89,-103,-119,-124,-103,-63,-25,-6,-11,-35,-75,-126,-176,-215,-234,-238,-231,-214,-192,-176,-176,-189,-202,-205,-201,-195,-187,-168,-139,-105,-77,-61,-57,-62,-70,-73,-66,-52,-45,-48,-57,-64,-66,-67,-72,-76,-77,-80,-87,-102,-117,-128,-133,-136,-140,-142,-143,-145,-146,-145,-139,-132,-129,-127,-117,-93,-59,-23,12,47,79,97,97,90,89,95,90,61,21}
        },
        {    // H40e148a.wav
            {3,2,0,-1,-1,-1,-1,-2,-3,-2,0,1,1,1,0,-1,-2,-2,-2,-2,-2,-2,1,3,3,0,-1,0,1,-3,-7,-5,0,-1,-8,-11,-1,9,5,-6,-2,11,4,7,190,786,1838,2980,3512,2794,703,-2212,-4957,-6566,-6509,-4864,-2185,804,3525,5653,7030,7519,7025,5671,3910,2374,1540,1482,1899,2345,2462,2094,1314,375,-411,-862,-1024,-1118,-1337,-1710,-2117,-2412,-2530,-2497,-2384,-2259,-2163,-2099,-2039,-1941,-1761,-1473,-1104,-755,-557,-548,-597,-479,-65,560,1184,1652,1941,2071,2013,1749,1377,1095,1026,1085,1071,873,564,290,102,-81,-356,-730,-1118,-1403,-1499,-1375,-1081,-744,-517,-486,-621,-808,-929,-924,-792,-573,-333,-145,-51,-36,-43,-26,11,32,22,1,5,42,83,97,79,52,44,62,94,121,125,98,39,-45,-148,-254,-343,-389,-382,-342,-312,-333,-407,-504,-588,-652,-711,-766,-786,-730,-593,-420,-275,-193,-170,-176,-190,-197,-186,-143,-68,17,81,106,99,79,58,32,-7,-63,-128,-184,-213,-211,-191,-175,-182,-208,-238,-258,-264,-258,-245,-228,-214,-209,-213,-224,-236,-246,-249,-240,-220,-192,-163,-132,-100,-70,-49,-40,-40,-42,-42,-41,-38,-32,-27,-23,-21,-22,-27,-42,-65,-88,-106,-120,-136,-152,-163,-167,-169,-172,-170,-157,-134,-109,-86,-64,-46,-38,-44,-54,-60,-59,-62,-67,-68,-61,-54,-56,-64,-69,-73,-79,-88,-89,-81,-78,-84,-91,-90,-94,-124,-168,-182,-132,-47},
            {0,7,10,7,1,-1,-1,-3,-8,-12,-9,-2,0,-4,-6,0,3,-6,-12,3,14,-23,-1,490,1974,4463,6894,7397,4544,-1301,-7818,-12138,-12708,-10024,-5713,-1024,3800,8824,13427,16194,15886,12509,7467,2747,-126,-627,833,3206,5141,5446,3668,438,-2843,-4901,-5372,-4850,-4252,-4144,-4526,-5045,-5294,-5034,-4337,-3590,-3229,-3342,-3543,-3338,-2601,-1645,-823,-202,325,742,925,937,1107,1669,2395,2761,2502,1911,1514,1534,1736,1747,1421,895,411,143,135,283,383,260,-102,-559,-959,-1246,-1420,-1457,-1344,-1158,-1054,-1127,-1314,-1469,-1505,-1439,-1324,-1176,-995,-801,-618,-453,-306,-196,-142,-114,-35,148,402,632,757,761,679,562,447,343,223,47,-193,-451,-653,-746,-724,-623,-497,-406,-387,-433,-490,-508,-474,-415,-352,-286,-219,-170,-156,-170,-180,-170,-147,-121,-87,-37,8,19,-13,-57,-74,-58,-28,-7,-1,-10,-36,-78,-122,-151,-161,-163,-170,-182,-191,-190,-172,-136,-90,-48,-32,-50,-94,-144,-186,-213,-228,-236,-242,-247,-242,-214,-161,-100,-55,-39,-42,-48,-47,-44,-47,-62,-88,-117,-133,-124,-87,-39,0,16,6,-24,-70,-121,-169,-205,-226,-232,-221,-197,-168,-152,-159,-181,-204,-220,-229,-232,-220,-189,-146,-106,-80,-68,-65,-68,-71,-69,-58,-45,-37,-38,-40,-39,-39,-46,-62,-82,-102,-119,-132,-134,-128,-120,-119,-125,-133,-136,-134,-131,-130,-135,-145,-153,-147,-122,-86,-51,-22,10,45,72,79,76,77,85,85,60,21}
        },
        {    // H40e154a.wav
            {1,-1,-2,-2,-2,-2,-2,-1,1,2,3,2,1,-1,-2,-2,-1,0,0,1,3,4,1,-2,-1,2,1,-4,-8,-3,3,0,-9,-8,4,9,-1,-9,6,20,4,46,395,1277,2576,3676,3726,2198,-684,-3979,-6494,-7356,-6344,-3876,-709,2433,5086,7032,8111,8134,7035,5113,3048,1589,1126,1507,2213,2689,2598,1908,854,-191,-913,-1237,-1342,-1482,-1779,-2170,-2503,-2677,-2681,-2566,-2417,-2307,-2255,-2213,-2102,-1889,-1594,-1246,-864,-503,-269,-235,-322,-309,-22,510,1097,1571,1883,2038,2010,1776,1419,1122,1001,996,938,743,481,266,116,-65,-361,-758,-1164,-1475,-1619,-1566,-1334,-1014,-739,-611,-630,-713,-764,-734,-625,-460,-271,-93,40,115,148,166,179,180,157,118,77,43,16,-5,-9,17,68,120,138,110,45,-38,-125,-209,-281,-333,-357,-357,-343,-331,-337,-379,-463,-579,-703,-798,-825,-765,-623,-441,-277,-176,-148,-171,-213,-248,-259,-236,-174,-90,-11,41,59,54,33,-2,-42,-75,-87,-76,-53,-35,-37,-64,-113,-167,-212,-239,-248,-248,-243,-234,-227,-229,-238,-251,-262,-270,-276,-275,-264,-239,-208,-179,-154,-131,-106,-81,-58,-40,-29,-25,-26,-28,-27,-18,-4,8,11,2,-16,-40,-66,-93,-118,-133,-137,-137,-144,-160,-181,-196,-200,-190,-168,-135,-102,-78,-67,-67,-69,-69,-68,-67,-64,-57,-45,-29,-13,-8,-20,-45,-71,-87,-95,-101,-105,-101,-91,-86,-92,-103,-113,-125,-145,-164,-154,-103,-34},
            {-3,-3,1,7,10,7,1,-1,1,0,-7,-13,-10,0,4,-5,-12,-2,10,2,-15,-8,12,-6,15,462,1849,4205,6526,7046,4425,-1023,-7227,-11601,-12622,-10441,-6220,-1078,4347,9529,13621,15579,14774,11499,6925,2596,-176,-740,695,3104,5032,5256,3446,355,-2660,-4485,-4862,-4352,-3794,-3728,-4174,-4762,-5041,-4772,-4083,-3393,-3084,-3171,-3291,-3057,-2411,-1613,-921,-374,104,515,802,1019,1327,1764,2110,2108,1797,1515,1533,1761,1870,1666,1255,867,608,443,329,275,258,176,-75,-480,-910,-1230,-1387,-1402,-1330,-1240,-1204,-1266,-1405,-1535,-1564,-1448,-1212,-933,-700,-560,-500,-464,-398,-285,-131,46,222,362,443,481,519,577,632,638,574,444,262,39,-203,-414,-550,-601,-587,-532,-453,-374,-325,-327,-372,-435,-494,-534,-538,-489,-398,-307,-255,-243,-242,-233,-223,-224,-224,-195,-132,-57,-2,27,40,50,55,51,38,15,-17,-52,-72,-67,-45,-30,-46,-90,-145,-188,-204,-188,-147,-100,-71,-77,-114,-163,-208,-239,-262,-287,-319,-346,-344,-295,-209,-118,-55,-31,-36,-51,-65,-74,-77,-80,-87,-96,-96,-74,-32,10,33,29,2,-41,-90,-134,-163,-174,-175,-173,-172,-167,-162,-164,-176,-192,-206,-214,-218,-217,-204,-180,-149,-124,-112,-111,-115,-114,-99,-72,-39,-13,-1,-2,-13,-29,-46,-63,-82,-104,-128,-150,-160,-158,-146,-131,-118,-107,-100,-95,-97,-107,-122,-138,-145,-135,-111,-81,-51,-23,4,24,32,33,37,46,50,38,14}
        },
        {    // H40e161a.wav
            {-3,-3,-2,-2,-1,-1,0,0,1,2,2,0,-3,-3,-1,0,-1,0,3,5,2,-2,-1,2,2,-6,-10,-4,4,0,-10,-9,5,11,-3,-13,7,25,7,55,458,1469,2925,4091,4004,2130,-1177,-4779,-7342,-7975,-6560,-3664,-163,3176,5910,7855,8857,8702,7316,5060,2738,1205,862,1466,2367,2919,2765,1916,681,-489,-1241,-1520,-1573,-1712,-2060,-2494,-2807,-2898,-2806,-2640,-2490,-2402,-2364,-2311,-2170,-1915,-1574,-1183,-762,-357,-70,8,-81,-144,15,434,981,1492,1873,2082,2070,1820,1427,1078,910,884,840,668,409,189,68,-20,-198,-535,-985,-1421,-1696,-1726,-1527,-1219,-951,-815,-801,-824,-803,-706,-548,-367,-198,-65,28,103,189,293,382,406,342,225,115,49,32,48,87,137,169,153,91,14,-46,-93,-159,-254,-349,-407,-417,-397,-370,-347,-353,-422,-571,-763,-911,-945,-851,-676,-475,-292,-157,-91,-98,-148,-192,-195,-159,-107,-59,-20,6,15,2,-31,-70,-102,-111,-88,-36,23,55,37,-25,-103,-165,-193,-192,-177,-166,-173,-201,-243,-284,-309,-314,-303,-286,-272,-267,-269,-267,-251,-221,-183,-149,-122,-102,-85,-69,-51,-32,-15,-5,-2,-2,1,9,18,26,25,8,-25,-64,-94,-110,-118,-126,-139,-152,-163,-173,-181,-184,-179,-171,-164,-157,-145,-127,-105,-86,-72,-64,-65,-70,-70,-60,-42,-22,-8,1,1,-13,-37,-62,-80,-93,-105,-114,-111,-102,-101,-114,-127,-120,-104,-103,-119,-126,-93,-34},
            {-5,-3,-1,0,2,5,7,5,1,0,2,0,-9,-15,-10,2,3,-8,-14,-1,11,-2,-20,-7,17,-1,51,597,2108,4462,6514,6549,3505,-2014,-7885,-11743,-12313,-9791,-5240,214,5701,10453,13684,14738,13406,10108,5836,1909,-454,-623,1086,3472,5035,4771,2695,-251,-2819,-4183,-4306,-3791,-3382,-3492,-4042,-4612,-4778,-4401,-3714,-3138,-2948,-3057,-3111,-2826,-2215,-1516,-916,-420,51,508,895,1193,1430,1592,1615,1504,1411,1499,1740,1910,1823,1523,1197,951,740,511,322,252,250,148,-156,-582,-965,-1212,-1345,-1404,-1391,-1322,-1274,-1332,-1483,-1599,-1550,-1317,-998,-713,-529,-445,-423,-413,-362,-231,-33,172,315,372,383,409,481,578,650,652,561,379,142,-84,-232,-283,-284,-301,-355,-409,-419,-386,-355,-356,-388,-438,-500,-571,-629,-641,-598,-523,-449,-384,-325,-279,-261,-268,-271,-239,-169,-85,-5,66,124,156,147,104,55,21,6,8,24,49,65,50,-4,-77,-142,-182,-195,-187,-165,-139,-123,-130,-161,-206,-253,-297,-337,-370,-390,-387,-353,-290,-213,-140,-90,-65,-55,-52,-51,-53,-57,-63,-68,-69,-63,-44,-16,13,30,26,1,-40,-85,-124,-149,-158,-158,-156,-155,-155,-156,-159,-164,-169,-174,-182,-194,-202,-199,-183,-163,-148,-141,-137,-132,-122,-102,-71,-35,-5,7,1,-18,-40,-65,-91,-117,-138,-151,-155,-153,-146,-134,-119,-101,-84,-71,-67,-74,-89,-103,-110,-108,-99,-84,-62,-37,-15,0,7,12,16,17,13,4}
        },
        {    // H40e167a.wav
            {-4,-5,-3,-1,1,2,2,2,-1,-4,-5,-3,-1,-2,-3,0,4,5,0,-5,-2,0,-4,-12,-12,-2,3,-6,-15,-7,9,6,-15,-16,15,24,6,163,858,2251,3889,4740,3800,857,-3217,-6893,-8799,-8335,-5801,-2088,1817,5206,7759,9344,9789,8891,6737,3968,1616,519,811,1904,2934,3252,2664,1392,-82,-1244,-1813,-1893,-1867,-2073,-2534,-3005,-3227,-3141,-2883,-2638,-2514,-2505,-2518,-2437,-2197,-1822,-1383,-932,-484,-80,186,241,146,83,219,583,1073,1553,1921,2104,2061,1813,1463,1131,878,682,503,335,196,89,-14,-151,-348,-619,-956,-1302,-1563,-1655,-1571,-1384,-1188,-1041,-950,-891,-826,-725,-574,-389,-207,-53,71,179,274,352,408,437,427,362,257,162,140,201,291,333,285,169,38,-66,-137,-193,-247,-302,-349,-382,-398,-408,-432,-496,-613,-765,-900,-963,-927,-808,-648,-492,-373,-304,-279,-268,-233,-154,-50,42,98,118,112,84,32,-37,-103,-142,-138,-91,-15,61,101,81,8,-85,-163,-203,-202,-171,-133,-113,-127,-172,-232,-289,-332,-359,-366,-358,-344,-331,-317,-294,-259,-219,-182,-151,-124,-101,-89,-86,-86,-76,-57,-33,-13,5,21,36,46,46,35,13,-16,-47,-76,-99,-115,-123,-127,-132,-142,-157,-170,-178,-183,-184,-183,-181,-180,-179,-173,-157,-133,-114,-105,-104,-102,-95,-80,-58,-36,-20,-14,-16,-19,-23,-35,-55,-76,-89,-95,-100,-107,-111,-113,-121,-132,-134,-117,-99,-104,-130,-139,-103,-37},
            {1,-2,-4,-3,-1,-1,0,4,8,7,0,-3,1,3,-5,-16,-14,-1,5,-7,-17,-4,15,6,-20,-16,16,13,21,391,1615,3741,5869,6403,4119,-762,-6484,-10753,-12027,-10116,-5880,-543,4795,9292,12344,13561,12794,10213,6441,2585,-66,-651,713,2931,4544,4557,2909,365,-2011,-3436,-3753,-3389,-3014,-3090,-3617,-4217,-4463,-4192,-3600,-3061,-2836,-2889,-2948,-2756,-2277,-1675,-1119,-632,-137,388,847,1123,1192,1141,1089,1129,1292,1546,1785,1888,1807,1602,1361,1120,867,618,430,330,248,85,-193,-525,-838,-1105,-1311,-1419,-1408,-1336,-1318,-1406,-1527,-1548,-1410,-1164,-906,-696,-548,-456,-398,-330,-216,-65,66,132,151,187,283,427,569,664,681,608,455,262,88,-14,-33,-1,21,-16,-125,-271,-394,-452,-450,-432,-441,-496,-581,-670,-737,-770,-768,-736,-676,-592,-490,-386,-296,-229,-188,-166,-154,-131,-71,31,146,225,233,178,100,41,26,59,122,180,191,138,37,-71,-156,-205,-221,-209,-178,-152,-154,-190,-242,-288,-321,-350,-379,-400,-404,-389,-360,-320,-267,-204,-141,-87,-45,-18,-7,-14,-34,-60,-80,-87,-75,-44,-1,37,53,44,15,-23,-64,-102,-131,-148,-153,-151,-144,-133,-121,-116,-121,-136,-155,-172,-188,-200,-201,-190,-171,-154,-146,-145,-142,-134,-120,-99,-75,-54,-40,-36,-39,-48,-61,-80,-102,-125,-143,-154,-153,-137,-108,-75,-51,-43,-49,-65,-81,-91,-93,-89,-85,-83,-79,-69,-53,-36,-23,-14,-8,-4,-1}
        },
        {    // H40e174a.wav
            {-3,-1,2,3,3,2,0,-2,-4,-2,0,0,-1,1,5,7,2,-2,0,3,-2,-11,-12,-1,5,-5,-16,-7,13,9,-15,-18,16,28,9,181,952,2498,4300,5190,4057,713,-3805,-7763,-9665,-8934,-5983,-1831,2441,6072,8720,10258,10530,9361,6876,3792,1242,150,645,2022,3251,3576,2812,1287,-399,-1661,-2214,-2212,-2105,-2284,-2787,-3324,-3567,-3417,-3036,-2683,-2529,-2563,-2634,-2569,-2295,-1867,-1384,-891,-384,92,409,475,358,260,350,644,1049,1472,1842,2069,2066,1836,1508,1223,1004,770,483,212,50,-20,-104,-275,-503,-727,-940,-1171,-1399,-1538,-1528,-1411,-1285,-1203,-1138,-1039,-900,-745,-590,-425,-254,-102,11,101,200,307,385,403,375,349,358,396,435,452,435,374,265,131,18,-40,-55,-78,-141,-234,-316,-370,-414,-479,-578,-698,-818,-909,-943,-902,-801,-690,-612,-568,-527,-463,-380,-297,-214,-118,-5,101,167,183,159,108,41,-25,-55,-27,47,120,147,116,46,-31,-95,-138,-158,-161,-156,-152,-156,-166,-184,-211,-244,-278,-310,-340,-367,-387,-392,-380,-355,-318,-272,-219,-165,-121,-90,-73,-65,-62,-62,-62,-62,-55,-39,-13,20,47,60,59,44,20,-10,-43,-69,-88,-103,-118,-131,-135,-132,-131,-138,-150,-161,-168,-177,-187,-192,-187,-174,-163,-157,-156,-155,-149,-134,-109,-78,-52,-38,-33,-32,-31,-33,-37,-41,-45,-52,-63,-71,-70,-66,-71,-88,-108,-122,-128,-130,-124,-111,-99,-102,-115,-112,-78,-27},
            {5,4,1,-3,-4,-1,1,1,2,6,10,7,1,-1,3,3,-5,-14,-9,5,8,-7,-15,0,17,5,-21,-13,23,19,28,400,1601,3635,5604,5995,3714,-965,-6357,-10318,-11410,-9454,-5288,-155,4817,8847,11502,12562,11909,9597,6114,2505,54,-421,891,2886,4236,4134,2614,368,-1706,-2955,-3243,-2949,-2678,-2840,-3403,-3989,-4207,-3941,-3395,-2907,-2696,-2732,-2786,-2637,-2233,-1700,-1180,-689,-166,383,818,995,929,799,797,978,1266,1555,1774,1886,1860,1694,1433,1155,913,706,506,300,104,-72,-251,-478,-768,-1067,-1284,-1372,-1373,-1371,-1409,-1451,-1440,-1356,-1223,-1069,-901,-731,-585,-474,-366,-217,-35,115,168,133,83,98,209,395,598,743,760,635,422,216,81,30,37,70,99,84,0,-145,-307,-442,-535,-594,-630,-656,-689,-741,-802,-841,-833,-785,-718,-645,-557,-450,-335,-232,-152,-90,-43,-12,8,29,67,118,164,186,179,156,138,139,157,171,156,103,23,-65,-145,-208,-244,-245,-218,-187,-182,-213,-264,-313,-350,-379,-401,-411,-405,-385,-357,-320,-270,-208,-142,-84,-43,-21,-18,-30,-50,-68,-78,-71,-49,-17,17,42,51,43,17,-19,-58,-91,-114,-125,-129,-128,-122,-113,-110,-118,-134,-151,-160,-164,-168,-175,-178,-177,-172,-168,-167,-168,-167,-162,-148,-123,-93,-69,-56,-50,-49,-52,-60,-73,-87,-101,-114,-123,-121,-102,-71,-43,-34,-47,-72,-95,-106,-103,-93,-84,-80,-81,-82,-79,-73,-64,-50,-29,-9}
        },
        {    // H40e180a.wav
            {0,1,3,3,0,-4,-6,-4,-1,-1,-2,2,7,7,1,-4,-1,3,-2,-13,-14,-2,5,-5,-17,-9,11,9,-16,-21,13,25,6,193,1028,2706,4668,5631,4368,680,-4264,-8536,-10509,-9599,-6307,-1747,2920,6867,9686,11216,11315,9863,7055,3676,940,-166,493,2123,3547,3898,2979,1203,-715,-2109,-2669,-2579,-2357,-2464,-2978,-3590,-3904,-3751,-3280,-2804,-2564,-2588,-2696,-2659,-2372,-1906,-1395,-892,-364,177,593,736,629,481,503,738,1083,1429,1735,1958,2014,1853,1546,1241,1013,809,549,257,38,-67,-148,-327,-617,-914,-1120,-1234,-1320,-1406,-1453,-1428,-1349,-1265,-1193,-1106,-978,-817,-650,-483,-309,-135,11,106,157,186,200,206,230,316,472,636,711,647,482,300,160,75,33,27,41,42,-4,-104,-233,-363,-488,-608,-717,-797,-842,-859,-858,-837,-795,-742,-692,-649,-594,-512,-409,-303,-205,-109,-11,78,130,133,98,56,36,52,98,154,195,201,169,114,55,5,-37,-79,-128,-179,-221,-242,-239,-221,-200,-193,-210,-256,-319,-381,-422,-434,-420,-392,-358,-316,-268,-217,-169,-128,-95,-69,-54,-48,-50,-55,-58,-55,-44,-22,6,31,42,36,18,-3,-23,-42,-64,-88,-108,-122,-130,-134,-137,-138,-139,-142,-148,-156,-164,-172,-179,-184,-187,-188,-189,-189,-184,-172,-151,-123,-93,-68,-54,-53,-58,-61,-59,-54,-54,-58,-66,-73,-79,-79,-71,-63,-64,-80,-102,-115,-113,-105,-103,-106,-108,-107,-105,-101,-85,-54,-18},
            {0,1,3,3,0,-4,-6,-4,-1,-1,-2,2,7,7,1,-4,-1,3,-2,-13,-14,-2,5,-5,-17,-9,11,9,-16,-21,13,25,6,193,1028,2706,4668,5631,4368,680,-4264,-8536,-10509,-9599,-6307,-1747,2920,6867,9686,11216,11315,9863,7055,3676,940,-166,493,2123,3547,3898,2979,1203,-715,-2109,-2669,-2579,-2357,-2464,-2978,-3590,-3904,-3751,-3280,-2804,-2564,-2588,-2696,-2659,-2372,-1906,-1395,-892,-364,177,593,736,629,481,503,738,1083,1429,1735,1958,2014,1853,1546,1241,1013,809,549,257,38,-67,-148,-327,-617,-914,-1120,-1234,-1320,-1406,-1453,-1428,-1349,-1265,-1193,-1106,-978,-817,-650,-483,-309,-135,11,106,157,186,200,206,230,316,472,636,711,647,482,300,160,75,33,27,41,42,-4,-104,-233,-363,-488,-608,-717,-797,-842,-859,-858,-837,-795,-742,-692,-649,-594,-512,-409,-303,-205,-109,-11,78,130,133,98,56,36,52,98,154,195,201,169,114,55,5,-37,-79,-128,-179,-221,-242,-239,-221,-200,-193,-210,-256,-319,-381,-422,-434,-420,-392,-358,-316,-268,-217,-169,-128,-95,-69,-54,-48,-50,-55,-58,-55,-44,-22,6,31,42,36,18,-3,-23,-42,-64,-88,-108,-122,-130,-134,-137,-138,-139,-142,-148,-156,-164,-172,-179,-184,-187,-188,-189,-189,-184,-172,-151,-123,-93,-68,-54,-53,-58,-61,-59,-54,-54,-58,-66,-73,-79,-79,-71,-63,-64,-80,-102,-115,-113,-105,-103,-106,-108,-107,-105,-101,-85,-54,-18}
        }
    },
    {    // elev50 
        {    // H50e000a.wav
            {-2,31,20,-38,-53,15,65,-1,-94,-49,95,103,-78,-166,31,222,39,-183,474,2312,4295,5076,4538,3596,2273,-1040,-7342,-14247,-16815,-12078,-2377,6655,11395,12847,13985,15554,15446,11828,5726,113,-2842,-3028,-1473,743,2553,2836,1175,-1459,-3441,-4118,-4336,-5143,-6325,-6652,-5460,-3558,-2364,-2442,-3125,-3467,-3207,-2723,-2323,-1888,-1201,-368,274,602,883,1433,2183,2714,2711,2305,1923,1860,2056,2249,2231,1940,1422,815,321,72,0,-92,-267,-371,-285,-202,-498,-1274,-2138,-2550,-2347,-1859,-1518,-1442,-1426,-1244,-855,-370,64,324,343,184,45,118,406,713,852,813,719,640,518,280,-11,-185,-116,152,453,631,619,442,179,-58,-162,-100,41,107,3,-230,-462,-599,-651,-690,-769,-890,-1033,-1189,-1347,-1468,-1504,-1429,-1260,-1046,-832,-650,-516,-423,-341,-230,-82,65,151,150,105,88,133,207,250,238,201,181,189,204,200,157,63,-71,-207,-292,-299,-255,-211,-200,-214,-237,-264,-294,-317,-325,-331,-361,-414,-452,-441,-387,-321,-267,-224,-189,-172,-178,-190,-184,-154,-116,-81,-42,15,85,150,194,219,220,190,127,50,-14,-49,-64,-73,-86,-97,-105,-110,-123,-152,-198,-246,-277,-281,-262,-235,-208,-182,-157,-137,-130,-131,-134,-131,-121,-113,-111,-115,-122,-122,-110,-87,-68,-63,-75,-88,-91,-83,-71,-65,-64,-61,-51,-35,-20,-17,-27,-45,-60,-64,-64,-66,-73,-79,-82,-85,-95,-112,-126,-130,-124,-110,-90,-64,-41,-32,-38,-45,-37,-15},
            {-2,31,20,-38,-53,15,65,-1,-94,-49,95,103,-78,-166,31,222,39,-183,474,2312,4295,5076,4538,3596,2273,-1040,-7342,-14247,-16815,-12078,-2377,6655,11395,12847,13985,15554,15446,11828,5726,113,-2842,-3028,-1473,743,2553,2836,1175,-1459,-3441,-4118,-4336,-5143,-6325,-6652,-5460,-3558,-2364,-2442,-3125,-3467,-3207,-2723,-2323,-1888,-1201,-368,274,602,883,1433,2183,2714,2711,2305,1923,1860,2056,2249,2231,1940,1422,815,321,72,0,-92,-267,-371,-285,-202,-498,-1274,-2138,-2550,-2347,-1859,-1518,-1442,-1426,-1244,-855,-370,64,324,343,184,45,118,406,713,852,813,719,640,518,280,-11,-185,-116,152,453,631,619,442,179,-58,-162,-100,41,107,3,-230,-462,-599,-651,-690,-769,-890,-1033,-1189,-1347,-1468,-1504,-1429,-1260,-1046,-832,-650,-516,-423,-341,-230,-82,65,151,150,105,88,133,207,250,238,201,181,189,204,200,157,63,-71,-207,-292,-299,-255,-211,-200,-214,-237,-264,-294,-317,-325,-331,-361,-414,-452,-441,-387,-321,-267,-224,-189,-172,-178,-190,-184,-154,-116,-81,-42,15,85,150,194,219,220,190,127,50,-14,-49,-64,-73,-86,-97,-105,-110,-123,-152,-198,-246,-277,-281,-262,-235,-208,-182,-157,-137,-130,-131,-134,-131,-121,-113,-111,-115,-122,-122,-110,-87,-68,-63,-75,-88,-91,-83,-71,-65,-64,-61,-51,-35,-20,-17,-27,-45,-60,-64,-64,-66,-73,-79,-82,-85,-95,-112,-126,-130,-124,-110,-90,-64,-41,-32,-38,-45,-37,-15}
        },
        {    // H50e008a.wav
            {20,8,-11,0,27,19,-26,-40,10,47,-3,-74,-39,71,76,-59,-119,36,174,24,-126,455,1986,3636,4332,3965,3206,2017,-905,-6347,-12422,-15191,-12154,-4844,2639,7559,10470,13210,15866,16486,13579,8077,2552,-1006,-2254,-1841,-543,848,1464,873,-441,-1529,-2036,-2528,-3603,-4938,-5543,-4927,-3711,-2965,-3083,-3514,-3528,-3010,-2433,-2184,-2144,-1919,-1328,-547,179,789,1329,1755,1939,1880,1766,1769,1862,1920,1948,2066,2255,2266,1889,1245,675,356,149,-130,-441,-629,-734,-1000,-1528,-2066,-2253,-2028,-1673,-1459,-1374,-1223,-909,-523,-195,27,139,126,16,-70,9,253,504,610,574,514,493,443,271,7,-189,-160,110,485,789,904,806,540,207,-65,-183,-161,-119,-189,-386,-594,-688,-654,-597,-630,-779,-986,-1183,-1328,-1395,-1361,-1217,-998,-774,-606,-520,-495,-481,-425,-287,-81,125,240,217,87,-64,-155,-160,-102,-21,49,94,116,130,145,149,111,13,-122,-235,-279,-258,-211,-182,-188,-224,-278,-330,-359,-358,-342,-336,-351,-375,-391,-395,-386,-359,-308,-242,-185,-154,-138,-116,-78,-36,-3,22,48,83,122,152,170,177,172,153,112,54,-5,-49,-71,-83,-101,-132,-165,-192,-210,-223,-228,-221,-208,-197,-191,-183,-163,-137,-126,-140,-173,-202,-207,-188,-152,-114,-79,-49,-25,-9,-6,-18,-47,-86,-124,-151,-159,-148,-124,-88,-43,6,45,59,43,4,-43,-85,-116,-131,-127,-109,-86,-66,-52,-44,-48,-69,-102,-133,-152,-154,-141,-110,-64,-20},
            {31,-41,-73,5,82,20,-105,-78,95,139,-64,-208,-9,255,94,-234,333,2322,4694,5807,5323,4266,2844,-733,-7895,-16221,-19875,-14808,-3256,7999,13974,15338,15817,16980,16793,12970,6307,14,-3429,-3861,-2384,-16,2235,3009,1444,-1646,-4252,-5177,-5150,-5612,-6752,-7290,-6183,-4011,-2359,-2119,-2772,-3265,-3175,-2829,-2545,-2160,-1372,-294,588,981,1125,1478,2150,2779,2959,2682,2295,2113,2157,2252,2233,2002,1520,858,232,-141,-262,-325,-437,-467,-281,-78,-297,-1116,-2155,-2791,-2741,-2267,-1820,-1598,-1482,-1275,-905,-419,67,398,452,273,99,163,468,789,927,905,874,877,782,467,21,-297,-295,-16,314,496,489,377,258,172,111,59,10,-41,-107,-192,-296,-410,-535,-675,-827,-982,-1130,-1270,-1411,-1554,-1679,-1740,-1678,-1453,-1083,-659,-311,-139,-148,-243,-291,-210,-21,191,346,421,437,419,387,358,345,342,326,284,228,170,99,-11,-155,-288,-366,-390,-390,-376,-333,-265,-211,-219,-286,-369,-430,-456,-453,-418,-359,-303,-275,-268,-252,-213,-172,-151,-145,-133,-108,-83,-64,-36,16,86,150,192,212,209,182,128,60,-8,-65,-107,-130,-136,-130,-125,-129,-148,-182,-229,-276,-303,-295,-262,-226,-201,-185,-167,-142,-119,-106,-105,-108,-106,-98,-93,-97,-109,-118,-116,-107,-102,-103,-99,-82,-55,-37,-39,-57,-78,-86,-75,-52,-29,-18,-23,-40,-60,-75,-84,-90,-94,-99,-108,-118,-124,-123,-110,-90,-66,-47,-36,-33,-33,-29,-26,-28,-34,-35,-25,-8}
        },
        {    // H50e016a.wav
            {-6,5,16,8,-9,-3,20,18,-17,-32,3,35,0,-57,-36,47,60,-37,-88,22,128,20,-94,355,1577,2962,3656,3503,2983,2077,-233,-4667,-9881,-12762,-11054,-5567,640,5217,8230,10926,13437,14354,12466,8321,3807,562,-926,-971,-108,995,1547,1084,-75,-1134,-1690,-2103,-2904,-3993,-4681,-4498,-3752,-3163,-3090,-3243,-3149,-2723,-2290,-2133,-2152,-2005,-1495,-739,6,590,1012,1299,1452,1501,1533,1611,1695,1734,1782,1941,2168,2228,1923,1340,775,431,250,74,-132,-314,-502,-827,-1310,-1745,-1886,-1714,-1452,-1301,-1247,-1142,-916,-640,-407,-245,-142,-100,-108,-104,-13,154,304,355,326,297,301,286,194,44,-59,-10,210,519,786,901,823,594,300,32,-156,-260,-309,-343,-382,-431,-489,-562,-656,-771,-892,-1005,-1095,-1152,-1166,-1125,-1024,-869,-684,-508,-386,-342,-364,-400,-384,-286,-128,23,106,100,26,-70,-155,-209,-219,-179,-98,-4,67,97,91,59,4,-68,-143,-199,-227,-236,-243,-251,-255,-260,-276,-312,-362,-406,-428,-419,-382,-335,-298,-283,-279,-266,-237,-198,-160,-120,-75,-34,-8,4,18,47,81,104,114,120,129,132,120,95,64,30,-11,-56,-94,-113,-120,-129,-152,-187,-220,-238,-240,-230,-219,-211,-200,-184,-165,-150,-146,-149,-155,-160,-160,-146,-116,-82,-58,-47,-39,-30,-27,-44,-76,-106,-119,-120,-120,-116,-97,-60,-16,16,27,16,-11,-46,-74,-90,-99,-107,-114,-111,-97,-84,-77,-70,-61,-62,-91,-135,-151,-112,-40},
            {-72,1,83,28,-112,-108,81,173,-24,-233,-75,256,171,-254,77,2000,4698,6331,6167,5162,3805,324,-7285,-17102,-22726,-18596,-5918,7866,15974,17896,17777,18364,18130,14316,7212,227,-3621,-4081,-2642,-518,1594,2657,1586,-1377,-4435,-5985,-6233,-6551,-7460,-7919,-6792,-4470,-2556,-2108,-2669,-3092,-2893,-2496,-2340,-2223,-1657,-602,445,1076,1418,1862,2478,2913,2876,2527,2292,2365,2552,2566,2332,1942,1450,862,279,-127,-320,-446,-595,-627,-391,-83,-191,-973,-2084,-2862,-2950,-2554,-2112,-1833,-1625,-1335,-934,-474,-25,317,441,350,228,291,561,838,943,914,924,1022,1044,797,305,-187,-439,-402,-199,41,275,491,624,582,355,64,-137,-190,-171,-183,-258,-354,-442,-548,-703,-897,-1086,-1261,-1467,-1740,-2032,-2209,-2127,-1736,-1126,-494,-54,65,-96,-345,-460,-334,-37,263,450,533,584,634,652,601,496,388,310,265,241,222,176,64,-119,-318,-457,-501,-468,-400,-325,-268,-265,-328,-419,-472,-456,-406,-370,-361,-357,-340,-317,-291,-252,-195,-137,-102,-90,-81,-63,-42,-26,-5,31,83,138,186,226,251,238,175,75,-29,-109,-159,-183,-192,-190,-181,-173,-176,-202,-247,-293,-317,-312,-290,-270,-255,-231,-187,-134,-92,-74,-76,-86,-95,-98,-97,-97,-100,-104,-106,-105,-102,-96,-85,-66,-47,-40,-50,-72,-89,-91,-76,-49,-24,-12,-17,-36,-63,-92,-121,-145,-157,-157,-146,-132,-114,-91,-65,-42,-31,-33,-40,-40,-27,-7,10,12,0,-16,-23,-20,-11,-4}
        },
        {    // H50e024a.wav
            {0,-4,-5,2,11,5,-8,-4,14,15,-12,-27,-4,23,2,-43,-35,30,51,-18,-69,1,90,26,-74,227,1159,2325,3041,3089,2791,2181,484,-3020,-7525,-10613,-10153,-6270,-1163,3064,6057,8649,11101,12441,11576,8629,4937,1925,253,-149,328,1116,1539,1167,192,-752,-1268,-1591,-2204,-3159,-3953,-4095,-3648,-3122,-2903,-2910,-2828,-2540,-2233,-2117,-2130,-2005,-1568,-904,-244,267,633,906,1097,1217,1316,1438,1550,1591,1591,1664,1846,1990,1894,1529,1082,747,545,375,176,-33,-258,-574,-1005,-1420,-1628,-1577,-1407,-1288,-1247,-1192,-1053,-852,-652,-479,-328,-207,-138,-125,-133,-121,-69,23,151,284,368,352,239,101,34,103,299,552,764,848,774,582,351,144,-23,-168,-306,-423,-498,-532,-551,-593,-676,-787,-894,-967,-995,-984,-950,-907,-853,-776,-668,-542,-422,-338,-299,-297,-303,-289,-234,-141,-41,24,30,-19,-92,-160,-206,-224,-213,-170,-101,-28,21,21,-26,-97,-159,-197,-224,-258,-303,-341,-352,-335,-309,-292,-297,-321,-351,-372,-366,-331,-277,-222,-177,-146,-128,-120,-114,-100,-73,-42,-18,-2,11,29,48,64,77,90,103,109,104,87,59,19,-28,-73,-103,-117,-125,-139,-164,-195,-223,-244,-255,-255,-241,-216,-189,-165,-147,-131,-116,-109,-114,-126,-132,-125,-108,-91,-78,-65,-51,-38,-34,-45,-68,-96,-117,-125,-116,-96,-74,-53,-30,-9,1,-8,-34,-66,-93,-109,-116,-115,-111,-109,-108,-102,-85,-68,-65,-76,-79,-58,-20},
            {51,34,-82,-115,47,189,45,-217,-154,215,276,-182,-207,1371,4219,6495,6941,6192,5056,2092,-5272,-16249,-24587,-23072,-10757,5342,16583,20204,19880,19702,19420,16117,9083,1337,-3502,-4485,-3078,-865,1353,2706,2031,-849,-4357,-6541,-7089,-7329,-8200,-8906,-8014,-5479,-2946,-1982,-2492,-3138,-2990,-2330,-1887,-1779,-1499,-744,176,828,1267,1888,2761,3403,3332,2690,2117,2069,2416,2709,2661,2275,1647,884,179,-241,-357,-411,-584,-716,-524,-114,-38,-723,-1929,-2931,-3221,-2910,-2438,-2063,-1734,-1336,-882,-450,-84,179,279,229,201,388,766,1076,1107,944,870,1027,1234,1168,683,-51,-691,-953,-751,-203,428,850,885,568,122,-197,-273,-172,-58,-50,-158,-308,-429,-500,-570,-710,-960,-1304,-1677,-2005,-2227,-2284,-2116,-1700,-1114,-536,-158,-64,-183,-345,-392,-261,7,312,557,698,746,730,675,594,506,435,391,366,342,298,210,61,-140,-340,-476,-521,-494,-430,-357,-301,-290,-339,-415,-468,-472,-449,-430,-414,-384,-339,-298,-267,-222,-152,-79,-44,-52,-67,-59,-31,-5,14,43,94,161,229,282,305,282,208,100,-14,-108,-170,-204,-220,-228,-233,-234,-228,-224,-239,-278,-323,-347,-342,-320,-294,-261,-210,-144,-88,-61,-63,-75,-81,-81,-87,-103,-119,-122,-108,-81,-52,-29,-14,-14,-32,-67,-100,-115,-107,-86,-63,-42,-20,-2,1,-19,-62,-115,-163,-190,-191,-167,-129,-93,-68,-57,-54,-54,-55,-55,-49,-30,3,36,50,36,8,-13,-19,-22,-32,-40,-34,-13}
        },
        {    // H50e032a.wav
            {-3,-3,0,-1,-2,2,9,5,-5,-4,10,13,-6,-22,-8,17,8,-29,-33,14,43,0,-51,-16,58,32,-49,134,821,1783,2492,2695,2588,2239,1064,-1650,-5521,-8714,-9239,-6703,-2591,1253,4183,6692,9097,10744,10647,8643,5664,2957,1254,619,751,1205,1471,1191,436,-359,-847,-1142,-1627,-2438,-3243,-3588,-3376,-2941,-2658,-2599,-2564,-2401,-2180,-2052,-2023,-1922,-1594,-1065,-499,-27,334,615,816,932,1005,1098,1221,1331,1421,1555,1772,1976,1995,1761,1388,1049,812,632,450,252,1,-375,-883,-1378,-1649,-1623,-1436,-1292,-1262,-1256,-1164,-977,-767,-596,-479,-409,-383,-378,-344,-241,-77,94,222,299,340,356,336,274,200,175,256,448,680,842,845,674,395,104,-126,-274,-361,-416,-461,-510,-573,-660,-764,-858,-904,-884,-820,-759,-744,-774,-811,-804,-725,-588,-433,-307,-235,-215,-227,-240,-232,-188,-117,-42,4,7,-28,-80,-131,-181,-232,-274,-282,-236,-152,-78,-62,-115,-201,-275,-314,-331,-344,-355,-354,-334,-305,-279,-263,-258,-261,-267,-265,-246,-209,-167,-130,-101,-77,-61,-56,-61,-67,-63,-49,-28,-6,14,36,60,80,90,87,72,52,29,1,-35,-74,-104,-119,-124,-134,-156,-187,-216,-234,-240,-236,-221,-197,-170,-146,-127,-108,-91,-81,-83,-95,-107,-109,-101,-92,-89,-89,-85,-72,-55,-45,-47,-59,-77,-95,-110,-115,-106,-84,-60,-43,-34,-30,-32,-48,-81,-117,-139,-138,-124,-110,-100,-91,-82,-77,-73,-63,-41,-14},
            {-13,-137,-54,158,149,-134,-251,68,348,27,-379,498,3102,5992,7369,7146,6336,4300,-1730,-12737,-23969,-27105,-17846,-825,14236,21246,21815,20959,20541,18255,12150,4076,-2065,-4285,-3592,-1785,332,2279,2838,900,-2879,-6318,-7932,-8290,-8766,-9476,-9175,-7146,-4426,-2747,-2639,-3092,-2987,-2316,-1787,-1647,-1401,-641,325,931,1178,1624,2552,3481,3701,3140,2438,2195,2387,2582,2516,2245,1844,1253,501,-152,-468,-534,-614,-734,-641,-258,2,-398,-1484,-2664,-3312,-3309,-2965,-2548,-2066,-1468,-845,-357,-49,130,198,153,103,255,677,1146,1344,1211,1022,1071,1311,1371,930,51,-833,-1247,-1001,-281,505,972,953,540,-3,-409,-544,-447,-261,-118,-77,-121,-199,-284,-403,-626,-1007,-1508,-1987,-2266,-2255,-2004,-1643,-1284,-967,-698,-494,-385,-369,-383,-335,-165,113,422,664,781,773,689,591,521,486,470,447,411,369,329,267,143,-59,-297,-493,-595,-604,-547,-447,-328,-235,-219,-287,-396,-488,-537,-545,-519,-457,-370,-284,-215,-153,-86,-28,-5,-23,-54,-68,-59,-36,-1,52,117,179,227,265,293,293,244,148,34,-67,-141,-195,-236,-265,-275,-263,-242,-231,-247,-287,-333,-363,-372,-362,-335,-289,-229,-169,-120,-86,-71,-76,-98,-123,-130,-118,-101,-92,-86,-69,-40,-14,-6,-16,-35,-55,-76,-90,-93,-85,-74,-67,-60,-48,-35,-40,-73,-125,-168,-179,-155,-117,-87,-76,-76,-76,-71,-64,-59,-51,-36,-16,2,13,13,4,-9,-19,-20,-14,-8,-5,-5,-2,1,2}
        },
        {    // H50e040a.wav
            {3,1,-3,-4,-1,-1,-2,0,5,4,-3,-4,7,12,-2,-18,-10,13,11,-19,-31,3,34,7,-41,-26,39,38,-31,64,560,1352,2029,2327,2361,2222,1468,-594,-3903,-7091,-8331,-6869,-3620,-162,2679,5111,7437,9227,9638,8359,6026,3691,2062,1271,1112,1282,1426,1239,674,-1,-484,-780,-1176,-1849,-2603,-3040,-2986,-2658,-2405,-2358,-2368,-2260,-2054,-1902,-1858,-1798,-1565,-1154,-709,-355,-88,158,409,636,829,1013,1194,1336,1429,1533,1716,1930,2028,1905,1604,1260,966,723,505,287,20,-371,-890,-1394,-1675,-1650,-1444,-1263,-1207,-1227,-1229,-1177,-1071,-903,-674,-441,-296,-275,-303,-268,-122,85,279,421,509,524,443,284,133,101,236,482,712,805,711,469,179,-55,-181,-221,-243,-310,-432,-577,-698,-775,-805,-799,-767,-728,-705,-712,-743,-772,-775,-735,-654,-547,-432,-331,-256,-207,-179,-164,-149,-122,-81,-32,1,3,-34,-95,-163,-223,-268,-297,-311,-308,-294,-276,-265,-268,-280,-293,-300,-305,-315,-332,-347,-349,-330,-289,-236,-186,-153,-140,-137,-137,-138,-139,-137,-125,-97,-62,-34,-20,-19,-21,-22,-19,-13,-5,9,25,40,44,32,6,-25,-54,-79,-103,-125,-144,-157,-164,-167,-167,-167,-170,-177,-188,-194,-189,-171,-144,-114,-85,-62,-49,-51,-67,-90,-109,-116,-114,-107,-100,-92,-79,-62,-47,-42,-49,-68,-95,-125,-147,-152,-137,-112,-86,-66,-52,-47,-53,-71,-95,-120,-138,-148,-146,-130,-106,-82,-64,-48,-29,-9},
            {-122,98,217,2,-268,-132,275,268,-262,-220,1550,4582,7041,7823,7490,6328,2319,-6956,-19616,-28171,-25099,-10358,7716,19755,23132,22019,20856,19569,15508,8310,1076,-2982,-3538,-2340,-665,1249,2767,2416,-488,-4564,-7584,-8763,-9141,-9700,-9924,-8717,-6249,-4094,-3443,-3793,-3759,-2825,-1752,-1348,-1383,-1040,-75,936,1494,1848,2521,3434,3899,3508,2701,2269,2462,2825,2831,2419,1839,1242,623,55,-299,-435,-557,-759,-821,-518,-79,-99,-909,-2162,-3156,-3500,-3336,-2974,-2517,-1901,-1169,-518,-105,87,152,150,142,251,574,1016,1336,1390,1300,1292,1384,1316,838,38,-671,-905,-633,-141,274,510,600,535,255,-210,-656,-848,-731,-456,-212,-78,-36,-83,-263,-606,-1074,-1582,-2019,-2260,-2196,-1819,-1285,-836,-632,-642,-710,-704,-593,-413,-194,48,282,456,534,529,502,508,558,612,620,560,459,368,325,323,311,224,32,-233,-484,-632,-643,-554,-432,-330,-266,-246,-270,-331,-410,-482,-529,-540,-511,-439,-334,-216,-104,-15,35,32,-13,-66,-84,-54,0,44,66,82,109,152,202,244,268,258,204,107,-11,-117,-191,-232,-253,-261,-251,-227,-209,-223,-270,-327,-365,-376,-369,-349,-313,-259,-195,-139,-104,-93,-107,-136,-158,-152,-117,-76,-57,-64,-76,-73,-54,-35,-30,-39,-56,-67,-66,-54,-46,-54,-75,-94,-99,-95,-96,-106,-119,-123,-116,-102,-85,-71,-65,-69,-75,-73,-59,-40,-24,-15,-10,-8,-15,-30,-47,-54,-45,-27,-9,3,11,16,17,11,2,-4,-4}
        },
        {    // H50e048a.wav
            {-3,-1,3,4,0,-1,-1,-1,-2,1,5,5,-1,-3,5,11,2,-12,-7,12,13,-12,-25,-1,28,10,-32,-26,31,42,-18,26,395,1053,1679,2021,2146,2150,1687,96,-2753,-5836,-7499,-6792,-4217,-1100,1646,4001,6197,7969,8638,7862,6065,4101,2610,1758,1416,1384,1420,1272,838,267,-201,-511,-853,-1392,-2025,-2454,-2507,-2317,-2154,-2139,-2156,-2050,-1839,-1684,-1681,-1745,-1697,-1451,-1067,-650,-252,116,435,675,846,999,1159,1294,1384,1473,1621,1804,1900,1802,1527,1190,890,652,456,263,8,-381,-889,-1365,-1613,-1577,-1403,-1300,-1343,-1425,-1400,-1220,-946,-672,-468,-373,-380,-417,-365,-162,134,384,494,489,459,450,424,330,183,70,83,231,438,590,600,451,197,-65,-248,-318,-312,-308,-370,-501,-649,-750,-776,-747,-705,-681,-679,-688,-697,-700,-692,-661,-599,-511,-416,-329,-251,-177,-110,-60,-36,-32,-37,-43,-53,-68,-91,-125,-176,-240,-306,-354,-376,-380,-378,-372,-356,-332,-310,-301,-308,-320,-324,-317,-302,-279,-247,-206,-164,-131,-116,-113,-111,-102,-91,-87,-89,-88,-74,-47,-19,4,19,26,22,5,-20,-41,-49,-45,-37,-36,-44,-63,-91,-120,-144,-158,-163,-161,-154,-142,-127,-114,-108,-113,-129,-149,-162,-156,-131,-96,-64,-41,-28,-25,-33,-54,-82,-105,-114,-108,-93,-78,-68,-63,-62,-64,-70,-82,-102,-126,-147,-161,-163,-153,-133,-108,-84,-66,-55,-54,-63,-82,-103,-117,-119,-115,-111,-104,-85,-51,-16},
            {111,114,-98,-218,33,325,95,-388,114,2365,5439,7615,8287,7960,6020,-64,-11501,-24082,-29325,-21596,-4120,13227,22499,23538,21443,19760,17590,12814,6069,375,-2267,-2433,-1554,-67,1979,3409,2393,-1384,-5945,-8916,-9789,-9770,-9753,-9296,-7760,-5719,-4506,-4552,-4845,-4250,-2887,-1799,-1500,-1409,-778,310,1223,1775,2434,3469,4344,4305,3389,2486,2351,2831,3194,2989,2354,1607,883,223,-237,-412,-463,-625,-848,-816,-433,-105,-378,-1342,-2525,-3371,-3681,-3559,-3114,-2387,-1509,-751,-323,-189,-152,-60,100,309,581,923,1265,1507,1611,1603,1483,1180,655,31,-421,-489,-221,114,275,264,248,304,297,41,-439,-884,-1047,-900,-602,-317,-123,-66,-214,-595,-1125,-1637,-1983,-2083,-1915,-1518,-1031,-654,-521,-589,-688,-676,-543,-350,-138,95,326,485,506,401,261,194,248,397,559,656,651,560,436,322,224,120,-13,-174,-336,-465,-539,-553,-508,-415,-308,-234,-228,-286,-368,-435,-475,-494,-490,-446,-355,-238,-127,-41,19,52,48,11,-32,-45,-17,27,55,61,67,95,142,188,216,220,194,128,22,-98,-192,-237,-245,-241,-233,-213,-181,-166,-195,-261,-323,-352,-350,-336,-318,-284,-231,-171,-125,-107,-115,-137,-153,-145,-113,-77,-62,-71,-86,-90,-81,-72,-70,-73,-76,-75,-69,-58,-49,-55,-79,-108,-125,-124,-111,-100,-93,-90,-88,-86,-81,-74,-68,-63,-57,-47,-34,-22,-11,1,8,3,-18,-44,-62,-68,-66,-59,-44,-23,-6,3,8,14,18,13,1,-7,-5}
        },
        {    // H50e056a.wav
            {-1,-2,-2,1,3,1,-1,-1,2,1,-2,-2,3,5,0,-3,2,8,1,-10,-5,11,12,-10,-24,-5,22,11,-26,-24,24,38,-12,17,320,884,1448,1793,1968,2052,1734,392,-2162,-5082,-6869,-6534,-4362,-1489,1165,3424,5439,7038,7714,7186,5775,4161,2873,2055,1624,1452,1393,1264,944,486,52,-284,-620,-1067,-1569,-1927,-2012,-1919,-1856,-1917,-2005,-1973,-1813,-1659,-1615,-1636,-1577,-1352,-996,-593,-196,173,477,675,782,868,986,1112,1197,1246,1319,1441,1544,1529,1365,1108,839,596,381,176,-60,-385,-822,-1290,-1624,-1701,-1544,-1304,-1136,-1078,-1059,-990,-851,-690,-566,-484,-395,-249,-42,172,333,417,448,458,446,384,249,64,-95,-143,-35,190,426,551,497,289,21,-197,-298,-289,-236,-224,-304,-461,-624,-721,-726,-675,-630,-629,-665,-699,-700,-666,-610,-548,-484,-421,-359,-296,-227,-153,-81,-26,1,-1,-29,-72,-115,-144,-158,-177,-225,-299,-369,-403,-396,-373,-360,-368,-386,-402,-403,-384,-342,-286,-233,-199,-191,-198,-205,-197,-173,-142,-116,-98,-83,-66,-49,-36,-28,-23,-18,-16,-14,-9,1,6,-4,-29,-59,-84,-103,-117,-126,-130,-130,-134,-143,-153,-156,-150,-138,-122,-106,-93,-86,-86,-90,-97,-104,-112,-116,-112,-95,-70,-41,-16,-1,-1,-14,-39,-70,-98,-114,-112,-100,-89,-86,-90,-92,-94,-100,-113,-128,-142,-158,-173,-178,-167,-148,-128,-109,-85,-58,-40,-40,-51,-58,-67,-89,-119,-127,-92,-32},
            {130,-166,-254,84,367,41,-443,214,2609,5687,7869,8707,8437,5912,-1416,-13831,-25988,-29305,-19397,-973,15706,23533,23353,20517,18291,15732,11113,5290,818,-1103,-1378,-1006,233,2465,4145,3030,-1236,-6394,-9789,-10764,-10466,-9851,-8761,-6989,-5312,-4770,-5244,-5467,-4584,-3158,-2303,-2206,-2012,-1075,238,1221,1867,2749,3985,4845,4616,3569,2722,2717,3235,3525,3224,2497,1623,759,49,-331,-398,-435,-661,-912,-855,-494,-296,-699,-1642,-2671,-3407,-3758,-3733,-3270,-2382,-1346,-581,-287,-310,-346,-228,23,340,704,1105,1492,1778,1879,1734,1331,755,191,-167,-233,-85,118,251,299,317,337,300,96,-300,-756,-1057,-1082,-883,-619,-418,-339,-413,-663,-1062,-1494,-1811,-1911,-1774,-1451,-1049,-699,-498,-439,-429,-388,-317,-252,-178,-32,200,431,538,471,292,109,10,40,198,425,615,676,591,424,253,112,-6,-117,-226,-332,-430,-506,-531,-486,-383,-274,-211,-219,-282,-361,-424,-459,-464,-437,-375,-283,-179,-84,-5,56,92,91,51,-5,-40,-34,1,35,53,64,89,131,176,200,188,136,43,-77,-195,-276,-303,-288,-256,-218,-174,-133,-119,-151,-215,-276,-308,-312,-297,-271,-236,-200,-170,-147,-127,-111,-105,-106,-101,-84,-70,-74,-92,-103,-99,-94,-103,-120,-123,-108,-86,-76,-82,-98,-121,-143,-152,-140,-109,-77,-58,-54,-62,-75,-87,-89,-77,-59,-44,-36,-30,-23,-15,-5,10,22,20,-1,-28,-49,-60,-70,-77,-73,-52,-26,-9,1,13,21,10,-22,-48,-45,-17}
        },
        {    // H50e064a.wav
            {-5,-3,0,0,-1,-1,0,0,-1,0,1,-1,-4,-3,2,3,-1,-3,2,6,-2,-10,-3,13,10,-13,-24,-3,18,4,-24,-11,33,32,-19,28,336,856,1350,1664,1869,1986,1640,249,-2265,-5002,-6561,-6104,-3967,-1205,1338,3455,5222,6497,6936,6405,5212,3887,2807,2077,1651,1459,1388,1281,1028,654,263,-93,-457,-869,-1264,-1529,-1635,-1679,-1766,-1875,-1885,-1723,-1473,-1294,-1267,-1322,-1325,-1198,-946,-607,-217,162,435,544,534,526,602,741,871,968,1071,1200,1302,1299,1168,967,764,574,355,62,-296,-663,-966,-1153,-1214,-1179,-1106,-1050,-1037,-1047,-1023,-924,-757,-583,-461,-382,-279,-93,154,365,449,389,244,98,11,-8,16,37,26,0,9,90,216,305,285,155,-18,-153,-208,-201,-183,-206,-293,-428,-561,-645,-665,-650,-641,-655,-676,-673,-627,-551,-471,-408,-369,-347,-324,-285,-226,-152,-83,-35,-19,-34,-73,-124,-174,-212,-237,-257,-283,-318,-354,-382,-396,-401,-401,-399,-395,-384,-364,-331,-287,-240,-201,-178,-170,-172,-174,-170,-158,-136,-107,-77,-47,-21,1,15,17,7,-12,-33,-49,-58,-61,-62,-69,-86,-111,-137,-161,-179,-188,-185,-169,-148,-131,-122,-118,-111,-99,-88,-80,-74,-71,-72,-77,-85,-90,-90,-85,-74,-57,-34,-11,5,10,2,-17,-47,-81,-112,-133,-140,-136,-125,-113,-105,-105,-108,-113,-123,-143,-167,-184,-187,-180,-169,-154,-129,-97,-68,-51,-39,-25,-21,-41,-79,-100,-79,-29},
            {-77,-183,34,286,60,-404,30,2127,5178,7711,9011,9014,6579,-652,-12986,-25381,-29405,-20299,-2160,14926,23342,23266,19963,17264,14811,10880,5826,1743,-233,-801,-740,335,2702,4825,4191,21,-5591,-9679,-11091,-10782,-9953,-8788,-7158,-5656,-5161,-5554,-5649,-4657,-3206,-2505,-2755,-2933,-2146,-657,686,1642,2675,3953,4838,4665,3713,3005,3161,3795,4093,3691,2823,1851,966,292,-55,-154,-306,-674,-1019,-976,-597,-401,-825,-1768,-2768,-3484,-3851,-3838,-3340,-2395,-1365,-708,-561,-652,-617,-336,65,442,772,1104,1450,1742,1855,1688,1252,700,242,7,-23,53,164,288,407,476,441,256,-89,-529,-913,-1079,-990,-772,-609,-592,-695,-872,-1111,-1390,-1623,-1710,-1627,-1436,-1204,-957,-703,-472,-300,-184,-97,-30,5,23,77,202,358,447,405,253,75,-39,-38,89,294,484,562,497,338,175,58,-26,-116,-230,-352,-453,-507,-497,-423,-308,-202,-155,-188,-276,-372,-439,-462,-442,-391,-320,-240,-156,-71,15,88,130,128,83,16,-40,-61,-43,-7,23,45,73,117,164,184,161,91,-15,-142,-263,-347,-373,-354,-310,-254,-186,-123,-94,-119,-176,-225,-244,-241,-235,-228,-215,-195,-170,-139,-103,-75,-69,-82,-89,-78,-62,-65,-88,-112,-126,-137,-154,-166,-154,-124,-103,-111,-142,-174,-193,-195,-181,-148,-105,-67,-50,-54,-68,-83,-90,-83,-61,-37,-25,-29,-36,-35,-24,-6,13,25,24,8,-15,-33,-44,-55,-67,-72,-62,-44,-29,-21,-14,-10,-18,-46,-76,-83,-58,-20}
        },
        {    // H50e072a.wav
            {-3,-4,-3,0,0,-2,-2,1,2,0,-1,0,0,-2,-3,0,3,0,-5,-3,4,4,-4,-7,4,12,0,-21,-19,5,14,-6,-16,12,38,4,-33,94,470,966,1377,1660,1891,1934,1280,-522,-3188,-5576,-6429,-5319,-2873,-131,2234,4082,5437,6181,6165,5464,4401,3333,2467,1878,1573,1489,1469,1350,1076,720,357,-27,-472,-922,-1234,-1325,-1282,-1279,-1392,-1525,-1531,-1379,-1185,-1082,-1099,-1167,-1204,-1165,-1023,-749,-368,10,242,276,203,175,278,484,702,866,962,1016,1060,1098,1082,934,628,245,-61,-191,-188,-196,-326,-573,-849,-1066,-1177,-1174,-1071,-913,-762,-664,-616,-566,-456,-276,-70,90,145,94,-8,-86,-91,-33,40,80,71,32,-6,-19,1,45,93,122,113,66,5,-35,-43,-48,-99,-222,-388,-536,-622,-644,-631,-611,-600,-599,-597,-576,-520,-437,-357,-311,-304,-312,-309,-288,-250,-198,-138,-83,-59,-78,-128,-184,-225,-250,-271,-297,-330,-365,-393,-405,-390,-352,-308,-285,-296,-330,-356,-349,-306,-245,-190,-154,-137,-133,-134,-131,-117,-92,-64,-42,-24,-9,3,8,-1,-22,-52,-84,-111,-130,-139,-142,-143,-147,-154,-163,-170,-174,-173,-164,-148,-127,-107,-92,-83,-77,-70,-64,-61,-63,-68,-73,-76,-77,-74,-65,-52,-36,-21,-11,-4,-2,-9,-28,-56,-86,-114,-137,-153,-156,-146,-131,-121,-120,-122,-125,-130,-139,-152,-163,-172,-176,-174,-162,-142,-120,-97,-71,-41,-20,-18,-33,-44,-36,-14},
            {-186,-9,268,173,-316,-334,1090,3840,6743,8778,9545,8124,2408,-8674,-21712,-28992,-24146,-8378,9679,21037,23265,20442,17373,15135,12141,7778,3496,757,-533,-998,-319,2054,4989,5739,2570,-3186,-8297,-10660,-10668,-9815,-8833,-7641,-6441,-5900,-6115,-6153,-5136,-3477,-2478,-2707,-3299,-3056,-1827,-401,716,1823,3219,4416,4617,3830,3022,3072,3847,4504,4444,3723,2691,1611,705,219,177,206,-106,-695,-1078,-989,-752,-906,-1593,-2500,-3285,-3830,-4044,-3717,-2777,-1597,-798,-677,-935,-1035,-723,-156,391,800,1113,1374,1558,1605,1480,1201,843,505,257,121,101,205,401,588,643,517,247,-117,-532,-905,-1081,-974,-709,-550,-662,-970,-1275,-1461,-1551,-1591,-1569,-1462,-1298,-1122,-936,-711,-455,-229,-77,13,76,126,159,196,268,366,428,392,256,78,-64,-110,-37,135,333,459,451,324,156,19,-66,-133,-226,-353,-475,-534,-496,-376,-231,-122,-86,-129,-229,-347,-438,-468,-438,-373,-301,-233,-161,-79,7,82,133,150,129,73,2,-50,-61,-40,-13,6,34,87,150,181,151,67,-44,-164,-280,-372,-415,-401,-353,-298,-244,-189,-142,-125,-141,-166,-176,-168,-163,-170,-179,-176,-155,-122,-86,-56,-42,-42,-45,-42,-40,-54,-84,-114,-135,-155,-179,-194,-182,-151,-132,-149,-188,-223,-235,-227,-204,-164,-115,-77,-63,-74,-91,-103,-102,-86,-56,-22,-3,-6,-22,-31,-23,-3,15,24,18,-1,-22,-33,-34,-31,-32,-35,-34,-31,-32,-38,-42,-42,-46,-64,-89,-99,-81,-46,-13}
        },
        {    // H50e080a.wav
            {1,0,-2,-2,0,0,-1,-1,1,2,1,0,1,1,-1,-2,1,5,3,-3,-3,4,7,0,-6,2,13,5,-15,-20,1,20,10,-5,9,31,6,-43,25,325,787,1221,1546,1821,1974,1570,89,-2411,-4980,-6306,-5675,-3456,-674,1804,3666,4942,5645,5719,5222,4386,3477,2653,2004,1616,1521,1591,1578,1323,897,489,188,-78,-393,-709,-904,-958,-991,-1123,-1317,-1416,-1339,-1169,-1063,-1086,-1178,-1257,-1293,-1274,-1146,-854,-443,-73,108,95,19,18,144,370,643,902,1064,1056,892,689,580,602,666,650,504,272,26,-194,-399,-605,-807,-980,-1091,-1113,-1032,-858,-639,-455,-376,-409,-491,-536,-491,-362,-194,-43,51,69,33,-12,-23,2,36,54,56,56,53,34,7,3,46,119,169,151,55,-101,-282,-451,-569,-614,-600,-563,-534,-522,-518,-515,-502,-470,-412,-343,-295,-287,-307,-326,-326,-309,-281,-237,-178,-118,-87,-102,-152,-213,-271,-324,-368,-387,-371,-330,-286,-257,-245,-242,-254,-285,-330,-365,-365,-323,-259,-197,-148,-112,-87,-75,-74,-75,-71,-62,-55,-53,-52,-45,-35,-34,-54,-92,-134,-167,-184,-189,-182,-165,-144,-129,-129,-138,-145,-141,-130,-117,-105,-90,-72,-58,-54,-58,-62,-59,-53,-50,-52,-56,-58,-57,-52,-46,-37,-28,-21,-19,-22,-30,-42,-58,-79,-104,-130,-151,-160,-158,-150,-138,-127,-117,-107,-104,-109,-124,-143,-160,-168,-166,-155,-139,-121,-99,-73,-47,-28,-17,-12,-8,-2},
            {-175,112,306,11,-439,-32,1872,4769,7545,9395,9585,6492,-1731,-14194,-25298,-27494,-17597,-410,14756,21630,21040,17957,15716,13859,10743,6496,2727,382,-823,-1013,459,3538,6138,5465,886,-5138,-9334,-10468,-9683,-8559,-7639,-6839,-6370,-6516,-6816,-6277,-4652,-2997,-2523,-3143,-3598,-2958,-1536,-163,935,2115,3372,4055,3731,2942,2702,3366,4297,4676,4297,3497,2595,1720,1021,677,604,432,-53,-594,-801,-709,-788,-1364,-2255,-3052,-3572,-3840,-3786,-3228,-2253,-1351,-994,-1140,-1289,-1044,-468,112,506,781,1047,1290,1418,1381,1203,931,615,325,147,139,298,544,753,807,663,370,11,-358,-686,-890,-891,-728,-583,-642,-922,-1276,-1540,-1654,-1644,-1548,-1405,-1264,-1147,-1009,-783,-478,-204,-54,-6,32,103,177,227,282,372,457,452,328,145,-14,-106,-123,-52,106,294,411,392,261,97,-39,-144,-239,-337,-425,-481,-480,-407,-273,-126,-32,-35,-125,-254,-366,-427,-433,-397,-341,-275,-203,-122,-35,46,109,143,145,112,52,-11,-47,-47,-25,-3,19,56,106,142,134,74,-18,-123,-233,-336,-407,-427,-400,-352,-297,-240,-186,-150,-144,-153,-152,-137,-124,-125,-134,-135,-124,-105,-81,-50,-20,-4,-6,-11,-14,-25,-55,-98,-132,-152,-169,-186,-190,-173,-151,-157,-197,-242,-262,-251,-224,-192,-154,-115,-92,-94,-110,-122,-117,-98,-69,-36,-10,-1,-8,-16,-10,9,27,34,24,3,-21,-38,-41,-33,-22,-16,-13,-10,-9,-14,-22,-29,-39,-58,-87,-109,-106,-77,-39,-10}
        },
        {    // H50e088a.wav
            {0,1,-1,-2,-2,0,0,-2,-2,1,2,1,-1,-1,-1,-3,-3,1,4,1,-4,-3,3,3,-5,-9,1,11,3,-14,-13,9,21,8,-3,14,23,-17,-56,52,390,858,1280,1605,1880,1953,1346,-373,-2962,-5347,-6275,-5232,-2774,12,2307,3890,4875,5356,5330,4858,4120,3319,2576,1971,1590,1482,1553,1586,1412,1049,653,351,129,-99,-370,-646,-882,-1080,-1258,-1391,-1420,-1334,-1202,-1133,-1181,-1317,-1458,-1521,-1448,-1216,-863,-486,-202,-77,-85,-121,-63,146,454,715,793,686,556,595,847,1153,1294,1169,856,505,219,17,-126,-260,-441,-698,-977,-1151,-1119,-901,-641,-500,-546,-731,-933,-1022,-920,-645,-305,-41,70,53,-2,-22,2,37,56,57,60,80,117,154,167,145,98,52,31,34,33,-6,-102,-247,-412,-556,-641,-647,-584,-490,-415,-387,-402,-429,-438,-416,-371,-323,-296,-305,-342,-377,-377,-328,-250,-179,-143,-143,-170,-211,-260,-303,-325,-321,-302,-278,-253,-228,-206,-201,-223,-268,-317,-348,-348,-319,-267,-207,-152,-113,-90,-79,-72,-67,-67,-75,-88,-100,-105,-105,-103,-106,-117,-137,-163,-185,-197,-193,-175,-151,-131,-121,-121,-126,-125,-116,-100,-82,-69,-61,-61,-67,-74,-75,-66,-50,-35,-30,-34,-42,-50,-59,-68,-72,-67,-53,-39,-32,-35,-41,-48,-57,-73,-98,-125,-146,-157,-160,-157,-145,-125,-103,-88,-87,-94,-101,-108,-120,-138,-152,-155,-149,-139,-125,-104,-72,-41,-22,-15,-12,-5},
            {-144,131,267,-47,-416,87,1981,4819,7647,9587,9509,5584,-3475,-15732,-25172,-25209,-14319,1882,14894,20032,19022,16509,14998,13596,10712,6574,2753,261,-909,-736,1142,4195,6238,4917,135,-5540,-9152,-9807,-8749,-7537,-6752,-6334,-6333,-6748,-7003,-6301,-4675,-3220,-2924,-3510,-3780,-3012,-1587,-221,962,2220,3369,3748,3138,2302,2270,3211,4304,4673,4183,3282,2399,1714,1316,1224,1211,910,236,-439,-710,-650,-732,-1286,-2176,-3051,-3671,-3913,-3646,-2857,-1892,-1301,-1318,-1594,-1568,-1053,-350,171,445,640,857,1041,1113,1077,963,759,468,187,65,177,458,753,918,876,645,303,-58,-370,-592,-687,-651,-566,-569,-749,-1060,-1366,-1565,-1638,-1605,-1490,-1332,-1196,-1097,-964,-717,-386,-114,-3,-10,-6,68,171,254,327,409,465,427,285,108,-34,-117,-141,-88,53,233,355,358,258,116,-29,-171,-299,-390,-432,-436,-410,-345,-237,-118,-47,-59,-136,-231,-313,-371,-398,-388,-343,-280,-211,-132,-40,51,114,132,111,71,28,-8,-25,-22,-5,14,35,63,97,112,88,24,-64,-160,-256,-342,-399,-418,-405,-374,-325,-257,-185,-140,-135,-150,-157,-149,-138,-132,-123,-105,-83,-67,-52,-30,-3,15,17,8,-6,-27,-60,-94,-119,-137,-157,-179,-188,-181,-175,-190,-224,-253,-259,-244,-223,-198,-170,-144,-131,-133,-138,-135,-121,-100,-74,-43,-18,-8,-12,-16,-5,16,35,39,25,1,-24,-42,-46,-40,-28,-14,-2,6,10,8,3,-4,-22,-52,-87,-106,-98,-67,-32,-8}
        },
        {    // H50e096a.wav
            {0,1,-1,-2,-2,0,1,-1,-1,1,2,1,0,1,1,-1,-2,1,5,3,-2,-2,4,5,-3,-10,-3,8,5,-10,-10,13,29,15,-7,2,23,-1,-54,-6,264,715,1181,1561,1872,2021,1609,163,-2269,-4807,-6185,-5648,-3482,-700,1741,3449,4500,5068,5226,4998,4464,3746,2966,2264,1789,1616,1647,1657,1477,1129,762,477,247,3,-263,-510,-733,-979,-1265,-1510,-1604,-1528,-1390,-1316,-1344,-1422,-1494,-1533,-1504,-1333,-983,-542,-202,-94,-159,-199,-74,165,350,379,338,409,692,1099,1423,1509,1354,1083,828,645,502,330,79,-245,-574,-806,-874,-809,-716,-704,-805,-967,-1118,-1200,-1181,-1045,-814,-556,-350,-228,-159,-95,-25,27,55,77,114,153,172,174,188,232,284,298,245,129,-15,-134,-180,-146,-87,-92,-218,-426,-611,-685,-639,-532,-431,-366,-338,-338,-358,-380,-390,-381,-369,-369,-379,-380,-356,-311,-264,-231,-218,-223,-239,-256,-261,-247,-221,-203,-205,-220,-233,-231,-224,-225,-240,-262,-279,-283,-271,-244,-204,-156,-116,-95,-96,-109,-120,-122,-117,-114,-117,-128,-142,-155,-166,-176,-186,-191,-188,-175,-158,-143,-133,-129,-127,-125,-121,-113,-99,-80,-61,-49,-43,-42,-46,-54,-65,-70,-64,-48,-31,-25,-30,-42,-53,-64,-72,-76,-73,-64,-54,-50,-52,-57,-61,-66,-76,-93,-115,-135,-146,-147,-139,-125,-107,-90,-76,-68,-65,-64,-68,-83,-107,-134,-152,-158,-150,-132,-105,-75,-50,-34,-26,-17,-6},
            {-127,91,229,-1,-347,-45,1486,4083,7013,9322,9664,6176,-2284,-13869,-23111,-23995,-14868,-395,11918,17566,17619,16005,15072,14128,11617,7533,3373,473,-805,-486,1415,4211,6014,4833,505,-4815,-8415,-9219,-8181,-6865,-6090,-5887,-6112,-6582,-6813,-6235,-4910,-3703,-3415,-3843,-4008,-3272,-1922,-579,609,1857,3021,3499,3022,2220,2069,2846,3882,4342,4008,3240,2438,1795,1422,1369,1454,1299,721,-7,-462,-575,-686,-1117,-1841,-2608,-3210,-3521,-3409,-2839,-2072,-1551,-1483,-1615,-1531,-1108,-582,-191,87,396,737,957,952,786,585,406,249,140,141,278,505,732,867,850,678,405,104,-173,-397,-525,-527,-458,-460,-642,-964,-1279,-1475,-1552,-1552,-1480,-1337,-1174,-1054,-952,-774,-489,-200,-39,-13,-12,50,152,234,294,370,449,457,344,150,-36,-153,-185,-133,0,174,313,354,295,178,36,-117,-267,-384,-439,-432,-381,-303,-206,-115,-66,-81,-146,-225,-294,-343,-365,-356,-321,-277,-230,-170,-87,9,84,115,102,66,26,-3,-11,0,19,31,40,55,77,89,71,22,-48,-133,-233,-329,-394,-411,-394,-367,-331,-276,-206,-150,-131,-140,-150,-151,-150,-152,-142,-112,-72,-42,-27,-14,2,15,18,14,7,-8,-34,-65,-89,-106,-125,-150,-171,-179,-184,-200,-226,-243,-244,-235,-225,-211,-187,-160,-145,-147,-152,-146,-127,-103,-80,-55,-34,-22,-22,-21,-9,14,35,39,26,3,-18,-31,-33,-26,-16,-6,7,20,29,30,25,15,0,-23,-50,-70,-70,-53,-28,-8}
        },
        {    // H50e104a.wav
            {0,1,-1,-2,-1,0,-1,-2,-1,1,1,-1,-1,0,1,-1,-1,2,4,1,-2,1,6,4,-7,-11,-3,4,-4,-15,-5,21,31,10,-9,4,16,-19,-55,44,367,843,1320,1730,2054,2086,1354,-501,-3158,-5525,-6383,-5259,-2730,100,2381,3874,4731,5137,5167,4878,4366,3733,3059,2440,2005,1825,1806,1719,1394,870,347,-1,-163,-252,-382,-593,-864,-1155,-1415,-1586,-1639,-1607,-1568,-1575,-1620,-1650,-1621,-1506,-1290,-977,-628,-340,-168,-79,0,73,68,-39,-124,14,450,1028,1472,1608,1474,1233,1028,909,845,763,577,249,-161,-503,-654,-624,-549,-573,-739,-990,-1233,-1392,-1415,-1276,-1015,-738,-556,-492,-475,-416,-300,-181,-103,-47,36,156,272,339,346,316,273,236,219,223,226,188,95,-26,-125,-183,-224,-281,-359,-441,-508,-555,-577,-561,-500,-414,-342,-310,-317,-346,-382,-416,-436,-431,-400,-357,-321,-299,-285,-272,-259,-249,-241,-234,-226,-219,-210,-195,-175,-164,-180,-223,-271,-294,-278,-238,-199,-175,-158,-141,-121,-107,-106,-114,-130,-151,-174,-194,-201,-196,-189,-190,-203,-218,-225,-218,-197,-169,-143,-127,-127,-137,-145,-144,-135,-121,-105,-86,-64,-46,-38,-41,-47,-51,-51,-50,-47,-43,-39,-41,-49,-57,-60,-59,-61,-69,-79,-85,-86,-84,-82,-77,-70,-64,-64,-71,-82,-96,-113,-129,-141,-143,-135,-118,-94,-69,-47,-33,-29,-37,-55,-82,-112,-136,-151,-156,-151,-130,-98,-64,-44,-42,-43,-32,-12},
            {-105,2,155,96,-193,-241,600,2594,5406,8221,9717,8040,1680,-8629,-18774,-23038,-18240,-6615,5718,13545,16050,15913,15629,15239,13353,9509,4928,1292,-531,-507,1093,3620,5633,5367,2141,-2751,-6901,-8668,-8207,-6841,-5754,-5372,-5602,-6149,-6535,-6246,-5217,-4091,-3656,-3981,-4295,-3840,-2642,-1283,-93,1075,2277,3074,3010,2348,1970,2443,3417,4055,3917,3242,2498,1933,1594,1486,1518,1419,958,262,-259,-387,-368,-626,-1289,-2094,-2707,-2980,-2926,-2613,-2172,-1816,-1680,-1670,-1558,-1248,-869,-571,-329,-9,407,748,835,652,346,90,-18,23,148,287,413,554,715,830,803,617,345,71,-172,-360,-440,-391,-315,-379,-649,-1014,-1301,-1438,-1464,-1433,-1356,-1243,-1131,-1030,-886,-652,-376,-172,-90,-66,-9,95,192,260,331,418,465,404,233,29,-129,-204,-192,-97,60,223,327,341,276,159,4,-172,-334,-434,-453,-402,-310,-204,-112,-63,-75,-138,-223,-301,-355,-373,-353,-308,-265,-237,-206,-149,-66,16,66,80,71,50,22,-3,-7,10,31,38,37,45,63,72,51,-1,-77,-169,-266,-347,-389,-388,-363,-330,-289,-240,-193,-164,-154,-151,-147,-148,-156,-160,-144,-110,-75,-48,-27,-8,5,7,6,9,10,-2,-28,-57,-78,-97,-121,-144,-156,-165,-184,-216,-244,-251,-241,-229,-219,-202,-176,-155,-149,-154,-155,-146,-127,-103,-77,-54,-41,-41,-42,-33,-12,8,18,15,3,-12,-24,-25,-16,-1,12,19,26,31,34,31,26,18,6,-15,-41,-59,-56,-36,-12}
        },
        {    // H50e112a.wav
            {1,-1,-4,-3,-2,-1,-1,0,2,1,-1,-2,0,1,-1,-1,2,5,3,-2,-2,4,5,-2,-8,-2,5,-2,-15,-11,13,27,12,-6,5,23,-2,-49,7,283,753,1286,1783,2183,2274,1602,-211,-2923,-5498,-6659,-5769,-3256,-222,2337,4018,4914,5268,5254,4971,4493,3878,3191,2558,2151,2046,2101,2022,1612,947,292,-153,-396,-571,-765,-965,-1137,-1305,-1499,-1682,-1766,-1722,-1627,-1599,-1673,-1776,-1795,-1652,-1339,-907,-459,-101,107,188,184,103,-61,-225,-201,154,764,1345,1632,1585,1373,1177,1055,959,831,645,391,89,-188,-349,-373,-354,-424,-636,-936,-1224,-1432,-1519,-1448,-1211,-881,-595,-459,-463,-506,-504,-448,-375,-295,-175,6,214,378,451,435,370,292,222,172,151,158,179,194,179,117,1,-154,-309,-423,-482,-511,-538,-562,-556,-503,-422,-360,-345,-371,-408,-436,-445,-439,-418,-389,-360,-337,-319,-302,-281,-254,-220,-189,-173,-181,-205,-226,-229,-219,-212,-215,-221,-217,-203,-186,-172,-154,-126,-95,-76,-78,-96,-116,-133,-151,-174,-199,-220,-240,-260,-279,-288,-281,-262,-233,-198,-158,-122,-105,-111,-129,-146,-151,-147,-135,-113,-84,-56,-40,-36,-39,-43,-48,-53,-56,-53,-46,-38,-33,-33,-38,-48,-60,-68,-72,-76,-84,-96,-107,-111,-105,-88,-70,-56,-51,-53,-60,-71,-88,-108,-123,-125,-120,-109,-91,-64,-33,-14,-15,-29,-47,-69,-97,-127,-143,-141,-130,-117,-96,-61,-28,-24,-53,-79,-69,-27},
            {-37,-72,18,119,27,-194,-73,943,3057,5921,8567,9354,6380,-1131,-11218,-19260,-20656,-14297,-3566,6343,12324,14807,15839,16348,15535,12501,7799,3182,206,-637,339,2473,4748,5740,4285,497,-4015,-7237,-8192,-7391,-6072,-5186,-5027,-5428,-5976,-6146,-5605,-4585,-3802,-3762,-4183,-4274,-3577,-2360,-1129,-5,1172,2278,2816,2549,1985,1938,2655,3560,3916,3538,2803,2144,1736,1571,1569,1529,1188,502,-193,-477,-328,-184,-475,-1194,-1960,-2426,-2522,-2363,-2084,-1803,-1629,-1596,-1607,-1520,-1295,-1005,-706,-369,34,411,591,482,179,-107,-204,-99,84,206,241,288,448,696,881,873,673,375,68,-191,-339,-323,-189,-107,-240,-584,-975,-1246,-1358,-1367,-1329,-1265,-1194,-1124,-1031,-865,-628,-397,-249,-173,-96,19,134,210,262,332,407,416,312,131,-42,-152,-187,-150,-44,107,246,321,318,254,146,-4,-181,-343,-437,-438,-361,-243,-128,-54,-49,-110,-206,-295,-348,-362,-350,-325,-301,-278,-247,-195,-123,-50,0,24,34,39,37,25,10,5,8,7,4,11,36,66,77,54,0,-76,-166,-254,-317,-344,-343,-328,-306,-272,-232,-198,-180,-170,-162,-156,-160,-169,-166,-142,-109,-83,-64,-47,-31,-20,-13,0,16,21,3,-28,-52,-61,-69,-88,-114,-137,-157,-184,-217,-244,-253,-246,-232,-213,-188,-161,-141,-134,-139,-145,-146,-137,-116,-89,-66,-57,-55,-52,-39,-21,-6,2,1,-6,-16,-21,-14,4,23,36,39,38,36,37,39,37,23,-5,-36,-52,-45,-25,-7}
        },
        {    // H50e120a.wav
            {-3,-3,0,1,-1,-2,-1,2,2,0,-1,-1,-2,-3,-2,2,4,1,-3,0,5,2,-6,-7,2,5,-6,-17,-6,15,19,0,-8,12,23,-12,-42,66,403,934,1545,2125,2505,2322,1110,-1273,-4217,-6480,-6910,-5234,-2207,967,3390,4817,5461,5617,5455,5026,4356,3527,2714,2142,1961,2088,2223,2056,1516,808,206,-180,-435,-690,-991,-1304,-1602,-1871,-2072,-2130,-2020,-1829,-1702,-1709,-1791,-1823,-1722,-1474,-1114,-698,-297,29,263,407,431,282,-2,-207,-58,518,1261,1762,1798,1499,1173,1013,981,916,712,394,62,-176,-267,-243,-216,-304,-545,-873,-1184,-1411,-1524,-1495,-1307,-1003,-698,-500,-430,-426,-425,-423,-444,-462,-403,-215,69,338,492,500,406,283,186,134,117,116,125,144,173,187,155,62,-68,-196,-299,-387,-475,-553,-588,-555,-478,-411,-396,-428,-472,-496,-495,-481,-467,-452,-432,-403,-362,-310,-253,-205,-175,-165,-167,-173,-179,-191,-214,-249,-280,-288,-261,-210,-155,-111,-80,-60,-53,-64,-87,-106,-113,-116,-130,-156,-182,-202,-221,-253,-298,-338,-351,-329,-282,-226,-180,-152,-144,-149,-159,-165,-162,-150,-130,-108,-88,-72,-60,-51,-47,-45,-45,-46,-48,-53,-58,-60,-58,-56,-56,-58,-57,-55,-55,-59,-71,-92,-115,-131,-130,-117,-100,-86,-72,-59,-50,-52,-58,-64,-67,-75,-89,-97,-92,-75,-58,-48,-42,-38,-42,-55,-75,-95,-114,-133,-143,-132,-103,-75,-59,-49,-37,-33,-59,-109,-137,-108,-40},
            {32,-45,-66,22,101,17,-155,-31,872,2826,5610,8247,8982,5966,-1260,-10550,-17692,-18931,-13613,-4563,4233,10435,14134,16335,17191,15929,12197,7055,2439,-172,-491,875,3024,4943,5511,3917,362,-3770,-6749,-7678,-6959,-5724,-4910,-4816,-5219,-5668,-5718,-5182,-4331,-3738,-3737,-4051,-4058,-3435,-2402,-1314,-229,944,2011,2508,2279,1819,1839,2511,3310,3610,3284,2678,2159,1849,1701,1603,1378,858,117,-475,-578,-287,-91,-369,-1021,-1628,-1907,-1915,-1842,-1772,-1674,-1550,-1467,-1461,-1473,-1405,-1202,-863,-427,9,298,320,93,-214,-391,-339,-125,91,196,209,246,402,646,846,880,726,444,125,-139,-259,-194,-21,76,-63,-434,-874,-1202,-1339,-1322,-1232,-1137,-1074,-1043,-1003,-909,-752,-571,-403,-249,-96,43,142,201,256,327,379,352,229,59,-85,-162,-165,-105,-1,118,217,271,276,234,141,5,-148,-276,-347,-352,-300,-212,-118,-63,-76,-151,-246,-316,-344,-343,-333,-322,-310,-290,-256,-203,-140,-80,-37,-12,2,9,8,4,1,1,-4,-17,-27,-14,25,70,92,78,30,-44,-134,-220,-279,-300,-297,-289,-281,-262,-230,-200,-187,-190,-195,-191,-181,-168,-153,-131,-107,-90,-82,-81,-77,-66,-43,-12,13,16,-1,-24,-34,-35,-41,-63,-95,-126,-152,-179,-207,-228,-236,-233,-221,-199,-169,-139,-122,-123,-136,-151,-157,-150,-128,-98,-74,-62,-62,-60,-50,-33,-16,-7,-7,-14,-22,-23,-11,11,33,47,53,54,50,39,23,8,-1,-5,-7,-8,-6,-2}
        },
        {    // H50e128a.wav
            {-3,-2,-2,-3,-2,0,1,-1,-3,-2,-1,-2,-3,-1,3,3,0,-1,3,3,-4,-8,-3,3,-2,-14,-13,4,14,3,-10,1,20,5,-34,8,258,761,1451,2181,2717,2667,1571,-752,-3803,-6417,-7355,-6088,-3138,317,3191,5007,5868,6100,5933,5438,4638,3641,2678,2020,1818,1975,2175,2091,1615,919,290,-106,-319,-510,-794,-1174,-1588,-1970,-2258,-2398,-2380,-2267,-2157,-2104,-2077,-2004,-1832,-1547,-1160,-711,-277,64,296,452,533,470,233,-15,30,539,1318,1913,1999,1650,1226,1010,983,926,689,316,-36,-243,-286,-237,-203,-282,-514,-853,-1199,-1454,-1572,-1538,-1353,-1047,-706,-443,-331,-348,-407,-443,-449,-438,-389,-249,-3,280,482,525,430,286,172,108,71,46,39,62,100,114,82,17,-47,-89,-124,-186,-285,-392,-456,-454,-409,-377,-401,-478,-564,-615,-612,-570,-520,-488,-476,-472,-454,-405,-324,-226,-134,-69,-45,-70,-142,-240,-319,-340,-296,-224,-169,-148,-138,-112,-69,-32,-18,-28,-52,-85,-125,-162,-180,-176,-172,-195,-250,-315,-360,-367,-335,-280,-221,-180,-167,-179,-200,-210,-206,-195,-186,-175,-153,-116,-77,-52,-45,-45,-43,-39,-43,-55,-63,-59,-49,-46,-57,-75,-89,-94,-93,-87,-82,-82,-91,-107,-123,-133,-133,-124,-107,-86,-70,-63,-62,-64,-65,-68,-72,-73,-67,-56,-43,-30,-20,-19,-29,-48,-65,-80,-98,-122,-144,-154,-150,-138,-119,-89,-56,-36,-37,-48,-57,-74,-112,-158,-171,-124,-44},
            {17,17,-15,-35,0,52,27,-82,-61,510,2048,4586,7350,8683,6722,763,-7633,-14984,-17833,-14924,-7821,497,7696,12981,16407,17793,16603,12804,7550,2760,-32,-470,800,2797,4594,5317,4253,1335,-2499,-5698,-7121,-6780,-5641,-4756,-4577,-4919,-5324,-5399,-4998,-4304,-3732,-3590,-3769,-3825,-3421,-2614,-1653,-633,481,1539,2148,2097,1719,1638,2120,2820,3196,3071,2693,2365,2156,1965,1678,1218,566,-139,-593,-576,-248,-66,-325,-856,-1244,-1308,-1244,-1321,-1540,-1683,-1619,-1452,-1364,-1394,-1411,-1270,-940,-518,-159,3,-69,-283,-464,-482,-339,-139,21,123,211,325,466,609,716,749,675,486,232,13,-72,-4,125,161,0,-344,-752,-1079,-1237,-1224,-1108,-987,-930,-943,-970,-951,-869,-741,-582,-390,-177,12,128,176,208,258,295,260,140,-10,-118,-155,-138,-90,-13,88,188,251,262,223,146,39,-80,-182,-239,-245,-216,-173,-133,-109,-120,-172,-248,-310,-335,-326,-309,-298,-295,-290,-274,-243,-201,-153,-110,-76,-50,-31,-22,-23,-30,-33,-31,-31,-31,-18,17,64,96,94,58,-4,-80,-158,-221,-256,-265,-262,-257,-248,-233,-217,-210,-211,-209,-198,-179,-159,-140,-119,-104,-102,-115,-130,-134,-120,-90,-50,-13,8,5,-11,-22,-25,-30,-53,-91,-128,-150,-162,-172,-186,-198,-205,-201,-189,-169,-146,-130,-125,-131,-140,-146,-143,-130,-111,-95,-88,-84,-75,-59,-39,-24,-18,-18,-23,-29,-30,-20,3,30,48,51,40,22,8,3,12,30,45,45,30,10}
        },
        {    // H50e136a.wav
            {-1,-2,-1,1,1,-1,-2,-1,0,-2,-3,-1,3,3,0,0,3,4,-1,-5,-3,2,-2,-12,-11,2,10,1,-9,1,19,9,-26,7,244,771,1551,2410,3015,2889,1573,-1014,-4254,-6913,-7760,-6311,-3133,551,3614,5551,6463,6678,6420,5749,4717,3508,2435,1798,1699,1958,2200,2086,1535,762,89,-300,-464,-599,-853,-1234,-1655,-2021,-2271,-2384,-2381,-2325,-2293,-2315,-2356,-2340,-2198,-1884,-1394,-792,-225,168,364,473,589,662,564,321,200,496,1199,1925,2237,2024,1549,1155,948,794,544,210,-79,-233,-281,-309,-377,-498,-666,-875,-1113,-1348,-1530,-1602,-1512,-1244,-854,-463,-197,-116,-180,-305,-416,-469,-425,-247,49,365,566,577,443,278,169,121,91,53,11,-15,-23,-23,-27,-47,-90,-150,-211,-250,-262,-258,-252,-248,-255,-288,-359,-457,-545,-593,-600,-594,-599,-611,-610,-578,-515,-430,-334,-236,-146,-83,-64,-91,-148,-205,-237,-237,-217,-192,-167,-137,-95,-46,-6,9,-9,-51,-98,-133,-148,-153,-163,-190,-233,-283,-323,-339,-323,-284,-238,-206,-197,-208,-224,-230,-222,-205,-188,-179,-173,-167,-156,-141,-121,-97,-72,-53,-43,-36,-24,-11,-9,-23,-47,-70,-84,-91,-93,-92,-89,-90,-98,-115,-135,-152,-162,-161,-149,-130,-108,-86,-68,-54,-49,-52,-60,-69,-77,-81,-74,-52,-21,4,14,11,4,-8,-32,-67,-103,-132,-153,-167,-167,-151,-126,-107,-93,-79,-63,-55,-63,-75,-83,-94,-125,-165,-175,-126,-44},
            {-12,2,15,6,-15,-19,9,29,-13,-69,131,1053,3033,5756,7941,7741,3891,-3113,-10813,-15969,-16380,-12008,-4652,3361,10310,15285,17772,17401,14259,9322,4303,824,-410,246,1916,3731,4935,4802,2893,-433,-3928,-6177,-6594,-5743,-4732,-4308,-4504,-4913,-5126,-4949,-4427,-3817,-3442,-3423,-3541,-3429,-2913,-2096,-1144,-118,896,1639,1852,1625,1422,1634,2188,2674,2816,2708,2588,2507,2309,1858,1183,433,-204,-550,-533,-299,-156,-297,-594,-754,-694,-653,-896,-1365,-1726,-1744,-1518,-1324,-1296,-1320,-1216,-940,-617,-413,-407,-548,-687,-677,-485,-218,-27,35,50,137,321,524,653,677,621,519,393,272,195,190,233,253,166,-58,-369,-663,-852,-920,-912,-885,-870,-872,-889,-907,-907,-872,-805,-711,-583,-409,-202,-12,108,154,161,154,122,47,-52,-128,-154,-143,-115,-64,30,155,262,303,270,188,85,-17,-97,-135,-131,-110,-101,-112,-134,-158,-189,-230,-270,-292,-296,-292,-294,-299,-303,-301,-293,-279,-254,-220,-178,-134,-91,-57,-39,-39,-45,-48,-46,-42,-31,-2,41,82,99,85,46,-8,-72,-138,-197,-239,-263,-270,-258,-229,-197,-179,-181,-191,-194,-187,-175,-161,-143,-125,-119,-129,-145,-153,-146,-126,-98,-63,-30,-10,-9,-18,-29,-38,-55,-82,-110,-127,-133,-137,-149,-167,-183,-189,-181,-161,-136,-115,-106,-108,-118,-132,-144,-148,-141,-129,-118,-109,-95,-73,-47,-28,-22,-25,-32,-35,-32,-20,-3,12,18,14,7,5,13,32,57,75,72,47,15}
        },
        {    // H50e144a.wav
            {0,3,4,1,-2,-2,-2,-2,-1,2,4,3,1,2,5,4,-3,-7,-2,3,-2,-11,-11,1,9,1,-8,2,18,6,-23,35,337,990,1939,2912,3425,2906,979,-2167,-5599,-7943,-8083,-5835,-2057,1891,4924,6661,7312,7243,6666,5649,4316,2960,1959,1563,1724,2112,2298,2008,1275,392,-306,-669,-790,-884,-1108,-1481,-1913,-2279,-2478,-2481,-2354,-2234,-2229,-2333,-2434,-2414,-2224,-1872,-1387,-827,-309,48,237,383,599,819,858,660,459,603,1192,1922,2331,2205,1722,1231,924,735,514,221,-59,-244,-346,-435,-552,-689,-834,-994,-1181,-1370,-1512,-1563,-1495,-1296,-975,-592,-256,-69,-57,-158,-277,-341,-307,-152,110,399,597,625,510,354,237,167,107,35,-32,-74,-84,-77,-67,-76,-123,-209,-301,-350,-338,-291,-250,-233,-236,-257,-309,-391,-476,-526,-532,-526,-547,-599,-651,-662,-612,-505,-364,-221,-119,-86,-117,-174,-211,-208,-175,-137,-107,-84,-62,-41,-24,-12,-5,-10,-33,-71,-113,-144,-162,-181,-216,-263,-304,-317,-299,-260,-222,-197,-193,-208,-236,-263,-273,-258,-224,-183,-151,-136,-139,-151,-156,-147,-127,-108,-97,-90,-76,-53,-25,-3,7,0,-21,-50,-76,-90,-93,-91,-91,-94,-100,-111,-128,-149,-168,-179,-180,-170,-148,-116,-81,-52,-38,-40,-55,-72,-80,-71,-48,-22,-2,9,14,14,10,0,-17,-40,-71,-104,-130,-145,-149,-147,-140,-127,-112,-98,-88,-80,-78,-86,-101,-114,-118,-118,-123,-128,-116,-77,-26},
            {-7,-10,-8,1,10,7,-9,-15,5,21,-16,-38,281,1425,3602,6211,7769,6598,1988,-5017,-11886,-15844,-15271,-10364,-2782,5311,12081,16358,17607,15887,11930,7080,2876,388,-170,722,2344,3984,4887,4316,2009,-1364,-4413,-5948,-5822,-4877,-4130,-4026,-4372,-4750,-4857,-4593,-4042,-3461,-3147,-3177,-3303,-3164,-2611,-1762,-804,143,952,1425,1465,1272,1230,1540,2040,2431,2613,2698,2745,2610,2128,1347,529,-69,-363,-420,-367,-311,-296,-275,-186,-83,-166,-585,-1220,-1720,-1819,-1583,-1308,-1198,-1199,-1138,-956,-763,-702,-799,-948,-998,-861,-562,-223,25,133,165,219,331,461,550,574,538,460,365,293,279,316,355,328,193,-44,-327,-562,-671,-645,-559,-509,-546,-648,-769,-873,-935,-934,-867,-758,-649,-552,-450,-324,-191,-84,-17,13,9,-30,-92,-141,-154,-138,-114,-81,-14,96,213,287,298,261,198,121,43,-16,-40,-42,-48,-72,-103,-127,-144,-169,-204,-241,-271,-296,-319,-338,-350,-353,-352,-344,-324,-292,-251,-205,-160,-122,-97,-83,-70,-52,-34,-26,-27,-21,5,46,83,100,92,63,11,-58,-132,-191,-226,-236,-229,-209,-181,-159,-155,-168,-185,-195,-195,-186,-172,-152,-133,-121,-122,-131,-141,-143,-134,-112,-81,-51,-32,-29,-33,-38,-44,-57,-79,-105,-125,-138,-146,-151,-150,-141,-125,-109,-96,-91,-94,-103,-116,-130,-143,-153,-160,-160,-148,-125,-98,-73,-52,-37,-28,-25,-25,-22,-14,-7,-7,-15,-20,-15,0,18,38,57,70,68,45,15}
        },
        {    // H50e152a.wav
            {1,-1,-3,-3,-3,-3,-2,1,3,1,0,1,3,2,-4,-6,-2,1,-5,-12,-8,2,4,-6,-12,2,18,3,-21,74,477,1302,2440,3480,3778,2714,77,-3609,-7101,-8942,-8223,-5116,-766,3381,6327,7833,8190,7773,6797,5388,3782,2375,1556,1470,1900,2376,2435,1887,909,-99,-790,-1080,-1140,-1214,-1441,-1809,-2214,-2528,-2652,-2568,-2374,-2239,-2269,-2411,-2500,-2409,-2125,-1707,-1201,-653,-166,135,231,270,428,714,937,934,778,746,1047,1595,2077,2219,1987,1552,1104,720,394,127,-53,-153,-250,-434,-711,-983,-1145,-1190,-1207,-1287,-1437,-1582,-1621,-1483,-1157,-710,-276,-1,47,-74,-223,-282,-210,-28,217,459,624,662,590,479,387,309,200,44,-114,-207,-203,-132,-55,-28,-76,-178,-291,-366,-387,-374,-359,-365,-392,-426,-453,-463,-453,-433,-429,-466,-545,-633,-684,-666,-579,-453,-329,-237,-179,-140,-110,-95,-105,-139,-172,-179,-142,-72,11,81,118,111,61,-15,-93,-154,-192,-214,-231,-251,-269,-273,-261,-238,-222,-225,-247,-274,-291,-294,-283,-261,-231,-200,-180,-176,-183,-189,-181,-162,-137,-116,-102,-94,-91,-84,-70,-47,-27,-21,-32,-53,-69,-75,-71,-64,-58,-58,-67,-85,-110,-135,-156,-170,-181,-189,-191,-184,-165,-139,-114,-98,-90,-88,-86,-80,-73,-63,-51,-35,-17,-1,12,19,16,1,-24,-54,-81,-103,-118,-126,-128,-126,-123,-119,-113,-104,-98,-100,-110,-122,-131,-138,-144,-142,-128,-105,-83,-66,-50,-31,-10},
            {-16,-6,3,-2,-12,-8,8,12,-8,-21,1,25,-9,-23,333,1531,3690,6117,7353,5906,1275,-5444,-11874,-15448,-14632,-9571,-1884,6167,12582,16166,16633,14435,10551,6228,2634,502,-20,768,2331,3959,4777,4022,1594,-1641,-4290,-5395,-5063,-4202,-3681,-3759,-4171,-4536,-4608,-4306,-3726,-3148,-2885,-2992,-3168,-3024,-2429,-1560,-661,136,759,1104,1135,1023,1059,1384,1871,2307,2603,2769,2742,2383,1684,876,258,-65,-221,-350,-432,-345,-53,299,471,281,-277,-1004,-1585,-1792,-1639,-1353,-1163,-1114,-1091,-1011,-924,-937,-1069,-1203,-1201,-1013,-702,-378,-110,98,279,443,551,553,457,334,269,284,341,395,428,436,402,304,145,-43,-220,-356,-424,-412,-334,-245,-213,-276,-433,-646,-861,-1013,-1047,-955,-788,-631,-536,-499,-480,-443,-376,-293,-215,-158,-125,-108,-96,-86,-78,-61,-22,45,121,182,220,248,271,275,246,186,115,51,-4,-50,-80,-88,-84,-94,-131,-189,-253,-309,-354,-386,-400,-398,-391,-384,-376,-356,-321,-280,-240,-204,-168,-132,-100,-74,-52,-34,-25,-21,-15,5,40,80,109,115,90,35,-38,-110,-164,-192,-200,-194,-179,-163,-157,-164,-180,-192,-194,-190,-184,-173,-153,-129,-111,-107,-114,-125,-135,-136,-125,-97,-64,-41,-37,-46,-58,-68,-77,-89,-106,-123,-138,-142,-132,-108,-82,-66,-64,-72,-87,-104,-122,-134,-141,-148,-156,-161,-155,-135,-110,-87,-66,-49,-36,-27,-17,-3,8,7,-11,-31,-41,-35,-19,0,24,47,55,41,15}
        },
        {    // H50e160a.wav
            {-1,-1,-3,-3,-1,4,5,3,1,3,4,1,-6,-7,-2,1,-4,-10,-5,5,4,-8,-11,6,18,-3,-11,161,736,1806,3141,4133,3984,2114,-1386,-5556,-8841,-9807,-7905,-3775,1124,5320,7987,9083,8993,8100,6637,4822,3021,1705,1215,1527,2227,2719,2547,1657,399,-712,-1343,-1516,-1509,-1595,-1867,-2249,-2606,-2819,-2821,-2629,-2374,-2235,-2297,-2465,-2545,-2407,-2052,-1552,-972,-382,98,357,405,406,534,805,1054,1119,1001,874,930,1219,1612,1898,1920,1663,1240,809,472,243,73,-101,-324,-604,-896,-1125,-1232,-1237,-1230,-1296,-1441,-1590,-1644,-1543,-1279,-895,-476,-133,49,60,-26,-100,-81,46,240,437,580,650,664,640,579,462,284,78,-98,-197,-208,-152,-71,-19,-35,-116,-223,-310,-361,-397,-446,-505,-555,-576,-570,-545,-518,-504,-524,-583,-657,-704,-697,-638,-542,-417,-264,-102,21,60,7,-98,-190,-223,-185,-99,5,95,151,162,135,86,30,-25,-82,-147,-212,-259,-272,-251,-215,-189,-191,-223,-271,-318,-345,-344,-322,-294,-272,-255,-236,-215,-198,-190,-186,-176,-160,-142,-128,-115,-96,-73,-49,-30,-18,-14,-17,-28,-45,-63,-79,-88,-85,-74,-60,-53,-55,-66,-84,-110,-142,-174,-196,-204,-196,-178,-154,-130,-111,-102,-101,-103,-105,-105,-101,-93,-79,-59,-32,-4,18,26,19,0,-26,-54,-81,-102,-115,-119,-117,-110,-96,-80,-69,-69,-77,-91,-107,-126,-141,-146,-140,-134,-131,-118,-88,-53,-37,-48,-63,-54,-21},
            {-1,-12,-15,-5,3,-2,-12,-8,9,11,-9,-22,2,26,-7,-24,305,1418,3423,5691,6884,5610,1347,-4968,-11151,-14727,-14103,-9302,-1877,5878,11920,15130,15408,13375,9977,6210,2948,806,64,648,2136,3765,4571,3813,1498,-1459,-3775,-4673,-4351,-3646,-3288,-3456,-3896,-4268,-4343,-4039,-3463,-2917,-2712,-2870,-3061,-2906,-2319,-1519,-745,-80,462,804,886,830,896,1234,1750,2229,2534,2627,2471,2029,1386,754,302,10,-227,-389,-313,76,585,858,668,77,-655,-1262,-1593,-1631,-1468,-1255,-1105,-1041,-1020,-1029,-1104,-1251,-1384,-1374,-1171,-851,-535,-278,-48,199,452,638,689,585,380,172,57,84,232,422,556,566,441,229,8,-157,-239,-246,-202,-137,-80,-58,-84,-167,-313,-523,-770,-988,-1102,-1084,-969,-826,-702,-610,-552,-528,-527,-516,-461,-354,-223,-107,-28,13,26,31,46,80,119,144,157,180,233,303,350,340,272,166,52,-49,-118,-146,-144,-137,-151,-192,-249,-307,-360,-403,-436,-458,-470,-469,-444,-392,-324,-262,-224,-206,-195,-179,-157,-132,-103,-67,-28,7,36,60,81,94,94,79,51,11,-36,-83,-121,-145,-160,-169,-175,-181,-188,-196,-203,-203,-194,-178,-159,-143,-131,-126,-126,-126,-123,-120,-119,-118,-111,-94,-74,-63,-68,-83,-97,-99,-92,-85,-87,-101,-120,-133,-131,-116,-96,-81,-75,-77,-83,-91,-102,-116,-130,-142,-149,-151,-145,-132,-111,-87,-65,-47,-30,-13,3,5,-11,-39,-64,-70,-57,-31,-5,14,21,16,6}
        },
        {    // H50e168a.wav
            {-4,-5,0,6,6,2,-1,1,3,-2,-8,-8,-2,-1,-7,-10,-2,7,2,-11,-11,10,18,-10,9,303,1119,2481,3968,4744,3912,1059,-3305,-7755,-10513,-10312,-7070,-1925,3402,7479,9709,10256,9595,8128,6139,3975,2129,1093,1069,1810,2701,3068,2536,1235,-290,-1438,-1934,-1946,-1863,-1974,-2306,-2709,-3013,-3111,-2978,-2686,-2405,-2301,-2395,-2535,-2521,-2272,-1844,-1325,-765,-212,238,501,598,660,807,1047,1279,1396,1350,1170,953,841,946,1241,1536,1600,1348,902,488,243,135,16,-240,-634,-1049,-1328,-1393,-1297,-1189,-1201,-1358,-1565,-1685,-1622,-1365,-986,-591,-273,-81,-4,9,22,80,191,325,440,520,583,645,685,650,507,289,75,-63,-97,-45,46,112,97,-13,-171,-306,-377,-400,-417,-449,-490,-532,-576,-625,-667,-694,-712,-743,-791,-838,-848,-798,-676,-488,-263,-53,81,107,45,-48,-115,-128,-88,-14,68,135,173,181,168,144,107,47,-35,-122,-187,-207,-185,-147,-129,-156,-223,-304,-365,-383,-363,-330,-310,-313,-328,-337,-326,-296,-256,-219,-192,-179,-176,-171,-150,-108,-59,-25,-18,-32,-44,-36,-14,6,10,-5,-30,-58,-83,-98,-99,-87,-75,-74,-86,-107,-129,-150,-168,-180,-184,-179,-169,-155,-134,-110,-91,-84,-91,-107,-123,-133,-132,-115,-86,-53,-22,-3,-1,-14,-38,-60,-74,-83,-94,-109,-118,-112,-95,-77,-62,-51,-46,-53,-70,-89,-102,-110,-124,-143,-154,-148,-127,-100,-73,-51,-46,-66,-97,-107,-78,-27},
            {3,6,0,-12,-14,-5,3,-2,-11,-7,9,11,-9,-22,-1,25,-1,-28,223,1152,2914,5026,6335,5522,1933,-3792,-9753,-13585,-13575,-9504,-2715,4596,10404,13606,14141,12624,9872,6642,3598,1325,257,523,1817,3380,4240,3675,1691,-903,-2986,-3872,-3703,-3174,-2919,-3122,-3578,-3972,-4069,-3791,-3257,-2766,-2598,-2757,-2939,-2811,-2310,-1629,-966,-372,152,526,673,681,783,1128,1629,2069,2302,2317,2142,1792,1308,787,331,-7,-178,-99,256,728,1009,878,382,-239,-774,-1155,-1393,-1476,-1399,-1224,-1065,-1005,-1052,-1178,-1352,-1508,-1539,-1368,-1034,-669,-376,-153,59,283,476,578,568,470,329,199,130,153,258,395,499,514,420,242,52,-78,-119,-99,-62,-30,-6,-6,-59,-179,-343,-515,-676,-829,-972,-1084,-1133,-1100,-987,-818,-646,-528,-490,-507,-514,-462,-352,-214,-81,34,122,171,179,161,138,124,125,147,196,267,334,365,335,242,105,-38,-147,-196,-194,-175,-175,-209,-266,-327,-382,-422,-446,-455,-455,-451,-438,-408,-364,-315,-274,-240,-210,-182,-154,-122,-83,-42,-7,15,29,43,61,77,83,74,51,13,-33,-78,-111,-132,-146,-157,-166,-171,-176,-183,-189,-189,-182,-173,-167,-160,-149,-135,-121,-108,-95,-84,-83,-95,-112,-119,-113,-100,-91,-90,-90,-86,-79,-75,-80,-97,-121,-143,-154,-149,-130,-107,-84,-63,-48,-44,-54,-76,-101,-124,-141,-150,-145,-125,-97,-73,-56,-45,-35,-28,-31,-46,-68,-85,-87,-71,-42,-15,3,7,3}
        },
        {    // H50e176a.wav
            {1,7,7,3,1,3,2,-3,-9,-6,0,-1,-8,-9,1,9,0,-14,-8,17,16,-19,53,523,1641,3302,4845,5218,3512,-398,-5511,-9978,-11921,-10375,-5783,261,5862,9693,11378,11267,9932,7841,5377,3002,1279,644,1131,2266,3255,3380,2389,640,-1121,-2241,-2555,-2391,-2235,-2366,-2740,-3143,-3377,-3348,-3086,-2731,-2477,-2440,-2550,-2608,-2455,-2083,-1581,-1027,-469,22,364,548,676,869,1139,1400,1575,1656,1641,1485,1156,754,498,552,862,1183,1267,1052,673,322,87,-93,-343,-711,-1105,-1363,-1397,-1267,-1135,-1139,-1299,-1525,-1681,-1663,-1443,-1081,-686,-357,-137,-16,43,81,135,223,330,422,486,543,612,664,629,469,230,23,-58,6,154,287,317,218,29,-167,-309,-390,-434,-459,-458,-441,-449,-521,-652,-789,-888,-948,-992,-1027,-1020,-927,-741,-502,-279,-132,-76,-82,-99,-89,-46,16,80,139,183,207,206,193,179,165,139,95,44,4,-16,-22,-34,-65,-123,-202,-285,-344,-366,-357,-340,-335,-344,-359,-372,-382,-384,-373,-344,-303,-262,-231,-207,-179,-140,-93,-51,-26,-21,-27,-30,-20,-1,18,29,29,20,1,-27,-60,-90,-109,-114,-110,-104,-105,-119,-144,-172,-191,-196,-189,-175,-153,-125,-98,-80,-75,-81,-93,-109,-128,-143,-144,-123,-88,-55,-37,-38,-50,-65,-74,-80,-86,-99,-115,-128,-128,-113,-89,-63,-45,-37,-35,-38,-44,-52,-68,-91,-118,-143,-155,-149,-125,-90,-58,-43,-51,-75,-101,-115,-108,-80,-44,-12},
            {7,2,-1,2,1,-5,-11,-7,0,-2,-10,-9,4,10,-5,-20,-7,20,7,-26,127,820,2270,4187,5654,5453,2771,-2133,-7771,-11974,-12910,-9998,-4189,2563,8274,11754,12830,12008,9967,7284,4473,2081,648,480,1425,2827,3777,3554,2052,-125,-2041,-3036,-3107,-2772,-2589,-2778,-3202,-3586,-3722,-3543,-3139,-2734,-2549,-2622,-2759,-2704,-2362,-1837,-1268,-708,-174,258,505,606,734,1022,1421,1764,1939,1960,1870,1654,1276,785,343,127,219,542,896,1059,922,551,120,-248,-567,-897,-1218,-1413,-1398,-1231,-1066,-1030,-1151,-1370,-1584,-1675,-1558,-1242,-838,-479,-222,-41,109,232,314,357,374,370,354,353,401,481,519,456,312,178,124,145,185,196,168,107,25,-61,-136,-198,-258,-329,-409,-489,-568,-659,-770,-898,-1029,-1133,-1166,-1089,-908,-683,-495,-391,-359,-353,-328,-261,-153,-23,100,183,216,211,189,168,157,161,181,210,231,230,208,165,102,19,-74,-155,-208,-235,-251,-270,-297,-331,-365,-393,-411,-421,-425,-425,-418,-401,-373,-337,-297,-251,-202,-157,-120,-90,-64,-41,-25,-15,-2,20,47,67,70,56,30,-6,-46,-80,-102,-112,-116,-122,-130,-138,-148,-164,-184,-200,-205,-199,-183,-159,-128,-98,-79,-74,-79,-86,-96,-111,-126,-131,-123,-105,-88,-77,-72,-70,-69,-72,-82,-99,-123,-147,-160,-155,-131,-98,-66,-42,-28,-25,-32,-46,-65,-88,-112,-133,-144,-140,-121,-93,-63,-42,-37,-51,-76,-101,-111,-102,-79,-51,-27,-11,-3}
        }
    },
    {    // elev60 
        {    // H60e000a.wav
            {15,42,-13,-74,-20,93,72,-91,-140,52,192,-2,-168,472,2048,3627,4291,4323,4559,4465,1860,-4418,-11770,-14964,-10843,-1615,7090,11320,11493,10331,9293,7780,5204,2507,1180,1486,2378,2915,3033,2856,1959,-111,-2864,-5024,-5803,-5646,-5495,-5580,-5309,-4280,-2995,-2341,-2561,-3013,-2953,-2313,-1594,-1167,-917,-552,-48,390,692,1031,1512,1941,2036,1816,1601,1604,1685,1600,1370,1227,1224,1113,686,124,-182,-94,140,230,175,142,144,-11,-435,-995,-1470,-1783,-1987,-2081,-1989,-1704,-1367,-1119,-944,-723,-408,-76,188,383,543,638,608,460,306,270,379,554,691,728,673,569,453,325,156,-66,-300,-472,-530,-479,-371,-263,-200,-191,-207,-207,-173,-141,-160,-241,-343,-425,-486,-553,-624,-658,-627,-561,-534,-607,-783,-1011,-1221,-1338,-1302,-1092,-749,-372,-67,111,183,205,213,206,163,88,8,-50,-76,-79,-66,-40,-8,18,33,42,58,77,79,44,-32,-134,-242,-339,-413,-451,-436,-365,-259,-157,-95,-82,-102,-139,-191,-262,-344,-409,-435,-420,-385,-346,-299,-228,-128,-16,73,113,100,52,-9,-66,-113,-141,-141,-106,-41,36,99,125,102,38,-39,-97,-125,-133,-134,-130,-114,-85,-55,-36,-33,-41,-58,-85,-123,-167,-209,-241,-260,-261,-245,-213,-167,-114,-70,-50,-63,-97,-132,-150,-155,-153,-146,-130,-103,-71,-42,-20,-6,1,-1,-9,-23,-43,-69,-90,-93,-72,-34,2,23,29,21,4,-20,-52,-89,-132,-173,-199,-198,-165,-110,-55,-14},
            {15,42,-13,-74,-20,93,72,-91,-140,52,192,-2,-168,472,2048,3627,4291,4323,4559,4465,1860,-4418,-11770,-14964,-10843,-1615,7090,11320,11493,10331,9293,7780,5204,2507,1180,1486,2378,2915,3033,2856,1959,-111,-2864,-5024,-5803,-5646,-5495,-5580,-5309,-4280,-2995,-2341,-2561,-3013,-2953,-2313,-1594,-1167,-917,-552,-48,390,692,1031,1512,1941,2036,1816,1601,1604,1685,1600,1370,1227,1224,1113,686,124,-182,-94,140,230,175,142,144,-11,-435,-995,-1470,-1783,-1987,-2081,-1989,-1704,-1367,-1119,-944,-723,-408,-76,188,383,543,638,608,460,306,270,379,554,691,728,673,569,453,325,156,-66,-300,-472,-530,-479,-371,-263,-200,-191,-207,-207,-173,-141,-160,-241,-343,-425,-486,-553,-624,-658,-627,-561,-534,-607,-783,-1011,-1221,-1338,-1302,-1092,-749,-372,-67,111,183,205,213,206,163,88,8,-50,-76,-79,-66,-40,-8,18,33,42,58,77,79,44,-32,-134,-242,-339,-413,-451,-436,-365,-259,-157,-95,-82,-102,-139,-191,-262,-344,-409,-435,-420,-385,-346,-299,-228,-128,-16,73,113,100,52,-9,-66,-113,-141,-141,-106,-41,36,99,125,102,38,-39,-97,-125,-133,-134,-130,-114,-85,-55,-36,-33,-41,-58,-85,-123,-167,-209,-241,-260,-261,-245,-213,-167,-114,-70,-50,-63,-97,-132,-150,-155,-153,-146,-130,-103,-71,-42,-20,-6,1,-1,-9,-23,-43,-69,-90,-93,-72,-34,2,23,29,21,4,-20,-52,-89,-132,-173,-199,-198,-165,-110,-55,-14}
        },
        {    // H60e010a.wav
            {-33,-17,30,35,-30,-70,-2,85,40,-96,-99,75,147,-44,-91,622,2045,3323,3808,3868,4088,3738,954,-4840,-10981,-13068,-8948,-938,6304,9886,10371,9790,8989,7423,4882,2390,1168,1326,2024,2579,2886,2828,1934,-29,-2411,-4119,-4702,-4695,-4803,-5008,-4743,-3797,-2730,-2268,-2510,-2887,-2849,-2383,-1842,-1439,-1086,-654,-207,124,389,775,1317,1775,1904,1754,1610,1628,1678,1579,1373,1248,1222,1078,667,159,-127,-84,98,204,222,237,213,5,-424,-923,-1315,-1571,-1751,-1851,-1791,-1559,-1264,-1024,-850,-674,-463,-243,-31,188,401,531,505,351,195,149,230,377,519,612,641,602,502,350,161,-42,-230,-364,-420,-392,-298,-184,-115,-127,-191,-228,-189,-113,-103,-225,-435,-621,-697,-660,-568,-484,-445,-468,-558,-704,-869,-1005,-1070,-1052,-957,-801,-604,-392,-196,-36,88,179,231,222,138,2,-135,-224,-245,-210,-146,-82,-38,-21,-20,-18,-5,14,22,4,-43,-114,-195,-274,-336,-371,-376,-352,-302,-236,-168,-115,-92,-108,-161,-236,-311,-362,-382,-376,-351,-312,-263,-204,-132,-45,43,102,107,62,-3,-55,-86,-105,-115,-105,-71,-21,28,57,54,18,-39,-92,-118,-116,-105,-97,-91,-77,-51,-25,-10,-15,-39,-76,-115,-152,-183,-213,-237,-245,-231,-199,-161,-127,-98,-80,-81,-103,-134,-158,-172,-176,-165,-135,-89,-44,-17,-9,-13,-21,-32,-39,-39,-36,-40,-51,-57,-47,-27,-12,-4,1,3,-10,-38,-62,-72,-83,-117,-165,-179,-129,-45},
            {16,-90,-65,91,129,-56,-190,-10,231,85,-231,207,1846,3803,4811,4878,5085,5330,3259,-3175,-11962,-17154,-13981,-3753,7091,12895,13187,11270,9694,8214,5772,2884,1216,1429,2510,3209,3295,3047,2185,103,-2945,-5621,-6792,-6668,-6317,-6249,-5949,-4863,-3382,-2502,-2635,-3140,-3098,-2325,-1406,-880,-675,-396,88,561,886,1229,1744,2231,2315,1952,1532,1420,1536,1556,1390,1253,1251,1141,669,11,-345,-176,223,414,317,176,130,23,-347,-936,-1520,-1955,-2238,-2360,-2253,-1918,-1511,-1206,-1012,-795,-460,-58,302,562,715,749,659,496,370,366,486,659,797,842,789,679,558,420,213,-84,-405,-634,-706,-655,-552,-431,-291,-149,-51,-35,-88,-170,-244,-300,-341,-379,-426,-487,-544,-565,-538,-498,-514,-641,-886,-1196,-1473,-1616,-1551,-1266,-822,-341,37,222,225,150,106,134,191,216,190,145,115,107,105,93,68,38,18,27,72,132,163,125,8,-162,-338,-475,-545,-536,-458,-335,-205,-109,-69,-76,-102,-129,-170,-244,-341,-424,-460,-450,-418,-374,-304,-197,-72,32,92,111,97,53,-19,-107,-183,-218,-194,-115,-4,102,168,174,128,52,-29,-100,-157,-193,-201,-178,-128,-69,-18,11,18,5,-29,-85,-153,-218,-264,-285,-287,-277,-254,-216,-162,-99,-49,-32,-52,-92,-124,-133,-131,-135,-147,-151,-130,-85,-32,11,32,33,20,1,-21,-49,-81,-107,-111,-87,-45,-3,29,47,47,27,-14,-66,-118,-160,-186,-189,-165,-123,-79,-46,-26,-12,-3}
        },
        {    // H60e020a.wav
            {17,-7,-33,-16,28,29,-27,-54,7,70,20,-84,-63,80,110,-52,-23,672,1902,2942,3342,3454,3654,3172,469,-4691,-9860,-11396,-7726,-907,5282,8585,9417,9230,8565,7035,4655,2387,1238,1287,1874,2433,2783,2728,1894,199,-1773,-3200,-3812,-4032,-4302,-4508,-4222,-3387,-2525,-2201,-2445,-2785,-2790,-2436,-1970,-1555,-1163,-753,-382,-104,179,617,1187,1647,1789,1675,1557,1574,1624,1552,1375,1231,1144,978,637,243,15,24,140,220,250,263,210,-7,-388,-807,-1152,-1417,-1630,-1750,-1688,-1451,-1163,-955,-840,-744,-603,-408,-172,92,330,443,369,165,-2,14,225,509,712,759,675,535,395,261,114,-45,-190,-290,-334,-324,-261,-161,-68,-44,-115,-239,-339,-375,-374,-390,-443,-502,-523,-496,-452,-433,-465,-542,-640,-733,-803,-838,-831,-779,-689,-576,-461,-362,-282,-203,-107,7,111,164,140,47,-80,-199,-281,-311,-291,-239,-179,-130,-98,-72,-44,-16,-4,-22,-73,-147,-222,-281,-315,-326,-317,-293,-260,-222,-184,-150,-126,-120,-138,-176,-222,-261,-286,-295,-287,-263,-225,-178,-123,-58,11,63,77,47,-9,-65,-99,-111,-107,-93,-71,-46,-22,-9,-13,-33,-63,-91,-106,-102,-85,-63,-44,-26,-8,7,9,-9,-47,-89,-124,-150,-172,-191,-205,-211,-209,-196,-172,-139,-108,-93,-95,-109,-128,-150,-169,-176,-163,-131,-88,-47,-16,-2,-6,-21,-35,-39,-37,-38,-43,-47,-48,-45,-39,-26,-12,-11,-23,-37,-38,-38,-57,-96,-118,-93,-35},
            {-95,85,176,-9,-227,-103,229,203,-220,-114,1359,3620,5145,5425,5550,6064,4900,-882,-10597,-18336,-17531,-7490,5448,13726,14993,12472,10041,8446,6383,3638,1695,1606,2605,3296,3336,3180,2661,851,-2449,-5866,-7697,-7697,-7088,-6859,-6673,-5698,-4056,-2856,-2826,-3389,-3389,-2441,-1240,-575,-435,-240,289,859,1161,1358,1788,2378,2644,2318,1716,1347,1316,1340,1250,1198,1290,1257,772,-16,-525,-392,118,462,443,296,231,129,-227,-821,-1438,-1939,-2335,-2603,-2604,-2273,-1779,-1374,-1127,-893,-536,-95,300,584,765,835,767,594,442,433,579,787,943,985,919,796,663,520,318,23,-329,-649,-864,-944,-884,-686,-400,-141,-21,-50,-139,-196,-209,-226,-278,-353,-431,-503,-556,-558,-491,-397,-375,-517,-840,-1268,-1664,-1883,-1822,-1462,-892,-294,132,275,188,47,19,134,289,368,342,271,219,199,186,165,136,107,84,79,107,156,178,122,-22,-214,-393,-516,-568,-550,-475,-363,-248,-160,-112,-90,-77,-75,-111,-204,-333,-448,-511,-513,-462,-366,-233,-93,12,62,75,78,74,40,-38,-139,-219,-240,-192,-94,19,108,153,158,136,89,8,-104,-213,-278,-278,-227,-157,-89,-31,17,52,60,28,-45,-141,-232,-297,-334,-349,-344,-310,-245,-162,-81,-23,1,-11,-51,-100,-141,-170,-192,-201,-181,-125,-48,19,56,64,56,37,7,-34,-78,-112,-127,-121,-95,-58,-17,16,36,34,6,-43,-96,-137,-155,-155,-143,-122,-94,-65,-45,-34,-29,-23,-14,-5}
        },
        {    // H60e030a.wav
            {-3,11,14,-8,-29,-10,26,21,-27,-42,12,56,5,-71,-36,79,78,-55,35,702,1766,2617,2960,3122,3303,2704,50,-4624,-9034,-10121,-6753,-796,4616,7680,8692,8698,8053,6527,4311,2305,1317,1353,1846,2334,2645,2586,1856,424,-1230,-2484,-3150,-3517,-3842,-3981,-3652,-2929,-2293,-2154,-2442,-2732,-2696,-2361,-1940,-1558,-1196,-835,-525,-272,40,527,1111,1541,1642,1508,1393,1426,1511,1496,1373,1239,1124,941,643,329,149,135,191,227,242,247,179,-42,-404,-792,-1112,-1353,-1531,-1605,-1524,-1320,-1115,-995,-931,-827,-643,-427,-240,-93,37,155,236,271,294,350,450,560,624,613,535,424,302,182,65,-37,-112,-161,-199,-232,-251,-252,-249,-268,-311,-349,-345,-303,-269,-288,-366,-460,-516,-510,-464,-429,-443,-505,-581,-638,-662,-658,-635,-596,-549,-507,-477,-444,-387,-292,-168,-37,72,130,118,40,-76,-194,-289,-356,-389,-378,-321,-236,-160,-115,-99,-95,-91,-95,-118,-160,-208,-250,-281,-297,-290,-256,-203,-156,-133,-130,-131,-124,-116,-118,-133,-155,-177,-199,-221,-233,-223,-187,-133,-75,-26,6,13,-7,-46,-89,-120,-131,-125,-107,-87,-68,-54,-46,-48,-59,-75,-86,-84,-71,-51,-29,-8,8,15,11,-4,-26,-52,-81,-112,-139,-160,-178,-191,-197,-193,-180,-164,-147,-131,-118,-113,-117,-128,-140,-152,-162,-161,-140,-98,-50,-16,-1,-1,-8,-22,-42,-59,-65,-63,-60,-56,-48,-33,-23,-24,-30,-34,-37,-50,-71,-80,-61,-22},
            {138,56,-167,-180,134,309,-45,-348,550,2801,5019,5923,6022,6524,6478,2567,-6721,-17146,-20828,-13546,566,12555,16709,14475,10859,8634,7003,4739,2580,1971,2781,3512,3373,2979,2796,1928,-758,-4734,-7939,-8920,-8229,-7392,-6993,-6377,-5059,-3697,-3271,-3707,-3874,-2970,-1463,-426,-223,-225,229,1020,1574,1735,1904,2355,2765,2655,2070,1527,1351,1345,1222,1058,1083,1179,927,215,-474,-581,-132,333,436,317,279,302,97,-466,-1198,-1851,-2345,-2686,-2794,-2579,-2127,-1672,-1347,-1068,-686,-200,254,564,723,775,738,638,541,535,652,850,1036,1122,1078,945,798,664,491,205,-197,-631,-986,-1165,-1110,-825,-428,-130,-83,-237,-383,-364,-218,-106,-132,-259,-394,-482,-518,-503,-442,-374,-378,-521,-811,-1190,-1558,-1801,-1821,-1576,-1114,-566,-93,188,259,200,136,149,241,357,436,449,395,292,179,105,94,128,167,188,200,210,196,120,-26,-208,-371,-482,-538,-546,-510,-433,-328,-222,-138,-86,-61,-65,-104,-185,-298,-415,-501,-526,-473,-350,-194,-56,33,78,105,123,106,32,-85,-191,-238,-214,-142,-54,25,85,129,161,166,118,8,-137,-256,-307,-292,-242,-185,-125,-60,7,61,82,56,-16,-116,-212,-281,-325,-353,-365,-347,-293,-209,-112,-20,46,61,19,-64,-153,-219,-251,-245,-199,-120,-33,36,79,104,112,95,47,-21,-83,-124,-143,-142,-117,-74,-26,12,28,19,-14,-58,-97,-115,-116,-110,-108,-106,-95,-75,-47,-18,4,10,-1,-16,-20,-9}
        },
        {    // H60e040a.wav
            {11,0,-4,7,10,-8,-22,-5,23,13,-27,-32,17,46,-4,-58,-13,76,52,-53,92,740,1669,2372,2678,2882,3027,2281,-401,-4733,-8524,-9167,-5911,-522,4328,7166,8205,8214,7464,5903,3878,2196,1438,1500,1890,2263,2499,2424,1780,554,-858,-1971,-2646,-3077,-3396,-3464,-3122,-2532,-2116,-2133,-2427,-2624,-2513,-2185,-1831,-1519,-1207,-887,-607,-361,-34,457,1005,1372,1430,1305,1234,1316,1448,1484,1399,1257,1091,873,610,383,264,231,209,172,148,136,58,-152,-460,-767,-1014,-1216,-1386,-1481,-1443,-1290,-1111,-990,-939,-913,-853,-705,-429,-51,318,530,523,383,274,293,405,503,519,466,395,335,281,223,155,73,-43,-206,-392,-538,-575,-482,-305,-133,-44,-71,-187,-328,-431,-469,-455,-421,-384,-352,-335,-351,-408,-482,-532,-541,-530,-535,-561,-585,-575,-526,-457,-391,-333,-271,-194,-100,-9,48,44,-22,-121,-214,-282,-331,-374,-408,-416,-387,-328,-257,-186,-123,-77,-63,-91,-150,-209,-247,-259,-250,-226,-187,-139,-97,-71,-63,-65,-70,-81,-97,-113,-122,-128,-140,-163,-190,-206,-201,-173,-129,-81,-48,-38,-54,-84,-117,-143,-158,-158,-142,-114,-80,-48,-28,-22,-29,-44,-55,-58,-50,-36,-21,-7,4,11,12,5,-11,-35,-63,-89,-114,-141,-165,-182,-189,-186,-177,-165,-150,-136,-128,-127,-129,-131,-133,-138,-139,-129,-105,-75,-48,-29,-19,-17,-22,-33,-43,-52,-59,-64,-63,-56,-47,-42,-38,-32,-29,-36,-50,-56,-42,-15},
            {37,-221,-143,229,266,-212,-245,1248,3842,5851,6475,6743,7333,6089,-356,-11513,-20801,-20394,-8958,6345,16240,17302,13230,9322,7334,5895,4086,2816,2935,3658,3697,3069,2712,2580,1245,-2175,-6428,-9191,-9498,-8441,-7499,-6876,-5917,-4610,-3855,-4147,-4652,-4109,-2399,-714,-97,-276,-196,609,1599,2127,2270,2510,2902,2983,2498,1822,1479,1490,1471,1255,1073,1063,942,398,-352,-710,-417,132,389,285,168,231,260,-40,-662,-1379,-2036,-2603,-2985,-2993,-2586,-1999,-1533,-1248,-959,-509,35,477,699,726,653,566,520,554,679,871,1077,1221,1241,1129,954,796,651,420,23,-492,-964,-1228,-1208,-944,-569,-271,-194,-326,-500,-536,-407,-238,-161,-196,-278,-354,-417,-459,-460,-422,-406,-499,-733,-1060,-1380,-1595,-1642,-1509,-1224,-849,-455,-114,117,228,261,288,346,418,456,434,364,275,191,138,131,161,189,185,163,160,184,187,110,-56,-262,-439,-551,-593,-573,-502,-398,-284,-184,-111,-70,-67,-102,-174,-272,-381,-471,-502,-448,-322,-180,-77,-25,14,77,146,162,84,-55,-180,-233,-214,-157,-92,-22,53,122,166,168,116,11,-123,-241,-304,-307,-274,-228,-173,-100,-18,49,76,54,-8,-93,-181,-258,-320,-363,-380,-365,-315,-239,-147,-49,35,73,38,-58,-164,-234,-255,-241,-208,-157,-86,-10,56,103,129,124,83,17,-48,-95,-124,-143,-148,-129,-90,-46,-17,-6,-12,-29,-51,-68,-78,-89,-112,-135,-138,-109,-63,-20,12,31,32,8,-32,-58,-50,-18}
        },
        {    // H60e050a.wav
            {2,9,6,-2,1,11,7,-12,-18,4,22,2,-31,-20,27,35,-18,-46,14,75,18,-45,198,873,1684,2231,2497,2741,2771,1669,-1308,-5420,-8414,-8182,-4587,464,4690,7053,7840,7637,6666,5058,3298,2047,1592,1686,1947,2200,2373,2261,1620,496,-729,-1684,-2310,-2753,-3036,-3009,-2625,-2144,-1933,-2095,-2378,-2465,-2273,-1957,-1671,-1422,-1160,-893,-662,-421,-51,474,990,1268,1250,1112,1080,1213,1391,1468,1400,1226,991,734,506,353,266,193,106,39,28,35,-25,-199,-451,-716,-959,-1161,-1290,-1321,-1289,-1277,-1315,-1325,-1191,-884,-497,-156,79,228,322,364,354,317,290,292,312,337,371,421,468,463,366,173,-73,-308,-478,-556,-541,-447,-302,-148,-39,-17,-95,-243,-394,-481,-471,-381,-269,-195,-187,-239,-324,-409,-472,-498,-493,-474,-466,-479,-502,-518,-513,-487,-444,-392,-337,-284,-230,-170,-104,-50,-34,-68,-138,-222,-302,-376,-441,-487,-494,-454,-375,-277,-181,-103,-58,-54,-86,-136,-179,-201,-201,-184,-154,-115,-73,-39,-23,-24,-36,-52,-72,-94,-114,-126,-133,-143,-162,-188,-208,-212,-195,-163,-127,-98,-88,-99,-126,-156,-175,-179,-166,-141,-106,-63,-21,9,17,5,-17,-38,-48,-47,-37,-24,-10,2,11,13,6,-10,-30,-50,-72,-100,-132,-162,-183,-191,-191,-184,-171,-155,-141,-134,-133,-133,-129,-122,-116,-112,-105,-93,-76,-62,-53,-48,-42,-38,-36,-41,-48,-53,-59,-65,-71,-68,-55,-41,-36,-43,-47,-35,-13},
            {-215,25,317,137,-368,-109,1719,4377,6273,6962,7460,7841,5466,-2511,-14237,-22236,-19352,-6013,9372,17829,17225,12209,8100,6276,5236,4101,3529,3865,4151,3552,2692,2585,2685,1128,-2843,-7490,-10191,-10083,-8537,-7210,-6398,-5539,-4633,-4360,-4858,-5138,-4170,-2221,-620,-203,-433,-221,739,1810,2406,2672,3013,3346,3214,2527,1796,1519,1607,1639,1467,1286,1144,766,16,-714,-863,-388,166,323,169,85,173,153,-208,-833,-1507,-2145,-2729,-3114,-3083,-2624,-1999,-1489,-1130,-764,-295,192,536,664,626,531,475,501,603,761,964,1189,1353,1358,1199,985,806,598,220,-336,-861,-1115,-1051,-826,-622,-510,-473,-492,-542,-573,-532,-425,-317,-263,-267,-303,-357,-414,-449,-448,-446,-506,-668,-909,-1164,-1355,-1425,-1348,-1152,-899,-644,-409,-192,8,188,346,474,542,520,419,297,208,162,138,128,143,175,192,174,149,153,179,169,77,-91,-284,-453,-568,-617,-595,-510,-387,-260,-155,-90,-68,-83,-129,-204,-308,-415,-477,-453,-350,-222,-122,-61,-11,52,112,133,92,4,-92,-159,-187,-181,-149,-91,-11,69,124,137,107,40,-55,-161,-252,-304,-310,-277,-217,-139,-60,1,31,33,14,-32,-111,-213,-306,-364,-384,-376,-342,-277,-186,-86,-4,37,25,-38,-127,-204,-244,-245,-227,-196,-146,-73,12,81,119,123,97,49,-10,-64,-104,-133,-152,-157,-141,-106,-68,-37,-13,3,5,-12,-44,-79,-113,-143,-162,-153,-109,-47,5,33,39,31,6,-38,-84,-102,-76,-28}
        },
        {    // H60e060a.wav
            {-6,-1,8,10,1,-5,3,10,-2,-17,-10,15,16,-13,-28,3,35,11,-37,-22,49,56,-29,9,421,1141,1808,2194,2452,2681,2341,503,-2987,-6697,-8356,-6671,-2424,2262,5625,7215,7474,6858,5597,4019,2663,1926,1753,1832,1977,2177,2316,2092,1307,158,-924,-1677,-2165,-2520,-2688,-2534,-2132,-1804,-1812,-2080,-2296,-2250,-2003,-1739,-1529,-1315,-1059,-811,-604,-355,46,561,987,1144,1060,939,960,1133,1332,1421,1333,1080,743,444,278,236,218,145,43,-9,5,6,-88,-268,-466,-657,-876,-1143,-1396,-1531,-1494,-1317,-1075,-822,-589,-390,-231,-99,25,140,225,262,259,243,237,255,303,377,441,438,321,107,-128,-296,-354,-329,-283,-256,-252,-248,-229,-202,-185,-193,-229,-280,-323,-329,-284,-208,-147,-147,-216,-325,-427,-480,-470,-411,-347,-323,-357,-432,-505,-542,-535,-497,-448,-401,-361,-326,-281,-219,-149,-99,-97,-152,-240,-329,-394,-429,-441,-439,-425,-393,-336,-252,-156,-72,-23,-20,-54,-100,-136,-149,-139,-117,-92,-67,-44,-28,-21,-23,-35,-57,-89,-127,-158,-172,-172,-168,-173,-190,-212,-225,-219,-196,-164,-136,-121,-123,-140,-160,-173,-168,-148,-116,-78,-38,-1,24,29,16,-6,-23,-29,-27,-21,-15,-9,-3,1,-1,-11,-26,-42,-59,-77,-98,-126,-155,-177,-189,-190,-183,-169,-153,-140,-132,-129,-126,-121,-117,-114,-110,-98,-82,-68,-60,-55,-50,-45,-44,-49,-53,-55,-57,-63,-68,-66,-59,-55,-57,-55,-39,-14},
            {-72,285,201,-306,-156,1585,4306,6424,7359,7944,8172,5513,-2666,-14402,-22312,-19380,-6032,9433,18036,17438,12137,7616,5632,4886,4289,4093,4425,4436,3554,2588,2590,2932,1572,-2442,-7421,-10552,-10660,-8946,-7203,-6058,-5208,-4641,-4773,-5435,-5544,-4265,-2182,-754,-633,-985,-613,621,1860,2481,2738,3115,3502,3401,2744,2070,1838,1896,1839,1612,1458,1362,960,105,-743,-966,-526,10,169,48,13,124,86,-312,-951,-1602,-2204,-2780,-3195,-3198,-2725,-2026,-1427,-1022,-664,-222,240,542,596,493,404,433,557,697,826,986,1194,1368,1398,1265,1058,825,489,-30,-627,-1026,-1037,-755,-473,-398,-506,-643,-705,-686,-619,-523,-420,-349,-337,-373,-419,-448,-455,-452,-459,-505,-615,-785,-980,-1144,-1224,-1194,-1062,-872,-675,-494,-318,-135,47,208,344,453,515,495,391,254,151,106,96,97,107,133,163,176,173,175,181,156,59,-110,-302,-459,-556,-592,-577,-513,-406,-279,-164,-85,-48,-52,-99,-192,-313,-417,-450,-395,-286,-178,-105,-55,-2,59,103,102,55,-10,-69,-116,-156,-180,-165,-102,-15,54,83,81,60,19,-55,-156,-253,-307,-306,-259,-187,-112,-55,-23,-6,7,11,-17,-93,-202,-304,-368,-387,-366,-313,-234,-146,-71,-21,-3,-16,-60,-123,-186,-229,-248,-244,-214,-153,-65,27,95,124,117,83,35,-20,-73,-121,-161,-185,-184,-154,-102,-43,9,41,47,25,-16,-63,-104,-135,-155,-157,-136,-89,-30,19,41,36,16,-10,-39,-73,-101,-103,-73,-25}
        },
        {    // H60e070a.wav
            {-1,-5,-3,6,11,4,-3,2,10,3,-13,-12,8,17,-4,-25,-5,29,21,-24,-28,33,60,-10,-30,253,875,1549,2002,2292,2558,2442,1081,-1947,-5662,-7970,-7235,-3641,1002,4750,6751,7229,6715,5578,4155,2904,2176,1943,1921,1948,2075,2278,2258,1686,606,-554,-1384,-1832,-2090,-2256,-2246,-2019,-1752,-1692,-1876,-2094,-2127,-1963,-1737,-1537,-1335,-1097,-866,-690,-511,-209,241,695,962,988,891,836,903,1060,1213,1253,1108,792,435,199,146,192,204,137,51,20,31,8,-120,-371,-703,-1035,-1262,-1304,-1177,-988,-849,-787,-737,-636,-489,-346,-233,-132,-23,88,176,228,259,280,280,244,170,83,15,-16,-18,-16,-27,-53,-88,-131,-187,-257,-323,-356,-333,-258,-165,-100,-101,-165,-251,-304,-297,-250,-215,-226,-276,-328,-349,-330,-289,-258,-266,-324,-418,-510,-563,-560,-519,-471,-443,-435,-426,-395,-332,-255,-195,-180,-215,-275,-328,-352,-352,-348,-353,-363,-358,-322,-250,-156,-64,2,27,10,-32,-75,-104,-112,-101,-80,-59,-44,-40,-44,-52,-66,-90,-122,-155,-181,-192,-192,-189,-190,-203,-225,-243,-243,-219,-178,-136,-106,-97,-109,-133,-156,-163,-149,-118,-79,-38,-1,26,35,26,8,-7,-14,-14,-9,-3,1,-1,-9,-21,-33,-42,-50,-56,-64,-77,-100,-128,-154,-172,-178,-174,-162,-149,-139,-136,-137,-137,-131,-122,-111,-99,-85,-73,-63,-54,-47,-48,-57,-71,-78,-72,-62,-56,-54,-52,-50,-56,-66,-68,-49,-17},
            {155,167,-192,-259,949,3412,5897,7417,8227,8530,6577,-246,-11327,-20691,-20889,-10059,5463,16352,18120,13581,8430,5718,4867,4469,4284,4492,4548,3825,2840,2696,3212,2521,-858,-5948,-9959,-10979,-9548,-7544,-6153,-5349,-4891,-4950,-5503,-5746,-4779,-2810,-1143,-754,-1201,-1230,-248,1174,2213,2736,3111,3431,3375,2839,2259,2109,2299,2357,2087,1734,1487,1141,461,-326,-702,-506,-134,-24,-146,-163,18,100,-212,-865,-1600,-2260,-2835,-3247,-3302,-2899,-2203,-1517,-1008,-628,-260,108,382,486,451,394,415,522,662,805,980,1202,1390,1424,1280,1047,787,440,-62,-611,-946,-907,-624,-385,-356,-479,-609,-678,-692,-653,-553,-430,-365,-400,-488,-553,-564,-539,-506,-492,-534,-664,-853,-1020,-1089,-1054,-970,-878,-775,-628,-418,-167,63,210,259,258,273,327,384,390,331,234,134,53,8,15,72,143,189,198,186,167,127,39,-98,-259,-408,-522,-587,-592,-529,-412,-279,-166,-91,-51,-39,-70,-154,-274,-376,-408,-361,-273,-188,-119,-53,13,60,72,52,24,7,-8,-44,-108,-172,-196,-160,-85,-11,37,64,70,42,-35,-145,-246,-299,-297,-255,-192,-126,-73,-44,-26,0,24,11,-65,-178,-276,-327,-338,-327,-297,-241,-168,-99,-48,-16,-8,-34,-95,-168,-227,-258,-260,-234,-173,-86,4,72,107,112,92,49,-9,-74,-136,-189,-221,-218,-175,-103,-23,42,78,75,36,-22,-76,-114,-136,-143,-134,-105,-65,-25,7,27,30,13,-16,-42,-60,-77,-95,-98,-70,-24}
        },
        {    // H60e080a.wav
            {0,-2,-4,0,7,9,2,-1,6,10,-2,-16,-9,12,14,-11,-24,2,32,15,-27,-18,43,54,-24,-24,287,904,1544,1984,2298,2552,2300,726,-2410,-5965,-7892,-6782,-3037,1502,5003,6729,6956,6254,5059,3754,2741,2242,2127,2107,2080,2149,2309,2266,1689,603,-583,-1442,-1857,-1974,-1950,-1845,-1714,-1673,-1787,-1958,-2011,-1891,-1716,-1610,-1549,-1415,-1165,-888,-670,-476,-206,152,493,706,787,806,819,840,886,972,1054,1028,823,508,239,118,119,157,191,215,189,50,-207,-482,-660,-725,-755,-815,-874,-865,-777,-676,-625,-626,-636,-613,-540,-410,-230,-35,121,200,206,164,89,-17,-127,-182,-135,-1,140,211,188,110,25,-47,-116,-186,-249,-288,-299,-281,-233,-166,-111,-111,-185,-300,-386,-390,-316,-214,-142,-125,-154,-201,-239,-256,-265,-290,-346,-423,-492,-527,-528,-516,-515,-532,-553,-557,-529,-465,-374,-281,-212,-188,-207,-247,-285,-309,-322,-328,-324,-297,-240,-156,-65,9,48,48,19,-20,-54,-74,-79,-74,-66,-63,-69,-83,-101,-118,-135,-154,-174,-192,-206,-213,-214,-215,-220,-234,-248,-248,-225,-182,-135,-97,-80,-82,-100,-124,-144,-151,-138,-108,-67,-25,7,21,18,5,-8,-14,-13,-8,-3,-2,-5,-10,-14,-19,-27,-40,-55,-70,-84,-98,-112,-124,-132,-139,-143,-145,-145,-147,-150,-150,-145,-134,-123,-112,-100,-86,-73,-65,-60,-57,-58,-67,-82,-91,-87,-78,-70,-61,-48,-37,-44,-67,-80,-63,-23},
            {216,-14,-345,79,1842,4408,6632,8018,8735,8074,3859,-5116,-15773,-21274,-16470,-3200,10572,17411,16119,11079,7015,5286,4733,4379,4268,4368,4106,3339,2875,3264,3461,1581,-2813,-7741,-10541,-10313,-8363,-6498,-5469,-5090,-5156,-5604,-5977,-5461,-3820,-1943,-1024,-1244,-1602,-1115,143,1370,2111,2601,3108,3403,3137,2485,2060,2175,2508,2587,2350,2027,1652,1023,171,-465,-501,-110,170,73,-156,-189,-77,-152,-593,-1273,-1992,-2676,-3255,-3530,-3291,-2585,-1737,-1075,-681,-429,-187,60,261,385,453,496,526,553,613,764,1026,1314,1477,1413,1158,814,434,13,-401,-667,-684,-535,-422,-455,-554,-587,-538,-494,-500,-511,-486,-455,-475,-539,-596,-619,-623,-615,-586,-564,-618,-783,-981,-1084,-1040,-915,-806,-726,-610,-401,-120,146,307,331,262,184,171,231,314,362,344,260,131,-3,-84,-70,24,137,206,217,191,143,65,-53,-201,-352,-479,-562,-585,-541,-439,-310,-188,-99,-49,-38,-64,-129,-219,-304,-348,-336,-286,-228,-171,-107,-29,40,70,55,24,11,15,5,-44,-121,-185,-198,-162,-102,-43,10,54,70,29,-71,-193,-282,-310,-285,-234,-176,-122,-76,-35,5,39,40,-15,-116,-217,-280,-300,-295,-278,-245,-195,-141,-93,-48,-10,2,-36,-115,-199,-255,-275,-263,-219,-144,-55,19,64,84,88,72,28,-41,-118,-183,-225,-234,-205,-144,-65,10,64,83,62,10,-51,-95,-116,-119,-111,-90,-59,-26,-3,11,17,11,-12,-41,-61,-70,-80,-94,-97,-70,-24}
        },
        {    // H60e090a.wav
            {-1,-1,-5,-4,2,8,4,-2,1,10,6,-11,-16,0,15,1,-22,-13,23,29,-8,-28,17,59,9,-60,88,579,1241,1793,2174,2483,2509,1541,-983,-4516,-7294,-7506,-4751,-361,3686,6122,6836,6369,5292,4046,3015,2449,2298,2299,2277,2288,2402,2436,2059,1149,-28,-1050,-1684,-1961,-1994,-1849,-1620,-1494,-1624,-1933,-2142,-2051,-1746,-1489,-1427,-1461,-1406,-1197,-905,-601,-280,57,335,468,477,491,609,802,967,1041,1033,959,813,606,410,305,293,292,219,70,-91,-198,-236,-241,-276,-392,-580,-759,-827,-749,-600,-503,-522,-620,-703,-707,-622,-475,-304,-150,-50,-22,-56,-119,-177,-205,-187,-120,-19,86,166,205,198,153,88,25,-18,-40,-61,-98,-157,-224,-275,-298,-300,-301,-322,-359,-383,-359,-278,-167,-74,-37,-64,-133,-209,-260,-276,-273,-279,-313,-373,-441,-498,-541,-576,-616,-663,-706,-715,-660,-531,-357,-195,-97,-86,-144,-234,-316,-360,-355,-305,-227,-140,-61,0,37,49,42,25,6,-13,-34,-55,-71,-81,-89,-105,-128,-154,-178,-199,-216,-228,-233,-233,-231,-231,-233,-236,-238,-236,-226,-203,-168,-128,-93,-69,-63,-74,-97,-120,-133,-130,-113,-85,-52,-23,-8,-6,-11,-18,-24,-29,-31,-27,-19,-10,-4,-1,-2,-10,-30,-59,-86,-103,-107,-104,-100,-99,-104,-113,-125,-137,-148,-155,-153,-144,-131,-120,-110,-98,-86,-80,-79,-78,-72,-69,-75,-88,-97,-96,-91,-86,-77,-60,-47,-57,-85,-100,-78,-29},
            {193,-63,-329,198,1982,4505,6766,8257,8831,7519,2480,-6637,-16252,-20090,-14272,-1415,10974,16623,15073,10491,6938,5398,4780,4284,4016,4005,3821,3366,3213,3585,3405,1139,-3273,-7838,-10195,-9711,-7711,-5905,-5035,-4949,-5345,-5943,-6179,-5401,-3644,-1877,-1130,-1402,-1709,-1209,-15,1173,1965,2502,2932,3072,2759,2261,2063,2285,2576,2595,2387,2147,1827,1222,403,-206,-291,-21,183,158,86,115,86,-259,-926,-1679,-2338,-2899,-3353,-3518,-3193,-2428,-1552,-902,-574,-433,-305,-114,112,317,463,538,553,542,567,695,935,1205,1364,1314,1068,706,301,-88,-376,-478,-413,-338,-407,-598,-728,-659,-447,-271,-241,-329,-447,-542,-607,-639,-642,-637,-640,-638,-621,-620,-694,-846,-995,-1051,-1003,-908,-810,-683,-481,-207,78,289,373,331,224,141,143,221,311,358,342,265,140,-4,-109,-120,-38,76,157,187,183,150,73,-61,-232,-395,-515,-572,-559,-483,-368,-250,-156,-94,-58,-46,-69,-134,-224,-300,-330,-312,-271,-224,-173,-106,-31,27,49,43,37,45,47,15,-57,-140,-193,-197,-163,-114,-62,-10,34,47,7,-82,-188,-270,-307,-298,-257,-200,-139,-82,-27,26,59,46,-23,-121,-202,-246,-264,-271,-263,-227,-171,-116,-76,-43,-13,-3,-39,-114,-195,-251,-273,-265,-227,-157,-73,1,47,69,73,54,6,-63,-136,-194,-226,-227,-194,-133,-62,2,44,55,35,-5,-45,-69,-77,-79,-78,-66,-41,-11,11,19,15,-1,-28,-59,-82,-92,-96,-96,-85,-55,-18}
        },
        {    // H60e100a.wav
            {-3,-3,-4,-2,4,7,2,-4,1,10,7,-9,-14,1,12,-4,-25,-13,21,27,-9,-24,21,58,3,-64,87,576,1242,1819,2238,2559,2525,1440,-1184,-4717,-7373,-7405,-4508,-73,3915,6218,6768,6158,5018,3813,2905,2478,2425,2462,2438,2444,2559,2587,2173,1195,-52,-1105,-1718,-1957,-1992,-1914,-1771,-1673,-1743,-1956,-2127,-2090,-1869,-1625,-1472,-1389,-1295,-1159,-981,-728,-362,68,409,530,464,379,429,641,931,1182,1287,1174,866,518,328,358,456,392,103,-233,-373,-248,-24,62,-92,-396,-678,-813,-786,-667,-549,-498,-520,-576,-612,-593,-518,-412,-314,-262,-279,-349,-418,-419,-317,-142,28,123,131,99,82,95,119,134,141,150,154,129,64,-22,-104,-176,-256,-352,-449,-516,-529,-485,-396,-279,-161,-72,-32,-41,-86,-148,-210,-251,-257,-231,-203,-211,-271,-366,-466,-553,-632,-713,-790,-836,-819,-717,-543,-336,-157,-59,-63,-146,-256,-341,-368,-332,-246,-138,-40,26,56,63,64,63,55,35,3,-32,-64,-88,-106,-122,-142,-170,-206,-244,-271,-281,-277,-266,-254,-245,-238,-234,-232,-230,-221,-201,-172,-139,-106,-76,-54,-49,-62,-86,-105,-113,-112,-106,-93,-71,-45,-25,-19,-25,-36,-47,-56,-60,-53,-37,-17,-2,0,-10,-29,-50,-67,-77,-78,-74,-69,-69,-77,-92,-110,-124,-133,-138,-141,-139,-130,-119,-109,-103,-97,-91,-89,-90,-89,-85,-80,-82,-91,-98,-97,-93,-91,-89,-84,-81,-92,-110,-111,-79,-27},
            {154,9,-250,19,1415,3767,6223,8035,8781,7649,3214,-4944,-14091,-18823,-15038,-3967,8185,15127,15178,11378,7690,5730,4854,4208,3764,3696,3743,3628,3563,3733,3460,1523,-2357,-6708,-9371,-9383,-7628,-5749,-4746,-4667,-5162,-5850,-6208,-5663,-4148,-2416,-1434,-1422,-1673,-1385,-464,609,1481,2186,2767,2987,2657,2067,1792,2063,2524,2699,2506,2175,1824,1347,734,240,100,213,277,191,144,261,339,44,-702,-1646,-2495,-3122,-3487,-3483,-3020,-2222,-1432,-948,-788,-733,-569,-258,82,320,415,416,400,423,505,647,830,1006,1104,1077,929,697,417,132,-90,-190,-201,-251,-438,-690,-815,-693,-404,-149,-69,-160,-341,-528,-664,-712,-682,-629,-605,-608,-608,-619,-691,-835,-981,-1045,-1015,-943,-860,-726,-497,-194,94,285,355,329,260,200,185,219,274,313,315,273,183,58,-62,-125,-104,-24,69,139,174,168,107,-13,-176,-342,-472,-539,-534,-470,-373,-272,-183,-112,-62,-41,-61,-121,-204,-280,-322,-323,-293,-247,-191,-127,-59,-4,26,35,42,58,70,50,-17,-109,-182,-203,-174,-123,-72,-28,10,25,-2,-75,-170,-251,-298,-306,-281,-228,-161,-94,-35,16,51,51,1,-81,-158,-206,-232,-248,-252,-228,-173,-110,-61,-27,-4,0,-30,-97,-177,-240,-271,-269,-236,-176,-100,-29,25,57,66,48,2,-65,-134,-190,-220,-220,-189,-135,-74,-20,19,35,28,5,-19,-33,-40,-46,-52,-49,-31,-4,17,23,13,-9,-39,-69,-92,-103,-105,-97,-77,-46,-13}
        },
        {    // H60e110a.wav
            {-3,-5,-6,0,8,7,-1,-4,4,9,-1,-14,-7,11,8,-17,-26,2,30,12,-24,-9,46,43,-39,-31,285,904,1585,2128,2536,2723,2173,207,-3127,-6489,-7901,-6233,-2149,2405,5629,6881,6577,5475,4188,3126,2535,2415,2519,2584,2578,2626,2707,2538,1840,669,-578,-1498,-1959,-2078,-2016,-1890,-1817,-1912,-2167,-2396,-2380,-2092,-1736,-1534,-1506,-1490,-1339,-1052,-717,-393,-79,207,404,476,474,506,641,861,1088,1234,1241,1103,886,686,536,374,130,-143,-278,-170,79,223,100,-221,-532,-692,-716,-703,-707,-708,-672,-602,-527,-469,-435,-421,-419,-420,-419,-430,-461,-494,-478,-377,-203,-16,120,176,165,115,64,45,82,171,264,297,240,119,-2,-74,-109,-156,-261,-415,-560,-631,-594,-467,-309,-187,-134,-140,-161,-161,-137,-115,-119,-149,-181,-201,-209,-221,-253,-320,-430,-577,-734,-852,-889,-834,-709,-551,-394,-265,-185,-162,-189,-240,-289,-312,-294,-233,-140,-42,31,71,87,97,104,98,73,33,-11,-50,-86,-118,-145,-169,-198,-233,-271,-299,-306,-294,-274,-257,-247,-244,-242,-239,-234,-224,-205,-172,-129,-88,-58,-42,-41,-53,-75,-96,-109,-108,-99,-86,-71,-52,-34,-25,-32,-51,-71,-82,-83,-75,-63,-51,-42,-38,-37,-37,-38,-37,-31,-23,-19,-24,-40,-61,-81,-98,-113,-121,-121,-115,-107,-101,-98,-96,-97,-100,-103,-104,-103,-100,-94,-87,-83,-84,-87,-88,-90,-100,-115,-121,-113,-100,-98,-108,-105,-73,-25},
            {64,108,-78,-178,502,2316,4805,7087,8441,8205,5335,-976,-9535,-16355,-16788,-9426,2092,11608,15143,13303,9527,6599,5049,4174,3585,3416,3635,3874,3936,3938,3714,2473,-450,-4490,-7882,-9069,-8018,-6071,-4649,-4277,-4691,-5407,-5967,-5899,-4937,-3393,-2074,-1564,-1660,-1643,-1072,-123,808,1588,2270,2740,2739,2275,1778,1703,2053,2440,2541,2352,2001,1531,971,494,310,401,521,490,384,360,378,201,-331,-1144,-2037,-2838,-3398,-3527,-3108,-2282,-1449,-978,-918,-1006,-939,-616,-166,208,386,380,293,243,298,447,629,774,839,828,770,684,568,420,269,157,70,-78,-355,-690,-888,-802,-476,-121,66,25,-175,-429,-642,-749,-733,-642,-558,-525,-532,-563,-633,-761,-914,-1024,-1049,-1008,-934,-819,-629,-364,-83,139,265,305,296,270,245,234,237,251,266,266,229,144,25,-83,-131,-102,-21,72,141,168,146,70,-57,-215,-367,-471,-505,-475,-410,-335,-258,-176,-99,-50,-51,-104,-187,-266,-318,-334,-319,-285,-238,-182,-117,-53,0,31,44,53,64,67,36,-38,-129,-189,-191,-145,-88,-45,-14,6,1,-49,-138,-233,-300,-324,-309,-265,-200,-125,-57,-3,32,43,20,-36,-105,-164,-201,-224,-236,-227,-190,-132,-72,-25,3,7,-19,-78,-153,-222,-265,-276,-254,-202,-132,-64,-9,26,41,34,3,-48,-108,-163,-203,-219,-208,-172,-119,-62,-13,19,28,17,1,-10,-16,-23,-34,-39,-33,-17,-2,5,2,-10,-35,-66,-92,-106,-108,-101,-81,-50,-16}
        },
        {    // H60e120a.wav
            {-3,-5,0,9,9,0,-3,6,11,1,-13,-7,12,12,-12,-25,-1,27,13,-22,-11,44,47,-31,-34,262,885,1619,2248,2720,2903,2279,202,-3242,-6694,-8145,-6420,-2163,2622,6016,7277,6826,5526,4100,3000,2437,2359,2497,2597,2636,2736,2854,2683,1930,668,-656,-1589,-1997,-2052,-1983,-1928,-1957,-2123,-2404,-2645,-2656,-2397,-2027,-1745,-1607,-1514,-1354,-1102,-777,-386,49,430,619,587,473,481,692,1013,1275,1371,1302,1134,943,768,586,346,50,-186,-215,-18,225,279,70,-269,-552,-716,-816,-893,-912,-830,-681,-555,-504,-498,-486,-454,-431,-434,-451,-463,-456,-420,-341,-218,-82,23,74,82,77,75,86,121,190,281,347,330,215,53,-77,-130,-129,-141,-217,-351,-492,-574,-563,-464,-327,-220,-191,-233,-292,-308,-260,-170,-83,-31,-28,-72,-147,-225,-289,-347,-431,-554,-690,-785,-795,-720,-592,-455,-343,-279,-268,-296,-330,-339,-312,-260,-201,-146,-94,-42,9,59,104,135,144,125,82,30,-18,-56,-88,-120,-157,-200,-245,-283,-301,-294,-270,-244,-231,-233,-244,-257,-264,-260,-244,-216,-181,-144,-109,-77,-52,-39,-40,-55,-80,-103,-115,-111,-93,-69,-44,-23,-15,-23,-46,-71,-89,-97,-97,-94,-90,-86,-84,-81,-70,-50,-26,-5,6,11,10,0,-21,-48,-72,-87,-94,-92,-83,-71,-64,-66,-76,-87,-97,-105,-109,-108,-105,-102,-100,-96,-87,-80,-84,-97,-109,-114,-114,-115,-114,-106,-98,-98,-104,-97,-66,-22},
            {-54,104,110,-113,-135,702,2607,5058,7196,8253,7437,3817,-2866,-10809,-16065,-14891,-6937,3881,12108,14698,12607,8946,6071,4433,3533,3120,3253,3756,4178,4269,4081,3452,1780,-1297,-5043,-7829,-8432,-7093,-5197,-4039,-3978,-4616,-5379,-5806,-5552,-4537,-3151,-2076,-1702,-1763,-1661,-1079,-179,740,1552,2219,2581,2476,2029,1655,1671,1989,2275,2310,2118,1792,1362,882,512,397,495,625,669,654,604,430,5,-670,-1458,-2211,-2816,-3141,-3041,-2510,-1795,-1253,-1065,-1112,-1125,-939,-582,-192,109,265,283,227,183,208,294,394,473,534,594,651,685,671,605,497,353,154,-130,-476,-772,-861,-672,-303,36,171,65,-197,-491,-711,-793,-731,-588,-456,-402,-427,-507,-625,-775,-929,-1035,-1060,-1017,-931,-805,-623,-388,-147,46,167,232,262,269,257,237,225,230,244,244,208,129,23,-70,-113,-94,-27,58,135,179,170,93,-46,-213,-362,-454,-478,-450,-393,-324,-252,-182,-123,-94,-106,-158,-232,-299,-338,-344,-327,-296,-257,-207,-142,-65,8,60,80,76,61,40,1,-63,-136,-179,-169,-117,-59,-20,-4,-8,-35,-97,-185,-274,-331,-343,-314,-254,-178,-99,-33,12,32,27,-5,-58,-117,-166,-196,-211,-216,-203,-167,-110,-53,-15,-6,-23,-61,-113,-171,-224,-257,-261,-234,-184,-123,-66,-21,6,13,2,-25,-64,-111,-159,-198,-219,-212,-177,-120,-59,-8,19,24,15,3,-7,-15,-23,-31,-37,-39,-34,-23,-14,-15,-29,-50,-71,-89,-104,-111,-98,-63,-21}
        },
        {    // H60e130a.wav
            {-6,1,10,7,-2,-2,7,8,-6,-15,-1,15,6,-19,-19,12,26,-5,-34,1,57,32,-52,13,431,1157,1953,2631,3092,3036,1822,-1001,-4839,-7892,-8222,-5245,-274,4429,7182,7682,6661,5081,3638,2694,2330,2372,2519,2600,2680,2848,2941,2577,1544,83,-1252,-2034,-2234,-2115,-1952,-1901,-2035,-2357,-2744,-2960,-2834,-2437,-2040,-1849,-1824,-1759,-1508,-1090,-606,-129,297,602,726,707,685,787,1007,1229,1348,1350,1282,1178,1030,802,477,100,-192,-243,-15,317,472,294,-114,-512,-745,-846,-915,-981,-987,-900,-763,-648,-587,-563,-556,-555,-546,-515,-467,-420,-372,-288,-147,17,134,161,119,61,27,33,89,200,336,427,407,270,78,-83,-166,-187,-197,-241,-322,-405,-447,-430,-377,-335,-335,-365,-388,-371,-320,-266,-236,-225,-202,-148,-81,-39,-54,-134,-262,-417,-571,-686,-726,-681,-577,-457,-356,-295,-279,-308,-362,-408,-414,-372,-302,-229,-166,-114,-68,-30,7,48,92,127,138,116,70,11,-50,-107,-158,-201,-235,-260,-272,-268,-248,-223,-208,-210,-229,-253,-272,-279,-270,-249,-220,-192,-166,-139,-108,-78,-57,-53,-68,-91,-111,-120,-114,-98,-77,-58,-43,-33,-29,-36,-55,-81,-103,-116,-119,-118,-116,-112,-105,-92,-76,-57,-37,-20,-9,-5,-8,-18,-35,-55,-71,-74,-64,-45,-27,-19,-27,-50,-81,-107,-120,-122,-119,-113,-105,-96,-90,-91,-97,-107,-120,-134,-142,-137,-121,-105,-96,-94,-93,-94,-99,-102,-90,-58,-19},
            {-58,-38,66,88,-74,-128,511,2166,4492,6673,7851,7217,3964,-2131,-9579,-14931,-14608,-7788,2402,10905,14339,12939,9373,6134,4112,3086,2780,3103,3788,4348,4485,4231,3528,1936,-881,-4374,-7124,-7916,-6789,-4958,-3736,-3614,-4258,-5068,-5555,-5405,-4539,-3267,-2196,-1755,-1807,-1811,-1372,-537,415,1295,2012,2413,2344,1915,1531,1541,1880,2181,2176,1918,1595,1287,970,676,512,525,633,729,767,723,510,28,-702,-1510,-2185,-2584,-2652,-2411,-1983,-1572,-1344,-1304,-1305,-1201,-960,-641,-318,-42,142,209,184,125,77,48,54,127,281,473,635,740,805,828,753,532,186,-198,-524,-712,-706,-500,-175,105,192,53,-224,-507,-698,-753,-676,-524,-382,-320,-349,-437,-554,-692,-845,-979,-1054,-1049,-974,-848,-682,-494,-308,-145,-8,104,187,233,243,237,232,233,234,229,210,167,93,3,-71,-94,-53,35,138,216,232,161,12,-174,-335,-432,-457,-433,-385,-330,-276,-226,-186,-160,-156,-182,-235,-298,-349,-370,-360,-328,-284,-230,-162,-79,11,87,123,111,67,14,-34,-81,-130,-162,-154,-102,-39,0,-1,-27,-67,-120,-189,-262,-315,-331,-306,-251,-177,-101,-38,3,21,18,-6,-50,-102,-147,-176,-191,-197,-189,-163,-118,-70,-36,-23,-33,-63,-107,-156,-200,-230,-242,-232,-197,-140,-78,-30,-6,-5,-18,-40,-70,-105,-142,-174,-194,-193,-166,-119,-67,-23,6,19,18,7,-7,-16,-23,-33,-47,-54,-48,-32,-20,-21,-31,-43,-59,-80,-97,-94,-64,-22}
        },
        {    // H60e140a.wav
            {6,7,1,-3,4,10,0,-14,-10,9,11,-11,-25,-1,29,14,-28,-25,33,52,-22,-49,220,879,1762,2621,3281,3473,2619,133,-3752,-7499,-8956,-6895,-2054,3335,7084,8305,7501,5776,4079,2917,2402,2360,2486,2579,2668,2859,3038,2823,1902,406,-1114,-2112,-2432,-2312,-2092,-1991,-2088,-2384,-2782,-3072,-3046,-2698,-2256,-1979,-1921,-1917,-1774,-1437,-966,-430,113,566,817,849,798,852,1077,1370,1568,1583,1443,1237,1036,848,617,294,-60,-263,-163,180,485,482,154,-289,-642,-868,-1035,-1149,-1140,-988,-794,-693,-712,-767,-773,-722,-655,-591,-526,-457,-389,-302,-163,31,219,321,307,219,129,93,130,233,366,468,470,343,127,-90,-226,-266,-261,-279,-346,-421,-444,-396,-317,-274,-300,-374,-444,-466,-434,-366,-293,-238,-203,-182,-165,-152,-156,-192,-271,-388,-521,-626,-661,-604,-478,-331,-219,-171,-189,-252,-328,-383,-395,-364,-308,-245,-186,-136,-98,-72,-49,-12,41,94,118,102,57,3,-55,-123,-200,-269,-307,-305,-269,-219,-171,-142,-143,-175,-222,-265,-286,-282,-259,-230,-206,-191,-179,-163,-137,-108,-85,-72,-72,-85,-105,-124,-128,-114,-91,-70,-59,-55,-55,-59,-68,-80,-92,-101,-110,-118,-122,-120,-110,-97,-83,-72,-65,-60,-54,-47,-43,-46,-57,-68,-73,-66,-46,-20,1,8,-2,-26,-56,-84,-106,-122,-131,-130,-120,-103,-85,-77,-85,-108,-136,-157,-164,-158,-144,-127,-110,-97,-90,-83,-73,-66,-69,-76,-73,-50,-17},
            {44,-51,-87,17,116,15,-147,160,1398,3458,5663,7177,7209,4961,-41,-6968,-13061,-14726,-10113,-973,8230,13432,13564,10486,6860,4242,2867,2465,2798,3548,4236,4514,4375,3848,2618,268,-2968,-5931,-7303,-6725,-5078,-3678,-3255,-3701,-4495,-5143,-5283,-4717,-3589,-2433,-1808,-1797,-1946,-1740,-1057,-124,812,1623,2165,2252,1894,1449,1350,1667,2042,2104,1833,1486,1241,1058,850,658,584,634,712,740,699,539,152,-511,-1305,-1947,-2223,-2134,-1861,-1607,-1474,-1445,-1444,-1400,-1282,-1085,-808,-469,-136,91,157,95,-15,-120,-200,-218,-115,111,369,558,680,813,963,1002,789,340,-167,-533,-663,-570,-321,-24,180,181,-15,-288,-504,-611,-624,-568,-467,-364,-314,-336,-398,-463,-538,-654,-816,-971,-1057,-1044,-949,-806,-649,-497,-356,-218,-80,43,133,187,221,245,256,248,234,227,218,180,102,9,-51,-47,21,125,223,267,221,84,-98,-263,-373,-427,-440,-423,-381,-325,-273,-235,-209,-194,-198,-227,-279,-333,-366,-369,-344,-303,-251,-191,-117,-27,69,139,155,111,34,-41,-97,-134,-156,-155,-124,-71,-19,6,-3,-39,-95,-159,-223,-274,-302,-300,-262,-196,-120,-56,-17,3,10,4,-22,-66,-114,-151,-174,-186,-187,-168,-130,-85,-49,-28,-28,-48,-86,-132,-174,-204,-219,-217,-194,-150,-98,-55,-34,-32,-42,-55,-69,-83,-101,-125,-149,-160,-147,-114,-74,-39,-13,5,10,3,-9,-18,-25,-38,-54,-65,-60,-44,-27,-18,-16,-25,-43,-63,-68,-48,-16}
        },
        {    // H60e150a.wav
            {4,-2,1,7,1,-14,-14,5,14,-6,-26,-8,26,19,-26,-37,20,59,-4,-66,136,770,1726,2739,3558,3869,3085,591,-3463,-7585,-9503,-7724,-2771,3078,7357,8891,8095,6190,4289,2995,2428,2390,2547,2669,2766,2958,3150,2948,1980,343,-1361,-2476,-2778,-2543,-2210,-2060,-2165,-2499,-2954,-3304,-3300,-2892,-2327,-1949,-1887,-1961,-1899,-1582,-1077,-501,58,510,763,807,783,878,1150,1478,1685,1701,1577,1401,1223,1031,774,406,-29,-350,-348,4,450,631,383,-141,-654,-983,-1132,-1164,-1104,-976,-853,-816,-865,-913,-882,-786,-697,-656,-640,-604,-522,-388,-205,12,220,364,409,370,302,264,290,373,474,541,528,415,219,-8,-206,-338,-407,-438,-444,-418,-357,-292,-271,-314,-390,-450,-468,-452,-424,-394,-363,-329,-291,-244,-192,-158,-177,-267,-412,-564,-673,-698,-622,-465,-280,-135,-73,-86,-137,-190,-230,-256,-266,-255,-226,-192,-163,-142,-124,-103,-74,-37,5,45,66,57,17,-52,-139,-227,-297,-325,-308,-259,-206,-169,-155,-159,-170,-184,-196,-203,-207,-214,-225,-236,-237,-224,-200,-170,-136,-102,-75,-62,-67,-84,-103,-114,-117,-113,-109,-104,-96,-84,-71,-64,-66,-77,-92,-107,-117,-117,-105,-90,-81,-83,-90,-93,-87,-76,-67,-62,-63,-71,-86,-97,-92,-70,-42,-17,-2,3,-2,-19,-42,-65,-84,-102,-117,-123,-114,-95,-80,-79,-91,-110,-127,-137,-138,-135,-134,-136,-135,-123,-100,-77,-60,-44,-28,-20,-31,-54,-66,-51,-18},
            {6,50,14,-62,-48,61,82,-71,-91,555,2098,4170,6035,6928,6078,2756,-3054,-9692,-13906,-12735,-5936,3384,10799,13572,12040,8517,5220,3145,2312,2419,3083,3834,4287,4364,4146,3454,1819,-920,-4041,-6232,-6617,-5484,-3970,-3091,-3121,-3744,-4496,-4980,-4875,-4085,-2932,-2025,-1754,-1930,-2010,-1631,-848,91,1005,1749,2105,1945,1486,1202,1373,1784,1994,1825,1493,1266,1159,1022,818,669,655,697,685,604,476,227,-248,-898,-1467,-1714,-1646,-1489,-1442,-1503,-1541,-1482,-1373,-1283,-1191,-1004,-679,-298,-14,80,11,-126,-263,-369,-400,-304,-79,190,407,572,759,980,1110,989,596,88,-328,-528,-495,-280,9,217,216,7,-277,-484,-559,-541,-483,-410,-345,-326,-362,-416,-441,-445,-482,-590,-748,-900,-1006,-1045,-1007,-890,-719,-540,-386,-259,-143,-35,60,139,207,259,282,274,252,234,218,187,133,70,30,31,77,147,209,220,155,23,-139,-289,-399,-460,-476,-453,-403,-346,-292,-249,-217,-200,-203,-229,-270,-316,-352,-364,-342,-289,-219,-150,-83,-9,71,133,147,102,17,-74,-143,-179,-182,-159,-115,-63,-17,9,7,-29,-92,-164,-227,-268,-284,-270,-226,-161,-96,-49,-24,-12,-9,-17,-41,-76,-111,-140,-161,-173,-167,-143,-109,-76,-50,-33,-30,-48,-87,-136,-179,-204,-209,-195,-166,-131,-98,-75,-61,-54,-51,-54,-63,-80,-100,-118,-127,-122,-102,-74,-48,-26,-11,-4,-4,-10,-18,-30,-45,-61,-73,-72,-60,-41,-22,-13,-14,-23,-28,-22,-8}
        },
        {    // H60e160a.wav
            {-1,7,1,-17,-18,4,17,-5,-30,-14,25,22,-28,-47,10,60,2,-75,109,766,1822,2991,3955,4309,3413,651,-3753,-8169,-10166,-8167,-2766,3549,8085,9578,8529,6343,4274,2944,2415,2429,2632,2795,2927,3134,3302,3014,1888,45,-1840,-3020,-3239,-2833,-2352,-2152,-2300,-2703,-3196,-3538,-3491,-3026,-2411,-2002,-1925,-1987,-1903,-1557,-1026,-429,151,616,851,836,739,794,1081,1459,1717,1758,1630,1435,1248,1099,950,702,291,-183,-457,-327,117,514,525,104,-518,-1051,-1336,-1362,-1202,-971,-802,-784,-890,-1002,-1006,-890,-734,-628,-603,-629,-644,-593,-440,-190,104,360,501,510,440,378,391,477,581,641,622,518,339,109,-129,-332,-471,-539,-533,-458,-345,-258,-250,-319,-410,-472,-497,-509,-511,-485,-421,-343,-282,-251,-244,-264,-331,-453,-602,-724,-770,-722,-591,-414,-236,-99,-20,6,-3,-36,-82,-128,-153,-148,-120,-88,-68,-67,-84,-108,-118,-98,-46,13,43,18,-61,-173,-284,-359,-379,-347,-288,-232,-197,-184,-184,-185,-182,-177,-174,-181,-198,-218,-229,-232,-231,-230,-222,-195,-149,-96,-55,-36,-43,-69,-104,-134,-148,-146,-137,-129,-121,-108,-89,-74,-71,-85,-107,-125,-132,-130,-122,-112,-103,-95,-89,-85,-82,-80,-80,-83,-89,-98,-104,-106,-102,-93,-80,-64,-48,-37,-32,-36,-50,-74,-101,-123,-133,-129,-114,-97,-86,-89,-104,-120,-128,-127,-126,-131,-136,-136,-130,-125,-116,-96,-66,-41,-32,-33,-32,-33,-50,-81,-98,-77,-29},
            {-31,-19,31,44,-18,-72,-16,82,44,-107,6,827,2411,4315,5875,6389,5072,1279,-4651,-10628,-13419,-10763,-3349,5330,11341,12847,10746,7297,4359,2676,2190,2525,3208,3795,4085,4143,3967,3197,1367,-1422,-4222,-5833,-5761,-4575,-3339,-2783,-2983,-3627,-4329,-4719,-4499,-3652,-2595,-1904,-1814,-2022,-2025,-1576,-778,154,1044,1693,1886,1612,1209,1102,1381,1723,1791,1592,1379,1286,1203,1016,801,702,713,691,558,373,185,-69,-446,-845,-1087,-1145,-1190,-1363,-1583,-1643,-1476,-1247,-1152,-1187,-1169,-949,-573,-223,-42,-44,-159,-315,-462,-546,-505,-316,-34,253,495,703,891,1009,975,763,442,120,-126,-258,-255,-123,54,141,55,-157,-360,-462,-470,-440,-406,-376,-365,-391,-441,-471,-456,-427,-436,-504,-620,-765,-924,-1055,-1094,-998,-799,-579,-401,-275,-176,-84,2,83,162,236,287,301,288,263,235,199,153,110,87,90,110,130,139,122,64,-43,-181,-316,-416,-472,-489,-476,-435,-369,-291,-227,-191,-182,-188,-203,-229,-269,-314,-343,-336,-292,-228,-161,-99,-35,32,92,123,106,40,-55,-147,-207,-218,-184,-126,-67,-20,8,12,-17,-77,-151,-213,-250,-257,-240,-202,-149,-97,-59,-39,-33,-33,-39,-50,-67,-87,-110,-135,-152,-152,-133,-104,-74,-50,-35,-33,-51,-87,-133,-174,-200,-205,-187,-155,-120,-95,-82,-73,-64,-58,-60,-73,-90,-102,-107,-103,-90,-69,-47,-28,-15,-8,-8,-13,-23,-35,-48,-65,-81,-90,-83,-64,-42,-26,-17,-13,-8,-3}
        },
        {    // H60e170a.wav
            {5,-16,-20,4,19,-3,-30,-13,30,29,-26,-50,10,68,7,-83,106,827,2018,3358,4447,4794,3691,539,-4312,-9016,-10946,-8493,-2444,4397,9101,10386,8937,6392,4141,2806,2371,2500,2799,3026,3188,3381,3472,3022,1658,-438,-2492,-3680,-3753,-3138,-2499,-2253,-2456,-2953,-3515,-3852,-3717,-3113,-2379,-1935,-1914,-2059,-1997,-1572,-898,-176,447,870,1022,939,809,842,1092,1422,1653,1714,1627,1447,1231,1058,960,850,583,144,-262,-371,-131,225,369,133,-402,-1005,-1433,-1543,-1355,-1043,-827,-817,-942,-1038,-996,-833,-645,-522,-505,-574,-663,-691,-602,-398,-123,167,419,583,635,605,564,564,600,629,620,562,442,246,-12,-269,-445,-500,-457,-376,-312,-295,-327,-382,-425,-444,-460,-493,-531,-537,-485,-393,-302,-248,-253,-332,-482,-668,-824,-892,-849,-715,-532,-340,-179,-70,-9,27,57,80,82,63,41,31,34,39,31,6,-29,-62,-71,-46,-2,25,-2,-86,-200,-303,-364,-377,-353,-313,-277,-257,-249,-238,-212,-172,-137,-122,-135,-169,-209,-239,-253,-254,-246,-231,-202,-151,-85,-23,12,14,-13,-53,-95,-133,-158,-167,-161,-142,-113,-79,-51,-44,-59,-86,-109,-124,-132,-138,-139,-133,-120,-102,-82,-62,-47,-44,-51,-62,-73,-85,-98,-106,-101,-88,-75,-67,-60,-51,-46,-53,-68,-85,-100,-114,-124,-125,-115,-100,-90,-86,-84,-85,-90,-98,-104,-103,-101,-102,-101,-94,-78,-61,-44,-26,-10,-7,-19,-37,-47,-56,-77,-105,-113,-83,-29},
            {18,-10,-38,-15,38,40,-27,-66,2,82,22,-107,66,904,2387,4099,5466,5845,4448,670,-5021,-10467,-12618,-9606,-2400,5611,10911,12034,9949,6733,4055,2580,2223,2571,3139,3573,3800,3915,3827,3091,1293,-1343,-3850,-5181,-5023,-3974,-2960,-2554,-2790,-3410,-4080,-4447,-4223,-3428,-2476,-1891,-1846,-2040,-2025,-1585,-806,109,953,1506,1601,1319,1013,1010,1304,1594,1654,1541,1431,1355,1216,997,823,774,751,605,335,79,-80,-188,-313,-452,-600,-828,-1193,-1572,-1721,-1534,-1193,-997,-1047,-1167,-1125,-865,-522,-260,-154,-195,-339,-517,-641,-640,-495,-240,70,379,637,800,857,829,754,653,524,359,169,-6,-117,-143,-117,-98,-127,-198,-277,-344,-399,-438,-452,-445,-442,-462,-490,-491,-451,-399,-375,-405,-496,-645,-831,-997,-1070,-1013,-851,-650,-459,-300,-177,-91,-31,33,119,211,273,286,266,242,223,201,169,132,102,79,61,50,45,33,-8,-91,-205,-320,-409,-462,-479,-463,-421,-363,-298,-232,-172,-129,-116,-139,-187,-246,-301,-339,-348,-318,-256,-180,-109,-48,6,55,84,79,37,-36,-120,-191,-224,-206,-148,-77,-24,-3,-15,-48,-92,-136,-172,-195,-204,-197,-174,-144,-115,-93,-73,-54,-42,-43,-54,-63,-67,-74,-95,-122,-138,-132,-110,-85,-63,-46,-39,-49,-78,-118,-157,-184,-193,-182,-152,-117,-89,-76,-73,-76,-79,-82,-85,-88,-91,-92,-88,-76,-58,-40,-23,-9,-1,-2,-15,-33,-52,-70,-86,-98,-98,-86,-69,-54,-42,-26,-9}
        },
        {    // H60e180a.wav
            {-22,7,23,-3,-36,-19,30,32,-28,-58,7,73,9,-97,96,885,2222,3738,4956,5297,4004,484,-4807,-9823,-11738,-8885,-2217,5154,10054,11170,9360,6477,4037,2669,2304,2551,2973,3291,3490,3658,3657,3033,1416,-958,-3207,-4418,-4343,-3506,-2691,-2379,-2612,-3187,-3817,-4170,-3978,-3261,-2407,-1892,-1869,-2055,-2031,-1598,-849,-1,737,1194,1279,1088,894,933,1194,1469,1596,1590,1528,1418,1230,1019,888,837,720,427,44,-212,-222,-68,50,-26,-354,-874,-1401,-1689,-1600,-1248,-931,-865,-1001,-1116,-1049,-819,-557,-376,-321,-391,-538,-674,-707,-595,-360,-56,259,523,684,731,712,689,679,654,586,477,338,173,-11,-182,-293,-324,-301,-270,-268,-305,-371,-439,-479,-482,-471,-477,-501,-510,-474,-403,-337,-319,-375,-506,-682,-847,-946,-950,-870,-730,-547,-348,-171,-52,11,53,97,135,152,157,174,206,222,192,122,46,-7,-30,-23,9,47,52,-9,-129,-260,-360,-414,-431,-420,-388,-343,-301,-265,-225,-175,-129,-112,-138,-189,-239,-269,-279,-276,-268,-250,-219,-171,-108,-42,14,45,47,21,-26,-88,-150,-193,-202,-175,-127,-78,-48,-42,-56,-81,-104,-121,-134,-148,-162,-168,-162,-143,-115,-84,-56,-38,-34,-42,-53,-64,-78,-95,-113,-123,-119,-101,-78,-57,-43,-43,-58,-85,-116,-141,-155,-158,-149,-129,-106,-87,-80,-83,-89,-92,-91,-89,-89,-89,-89,-87,-80,-64,-43,-24,-12,-9,-11,-19,-34,-54,-72,-83,-92,-102,-108,-96,-62,-20},
            {-22,7,23,-3,-36,-19,30,32,-28,-58,7,73,9,-97,96,885,2222,3738,4956,5297,4004,484,-4807,-9823,-11738,-8885,-2217,5154,10054,11170,9360,6477,4037,2669,2304,2551,2973,3291,3490,3658,3657,3033,1416,-958,-3207,-4418,-4343,-3506,-2691,-2379,-2612,-3187,-3817,-4170,-3978,-3261,-2407,-1892,-1869,-2055,-2031,-1598,-849,-1,737,1194,1279,1088,894,933,1194,1469,1596,1590,1528,1418,1230,1019,888,837,720,427,44,-212,-222,-68,50,-26,-354,-874,-1401,-1689,-1600,-1248,-931,-865,-1001,-1116,-1049,-819,-557,-376,-321,-391,-538,-674,-707,-595,-360,-56,259,523,684,731,712,689,679,654,586,477,338,173,-11,-182,-293,-324,-301,-270,-268,-305,-371,-439,-479,-482,-471,-477,-501,-510,-474,-403,-337,-319,-375,-506,-682,-847,-946,-950,-870,-730,-547,-348,-171,-52,11,53,97,135,152,157,174,206,222,192,122,46,-7,-30,-23,9,47,52,-9,-129,-260,-360,-414,-431,-420,-388,-343,-301,-265,-225,-175,-129,-112,-138,-189,-239,-269,-279,-276,-268,-250,-219,-171,-108,-42,14,45,47,21,-26,-88,-150,-193,-202,-175,-127,-78,-48,-42,-56,-81,-104,-121,-134,-148,-162,-168,-162,-143,-115,-84,-56,-38,-34,-42,-53,-64,-78,-95,-113,-123,-119,-101,-78,-57,-43,-43,-58,-85,-116,-141,-155,-158,-149,-129,-106,-87,-80,-83,-89,-92,-91,-89,-89,-89,-89,-87,-80,-64,-43,-24,-12,-9,-11,-19,-34,-54,-72,-83,-92,-102,-108,-96,-62,-20}
        }
    },
    {    // elev70 
        {    // H70e000a.wav
            {-1,-12,-10,0,-1,-5,5,21,16,-10,-14,15,26,-12,-45,-10,51,32,-54,-67,39,102,-6,-136,-54,145,113,-134,26,1098,2656,3728,4057,4373,4906,4100,-110,-7252,-13248,-13412,-6841,2556,9547,11800,10644,8504,6541,4772,3359,2832,3195,3641,3463,2842,2323,1801,531,-1788,-4378,-6094,-6562,-6319,-5947,-5430,-4526,-3446,-2804,-2877,-3197,-3036,-2197,-1158,-461,-162,58,403,777,1068,1376,1832,2291,2413,2071,1552,1245,1232,1293,1261,1191,1144,976,509,-151,-632,-681,-429,-189,-108,-107,-112,-193,-435,-782,-1112,-1398,-1689,-1961,-2073,-1930,-1609,-1274,-998,-733,-427,-103,190,447,683,870,947,896,769,659,630,695,808,876,821,634,384,151,-43,-221,-388,-519,-598,-635,-643,-614,-551,-506,-538,-635,-706,-668,-535,-390,-289,-215,-129,-38,10,-16,-95,-177,-233,-267,-303,-365,-472,-626,-809,-976,-1071,-1054,-913,-676,-396,-137,49,133,120,43,-47,-105,-110,-62,15,86,119,97,30,-49,-106,-121,-102,-75,-71,-110,-184,-268,-335,-368,-365,-330,-272,-200,-129,-69,-24,0,-11,-66,-149,-234,-295,-325,-329,-310,-274,-229,-185,-140,-88,-39,-17,-39,-100,-171,-226,-250,-235,-180,-97,-10,54,87,88,60,5,-64,-118,-140,-132,-111,-88,-57,-13,34,71,86,74,36,-21,-84,-139,-182,-213,-231,-229,-205,-167,-125,-90,-72,-80,-114,-160,-199,-221,-231,-230,-209,-160,-91,-26,18,37,33,11,-19,-40,-41,-30,-29,-41,-50,-39,-14},
            {-1,-12,-10,0,-1,-5,5,21,16,-10,-14,15,26,-12,-45,-10,51,32,-54,-67,39,102,-6,-136,-54,145,113,-134,26,1098,2656,3728,4057,4373,4906,4100,-110,-7252,-13248,-13412,-6841,2556,9547,11800,10644,8504,6541,4772,3359,2832,3195,3641,3463,2842,2323,1801,531,-1788,-4378,-6094,-6562,-6319,-5947,-5430,-4526,-3446,-2804,-2877,-3197,-3036,-2197,-1158,-461,-162,58,403,777,1068,1376,1832,2291,2413,2071,1552,1245,1232,1293,1261,1191,1144,976,509,-151,-632,-681,-429,-189,-108,-107,-112,-193,-435,-782,-1112,-1398,-1689,-1961,-2073,-1930,-1609,-1274,-998,-733,-427,-103,190,447,683,870,947,896,769,659,630,695,808,876,821,634,384,151,-43,-221,-388,-519,-598,-635,-643,-614,-551,-506,-538,-635,-706,-668,-535,-390,-289,-215,-129,-38,10,-16,-95,-177,-233,-267,-303,-365,-472,-626,-809,-976,-1071,-1054,-913,-676,-396,-137,49,133,120,43,-47,-105,-110,-62,15,86,119,97,30,-49,-106,-121,-102,-75,-71,-110,-184,-268,-335,-368,-365,-330,-272,-200,-129,-69,-24,0,-11,-66,-149,-234,-295,-325,-329,-310,-274,-229,-185,-140,-88,-39,-17,-39,-100,-171,-226,-250,-235,-180,-97,-10,54,87,88,60,5,-64,-118,-140,-132,-111,-88,-57,-13,34,71,86,74,36,-21,-84,-139,-182,-213,-231,-229,-205,-167,-125,-90,-72,-80,-114,-160,-199,-221,-231,-230,-209,-160,-91,-26,18,37,33,11,-19,-40,-41,-30,-29,-41,-50,-39,-14}
        },
        {    // H70e015a.wav
            {-1,3,-1,-9,-7,0,-1,-6,1,15,14,-4,-8,12,21,-8,-37,-12,37,28,-40,-58,22,81,6,-103,-54,103,99,-89,14,855,2161,3146,3507,3768,4184,3602,276,-5689,-11170,-12136,-7277,672,7366,10367,10221,8719,6929,5058,3402,2557,2684,3148,3212,2828,2406,1980,1022,-808,-3036,-4749,-5481,-5504,-5274,-4874,-4162,-3265,-2643,-2588,-2841,-2848,-2346,-1585,-972,-636,-400,-97,256,594,964,1437,1897,2089,1909,1568,1373,1399,1464,1411,1292,1206,1075,725,161,-350,-549,-447,-262,-154,-112,-96,-156,-365,-686,-1006,-1266,-1499,-1712,-1823,-1752,-1529,-1265,-1025,-784,-504,-211,41,240,417,584,704,734,677,592,550,593,700,793,789,664,472,277,99,-82,-272,-438,-552,-622,-664,-657,-574,-445,-368,-417,-560,-678,-672,-545,-372,-230,-145,-109,-104,-120,-144,-165,-177,-189,-216,-275,-373,-501,-639,-758,-832,-837,-762,-617,-428,-230,-63,38,54,-6,-103,-191,-236,-236,-205,-158,-107,-69,-58,-76,-101,-111,-100,-85,-89,-120,-167,-216,-261,-292,-298,-267,-210,-155,-126,-120,-113,-91,-67,-67,-100,-152,-202,-238,-265,-282,-283,-260,-215,-158,-99,-51,-26,-33,-75,-138,-200,-240,-243,-208,-144,-71,-3,48,70,55,7,-55,-104,-123,-115,-92,-64,-30,8,46,76,92,94,75,31,-31,-96,-149,-184,-205,-213,-206,-183,-151,-124,-115,-126,-149,-174,-195,-211,-222,-222,-205,-169,-117,-60,-8,30,46,41,20,-9,-39,-60,-61,-42,-14},
            {-8,2,-1,-8,4,25,19,-12,-15,23,38,-12,-59,-16,62,41,-66,-84,48,132,2,-162,-66,179,143,-174,-25,1216,3052,4311,4682,5058,5745,4896,31,-8293,-15211,-15186,-7281,3669,11373,13224,11141,8302,6171,4611,3550,3367,3918,4240,3657,2642,2028,1649,396,-2277,-5404,-7416,-7733,-7094,-6416,-5810,-4919,-3838,-3196,-3309,-3623,-3277,-2099,-763,20,246,425,858,1356,1666,1870,2201,2596,2690,2291,1661,1214,1073,1060,1038,1052,1078,875,269,-508,-956,-836,-411,-101,-35,-46,-30,-106,-397,-825,-1223,-1553,-1891,-2210,-2335,-2145,-1748,-1354,-1044,-732,-339,75,399,609,780,957,1091,1093,950,761,674,762,956,1083,1002,717,350,23,-223,-399,-511,-555,-563,-589,-652,-709,-721,-702,-694,-699,-677,-609,-521,-433,-324,-166,5,105,85,-13,-108,-156,-176,-207,-270,-381,-554,-794,-1057,-1262,-1329,-1222,-960,-606,-251,9,112,72,-23,-72,-27,86,202,277,307,301,255,167,53,-46,-98,-96,-66,-42,-55,-120,-230,-354,-452,-497,-482,-412,-299,-167,-49,23,43,22,-21,-80,-152,-227,-289,-328,-340,-328,-292,-238,-166,-85,-9,37,27,-41,-139,-226,-273,-274,-232,-159,-70,14,77,110,108,67,-10,-98,-161,-181,-166,-136,-100,-52,7,66,105,112,86,29,-47,-127,-193,-239,-264,-268,-248,-205,-149,-93,-49,-28,-39,-82,-143,-195,-226,-235,-228,-201,-149,-80,-17,21,34,36,35,31,18,-3,-28,-50,-67,-74,-71,-56,-32,-10}
        },
        {    // H70e030a.wav
            {1,-3,-1,4,1,-5,-6,-2,-2,-4,1,13,15,1,-6,7,17,-2,-27,-14,26,27,-23,-47,7,64,20,-73,-58,66,95,-43,-17,583,1653,2584,3011,3250,3598,3293,860,-4013,-9136,-11037,-7922,-1359,5106,8852,9655,8746,7171,5338,3610,2561,2440,2791,2931,2689,2387,2144,1546,169,-1765,-3496,-4459,-4709,-4618,-4351,-3831,-3111,-2529,-2382,-2565,-2663,-2394,-1863,-1364,-1024,-738,-399,-42,264,574,999,1489,1810,1797,1563,1384,1395,1478,1470,1368,1263,1139,864,396,-88,-357,-364,-261,-188,-158,-135,-168,-337,-629,-926,-1145,-1311,-1476,-1607,-1613,-1470,-1253,-1040,-833,-592,-327,-104,34,126,253,447,655,782,777,676,575,552,602,659,655,574,431,233,-11,-266,-464,-569,-600,-604,-596,-557,-490,-444,-470,-556,-626,-613,-512,-371,-251,-189,-187,-218,-231,-192,-107,-27,-4,-59,-173,-313,-445,-543,-590,-588,-559,-526,-497,-460,-397,-309,-212,-135,-101,-115,-165,-223,-267,-287,-291,-288,-281,-263,-228,-176,-115,-62,-37,-53,-106,-173,-226,-253,-257,-246,-224,-188,-146,-110,-87,-73,-62,-56,-64,-90,-123,-149,-166,-181,-196,-210,-212,-202,-178,-145,-109,-82,-76,-96,-136,-181,-218,-237,-229,-193,-136,-74,-23,6,11,-7,-38,-66,-78,-71,-49,-21,10,39,65,84,94,90,69,34,-8,-51,-97,-145,-189,-216,-218,-201,-174,-151,-137,-139,-157,-181,-199,-204,-200,-196,-190,-170,-131,-81,-33,6,34,47,40,17,-6,-13,-6},
            {1,-12,0,30,29,-10,-24,16,44,-4,-64,-27,66,59,-64,-108,33,155,33,-176,-110,184,207,-167,-164,1050,3114,4713,5276,5688,6511,5960,1122,-7965,-16264,-17258,-9103,3222,12297,14498,11758,8101,5715,4490,3927,4076,4724,4910,3962,2499,1659,1440,508,-2118,-5649,-8228,-8828,-8017,-6921,-5980,-5018,-4105,-3738,-4056,-4340,-3696,-2117,-532,247,366,561,1179,1874,2233,2349,2578,2918,2960,2474,1763,1298,1171,1114,974,875,873,701,99,-725,-1203,-1034,-506,-124,-47,-63,-13,-14,-241,-662,-1120,-1565,-2040,-2470,-2629,-2389,-1905,-1453,-1134,-819,-382,120,526,762,894,1004,1089,1084,968,824,784,912,1128,1245,1123,788,393,64,-187,-401,-561,-613,-574,-556,-656,-837,-960,-939,-819,-715,-694,-714,-684,-535,-283,-15,157,171,56,-90,-175,-168,-111,-77,-133,-310,-591,-918,-1214,-1406,-1438,-1285,-972,-588,-254,-52,21,34,58,115,188,254,310,356,385,374,315,216,108,18,-34,-46,-31,-20,-54,-159,-318,-477,-575,-586,-519,-400,-260,-127,-33,9,12,0,-21,-64,-136,-221,-293,-336,-349,-332,-280,-196,-98,-8,52,70,37,-46,-153,-244,-286,-272,-216,-140,-61,11,66,96,92,48,-30,-120,-193,-226,-221,-187,-135,-69,-1,60,105,125,112,57,-33,-135,-221,-280,-314,-322,-298,-238,-152,-67,-4,19,0,-54,-125,-188,-228,-244,-239,-218,-178,-117,-41,37,97,124,112,68,13,-35,-72,-100,-120,-125,-108,-70,-27,5,15,8}
        },
        {    // H70e045a.wav
            {-3,1,0,-2,-1,1,-1,-5,-4,-1,-3,-6,-2,8,10,0,-5,6,14,-2,-23,-13,18,19,-21,-40,5,50,14,-61,-47,55,79,-34,-10,495,1407,2231,2654,2911,3216,2920,771,-3525,-8141,-10075,-7625,-1924,4047,7857,9017,8403,6956,5196,3562,2566,2394,2640,2731,2534,2320,2188,1767,648,-1035,-2650,-3660,-4028,-4019,-3799,-3365,-2800,-2374,-2292,-2444,-2501,-2269,-1856,-1478,-1198,-916,-572,-232,43,325,727,1204,1538,1577,1416,1293,1325,1424,1451,1389,1295,1158,895,492,83,-181,-276,-293,-299,-277,-225,-224,-358,-605,-855,-1040,-1189,-1346,-1472,-1483,-1355,-1160,-986,-855,-728,-562,-341,-68,233,504,676,714,650,555,491,480,516,572,611,597,510,355,156,-62,-266,-426,-533,-599,-643,-660,-624,-536,-439,-393,-421,-490,-540,-532,-461,-352,-242,-161,-126,-123,-122,-96,-48,-3,5,-46,-153,-290,-413,-485,-496,-474,-459,-473,-503,-513,-476,-391,-285,-196,-158,-181,-248,-323,-370,-379,-361,-337,-318,-299,-264,-203,-125,-55,-26,-52,-120,-193,-239,-247,-223,-183,-141,-105,-78,-56,-36,-16,-10,-26,-63,-105,-136,-150,-152,-150,-154,-170,-196,-219,-221,-195,-155,-126,-123,-145,-179,-215,-240,-244,-223,-181,-128,-75,-33,-7,1,-4,-12,-17,-15,-8,4,21,41,62,77,83,74,51,18,-18,-51,-85,-123,-164,-197,-212,-208,-191,-171,-156,-153,-163,-180,-195,-200,-194,-180,-161,-136,-104,-67,-31,-5,7,6,-1,-5,-3},
            {-11,19,38,8,-29,-7,44,28,-50,-64,31,91,-4,-122,-52,133,129,-106,-203,56,282,24,-316,322,2262,4427,5622,6109,6892,7246,4220,-3973,-14147,-19230,-14393,-2022,10070,15448,13778,9272,5819,4371,4144,4556,5321,5667,4755,2911,1534,1330,1164,-707,-4419,-8084,-9716,-9112,-7592,-6314,-5391,-4584,-4118,-4341,-4856,-4631,-3155,-1154,166,441,399,844,1737,2475,2783,2951,3230,3368,2980,2171,1484,1258,1311,1297,1153,987,709,87,-799,-1438,-1395,-822,-283,-118,-175,-163,-78,-136,-442,-885,-1356,-1868,-2398,-2751,-2711,-2297,-1757,-1296,-903,-471,11,437,734,924,1055,1114,1065,925,796,791,948,1185,1343,1286,1002,599,210,-103,-337,-489,-543,-540,-582,-738,-941,-1043,-976,-833,-772,-843,-943,-923,-719,-393,-68,147,204,125,-17,-133,-164,-118,-65,-91,-247,-525,-859,-1153,-1323,-1326,-1174,-936,-699,-513,-359,-180,47,277,430,466,413,340,293,278,272,255,218,161,96,41,14,11,5,-49,-176,-352,-516,-609,-605,-524,-400,-269,-157,-84,-49,-30,-9,2,-28,-113,-221,-307,-345,-339,-299,-230,-140,-51,16,54,69,54,-1,-95,-195,-264,-280,-248,-182,-100,-20,42,77,81,49,-21,-117,-210,-264,-269,-235,-179,-113,-41,29,89,128,132,87,-6,-124,-232,-305,-338,-337,-305,-244,-166,-86,-19,24,30,-7,-77,-152,-212,-252,-277,-279,-236,-143,-26,76,135,151,132,84,16,-59,-119,-155,-167,-159,-125,-69,-7,35,41,23,3,-4}
        },
        {    // H70e060a.wav
            {-8,-5,1,2,-1,-3,1,3,-1,-5,-4,-1,-3,-5,1,10,7,-3,-4,8,11,-8,-21,-4,20,9,-26,-26,20,42,-8,-59,-15,69,46,-51,73,649,1487,2152,2505,2793,2995,2284,-346,-4632,-8470,-9256,-6058,-450,4814,7859,8528,7675,6141,4470,3128,2479,2473,2647,2605,2395,2269,2179,1710,571,-997,-2412,-3273,-3589,-3553,-3276,-2819,-2366,-2165,-2268,-2433,-2363,-2018,-1611,-1335,-1161,-945,-640,-324,-37,293,721,1140,1350,1296,1143,1106,1232,1390,1452,1401,1277,1071,756,374,34,-191,-319,-390,-395,-312,-199,-185,-348,-629,-894,-1066,-1160,-1225,-1286,-1342,-1377,-1338,-1144,-764,-295,73,213,170,114,182,366,550,624,569,455,373,379,453,522,507,375,157,-87,-299,-448,-524,-530,-484,-418,-368,-363,-412,-498,-583,-626,-598,-502,-369,-241,-158,-138,-168,-206,-205,-143,-36,67,118,91,-4,-134,-258,-347,-396,-420,-445,-490,-551,-608,-628,-587,-487,-363,-268,-239,-275,-338,-383,-391,-369,-343,-329,-326,-317,-280,-204,-103,-18,13,-22,-94,-160,-194,-191,-165,-125,-83,-50,-32,-24,-15,-2,0,-25,-75,-132,-173,-188,-181,-166,-162,-179,-215,-248,-259,-239,-199,-162,-142,-147,-173,-211,-240,-244,-215,-164,-108,-57,-19,5,15,15,11,9,9,10,14,24,39,54,62,57,41,18,-5,-28,-53,-83,-118,-154,-182,-198,-200,-190,-176,-166,-166,-172,-177,-172,-160,-147,-137,-126,-111,-90,-66,-43,-24,-9,-2,0},
            {22,32,-1,-27,6,48,14,-62,-54,48,84,-29,-124,-20,151,97,-143,-179,115,277,-54,-314,548,2671,4879,6129,6803,7627,7386,3120,-6122,-16107,-19597,-12809,506,12050,16049,13192,8215,4905,3915,4246,5109,5965,5963,4544,2463,1259,1341,1186,-1015,-5108,-8908,-10372,-9420,-7508,-5907,-4903,-4389,-4462,-5056,-5424,-4645,-2722,-782,101,46,81,845,1949,2671,2910,3122,3496,3635,3150,2279,1634,1484,1552,1511,1357,1179,806,8,-1027,-1691,-1582,-953,-409,-247,-282,-251,-180,-270,-592,-1048,-1562,-2124,-2637,-2876,-2691,-2192,-1644,-1192,-777,-301,203,623,892,1027,1063,1015,915,832,828,921,1077,1235,1311,1223,946,547,152,-146,-333,-449,-545,-656,-783,-880,-889,-812,-745,-804,-995,-1177,-1178,-944,-576,-238,-35,22,-8,-56,-72,-47,-7,5,-50,-192,-418,-696,-961,-1135,-1165,-1064,-896,-730,-598,-481,-335,-128,134,399,586,633,536,361,199,112,99,123,145,146,122,78,29,-11,-49,-113,-232,-392,-532,-593,-563,-473,-364,-259,-163,-85,-32,-6,-3,-26,-80,-161,-247,-311,-335,-310,-240,-144,-47,28,73,90,80,39,-31,-115,-189,-241,-263,-246,-189,-106,-22,38,66,60,12,-75,-179,-259,-290,-273,-228,-169,-101,-27,46,103,132,117,53,-53,-176,-280,-340,-349,-316,-259,-189,-115,-42,19,52,38,-22,-110,-201,-271,-305,-293,-236,-146,-44,45,107,134,127,89,27,-46,-117,-167,-185,-172,-141,-98,-39,27,68,46,-28,-93,-95,-39}
        },
        {    // H70e075a.wav
            {-3,-7,-6,-1,2,-1,-2,0,2,-1,-6,-5,-2,-2,-4,0,7,7,-2,-4,6,11,-4,-20,-9,14,12,-19,-28,10,41,7,-46,-25,53,56,-37,9,447,1201,1899,2328,2637,2868,2388,238,-3623,-7537,-9027,-6768,-1737,3586,7096,8217,7588,6122,4502,3218,2582,2537,2673,2627,2430,2338,2344,2052,1105,-364,-1818,-2800,-3238,-3295,-3090,-2682,-2237,-2020,-2141,-2392,-2426,-2112,-1636,-1264,-1072,-945,-770,-542,-277,72,537,999,1239,1165,936,828,970,1255,1477,1507,1340,1026,637,269,16,-103,-159,-229,-309,-339,-304,-266,-300,-424,-623,-897,-1231,-1539,-1663,-1500,-1109,-678,-379,-252,-222,-195,-129,-29,84,197,301,378,410,394,352,327,344,382,377,273,75,-148,-305,-347,-285,-182,-110,-116,-204,-340,-474,-563,-588,-553,-487,-429,-401,-392,-369,-309,-227,-156,-115,-95,-70,-24,38,93,112,74,-21,-142,-245,-310,-351,-404,-490,-598,-696,-753,-747,-669,-534,-391,-299,-290,-343,-400,-416,-386,-334,-290,-263,-245,-217,-163,-84,-3,46,38,-19,-89,-135,-142,-117,-79,-42,-19,-14,-24,-37,-48,-59,-82,-121,-167,-203,-218,-211,-191,-180,-192,-228,-269,-286,-263,-212,-157,-121,-114,-134,-170,-204,-217,-201,-159,-106,-55,-16,5,11,8,6,8,13,16,18,21,25,30,33,31,25,12,-5,-25,-46,-70,-100,-133,-162,-178,-183,-177,-166,-152,-141,-137,-138,-140,-138,-134,-131,-125,-113,-91,-64,-39,-20,-9,-2},
            {38,9,-28,-11,38,29,-42,-63,21,87,10,-108,-62,109,130,-78,-198,18,264,71,-302,141,1933,4303,6052,7017,7810,7821,4566,-3561,-13764,-19384,-15351,-3292,9369,15678,14408,9501,5433,3861,4054,4931,5817,6012,4936,3008,1599,1473,1572,-8,-3761,-7948,-10230,-9853,-7973,-6148,-5038,-4550,-4588,-5095,-5557,-5104,-3447,-1405,-161,-21,-185,224,1218,2176,2740,3111,3495,3661,3275,2495,1894,1804,1983,2006,1770,1434,1008,318,-604,-1331,-1456,-1066,-645,-516,-554,-482,-288,-223,-483,-1024,-1676,-2305,-2794,-2994,-2815,-2333,-1751,-1221,-748,-280,186,590,878,1023,1025,927,818,789,856,972,1090,1203,1277,1225,971,565,163,-106,-249,-362,-517,-699,-839,-872,-785,-643,-576,-698,-990,-1274,-1333,-1085,-652,-253,-48,-52,-164,-256,-245,-132,10,83,26,-161,-425,-693,-903,-1014,-1016,-937,-812,-669,-514,-344,-166,13,190,354,479,528,483,370,237,128,60,34,45,74,90,71,27,-14,-46,-100,-210,-363,-498,-560,-543,-478,-393,-295,-193,-103,-44,-12,2,-4,-48,-133,-234,-310,-335,-305,-232,-136,-41,35,86,115,117,82,9,-85,-175,-244,-277,-264,-205,-120,-42,8,31,30,-5,-81,-182,-269,-308,-294,-246,-182,-108,-33,33,82,106,97,46,-44,-151,-248,-313,-338,-320,-262,-182,-96,-17,47,81,60,-21,-135,-239,-301,-315,-286,-219,-126,-30,49,100,121,110,65,-4,-74,-127,-164,-184,-183,-154,-102,-45,5,35,27,-29,-106,-148,-118,-43}
        },
        {    // H70e090a.wav
            {1,-2,-4,-2,0,0,-2,0,3,2,-3,-5,-2,-1,-3,-2,6,11,5,-3,1,11,8,-9,-14,5,18,-2,-29,-14,29,34,-14,-38,17,71,14,-59,128,712,1471,2069,2455,2769,2759,1576,-1414,-5481,-8468,-8272,-4593,778,5374,7728,7878,6687,5044,3589,2735,2573,2770,2847,2643,2421,2423,2441,1962,750,-847,-2202,-2947,-3138,-3011,-2726,-2386,-2150,-2158,-2353,-2477,-2319,-1923,-1507,-1215,-1010,-801,-586,-407,-214,111,586,1032,1224,1121,907,805,890,1083,1271,1363,1280,979,526,109,-105,-118,-80,-119,-214,-262,-233,-228,-382,-721,-1128,-1421,-1472,-1284,-980,-710,-554,-484,-422,-331,-238,-165,-89,27,169,274,291,239,180,159,171,187,185,156,96,13,-67,-112,-108,-72,-40,-47,-106,-203,-298,-347,-335,-297,-290,-358,-487,-620,-684,-635,-483,-284,-111,-16,1,-20,-29,-4,45,87,94,56,-17,-98,-166,-217,-271,-359,-497,-668,-826,-915,-899,-780,-604,-437,-332,-303,-324,-358,-372,-359,-326,-283,-233,-168,-85,11,93,129,103,33,-41,-84,-88,-67,-42,-21,-11,-19,-45,-80,-112,-134,-153,-177,-203,-221,-225,-220,-215,-218,-231,-249,-262,-258,-231,-187,-141,-108,-95,-104,-127,-152,-166,-163,-143,-113,-77,-40,-10,2,-2,-13,-16,-10,0,6,9,13,16,16,14,12,8,-3,-22,-45,-64,-81,-98,-116,-131,-140,-141,-135,-122,-109,-101,-103,-112,-123,-131,-131,-119,-97,-71,-54,-48,-43,-29,-10},
            {35,1,-27,0,41,16,-49,-48,36,71,-19,-104,-25,122,92,-108,-158,75,232,-25,-281,394,2304,4620,6345,7396,8017,7161,2632,-6054,-15162,-18445,-12468,-260,10869,15342,13185,8483,5030,3877,4177,4966,5631,5559,4405,2758,1791,1811,1551,-571,-4513,-8332,-9986,-9146,-7143,-5456,-4643,-4555,-4957,-5548,-5699,-4782,-2924,-1123,-311,-393,-456,146,1171,2009,2493,2914,3376,3527,3069,2284,1792,1856,2163,2278,2095,1721,1150,301,-652,-1254,-1217,-767,-409,-387,-512,-514,-399,-410,-724,-1307,-2006,-2659,-3099,-3168,-2821,-2199,-1532,-969,-508,-85,322,667,887,952,894,803,770,817,896,964,1041,1153,1234,1143,817,366,-7,-195,-262,-337,-479,-645,-754,-758,-675,-583,-589,-752,-1011,-1201,-1172,-911,-549,-256,-137,-180,-292,-358,-306,-152,8,62,-43,-272,-538,-757,-887,-924,-894,-823,-715,-559,-349,-115,93,236,316,356,372,362,325,272,218,165,108,51,11,-5,-5,-1,2,0,-28,-108,-246,-400,-515,-558,-538,-478,-386,-269,-149,-57,-6,12,10,-13,-70,-155,-243,-304,-321,-291,-219,-123,-27,50,103,131,130,89,12,-84,-177,-247,-278,-258,-189,-100,-27,11,17,-2,-51,-132,-224,-292,-315,-296,-246,-174,-89,-8,51,81,88,68,16,-67,-163,-245,-293,-303,-275,-217,-139,-57,21,79,95,47,-58,-180,-271,-309,-299,-255,-188,-105,-19,53,100,114,89,30,-41,-102,-142,-169,-182,-172,-135,-87,-49,-24,-10,-15,-55,-113,-144,-112,-41}
        },
        {    // H70e105a.wav
            {0,-3,-4,0,2,1,-1,1,3,1,-3,-3,-1,-1,-5,-2,7,11,3,-5,2,12,5,-13,-13,9,19,-6,-30,-10,32,28,-22,-33,32,72,-2,-61,178,810,1585,2193,2603,2890,2677,1109,-2227,-6280,-8765,-7809,-3536,1964,6234,8039,7671,6156,4437,3124,2524,2585,2896,3002,2810,2596,2557,2459,1849,578,-981,-2261,-2954,-3114,-2947,-2628,-2323,-2220,-2399,-2690,-2771,-2471,-1937,-1464,-1204,-1070,-902,-648,-348,-12,385,800,1088,1135,999,871,890,1031,1170,1217,1161,1017,802,553,326,146,-10,-153,-235,-202,-117,-153,-431,-864,-1213,-1300,-1156,-953,-826,-783,-756,-699,-614,-512,-385,-230,-62,84,180,221,222,197,155,95,21,-51,-96,-87,-14,99,205,251,203,74,-88,-224,-297,-297,-232,-126,-27,2,-85,-280,-513,-700,-784,-754,-639,-481,-323,-196,-108,-49,-4,28,46,51,55,61,58,32,-20,-84,-150,-226,-331,-478,-653,-820,-933,-955,-873,-709,-519,-370,-301,-307,-352,-395,-409,-383,-307,-184,-42,79,146,156,129,89,46,11,-11,-18,-18,-23,-38,-57,-77,-102,-138,-179,-216,-237,-241,-236,-231,-234,-248,-271,-293,-299,-280,-235,-178,-130,-103,-97,-103,-113,-126,-140,-148,-142,-125,-105,-87,-66,-41,-22,-19,-33,-48,-52,-45,-36,-28,-17,-6,-1,-6,-15,-22,-27,-37,-51,-63,-72,-79,-87,-92,-94,-97,-102,-106,-102,-92,-86,-88,-93,-95,-98,-105,-108,-97,-78,-69,-75,-79,-59,-22},
            {32,12,-19,-9,29,27,-28,-53,6,64,16,-77,-58,73,109,-38,-151,-11,193,82,-226,35,1460,3670,5700,7051,7774,7291,3914,-3324,-12129,-17196,-14226,-4091,7353,13959,13895,9935,6020,4102,3896,4438,5067,5289,4697,3449,2371,2031,1791,284,-2984,-6771,-9097,-9030,-7329,-5478,-4423,-4265,-4724,-5429,-5822,-5283,-3703,-1808,-603,-409,-614,-418,360,1311,2078,2666,3134,3289,2930,2259,1798,1838,2151,2321,2201,1912,1495,840,-25,-756,-995,-773,-461,-334,-320,-236,-125,-238,-724,-1455,-2179,-2734,-3072,-3140,-2877,-2325,-1658,-1066,-607,-215,173,526,751,807,756,713,745,820,864,865,889,980,1067,1008,746,382,83,-75,-146,-214,-309,-420,-530,-623,-669,-655,-629,-677,-822,-977,-1012,-877,-641,-419,-290,-266,-310,-356,-338,-230,-81,10,-36,-219,-470,-702,-858,-918,-894,-809,-683,-520,-323,-108,86,227,307,338,333,298,251,218,213,216,191,123,36,-32,-62,-59,-35,-7,-1,-51,-171,-329,-469,-549,-563,-525,-445,-327,-190,-68,11,39,26,-19,-85,-158,-222,-265,-285,-280,-247,-185,-101,-13,66,123,144,118,50,-41,-130,-201,-245,-248,-206,-135,-63,-15,3,-8,-48,-118,-205,-280,-319,-315,-275,-209,-128,-46,22,66,86,77,35,-36,-123,-204,-260,-282,-264,-211,-137,-62,5,57,80,56,-20,-125,-223,-283,-297,-271,-213,-137,-56,14,65,90,82,39,-23,-84,-129,-159,-174,-170,-146,-113,-84,-61,-41,-33,-54,-96,-120,-95,-35}
        },
        {    // H70e120a.wav
            {-4,-7,-4,1,2,-1,-1,2,1,-2,-4,-3,-3,-6,-5,4,10,3,-5,-1,8,4,-14,-17,4,18,-3,-31,-17,24,27,-20,-40,19,70,9,-68,121,721,1536,2244,2746,3068,2863,1318,-2009,-6161,-8877,-8156,-3930,1778,6363,8359,7949,6243,4348,2970,2402,2538,2934,3116,2973,2772,2725,2620,1994,669,-984,-2339,-3025,-3109,-2886,-2604,-2412,-2414,-2637,-2933,-3036,-2784,-2276,-1770,-1432,-1227,-1029,-773,-457,-58,457,1016,1409,1455,1200,904,814,970,1219,1383,1374,1181,843,450,136,3,36,113,108,-35,-294,-599,-854,-969,-931,-844,-845,-965,-1093,-1089,-934,-739,-609,-545,-471,-335,-154,28,182,290,325,268,139,-6,-106,-130,-80,26,150,247,284,255,182,86,-23,-141,-242,-287,-253,-159,-63,-36,-116,-293,-506,-679,-755,-719,-602,-462,-354,-299,-273,-237,-167,-76,10,71,106,119,109,78,31,-25,-98,-202,-339,-489,-625,-726,-779,-776,-715,-614,-514,-453,-442,-461,-482,-483,-448,-363,-232,-87,26,78,88,92,111,130,127,95,51,12,-17,-43,-66,-90,-119,-160,-207,-242,-250,-233,-215,-214,-235,-268,-300,-320,-321,-300,-258,-205,-151,-107,-77,-67,-74,-96,-125,-152,-168,-167,-148,-117,-83,-52,-26,-12,-17,-43,-74,-93,-90,-72,-52,-38,-32,-32,-37,-42,-46,-49,-55,-63,-68,-71,-74,-83,-92,-93,-84,-74,-68,-64,-60,-57,-59,-64,-63,-59,-64,-83,-102,-105,-97,-94,-100,-98,-70,-25},
            {16,28,9,-15,-4,26,16,-31,-40,17,55,1,-72,-34,76,80,-57,-123,28,175,24,-214,179,1645,3762,5680,6947,7418,6331,2278,-4989,-12704,-16019,-11803,-1785,8411,13666,12976,9124,5538,3790,3600,4142,4785,5024,4522,3494,2628,2237,1640,-221,-3453,-6755,-8475,-8063,-6383,-4762,-3965,-4023,-4634,-5379,-5688,-5046,-3496,-1785,-764,-608,-737,-509,179,1020,1795,2497,3035,3124,2637,1922,1552,1737,2147,2336,2177,1816,1337,704,-2,-500,-590,-407,-256,-246,-215,-51,65,-173,-841,-1708,-2474,-2980,-3179,-3030,-2538,-1860,-1259,-882,-645,-352,61,462,679,688,619,612,685,756,766,745,761,811,812,691,471,254,113,47,12,-27,-92,-211,-391,-574,-670,-649,-586,-589,-681,-791,-833,-786,-679,-544,-409,-312,-286,-304,-293,-203,-78,-20,-93,-275,-496,-694,-841,-916,-902,-800,-634,-446,-264,-100,42,159,244,290,293,263,228,211,215,220,202,153,86,21,-27,-47,-38,-16,-17,-70,-180,-315,-436,-515,-543,-519,-445,-330,-201,-89,-17,10,-3,-48,-111,-175,-225,-253,-263,-256,-230,-179,-106,-24,52,105,123,102,47,-29,-111,-183,-227,-229,-190,-128,-68,-29,-16,-30,-73,-140,-215,-273,-300,-290,-251,-191,-118,-46,14,54,69,59,20,-43,-117,-186,-233,-248,-229,-182,-123,-62,-7,38,60,45,-12,-97,-183,-248,-277,-266,-215,-137,-54,12,51,64,56,27,-23,-85,-141,-173,-177,-163,-144,-120,-86,-46,-21,-34,-71,-96,-77,-29}
        },
        {    // H70e135a.wav
            {-6,-2,1,0,-2,1,2,-2,-7,-5,-2,-3,-6,-2,7,8,-1,-6,3,8,-4,-19,-9,14,12,-21,-33,3,35,7,-45,-28,50,59,-41,-35,359,1151,2039,2755,3249,3366,2456,-226,-4426,-8302,-9379,-6472,-783,4937,8349,8843,7332,5179,3395,2452,2369,2788,3169,3184,2953,2802,2763,2428,1373,-316,-2031,-3136,-3442,-3204,-2800,-2489,-2410,-2618,-3020,-3336,-3268,-2770,-2113,-1633,-1437,-1371,-1220,-890,-390,242,925,1472,1682,1528,1235,1089,1185,1379,1480,1418,1243,1003,709,398,154,35,7,-27,-136,-316,-515,-681,-779,-811,-831,-902,-1031,-1141,-1146,-1049,-929,-845,-771,-642,-451,-250,-87,41,151,228,238,178,86,6,-36,-19,83,262,451,549,497,317,92,-101,-215,-237,-182,-95,-40,-63,-167,-314,-465,-594,-683,-711,-664,-555,-432,-345,-320,-337,-353,-332,-261,-152,-29,78,137,132,75,3,-53,-91,-143,-242,-388,-545,-661,-694,-634,-508,-379,-312,-340,-438,-544,-597,-572,-481,-357,-232,-133,-67,-22,25,83,134,151,123,72,24,-5,-23,-40,-65,-101,-149,-201,-239,-247,-223,-188,-171,-184,-222,-267,-303,-319,-311,-280,-234,-184,-139,-108,-90,-81,-78,-84,-104,-134,-163,-178,-176,-159,-129,-89,-46,-17,-13,-35,-65,-84,-85,-76,-69,-67,-70,-71,-68,-63,-56,-50,-47,-51,-63,-78,-90,-98,-102,-106,-103,-89,-65,-42,-26,-16,-11,-14,-29,-52,-72,-83,-88,-94,-95,-87,-80,-89,-109,-114,-83,-30},
            {-9,8,27,17,-11,-12,16,23,-14,-40,-4,46,22,-52,-54,39,86,-8,-110,-32,133,91,-151,-46,971,2801,4736,6174,6869,6301,3321,-2695,-10032,-14619,-12820,-4756,5285,12067,13228,10279,6426,3896,3097,3436,4211,4808,4747,4002,3104,2537,2004,599,-2109,-5296,-7431,-7615,-6290,-4673,-3709,-3611,-4134,-4897,-5419,-5183,-4019,-2410,-1188,-795,-911,-878,-374,429,1252,1998,2614,2889,2634,2017,1529,1518,1857,2142,2127,1855,1436,899,300,-170,-331,-236,-106,-66,-40,54,91,-152,-741,-1508,-2225,-2752,-2999,-2874,-2371,-1695,-1158,-911,-810,-601,-208,209,460,524,520,549,604,626,595,554,538,542,532,485,408,318,228,159,135,156,165,74,-154,-439,-632,-643,-521,-406,-406,-527,-699,-837,-875,-783,-587,-374,-237,-205,-219,-207,-152,-102,-113,-204,-360,-550,-735,-868,-908,-844,-707,-538,-368,-217,-94,0,74,137,191,224,230,222,216,223,230,220,185,129,67,14,-18,-31,-39,-63,-127,-232,-356,-463,-522,-521,-471,-390,-297,-206,-130,-78,-55,-62,-94,-140,-185,-219,-234,-231,-211,-178,-133,-79,-20,38,82,96,69,7,-73,-150,-208,-234,-221,-176,-116,-66,-40,-39,-60,-100,-157,-215,-256,-266,-246,-202,-145,-82,-25,18,39,37,14,-28,-83,-138,-185,-216,-225,-205,-156,-91,-29,16,38,37,8,-46,-115,-180,-224,-241,-227,-181,-110,-38,11,27,20,3,-24,-66,-115,-154,-172,-169,-152,-121,-79,-41,-26,-36,-50,-43,-17}
        },
        {    // H70e150a.wav
            {1,-2,-3,1,3,-1,-6,-5,-2,-4,-7,-1,10,11,-1,-8,3,11,-2,-21,-13,14,16,-18,-36,-1,38,12,-48,-38,47,68,-38,-62,318,1162,2181,3053,3659,3792,2783,-120,-4632,-8802,-9980,-6863,-713,5475,9097,9457,7609,5159,3268,2396,2444,2948,3341,3323,3054,2872,2798,2401,1238,-599,-2450,-3615,-3864,-3483,-2936,-2565,-2532,-2845,-3331,-3649,-3497,-2875,-2120,-1613,-1458,-1459,-1355,-1028,-489,207,953,1541,1761,1607,1335,1243,1400,1633,1741,1671,1467,1158,751,334,57,-7,51,56,-87,-339,-610,-824,-936,-929,-856,-831,-937,-1130,-1268,-1254,-1111,-931,-766,-615,-468,-341,-236,-120,31,180,248,193,51,-81,-112,-4,219,479,679,746,668,485,262,56,-92,-168,-180,-155,-127,-120,-162,-278,-471,-695,-857,-881,-765,-585,-433,-359,-348,-351,-330,-280,-213,-145,-83,-32,2,14,1,-34,-93,-183,-300,-422,-513,-547,-519,-445,-351,-265,-219,-239,-316,-404,-449,-426,-357,-283,-230,-194,-163,-129,-92,-48,6,60,90,78,31,-25,-70,-104,-137,-173,-204,-219,-215,-195,-166,-139,-129,-147,-187,-235,-273,-292,-290,-265,-224,-179,-143,-120,-101,-83,-70,-71,-90,-121,-156,-189,-206,-200,-167,-120,-77,-50,-44,-54,-74,-90,-94,-86,-72,-63,-61,-68,-79,-87,-84,-71,-55,-48,-52,-62,-75,-92,-113,-129,-130,-115,-93,-68,-39,-11,6,5,-12,-33,-55,-79,-100,-109,-102,-86,-74,-68,-66,-72,-92,-118,-122,-86,-30},
            {0,-7,-4,15,25,7,-13,-3,21,13,-25,-33,11,42,1,-56,-28,57,61,-44,-96,18,134,22,-166,125,1274,3015,4698,5874,6263,5161,1526,-4655,-11047,-13749,-10228,-1770,7163,12250,12238,9029,5464,3275,2699,3201,4083,4669,4533,3811,3061,2575,1884,209,-2527,-5316,-6838,-6600,-5260,-3921,-3275,-3392,-4007,-4748,-5142,-4748,-3548,-2108,-1169,-983,-1136,-1041,-488,328,1164,1916,2471,2619,2275,1712,1384,1497,1830,2018,1916,1619,1238,797,342,4,-120,-81,-7,50,109,127,-37,-479,-1124,-1786,-2306,-2584,-2552,-2204,-1690,-1266,-1077,-1018,-859,-511,-106,175,296,355,431,500,508,449,365,291,247,251,309,385,420,388,328,292,293,287,220,72,-128,-321,-437,-441,-363,-295,-333,-506,-747,-935,-970,-836,-599,-365,-212,-158,-167,-186,-184,-162,-151,-192,-310,-492,-683,-813,-841,-775,-654,-519,-395,-290,-202,-123,-47,26,86,125,152,187,241,294,311,271,189,103,45,27,37,52,37,-34,-161,-312,-434,-495,-498,-471,-434,-389,-335,-274,-212,-153,-102,-67,-62,-88,-131,-172,-199,-208,-199,-175,-138,-91,-35,22,66,74,40,-29,-113,-191,-246,-262,-230,-166,-98,-52,-33,-32,-47,-82,-134,-185,-217,-226,-215,-188,-142,-82,-25,12,22,10,-17,-56,-101,-144,-178,-194,-189,-160,-113,-61,-15,16,27,14,-21,-66,-106,-134,-153,-167,-170,-154,-121,-88,-66,-55,-51,-50,-54,-64,-79,-96,-115,-130,-131,-114,-80,-44,-18,-5,0}
        },
        {    // H70e165a.wav
            {-2,3,3,-3,-8,-5,0,-2,-6,1,13,11,-4,-8,6,13,-5,-24,-9,21,14,-27,-37,12,47,3,-61,-31,66,64,-68,-48,469,1491,2665,3648,4272,4190,2597,-1130,-6220,-10184,-10290,-5776,1292,7460,10295,9665,7134,4497,2822,2344,2735,3376,3683,3483,3089,2867,2711,2058,506,-1635,-3503,-4389,-4250,-3588,-2958,-2664,-2781,-3236,-3787,-4035,-3676,-2806,-1894,-1387,-1334,-1427,-1327,-911,-239,570,1335,1809,1828,1513,1227,1251,1534,1792,1835,1701,1500,1237,863,429,94,-43,-49,-61,-145,-282,-467,-719,-1010,-1231,-1291,-1221,-1144,-1148,-1205,-1226,-1147,-970,-749,-547,-406,-322,-242,-115,49,178,203,118,-16,-116,-118,4,229,491,703,804,778,641,430,197,6,-91,-93,-47,-24,-75,-220,-439,-670,-830,-866,-791,-679,-601,-573,-555,-503,-404,-282,-172,-101,-73,-73,-75,-71,-78,-119,-203,-311,-419,-509,-564,-571,-517,-411,-286,-188,-142,-149,-183,-217,-230,-220,-189,-145,-96,-52,-25,-25,-45,-67,-71,-55,-32,-25,-48,-100,-168,-233,-280,-300,-290,-257,-212,-168,-134,-116,-112,-121,-142,-172,-206,-233,-244,-234,-210,-183,-161,-143,-122,-93,-62,-40,-41,-70,-122,-181,-227,-241,-219,-169,-113,-68,-44,-42,-56,-79,-101,-113,-114,-108,-102,-98,-91,-78,-60,-44,-35,-37,-48,-66,-87,-106,-118,-126,-128,-121,-101,-69,-35,-8,5,3,-15,-44,-77,-103,-116,-118,-114,-102,-81,-62,-59,-73,-88,-89,-85,-93,-112,-115,-83,-30},
            {-12,-4,0,-5,-4,11,19,5,-14,-6,15,10,-23,-30,8,34,-3,-53,-28,47,50,-41,-86,14,115,17,-146,109,1111,2637,4136,5220,5611,4634,1330,-4307,-10162,-12710,-9622,-1953,6352,11345,11700,8917,5516,3219,2457,2852,3726,4363,4323,3730,3101,2700,2103,615,-1849,-4414,-5911,-5862,-4788,-3631,-3029,-3094,-3639,-4347,-4781,-4522,-3513,-2233,-1353,-1141,-1273,-1224,-763,-18,803,1578,2167,2356,2067,1561,1275,1407,1741,1919,1809,1535,1238,923,562,224,24,-13,31,71,72,-6,-239,-674,-1240,-1769,-2096,-2140,-1932,-1606,-1343,-1242,-1231,-1123,-816,-409,-91,57,117,195,295,346,314,231,140,65,35,91,236,398,497,518,506,485,423,294,142,34,-15,-58,-139,-246,-334,-399,-478,-602,-752,-871,-907,-839,-683,-487,-311,-199,-155,-155,-166,-173,-175,-188,-232,-326,-468,-622,-735,-765,-702,-575,-439,-338,-280,-237,-175,-92,-15,32,64,112,184,248,265,227,159,96,54,39,51,74,68,-3,-143,-309,-442,-512,-524,-496,-441,-373,-307,-256,-217,-177,-130,-88,-66,-68,-88,-121,-159,-196,-216,-210,-178,-129,-74,-23,10,15,-10,-60,-126,-197,-250,-265,-232,-168,-102,-56,-33,-27,-40,-73,-117,-157,-183,-196,-197,-181,-144,-92,-47,-21,-16,-23,-38,-62,-94,-127,-152,-165,-161,-142,-107,-64,-25,0,7,-4,-26,-54,-84,-111,-133,-148,-152,-146,-134,-124,-116,-111,-101,-87,-73,-68,-72,-83,-92,-98,-98,-91,-73,-44,-14}
        },
        {    // H70e180a.wav
            {3,-5,-9,-3,1,-4,-6,5,17,9,-7,-6,12,13,-13,-27,0,29,7,-39,-31,31,51,-19,-74,-8,94,43,-110,20,774,2046,3385,4431,4961,4439,1954,-2810,-8362,-11621,-10018,-3746,4095,9717,11224,9354,6232,3682,2474,2504,3217,3903,4044,3636,3120,2820,2455,1376,-665,-3061,-4768,-5175,-4525,-3569,-2929,-2823,-3181,-3796,-4316,-4325,-3637,-2540,-1617,-1242,-1287,-1330,-1073,-509,243,1064,1780,2129,1970,1509,1190,1281,1629,1871,1826,1601,1359,1107,778,407,128,17,6,-18,-92,-207,-395,-711,-1130,-1509,-1688,-1631,-1449,-1302,-1273,-1306,-1261,-1040,-682,-349,-177,-155,-149,-50,117,243,251,152,15,-87,-95,17,223,447,615,699,704,631,477,274,95,1,-9,7,-9,-91,-243,-448,-652,-791,-833,-807,-764,-723,-659,-554,-428,-317,-234,-171,-127,-109,-115,-123,-125,-149,-237,-390,-560,-676,-699,-634,-518,-393,-290,-223,-183,-153,-121,-89,-62,-35,6,62,114,136,117,71,24,-2,0,17,23,-8,-85,-196,-310,-396,-441,-443,-408,-344,-270,-205,-161,-134,-114,-95,-87,-98,-124,-153,-175,-189,-200,-205,-197,-170,-125,-74,-34,-17,-25,-54,-100,-157,-211,-240,-230,-186,-131,-86,-55,-36,-33,-52,-89,-125,-147,-154,-154,-144,-122,-91,-63,-47,-39,-34,-33,-42,-63,-89,-113,-134,-148,-147,-122,-80,-35,1,20,19,-1,-35,-71,-102,-128,-148,-154,-141,-113,-86,-73,-72,-77,-87,-99,-105,-98,-86,-82,-88,-86,-61,-21},
            {3,-5,-9,-3,1,-4,-6,5,17,9,-7,-6,12,13,-13,-27,0,29,7,-39,-31,31,51,-19,-74,-8,94,43,-110,20,774,2046,3385,4431,4961,4439,1954,-2810,-8362,-11621,-10018,-3746,4095,9717,11224,9354,6232,3682,2474,2504,3217,3903,4044,3636,3120,2820,2455,1376,-665,-3061,-4768,-5175,-4525,-3569,-2929,-2823,-3181,-3796,-4316,-4325,-3637,-2540,-1617,-1242,-1287,-1330,-1073,-509,243,1064,1780,2129,1970,1509,1190,1281,1629,1871,1826,1601,1359,1107,778,407,128,17,6,-18,-92,-207,-395,-711,-1130,-1509,-1688,-1631,-1449,-1302,-1273,-1306,-1261,-1040,-682,-349,-177,-155,-149,-50,117,243,251,152,15,-87,-95,17,223,447,615,699,704,631,477,274,95,1,-9,7,-9,-91,-243,-448,-652,-791,-833,-807,-764,-723,-659,-554,-428,-317,-234,-171,-127,-109,-115,-123,-125,-149,-237,-390,-560,-676,-699,-634,-518,-393,-290,-223,-183,-153,-121,-89,-62,-35,6,62,114,136,117,71,24,-2,0,17,23,-8,-85,-196,-310,-396,-441,-443,-408,-344,-270,-205,-161,-134,-114,-95,-87,-98,-124,-153,-175,-189,-200,-205,-197,-170,-125,-74,-34,-17,-25,-54,-100,-157,-211,-240,-230,-186,-131,-86,-55,-36,-33,-52,-89,-125,-147,-154,-154,-144,-122,-91,-63,-47,-39,-34,-33,-42,-63,-89,-113,-134,-148,-147,-122,-80,-35,1,20,19,-1,-35,-71,-102,-128,-148,-154,-141,-113,-86,-73,-72,-77,-87,-99,-105,-98,-86,-82,-88,-86,-61,-21}
        }
    },
    {    // elev80 
        {    // H80e000a.wav
            {16,19,-1,-14,6,27,3,-39,-26,35,47,-25,-72,1,96,48,-92,-90,88,152,-56,-128,546,1929,3248,3972,4493,5256,5312,2606,-3519,-10346,-13198,-9452,-1093,6918,10744,10121,7336,4688,3177,2875,3528,4532,4984,4358,3106,2171,1828,1296,-313,-2863,-5231,-6416,-6352,-5639,-4795,-4007,-3443,-3377,-3812,-4206,-3868,-2692,-1315,-458,-213,-95,304,903,1396,1706,1982,2256,2317,2017,1538,1217,1162,1188,1129,1027,957,807,396,-203,-645,-671,-391,-118,-17,-9,2,-49,-260,-594,-919,-1188,-1473,-1793,-2021,-2002,-1745,-1411,-1137,-926,-709,-464,-224,-8,211,465,726,920,987,945,885,900,1001,1093,1056,848,523,168,-166,-457,-670,-764,-731,-609,-451,-291,-167,-141,-268,-525,-802,-967,-957,-797,-570,-367,-249,-226,-248,-246,-179,-71,25,73,77,57,29,-12,-76,-177,-320,-493,-665,-798,-854,-810,-666,-456,-253,-140,-160,-293,-460,-572,-574,-460,-271,-74,71,133,126,93,72,69,62,29,-28,-88,-126,-132,-112,-84,-67,-76,-107,-137,-139,-109,-74,-68,-99,-155,-219,-286,-349,-390,-390,-348,-282,-211,-146,-97,-82,-113,-182,-265,-333,-368,-357,-292,-185,-67,26,78,90,70,23,-37,-91,-119,-119,-99,-65,-20,32,82,121,145,145,109,35,-56,-135,-182,-201,-205,-197,-175,-141,-104,-72,-56,-65,-103,-159,-211,-244,-257,-256,-240,-199,-135,-64,-6,28,41,33,4,-44,-103,-162,-210,-232,-215,-158,-78,6,80,135,159,140,86,27},
            {16,19,-1,-14,6,27,3,-39,-26,35,47,-25,-72,1,96,48,-92,-90,88,152,-56,-128,546,1929,3248,3972,4493,5256,5312,2606,-3519,-10346,-13198,-9452,-1093,6918,10744,10121,7336,4688,3177,2875,3528,4532,4984,4358,3106,2171,1828,1296,-313,-2863,-5231,-6416,-6352,-5639,-4795,-4007,-3443,-3377,-3812,-4206,-3868,-2692,-1315,-458,-213,-95,304,903,1396,1706,1982,2256,2317,2017,1538,1217,1162,1188,1129,1027,957,807,396,-203,-645,-671,-391,-118,-17,-9,2,-49,-260,-594,-919,-1188,-1473,-1793,-2021,-2002,-1745,-1411,-1137,-926,-709,-464,-224,-8,211,465,726,920,987,945,885,900,1001,1093,1056,848,523,168,-166,-457,-670,-764,-731,-609,-451,-291,-167,-141,-268,-525,-802,-967,-957,-797,-570,-367,-249,-226,-248,-246,-179,-71,25,73,77,57,29,-12,-76,-177,-320,-493,-665,-798,-854,-810,-666,-456,-253,-140,-160,-293,-460,-572,-574,-460,-271,-74,71,133,126,93,72,69,62,29,-28,-88,-126,-132,-112,-84,-67,-76,-107,-137,-139,-109,-74,-68,-99,-155,-219,-286,-349,-390,-390,-348,-282,-211,-146,-97,-82,-113,-182,-265,-333,-368,-357,-292,-185,-67,26,78,90,70,23,-37,-91,-119,-119,-99,-65,-20,32,82,121,145,145,109,35,-56,-135,-182,-201,-205,-197,-175,-141,-104,-72,-56,-65,-103,-159,-211,-244,-257,-256,-240,-199,-135,-64,-6,28,41,33,4,-44,-103,-162,-210,-232,-215,-158,-78,6,80,135,159,140,86,27}
        },
        {    // H80e030a.wav
            {-6,-2,16,20,2,-13,3,24,7,-28,-21,28,40,-18,-59,0,81,45,-73,-78,70,132,-37,-99,472,1666,2824,3452,3842,4382,4295,1815,-3678,-9863,-12573,-9284,-1525,6330,10613,10692,8333,5576,3533,2577,2737,3586,4244,4039,3182,2466,2222,1840,494,-1809,-4130,-5502,-5720,-5231,-4505,-3758,-3170,-3008,-3345,-3777,-3688,-2858,-1703,-831,-457,-312,-69,320,737,1153,1619,2047,2187,1928,1493,1229,1234,1307,1254,1120,1030,930,638,131,-342,-521,-406,-211,-93,-41,-11,-59,-261,-587,-923,-1213,-1487,-1746,-1896,-1845,-1621,-1344,-1091,-848,-582,-313,-88,87,249,421,585,698,741,729,712,750,866,1000,1035,887,581,222,-96,-346,-538,-669,-714,-669,-563,-444,-356,-335,-396,-523,-668,-772,-788,-701,-529,-329,-180,-130,-153,-173,-127,-21,86,141,132,82,16,-42,-79,-105,-150,-250,-409,-597,-762,-855,-839,-706,-497,-297,-197,-239,-386,-547,-644,-640,-543,-380,-192,-18,109,172,179,145,84,7,-68,-119,-132,-109,-64,-15,26,43,26,-21,-77,-118,-136,-145,-163,-195,-230,-256,-275,-296,-323,-341,-330,-282,-207,-136,-95,-94,-130,-187,-253,-308,-330,-304,-235,-146,-60,8,52,62,35,-17,-67,-95,-94,-69,-29,18,64,99,121,134,136,117,71,5,-61,-114,-152,-179,-194,-192,-172,-144,-118,-107,-114,-138,-170,-197,-212,-214,-207,-189,-156,-108,-57,-14,10,17,12,1,-9,-16,-24,-38,-56,-73,-78,-64,-36,-5,15,17,7},
            {12,-12,-4,24,15,-32,-39,23,60,-3,-81,-34,89,87,-67,-130,41,188,15,-194,289,1712,3377,4488,5202,6149,6741,4782,-1214,-9244,-14256,-12249,-4069,5175,10461,10526,7654,4779,3329,3284,4127,5184,5596,4800,3201,1897,1447,1130,-249,-2895,-5654,-7142,-7023,-6031,-5028,-4330,-3916,-3835,-4111,-4387,-4063,-2924,-1478,-464,-89,90,534,1196,1703,1923,2086,2373,2590,2413,1845,1259,991,1036,1173,1234,1149,830,222,-504,-963,-905,-484,-103,1,-73,-120,-101,-133,-309,-613,-1006,-1462,-1898,-2159,-2142,-1913,-1641,-1418,-1200,-911,-560,-213,99,402,707,963,1094,1071,944,816,783,871,1000,1029,864,530,144,-179,-394,-516,-566,-552,-470,-321,-134,12,2,-233,-630,-1004,-1167,-1068,-817,-586,-478,-478,-487,-423,-272,-99,16,41,11,-15,-8,9,-7,-81,-210,-377,-558,-722,-830,-847,-759,-579,-355,-158,-61,-104,-258,-435,-530,-480,-305,-89,82,167,184,173,160,151,136,98,25,-80,-185,-243,-231,-170,-108,-77,-73,-68,-51,-32,-39,-87,-167,-256,-324,-357,-363,-353,-328,-280,-210,-139,-93,-79,-83,-88,-103,-145,-220,-305,-356,-347,-279,-180,-85,-17,21,31,15,-21,-68,-107,-126,-120,-97,-61,-16,38,96,147,177,171,120,35,-60,-139,-189,-212,-214,-199,-170,-131,-93,-65,-61,-86,-133,-187,-230,-256,-264,-256,-233,-206,-186,-173,-152,-115,-73,-45,-33,-23,1,34,64,89,113,130,117,69,5,-42,-62,-69,-74,-70,-49,-16}
        },
        {    // H80e060a.wav
            {-5,-8,-8,5,16,9,-10,-9,12,17,-11,-30,-3,34,16,-41,-42,32,68,-7,-87,-24,103,68,-94,44,818,1956,2838,3279,3653,3938,2958,-658,-6413,-11234,-11547,-6403,1525,8114,10882,10119,7634,5038,3177,2406,2691,3454,3833,3456,2775,2437,2385,1847,263,-2000,-3963,-4941,-4981,-4511,-3858,-3205,-2790,-2848,-3282,-3597,-3321,-2480,-1548,-944,-674,-479,-200,131,486,945,1511,1955,1996,1647,1256,1146,1297,1435,1389,1221,1043,824,474,53,-254,-341,-295,-248,-213,-138,-62,-121,-383,-750,-1073,-1314,-1527,-1721,-1811,-1728,-1511,-1257,-998,-696,-343,-13,204,309,380,483,600,662,630,544,496,550,685,805,807,660,404,110,-173,-412,-577,-646,-623,-537,-431,-340,-308,-371,-527,-711,-833,-842,-748,-595,-417,-244,-111,-52,-58,-69,-29,61,147,175,139,78,31,13,10,-8,-66,-184,-364,-583,-790,-918,-915,-780,-574,-390,-310,-356,-486,-629,-719,-722,-635,-480,-291,-100,67,187,241,218,130,16,-75,-112,-96,-49,4,48,74,70,33,-25,-81,-124,-156,-187,-218,-239,-244,-240,-246,-273,-317,-359,-374,-346,-278,-192,-119,-85,-100,-152,-216,-265,-279,-256,-208,-148,-87,-32,7,18,1,-30,-53,-62,-56,-41,-16,16,48,70,85,94,94,76,37,-12,-60,-100,-138,-172,-193,-194,-175,-148,-124,-114,-119,-138,-161,-177,-183,-180,-174,-163,-140,-106,-67,-35,-19,-18,-24,-30,-32,-29,-23,-19,-24,-40,-62,-76,-70,-44,-14},
            {-17,13,34,-1,-52,-33,43,56,-33,-91,-4,112,59,-110,-116,96,185,-64,-187,569,2257,4035,5237,6191,7314,7472,4273,-3093,-11487,-15380,-11539,-2180,6842,10942,9900,6688,4198,3411,3895,4906,5711,5589,4309,2571,1448,1163,705,-1045,-3941,-6577,-7649,-7089,-5834,-4780,-4216,-4063,-4231,-4530,-4511,-3755,-2384,-1057,-319,-61,242,833,1435,1718,1796,2047,2537,2853,2596,1884,1234,1016,1159,1368,1434,1262,776,-2,-796,-1187,-1001,-511,-163,-138,-245,-236,-99,-27,-189,-607,-1193,-1804,-2262,-2424,-2285,-1997,-1716,-1458,-1136,-706,-239,165,479,736,937,1035,994,845,685,612,673,829,962,949,751,436,117,-141,-335,-466,-505,-428,-261,-71,66,79,-91,-443,-869,-1187,-1257,-1093,-844,-665,-607,-607,-575,-463,-285,-98,36,88,73,39,18,5,-39,-144,-310,-501,-666,-758,-754,-662,-521,-378,-274,-227,-236,-277,-315,-314,-263,-177,-86,-5,67,132,177,184,148,93,48,26,9,-25,-83,-144,-188,-207,-207,-197,-175,-138,-91,-55,-58,-116,-218,-325,-395,-412,-386,-333,-254,-152,-49,19,33,8,-33,-85,-162,-265,-363,-416,-405,-340,-242,-131,-29,45,76,63,15,-58,-141,-208,-229,-193,-116,-26,60,127,169,180,165,129,70,-16,-119,-214,-275,-299,-294,-264,-207,-135,-67,-22,-4,-20,-83,-195,-327,-432,-479,-473,-423,-321,-162,30,206,325,371,338,226,56,-115,-230,-270,-253,-192,-95,20,110,149,151,130,64,-78,-252,-343,-273,-101}
        },
        {    // H80e090a.wav
            {-5,-3,-7,-5,7,15,5,-10,-4,14,10,-17,-24,9,32,-1,-48,-26,45,52,-33,-75,16,107,21,-100,179,1048,2125,2882,3293,3650,3609,1886,-2419,-8052,-11684,-10382,-4246,3512,9118,10856,9509,6890,4420,2815,2338,2805,3521,3718,3258,2697,2522,2449,1705,-40,-2219,-3893,-4586,-4488,-4018,-3434,-2899,-2655,-2877,-3366,-3601,-3208,-2341,-1496,-1011,-811,-634,-352,8,447,1019,1633,2003,1901,1457,1086,1085,1360,1589,1568,1333,1001,619,216,-111,-254,-238,-199,-224,-259,-222,-154,-195,-425,-779,-1140,-1447,-1691,-1841,-1831,-1627,-1281,-895,-558,-317,-174,-83,33,224,457,631,669,582,463,407,452,560,650,646,522,317,101,-82,-228,-340,-406,-412,-379,-352,-359,-392,-433,-485,-565,-665,-749,-778,-732,-616,-448,-266,-122,-48,-29,-11,44,125,187,201,177,137,94,51,11,-27,-77,-170,-329,-540,-754,-904,-939,-847,-672,-498,-402,-420,-524,-650,-736,-743,-659,-496,-286,-72,102,210,241,204,124,39,-13,-21,7,46,81,103,105,78,19,-57,-132,-190,-228,-250,-260,-264,-267,-275,-293,-320,-349,-361,-337,-274,-193,-126,-94,-102,-138,-187,-235,-263,-258,-221,-167,-112,-64,-27,-7,-11,-32,-51,-53,-38,-19,-5,3,10,21,34,49,59,58,39,1,-45,-91,-129,-157,-176,-183,-179,-164,-143,-122,-106,-100,-101,-106,-112,-117,-122,-124,-120,-103,-75,-44,-27,-31,-46,-58,-60,-57,-55,-50,-45,-49,-70,-99,-106,-77,-27},
            {-13,23,29,-21,-56,-8,59,31,-65,-73,45,111,-9,-144,-51,161,120,-169,-48,1084,2942,4637,5817,6914,7808,6753,1728,-6581,-13776,-14772,-8345,1520,8977,10969,8747,5580,3735,3539,4306,5255,5682,5071,3569,2069,1350,1114,205,-2064,-4987,-7066,-7427,-6471,-5238,-4417,-4087,-4107,-4368,-4625,-4415,-3436,-1976,-733,-144,4,214,673,1166,1503,1809,2257,2697,2750,2284,1636,1268,1318,1551,1679,1571,1193,543,-248,-855,-992,-714,-390,-314,-422,-433,-227,18,21,-340,-974,-1682,-2258,-2546,-2506,-2236,-1890,-1555,-1207,-807,-375,35,400,718,943,1000,878,674,525,508,607,754,877,903,783,534,238,-22,-213,-345,-412,-385,-257,-72,90,154,63,-203,-593,-976,-1199,-1194,-1027,-839,-731,-709,-703,-637,-483,-270,-65,71,120,113,92,66,14,-89,-243,-421,-582,-684,-690,-596,-448,-320,-268,-297,-361,-398,-372,-277,-149,-39,8,-4,-32,-31,8,61,107,149,188,202,153,37,-103,-211,-270,-298,-310,-287,-207,-84,23,53,-15,-147,-291,-398,-441,-418,-346,-252,-163,-94,-51,-31,-26,-31,-47,-84,-146,-226,-303,-352,-361,-325,-251,-156,-66,-4,23,22,-4,-56,-127,-196,-230,-211,-149,-69,10,80,137,170,172,139,74,-13,-109,-200,-272,-316,-328,-299,-229,-129,-29,39,50,-4,-116,-261,-396,-475,-478,-418,-317,-182,-14,164,301,351,299,170,-1,-168,-287,-318,-264,-163,-57,38,123,175,159,74,-34,-118,-186,-268,-349,-358,-251,-87}
        },
        {    // H80e120a.wav
            {-3,-4,-6,2,15,15,-2,-10,5,18,1,-25,-13,25,27,-22,-48,3,60,22,-66,-53,68,100,-45,-74,434,1463,2506,3171,3592,3867,3228,380,-4792,-10015,-11779,-8202,-834,6471,10498,10604,8274,5419,3260,2273,2430,3228,3859,3791,3221,2760,2614,2260,1046,-996,-3081,-4373,-4637,-4216,-3570,-3004,-2720,-2852,-3316,-3721,-3625,-2947,-2056,-1400,-1105,-964,-744,-388,76,666,1369,1981,2200,1930,1447,1157,1218,1451,1594,1540,1324,969,487,-12,-334,-384,-277,-211,-241,-264,-199,-133,-229,-548,-997,-1437,-1771,-1936,-1881,-1595,-1172,-776,-538,-465,-455,-376,-157,164,464,616,584,446,327,309,396,537,659,689,580,354,100,-82,-149,-138,-120,-148,-237,-365,-479,-521,-472,-381,-345,-428,-611,-800,-894,-837,-648,-406,-207,-102,-71,-53,-5,60,105,119,122,135,153,154,129,78,0,-119,-284,-476,-656,-784,-833,-793,-684,-554,-461,-449,-515,-620,-711,-741,-683,-533,-318,-95,72,147,143,104,72,68,83,100,104,96,86,80,77,62,23,-40,-113,-176,-217,-237,-242,-247,-265,-305,-358,-403,-413,-381,-314,-233,-160,-111,-93,-103,-134,-173,-206,-223,-218,-192,-156,-117,-80,-49,-31,-32,-51,-71,-76,-65,-46,-29,-16,-4,6,13,21,28,30,16,-16,-57,-93,-119,-137,-151,-159,-157,-144,-125,-104,-87,-77,-75,-80,-87,-95,-101,-101,-93,-79,-62,-47,-39,-39,-44,-51,-55,-57,-61,-71,-85,-97,-104,-107,-102,-83,-51,-16},
            {-13,7,29,7,-40,-37,26,55,-12,-79,-25,86,72,-75,-122,45,173,-1,-199,269,1675,3450,4877,5940,6903,6999,4324,-2049,-9823,-14213,-11748,-3549,5422,10431,10342,7408,4555,3247,3397,4308,5217,5416,4579,3145,2001,1520,1037,-435,-3002,-5603,-6968,-6742,-5604,-4481,-3864,-3788,-4111,-4573,-4724,-4145,-2873,-1495,-637,-388,-314,-17,490,979,1409,1915,2464,2737,2480,1874,1406,1368,1621,1833,1817,1564,1075,366,-382,-834,-802,-474,-237,-275,-425,-425,-243,-100,-239,-717,-1397,-2048,-2459,-2522,-2282,-1892,-1506,-1184,-905,-627,-316,56,469,819,966,872,662,522,534,638,737,786,772,673,473,215,-14,-160,-242,-293,-303,-232,-83,81,176,149,-20,-312,-658,-939,-1053,-998,-872,-789,-784,-801,-759,-621,-410,-187,-7,101,138,126,88,33,-42,-147,-283,-434,-563,-627,-599,-492,-360,-266,-248,-303,-386,-435,-404,-292,-147,-36,4,-10,-30,-17,31,91,140,168,170,139,70,-30,-137,-226,-280,-291,-259,-192,-109,-38,-6,-27,-99,-203,-308,-376,-389,-357,-304,-245,-180,-107,-40,-4,-5,-28,-56,-90,-146,-222,-295,-338,-339,-299,-227,-138,-55,-1,15,2,-29,-78,-139,-194,-216,-191,-131,-58,12,72,115,138,136,110,61,-12,-99,-183,-246,-278,-276,-241,-177,-102,-36,7,23,7,-48,-141,-247,-331,-371,-363,-314,-229,-122,-14,76,140,172,159,89,-20,-126,-190,-207,-187,-136,-55,38,106,130,123,99,43,-63,-186,-244,-190,-69}
        },
        {    // H80e150a.wav
            {-7,-8,7,21,11,-10,-9,14,18,-13,-32,0,39,17,-41,-38,36,65,-16,-87,-12,113,63,-110,34,830,2031,3058,3697,4150,4190,2653,-1488,-7289,-11518,-10902,-5024,3062,9197,11134,9499,6430,3762,2327,2205,3005,3963,4310,3852,3110,2665,2408,1635,-106,-2394,-4258,-5033,-4789,-4053,-3310,-2843,-2824,-3274,-3896,-4136,-3622,-2554,-1549,-1078,-1078,-1127,-893,-346,389,1194,1918,2331,2269,1862,1485,1416,1593,1738,1668,1415,1079,688,259,-109,-302,-338,-347,-397,-405,-278,-97,-75,-346,-840,-1366,-1773,-1988,-1969,-1706,-1283,-877,-647,-609,-629,-542,-283,77,384,513,454,311,224,268,414,583,702,733,664,513,330,168,52,-31,-106,-184,-262,-341,-411,-433,-377,-269,-204,-276,-493,-759,-941,-956,-809,-580,-368,-241,-201,-196,-169,-97,4,100,162,173,135,72,23,10,12,-25,-147,-352,-585,-761,-811,-719,-540,-377,-319,-387,-530,-664,-723,-680,-542,-349,-161,-35,11,11,18,58,108,128,102,54,17,9,22,34,30,4,-44,-98,-135,-136,-110,-90,-110,-178,-275,-367,-427,-439,-403,-333,-250,-179,-131,-106,-97,-100,-119,-154,-199,-237,-252,-238,-201,-153,-103,-57,-22,-7,-17,-46,-73,-87,-88,-85,-78,-59,-25,16,49,61,51,23,-16,-60,-98,-125,-143,-154,-161,-159,-147,-125,-97,-72,-58,-58,-69,-83,-94,-100,-104,-103,-91,-68,-41,-21,-14,-14,-18,-25,-36,-51,-71,-96,-123,-143,-145,-125,-88,-48,-17,-1,2},
            {18,-9,-15,13,25,-9,-40,-8,44,26,-49,-58,34,88,-3,-111,-41,128,100,-132,-52,838,2351,3795,4823,5644,6072,4769,327,-6489,-12065,-12368,-6501,2231,8949,10929,8961,5724,3390,2649,3168,4249,5085,5032,4068,2867,2107,1670,739,-1238,-3791,-5776,-6387,-5754,-4625,-3704,-3325,-3534,-4141,-4687,-4595,-3636,-2226,-1118,-718,-766,-716,-308,311,936,1548,2147,2539,2477,2014,1544,1423,1625,1851,1880,1704,1360,820,127,-477,-714,-570,-316,-217,-271,-301,-238,-208,-378,-780,-1306,-1817,-2190,-2319,-2153,-1755,-1296,-948,-775,-709,-612,-371,20,431,688,716,604,521,558,668,755,774,729,622,446,226,24,-108,-176,-207,-214,-187,-134,-75,-16,41,57,-46,-309,-654,-918,-987,-891,-763,-707,-722,-732,-669,-526,-338,-144,22,136,179,151,76,-12,-89,-164,-258,-377,-501,-589,-606,-543,-419,-287,-214,-245,-361,-483,-519,-433,-269,-113,-24,-8,-29,-43,-18,55,155,236,245,160,10,-142,-242,-275,-266,-239,-204,-152,-85,-23,9,-10,-82,-188,-296,-370,-383,-340,-264,-188,-136,-117,-123,-137,-139,-124,-104,-101,-129,-187,-255,-308,-318,-276,-197,-113,-54,-26,-17,-20,-37,-72,-117,-155,-172,-162,-126,-67,3,63,96,96,71,31,-17,-66,-112,-156,-196,-223,-220,-184,-125,-65,-17,8,4,-33,-95,-158,-200,-213,-201,-171,-126,-79,-44,-31,-32,-43,-66,-110,-169,-219,-234,-205,-140,-61,10,55,71,68,59,44,17,-17,-41,-37,-15}
        },
        {    // H80e180a.wav
            {5,19,12,-9,-8,16,21,-13,-36,-2,43,21,-45,-47,37,77,-10,-98,-24,121,79,-122,-8,828,2167,3384,4202,4810,4982,3491,-810,-7009,-11702,-11338,-5367,3001,9298,11105,9171,5920,3371,2296,2556,3574,4540,4738,4061,3096,2464,2072,1193,-660,-3067,-4996,-5704,-5261,-4294,-3429,-3013,-3156,-3738,-4346,-4418,-3672,-2424,-1354,-908,-950,-1007,-751,-179,569,1377,2096,2479,2364,1912,1531,1499,1719,1885,1821,1571,1208,728,168,-294,-476,-408,-311,-326,-369,-296,-145,-130,-406,-912,-1456,-1881,-2109,-2096,-1829,-1389,-959,-704,-650,-669,-596,-354,-2,314,468,449,364,344,438,594,725,779,744,629,458,278,135,40,-32,-107,-183,-252,-311,-344,-307,-177,-24,6,-185,-539,-869,-1010,-940,-764,-609,-532,-510,-485,-414,-291,-139,9,121,178,173,117,39,-32,-88,-147,-237,-361,-494,-591,-614,-554,-438,-331,-299,-367,-491,-587,-591,-492,-337,-187,-86,-46,-48,-51,-22,44,119,162,144,72,-19,-89,-118,-115,-106,-113,-134,-151,-148,-125,-97,-84,-99,-143,-206,-268,-306,-305,-274,-234,-210,-204,-199,-183,-158,-139,-135,-147,-171,-210,-258,-294,-288,-231,-145,-69,-24,-4,2,-6,-30,-67,-102,-120,-121,-109,-86,-48,1,46,69,62,29,-17,-63,-103,-140,-176,-201,-205,-183,-144,-97,-53,-21,-9,-25,-61,-101,-130,-144,-147,-136,-108,-67,-27,-5,-4,-14,-24,-35,-53,-81,-115,-145,-167,-176,-172,-155,-130,-104,-82,-64,-46,-27,-9},
            {5,19,12,-9,-8,16,21,-13,-36,-2,43,21,-45,-47,37,77,-10,-98,-24,121,79,-122,-8,828,2167,3384,4202,4810,4982,3491,-810,-7009,-11702,-11338,-5367,3001,9298,11105,9171,5920,3371,2296,2556,3574,4540,4738,4061,3096,2464,2072,1193,-660,-3067,-4996,-5704,-5261,-4294,-3429,-3013,-3156,-3738,-4346,-4418,-3672,-2424,-1354,-908,-950,-1007,-751,-179,569,1377,2096,2479,2364,1912,1531,1499,1719,1885,1821,1571,1208,728,168,-294,-476,-408,-311,-326,-369,-296,-145,-130,-406,-912,-1456,-1881,-2109,-2096,-1829,-1389,-959,-704,-650,-669,-596,-354,-2,314,468,449,364,344,438,594,725,779,744,629,458,278,135,40,-32,-107,-183,-252,-311,-344,-307,-177,-24,6,-185,-539,-869,-1010,-940,-764,-609,-532,-510,-485,-414,-291,-139,9,121,178,173,117,39,-32,-88,-147,-237,-361,-494,-591,-614,-554,-438,-331,-299,-367,-491,-587,-591,-492,-337,-187,-86,-46,-48,-51,-22,44,119,162,144,72,-19,-89,-118,-115,-106,-113,-134,-151,-148,-125,-97,-84,-99,-143,-206,-268,-306,-305,-274,-234,-210,-204,-199,-183,-158,-139,-135,-147,-171,-210,-258,-294,-288,-231,-145,-69,-24,-4,2,-6,-30,-67,-102,-120,-121,-109,-86,-48,1,46,69,62,29,-17,-63,-103,-140,-176,-201,-205,-183,-144,-97,-53,-21,-9,-25,-61,-101,-130,-144,-147,-136,-108,-67,-27,-5,-4,-14,-24,-35,-53,-81,-115,-145,-167,-176,-172,-155,-130,-104,-82,-64,-46,-27,-9}
        }
    },
    {    // elev90 
        {    // H90e000a.wav
            {9,-27,-26,20,41,-8,-56,-14,65,49,-56,-79,47,126,-11,-117,323,1453,2804,3870,4716,5571,5780,3774,-1242,-7525,-11324,-9775,-3481,3859,8404,8840,6580,3978,2586,2687,3719,4806,5177,4569,3406,2392,1794,1167,-122,-2129,-4173,-5420,-5554,-4892,-4005,-3348,-3156,-3438,-3940,-4192,-3805,-2829,-1742,-1014,-694,-463,-62,447,866,1176,1534,1981,2292,2217,1795,1340,1128,1162,1259,1250,1050,622,14,-567,-832,-649,-187,237,437,453,394,273,28,-366,-859,-1373,-1842,-2178,-2290,-2146,-1825,-1447,-1088,-760,-466,-228,-52,101,271,439,539,532,460,420,484,646,825,927,899,753,534,285,36,-176,-313,-367,-373,-371,-352,-271,-133,-27,-66,-286,-615,-927,-1111,-1112,-941,-681,-461,-363,-350,-307,-164,29,152,141,36,-73,-129,-137,-121,-100,-93,-127,-224,-371,-524,-628,-649,-584,-465,-352,-305,-356,-484,-619,-683,-628,-456,-221,3,148,189,152,92,52,41,36,14,-32,-92,-154,-203,-223,-208,-164,-109,-55,-3,48,82,74,5,-115,-260,-389,-464,-460,-380,-255,-129,-34,17,13,-54,-183,-344,-492,-585,-603,-544,-422,-262,-97,40,122,137,91,12,-55,-78,-52,-3,47,90,131,166,183,179,156,114,49,-42,-140,-219,-264,-277,-272,-255,-229,-197,-163,-130,-105,-99,-115,-145,-176,-197,-206,-202,-180,-135,-78,-21,26,60,72,58,23,-19,-56,-90,-122,-141,-134,-100,-51,0,46,75,72,33,-21,-64,-94,-124,-153,-155,-110,-38},
            {9,-27,-26,20,41,-8,-56,-14,65,49,-56,-79,47,126,-11,-117,323,1453,2804,3870,4716,5571,5780,3774,-1242,-7525,-11324,-9775,-3481,3859,8404,8840,6580,3978,2586,2687,3719,4806,5177,4569,3406,2392,1794,1167,-122,-2129,-4173,-5420,-5554,-4892,-4005,-3348,-3156,-3438,-3940,-4192,-3805,-2829,-1742,-1014,-694,-463,-62,447,866,1176,1534,1981,2292,2217,1795,1340,1128,1162,1259,1250,1050,622,14,-567,-832,-649,-187,237,437,453,394,273,28,-366,-859,-1373,-1842,-2178,-2290,-2146,-1825,-1447,-1088,-760,-466,-228,-52,101,271,439,539,532,460,420,484,646,825,927,899,753,534,285,36,-176,-313,-367,-373,-371,-352,-271,-133,-27,-66,-286,-615,-927,-1111,-1112,-941,-681,-461,-363,-350,-307,-164,29,152,141,36,-73,-129,-137,-121,-100,-93,-127,-224,-371,-524,-628,-649,-584,-465,-352,-305,-356,-484,-619,-683,-628,-456,-221,3,148,189,152,92,52,41,36,14,-32,-92,-154,-203,-223,-208,-164,-109,-55,-3,48,82,74,5,-115,-260,-389,-464,-460,-380,-255,-129,-34,17,13,-54,-183,-344,-492,-585,-603,-544,-422,-262,-97,40,122,137,91,12,-55,-78,-52,-3,47,90,131,166,183,179,156,114,49,-42,-140,-219,-264,-277,-272,-255,-229,-197,-163,-130,-105,-99,-115,-145,-176,-197,-206,-202,-180,-135,-78,-21,26,60,72,58,23,-19,-56,-90,-122,-141,-134,-100,-51,0,46,75,72,33,-21,-64,-94,-124,-153,-155,-110,-38}
        }
    }
};