/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.project;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.project.Project;
import com.sun.electric.tool.project.ProjectCell;
import com.sun.electric.tool.project.ProjectDB;
import com.sun.electric.tool.project.ProjectLibrary;
import com.sun.electric.tool.project.Users;
import com.sun.electric.util.math.MutableInteger;
import java.util.HashMap;
import java.util.Iterator;

public class CheckInJob
extends Job {
    private ProjectDB pdb;
    private Library lib;
    private HashMap<Cell, MutableInteger> cellsMarked;
    private String comment;
    private int backupScheme;
    private static String lastComment = null;

    public static void checkInThisCell() {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        CheckInJob.checkIn(cell);
    }

    public static void checkIn(Cell cell) {
        if (Users.needUserName()) {
            return;
        }
        if (Project.ensureRepository()) {
            return;
        }
        HashMap<Cell, MutableInteger> cellsMarked = CheckInJob.markRelatedCells(cell);
        for (Cell aCell : cellsMarked.keySet()) {
            MutableInteger mi = cellsMarked.get(aCell);
            if (mi.intValue() == 0) continue;
            ProjectCell pc = Project.projectDB.findProjectCell(aCell);
            if (pc == null) {
                Job.getUserInterface().showErrorMessage("Cell " + aCell.describe(true) + " is not in the project.  Add it before checking it in or out.", "Check-In Error");
                return;
            }
            if (pc.getOwner().equals(Project.getCurrentUserName())) continue;
            Job.getUserInterface().showErrorMessage("Cell " + aCell.describe(true) + "You cannot check-in " + aCell + " because it is checked out to '" + pc.getOwner() + "', not you.", "Check-In Error");
            return;
        }
        String comment = Job.getUserInterface().askForInput("Reason for checking-in " + cell.describe(true), "Describe the Change", lastComment);
        if (comment == null) {
            return;
        }
        lastComment = comment;
        new CheckInJob(Project.projectDB, cell.getLibrary(), cellsMarked, comment);
    }

    private CheckInJob(ProjectDB pdb, Library lib, HashMap<Cell, MutableInteger> cellsMarked, String comment) {
        super("Check in cells", Project.getProjectTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
        this.pdb = pdb;
        this.lib = lib;
        this.cellsMarked = cellsMarked;
        this.comment = comment;
        this.backupScheme = IOTool.getBackupRedundancy();
        this.startJob();
    }

    @Override
    public boolean doIt() throws JobException {
        EditingPreferences ep = this.getEditingPreferences();
        ProjectLibrary pl = this.pdb.findProjectLibrary(this.lib);
        pl.lockProjectFile();
        Project.setChangeStatus(true);
        Object cellNames = "";
        for (Cell cell : this.cellsMarked.keySet()) {
            MutableInteger mi = this.cellsMarked.get(cell);
            if (mi.intValue() == 0) continue;
            if (((String)cellNames).length() > 0) {
                cellNames = (String)cellNames + ", ";
            }
            cellNames = (String)cellNames + cell.describe(false);
        }
        String error = null;
        for (Cell cell : this.cellsMarked.keySet()) {
            MutableInteger mi = this.cellsMarked.get(cell);
            if (mi.intValue() == 0) continue;
            ProjectCell pc = this.pdb.findProjectCell(cell);
            if (pc == null) {
                error = "Cell " + cell.describe(true) + " is not in the project.  Add it before checking it in or out.";
                continue;
            }
            if (!pc.getOwner().equals(Project.getCurrentUserName())) {
                error = "You cannot check-in " + cell + " because it is checked out to '" + pc.getOwner() + "', not you.";
                continue;
            }
            if (Project.writeCell(cell, pc, this.backupScheme, ep)) {
                error = "Error writing " + cell;
                continue;
            }
            pc.setOwner("");
            pc.setLastOwner(Project.getCurrentUserName());
            pc.setVersion(cell.getVersion());
            pc.setComment(this.comment);
            Project.markLocked(cell, true, ep);
            System.out.println("Cell " + cell.describe(true) + " checked in");
        }
        Project.setChangeStatus(false);
        pl.releaseProjectFileLock(true);
        if (error != null) {
            throw new JobException(error);
        }
        return true;
    }

    private static HashMap<Cell, MutableInteger> markRelatedCells(Cell cell) {
        String owner;
        Cell oCell;
        Iterator<Cell> cIt;
        Library oLib;
        HashMap<Cell, MutableInteger> cellsMarked1 = new HashMap<Cell, MutableInteger>();
        HashMap<Cell, MutableInteger> cellsMarked2 = new HashMap<Cell, MutableInteger>();
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library oLib2 = it.next();
            Iterator<Cell> cIt2 = oLib2.getCells();
            while (cIt2.hasNext()) {
                Cell oCell2 = cIt2.next();
                cellsMarked1.put(oCell2, new MutableInteger(0));
                cellsMarked2.put(oCell2, new MutableInteger(0));
            }
        }
        MutableInteger mi = (MutableInteger)cellsMarked1.get(cell);
        mi.setValue(1);
        mi = (MutableInteger)cellsMarked2.get(cell);
        mi.setValue(1);
        boolean propagated = true;
        while (propagated) {
            propagated = false;
            Iterator<Library> it2 = Library.getLibraries();
            while (it2.hasNext()) {
                Library oLib3 = it2.next();
                Iterator<Cell> cIt3 = oLib3.getCells();
                while (cIt3.hasNext()) {
                    Cell oCell3 = cIt3.next();
                    mi = (MutableInteger)cellsMarked2.get(oCell3);
                    if (mi.intValue() != 1) continue;
                    propagated = true;
                    mi.setValue(2);
                    Iterator<NodeInst> nIt = oCell3.getInstancesOf();
                    while (nIt.hasNext()) {
                        NodeInst ni = nIt.next();
                        mi = (MutableInteger)cellsMarked2.get(ni.getParent());
                        if (mi.intValue() != 0) continue;
                        mi.setValue(1);
                    }
                }
            }
        }
        mi = (MutableInteger)cellsMarked2.get(cell);
        mi.setValue(0);
        int total = 0;
        Iterator<Library> it3 = Library.getLibraries();
        while (it3.hasNext()) {
            oLib = it3.next();
            cIt = oLib.getCells();
            while (cIt.hasNext()) {
                oCell = cIt.next();
                mi = (MutableInteger)cellsMarked2.get(oCell);
                if (mi.intValue() == 0 || (owner = Project.getCellOwner(oCell)).length() == 0 || !owner.equals(Project.getCurrentUserName())) continue;
                mi = cellsMarked1.get(oCell);
                mi.setValue(1);
                ++total;
            }
        }
        it3 = Library.getLibraries();
        while (it3.hasNext()) {
            oLib = it3.next();
            cIt = oLib.getCells();
            while (cIt.hasNext()) {
                oCell = cIt.next();
                mi = (MutableInteger)cellsMarked2.get(oCell);
                mi.setValue(0);
            }
        }
        mi = (MutableInteger)cellsMarked2.get(cell);
        mi.setValue(1);
        propagated = true;
        while (propagated) {
            propagated = false;
            it3 = Library.getLibraries();
            while (it3.hasNext()) {
                oLib = it3.next();
                cIt = oLib.getCells();
                while (cIt.hasNext()) {
                    oCell = cIt.next();
                    mi = (MutableInteger)cellsMarked2.get(oCell);
                    if (mi.intValue() != 1) continue;
                    propagated = true;
                    mi.setValue(2);
                    Iterator<NodeInst> nIt = oCell.getNodes();
                    while (nIt.hasNext()) {
                        NodeInst ni = nIt.next();
                        if (!ni.isCellInstance() || (mi = (MutableInteger)cellsMarked2.get(ni.getProto())).intValue() != 0) continue;
                        mi.setValue(1);
                    }
                }
            }
        }
        mi = (MutableInteger)cellsMarked2.get(cell);
        mi.setValue(0);
        it3 = Library.getLibraries();
        while (it3.hasNext()) {
            oLib = it3.next();
            cIt = oLib.getCells();
            while (cIt.hasNext()) {
                oCell = cIt.next();
                mi = (MutableInteger)cellsMarked2.get(oCell);
                if (mi.intValue() == 0 || (owner = Project.getCellOwner(oCell)).length() == 0 || !owner.equals(Project.getCurrentUserName())) continue;
                mi = cellsMarked1.get(oCell);
                mi.setValue(1);
                ++total;
            }
        }
        if (total > 0) {
            total = 0;
            StringBuffer infstr = new StringBuffer();
            Iterator<Library> it4 = Library.getLibraries();
            while (it4.hasNext()) {
                Library oLib4 = it4.next();
                Iterator<Cell> cIt4 = oLib4.getCells();
                while (cIt4.hasNext()) {
                    Cell oCell4 = cIt4.next();
                    mi = cellsMarked1.get(oCell4);
                    if (oCell4 == cell || mi.intValue() == 0) continue;
                    if (total > 0) {
                        infstr.append(", ");
                    }
                    infstr.append(oCell4.describe(true));
                    ++total;
                }
            }
            System.out.println("Also checking in related cell(s): " + infstr.toString());
        }
        return cellsMarked1;
    }
}

