# -*- coding: utf-8 -*-

# Copyright (C) 2004-2006 Johan Svedberg <johan@svedberg.com>

# This file is part of ontv.

# ontv is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ontv is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ontv; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

import getopt
import gettext
import locale
import sys
from gettext import gettext as _

import pygtk
pygtk.require("2.0")
import gtk
import gnome
import gnomeapplet

import GUI
from OnTVApplet import OnTVApplet
from ontv import NAME, VERSION, LOCALE_DIR

def main():
    gettext.bindtextdomain(NAME.lower(), LOCALE_DIR)
    gettext.textdomain(NAME.lower())

    locale.bindtextdomain(NAME.lower(), LOCALE_DIR)
    locale.textdomain(NAME.lower())

    try:
        opts, args = getopt.getopt(sys.argv[1:], "hdw", ["help", "debug",
                                   "window"])
    except getopt.GetoptError:
        opts = []
        args = sys.argv[1:]

    debug = standalone = False
    for o, a in opts:
        if o in ("-h", "--help"):
            print_usage()
        elif o in ("-d", "--debug"):
            debug = True
        elif o in ("-w", "--window"):
            standalone = True

    gnome.init(NAME, VERSION)
    gtk.threads_init()

    if standalone:
        window = gtk.Window(gtk.WINDOW_TOPLEVEL)
        window.set_title(NAME)
        window.set_icon(GUI.icon)
        window.connect("destroy", gtk.main_quit)
        applet = gnomeapplet.Applet()
        applet_factory(applet, None, debug, True)
        applet.reparent(window)
        window.show_all()
        gtk.main()
    else:
        activate_factory(debug)

def print_usage():
    print _("Usage: %s [OPTIONS]...") % (sys.argv[0])
    print ""
    print _("OPTIONS:")
    print "  -h, --help	%s" % (_("show this help message and exit"))
    print "  -d, --debug	%s" % (_("enable debug messages"))
    print "  -w, --window	%s" % (_("run OnTV in a standalone window (for testing purposes)"))

    sys.exit()

def applet_factory(applet, iid=None, debug=False, standalone=False):
    ontvapplet = OnTVApplet(applet, debug, standalone)
    ontvapplet.run()
    return True

def activate_factory(debug=False):
    gnomeapplet.bonobo_factory("OAFIID:GNOME_OnTVApplet_Factory",
                               gnomeapplet.Applet.__gtype__, NAME, VERSION,
                               applet_factory, (debug,))

# vim: set sw=4 et sts=4 tw=79 fo+=l:
