/*
 * Java-Gnome Bindings Library
 *
 * * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gtk;

import org.gnu.gdk.KeySymbol;
import org.gnu.gdk.ModifierType;
import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;

/**
 * Key bindings for individual widgets.
 * TODO: Complete javadocs. 
 */
public class BindingSet extends Boxed {
	
	/**
	 * Construct a new BindingSet using a handle to a native resource.
	 */
	private BindingSet(Handle handle) {
		this.handle = handle;
	}
	
	/**
	 * Construct a new BindingSet.
	 * @param setName The name of the BindingSet
	 */
	public BindingSet(String setName) {
		handle = gtk_binding_set_new(setName);
	}
	
	/**
	 * Finds a BindingSet object given the name.
	 * @param setName The name of the BindingSet to find
	 * @return A BindingSet object
	 */
	static public BindingSet findBindingSet(String setName) {
		return new BindingSet(gtk_binding_set_find(setName));
	}
	
	/**
	 * 
	 * @param keyval The key value for the BindingSet.
	 * @param modifier The key modifier for the BindingSet
	 */
	public boolean activateBindings(KeySymbol keyval, ModifierType modifier) {
        return gtk_bindings_activate(handle, keyval.getValue(), modifier.getValue());
	}
	
	/**
	 * 
	 * @param keyval The key value for the BindingSet.
	 * @param modifier The key modifier for the BindingSet
	 */
	public boolean activateBindingSet(KeySymbol keyval, ModifierType modifier) {
		return gtk_binding_set_activate(handle, keyval.getValue(), modifier.getValue(), handle);
	}
	
	/**
	 * Clears a BindingSet entry.
	 * @param keyval The key value for the BindingSet.
	 * @param modifier The key modifier for the BindingSet
	 */
	public void clearEntry(KeySymbol keyval, ModifierType modifier) {
		gtk_binding_entry_clear(handle, keyval.getValue(), modifier.getValue());
	}
	
	/**
	 *  
	 * @param pathType
	 * @param pathPattern
	 * @param priority
	 */
	public void addPath(PathType pathType, String pathPattern, PathPriorityType priority) {
		gtk_binding_set_add_path(handle, pathType.getValue(), pathPattern, priority.getValue());
	}
	
	
	native static final protected Handle gtk_binding_set_new(String setName);
	native static final protected Handle gtk_binding_set_find(String setName);
	native static final protected boolean gtk_bindings_activate(Handle object, int keyval, int modifier);
	native static final protected boolean gtk_binding_set_activate(Handle bindingSet, int keyval, int modifier, Handle object);
	native static final protected void gtk_binding_entry_clear(Handle bindingSet, int keyval, int modifier);
	native static final protected void gtk_binding_set_add_path(Handle bindingSet, int pathType, String pathPattern, int priority);

}
