/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#ifdef __cplusplus
extern "C" 
{
#endif

    /*
     * Class:     org.gnu.gtk.Entry
     * Method:    gtk_entry_get_type
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Entry_gtk_1entry_1get_1type (JNIEnv *env, jclass cls) 
    {
        {
            return (jint)gtk_entry_get_type ();
        }
    }

    /*
     * Class:     org.gnu.gtk.Entry
     * Method:    gtk_entry_new
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Entry_gtk_1entry_1new (JNIEnv *env, jclass cls) 
    {
        {
            return (jint)gtk_entry_new ();
        }
    }

    /*
     * Class:     org.gnu.gtk.Entry
     * Method:    gtk_entry_set_visibility
     * Signature: (IZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Entry_gtk_1entry_1set_1visibility (JNIEnv *env, jclass 
        cls, jint entry, jboolean visible) 
    {
        GtkEntry *entry_g = (GtkEntry *)entry;
        gboolean visible_g = (gboolean) visible;
        {
            gtk_entry_set_visibility (entry_g, visible_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Entry
     * Method:    gtk_entry_get_visibility
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Entry_gtk_1entry_1get_1visibility (JNIEnv *env, 
        jclass cls, jint entry) 
    {
        GtkEntry *entry_g = (GtkEntry *)entry;
        {
            jboolean result_j = (jboolean) (gtk_entry_get_visibility (entry_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Entry
     * Method:    gtk_entry_set_invisible_char
     * Signature: (IB)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Entry_gtk_1entry_1set_1invisible_1char (JNIEnv *env, 
        jclass cls, jint entry, jbyte ch) 
    {
        GtkEntry *entry_g = (GtkEntry *)entry;
        gchar ch_g = (gchar) ch;
        {
            gtk_entry_set_invisible_char (entry_g, ch_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Entry
     * Method:    gtk_entry_get_invisible_char
     * Signature: (I)B
     */
    JNIEXPORT jbyte JNICALL Java_org_gnu_gtk_Entry_gtk_1entry_1get_1invisible_1char (JNIEnv *env, 
        jclass cls, jint entry) 
    {
        GtkEntry *entry_g = (GtkEntry *)entry;
        {
            jbyte result_j = (jbyte) (gtk_entry_get_invisible_char (entry_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Entry
     * Method:    gtk_entry_set_has_frame
     * Signature: (IZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Entry_gtk_1entry_1set_1has_1frame (JNIEnv *env, jclass 
        cls, jint entry, jboolean setting) 
    {
        GtkEntry *entry_g = (GtkEntry *)entry;
        gboolean setting_g = (gboolean) setting;
        {
            gtk_entry_set_has_frame (entry_g, setting_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Entry
     * Method:    gtk_entry_get_has_frame
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Entry_gtk_1entry_1get_1has_1frame (JNIEnv *env, 
        jclass cls, jint entry) 
    {
        GtkEntry *entry_g = (GtkEntry *)entry;
        {
            jboolean result_j = (jboolean) (gtk_entry_get_has_frame (entry_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Entry
     * Method:    gtk_entry_set_max_length
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Entry_gtk_1entry_1set_1max_1length (JNIEnv *env, jclass 
        cls, jint entry, jint max) 
    {
        GtkEntry *entry_g = (GtkEntry *)entry;
        gint32 max_g = (gint32) max;
        {
            gtk_entry_set_max_length (entry_g, max_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Entry
     * Method:    gtk_entry_get_max_length
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Entry_gtk_1entry_1get_1max_1length (JNIEnv *env, jclass 
        cls, jint entry) 
    {
        GtkEntry *entry_g = (GtkEntry *)entry;
        {
            jint result_j = (jint) (gtk_entry_get_max_length (entry_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Entry
     * Method:    gtk_entry_set_activates_default
     * Signature: (IZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Entry_gtk_1entry_1set_1activates_1default (JNIEnv *env, 
        jclass cls, jint entry, jboolean setting) 
    {
        GtkEntry *entry_g = (GtkEntry *)entry;
        gboolean setting_g = (gboolean) setting;
        {
            gtk_entry_set_activates_default (entry_g, setting_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Entry
     * Method:    gtk_entry_get_activates_default
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Entry_gtk_1entry_1get_1activates_1default (JNIEnv 
        *env, jclass cls, jint entry) 
    {
        GtkEntry *entry_g = (GtkEntry *)entry;
        {
            jboolean result_j = (jboolean) (gtk_entry_get_activates_default (entry_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Entry
     * Method:    gtk_entry_set_width_chars
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Entry_gtk_1entry_1set_1width_1chars (JNIEnv *env, 
        jclass cls, jint entry, jint numChars) 
    {
        GtkEntry *entry_g = (GtkEntry *)entry;
        gint32 numChars_g = (gint32) numChars;
        {
            gtk_entry_set_width_chars (entry_g, numChars_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Entry
     * Method:    gtk_entry_get_width_chars
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Entry_gtk_1entry_1get_1width_1chars (JNIEnv *env, 
        jclass cls, jint entry) 
    {
        GtkEntry *entry_g = (GtkEntry *)entry;
        {
            jint result_j = (jint) (gtk_entry_get_width_chars (entry_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Entry
     * Method:    gtk_entry_set_text
     * Signature: (I[B)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Entry_gtk_1entry_1set_1text (JNIEnv *env, jclass cls, 
        jint entry, jstring text) 
    {
        GtkEntry *entry_g = (GtkEntry *)entry;
        const gchar* text_g = (*env)->GetStringUTFChars(env, text, NULL);
		gtk_entry_set_text (entry_g, text_g);
		(*env)->ReleaseStringUTFChars(env, text, text_g);
    }

    /*
     * Class:     org.gnu.gtk.Entry
     * Method:    gtk_entry_get_text
     * Signature: (I)[B
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_gtk_Entry_gtk_1entry_1get_1text (JNIEnv *env, jclass 
        cls, jint entry) 
    {
		return (*env)->NewStringUTF(env, (char *)gtk_entry_get_text ((GtkEntry*)entry));
    }

    /*
     * Class:     org.gnu.gtk.Entry
     * Method:    gtk_entry_get_layout
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Entry_gtk_1entry_1get_1layout (JNIEnv *env, jclass cls, 
        jint entry) 
    {
        GtkEntry *entry_g = (GtkEntry *)entry;
        {
            return (jint)gtk_entry_get_layout (entry_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Entry
     * Method:    gtk_entry_get_layout_offsets
     * Signature: (I[Lint ;[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Entry_gtk_1entry_1get_1layout_1offsets (JNIEnv *env, 
        jclass cls, jint entry, jintArray x, jintArray y) 
    {
        GtkEntry *entry_g = (GtkEntry *)entry;
        gint *x_g = (gint *) (*env)->GetIntArrayElements (env, x, NULL);
        gint *y_g = (gint *) (*env)->GetIntArrayElements (env, y, NULL);
        {
            gtk_entry_get_layout_offsets (entry_g, x_g, y_g);
            (*env)->ReleaseIntArrayElements (env, x, (jint *) x_g, 0);
            (*env)->ReleaseIntArrayElements (env, y, (jint *) y_g, 0);
        }
    }


/*
 * Class:     org_gnu_gtk_Entry
 * Method:    gtk_entry_set_completion
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Entry_gtk_1entry_1set_1completion
  (JNIEnv *env, jclass cls, jint entry, jint completion)
{
	gtk_entry_set_completion((GtkEntry*)entry, (GtkEntryCompletion*)completion);
}
                                                                                 /*
 * Class:     org_gnu_gtk_Entry
 * Method:    gtk_entry_get_completion
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_Entry_gtk_1entry_1get_1completion
  (JNIEnv *env, jclass cls, jint entry)
{
	return (jint)gtk_entry_get_completion((GtkEntry*)entry);
}

#ifdef __cplusplus
}

#endif
