/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif

GdkBitmap * GdkPangoAttrStipple_get_stipple (GdkPangoAttrStipple * cptr) 
{
    return cptr->stipple;
}

/*
 * Class:     org.gnu.gdk.PangoAttrStipple
 * Method:    getStipple
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_PangoAttrStipple_getStipple (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkPangoAttrStipple *obj_g = (GdkPangoAttrStipple *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkPangoAttrStipple_get_stipple (obj_g));
}

/*
 * Class:     org.gnu.gdk.PangoAttrStipple
 * Method:    gdk_pango_attr_stipple_new
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_PangoAttrStipple_gdk_1pango_1attr_1stipple_1new (JNIEnv 
    *env, jclass cls, jobject stipple) 
{
    GdkBitmap *stipple_g = (GdkBitmap *)getPointerFromHandle(env, stipple);
    return getHandleFromPointer(env, gdk_pango_attr_stipple_new (stipple_g));
}


#ifdef __cplusplus
}

#endif
