/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import java.util.HashMap;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;

/**
 * Class for sorting the rows of a base {@link TreeModel}.  The underlying
 * TreeModel us sorted using a comparison function.  The comparison function
 * is set with the <tt>{@link #setSortMethod}</tt> method.
 */
public class TreeModelSort extends TreeModel  {

    // Hash to store the TreeIterComparison objects used to sort a column.
    protected HashMap sortMethods = null;

    /** For internal use only. */
    protected TreeModelSort( Handle handle ) {
        super( handle );
    }

    /**
     * Create a new TreeModelSort using the given TreeModel as the underlying
     * data model.
     */
    public TreeModelSort(TreeModel model) {
        super(gtk_tree_model_sort_new_with_model( model.getHandle() ));
    }

    /**
     * Retrieve the runtime type used by the GLib library.
     */
    public static Type getType() {
        return new Type(gtk_tree_model_sort_get_type());
    }

    /**
     * Return the underlying data model.
     */
    public TreeModel getModel() {
        return (TreeModel)getGObjectFromHandle(gtk_tree_model_sort_get_model(getHandle()));
    }


    native static final protected int gtk_tree_model_sort_get_type();
    native static final protected Handle gtk_tree_model_sort_new_with_model(Handle childModel);
    native static final protected Handle gtk_tree_model_sort_get_model(Handle treeModel);

    // Implemented in C, but not in Java.
    native static final protected Handle gtk_tree_model_sort_convert_child_path_to_path(Handle treeModel, Handle childPath);
    native static final protected void gtk_tree_model_sort_convert_child_iter_to_iter(Handle treeModel, Handle childIter, Handle sortIter);
    native static final protected Handle gtk_tree_model_sort_convert_path_to_child_path(Handle treeModel, Handle sortedPath);
    native static final protected void gtk_tree_model_sort_convert_iter_to_child_iter(Handle treeModel, Handle childIter, Handle sortedIter);
    native static final protected void gtk_tree_model_sort_clear_cache(Handle treeModel);

    // Not implemented.
    //native static final protected void gtk_tree_model_sort_reset_default_sort_func(Handle treeModel);
    //native static final protected boolean gtk_tree_model_sort_iter_is_valid(Handle treeModel, Handle iter);
}
