/*
 * Java-Gnome Bindings Library
 *
 * * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

import org.gnu.gdk.EventKey;
import org.gnu.gdk.ModifierType;

/**
 * @author Jeffrey S. Morgan
 *
 * This event object is used to identify when a key has been pressed and released.
 * 
 * @see KeyListener
 */
public class KeyEvent extends GtkEvent {

	public static class Type extends GtkEventType{
		private Type(int id, String name){
			super(id, name);
		}
		/**
		 * This event indicates that a key has been pressed.
		 */
		public static final Type KEY_PRESSED = new Type(1, "KEY_PRESSED");

		/**
		 * This event indicates that a key has been released.
		 */	
		public static final Type KEY_RELEASED = new Type(2, "KEY_RELEASED");
	}

	/**
	 * Represents the state of the modifier keys (e.g. Control, Shift, and Alt) and the 
	 * pointer buttons.
	 */
	private ModifierType modifierKey;
	
	/**
	 * The key that was pressed or released.  This value can be compared against the 
	 * values contained in org.gnu.gdk.KeySymbols.
	 */
	private int keyval;
	
	/**
	 * The length of the string
	 */
	private int length;
	
	/**
	 * A null-terminated multi-byte string containing the composed characters resulting from the 
	 * key press. 
	 */
	private String string;

	/**
	 * Construct a KeyEvent object.
	 */
	public KeyEvent(Object source, KeyEvent.Type type, EventKey gdkEvent) {
		super(source, type);
		this.modifierKey = ModifierType.intern(gdkEvent.getState());
		this.keyval = gdkEvent.getKeyVal();
		this.length = gdkEvent.getLength();
		this.string = gdkEvent.getString();
	}

	/**
	 * Test to compare events.
	 */
	public boolean isOfType(KeyEvent.Type test){
		return type.getID() == test.getID();
	}
	/**
	 * Returns the keyval.
	 * @return int
	 */
	public int getKeyval() {
		return keyval;
	}

	/**
	 * Returns the length.
	 * @return int
	 */
	public int getLength() {
		return length;
	}

	/**
	 * Returns the modifierKey.
	 * @return ModifierType
	 */
	public ModifierType getModifierKey() {
		return modifierKey;
	}

	/**
	 * Returns the string.
	 * @return String
	 */
	public String getString() {
		return string;
	}

}
