/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:42:31 EDT
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#ifdef __cplusplus
extern "C" 
{
#endif
	typedef struct{
		JNIEnv *env;
		jobject obj;
		jmethodID mid;
	} ForEachData;

	void forEachFunc(GtkTreeModel *model,
                                             GtkTreePath *path,
                                             GtkTreeIter *iter,
                                             gpointer data)
	{
		jvalue *jargs;
		ForEachData *fedata = (ForEachData *) data;
		jargs = alloca(sizeof(jvalue) * 3);
		jargs[0].i = (jint) model;
		jargs[1].i = (jint) path;
		jargs[2].i = (jint) iter;
		(*(fedata->env))->CallVoidMethodA(fedata->env, fedata->obj, fedata->mid, jargs);
	}
	
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeSelection_startForEach (JNIEnv 
        *env, jclass cls, jint selection, jobject connect_to) 
    {
		ForEachData * fedata = g_new(ForEachData, 1);
		GtkTreeSelection *selection_g = (GtkTreeSelection *)selection;
		fedata->env = env;				
		fedata->obj = (*env)->NewGlobalRef(env, connect_to);
		fedata->mid = (*env)->GetMethodID(env, (*env)->GetObjectClass(env, connect_to), "doEach", "(III)V");
		gtk_tree_selection_selected_foreach(selection_g, (GtkTreeSelectionForeachFunc) forEachFunc, fedata);
	}
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    /*
     * Class:     org.gnu.gtk.TreeSelection
     * Method:    gtk_tree_selection_get_type
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeSelection_gtk_1tree_1selection_1get_1type (JNIEnv 
        *env, jclass cls) 
    {
        {
            return (jint)gtk_tree_selection_get_type ();
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeSelection
     * Method:    gtk_tree_selection_set_mode
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeSelection_gtk_1tree_1selection_1set_1mode (JNIEnv 
        *env, jclass cls, jint selection, jint type) 
    {
        GtkTreeSelection *selection_g = (GtkTreeSelection *)selection;
        GtkSelectionMode type_g = (GtkSelectionMode) type;
        {
            gtk_tree_selection_set_mode (selection_g, type_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeSelection
     * Method:    gtk_tree_selection_get_mode
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeSelection_gtk_1tree_1selection_1get_1mode (JNIEnv 
        *env, jclass cls, jint selection) 
    {
        GtkTreeSelection *selection_g = (GtkTreeSelection *)selection;
        {
            jint result_j = (jint) (gtk_tree_selection_get_mode (selection_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeSelection
     * Method:    gtk_tree_selection_get_user_data
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeSelection_gtk_1tree_1selection_1get_1user_1data (
        JNIEnv *env, jclass cls, jint selection) 
    {
        GtkTreeSelection *selection_g = (GtkTreeSelection *)selection;
        {
            return (jint)gtk_tree_selection_get_user_data (selection_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeSelection
     * Method:    gtk_tree_selection_get_tree_view
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeSelection_gtk_1tree_1selection_1get_1tree_1view (
        JNIEnv *env, jclass cls, jint selection) 
    {
        GtkTreeSelection *selection_g = (GtkTreeSelection *)selection;
        {
            return (jint)gtk_tree_selection_get_tree_view (selection_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeSelection
     * Method:    gtk_tree_selection_get_selected
     * Signature: (I[Lint ;I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreeSelection_gtk_1tree_1selection_1get_1selected (
        JNIEnv *env, jclass cls, jint selection, jintArray model, jint iter) 
    {
        GtkTreeSelection *selection_g = (GtkTreeSelection *)selection;
        gint *model_g_g = (gint *) (*env)->GetIntArrayElements (env, model, NULL);
        GtkTreeModel **model_g = (GtkTreeModel **)model_g_g;
        GtkTreeIter *iter_g = (GtkTreeIter *)iter;
        {
            jboolean result_j = (jboolean) (gtk_tree_selection_get_selected (selection_g, model_g, 
                    iter_g));
            (*env)->ReleaseIntArrayElements (env, model, (jint*)model_g_g, 0);
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeSelection
     * Method:    gtk_tree_selection_select_path
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeSelection_gtk_1tree_1selection_1select_1path (
        JNIEnv *env, jclass cls, jint selection, jint path) 
    {
        GtkTreeSelection *selection_g = (GtkTreeSelection *)selection;
        GtkTreePath *path_g = (GtkTreePath *)path;
        {
            gtk_tree_selection_select_path (selection_g, path_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeSelection
     * Method:    gtk_tree_selection_unselect_path
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeSelection_gtk_1tree_1selection_1unselect_1path (
        JNIEnv *env, jclass cls, jint selection, jint path) 
    {
        GtkTreeSelection *selection_g = (GtkTreeSelection *)selection;
        GtkTreePath *path_g = (GtkTreePath *)path;
        {
            gtk_tree_selection_unselect_path (selection_g, path_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeSelection
     * Method:    gtk_tree_selection_select_iter
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeSelection_gtk_1tree_1selection_1select_1iter (
        JNIEnv *env, jclass cls, jint selection, jint iter) 
    {
        GtkTreeSelection *selection_g = (GtkTreeSelection *)selection;
        GtkTreeIter *iter_g = (GtkTreeIter *)iter;
        {
            gtk_tree_selection_select_iter (selection_g, iter_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeSelection
     * Method:    gtk_tree_selection_unselect_iter
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeSelection_gtk_1tree_1selection_1unselect_1iter (
        JNIEnv *env, jclass cls, jint selection, jint iter) 
    {
        GtkTreeSelection *selection_g = (GtkTreeSelection *)selection;
        GtkTreeIter *iter_g = (GtkTreeIter *)iter;
        {
            gtk_tree_selection_unselect_iter (selection_g, iter_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeSelection
     * Method:    gtk_tree_selection_path_is_selected
     * Signature: (II)Z
     */
    JNIEXPORT jboolean JNICALL 
    Java_org_gnu_gtk_TreeSelection_gtk_1tree_1selection_1path_1is_1selected (JNIEnv *env, jclass 
        cls, jint selection, jint path) 
    {
        GtkTreeSelection *selection_g = (GtkTreeSelection *)selection;
        GtkTreePath *path_g = (GtkTreePath *)path;
        {
            jboolean result_j = (jboolean) (gtk_tree_selection_path_is_selected (selection_g, 
                    path_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeSelection
     * Method:    gtk_tree_selection_iter_is_selected
     * Signature: (II)Z
     */
    JNIEXPORT jboolean JNICALL 
    Java_org_gnu_gtk_TreeSelection_gtk_1tree_1selection_1iter_1is_1selected (JNIEnv *env, jclass 
        cls, jint selection, jint iter) 
    {
        GtkTreeSelection *selection_g = (GtkTreeSelection *)selection;
        GtkTreeIter *iter_g = (GtkTreeIter *)iter;
        {
            jboolean result_j = (jboolean) (gtk_tree_selection_iter_is_selected (selection_g, 
                    iter_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeSelection
     * Method:    gtk_tree_selection_select_all
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeSelection_gtk_1tree_1selection_1select_1all (JNIEnv 
        *env, jclass cls, jint selection) 
    {
        GtkTreeSelection *selection_g = (GtkTreeSelection *)selection;
        {
            gtk_tree_selection_select_all (selection_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeSelection
     * Method:    gtk_tree_selection_unselect_all
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeSelection_gtk_1tree_1selection_1unselect_1all (
        JNIEnv *env, jclass cls, jint selection) 
    {
        GtkTreeSelection *selection_g = (GtkTreeSelection *)selection;
        {
            gtk_tree_selection_unselect_all (selection_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.TreeSelection
     * Method:    gtk_tree_selection_select_range
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeSelection_gtk_1tree_1selection_1select_1range (
        JNIEnv *env, jclass cls, jint selection, jint startPath, jint endPath) 
    {
        GtkTreeSelection *selection_g = (GtkTreeSelection *)selection;
        GtkTreePath *startPath_g = (GtkTreePath *)startPath;
        GtkTreePath *endPath_g = (GtkTreePath *)endPath;
        {
            gtk_tree_selection_select_range (selection_g, startPath_g, endPath_g);
        }
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
