/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:33 EDT
 */

package org.gnu.gtk;

import org.gnu.glib.EventMap;
import org.gnu.glib.Type;
import org.gnu.gtk.event.ScaleEvent;
import org.gnu.gtk.event.ScaleListener;
import org.gnu.gtk.event.GtkEventType;

/**
 * A Scale is a slider control used to select a numeric value. To use it, 
 * you'll probably want to investigate the methods on its base class, 
 * {@link Range}, in addition to the methods for Scale itself. To set the 
 * value of a scale, you would normally use {@link Range#setValue(double)}. 
 * To detect changes to the value, add RangeListener object to the widget.
 *
 * <p>The GtkScale widget is an abstract class, used only for deriving the 
 * subclasses {@link HScale} and {@link VScale}.
 * @see HScale
 * @see VScale
 */
public abstract class Scale extends Range {
	protected Scale(int handle) {
		super(handle);
	}

	protected Scale() {
	}

	protected void noopInit() {
	}

	/**
	 * Sets the number of decimal places that are displayed in the value. 
	 * Also causes the value of the adjustment to be rounded off to this number
	 * of digits, so the retrieved value matches the value the user saw.
	 * @param digits The number of decimal places to display, e.g. use 1 to 
	 * display 1.0, 2 to display 1.00 etc.
	 */
	public void setDigits(int digits) {
		gtk_scale_set_digits(handle, digits);
	}

	/**
	 * Sets the position in which the current value is displayed.
	 * @param pos The position in which the current value is displayed.
	 */
	public void setValuePosition(PositionType pos) {
		gtk_scale_set_value_pos(handle, pos.getValue());
	}

	/**
	 * Specifies whether the current value is displayed as a string next to the slider.
	 * @param setting If true, the value is displayed.
	 */
	public void setDrawValue(boolean setting) {
		gtk_scale_set_draw_value(handle, setting);
	}

	/* 
	 * EVENT HANDLING
	 */

	ScaleListener formatListener = null;

	/**
	 * Sets a listener to be used when a format-value request is called. 
	 */
	public void setFormatListener(ScaleListener listener) {
		formatListener = listener;
	}
	/**
	 * Removes the format listener
	 */
	public void removeFormatListener() {
		formatListener = null;
	}
	protected void initializeEventHandlers() {
		super.initializeEventHandlers();
		evtMap.initialize(this);
	}

	public Class getEventListenerClass(String signal) {
		return evtMap.getListenerClass(signal);
	}

	public GtkEventType getEventType(String signal) {
		return evtMap.getEventType(signal);
	}

	private static EventMap evtMap = new EventMap();
	static {
		addEvents(evtMap);
	}

	private static void addEvents(EventMap anEvtMap) {
		anEvtMap.addEvent("format_value", "handleFormatValue", ScaleEvent.Type.FORMAT_VALUE, ScaleListener.class);
	}

	private String handleFormatValue(double value) {
		if (null == formatListener) {
			return (java.lang.Double.toString(value));
		} else {
			return (formatListener.formatScaleValue(new ScaleEvent(this), value));
		}
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_scale_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gtk_scale_get_type();
	native static final protected void gtk_scale_set_digits(int scale, int digits);
	native static final protected int gtk_scale_get_digits(int scale);
	native static final protected void gtk_scale_set_draw_value(int scale, boolean drawValue);
	native static final protected boolean gtk_scale_get_draw_value(int scale);
	native static final protected void gtk_scale_set_value_pos(int scale, int pos);
	native static final protected int gtk_scale_get_value_pos(int scale);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
