/* -----------------------------------------------------------------------------
 * std_list.i
 * ----------------------------------------------------------------------------- */

%{
#include <list>
%}

namespace std {

    template<class T> class list {
      public:
        typedef size_t size_type;
        typedef T value_type;
        typedef const value_type& const_reference;
        list();
        list(size_type n);
        size_type size() const;
        %rename(isEmpty) empty;
        bool empty() const;
        void clear();
        void reverse();
        %rename(addFirst) push_front;
        void push_front(const value_type& x);
        %rename(addLast) push_back;
        void push_back(const value_type& x);
        %rename(getFirst) front;
        const_reference front();
        %rename(getLast) back;
        const_reference back();
        %rename(clearLast) pop_back;
        void pop_back();
        %rename(clearFirst) pop_front;
        void pop_front();
   };
}
