/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gnome-scan
 * Copyright (C) Étienne Bersac 2007 <bersace03@laposte.net>
 * 
 * gnome-scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#ifndef _META_PARAM_H_
#define _META_PARAM_H_

#include <glib-object.h>
#include <gnome-scan-param-specs.h>
#include <sane/sane.h>
#include "gsane-scanner.h"
#include "gsane-common.h"

G_BEGIN_DECLS

#define GSANE_TYPE_META_PARAM       		(meta_param_get_type ())
#define GSANE_META_PARAM(inst)           	(G_TYPE_CHECK_INSTANCE_CAST ((inst), GSANE_TYPE_META_PARAM, MetaParam))
#define GSANE_META_PARAM_CLASS(klass)   	(G_TYPE_CHECK_CLASS_CAST ((klass), GSANE_TYPE_META_PARAM, MetaParamClass))
#define GSANE_META_PARAM_GET_CLASS(inst)   	(G_TYPE_INSTANCE_GET_CLASS ((inst), GSANE_TYPE_META_PARAM, MetaParamClass))

typedef struct _MetaParamClass MetaParamClass;
typedef struct _MetaParam MetaParam;
typedef void	(*MetaParamFinalizeFunc)	(MetaParam *mp);

struct _MetaParamClass
{
	GTypeClass	parent_class;
	
	GStrv		options_names;
	GStrv		params_names;
	
	void		(* add_param)			(MetaParam *mp,
										  GParamSpec* spec);
	gboolean	(* get_params)			(MetaParam *mp);
	GValue*		(* get_value)			(MetaParam *mp,
										  GParamSpec *spec);
	SANE_Int	(* set_value)			(MetaParam *mp,
										  GParamSpec *spec,
										  GValue *value);
	MetaParamFinalizeFunc	finalize;
};

/*
 * MetaParam is away to handle SANE backends quirks and inconsistency.
 * This is only a set of workarounds for various scanners, as bugs arrive.
 */
struct _MetaParam
{
	GTypeInstance		instance;
	
	GSaneScanner*		gss;
	GnomeScanSettings*	settings;
	const gchar*		name;
};

GType meta_param_get_type (void) G_GNUC_CONST;

MetaParam*	meta_param_internal		(GType type,
								   gchar *name,
								   GSaneScanner *gss);

gchar*		meta_param_get_name		(MetaParam *mp);
#define	meta_param_get_options_names(mp)	GSANE_META_PARAM_GET_CLASS (mp)->options_names
#define	meta_param_get_params_names(mp)		GSANE_META_PARAM_GET_CLASS (mp)->params_names

void		meta_param_add_params (MetaParam *mp, GParamSpec *spec);
gboolean	meta_param_get_params (MetaParam *mp);
SANE_Int	meta_param_set_value (MetaParam *mp, GParamSpec *spec, GnomeScanSettings *settings);
GValue*		meta_param_get_value (MetaParam *mp, GParamSpec *spec);
void		meta_param_destroy		(MetaParam* mp);



/* PAPER_SIZE */
/* Paper_Size meta param allow to use PWG paper name, orientation other.
 * Samsung backend provide a page-format option.
 * I suppose fujitsu/avision use paper-width/paper-height
 * Most scanners provide {tl,br}-{x,y} options (except handhelds).
 */
#define GSANE_TYPE_META_PARAM_PAPER_SIZE       	(meta_param_paper_size_get_type ())
#define GSANE_META_PARAM_PAPER_SIZE(obj)          (G_TYPE_CHECK_INSTANCE_CAST ((obj), GSANE_TYPE_META_PARAM_PAPER_SIZE, MetaParamPaperSize))

typedef struct _MetaParamPaperSize MetaParamPaperSize;
struct _MetaParamPaperSize
{
	MetaParam	parent_instance;
	
	GParamSpec*	tl_x;
	GParamSpec*	tl_y;
	GParamSpec*	br_x;
	GParamSpec*	br_y;
	
	gboolean	manual;

	/* values */
	GtkPaperSize		*ps;
	GtkPageOrientation	po;
	GdkPoint			*origin;
};

GType		meta_param_paper_size_get_type	(void) G_GNUC_CONST;
MetaParam*	meta_param_paper_size (GSaneScanner *gss);

/* SOURCE */
/* The purpose of this meta-param is to determine wether the scan is adf or not.
 * Also, it allow to handle properly duplex.
 *
 * SANE 1.x does not state about source nor duplex.
 *
 * Samsung uses doc-source
 * avision/fujitsu uses source with duplex option inside.
 * samsung and hpaio provides "Auto" source.
 */
#define GSANE_TYPE_META_PARAM_SOURCE       	(meta_param_source_get_type ())
#define GSANE_META_PARAM_SOURCE(obj)        (G_TYPE_CHECK_INSTANCE_CAST ((obj), GSANE_TYPE_META_PARAM_SOURCE, MetaParamSource))

typedef struct _MetaParamSource MetaParamSource;
struct _MetaParamSource
{
	MetaParam		parent_instance;
	
	GHashTable*		dic;
	
	/* saved option */
	GParamSpec*		source;
	GParamSpec*		adf;
	GParamSpec*		duplex;
};

GType		meta_param_source_get_type	(void) G_GNUC_CONST;
MetaParam*	meta_param_source (GSaneScanner *gss);


G_END_DECLS

#endif /* _META_PARAM_H_ */
