/* match-all.c generated by valac 0.12.0, the Vala compiler
 * generated from match-all.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <tracker-test.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <folks/folks-tracker.h>
#include <gio/gio.h>
#include <gee.h>


#define TYPE_MATCH_ALL_TESTS (match_all_tests_get_type ())
#define MATCH_ALL_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATCH_ALL_TESTS, MatchAllTests))
#define MATCH_ALL_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATCH_ALL_TESTS, MatchAllTestsClass))
#define IS_MATCH_ALL_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATCH_ALL_TESTS))
#define IS_MATCH_ALL_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATCH_ALL_TESTS))
#define MATCH_ALL_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATCH_ALL_TESTS, MatchAllTestsClass))

typedef struct _MatchAllTests MatchAllTests;
typedef struct _MatchAllTestsClass MatchAllTestsClass;
typedef struct _MatchAllTestsPrivate MatchAllTestsPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _tracker_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (tracker_test_backend_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _MatchAllTestsTestMatchAllAsyncData MatchAllTestsTestMatchAllAsyncData;
typedef struct _MatchAllTestsTryToAddData MatchAllTestsTryToAddData;
typedef struct _MatchAllTestsAddPersonasData MatchAllTestsAddPersonasData;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _MatchAllTestsDoAddPersonaData MatchAllTestsDoAddPersonaData;

struct _MatchAllTests {
	FolksTestCase parent_instance;
	MatchAllTestsPrivate * priv;
};

struct _MatchAllTestsClass {
	FolksTestCaseClass parent_class;
};

struct _MatchAllTestsPrivate {
	GMainLoop* _main_loop;
	TrackerTestBackend* _tracker_backend;
	FolksIndividualAggregator* _aggregator;
	gchar* _persona_fullname_1;
	gchar* _persona_fullname_2;
	gchar* _persona_fullname_3;
	gchar* _persona_fullname_4;
	gboolean _added_personas;
	GStaticRecMutex __lock__added_personas;
	gchar* _individual_id_1;
	gchar* _individual_id_2;
	gchar* _individual_id_3;
	gchar* _individual_id_4;
	TrfPersonaStore* _pstore;
	GList* _matches_all;
	gint _matches_1;
};

struct _MatchAllTestsTestMatchAllAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MatchAllTests* self;
	FolksBackendStore* _tmp0_;
	FolksBackendStore* store;
	FolksIndividualAggregator* _tmp1_;
	GeeMap* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	GeeIterator* _backend_it;
	gboolean _tmp7_;
	gpointer _tmp8_;
	FolksBackend* backend;
	GeeMap* _tmp9_;
	gpointer _tmp10_;
	GError * e;
	GError * _inner_error_;
};

struct _MatchAllTestsTryToAddData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MatchAllTests* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_;
};

struct _MatchAllTestsAddPersonasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MatchAllTests* self;
};

struct _MatchAllTestsDoAddPersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MatchAllTests* self;
	gchar* fn;
	GHashTable* _tmp0_;
	GHashTable* details;
	GValue* val;
	GValue _tmp1_;
	GValue _tmp2_;
	GValue _tmp3_;
	GValue* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GValue* _tmp7_;
	FolksPersona* _tmp8_;
	FolksPersona* _tmp9_;
	GError * e;
	GError * _inner_error_;
};


static gpointer match_all_tests_parent_class = NULL;

GType match_all_tests_get_type (void) G_GNUC_CONST;
#define MATCH_ALL_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATCH_ALL_TESTS, MatchAllTestsPrivate))
enum  {
	MATCH_ALL_TESTS_DUMMY_PROPERTY
};
MatchAllTests* match_all_tests_new (void);
MatchAllTests* match_all_tests_construct (GType object_type);
void match_all_tests_test_match_all (MatchAllTests* self);
static void _match_all_tests_test_match_all_folks_test_case_test_method (gpointer self);
static void match_all_tests_real_set_up (FolksTestCase* base);
static void match_all_tests_real_tear_down (FolksTestCase* base);
static void _match_all_tests_test_match_all_async (MatchAllTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _match_all_tests_test_match_all_finish (MatchAllTests* self, GAsyncResult* _res_);
static gboolean _lambda0_ (MatchAllTests* self);
static gboolean __lambda0__gsource_func (gpointer self);
static void _match_all_tests_test_match_all_async_data_free (gpointer _data);
static gboolean _match_all_tests_test_match_all_async_co (MatchAllTestsTestMatchAllAsyncData* data);
static void _match_all_tests_test_match_all_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _match_all_tests_individuals_changed_cb (MatchAllTests* self, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason);
static void __match_all_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static void _match_all_tests_notify_pstore_cb (MatchAllTests* self, GObject* _pstore, GParamSpec* ps);
static void __match_all_tests_notify_pstore_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _match_all_tests_try_to_add (MatchAllTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _match_all_tests_try_to_add_finish (MatchAllTests* self, GAsyncResult* _res_);
static void _match_all_tests_try_match_all (MatchAllTests* self);
static void _match_all_tests_try_to_add_data_free (gpointer _data);
static gboolean _match_all_tests_try_to_add_co (MatchAllTestsTryToAddData* data);
static void _match_all_tests_add_personas (MatchAllTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _match_all_tests_add_personas_finish (MatchAllTests* self, GAsyncResult* _res_);
static void _match_all_tests_try_to_add_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _match_all_tests_add_personas_data_free (gpointer _data);
static gboolean _match_all_tests_add_personas_co (MatchAllTestsAddPersonasData* data);
static void _match_all_tests_do_add_persona (MatchAllTests* self, const gchar* fn, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _match_all_tests_do_add_persona_finish (MatchAllTests* self, GAsyncResult* _res_);
static void _match_all_tests_add_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _match_all_tests_do_add_persona_data_free (gpointer _data);
static gboolean _match_all_tests_do_add_persona_co (MatchAllTestsDoAddPersonaData* data);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static GValue* _g_value_dup (GValue* self);
static void _match_all_tests_do_add_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void match_all_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static void _match_all_tests_test_match_all_folks_test_case_test_method (gpointer self) {
	match_all_tests_test_match_all (self);
}


MatchAllTests* match_all_tests_construct (GType object_type) {
	MatchAllTests * self = NULL;
	TrackerTestBackend* _tmp0_ = NULL;
	self = (MatchAllTests*) folks_test_case_construct (object_type, "MatchAllTests");
	_tmp0_ = tracker_test_backend_new ();
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	self->priv->_tracker_backend = _tmp0_;
	folks_test_case_add_test ((FolksTestCase*) self, "test potential match all ", _match_all_tests_test_match_all_folks_test_case_test_method, self);
	return self;
}


MatchAllTests* match_all_tests_new (void) {
	return match_all_tests_construct (TYPE_MATCH_ALL_TESTS);
}


static void match_all_tests_real_set_up (FolksTestCase* base) {
	MatchAllTests * self;
	self = (MatchAllTests*) base;
}


static void match_all_tests_real_tear_down (FolksTestCase* base) {
	MatchAllTests * self;
	self = (MatchAllTests*) base;
	tracker_test_backend_tear_down (self->priv->_tracker_backend);
}


static gboolean _lambda0_ (MatchAllTests* self) {
	gboolean result = FALSE;
	g_main_loop_quit (self->priv->_main_loop);
	g_assert_not_reached ();
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


void match_all_tests_test_match_all (MatchAllTests* self) {
	GMainLoop* _tmp0_ = NULL;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->_main_loop);
	self->priv->_main_loop = _tmp0_;
	_match_all_tests_test_match_all_async (self, NULL, NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda0__gsource_func, g_object_ref (self), g_object_unref);
	g_main_loop_run (self->priv->_main_loop);
	g_assert (self->priv->_matches_1 == 1);
	_tmp1_ = g_list_length (self->priv->_matches_all);
	g_assert (_tmp1_ == 4);
	{
		GList* size_collection;
		GList* size_it;
		size_collection = self->priv->_matches_all;
		for (size_it = size_collection; size_it != NULL; size_it = size_it->next) {
			gint size;
			size = GPOINTER_TO_INT (size_it->data);
			{
				g_assert (size == 1);
			}
		}
	}
}


static void _match_all_tests_test_match_all_async_data_free (gpointer _data) {
	MatchAllTestsTestMatchAllAsyncData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (MatchAllTestsTestMatchAllAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _match_all_tests_test_match_all_async (MatchAllTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MatchAllTestsTestMatchAllAsyncData* _data_;
	_data_ = g_slice_new0 (MatchAllTestsTestMatchAllAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _match_all_tests_test_match_all_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _match_all_tests_test_match_all_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_match_all_tests_test_match_all_async_co (_data_);
}


static void _match_all_tests_test_match_all_finish (MatchAllTests* self, GAsyncResult* _res_) {
	MatchAllTestsTestMatchAllAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _match_all_tests_test_match_all_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	MatchAllTestsTestMatchAllAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_match_all_tests_test_match_all_async_co (data);
}


static void __match_all_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_match_all_tests_individuals_changed_cb (self, added, removed, message, actor, reason);
}


static void __match_all_tests_notify_pstore_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_match_all_tests_notify_pstore_cb (self, _sender, pspec);
}


static gboolean _match_all_tests_test_match_all_async_co (MatchAllTestsTestMatchAllAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_backend_store_dup ();
	data->store = data->_tmp0_;
	data->_state_ = 1;
	folks_backend_store_prepare (data->store, _match_all_tests_test_match_all_async_ready, data);
	return FALSE;
	_state_1:
	folks_backend_store_prepare_finish (data->store, data->_res_);
	if (data->self->priv->_aggregator == NULL) {
		data->_tmp1_ = NULL;
		data->_tmp1_ = folks_individual_aggregator_new ();
		_g_object_unref0 (data->self->priv->_aggregator);
		data->self->priv->_aggregator = data->_tmp1_;
		g_signal_connect_object (data->self->priv->_aggregator, "individuals-changed", (GCallback) __match_all_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed, data->self, 0);
	}
	data->_state_ = 2;
	folks_individual_aggregator_prepare (data->self->priv->_aggregator, _match_all_tests_test_match_all_async_ready, data);
	return FALSE;
	_state_2:
	folks_individual_aggregator_prepare_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	_g_object_unref0 (data->self->priv->_pstore);
	data->self->priv->_pstore = NULL;
	{
		data->_tmp2_ = NULL;
		data->_tmp2_ = folks_backend_store_get_enabled_backends (data->store);
		data->_tmp3_ = NULL;
		data->_tmp3_ = gee_map_get_values (data->_tmp2_);
		data->_tmp4_ = data->_tmp3_;
		data->_tmp5_ = NULL;
		data->_tmp5_ = gee_iterable_iterator ((GeeIterable*) data->_tmp4_);
		data->_tmp6_ = data->_tmp5_;
		_g_object_unref0 (data->_tmp4_);
		data->_backend_it = data->_tmp6_;
		while (TRUE) {
			data->_tmp7_ = gee_iterator_next (data->_backend_it);
			if (!data->_tmp7_) {
				break;
			}
			data->_tmp8_ = NULL;
			data->_tmp8_ = gee_iterator_get (data->_backend_it);
			data->backend = (FolksBackend*) data->_tmp8_;
			data->_tmp9_ = NULL;
			data->_tmp9_ = folks_backend_get_persona_stores (data->backend);
			data->_tmp10_ = NULL;
			data->_tmp10_ = gee_map_get (data->_tmp9_, "tracker");
			_g_object_unref0 (data->self->priv->_pstore);
			data->self->priv->_pstore = TRF_PERSONA_STORE ((FolksPersonaStore*) data->_tmp10_);
			if (data->self->priv->_pstore != NULL) {
				_g_object_unref0 (data->backend);
				break;
			}
			_g_object_unref0 (data->backend);
		}
		_g_object_unref0 (data->_backend_it);
	}
	g_assert (data->self->priv->_pstore != NULL);
	g_signal_connect_object ((GObject*) data->self->priv->_pstore, "notify::is-prepared", (GCallback) __match_all_tests_notify_pstore_cb_g_object_notify, data->self, 0);
	_match_all_tests_try_to_add (data->self, NULL, NULL);
	goto __finally0;
	__catch0_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("match-all.vala:125: Error when calling prepare: %s\n", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally0:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->store);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _match_all_tests_individuals_changed_cb (MatchAllTests* self, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason) {
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gint _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _i_it;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) added);
		_i_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			FolksIndividual* i;
			const gchar* _tmp3_ = NULL;
			_tmp1_ = gee_iterator_next (_i_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_i_it);
			i = (FolksIndividual*) _tmp2_;
			_tmp3_ = folks_name_details_get_full_name ((FolksNameDetails*) i);
			if (g_strcmp0 (_tmp3_, self->priv->_persona_fullname_1) == 0) {
				const gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				_tmp4_ = folks_individual_get_id (i);
				_tmp5_ = g_strdup (_tmp4_);
				_g_free0 (self->priv->_individual_id_1);
				self->priv->_individual_id_1 = _tmp5_;
			} else {
				const gchar* _tmp6_ = NULL;
				_tmp6_ = folks_name_details_get_full_name ((FolksNameDetails*) i);
				if (g_strcmp0 (_tmp6_, self->priv->_persona_fullname_2) == 0) {
					const gchar* _tmp7_ = NULL;
					gchar* _tmp8_;
					_tmp7_ = folks_individual_get_id (i);
					_tmp8_ = g_strdup (_tmp7_);
					_g_free0 (self->priv->_individual_id_2);
					self->priv->_individual_id_2 = _tmp8_;
				} else {
					const gchar* _tmp9_ = NULL;
					_tmp9_ = folks_name_details_get_full_name ((FolksNameDetails*) i);
					if (g_strcmp0 (_tmp9_, self->priv->_persona_fullname_3) == 0) {
						const gchar* _tmp10_ = NULL;
						gchar* _tmp11_;
						_tmp10_ = folks_individual_get_id (i);
						_tmp11_ = g_strdup (_tmp10_);
						_g_free0 (self->priv->_individual_id_3);
						self->priv->_individual_id_3 = _tmp11_;
					} else {
						const gchar* _tmp12_ = NULL;
						_tmp12_ = folks_name_details_get_full_name ((FolksNameDetails*) i);
						if (g_strcmp0 (_tmp12_, self->priv->_persona_fullname_4) == 0) {
							const gchar* _tmp13_ = NULL;
							gchar* _tmp14_;
							_tmp13_ = folks_individual_get_id (i);
							_tmp14_ = g_strdup (_tmp13_);
							_g_free0 (self->priv->_individual_id_4);
							self->priv->_individual_id_4 = _tmp14_;
						}
					}
				}
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	if (g_strcmp0 (self->priv->_individual_id_1, "") != 0) {
		_tmp17_ = g_strcmp0 (self->priv->_individual_id_2, "") != 0;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		_tmp16_ = g_strcmp0 (self->priv->_individual_id_3, "") != 0;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		_tmp15_ = g_strcmp0 (self->priv->_individual_id_4, "") != 0;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		_match_all_tests_try_match_all (self);
	}
	_tmp18_ = gee_collection_get_size ((GeeCollection*) removed);
	g_assert (_tmp18_ == 0);
}


static void _match_all_tests_try_match_all (MatchAllTests* self) {
	GeeMap* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	FolksIndividual* ind1;
	GeeMap* _tmp2_ = NULL;
	GeeMap* matches_1;
	gint _tmp3_;
	GeeMap* _tmp4_ = NULL;
	GeeMap* all_matches;
	g_return_if_fail (self != NULL);
	_tmp0_ = folks_individual_aggregator_get_individuals (self->priv->_aggregator);
	_tmp1_ = gee_map_get (_tmp0_, self->priv->_individual_id_1);
	ind1 = (FolksIndividual*) _tmp1_;
	_tmp2_ = folks_individual_aggregator_get_potential_matches (self->priv->_aggregator, ind1, FOLKS_MATCH_RESULT_MEDIUM);
	matches_1 = _tmp2_;
	_tmp3_ = gee_map_get_size (matches_1);
	self->priv->_matches_1 = _tmp3_;
	_tmp4_ = folks_individual_aggregator_get_all_potential_matches (self->priv->_aggregator, FOLKS_MATCH_RESULT_MEDIUM);
	all_matches = _tmp4_;
	{
		GeeSet* _tmp5_ = NULL;
		GeeSet* _tmp6_;
		GeeIterator* _tmp7_ = NULL;
		GeeIterator* _tmp8_;
		GeeIterator* _i_it;
		_tmp5_ = gee_map_get_keys (all_matches);
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_i_it = _tmp8_;
		while (TRUE) {
			gboolean _tmp9_;
			gpointer _tmp10_ = NULL;
			FolksIndividual* i;
			gboolean _tmp11_;
			gpointer _tmp12_ = NULL;
			GeeMap* matches;
			gint _tmp13_;
			_tmp9_ = gee_iterator_next (_i_it);
			if (!_tmp9_) {
				break;
			}
			_tmp10_ = gee_iterator_get (_i_it);
			i = (FolksIndividual*) _tmp10_;
			_tmp11_ = folks_individual_get_is_user (i);
			if (_tmp11_) {
				_g_object_unref0 (i);
				continue;
			}
			_tmp12_ = gee_map_get (all_matches, i);
			matches = (GeeMap*) _tmp12_;
			_tmp13_ = gee_map_get_size (matches);
			self->priv->_matches_all = g_list_prepend (self->priv->_matches_all, GINT_TO_POINTER (_tmp13_));
			_g_object_unref0 (matches);
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	g_main_loop_quit (self->priv->_main_loop);
	_g_object_unref0 (all_matches);
	_g_object_unref0 (matches_1);
	_g_object_unref0 (ind1);
}


static void _match_all_tests_notify_pstore_cb (MatchAllTests* self, GObject* _pstore, GParamSpec* ps) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (_pstore != NULL);
	g_return_if_fail (ps != NULL);
	_match_all_tests_try_to_add (self, NULL, NULL);
}


static void _match_all_tests_try_to_add_data_free (gpointer _data) {
	MatchAllTestsTryToAddData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (MatchAllTestsTryToAddData, data);
}


static void _match_all_tests_try_to_add (MatchAllTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MatchAllTestsTryToAddData* _data_;
	_data_ = g_slice_new0 (MatchAllTestsTryToAddData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _match_all_tests_try_to_add);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _match_all_tests_try_to_add_data_free);
	_data_->self = _g_object_ref0 (self);
	_match_all_tests_try_to_add_co (_data_);
}


static void _match_all_tests_try_to_add_finish (MatchAllTests* self, GAsyncResult* _res_) {
	MatchAllTestsTryToAddData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _match_all_tests_try_to_add_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	MatchAllTestsTryToAddData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_match_all_tests_try_to_add_co (data);
}


static gboolean _match_all_tests_try_to_add_co (MatchAllTestsTryToAddData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_static_rec_mutex_lock (&data->self->priv->__lock__added_personas);
		data->_tmp1_ = folks_persona_store_get_is_prepared ((FolksPersonaStore*) data->self->priv->_pstore);
		if (data->_tmp1_) {
			data->_tmp0_ = data->self->priv->_added_personas == FALSE;
		} else {
			data->_tmp0_ = FALSE;
		}
		if (data->_tmp0_) {
			data->self->priv->_added_personas = TRUE;
			data->_state_ = 1;
			_match_all_tests_add_personas (data->self, _match_all_tests_try_to_add_ready, data);
			return FALSE;
			_state_1:
			_match_all_tests_add_personas_finish (data->self, data->_res_);
		}
		__finally1:
		g_static_rec_mutex_unlock (&data->self->priv->__lock__added_personas);
		if (data->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _match_all_tests_add_personas_data_free (gpointer _data) {
	MatchAllTestsAddPersonasData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (MatchAllTestsAddPersonasData, data);
}


static void _match_all_tests_add_personas (MatchAllTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MatchAllTestsAddPersonasData* _data_;
	_data_ = g_slice_new0 (MatchAllTestsAddPersonasData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _match_all_tests_add_personas);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _match_all_tests_add_personas_data_free);
	_data_->self = _g_object_ref0 (self);
	_match_all_tests_add_personas_co (_data_);
}


static void _match_all_tests_add_personas_finish (MatchAllTests* self, GAsyncResult* _res_) {
	MatchAllTestsAddPersonasData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _match_all_tests_add_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	MatchAllTestsAddPersonasData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_match_all_tests_add_personas_co (data);
}


static gboolean _match_all_tests_add_personas_co (MatchAllTestsAddPersonasData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	_match_all_tests_do_add_persona (data->self, data->self->priv->_persona_fullname_1, _match_all_tests_add_personas_ready, data);
	return FALSE;
	_state_1:
	_match_all_tests_do_add_persona_finish (data->self, data->_res_);
	data->_state_ = 2;
	_match_all_tests_do_add_persona (data->self, data->self->priv->_persona_fullname_2, _match_all_tests_add_personas_ready, data);
	return FALSE;
	_state_2:
	_match_all_tests_do_add_persona_finish (data->self, data->_res_);
	data->_state_ = 3;
	_match_all_tests_do_add_persona (data->self, data->self->priv->_persona_fullname_3, _match_all_tests_add_personas_ready, data);
	return FALSE;
	_state_3:
	_match_all_tests_do_add_persona_finish (data->self, data->_res_);
	data->_state_ = 4;
	_match_all_tests_do_add_persona (data->self, data->self->priv->_persona_fullname_4, _match_all_tests_add_personas_ready, data);
	return FALSE;
	_state_4:
	_match_all_tests_do_add_persona_finish (data->self, data->_res_);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _match_all_tests_do_add_persona_data_free (gpointer _data) {
	MatchAllTestsDoAddPersonaData* data;
	data = _data;
	_g_free0 (data->fn);
	_g_object_unref0 (data->self);
	g_slice_free (MatchAllTestsDoAddPersonaData, data);
}


static void _match_all_tests_do_add_persona (MatchAllTests* self, const gchar* fn, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MatchAllTestsDoAddPersonaData* _data_;
	_data_ = g_slice_new0 (MatchAllTestsDoAddPersonaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _match_all_tests_do_add_persona);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _match_all_tests_do_add_persona_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->fn = g_strdup (fn);
	_match_all_tests_do_add_persona_co (_data_);
}


static void _match_all_tests_do_add_persona_finish (MatchAllTests* self, GAsyncResult* _res_) {
	MatchAllTestsDoAddPersonaData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static void _match_all_tests_do_add_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	MatchAllTestsDoAddPersonaData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_match_all_tests_do_add_persona_co (data);
}


static gboolean _match_all_tests_do_add_persona_co (MatchAllTestsDoAddPersonaData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, __vala_GValue_free0_);
	data->details = data->_tmp0_;
	memset (&data->_tmp1_, 0, sizeof (GValue));
	g_value_init (&data->_tmp1_, G_TYPE_STRING);
	memset (&data->_tmp2_, 0, sizeof (GValue));
	data->_tmp2_ = data->_tmp1_;
	data->_tmp3_ = data->_tmp2_;
	data->_tmp4_ = __g_value_dup0 (&data->_tmp3_);
	__vala_GValue_free0 (data->val);
	data->val = data->_tmp4_;
	G_IS_VALUE (&data->_tmp3_) ? (g_value_unset (&data->_tmp3_), NULL) : NULL;
	g_value_set_string (data->val, data->fn);
	data->_tmp5_ = NULL;
	data->_tmp5_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_FULL_NAME);
	data->_tmp6_ = g_strdup (data->_tmp5_);
	data->_tmp7_ = data->val;
	data->val = NULL;
	g_hash_table_insert (data->details, data->_tmp6_, data->_tmp7_);
	data->_state_ = 1;
	folks_individual_aggregator_add_persona_from_details (data->self->priv->_aggregator, NULL, (FolksPersonaStore*) data->self->priv->_pstore, data->details, _match_all_tests_do_add_persona_ready, data);
	return FALSE;
	_state_1:
	data->_tmp8_ = NULL;
	data->_tmp8_ = folks_individual_aggregator_add_persona_from_details_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	data->_tmp9_ = data->_tmp8_;
	_g_object_unref0 (data->_tmp9_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			goto __catch2_folks_individual_aggregator_error;
		}
		__vala_GValue_free0 (data->val);
		_g_hash_table_unref0 (data->details);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	goto __finally2;
	__catch2_folks_individual_aggregator_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("match-all.vala:232: [AddPersonaError] add_persona_from_details: %s\n", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally2:
	if (data->_inner_error_ != NULL) {
		__vala_GValue_free0 (data->val);
		_g_hash_table_unref0 (data->details);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	__vala_GValue_free0 (data->val);
	_g_hash_table_unref0 (data->details);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void match_all_tests_class_init (MatchAllTestsClass * klass) {
	match_all_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MatchAllTestsPrivate));
	FOLKS_TEST_CASE_CLASS (klass)->set_up = match_all_tests_real_set_up;
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = match_all_tests_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = match_all_tests_finalize;
}


static void match_all_tests_instance_init (MatchAllTests * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	self->priv = MATCH_ALL_TESTS_GET_PRIVATE (self);
	self->priv->_aggregator = NULL;
	_tmp0_ = g_strdup ("Bernie Innocenti");
	self->priv->_persona_fullname_1 = _tmp0_;
	_tmp1_ = g_strdup ("Bernardo H. Innocenti");
	self->priv->_persona_fullname_2 = _tmp1_;
	_tmp2_ = g_strdup ("Travis R.");
	self->priv->_persona_fullname_3 = _tmp2_;
	_tmp3_ = g_strdup ("Travis Reitter");
	self->priv->_persona_fullname_4 = _tmp3_;
	g_static_rec_mutex_init (&self->priv->__lock__added_personas);
	self->priv->_added_personas = FALSE;
	_tmp4_ = g_strdup ("");
	self->priv->_individual_id_1 = _tmp4_;
	_tmp5_ = g_strdup ("");
	self->priv->_individual_id_2 = _tmp5_;
	_tmp6_ = g_strdup ("");
	self->priv->_individual_id_3 = _tmp6_;
	_tmp7_ = g_strdup ("");
	self->priv->_individual_id_4 = _tmp7_;
	self->priv->_matches_all = NULL;
	self->priv->_matches_1 = 0;
}


static void match_all_tests_finalize (GObject* obj) {
	MatchAllTests * self;
	self = MATCH_ALL_TESTS (obj);
	_g_main_loop_unref0 (self->priv->_main_loop);
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	_g_object_unref0 (self->priv->_aggregator);
	_g_free0 (self->priv->_persona_fullname_1);
	_g_free0 (self->priv->_persona_fullname_2);
	_g_free0 (self->priv->_persona_fullname_3);
	_g_free0 (self->priv->_persona_fullname_4);
	g_static_rec_mutex_free (&self->priv->__lock__added_personas);
	_g_free0 (self->priv->_individual_id_1);
	_g_free0 (self->priv->_individual_id_2);
	_g_free0 (self->priv->_individual_id_3);
	_g_free0 (self->priv->_individual_id_4);
	_g_object_unref0 (self->priv->_pstore);
	_g_list_free0 (self->priv->_matches_all);
	G_OBJECT_CLASS (match_all_tests_parent_class)->finalize (obj);
}


GType match_all_tests_get_type (void) {
	static volatile gsize match_all_tests_type_id__volatile = 0;
	if (g_once_init_enter (&match_all_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MatchAllTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) match_all_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MatchAllTests), 0, (GInstanceInitFunc) match_all_tests_instance_init, NULL };
		GType match_all_tests_type_id;
		match_all_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "MatchAllTests", &g_define_type_info, 0);
		g_once_init_leave (&match_all_tests_type_id__volatile, match_all_tests_type_id);
	}
	return match_all_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GTestSuite* _tmp0_ = NULL;
	GTestSuite* root;
	MatchAllTests* _tmp1_ = NULL;
	MatchAllTests* _tmp2_;
	GTestSuite* _tmp3_ = NULL;
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_test_get_root ();
	root = _tmp0_;
	_tmp1_ = match_all_tests_new ();
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_test_case_get_suite ((FolksTestCase*) _tmp2_);
	g_test_suite_add_suite (root, _tmp3_);
	_g_object_unref0 (_tmp2_);
	g_test_run ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



