/* role-details.c generated by valac 0.12.0, the Vala compiler
 * generated from role-details.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>


#define FOLKS_TYPE_ROLE (folks_role_get_type ())
#define FOLKS_ROLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ROLE, FolksRole))
#define FOLKS_ROLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_ROLE, FolksRoleClass))
#define FOLKS_IS_ROLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ROLE))
#define FOLKS_IS_ROLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_ROLE))
#define FOLKS_ROLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_ROLE, FolksRoleClass))

typedef struct _FolksRole FolksRole;
typedef struct _FolksRoleClass FolksRoleClass;
typedef struct _FolksRolePrivate FolksRolePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define FOLKS_TYPE_ROLE_DETAILS (folks_role_details_get_type ())
#define FOLKS_ROLE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ROLE_DETAILS, FolksRoleDetails))
#define FOLKS_IS_ROLE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ROLE_DETAILS))
#define FOLKS_ROLE_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_ROLE_DETAILS, FolksRoleDetailsIface))

typedef struct _FolksRoleDetails FolksRoleDetails;
typedef struct _FolksRoleDetailsIface FolksRoleDetailsIface;

struct _FolksRole {
	GObject parent_instance;
	FolksRolePrivate * priv;
};

struct _FolksRoleClass {
	GObjectClass parent_class;
};

struct _FolksRolePrivate {
	gchar* _organisation_name;
	gchar* _title;
	gchar* _uid;
};

struct _FolksRoleDetailsIface {
	GTypeInterface parent_iface;
	GeeSet* (*get_roles) (FolksRoleDetails* self);
	void (*set_roles) (FolksRoleDetails* self, GeeSet* value);
};


static gpointer folks_role_parent_class = NULL;

GType folks_role_get_type (void) G_GNUC_CONST;
#define FOLKS_ROLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_ROLE, FolksRolePrivate))
enum  {
	FOLKS_ROLE_DUMMY_PROPERTY,
	FOLKS_ROLE_ORGANISATION_NAME,
	FOLKS_ROLE_TITLE,
	FOLKS_ROLE_UID
};
FolksRole* folks_role_new (const gchar* title, const gchar* organisation_name, const gchar* uid);
FolksRole* folks_role_construct (GType object_type, const gchar* title, const gchar* organisation_name, const gchar* uid);
gboolean folks_role_equal (FolksRole* a, FolksRole* b);
const gchar* folks_role_get_title (FolksRole* self);
const gchar* folks_role_get_organisation_name (FolksRole* self);
guint folks_role_hash (FolksRole* r);
gchar* folks_role_to_string (FolksRole* self);
void folks_role_set_organisation_name (FolksRole* self, const gchar* value);
void folks_role_set_title (FolksRole* self, const gchar* value);
const gchar* folks_role_get_uid (FolksRole* self);
void folks_role_set_uid (FolksRole* self, const gchar* value);
static void folks_role_finalize (GObject* obj);
static void _vala_folks_role_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_role_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType folks_role_details_get_type (void) G_GNUC_CONST;
GeeSet* folks_role_details_get_roles (FolksRoleDetails* self);
void folks_role_details_set_roles (FolksRoleDetails* self, GeeSet* value);


/**
   * Default constructor.
   *
   * @param title title of the position
   * @param organisation_name organisation where the role is hold
   * @param uid a Unique ID associated to this Role
   * @return a new Role
   *
   * @since 0.4.0
   */
FolksRole* folks_role_construct (GType object_type, const gchar* title, const gchar* organisation_name, const gchar* uid) {
	FolksRole * self = NULL;
	if (title == NULL) {
		title = "";
	}
	if (organisation_name == NULL) {
		organisation_name = "";
	}
	if (uid == NULL) {
		uid = "";
	}
	self = (FolksRole*) g_object_new (object_type, "uid", uid, "title", title, "organisation-name", organisation_name, NULL);
	return self;
}


FolksRole* folks_role_new (const gchar* title, const gchar* organisation_name, const gchar* uid) {
	return folks_role_construct (FOLKS_TYPE_ROLE, title, organisation_name, uid);
}


/**
   * Compare if 2 roles are equal
   */
gboolean folks_role_equal (FolksRole* a, FolksRole* b) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	if (g_strcmp0 (a->priv->_title, b->priv->_title) == 0) {
		_tmp0_ = g_strcmp0 (a->priv->_organisation_name, b->priv->_organisation_name) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


/**
   * Hash function for the class.
   */
guint folks_role_hash (FolksRole* r) {
	guint result = 0U;
	guint _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (r != NULL, 0U);
	_tmp0_ = g_str_hash (r->priv->_organisation_name);
	_tmp1_ = g_str_hash (r->priv->_title);
	result = _tmp0_ + _tmp1_;
	return result;
}


/**
   * Formatted version of this role.
   *
   * @since 0.4.0
   */
gchar* folks_role_to_string (FolksRole* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* str;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _ ("Title: %s , Organisation: %s");
	_tmp1_ = g_strdup (_tmp0_);
	str = _tmp1_;
	_tmp2_ = g_strdup_printf (str, self->priv->_title, self->priv->_organisation_name);
	result = _tmp2_;
	_g_free0 (str);
	return result;
}


const gchar* folks_role_get_organisation_name (FolksRole* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_organisation_name;
	return result;
}


void folks_role_set_organisation_name (FolksRole* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_organisation_name);
	self->priv->_organisation_name = _tmp0_;
	g_object_notify ((GObject *) self, "organisation-name");
}


const gchar* folks_role_get_title (FolksRole* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_title;
	return result;
}


void folks_role_set_title (FolksRole* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp0_;
	g_object_notify ((GObject *) self, "title");
}


const gchar* folks_role_get_uid (FolksRole* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_uid;
	return result;
}


void folks_role_set_uid (FolksRole* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_uid);
	self->priv->_uid = _tmp0_;
	g_object_notify ((GObject *) self, "uid");
}


static void folks_role_class_init (FolksRoleClass * klass) {
	folks_role_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksRolePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_role_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_role_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_role_finalize;
	/**
	   * The name of the organisation in which the role is held.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ROLE_ORGANISATION_NAME, g_param_spec_string ("organisation-name", "organisation-name", "organisation-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The name of the position held.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ROLE_TITLE, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The UID that distinguishes this role.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ROLE_UID, g_param_spec_string ("uid", "uid", "uid", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void folks_role_instance_init (FolksRole * self) {
	self->priv = FOLKS_ROLE_GET_PRIVATE (self);
}


static void folks_role_finalize (GObject* obj) {
	FolksRole * self;
	self = FOLKS_ROLE (obj);
	_g_free0 (self->priv->_organisation_name);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_uid);
	G_OBJECT_CLASS (folks_role_parent_class)->finalize (obj);
}


/**
 * This interface represents the role a {@link Persona} and {@link Individual}
 * have in a given Organisation.
 *
 * @since 0.4.0
 */
GType folks_role_get_type (void) {
	static volatile gsize folks_role_type_id__volatile = 0;
	if (g_once_init_enter (&folks_role_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksRoleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_role_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksRole), 0, (GInstanceInitFunc) folks_role_instance_init, NULL };
		GType folks_role_type_id;
		folks_role_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksRole", &g_define_type_info, 0);
		g_once_init_leave (&folks_role_type_id__volatile, folks_role_type_id);
	}
	return folks_role_type_id__volatile;
}


static void _vala_folks_role_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksRole * self;
	self = FOLKS_ROLE (object);
	switch (property_id) {
		case FOLKS_ROLE_ORGANISATION_NAME:
		g_value_set_string (value, folks_role_get_organisation_name (self));
		break;
		case FOLKS_ROLE_TITLE:
		g_value_set_string (value, folks_role_get_title (self));
		break;
		case FOLKS_ROLE_UID:
		g_value_set_string (value, folks_role_get_uid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_role_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksRole * self;
	self = FOLKS_ROLE (object);
	switch (property_id) {
		case FOLKS_ROLE_ORGANISATION_NAME:
		folks_role_set_organisation_name (self, g_value_get_string (value));
		break;
		case FOLKS_ROLE_TITLE:
		folks_role_set_title (self, g_value_get_string (value));
		break;
		case FOLKS_ROLE_UID:
		folks_role_set_uid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GeeSet* folks_role_details_get_roles (FolksRoleDetails* self) {
	return FOLKS_ROLE_DETAILS_GET_INTERFACE (self)->get_roles (self);
}


void folks_role_details_set_roles (FolksRoleDetails* self, GeeSet* value) {
	FOLKS_ROLE_DETAILS_GET_INTERFACE (self)->set_roles (self, value);
}


static void folks_role_details_base_init (FolksRoleDetailsIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * The roles of the contact.
		   *
		   * @since 0.5.1
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("roles", "roles", "roles", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


/**
 * This interfaces represents the list of roles a {@link Persona} and
 * {@link Individual} might have.
 *
 * @since 0.4.0
 */
GType folks_role_details_get_type (void) {
	static volatile gsize folks_role_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_role_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksRoleDetailsIface), (GBaseInitFunc) folks_role_details_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType folks_role_details_type_id;
		folks_role_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksRoleDetails", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (folks_role_details_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&folks_role_details_type_id__volatile, folks_role_details_type_id);
	}
	return folks_role_details_type_id__volatile;
}



