/* persona-store.c generated by valac 0.11.2.25-30b2-dirty, the Vala compiler
 * generated from persona-store.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define FOLKS_TYPE_PERSONA_STORE_TRUST (folks_persona_store_trust_get_type ())

#define FOLKS_TYPE_PERSONA_STORE (folks_persona_store_get_type ())
#define FOLKS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore))
#define FOLKS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))
#define FOLKS_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))

typedef struct _FolksPersonaStore FolksPersonaStore;
typedef struct _FolksPersonaStoreClass FolksPersonaStoreClass;
typedef struct _FolksPersonaStorePrivate FolksPersonaStorePrivate;

#define FOLKS_TYPE_PERSONA (folks_persona_get_type ())
#define FOLKS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA, FolksPersona))
#define FOLKS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA, FolksPersonaClass))
#define FOLKS_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA))
#define FOLKS_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA))
#define FOLKS_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA, FolksPersonaClass))

typedef struct _FolksPersona FolksPersona;
typedef struct _FolksPersonaClass FolksPersonaClass;

#define FOLKS_TYPE_MAYBE_BOOL (folks_maybe_bool_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksPersonaStoreFlushData FolksPersonaStoreFlushData;

#define FOLKS_GROUPABLE_TYPE_CHANGE_REASON (folks_groupable_change_reason_get_type ())

typedef enum  {
	FOLKS_PERSONA_STORE_TRUST_NONE,
	FOLKS_PERSONA_STORE_TRUST_PARTIAL,
	FOLKS_PERSONA_STORE_TRUST_FULL
} FolksPersonaStoreTrust;

/**
 * Errors from {@link PersonaStore}s.
 */
typedef enum  {
	FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT,
	FOLKS_PERSONA_STORE_ERROR_CREATE_FAILED,
	FOLKS_PERSONA_STORE_ERROR_UNSUPPORTED_ON_USER,
	FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE
} FolksPersonaStoreError;
#define FOLKS_PERSONA_STORE_ERROR folks_persona_store_error_quark ()
typedef enum  {
	FOLKS_MAYBE_BOOL_UNSET = 0,
	FOLKS_MAYBE_BOOL_FALSE = 1,
	FOLKS_MAYBE_BOOL_TRUE = 2
} FolksMaybeBool;

struct _FolksPersonaStore {
	GObject parent_instance;
	FolksPersonaStorePrivate * priv;
};

struct _FolksPersonaStoreClass {
	GObjectClass parent_class;
	void (*prepare) (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*prepare_finish) (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
	void (*flush) (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*flush_finish) (FolksPersonaStore* self, GAsyncResult* _res_);
	void (*add_persona_from_details) (FolksPersonaStore* self, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
	FolksPersona* (*add_persona_from_details_finish) (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
	void (*remove_persona) (FolksPersonaStore* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_persona_finish) (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
	const gchar* (*get_type_id) (FolksPersonaStore* self);
	GHashTable* (*get_personas) (FolksPersonaStore* self);
	FolksMaybeBool (*get_can_add_personas) (FolksPersonaStore* self);
	FolksMaybeBool (*get_can_alias_personas) (FolksPersonaStore* self);
	FolksMaybeBool (*get_can_group_personas) (FolksPersonaStore* self);
	FolksMaybeBool (*get_can_remove_personas) (FolksPersonaStore* self);
	gboolean (*get_is_prepared) (FolksPersonaStore* self);
};

struct _FolksPersonaStorePrivate {
	gchar* _display_name;
	gchar* _id;
	gboolean _is_writeable;
	FolksPersonaStoreTrust _trust_level;
};

struct _FolksPersonaStoreFlushData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksPersonaStore* self;
};

typedef enum  {
	FOLKS_GROUPABLE_CHANGE_REASON_NONE = 0,
	FOLKS_GROUPABLE_CHANGE_REASON_OFFLINE = 1,
	FOLKS_GROUPABLE_CHANGE_REASON_KICKED = 2,
	FOLKS_GROUPABLE_CHANGE_REASON_BUSY = 3,
	FOLKS_GROUPABLE_CHANGE_REASON_INVITED = 4,
	FOLKS_GROUPABLE_CHANGE_REASON_BANNED = 5,
	FOLKS_GROUPABLE_CHANGE_REASON_ERROR = 6,
	FOLKS_GROUPABLE_CHANGE_REASON_INVALID_MEMBER = 7,
	FOLKS_GROUPABLE_CHANGE_REASON_NO_ANSWER = 8,
	FOLKS_GROUPABLE_CHANGE_REASON_RENAMED = 9,
	FOLKS_GROUPABLE_CHANGE_REASON_PERMISSION_DENIED = 10,
	FOLKS_GROUPABLE_CHANGE_REASON_SEPARATED = 11
} FolksGroupableChangeReason;


static gpointer folks_persona_store_parent_class = NULL;

GType folks_persona_store_trust_get_type (void) G_GNUC_CONST;
GQuark folks_persona_store_error_quark (void);
GType folks_persona_store_get_type (void) G_GNUC_CONST;
GType folks_persona_get_type (void) G_GNUC_CONST;
GType folks_maybe_bool_get_type (void) G_GNUC_CONST;
#define FOLKS_PERSONA_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStorePrivate))
enum  {
	FOLKS_PERSONA_STORE_DUMMY_PROPERTY,
	FOLKS_PERSONA_STORE_TYPE_ID,
	FOLKS_PERSONA_STORE_DISPLAY_NAME,
	FOLKS_PERSONA_STORE_ID,
	FOLKS_PERSONA_STORE_PERSONAS,
	FOLKS_PERSONA_STORE_CAN_ADD_PERSONAS,
	FOLKS_PERSONA_STORE_CAN_ALIAS_PERSONAS,
	FOLKS_PERSONA_STORE_CAN_GROUP_PERSONAS,
	FOLKS_PERSONA_STORE_CAN_REMOVE_PERSONAS,
	FOLKS_PERSONA_STORE_IS_PREPARED,
	FOLKS_PERSONA_STORE_IS_WRITEABLE,
	FOLKS_PERSONA_STORE_TRUST_LEVEL
};
void folks_persona_store_prepare (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_persona_store_prepare_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
static void folks_persona_store_real_flush_data_free (gpointer _data);
static void folks_persona_store_real_flush (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void folks_persona_store_flush_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void folks_persona_store_flush (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_persona_store_flush_finish (FolksPersonaStore* self, GAsyncResult* _res_);
static gboolean folks_persona_store_real_flush_co (FolksPersonaStoreFlushData* data);
void folks_persona_store_add_persona_from_details (FolksPersonaStore* self, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
FolksPersona* folks_persona_store_add_persona_from_details_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
void folks_persona_store_remove_persona (FolksPersonaStore* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_persona_store_remove_persona_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
FolksPersonaStore* folks_persona_store_construct (GType object_type);
const gchar* folks_persona_store_get_type_id (FolksPersonaStore* self);
const gchar* folks_persona_store_get_display_name (FolksPersonaStore* self);
static void folks_persona_store_set_display_name (FolksPersonaStore* self, const gchar* value);
const gchar* folks_persona_store_get_id (FolksPersonaStore* self);
static void folks_persona_store_set_id (FolksPersonaStore* self, const gchar* value);
GHashTable* folks_persona_store_get_personas (FolksPersonaStore* self);
FolksMaybeBool folks_persona_store_get_can_add_personas (FolksPersonaStore* self);
FolksMaybeBool folks_persona_store_get_can_alias_personas (FolksPersonaStore* self);
FolksMaybeBool folks_persona_store_get_can_group_personas (FolksPersonaStore* self);
FolksMaybeBool folks_persona_store_get_can_remove_personas (FolksPersonaStore* self);
gboolean folks_persona_store_get_is_prepared (FolksPersonaStore* self);
gboolean folks_persona_store_get_is_writeable (FolksPersonaStore* self);
void folks_persona_store_set_is_writeable (FolksPersonaStore* self, gboolean value);
FolksPersonaStoreTrust folks_persona_store_get_trust_level (FolksPersonaStore* self);
void folks_persona_store_set_trust_level (FolksPersonaStore* self, FolksPersonaStoreTrust value);
GType folks_groupable_change_reason_get_type (void) G_GNUC_CONST;
static void g_cclosure_user_marshal_VOID__POINTER_POINTER_STRING_OBJECT_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void folks_persona_store_finalize (GObject* obj);
static void _vala_folks_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
 * Trust level for a {@link PersonaStore}'s {@link Persona}s for linking
 * purposes.
 *
 * @since 0.1.13
 */
GType folks_persona_store_trust_get_type (void) {
	static volatile gsize folks_persona_store_trust_type_id__volatile = 0;
	if (g_once_init_enter (&folks_persona_store_trust_type_id__volatile)) {
		static const GEnumValue values[] = {{FOLKS_PERSONA_STORE_TRUST_NONE, "FOLKS_PERSONA_STORE_TRUST_NONE", "none"}, {FOLKS_PERSONA_STORE_TRUST_PARTIAL, "FOLKS_PERSONA_STORE_TRUST_PARTIAL", "partial"}, {FOLKS_PERSONA_STORE_TRUST_FULL, "FOLKS_PERSONA_STORE_TRUST_FULL", "full"}, {0, NULL, NULL}};
		GType folks_persona_store_trust_type_id;
		folks_persona_store_trust_type_id = g_enum_register_static ("FolksPersonaStoreTrust", values);
		g_once_init_leave (&folks_persona_store_trust_type_id__volatile, folks_persona_store_trust_type_id);
	}
	return folks_persona_store_trust_type_id__volatile;
}


GQuark folks_persona_store_error_quark (void) {
	return g_quark_from_static_string ("folks_persona_store_error-quark");
}


void folks_persona_store_prepare (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_PERSONA_STORE_GET_CLASS (self)->prepare (self, _callback_, _user_data_);
}


void folks_persona_store_prepare_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error) {
	FOLKS_PERSONA_STORE_GET_CLASS (self)->prepare_finish (self, _res_, error);
}


static void folks_persona_store_real_flush_data_free (gpointer _data) {
	FolksPersonaStoreFlushData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (FolksPersonaStoreFlushData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_persona_store_real_flush (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksPersonaStoreFlushData* _data_;
	_data_ = g_slice_new0 (FolksPersonaStoreFlushData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_persona_store_real_flush);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_persona_store_real_flush_data_free);
	_data_->self = _g_object_ref0 (self);
	folks_persona_store_real_flush_co (_data_);
}


static void folks_persona_store_real_flush_finish (FolksPersonaStore* self, GAsyncResult* _res_) {
	FolksPersonaStoreFlushData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void folks_persona_store_flush_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksPersonaStoreFlushData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	folks_persona_store_real_flush_co (data);
}


/**
   * Flush any pending changes to the PersonaStore's backing store.
   *
   * PersonaStores may (transparently) implement caching or I/O queueing which
   * means that changes to their {@link Persona}s may not be immediately written
   * to the PersonaStore's backing store. Calling this function will force all
   * pending changes to be flushed to the backing store.
   *
   * This must not be called before {@link PersonaStore.prepare}.
   *
   * @since 0.1.17
   */
static gboolean folks_persona_store_real_flush_co (FolksPersonaStoreFlushData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


void folks_persona_store_flush (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_PERSONA_STORE_GET_CLASS (self)->flush (self, _callback_, _user_data_);
}


void folks_persona_store_flush_finish (FolksPersonaStore* self, GAsyncResult* _res_) {
	FOLKS_PERSONA_STORE_GET_CLASS (self)->flush_finish (self, _res_);
}


void folks_persona_store_add_persona_from_details (FolksPersonaStore* self, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_PERSONA_STORE_GET_CLASS (self)->add_persona_from_details (self, details, _callback_, _user_data_);
}


FolksPersona* folks_persona_store_add_persona_from_details_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error) {
	return FOLKS_PERSONA_STORE_GET_CLASS (self)->add_persona_from_details_finish (self, _res_, error);
}


void folks_persona_store_remove_persona (FolksPersonaStore* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_PERSONA_STORE_GET_CLASS (self)->remove_persona (self, persona, _callback_, _user_data_);
}


void folks_persona_store_remove_persona_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error) {
	FOLKS_PERSONA_STORE_GET_CLASS (self)->remove_persona_finish (self, _res_, error);
}


FolksPersonaStore* folks_persona_store_construct (GType object_type) {
	FolksPersonaStore * self = NULL;
	self = (FolksPersonaStore*) g_object_new (object_type, NULL);
	return self;
}


const gchar* folks_persona_store_get_type_id (FolksPersonaStore* self) {
	return FOLKS_PERSONA_STORE_GET_CLASS (self)->get_type_id (self);
}


const gchar* folks_persona_store_get_display_name (FolksPersonaStore* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_display_name;
	return result;
}


static void folks_persona_store_set_display_name (FolksPersonaStore* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_display_name);
	self->priv->_display_name = _tmp1_;
	g_object_notify ((GObject *) self, "display-name");
}


const gchar* folks_persona_store_get_id (FolksPersonaStore* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_id;
	return result;
}


static void folks_persona_store_set_id (FolksPersonaStore* self, const gchar* value) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp1_;
	g_object_notify ((GObject *) self, "id");
}


GHashTable* folks_persona_store_get_personas (FolksPersonaStore* self) {
	return FOLKS_PERSONA_STORE_GET_CLASS (self)->get_personas (self);
}


FolksMaybeBool folks_persona_store_get_can_add_personas (FolksPersonaStore* self) {
	return FOLKS_PERSONA_STORE_GET_CLASS (self)->get_can_add_personas (self);
}


FolksMaybeBool folks_persona_store_get_can_alias_personas (FolksPersonaStore* self) {
	return FOLKS_PERSONA_STORE_GET_CLASS (self)->get_can_alias_personas (self);
}


FolksMaybeBool folks_persona_store_get_can_group_personas (FolksPersonaStore* self) {
	return FOLKS_PERSONA_STORE_GET_CLASS (self)->get_can_group_personas (self);
}


FolksMaybeBool folks_persona_store_get_can_remove_personas (FolksPersonaStore* self) {
	return FOLKS_PERSONA_STORE_GET_CLASS (self)->get_can_remove_personas (self);
}


gboolean folks_persona_store_get_is_prepared (FolksPersonaStore* self) {
	return FOLKS_PERSONA_STORE_GET_CLASS (self)->get_is_prepared (self);
}


gboolean folks_persona_store_get_is_writeable (FolksPersonaStore* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_writeable;
	return result;
}


void folks_persona_store_set_is_writeable (FolksPersonaStore* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_writeable = value;
	g_object_notify ((GObject *) self, "is-writeable");
}


FolksPersonaStoreTrust folks_persona_store_get_trust_level (FolksPersonaStore* self) {
	FolksPersonaStoreTrust result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_trust_level;
	return result;
}


void folks_persona_store_set_trust_level (FolksPersonaStore* self, FolksPersonaStoreTrust value) {
	g_return_if_fail (self != NULL);
	self->priv->_trust_level = value;
	g_object_notify ((GObject *) self, "trust-level");
}


static void g_cclosure_user_marshal_VOID__POINTER_POINTER_STRING_OBJECT_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_POINTER_STRING_OBJECT_ENUM) (gpointer data1, gpointer arg_1, gpointer arg_2, const char* arg_3, gpointer arg_4, gint arg_5, gpointer data2);
	register GMarshalFunc_VOID__POINTER_POINTER_STRING_OBJECT_ENUM callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_POINTER_STRING_OBJECT_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_pointer (param_values + 2), g_value_get_string (param_values + 3), g_value_get_object (param_values + 4), g_value_get_enum (param_values + 5), data2);
}


static void folks_persona_store_class_init (FolksPersonaStoreClass * klass) {
	folks_persona_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksPersonaStorePrivate));
	FOLKS_PERSONA_STORE_CLASS (klass)->flush = folks_persona_store_real_flush;
	FOLKS_PERSONA_STORE_CLASS (klass)->flush_finish = folks_persona_store_real_flush_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_persona_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_persona_store_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_persona_store_finalize;
	/**
	   * The type of PersonaStore this is.
	   *
	   * This is the same for all PersonaStores provided by a given {@link Backend}.
	   *
	   * This is guaranteed to always be available; even before
	   * {@link PersonaStore.prepare} is called.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_TYPE_ID, g_param_spec_string ("type-id", "type-id", "type-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * The human-readable, service-specific name used to represent the
	   * PersonaStore to the user.
	   *
	   * For example: `foo@@xmpp.example.org`.
	   *
	   * This should be used whenever the user needs to be presented with a
	   * familiar, service-specific name. For instance, in a prompt for the user to
	   * select a specific IM account from which to initiate a chat.
	   *
	   * This is not guaranteed to be unique even within this PersonaStore's
	   * {@link Backend}.
	   *
	   * @since 0.1.13
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The instance identifier for this PersonaStore.
	   *
	   * Since each {@link Backend} can provide multiple different PersonaStores
	   * for different accounts or servers (for example), they each need an ID
	   * which is unique within the backend.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The {@link Persona}s exposed by this PersonaStore.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_PERSONAS, g_param_spec_boxed ("personas", "personas", "personas", G_TYPE_HASH_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this {@link PersonaStore} can add {@link Persona}s.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_CAN_ADD_PERSONAS, g_param_spec_enum ("can-add-personas", "can-add-personas", "can-add-personas", FOLKS_TYPE_MAYBE_BOOL, FOLKS_MAYBE_BOOL_UNSET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this {@link PersonaStore} can set the alias of {@link Persona}s.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_CAN_ALIAS_PERSONAS, g_param_spec_enum ("can-alias-personas", "can-alias-personas", "can-alias-personas", FOLKS_TYPE_MAYBE_BOOL, FOLKS_MAYBE_BOOL_UNSET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this {@link PersonaStore} can set the groups of {@link Persona}s.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_CAN_GROUP_PERSONAS, g_param_spec_enum ("can-group-personas", "can-group-personas", "can-group-personas", FOLKS_TYPE_MAYBE_BOOL, FOLKS_MAYBE_BOOL_UNSET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this {@link PersonaStore} can remove {@link Persona}s.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_CAN_REMOVE_PERSONAS, g_param_spec_enum ("can-remove-personas", "can-remove-personas", "can-remove-personas", FOLKS_TYPE_MAYBE_BOOL, FOLKS_MAYBE_BOOL_UNSET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether {@link PersonaStore.prepare} has successfully completed for this
	   * store.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether the PersonaStore is writeable.
	   *
	   * Only if a PersonaStore is writeable will changes to its {@link Persona}s'
	   * properties be written out to the relevant backing store.
	   *
	   * PersonaStores must not set this property themselves; it will be set as
	   * appropriate by the {@link IndividualAggregator}.
	   *
	   * @since 0.1.13
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_IS_WRITEABLE, g_param_spec_boolean ("is-writeable", "is-writeable", "is-writeable", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The trust level of the PersonaStore for linking.
	   *
	   * Each {@link PersonaStore} is assigned a trust level by the
	   * IndividualAggregator, designating whether to trust the properties of its
	   * {@link Persona}s for linking to produce {@link Individual}s.
	   *
	   * @see PersonaStoreTrust
	   * @since 0.1.13
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_TRUST_LEVEL, g_param_spec_enum ("trust-level", "trust-level", "trust-level", FOLKS_TYPE_PERSONA_STORE_TRUST, FOLKS_PERSONA_STORE_TRUST_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * Emitted when one or more {@link Persona}s are added to or removed from
	   * the store.
	   *
	   * This will not be emitted until after {@link PersonaStore.prepare} has been
	   * called.
	   *
	   * @param added a list of {@link Persona}s which have been removed
	   * @param removed a list of {@link Persona}s which have been removed
	   * @param message a string message from the backend, if any
	   * @param actor the {@link Persona} who made the change, if known
	   * @param reason the reason for the change
	   */
	g_signal_new ("personas_changed", FOLKS_TYPE_PERSONA_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_POINTER_STRING_OBJECT_ENUM, G_TYPE_NONE, 5, G_TYPE_POINTER, G_TYPE_POINTER, G_TYPE_STRING, FOLKS_TYPE_PERSONA, FOLKS_GROUPABLE_TYPE_CHANGE_REASON);
	/**
	   * Emitted when the backing store for this PersonaStore has been removed.
	   *
	   * At this point, the PersonaStore and all its {@link Persona}s are invalid,
	   * so any client referencing it should unreference it.
	   *
	   * This will not be emitted until after {@link PersonaStore.prepare} has been
	   * called.
	   */
	g_signal_new ("removed", FOLKS_TYPE_PERSONA_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void folks_persona_store_instance_init (FolksPersonaStore * self) {
	self->priv = FOLKS_PERSONA_STORE_GET_PRIVATE (self);
	self->priv->_is_writeable = FALSE;
	self->priv->_trust_level = FOLKS_PERSONA_STORE_TRUST_NONE;
}


static void folks_persona_store_finalize (GObject* obj) {
	FolksPersonaStore * self;
	self = FOLKS_PERSONA_STORE (obj);
	_g_free0 (self->priv->_display_name);
	_g_free0 (self->priv->_id);
	G_OBJECT_CLASS (folks_persona_store_parent_class)->finalize (obj);
}


/**
 * A store for {@link Persona}s.
 *
 * After creating a PersonaStore instance, you must connect to the
 * {@link PersonaStore.personas_changed} signal, //then// call
 * {@link PersonaStore.prepare}, otherwise a race condition may occur between
 * emission of {@link PersonaStore.personas_changed} and your code connecting to
 * it.
 */
GType folks_persona_store_get_type (void) {
	static volatile gsize folks_persona_store_type_id__volatile = 0;
	if (g_once_init_enter (&folks_persona_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksPersonaStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_persona_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksPersonaStore), 0, (GInstanceInitFunc) folks_persona_store_instance_init, NULL };
		GType folks_persona_store_type_id;
		folks_persona_store_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksPersonaStore", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&folks_persona_store_type_id__volatile, folks_persona_store_type_id);
	}
	return folks_persona_store_type_id__volatile;
}


static void _vala_folks_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksPersonaStore * self;
	self = FOLKS_PERSONA_STORE (object);
	switch (property_id) {
		case FOLKS_PERSONA_STORE_DISPLAY_NAME:
		g_value_set_string (value, folks_persona_store_get_display_name (self));
		break;
		case FOLKS_PERSONA_STORE_ID:
		g_value_set_string (value, folks_persona_store_get_id (self));
		break;
		case FOLKS_PERSONA_STORE_IS_WRITEABLE:
		g_value_set_boolean (value, folks_persona_store_get_is_writeable (self));
		break;
		case FOLKS_PERSONA_STORE_TRUST_LEVEL:
		g_value_set_enum (value, folks_persona_store_get_trust_level (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksPersonaStore * self;
	self = FOLKS_PERSONA_STORE (object);
	switch (property_id) {
		case FOLKS_PERSONA_STORE_DISPLAY_NAME:
		folks_persona_store_set_display_name (self, g_value_get_string (value));
		break;
		case FOLKS_PERSONA_STORE_ID:
		folks_persona_store_set_id (self, g_value_get_string (value));
		break;
		case FOLKS_PERSONA_STORE_IS_WRITEABLE:
		folks_persona_store_set_is_writeable (self, g_value_get_boolean (value));
		break;
		case FOLKS_PERSONA_STORE_TRUST_LEVEL:
		folks_persona_store_set_trust_level (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



