/* tpf-persona.c generated by valac 0.11.2.11-bbde6, the Vala compiler
 * generated from tpf-persona.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <telepathy-glib/telepathy-glib.h>


#define TPF_TYPE_PERSONA (tpf_persona_get_type ())
#define TPF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA, TpfPersona))
#define TPF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA, TpfPersonaClass))
#define TPF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA))
#define TPF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA))
#define TPF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA, TpfPersonaClass))

typedef struct _TpfPersona TpfPersona;
typedef struct _TpfPersonaClass TpfPersonaClass;
typedef struct _TpfPersonaPrivate TpfPersonaPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TPF_TYPE_PERSONA_STORE (tpf_persona_store_get_type ())
#define TPF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA_STORE, TpfPersonaStore))
#define TPF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA_STORE, TpfPersonaStoreClass))
#define TPF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA_STORE))
#define TPF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA_STORE))
#define TPF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA_STORE, TpfPersonaStoreClass))

typedef struct _TpfPersonaStore TpfPersonaStore;
typedef struct _TpfPersonaStoreClass TpfPersonaStoreClass;
typedef struct _TpfPersonaChangeGroupData TpfPersonaChangeGroupData;
typedef struct _Block1Data Block1Data;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block3Data Block3Data;

struct _TpfPersona {
	FolksPersona parent_instance;
	TpfPersonaPrivate * priv;
};

struct _TpfPersonaClass {
	FolksPersonaClass parent_class;
};

struct _TpfPersonaPrivate {
	GHashTable* _groups;
	gboolean _is_favourite;
	gchar* _alias;
	GHashTable* _im_addresses;
	gboolean is_constructed;
	GFile* _avatar;
	FolksPresenceType _presence_type;
	gchar* _presence_message;
	TpContact* _contact;
};

struct _TpfPersonaChangeGroupData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	gchar* group;
	gboolean is_member;
	gboolean _tmp0_;
	FolksPersonaStore* _tmp1_;
	TpfPersonaStore* _tmp2_;
	TpfPersonaStore* store;
};

struct _Block1Data {
	int _ref_count_;
	TpfPersona * self;
	TpContact* contact;
};

struct _Block2Data {
	int _ref_count_;
	TpAccount* account_found;
	TpConnection* conn;
};

struct _Block3Data {
	int _ref_count_;
	TpfPersona * self;
	GHashTable* value;
};


static gpointer tpf_persona_parent_class = NULL;
static FolksAliasableIface* tpf_persona_folks_aliasable_parent_iface = NULL;
static FolksAvatarIface* tpf_persona_folks_avatar_parent_iface = NULL;
static FolksFavouriteIface* tpf_persona_folks_favourite_parent_iface = NULL;
static FolksGroupableIface* tpf_persona_folks_groupable_parent_iface = NULL;
static FolksIMableIface* tpf_persona_folks_imable_parent_iface = NULL;
static FolksPresenceIface* tpf_persona_folks_presence_parent_iface = NULL;

GType tpf_persona_get_type (void) G_GNUC_CONST;
#define TPF_PERSONA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TPF_TYPE_PERSONA, TpfPersonaPrivate))
enum  {
	TPF_PERSONA_DUMMY_PROPERTY,
	TPF_PERSONA_AVATAR,
	TPF_PERSONA_PRESENCE_TYPE,
	TPF_PERSONA_PRESENCE_MESSAGE,
	TPF_PERSONA_LINKABLE_PROPERTIES,
	TPF_PERSONA_ALIAS,
	TPF_PERSONA_IS_FAVOURITE,
	TPF_PERSONA_IM_ADDRESSES,
	TPF_PERSONA_GROUPS,
	TPF_PERSONA_CONTACT
};
static void tpf_persona_real_change_group_data_free (gpointer _data);
static void tpf_persona_real_change_group (FolksGroupable* base, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tpf_persona_change_group_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean tpf_persona_real_change_group_co (TpfPersonaChangeGroupData* data);
static gboolean _tpf_persona_change_group (TpfPersona* self, const gchar* group, gboolean is_member);
GType tpf_persona_store_get_type (void) G_GNUC_CONST;
void tpf_persona_store_change_group_membership (TpfPersonaStore* self, FolksPersona* persona, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_group_membership_finish (TpfPersonaStore* self, GAsyncResult* _res_);
TpfPersona* tpf_persona_new (TpContact* contact, TpfPersonaStore* store);
TpfPersona* tpf_persona_construct (GType object_type, TpContact* contact, TpfPersonaStore* store);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static TpAccount* tpf_persona_account_for_connection (TpConnection* conn);
static void _lambda15_ (GObject* s, GParamSpec* p, Block1Data* _data1_);
static void __lambda15__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _g_free0_ (gpointer var);
static void _g_ptr_array_unref0_ (gpointer var);
static void _lambda16_ (GObject* s, GParamSpec* p, TpfPersona* self);
static void tpf_persona_contact_notify_avatar (TpfPersona* self);
static void __lambda16__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda17_ (GObject* s, GParamSpec* p, TpfPersona* self);
static void tpf_persona_contact_notify_presence_message (TpfPersona* self);
static void __lambda17__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda18_ (GObject* s, GParamSpec* p, TpfPersona* self);
static void tpf_persona_contact_notify_presence_type (TpfPersona* self);
static void __lambda18__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda19_ (TpfPersonaStore* s, const gchar* group, GList* added, GList* removed, TpfPersona* self);
static void __lambda19__tpf_persona_store_group_members_changed (TpfPersonaStore* _sender, const gchar* group, GList* added, GList* removed, gpointer self);
static void _lambda20_ (TpfPersonaStore* s, const gchar* group, GError* _error_, TpfPersona* self);
static void __lambda20__tpf_persona_store_group_removed (TpfPersonaStore* _sender, const gchar* group, GError* _error_, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void _lambda14_ (TpAccount* l, Block2Data* _data2_);
static void __lambda14__gfunc (gconstpointer data, gpointer self);
TpContact* tpf_persona_get_contact (TpfPersona* self);
static FolksPresenceType tpf_persona_folks_presence_type_from_tp (TpConnectionPresenceType type);
void tpf_persona_store_change_alias (TpfPersonaStore* self, TpfPersona* persona, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_alias_finish (TpfPersonaStore* self, GAsyncResult* _res_);
void tpf_persona_store_change_is_favourite (TpfPersonaStore* self, FolksPersona* persona, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_is_favourite_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void _lambda21_ (const gchar* k, gboolean v, TpfPersona* self);
static void __lambda21__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void _lambda22_ (const gchar* k, gboolean v, Block3Data* _data3_);
static void __lambda22__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void tpf_persona_set_contact (TpfPersona* self, TpContact* value);
static void tpf_persona_finalize (GObject* obj);
static void _vala_tpf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tpf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const gchar* TPF_PERSONA__linkable_properties[1] = {"im-addresses"};

static void tpf_persona_real_change_group_data_free (gpointer _data) {
	TpfPersonaChangeGroupData* data;
	data = _data;
	_g_free0 (data->group);
	_g_object_unref0 (data->self);
	g_slice_free (TpfPersonaChangeGroupData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void tpf_persona_real_change_group (FolksGroupable* base, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeGroupData* _data_;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeGroupData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_group);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_group_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->group = g_strdup (group);
	_data_->is_member = is_member;
	tpf_persona_real_change_group_co (_data_);
}


static void tpf_persona_real_change_group_finish (FolksGroupable* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeGroupData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tpf_persona_change_group_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeGroupData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tpf_persona_real_change_group_co (data);
}


/**
   * Add or remove the Persona from the specified group.
   *
   * See {@link Folks.Groupable.change_group}.
   */
static gboolean tpf_persona_real_change_group_co (TpfPersonaChangeGroupData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = _tpf_persona_change_group (data->self, data->group, data->is_member);
	if (data->_tmp0_) {
		data->_tmp1_ = NULL;
		data->_tmp1_ = folks_persona_get_store ((FolksPersona*) data->self);
		data->_tmp2_ = _g_object_ref0 (TPF_PERSONA_STORE (data->_tmp1_));
		data->store = data->_tmp2_;
		data->_state_ = 1;
		tpf_persona_store_change_group_membership (data->store, (FolksPersona*) data->self, data->group, data->is_member, tpf_persona_change_group_ready, data);
		return FALSE;
		_state_1:
		tpf_persona_store_change_group_membership_finish (data->store, data->_res_);
		_g_object_unref0 (data->store);
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gboolean _tpf_persona_change_group (TpfPersona* self, const gchar* group, gboolean is_member) {
	gboolean result = FALSE;
	gboolean changed;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	changed = FALSE;
	if (is_member) {
		gconstpointer _tmp0_ = NULL;
		_tmp0_ = g_hash_table_lookup (self->priv->_groups, group);
		if (GPOINTER_TO_INT (_tmp0_) != TRUE) {
			gchar* _tmp1_;
			_tmp1_ = g_strdup (group);
			g_hash_table_insert (self->priv->_groups, _tmp1_, GINT_TO_POINTER (TRUE));
			changed = TRUE;
		}
	} else {
		gboolean _tmp2_;
		_tmp2_ = g_hash_table_remove (self->priv->_groups, group);
		changed = _tmp2_;
	}
	if (changed == TRUE) {
		g_signal_emit_by_name ((FolksGroupable*) self, "group-changed", group, is_member);
	}
	result = changed;
	return result;
}


/**
   * Create a new persona.
   *
   * Create a new persona for the {@link PersonaStore} `store`, representing
   * the Telepathy contact given by `contact`.
   */
static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->contact);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda15_ (GObject* s, GParamSpec* p, Block1Data* _data1_) {
	TpfPersona * self;
	const gchar* _tmp0_ = NULL;
	self = _data1_->self;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = tp_contact_get_alias (_data1_->contact);
	if (g_strcmp0 (self->priv->_alias, _tmp0_) != 0) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = tp_contact_get_alias (_data1_->contact);
		_tmp2_ = g_strdup (_tmp1_);
		_tmp3_ = _tmp2_;
		_g_free0 (self->priv->_alias);
		self->priv->_alias = _tmp3_;
		g_object_notify ((GObject*) self, "alias");
	}
}


static void __lambda15__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda15_ (_sender, pspec, self);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_ptr_array_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL));
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


static void _lambda16_ (GObject* s, GParamSpec* p, TpfPersona* self) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	tpf_persona_contact_notify_avatar (self);
}


static void __lambda16__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda16_ (_sender, pspec, self);
}


static void _lambda17_ (GObject* s, GParamSpec* p, TpfPersona* self) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	tpf_persona_contact_notify_presence_message (self);
}


static void __lambda17__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda17_ (_sender, pspec, self);
}


static void _lambda18_ (GObject* s, GParamSpec* p, TpfPersona* self) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	tpf_persona_contact_notify_presence_type (self);
}


static void __lambda18__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda18_ (_sender, pspec, self);
}


static void _lambda19_ (TpfPersonaStore* s, const gchar* group, GList* added, GList* removed, TpfPersona* self) {
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	g_return_if_fail (s != NULL);
	g_return_if_fail (group != NULL);
	_tmp0_ = g_list_find (added, self);
	if (_tmp0_ != NULL) {
		_tpf_persona_change_group (self, group, TRUE);
	}
	_tmp1_ = g_list_find (removed, self);
	if (_tmp1_ != NULL) {
		_tpf_persona_change_group (self, group, FALSE);
	}
}


static void __lambda19__tpf_persona_store_group_members_changed (TpfPersonaStore* _sender, const gchar* group, GList* added, GList* removed, gpointer self) {
	_lambda19_ (_sender, group, added, removed, self);
}


static void _lambda20_ (TpfPersonaStore* s, const gchar* group, GError* _error_, TpfPersona* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (s != NULL);
	g_return_if_fail (group != NULL);
	if (_error_ != NULL) {
		gboolean _tmp1_ = FALSE;
		GQuark _tmp2_;
		_tmp2_ = tp_dbus_errors_quark ();
		if (_error_->domain != _tmp2_) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = _error_->code != TP_DBUS_ERROR_OBJECT_REMOVED;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_debug ("tpf-persona.vala:291: Group invalidated: %s", _error_->message);
	}
	_tpf_persona_change_group (self, group, FALSE);
}


static void __lambda20__tpf_persona_store_group_removed (TpfPersonaStore* _sender, const gchar* group, GError* _error_, gpointer self) {
	_lambda20_ (_sender, group, _error_, self);
}


TpfPersona* tpf_persona_construct (GType object_type, TpContact* contact, TpfPersonaStore* store) {
	TpfPersona * self = NULL;
	Block1Data* _data1_;
	const gchar* _tmp0_ = NULL;
	const gchar* id;
	TpConnection* _tmp1_ = NULL;
	TpConnection* connection;
	TpAccount* _tmp2_ = NULL;
	TpAccount* account;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* uid;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	GPtrArray* _tmp11_ = NULL;
	GPtrArray* im_address_array;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	GHashTable* _tmp14_ = NULL;
	GHashTable* _tmp15_;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	GPtrArray* _tmp18_;
	GHashTable* _tmp19_ = NULL;
	GHashTable* _tmp20_;
	FolksPersonaStore* _tmp21_ = NULL;
	FolksPersonaStore* _tmp22_ = NULL;
	g_return_val_if_fail (contact != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->contact = _g_object_ref0 (contact);
	_tmp0_ = tp_contact_get_identifier (_data1_->contact);
	id = _tmp0_;
	_tmp1_ = tp_contact_get_connection (_data1_->contact);
	connection = _tmp1_;
	_tmp2_ = tpf_persona_account_for_connection (connection);
	account = _tmp2_;
	_tmp3_ = tp_account_get_protocol (account);
	_tmp4_ = folks_persona_build_uid ("telepathy", _tmp3_, id);
	uid = _tmp4_;
	_tmp5_ = tp_contact_get_alias (_data1_->contact);
	_tmp6_ = tp_account_get_protocol (account);
	_tmp7_ = g_strconcat (_tmp6_, ":", NULL);
	_tmp8_ = g_strconcat (_tmp7_, id, NULL);
	_tmp9_ = tp_contact_get_handle (_data1_->contact);
	_tmp10_ = tp_connection_get_self_handle (connection);
	_data1_->self = g_object_ref (self = (TpfPersona*) g_object_new (object_type, "alias", _tmp5_, "contact", _data1_->contact, "display-id", id, "iid", _tmp8_, "uid", uid, "store", store, "is-user", _tmp9_ == _tmp10_, NULL));
	_g_free0 (_tmp8_);
	_g_free0 (_tmp7_);
	g_signal_connect_data ((GObject*) _data1_->contact, "notify::alias", (GCallback) __lambda15__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	g_debug ("tpf-persona.vala:238: Creating new Tpf.Persona '%s' for service-specif" \
"ic UID '%s': %p", uid, id, self);
	self->priv->is_constructed = TRUE;
	_tmp11_ = g_ptr_array_new_with_free_func (_g_free0_);
	im_address_array = _tmp11_;
	_tmp12_ = tp_account_get_protocol (account);
	_tmp13_ = folks_imable_normalise_im_address (id, _tmp12_);
	g_ptr_array_add (im_address_array, _tmp13_);
	_tmp14_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_ptr_array_unref0_);
	_tmp15_ = _tmp14_;
	_g_hash_table_unref0 (self->priv->_im_addresses);
	self->priv->_im_addresses = _tmp15_;
	_tmp16_ = tp_account_get_protocol (account);
	_tmp17_ = g_strdup (_tmp16_);
	_tmp18_ = _g_ptr_array_ref0 (im_address_array);
	g_hash_table_insert (self->priv->_im_addresses, _tmp17_, _tmp18_);
	_tmp19_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, NULL);
	_tmp20_ = _tmp19_;
	_g_hash_table_unref0 (self->priv->_groups);
	self->priv->_groups = _tmp20_;
	g_signal_connect_object ((GObject*) _data1_->contact, "notify::avatar-file", (GCallback) __lambda16__g_object_notify, self, 0);
	tpf_persona_contact_notify_avatar (self);
	g_signal_connect_object ((GObject*) _data1_->contact, "notify::presence-message", (GCallback) __lambda17__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) _data1_->contact, "notify::presence-type", (GCallback) __lambda18__g_object_notify, self, 0);
	tpf_persona_contact_notify_presence_message (self);
	tpf_persona_contact_notify_presence_type (self);
	_tmp21_ = folks_persona_get_store ((FolksPersona*) self);
	g_signal_connect_object (TPF_PERSONA_STORE (_tmp21_), "group-members-changed", (GCallback) __lambda19__tpf_persona_store_group_members_changed, self, 0);
	_tmp22_ = folks_persona_get_store ((FolksPersona*) self);
	g_signal_connect_object (TPF_PERSONA_STORE (_tmp22_), "group-removed", (GCallback) __lambda20__tpf_persona_store_group_removed, self, 0);
	_g_ptr_array_unref0 (im_address_array);
	_g_free0 (uid);
	_g_object_unref0 (account);
	block1_data_unref (_data1_);
	return self;
}


TpfPersona* tpf_persona_new (TpContact* contact, TpfPersonaStore* store) {
	return tpf_persona_construct (TPF_TYPE_PERSONA, contact, store);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->account_found);
		_g_object_unref0 (_data2_->conn);
		g_slice_free (Block2Data, _data2_);
	}
}


static void _lambda14_ (TpAccount* l, Block2Data* _data2_) {
	TpAccount* account;
	TpConnection* _tmp0_ = NULL;
	g_return_if_fail (l != NULL);
	account = TP_ACCOUNT (l);
	_tmp0_ = tp_account_get_connection (account);
	if (_tmp0_ == _data2_->conn) {
		TpAccount* _tmp1_;
		TpAccount* _tmp2_;
		_tmp1_ = _g_object_ref0 (account);
		_tmp2_ = _tmp1_;
		_g_object_unref0 (_data2_->account_found);
		_data2_->account_found = _tmp2_;
		return;
	}
}


static void __lambda14__gfunc (gconstpointer data, gpointer self) {
	_lambda14_ (data, self);
}


static TpAccount* tpf_persona_account_for_connection (TpConnection* conn) {
	TpAccount* result = NULL;
	Block2Data* _data2_;
	TpAccountManager* _tmp0_ = NULL;
	TpAccountManager* manager;
	GList* _tmp1_ = NULL;
	GList* accounts;
	TpAccount* _tmp2_;
	g_return_val_if_fail (conn != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->conn = _g_object_ref0 (conn);
	_tmp0_ = tp_account_manager_dup ();
	manager = _tmp0_;
	_tmp1_ = tp_account_manager_get_valid_accounts (manager);
	accounts = _tmp1_;
	_data2_->account_found = NULL;
	g_list_foreach (accounts, __lambda14__gfunc, _data2_);
	_tmp2_ = _g_object_ref0 (_data2_->account_found);
	result = _tmp2_;
	_g_list_free0 (accounts);
	_g_object_unref0 (manager);
	block2_data_unref (_data2_);
	return result;
}


static void tpf_persona_contact_notify_presence_message (TpfPersona* self) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = tp_contact_get_presence_message (self->priv->_contact);
	folks_presence_set_presence_message ((FolksPresence*) self, _tmp0_);
}


static void tpf_persona_contact_notify_presence_type (TpfPersona* self) {
	TpConnectionPresenceType _tmp0_;
	FolksPresenceType _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tp_contact_get_presence_type (self->priv->_contact);
	_tmp1_ = tpf_persona_folks_presence_type_from_tp (_tmp0_);
	folks_presence_set_presence_type ((FolksPresence*) self, _tmp1_);
}


static FolksPresenceType tpf_persona_folks_presence_type_from_tp (TpConnectionPresenceType type) {
	FolksPresenceType result = 0;
	switch (type) {
		case TP_CONNECTION_PRESENCE_TYPE_AVAILABLE:
		{
			result = FOLKS_PRESENCE_TYPE_AVAILABLE;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_AWAY:
		{
			result = FOLKS_PRESENCE_TYPE_AWAY;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_BUSY:
		{
			result = FOLKS_PRESENCE_TYPE_BUSY;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_ERROR:
		{
			result = FOLKS_PRESENCE_TYPE_ERROR;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_EXTENDED_AWAY:
		{
			result = FOLKS_PRESENCE_TYPE_EXTENDED_AWAY;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_HIDDEN:
		{
			result = FOLKS_PRESENCE_TYPE_HIDDEN;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_OFFLINE:
		{
			result = FOLKS_PRESENCE_TYPE_OFFLINE;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_UNKNOWN:
		{
			result = FOLKS_PRESENCE_TYPE_UNKNOWN;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_UNSET:
		{
			result = FOLKS_PRESENCE_TYPE_UNSET;
			return result;
		}
		default:
		{
			result = FOLKS_PRESENCE_TYPE_UNKNOWN;
			return result;
		}
	}
}


static void tpf_persona_contact_notify_avatar (TpfPersona* self) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFile* file;
	GFile* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = tp_contact_get_avatar_file (self->priv->_contact);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	file = _tmp1_;
	_tmp2_ = folks_avatar_get_avatar ((FolksAvatar*) self);
	if (_tmp2_ != file) {
		folks_avatar_set_avatar ((FolksAvatar*) self, file);
	}
	_g_object_unref0 (file);
}


static GFile* tpf_persona_real_get_avatar (FolksAvatar* base) {
	GFile* result;
	TpfPersona* self;
	self = (TpfPersona*) base;
	result = self->priv->_avatar;
	return result;
}


static void tpf_persona_real_set_avatar (FolksAvatar* base, GFile* value) {
	TpfPersona* self;
	GFile* _tmp0_;
	GFile* _tmp1_;
	self = (TpfPersona*) base;
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_avatar);
	self->priv->_avatar = _tmp1_;
	g_object_notify ((GObject *) self, "avatar");
}


static FolksPresenceType tpf_persona_real_get_presence_type (FolksPresence* base) {
	FolksPresenceType result;
	TpfPersona* self;
	self = (TpfPersona*) base;
	result = self->priv->_presence_type;
	return result;
}


static void tpf_persona_real_set_presence_type (FolksPresence* base, FolksPresenceType value) {
	TpfPersona* self;
	self = (TpfPersona*) base;
	self->priv->_presence_type = value;
	g_object_notify ((GObject *) self, "presence-type");
}


static const gchar* tpf_persona_real_get_presence_message (FolksPresence* base) {
	const gchar* result;
	TpfPersona* self;
	self = (TpfPersona*) base;
	result = self->priv->_presence_message;
	return result;
}


static void tpf_persona_real_set_presence_message (FolksPresence* base, const gchar* value) {
	TpfPersona* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (TpfPersona*) base;
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_presence_message);
	self->priv->_presence_message = _tmp1_;
	g_object_notify ((GObject *) self, "presence-message");
}


static gchar** tpf_persona_real_get_linkable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	TpfPersona* self;
	const gchar** _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = TPF_PERSONA__linkable_properties;
	*result_length1 = G_N_ELEMENTS (TPF_PERSONA__linkable_properties);
	result = _tmp0_;
	return result;
}


static const gchar* tpf_persona_real_get_alias (FolksAliasable* base) {
	const gchar* result;
	TpfPersona* self;
	self = (TpfPersona*) base;
	result = self->priv->_alias;
	return result;
}


static void tpf_persona_real_set_alias (FolksAliasable* base, const gchar* value) {
	TpfPersona* self;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self = (TpfPersona*) base;
	if (g_strcmp0 (self->priv->_alias, value) == 0) {
		return;
	}
	if (self->priv->is_constructed) {
		FolksPersonaStore* _tmp0_ = NULL;
		_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
		tpf_persona_store_change_alias (TPF_PERSONA_STORE (_tmp0_), self, value, NULL, NULL);
	}
	_tmp1_ = g_strdup (value);
	_tmp2_ = _tmp1_;
	_g_free0 (self->priv->_alias);
	self->priv->_alias = _tmp2_;
	g_object_notify ((GObject *) self, "alias");
}


static gboolean tpf_persona_real_get_is_favourite (FolksFavourite* base) {
	gboolean result;
	TpfPersona* self;
	self = (TpfPersona*) base;
	result = self->priv->_is_favourite;
	return result;
}


static void tpf_persona_real_set_is_favourite (FolksFavourite* base, gboolean value) {
	TpfPersona* self;
	self = (TpfPersona*) base;
	if (self->priv->_is_favourite == value) {
		return;
	}
	if (self->priv->is_constructed) {
		FolksPersonaStore* _tmp0_ = NULL;
		_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
		tpf_persona_store_change_is_favourite (TPF_PERSONA_STORE (_tmp0_), (FolksPersona*) self, value, NULL, NULL);
	}
	self->priv->_is_favourite = value;
	g_object_notify ((GObject *) self, "is-favourite");
}


static GHashTable* tpf_persona_real_get_im_addresses (FolksIMable* base) {
	GHashTable* result;
	TpfPersona* self;
	self = (TpfPersona*) base;
	result = self->priv->_im_addresses;
	return result;
}


static void tpf_persona_real_set_im_addresses (FolksIMable* base, GHashTable* value) {
	TpfPersona* self;
	self = (TpfPersona*) base;
	g_object_notify ((GObject *) self, "im-addresses");
}


static GHashTable* tpf_persona_real_get_groups (FolksGroupable* base) {
	GHashTable* result;
	TpfPersona* self;
	self = (TpfPersona*) base;
	result = self->priv->_groups;
	return result;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_g_hash_table_unref0 (_data3_->value);
		g_slice_free (Block3Data, _data3_);
	}
}


static void _lambda21_ (const gchar* k, gboolean v, TpfPersona* self) {
	gchar* _tmp0_;
	gchar* group;
	gconstpointer _tmp1_ = NULL;
	g_return_if_fail (k != NULL);
	_tmp0_ = g_strdup ((const gchar*) k);
	group = _tmp0_;
	_tmp1_ = g_hash_table_lookup (self->priv->_groups, group);
	if (GPOINTER_TO_INT (_tmp1_) == FALSE) {
		_tpf_persona_change_group (self, group, TRUE);
	}
	_g_free0 (group);
}


static void __lambda21__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda21_ (key, value, self);
}


static void _lambda22_ (const gchar* k, gboolean v, Block3Data* _data3_) {
	TpfPersona * self;
	gchar* _tmp0_;
	gchar* group;
	gconstpointer _tmp1_ = NULL;
	self = _data3_->self;
	g_return_if_fail (k != NULL);
	_tmp0_ = g_strdup ((const gchar*) k);
	group = _tmp0_;
	_tmp1_ = g_hash_table_lookup (_data3_->value, group);
	if (GPOINTER_TO_INT (_tmp1_) == FALSE) {
		_tpf_persona_change_group (self, group, TRUE);
	}
	_g_free0 (group);
}


static void __lambda22__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda22_ (key, value, self);
}


static void tpf_persona_real_set_groups (FolksGroupable* base, GHashTable* value) {
	TpfPersona* self;
	Block3Data* _data3_;
	self = (TpfPersona*) base;
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->value = _g_hash_table_ref0 (value);
	g_hash_table_foreach (_data3_->value, __lambda21__gh_func, self);
	g_hash_table_foreach (self->priv->_groups, __lambda22__gh_func, _data3_);
	g_object_notify ((GObject*) self, "groups");
	block3_data_unref (_data3_);
	g_object_notify ((GObject *) self, "groups");
}


TpContact* tpf_persona_get_contact (TpfPersona* self) {
	TpContact* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_contact;
	return result;
}


static void tpf_persona_set_contact (TpfPersona* self, TpContact* value) {
	TpContact* _tmp0_;
	TpContact* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_contact);
	self->priv->_contact = _tmp1_;
	g_object_notify ((GObject *) self, "contact");
}


static void tpf_persona_class_init (TpfPersonaClass * klass) {
	tpf_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TpfPersonaPrivate));
	FOLKS_PERSONA_CLASS (klass)->get_linkable_properties = tpf_persona_real_get_linkable_properties;
	G_OBJECT_CLASS (klass)->get_property = _vala_tpf_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tpf_persona_set_property;
	G_OBJECT_CLASS (klass)->finalize = tpf_persona_finalize;
	/**
	   * An avatar for the Persona.
	   *
	   * See {@link Folks.Avatar.avatar}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_AVATAR, "avatar");
	/**
	   * The Persona's presence type.
	   *
	   * See {@link Folks.Presence.presence_type}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_PRESENCE_TYPE, "presence-type");
	/**
	   * The Persona's presence message.
	   *
	   * See {@link Folks.Presence.presence_message}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_PRESENCE_MESSAGE, "presence-message");
	/**
	   * The names of the Persona's linkable properties.
	   *
	   * See {@link Folks.Persona.linkable_properties}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_LINKABLE_PROPERTIES, "linkable-properties");
	/**
	   * An alias for the Persona.
	   *
	   * See {@link Folks.Aliasable.alias}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_ALIAS, "alias");
	/**
	   * Whether this Persona is a user-defined favourite.
	   *
	   * See {@link Folks.Favourite.is_favourite}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_IS_FAVOURITE, "is-favourite");
	/**
	   * A mapping of IM protocol to an ordered set of IM addresses.
	   *
	   * See {@link Folks.IMable.im_addresses}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_IM_ADDRESSES, "im-addresses");
	/**
	   * A mapping of group ID to whether the contact is a member.
	   *
	   * See {@link Folks.Groupable.groups}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_GROUPS, "groups");
	/**
	   * The Telepathy contact represented by this persona.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_CONTACT, g_param_spec_object ("contact", "contact", "contact", TP_TYPE_CONTACT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void tpf_persona_folks_aliasable_interface_init (FolksAliasableIface * iface) {
	tpf_persona_folks_aliasable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_alias = tpf_persona_real_get_alias;
	iface->set_alias = tpf_persona_real_set_alias;
}


static void tpf_persona_folks_avatar_interface_init (FolksAvatarIface * iface) {
	tpf_persona_folks_avatar_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_avatar = tpf_persona_real_get_avatar;
	iface->set_avatar = tpf_persona_real_set_avatar;
}


static void tpf_persona_folks_favourite_interface_init (FolksFavouriteIface * iface) {
	tpf_persona_folks_favourite_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_is_favourite = tpf_persona_real_get_is_favourite;
	iface->set_is_favourite = tpf_persona_real_set_is_favourite;
}


static void tpf_persona_folks_groupable_interface_init (FolksGroupableIface * iface) {
	tpf_persona_folks_groupable_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_group = (void (*)(FolksGroupable* ,const gchar* ,gboolean ,GError**)) tpf_persona_real_change_group;
	iface->change_group_finish = tpf_persona_real_change_group_finish;
	iface->get_groups = tpf_persona_real_get_groups;
	iface->set_groups = tpf_persona_real_set_groups;
}


static void tpf_persona_folks_imable_interface_init (FolksIMableIface * iface) {
	tpf_persona_folks_imable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_im_addresses = tpf_persona_real_get_im_addresses;
	iface->set_im_addresses = tpf_persona_real_set_im_addresses;
}


static void tpf_persona_folks_presence_interface_init (FolksPresenceIface * iface) {
	tpf_persona_folks_presence_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_presence_type = tpf_persona_real_get_presence_type;
	iface->set_presence_type = tpf_persona_real_set_presence_type;
	iface->get_presence_message = tpf_persona_real_get_presence_message;
	iface->set_presence_message = tpf_persona_real_set_presence_message;
}


static void tpf_persona_instance_init (TpfPersona * self) {
	self->priv = TPF_PERSONA_GET_PRIVATE (self);
	self->priv->is_constructed = FALSE;
}


static void tpf_persona_finalize (GObject* obj) {
	TpfPersona * self;
	const gchar* _tmp0_ = NULL;
	self = TPF_PERSONA (obj);
	_tmp0_ = folks_persona_get_uid ((FolksPersona*) self);
	g_debug ("tpf-persona.vala:300: Destroying Tpf.Persona '%s': %p", _tmp0_, self);
	_g_hash_table_unref0 (self->priv->_groups);
	_g_free0 (self->priv->_alias);
	_g_hash_table_unref0 (self->priv->_im_addresses);
	_g_object_unref0 (self->priv->_avatar);
	_g_free0 (self->priv->_presence_message);
	_g_object_unref0 (self->priv->_contact);
	G_OBJECT_CLASS (tpf_persona_parent_class)->finalize (obj);
}


/**
 * A persona subclass which represents a single instant messaging contact from
 * Telepathy.
 */
GType tpf_persona_get_type (void) {
	static volatile gsize tpf_persona_type_id__volatile = 0;
	if (g_once_init_enter (&tpf_persona_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TpfPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tpf_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TpfPersona), 0, (GInstanceInitFunc) tpf_persona_instance_init, NULL };
		static const GInterfaceInfo folks_aliasable_info = { (GInterfaceInitFunc) tpf_persona_folks_aliasable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_avatar_info = { (GInterfaceInitFunc) tpf_persona_folks_avatar_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_favourite_info = { (GInterfaceInitFunc) tpf_persona_folks_favourite_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_groupable_info = { (GInterfaceInitFunc) tpf_persona_folks_groupable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_imable_info = { (GInterfaceInitFunc) tpf_persona_folks_imable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_presence_info = { (GInterfaceInitFunc) tpf_persona_folks_presence_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType tpf_persona_type_id;
		tpf_persona_type_id = g_type_register_static (FOLKS_TYPE_PERSONA, "TpfPersona", &g_define_type_info, 0);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_ALIASABLE, &folks_aliasable_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_AVATAR, &folks_avatar_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_FAVOURITE, &folks_favourite_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_GROUPABLE, &folks_groupable_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_IMABLE, &folks_imable_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_PRESENCE, &folks_presence_info);
		g_once_init_leave (&tpf_persona_type_id__volatile, tpf_persona_type_id);
	}
	return tpf_persona_type_id__volatile;
}


static void _vala_tpf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TpfPersona * self;
	int length;
	self = TPF_PERSONA (object);
	switch (property_id) {
		case TPF_PERSONA_AVATAR:
		g_value_set_object (value, folks_avatar_get_avatar ((FolksAvatar*) self));
		break;
		case TPF_PERSONA_PRESENCE_TYPE:
		g_value_set_enum (value, folks_presence_get_presence_type ((FolksPresence*) self));
		break;
		case TPF_PERSONA_PRESENCE_MESSAGE:
		g_value_set_string (value, folks_presence_get_presence_message ((FolksPresence*) self));
		break;
		case TPF_PERSONA_LINKABLE_PROPERTIES:
		g_value_set_boxed (value, folks_persona_get_linkable_properties ((FolksPersona*) self, &length));
		break;
		case TPF_PERSONA_ALIAS:
		g_value_set_string (value, folks_aliasable_get_alias ((FolksAliasable*) self));
		break;
		case TPF_PERSONA_IS_FAVOURITE:
		g_value_set_boolean (value, folks_favourite_get_is_favourite ((FolksFavourite*) self));
		break;
		case TPF_PERSONA_IM_ADDRESSES:
		g_value_set_boxed (value, folks_imable_get_im_addresses ((FolksIMable*) self));
		break;
		case TPF_PERSONA_GROUPS:
		g_value_set_boxed (value, folks_groupable_get_groups ((FolksGroupable*) self));
		break;
		case TPF_PERSONA_CONTACT:
		g_value_set_object (value, tpf_persona_get_contact (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tpf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TpfPersona * self;
	self = TPF_PERSONA (object);
	switch (property_id) {
		case TPF_PERSONA_AVATAR:
		folks_avatar_set_avatar ((FolksAvatar*) self, g_value_get_object (value));
		break;
		case TPF_PERSONA_PRESENCE_TYPE:
		folks_presence_set_presence_type ((FolksPresence*) self, g_value_get_enum (value));
		break;
		case TPF_PERSONA_PRESENCE_MESSAGE:
		folks_presence_set_presence_message ((FolksPresence*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_ALIAS:
		folks_aliasable_set_alias ((FolksAliasable*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_IS_FAVOURITE:
		folks_favourite_set_is_favourite ((FolksFavourite*) self, g_value_get_boolean (value));
		break;
		case TPF_PERSONA_IM_ADDRESSES:
		folks_imable_set_im_addresses ((FolksIMable*) self, g_value_get_boxed (value));
		break;
		case TPF_PERSONA_GROUPS:
		folks_groupable_set_groups ((FolksGroupable*) self, g_value_get_boxed (value));
		break;
		case TPF_PERSONA_CONTACT:
		tpf_persona_set_contact (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



